(function ($hx_exports, $global) { "use strict"; var $hx_script = (function (exports, global) { // Generated by Haxe 4.0.5
(function ($hx_exports, $global) { "use strict";
$hx_exports["lime"] = $hx_exports["lime"] || {};
var $hxClasses = {},$estr = function() { return js_Boot.__string_rec(this,''); },$hxEnums = $hxEnums || {},$_;
function $extend(from, fields) {
	var proto = Object.create(from);
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var lime_app_IModule = function() { };
$hxClasses["lime.app.IModule"] = lime_app_IModule;
lime_app_IModule.__name__ = "lime.app.IModule";
lime_app_IModule.__isInterface__ = true;
lime_app_IModule.prototype = {
	__registerLimeModule: null
	,__unregisterLimeModule: null
	,__class__: lime_app_IModule
};
var lime_app_Module = function() {
	this.onExit = new lime_app__$Event_$Int_$Void();
};
$hxClasses["lime.app.Module"] = lime_app_Module;
lime_app_Module.__name__ = "lime.app.Module";
lime_app_Module.__interfaces__ = [lime_app_IModule];
lime_app_Module.prototype = {
	onExit: null
	,__registerLimeModule: function(application) {
	}
	,__unregisterLimeModule: function(application) {
	}
	,__class__: lime_app_Module
};
var lime__$internal_backend_html5_HTML5Application = function(parent) {
	this.gameDeviceCache = new haxe_ds_IntMap();
	this.parent = parent;
	this.currentUpdate = 0;
	this.lastUpdate = 0;
	this.nextUpdate = 0;
	this.framePeriod = -1;
	lime_media_AudioManager.init();
	this.accelerometer = lime_system_Sensor.registerSensor(lime_system_SensorType.ACCELEROMETER,0);
};
$hxClasses["lime._internal.backend.html5.HTML5Application"] = lime__$internal_backend_html5_HTML5Application;
lime__$internal_backend_html5_HTML5Application.__name__ = "lime._internal.backend.html5.HTML5Application";
lime__$internal_backend_html5_HTML5Application.prototype = {
	gameDeviceCache: null
	,accelerometer: null
	,currentUpdate: null
	,deltaTime: null
	,framePeriod: null
	,lastUpdate: null
	,nextUpdate: null
	,parent: null
	,convertKeyCode: function(keyCode) {
		if(keyCode >= 65 && keyCode <= 90) {
			return keyCode + 32;
		}
		switch(keyCode) {
		case 12:
			return 1073741980;
		case 16:
			return 1073742049;
		case 17:
			return 1073742048;
		case 18:
			return 1073742050;
		case 19:
			return 1073741896;
		case 20:
			return 1073741881;
		case 33:
			return 1073741899;
		case 34:
			return 1073741902;
		case 35:
			return 1073741901;
		case 36:
			return 1073741898;
		case 37:
			return 1073741904;
		case 38:
			return 1073741906;
		case 39:
			return 1073741903;
		case 40:
			return 1073741905;
		case 41:
			return 1073741943;
		case 43:
			return 1073741940;
		case 44:
			return 1073741894;
		case 45:
			return 1073741897;
		case 46:
			return 127;
		case 91:
			return 1073742051;
		case 92:
			return 1073742055;
		case 93:
			return 1073742055;
		case 95:
			return 1073742106;
		case 96:
			return 1073741922;
		case 97:
			return 1073741913;
		case 98:
			return 1073741914;
		case 99:
			return 1073741915;
		case 100:
			return 1073741916;
		case 101:
			return 1073741917;
		case 102:
			return 1073741918;
		case 103:
			return 1073741919;
		case 104:
			return 1073741920;
		case 105:
			return 1073741921;
		case 106:
			return 1073741909;
		case 107:
			return 1073741911;
		case 108:
			return 1073741923;
		case 109:
			return 1073741910;
		case 110:
			return 1073741923;
		case 111:
			return 1073741908;
		case 112:
			return 1073741882;
		case 113:
			return 1073741883;
		case 114:
			return 1073741884;
		case 115:
			return 1073741885;
		case 116:
			return 1073741886;
		case 117:
			return 1073741887;
		case 118:
			return 1073741888;
		case 119:
			return 1073741889;
		case 120:
			return 1073741890;
		case 121:
			return 1073741891;
		case 122:
			return 1073741892;
		case 123:
			return 1073741893;
		case 124:
			return 1073741928;
		case 125:
			return 1073741929;
		case 126:
			return 1073741930;
		case 127:
			return 1073741931;
		case 128:
			return 1073741932;
		case 129:
			return 1073741933;
		case 130:
			return 1073741934;
		case 131:
			return 1073741935;
		case 132:
			return 1073741936;
		case 133:
			return 1073741937;
		case 134:
			return 1073741938;
		case 135:
			return 1073741939;
		case 144:
			return 1073741907;
		case 145:
			return 1073741895;
		case 160:
			return 94;
		case 161:
			return 33;
		case 163:
			return 35;
		case 164:
			return 36;
		case 166:
			return 1073742094;
		case 167:
			return 1073742095;
		case 168:
			return 1073742097;
		case 169:
			return 41;
		case 170:
			return 42;
		case 171:
			return 96;
		case 172:
			return 1073741898;
		case 173:
			return 45;
		case 174:
			return 1073741953;
		case 175:
			return 1073741952;
		case 176:
			return 1073742082;
		case 177:
			return 1073742083;
		case 178:
			return 1073742084;
		case 179:
			return 1073742085;
		case 180:
			return 1073742089;
		case 181:
			return 1073742086;
		case 182:
			return 1073741953;
		case 183:
			return 1073741952;
		case 186:
			return 59;
		case 187:
			return 61;
		case 188:
			return 44;
		case 189:
			return 45;
		case 190:
			return 46;
		case 191:
			return 47;
		case 192:
			return 96;
		case 193:
			return 63;
		case 194:
			return 1073741923;
		case 219:
			return 91;
		case 220:
			return 92;
		case 221:
			return 93;
		case 222:
			return 39;
		case 223:
			return 96;
		case 224:
			return 1073742051;
		case 226:
			return 92;
		}
		return keyCode;
	}
	,exec: function() {
		window.addEventListener("keydown",$bind(this,this.handleKeyEvent),false);
		window.addEventListener("keyup",$bind(this,this.handleKeyEvent),false);
		window.addEventListener("focus",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("blur",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("resize",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("beforeunload",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("devicemotion",$bind(this,this.handleSensorEvent),false);
		
			if (!CanvasRenderingContext2D.prototype.isPointInStroke) {
				CanvasRenderingContext2D.prototype.isPointInStroke = function (path, x, y) {
					return false;
				};
			}
			if (!CanvasRenderingContext2D.prototype.isPointInPath) {
				CanvasRenderingContext2D.prototype.isPointInPath = function (path, x, y) {
					return false;
				};
			}

			if ('performance' in window == false) {
				window.performance = {};
			}

			if ('now' in window.performance == false) {
				var offset = Date.now();
				if (performance.timing && performance.timing.navigationStart) {
					offset = performance.timing.navigationStart
				}
				window.performance.now = function now() {
					return Date.now() - offset;
				}
			}

			var lastTime = 0;
			var vendors = ['ms', 'moz', 'webkit', 'o'];
			for (var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
				window.requestAnimationFrame = window[vendors[x]+'RequestAnimationFrame'];
				window.cancelAnimationFrame = window[vendors[x]+'CancelAnimationFrame'] || window[vendors[x]+'CancelRequestAnimationFrame'];
			}

			if (!window.requestAnimationFrame)
				window.requestAnimationFrame = function(callback, element) {
					var currTime = new Date().getTime();
					var timeToCall = Math.max(0, 16 - (currTime - lastTime));
					var id = window.setTimeout(function() { callback(currTime + timeToCall); },
					  timeToCall);
					lastTime = currTime + timeToCall;
					return id;
				};

			if (!window.cancelAnimationFrame)
				window.cancelAnimationFrame = function(id) {
					clearTimeout(id);
				};

			window.requestAnimFrame = window.requestAnimationFrame;
		;
		this.lastUpdate = new Date().getTime();
		this.handleApplicationEvent();
		return 0;
	}
	,exit: function() {
	}
	,handleApplicationEvent: function(__) {
		var _g = 0;
		var _g1 = this.parent.__windows;
		while(_g < _g1.length) {
			var $window = _g1[_g];
			++_g;
			$window.__backend.updateSize();
		}
		this.updateGameDevices();
		this.currentUpdate = new Date().getTime();
		if(this.currentUpdate >= this.nextUpdate) {
			this.deltaTime = this.currentUpdate - this.lastUpdate;
			var _g2 = 0;
			var _g3 = this.parent.__windows;
			while(_g2 < _g3.length) {
				var window1 = _g3[_g2];
				++_g2;
				this.parent.onUpdate.dispatch(this.deltaTime | 0);
				if(window1.context != null) {
					window1.onRender.dispatch(window1.context);
				}
			}
			if(this.framePeriod < 0) {
				this.nextUpdate = this.currentUpdate;
			} else {
				this.nextUpdate = this.currentUpdate - this.currentUpdate % this.framePeriod + this.framePeriod;
			}
			this.lastUpdate = this.currentUpdate;
		}
		window.requestAnimationFrame($bind(this,this.handleApplicationEvent));
	}
	,handleKeyEvent: function(event) {
		if(this.parent.__window != null) {
			var keyCode = this.convertKeyCode(event.keyCode != null ? event.keyCode : event.which);
			var modifier = (event.shiftKey ? 3 : 0) | (event.ctrlKey ? 192 : 0) | (event.altKey ? 768 : 0) | (event.metaKey ? 3072 : 0);
			if(event.type == "keydown") {
				this.parent.__window.onKeyDown.dispatch(keyCode,modifier);
				if(this.parent.__window.onKeyDown.canceled && event.cancelable) {
					event.preventDefault();
				}
			} else {
				this.parent.__window.onKeyUp.dispatch(keyCode,modifier);
				if(this.parent.__window.onKeyUp.canceled && event.cancelable) {
					event.preventDefault();
				}
			}
		}
	}
	,handleSensorEvent: function(event) {
		this.accelerometer.onUpdate.dispatch(event.accelerationIncludingGravity.x,event.accelerationIncludingGravity.y,event.accelerationIncludingGravity.z);
	}
	,handleWindowEvent: function(event) {
		if(this.parent.__window != null) {
			switch(event.type) {
			case "beforeunload":
				break;
			case "blur":
				this.parent.__window.onFocusOut.dispatch();
				this.parent.__window.onDeactivate.dispatch();
				break;
			case "focus":
				this.parent.__window.onFocusIn.dispatch();
				this.parent.__window.onActivate.dispatch();
				break;
			case "resize":
				this.parent.__window.__backend.handleResizeEvent(event);
				break;
			}
		}
	}
	,updateGameDevices: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		if(devices == null) {
			return;
		}
		var id;
		var gamepad;
		var joystick;
		var data;
		var cache;
		var _g = 0;
		var _g1 = devices.length;
		while(_g < _g1) {
			var i = _g++;
			id = i;
			data = devices[id];
			if(data == null) {
				continue;
			}
			if(!this.gameDeviceCache.h.hasOwnProperty(id)) {
				cache = new lime__$internal_backend_html5_GameDeviceData();
				cache.id = id;
				cache.connected = data.connected;
				var _g2 = 0;
				var _g11 = data.buttons.length;
				while(_g2 < _g11) {
					var i1 = _g2++;
					cache.buttons.push(data.buttons[i1].value);
				}
				var _g21 = 0;
				var _g3 = data.axes.length;
				while(_g21 < _g3) {
					var i2 = _g21++;
					cache.axes.push(data.axes[i2]);
				}
				if(data.mapping == "standard") {
					cache.isGamepad = true;
				}
				this.gameDeviceCache.h[id] = cache;
				if(data.connected) {
					lime_ui_Joystick.__connect(id);
					if(cache.isGamepad) {
						lime_ui_Gamepad.__connect(id);
					}
				}
			}
			cache = this.gameDeviceCache.h[id];
			joystick = lime_ui_Joystick.devices.h[id];
			gamepad = lime_ui_Gamepad.devices.h[id];
			if(data.connected) {
				var button;
				var value;
				var _g4 = 0;
				var _g12 = data.buttons.length;
				while(_g4 < _g12) {
					var i3 = _g4++;
					value = data.buttons[i3].value;
					if(value != cache.buttons[i3]) {
						if(i3 == 6) {
							joystick.onAxisMove.dispatch(data.axes.length,value);
							if(gamepad != null) {
								gamepad.onAxisMove.dispatch(4,value);
							}
						} else if(i3 == 7) {
							joystick.onAxisMove.dispatch(data.axes.length + 1,value);
							if(gamepad != null) {
								gamepad.onAxisMove.dispatch(5,value);
							}
						} else {
							if(value > 0) {
								joystick.onButtonDown.dispatch(i3);
							} else {
								joystick.onButtonUp.dispatch(i3);
							}
							if(gamepad != null) {
								switch(i3) {
								case 0:
									button = 0;
									break;
								case 1:
									button = 1;
									break;
								case 2:
									button = 2;
									break;
								case 3:
									button = 3;
									break;
								case 4:
									button = 9;
									break;
								case 5:
									button = 10;
									break;
								case 8:
									button = 4;
									break;
								case 9:
									button = 6;
									break;
								case 10:
									button = 7;
									break;
								case 11:
									button = 8;
									break;
								case 12:
									button = 11;
									break;
								case 13:
									button = 12;
									break;
								case 14:
									button = 13;
									break;
								case 15:
									button = 14;
									break;
								case 16:
									button = 5;
									break;
								default:
									continue;
								}
								if(value > 0) {
									gamepad.onButtonDown.dispatch(button);
								} else {
									gamepad.onButtonUp.dispatch(button);
								}
							}
						}
						cache.buttons[i3] = value;
					}
				}
				var _g22 = 0;
				var _g31 = data.axes.length;
				while(_g22 < _g31) {
					var i4 = _g22++;
					if(data.axes[i4] != cache.axes[i4]) {
						joystick.onAxisMove.dispatch(i4,data.axes[i4]);
						if(gamepad != null) {
							gamepad.onAxisMove.dispatch(i4,data.axes[i4]);
						}
						cache.axes[i4] = data.axes[i4];
					}
				}
			} else if(cache.connected) {
				cache.connected = false;
				lime_ui_Joystick.__disconnect(id);
				lime_ui_Gamepad.__disconnect(id);
			}
		}
	}
	,__class__: lime__$internal_backend_html5_HTML5Application
};
var lime_app_Application = function() {
	this.onCreateWindow = new lime_app__$Event_$lime_$ui_$Window_$Void();
	this.onUpdate = new lime_app__$Event_$Int_$Void();
	lime_app_Module.call(this);
	if(lime_app_Application.current == null) {
		lime_app_Application.current = this;
	}
	this.meta = new haxe_ds_StringMap();
	this.modules = [];
	this.__windowByID = new haxe_ds_IntMap();
	this.__windows = [];
	this.__backend = new lime__$internal_backend_html5_HTML5Application(this);
	this.__registerLimeModule(this);
	this.__preloader = new lime_utils_Preloader();
	this.__preloader.onProgress.add($bind(this,this.onPreloadProgress));
	this.__preloader.onComplete.add($bind(this,this.onPreloadComplete));
};
$hxClasses["lime.app.Application"] = lime_app_Application;
lime_app_Application.__name__ = "lime.app.Application";
lime_app_Application.__super__ = lime_app_Module;
lime_app_Application.prototype = $extend(lime_app_Module.prototype,{
	meta: null
	,modules: null
	,onUpdate: null
	,onCreateWindow: null
	,preloader: null
	,window: null
	,windows: null
	,__backend: null
	,__preloader: null
	,__window: null
	,__windowByID: null
	,__windows: null
	,addModule: function(module) {
		module.__registerLimeModule(this);
		this.modules.push(module);
	}
	,createWindow: function(attributes) {
		var $window = this.__createWindow(attributes);
		this.__addWindow($window);
		return $window;
	}
	,exec: function() {
		lime_app_Application.current = this;
		return this.__backend.exec();
	}
	,onGamepadAxisMove: function(gamepad,axis,value) {
	}
	,onGamepadButtonDown: function(gamepad,button) {
	}
	,onGamepadButtonUp: function(gamepad,button) {
	}
	,onGamepadConnect: function(gamepad) {
	}
	,onGamepadDisconnect: function(gamepad) {
	}
	,onJoystickAxisMove: function(joystick,axis,value) {
	}
	,onJoystickButtonDown: function(joystick,button) {
	}
	,onJoystickButtonUp: function(joystick,button) {
	}
	,onJoystickConnect: function(joystick) {
	}
	,onJoystickDisconnect: function(joystick) {
	}
	,onJoystickHatMove: function(joystick,hat,position) {
	}
	,onJoystickTrackballMove: function(joystick,trackball,x,y) {
	}
	,onKeyDown: function(keyCode,modifier) {
	}
	,onKeyUp: function(keyCode,modifier) {
	}
	,onModuleExit: function(code) {
	}
	,onMouseDown: function(x,y,button) {
	}
	,onMouseMove: function(x,y) {
	}
	,onMouseMoveRelative: function(x,y) {
	}
	,onMouseUp: function(x,y,button) {
	}
	,onMouseWheel: function(deltaX,deltaY,deltaMode) {
	}
	,onPreloadComplete: function() {
	}
	,onPreloadProgress: function(loaded,total) {
	}
	,onRenderContextLost: function() {
	}
	,onRenderContextRestored: function(context) {
	}
	,onTextEdit: function(text,start,length) {
	}
	,onTextInput: function(text) {
	}
	,onTouchCancel: function(touch) {
	}
	,onTouchEnd: function(touch) {
	}
	,onTouchMove: function(touch) {
	}
	,onTouchStart: function(touch) {
	}
	,onWindowActivate: function() {
	}
	,onWindowClose: function() {
	}
	,onWindowCreate: function() {
	}
	,onWindowDeactivate: function() {
	}
	,onWindowDropFile: function(file) {
	}
	,onWindowEnter: function() {
	}
	,onWindowExpose: function() {
	}
	,onWindowFocusIn: function() {
	}
	,onWindowFocusOut: function() {
	}
	,onWindowFullscreen: function() {
	}
	,onWindowLeave: function() {
	}
	,onWindowMove: function(x,y) {
	}
	,onWindowMinimize: function() {
	}
	,onWindowResize: function(width,height) {
	}
	,onWindowRestore: function() {
	}
	,removeModule: function(module) {
		if(module != null) {
			module.__unregisterLimeModule(this);
			HxOverrides.remove(this.modules,module);
		}
	}
	,render: function(context) {
	}
	,update: function(deltaTime) {
	}
	,__addWindow: function($window) {
		if($window != null) {
			this.__windows.push($window);
			this.__windowByID.h[$window.id] = $window;
			var f = $bind(this,this.__onWindowClose);
			var window1 = $window;
			var tmp = function() {
				f(window1);
			};
			$window.onClose.add(tmp,false,-10000);
			if(this.__window == null) {
				this.__window = $window;
				$window.onActivate.add($bind(this,this.onWindowActivate));
				$window.onRenderContextLost.add($bind(this,this.onRenderContextLost));
				$window.onRenderContextRestored.add($bind(this,this.onRenderContextRestored));
				$window.onDeactivate.add($bind(this,this.onWindowDeactivate));
				$window.onDropFile.add($bind(this,this.onWindowDropFile));
				$window.onEnter.add($bind(this,this.onWindowEnter));
				$window.onExpose.add($bind(this,this.onWindowExpose));
				$window.onFocusIn.add($bind(this,this.onWindowFocusIn));
				$window.onFocusOut.add($bind(this,this.onWindowFocusOut));
				$window.onFullscreen.add($bind(this,this.onWindowFullscreen));
				$window.onKeyDown.add($bind(this,this.onKeyDown));
				$window.onKeyUp.add($bind(this,this.onKeyUp));
				$window.onLeave.add($bind(this,this.onWindowLeave));
				$window.onMinimize.add($bind(this,this.onWindowMinimize));
				$window.onMouseDown.add($bind(this,this.onMouseDown));
				$window.onMouseMove.add($bind(this,this.onMouseMove));
				$window.onMouseMoveRelative.add($bind(this,this.onMouseMoveRelative));
				$window.onMouseUp.add($bind(this,this.onMouseUp));
				$window.onMouseWheel.add($bind(this,this.onMouseWheel));
				$window.onMove.add($bind(this,this.onWindowMove));
				$window.onRender.add($bind(this,this.render));
				$window.onResize.add($bind(this,this.onWindowResize));
				$window.onRestore.add($bind(this,this.onWindowRestore));
				$window.onTextEdit.add($bind(this,this.onTextEdit));
				$window.onTextInput.add($bind(this,this.onTextInput));
				this.onWindowCreate();
			}
			this.onCreateWindow.dispatch($window);
		}
	}
	,__createWindow: function(attributes) {
		var $window = new lime_ui_Window(this,attributes);
		if($window.id == -1) {
			return null;
		}
		return $window;
	}
	,__registerLimeModule: function(application) {
		application.onUpdate.add($bind(this,this.update));
		application.onExit.add($bind(this,this.onModuleExit),false,0);
		application.onExit.add($bind(this,this.__onModuleExit),false,0);
		var gamepad = lime_ui_Gamepad.devices.iterator();
		while(gamepad.hasNext()) {
			var gamepad1 = gamepad.next();
			this.__onGamepadConnect(gamepad1);
		}
		lime_ui_Gamepad.onConnect.add($bind(this,this.__onGamepadConnect));
		var joystick = lime_ui_Joystick.devices.iterator();
		while(joystick.hasNext()) {
			var joystick1 = joystick.next();
			this.__onJoystickConnect(joystick1);
		}
		lime_ui_Joystick.onConnect.add($bind(this,this.__onJoystickConnect));
		lime_ui_Touch.onCancel.add($bind(this,this.onTouchCancel));
		lime_ui_Touch.onStart.add($bind(this,this.onTouchStart));
		lime_ui_Touch.onMove.add($bind(this,this.onTouchMove));
		lime_ui_Touch.onEnd.add($bind(this,this.onTouchEnd));
	}
	,__removeWindow: function($window) {
		if($window != null && this.__windowByID.h.hasOwnProperty($window.id)) {
			if(this.__window == $window) {
				this.__window = null;
			}
			HxOverrides.remove(this.__windows,$window);
			this.__windowByID.remove($window.id);
			$window.close();
			if(this.__windows.length == 0) {
				lime_system_System.exit(0);
			}
		}
	}
	,__onGamepadConnect: function(gamepad) {
		this.onGamepadConnect(gamepad);
		var f = $bind(this,this.onGamepadAxisMove);
		var gamepad1 = gamepad;
		var tmp = function(axis,value) {
			f(gamepad1,axis,value);
		};
		gamepad.onAxisMove.add(tmp);
		var f1 = $bind(this,this.onGamepadButtonDown);
		var gamepad2 = gamepad;
		var tmp1 = function(button) {
			f1(gamepad2,button);
		};
		gamepad.onButtonDown.add(tmp1);
		var f2 = $bind(this,this.onGamepadButtonUp);
		var gamepad3 = gamepad;
		var tmp2 = function(button1) {
			f2(gamepad3,button1);
		};
		gamepad.onButtonUp.add(tmp2);
		var f3 = $bind(this,this.onGamepadDisconnect);
		var gamepad4 = gamepad;
		var tmp3 = function() {
			f3(gamepad4);
		};
		gamepad.onDisconnect.add(tmp3);
	}
	,__onJoystickConnect: function(joystick) {
		this.onJoystickConnect(joystick);
		var f = $bind(this,this.onJoystickAxisMove);
		var joystick1 = joystick;
		var tmp = function(axis,value) {
			f(joystick1,axis,value);
		};
		joystick.onAxisMove.add(tmp);
		var f1 = $bind(this,this.onJoystickButtonDown);
		var joystick2 = joystick;
		var tmp1 = function(button) {
			f1(joystick2,button);
		};
		joystick.onButtonDown.add(tmp1);
		var f2 = $bind(this,this.onJoystickButtonUp);
		var joystick3 = joystick;
		var tmp2 = function(button1) {
			f2(joystick3,button1);
		};
		joystick.onButtonUp.add(tmp2);
		var f3 = $bind(this,this.onJoystickDisconnect);
		var joystick4 = joystick;
		var tmp3 = function() {
			f3(joystick4);
		};
		joystick.onDisconnect.add(tmp3);
		var f4 = $bind(this,this.onJoystickHatMove);
		var joystick5 = joystick;
		var tmp4 = function(hat,position) {
			f4(joystick5,hat,position);
		};
		joystick.onHatMove.add(tmp4);
		var f5 = $bind(this,this.onJoystickTrackballMove);
		var joystick6 = joystick;
		var tmp5 = function(trackball,x,y) {
			f5(joystick6,trackball,x,y);
		};
		joystick.onTrackballMove.add(tmp5);
	}
	,__onModuleExit: function(code) {
		this.__backend.exit();
	}
	,__onWindowClose: function($window) {
		if(this.__window == $window) {
			this.onWindowClose();
		}
		this.__removeWindow($window);
	}
	,__unregisterLimeModule: function(application) {
		application.onUpdate.remove($bind(this,this.update));
		application.onExit.remove($bind(this,this.__onModuleExit));
		application.onExit.remove($bind(this,this.onModuleExit));
		lime_ui_Gamepad.onConnect.remove($bind(this,this.__onGamepadConnect));
		lime_ui_Joystick.onConnect.remove($bind(this,this.__onJoystickConnect));
		lime_ui_Touch.onCancel.remove($bind(this,this.onTouchCancel));
		lime_ui_Touch.onStart.remove($bind(this,this.onTouchStart));
		lime_ui_Touch.onMove.remove($bind(this,this.onTouchMove));
		lime_ui_Touch.onEnd.remove($bind(this,this.onTouchEnd));
		this.onModuleExit(0);
	}
	,get_preloader: function() {
		return this.__preloader;
	}
	,get_window: function() {
		return this.__window;
	}
	,get_windows: function() {
		return this.__windows;
	}
	,__class__: lime_app_Application
	,__properties__: {get_windows:"get_windows",get_window:"get_window",get_preloader:"get_preloader"}
});
var ApplicationMain = function() { };
$hxClasses["ApplicationMain"] = ApplicationMain;
ApplicationMain.__name__ = "ApplicationMain";
ApplicationMain.main = function() {
	lime_system_System.__registerEntryPoint("Tweening3D",ApplicationMain.create);
};
ApplicationMain.create = function(config) {
	var app = new openfl_display_Application();
	ManifestResources.init(config);
	var _this = app.meta;
	if(__map_reserved["build"] != null) {
		_this.setReserved("build","324");
	} else {
		_this.h["build"] = "324";
	}
	var _this1 = app.meta;
	if(__map_reserved["company"] != null) {
		_this1.setReserved("company","");
	} else {
		_this1.h["company"] = "";
	}
	var _this2 = app.meta;
	if(__map_reserved["file"] != null) {
		_this2.setReserved("file","Tweening3D");
	} else {
		_this2.h["file"] = "Tweening3D";
	}
	var _this3 = app.meta;
	if(__map_reserved["name"] != null) {
		_this3.setReserved("name","Away3D Basic Tweening3D");
	} else {
		_this3.h["name"] = "Away3D Basic Tweening3D";
	}
	var _this4 = app.meta;
	if(__map_reserved["packageName"] != null) {
		_this4.setReserved("packageName","away3d.samples.basictweening3d");
	} else {
		_this4.h["packageName"] = "away3d.samples.basictweening3d";
	}
	var _this5 = app.meta;
	if(__map_reserved["version"] != null) {
		_this5.setReserved("version","1.0.0");
	} else {
		_this5.h["version"] = "1.0.0";
	}
	var attributes = { allowHighDPI : false, alwaysOnTop : false, borderless : false, element : null, frameRate : 60, height : 0, hidden : false, maximized : false, minimized : false, parameters : { }, resizable : true, title : "Away3D Basic Tweening3D", width : 0, x : null, y : null};
	attributes.context = { antialiasing : 0, background : 0, colorDepth : 32, depth : true, hardware : true, stencil : true, type : null, vsync : false};
	if(app.__window == null) {
		if(config != null) {
			var _g = 0;
			var _g1 = Reflect.fields(config);
			while(_g < _g1.length) {
				var field = _g1[_g];
				++_g;
				if(Object.prototype.hasOwnProperty.call(attributes,field)) {
					attributes[field] = Reflect.field(config,field);
				} else if(Object.prototype.hasOwnProperty.call(attributes.context,field)) {
					attributes.context[field] = Reflect.field(config,field);
				}
			}
		}
	}
	app.createWindow(attributes);
	var preloader = new openfl_display_Preloader(new openfl_display_DefaultPreloader());
	app.__preloader.onProgress.add(function(loaded,total) {
		preloader.update(loaded,total);
	});
	app.__preloader.onComplete.add(function() {
		preloader.start();
	});
	var stage = (js_Boot.__cast(app.__window , openfl_display_Window)).stage;
	var tmp = function() {
		ApplicationMain.start(stage);
	};
	preloader.onComplete.add(tmp);
	var _g2 = 0;
	var _g11 = ManifestResources.preloadLibraries;
	while(_g2 < _g11.length) {
		var library = _g11[_g2];
		++_g2;
		app.__preloader.addLibrary(library);
	}
	var _g21 = 0;
	var _g3 = ManifestResources.preloadLibraryNames;
	while(_g21 < _g3.length) {
		var name = _g3[_g21];
		++_g21;
		app.__preloader.addLibraryName(name);
	}
	app.__preloader.load();
	var result = app.exec();
};
ApplicationMain.start = function(stage) {
	try {
		var current = stage.getChildAt(0);
		if(current == null || !((current) instanceof openfl_display_DisplayObjectContainer)) {
			current = new openfl_display_MovieClip();
			stage.addChild(current);
		}
		new DocumentClass(current);
		stage.dispatchEvent(new openfl_events_Event("resize",false,false));
		if(stage.window.__fullscreen) {
			stage.dispatchEvent(new openfl_events_FullScreenEvent("fullScreen",false,false,true,true));
		}
	} catch( e ) {
		haxe_CallStack.lastException = e;
		stage.__handleError(((e) instanceof js__$Boot_HaxeError) ? e.val : e);
	}
};
var openfl_events_IEventDispatcher = function() { };
$hxClasses["openfl.events.IEventDispatcher"] = openfl_events_IEventDispatcher;
openfl_events_IEventDispatcher.__name__ = "openfl.events.IEventDispatcher";
openfl_events_IEventDispatcher.__isInterface__ = true;
openfl_events_IEventDispatcher.prototype = {
	addEventListener: null
	,dispatchEvent: null
	,hasEventListener: null
	,removeEventListener: null
	,willTrigger: null
	,__class__: openfl_events_IEventDispatcher
};
var openfl_events_EventDispatcher = function(target) {
	if(target != null) {
		this.__targetDispatcher = target;
	}
};
$hxClasses["openfl.events.EventDispatcher"] = openfl_events_EventDispatcher;
openfl_events_EventDispatcher.__name__ = "openfl.events.EventDispatcher";
openfl_events_EventDispatcher.__interfaces__ = [openfl_events_IEventDispatcher];
openfl_events_EventDispatcher.prototype = {
	__eventMap: null
	,__iterators: null
	,__targetDispatcher: null
	,addEventListener: function(type,listener,useCapture,priority,useWeakReference) {
		if(useWeakReference == null) {
			useWeakReference = false;
		}
		if(priority == null) {
			priority = 0;
		}
		if(useCapture == null) {
			useCapture = false;
		}
		if(listener == null) {
			return;
		}
		if(this.__eventMap == null) {
			this.__eventMap = new haxe_ds_StringMap();
			this.__iterators = new haxe_ds_StringMap();
		}
		var _this = this.__eventMap;
		if(!(__map_reserved[type] != null ? _this.existsReserved(type) : _this.h.hasOwnProperty(type))) {
			var list = [];
			list.push(new openfl_events__$EventDispatcher_Listener(listener,useCapture,priority));
			var iterator = new openfl_events__$EventDispatcher_DispatchIterator(list);
			var _this1 = this.__eventMap;
			if(__map_reserved[type] != null) {
				_this1.setReserved(type,list);
			} else {
				_this1.h[type] = list;
			}
			var _this2 = this.__iterators;
			var value = [iterator];
			if(__map_reserved[type] != null) {
				_this2.setReserved(type,value);
			} else {
				_this2.h[type] = value;
			}
		} else {
			var _this3 = this.__eventMap;
			var list1 = __map_reserved[type] != null ? _this3.getReserved(type) : _this3.h[type];
			var _g = 0;
			var _g1 = list1.length;
			while(_g < _g1) {
				var i = _g++;
				if(list1[i].match(listener,useCapture)) {
					return;
				}
			}
			var _this4 = this.__iterators;
			var iterators = __map_reserved[type] != null ? _this4.getReserved(type) : _this4.h[type];
			var _g2 = 0;
			while(_g2 < iterators.length) {
				var iterator1 = iterators[_g2];
				++_g2;
				if(iterator1.active) {
					iterator1.copy();
				}
			}
			this.__addListenerByPriority(list1,new openfl_events__$EventDispatcher_Listener(listener,useCapture,priority));
		}
	}
	,dispatchEvent: function(event) {
		if(this.__targetDispatcher != null) {
			event.target = this.__targetDispatcher;
		} else {
			event.target = this;
		}
		return this.__dispatchEvent(event);
	}
	,hasEventListener: function(type) {
		if(this.__eventMap == null) {
			return false;
		}
		var _this = this.__eventMap;
		if(__map_reserved[type] != null) {
			return _this.existsReserved(type);
		} else {
			return _this.h.hasOwnProperty(type);
		}
	}
	,removeEventListener: function(type,listener,useCapture) {
		if(useCapture == null) {
			useCapture = false;
		}
		if(this.__eventMap == null || listener == null) {
			return;
		}
		var _this = this.__eventMap;
		var list = __map_reserved[type] != null ? _this.getReserved(type) : _this.h[type];
		if(list == null) {
			return;
		}
		var _this1 = this.__iterators;
		var iterators = __map_reserved[type] != null ? _this1.getReserved(type) : _this1.h[type];
		var _g = 0;
		var _g1 = list.length;
		while(_g < _g1) {
			var i = _g++;
			if(list[i].match(listener,useCapture)) {
				var _g2 = 0;
				while(_g2 < iterators.length) {
					var iterator = iterators[_g2];
					++_g2;
					iterator.remove(list[i],i);
				}
				list.splice(i,1);
				break;
			}
		}
		if(list.length == 0) {
			this.__eventMap.remove(type);
			this.__iterators.remove(type);
		}
		var _this2 = this.__eventMap;
		if(!new haxe_ds__$StringMap_StringMapIterator(_this2,_this2.arrayKeys()).hasNext()) {
			this.__eventMap = null;
			this.__iterators = null;
		}
	}
	,toString: function() {
		var c = js_Boot.getClass(this);
		var full = c.__name__;
		var short = full.split(".").pop();
		return "[object " + short + "]";
	}
	,willTrigger: function(type) {
		return this.hasEventListener(type);
	}
	,__dispatchEvent: function(event) {
		if(this.__eventMap == null || event == null) {
			return true;
		}
		var type = event.type;
		var _this = this.__eventMap;
		var list = __map_reserved[type] != null ? _this.getReserved(type) : _this.h[type];
		if(list == null) {
			return true;
		}
		if(event.target == null) {
			if(this.__targetDispatcher != null) {
				event.target = this.__targetDispatcher;
			} else {
				event.target = this;
			}
		}
		event.currentTarget = this;
		var capture = event.eventPhase == 1;
		var _this1 = this.__iterators;
		var iterators = __map_reserved[type] != null ? _this1.getReserved(type) : _this1.h[type];
		var iterator = iterators[0];
		if(iterator.active) {
			iterator = new openfl_events__$EventDispatcher_DispatchIterator(list);
			iterators.push(iterator);
		}
		iterator.start();
		var listener = iterator;
		while(listener.hasNext()) {
			var listener1 = listener.next();
			if(listener1 == null) {
				continue;
			}
			if(listener1.useCapture == capture) {
				listener1.callback(event);
				if(event.__isCanceledNow) {
					break;
				}
			}
		}
		iterator.stop();
		if(iterator != iterators[0]) {
			HxOverrides.remove(iterators,iterator);
		} else {
			iterator.reset(list);
		}
		return !event.isDefaultPrevented();
	}
	,__removeAllListeners: function() {
		this.__eventMap = null;
		this.__iterators = null;
	}
	,__addListenerByPriority: function(list,listener) {
		var numElements = list.length;
		var addAtPosition = numElements;
		var _g = 0;
		var _g1 = numElements;
		while(_g < _g1) {
			var i = _g++;
			if(list[i].priority < listener.priority) {
				addAtPosition = i;
				break;
			}
		}
		list.splice(addAtPosition,0,listener);
	}
	,__class__: openfl_events_EventDispatcher
};
var openfl_display_IBitmapDrawable = function() { };
$hxClasses["openfl.display.IBitmapDrawable"] = openfl_display_IBitmapDrawable;
openfl_display_IBitmapDrawable.__name__ = "openfl.display.IBitmapDrawable";
openfl_display_IBitmapDrawable.__isInterface__ = true;
openfl_display_IBitmapDrawable.prototype = {
	__blendMode: null
	,__isMask: null
	,__renderable: null
	,__renderTransform: null
	,__transform: null
	,__worldAlpha: null
	,__worldColorTransform: null
	,__worldTransform: null
	,__getBounds: null
	,__renderCairo: null
	,__renderCairoMask: null
	,__renderCanvas: null
	,__renderCanvasMask: null
	,__renderDOM: null
	,__renderGL: null
	,__renderGLMask: null
	,__update: null
	,__updateTransforms: null
	,__mask: null
	,__scrollRect: null
	,__class__: openfl_display_IBitmapDrawable
};
var openfl__$Vector_Vector_$Impl_$ = {};
$hxClasses["openfl._Vector.Vector_Impl_"] = openfl__$Vector_Vector_$Impl_$;
openfl__$Vector_Vector_$Impl_$.__name__ = "openfl._Vector.Vector_Impl_";
openfl__$Vector_Vector_$Impl_$.__properties__ = {set_length:"set_length",get_length:"get_length",set_fixed:"set_fixed",get_fixed:"get_fixed"};
openfl__$Vector_Vector_$Impl_$.ofArray_String = function(array) {
	var vector = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	var _g = 0;
	var _g1 = array.length;
	while(_g < _g1) {
		var i = _g++;
		vector.set(i,array[i]);
	}
	return vector;
};
openfl__$Vector_Vector_$Impl_$.ofArray_Int = function(array) {
	var vector = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
	var _g = 0;
	var _g1 = array.length;
	while(_g < _g1) {
		var i = _g++;
		vector.set(i,array[i]);
	}
	return vector;
};
openfl__$Vector_Vector_$Impl_$.ofArray_openfl_geom_Vector3D = function(array) {
	var vector = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	var _g = 0;
	var _g1 = array.length;
	while(_g < _g1) {
		var i = _g++;
		vector.set(i,array[i]);
	}
	return vector;
};
openfl__$Vector_Vector_$Impl_$.ofArray_Float = function(array) {
	var vector = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
	var _g = 0;
	var _g1 = array.length;
	while(_g < _g1) {
		var i = _g++;
		vector.set(i,array[i]);
	}
	return vector;
};
openfl__$Vector_Vector_$Impl_$.ofArray_UInt = function(array) {
	var vector = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
	var _g = 0;
	var _g1 = array.length;
	while(_g < _g1) {
		var i = _g++;
		vector.set(i,array[i]);
	}
	return vector;
};
openfl__$Vector_Vector_$Impl_$.concat = function(this1,vec) {
	return this1.concat(vec);
};
openfl__$Vector_Vector_$Impl_$.copy = function(this1) {
	return this1.copy();
};
openfl__$Vector_Vector_$Impl_$.filter = function(this1,callback) {
	return this1.filter(callback);
};
openfl__$Vector_Vector_$Impl_$.get = function(this1,index) {
	return this1.get(index);
};
openfl__$Vector_Vector_$Impl_$.indexOf = function(this1,searchElement,fromIndex) {
	if(fromIndex == null) {
		fromIndex = 0;
	}
	return this1.indexOf(searchElement,fromIndex);
};
openfl__$Vector_Vector_$Impl_$.insertAt = function(this1,index,element) {
	this1.insertAt(index,element);
};
openfl__$Vector_Vector_$Impl_$.iterator = function(this1) {
	return this1.iterator();
};
openfl__$Vector_Vector_$Impl_$.join = function(this1,sep) {
	if(sep == null) {
		sep = ",";
	}
	return this1.join(sep);
};
openfl__$Vector_Vector_$Impl_$.lastIndexOf = function(this1,searchElement,fromIndex) {
	return this1.lastIndexOf(searchElement,fromIndex);
};
openfl__$Vector_Vector_$Impl_$.pop = function(this1) {
	return this1.pop();
};
openfl__$Vector_Vector_$Impl_$.push = function(this1,value) {
	return this1.push(value);
};
openfl__$Vector_Vector_$Impl_$.removeAt = function(this1,index) {
	return this1.removeAt(index);
};
openfl__$Vector_Vector_$Impl_$.reverse = function(this1) {
	return this1.reverse();
};
openfl__$Vector_Vector_$Impl_$.set = function(this1,index,value) {
	return this1.set(index,value);
};
openfl__$Vector_Vector_$Impl_$.shift = function(this1) {
	return this1.shift();
};
openfl__$Vector_Vector_$Impl_$.slice = function(this1,startIndex,endIndex) {
	if(startIndex == null) {
		startIndex = 0;
	}
	return this1.slice(startIndex,endIndex);
};
openfl__$Vector_Vector_$Impl_$.sort = function(this1,sortBehavior) {
	this1.sort(sortBehavior);
};
openfl__$Vector_Vector_$Impl_$.splice = function(this1,startIndex,deleteCount) {
	return this1.splice(startIndex,deleteCount);
};
openfl__$Vector_Vector_$Impl_$.toString = function(this1) {
	if(this1 != null) {
		return this1.toString();
	} else {
		return null;
	}
};
openfl__$Vector_Vector_$Impl_$.unshift = function(this1,value) {
	this1.unshift(value);
};
openfl__$Vector_Vector_$Impl_$.convert = function(vec) {
	return vec;
};
openfl__$Vector_Vector_$Impl_$.toBoolVector = function(t,length,fixed,array) {
	return new openfl__$Vector_BoolVector(length,fixed,array);
};
openfl__$Vector_Vector_$Impl_$.toIntVector = function(t,length,fixed,array) {
	return new openfl__$Vector_IntVector(length,fixed,array);
};
openfl__$Vector_Vector_$Impl_$.toFloatVector = function(t,length,fixed,array) {
	return new openfl__$Vector_FloatVector(length,fixed,array,true);
};
openfl__$Vector_Vector_$Impl_$.toFunctionVector = function(t,length,fixed,array) {
	return new openfl__$Vector_FunctionVector(length,fixed,array);
};
openfl__$Vector_Vector_$Impl_$.toObjectVector = function(t,length,fixed,array) {
	return new openfl__$Vector_ObjectVector(length,fixed,array,true);
};
openfl__$Vector_Vector_$Impl_$.toNullVector = function(t,length,fixed,array) {
	return new openfl__$Vector_ObjectVector(length,fixed,array,true);
};
openfl__$Vector_Vector_$Impl_$.fromBoolVector = function(vector) {
	return vector;
};
openfl__$Vector_Vector_$Impl_$.fromIntVector = function(vector) {
	return vector;
};
openfl__$Vector_Vector_$Impl_$.fromFloatVector = function(vector) {
	return vector;
};
openfl__$Vector_Vector_$Impl_$.fromFunctionVector = function(vector) {
	return vector;
};
openfl__$Vector_Vector_$Impl_$.fromObjectVector = function(vector) {
	return vector;
};
openfl__$Vector_Vector_$Impl_$.get_fixed = function(this1) {
	return this1.fixed;
};
openfl__$Vector_Vector_$Impl_$.set_fixed = function(this1,value) {
	return this1.fixed = value;
};
openfl__$Vector_Vector_$Impl_$.get_length = function(this1) {
	return this1.get_length();
};
openfl__$Vector_Vector_$Impl_$.set_length = function(this1,value) {
	return this1.set_length(value);
};
var lime_utils_ObjectPool = function(create,clean,size) {
	this.__pool = new haxe_ds_ObjectMap();
	this.activeObjects = 0;
	this.inactiveObjects = 0;
	this.__inactiveObject0 = null;
	this.__inactiveObject1 = null;
	this.__inactiveObjectList = new haxe_ds_List();
	if(create != null) {
		this.create = create;
	}
	if(clean != null) {
		this.clean = clean;
	}
	if(size != null) {
		this.set_size(size);
	}
};
$hxClasses["lime.utils.ObjectPool"] = lime_utils_ObjectPool;
lime_utils_ObjectPool.__name__ = "lime.utils.ObjectPool";
lime_utils_ObjectPool.prototype = {
	activeObjects: null
	,inactiveObjects: null
	,__inactiveObject0: null
	,__inactiveObject1: null
	,__inactiveObjectList: null
	,__pool: null
	,__size: null
	,add: function(object) {
		if(!this.__pool.exists(object)) {
			this.__pool.set(object,false);
			this.clean(object);
			if(this.__inactiveObject0 == null) {
				this.__inactiveObject0 = object;
			} else if(this.__inactiveObject1 == null) {
				this.__inactiveObject1 = object;
			} else {
				this.__inactiveObjectList.add(object);
			}
			this.inactiveObjects++;
		}
	}
	,clean: function(object) {
	}
	,clear: function() {
		this.__pool = new haxe_ds_ObjectMap();
		this.activeObjects = 0;
		this.inactiveObjects = 0;
		this.__inactiveObject0 = null;
		this.__inactiveObject1 = null;
		this.__inactiveObjectList.clear();
	}
	,create: function() {
		return null;
	}
	,get: function() {
		var object = null;
		if(this.inactiveObjects > 0) {
			var object1 = null;
			if(this.__inactiveObject0 != null) {
				object1 = this.__inactiveObject0;
				this.__inactiveObject0 = null;
			} else if(this.__inactiveObject1 != null) {
				object1 = this.__inactiveObject1;
				this.__inactiveObject1 = null;
			} else {
				object1 = this.__inactiveObjectList.pop();
				if(this.__inactiveObjectList.length > 0) {
					this.__inactiveObject0 = this.__inactiveObjectList.pop();
				}
				if(this.__inactiveObjectList.length > 0) {
					this.__inactiveObject1 = this.__inactiveObjectList.pop();
				}
			}
			this.inactiveObjects--;
			this.activeObjects++;
			object = object1;
		} else if(this.__size == null || this.activeObjects < this.__size) {
			object = this.create();
			if(object != null) {
				this.__pool.set(object,true);
				this.activeObjects++;
			}
		}
		return object;
	}
	,release: function(object) {
		this.activeObjects--;
		if(this.__size == null || this.activeObjects + this.inactiveObjects < this.__size) {
			this.clean(object);
			if(this.__inactiveObject0 == null) {
				this.__inactiveObject0 = object;
			} else if(this.__inactiveObject1 == null) {
				this.__inactiveObject1 = object;
			} else {
				this.__inactiveObjectList.add(object);
			}
			this.inactiveObjects++;
		} else {
			this.__pool.remove(object);
		}
	}
	,remove: function(object) {
		if(this.__pool.exists(object)) {
			this.__pool.remove(object);
			if(this.__inactiveObject0 == object) {
				this.__inactiveObject0 = null;
				this.inactiveObjects--;
			} else if(this.__inactiveObject1 == object) {
				this.__inactiveObject1 = null;
				this.inactiveObjects--;
			} else if(this.__inactiveObjectList.remove(object)) {
				this.inactiveObjects--;
			} else {
				this.activeObjects--;
			}
		}
	}
	,__addInactive: function(object) {
		if(this.__inactiveObject0 == null) {
			this.__inactiveObject0 = object;
		} else if(this.__inactiveObject1 == null) {
			this.__inactiveObject1 = object;
		} else {
			this.__inactiveObjectList.add(object);
		}
		this.inactiveObjects++;
	}
	,__getInactive: function() {
		var object = null;
		if(this.__inactiveObject0 != null) {
			object = this.__inactiveObject0;
			this.__inactiveObject0 = null;
		} else if(this.__inactiveObject1 != null) {
			object = this.__inactiveObject1;
			this.__inactiveObject1 = null;
		} else {
			object = this.__inactiveObjectList.pop();
			if(this.__inactiveObjectList.length > 0) {
				this.__inactiveObject0 = this.__inactiveObjectList.pop();
			}
			if(this.__inactiveObjectList.length > 0) {
				this.__inactiveObject1 = this.__inactiveObjectList.pop();
			}
		}
		this.inactiveObjects--;
		this.activeObjects++;
		return object;
	}
	,__removeInactive: function(count) {
		if(count <= 0 || this.inactiveObjects == 0) {
			return;
		}
		if(this.__inactiveObject0 != null) {
			this.__pool.remove(this.__inactiveObject0);
			this.__inactiveObject0 = null;
			this.inactiveObjects--;
			--count;
		}
		if(count == 0 || this.inactiveObjects == 0) {
			return;
		}
		if(this.__inactiveObject1 != null) {
			this.__pool.remove(this.__inactiveObject1);
			this.__inactiveObject1 = null;
			this.inactiveObjects--;
			--count;
		}
		if(count == 0 || this.inactiveObjects == 0) {
			return;
		}
		var _g_head = this.__inactiveObjectList.h;
		while(_g_head != null) {
			var val = _g_head.item;
			_g_head = _g_head.next;
			var object = val;
			this.__pool.remove(object);
			this.__inactiveObjectList.remove(object);
			this.inactiveObjects--;
			--count;
			if(count == 0 || this.inactiveObjects == 0) {
				return;
			}
		}
	}
	,get_size: function() {
		return this.__size;
	}
	,set_size: function(value) {
		if(value == null) {
			this.__size = null;
		} else {
			var current = this.inactiveObjects + this.activeObjects;
			this.__size = value;
			if(current > value) {
				this.__removeInactive(current - value);
			} else if(value > current) {
				var object;
				var _g = 0;
				var _g1 = value - current;
				while(_g < _g1) {
					var i = _g++;
					object = this.create();
					if(object != null) {
						this.__pool.set(object,false);
						this.__inactiveObjectList.add(object);
						this.inactiveObjects++;
					} else {
						break;
					}
				}
			}
		}
		return value;
	}
	,__class__: lime_utils_ObjectPool
	,__properties__: {set_size:"set_size",get_size:"get_size"}
};
var haxe_IMap = function() { };
$hxClasses["haxe.IMap"] = haxe_IMap;
haxe_IMap.__name__ = "haxe.IMap";
haxe_IMap.__isInterface__ = true;
haxe_IMap.prototype = {
	set: null
	,exists: null
	,remove: null
	,__class__: haxe_IMap
};
var haxe_ds_ObjectMap = function() {
	this.h = { __keys__ : { }};
};
$hxClasses["haxe.ds.ObjectMap"] = haxe_ds_ObjectMap;
haxe_ds_ObjectMap.__name__ = "haxe.ds.ObjectMap";
haxe_ds_ObjectMap.__interfaces__ = [haxe_IMap];
haxe_ds_ObjectMap.prototype = {
	h: null
	,set: function(key,value) {
		var id = key.__id__;
		if(id == null) {
			id = (key.__id__ = $global.$haxeUID++);
		}
		this.h[id] = value;
		this.h.__keys__[id] = key;
	}
	,exists: function(key) {
		return this.h.__keys__[key.__id__] != null;
	}
	,remove: function(key) {
		var id = key.__id__;
		if(this.h.__keys__[id] == null) {
			return false;
		}
		delete(this.h[id]);
		delete(this.h.__keys__[id]);
		return true;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h.__keys__ ) {
		if(this.h.hasOwnProperty(key)) {
			a.push(this.h.__keys__[key]);
		}
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i.__id__];
		}};
	}
	,__class__: haxe_ds_ObjectMap
};
var haxe_ds_List = function() {
	this.length = 0;
};
$hxClasses["haxe.ds.List"] = haxe_ds_List;
haxe_ds_List.__name__ = "haxe.ds.List";
haxe_ds_List.prototype = {
	h: null
	,q: null
	,length: null
	,add: function(item) {
		var x = new haxe_ds__$List_ListNode(item,null);
		if(this.h == null) {
			this.h = x;
		} else {
			this.q.next = x;
		}
		this.q = x;
		this.length++;
	}
	,push: function(item) {
		var x = new haxe_ds__$List_ListNode(item,this.h);
		this.h = x;
		if(this.q == null) {
			this.q = x;
		}
		this.length++;
	}
	,pop: function() {
		if(this.h == null) {
			return null;
		}
		var x = this.h.item;
		this.h = this.h.next;
		if(this.h == null) {
			this.q = null;
		}
		this.length--;
		return x;
	}
	,clear: function() {
		this.h = null;
		this.q = null;
		this.length = 0;
	}
	,remove: function(v) {
		var prev = null;
		var l = this.h;
		while(l != null) {
			if(l.item == v) {
				if(prev == null) {
					this.h = l.next;
				} else {
					prev.next = l.next;
				}
				if(this.q == l) {
					this.q = prev;
				}
				this.length--;
				return true;
			}
			prev = l;
			l = l.next;
		}
		return false;
	}
	,iterator: function() {
		return new haxe_ds__$List_ListIterator(this.h);
	}
	,__class__: haxe_ds_List
};
var openfl_display_DisplayObject = function() {
	openfl_events_EventDispatcher.call(this);
	this.__alpha = 1;
	this.__blendMode = 10;
	this.__cacheAsBitmap = false;
	this.__transform = new openfl_geom_Matrix();
	this.__visible = true;
	this.__rotation = 0;
	this.__rotationSine = 0;
	this.__rotationCosine = 1;
	this.__scaleX = 1;
	this.__scaleY = 1;
	this.__worldAlpha = 1;
	this.__worldBlendMode = 10;
	this.__worldTransform = new openfl_geom_Matrix();
	this.__worldColorTransform = new openfl_geom_ColorTransform();
	this.__renderTransform = new openfl_geom_Matrix();
	this.__worldVisible = true;
	this.set_name("instance" + ++openfl_display_DisplayObject.__instanceCount);
	if(openfl_display_DisplayObject.__initStage != null) {
		this.stage = openfl_display_DisplayObject.__initStage;
		openfl_display_DisplayObject.__initStage = null;
		this.stage.addChild(this);
	}
};
$hxClasses["openfl.display.DisplayObject"] = openfl_display_DisplayObject;
openfl_display_DisplayObject.__name__ = "openfl.display.DisplayObject";
openfl_display_DisplayObject.__interfaces__ = [openfl_display_IBitmapDrawable];
openfl_display_DisplayObject.__calculateAbsoluteTransform = function(local,parentTransform,target) {
	target.a = local.a * parentTransform.a + local.b * parentTransform.c;
	target.b = local.a * parentTransform.b + local.b * parentTransform.d;
	target.c = local.c * parentTransform.a + local.d * parentTransform.c;
	target.d = local.c * parentTransform.b + local.d * parentTransform.d;
	target.tx = local.tx * parentTransform.a + local.ty * parentTransform.c + parentTransform.tx;
	target.ty = local.tx * parentTransform.b + local.ty * parentTransform.d + parentTransform.ty;
};
openfl_display_DisplayObject.__super__ = openfl_events_EventDispatcher;
openfl_display_DisplayObject.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	opaqueBackground: null
	,parent: null
	,stage: null
	,__alpha: null
	,__blendMode: null
	,__cacheAsBitmap: null
	,__cacheAsBitmapMatrix: null
	,__cacheBitmap: null
	,__cacheBitmapBackground: null
	,__cacheBitmapColorTransform: null
	,__cacheBitmapData: null
	,__cacheBitmapData2: null
	,__cacheBitmapData3: null
	,__cacheBitmapMatrix: null
	,__cacheBitmapRenderer: null
	,__cairo: null
	,__children: null
	,__customRenderClear: null
	,__customRenderEvent: null
	,__filters: null
	,__graphics: null
	,__interactive: null
	,__isCacheBitmapRender: null
	,__isMask: null
	,__loaderInfo: null
	,__mask: null
	,__maskTarget: null
	,__name: null
	,__objectTransform: null
	,__renderable: null
	,__renderDirty: null
	,__renderParent: null
	,__renderTransform: null
	,__renderTransformCache: null
	,__renderTransformChanged: null
	,__rotation: null
	,__rotationCosine: null
	,__rotationSine: null
	,__scale9Grid: null
	,__scaleX: null
	,__scaleY: null
	,__scrollRect: null
	,__shader: null
	,__tempPoint: null
	,__transform: null
	,__transformDirty: null
	,__visible: null
	,__worldAlpha: null
	,__worldAlphaChanged: null
	,__worldBlendMode: null
	,__worldClip: null
	,__worldClipChanged: null
	,__worldColorTransform: null
	,__worldShader: null
	,__worldScale9Grid: null
	,__worldTransform: null
	,__worldVisible: null
	,__worldVisibleChanged: null
	,__worldTransformInvalid: null
	,__worldZ: null
	,__canvas: null
	,__context: null
	,__style: null
	,addEventListener: function(type,listener,useCapture,priority,useWeakReference) {
		if(useWeakReference == null) {
			useWeakReference = false;
		}
		if(priority == null) {
			priority = 0;
		}
		if(useCapture == null) {
			useCapture = false;
		}
		switch(type) {
		case "activate":case "deactivate":case "enterFrame":case "exitFrame":case "frameConstructed":case "render":
			var _this = openfl_display_DisplayObject.__broadcastEvents;
			if(!(__map_reserved[type] != null ? _this.existsReserved(type) : _this.h.hasOwnProperty(type))) {
				var _this1 = openfl_display_DisplayObject.__broadcastEvents;
				var value = [];
				if(__map_reserved[type] != null) {
					_this1.setReserved(type,value);
				} else {
					_this1.h[type] = value;
				}
			}
			var _this2 = openfl_display_DisplayObject.__broadcastEvents;
			var dispatchers = __map_reserved[type] != null ? _this2.getReserved(type) : _this2.h[type];
			if(dispatchers.indexOf(this) == -1) {
				dispatchers.push(this);
			}
			break;
		case "clearDOM":case "renderCairo":case "renderCanvas":case "renderDOM":case "renderOpenGL":
			if(this.__customRenderEvent == null) {
				this.__customRenderEvent = new openfl_events_RenderEvent(null);
				this.__customRenderEvent.objectColorTransform = new openfl_geom_ColorTransform();
				this.__customRenderEvent.objectMatrix = new openfl_geom_Matrix();
				this.__customRenderClear = true;
			}
			break;
		default:
		}
		openfl_events_EventDispatcher.prototype.addEventListener.call(this,type,listener,useCapture,priority,useWeakReference);
	}
	,dispatchEvent: function(event) {
		if(((event) instanceof openfl_events_MouseEvent)) {
			var mouseEvent = event;
			var _this = this.__getRenderTransform();
			mouseEvent.stageX = mouseEvent.localX * _this.a + mouseEvent.localY * _this.c + _this.tx;
			var _this1 = this.__getRenderTransform();
			mouseEvent.stageY = mouseEvent.localX * _this1.b + mouseEvent.localY * _this1.d + _this1.ty;
		} else if(((event) instanceof openfl_events_TouchEvent)) {
			var touchEvent = event;
			var _this2 = this.__getRenderTransform();
			touchEvent.stageX = touchEvent.localX * _this2.a + touchEvent.localY * _this2.c + _this2.tx;
			var _this3 = this.__getRenderTransform();
			touchEvent.stageY = touchEvent.localX * _this3.b + touchEvent.localY * _this3.d + _this3.ty;
		}
		event.target = this;
		return this.__dispatchWithCapture(event);
	}
	,getBounds: function(targetCoordinateSpace) {
		var matrix = openfl_geom_Matrix.__pool.get();
		if(targetCoordinateSpace != null && targetCoordinateSpace != this) {
			matrix.copyFrom(this.__getWorldTransform());
			var targetMatrix = openfl_geom_Matrix.__pool.get();
			targetMatrix.copyFrom(targetCoordinateSpace.__getWorldTransform());
			targetMatrix.invert();
			matrix.concat(targetMatrix);
			openfl_geom_Matrix.__pool.release(targetMatrix);
		} else {
			matrix.identity();
		}
		var bounds = new openfl_geom_Rectangle();
		this.__getBounds(bounds,matrix);
		openfl_geom_Matrix.__pool.release(matrix);
		return bounds;
	}
	,getRect: function(targetCoordinateSpace) {
		return this.getBounds(targetCoordinateSpace);
	}
	,globalToLocal: function(pos) {
		return this.__globalToLocal(pos,new openfl_geom_Point());
	}
	,hitTestObject: function(obj) {
		if(obj != null && obj.parent != null && this.parent != null) {
			var currentBounds = this.getBounds(this);
			var targetBounds = obj.getBounds(this);
			return currentBounds.intersects(targetBounds);
		}
		return false;
	}
	,hitTestPoint: function(x,y,shapeFlag) {
		if(shapeFlag == null) {
			shapeFlag = false;
		}
		if(this.stage != null) {
			return this.__hitTest(x,y,shapeFlag,null,false,this);
		} else {
			return false;
		}
	}
	,invalidate: function() {
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
	}
	,localToGlobal: function(point) {
		return this.__getRenderTransform().transformPoint(point);
	}
	,removeEventListener: function(type,listener,useCapture) {
		if(useCapture == null) {
			useCapture = false;
		}
		openfl_events_EventDispatcher.prototype.removeEventListener.call(this,type,listener,useCapture);
		switch(type) {
		case "activate":case "deactivate":case "enterFrame":case "exitFrame":case "frameConstructed":case "render":
			if(!this.hasEventListener(type)) {
				var _this = openfl_display_DisplayObject.__broadcastEvents;
				if(__map_reserved[type] != null ? _this.existsReserved(type) : _this.h.hasOwnProperty(type)) {
					var _this1 = openfl_display_DisplayObject.__broadcastEvents;
					HxOverrides.remove(__map_reserved[type] != null ? _this1.getReserved(type) : _this1.h[type],this);
				}
			}
			break;
		case "clearDOM":case "renderCairo":case "renderCanvas":case "renderDOM":case "renderOpenGL":
			if(!this.hasEventListener("clearDOM") && !this.hasEventListener("renderCairo") && !this.hasEventListener("renderCanvas") && !this.hasEventListener("renderDOM") && !this.hasEventListener("renderOpenGL")) {
				this.__customRenderEvent = null;
			}
			break;
		default:
		}
	}
	,__cleanup: function() {
		this.__cairo = null;
		this.__canvas = null;
		this.__context = null;
		if(this.__graphics != null) {
			this.__graphics.__cleanup();
		}
		if(this.__cacheBitmap != null) {
			this.__cacheBitmap.__cleanup();
			this.__cacheBitmap = null;
		}
		if(this.__cacheBitmapData != null) {
			this.__cacheBitmapData.dispose();
			this.__cacheBitmapData = null;
		}
	}
	,__dispatch: function(event) {
		if(this.__eventMap != null && this.hasEventListener(event.type)) {
			var result = openfl_events_EventDispatcher.prototype.__dispatchEvent.call(this,event);
			if(event.__isCanceled) {
				return true;
			}
			return result;
		}
		return true;
	}
	,__dispatchChildren: function(event) {
	}
	,__dispatchEvent: function(event) {
		var parent = event.bubbles ? this.parent : null;
		var result = openfl_events_EventDispatcher.prototype.__dispatchEvent.call(this,event);
		if(event.__isCanceled) {
			return true;
		}
		if(parent != null && parent != this) {
			event.eventPhase = 3;
			if(event.target == null) {
				event.target = this;
			}
			parent.__dispatchEvent(event);
		}
		return result;
	}
	,__dispatchWithCapture: function(event) {
		if(event.target == null) {
			event.target = this;
		}
		if(this.parent != null) {
			event.eventPhase = 1;
			if(this.parent == this.stage) {
				this.parent.__dispatch(event);
			} else {
				var stack = openfl_display_DisplayObject.__tempStack.get();
				var parent = this.parent;
				var i = 0;
				while(parent != null) {
					stack.set(i,parent);
					parent = parent.parent;
					++i;
				}
				var _g = 0;
				var _g1 = i;
				while(_g < _g1) {
					var j = _g++;
					stack.get(i - j - 1).__dispatch(event);
				}
				openfl_display_DisplayObject.__tempStack.release(stack);
			}
		}
		event.eventPhase = 2;
		return this.__dispatchEvent(event);
	}
	,__enterFrame: function(deltaTime) {
	}
	,__getBounds: function(rect,matrix) {
		if(this.__graphics != null) {
			this.__graphics.__getBounds(rect,matrix);
		}
	}
	,__getCursor: function() {
		return null;
	}
	,__getFilterBounds: function(rect,matrix) {
		this.__getRenderBounds(rect,matrix);
		if(this.__filters != null) {
			var extension = openfl_geom_Rectangle.__pool.get();
			var _g = 0;
			var _g1 = this.__filters;
			while(_g < _g1.length) {
				var filter = _g1[_g];
				++_g;
				extension.__expand(-filter.__leftExtension,-filter.__topExtension,filter.__leftExtension + filter.__rightExtension,filter.__topExtension + filter.__bottomExtension);
			}
			rect.width += extension.width;
			rect.height += extension.height;
			rect.x += extension.x;
			rect.y += extension.y;
			openfl_geom_Rectangle.__pool.release(extension);
		}
	}
	,__getInteractive: function(stack) {
		return false;
	}
	,__getLocalBounds: function(rect) {
		this.__getBounds(rect,this.__transform);
		rect.x -= this.__transform.tx;
		rect.y -= this.__transform.ty;
	}
	,__getRenderBounds: function(rect,matrix) {
		if(this.__scrollRect == null) {
			this.__getBounds(rect,matrix);
		} else {
			var r = openfl_geom_Rectangle.__pool.get();
			r.copyFrom(this.__scrollRect);
			r.__transform(r,matrix);
			rect.__expand(r.x,r.y,r.width,r.height);
			openfl_geom_Rectangle.__pool.release(r);
		}
	}
	,__getRenderTransform: function() {
		this.__getWorldTransform();
		return this.__renderTransform;
	}
	,__getWorldTransform: function() {
		var transformDirty = this.__transformDirty || this.__worldTransformInvalid;
		if(transformDirty) {
			var list = [];
			var current = this;
			if(this.parent == null) {
				this.__update(true,false);
			} else {
				while(current != this.stage) {
					list.push(current);
					current = current.parent;
					if(current == null) {
						break;
					}
				}
			}
			var i = list.length;
			while(--i >= 0) {
				current = list[i];
				current.__update(true,false);
			}
		}
		return this.__worldTransform;
	}
	,__globalToLocal: function(global,local) {
		this.__getRenderTransform();
		if(global == local) {
			var _this = this.__renderTransform;
			var norm = _this.a * _this.d - _this.b * _this.c;
			if(norm == 0) {
				global.x = -_this.tx;
				global.y = -_this.ty;
			} else {
				var px = 1.0 / norm * (_this.c * (_this.ty - global.y) + _this.d * (global.x - _this.tx));
				global.y = 1.0 / norm * (_this.a * (global.y - _this.ty) + _this.b * (_this.tx - global.x));
				global.x = px;
			}
		} else {
			var _this1 = this.__renderTransform;
			var norm1 = _this1.a * _this1.d - _this1.b * _this1.c;
			local.x = norm1 == 0 ? -_this1.tx : 1.0 / norm1 * (_this1.c * (_this1.ty - global.y) + _this1.d * (global.x - _this1.tx));
			var _this2 = this.__renderTransform;
			var norm2 = _this2.a * _this2.d - _this2.b * _this2.c;
			local.y = norm2 == 0 ? -_this2.ty : 1.0 / norm2 * (_this2.a * (global.y - _this2.ty) + _this2.b * (_this2.tx - global.x));
		}
		return local;
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(this.__graphics != null) {
			if(!hitObject.__visible || this.__isMask) {
				return false;
			}
			if(this.get_mask() != null && !this.get_mask().__hitTestMask(x,y)) {
				return false;
			}
			if(this.__graphics.__hitTest(x,y,shapeFlag,this.__getRenderTransform())) {
				if(stack != null && !interactiveOnly) {
					stack.push(hitObject);
				}
				return true;
			}
		}
		return false;
	}
	,__hitTestMask: function(x,y) {
		if(this.__graphics != null) {
			if(this.__graphics.__hitTest(x,y,true,this.__getRenderTransform())) {
				return true;
			}
		}
		return false;
	}
	,__readGraphicsData: function(graphicsData,recurse) {
		if(this.__graphics != null) {
			this.__graphics.__readGraphicsData(graphicsData);
		}
	}
	,__renderCairo: function(renderer) {
	}
	,__renderCairoMask: function(renderer) {
	}
	,__renderCanvas: function(renderer) {
		if(this.get_mask() == null || this.get_mask().get_width() > 0 && this.get_mask().get_height() > 0) {
			this.__updateCacheBitmap(renderer,false);
			if(this.__cacheBitmap != null && !this.__isCacheBitmapRender) {
				var bitmap = this.__cacheBitmap;
				if(!(!bitmap.__renderable)) {
					var alpha = renderer.__getAlpha(bitmap.__worldAlpha);
					if(alpha > 0 && bitmap.__bitmapData != null && bitmap.__bitmapData.__isValid && bitmap.__bitmapData.readable) {
						var context = renderer.context;
						renderer.__setBlendMode(bitmap.__worldBlendMode);
						renderer.__pushMaskObject(bitmap,false);
						lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(bitmap.__bitmapData.image);
						context.globalAlpha = alpha;
						var scrollRect = bitmap.__scrollRect;
						renderer.setTransform(bitmap.__renderTransform,context);
						if(!renderer.__allowSmoothing || !bitmap.smoothing) {
							context.imageSmoothingEnabled = false;
						}
						if(scrollRect == null) {
							context.drawImage(bitmap.__bitmapData.image.get_src(),0,0,bitmap.__bitmapData.image.width,bitmap.__bitmapData.image.height);
						} else {
							context.drawImage(bitmap.__bitmapData.image.get_src(),scrollRect.x,scrollRect.y,scrollRect.width,scrollRect.height);
						}
						if(!renderer.__allowSmoothing || !bitmap.smoothing) {
							context.imageSmoothingEnabled = true;
						}
						renderer.__popMaskObject(bitmap,false);
					}
				}
			} else if(!(this.opaqueBackground == null && this.__graphics == null)) {
				if(!(!this.__renderable)) {
					var alpha1 = renderer.__getAlpha(this.__worldAlpha);
					if(!(alpha1 <= 0)) {
						if(this.opaqueBackground != null && !this.__isCacheBitmapRender && this.get_width() > 0 && this.get_height() > 0) {
							renderer.__setBlendMode(this.__worldBlendMode);
							renderer.__pushMaskObject(this);
							var context1 = renderer.context;
							renderer.setTransform(this.__renderTransform,context1);
							var color = this.opaqueBackground;
							context1.fillStyle = "rgb(" + (color >>> 16 & 255) + "," + (color >>> 8 & 255) + "," + (color & 255) + ")";
							context1.fillRect(0,0,this.get_width(),this.get_height());
							renderer.__popMaskObject(this);
						}
						if(this.__graphics != null) {
							if(!(!this.__renderable)) {
								var alpha2 = renderer.__getAlpha(this.__worldAlpha);
								if(!(alpha2 <= 0)) {
									var graphics = this.__graphics;
									if(graphics != null) {
										openfl__$internal_renderer_canvas_CanvasGraphics.render(graphics,renderer);
										var width = graphics.__width;
										var height = graphics.__height;
										var canvas = graphics.__canvas;
										if(canvas != null && graphics.__visible && width >= 1 && height >= 1) {
											var transform = graphics.__worldTransform;
											var context2 = renderer.context;
											var scrollRect1 = this.__scrollRect;
											var scale9Grid = this.__worldScale9Grid;
											if(scrollRect1 == null || scrollRect1.width > 0 && scrollRect1.height > 0) {
												renderer.__setBlendMode(this.__worldBlendMode);
												renderer.__pushMaskObject(this);
												context2.globalAlpha = alpha2;
												if(scale9Grid != null && transform.b == 0 && transform.c == 0) {
													context2.setTransform(1,0,0,1,transform.tx,transform.ty);
													var bounds = graphics.__bounds;
													var scaleX = graphics.__renderTransform.a;
													var scaleY = graphics.__renderTransform.d;
													var renderScaleX = transform.a;
													var renderScaleY = transform.d;
													var left = Math.max(1,Math.round(scale9Grid.x * scaleX));
													var top = Math.round(scale9Grid.y * scaleY);
													var right = Math.max(1,Math.round((bounds.get_right() - scale9Grid.get_right()) * scaleX));
													var bottom = Math.round((bounds.get_bottom() - scale9Grid.get_bottom()) * scaleY);
													var centerWidth = Math.round(scale9Grid.width * scaleX);
													var centerHeight = Math.round(scale9Grid.height * scaleY);
													var renderLeft = Math.round(scale9Grid.x * renderScaleX);
													var renderTop = Math.round(scale9Grid.y * renderScaleY);
													var renderRight = Math.round((bounds.get_right() - scale9Grid.get_right()) * renderScaleX);
													var renderBottom = Math.round((bounds.get_bottom() - scale9Grid.get_bottom()) * renderScaleY);
													var renderCenterWidth = Math.round(width * renderScaleX) - renderLeft - renderRight;
													var renderCenterHeight = Math.round(height * renderScaleY) - renderTop - renderBottom;
													renderer.applySmoothing(context2,false);
													if(centerWidth != 0 && centerHeight != 0) {
														context2.drawImage(canvas,0,0,left,top,0,0,renderLeft,renderTop);
														context2.drawImage(canvas,left,0,centerWidth,top,renderLeft,0,renderCenterWidth,renderTop);
														context2.drawImage(canvas,left + centerWidth,0,right,top,renderLeft + renderCenterWidth,0,renderRight,renderTop);
														context2.drawImage(canvas,0,top,left,centerHeight,0,renderTop,renderLeft,renderCenterHeight);
														context2.drawImage(canvas,left,top,centerWidth,centerHeight,renderLeft,renderTop,renderCenterWidth,renderCenterHeight);
														context2.drawImage(canvas,left + centerWidth,top,right,centerHeight,renderLeft + renderCenterWidth,renderTop,renderRight,renderCenterHeight);
														context2.drawImage(canvas,0,top + centerHeight,left,bottom,0,renderTop + renderCenterHeight,renderLeft,renderBottom);
														context2.drawImage(canvas,left,top + centerHeight,centerWidth,bottom,renderLeft,renderTop + renderCenterHeight,renderCenterWidth,renderBottom);
														context2.drawImage(canvas,left + centerWidth,top + centerHeight,right,bottom,renderLeft + renderCenterWidth,renderTop + renderCenterHeight,renderRight,renderBottom);
													} else if(centerWidth == 0 && centerHeight != 0) {
														var renderWidth = renderLeft + renderCenterWidth + renderRight;
														context2.drawImage(canvas,0,0,width,top,0,0,renderWidth,renderTop);
														context2.drawImage(canvas,0,top,width,centerHeight,0,renderTop,renderWidth,renderCenterHeight);
														context2.drawImage(canvas,0,top + centerHeight,width,bottom,0,renderTop + renderCenterHeight,renderWidth,renderBottom);
													} else if(centerHeight == 0 && centerWidth != 0) {
														var renderHeight = renderTop + renderCenterHeight + renderBottom;
														context2.drawImage(canvas,0,0,left,height,0,0,renderLeft,renderHeight);
														context2.drawImage(canvas,left,0,centerWidth,height,renderLeft,0,renderCenterWidth,renderHeight);
														context2.drawImage(canvas,left + centerWidth,0,right,height,renderLeft + renderCenterWidth,0,renderRight,renderHeight);
													}
												} else {
													renderer.setTransform(transform,context2);
													if(renderer.__isDOM) {
														var reverseScale = 1 / renderer.pixelRatio;
														context2.scale(reverseScale,reverseScale);
													}
													context2.drawImage(canvas,0,0,width,height);
												}
												renderer.__popMaskObject(this);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		this.__renderEvent(renderer);
	}
	,__renderCanvasMask: function(renderer) {
		if(this.__graphics != null) {
			openfl__$internal_renderer_canvas_CanvasGraphics.renderMask(this.__graphics,renderer);
		}
	}
	,__renderDOM: function(renderer) {
		this.__updateCacheBitmap(renderer,false);
		if(this.__cacheBitmap != null && !this.__isCacheBitmapRender) {
			this.__renderDOMClear(renderer);
			this.__cacheBitmap.stage = this.stage;
			var bitmap = this.__cacheBitmap;
			if(bitmap.stage != null && bitmap.__worldVisible && bitmap.__renderable && bitmap.__bitmapData != null && bitmap.__bitmapData.__isValid && bitmap.__bitmapData.readable) {
				renderer.__pushMaskObject(bitmap);
				if(bitmap.__bitmapData.image.buffer.__srcImage != null) {
					openfl__$internal_renderer_dom_DOMBitmap.renderImage(bitmap,renderer);
				} else {
					openfl__$internal_renderer_dom_DOMBitmap.renderCanvas(bitmap,renderer);
				}
				renderer.__popMaskObject(bitmap);
			} else {
				openfl__$internal_renderer_dom_DOMBitmap.clear(bitmap,renderer);
			}
		} else {
			var tmp = this.opaqueBackground != null && !this.__isCacheBitmapRender && this.get_width() > 0 && this.get_height() > 0;
			var graphics = this.__graphics;
			if(this.stage != null && this.__worldVisible && this.__renderable && graphics != null) {
				openfl__$internal_renderer_canvas_CanvasGraphics.render(graphics,renderer.__canvasRenderer);
				if(graphics.__softwareDirty || this.__worldAlphaChanged || this.__canvas != graphics.__canvas) {
					if(graphics.__canvas != null) {
						if(this.__canvas != graphics.__canvas) {
							if(this.__canvas != null) {
								renderer.element.removeChild(this.__canvas);
							}
							this.__canvas = graphics.__canvas;
							this.__context = graphics.__context;
							renderer.__initializeElement(this,this.__canvas);
						}
					} else {
						openfl__$internal_renderer_dom_DOMShape.clear(this,renderer);
					}
				}
				if(this.__canvas != null) {
					renderer.__pushMaskObject(this);
					var cacheTransform = this.__renderTransform;
					this.__renderTransform = graphics.__worldTransform;
					if(graphics.__transformDirty) {
						graphics.__transformDirty = false;
						this.__renderTransformChanged = true;
					}
					renderer.__updateClip(this);
					renderer.__applyStyle(this,true,true,true);
					this.__renderTransform = cacheTransform;
					renderer.__popMaskObject(this);
				}
			} else {
				openfl__$internal_renderer_dom_DOMShape.clear(this,renderer);
			}
		}
		this.__renderEvent(renderer);
	}
	,__renderDOMClear: function(renderer) {
		openfl__$internal_renderer_dom_DOMDisplayObject.clear(this,renderer);
	}
	,__renderEvent: function(renderer) {
		if(this.__customRenderEvent != null && this.__renderable) {
			this.__customRenderEvent.allowSmoothing = renderer.__allowSmoothing;
			this.__customRenderEvent.objectMatrix.copyFrom(this.__renderTransform);
			this.__customRenderEvent.objectColorTransform.__copyFrom(this.__worldColorTransform);
			this.__customRenderEvent.renderer = renderer;
			switch(renderer.__type) {
			case "cairo":
				this.__customRenderEvent.type = "renderCairo";
				break;
			case "canvas":
				this.__customRenderEvent.type = "renderCanvas";
				break;
			case "dom":
				if(this.stage != null && this.__worldVisible) {
					this.__customRenderEvent.type = "renderDOM";
				} else {
					this.__customRenderEvent.type = "clearDOM";
				}
				break;
			case "opengl":
				if(!renderer.__cleared) {
					renderer.__clear();
				}
				var renderer1 = renderer;
				renderer1.setShader(this.__worldShader);
				renderer1.__context3D.__flushGL();
				this.__customRenderEvent.type = "renderOpenGL";
				break;
			default:
				return;
			}
			renderer.__setBlendMode(this.__worldBlendMode);
			renderer.__pushMaskObject(this);
			this.dispatchEvent(this.__customRenderEvent);
			renderer.__popMaskObject(this);
			if(renderer.__type == "opengl") {
				var renderer2 = renderer;
				renderer2.setViewport();
			}
		}
	}
	,__renderGL: function(renderer) {
		this.__updateCacheBitmap(renderer,false);
		if(this.__cacheBitmap != null && !this.__isCacheBitmapRender) {
			openfl__$internal_renderer_context3D_Context3DBitmap.render(this.__cacheBitmap,renderer);
		} else if(!(this.opaqueBackground == null && this.__graphics == null)) {
			if(!(!this.__renderable || this.__worldAlpha <= 0)) {
				if(this.opaqueBackground != null && !this.__isCacheBitmapRender && this.get_width() > 0 && this.get_height() > 0) {
					renderer.__setBlendMode(this.__worldBlendMode);
					renderer.__pushMaskObject(this);
					var context = renderer.__context3D;
					var rect = openfl_geom_Rectangle.__pool.get();
					rect.setTo(0,0,this.get_width(),this.get_height());
					renderer.__pushMaskRect(rect,this.__renderTransform);
					var color = this.opaqueBackground;
					context.clear((color >>> 16 & 255) / 255,(color >>> 8 & 255) / 255,(color & 255) / 255,1,0,0,1);
					renderer.__popMaskRect();
					renderer.__popMaskObject(this);
					openfl_geom_Rectangle.__pool.release(rect);
				}
				if(this.__graphics != null) {
					openfl__$internal_renderer_context3D_Context3DShape.render(this,renderer);
				}
			}
		}
		this.__renderEvent(renderer);
	}
	,__renderGLMask: function(renderer) {
		if(this.__graphics != null) {
			openfl__$internal_renderer_context3D_Context3DShape.renderMask(this,renderer);
		}
	}
	,__setParentRenderDirty: function() {
		var renderParent = this.__renderParent != null ? this.__renderParent : this.parent;
		if(renderParent != null && !renderParent.__renderDirty) {
			renderParent.__renderDirty = true;
			renderParent.__setParentRenderDirty();
		}
	}
	,__setRenderDirty: function() {
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
	}
	,__setStageReference: function(stage) {
		this.stage = stage;
	}
	,__setTransformDirty: function() {
		if(!this.__transformDirty) {
			this.__transformDirty = true;
			this.__setWorldTransformInvalid();
			this.__setParentRenderDirty();
		}
	}
	,__setWorldTransformInvalid: function() {
		this.__worldTransformInvalid = true;
	}
	,__shouldCacheHardware: function(value) {
		if(value == true || this.__filters != null) {
			return true;
		}
		if(value == false || this.__graphics != null && !openfl__$internal_renderer_context3D_Context3DGraphics.isCompatible(this.__graphics)) {
			return false;
		}
		return null;
	}
	,__stopAllMovieClips: function() {
	}
	,__update: function(transformOnly,updateChildren) {
		var renderParent = this.__renderParent != null ? this.__renderParent : this.parent;
		if(this.__isMask && renderParent == null) {
			renderParent = this.__maskTarget;
		}
		this.__renderable = this.__visible && this.__scaleX != 0 && this.__scaleY != 0 && !this.__isMask && (renderParent == null || !renderParent.__isMask);
		this.__updateTransforms();
		this.__transformDirty = false;
		this.__worldTransformInvalid = false;
		if(!transformOnly) {
			if(openfl_display_DisplayObject.__supportDOM) {
				this.__renderTransformChanged = !this.__renderTransform.equals(this.__renderTransformCache);
				if(this.__renderTransformCache == null) {
					this.__renderTransformCache = this.__renderTransform.clone();
				} else {
					this.__renderTransformCache.copyFrom(this.__renderTransform);
				}
			}
			if(renderParent != null) {
				if(openfl_display_DisplayObject.__supportDOM) {
					var worldVisible = renderParent.__worldVisible && this.__visible;
					this.__worldVisibleChanged = this.__worldVisible != worldVisible;
					this.__worldVisible = worldVisible;
					var worldAlpha = this.get_alpha() * renderParent.__worldAlpha;
					this.__worldAlphaChanged = this.__worldAlpha != worldAlpha;
					this.__worldAlpha = worldAlpha;
				} else {
					this.__worldAlpha = this.get_alpha() * renderParent.__worldAlpha;
				}
				if(this.__objectTransform != null) {
					this.__worldColorTransform.__copyFrom(this.__objectTransform.get_colorTransform());
					this.__worldColorTransform.__combine(renderParent.__worldColorTransform);
				} else {
					this.__worldColorTransform.__copyFrom(renderParent.__worldColorTransform);
				}
				if(this.__blendMode == null || this.__blendMode == 10) {
					this.__worldBlendMode = renderParent.__worldBlendMode;
				} else {
					this.__worldBlendMode = this.__blendMode;
				}
				if(this.__shader == null) {
					this.__worldShader = renderParent.__shader;
				} else {
					this.__worldShader = this.__shader;
				}
				if(this.__scale9Grid == null) {
					this.__worldScale9Grid = renderParent.__scale9Grid;
				} else {
					this.__worldScale9Grid = this.__scale9Grid;
				}
			} else {
				this.__worldAlpha = this.get_alpha();
				if(openfl_display_DisplayObject.__supportDOM) {
					this.__worldVisibleChanged = this.__worldVisible != this.__visible;
					this.__worldVisible = this.__visible;
					this.__worldAlphaChanged = this.__worldAlpha != this.get_alpha();
				}
				if(this.__objectTransform != null) {
					this.__worldColorTransform.__copyFrom(this.__objectTransform.get_colorTransform());
				} else {
					this.__worldColorTransform.__identity();
				}
				this.__worldBlendMode = this.__blendMode;
				this.__worldShader = this.__shader;
				this.__worldScale9Grid = this.__scale9Grid;
			}
		}
		if(updateChildren && this.get_mask() != null) {
			this.get_mask().__update(transformOnly,true);
		}
	}
	,__updateCacheBitmap: function(renderer,force) {
		if(this.__isCacheBitmapRender) {
			return false;
		}
		var colorTransform = openfl_geom_ColorTransform.__pool.get();
		colorTransform.__copyFrom(this.__worldColorTransform);
		if(renderer.__worldColorTransform != null) {
			colorTransform.__combine(renderer.__worldColorTransform);
		}
		var updated = false;
		if(this.get_cacheAsBitmap() || renderer.__type != "opengl" && !colorTransform.__isDefault(true)) {
			var rect = null;
			var needRender = this.__cacheBitmap == null || this.__renderDirty && (force || this.__children != null && this.__children.length > 0) || this.opaqueBackground != this.__cacheBitmapBackground;
			var softwareDirty = needRender || this.__graphics != null && this.__graphics.__softwareDirty || !this.__cacheBitmapColorTransform.__equals(colorTransform,true);
			var hardwareDirty = needRender || this.__graphics != null && this.__graphics.__hardwareDirty;
			var renderType = renderer.__type;
			if(softwareDirty || hardwareDirty) {
				if(renderType == "opengl") {
					if(this.__shouldCacheHardware(null) == false) {
						renderType = "canvas";
					}
				}
				if(softwareDirty && (renderType == "canvas" || renderType == "cairo")) {
					needRender = true;
				}
				if(hardwareDirty && renderType == "opengl") {
					needRender = true;
				}
			}
			var updateTransform = needRender || !this.__cacheBitmap.__worldTransform.equals(this.__worldTransform);
			var hasFilters = this.__filters != null;
			if(hasFilters && !needRender) {
				var _g = 0;
				var _g1 = this.__filters;
				while(_g < _g1.length) {
					var filter = _g1[_g];
					++_g;
					if(filter.__renderDirty) {
						needRender = true;
						break;
					}
				}
			}
			if(this.__cacheBitmapMatrix == null) {
				this.__cacheBitmapMatrix = new openfl_geom_Matrix();
			}
			var bitmapMatrix = this.__cacheAsBitmapMatrix != null ? this.__cacheAsBitmapMatrix : this.__renderTransform;
			if(!needRender && (bitmapMatrix.a != this.__cacheBitmapMatrix.a || bitmapMatrix.b != this.__cacheBitmapMatrix.b || bitmapMatrix.c != this.__cacheBitmapMatrix.c || bitmapMatrix.d != this.__cacheBitmapMatrix.d)) {
				needRender = true;
			}
			if(!needRender && renderer.__type != "opengl" && this.__cacheBitmapData != null && this.__cacheBitmapData.image != null && this.__cacheBitmapData.image.version < this.__cacheBitmapData.__textureVersion) {
				needRender = true;
			}
			this.__cacheBitmapMatrix.copyFrom(bitmapMatrix);
			this.__cacheBitmapMatrix.tx = 0;
			this.__cacheBitmapMatrix.ty = 0;
			var bitmapWidth = 0;
			var bitmapHeight = 0;
			var filterWidth = 0;
			var filterHeight = 0;
			var offsetX = 0.;
			var offsetY = 0.;
			if(updateTransform || needRender) {
				rect = openfl_geom_Rectangle.__pool.get();
				this.__getFilterBounds(rect,this.__cacheBitmapMatrix);
				filterWidth = Math.ceil(rect.width);
				filterHeight = Math.ceil(rect.height);
				offsetX = rect.x > 0 ? Math.ceil(rect.x) : Math.floor(rect.x);
				offsetY = rect.y > 0 ? Math.ceil(rect.y) : Math.floor(rect.y);
				if(this.__cacheBitmapData != null) {
					if(filterWidth > this.__cacheBitmapData.width || filterHeight > this.__cacheBitmapData.height) {
						bitmapWidth = Math.ceil(Math.max(filterWidth * 1.25,this.__cacheBitmapData.width));
						bitmapHeight = Math.ceil(Math.max(filterHeight * 1.25,this.__cacheBitmapData.height));
						needRender = true;
					} else {
						bitmapWidth = this.__cacheBitmapData.width;
						bitmapHeight = this.__cacheBitmapData.height;
					}
				} else {
					bitmapWidth = filterWidth;
					bitmapHeight = filterHeight;
				}
			}
			if(needRender) {
				updateTransform = true;
				this.__cacheBitmapBackground = this.opaqueBackground;
				if(filterWidth >= 0.5 && filterHeight >= 0.5) {
					var needsFill = this.opaqueBackground != null && (bitmapWidth != filterWidth || bitmapHeight != filterHeight);
					var fillColor = this.opaqueBackground != null ? -16777216 | this.opaqueBackground : 0;
					var bitmapColor = needsFill ? 0 : fillColor;
					var allowFramebuffer = renderer.__type == "opengl";
					if(this.__cacheBitmapData == null || bitmapWidth > this.__cacheBitmapData.width || bitmapHeight > this.__cacheBitmapData.height) {
						this.__cacheBitmapData = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,bitmapColor);
						if(this.__cacheBitmap == null) {
							this.__cacheBitmap = new openfl_display_Bitmap();
						}
						this.__cacheBitmap.__bitmapData = this.__cacheBitmapData;
						this.__cacheBitmapRenderer = null;
					} else {
						this.__cacheBitmapData.__fillRect(this.__cacheBitmapData.rect,bitmapColor,allowFramebuffer);
					}
					if(needsFill) {
						rect.setTo(0,0,filterWidth,filterHeight);
						this.__cacheBitmapData.__fillRect(rect,fillColor,allowFramebuffer);
					}
				} else {
					openfl_geom_ColorTransform.__pool.release(colorTransform);
					this.__cacheBitmap = null;
					this.__cacheBitmapData = null;
					this.__cacheBitmapData2 = null;
					this.__cacheBitmapData3 = null;
					this.__cacheBitmapRenderer = null;
					return true;
				}
			} else {
				this.__cacheBitmapData = this.__cacheBitmap.get_bitmapData();
				this.__cacheBitmapData2 = null;
				this.__cacheBitmapData3 = null;
			}
			if(updateTransform || needRender) {
				this.__cacheBitmap.__worldTransform.copyFrom(this.__worldTransform);
				if(bitmapMatrix == this.__renderTransform) {
					this.__cacheBitmap.__renderTransform.identity();
					this.__cacheBitmap.__renderTransform.tx = this.__renderTransform.tx + offsetX;
					this.__cacheBitmap.__renderTransform.ty = this.__renderTransform.ty + offsetY;
				} else {
					this.__cacheBitmap.__renderTransform.copyFrom(this.__cacheBitmapMatrix);
					this.__cacheBitmap.__renderTransform.invert();
					this.__cacheBitmap.__renderTransform.concat(this.__renderTransform);
					this.__cacheBitmap.__renderTransform.tx += offsetX;
					this.__cacheBitmap.__renderTransform.ty += offsetY;
				}
			}
			this.__cacheBitmap.smoothing = renderer.__allowSmoothing;
			this.__cacheBitmap.__renderable = this.__renderable;
			this.__cacheBitmap.__worldAlpha = this.__worldAlpha;
			this.__cacheBitmap.__worldBlendMode = this.__worldBlendMode;
			this.__cacheBitmap.__worldShader = this.__worldShader;
			this.__cacheBitmap.set_mask(this.__mask);
			if(needRender) {
				if(this.__cacheBitmapRenderer == null || renderType != this.__cacheBitmapRenderer.__type) {
					if(renderType == "opengl") {
						this.__cacheBitmapRenderer = new openfl_display_OpenGLRenderer((js_Boot.__cast(renderer , openfl_display_OpenGLRenderer)).__context3D,this.__cacheBitmapData);
					} else {
						if(this.__cacheBitmapData.image == null) {
							var color = this.opaqueBackground != null ? -16777216 | this.opaqueBackground : 0;
							this.__cacheBitmapData = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,color);
							this.__cacheBitmap.__bitmapData = this.__cacheBitmapData;
						}
						lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this.__cacheBitmapData.image);
						this.__cacheBitmapRenderer = new openfl_display_CanvasRenderer(this.__cacheBitmapData.image.buffer.__srcContext);
					}
					this.__cacheBitmapRenderer.__worldTransform = new openfl_geom_Matrix();
					this.__cacheBitmapRenderer.__worldColorTransform = new openfl_geom_ColorTransform();
				}
				if(this.__cacheBitmapColorTransform == null) {
					this.__cacheBitmapColorTransform = new openfl_geom_ColorTransform();
				}
				this.__cacheBitmapRenderer.__stage = this.stage;
				this.__cacheBitmapRenderer.__allowSmoothing = renderer.__allowSmoothing;
				this.__cacheBitmapRenderer.__setBlendMode(10);
				this.__cacheBitmapRenderer.__worldAlpha = 1 / this.__worldAlpha;
				this.__cacheBitmapRenderer.__worldTransform.copyFrom(this.__renderTransform);
				this.__cacheBitmapRenderer.__worldTransform.invert();
				this.__cacheBitmapRenderer.__worldTransform.concat(this.__cacheBitmapMatrix);
				this.__cacheBitmapRenderer.__worldTransform.tx -= offsetX;
				this.__cacheBitmapRenderer.__worldTransform.ty -= offsetY;
				this.__cacheBitmapRenderer.__worldColorTransform.__copyFrom(colorTransform);
				this.__cacheBitmapRenderer.__worldColorTransform.__invert();
				this.__isCacheBitmapRender = true;
				if(this.__cacheBitmapRenderer.__type == "opengl") {
					var parentRenderer = renderer;
					var childRenderer = this.__cacheBitmapRenderer;
					var context = childRenderer.__context3D;
					var cacheRTT = context.__state.renderToTexture;
					var cacheRTTDepthStencil = context.__state.renderToTextureDepthStencil;
					var cacheRTTAntiAlias = context.__state.renderToTextureAntiAlias;
					var cacheRTTSurfaceSelector = context.__state.renderToTextureSurfaceSelector;
					var cacheBlendMode = parentRenderer.__blendMode;
					parentRenderer.__suspendClipAndMask();
					childRenderer.__copyShader(parentRenderer);
					this.__cacheBitmapData.__setUVRect(context,0,0,filterWidth,filterHeight);
					childRenderer.__setRenderTarget(this.__cacheBitmapData);
					if(this.__cacheBitmapData.image != null) {
						this.__cacheBitmapData.__textureVersion = this.__cacheBitmapData.image.version + 1;
					}
					this.__cacheBitmapData.__drawGL(this,childRenderer);
					if(hasFilters) {
						var needSecondBitmapData = true;
						var needCopyOfOriginal = false;
						var _g2 = 0;
						var _g11 = this.__filters;
						while(_g2 < _g11.length) {
							var filter1 = _g11[_g2];
							++_g2;
							if(filter1.__preserveObject) {
								needCopyOfOriginal = true;
							}
						}
						var bitmap = this.__cacheBitmapData;
						var bitmap2 = null;
						var bitmap3 = null;
						if(this.__cacheBitmapData2 == null || bitmapWidth > this.__cacheBitmapData2.width || bitmapHeight > this.__cacheBitmapData2.height) {
							this.__cacheBitmapData2 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
						} else {
							this.__cacheBitmapData2.fillRect(this.__cacheBitmapData2.rect,0);
							if(this.__cacheBitmapData2.image != null) {
								this.__cacheBitmapData2.__textureVersion = this.__cacheBitmapData2.image.version + 1;
							}
						}
						this.__cacheBitmapData2.__setUVRect(context,0,0,filterWidth,filterHeight);
						bitmap2 = this.__cacheBitmapData2;
						if(needCopyOfOriginal) {
							if(this.__cacheBitmapData3 == null || bitmapWidth > this.__cacheBitmapData3.width || bitmapHeight > this.__cacheBitmapData3.height) {
								this.__cacheBitmapData3 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
							} else {
								this.__cacheBitmapData3.fillRect(this.__cacheBitmapData3.rect,0);
								if(this.__cacheBitmapData3.image != null) {
									this.__cacheBitmapData3.__textureVersion = this.__cacheBitmapData3.image.version + 1;
								}
							}
							this.__cacheBitmapData3.__setUVRect(context,0,0,filterWidth,filterHeight);
							bitmap3 = this.__cacheBitmapData3;
						}
						childRenderer.__setBlendMode(10);
						childRenderer.__worldAlpha = 1;
						childRenderer.__worldTransform.identity();
						childRenderer.__worldColorTransform.__identity();
						var shader;
						var cacheBitmap;
						var _g21 = 0;
						var _g3 = this.__filters;
						while(_g21 < _g3.length) {
							var filter2 = _g3[_g21];
							++_g21;
							if(filter2.__preserveObject) {
								childRenderer.__setRenderTarget(bitmap3);
								childRenderer.__renderFilterPass(bitmap,childRenderer.__defaultDisplayShader,filter2.__smooth);
							}
							var _g22 = 0;
							var _g31 = filter2.__numShaderPasses;
							while(_g22 < _g31) {
								var i = _g22++;
								shader = filter2.__initShader(childRenderer,i);
								childRenderer.__setBlendMode(filter2.__shaderBlendMode);
								childRenderer.__setRenderTarget(bitmap2);
								childRenderer.__renderFilterPass(bitmap,shader,filter2.__smooth);
								cacheBitmap = bitmap;
								bitmap = bitmap2;
								bitmap2 = cacheBitmap;
							}
							if(filter2.__preserveObject) {
								childRenderer.__setBlendMode(10);
								childRenderer.__setRenderTarget(bitmap);
								childRenderer.__renderFilterPass(bitmap3,childRenderer.__defaultDisplayShader,filter2.__smooth,false);
							}
							filter2.__renderDirty = false;
						}
						this.__cacheBitmap.__bitmapData = bitmap;
					}
					parentRenderer.__blendMode = 10;
					parentRenderer.__setBlendMode(cacheBlendMode);
					parentRenderer.__copyShader(childRenderer);
					if(cacheRTT != null) {
						context.setRenderToTexture(cacheRTT,cacheRTTDepthStencil,cacheRTTAntiAlias,cacheRTTSurfaceSelector);
					} else {
						context.setRenderToBackBuffer();
					}
					parentRenderer.__resumeClipAndMask(childRenderer);
					parentRenderer.setViewport();
					this.__cacheBitmapColorTransform.__copyFrom(colorTransform);
				} else {
					this.__cacheBitmapData.__drawCanvas(this,this.__cacheBitmapRenderer);
					if(hasFilters) {
						var needSecondBitmapData1 = false;
						var needCopyOfOriginal1 = false;
						var _g4 = 0;
						var _g12 = this.__filters;
						while(_g4 < _g12.length) {
							var filter3 = _g12[_g4];
							++_g4;
							if(filter3.__needSecondBitmapData) {
								needSecondBitmapData1 = true;
							}
							if(filter3.__preserveObject) {
								needCopyOfOriginal1 = true;
							}
						}
						var bitmap1 = this.__cacheBitmapData;
						var bitmap21 = null;
						var bitmap31 = null;
						if(needSecondBitmapData1) {
							if(this.__cacheBitmapData2 == null || this.__cacheBitmapData2.image == null || bitmapWidth > this.__cacheBitmapData2.width || bitmapHeight > this.__cacheBitmapData2.height) {
								this.__cacheBitmapData2 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
							} else {
								this.__cacheBitmapData2.fillRect(this.__cacheBitmapData2.rect,0);
							}
							bitmap21 = this.__cacheBitmapData2;
						} else {
							bitmap21 = bitmap1;
						}
						if(needCopyOfOriginal1) {
							if(this.__cacheBitmapData3 == null || this.__cacheBitmapData3.image == null || bitmapWidth > this.__cacheBitmapData3.width || bitmapHeight > this.__cacheBitmapData3.height) {
								this.__cacheBitmapData3 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
							} else {
								this.__cacheBitmapData3.fillRect(this.__cacheBitmapData3.rect,0);
							}
							bitmap31 = this.__cacheBitmapData3;
						}
						if(this.__tempPoint == null) {
							this.__tempPoint = new openfl_geom_Point();
						}
						var destPoint = this.__tempPoint;
						var cacheBitmap1;
						var lastBitmap;
						var _g23 = 0;
						var _g32 = this.__filters;
						while(_g23 < _g32.length) {
							var filter4 = _g32[_g23];
							++_g23;
							if(filter4.__preserveObject) {
								bitmap31.copyPixels(bitmap1,bitmap1.rect,destPoint);
							}
							lastBitmap = filter4.__applyFilter(bitmap21,bitmap1,bitmap1.rect,destPoint);
							if(filter4.__preserveObject) {
								lastBitmap.draw(bitmap31,null,this.__objectTransform != null ? this.__objectTransform.get_colorTransform() : null);
							}
							filter4.__renderDirty = false;
							if(needSecondBitmapData1 && lastBitmap == bitmap21) {
								cacheBitmap1 = bitmap1;
								bitmap1 = bitmap21;
								bitmap21 = cacheBitmap1;
							}
						}
						if(this.__cacheBitmapData != bitmap1) {
							cacheBitmap1 = this.__cacheBitmapData;
							this.__cacheBitmapData = bitmap1;
							this.__cacheBitmapData2 = cacheBitmap1;
							this.__cacheBitmap.__bitmapData = this.__cacheBitmapData;
							this.__cacheBitmapRenderer = null;
						}
						this.__cacheBitmap.__imageVersion = this.__cacheBitmapData.__textureVersion;
					}
					this.__cacheBitmapColorTransform.__copyFrom(colorTransform);
					if(!this.__cacheBitmapColorTransform.__isDefault(true)) {
						this.__cacheBitmapColorTransform.alphaMultiplier = 1;
						this.__cacheBitmapData.colorTransform(this.__cacheBitmapData.rect,this.__cacheBitmapColorTransform);
					}
				}
				this.__isCacheBitmapRender = false;
			}
			if(updateTransform || needRender) {
				openfl_geom_Rectangle.__pool.release(rect);
			}
			updated = updateTransform;
		} else if(this.__cacheBitmap != null) {
			if(renderer.__type == "dom") {
				this.__cacheBitmap.__renderDOMClear(renderer);
			}
			this.__cacheBitmap = null;
			this.__cacheBitmapData = null;
			this.__cacheBitmapData2 = null;
			this.__cacheBitmapData3 = null;
			this.__cacheBitmapColorTransform = null;
			this.__cacheBitmapRenderer = null;
			updated = true;
		}
		openfl_geom_ColorTransform.__pool.release(colorTransform);
		return updated;
	}
	,__updateTransforms: function(overrideTransform) {
		var overrided = overrideTransform != null;
		var local = overrided ? overrideTransform : this.__transform;
		if(this.__worldTransform == null) {
			this.__worldTransform = new openfl_geom_Matrix();
		}
		if(this.__renderTransform == null) {
			this.__renderTransform = new openfl_geom_Matrix();
		}
		var renderParent = this.__renderParent != null ? this.__renderParent : this.parent;
		if(!overrided && this.parent != null) {
			var parentTransform = this.parent.__worldTransform;
			var target = this.__worldTransform;
			target.a = local.a * parentTransform.a + local.b * parentTransform.c;
			target.b = local.a * parentTransform.b + local.b * parentTransform.d;
			target.c = local.c * parentTransform.a + local.d * parentTransform.c;
			target.d = local.c * parentTransform.b + local.d * parentTransform.d;
			target.tx = local.tx * parentTransform.a + local.ty * parentTransform.c + parentTransform.tx;
			target.ty = local.tx * parentTransform.b + local.ty * parentTransform.d + parentTransform.ty;
		} else {
			this.__worldTransform.copyFrom(local);
		}
		if(!overrided && renderParent != null) {
			var parentTransform1 = renderParent.__renderTransform;
			var target1 = this.__renderTransform;
			target1.a = local.a * parentTransform1.a + local.b * parentTransform1.c;
			target1.b = local.a * parentTransform1.b + local.b * parentTransform1.d;
			target1.c = local.c * parentTransform1.a + local.d * parentTransform1.c;
			target1.d = local.c * parentTransform1.b + local.d * parentTransform1.d;
			target1.tx = local.tx * parentTransform1.a + local.ty * parentTransform1.c + parentTransform1.tx;
			target1.ty = local.tx * parentTransform1.b + local.ty * parentTransform1.d + parentTransform1.ty;
		} else {
			this.__renderTransform.copyFrom(local);
		}
		if(this.__scrollRect != null) {
			var _this = this.__renderTransform;
			var px = -this.__scrollRect.x;
			var py = -this.__scrollRect.y;
			_this.tx = px * _this.a + py * _this.c + _this.tx;
			_this.ty = px * _this.b + py * _this.d + _this.ty;
		}
	}
	,get_alpha: function() {
		return this.__alpha;
	}
	,set_alpha: function(value) {
		if(value > 1.0) {
			value = 1.0;
		}
		if(value < 0.0) {
			value = 0.0;
		}
		if(value != this.__alpha && !this.get_cacheAsBitmap()) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__alpha = value;
	}
	,get_blendMode: function() {
		return this.__blendMode;
	}
	,set_blendMode: function(value) {
		if(value == null) {
			value = 10;
		}
		if(value != this.__blendMode) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__blendMode = value;
	}
	,get_cacheAsBitmap: function() {
		if(this.__filters == null) {
			return this.__cacheAsBitmap;
		} else {
			return true;
		}
	}
	,set_cacheAsBitmap: function(value) {
		if(value != this.__cacheAsBitmap) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__cacheAsBitmap = value;
	}
	,get_cacheAsBitmapMatrix: function() {
		return this.__cacheAsBitmapMatrix;
	}
	,set_cacheAsBitmapMatrix: function(value) {
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
		return this.__cacheAsBitmapMatrix = value != null ? value.clone() : value;
	}
	,get_filters: function() {
		if(this.__filters == null) {
			return [];
		} else {
			return this.__filters.slice();
		}
	}
	,set_filters: function(value) {
		if(value != null && value.length > 0) {
			this.__filters = value;
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		} else if(this.__filters != null) {
			this.__filters = null;
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return value;
	}
	,get_height: function() {
		var rect = openfl_geom_Rectangle.__pool.get();
		this.__getLocalBounds(rect);
		var height = rect.height;
		openfl_geom_Rectangle.__pool.release(rect);
		return height;
	}
	,set_height: function(value) {
		var rect = openfl_geom_Rectangle.__pool.get();
		var matrix = openfl_geom_Matrix.__pool.get();
		matrix.identity();
		this.__getBounds(rect,matrix);
		if(value != rect.height) {
			this.set_scaleY(value / rect.height);
		} else {
			this.set_scaleY(1);
		}
		openfl_geom_Rectangle.__pool.release(rect);
		openfl_geom_Matrix.__pool.release(matrix);
		return value;
	}
	,get_loaderInfo: function() {
		if(this.stage != null) {
			return openfl__$internal_Lib.current.__loaderInfo;
		}
		return null;
	}
	,get_mask: function() {
		return this.__mask;
	}
	,set_mask: function(value) {
		if(value == this.__mask) {
			return value;
		}
		if(value != this.__mask) {
			this.__setTransformDirty();
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		if(this.__mask != null) {
			this.__mask.__isMask = false;
			this.__mask.__maskTarget = null;
			this.__mask.__setTransformDirty();
			var _this = this.__mask;
			if(!_this.__renderDirty) {
				_this.__renderDirty = true;
				_this.__setParentRenderDirty();
			}
		}
		if(value != null) {
			value.__isMask = true;
			value.__maskTarget = this;
			value.__setWorldTransformInvalid();
		}
		if(this.__cacheBitmap != null && this.__cacheBitmap.get_mask() != value) {
			this.__cacheBitmap.set_mask(value);
		}
		return this.__mask = value;
	}
	,get_mouseX: function() {
		var mouseX = this.stage != null ? this.stage.__mouseX : openfl__$internal_Lib.current.stage.__mouseX;
		var mouseY = this.stage != null ? this.stage.__mouseY : openfl__$internal_Lib.current.stage.__mouseY;
		var _this = this.__getRenderTransform();
		var norm = _this.a * _this.d - _this.b * _this.c;
		if(norm == 0) {
			return -_this.tx;
		} else {
			return 1.0 / norm * (_this.c * (_this.ty - mouseY) + _this.d * (mouseX - _this.tx));
		}
	}
	,get_mouseY: function() {
		var mouseX = this.stage != null ? this.stage.__mouseX : openfl__$internal_Lib.current.stage.__mouseX;
		var mouseY = this.stage != null ? this.stage.__mouseY : openfl__$internal_Lib.current.stage.__mouseY;
		var _this = this.__getRenderTransform();
		var norm = _this.a * _this.d - _this.b * _this.c;
		if(norm == 0) {
			return -_this.ty;
		} else {
			return 1.0 / norm * (_this.a * (mouseY - _this.ty) + _this.b * (_this.tx - mouseX));
		}
	}
	,get_name: function() {
		return this.__name;
	}
	,set_name: function(value) {
		return this.__name = value;
	}
	,get_root: function() {
		if(this.stage != null) {
			return openfl__$internal_Lib.current;
		}
		return null;
	}
	,get_rotation: function() {
		return this.__rotation;
	}
	,set_rotation: function(value) {
		if(value != this.__rotation) {
			this.__rotation = value;
			var radians = this.__rotation * (Math.PI / 180);
			this.__rotationSine = Math.sin(radians);
			this.__rotationCosine = Math.cos(radians);
			this.__transform.a = this.__rotationCosine * this.__scaleX;
			this.__transform.b = this.__rotationSine * this.__scaleX;
			this.__transform.c = -this.__rotationSine * this.__scaleY;
			this.__transform.d = this.__rotationCosine * this.__scaleY;
			this.__setTransformDirty();
		}
		return value;
	}
	,get_scale9Grid: function() {
		if(this.__scale9Grid == null) {
			return null;
		}
		return this.__scale9Grid.clone();
	}
	,set_scale9Grid: function(value) {
		if(value == null && this.__scale9Grid == null) {
			return value;
		}
		if(value != null && this.__scale9Grid != null && this.__scale9Grid.equals(value)) {
			return value;
		}
		if(value != null) {
			if(this.__scale9Grid == null) {
				this.__scale9Grid = new openfl_geom_Rectangle();
			}
			this.__scale9Grid.copyFrom(value);
		} else {
			this.__scale9Grid = null;
		}
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
		return value;
	}
	,get_scaleX: function() {
		return this.__scaleX;
	}
	,set_scaleX: function(value) {
		if(value != this.__scaleX) {
			this.__scaleX = value;
			if(this.__transform.b == 0) {
				if(value != this.__transform.a) {
					this.__setTransformDirty();
				}
				this.__transform.a = value;
			} else {
				var a = this.__rotationCosine * value;
				var b = this.__rotationSine * value;
				if(this.__transform.a != a || this.__transform.b != b) {
					this.__setTransformDirty();
				}
				this.__transform.a = a;
				this.__transform.b = b;
			}
		}
		return value;
	}
	,get_scaleY: function() {
		return this.__scaleY;
	}
	,set_scaleY: function(value) {
		if(value != this.__scaleY) {
			this.__scaleY = value;
			if(this.__transform.c == 0) {
				if(value != this.__transform.d) {
					this.__setTransformDirty();
				}
				this.__transform.d = value;
			} else {
				var c = -this.__rotationSine * value;
				var d = this.__rotationCosine * value;
				if(this.__transform.d != d || this.__transform.c != c) {
					this.__setTransformDirty();
				}
				this.__transform.c = c;
				this.__transform.d = d;
			}
		}
		return value;
	}
	,get_scrollRect: function() {
		if(this.__scrollRect == null) {
			return null;
		}
		return this.__scrollRect.clone();
	}
	,set_scrollRect: function(value) {
		if(value == null && this.__scrollRect == null) {
			return value;
		}
		if(value != null && this.__scrollRect != null && this.__scrollRect.equals(value)) {
			return value;
		}
		if(value != null) {
			if(this.__scrollRect == null) {
				this.__scrollRect = new openfl_geom_Rectangle();
			}
			this.__scrollRect.copyFrom(value);
		} else {
			this.__scrollRect = null;
		}
		this.__setTransformDirty();
		if(openfl_display_DisplayObject.__supportDOM) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return value;
	}
	,get_shader: function() {
		return this.__shader;
	}
	,set_shader: function(value) {
		this.__shader = value;
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
		return value;
	}
	,get_transform: function() {
		if(this.__objectTransform == null) {
			this.__objectTransform = new openfl_geom_Transform(this);
		}
		return this.__objectTransform;
	}
	,set_transform: function(value) {
		if(value == null) {
			throw new js__$Boot_HaxeError(new openfl_errors_TypeError("Parameter transform must be non-null."));
		}
		if(this.__objectTransform == null) {
			this.__objectTransform = new openfl_geom_Transform(this);
		}
		this.__setTransformDirty();
		this.__objectTransform.set_matrix(value.get_matrix());
		if(!this.__objectTransform.get_colorTransform().__equals(value.get_colorTransform(),true) || !this.get_cacheAsBitmap() && this.__objectTransform.get_colorTransform().alphaMultiplier != value.get_colorTransform().alphaMultiplier) {
			this.__objectTransform.get_colorTransform().__copyFrom(value.get_colorTransform());
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__objectTransform;
	}
	,get_visible: function() {
		return this.__visible;
	}
	,set_visible: function(value) {
		if(value != this.__visible) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__visible = value;
	}
	,get_width: function() {
		var rect = openfl_geom_Rectangle.__pool.get();
		this.__getLocalBounds(rect);
		var width = rect.width;
		openfl_geom_Rectangle.__pool.release(rect);
		return width;
	}
	,set_width: function(value) {
		var rect = openfl_geom_Rectangle.__pool.get();
		var matrix = openfl_geom_Matrix.__pool.get();
		matrix.identity();
		this.__getBounds(rect,matrix);
		if(value != rect.width) {
			this.set_scaleX(value / rect.width);
		} else {
			this.set_scaleX(1);
		}
		openfl_geom_Rectangle.__pool.release(rect);
		openfl_geom_Matrix.__pool.release(matrix);
		return value;
	}
	,get_x: function() {
		return this.__transform.tx;
	}
	,set_x: function(value) {
		if(value != this.__transform.tx) {
			this.__setTransformDirty();
		}
		return this.__transform.tx = value;
	}
	,get_y: function() {
		return this.__transform.ty;
	}
	,set_y: function(value) {
		if(value != this.__transform.ty) {
			this.__setTransformDirty();
		}
		return this.__transform.ty = value;
	}
	,__class__: openfl_display_DisplayObject
	,__properties__: {set_y:"set_y",get_y:"get_y",set_x:"set_x",get_x:"get_x",set_width:"set_width",get_width:"get_width",set_visible:"set_visible",get_visible:"get_visible",set_transform:"set_transform",get_transform:"get_transform",set_shader:"set_shader",get_shader:"get_shader",set_scrollRect:"set_scrollRect",get_scrollRect:"get_scrollRect",set_scaleY:"set_scaleY",get_scaleY:"get_scaleY",set_scaleX:"set_scaleX",get_scaleX:"get_scaleX",set_scale9Grid:"set_scale9Grid",get_scale9Grid:"get_scale9Grid",set_rotation:"set_rotation",get_rotation:"get_rotation",get_root:"get_root",set_name:"set_name",get_name:"get_name",get_mouseY:"get_mouseY",get_mouseX:"get_mouseX",set_mask:"set_mask",get_mask:"get_mask",get_loaderInfo:"get_loaderInfo",set_height:"set_height",get_height:"get_height",set_filters:"set_filters",get_filters:"get_filters",set_cacheAsBitmapMatrix:"set_cacheAsBitmapMatrix",get_cacheAsBitmapMatrix:"get_cacheAsBitmapMatrix",set_cacheAsBitmap:"set_cacheAsBitmap",get_cacheAsBitmap:"get_cacheAsBitmap",set_blendMode:"set_blendMode",get_blendMode:"get_blendMode",set_alpha:"set_alpha",get_alpha:"get_alpha"}
});
var openfl_display_InteractiveObject = function() {
	openfl_display_DisplayObject.call(this);
	this.doubleClickEnabled = false;
	this.mouseEnabled = true;
	this.needsSoftKeyboard = false;
	this.__tabEnabled = null;
	this.__tabIndex = -1;
};
$hxClasses["openfl.display.InteractiveObject"] = openfl_display_InteractiveObject;
openfl_display_InteractiveObject.__name__ = "openfl.display.InteractiveObject";
openfl_display_InteractiveObject.__super__ = openfl_display_DisplayObject;
openfl_display_InteractiveObject.prototype = $extend(openfl_display_DisplayObject.prototype,{
	doubleClickEnabled: null
	,focusRect: null
	,mouseEnabled: null
	,needsSoftKeyboard: null
	,softKeyboardInputAreaOfInterest: null
	,__tabEnabled: null
	,__tabIndex: null
	,requestSoftKeyboard: function() {
		openfl__$internal_Lib.notImplemented({ fileName : "openfl/display/InteractiveObject.hx", lineNumber : 1251, className : "openfl.display.InteractiveObject", methodName : "requestSoftKeyboard"});
		return false;
	}
	,__allowMouseFocus: function() {
		return this.get_tabEnabled();
	}
	,__getInteractive: function(stack) {
		if(stack != null) {
			stack.push(this);
			if(this.parent != null) {
				this.parent.__getInteractive(stack);
			}
		}
		return true;
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(!hitObject.get_visible() || this.__isMask || interactiveOnly && !this.mouseEnabled) {
			return false;
		}
		return openfl_display_DisplayObject.prototype.__hitTest.call(this,x,y,shapeFlag,stack,interactiveOnly,hitObject);
	}
	,__tabTest: function(stack) {
		if(this.get_tabEnabled()) {
			stack.push(this);
		}
	}
	,get_tabEnabled: function() {
		if(this.__tabEnabled == true) {
			return true;
		} else {
			return false;
		}
	}
	,set_tabEnabled: function(value) {
		if(this.__tabEnabled != value) {
			this.__tabEnabled = value;
			this.dispatchEvent(new openfl_events_Event("tabEnabledChange",true,false));
		}
		return this.__tabEnabled;
	}
	,get_tabIndex: function() {
		return this.__tabIndex;
	}
	,set_tabIndex: function(value) {
		if(this.__tabIndex != value) {
			if(value < -1) {
				throw new js__$Boot_HaxeError(new openfl_errors_RangeError("Parameter tabIndex must be a non-negative number; got " + value));
			}
			this.__tabIndex = value;
			this.dispatchEvent(new openfl_events_Event("tabIndexChange",true,false));
		}
		return this.__tabIndex;
	}
	,__class__: openfl_display_InteractiveObject
	,__properties__: $extend(openfl_display_DisplayObject.prototype.__properties__,{set_tabIndex:"set_tabIndex",get_tabIndex:"get_tabIndex",set_tabEnabled:"set_tabEnabled",get_tabEnabled:"get_tabEnabled"})
});
var openfl_display_DisplayObjectContainer = function() {
	openfl_display_InteractiveObject.call(this);
	this.mouseChildren = true;
	this.__tabChildren = true;
	this.__children = [];
	this.__removedChildren = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
};
$hxClasses["openfl.display.DisplayObjectContainer"] = openfl_display_DisplayObjectContainer;
openfl_display_DisplayObjectContainer.__name__ = "openfl.display.DisplayObjectContainer";
openfl_display_DisplayObjectContainer.__super__ = openfl_display_InteractiveObject;
openfl_display_DisplayObjectContainer.prototype = $extend(openfl_display_InteractiveObject.prototype,{
	mouseChildren: null
	,__removedChildren: null
	,__tabChildren: null
	,addChild: function(child) {
		return this.addChildAt(child,this.get_numChildren());
	}
	,addChildAt: function(child,index) {
		if(child == null) {
			var error = new openfl_errors_TypeError("Error #2007: Parameter child must be non-null.");
			error.errorID = 2007;
			throw new js__$Boot_HaxeError(error);
		} else if(child.stage == child) {
			var error1 = new openfl_errors_ArgumentError("Error #3783: A Stage object cannot be added as the child of another object.");
			error1.errorID = 3783;
			throw new js__$Boot_HaxeError(error1);
		}
		if(index > this.__children.length || index < 0) {
			throw new js__$Boot_HaxeError("Invalid index position " + index);
		}
		if(child.parent == this) {
			if(this.__children[index] != child) {
				HxOverrides.remove(this.__children,child);
				this.__children.splice(index,0,child);
				if(!this.__renderDirty) {
					this.__renderDirty = true;
					this.__setParentRenderDirty();
				}
			}
		} else {
			if(child.parent != null) {
				child.parent.removeChild(child);
			}
			this.__children.splice(index,0,child);
			child.parent = this;
			var addedToStage = this.stage != null && child.stage == null;
			if(addedToStage) {
				this.__setStageReference(this.stage);
			}
			child.__setTransformDirty();
			if(!child.__renderDirty) {
				child.__renderDirty = true;
				child.__setParentRenderDirty();
			}
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
			var event = openfl_events_Event.__pool.get();
			event.type = "added";
			event.bubbles = true;
			event.target = child;
			child.__dispatchWithCapture(event);
			openfl_events_Event.__pool.release(event);
			if(addedToStage) {
				event = new openfl_events_Event("addedToStage",false,false);
				child.__dispatchWithCapture(event);
				child.__dispatchChildren(event);
			}
		}
		return child;
	}
	,areInaccessibleObjectsUnderPoint: function(point) {
		return false;
	}
	,contains: function(child) {
		while(child != this && child != null) child = child.parent;
		return child == this;
	}
	,getChildAt: function(index) {
		if(index >= 0 && index < this.__children.length) {
			return this.__children[index];
		}
		return null;
	}
	,getChildByName: function(name) {
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.get_name() == name) {
				return child;
			}
		}
		return null;
	}
	,getChildIndex: function(child) {
		var _g = 0;
		var _g1 = this.__children.length;
		while(_g < _g1) {
			var i = _g++;
			if(this.__children[i] == child) {
				return i;
			}
		}
		return -1;
	}
	,getObjectsUnderPoint: function(point) {
		var stack = [];
		this.__hitTest(point.x,point.y,false,stack,false,this);
		stack.reverse();
		return stack;
	}
	,removeChild: function(child) {
		if(child != null && child.parent == this) {
			child.__setTransformDirty();
			if(!child.__renderDirty) {
				child.__renderDirty = true;
				child.__setParentRenderDirty();
			}
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
			var event = new openfl_events_Event("removed",true);
			child.__dispatchWithCapture(event);
			if(this.stage != null) {
				if(child.stage != null && this.stage.get_focus() == child) {
					this.stage.set_focus(null);
				}
				var event1 = new openfl_events_Event("removedFromStage",false,false);
				child.__dispatchWithCapture(event1);
				child.__dispatchChildren(event1);
				child.__setStageReference(null);
			}
			child.parent = null;
			HxOverrides.remove(this.__children,child);
			this.__removedChildren.push(child);
			child.__setTransformDirty();
		}
		return child;
	}
	,removeChildAt: function(index) {
		if(index >= 0 && index < this.__children.length) {
			return this.removeChild(this.__children[index]);
		}
		return null;
	}
	,removeChildren: function(beginIndex,endIndex) {
		if(endIndex == null) {
			endIndex = 2147483647;
		}
		if(beginIndex == null) {
			beginIndex = 0;
		}
		if(endIndex == 2147483647) {
			endIndex = this.__children.length - 1;
			if(endIndex < 0) {
				return;
			}
		}
		if(beginIndex > this.__children.length - 1) {
			return;
		} else if(endIndex < beginIndex || beginIndex < 0 || endIndex > this.__children.length) {
			throw new js__$Boot_HaxeError(new openfl_errors_RangeError("The supplied index is out of bounds."));
		}
		var numRemovals = endIndex - beginIndex;
		while(numRemovals >= 0) {
			this.removeChildAt(beginIndex);
			--numRemovals;
		}
	}
	,resolve: function(fieldName) {
		if(this.__children == null) {
			return null;
		}
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.get_name() == fieldName) {
				return child;
			}
		}
		return null;
	}
	,setChildIndex: function(child,index) {
		if(index >= 0 && index <= this.__children.length && child.parent == this) {
			HxOverrides.remove(this.__children,child);
			this.__children.splice(index,0,child);
		}
	}
	,stopAllMovieClips: function() {
		this.__stopAllMovieClips();
	}
	,swapChildren: function(child1,child2) {
		if(child1.parent == this && child2.parent == this) {
			var index1 = this.__children.indexOf(child1);
			var index2 = this.__children.indexOf(child2);
			this.__children[index1] = child2;
			this.__children[index2] = child1;
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
	}
	,swapChildrenAt: function(index1,index2) {
		var swap = this.__children[index1];
		this.__children[index1] = this.__children[index2];
		this.__children[index2] = swap;
		swap = null;
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
	}
	,__cleanup: function() {
		openfl_display_InteractiveObject.prototype.__cleanup.call(this);
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__cleanup();
		}
		var orphan = this.__removedChildren.iterator();
		while(orphan.hasNext()) {
			var orphan1 = orphan.next();
			if(orphan1.stage == null) {
				orphan1.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
	}
	,__cleanupRemovedChildren: function() {
		var orphan = this.__removedChildren.iterator();
		while(orphan.hasNext()) {
			var orphan1 = orphan.next();
			if(orphan1.stage == null) {
				orphan1.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
	}
	,__dispatchChildren: function(event) {
		if(this.__children != null) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				event.target = child;
				if(!child.__dispatchWithCapture(event)) {
					break;
				}
				child.__dispatchChildren(event);
			}
		}
	}
	,__enterFrame: function(deltaTime) {
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__enterFrame(deltaTime);
		}
	}
	,__getBounds: function(rect,matrix) {
		openfl_display_InteractiveObject.prototype.__getBounds.call(this,rect,matrix);
		if(this.__children.length == 0) {
			return;
		}
		var childWorldTransform = openfl_geom_Matrix.__pool.get();
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.__scaleX == 0 || child.__scaleY == 0) {
				continue;
			}
			var local = child.__transform;
			childWorldTransform.a = local.a * matrix.a + local.b * matrix.c;
			childWorldTransform.b = local.a * matrix.b + local.b * matrix.d;
			childWorldTransform.c = local.c * matrix.a + local.d * matrix.c;
			childWorldTransform.d = local.c * matrix.b + local.d * matrix.d;
			childWorldTransform.tx = local.tx * matrix.a + local.ty * matrix.c + matrix.tx;
			childWorldTransform.ty = local.tx * matrix.b + local.ty * matrix.d + matrix.ty;
			child.__getBounds(rect,childWorldTransform);
		}
		openfl_geom_Matrix.__pool.release(childWorldTransform);
	}
	,__getFilterBounds: function(rect,matrix) {
		openfl_display_InteractiveObject.prototype.__getFilterBounds.call(this,rect,matrix);
		if(this.__scrollRect != null) {
			return;
		}
		if(this.__children.length == 0) {
			return;
		}
		var childWorldTransform = openfl_geom_Matrix.__pool.get();
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.__scaleX == 0 || child.__scaleY == 0 || child.__isMask) {
				continue;
			}
			var local = child.__transform;
			childWorldTransform.a = local.a * matrix.a + local.b * matrix.c;
			childWorldTransform.b = local.a * matrix.b + local.b * matrix.d;
			childWorldTransform.c = local.c * matrix.a + local.d * matrix.c;
			childWorldTransform.d = local.c * matrix.b + local.d * matrix.d;
			childWorldTransform.tx = local.tx * matrix.a + local.ty * matrix.c + matrix.tx;
			childWorldTransform.ty = local.tx * matrix.b + local.ty * matrix.d + matrix.ty;
			child.__getFilterBounds(rect,childWorldTransform);
		}
		openfl_geom_Matrix.__pool.release(childWorldTransform);
	}
	,__getRenderBounds: function(rect,matrix) {
		if(this.__scrollRect != null) {
			openfl_display_InteractiveObject.prototype.__getRenderBounds.call(this,rect,matrix);
			return;
		} else {
			openfl_display_InteractiveObject.prototype.__getBounds.call(this,rect,matrix);
		}
		if(this.__children.length == 0) {
			return;
		}
		var childWorldTransform = openfl_geom_Matrix.__pool.get();
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.__scaleX == 0 || child.__scaleY == 0 || child.__isMask) {
				continue;
			}
			var local = child.__transform;
			childWorldTransform.a = local.a * matrix.a + local.b * matrix.c;
			childWorldTransform.b = local.a * matrix.b + local.b * matrix.d;
			childWorldTransform.c = local.c * matrix.a + local.d * matrix.c;
			childWorldTransform.d = local.c * matrix.b + local.d * matrix.d;
			childWorldTransform.tx = local.tx * matrix.a + local.ty * matrix.c + matrix.tx;
			childWorldTransform.ty = local.tx * matrix.b + local.ty * matrix.d + matrix.ty;
			child.__getRenderBounds(rect,childWorldTransform);
		}
		openfl_geom_Matrix.__pool.release(childWorldTransform);
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(!hitObject.get_visible() || this.__isMask || interactiveOnly && !this.mouseEnabled && !this.mouseChildren) {
			return false;
		}
		if(this.get_mask() != null && !this.get_mask().__hitTestMask(x,y)) {
			return false;
		}
		if(this.__scrollRect != null) {
			var point = openfl_geom_Point.__pool.get();
			point.setTo(x,y);
			var _this = this.__getRenderTransform();
			var norm = _this.a * _this.d - _this.b * _this.c;
			if(norm == 0) {
				point.x = -_this.tx;
				point.y = -_this.ty;
			} else {
				var px = 1.0 / norm * (_this.c * (_this.ty - point.y) + _this.d * (point.x - _this.tx));
				point.y = 1.0 / norm * (_this.a * (point.y - _this.ty) + _this.b * (_this.tx - point.x));
				point.x = px;
			}
			if(!this.__scrollRect.containsPoint(point)) {
				openfl_geom_Point.__pool.release(point);
				return false;
			}
			openfl_geom_Point.__pool.release(point);
		}
		var i = this.__children.length;
		if(interactiveOnly) {
			if(stack == null || !this.mouseChildren) {
				while(--i >= 0) if(this.__children[i].__hitTest(x,y,shapeFlag,null,true,this.__children[i])) {
					if(stack != null) {
						stack.push(hitObject);
					}
					return true;
				}
			} else if(stack != null) {
				var length = stack.length;
				var interactive = false;
				var hitTest = false;
				while(--i >= 0) {
					interactive = this.__children[i].__getInteractive(null);
					if(interactive || this.mouseEnabled && !hitTest) {
						if(this.__children[i].__hitTest(x,y,shapeFlag,stack,true,this.__children[i])) {
							hitTest = true;
							if(interactive && stack.length > length) {
								break;
							}
						}
					}
				}
				if(hitTest) {
					stack.splice(length,0,hitObject);
					return true;
				}
			}
		} else {
			var hitTest1 = false;
			while(--i >= 0) if(this.__children[i].__hitTest(x,y,shapeFlag,stack,false,this.__children[i])) {
				hitTest1 = true;
				if(stack == null) {
					break;
				}
			}
			return hitTest1;
		}
		return false;
	}
	,__hitTestMask: function(x,y) {
		var i = this.__children.length;
		while(--i >= 0) if(this.__children[i].__hitTestMask(x,y)) {
			return true;
		}
		return false;
	}
	,__readGraphicsData: function(graphicsData,recurse) {
		openfl_display_InteractiveObject.prototype.__readGraphicsData.call(this,graphicsData,recurse);
		if(recurse) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__readGraphicsData(graphicsData,recurse);
			}
		}
	}
	,__renderCairo: function(renderer) {
	}
	,__renderCairoMask: function(renderer) {
	}
	,__renderCanvas: function(renderer) {
		var orphan = this.__removedChildren.iterator();
		while(orphan.hasNext()) {
			var orphan1 = orphan.next();
			if(orphan1.stage == null) {
				orphan1.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
		if(!this.__renderable || this.__worldAlpha <= 0 || this.get_mask() != null && (this.get_mask().get_width() <= 0 || this.get_mask().get_height() <= 0)) {
			return;
		}
		openfl_display_InteractiveObject.prototype.__renderCanvas.call(this,renderer);
		if(this.__cacheBitmap != null && !this.__isCacheBitmapRender) {
			return;
		}
		renderer.__pushMaskObject(this);
		if(renderer.__stage != null) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__renderCanvas(renderer);
				child.__renderDirty = false;
			}
			this.__renderDirty = false;
		} else {
			var _g2 = 0;
			var _g11 = this.__children;
			while(_g2 < _g11.length) {
				var child1 = _g11[_g2];
				++_g2;
				child1.__renderCanvas(renderer);
			}
		}
		renderer.__popMaskObject(this);
	}
	,__renderCanvasMask: function(renderer) {
		var orphan = this.__removedChildren.iterator();
		while(orphan.hasNext()) {
			var orphan1 = orphan.next();
			if(orphan1.stage == null) {
				orphan1.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
		if(this.__graphics != null) {
			openfl__$internal_renderer_canvas_CanvasGraphics.renderMask(this.__graphics,renderer);
		}
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__renderCanvasMask(renderer);
		}
	}
	,__renderDOM: function(renderer) {
		var orphan = this.__removedChildren.iterator();
		while(orphan.hasNext()) {
			var orphan1 = orphan.next();
			if(orphan1.stage == null) {
				orphan1.__renderDOM(renderer);
			}
		}
		var orphan2 = this.__removedChildren.iterator();
		while(orphan2.hasNext()) {
			var orphan3 = orphan2.next();
			if(orphan3.stage == null) {
				orphan3.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
		openfl_display_InteractiveObject.prototype.__renderDOM.call(this,renderer);
		if(this.__cacheBitmap != null && !this.__isCacheBitmapRender) {
			return;
		}
		renderer.__pushMaskObject(this);
		if(renderer.__stage != null) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__renderDOM(renderer);
				child.__renderDirty = false;
			}
			this.__renderDirty = false;
		} else {
			var _g2 = 0;
			var _g11 = this.__children;
			while(_g2 < _g11.length) {
				var child1 = _g11[_g2];
				++_g2;
				child1.__renderDOM(renderer);
			}
		}
		renderer.__popMaskObject(this);
	}
	,__renderDOMClear: function(renderer) {
		var orphan = this.__removedChildren.iterator();
		while(orphan.hasNext()) {
			var orphan1 = orphan.next();
			if(orphan1.stage == null) {
				orphan1.__renderDOMClear(renderer);
			}
		}
		var orphan2 = this.__removedChildren.iterator();
		while(orphan2.hasNext()) {
			var orphan3 = orphan2.next();
			if(orphan3.stage == null) {
				orphan3.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__renderDOMClear(renderer);
		}
	}
	,__renderGL: function(renderer) {
		var orphan = this.__removedChildren.iterator();
		while(orphan.hasNext()) {
			var orphan1 = orphan.next();
			if(orphan1.stage == null) {
				orphan1.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
		if(!this.__renderable || this.__worldAlpha <= 0) {
			return;
		}
		openfl_display_InteractiveObject.prototype.__renderGL.call(this,renderer);
		if(this.__cacheBitmap != null && !this.__isCacheBitmapRender) {
			return;
		}
		if(this.__children.length > 0) {
			renderer.__pushMaskObject(this);
			if(renderer.__stage != null) {
				var _g = 0;
				var _g1 = this.__children;
				while(_g < _g1.length) {
					var child = _g1[_g];
					++_g;
					child.__renderGL(renderer);
					child.__renderDirty = false;
				}
				this.__renderDirty = false;
			} else {
				var _g2 = 0;
				var _g11 = this.__children;
				while(_g2 < _g11.length) {
					var child1 = _g11[_g2];
					++_g2;
					child1.__renderGL(renderer);
				}
			}
		}
		if(this.__children.length > 0) {
			renderer.__popMaskObject(this);
		}
	}
	,__renderGLMask: function(renderer) {
		var orphan = this.__removedChildren.iterator();
		while(orphan.hasNext()) {
			var orphan1 = orphan.next();
			if(orphan1.stage == null) {
				orphan1.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
		if(this.__graphics != null) {
			openfl__$internal_renderer_context3D_Context3DShape.renderMask(this,renderer);
		}
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__renderGLMask(renderer);
		}
	}
	,__setStageReference: function(stage) {
		openfl_display_InteractiveObject.prototype.__setStageReference.call(this,stage);
		if(this.__children != null) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__setStageReference(stage);
			}
		}
	}
	,__setWorldTransformInvalid: function() {
		if(!this.__worldTransformInvalid) {
			this.__worldTransformInvalid = true;
			if(this.__children != null) {
				var _g = 0;
				var _g1 = this.__children;
				while(_g < _g1.length) {
					var child = _g1[_g];
					++_g;
					child.__setWorldTransformInvalid();
				}
			}
		}
	}
	,__shouldCacheHardware: function(value) {
		if(value == true) {
			return true;
		}
		value = openfl_display_InteractiveObject.prototype.__shouldCacheHardware.call(this,value);
		if(value == true) {
			return true;
		}
		if(this.__children != null) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				value = child.__shouldCacheHardware(value);
				if(value == true) {
					return true;
				}
			}
		}
		return value;
	}
	,__stopAllMovieClips: function() {
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__stopAllMovieClips();
		}
	}
	,__tabTest: function(stack) {
		openfl_display_InteractiveObject.prototype.__tabTest.call(this,stack);
		if(!this.get_tabChildren()) {
			return;
		}
		var interactive = false;
		var interactiveObject = null;
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			interactive = child.__getInteractive(null);
			if(interactive) {
				interactiveObject = child;
				interactiveObject.__tabTest(stack);
			}
		}
	}
	,__update: function(transformOnly,updateChildren) {
		openfl_display_InteractiveObject.prototype.__update.call(this,transformOnly,updateChildren);
		if(updateChildren) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__update(transformOnly,true);
			}
		}
	}
	,get_numChildren: function() {
		return this.__children.length;
	}
	,get_tabChildren: function() {
		return this.__tabChildren;
	}
	,set_tabChildren: function(value) {
		if(this.__tabChildren != value) {
			this.__tabChildren = value;
			this.dispatchEvent(new openfl_events_Event("tabChildrenChange",true,false));
		}
		return this.__tabChildren;
	}
	,__class__: openfl_display_DisplayObjectContainer
	,__properties__: $extend(openfl_display_InteractiveObject.prototype.__properties__,{set_tabChildren:"set_tabChildren",get_tabChildren:"get_tabChildren",get_numChildren:"get_numChildren"})
});
var openfl_display_Sprite = function() {
	openfl_display_DisplayObjectContainer.call(this);
	this.__buttonMode = false;
	this.useHandCursor = true;
};
$hxClasses["openfl.display.Sprite"] = openfl_display_Sprite;
openfl_display_Sprite.__name__ = "openfl.display.Sprite";
openfl_display_Sprite.__super__ = openfl_display_DisplayObjectContainer;
openfl_display_Sprite.prototype = $extend(openfl_display_DisplayObjectContainer.prototype,{
	dropTarget: null
	,hitArea: null
	,useHandCursor: null
	,__buttonMode: null
	,startDrag: function(lockCenter,bounds) {
		if(lockCenter == null) {
			lockCenter = false;
		}
		if(this.stage != null) {
			this.stage.__startDrag(this,lockCenter,bounds);
		}
	}
	,stopDrag: function() {
		if(this.stage != null) {
			this.stage.__stopDrag(this);
		}
	}
	,__getCursor: function() {
		if(this.__buttonMode && this.useHandCursor) {
			return "button";
		} else {
			return null;
		}
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(interactiveOnly && !this.mouseEnabled && !this.mouseChildren) {
			return false;
		}
		if(!hitObject.get_visible() || this.__isMask) {
			return this.__hitTestHitArea(x,y,shapeFlag,stack,interactiveOnly,hitObject);
		}
		if(this.get_mask() != null && !this.get_mask().__hitTestMask(x,y)) {
			return this.__hitTestHitArea(x,y,shapeFlag,stack,interactiveOnly,hitObject);
		}
		if(this.__scrollRect != null) {
			var point = openfl_geom_Point.__pool.get();
			point.setTo(x,y);
			var _this = this.__getRenderTransform();
			var norm = _this.a * _this.d - _this.b * _this.c;
			if(norm == 0) {
				point.x = -_this.tx;
				point.y = -_this.ty;
			} else {
				var px = 1.0 / norm * (_this.c * (_this.ty - point.y) + _this.d * (point.x - _this.tx));
				point.y = 1.0 / norm * (_this.a * (point.y - _this.ty) + _this.b * (_this.tx - point.x));
				point.x = px;
			}
			if(!this.__scrollRect.containsPoint(point)) {
				openfl_geom_Point.__pool.release(point);
				return this.__hitTestHitArea(x,y,shapeFlag,stack,true,hitObject);
			}
			openfl_geom_Point.__pool.release(point);
		}
		if(openfl_display_DisplayObjectContainer.prototype.__hitTest.call(this,x,y,shapeFlag,stack,interactiveOnly,hitObject)) {
			if(stack != null) {
				return interactiveOnly;
			} else {
				return true;
			}
		} else if(this.hitArea == null && this.__graphics != null && this.__graphics.__hitTest(x,y,shapeFlag,this.__getRenderTransform())) {
			if(stack != null && (!interactiveOnly || this.mouseEnabled)) {
				stack.push(hitObject);
			}
			return true;
		}
		return this.__hitTestHitArea(x,y,shapeFlag,stack,interactiveOnly,hitObject);
	}
	,__hitTestHitArea: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(this.hitArea != null) {
			if(!this.hitArea.mouseEnabled) {
				this.hitArea.mouseEnabled = true;
				var hitTest = this.hitArea.__hitTest(x,y,shapeFlag,null,true,hitObject);
				this.hitArea.mouseEnabled = false;
				if(stack != null && hitTest) {
					stack[stack.length] = hitObject;
				}
				return hitTest;
			}
		}
		return false;
	}
	,__hitTestMask: function(x,y) {
		if(openfl_display_DisplayObjectContainer.prototype.__hitTestMask.call(this,x,y)) {
			return true;
		} else if(this.__graphics != null && this.__graphics.__hitTest(x,y,true,this.__getRenderTransform())) {
			return true;
		}
		return false;
	}
	,get_graphics: function() {
		if(this.__graphics == null) {
			this.__graphics = new openfl_display_Graphics(this);
		}
		return this.__graphics;
	}
	,get_tabEnabled: function() {
		if(this.__tabEnabled == null) {
			return this.__buttonMode;
		} else {
			return this.__tabEnabled;
		}
	}
	,get_buttonMode: function() {
		return this.__buttonMode;
	}
	,set_buttonMode: function(value) {
		return this.__buttonMode = value;
	}
	,__class__: openfl_display_Sprite
	,__properties__: $extend(openfl_display_DisplayObjectContainer.prototype.__properties__,{get_graphics:"get_graphics",set_buttonMode:"set_buttonMode",get_buttonMode:"get_buttonMode"})
});
var Main = function() {
	openfl_display_Sprite.call(this);
	var container = new away3d_containers_ObjectContainer3D();
	var textContainer = new away3d_containers_ObjectContainer3D();
	var colour = 16777215 * Math.random() | 0;
	var bitmapFont = away3d_textfield_utils_AwayFont.type(definitions_berberRevKC_BerberRevKC_$260,false);
	var textField = new away3d_textfield_TextField(800,400,"SCORE",bitmapFont,100,colour,false,away3d_textfield_HAlign.CENTER);
	textField.set_rotationX(90);
	textField.set_y(400);
	textField.set_x(-800);
	this.stage.set_scaleMode(2);
	this.stage.align = 6;
	this._view = new away3d_containers_View3D();
	this.addChild(this._view);
	this._view.get_camera().set_z(-600);
	this._view.get_camera().set_y(500);
	this._view.get_camera().lookAt(new openfl_geom_Vector3D());
	this._plane = new away3d_entities_Mesh(new away3d_primitives_PlaneGeometry(2700,2700));
	this._view.get_scene().addChild(this._plane);
	this._cube = new away3d_entities_Mesh(new away3d_primitives_CubeGeometry(200,100,100,1,1,1,false),new away3d_materials_TextureMaterial(away3d_utils_Cast.bitmapTexture("assets/trinket_diffuse.jpg")));
	this._cube2 = new away3d_entities_Mesh(new away3d_primitives_CubeGeometry(200,100,100,1,1,1,false),new away3d_materials_TextureMaterial(away3d_utils_Cast.bitmapTexture("assets/trinket_diffuse.jpg")));
	this._sphere_head1 = new away3d_entities_Mesh(new away3d_primitives_SphereGeometry(50,100),new away3d_materials_TextureMaterial(away3d_utils_Cast.bitmapTexture("assets/kasajizou.jpg")));
	this._sphere_body1 = new away3d_entities_Mesh(new away3d_primitives_SphereGeometry(50,100),new away3d_materials_TextureMaterial(away3d_utils_Cast.bitmapTexture("assets/kasajizou.jpg")));
	this._botamoti_ohagi1 = new away3d_entities_Mesh(new away3d_primitives_SphereGeometry(50,100),new away3d_materials_TextureMaterial(away3d_utils_Cast.bitmapTexture("assets/ob.png")));
	this._botamoti_ohagi2 = new away3d_entities_Mesh(new away3d_primitives_SphereGeometry(50,100),new away3d_materials_TextureMaterial(away3d_utils_Cast.bitmapTexture("assets/ob.png")));
	this._botamoti_ohagi3 = new away3d_entities_Mesh(new away3d_primitives_SphereGeometry(50,100),new away3d_materials_TextureMaterial(away3d_utils_Cast.bitmapTexture("assets/ob.png")));
	this._cube.set_y(50);
	this._cube.set_x(-450);
	this._cube2.set_z(555);
	this._botamoti_ohagi1.set_z(1300);
	this._botamoti_ohagi2.set_z(1500);
	this._botamoti_ohagi3.set_z(1500);
	this._botamoti_ohagi1.set_x(-500);
	this._botamoti_ohagi1.set_x(500 - 1000 * Math.random());
	this._botamoti_ohagi2.set_x(500 - 1000 * Math.random());
	this._botamoti_ohagi3.set_x(500 - 1000 * Math.random());
	this._sphere_head1.set_x(-500);
	this._sphere_body1.set_x(0);
	this._sphere_head1.set_y(70);
	this._view.get_scene().addChild(this._botamoti_ohagi1);
	this._view.get_scene().addChild(this._botamoti_ohagi2);
	this._view.get_scene().addChild(this._botamoti_ohagi3);
	this._view.get_scene().addChild(this._sphere_head1);
	this._view.get_scene().addChild(this._sphere_body1);
	this._view.get_scene().addChild(textField);
	this._plane.set_y(-100);
	this._plane.set_z(1000);
	this.addEventListener("enterFrame",$bind(this,this._onEnterFrame));
	this.stage.addEventListener("resize",$bind(this,this.onResize));
	this.stage.addEventListener("keyDown",$bind(this,this.stage_onKeyDown));
	this.stage.addEventListener("keyUp",$bind(this,this.stage_onKeyUp));
	this.onResize();
};
$hxClasses["Main"] = Main;
Main.__name__ = "Main";
Main.__super__ = openfl_display_Sprite;
Main.prototype = $extend(openfl_display_Sprite.prototype,{
	_view: null
	,score: null
	,_text: null
	,_cube: null
	,_cube2: null
	,_sphere_head1: null
	,_sphere_body1: null
	,movingDown: null
	,movingLeft: null
	,movingRight: null
	,movingUp: null
	,_botamoti_ohagi1: null
	,_botamoti_ohagi2: null
	,_botamoti_ohagi3: null
	,_plane: null
	,stage_onKeyDown: function(event) {
		switch(event.keyCode) {
		case 37:
			this.movingLeft = true;
			break;
		case 38:
			this.movingUp = true;
			break;
		case 39:
			this.movingRight = true;
			break;
		case 40:
			this.movingDown = true;
			break;
		}
	}
	,stage_onKeyUp: function(event) {
		switch(event.keyCode) {
		case 37:
			this.movingLeft = false;
			break;
		case 38:
			this.movingUp = false;
			break;
		case 39:
			this.movingRight = false;
			break;
		case 40:
			this.movingDown = false;
			break;
		}
	}
	,_onEnterFrame: function(event) {
		this._sphere_head1.set_x(this.get_mouseX() - 600);
		this._sphere_body1.set_x(this.get_mouseX() - 600);
		var _g = this._botamoti_ohagi1;
		_g.set_z(_g.get_z() - 5);
		var _g1 = this._botamoti_ohagi2;
		_g1.set_z(_g1.get_z() - 5);
		var _g2 = this._botamoti_ohagi3;
		_g2.set_z(_g2.get_z() - 5);
		if(this._sphere_body1.get_x() < this._botamoti_ohagi1.get_x() + 155 && this._sphere_body1.get_x() > this._botamoti_ohagi1.get_x() && this._sphere_body1.get_z() > this._botamoti_ohagi1.get_z() && this._botamoti_ohagi1.get_z() + 50 > this._sphere_body1.get_z()) {
			this._view.get_scene().removeChild(this._botamoti_ohagi1);
			this._botamoti_ohagi1.set_z(1500);
			this._botamoti_ohagi1.set_x(1000 * Math.random());
			this._view.get_scene().addChild(this._botamoti_ohagi1);
		}
		if(this._sphere_body1.get_x() < this._botamoti_ohagi2.get_x() + 55 && this._sphere_body1.get_x() > this._botamoti_ohagi2.get_x() && this._sphere_body1.get_z() > this._botamoti_ohagi2.get_z()) {
			this._view.get_scene().removeChild(this._botamoti_ohagi2);
			this._botamoti_ohagi2.set_z(1500);
			this._botamoti_ohagi2.set_x(1000 * Math.random());
			this._view.get_scene().addChild(this._botamoti_ohagi2);
		}
		if(this._sphere_body1.get_x() < this._botamoti_ohagi3.get_x() + 55 && this._sphere_body1.get_x() > this._botamoti_ohagi3.get_x() && this._sphere_body1.get_z() > this._botamoti_ohagi3.get_z()) {
			this._view.get_scene().removeChild(this._botamoti_ohagi3);
			this._botamoti_ohagi3.set_z(1500);
			this._botamoti_ohagi3.set_x(1000 * Math.random());
			this._view.get_scene().addChild(this._botamoti_ohagi3);
		}
		if(this._botamoti_ohagi1.get_z() == -300) {
			this._view.get_scene().removeChild(this._botamoti_ohagi1);
			this._botamoti_ohagi1.set_z(1500);
			this._botamoti_ohagi1.set_x(500 - 1000 * Math.random());
			this._view.get_scene().addChild(this._botamoti_ohagi1);
		}
		if(this._botamoti_ohagi2.get_z() == -300) {
			this._view.get_scene().removeChild(this._botamoti_ohagi2);
			this._botamoti_ohagi2.set_z(1500);
			this._botamoti_ohagi2.set_x(500 - 1000 * Math.random());
			this._view.get_scene().addChild(this._botamoti_ohagi2);
		}
		if(this._botamoti_ohagi3.get_z() == -300) {
			this._view.get_scene().removeChild(this._botamoti_ohagi3);
			this._botamoti_ohagi3.set_z(1500);
			this._botamoti_ohagi3.set_x(500 - 1000 * Math.random());
			this._view.get_scene().addChild(this._botamoti_ohagi3);
		}
		this._view.render();
	}
	,_onMouseUp: function(ev) {
		var path = new motion_MotionPath().bezier(ev.get_scenePosition().x,ev.get_scenePosition().z,this._cube.get_x(),ev.get_scenePosition().z);
		motion_Actuate.motionPath(this._cube,0.5,{ x : path.get_x(), z : path.get_y()});
	}
	,onResize: function(event) {
		this._view.set_width(this.stage.stageWidth);
		this._view.set_height(this.stage.stageHeight);
	}
	,__class__: Main
});
var DocumentClass = function(current) {
	current.addChild(this);
	Main.call(this);
	this.dispatchEvent(new openfl_events_Event("addedToStage",false,false));
};
$hxClasses["DocumentClass"] = DocumentClass;
DocumentClass.__name__ = "DocumentClass";
DocumentClass.__super__ = Main;
DocumentClass.prototype = $extend(Main.prototype,{
	__class__: DocumentClass
});
var EReg = function(r,opt) {
	this.r = new RegExp(r,opt.split("u").join(""));
};
$hxClasses["EReg"] = EReg;
EReg.__name__ = "EReg";
EReg.prototype = {
	r: null
	,match: function(s) {
		if(this.r.global) {
			this.r.lastIndex = 0;
		}
		this.r.m = this.r.exec(s);
		this.r.s = s;
		return this.r.m != null;
	}
	,matched: function(n) {
		if(this.r.m != null && n >= 0 && n < this.r.m.length) {
			return this.r.m[n];
		} else {
			throw new js__$Boot_HaxeError("EReg::matched");
		}
	}
	,matchedRight: function() {
		if(this.r.m == null) {
			throw new js__$Boot_HaxeError("No string matched");
		}
		var sz = this.r.m.index + this.r.m[0].length;
		return HxOverrides.substr(this.r.s,sz,this.r.s.length - sz);
	}
	,matchedPos: function() {
		if(this.r.m == null) {
			throw new js__$Boot_HaxeError("No string matched");
		}
		return { pos : this.r.m.index, len : this.r.m[0].length};
	}
	,matchSub: function(s,pos,len) {
		if(len == null) {
			len = -1;
		}
		if(this.r.global) {
			this.r.lastIndex = pos;
			this.r.m = this.r.exec(len < 0 ? s : HxOverrides.substr(s,0,pos + len));
			var b = this.r.m != null;
			if(b) {
				this.r.s = s;
			}
			return b;
		} else {
			var b1 = this.match(len < 0 ? HxOverrides.substr(s,pos,null) : HxOverrides.substr(s,pos,len));
			if(b1) {
				this.r.s = s;
				this.r.m.index += pos;
			}
			return b1;
		}
	}
	,split: function(s) {
		var d = "#__delim__#";
		return s.replace(this.r,d).split(d);
	}
	,map: function(s,f) {
		var offset = 0;
		var buf_b = "";
		while(true) {
			if(offset >= s.length) {
				break;
			} else if(!this.matchSub(s,offset)) {
				buf_b += Std.string(HxOverrides.substr(s,offset,null));
				break;
			}
			var p = this.matchedPos();
			buf_b += Std.string(HxOverrides.substr(s,offset,p.pos - offset));
			buf_b += Std.string(f(this));
			if(p.len == 0) {
				buf_b += Std.string(HxOverrides.substr(s,p.pos,1));
				offset = p.pos + 1;
			} else {
				offset = p.pos + p.len;
			}
			if(!this.r.global) {
				break;
			}
		}
		if(!this.r.global && offset > 0 && offset < s.length) {
			buf_b += Std.string(HxOverrides.substr(s,offset,null));
		}
		return buf_b;
	}
	,__class__: EReg
};
var HxOverrides = function() { };
$hxClasses["HxOverrides"] = HxOverrides;
HxOverrides.__name__ = "HxOverrides";
HxOverrides.strDate = function(s) {
	switch(s.length) {
	case 8:
		var k = s.split(":");
		var d = new Date();
		d["setTime"](0);
		d["setUTCHours"](k[0]);
		d["setUTCMinutes"](k[1]);
		d["setUTCSeconds"](k[2]);
		return d;
	case 10:
		var k1 = s.split("-");
		return new Date(k1[0],k1[1] - 1,k1[2],0,0,0);
	case 19:
		var k2 = s.split(" ");
		var y = k2[0].split("-");
		var t = k2[1].split(":");
		return new Date(y[0],y[1] - 1,y[2],t[0],t[1],t[2]);
	default:
		throw new js__$Boot_HaxeError("Invalid date format : " + s);
	}
};
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
};
var Lambda = function() { };
$hxClasses["Lambda"] = Lambda;
Lambda.__name__ = "Lambda";
Lambda.array = function(it) {
	var a = [];
	var i = $getIterator(it);
	while(i.hasNext()) {
		var i1 = i.next();
		a.push(i1);
	}
	return a;
};
var ManifestResources = function() { };
$hxClasses["ManifestResources"] = ManifestResources;
ManifestResources.__name__ = "ManifestResources";
ManifestResources.init = function(config) {
	ManifestResources.preloadLibraries = [];
	ManifestResources.preloadLibraryNames = [];
	ManifestResources.rootPath = null;
	if(config != null && Object.prototype.hasOwnProperty.call(config,"rootPath")) {
		ManifestResources.rootPath = Reflect.field(config,"rootPath");
	}
	if(ManifestResources.rootPath == null) {
		ManifestResources.rootPath = "./";
	}
	var bundle;
	var data = "{\"name\":null,\"assets\":\"aoy4:pathy36:assets%2Ffonts%2FBerberRevKC_260.pngy4:sizei51223y4:typey5:IMAGEy2:idR1y7:preloadtgoR0y36:assets%2Ffonts%2FBerberRevKC_260.fntR2i8673R3y4:TEXTR5R7R6tgoR0y26:assets%2Fkasajizougray.jpgR2i5243R3R4R5R9R6tgoR0y22:assets%2Fkasajizou.jpgR2i158146R3R4R5R10R6tgoR0y15:assets%2Fob.pngR2i1577R3R4R5R11R6tgoR0y23:assets%2Fkasajizou2.jpgR2i1172499R3R4R5R12R6tgoR0y26:assets%2Ffloor_diffuse.jpgR2i139264R3R4R5R13R6tgoR0y17:assets%2Fkasa.jpgR2i3815R3R4R5R14R6tgoR0y20:assets%2Fmarines.pngR2i1596R3R4R5R15R6tgoR0y17:assets%2Fkasa.pngR2i1416R3R4R5R16R6tgoR0y21:assets%2Fmarines2.pngR2i2784R3R4R5R17R6tgoR0y28:assets%2Ftrinket_diffuse.jpgR2i262144R3R4R5R18R6tgh\",\"rootPath\":null,\"version\":2,\"libraryArgs\":[],\"libraryType\":null}";
	var manifest = lime_utils_AssetManifest.parse(data,ManifestResources.rootPath);
	var library = lime_utils_AssetLibrary.fromManifest(manifest);
	lime_utils_Assets.registerLibrary("default",library);
	library = lime_utils_Assets.getLibrary("default");
	if(library != null) {
		ManifestResources.preloadLibraries.push(library);
	} else {
		ManifestResources.preloadLibraryNames.push("default");
	}
};
Math.__name__ = "Math";
var Reflect = function() { };
$hxClasses["Reflect"] = Reflect;
Reflect.__name__ = "Reflect";
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( e ) {
		haxe_CallStack.lastException = e;
		var e1 = ((e) instanceof js__$Boot_HaxeError) ? e.val : e;
		return null;
	}
};
Reflect.getProperty = function(o,field) {
	var tmp;
	if(o == null) {
		return null;
	} else {
		var tmp1;
		if(o.__properties__) {
			tmp = o.__properties__["get_" + field];
			tmp1 = tmp;
		} else {
			tmp1 = false;
		}
		if(tmp1) {
			return o[tmp]();
		} else {
			return o[field];
		}
	}
};
Reflect.setProperty = function(o,field,value) {
	var tmp;
	var tmp1;
	if(o.__properties__) {
		tmp = o.__properties__["set_" + field];
		tmp1 = tmp;
	} else {
		tmp1 = false;
	}
	if(tmp1) {
		o[tmp](value);
	} else {
		o[field] = value;
	}
};
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(f != "__id__" && f != "hx__closures__" && hasOwnProperty.call(o,f)) {
			a.push(f);
		}
		}
	}
	return a;
};
Reflect.isFunction = function(f) {
	if(typeof(f) == "function") {
		return !(f.__name__ || f.__ename__);
	} else {
		return false;
	}
};
Reflect.compare = function(a,b) {
	if(a == b) {
		return 0;
	} else if(a > b) {
		return 1;
	} else {
		return -1;
	}
};
Reflect.compareMethods = function(f1,f2) {
	if(f1 == f2) {
		return true;
	}
	if(!Reflect.isFunction(f1) || !Reflect.isFunction(f2)) {
		return false;
	}
	if(f1.scope == f2.scope && f1.method == f2.method) {
		return f1.method != null;
	} else {
		return false;
	}
};
Reflect.deleteField = function(o,field) {
	if(!Object.prototype.hasOwnProperty.call(o,field)) {
		return false;
	}
	delete(o[field]);
	return true;
};
Reflect.makeVarArgs = function(f) {
	return function() {
		var a = Array.prototype.slice.call(arguments);
		return f(a);
	};
};
var Std = function() { };
$hxClasses["Std"] = Std;
Std.__name__ = "Std";
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
Std.parseInt = function(x) {
	if(x != null) {
		var _g = 0;
		var _g1 = x.length;
		while(_g < _g1) {
			var i = _g++;
			var c = x.charCodeAt(i);
			if(c <= 8 || c >= 14 && c != 32 && c != 45) {
				var v = parseInt(x, (x[(i + 1)]=="x" || x[(i + 1)]=="X") ? 16 : 10);
				if(isNaN(v)) {
					return null;
				} else {
					return v;
				}
			}
		}
	}
	return null;
};
var _$String_String_$Impl_$ = function() { };
$hxClasses["_String.String_Impl_"] = _$String_String_$Impl_$;
_$String_String_$Impl_$.__name__ = "_String.String_Impl_";
_$String_String_$Impl_$.fromCharCode = function(code) {
	return String.fromCodePoint(code);
};
var StringBuf = function() {
	this.b = "";
};
$hxClasses["StringBuf"] = StringBuf;
StringBuf.__name__ = "StringBuf";
StringBuf.prototype = {
	b: null
	,__class__: StringBuf
};
var StringTools = function() { };
$hxClasses["StringTools"] = StringTools;
StringTools.__name__ = "StringTools";
StringTools.htmlEscape = function(s,quotes) {
	var buf_b = "";
	var _g_offset = 0;
	var _g_s = s;
	while(_g_offset < _g_s.length) {
		var s1 = _g_s;
		var index = _g_offset++;
		var c = s1.charCodeAt(index);
		if(c >= 55296 && c <= 56319) {
			c = c - 55232 << 10 | s1.charCodeAt(index + 1) & 1023;
		}
		var c1 = c;
		if(c1 >= 65536) {
			++_g_offset;
		}
		var code = c1;
		switch(code) {
		case 34:
			if(quotes) {
				buf_b += "&quot;";
			} else {
				buf_b += String.fromCodePoint(code);
			}
			break;
		case 38:
			buf_b += "&amp;";
			break;
		case 39:
			if(quotes) {
				buf_b += "&#039;";
			} else {
				buf_b += String.fromCodePoint(code);
			}
			break;
		case 60:
			buf_b += "&lt;";
			break;
		case 62:
			buf_b += "&gt;";
			break;
		default:
			buf_b += String.fromCodePoint(code);
		}
	}
	return buf_b;
};
StringTools.startsWith = function(s,start) {
	if(s.length >= start.length) {
		return s.lastIndexOf(start,0) == 0;
	} else {
		return false;
	}
};
StringTools.endsWith = function(s,end) {
	var elen = end.length;
	var slen = s.length;
	if(slen >= elen) {
		return s.indexOf(end,slen - elen) == slen - elen;
	} else {
		return false;
	}
};
StringTools.isSpace = function(s,pos) {
	var c = HxOverrides.cca(s,pos);
	if(!(c > 8 && c < 14)) {
		return c == 32;
	} else {
		return true;
	}
};
StringTools.ltrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,r)) ++r;
	if(r > 0) {
		return HxOverrides.substr(s,r,l - r);
	} else {
		return s;
	}
};
StringTools.rtrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,l - r - 1)) ++r;
	if(r > 0) {
		return HxOverrides.substr(s,0,l - r);
	} else {
		return s;
	}
};
StringTools.trim = function(s) {
	return StringTools.ltrim(StringTools.rtrim(s));
};
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
StringTools.hex = function(n,digits) {
	var s = "";
	var hexChars = "0123456789ABCDEF";
	while(true) {
		s = hexChars.charAt(n & 15) + s;
		n >>>= 4;
		if(!(n > 0)) {
			break;
		}
	}
	if(digits != null) {
		while(s.length < digits) s = "0" + s;
	}
	return s;
};
var ValueType = $hxEnums["ValueType"] = { __ename__ : "ValueType", __constructs__ : ["TNull","TInt","TFloat","TBool","TObject","TFunction","TClass","TEnum","TUnknown"]
	,TNull: {_hx_index:0,__enum__:"ValueType",toString:$estr}
	,TInt: {_hx_index:1,__enum__:"ValueType",toString:$estr}
	,TFloat: {_hx_index:2,__enum__:"ValueType",toString:$estr}
	,TBool: {_hx_index:3,__enum__:"ValueType",toString:$estr}
	,TObject: {_hx_index:4,__enum__:"ValueType",toString:$estr}
	,TFunction: {_hx_index:5,__enum__:"ValueType",toString:$estr}
	,TClass: ($_=function(c) { return {_hx_index:6,c:c,__enum__:"ValueType",toString:$estr}; },$_.__params__ = ["c"],$_)
	,TEnum: ($_=function(e) { return {_hx_index:7,e:e,__enum__:"ValueType",toString:$estr}; },$_.__params__ = ["e"],$_)
	,TUnknown: {_hx_index:8,__enum__:"ValueType",toString:$estr}
};
var Type = function() { };
$hxClasses["Type"] = Type;
Type.__name__ = "Type";
Type.createInstance = function(cl,args) {
	return new (Function.prototype.bind.apply(cl,[null].concat(args)));
};
Type.createEnum = function(e,constr,params) {
	var f = Reflect.field(e,constr);
	if(f == null) {
		throw new js__$Boot_HaxeError("No such constructor " + constr);
	}
	if(Reflect.isFunction(f)) {
		if(params == null) {
			throw new js__$Boot_HaxeError("Constructor " + constr + " need parameters");
		}
		return f.apply(e,params);
	}
	if(params != null && params.length != 0) {
		throw new js__$Boot_HaxeError("Constructor " + constr + " does not need parameters");
	}
	return f;
};
Type.getInstanceFields = function(c) {
	var a = [];
	for(var i in c.prototype) a.push(i);
	HxOverrides.remove(a,"__class__");
	HxOverrides.remove(a,"__properties__");
	return a;
};
Type.typeof = function(v) {
	switch(typeof(v)) {
	case "boolean":
		return ValueType.TBool;
	case "function":
		if(v.__name__ || v.__ename__) {
			return ValueType.TObject;
		}
		return ValueType.TFunction;
	case "number":
		if(Math.ceil(v) == v % 2147483648.0) {
			return ValueType.TInt;
		}
		return ValueType.TFloat;
	case "object":
		if(v == null) {
			return ValueType.TNull;
		}
		var e = v.__enum__;
		if(e != null) {
			return ValueType.TEnum($hxEnums[e]);
		}
		var c = js_Boot.getClass(v);
		if(c != null) {
			return ValueType.TClass(c);
		}
		return ValueType.TObject;
	case "string":
		return ValueType.TClass(String);
	case "undefined":
		return ValueType.TNull;
	default:
		return ValueType.TUnknown;
	}
};
Type.enumParameters = function(e) {
	var enm = $hxEnums[e.__enum__];
	var ctorName = enm.__constructs__[e._hx_index];
	var params = enm[ctorName].__params__;
	if(params != null) {
		var _g = [];
		var _g1 = 0;
		while(_g1 < params.length) {
			var p = params[_g1];
			++_g1;
			_g.push(e[p]);
		}
		return _g;
	} else {
		return [];
	}
};
var _$UInt_UInt_$Impl_$ = {};
$hxClasses["_UInt.UInt_Impl_"] = _$UInt_UInt_$Impl_$;
_$UInt_UInt_$Impl_$.__name__ = "_UInt.UInt_Impl_";
_$UInt_UInt_$Impl_$.gt = function(a,b) {
	var aNeg = a < 0;
	var bNeg = b < 0;
	if(aNeg != bNeg) {
		return aNeg;
	} else {
		return a > b;
	}
};
_$UInt_UInt_$Impl_$.gte = function(a,b) {
	var aNeg = a < 0;
	var bNeg = b < 0;
	if(aNeg != bNeg) {
		return aNeg;
	} else {
		return a >= b;
	}
};
_$UInt_UInt_$Impl_$.toFloat = function(this1) {
	var int = this1;
	if(int < 0) {
		return 4294967296.0 + int;
	} else {
		return int + 0.0;
	}
};
var _$Xml_XmlType_$Impl_$ = {};
$hxClasses["_Xml.XmlType_Impl_"] = _$Xml_XmlType_$Impl_$;
_$Xml_XmlType_$Impl_$.__name__ = "_Xml.XmlType_Impl_";
_$Xml_XmlType_$Impl_$.toString = function(this1) {
	switch(this1) {
	case 0:
		return "Element";
	case 1:
		return "PCData";
	case 2:
		return "CData";
	case 3:
		return "Comment";
	case 4:
		return "DocType";
	case 5:
		return "ProcessingInstruction";
	case 6:
		return "Document";
	}
};
var Xml = function(nodeType) {
	this.nodeType = nodeType;
	this.children = [];
	this.attributeMap = new haxe_ds_StringMap();
};
$hxClasses["Xml"] = Xml;
Xml.__name__ = "Xml";
Xml.parse = function(str) {
	return haxe_xml_Parser.parse(str);
};
Xml.createElement = function(name) {
	var xml = new Xml(Xml.Element);
	if(xml.nodeType != Xml.Element) {
		throw new js__$Boot_HaxeError("Bad node type, expected Element but found " + _$Xml_XmlType_$Impl_$.toString(xml.nodeType));
	}
	xml.nodeName = name;
	return xml;
};
Xml.createPCData = function(data) {
	var xml = new Xml(Xml.PCData);
	if(xml.nodeType == Xml.Document || xml.nodeType == Xml.Element) {
		throw new js__$Boot_HaxeError("Bad node type, unexpected " + _$Xml_XmlType_$Impl_$.toString(xml.nodeType));
	}
	xml.nodeValue = data;
	return xml;
};
Xml.createCData = function(data) {
	var xml = new Xml(Xml.CData);
	if(xml.nodeType == Xml.Document || xml.nodeType == Xml.Element) {
		throw new js__$Boot_HaxeError("Bad node type, unexpected " + _$Xml_XmlType_$Impl_$.toString(xml.nodeType));
	}
	xml.nodeValue = data;
	return xml;
};
Xml.createComment = function(data) {
	var xml = new Xml(Xml.Comment);
	if(xml.nodeType == Xml.Document || xml.nodeType == Xml.Element) {
		throw new js__$Boot_HaxeError("Bad node type, unexpected " + _$Xml_XmlType_$Impl_$.toString(xml.nodeType));
	}
	xml.nodeValue = data;
	return xml;
};
Xml.createDocType = function(data) {
	var xml = new Xml(Xml.DocType);
	if(xml.nodeType == Xml.Document || xml.nodeType == Xml.Element) {
		throw new js__$Boot_HaxeError("Bad node type, unexpected " + _$Xml_XmlType_$Impl_$.toString(xml.nodeType));
	}
	xml.nodeValue = data;
	return xml;
};
Xml.createProcessingInstruction = function(data) {
	var xml = new Xml(Xml.ProcessingInstruction);
	if(xml.nodeType == Xml.Document || xml.nodeType == Xml.Element) {
		throw new js__$Boot_HaxeError("Bad node type, unexpected " + _$Xml_XmlType_$Impl_$.toString(xml.nodeType));
	}
	xml.nodeValue = data;
	return xml;
};
Xml.createDocument = function() {
	return new Xml(Xml.Document);
};
Xml.prototype = {
	nodeType: null
	,nodeName: null
	,nodeValue: null
	,parent: null
	,children: null
	,attributeMap: null
	,get: function(att) {
		if(this.nodeType != Xml.Element) {
			throw new js__$Boot_HaxeError("Bad node type, expected Element but found " + _$Xml_XmlType_$Impl_$.toString(this.nodeType));
		}
		var _this = this.attributeMap;
		if(__map_reserved[att] != null) {
			return _this.getReserved(att);
		} else {
			return _this.h[att];
		}
	}
	,set: function(att,value) {
		if(this.nodeType != Xml.Element) {
			throw new js__$Boot_HaxeError("Bad node type, expected Element but found " + _$Xml_XmlType_$Impl_$.toString(this.nodeType));
		}
		var _this = this.attributeMap;
		if(__map_reserved[att] != null) {
			_this.setReserved(att,value);
		} else {
			_this.h[att] = value;
		}
	}
	,exists: function(att) {
		if(this.nodeType != Xml.Element) {
			throw new js__$Boot_HaxeError("Bad node type, expected Element but found " + _$Xml_XmlType_$Impl_$.toString(this.nodeType));
		}
		var _this = this.attributeMap;
		if(__map_reserved[att] != null) {
			return _this.existsReserved(att);
		} else {
			return _this.h.hasOwnProperty(att);
		}
	}
	,attributes: function() {
		if(this.nodeType != Xml.Element) {
			throw new js__$Boot_HaxeError("Bad node type, expected Element but found " + _$Xml_XmlType_$Impl_$.toString(this.nodeType));
		}
		return this.attributeMap.keys();
	}
	,elementsNamed: function(name) {
		if(this.nodeType != Xml.Document && this.nodeType != Xml.Element) {
			throw new js__$Boot_HaxeError("Bad node type, expected Element or Document but found " + _$Xml_XmlType_$Impl_$.toString(this.nodeType));
		}
		var _g = [];
		var _g1 = 0;
		var _g2 = this.children;
		while(_g1 < _g2.length) {
			var child = _g2[_g1];
			++_g1;
			var tmp;
			if(child.nodeType == Xml.Element) {
				if(child.nodeType != Xml.Element) {
					throw new js__$Boot_HaxeError("Bad node type, expected Element but found " + _$Xml_XmlType_$Impl_$.toString(child.nodeType));
				}
				tmp = child.nodeName == name;
			} else {
				tmp = false;
			}
			if(tmp) {
				_g.push(child);
			}
		}
		var ret = _g;
		return HxOverrides.iter(ret);
	}
	,addChild: function(x) {
		if(this.nodeType != Xml.Document && this.nodeType != Xml.Element) {
			throw new js__$Boot_HaxeError("Bad node type, expected Element or Document but found " + _$Xml_XmlType_$Impl_$.toString(this.nodeType));
		}
		if(x.parent != null) {
			x.parent.removeChild(x);
		}
		this.children.push(x);
		x.parent = this;
	}
	,removeChild: function(x) {
		if(this.nodeType != Xml.Document && this.nodeType != Xml.Element) {
			throw new js__$Boot_HaxeError("Bad node type, expected Element or Document but found " + _$Xml_XmlType_$Impl_$.toString(this.nodeType));
		}
		if(HxOverrides.remove(this.children,x)) {
			x.parent = null;
			return true;
		}
		return false;
	}
	,toString: function() {
		return haxe_xml_Printer.print(this);
	}
	,__class__: Xml
};
var away3d_Away3D = function() { };
$hxClasses["away3d.Away3D"] = away3d_Away3D;
away3d_Away3D.__name__ = "away3d.Away3D";
var away3d_library_assets_NamedAssetBase = function(name) {
	if(name == null) {
		name = "null";
	}
	this._name = name;
	this._originalName = name;
	this.updateFullPath();
	openfl_events_EventDispatcher.call(this);
};
$hxClasses["away3d.library.assets.NamedAssetBase"] = away3d_library_assets_NamedAssetBase;
away3d_library_assets_NamedAssetBase.__name__ = "away3d.library.assets.NamedAssetBase";
away3d_library_assets_NamedAssetBase.__super__ = openfl_events_EventDispatcher;
away3d_library_assets_NamedAssetBase.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	_originalName: null
	,_namespace: null
	,_name: null
	,_id: null
	,_full_path: null
	,get_originalName: function() {
		return this._originalName;
	}
	,get_id: function() {
		return this._id;
	}
	,set_id: function(newID) {
		this._id = newID;
		return newID;
	}
	,get_name: function() {
		return this._name;
	}
	,set_name: function(val) {
		var prev = this._name;
		this._name = val;
		if(this._name == null) {
			this._name = "null";
		}
		this.updateFullPath();
		if(this.hasEventListener("assetRename")) {
			this.dispatchEvent(new away3d_events_Asset3DEvent("assetRename",js_Boot.__cast(this , away3d_library_assets_IAsset),prev));
		}
		return val;
	}
	,get_assetNamespace: function() {
		return this._namespace;
	}
	,get_assetFullPath: function() {
		return this._full_path;
	}
	,assetPathEquals: function(name,ns) {
		if(this._name == name) {
			if(ns != null) {
				return this._namespace == ns;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	,resetAssetPath: function(name,ns,overrideOriginal) {
		if(overrideOriginal == null) {
			overrideOriginal = true;
		}
		this._name = name != null ? name : "null";
		this._namespace = ns != null ? ns : "default";
		if(overrideOriginal) {
			this._originalName = this._name;
		}
		this.updateFullPath();
	}
	,updateFullPath: function() {
		this._full_path = [this._namespace,this._name];
	}
	,__class__: away3d_library_assets_NamedAssetBase
	,__properties__: {get_assetFullPath:"get_assetFullPath",get_assetNamespace:"get_assetNamespace",set_name:"set_name",get_name:"get_name",set_id:"set_id",get_id:"get_id",get_originalName:"get_originalName"}
});
var away3d_library_assets_IAsset = function() { };
$hxClasses["away3d.library.assets.IAsset"] = away3d_library_assets_IAsset;
away3d_library_assets_IAsset.__name__ = "away3d.library.assets.IAsset";
away3d_library_assets_IAsset.__isInterface__ = true;
away3d_library_assets_IAsset.__interfaces__ = [openfl_events_IEventDispatcher];
away3d_library_assets_IAsset.prototype = {
	get_name: null
	,set_name: null
	,get_id: null
	,set_id: null
	,get_assetNamespace: null
	,get_assetType: null
	,get_assetFullPath: null
	,assetPathEquals: null
	,resetAssetPath: null
	,dispose: null
	,__class__: away3d_library_assets_IAsset
	,__properties__: {get_assetFullPath:"get_assetFullPath",get_assetType:"get_assetType",get_assetNamespace:"get_assetNamespace",set_id:"set_id",get_id:"get_id",set_name:"set_name",get_name:"get_name"}
};
var away3d_animators_AnimatorBase = function(animationSet) {
	this.updatePosition = true;
	this._animationStates = new haxe_ds_ObjectMap();
	this._absoluteTime = 0;
	this._owners = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this._playbackSpeed = 1;
	this._time = 0;
	this._autoUpdate = true;
	this._broadcaster = new openfl_display_Sprite();
	this._animationSet = animationSet;
	away3d_library_assets_NamedAssetBase.call(this);
};
$hxClasses["away3d.animators.AnimatorBase"] = away3d_animators_AnimatorBase;
away3d_animators_AnimatorBase.__name__ = "away3d.animators.AnimatorBase";
away3d_animators_AnimatorBase.__interfaces__ = [away3d_library_assets_IAsset];
away3d_animators_AnimatorBase.__super__ = away3d_library_assets_NamedAssetBase;
away3d_animators_AnimatorBase.prototype = $extend(away3d_library_assets_NamedAssetBase.prototype,{
	_broadcaster: null
	,_isPlaying: null
	,_autoUpdate: null
	,_startEvent: null
	,_stopEvent: null
	,_cycleEvent: null
	,_time: null
	,_playbackSpeed: null
	,_animationSet: null
	,_owners: null
	,_activeNode: null
	,_activeState: null
	,_activeAnimationName: null
	,_absoluteTime: null
	,_animationStates: null
	,updatePosition: null
	,getAnimationState: function(node) {
		var stateConstructor = node.get_stateConstructor();
		if(this._animationStates.h.__keys__[node.__id__] == null) {
			this._animationStates.set(node,stateConstructor(js_Boot.__cast(this , away3d_animators_IAnimator),node));
		}
		return this._animationStates.h[node.__id__];
	}
	,getAnimationStateByName: function(name) {
		return this.getAnimationState(this._animationSet.getAnimation(name));
	}
	,get_absoluteTime: function() {
		return this._absoluteTime;
	}
	,get_animationSet: function() {
		return this._animationSet;
	}
	,get_activeState: function() {
		return this._activeState;
	}
	,get_activeAnimation: function() {
		return this._animationSet.getAnimation(this._activeAnimationName);
	}
	,get_activeAnimationName: function() {
		return this._activeAnimationName;
	}
	,get_autoUpdate: function() {
		return this._autoUpdate;
	}
	,set_autoUpdate: function(value) {
		if(this._autoUpdate == value) {
			return value;
		}
		this._autoUpdate = value;
		if(this._autoUpdate) {
			this.start();
		} else {
			this.stop();
		}
		return value;
	}
	,get_time: function() {
		return this._time;
	}
	,set_time: function(value) {
		if(this._time == value) {
			return value;
		}
		this.update(value);
		return value;
	}
	,phase: function(value) {
		this._activeState.phase(value);
	}
	,get_playbackSpeed: function() {
		return this._playbackSpeed;
	}
	,set_playbackSpeed: function(value) {
		this._playbackSpeed = value;
		return value;
	}
	,start: function() {
		if(this._isPlaying || !this._autoUpdate) {
			return;
		}
		this._time = this._absoluteTime = openfl_Lib.getTimer();
		this._isPlaying = true;
		if(!this._broadcaster.hasEventListener("enterFrame")) {
			this._broadcaster.addEventListener("enterFrame",$bind(this,this.onEnterFrame));
		}
		if(!this.hasEventListener("start")) {
			return;
		}
		if(this._startEvent == null) {
			this._startEvent = new away3d_events_AnimatorEvent("start",this);
		}
		this.dispatchEvent(this._startEvent);
	}
	,stop: function() {
		if(!this._isPlaying) {
			return;
		}
		this._isPlaying = false;
		if(this._broadcaster.hasEventListener("enterFrame")) {
			this._broadcaster.removeEventListener("enterFrame",$bind(this,this.onEnterFrame));
		}
		if(!this.hasEventListener("stop")) {
			return;
		}
		if(this._stopEvent == null) {
			this._startEvent = this._stopEvent = new away3d_events_AnimatorEvent("stop",this);
		}
		this.dispatchEvent(this._stopEvent);
	}
	,update: function(time) {
		var dt = (time - this._time) * this.get_playbackSpeed() | 0;
		this.updateDeltaTime(dt);
		this._time = time;
	}
	,reset: function(name,offset) {
		if(offset == null) {
			offset = 0;
		}
		this.getAnimationState(this._animationSet.getAnimation(name)).offset(offset + this._absoluteTime);
	}
	,addOwner: function(mesh) {
		this._owners.push(mesh);
	}
	,removeOwner: function(mesh) {
		this._owners.splice(this._owners.indexOf(mesh,0),1);
	}
	,updateDeltaTime: function(dt) {
		this._absoluteTime += dt;
		this._activeState.update(this._absoluteTime);
		if(this.updatePosition) {
			this.applyPositionDelta();
		}
	}
	,onEnterFrame: function(event) {
		this.update(openfl_Lib.getTimer());
	}
	,applyPositionDelta: function() {
		var delta = this._activeState.get_positionDelta();
		var dist = delta.get_length();
		var len;
		if(dist > 0) {
			len = this._owners.get_length();
			var _g = 0;
			var _g1 = len;
			while(_g < _g1) {
				var i = _g++;
				this._owners.get(i).translateLocal(delta,dist);
			}
		}
	}
	,dispatchCycleEvent: function() {
		if(this.hasEventListener("cycle_complete")) {
			if(this._cycleEvent == null) {
				this._cycleEvent = new away3d_events_AnimatorEvent("cycle_complete",this);
			}
			this.dispatchEvent(this._cycleEvent);
		}
	}
	,dispose: function() {
	}
	,get_assetType: function() {
		return "animator";
	}
	,__class__: away3d_animators_AnimatorBase
	,__properties__: $extend(away3d_library_assets_NamedAssetBase.prototype.__properties__,{get_assetType:"get_assetType",set_playbackSpeed:"set_playbackSpeed",get_playbackSpeed:"get_playbackSpeed",set_time:"set_time",get_time:"get_time",set_autoUpdate:"set_autoUpdate",get_autoUpdate:"get_autoUpdate",get_activeAnimationName:"get_activeAnimationName",get_activeAnimation:"get_activeAnimation",get_activeState:"get_activeState",get_animationSet:"get_animationSet",get_absoluteTime:"get_absoluteTime"})
});
var away3d_animators_IAnimationSet = function() { };
$hxClasses["away3d.animators.IAnimationSet"] = away3d_animators_IAnimationSet;
away3d_animators_IAnimationSet.__name__ = "away3d.animators.IAnimationSet";
away3d_animators_IAnimationSet.__isInterface__ = true;
away3d_animators_IAnimationSet.prototype = {
	get_usesCPU: null
	,hasAnimation: null
	,getAnimation: null
	,resetGPUCompatibility: null
	,cancelGPUCompatibility: null
	,getAGALVertexCode: null
	,getAGALFragmentCode: null
	,getAGALUVCode: null
	,doneAGALCode: null
	,activate: null
	,deactivate: null
	,__class__: away3d_animators_IAnimationSet
	,__properties__: {get_usesCPU:"get_usesCPU"}
};
var away3d_animators_IAnimator = function() { };
$hxClasses["away3d.animators.IAnimator"] = away3d_animators_IAnimator;
away3d_animators_IAnimator.__name__ = "away3d.animators.IAnimator";
away3d_animators_IAnimator.__isInterface__ = true;
away3d_animators_IAnimator.prototype = {
	get_animationSet: null
	,setRenderState: null
	,testGPUCompatibility: null
	,addOwner: null
	,removeOwner: null
	,getAnimationState: null
	,getAnimationStateByName: null
	,clone: null
	,dispose: null
	,__class__: away3d_animators_IAnimator
	,__properties__: {get_animationSet:"get_animationSet"}
};
var away3d_materials_compilation_ShaderRegisterCache = function(profile) {
	this._profile = profile;
};
$hxClasses["away3d.materials.compilation.ShaderRegisterCache"] = away3d_materials_compilation_ShaderRegisterCache;
away3d_materials_compilation_ShaderRegisterCache.__name__ = "away3d.materials.compilation.ShaderRegisterCache";
away3d_materials_compilation_ShaderRegisterCache.prototype = {
	_fragmentTempCache: null
	,_vertexTempCache: null
	,_varyingCache: null
	,_fragmentConstantsCache: null
	,_vertexConstantsCache: null
	,_textureCache: null
	,_vertexAttributesCache: null
	,_vertexConstantOffset: null
	,_vertexAttributesOffset: null
	,_varyingsOffset: null
	,_fragmentConstantOffset: null
	,_fragmentOutputRegister: null
	,_vertexOutputRegister: null
	,_numUsedVertexConstants: null
	,_numUsedFragmentConstants: null
	,_numUsedStreams: null
	,_numUsedTextures: null
	,_numUsedVaryings: null
	,_profile: null
	,reset: function() {
		this._fragmentTempCache = new away3d_materials_compilation_RegisterPool("ft",8,false);
		this._vertexTempCache = new away3d_materials_compilation_RegisterPool("vt",8,false);
		this._varyingCache = new away3d_materials_compilation_RegisterPool("v",8);
		this._textureCache = new away3d_materials_compilation_RegisterPool("fs",8);
		this._vertexAttributesCache = new away3d_materials_compilation_RegisterPool("va",8);
		this._fragmentConstantsCache = new away3d_materials_compilation_RegisterPool("fc",28);
		this._vertexConstantsCache = new away3d_materials_compilation_RegisterPool("vc",128);
		this._fragmentOutputRegister = new away3d_materials_compilation_ShaderRegisterElement("oc",-1);
		this._vertexOutputRegister = new away3d_materials_compilation_ShaderRegisterElement("op",-1);
		this._numUsedVertexConstants = 0;
		this._numUsedStreams = 0;
		this._numUsedTextures = 0;
		this._numUsedVaryings = 0;
		this._numUsedFragmentConstants = 0;
		var _g = 0;
		var _g1 = this._vertexAttributesOffset;
		while(_g < _g1) {
			var i = _g++;
			this.getFreeVertexAttribute();
		}
		var _g2 = 0;
		var _g3 = this._vertexConstantOffset;
		while(_g2 < _g3) {
			var i1 = _g2++;
			this.getFreeVertexConstant();
		}
		var _g4 = 0;
		var _g5 = this._varyingsOffset;
		while(_g4 < _g5) {
			var i2 = _g4++;
			this.getFreeVarying();
		}
		var _g6 = 0;
		var _g7 = this._fragmentConstantOffset;
		while(_g6 < _g7) {
			var i3 = _g6++;
			this.getFreeFragmentConstant();
		}
	}
	,dispose: function() {
		this._fragmentTempCache.dispose();
		this._vertexTempCache.dispose();
		this._varyingCache.dispose();
		this._fragmentConstantsCache.dispose();
		this._vertexAttributesCache.dispose();
		this._fragmentTempCache = null;
		this._vertexTempCache = null;
		this._varyingCache = null;
		this._fragmentConstantsCache = null;
		this._vertexAttributesCache = null;
		this._fragmentOutputRegister = null;
		this._vertexOutputRegister = null;
	}
	,addFragmentTempUsages: function(register,usageCount) {
		this._fragmentTempCache.addUsage(register,usageCount);
	}
	,removeFragmentTempUsage: function(register) {
		this._fragmentTempCache.removeUsage(register);
	}
	,addVertexTempUsages: function(register,usageCount) {
		this._vertexTempCache.addUsage(register,usageCount);
	}
	,removeVertexTempUsage: function(register) {
		this._vertexTempCache.removeUsage(register);
	}
	,getFreeFragmentVectorTemp: function() {
		return this._fragmentTempCache.requestFreeVectorReg();
	}
	,getFreeFragmentSingleTemp: function() {
		return this._fragmentTempCache.requestFreeRegComponent();
	}
	,getFreeVarying: function() {
		var result = this._varyingCache.requestFreeVectorReg();
		++this._numUsedVaryings;
		return result;
	}
	,getFreeFragmentConstant: function() {
		var result = this._fragmentConstantsCache.requestFreeVectorReg();
		++this._numUsedFragmentConstants;
		return result;
	}
	,getFreeVertexConstant: function() {
		var result = this._vertexConstantsCache.requestFreeVectorReg();
		++this._numUsedVertexConstants;
		return result;
	}
	,getFreeVertexVectorTemp: function() {
		return this._vertexTempCache.requestFreeVectorReg();
	}
	,getFreeVertexSingleTemp: function() {
		return this._vertexTempCache.requestFreeRegComponent();
	}
	,getFreeVertexAttribute: function() {
		var result = this._vertexAttributesCache.requestFreeVectorReg();
		++this._numUsedStreams;
		return result;
	}
	,getFreeTextureReg: function() {
		var result = this._textureCache.requestFreeVectorReg();
		++this._numUsedTextures;
		return result;
	}
	,get_vertexConstantOffset: function() {
		return this._vertexConstantOffset;
	}
	,set_vertexConstantOffset: function(vertexConstantOffset) {
		this._vertexConstantOffset = vertexConstantOffset;
		return vertexConstantOffset;
	}
	,get_vertexAttributesOffset: function() {
		return this._vertexAttributesOffset;
	}
	,set_vertexAttributesOffset: function(value) {
		this._vertexAttributesOffset = value;
		return value;
	}
	,get_varyingsOffset: function() {
		return this._varyingsOffset;
	}
	,set_varyingsOffset: function(value) {
		this._varyingsOffset = value;
		return value;
	}
	,get_fragmentConstantOffset: function() {
		return this._fragmentConstantOffset;
	}
	,set_fragmentConstantOffset: function(value) {
		this._fragmentConstantOffset = value;
		return value;
	}
	,get_fragmentOutputRegister: function() {
		return this._fragmentOutputRegister;
	}
	,get_numUsedVertexConstants: function() {
		return this._numUsedVertexConstants;
	}
	,get_numUsedFragmentConstants: function() {
		return this._numUsedFragmentConstants;
	}
	,get_numUsedStreams: function() {
		return this._numUsedStreams;
	}
	,get_numUsedTextures: function() {
		return this._numUsedTextures;
	}
	,get_numUsedVaryings: function() {
		return this._numUsedVaryings;
	}
	,__class__: away3d_materials_compilation_ShaderRegisterCache
	,__properties__: {get_numUsedVaryings:"get_numUsedVaryings",get_numUsedTextures:"get_numUsedTextures",get_numUsedStreams:"get_numUsedStreams",get_numUsedFragmentConstants:"get_numUsedFragmentConstants",get_numUsedVertexConstants:"get_numUsedVertexConstants",get_fragmentOutputRegister:"get_fragmentOutputRegister",set_fragmentConstantOffset:"set_fragmentConstantOffset",get_fragmentConstantOffset:"get_fragmentConstantOffset",set_varyingsOffset:"set_varyingsOffset",get_varyingsOffset:"get_varyingsOffset",set_vertexAttributesOffset:"set_vertexAttributesOffset",get_vertexAttributesOffset:"get_vertexAttributesOffset",set_vertexConstantOffset:"set_vertexConstantOffset",get_vertexConstantOffset:"get_vertexConstantOffset"}
};
var away3d_animators_data_AnimationRegisterCache = function(profile) {
	this.fragmentConstantData = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
	this.vertexConstantData = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
	this.indexDictionary = new haxe_ds_ObjectMap();
	away3d_materials_compilation_ShaderRegisterCache.call(this,profile);
};
$hxClasses["away3d.animators.data.AnimationRegisterCache"] = away3d_animators_data_AnimationRegisterCache;
away3d_animators_data_AnimationRegisterCache.__name__ = "away3d.animators.data.AnimationRegisterCache";
away3d_animators_data_AnimationRegisterCache.__super__ = away3d_materials_compilation_ShaderRegisterCache;
away3d_animators_data_AnimationRegisterCache.prototype = $extend(away3d_materials_compilation_ShaderRegisterCache.prototype,{
	positionAttribute: null
	,uvAttribute: null
	,positionTarget: null
	,scaleAndRotateTarget: null
	,velocityTarget: null
	,vertexTime: null
	,vertexLife: null
	,vertexZeroConst: null
	,vertexOneConst: null
	,vertexTwoConst: null
	,uvTarget: null
	,colorAddTarget: null
	,colorMulTarget: null
	,colorAddVary: null
	,colorMulVary: null
	,uvVar: null
	,rotationRegisters: null
	,needFragmentAnimation: null
	,needUVAnimation: null
	,sourceRegisters: null
	,targetRegisters: null
	,indexDictionary: null
	,hasUVNode: null
	,needVelocity: null
	,hasBillboard: null
	,hasColorMulNode: null
	,hasColorAddNode: null
	,reset: function() {
		away3d_materials_compilation_ShaderRegisterCache.prototype.reset.call(this);
		this.rotationRegisters = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		this.positionAttribute = this.getRegisterFromString(this.sourceRegisters.get(0));
		this.scaleAndRotateTarget = this.getRegisterFromString(this.targetRegisters.get(0));
		this.addVertexTempUsages(this.scaleAndRotateTarget,1);
		var _g = 1;
		var _g1 = this.targetRegisters.get_length();
		while(_g < _g1) {
			var i = _g++;
			this.rotationRegisters.push(this.getRegisterFromString(this.targetRegisters.get(i)));
			this.addVertexTempUsages(this.rotationRegisters.get(i - 1),1);
		}
		this.scaleAndRotateTarget = new away3d_materials_compilation_ShaderRegisterElement(this.scaleAndRotateTarget.get_regName(),this.scaleAndRotateTarget.get_index());
		this.vertexZeroConst = this.getFreeVertexConstant();
		this.vertexZeroConst = new away3d_materials_compilation_ShaderRegisterElement(this.vertexZeroConst.get_regName(),this.vertexZeroConst.get_index(),0);
		this.vertexOneConst = new away3d_materials_compilation_ShaderRegisterElement(this.vertexZeroConst.get_regName(),this.vertexZeroConst.get_index(),1);
		this.vertexTwoConst = new away3d_materials_compilation_ShaderRegisterElement(this.vertexZeroConst.get_regName(),this.vertexZeroConst.get_index(),2);
		this.positionTarget = this.getFreeVertexVectorTemp();
		this.addVertexTempUsages(this.positionTarget,1);
		this.positionTarget = new away3d_materials_compilation_ShaderRegisterElement(this.positionTarget.get_regName(),this.positionTarget.get_index());
		if(this.needVelocity) {
			this.velocityTarget = this.getFreeVertexVectorTemp();
			this.addVertexTempUsages(this.velocityTarget,1);
			this.velocityTarget = new away3d_materials_compilation_ShaderRegisterElement(this.velocityTarget.get_regName(),this.velocityTarget.get_index());
			this.vertexTime = new away3d_materials_compilation_ShaderRegisterElement(this.velocityTarget.get_regName(),this.velocityTarget.get_index(),3);
			this.vertexLife = new away3d_materials_compilation_ShaderRegisterElement(this.positionTarget.get_regName(),this.positionTarget.get_index(),3);
		} else {
			var tempTime = this.getFreeVertexVectorTemp();
			this.addVertexTempUsages(tempTime,1);
			this.vertexTime = new away3d_materials_compilation_ShaderRegisterElement(tempTime.get_regName(),tempTime.get_index(),0);
			this.vertexLife = new away3d_materials_compilation_ShaderRegisterElement(tempTime.get_regName(),tempTime.get_index(),1);
		}
	}
	,setUVSourceAndTarget: function(UVAttribute,UVVaring) {
		this.uvVar = this.getRegisterFromString(UVVaring);
		this.uvAttribute = this.getRegisterFromString(UVAttribute);
		this.uvTarget = new away3d_materials_compilation_ShaderRegisterElement(this.positionTarget.get_regName(),this.positionTarget.get_index());
	}
	,setRegisterIndex: function(node,parameterIndex,registerIndex) {
		var t = this.indexDictionary.h.__keys__[node.__id__] != null ? this.indexDictionary.h[node.__id__] : openfl__$Vector_Vector_$Impl_$.toIntVector(null,8,true);
		t.set(parameterIndex,registerIndex);
		this.indexDictionary.set(node,t);
	}
	,getRegisterIndex: function(node,parameterIndex) {
		return this.indexDictionary.h[node.__id__].get(parameterIndex);
	}
	,getInitCode: function() {
		var len = this.sourceRegisters.get_length();
		var code = "";
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			code += "mov " + this.targetRegisters.get(i) + "," + this.sourceRegisters.get(i) + "\n";
		}
		code += "mov " + Std.string(this.positionTarget) + ".xyz," + this.vertexZeroConst.toString() + "\n";
		if(this.needVelocity) {
			code += "mov " + Std.string(this.velocityTarget) + ".xyz," + this.vertexZeroConst.toString() + "\n";
		}
		return code;
	}
	,getCombinationCode: function() {
		return "add " + Std.string(this.scaleAndRotateTarget) + ".xyz," + Std.string(this.scaleAndRotateTarget) + ".xyz," + Std.string(this.positionTarget) + ".xyz\n";
	}
	,initColorRegisters: function() {
		var code = "";
		if(this.hasColorMulNode) {
			this.colorMulTarget = this.getFreeVertexVectorTemp();
			this.addVertexTempUsages(this.colorMulTarget,1);
			this.colorMulVary = this.getFreeVarying();
			code += "mov " + Std.string(this.colorMulTarget) + "," + Std.string(this.vertexOneConst) + "\n";
		}
		if(this.hasColorAddNode) {
			this.colorAddTarget = this.getFreeVertexVectorTemp();
			this.addVertexTempUsages(this.colorAddTarget,1);
			this.colorAddVary = this.getFreeVarying();
			code += "mov " + Std.string(this.colorAddTarget) + "," + Std.string(this.vertexZeroConst) + "\n";
		}
		return code;
	}
	,getColorPassCode: function() {
		var code = "";
		if(this.needFragmentAnimation && (this.hasColorAddNode || this.hasColorMulNode)) {
			if(this.hasColorMulNode) {
				code += "mov " + Std.string(this.colorMulVary) + "," + Std.string(this.colorMulTarget) + "\n";
			}
			if(this.hasColorAddNode) {
				code += "mov " + Std.string(this.colorAddVary) + "," + Std.string(this.colorAddTarget) + "\n";
			}
		}
		return code;
	}
	,getColorCombinationCode: function(shadedTarget) {
		var code = "";
		if(this.needFragmentAnimation && (this.hasColorAddNode || this.hasColorMulNode)) {
			var colorTarget = this.getRegisterFromString(shadedTarget);
			this.addFragmentTempUsages(colorTarget,1);
			if(this.hasColorMulNode) {
				code += "mul " + Std.string(colorTarget) + "," + Std.string(colorTarget) + "," + Std.string(this.colorMulVary) + "\n";
			}
			if(this.hasColorAddNode) {
				code += "add " + Std.string(colorTarget) + "," + Std.string(colorTarget) + "," + Std.string(this.colorAddVary) + "\n";
			}
		}
		return code;
	}
	,getRegisterFromString: function(code) {
		var ereg = new EReg("([a-z]+)([\\d]+)","");
		ereg.match(code);
		return new away3d_materials_compilation_ShaderRegisterElement(ereg.matched(1),Std.parseInt(ereg.matched(2)));
	}
	,vertexConstantData: null
	,fragmentConstantData: null
	,_numVertexConstant: null
	,_numFragmentConstant: null
	,get_numVertexConstant: function() {
		return this._numVertexConstant;
	}
	,get_numFragmentConstant: function() {
		return this._numFragmentConstant;
	}
	,setDataLength: function() {
		this._numVertexConstant = this._numUsedVertexConstants - this._vertexConstantOffset;
		this._numFragmentConstant = this._numUsedFragmentConstants - this._fragmentConstantOffset;
		this.vertexConstantData.set_length(this._numVertexConstant * 4);
		this.fragmentConstantData.set_length(this._numFragmentConstant * 4);
	}
	,setVertexConst: function(index,x,y,z,w) {
		if(w == null) {
			w = 0;
		}
		if(z == null) {
			z = 0;
		}
		if(y == null) {
			y = 0;
		}
		if(x == null) {
			x = 0;
		}
		var _index = (index - this._vertexConstantOffset) * 4;
		this.vertexConstantData.set(_index++,x);
		this.vertexConstantData.set(_index++,y);
		this.vertexConstantData.set(_index++,z);
		this.vertexConstantData.set(_index,w);
	}
	,setVertexConstFromVector: function(index,data) {
		var _index = (index - this._vertexConstantOffset) * 4;
		var _g = 0;
		var _g1 = data.get_length();
		while(_g < _g1) {
			var i = _g++;
			this.vertexConstantData.set(_index++,data.get(i));
		}
	}
	,setVertexConstFromMatrix: function(index,matrix) {
		var rawData = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
		matrix.copyRawDataTo(rawData);
		var _index = (index - this._vertexConstantOffset) * 4;
		this.vertexConstantData.set(_index++,rawData.get(0));
		this.vertexConstantData.set(_index++,rawData.get(4));
		this.vertexConstantData.set(_index++,rawData.get(8));
		this.vertexConstantData.set(_index++,rawData.get(12));
		this.vertexConstantData.set(_index++,rawData.get(1));
		this.vertexConstantData.set(_index++,rawData.get(5));
		this.vertexConstantData.set(_index++,rawData.get(9));
		this.vertexConstantData.set(_index++,rawData.get(13));
		this.vertexConstantData.set(_index++,rawData.get(2));
		this.vertexConstantData.set(_index++,rawData.get(6));
		this.vertexConstantData.set(_index++,rawData.get(10));
		this.vertexConstantData.set(_index++,rawData.get(14));
		this.vertexConstantData.set(_index++,rawData.get(3));
		this.vertexConstantData.set(_index++,rawData.get(7));
		this.vertexConstantData.set(_index++,rawData.get(11));
		this.vertexConstantData.set(_index,rawData.get(15));
	}
	,setFragmentConst: function(index,x,y,z,w) {
		if(w == null) {
			w = 0;
		}
		if(z == null) {
			z = 0;
		}
		if(y == null) {
			y = 0;
		}
		if(x == null) {
			x = 0;
		}
		var _index = (index - this._fragmentConstantOffset) * 4;
		this.fragmentConstantData.set(_index++,x);
		this.fragmentConstantData.set(_index++,y);
		this.fragmentConstantData.set(_index++,z);
		this.fragmentConstantData.set(_index,w);
	}
	,__class__: away3d_animators_data_AnimationRegisterCache
	,__properties__: $extend(away3d_materials_compilation_ShaderRegisterCache.prototype.__properties__,{get_numFragmentConstant:"get_numFragmentConstant",get_numVertexConstant:"get_numVertexConstant"})
});
var away3d_animators_data_AnimationSubGeometry = function() {
	this.animationParticles = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this.previousTime = -Infinity;
	this.numProcessedVertices = 0;
	this._bufferDirty = openfl__$Vector_Vector_$Impl_$.toBoolVector(null,8);
	this._bufferContext = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._vertexBuffer = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._bufferDirty.set(0,true);
	this._bufferDirty.set(1,true);
	this._bufferDirty.set(2,true);
	this._bufferDirty.set(3,true);
	this._bufferDirty.set(4,true);
	this._bufferDirty.set(5,true);
	this._bufferDirty.set(6,true);
	this._bufferDirty.set(7,true);
};
$hxClasses["away3d.animators.data.AnimationSubGeometry"] = away3d_animators_data_AnimationSubGeometry;
away3d_animators_data_AnimationSubGeometry.__name__ = "away3d.animators.data.AnimationSubGeometry";
away3d_animators_data_AnimationSubGeometry.prototype = {
	_vertexData: null
	,_vertexBuffer: null
	,_bufferContext: null
	,_bufferDirty: null
	,_numVertices: null
	,_totalLenOfOneVertex: null
	,numProcessedVertices: null
	,previousTime: null
	,animationParticles: null
	,createVertexData: function(numVertices,totalLenOfOneVertex) {
		this._numVertices = numVertices;
		this._totalLenOfOneVertex = totalLenOfOneVertex;
		this._vertexData = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,numVertices * totalLenOfOneVertex);
	}
	,activateVertexBuffer: function(index,bufferOffset,stage3DProxy,format) {
		var contextIndex = stage3DProxy.get_stage3DIndex();
		var context = stage3DProxy.get_context3D();
		var buffer = this._vertexBuffer.get(contextIndex);
		if(buffer == null || this._bufferContext.get(contextIndex) != context) {
			buffer = this._vertexBuffer.set(contextIndex,context.createVertexBuffer(this._numVertices,this._totalLenOfOneVertex));
			this._bufferContext.set(contextIndex,context);
			this._bufferDirty.set(contextIndex,true);
		}
		if(this._bufferDirty.get(contextIndex)) {
			buffer.uploadFromVector(this._vertexData,0,this._numVertices);
			this._bufferDirty.set(contextIndex,false);
		}
		context.setVertexBufferAt(index,buffer,bufferOffset,format);
	}
	,dispose: function() {
		while(this._vertexBuffer.get_length() > 0) {
			var vertexBuffer = this._vertexBuffer.pop();
			if(vertexBuffer != null) {
				vertexBuffer.dispose();
			}
		}
	}
	,invalidateBuffer: function() {
		this._bufferDirty.set(0,true);
		this._bufferDirty.set(1,true);
		this._bufferDirty.set(2,true);
		this._bufferDirty.set(3,true);
		this._bufferDirty.set(4,true);
		this._bufferDirty.set(5,true);
		this._bufferDirty.set(6,true);
		this._bufferDirty.set(7,true);
	}
	,get_vertexData: function() {
		return this._vertexData;
	}
	,get_numVertices: function() {
		return this._numVertices;
	}
	,get_totalLenOfOneVertex: function() {
		return this._totalLenOfOneVertex;
	}
	,__class__: away3d_animators_data_AnimationSubGeometry
	,__properties__: {get_totalLenOfOneVertex:"get_totalLenOfOneVertex",get_numVertices:"get_numVertices",get_vertexData:"get_vertexData"}
};
var away3d_animators_data_ParticleAnimationData = function(index,startTime,duration,delay,particle) {
	this.index = index;
	this.startTime = startTime;
	this.totalTime = duration + delay;
	this.duration = duration;
	this.delay = delay;
	this.startVertexIndex = particle.startVertexIndex;
	this.numVertices = particle.numVertices;
};
$hxClasses["away3d.animators.data.ParticleAnimationData"] = away3d_animators_data_ParticleAnimationData;
away3d_animators_data_ParticleAnimationData.__name__ = "away3d.animators.data.ParticleAnimationData";
away3d_animators_data_ParticleAnimationData.prototype = {
	index: null
	,startTime: null
	,totalTime: null
	,duration: null
	,delay: null
	,startVertexIndex: null
	,numVertices: null
	,__class__: away3d_animators_data_ParticleAnimationData
};
var away3d_animators_nodes_AnimationNodeBase = function() {
	away3d_library_assets_NamedAssetBase.call(this);
};
$hxClasses["away3d.animators.nodes.AnimationNodeBase"] = away3d_animators_nodes_AnimationNodeBase;
away3d_animators_nodes_AnimationNodeBase.__name__ = "away3d.animators.nodes.AnimationNodeBase";
away3d_animators_nodes_AnimationNodeBase.__interfaces__ = [away3d_library_assets_IAsset];
away3d_animators_nodes_AnimationNodeBase.__super__ = away3d_library_assets_NamedAssetBase;
away3d_animators_nodes_AnimationNodeBase.prototype = $extend(away3d_library_assets_NamedAssetBase.prototype,{
	_stateConstructor: null
	,get_stateConstructor: function() {
		return this._stateConstructor;
	}
	,dispose: function() {
	}
	,get_assetType: function() {
		return "animationNode";
	}
	,__class__: away3d_animators_nodes_AnimationNodeBase
	,__properties__: $extend(away3d_library_assets_NamedAssetBase.prototype.__properties__,{get_assetType:"get_assetType",get_stateConstructor:"get_stateConstructor"})
});
var away3d_animators_states_IAnimationState = function() { };
$hxClasses["away3d.animators.states.IAnimationState"] = away3d_animators_states_IAnimationState;
away3d_animators_states_IAnimationState.__name__ = "away3d.animators.states.IAnimationState";
away3d_animators_states_IAnimationState.__isInterface__ = true;
away3d_animators_states_IAnimationState.prototype = {
	get_positionDelta: null
	,offset: null
	,update: null
	,phase: null
	,__class__: away3d_animators_states_IAnimationState
	,__properties__: {get_positionDelta:"get_positionDelta"}
};
var away3d_bounds_BoundingVolumeBase = function() {
	this._aabbPointsDirty = true;
	this._aabbPoints = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
	this._min = new openfl_geom_Vector3D();
	this._max = new openfl_geom_Vector3D();
};
$hxClasses["away3d.bounds.BoundingVolumeBase"] = away3d_bounds_BoundingVolumeBase;
away3d_bounds_BoundingVolumeBase.__name__ = "away3d.bounds.BoundingVolumeBase";
away3d_bounds_BoundingVolumeBase.prototype = {
	_min: null
	,_max: null
	,_aabbPoints: null
	,_aabbPointsDirty: null
	,_boundingRenderable: null
	,get_max: function() {
		return this._max;
	}
	,get_min: function() {
		return this._min;
	}
	,get_aabbPoints: function() {
		if(this._aabbPointsDirty) {
			this.updateAABBPoints();
		}
		return this._aabbPoints;
	}
	,get_boundingRenderable: function() {
		if(this._boundingRenderable == null) {
			this._boundingRenderable = this.createBoundingRenderable();
			this.updateBoundingRenderable();
		}
		return this._boundingRenderable;
	}
	,nullify: function() {
		this._min.x = this._min.y = this._min.z = 0;
		this._max.x = this._max.y = this._max.z = 0;
		this._aabbPointsDirty = true;
		if(this._boundingRenderable != null) {
			this.updateBoundingRenderable();
		}
	}
	,disposeRenderable: function() {
		if(this._boundingRenderable != null) {
			this._boundingRenderable.dispose();
		}
		this._boundingRenderable = null;
	}
	,fromVertices: function(vertices) {
		var i = 0;
		var len = vertices.get_length();
		if(len == 0) {
			this.nullify();
			return;
		}
		var v;
		var maxX = vertices.get(i++);
		var minX = maxX;
		var maxY = vertices.get(i++);
		var minY = maxY;
		var maxZ = vertices.get(i++);
		var minZ = maxZ;
		while(i < len) {
			v = vertices.get(i++);
			if(v < minX) {
				minX = v;
			} else if(v > maxX) {
				maxX = v;
			}
			v = vertices.get(i++);
			if(v < minY) {
				minY = v;
			} else if(v > maxY) {
				maxY = v;
			}
			v = vertices.get(i++);
			if(v < minZ) {
				minZ = v;
			} else if(v > maxZ) {
				maxZ = v;
			}
		}
		this.fromExtremes(minX,minY,minZ,maxX,maxY,maxZ);
	}
	,fromGeometry: function(geometry) {
		var subGeoms = geometry.get_subGeometries();
		var numSubGeoms = subGeoms.get_length();
		var minX;
		var minY;
		var minZ;
		var maxX;
		var maxY;
		var maxZ;
		if(numSubGeoms > 0) {
			var subGeom = subGeoms.get(0);
			var vertices = subGeom.get_vertexData();
			var i = subGeom.get_vertexOffset();
			maxX = vertices.get(i);
			minX = maxX;
			maxY = vertices.get(i + 1);
			minY = maxY;
			maxZ = vertices.get(i + 2);
			minZ = maxZ;
			var j = 0;
			while(j < numSubGeoms) {
				subGeom = subGeoms.get(j++);
				vertices = subGeom.get_vertexData();
				var vertexDataLen = vertices.get_length();
				i = subGeom.get_vertexOffset();
				var stride = subGeom.get_vertexStride();
				while(i < vertexDataLen) {
					var v = vertices.get(i);
					if(v < minX) {
						minX = v;
					} else if(v > maxX) {
						maxX = v;
					}
					v = vertices.get(i + 1);
					if(v < minY) {
						minY = v;
					} else if(v > maxY) {
						maxY = v;
					}
					v = vertices.get(i + 2);
					if(v < minZ) {
						minZ = v;
					} else if(v > maxZ) {
						maxZ = v;
					}
					i += stride;
				}
			}
			this.fromExtremes(minX,minY,minZ,maxX,maxY,maxZ);
		} else {
			this.fromExtremes(0,0,0,0,0,0);
		}
	}
	,fromSphere: function(center,radius) {
		this.fromExtremes(center.x - radius,center.y - radius,center.z - radius,center.x + radius,center.y + radius,center.z + radius);
	}
	,fromExtremes: function(minX,minY,minZ,maxX,maxY,maxZ) {
		this._min.x = minX;
		this._min.y = minY;
		this._min.z = minZ;
		this._max.x = maxX;
		this._max.y = maxY;
		this._max.z = maxZ;
		this._aabbPointsDirty = true;
		if(this._boundingRenderable != null) {
			this.updateBoundingRenderable();
		}
	}
	,isInFrustum: function(planes,numPlanes) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,overlaps: function(bounds) {
		var min = bounds._min;
		var max = bounds._max;
		if(this._max.x > min.x && this._min.x < max.x && this._max.y > min.y && this._min.y < max.y && this._max.z > min.z) {
			return this._min.z < max.z;
		} else {
			return false;
		}
	}
	,clone: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,rayIntersection: function(position,direction,targetNormal) {
		return -1;
	}
	,containsPoint: function(position) {
		return false;
	}
	,updateAABBPoints: function() {
		var maxX = this._max.x;
		var maxY = this._max.y;
		var maxZ = this._max.z;
		var minX = this._min.x;
		var minY = this._min.y;
		var minZ = this._min.z;
		this._aabbPoints.set(0,minX);
		this._aabbPoints.set(1,minY);
		this._aabbPoints.set(2,minZ);
		this._aabbPoints.set(3,maxX);
		this._aabbPoints.set(4,minY);
		this._aabbPoints.set(5,minZ);
		this._aabbPoints.set(6,minX);
		this._aabbPoints.set(7,maxY);
		this._aabbPoints.set(8,minZ);
		this._aabbPoints.set(9,maxX);
		this._aabbPoints.set(10,maxY);
		this._aabbPoints.set(11,minZ);
		this._aabbPoints.set(12,minX);
		this._aabbPoints.set(13,minY);
		this._aabbPoints.set(14,maxZ);
		this._aabbPoints.set(15,maxX);
		this._aabbPoints.set(16,minY);
		this._aabbPoints.set(17,maxZ);
		this._aabbPoints.set(18,minX);
		this._aabbPoints.set(19,maxY);
		this._aabbPoints.set(20,maxZ);
		this._aabbPoints.set(21,maxX);
		this._aabbPoints.set(22,maxY);
		this._aabbPoints.set(23,maxZ);
		this._aabbPointsDirty = false;
	}
	,updateBoundingRenderable: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,createBoundingRenderable: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,classifyToPlane: function(plane) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,transformFrom: function(bounds,matrix) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,__class__: away3d_bounds_BoundingVolumeBase
	,__properties__: {get_boundingRenderable:"get_boundingRenderable",get_aabbPoints:"get_aabbPoints",get_min:"get_min",get_max:"get_max"}
};
var away3d_bounds_AxisAlignedBoundingBox = function() {
	this._halfExtentsZ = 0;
	this._halfExtentsY = 0;
	this._halfExtentsX = 0;
	this._centerZ = 0;
	this._centerY = 0;
	this._centerX = 0;
	away3d_bounds_BoundingVolumeBase.call(this);
};
$hxClasses["away3d.bounds.AxisAlignedBoundingBox"] = away3d_bounds_AxisAlignedBoundingBox;
away3d_bounds_AxisAlignedBoundingBox.__name__ = "away3d.bounds.AxisAlignedBoundingBox";
away3d_bounds_AxisAlignedBoundingBox.__super__ = away3d_bounds_BoundingVolumeBase;
away3d_bounds_AxisAlignedBoundingBox.prototype = $extend(away3d_bounds_BoundingVolumeBase.prototype,{
	_centerX: null
	,_centerY: null
	,_centerZ: null
	,_halfExtentsX: null
	,_halfExtentsY: null
	,_halfExtentsZ: null
	,nullify: function() {
		away3d_bounds_BoundingVolumeBase.prototype.nullify.call(this);
		this._centerX = this._centerY = this._centerZ = 0;
		this._halfExtentsX = this._halfExtentsY = this._halfExtentsZ = 0;
	}
	,isInFrustum: function(planes,numPlanes) {
		var _g = 0;
		var _g1 = numPlanes;
		while(_g < _g1) {
			var i = _g++;
			var plane = planes.get(i);
			var a = plane.a;
			var b = plane.b;
			var c = plane.c;
			var flippedExtentX = a < 0 ? -this._halfExtentsX : this._halfExtentsX;
			var flippedExtentY = b < 0 ? -this._halfExtentsY : this._halfExtentsY;
			var flippedExtentZ = c < 0 ? -this._halfExtentsZ : this._halfExtentsZ;
			var projDist = a * (this._centerX + flippedExtentX) + b * (this._centerY + flippedExtentY) + c * (this._centerZ + flippedExtentZ) - plane.d;
			if(projDist < 0) {
				return false;
			}
		}
		return true;
	}
	,rayIntersection: function(position,direction,targetNormal) {
		if(this.containsPoint(position)) {
			return 0;
		}
		var px = position.x - this._centerX;
		var py = position.y - this._centerY;
		var pz = position.z - this._centerZ;
		var vx = direction.x;
		var vy = direction.y;
		var vz = direction.z;
		var ix;
		var iy;
		var iz;
		var rayEntryDistance = 0;
		var intersects = false;
		if(vx < 0) {
			rayEntryDistance = (this._halfExtentsX - px) / vx;
			if(rayEntryDistance > 0) {
				iy = py + rayEntryDistance * vy;
				iz = pz + rayEntryDistance * vz;
				if(iy > -this._halfExtentsY && iy < this._halfExtentsY && iz > -this._halfExtentsZ && iz < this._halfExtentsZ) {
					targetNormal.x = 1;
					targetNormal.y = 0;
					targetNormal.z = 0;
					intersects = true;
				}
			}
		}
		if(!intersects && vx > 0) {
			rayEntryDistance = (-this._halfExtentsX - px) / vx;
			if(rayEntryDistance > 0) {
				iy = py + rayEntryDistance * vy;
				iz = pz + rayEntryDistance * vz;
				if(iy > -this._halfExtentsY && iy < this._halfExtentsY && iz > -this._halfExtentsZ && iz < this._halfExtentsZ) {
					targetNormal.x = -1;
					targetNormal.y = 0;
					targetNormal.z = 0;
					intersects = true;
				}
			}
		}
		if(!intersects && vy < 0) {
			rayEntryDistance = (this._halfExtentsY - py) / vy;
			if(rayEntryDistance > 0) {
				ix = px + rayEntryDistance * vx;
				iz = pz + rayEntryDistance * vz;
				if(ix > -this._halfExtentsX && ix < this._halfExtentsX && iz > -this._halfExtentsZ && iz < this._halfExtentsZ) {
					targetNormal.x = 0;
					targetNormal.y = 1;
					targetNormal.z = 0;
					intersects = true;
				}
			}
		}
		if(!intersects && vy > 0) {
			rayEntryDistance = (-this._halfExtentsY - py) / vy;
			if(rayEntryDistance > 0) {
				ix = px + rayEntryDistance * vx;
				iz = pz + rayEntryDistance * vz;
				if(ix > -this._halfExtentsX && ix < this._halfExtentsX && iz > -this._halfExtentsZ && iz < this._halfExtentsZ) {
					targetNormal.x = 0;
					targetNormal.y = -1;
					targetNormal.z = 0;
					intersects = true;
				}
			}
		}
		if(!intersects && vz < 0) {
			rayEntryDistance = (this._halfExtentsZ - pz) / vz;
			if(rayEntryDistance > 0) {
				ix = px + rayEntryDistance * vx;
				iy = py + rayEntryDistance * vy;
				if(iy > -this._halfExtentsY && iy < this._halfExtentsY && ix > -this._halfExtentsX && ix < this._halfExtentsX) {
					targetNormal.x = 0;
					targetNormal.y = 0;
					targetNormal.z = 1;
					intersects = true;
				}
			}
		}
		if(!intersects && vz > 0) {
			rayEntryDistance = (-this._halfExtentsZ - pz) / vz;
			if(rayEntryDistance > 0) {
				ix = px + rayEntryDistance * vx;
				iy = py + rayEntryDistance * vy;
				if(iy > -this._halfExtentsY && iy < this._halfExtentsY && ix > -this._halfExtentsX && ix < this._halfExtentsX) {
					targetNormal.x = 0;
					targetNormal.y = 0;
					targetNormal.z = -1;
					intersects = true;
				}
			}
		}
		if(intersects) {
			return rayEntryDistance;
		} else {
			return -1;
		}
	}
	,containsPoint: function(position) {
		var px = position.x - this._centerX;
		var py = position.y - this._centerY;
		var pz = position.z - this._centerZ;
		if(px <= this._halfExtentsX && px >= -this._halfExtentsX && py <= this._halfExtentsY && py >= -this._halfExtentsY && pz <= this._halfExtentsZ) {
			return pz >= -this._halfExtentsZ;
		} else {
			return false;
		}
	}
	,fromExtremes: function(minX,minY,minZ,maxX,maxY,maxZ) {
		this._centerX = (maxX + minX) * .5;
		this._centerY = (maxY + minY) * .5;
		this._centerZ = (maxZ + minZ) * .5;
		this._halfExtentsX = (maxX - minX) * .5;
		this._halfExtentsY = (maxY - minY) * .5;
		this._halfExtentsZ = (maxZ - minZ) * .5;
		away3d_bounds_BoundingVolumeBase.prototype.fromExtremes.call(this,minX,minY,minZ,maxX,maxY,maxZ);
	}
	,clone: function() {
		var clone = new away3d_bounds_AxisAlignedBoundingBox();
		clone.fromExtremes(this._min.x,this._min.y,this._min.z,this._max.x,this._max.y,this._max.z);
		return clone;
	}
	,get_halfExtentsX: function() {
		return this._halfExtentsX;
	}
	,get_halfExtentsY: function() {
		return this._halfExtentsY;
	}
	,get_halfExtentsZ: function() {
		return this._halfExtentsZ;
	}
	,closestPointToPoint: function(point,target) {
		if(target == null) {
			target = new openfl_geom_Vector3D();
		}
		var p = point.x;
		if(p < this._min.x) {
			p = this._min.x;
		}
		if(p > this._max.x) {
			p = this._max.x;
		}
		target.x = p;
		p = point.y;
		if(p < this._min.y) {
			p = this._min.y;
		}
		if(p > this._max.y) {
			p = this._max.y;
		}
		target.y = p;
		p = point.z;
		if(p < this._min.z) {
			p = this._min.z;
		}
		if(p > this._max.z) {
			p = this._max.z;
		}
		target.z = p;
		return target;
	}
	,updateBoundingRenderable: function() {
		this._boundingRenderable.set_scaleX(Math.max(this._halfExtentsX * 2,0.001));
		this._boundingRenderable.set_scaleY(Math.max(this._halfExtentsY * 2,0.001));
		this._boundingRenderable.set_scaleZ(Math.max(this._halfExtentsZ * 2,0.001));
		this._boundingRenderable.set_x(this._centerX);
		this._boundingRenderable.set_y(this._centerY);
		this._boundingRenderable.set_z(this._centerZ);
	}
	,createBoundingRenderable: function() {
		return new away3d_primitives_WireframeCube(1,1,1,16777215,0.5);
	}
	,classifyToPlane: function(plane) {
		var a = plane.a;
		var b = plane.b;
		var c = plane.c;
		var centerDistance = a * this._centerX + b * this._centerY + c * this._centerZ - plane.d;
		if(a < 0) {
			a = -a;
		}
		if(b < 0) {
			b = -b;
		}
		if(c < 0) {
			c = -c;
		}
		var boundOffset = a * this._halfExtentsX + b * this._halfExtentsY + c * this._halfExtentsZ;
		if(centerDistance > boundOffset) {
			return 1;
		} else if(centerDistance < -boundOffset) {
			return 0;
		} else {
			return 2;
		}
	}
	,transformFrom: function(bounds,matrix) {
		var aabb = js_Boot.__cast(bounds , away3d_bounds_AxisAlignedBoundingBox);
		var cx = aabb._centerX;
		var cy = aabb._centerY;
		var cz = aabb._centerZ;
		var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
		matrix.copyRawDataTo(raw);
		var m11 = raw.get(0);
		var m12 = raw.get(4);
		var m13 = raw.get(8);
		var m14 = raw.get(12);
		var m21 = raw.get(1);
		var m22 = raw.get(5);
		var m23 = raw.get(9);
		var m24 = raw.get(13);
		var m31 = raw.get(2);
		var m32 = raw.get(6);
		var m33 = raw.get(10);
		var m34 = raw.get(14);
		this._centerX = cx * m11 + cy * m12 + cz * m13 + m14;
		this._centerY = cx * m21 + cy * m22 + cz * m23 + m24;
		this._centerZ = cx * m31 + cy * m32 + cz * m33 + m34;
		if(m11 < 0) {
			m11 = -m11;
		}
		if(m12 < 0) {
			m12 = -m12;
		}
		if(m13 < 0) {
			m13 = -m13;
		}
		if(m21 < 0) {
			m21 = -m21;
		}
		if(m22 < 0) {
			m22 = -m22;
		}
		if(m23 < 0) {
			m23 = -m23;
		}
		if(m31 < 0) {
			m31 = -m31;
		}
		if(m32 < 0) {
			m32 = -m32;
		}
		if(m33 < 0) {
			m33 = -m33;
		}
		var hx = aabb._halfExtentsX;
		var hy = aabb._halfExtentsY;
		var hz = aabb._halfExtentsZ;
		this._halfExtentsX = hx * m11 + hy * m12 + hz * m13;
		this._halfExtentsY = hx * m21 + hy * m22 + hz * m23;
		this._halfExtentsZ = hx * m31 + hy * m32 + hz * m33;
		this._min.x = this._centerX - this._halfExtentsX;
		this._min.y = this._centerY - this._halfExtentsY;
		this._min.z = this._centerZ - this._halfExtentsZ;
		this._max.x = this._centerX + this._halfExtentsX;
		this._max.y = this._centerY + this._halfExtentsY;
		this._max.z = this._centerZ + this._halfExtentsZ;
		this._aabbPointsDirty = true;
	}
	,__class__: away3d_bounds_AxisAlignedBoundingBox
	,__properties__: $extend(away3d_bounds_BoundingVolumeBase.prototype.__properties__,{get_halfExtentsZ:"get_halfExtentsZ",get_halfExtentsY:"get_halfExtentsY",get_halfExtentsX:"get_halfExtentsX"})
});
var away3d_bounds_BoundingSphere = function() {
	this._centerZ = 0;
	this._centerY = 0;
	this._centerX = 0;
	this._radius = 0;
	away3d_bounds_BoundingVolumeBase.call(this);
};
$hxClasses["away3d.bounds.BoundingSphere"] = away3d_bounds_BoundingSphere;
away3d_bounds_BoundingSphere.__name__ = "away3d.bounds.BoundingSphere";
away3d_bounds_BoundingSphere.__super__ = away3d_bounds_BoundingVolumeBase;
away3d_bounds_BoundingSphere.prototype = $extend(away3d_bounds_BoundingVolumeBase.prototype,{
	_radius: null
	,_centerX: null
	,_centerY: null
	,_centerZ: null
	,get_radius: function() {
		return this._radius;
	}
	,nullify: function() {
		away3d_bounds_BoundingVolumeBase.prototype.nullify.call(this);
		this._centerX = this._centerY = this._centerZ = 0;
		this._radius = 0;
	}
	,isInFrustum: function(planes,numPlanes) {
		var _g = 0;
		var _g1 = numPlanes;
		while(_g < _g1) {
			var i = _g++;
			var plane = planes.get(i);
			var flippedExtentX = plane.a < 0 ? -this._radius : this._radius;
			var flippedExtentY = plane.b < 0 ? -this._radius : this._radius;
			var flippedExtentZ = plane.c < 0 ? -this._radius : this._radius;
			var projDist = plane.a * (this._centerX + flippedExtentX) + plane.b * (this._centerY + flippedExtentY) + plane.c * (this._centerZ + flippedExtentZ) - plane.d;
			if(projDist < 0) {
				return false;
			}
		}
		return true;
	}
	,fromSphere: function(center,radius) {
		this._centerX = center.x;
		this._centerY = center.y;
		this._centerZ = center.z;
		this._radius = radius;
		this._max.x = this._centerX + radius;
		this._max.y = this._centerY + radius;
		this._max.z = this._centerZ + radius;
		this._min.x = this._centerX - radius;
		this._min.y = this._centerY - radius;
		this._min.z = this._centerZ - radius;
		this._aabbPointsDirty = true;
		if(this._boundingRenderable != null) {
			this.updateBoundingRenderable();
		}
	}
	,fromExtremes: function(minX,minY,minZ,maxX,maxY,maxZ) {
		this._centerX = (maxX + minX) * .5;
		this._centerY = (maxY + minY) * .5;
		this._centerZ = (maxZ + minZ) * .5;
		var d = maxX - minX;
		var y = maxY - minY;
		var z = maxZ - minZ;
		if(y > d) {
			d = y;
		}
		if(z > d) {
			d = z;
		}
		this._radius = d * Math.sqrt(.5);
		away3d_bounds_BoundingVolumeBase.prototype.fromExtremes.call(this,minX,minY,minZ,maxX,maxY,maxZ);
	}
	,clone: function() {
		var clone = new away3d_bounds_BoundingSphere();
		clone.fromSphere(new openfl_geom_Vector3D(this._centerX,this._centerY,this._centerZ),this._radius);
		return clone;
	}
	,rayIntersection: function(position,direction,targetNormal) {
		if(this.containsPoint(position)) {
			return 0;
		}
		var px = position.x - this._centerX;
		var py = position.y - this._centerY;
		var pz = position.z - this._centerZ;
		var vx = direction.x;
		var vy = direction.y;
		var vz = direction.z;
		var rayEntryDistance;
		var a = vx * vx + vy * vy + vz * vz;
		var b = 2 * (px * vx + py * vy + pz * vz);
		var c = px * px + py * py + pz * pz - this._radius * this._radius;
		var det = b * b - 4 * a * c;
		if(det >= 0) {
			var sqrtDet = Math.sqrt(det);
			rayEntryDistance = (-b - sqrtDet) / (2 * a);
			if(rayEntryDistance >= 0) {
				targetNormal.x = px + rayEntryDistance * vx;
				targetNormal.y = py + rayEntryDistance * vy;
				targetNormal.z = pz + rayEntryDistance * vz;
				targetNormal.normalize();
				return rayEntryDistance;
			}
		}
		return -1;
	}
	,containsPoint: function(position) {
		var px = position.x - this._centerX;
		var py = position.y - this._centerY;
		var pz = position.z - this._centerZ;
		var distance = Math.sqrt(px * px + py * py + pz * pz);
		return distance <= this._radius;
	}
	,updateBoundingRenderable: function() {
		var sc = this._radius;
		if(sc == 0) {
			sc = 0.001;
		}
		this._boundingRenderable.set_scaleX(sc);
		this._boundingRenderable.set_scaleY(sc);
		this._boundingRenderable.set_scaleZ(sc);
		this._boundingRenderable.set_x(this._centerX);
		this._boundingRenderable.set_y(this._centerY);
		this._boundingRenderable.set_z(this._centerZ);
	}
	,createBoundingRenderable: function() {
		return new away3d_primitives_WireframeSphere(1,16,12,16777215,0.5);
	}
	,classifyToPlane: function(plane) {
		var a = plane.a;
		var b = plane.b;
		var c = plane.c;
		var dd = a * this._centerX + b * this._centerY + c * this._centerZ - plane.d;
		if(a < 0) {
			a = -a;
		}
		if(b < 0) {
			b = -b;
		}
		if(c < 0) {
			c = -c;
		}
		var rr = (a + b + c) * this._radius;
		if(dd > rr) {
			return 1;
		} else if(dd < -rr) {
			return 0;
		} else {
			return 2;
		}
	}
	,transformFrom: function(bounds,matrix) {
		var sphere = js_Boot.__cast(bounds , away3d_bounds_BoundingSphere);
		var cx = sphere._centerX;
		var cy = sphere._centerY;
		var cz = sphere._centerZ;
		var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
		matrix.copyRawDataTo(raw);
		var m11 = raw.get(0);
		var m12 = raw.get(4);
		var m13 = raw.get(8);
		var m14 = raw.get(12);
		var m21 = raw.get(1);
		var m22 = raw.get(5);
		var m23 = raw.get(9);
		var m24 = raw.get(13);
		var m31 = raw.get(2);
		var m32 = raw.get(6);
		var m33 = raw.get(10);
		var m34 = raw.get(14);
		this._centerX = cx * m11 + cy * m12 + cz * m13 + m14;
		this._centerY = cx * m21 + cy * m22 + cz * m23 + m24;
		this._centerZ = cx * m31 + cy * m32 + cz * m33 + m34;
		if(m11 < 0) {
			m11 = -m11;
		}
		if(m12 < 0) {
			m12 = -m12;
		}
		if(m13 < 0) {
			m13 = -m13;
		}
		if(m21 < 0) {
			m21 = -m21;
		}
		if(m22 < 0) {
			m22 = -m22;
		}
		if(m23 < 0) {
			m23 = -m23;
		}
		if(m31 < 0) {
			m31 = -m31;
		}
		if(m32 < 0) {
			m32 = -m32;
		}
		if(m33 < 0) {
			m33 = -m33;
		}
		var r = sphere._radius;
		var rx = m11 + m12 + m13;
		var ry = m21 + m22 + m23;
		var rz = m31 + m32 + m33;
		this._radius = r * Math.sqrt(rx * rx + ry * ry + rz * rz);
		this._min.x = this._centerX - this._radius;
		this._min.y = this._centerY - this._radius;
		this._min.z = this._centerZ - this._radius;
		this._max.x = this._centerX + this._radius;
		this._max.y = this._centerY + this._radius;
		this._max.z = this._centerZ + this._radius;
	}
	,__class__: away3d_bounds_BoundingSphere
	,__properties__: $extend(away3d_bounds_BoundingVolumeBase.prototype.__properties__,{get_radius:"get_radius"})
});
var away3d_bounds_NullBounds = function(alwaysIn,renderable) {
	if(alwaysIn == null) {
		alwaysIn = true;
	}
	away3d_bounds_BoundingVolumeBase.call(this);
	this._alwaysIn = alwaysIn;
	this._renderable = renderable;
	this._max.x = this._max.y = this._max.z = Infinity;
	this._min.x = this._min.y = this._min.z = this._alwaysIn ? -Infinity : Infinity;
};
$hxClasses["away3d.bounds.NullBounds"] = away3d_bounds_NullBounds;
away3d_bounds_NullBounds.__name__ = "away3d.bounds.NullBounds";
away3d_bounds_NullBounds.__super__ = away3d_bounds_BoundingVolumeBase;
away3d_bounds_NullBounds.prototype = $extend(away3d_bounds_BoundingVolumeBase.prototype,{
	_alwaysIn: null
	,_renderable: null
	,clone: function() {
		return new away3d_bounds_NullBounds(this._alwaysIn);
	}
	,createBoundingRenderable: function() {
		if(this._renderable != null) {
			return this._renderable;
		} else {
			return new away3d_primitives_WireframeSphere(100,16,12,16777215,0.5);
		}
	}
	,isInFrustum: function(planes,numPlanes) {
		return this._alwaysIn;
	}
	,fromGeometry: function(geometry) {
	}
	,fromSphere: function(center,radius) {
	}
	,fromExtremes: function(minX,minY,minZ,maxX,maxY,maxZ) {
	}
	,classifyToPlane: function(plane) {
		return 2;
	}
	,transformFrom: function(bounds,matrix) {
		this._alwaysIn = (js_Boot.__cast(bounds , away3d_bounds_NullBounds))._alwaysIn;
	}
	,__class__: away3d_bounds_NullBounds
});
var away3d_core_base_Object3D = function() {
	this._sca = new openfl_geom_Vector3D();
	this._rot = new openfl_geom_Vector3D();
	this._pos = new openfl_geom_Vector3D();
	this._pivotZero = true;
	this._pivotPoint = new openfl_geom_Vector3D();
	this._z = 0;
	this._y = 0;
	this._x = 0;
	this._scaleZ = 1;
	this._scaleY = 1;
	this._scaleX = 1;
	this._transform = new openfl_geom_Matrix3D();
	this._zOffset = 0;
	this._flipY = new openfl_geom_Matrix3D();
	this._eulers = new openfl_geom_Vector3D();
	this._rotationZ = 0;
	this._rotationY = 0;
	this._rotationX = 0;
	this._transformDirty = true;
	this._smallestNumber = 0.0000000000000000000001;
	this._transformComponents = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,3,true);
	this._transformComponents.set(0,this._pos);
	this._transformComponents.set(1,this._rot);
	this._transformComponents.set(2,this._sca);
	this._transform.identity();
	this._flipY.appendScale(1,-1,1);
	away3d_library_assets_NamedAssetBase.call(this);
};
$hxClasses["away3d.core.base.Object3D"] = away3d_core_base_Object3D;
away3d_core_base_Object3D.__name__ = "away3d.core.base.Object3D";
away3d_core_base_Object3D.__super__ = away3d_library_assets_NamedAssetBase;
away3d_core_base_Object3D.prototype = $extend(away3d_library_assets_NamedAssetBase.prototype,{
	_controller: null
	,_smallestNumber: null
	,_transformDirty: null
	,_positionDirty: null
	,_rotationDirty: null
	,_scaleDirty: null
	,_positionChanged: null
	,_rotationChanged: null
	,_scaleChanged: null
	,_rotationX: null
	,_rotationY: null
	,_rotationZ: null
	,_eulers: null
	,_flipY: null
	,_listenToPositionChanged: null
	,_listenToRotationChanged: null
	,_listenToScaleChanged: null
	,_zOffset: null
	,invalidatePivot: function() {
		this._pivotZero = this._pivotPoint.x == 0 && this._pivotPoint.y == 0 && this._pivotPoint.z == 0;
		this.invalidateTransform();
	}
	,invalidatePosition: function() {
		if(this._positionDirty) {
			return;
		}
		this._positionDirty = true;
		this.invalidateTransform();
		if(this._listenToPositionChanged) {
			this.notifyPositionChanged();
		}
	}
	,notifyPositionChanged: function() {
		if(this._positionChanged == null) {
			this._positionChanged = new away3d_events_Object3DEvent("positionChanged",this);
		}
		this.dispatchEvent(this._positionChanged);
	}
	,addEventListener: function(type,listener,useCapture,priority,useWeakReference) {
		if(useWeakReference == null) {
			useWeakReference = false;
		}
		if(priority == null) {
			priority = 0;
		}
		if(useCapture == null) {
			useCapture = false;
		}
		away3d_library_assets_NamedAssetBase.prototype.addEventListener.call(this,type,listener,useCapture,priority,useWeakReference);
		switch(type) {
		case "positionChanged":
			this._listenToPositionChanged = true;
			break;
		case "rotationChanged":
			this._listenToRotationChanged = true;
			break;
		case "scaleChanged":
			this._listenToScaleChanged = true;
			break;
		}
	}
	,removeEventListener: function(type,listener,useCapture) {
		if(useCapture == null) {
			useCapture = false;
		}
		away3d_library_assets_NamedAssetBase.prototype.removeEventListener.call(this,type,listener,useCapture);
		if(this.hasEventListener(type)) {
			return;
		}
		switch(type) {
		case "positionChanged":
			this._listenToPositionChanged = false;
			break;
		case "rotationChanged":
			this._listenToRotationChanged = false;
			break;
		case "scaleChanged":
			this._listenToScaleChanged = false;
			break;
		}
	}
	,invalidateRotation: function() {
		if(this._rotationDirty) {
			return;
		}
		this._rotationDirty = true;
		this.invalidateTransform();
		if(this._listenToRotationChanged) {
			this.notifyRotationChanged();
		}
	}
	,notifyRotationChanged: function() {
		if(this._rotationChanged == null) {
			this._rotationChanged = new away3d_events_Object3DEvent("rotationChanged",this);
		}
		this.dispatchEvent(this._rotationChanged);
	}
	,invalidateScale: function() {
		if(this._scaleDirty) {
			return;
		}
		this._scaleDirty = true;
		this.invalidateTransform();
		if(this._listenToScaleChanged) {
			this.notifyScaleChanged();
		}
	}
	,notifyScaleChanged: function() {
		if(this._scaleChanged == null) {
			this._scaleChanged = new away3d_events_Object3DEvent("scaleChanged",this);
		}
		this.dispatchEvent(this._scaleChanged);
	}
	,_transform: null
	,_scaleX: null
	,_scaleY: null
	,_scaleZ: null
	,_x: null
	,_y: null
	,_z: null
	,_pivotPoint: null
	,_pivotZero: null
	,_pos: null
	,_rot: null
	,_sca: null
	,_transformComponents: null
	,extra: null
	,get_x: function() {
		return this._x;
	}
	,set_x: function(val) {
		if(this._x == val) {
			return val;
		}
		this._x = val;
		this.invalidatePosition();
		return val;
	}
	,get_y: function() {
		return this._y;
	}
	,set_y: function(val) {
		if(this._y == val) {
			return val;
		}
		this._y = val;
		this.invalidatePosition();
		return val;
	}
	,get_z: function() {
		return this._z;
	}
	,set_z: function(val) {
		if(this._z == val) {
			return val;
		}
		this._z = val;
		this.invalidatePosition();
		return val;
	}
	,get_rotationX: function() {
		return this._rotationX * away3d_core_math_MathConsts.RADIANS_TO_DEGREES;
	}
	,set_rotationX: function(val) {
		if(this.get_rotationX() == val) {
			return val;
		}
		this._rotationX = val * away3d_core_math_MathConsts.DEGREES_TO_RADIANS;
		this.invalidateRotation();
		return val;
	}
	,get_rotationY: function() {
		return this._rotationY * away3d_core_math_MathConsts.RADIANS_TO_DEGREES;
	}
	,set_rotationY: function(val) {
		if(this.get_rotationY() == val) {
			return val;
		}
		this._rotationY = val * away3d_core_math_MathConsts.DEGREES_TO_RADIANS;
		this.invalidateRotation();
		return val;
	}
	,get_rotationZ: function() {
		return this._rotationZ * away3d_core_math_MathConsts.RADIANS_TO_DEGREES;
	}
	,set_rotationZ: function(val) {
		if(this.get_rotationZ() == val) {
			return val;
		}
		this._rotationZ = val * away3d_core_math_MathConsts.DEGREES_TO_RADIANS;
		this.invalidateRotation();
		return val;
	}
	,get_scaleX: function() {
		return this._scaleX;
	}
	,set_scaleX: function(val) {
		if(this._scaleX == val) {
			return val;
		}
		this._scaleX = val;
		this.invalidateScale();
		return val;
	}
	,get_scaleY: function() {
		return this._scaleY;
	}
	,set_scaleY: function(val) {
		if(this._scaleY == val) {
			return val;
		}
		this._scaleY = val;
		this.invalidateScale();
		return val;
	}
	,get_scaleZ: function() {
		return this._scaleZ;
	}
	,set_scaleZ: function(val) {
		if(this._scaleZ == val) {
			return val;
		}
		this._scaleZ = val;
		this.invalidateScale();
		return val;
	}
	,get_eulers: function() {
		this._eulers.x = this._rotationX * away3d_core_math_MathConsts.RADIANS_TO_DEGREES;
		this._eulers.y = this._rotationY * away3d_core_math_MathConsts.RADIANS_TO_DEGREES;
		this._eulers.z = this._rotationZ * away3d_core_math_MathConsts.RADIANS_TO_DEGREES;
		return this._eulers;
	}
	,set_eulers: function(value) {
		this._rotationX = value.x * away3d_core_math_MathConsts.DEGREES_TO_RADIANS;
		this._rotationY = value.y * away3d_core_math_MathConsts.DEGREES_TO_RADIANS;
		this._rotationZ = value.z * away3d_core_math_MathConsts.DEGREES_TO_RADIANS;
		this.invalidateRotation();
		return value;
	}
	,get_transform: function() {
		if(this._transformDirty) {
			this.updateTransform();
		}
		return this._transform;
	}
	,set_transform: function(val) {
		if(val.rawData.get(0) == 0) {
			var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
			val.copyRawDataTo(raw);
			raw.set(0,this._smallestNumber);
			val.copyRawDataFrom(raw);
		}
		var elements = away3d_core_math_Matrix3DUtils.decompose(val);
		var vec = elements.get(0);
		if(this._x != vec.x || this._y != vec.y || this._z != vec.z) {
			this._x = vec.x;
			this._y = vec.y;
			this._z = vec.z;
			this.invalidatePosition();
		}
		vec = elements.get(1);
		if(this._rotationX != vec.x || this._rotationY != vec.y || this._rotationZ != vec.z) {
			this._rotationX = vec.x;
			this._rotationY = vec.y;
			this._rotationZ = vec.z;
			this.invalidateRotation();
		}
		vec = elements.get(2);
		if(this._scaleX != vec.x || this._scaleY != vec.y || this._scaleZ != vec.z) {
			this._scaleX = vec.x;
			this._scaleY = vec.y;
			this._scaleZ = vec.z;
			this.invalidateScale();
		}
		return val;
	}
	,get_pivotPoint: function() {
		return this._pivotPoint;
	}
	,set_pivotPoint: function(pivot) {
		if(this._pivotPoint == null) {
			this._pivotPoint = new openfl_geom_Vector3D();
		}
		this._pivotPoint.x = pivot.x;
		this._pivotPoint.y = pivot.y;
		this._pivotPoint.z = pivot.z;
		this.invalidatePivot();
		return pivot;
	}
	,get_position: function() {
		this.get_transform().copyColumnTo(3,this._pos);
		return this._pos.clone();
	}
	,set_position: function(value) {
		this._x = value.x;
		this._y = value.y;
		this._z = value.z;
		this.invalidatePosition();
		return value;
	}
	,getPosition: function(v) {
		if(v == null) {
			v = new openfl_geom_Vector3D();
		}
		this.get_transform().copyColumnTo(3,v);
		return v;
	}
	,get_forwardVector: function() {
		return away3d_core_math_Matrix3DUtils.getForward(this.get_transform());
	}
	,get_rightVector: function() {
		return away3d_core_math_Matrix3DUtils.getRight(this.get_transform());
	}
	,get_upVector: function() {
		return away3d_core_math_Matrix3DUtils.getUp(this.get_transform());
	}
	,get_backVector: function() {
		var director = away3d_core_math_Matrix3DUtils.getForward(this.get_transform());
		director.negate();
		return director;
	}
	,get_leftVector: function() {
		var director = away3d_core_math_Matrix3DUtils.getRight(this.get_transform());
		director.negate();
		return director;
	}
	,get_downVector: function() {
		var director = away3d_core_math_Matrix3DUtils.getUp(this.get_transform());
		director.negate();
		return director;
	}
	,scale: function(value) {
		this._scaleX *= value;
		this._scaleY *= value;
		this._scaleZ *= value;
		this.invalidateScale();
	}
	,moveForward: function(distance) {
		this.translateLocal(new openfl_geom_Vector3D(0,0,1),distance);
	}
	,moveBackward: function(distance) {
		this.translateLocal(new openfl_geom_Vector3D(0,0,1),-distance);
	}
	,moveLeft: function(distance) {
		this.translateLocal(new openfl_geom_Vector3D(1,0,0),-distance);
	}
	,moveRight: function(distance) {
		this.translateLocal(new openfl_geom_Vector3D(1,0,0),distance);
	}
	,moveUp: function(distance) {
		this.translateLocal(new openfl_geom_Vector3D(0,1,0),distance);
	}
	,moveDown: function(distance) {
		this.translateLocal(new openfl_geom_Vector3D(0,1,0),-distance);
	}
	,moveTo: function(dx,dy,dz) {
		if(this._x == dx && this._y == dy && this._z == dz) {
			return;
		}
		this._x = dx;
		this._y = dy;
		this._z = dz;
		this.invalidatePosition();
	}
	,movePivot: function(dx,dy,dz) {
		if(this._pivotPoint == null) {
			this._pivotPoint = new openfl_geom_Vector3D();
		}
		this._pivotPoint.x += dx;
		this._pivotPoint.y += dy;
		this._pivotPoint.z += dz;
		this.invalidatePivot();
	}
	,translate: function(axis,distance) {
		var x = axis.x;
		var y = axis.y;
		var z = axis.z;
		var len = distance / Math.sqrt(x * x + y * y + z * z);
		this._x += x * len;
		this._y += y * len;
		this._z += z * len;
		this.invalidatePosition();
	}
	,translateLocal: function(axis,distance) {
		var x = axis.x;
		var y = axis.y;
		var z = axis.z;
		var len = distance / Math.sqrt(x * x + y * y + z * z);
		this.get_transform().prependTranslation(x * len,y * len,z * len);
		this._transform.copyColumnTo(3,this._pos);
		this._x = this._pos.x;
		this._y = this._pos.y;
		this._z = this._pos.z;
		this.invalidatePosition();
	}
	,pitch: function(angle) {
		this.rotate(new openfl_geom_Vector3D(1,0,0),angle);
	}
	,yaw: function(angle) {
		this.rotate(new openfl_geom_Vector3D(0,1,0),angle);
	}
	,roll: function(angle) {
		this.rotate(new openfl_geom_Vector3D(0,0,1),angle);
	}
	,clone: function() {
		var clone = new away3d_core_base_Object3D();
		clone.set_pivotPoint(this.get_pivotPoint());
		clone.set_transform(this.get_transform());
		clone.set_name(this.get_name());
		return clone;
	}
	,rotateTo: function(ax,ay,az) {
		this._rotationX = ax * away3d_core_math_MathConsts.DEGREES_TO_RADIANS;
		this._rotationY = ay * away3d_core_math_MathConsts.DEGREES_TO_RADIANS;
		this._rotationZ = az * away3d_core_math_MathConsts.DEGREES_TO_RADIANS;
		this.invalidateRotation();
	}
	,rotate: function(axis,angle) {
		var m = new openfl_geom_Matrix3D();
		m.prependRotation(angle,axis);
		var vec = m.decompose().get(1);
		this._rotationX += vec.x;
		this._rotationY += vec.y;
		this._rotationZ += vec.z;
		this.invalidateRotation();
	}
	,lookAt: function(target,upAxis) {
		if(away3d_core_base_Object3D.tempAxeX == null) {
			away3d_core_base_Object3D.tempAxeX = new openfl_geom_Vector3D();
		}
		if(away3d_core_base_Object3D.tempAxeY == null) {
			away3d_core_base_Object3D.tempAxeY = new openfl_geom_Vector3D();
		}
		if(away3d_core_base_Object3D.tempAxeZ == null) {
			away3d_core_base_Object3D.tempAxeZ = new openfl_geom_Vector3D();
		}
		var xAxis = away3d_core_base_Object3D.tempAxeX;
		var yAxis = away3d_core_base_Object3D.tempAxeY;
		var zAxis = away3d_core_base_Object3D.tempAxeZ;
		if(upAxis == null) {
			upAxis = new openfl_geom_Vector3D(0,1,0);
		}
		if(this._transformDirty) {
			this.updateTransform();
		}
		zAxis.x = target.x - this._x;
		zAxis.y = target.y - this._y;
		zAxis.z = target.z - this._z;
		zAxis.normalize();
		xAxis.x = upAxis.y * zAxis.z - upAxis.z * zAxis.y;
		xAxis.y = upAxis.z * zAxis.x - upAxis.x * zAxis.z;
		xAxis.z = upAxis.x * zAxis.y - upAxis.y * zAxis.x;
		xAxis.normalize();
		if(xAxis.get_length() < .05) {
			xAxis.x = upAxis.y;
			xAxis.y = upAxis.x;
			xAxis.z = 0;
			xAxis.normalize();
		}
		yAxis.x = zAxis.y * xAxis.z - zAxis.z * xAxis.y;
		yAxis.y = zAxis.z * xAxis.x - zAxis.x * xAxis.z;
		yAxis.z = zAxis.x * xAxis.y - zAxis.y * xAxis.x;
		var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
		raw.set(0,this._scaleX * xAxis.x);
		raw.set(1,this._scaleX * xAxis.y);
		raw.set(2,this._scaleX * xAxis.z);
		raw.set(3,0);
		raw.set(4,this._scaleY * yAxis.x);
		raw.set(5,this._scaleY * yAxis.y);
		raw.set(6,this._scaleY * yAxis.z);
		raw.set(7,0);
		raw.set(8,this._scaleZ * zAxis.x);
		raw.set(9,this._scaleZ * zAxis.y);
		raw.set(10,this._scaleZ * zAxis.z);
		raw.set(11,0);
		raw.set(12,this._x);
		raw.set(13,this._y);
		raw.set(14,this._z);
		raw.set(15,1);
		this._transform.copyRawDataFrom(raw);
		this.set_transform(this.get_transform());
		if(zAxis.z < 0) {
			this.set_rotationY(180 - this.get_rotationY());
			var _g = this;
			_g.set_rotationX(_g.get_rotationX() - 180);
			var _g1 = this;
			_g1.set_rotationZ(_g1.get_rotationZ() - 180);
		}
	}
	,dispose: function() {
	}
	,disposeAsset: function() {
		this.dispose();
	}
	,invalidateTransform: function() {
		this._transformDirty = true;
	}
	,updateTransform: function() {
		this._pos.x = this._x;
		this._pos.y = this._y;
		this._pos.z = this._z;
		this._rot.x = this._rotationX;
		this._rot.y = this._rotationY;
		this._rot.z = this._rotationZ;
		if(!this._pivotZero) {
			this._sca.x = 1;
			this._sca.y = 1;
			this._sca.z = 1;
			this._transform.recompose(this._transformComponents);
			this._transform.appendTranslation(this._pivotPoint.x,this._pivotPoint.y,this._pivotPoint.z);
			this._transform.prependTranslation(-this._pivotPoint.x,-this._pivotPoint.y,-this._pivotPoint.z);
			this._transform.prependScale(this._scaleX,this._scaleY,this._scaleZ);
			this._sca.x = this._scaleX;
			this._sca.y = this._scaleY;
			this._sca.z = this._scaleZ;
		} else {
			this._sca.x = this._scaleX;
			this._sca.y = this._scaleY;
			this._sca.z = this._scaleZ;
			this._transform.recompose(this._transformComponents);
		}
		this._transformDirty = false;
		this._positionDirty = false;
		this._rotationDirty = false;
		this._scaleDirty = false;
	}
	,get_zOffset: function() {
		return this._zOffset;
	}
	,set_zOffset: function(value) {
		this._zOffset = value;
		return value;
	}
	,__class__: away3d_core_base_Object3D
	,__properties__: $extend(away3d_library_assets_NamedAssetBase.prototype.__properties__,{set_zOffset:"set_zOffset",get_zOffset:"get_zOffset",get_downVector:"get_downVector",get_leftVector:"get_leftVector",get_backVector:"get_backVector",get_upVector:"get_upVector",get_rightVector:"get_rightVector",get_forwardVector:"get_forwardVector",set_position:"set_position",get_position:"get_position",set_pivotPoint:"set_pivotPoint",get_pivotPoint:"get_pivotPoint",set_transform:"set_transform",get_transform:"get_transform",set_eulers:"set_eulers",get_eulers:"get_eulers",set_scaleZ:"set_scaleZ",get_scaleZ:"get_scaleZ",set_scaleY:"set_scaleY",get_scaleY:"get_scaleY",set_scaleX:"set_scaleX",get_scaleX:"get_scaleX",set_rotationZ:"set_rotationZ",get_rotationZ:"get_rotationZ",set_rotationY:"set_rotationY",get_rotationY:"get_rotationY",set_rotationX:"set_rotationX",get_rotationX:"get_rotationX",set_z:"set_z",get_z:"get_z",set_y:"set_y",get_y:"get_y",set_x:"set_x",get_x:"get_x"})
});
var away3d_containers_ObjectContainer3D = function() {
	this._ignoreTransform = false;
	this._implicitVisibility = true;
	this._explicitVisibility = true;
	this._scenePositionDirty = true;
	this._scenePosition = new openfl_geom_Vector3D();
	this._inverseSceneTransformDirty = true;
	this._inverseSceneTransform = new openfl_geom_Matrix3D();
	this._mouseChildren = true;
	this._children = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this._sceneTransformDirty = true;
	this._sceneTransform = new openfl_geom_Matrix3D();
	away3d_core_base_Object3D.call(this);
};
$hxClasses["away3d.containers.ObjectContainer3D"] = away3d_containers_ObjectContainer3D;
away3d_containers_ObjectContainer3D.__name__ = "away3d.containers.ObjectContainer3D";
away3d_containers_ObjectContainer3D.__interfaces__ = [away3d_library_assets_IAsset];
away3d_containers_ObjectContainer3D.__super__ = away3d_core_base_Object3D;
away3d_containers_ObjectContainer3D.prototype = $extend(away3d_core_base_Object3D.prototype,{
	_ancestorsAllowMouseEnabled: null
	,_isRoot: null
	,_scene: null
	,_parent: null
	,_sceneTransform: null
	,_sceneTransformDirty: null
	,_explicitPartition: null
	,_implicitPartition: null
	,_mouseEnabled: null
	,_sceneTransformChanged: null
	,_scenechanged: null
	,_children: null
	,_mouseChildren: null
	,_oldScene: null
	,_inverseSceneTransform: null
	,_inverseSceneTransformDirty: null
	,_scenePosition: null
	,_scenePositionDirty: null
	,_explicitVisibility: null
	,_implicitVisibility: null
	,_listenToSceneTransformChanged: null
	,_listenToSceneChanged: null
	,_ignoreTransform: null
	,get_ignoreTransform: function() {
		return this._ignoreTransform;
	}
	,set_ignoreTransform: function(value) {
		this._ignoreTransform = value;
		this._sceneTransformDirty = !value;
		this._inverseSceneTransformDirty = !value;
		this._scenePositionDirty = !value;
		if(!value) {
			this._sceneTransform.identity();
			this._scenePosition.setTo(0,0,0);
		}
		return value;
	}
	,get_implicitPartition: function() {
		return this._implicitPartition;
	}
	,set_implicitPartition: function(value) {
		if(value == this._implicitPartition) {
			return value;
		}
		var i = 0;
		var len = this._children.get_length();
		var child;
		this._implicitPartition = value;
		while(i < len) {
			child = this._children.get(i++);
			if(child._explicitPartition == null) {
				child.set_implicitPartition(value);
			}
		}
		return value;
	}
	,get_isVisible: function() {
		if(this._implicitVisibility) {
			return this._explicitVisibility;
		} else {
			return false;
		}
	}
	,setParent: function(value) {
		this._parent = value;
		this.updateMouseChildren();
		if(value == null) {
			this.set_scene(null);
			return;
		}
		this.notifySceneTransformChange();
		this.notifySceneChange();
	}
	,notifySceneTransformChange: function() {
		if(this._sceneTransformDirty || this._ignoreTransform) {
			return;
		}
		this.invalidateSceneTransform();
		var i = 0;
		var len = this._children.get_length();
		while(i < len) this._children.get(i++).notifySceneTransformChange();
		if(this._listenToSceneTransformChanged) {
			if(this._sceneTransformChanged == null) {
				this._sceneTransformChanged = new away3d_events_Object3DEvent("scenetransformChanged",this);
			}
			this.dispatchEvent(this._sceneTransformChanged);
		}
	}
	,notifySceneChange: function() {
		this.notifySceneTransformChange();
		var i = 0;
		var len = this._children.get_length();
		while(i < len) this._children.get(i++).notifySceneChange();
		if(this._listenToSceneChanged) {
			if(this._scenechanged == null) {
				this._scenechanged = new away3d_events_Object3DEvent("sceneChanged",this);
			}
			this.dispatchEvent(this._scenechanged);
		}
	}
	,updateMouseChildren: function() {
		if(this._parent != null && !this._parent._isRoot) {
			this._ancestorsAllowMouseEnabled = this.get_parent()._ancestorsAllowMouseEnabled && this._parent.get_mouseChildren();
		} else {
			this._ancestorsAllowMouseEnabled = this.get_mouseChildren();
		}
		var len = this._children.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			this._children.get(i).updateMouseChildren();
		}
	}
	,get_mouseEnabled: function() {
		return this._mouseEnabled;
	}
	,set_mouseEnabled: function(value) {
		this._mouseEnabled = value;
		this.updateMouseChildren();
		return value;
	}
	,invalidateTransform: function() {
		away3d_core_base_Object3D.prototype.invalidateTransform.call(this);
		this.notifySceneTransformChange();
	}
	,invalidateSceneTransform: function() {
		this._sceneTransformDirty = !this._ignoreTransform;
		this._inverseSceneTransformDirty = !this._ignoreTransform;
		this._scenePositionDirty = !this._ignoreTransform;
	}
	,updateSceneTransform: function() {
		if(this._parent != null && !this._parent._isRoot) {
			this._sceneTransform.copyFrom(this._parent.get_sceneTransform());
			this._sceneTransform.prepend(this.get_transform());
		} else {
			this._sceneTransform.copyFrom(this.get_transform());
		}
		this._sceneTransformDirty = false;
	}
	,get_mouseChildren: function() {
		return this._mouseChildren;
	}
	,set_mouseChildren: function(value) {
		this._mouseChildren = value;
		this.updateMouseChildren();
		return value;
	}
	,get_visible: function() {
		return this._explicitVisibility;
	}
	,set_visible: function(value) {
		var len = this._children.get_length();
		this._explicitVisibility = value;
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			this._children.get(i).updateImplicitVisibility();
		}
		return value;
	}
	,get_assetType: function() {
		return "container";
	}
	,get_scenePosition: function() {
		if(this._scenePositionDirty) {
			this.get_sceneTransform().copyColumnTo(3,this._scenePosition);
			this._scenePositionDirty = false;
		}
		return this._scenePosition;
	}
	,get_minX: function() {
		var i = 0;
		var len = this._children.get_length();
		var min = Infinity;
		var m;
		while(i < len) {
			var child = this._children.get(i++);
			m = child.get_minX() + child.get_x();
			if(m < min) {
				min = m;
			}
		}
		return min;
	}
	,get_minY: function() {
		var i = 0;
		var len = this._children.get_length();
		var min = Infinity;
		var m;
		while(i < len) {
			var child = this._children.get(i++);
			m = child.get_minY() + child.get_y();
			if(m < min) {
				min = m;
			}
		}
		return min;
	}
	,get_minZ: function() {
		var i = 0;
		var len = this._children.get_length();
		var min = Infinity;
		var m;
		while(i < len) {
			var child = this._children.get(i++);
			m = child.get_minZ() + child.get_z();
			if(m < min) {
				min = m;
			}
		}
		return min;
	}
	,get_maxX: function() {
		var i = 0;
		var len = this._children.get_length();
		var max = -Infinity;
		var m;
		while(i < len) {
			var child = this._children.get(i++);
			m = child.get_maxX() + child.get_x();
			if(m > max) {
				max = m;
			}
		}
		return max;
	}
	,get_maxY: function() {
		var i = 0;
		var len = this._children.get_length();
		var max = -Infinity;
		var m;
		while(i < len) {
			var child = this._children.get(i++);
			m = child.get_maxY() + child.get_y();
			if(m > max) {
				max = m;
			}
		}
		return max;
	}
	,get_maxZ: function() {
		var i = 0;
		var len = this._children.get_length();
		var max = -Infinity;
		var m;
		while(i < len) {
			var child = this._children.get(i++);
			m = child.get_maxZ() + child.get_z();
			if(m > max) {
				max = m;
			}
		}
		return max;
	}
	,get_partition: function() {
		return this._explicitPartition;
	}
	,set_partition: function(value) {
		this._explicitPartition = value;
		this.set_implicitPartition(value != null ? value : this._parent != null ? this._parent.get_implicitPartition() : null);
		return value;
	}
	,get_sceneTransform: function() {
		if(this._sceneTransformDirty) {
			this.updateSceneTransform();
		}
		return this._sceneTransform;
	}
	,get_scene: function() {
		return this._scene;
	}
	,set_scene: function(value) {
		var i = 0;
		var len = this._children.get_length();
		while(i < len) this._children.get(i++).set_scene(value);
		if(this._scene == value) {
			return value;
		}
		if(value == null) {
			this._oldScene = this._scene;
		}
		if(this._explicitPartition != null && this._oldScene != null && this._oldScene != this._scene) {
			this.set_partition(null);
		}
		if(value != null) {
			this._oldScene = null;
		}
		this._scene = value;
		if(this._scene != null) {
			this._scene.dispatchEvent(new away3d_events_Scene3DEvent("addedToScene",this));
		} else if(this._oldScene != null) {
			this._oldScene.dispatchEvent(new away3d_events_Scene3DEvent("removedFromScene",this));
		}
		return value;
	}
	,get_inverseSceneTransform: function() {
		if(this._inverseSceneTransformDirty) {
			this._inverseSceneTransform.copyFrom(this.get_sceneTransform());
			this._inverseSceneTransform.invert();
			this._inverseSceneTransformDirty = false;
		}
		return this._inverseSceneTransform;
	}
	,get_parent: function() {
		return this._parent;
	}
	,contains: function(child) {
		return this._children.indexOf(child,0) >= 0;
	}
	,addChild: function(child) {
		if(child == null) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Parameter child cannot be null."));
		}
		if(child._parent != null) {
			child._parent.removeChild(child);
		}
		if(child._explicitPartition == null) {
			child.set_implicitPartition(this._implicitPartition);
		}
		child.setParent(this);
		child.set_scene(this._scene);
		child.notifySceneTransformChange();
		child.updateMouseChildren();
		child.updateImplicitVisibility();
		this._children.push(child);
		return child;
	}
	,addChildren: function(childarray) {
		var child = childarray.iterator();
		while(child.hasNext()) {
			var child1 = child.next();
			this.addChild(child1);
		}
	}
	,removeChild: function(child) {
		if(child == null) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Parameter child cannot be null"));
		}
		var childIndex = this._children.indexOf(child,0);
		if(childIndex == -1) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Parameter is not a child of the caller"));
		}
		this.removeChildInternal(childIndex,child);
	}
	,removeChildAt: function(index) {
		var child = this._children.get(index);
		this.removeChildInternal(index,child);
	}
	,removeChildInternal: function(childIndex,child) {
		this._children.splice(childIndex,1);
		child.setParent(null);
		if(child._explicitPartition == null) {
			child.set_implicitPartition(null);
		}
	}
	,getChildAt: function(index) {
		return this._children.get(index);
	}
	,get_numChildren: function() {
		return this._children.get_length();
	}
	,lookAt: function(target,upAxis) {
		away3d_core_base_Object3D.prototype.lookAt.call(this,target,upAxis);
		this.notifySceneTransformChange();
	}
	,translateLocal: function(axis,distance) {
		away3d_core_base_Object3D.prototype.translateLocal.call(this,axis,distance);
		this.notifySceneTransformChange();
	}
	,dispose: function() {
		if(this.get_parent() != null) {
			this.get_parent().removeChild(this);
		}
	}
	,disposeWithChildren: function() {
		this.dispose();
		while(this.get_numChildren() > 0) this.getChildAt(0).dispose();
	}
	,clone: function() {
		var clone = new away3d_containers_ObjectContainer3D();
		clone.set_pivotPoint(this.get_pivotPoint());
		clone.set_transform(this.get_transform());
		clone.set_partition(this.get_partition());
		clone.set_name(this.get_name());
		var len = this._children.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			clone.addChild(js_Boot.__cast(this._children.get(i).clone() , away3d_containers_ObjectContainer3D));
		}
		return clone;
	}
	,rotate: function(axis,angle) {
		away3d_core_base_Object3D.prototype.rotate.call(this,axis,angle);
		this.notifySceneTransformChange();
	}
	,dispatchEvent: function(event) {
		var ret = away3d_core_base_Object3D.prototype.dispatchEvent.call(this,event);
		if(event.bubbles) {
			if(this._parent != null) {
				this._parent.dispatchEvent(event);
			} else if(this._scene != null) {
				this._scene.dispatchEvent(event);
			}
		}
		return ret;
	}
	,updateImplicitVisibility: function() {
		var len = this._children.get_length();
		this._implicitVisibility = this._parent._explicitVisibility && this._parent._implicitVisibility;
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			this._children.get(i).updateImplicitVisibility();
		}
	}
	,addEventListener: function(type,listener,useCapture,priority,useWeakReference) {
		if(useWeakReference == null) {
			useWeakReference = false;
		}
		if(priority == null) {
			priority = 0;
		}
		if(useCapture == null) {
			useCapture = false;
		}
		away3d_core_base_Object3D.prototype.addEventListener.call(this,type,listener,useCapture,priority,useWeakReference);
		switch(type) {
		case "sceneChanged":
			this._listenToSceneChanged = true;
			break;
		case "scenetransformChanged":
			this._listenToSceneTransformChanged = true;
			break;
		}
	}
	,removeEventListener: function(type,listener,useCapture) {
		if(useCapture == null) {
			useCapture = false;
		}
		away3d_core_base_Object3D.prototype.removeEventListener.call(this,type,listener,useCapture);
		if(this.hasEventListener(type)) {
			return;
		}
		switch(type) {
		case "sceneChanged":
			this._listenToSceneChanged = false;
			break;
		case "scenetransformChanged":
			this._listenToSceneTransformChanged = false;
			break;
		}
	}
	,__class__: away3d_containers_ObjectContainer3D
	,__properties__: $extend(away3d_core_base_Object3D.prototype.__properties__,{get_numChildren:"get_numChildren",get_parent:"get_parent",get_inverseSceneTransform:"get_inverseSceneTransform",set_scene:"set_scene",get_scene:"get_scene",get_sceneTransform:"get_sceneTransform",set_partition:"set_partition",get_partition:"get_partition",get_maxZ:"get_maxZ",get_maxY:"get_maxY",get_maxX:"get_maxX",get_minZ:"get_minZ",get_minY:"get_minY",get_minX:"get_minX",get_scenePosition:"get_scenePosition",get_assetType:"get_assetType",set_visible:"set_visible",get_visible:"get_visible",set_mouseChildren:"set_mouseChildren",get_mouseChildren:"get_mouseChildren",set_mouseEnabled:"set_mouseEnabled",get_mouseEnabled:"get_mouseEnabled",get_isVisible:"get_isVisible",set_implicitPartition:"set_implicitPartition",get_implicitPartition:"get_implicitPartition",set_ignoreTransform:"set_ignoreTransform",get_ignoreTransform:"get_ignoreTransform"})
});
var away3d_entities_Entity = function() {
	this._worldBoundsInvalid = true;
	this._boundsInvalid = true;
	this._boundsIsShown = false;
	away3d_containers_ObjectContainer3D.call(this);
	this._bounds = this.getDefaultBoundingVolume();
	this._worldBounds = this.getDefaultBoundingVolume();
};
$hxClasses["away3d.entities.Entity"] = away3d_entities_Entity;
away3d_entities_Entity.__name__ = "away3d.entities.Entity";
away3d_entities_Entity.__super__ = away3d_containers_ObjectContainer3D;
away3d_entities_Entity.prototype = $extend(away3d_containers_ObjectContainer3D.prototype,{
	_showBounds: null
	,_partitionNode: null
	,_boundsIsShown: null
	,_shaderPickingDetails: null
	,_pickingCollisionVO: null
	,_pickingCollider: null
	,_staticNode: null
	,_bounds: null
	,_boundsInvalid: null
	,_worldBounds: null
	,_worldBoundsInvalid: null
	,set_ignoreTransform: function(value) {
		if(this._scene != null) {
			this._scene.invalidateEntityBounds(this);
		}
		away3d_containers_ObjectContainer3D.prototype.set_ignoreTransform.call(this,value);
		return value;
	}
	,get_shaderPickingDetails: function() {
		return this._shaderPickingDetails;
	}
	,set_shaderPickingDetails: function(value) {
		this._shaderPickingDetails = value;
		return value;
	}
	,get_staticNode: function() {
		return this._staticNode;
	}
	,set_staticNode: function(value) {
		this._staticNode = value;
		return value;
	}
	,get_pickingCollisionVO: function() {
		if(this._pickingCollisionVO == null) {
			this._pickingCollisionVO = new away3d_core_pick_PickingCollisionVO(this);
		}
		return this._pickingCollisionVO;
	}
	,collidesBefore: function(shortestCollisionDistance,findClosest) {
		return true;
	}
	,get_showBounds: function() {
		return this._showBounds;
	}
	,set_showBounds: function(value) {
		if(value == this._showBounds) {
			return value;
		}
		this._showBounds = value;
		if(this._showBounds) {
			this.addBounds();
		} else {
			this.removeBounds();
		}
		return value;
	}
	,get_minX: function() {
		if(this._boundsInvalid) {
			this.updateBounds();
		}
		return this._bounds.get_min().x;
	}
	,get_minY: function() {
		if(this._boundsInvalid) {
			this.updateBounds();
		}
		return this._bounds.get_min().y;
	}
	,get_minZ: function() {
		if(this._boundsInvalid) {
			this.updateBounds();
		}
		return this._bounds.get_min().z;
	}
	,get_maxX: function() {
		if(this._boundsInvalid) {
			this.updateBounds();
		}
		return this._bounds.get_max().x;
	}
	,get_maxY: function() {
		if(this._boundsInvalid) {
			this.updateBounds();
		}
		return this._bounds.get_max().y;
	}
	,get_maxZ: function() {
		if(this._boundsInvalid) {
			this.updateBounds();
		}
		return this._bounds.get_max().z;
	}
	,get_bounds: function() {
		if(this._boundsInvalid) {
			this.updateBounds();
		}
		return this._bounds;
	}
	,set_bounds: function(value) {
		this.removeBounds();
		this._bounds = value;
		this._worldBounds = value.clone();
		this.invalidateBounds();
		if(this._showBounds) {
			this.addBounds();
		}
		return value;
	}
	,get_worldBounds: function() {
		if(this._worldBoundsInvalid) {
			this.updateWorldBounds();
		}
		return this._worldBounds;
	}
	,updateWorldBounds: function() {
		this._worldBounds.transformFrom(this.get_bounds(),this.get_sceneTransform());
		this._worldBoundsInvalid = false;
	}
	,set_implicitPartition: function(value) {
		if(value == this._implicitPartition) {
			return value;
		}
		if(this._implicitPartition != null) {
			this.notifyPartitionUnassigned();
		}
		away3d_containers_ObjectContainer3D.prototype.set_implicitPartition.call(this,value);
		this.notifyPartitionAssigned();
		return value;
	}
	,set_scene: function(value) {
		if(value == this._scene) {
			return value;
		}
		if(this._scene != null) {
			this._scene.unregisterEntity(this);
		}
		if(value != null) {
			value.registerEntity(this);
		}
		away3d_containers_ObjectContainer3D.prototype.set_scene.call(this,value);
		return value;
	}
	,get_assetType: function() {
		return "entity";
	}
	,get_pickingCollider: function() {
		return this._pickingCollider;
	}
	,set_pickingCollider: function(value) {
		this._pickingCollider = value;
		return value;
	}
	,getEntityPartitionNode: function() {
		if(this._partitionNode == null) {
			this._partitionNode = this.createEntityPartitionNode();
		}
		return this._partitionNode;
	}
	,isIntersectingRay: function(rayPosition,rayDirection) {
		if(this.get_pickingCollisionVO().localRayPosition == null) {
			this.get_pickingCollisionVO().localRayPosition = new openfl_geom_Vector3D();
		}
		if(this.get_pickingCollisionVO().localRayDirection == null) {
			this.get_pickingCollisionVO().localRayDirection = new openfl_geom_Vector3D();
		}
		if(this.get_pickingCollisionVO().localNormal == null) {
			this.get_pickingCollisionVO().localNormal = new openfl_geom_Vector3D();
		}
		var localRayPosition = this.get_pickingCollisionVO().localRayPosition;
		var localRayDirection = this.get_pickingCollisionVO().localRayDirection;
		away3d_core_math_Matrix3DUtils.transformVector(this.get_inverseSceneTransform(),rayPosition,localRayPosition);
		away3d_core_math_Matrix3DUtils.deltaTransformVector(this.get_inverseSceneTransform(),rayDirection,localRayDirection);
		var rayEntryDistance = this.get_bounds().rayIntersection(localRayPosition,localRayDirection,this.get_pickingCollisionVO().localNormal);
		if(rayEntryDistance < 0) {
			return false;
		}
		this.get_pickingCollisionVO().rayEntryDistance = rayEntryDistance;
		this.get_pickingCollisionVO().rayPosition = rayPosition;
		this.get_pickingCollisionVO().rayDirection = rayDirection;
		this.get_pickingCollisionVO().rayOriginIsInsideBounds = rayEntryDistance == 0;
		return true;
	}
	,createEntityPartitionNode: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,getDefaultBoundingVolume: function() {
		return new away3d_bounds_AxisAlignedBoundingBox();
	}
	,updateBounds: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,invalidateSceneTransform: function() {
		if(!this._ignoreTransform) {
			away3d_containers_ObjectContainer3D.prototype.invalidateSceneTransform.call(this);
			this._worldBoundsInvalid = true;
			this.notifySceneBoundsInvalid();
		}
	}
	,invalidateBounds: function() {
		this._boundsInvalid = true;
		this._worldBoundsInvalid = true;
		this.notifySceneBoundsInvalid();
	}
	,updateMouseChildren: function() {
		if(this._parent == null && this.get_pickingCollider() != null) {
			if(((this._parent) instanceof away3d_entities_Entity)) {
				var collider = (js_Boot.__cast(this._parent , away3d_entities_Entity)).get_pickingCollider();
				if(collider != null) {
					this.set_pickingCollider(collider);
				}
			}
		}
		away3d_containers_ObjectContainer3D.prototype.updateMouseChildren.call(this);
	}
	,notifySceneBoundsInvalid: function() {
		if(this._scene != null) {
			this._scene.invalidateEntityBounds(this);
		}
	}
	,notifyPartitionAssigned: function() {
		if(this._scene != null) {
			this._scene.registerPartition(this);
		}
	}
	,notifyPartitionUnassigned: function() {
		if(this._scene != null) {
			this._scene.unregisterPartition(this);
		}
	}
	,addBounds: function() {
		if(!this._boundsIsShown) {
			this._boundsIsShown = true;
			this.addChild(this._bounds.get_boundingRenderable());
		}
	}
	,removeBounds: function() {
		if(this._boundsIsShown) {
			this._boundsIsShown = false;
			this.removeChild(this._bounds.get_boundingRenderable());
			this._bounds.disposeRenderable();
		}
	}
	,internalUpdate: function() {
		if(this._controller != null) {
			this._controller.update();
		}
	}
	,__class__: away3d_entities_Entity
	,__properties__: $extend(away3d_containers_ObjectContainer3D.prototype.__properties__,{set_pickingCollider:"set_pickingCollider",get_pickingCollider:"get_pickingCollider",get_worldBounds:"get_worldBounds",set_bounds:"set_bounds",get_bounds:"get_bounds",set_showBounds:"set_showBounds",get_showBounds:"get_showBounds",get_pickingCollisionVO:"get_pickingCollisionVO",set_staticNode:"set_staticNode",get_staticNode:"get_staticNode",set_shaderPickingDetails:"set_shaderPickingDetails",get_shaderPickingDetails:"get_shaderPickingDetails"})
});
var away3d_cameras_Camera3D = function(lens) {
	this._frustumPlanesDirty = true;
	this._viewProjectionDirty = true;
	this._viewProjection = new openfl_geom_Matrix3D();
	away3d_entities_Entity.call(this);
	this._lens = lens;
	if(this._lens == null) {
		this._lens = new away3d_cameras_lenses_PerspectiveLens();
	}
	this._lens.addEventListener("matrixChanged",$bind(this,this.onLensMatrixChanged));
	this._frustumPlanes = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,6,true);
	this._frustumPlanes.set(0,new away3d_core_math_Plane3D());
	this._frustumPlanes.set(1,new away3d_core_math_Plane3D());
	this._frustumPlanes.set(2,new away3d_core_math_Plane3D());
	this._frustumPlanes.set(3,new away3d_core_math_Plane3D());
	this._frustumPlanes.set(4,new away3d_core_math_Plane3D());
	this._frustumPlanes.set(5,new away3d_core_math_Plane3D());
	this.set_z(-1000);
};
$hxClasses["away3d.cameras.Camera3D"] = away3d_cameras_Camera3D;
away3d_cameras_Camera3D.__name__ = "away3d.cameras.Camera3D";
away3d_cameras_Camera3D.__super__ = away3d_entities_Entity;
away3d_cameras_Camera3D.prototype = $extend(away3d_entities_Entity.prototype,{
	_viewProjection: null
	,_viewProjectionDirty: null
	,_lens: null
	,_frustumPlanes: null
	,_frustumPlanesDirty: null
	,getDefaultBoundingVolume: function() {
		return new away3d_bounds_NullBounds();
	}
	,get_assetType: function() {
		return "camera";
	}
	,onLensMatrixChanged: function(event) {
		this._viewProjectionDirty = true;
		this._frustumPlanesDirty = true;
		this.dispatchEvent(event);
	}
	,get_frustumPlanes: function() {
		if(this._frustumPlanesDirty) {
			this.updateFrustum();
		}
		return this._frustumPlanes;
	}
	,updateFrustum: function() {
		var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
		this.get_viewProjection().copyRawDataTo(raw);
		var c11 = raw.get(0);
		var c12 = raw.get(4);
		var c13 = raw.get(8);
		var c14 = raw.get(12);
		var c21 = raw.get(1);
		var c22 = raw.get(5);
		var c23 = raw.get(9);
		var c24 = raw.get(13);
		var c31 = raw.get(2);
		var c32 = raw.get(6);
		var c33 = raw.get(10);
		var c34 = raw.get(14);
		var c41 = raw.get(3);
		var c42 = raw.get(7);
		var c43 = raw.get(11);
		var c44 = raw.get(15);
		var p = this._frustumPlanes.get(0);
		var a = c41 + c11;
		var b = c42 + c12;
		var c = c43 + c13;
		var invLen = 1 / Math.sqrt(a * a + b * b + c * c);
		p.a = a * invLen;
		p.b = b * invLen;
		p.c = c * invLen;
		p.d = -(c44 + c14) * invLen;
		p = this._frustumPlanes.get(1);
		a = c41 - c11;
		b = c42 - c12;
		c = c43 - c13;
		invLen = 1 / Math.sqrt(a * a + b * b + c * c);
		p.a = a * invLen;
		p.b = b * invLen;
		p.c = c * invLen;
		p.d = (c14 - c44) * invLen;
		p = this._frustumPlanes.get(2);
		a = c41 + c21;
		b = c42 + c22;
		c = c43 + c23;
		invLen = 1 / Math.sqrt(a * a + b * b + c * c);
		p.a = a * invLen;
		p.b = b * invLen;
		p.c = c * invLen;
		p.d = -(c44 + c24) * invLen;
		p = this._frustumPlanes.get(3);
		a = c41 - c21;
		b = c42 - c22;
		c = c43 - c23;
		invLen = 1 / Math.sqrt(a * a + b * b + c * c);
		p.a = a * invLen;
		p.b = b * invLen;
		p.c = c * invLen;
		p.d = (c24 - c44) * invLen;
		p = this._frustumPlanes.get(4);
		a = c31;
		b = c32;
		c = c33;
		invLen = 1 / Math.sqrt(a * a + b * b + c * c);
		p.a = a * invLen;
		p.b = b * invLen;
		p.c = c * invLen;
		p.d = -c34 * invLen;
		p = this._frustumPlanes.get(5);
		a = c41 - c31;
		b = c42 - c32;
		c = c43 - c33;
		invLen = 1 / Math.sqrt(a * a + b * b + c * c);
		p.a = a * invLen;
		p.b = b * invLen;
		p.c = c * invLen;
		p.d = (c34 - c44) * invLen;
		this._frustumPlanesDirty = false;
	}
	,invalidateSceneTransform: function() {
		away3d_entities_Entity.prototype.invalidateSceneTransform.call(this);
		this._viewProjectionDirty = true;
		this._frustumPlanesDirty = true;
	}
	,updateBounds: function() {
		this._bounds.nullify();
		this._boundsInvalid = false;
	}
	,createEntityPartitionNode: function() {
		return new away3d_core_partition_CameraNode(this);
	}
	,get_lens: function() {
		return this._lens;
	}
	,set_lens: function(value) {
		if(this._lens == value) {
			return value;
		}
		if(value == null) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Lens cannot be null!"));
		}
		this._lens.removeEventListener("matrixChanged",$bind(this,this.onLensMatrixChanged));
		this._lens = value;
		this._lens.addEventListener("matrixChanged",$bind(this,this.onLensMatrixChanged));
		this.dispatchEvent(new away3d_events_CameraEvent("lensChanged",this));
		return value;
	}
	,get_viewProjection: function() {
		if(this._viewProjectionDirty) {
			this._viewProjection.copyFrom(this.get_inverseSceneTransform());
			this._viewProjection.append(this._lens.get_matrix());
			this._viewProjectionDirty = false;
		}
		return this._viewProjection;
	}
	,unproject: function(nX,nY,sZ,v) {
		return away3d_core_math_Matrix3DUtils.transformVector(this.get_sceneTransform(),this.get_lens().unproject(nX,nY,sZ,v),v);
	}
	,getRay: function(nX,nY,sZ,v) {
		return away3d_core_math_Matrix3DUtils.deltaTransformVector(this.get_sceneTransform(),this.get_lens().unproject(nX,nY,sZ,v),v);
	}
	,project: function(point3d,v) {
		return this.get_lens().project(away3d_core_math_Matrix3DUtils.transformVector(this.get_inverseSceneTransform(),point3d,v),v);
	}
	,__class__: away3d_cameras_Camera3D
	,__properties__: $extend(away3d_entities_Entity.prototype.__properties__,{get_viewProjection:"get_viewProjection",set_lens:"set_lens",get_lens:"get_lens",get_frustumPlanes:"get_frustumPlanes"})
});
var away3d_cameras_lenses_CoordinateSystem = function() { };
$hxClasses["away3d.cameras.lenses.CoordinateSystem"] = away3d_cameras_lenses_CoordinateSystem;
away3d_cameras_lenses_CoordinateSystem.__name__ = "away3d.cameras.lenses.CoordinateSystem";
var away3d_cameras_lenses_LensBase = function() {
	this._unprojectionInvalid = true;
	this._frustumCorners = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,24,true);
	this._matrixInvalid = true;
	this._aspectRatio = 1;
	this._far = 3000;
	this._near = 20;
	this._viewPort = new openfl_geom_Rectangle();
	this._scissorRect = new openfl_geom_Rectangle();
	openfl_events_EventDispatcher.call(this);
	this._matrix = new openfl_geom_Matrix3D();
};
$hxClasses["away3d.cameras.lenses.LensBase"] = away3d_cameras_lenses_LensBase;
away3d_cameras_lenses_LensBase.__name__ = "away3d.cameras.lenses.LensBase";
away3d_cameras_lenses_LensBase.__super__ = openfl_events_EventDispatcher;
away3d_cameras_lenses_LensBase.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	_matrix: null
	,_scissorRect: null
	,_viewPort: null
	,_near: null
	,_far: null
	,_aspectRatio: null
	,_matrixInvalid: null
	,_frustumCorners: null
	,_unprojection: null
	,_unprojectionInvalid: null
	,get_frustumCorners: function() {
		return this._frustumCorners;
	}
	,set_frustumCorners: function(frustumCorners) {
		this._frustumCorners = frustumCorners;
		return frustumCorners;
	}
	,get_matrix: function() {
		if(this._matrixInvalid) {
			this.updateMatrix();
			this._matrixInvalid = false;
		}
		return this._matrix;
	}
	,set_matrix: function(value) {
		this._matrix = value;
		this.invalidateMatrix();
		return value;
	}
	,get_near: function() {
		return this._near;
	}
	,set_near: function(value) {
		if(value == this._near) {
			return value;
		}
		this._near = value;
		this.invalidateMatrix();
		return value;
	}
	,get_far: function() {
		return this._far;
	}
	,set_far: function(value) {
		if(value == this._far) {
			return value;
		}
		this._far = value;
		this.invalidateMatrix();
		return value;
	}
	,project: function(point3d,v) {
		if(v == null) {
			v = new openfl_geom_Vector3D();
		}
		away3d_core_math_Matrix3DUtils.transformVector(this.get_matrix(),point3d,v);
		v.x /= v.w;
		v.y = -v.y / v.w;
		v.z = point3d.z;
		return v;
	}
	,get_unprojectionMatrix: function() {
		if(this._unprojectionInvalid) {
			if(this._unprojection == null) {
				this._unprojection = new openfl_geom_Matrix3D();
			}
			this._unprojection.copyFrom(this.get_matrix());
			this._unprojection.invert();
			this._unprojectionInvalid = false;
		}
		return this._unprojection;
	}
	,unproject: function(nX,nY,sZ,v) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,clone: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_aspectRatio: function() {
		return this._aspectRatio;
	}
	,set_aspectRatio: function(value) {
		if(this._aspectRatio == value || value * 0 != 0) {
			return value;
		}
		this._aspectRatio = value;
		this.invalidateMatrix();
		return value;
	}
	,invalidateMatrix: function() {
		this._matrixInvalid = true;
		this._unprojectionInvalid = true;
		this.dispatchEvent(new away3d_events_LensEvent("matrixChanged",this));
	}
	,updateMatrix: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,updateScissorRect: function(x,y,width,height) {
		this._scissorRect.x = x;
		this._scissorRect.y = y;
		this._scissorRect.width = width;
		this._scissorRect.height = height;
		this.invalidateMatrix();
	}
	,updateViewport: function(x,y,width,height) {
		this._viewPort.x = x;
		this._viewPort.y = y;
		this._viewPort.width = width;
		this._viewPort.height = height;
		this.invalidateMatrix();
	}
	,__class__: away3d_cameras_lenses_LensBase
	,__properties__: {set_aspectRatio:"set_aspectRatio",get_aspectRatio:"get_aspectRatio",get_unprojectionMatrix:"get_unprojectionMatrix",set_far:"set_far",get_far:"get_far",set_near:"set_near",get_near:"get_near",set_matrix:"set_matrix",get_matrix:"get_matrix",set_frustumCorners:"set_frustumCorners",get_frustumCorners:"get_frustumCorners"}
});
var away3d_cameras_lenses_FreeMatrixLens = function() {
	away3d_cameras_lenses_LensBase.call(this);
	this._matrix.copyFrom(new away3d_cameras_lenses_PerspectiveLens().get_matrix());
};
$hxClasses["away3d.cameras.lenses.FreeMatrixLens"] = away3d_cameras_lenses_FreeMatrixLens;
away3d_cameras_lenses_FreeMatrixLens.__name__ = "away3d.cameras.lenses.FreeMatrixLens";
away3d_cameras_lenses_FreeMatrixLens.__super__ = away3d_cameras_lenses_LensBase;
away3d_cameras_lenses_FreeMatrixLens.prototype = $extend(away3d_cameras_lenses_LensBase.prototype,{
	set_near: function(value) {
		this._near = value;
		return value;
	}
	,set_far: function(value) {
		this._far = value;
		return value;
	}
	,set_aspectRatio: function(value) {
		this._aspectRatio = value;
		return value;
	}
	,clone: function() {
		var clone = new away3d_cameras_lenses_FreeMatrixLens();
		clone._matrix.copyFrom(this._matrix);
		clone._near = this._near;
		clone._far = this._far;
		clone._aspectRatio = this._aspectRatio;
		clone.invalidateMatrix();
		return clone;
	}
	,updateMatrix: function() {
		this._matrixInvalid = false;
	}
	,__class__: away3d_cameras_lenses_FreeMatrixLens
});
var away3d_cameras_lenses_PerspectiveLens = function(fieldOfView,coordinateSystem) {
	if(coordinateSystem == null) {
		coordinateSystem = 0;
	}
	if(fieldOfView == null) {
		fieldOfView = 60;
	}
	away3d_cameras_lenses_LensBase.call(this);
	this.set_fieldOfView(fieldOfView);
	this.set_coordinateSystem(coordinateSystem);
};
$hxClasses["away3d.cameras.lenses.PerspectiveLens"] = away3d_cameras_lenses_PerspectiveLens;
away3d_cameras_lenses_PerspectiveLens.__name__ = "away3d.cameras.lenses.PerspectiveLens";
away3d_cameras_lenses_PerspectiveLens.__super__ = away3d_cameras_lenses_LensBase;
away3d_cameras_lenses_PerspectiveLens.prototype = $extend(away3d_cameras_lenses_LensBase.prototype,{
	_fieldOfView: null
	,_focalLength: null
	,_focalLengthInv: null
	,_yMax: null
	,_xMax: null
	,_coordinateSystem: null
	,get_fieldOfView: function() {
		return this._fieldOfView;
	}
	,set_fieldOfView: function(value) {
		if(value == this._fieldOfView) {
			return value;
		}
		this._fieldOfView = value;
		this._focalLengthInv = Math.tan(this._fieldOfView * Math.PI / 360);
		this._focalLength = 1 / this._focalLengthInv;
		this.invalidateMatrix();
		return value;
	}
	,get_focalLength: function() {
		return this._focalLength;
	}
	,set_focalLength: function(value) {
		if(value == this._focalLength) {
			return value;
		}
		this._focalLength = value;
		this._focalLengthInv = 1 / this._focalLength;
		this._fieldOfView = Math.atan(this._focalLengthInv) * 360 / Math.PI;
		this.invalidateMatrix();
		return value;
	}
	,unproject: function(nX,nY,sZ,v) {
		if(v == null) {
			v = new openfl_geom_Vector3D();
		}
		v.x = nX;
		v.y = -nY;
		v.z = sZ;
		v.w = 1;
		v.x *= sZ;
		v.y *= sZ;
		away3d_core_math_Matrix3DUtils.transformVector(this.get_unprojectionMatrix(),v,v);
		v.z = sZ;
		return v;
	}
	,clone: function() {
		var clone = new away3d_cameras_lenses_PerspectiveLens(this._fieldOfView);
		clone._near = this._near;
		clone._far = this._far;
		clone._aspectRatio = this._aspectRatio;
		clone._coordinateSystem = this._coordinateSystem;
		return clone;
	}
	,get_coordinateSystem: function() {
		return this._coordinateSystem;
	}
	,set_coordinateSystem: function(value) {
		if(value == this._coordinateSystem) {
			return value;
		}
		this._coordinateSystem = value;
		this.invalidateMatrix();
		return value;
	}
	,updateMatrix: function() {
		var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
		this._yMax = this._near * this._focalLengthInv;
		this._xMax = this._yMax * this._aspectRatio;
		var left;
		var right;
		var top;
		var bottom;
		if(this._scissorRect.x == 0 && this._scissorRect.y == 0 && this._scissorRect.width == this._viewPort.width && this._scissorRect.height == this._viewPort.height) {
			left = -this._xMax;
			right = this._xMax;
			top = -this._yMax;
			bottom = this._yMax;
			raw.set(0,this._near / this._xMax);
			raw.set(5,this._near / this._yMax);
			raw.set(10,this._far / (this._far - this._near));
			raw.set(11,1);
			raw.set(1,raw.set(2,raw.set(3,raw.set(4,raw.set(6,raw.set(7,raw.set(8,raw.set(9,raw.set(12,raw.set(13,raw.set(15,0)))))))))));
			raw.set(14,-this._near * raw.get(10));
		} else {
			var xWidth = this._xMax * (this._viewPort.width / this._scissorRect.width);
			var yHgt = this._yMax * (this._viewPort.height / this._scissorRect.height);
			var center = this._xMax * (this._scissorRect.x * 2 - this._viewPort.width) / this._scissorRect.width + this._xMax;
			var middle = -this._yMax * (this._scissorRect.y * 2 - this._viewPort.height) / this._scissorRect.height - this._yMax;
			left = center - xWidth;
			right = center + xWidth;
			top = middle - yHgt;
			bottom = middle + yHgt;
			raw.set(0,2 * this._near / (right - left));
			raw.set(5,2 * this._near / (bottom - top));
			raw.set(8,(right + left) / (right - left));
			raw.set(9,(bottom + top) / (bottom - top));
			raw.set(10,(this._far + this._near) / (this._far - this._near));
			raw.set(11,1);
			raw.set(1,raw.set(2,raw.set(3,raw.set(4,raw.set(6,raw.set(7,raw.set(12,raw.set(13,raw.set(15,0)))))))));
			raw.set(14,-2 * this._far * this._near / (this._far - this._near));
		}
		if(this._coordinateSystem == 1) {
			raw.set(5,-raw.get(5));
		}
		this._matrix.copyRawDataFrom(raw);
		var yMaxFar = this._far * this._focalLengthInv;
		var xMaxFar = yMaxFar * this._aspectRatio;
		this._frustumCorners.set(0,this._frustumCorners.set(9,left));
		this._frustumCorners.set(3,this._frustumCorners.set(6,right));
		this._frustumCorners.set(1,this._frustumCorners.set(4,top));
		this._frustumCorners.set(7,this._frustumCorners.set(10,bottom));
		this._frustumCorners.set(12,this._frustumCorners.set(21,-xMaxFar));
		this._frustumCorners.set(15,this._frustumCorners.set(18,xMaxFar));
		this._frustumCorners.set(13,this._frustumCorners.set(16,-yMaxFar));
		this._frustumCorners.set(19,this._frustumCorners.set(22,yMaxFar));
		this._frustumCorners.set(2,this._frustumCorners.set(5,this._frustumCorners.set(8,this._frustumCorners.set(11,this._near))));
		this._frustumCorners.set(14,this._frustumCorners.set(17,this._frustumCorners.set(20,this._frustumCorners.set(23,this._far))));
		this._matrixInvalid = false;
	}
	,__class__: away3d_cameras_lenses_PerspectiveLens
	,__properties__: $extend(away3d_cameras_lenses_LensBase.prototype.__properties__,{set_focalLength:"set_focalLength",get_focalLength:"get_focalLength",set_fieldOfView:"set_fieldOfView",get_fieldOfView:"get_fieldOfView",set_coordinateSystem:"set_coordinateSystem",get_coordinateSystem:"get_coordinateSystem"})
});
var away3d_containers_Scene3D = function() {
	this._partitions = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this._sceneGraphRoot = new away3d_containers_ObjectContainer3D();
	this._sceneGraphRoot.set_scene(this);
	this._sceneGraphRoot._isRoot = true;
	this._sceneGraphRoot.set_partition(new away3d_core_partition_Partition3D(new away3d_core_partition_NodeBase()));
	openfl_events_EventDispatcher.call(this);
};
$hxClasses["away3d.containers.Scene3D"] = away3d_containers_Scene3D;
away3d_containers_Scene3D.__name__ = "away3d.containers.Scene3D";
away3d_containers_Scene3D.__super__ = openfl_events_EventDispatcher;
away3d_containers_Scene3D.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	_sceneGraphRoot: null
	,_partitions: null
	,traversePartitions: function(traverser) {
		var i = 0;
		var len = this._partitions.get_length();
		traverser.scene = this;
		while(i < len) this._partitions.get(i++).traverse(traverser);
	}
	,get_partition: function() {
		return this._sceneGraphRoot.get_partition();
	}
	,set_partition: function(value) {
		this._sceneGraphRoot.set_partition(value);
		this.dispatchEvent(new away3d_events_Scene3DEvent("partitionChanged",this._sceneGraphRoot));
		return value;
	}
	,contains: function(child) {
		return this._sceneGraphRoot.contains(child);
	}
	,addChild: function(child) {
		return this._sceneGraphRoot.addChild(child);
	}
	,removeChild: function(child) {
		this._sceneGraphRoot.removeChild(child);
	}
	,removeChildAt: function(index) {
		this._sceneGraphRoot.removeChildAt(index);
	}
	,getChildAt: function(index) {
		return this._sceneGraphRoot.getChildAt(index);
	}
	,get_numChildren: function() {
		return this._sceneGraphRoot.get_numChildren();
	}
	,registerEntity: function(entity) {
		var partition = entity.get_implicitPartition();
		this.addPartitionUnique(partition);
		partition.markForUpdate(entity);
	}
	,unregisterEntity: function(entity) {
		entity.get_implicitPartition().removeEntity(entity);
	}
	,invalidateEntityBounds: function(entity) {
		entity.get_implicitPartition().markForUpdate(entity);
	}
	,registerPartition: function(entity) {
		this.addPartitionUnique(entity.get_implicitPartition());
	}
	,unregisterPartition: function(entity) {
		entity.get_implicitPartition().removeEntity(entity);
	}
	,addPartitionUnique: function(partition) {
		if(this._partitions.indexOf(partition,0) == -1) {
			this._partitions.push(partition);
		}
	}
	,__class__: away3d_containers_Scene3D
	,__properties__: {get_numChildren:"get_numChildren",set_partition:"set_partition",get_partition:"get_partition"}
});
var away3d_containers_View3D = function(scene,camera,renderer,forceSoftware,profile,contextIndex) {
	if(contextIndex == null) {
		contextIndex = -1;
	}
	if(profile == null) {
		profile = "baseline";
	}
	if(forceSoftware == null) {
		forceSoftware = false;
	}
	this._contextIndex = -1;
	this._layeredView = false;
	this._viewportDirty = true;
	this._scissorRectDirty = true;
	this._shareContext = false;
	this._rightClickMenuEnabled = true;
	this._backBufferInvalid = true;
	this._depthTextureInvalid = true;
	this._backgroundAlpha = 1;
	this._backgroundColor = 0;
	this._time = 0;
	this._globalHeight = 0;
	this._globalWidth = 0;
	this._globalPos = new openfl_geom_Point();
	this._localBRPos = new openfl_geom_Point();
	this._localTLPos = new openfl_geom_Point();
	this._height = 0;
	this._width = 0;
	openfl_display_Sprite.call(this);
	this._profile = profile;
	this._scene = scene != null ? scene : new away3d_containers_Scene3D();
	this._scene.addEventListener("partitionChanged",$bind(this,this.onScenePartitionChanged));
	this._camera = camera != null ? camera : new away3d_cameras_Camera3D();
	this._renderer = renderer != null ? renderer : new away3d_core_render_DefaultRenderer();
	this._depthRenderer = new away3d_core_render_DepthRenderer();
	this._forceSoftware = forceSoftware;
	this._contextIndex = contextIndex;
	this._entityCollector = this._renderer.createEntityCollector();
	this._entityCollector.set_camera(this._camera);
	this._scissorRect = new openfl_geom_Rectangle();
	this.initHitField();
	this._mouse3DManager = new away3d_core_managers_Mouse3DManager();
	this._mouse3DManager.enableMouseListeners(this);
	this._touch3DManager = new away3d_core_managers_Touch3DManager();
	this._touch3DManager.set_view(this);
	this._touch3DManager.enableTouchListeners(this);
	this.addEventListener("addedToStage",$bind(this,this.onAddedToStage),false,0,true);
	this.addEventListener("added",$bind(this,this.onAdded),false,0,true);
	this._camera.addEventListener("lensChanged",$bind(this,this.onLensChanged));
	this._camera.set_partition(this._scene.get_partition());
};
$hxClasses["away3d.containers.View3D"] = away3d_containers_View3D;
away3d_containers_View3D.__name__ = "away3d.containers.View3D";
away3d_containers_View3D.__super__ = openfl_display_Sprite;
away3d_containers_View3D.prototype = $extend(openfl_display_Sprite.prototype,{
	_width: null
	,_height: null
	,_localTLPos: null
	,_localBRPos: null
	,_globalPos: null
	,_globalWidth: null
	,_globalHeight: null
	,_globalPosDirty: null
	,_scene: null
	,_camera: null
	,_entityCollector: null
	,_aspectRatio: null
	,_time: null
	,_deltaTime: null
	,_backgroundColor: null
	,_backgroundAlpha: null
	,_mouse3DManager: null
	,_touch3DManager: null
	,_renderer: null
	,_depthRenderer: null
	,_addedToStage: null
	,_forceSoftware: null
	,_filter3DRenderer: null
	,_requireDepthRender: null
	,_depthRender: null
	,_depthTextureInvalid: null
	,_hitField: null
	,_parentIsStage: null
	,_background: null
	,_stage3DProxy: null
	,_backBufferInvalid: null
	,_antiAlias: null
	,_rttBufferManager: null
	,_rightClickMenuEnabled: null
	,_sourceURL: null
	,_shareContext: null
	,_scissorRect: null
	,_scissorRectDirty: null
	,_viewportDirty: null
	,_depthPrepass: null
	,_profile: null
	,_layeredView: null
	,_contextIndex: null
	,get_depthPrepass: function() {
		return this._depthPrepass;
	}
	,set_depthPrepass: function(value) {
		this._depthPrepass = value;
		return value;
	}
	,onScenePartitionChanged: function(event) {
		if(this._camera != null) {
			this._camera.set_partition(this.get_scene().get_partition());
		}
	}
	,get_stage3DProxy: function() {
		return this._stage3DProxy;
	}
	,set_stage3DProxy: function(stage3DProxy) {
		if(this._stage3DProxy != null) {
			this._stage3DProxy.removeEventListener("ViewportUpdated",$bind(this,this.onViewportUpdated));
			this._stage3DProxy.removeEventListener("Context3DRecreated",$bind(this,this.onContext3DRecreated));
		}
		this._stage3DProxy = stage3DProxy;
		this._stage3DProxy.addEventListener("ViewportUpdated",$bind(this,this.onViewportUpdated));
		this._stage3DProxy.addEventListener("Context3DRecreated",$bind(this,this.onContext3DRecreated));
		this._renderer.set_stage3DProxy(this._depthRenderer.set_stage3DProxy(this._stage3DProxy));
		this._globalPosDirty = true;
		this._backBufferInvalid = true;
		return this._stage3DProxy;
	}
	,onContext3DRecreated: function(event) {
		this._depthTextureInvalid = true;
	}
	,get_forceMouseMove: function() {
		return this._mouse3DManager.get_forceMouseMove();
	}
	,set_forceMouseMove: function(value) {
		this._mouse3DManager.set_forceMouseMove(value);
		this._touch3DManager.set_forceTouchMove(value);
		return value;
	}
	,get_background: function() {
		return this._background;
	}
	,set_background: function(value) {
		this._background = value;
		this._renderer.set_background(this._background);
		return this._background;
	}
	,get_layeredView: function() {
		return this._layeredView;
	}
	,set_layeredView: function(value) {
		this._layeredView = value;
		return this._layeredView;
	}
	,initHitField: function() {
		this._hitField = new openfl_display_Sprite();
		this._hitField.set_alpha(0);
		this._hitField.doubleClickEnabled = true;
		this._hitField.get_graphics().beginFill(0);
		this._hitField.get_graphics().drawRect(0,0,100,100);
		this.addChild(this._hitField);
	}
	,get_filters3d: function() {
		if(this._filter3DRenderer != null) {
			return this._filter3DRenderer.get_filters();
		} else {
			return null;
		}
	}
	,set_filters3d: function(value) {
		if(value != null && value.length == 0) {
			value = null;
		}
		if(this._filter3DRenderer != null && value == null) {
			this._filter3DRenderer.dispose();
			this._filter3DRenderer = null;
		} else if(this._filter3DRenderer == null && value != null) {
			this._filter3DRenderer = new away3d_core_render_Filter3DRenderer(this.get_stage3DProxy());
			this._filter3DRenderer.set_filters(value);
		}
		if(this._filter3DRenderer != null) {
			this._filter3DRenderer.set_filters(value);
			this._requireDepthRender = this._filter3DRenderer.get_requireDepthRender();
		} else {
			this._requireDepthRender = false;
			if(this._depthRender != null) {
				this._depthRender.dispose();
				this._depthRender = null;
			}
		}
		return value;
	}
	,get_renderer: function() {
		return this._renderer;
	}
	,set_renderer: function(value) {
		this._renderer.dispose();
		this._renderer = value;
		this._entityCollector = this._renderer.createEntityCollector();
		this._entityCollector.set_camera(this._camera);
		this._renderer.set_stage3DProxy(this._stage3DProxy);
		this._renderer.set_antiAlias(this._antiAlias);
		this._renderer.set_backgroundR(_$UInt_UInt_$Impl_$.toFloat(this._backgroundColor >>> 16 & 255) / _$UInt_UInt_$Impl_$.toFloat(255));
		this._renderer.set_backgroundG(_$UInt_UInt_$Impl_$.toFloat(this._backgroundColor >>> 8 & 255) / _$UInt_UInt_$Impl_$.toFloat(255));
		this._renderer.set_backgroundB(_$UInt_UInt_$Impl_$.toFloat(this._backgroundColor & 255) / _$UInt_UInt_$Impl_$.toFloat(255));
		this._renderer.set_backgroundAlpha(this._backgroundAlpha);
		this._renderer.set_viewWidth(this._globalWidth);
		this._renderer.set_viewHeight(this._globalHeight);
		this._backBufferInvalid = true;
		return this._renderer;
	}
	,get_backgroundColor: function() {
		return this._backgroundColor;
	}
	,set_backgroundColor: function(value) {
		this._backgroundColor = value;
		this._renderer.set_backgroundR(_$UInt_UInt_$Impl_$.toFloat(value >>> 16 & 255) / _$UInt_UInt_$Impl_$.toFloat(255));
		this._renderer.set_backgroundG(_$UInt_UInt_$Impl_$.toFloat(value >>> 8 & 255) / _$UInt_UInt_$Impl_$.toFloat(255));
		this._renderer.set_backgroundB(_$UInt_UInt_$Impl_$.toFloat(value & 255) / _$UInt_UInt_$Impl_$.toFloat(255));
		return value;
	}
	,get_backgroundAlpha: function() {
		return this._backgroundAlpha;
	}
	,set_backgroundAlpha: function(value) {
		if(value > 1) {
			value = 1;
		} else if(value < 0) {
			value = 0;
		}
		this._renderer.set_backgroundAlpha(value);
		this._backgroundAlpha = value;
		return value;
	}
	,get_camera: function() {
		return this._camera;
	}
	,set_camera: function(camera) {
		this._camera.removeEventListener("lensChanged",$bind(this,this.onLensChanged));
		this._camera = camera;
		this._entityCollector.set_camera(this._camera);
		if(this._scene != null) {
			this._camera.set_partition(this._scene.get_partition());
		}
		this._camera.addEventListener("lensChanged",$bind(this,this.onLensChanged));
		this._scissorRectDirty = true;
		this._viewportDirty = true;
		return camera;
	}
	,get_scene: function() {
		return this._scene;
	}
	,set_scene: function(scene) {
		this._scene.removeEventListener("partitionChanged",$bind(this,this.onScenePartitionChanged));
		this._scene = scene;
		this._scene.addEventListener("partitionChanged",$bind(this,this.onScenePartitionChanged));
		if(this._camera != null) {
			this._camera.set_partition(this._scene.get_partition());
		}
		return this._scene;
	}
	,deltaTime: null
	,get_deltaTime: function() {
		return this._deltaTime;
	}
	,get_filters: function() {
		throw new js__$Boot_HaxeError(new openfl_errors_Error("filters is not supported in View3D. Use filters3d instead."));
	}
	,set_filters: function(value) {
		throw new js__$Boot_HaxeError(new openfl_errors_Error("filters is not supported in View3D. Use filters3d instead."));
	}
	,get_width: function() {
		return this._width;
	}
	,set_width: function(value) {
		if(this._stage3DProxy != null && this._stage3DProxy.get_usesSoftwareRendering() && value > 2048) {
			value = 2048;
		}
		if(this._width == value) {
			return value;
		}
		this._hitField.set_width(value);
		this._width = value;
		this._localBRPos.x = value + this._localTLPos.x;
		this._globalWidth = this.parent != null ? this.parent.localToGlobal(this._localBRPos).x - this._globalPos.x : value;
		if(this._rttBufferManager != null) {
			this._rttBufferManager.set_viewWidth(this._globalWidth | 0);
		}
		this._aspectRatio = this._globalWidth / this._globalHeight;
		this._camera.get_lens().set_aspectRatio(this._aspectRatio);
		this._depthTextureInvalid = true;
		this._renderer.set_viewWidth(this._globalWidth);
		this._scissorRect.width = this._globalWidth;
		this._backBufferInvalid = true;
		this._scissorRectDirty = true;
		return value;
	}
	,get_height: function() {
		return this._height;
	}
	,set_height: function(value) {
		if(this._stage3DProxy != null && this._stage3DProxy.get_usesSoftwareRendering() && value > 2048) {
			value = 2048;
		}
		if(this._height == value) {
			return value;
		}
		this._hitField.set_height(value);
		this._height = value;
		this._localBRPos.y = value + this._localTLPos.y;
		this._globalHeight = this.parent != null ? this.parent.localToGlobal(this._localBRPos).y - this._globalPos.y : value;
		if(this._rttBufferManager != null) {
			this._rttBufferManager.set_viewHeight(this._globalHeight | 0);
		}
		this._aspectRatio = this._globalWidth / this._globalHeight;
		this._camera.get_lens().set_aspectRatio(this._aspectRatio);
		this._depthTextureInvalid = true;
		this._renderer.set_viewHeight(this._globalHeight);
		this._scissorRect.height = this._globalHeight;
		this._backBufferInvalid = true;
		this._scissorRectDirty = true;
		return value;
	}
	,set_x: function(value) {
		if(this.get_x() == value) {
			return value;
		}
		openfl_display_Sprite.prototype.set_x.call(this,value);
		this._localTLPos.x = value;
		var tmp = this.parent != null ? this.parent.localToGlobal(this._localTLPos).x : value;
		this._globalPos.x = tmp;
		this._globalPosDirty = true;
		return value;
	}
	,set_y: function(value) {
		if(this.get_y() == value) {
			return value;
		}
		openfl_display_Sprite.prototype.set_y.call(this,value);
		this._localTLPos.y = value;
		var tmp = this.parent != null ? this.parent.localToGlobal(this._localTLPos).y : value;
		this._globalPos.y = tmp;
		this._globalPosDirty = true;
		return value;
	}
	,set_visible: function(value) {
		openfl_display_Sprite.prototype.set_visible.call(this,value);
		if(this._stage3DProxy != null && !this._shareContext) {
			this._stage3DProxy.set_visible(value);
		}
		return value;
	}
	,get_antiAlias: function() {
		return this._antiAlias;
	}
	,set_antiAlias: function(value) {
		this._antiAlias = value;
		this._renderer.set_antiAlias(value);
		this._backBufferInvalid = true;
		return this._antiAlias;
	}
	,renderedFacesCount: null
	,get_renderedFacesCount: function() {
		return this._entityCollector.get_numTriangles();
	}
	,get_shareContext: function() {
		return this._shareContext;
	}
	,set_shareContext: function(value) {
		if(this._shareContext == value) {
			return value;
		}
		this._shareContext = value;
		this._globalPosDirty = true;
		return value;
	}
	,updateBackBuffer: function() {
		if(this._stage3DProxy.get_context3D() != null && !this._shareContext) {
			if(this._globalWidth > 0 && this._globalHeight > 0) {
				if(this._stage3DProxy.get_usesSoftwareRendering()) {
					if(this._globalWidth > 2048) {
						this._globalWidth = 2048;
					}
					if(this._globalHeight > 2048) {
						this._globalHeight = 2048;
					}
				}
				this._stage3DProxy.configureBackBuffer(this._globalWidth | 0,this._globalHeight | 0,this._antiAlias,true);
				this._backBufferInvalid = false;
			} else {
				var stageBR = new openfl_geom_Point(this.stage.get_x() + this.stage.stageWidth,this.stage.get_y() + this.stage.stageHeight);
				this.set_width(this.parent != null ? this.parent.globalToLocal(stageBR).x - this._localTLPos.x : this.stage.stageWidth);
				this.set_height(this.parent != null ? this.parent.globalToLocal(stageBR).y - this._localTLPos.y : this.stage.stageHeight);
			}
		}
	}
	,render: function() {
		away3d_core_managers_Stage3DProxy.drawTriangleCount = 0;
		if(this.get_stage3DProxy().get_context3D() == null || !this.get_stage3DProxy().recoverFromDisposal()) {
			this._backBufferInvalid = true;
			return;
		}
		if(this._backBufferInvalid) {
			this.updateBackBuffer();
		}
		if(this._shareContext && this._layeredView) {
			this.get_stage3DProxy().clearDepthBuffer();
		}
		if(!this._parentIsStage) {
			var globalPos = this.parent.localToGlobal(this._localTLPos);
			if(this._globalPos.x != globalPos.x || this._globalPos.y != globalPos.y) {
				this._globalPos = globalPos;
				this._globalPosDirty = true;
			}
		}
		if(this._globalPosDirty) {
			this.updateGlobalPos();
		}
		this.updateTime();
		this.updateViewSizeData();
		this._entityCollector.clear();
		this._scene.traversePartitions(this._entityCollector);
		this._mouse3DManager.updateCollider(this);
		this._touch3DManager.updateCollider();
		if(this._requireDepthRender) {
			this.renderSceneDepthToTexture(this._entityCollector);
		}
		if(this._depthPrepass) {
			this.renderDepthPrepass(this._entityCollector);
		}
		this._renderer.set_clearOnRender(!this._depthPrepass);
		if(this._filter3DRenderer != null && this._stage3DProxy.get_context3D() != null) {
			this._renderer.render(this._entityCollector,this._filter3DRenderer.getMainInputTexture(this._stage3DProxy),this._rttBufferManager.get_renderToTextureRect());
			this._filter3DRenderer.render(this._stage3DProxy,this.get_camera(),this._depthRender);
		} else {
			this._renderer.set_shareContext(this._shareContext);
			if(this._shareContext) {
				this._renderer.render(this._entityCollector,null,this._scissorRect);
			} else {
				this._renderer.render(this._entityCollector);
			}
		}
		if(!this._shareContext) {
			this.get_stage3DProxy().present();
			this._mouse3DManager.fireMouseEvents();
			this._touch3DManager.fireTouchEvents();
		}
		this._entityCollector.cleanUp();
		this.get_stage3DProxy().set_bufferClear(false);
	}
	,updateGlobalPos: function() {
		this._globalPosDirty = false;
		if(this._stage3DProxy == null) {
			return;
		}
		if(this._shareContext) {
			var tmp = this._globalPos.x;
			var tmp1 = this._stage3DProxy.get_x();
			this._scissorRect.x = tmp - tmp1;
			var tmp2 = this._globalPos.y;
			var tmp3 = this._stage3DProxy.get_y();
			this._scissorRect.y = tmp2 - tmp3;
		} else {
			this._scissorRect.x = 0;
			this._scissorRect.y = 0;
			this._stage3DProxy.set_x(this._globalPos.x);
			this._stage3DProxy.set_y(this._globalPos.y);
		}
		this._scissorRectDirty = true;
	}
	,updateTime: function() {
		var time = openfl_Lib.getTimer();
		if(this._time == 0) {
			this._time = time;
		}
		this._deltaTime = time - this._time;
		this._time = time;
	}
	,updateViewSizeData: function() {
		this._camera.get_lens().set_aspectRatio(this._aspectRatio);
		if(this._scissorRectDirty) {
			this._scissorRectDirty = false;
			this._camera.get_lens().updateScissorRect(this._scissorRect.x,this._scissorRect.y,this._scissorRect.width,this._scissorRect.height);
		}
		if(this._viewportDirty) {
			this._viewportDirty = false;
			this._camera.get_lens().updateViewport(this._stage3DProxy.get_viewPort().x,this._stage3DProxy.get_viewPort().y,this._stage3DProxy.get_viewPort().width,this._stage3DProxy.get_viewPort().height);
		}
		if(this._filter3DRenderer != null || this._renderer.get_renderToTexture()) {
			this._renderer.set_textureRatioX(this._rttBufferManager.get_textureRatioX());
			this._renderer.set_textureRatioY(this._rttBufferManager.get_textureRatioY());
		} else {
			this._renderer.set_textureRatioX(1);
			this._renderer.set_textureRatioY(1);
		}
	}
	,renderDepthPrepass: function(entityCollector) {
		this._depthRenderer.set_disableColor(true);
		if(this._filter3DRenderer != null || this._renderer.get_renderToTexture()) {
			this._depthRenderer.set_textureRatioX(this._rttBufferManager.get_textureRatioX());
			this._depthRenderer.set_textureRatioY(this._rttBufferManager.get_textureRatioY());
			this._depthRenderer.render(entityCollector,this._filter3DRenderer.getMainInputTexture(this._stage3DProxy),this._rttBufferManager.get_renderToTextureRect());
		} else {
			this._depthRenderer.set_textureRatioX(1);
			this._depthRenderer.set_textureRatioY(1);
			this._depthRenderer.render(entityCollector);
		}
		this._depthRenderer.set_disableColor(false);
	}
	,renderSceneDepthToTexture: function(entityCollector) {
		if(this._depthTextureInvalid || this._depthRender == null) {
			this.initDepthTexture(this._stage3DProxy.get_context3D());
		}
		this._depthRenderer.set_textureRatioX(this._rttBufferManager.get_textureRatioX());
		this._depthRenderer.set_textureRatioY(this._rttBufferManager.get_textureRatioY());
		this._depthRenderer.render(entityCollector,this._depthRender);
	}
	,initDepthTexture: function(context) {
		this._depthTextureInvalid = false;
		if(this._depthRender != null) {
			this._depthRender.dispose();
		}
		this._depthRender = context.createTexture(this._rttBufferManager.get_textureWidth(),this._rttBufferManager.get_textureHeight(),1,true);
	}
	,dispose: function() {
		this._stage3DProxy.removeEventListener("ViewportUpdated",$bind(this,this.onViewportUpdated));
		this._stage3DProxy.removeEventListener("Context3DRecreated",$bind(this,this.onContext3DRecreated));
		if(!this.get_shareContext()) {
			this._stage3DProxy.dispose();
		}
		this._renderer.dispose();
		if(this._depthRender != null) {
			this._depthRender.dispose();
		}
		if(this._rttBufferManager != null) {
			this._rttBufferManager.dispose();
		}
		this._mouse3DManager.disableMouseListeners(this);
		this._mouse3DManager.dispose();
		this._touch3DManager.disableTouchListeners(this);
		this._touch3DManager.dispose();
		this._rttBufferManager = null;
		this._depthRender = null;
		this._mouse3DManager = null;
		this._touch3DManager = null;
		this._depthRenderer = null;
		this._stage3DProxy = null;
		this._renderer = null;
		this._entityCollector = null;
	}
	,project: function(point3d) {
		var v = this._camera.project(point3d);
		v.x = (v.x + 1.0) * this._globalWidth / 2.0;
		v.y = (v.y + 1.0) * this._globalHeight / 2.0;
		return v;
	}
	,unproject: function(sX,sY,sZ,v) {
		return this._camera.unproject(((sX - this._globalPos.x) * 2 - this._globalWidth) / this._stage3DProxy.get_width(),((sY - this._globalPos.y) * 2 - this._globalHeight) / this._stage3DProxy.get_height(),sZ,v);
	}
	,getRay: function(sX,sY,sZ) {
		return this._camera.getRay(((sX - this._globalPos.x) * 2 - this._globalWidth) / this._globalWidth,((sY - this._globalPos.y) * 2 - this._globalHeight) / this._globalHeight,sZ);
	}
	,get_mousePicker: function() {
		return this._mouse3DManager.get_mousePicker();
	}
	,set_mousePicker: function(value) {
		this._mouse3DManager.set_mousePicker(value);
		return value;
	}
	,get_touchPicker: function() {
		return this._touch3DManager.get_touchPicker();
	}
	,set_touchPicker: function(value) {
		this._touch3DManager.set_touchPicker(value);
		return value;
	}
	,entityCollector: null
	,get_entityCollector: function() {
		return this._entityCollector;
	}
	,onLensChanged: function(event) {
		this._scissorRectDirty = true;
		this._viewportDirty = true;
	}
	,onAddedToStage: function(event) {
		if(this._addedToStage) {
			return;
		}
		this._addedToStage = true;
		if(this._stage3DProxy == null) {
			if(this._contextIndex == -1) {
				this._stage3DProxy = away3d_core_managers_Stage3DManager.getInstance(this.stage).getFreeStage3DProxy(this._forceSoftware,this._profile);
			} else {
				this._stage3DProxy = away3d_core_managers_Stage3DManager.getInstance(this.stage).getStage3DProxy(this._contextIndex,this._forceSoftware,this._profile);
			}
			this._stage3DProxy.addEventListener("ViewportUpdated",$bind(this,this.onViewportUpdated));
			this._stage3DProxy.addEventListener("Context3DRecreated",$bind(this,this.onContext3DRecreated));
		}
		this._globalPosDirty = true;
		this._rttBufferManager = away3d_core_managers_RTTBufferManager.getInstance(this._stage3DProxy);
		this._renderer.set_stage3DProxy(this._depthRenderer.set_stage3DProxy(this._stage3DProxy));
		var stageBR = new openfl_geom_Point(this.stage.get_x() + this.stage.stageWidth,this.stage.get_y() + this.stage.stageHeight);
		if(this._globalWidth == 0) {
			this.set_width(this.parent != null ? this.parent.globalToLocal(stageBR).x - this._localTLPos.x : this.stage.stageWidth);
		} else {
			this._rttBufferManager.set_viewWidth(this._globalWidth | 0);
		}
		if(this._globalHeight == 0) {
			this.set_height(this.parent != null ? this.parent.globalToLocal(stageBR).y - this._localTLPos.y : this.stage.stageHeight);
		} else {
			this._rttBufferManager.set_viewHeight(this._globalHeight | 0);
		}
		if(this._shareContext) {
			this._mouse3DManager.addViewLayer(this);
		}
	}
	,onAdded: function(event) {
		this._parentIsStage = this.parent == this.stage;
		this._globalPos = this.parent.localToGlobal(this._localTLPos);
		this._globalPosDirty = true;
	}
	,onViewportUpdated: function(event) {
		if(this._shareContext) {
			var tmp = this._globalPos.x;
			var tmp1 = this._stage3DProxy.get_x();
			this._scissorRect.x = tmp - tmp1;
			var tmp2 = this._globalPos.y;
			var tmp3 = this._stage3DProxy.get_y();
			this._scissorRect.y = tmp2 - tmp3;
			this._scissorRect.width = this._globalWidth;
			this._scissorRect.height = this._globalHeight;
			this._scissorRectDirty = true;
		}
		this._viewportDirty = true;
	}
	,__class__: away3d_containers_View3D
	,__properties__: $extend(openfl_display_Sprite.prototype.__properties__,{get_entityCollector:"get_entityCollector",set_touchPicker:"set_touchPicker",get_touchPicker:"get_touchPicker",set_mousePicker:"set_mousePicker",get_mousePicker:"get_mousePicker",set_shareContext:"set_shareContext",get_shareContext:"get_shareContext",get_renderedFacesCount:"get_renderedFacesCount",set_antiAlias:"set_antiAlias",get_antiAlias:"get_antiAlias",get_deltaTime:"get_deltaTime",set_scene:"set_scene",get_scene:"get_scene",set_camera:"set_camera",get_camera:"get_camera",set_backgroundAlpha:"set_backgroundAlpha",get_backgroundAlpha:"get_backgroundAlpha",set_backgroundColor:"set_backgroundColor",get_backgroundColor:"get_backgroundColor",set_renderer:"set_renderer",get_renderer:"get_renderer",set_filters3d:"set_filters3d",get_filters3d:"get_filters3d",set_layeredView:"set_layeredView",get_layeredView:"get_layeredView",set_background:"set_background",get_background:"get_background",set_forceMouseMove:"set_forceMouseMove",get_forceMouseMove:"get_forceMouseMove",set_stage3DProxy:"set_stage3DProxy",get_stage3DProxy:"get_stage3DProxy",set_depthPrepass:"set_depthPrepass",get_depthPrepass:"get_depthPrepass"})
});
var away3d_controllers_ControllerBase = function(targetObject) {
	this._autoUpdate = true;
	this.set_targetObject(targetObject);
};
$hxClasses["away3d.controllers.ControllerBase"] = away3d_controllers_ControllerBase;
away3d_controllers_ControllerBase.__name__ = "away3d.controllers.ControllerBase";
away3d_controllers_ControllerBase.prototype = {
	_autoUpdate: null
	,_targetObject: null
	,notifyUpdate: function() {
		if(this._targetObject != null && this._targetObject.get_implicitPartition() != null && this._autoUpdate) {
			this._targetObject.get_implicitPartition().markForUpdate(this._targetObject);
		}
	}
	,get_targetObject: function() {
		return this._targetObject;
	}
	,set_targetObject: function(val) {
		if(this._targetObject == val) {
			return val;
		}
		if(this._targetObject != null && this._autoUpdate) {
			this._targetObject._controller = null;
		}
		this._targetObject = val;
		if(this._targetObject != null && this._autoUpdate) {
			this._targetObject._controller = this;
		}
		this.notifyUpdate();
		return val;
	}
	,get_autoUpdate: function() {
		return this._autoUpdate;
	}
	,set_autoUpdate: function(val) {
		if(this._autoUpdate == val) {
			return val;
		}
		this._autoUpdate = val;
		if(this._targetObject != null) {
			if(this._autoUpdate) {
				this._targetObject._controller = this;
			} else {
				this._targetObject._controller = null;
			}
		}
		return val;
	}
	,update: function(interpolate) {
		if(interpolate == null) {
			interpolate = true;
		}
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,__class__: away3d_controllers_ControllerBase
	,__properties__: {set_autoUpdate:"set_autoUpdate",get_autoUpdate:"get_autoUpdate",set_targetObject:"set_targetObject",get_targetObject:"get_targetObject"}
};
var away3d_core_base_SubGeometryBase = function() {
	this._uvsDirty = true;
	this._scaleV = 1;
	this._scaleU = 1;
	this._vertexTangentsDirty = true;
	this._vertexNormalsDirty = true;
	this._useFaceWeights = false;
	this._autoGenerateUVs = false;
	this._autoDeriveVertexTangents = true;
	this._autoDeriveVertexNormals = true;
	this._indicesInvalid = openfl__$Vector_Vector_$Impl_$.toBoolVector(null,8,true);
	this._indexBufferContext = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._indexBuffer = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._faceTangentsDirty = true;
	this._faceNormalsDirty = true;
};
$hxClasses["away3d.core.base.SubGeometryBase"] = away3d_core_base_SubGeometryBase;
away3d_core_base_SubGeometryBase.__name__ = "away3d.core.base.SubGeometryBase";
away3d_core_base_SubGeometryBase.prototype = {
	_parentGeometry: null
	,_vertexData: null
	,_faceNormalsDirty: null
	,_faceTangentsDirty: null
	,_faceTangents: null
	,_indices: null
	,_indexBuffer: null
	,_numIndices: null
	,_indexBufferContext: null
	,_indicesInvalid: null
	,_numTriangles: null
	,_autoDeriveVertexNormals: null
	,_autoDeriveVertexTangents: null
	,_autoGenerateUVs: null
	,_useFaceWeights: null
	,_vertexNormalsDirty: null
	,_vertexTangentsDirty: null
	,_faceNormals: null
	,_faceWeights: null
	,_scaleU: null
	,_scaleV: null
	,_uvsDirty: null
	,get_autoGenerateDummyUVs: function() {
		return this._autoGenerateUVs;
	}
	,set_autoGenerateDummyUVs: function(value) {
		this._autoGenerateUVs = value;
		this._uvsDirty = value;
		return value;
	}
	,get_autoDeriveVertexNormals: function() {
		return this._autoDeriveVertexNormals;
	}
	,set_autoDeriveVertexNormals: function(value) {
		this._autoDeriveVertexNormals = value;
		this._vertexNormalsDirty = value;
		return value;
	}
	,get_useFaceWeights: function() {
		return this._useFaceWeights;
	}
	,set_useFaceWeights: function(value) {
		this._useFaceWeights = value;
		if(this._autoDeriveVertexNormals) {
			this._vertexNormalsDirty = true;
		}
		if(this._autoDeriveVertexTangents) {
			this._vertexTangentsDirty = true;
		}
		this._faceNormalsDirty = true;
		return value;
	}
	,get_numTriangles: function() {
		return this._numTriangles;
	}
	,getIndexBuffer: function(stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(this._indexBuffer.get(contextIndex) == null || this._indexBufferContext.get(contextIndex) != context) {
			this._indexBuffer.set(contextIndex,stage3DProxy.createIndexBuffer(this._numIndices));
			this._indexBufferContext.set(contextIndex,context);
			this._indicesInvalid.set(contextIndex,true);
		}
		if(this._indicesInvalid.get(contextIndex)) {
			this._indexBuffer.get(contextIndex).uploadFromVector(this._indices,0,this._numIndices);
			this._indicesInvalid.set(contextIndex,false);
		}
		return this._indexBuffer.get(contextIndex);
	}
	,updateFaceTangents: function() {
		var i = 0;
		var index1;
		var index2;
		var index3;
		var len = this._indices.get_length();
		var ui;
		var vi;
		var v0;
		var dv1;
		var dv2;
		var denom;
		var x0;
		var y0;
		var z0;
		var dx1;
		var dy1;
		var dz1;
		var dx2;
		var dy2;
		var dz2;
		var cx;
		var cy;
		var cz;
		var vertices = this._vertexData;
		var uvs = this.get_UVData();
		var posStride = this.get_vertexStride();
		var posOffset = this.get_vertexOffset();
		var texStride = this.get_UVStride();
		var texOffset = this.get_UVOffset();
		if(this._faceTangents == null) {
			this._faceTangents = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,this._indices.get_length(),true);
		}
		while(i < len) {
			index1 = this._indices.get(i);
			index2 = this._indices.get(i + 1);
			index3 = this._indices.get(i + 2);
			ui = texOffset + index1 * texStride + 1;
			v0 = uvs.get(ui);
			ui = texOffset + index2 * texStride + 1;
			dv1 = uvs.get(ui) - v0;
			ui = texOffset + index3 * texStride + 1;
			dv2 = uvs.get(ui) - v0;
			vi = posOffset + index1 * posStride;
			x0 = vertices.get(vi);
			y0 = vertices.get(vi + 1);
			z0 = vertices.get(vi + 2);
			vi = posOffset + index2 * posStride;
			dx1 = vertices.get(vi) - x0;
			dy1 = vertices.get(vi + 1) - y0;
			dz1 = vertices.get(vi + 2) - z0;
			vi = posOffset + index3 * posStride;
			dx2 = vertices.get(vi) - x0;
			dy2 = vertices.get(vi + 1) - y0;
			dz2 = vertices.get(vi + 2) - z0;
			cx = dv2 * dx1 - dv1 * dx2;
			cy = dv2 * dy1 - dv1 * dy2;
			cz = dv2 * dz1 - dv1 * dz2;
			denom = 1 / Math.sqrt(cx * cx + cy * cy + cz * cz);
			this._faceTangents.set(i++,denom * cx);
			this._faceTangents.set(i++,denom * cy);
			this._faceTangents.set(i++,denom * cz);
		}
		this._faceTangentsDirty = false;
	}
	,updateFaceNormals: function() {
		var i = 0;
		var j = 0;
		var k = 0;
		var index;
		var len = this._indices.get_length();
		var x1;
		var x2;
		var x3;
		var y1;
		var y2;
		var y3;
		var z1;
		var z2;
		var z3;
		var dx1;
		var dy1;
		var dz1;
		var dx2;
		var dy2;
		var dz2;
		var cx;
		var cy;
		var cz;
		var d;
		var vertices = this._vertexData;
		var posStride = this.get_vertexStride();
		var posOffset = this.get_vertexOffset();
		if(this._faceNormals == null) {
			this._faceNormals = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,len,true);
		}
		if(this._faceWeights == null) {
			this._faceWeights = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,len / 3 | 0,true);
		}
		while(i < len) {
			index = posOffset + this._indices.get(i++) * posStride;
			x1 = vertices.get(index);
			y1 = vertices.get(index + 1);
			z1 = vertices.get(index + 2);
			index = posOffset + this._indices.get(i++) * posStride;
			x2 = vertices.get(index);
			y2 = vertices.get(index + 1);
			z2 = vertices.get(index + 2);
			index = posOffset + this._indices.get(i++) * posStride;
			x3 = vertices.get(index);
			y3 = vertices.get(index + 1);
			z3 = vertices.get(index + 2);
			dx1 = x3 - x1;
			dy1 = y3 - y1;
			dz1 = z3 - z1;
			dx2 = x2 - x1;
			dy2 = y2 - y1;
			dz2 = z2 - z1;
			cx = dz1 * dy2 - dy1 * dz2;
			cy = dx1 * dz2 - dz1 * dx2;
			cz = dy1 * dx2 - dx1 * dy2;
			d = Math.sqrt(cx * cx + cy * cy + cz * cz);
			if(this._useFaceWeights) {
				var w = d * 10000;
				if(w < 1) {
					w = 1;
				}
				this._faceWeights.set(k++,w);
			}
			d = 1 / d;
			this._faceNormals.set(j++,cx * d);
			this._faceNormals.set(j++,cy * d);
			this._faceNormals.set(j++,cz * d);
		}
		this._faceNormalsDirty = false;
	}
	,updateVertexNormals: function(target) {
		if(this._faceNormalsDirty) {
			this.updateFaceNormals();
		}
		var f1 = 0;
		var f2 = 1;
		var f3 = 2;
		var lenV = this._vertexData.get_length();
		var normalStride = this.get_vertexNormalStride();
		var normalOffset = this.get_vertexNormalOffset();
		if(target == null) {
			target = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,lenV,true);
		}
		var v1 = normalOffset;
		while(v1 < lenV) {
			target.set(v1,0.0);
			target.set(v1 + 1,0.0);
			target.set(v1 + 2,0.0);
			v1 += normalStride;
		}
		var i = 0;
		var k = 0;
		var lenI = this._indices.get_length();
		var index;
		var weight;
		while(i < lenI) {
			weight = this._useFaceWeights ? this._faceWeights.get(k++) : 1;
			index = normalOffset + this._indices.get(i++) * normalStride;
			var _g = index++;
			var _g1 = target;
			_g1.set(_g,_g1.get(_g) + this._faceNormals.get(f1) * weight);
			var _g2 = index++;
			var _g11 = target;
			_g11.set(_g2,_g11.get(_g2) + this._faceNormals.get(f2) * weight);
			var _g3 = index;
			var _g12 = target;
			_g12.set(_g3,_g12.get(_g3) + this._faceNormals.get(f3) * weight);
			index = normalOffset + this._indices.get(i++) * normalStride;
			var _g4 = index++;
			var _g13 = target;
			_g13.set(_g4,_g13.get(_g4) + this._faceNormals.get(f1) * weight);
			var _g5 = index++;
			var _g14 = target;
			_g14.set(_g5,_g14.get(_g5) + this._faceNormals.get(f2) * weight);
			var _g6 = index;
			var _g15 = target;
			_g15.set(_g6,_g15.get(_g6) + this._faceNormals.get(f3) * weight);
			index = normalOffset + this._indices.get(i++) * normalStride;
			var _g7 = index++;
			var _g16 = target;
			_g16.set(_g7,_g16.get(_g7) + this._faceNormals.get(f1) * weight);
			var _g8 = index++;
			var _g17 = target;
			_g17.set(_g8,_g17.get(_g8) + this._faceNormals.get(f2) * weight);
			var _g9 = index;
			var _g18 = target;
			_g18.set(_g9,_g18.get(_g9) + this._faceNormals.get(f3) * weight);
			f1 += 3;
			f2 += 3;
			f3 += 3;
		}
		v1 = normalOffset;
		while(v1 < lenV) {
			var vx = target.get(v1);
			var vy = target.get(v1 + 1);
			var vz = target.get(v1 + 2);
			var d = 1.0 / Math.sqrt(vx * vx + vy * vy + vz * vz);
			target.set(v1,vx * d);
			target.set(v1 + 1,vy * d);
			target.set(v1 + 2,vz * d);
			v1 += normalStride;
		}
		this._vertexNormalsDirty = false;
		return target;
	}
	,updateVertexTangents: function(target) {
		if(this._faceTangentsDirty) {
			this.updateFaceTangents();
		}
		var i = 0;
		var lenV = this._vertexData.get_length();
		var tangentStride = this.get_vertexTangentStride();
		var tangentOffset = this.get_vertexTangentOffset();
		if(target == null) {
			target = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,lenV,true);
		}
		i = tangentOffset;
		while(i < lenV) {
			target.set(i,0.0);
			target.set(i + 1,0.0);
			target.set(i + 2,0.0);
			i += tangentStride;
		}
		var k = 0;
		var lenI = this._indices.get_length();
		var index;
		var weight;
		var f1 = 0;
		var f2 = 1;
		var f3 = 2;
		i = 0;
		while(i < lenI) {
			weight = this._useFaceWeights ? this._faceWeights.get(k++) : 1;
			index = tangentOffset + this._indices.get(i++) * tangentStride;
			var _g = index++;
			var _g1 = target;
			_g1.set(_g,_g1.get(_g) + this._faceTangents.get(f1) * weight);
			var _g2 = index++;
			var _g11 = target;
			_g11.set(_g2,_g11.get(_g2) + this._faceTangents.get(f2) * weight);
			var _g3 = index;
			var _g12 = target;
			_g12.set(_g3,_g12.get(_g3) + this._faceTangents.get(f3) * weight);
			index = tangentOffset + this._indices.get(i++) * tangentStride;
			var _g4 = index++;
			var _g13 = target;
			_g13.set(_g4,_g13.get(_g4) + this._faceTangents.get(f1) * weight);
			var _g5 = index++;
			var _g14 = target;
			_g14.set(_g5,_g14.get(_g5) + this._faceTangents.get(f2) * weight);
			var _g6 = index;
			var _g15 = target;
			_g15.set(_g6,_g15.get(_g6) + this._faceTangents.get(f3) * weight);
			index = tangentOffset + this._indices.get(i++) * tangentStride;
			var _g7 = index++;
			var _g16 = target;
			_g16.set(_g7,_g16.get(_g7) + this._faceTangents.get(f1) * weight);
			var _g8 = index++;
			var _g17 = target;
			_g17.set(_g8,_g17.get(_g8) + this._faceTangents.get(f2) * weight);
			var _g9 = index;
			var _g18 = target;
			_g18.set(_g9,_g18.get(_g9) + this._faceTangents.get(f3) * weight);
			f1 += 3;
			f2 += 3;
			f3 += 3;
		}
		i = tangentOffset;
		while(i < lenV) {
			var vx = target.get(i);
			var vy = target.get(i + 1);
			var vz = target.get(i + 2);
			var d = 1.0 / Math.sqrt(vx * vx + vy * vy + vz * vz);
			target.set(i,vx * d);
			target.set(i + 1,vy * d);
			target.set(i + 2,vz * d);
			i += tangentStride;
		}
		this._vertexTangentsDirty = false;
		return target;
	}
	,dispose: function() {
		this.disposeIndexBuffers(this._indexBuffer);
		this._indices = null;
		this._indexBufferContext = null;
		this._faceNormals = null;
		this._faceWeights = null;
		this._faceTangents = null;
		this._vertexData = null;
	}
	,get_indexData: function() {
		return this._indices;
	}
	,updateIndexData: function(indices) {
		this._indices = indices;
		this._numIndices = indices.get_length();
		var numTriangles = this._numIndices / 3 | 0;
		if(this._numTriangles != numTriangles) {
			this.disposeIndexBuffers(this._indexBuffer);
		}
		this._numTriangles = numTriangles;
		this.invalidateBuffers(this._indicesInvalid);
		this._faceNormalsDirty = true;
		if(this._autoDeriveVertexNormals) {
			this._vertexNormalsDirty = true;
		}
		if(this._autoDeriveVertexTangents) {
			this._vertexTangentsDirty = true;
		}
	}
	,disposeIndexBuffers: function(buffers) {
		if(buffers.get(0) != null) {
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(buffers.get(0));
			buffers.set(0,null);
		}
		if(buffers.get(1) != null) {
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(buffers.get(1));
			buffers.set(1,null);
		}
		if(buffers.get(2) != null) {
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(buffers.get(2));
			buffers.set(2,null);
		}
		if(buffers.get(3) != null) {
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(buffers.get(3));
			buffers.set(3,null);
		}
		if(buffers.get(4) != null) {
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(buffers.get(4));
			buffers.set(4,null);
		}
		if(buffers.get(5) != null) {
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(buffers.get(5));
			buffers.set(5,null);
		}
		if(buffers.get(6) != null) {
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(buffers.get(6));
			buffers.set(6,null);
		}
		if(buffers.get(7) != null) {
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(buffers.get(7));
			buffers.set(7,null);
		}
	}
	,disposeVertexBuffers: function(buffers) {
		if(buffers.get(0) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(buffers.get(0));
			buffers.set(0,null);
		}
		if(buffers.get(1) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(buffers.get(1));
			buffers.set(1,null);
		}
		if(buffers.get(2) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(buffers.get(2));
			buffers.set(2,null);
		}
		if(buffers.get(3) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(buffers.get(3));
			buffers.set(3,null);
		}
		if(buffers.get(4) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(buffers.get(4));
			buffers.set(4,null);
		}
		if(buffers.get(5) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(buffers.get(5));
			buffers.set(5,null);
		}
		if(buffers.get(6) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(buffers.get(6));
			buffers.set(6,null);
		}
		if(buffers.get(7) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(buffers.get(7));
			buffers.set(7,null);
		}
	}
	,get_autoDeriveVertexTangents: function() {
		return this._autoDeriveVertexTangents;
	}
	,set_autoDeriveVertexTangents: function(value) {
		this._autoDeriveVertexTangents = value;
		this._vertexTangentsDirty = value;
		return value;
	}
	,get_faceNormals: function() {
		if(this._faceNormalsDirty) {
			this.updateFaceNormals();
		}
		return this._faceNormals;
	}
	,invalidateBuffers: function(invalid) {
		invalid.set(0,true);
		invalid.set(1,true);
		invalid.set(2,true);
		invalid.set(3,true);
		invalid.set(4,true);
		invalid.set(5,true);
		invalid.set(6,true);
		invalid.set(7,true);
	}
	,get_UVStride: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_vertexData: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_vertexPositionData: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_vertexNormalData: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_vertexTangentData: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_UVData: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_vertexStride: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_vertexNormalStride: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_vertexTangentStride: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_vertexOffset: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_vertexNormalOffset: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_vertexTangentOffset: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_UVOffset: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,invalidateBounds: function() {
		if(this._parentGeometry != null) {
			this._parentGeometry.invalidateBounds(js_Boot.__cast(this , away3d_core_base_ISubGeometry));
		}
	}
	,get_parentGeometry: function() {
		return this._parentGeometry;
	}
	,set_parentGeometry: function(value) {
		this._parentGeometry = value;
		return value;
	}
	,get_scaleU: function() {
		return this._scaleU;
	}
	,get_scaleV: function() {
		return this._scaleV;
	}
	,scaleUV: function(scaleU,scaleV) {
		if(scaleV == null) {
			scaleV = 1;
		}
		if(scaleU == null) {
			scaleU = 1;
		}
		var offset = this.get_UVOffset();
		var stride = this.get_UVStride();
		var uvs = this.get_UVData();
		var len = uvs.get_length();
		var ratioU = scaleU / this._scaleU;
		var ratioV = scaleV / this._scaleV;
		var i = offset;
		while(i < len) {
			var _g = i;
			var _g1 = uvs;
			_g1.set(_g,_g1.get(_g) * ratioU);
			var _g2 = i + 1;
			var _g11 = uvs;
			_g11.set(_g2,_g11.get(_g2) * ratioV);
			i += stride;
		}
		this._scaleU = scaleU;
		this._scaleV = scaleV;
	}
	,scale: function(scale) {
		var vertices = this.get_UVData();
		var len = vertices.get_length();
		var offset = this.get_vertexOffset();
		var stride = this.get_vertexStride();
		var i = offset;
		while(i < len) {
			var _g = i;
			var _g1 = vertices;
			_g1.set(_g,_g1.get(_g) * scale);
			var _g2 = i + 1;
			var _g11 = vertices;
			_g11.set(_g2,_g11.get(_g2) * scale);
			var _g3 = i + 2;
			var _g12 = vertices;
			_g12.set(_g3,_g12.get(_g3) * scale);
			i += stride;
		}
	}
	,applyTransformation: function(transform) {
		var vertices = this._vertexData;
		var normals = this.get_vertexNormalData();
		var tangents = this.get_vertexTangentData();
		var posStride = this.get_vertexStride();
		var normalStride = this.get_vertexNormalStride();
		var tangentStride = this.get_vertexTangentStride();
		var posOffset = this.get_vertexOffset();
		var normalOffset = this.get_vertexNormalOffset();
		var tangentOffset = this.get_vertexTangentOffset();
		var len = vertices.get_length() / posStride | 0;
		var i;
		var i1;
		var i2;
		var vector = new openfl_geom_Vector3D();
		var bakeNormals = normals != null;
		var bakeTangents = tangents != null;
		var invTranspose = null;
		if(bakeNormals || bakeTangents) {
			invTranspose = transform.clone();
			invTranspose.invert();
			invTranspose.transpose();
		}
		var vi0 = posOffset;
		var ni0 = normalOffset;
		var ti0 = tangentOffset;
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i3 = _g++;
			i1 = vi0 + 1;
			i2 = vi0 + 2;
			vector.x = vertices.get(vi0);
			vector.y = vertices.get(i1);
			vector.z = vertices.get(i2);
			vector = transform.transformVector(vector);
			vertices.set(vi0,vector.x);
			vertices.set(i1,vector.y);
			vertices.set(i2,vector.z);
			vi0 += posStride;
			if(bakeNormals) {
				i1 = ni0 + 1;
				i2 = ni0 + 2;
				vector.x = normals.get(ni0);
				vector.y = normals.get(i1);
				vector.z = normals.get(i2);
				vector = invTranspose.deltaTransformVector(vector);
				vector.normalize();
				normals.set(ni0,vector.x);
				normals.set(i1,vector.y);
				normals.set(i2,vector.z);
				ni0 += normalStride;
			}
			if(bakeTangents) {
				i1 = ti0 + 1;
				i2 = ti0 + 2;
				vector.x = tangents.get(ti0);
				vector.y = tangents.get(i1);
				vector.z = tangents.get(i2);
				vector = invTranspose.deltaTransformVector(vector);
				vector.normalize();
				tangents.set(ti0,vector.x);
				tangents.set(i1,vector.y);
				tangents.set(i2,vector.z);
				ti0 += tangentStride;
			}
		}
	}
	,updateDummyUVs: function(target) {
		this._uvsDirty = false;
		var stride = this.get_UVStride();
		var skip = stride - 2;
		var len = this._vertexData.get_length() / this.get_vertexStride() * stride | 0;
		if(target == null) {
			target = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
		}
		target.fixed = false;
		target.set_length(len);
		target.fixed = true;
		var idx = this.get_UVOffset();
		var uvIdx = 0;
		while(idx < len) {
			target.set(idx++,uvIdx * .5);
			target.set(idx++,1.0 - (uvIdx & 1));
			idx += skip;
			if(++uvIdx == 3) {
				uvIdx = 0;
			}
		}
		return target;
	}
	,__class__: away3d_core_base_SubGeometryBase
	,__properties__: {get_scaleV:"get_scaleV",get_scaleU:"get_scaleU",set_parentGeometry:"set_parentGeometry",get_parentGeometry:"get_parentGeometry",get_UVOffset:"get_UVOffset",get_vertexTangentOffset:"get_vertexTangentOffset",get_vertexNormalOffset:"get_vertexNormalOffset",get_vertexOffset:"get_vertexOffset",get_vertexTangentStride:"get_vertexTangentStride",get_vertexNormalStride:"get_vertexNormalStride",get_vertexStride:"get_vertexStride",get_UVData:"get_UVData",get_vertexTangentData:"get_vertexTangentData",get_vertexNormalData:"get_vertexNormalData",get_vertexPositionData:"get_vertexPositionData",get_vertexData:"get_vertexData",get_UVStride:"get_UVStride",get_faceNormals:"get_faceNormals",set_autoDeriveVertexTangents:"set_autoDeriveVertexTangents",get_autoDeriveVertexTangents:"get_autoDeriveVertexTangents",get_indexData:"get_indexData",get_numTriangles:"get_numTriangles",set_useFaceWeights:"set_useFaceWeights",get_useFaceWeights:"get_useFaceWeights",set_autoDeriveVertexNormals:"set_autoDeriveVertexNormals",get_autoDeriveVertexNormals:"get_autoDeriveVertexNormals",set_autoGenerateDummyUVs:"set_autoGenerateDummyUVs",get_autoGenerateDummyUVs:"get_autoGenerateDummyUVs"}
};
var away3d_core_base_ISubGeometry = function() { };
$hxClasses["away3d.core.base.ISubGeometry"] = away3d_core_base_ISubGeometry;
away3d_core_base_ISubGeometry.__name__ = "away3d.core.base.ISubGeometry";
away3d_core_base_ISubGeometry.__isInterface__ = true;
away3d_core_base_ISubGeometry.prototype = {
	get_numVertices: null
	,get_numTriangles: null
	,get_vertexStride: null
	,get_vertexNormalStride: null
	,get_vertexTangentStride: null
	,get_UVStride: null
	,get_secondaryUVStride: null
	,get_vertexData: null
	,get_vertexNormalData: null
	,get_vertexTangentData: null
	,get_vertexOffset: null
	,get_vertexNormalOffset: null
	,get_vertexTangentOffset: null
	,get_UVOffset: null
	,get_secondaryUVOffset: null
	,get_indexData: null
	,get_UVData: null
	,get_scaleU: null
	,get_scaleV: null
	,get_parentGeometry: null
	,set_parentGeometry: null
	,get_faceNormals: null
	,get_autoDeriveVertexNormals: null
	,set_autoDeriveVertexNormals: null
	,get_autoDeriveVertexTangents: null
	,set_autoDeriveVertexTangents: null
	,get_vertexPositionData: null
	,activateVertexBuffer: null
	,activateUVBuffer: null
	,activateSecondaryUVBuffer: null
	,activateVertexNormalBuffer: null
	,activateVertexTangentBuffer: null
	,getIndexBuffer: null
	,applyTransformation: null
	,scale: null
	,dispose: null
	,clone: null
	,scaleUV: null
	,cloneWithSeperateBuffers: null
	,fromVectors: null
	,__class__: away3d_core_base_ISubGeometry
	,__properties__: {get_vertexPositionData:"get_vertexPositionData",set_autoDeriveVertexTangents:"set_autoDeriveVertexTangents",get_autoDeriveVertexTangents:"get_autoDeriveVertexTangents",set_autoDeriveVertexNormals:"set_autoDeriveVertexNormals",get_autoDeriveVertexNormals:"get_autoDeriveVertexNormals",get_faceNormals:"get_faceNormals",set_parentGeometry:"set_parentGeometry",get_parentGeometry:"get_parentGeometry",get_scaleV:"get_scaleV",get_scaleU:"get_scaleU",get_UVData:"get_UVData",get_indexData:"get_indexData",get_secondaryUVOffset:"get_secondaryUVOffset",get_UVOffset:"get_UVOffset",get_vertexTangentOffset:"get_vertexTangentOffset",get_vertexNormalOffset:"get_vertexNormalOffset",get_vertexOffset:"get_vertexOffset",get_vertexTangentData:"get_vertexTangentData",get_vertexNormalData:"get_vertexNormalData",get_vertexData:"get_vertexData",get_secondaryUVStride:"get_secondaryUVStride",get_UVStride:"get_UVStride",get_vertexTangentStride:"get_vertexTangentStride",get_vertexNormalStride:"get_vertexNormalStride",get_vertexStride:"get_vertexStride",get_numTriangles:"get_numTriangles",get_numVertices:"get_numVertices"}
};
var away3d_core_base_CompactSubGeometry = function() {
	this._bufferContext = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._vertexBuffer = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._vertexDataInvalid = openfl__$Vector_Vector_$Impl_$.toBoolVector(null,8,true);
	away3d_core_base_SubGeometryBase.call(this);
	this._autoDeriveVertexNormals = false;
	this._autoDeriveVertexTangents = false;
};
$hxClasses["away3d.core.base.CompactSubGeometry"] = away3d_core_base_CompactSubGeometry;
away3d_core_base_CompactSubGeometry.__name__ = "away3d.core.base.CompactSubGeometry";
away3d_core_base_CompactSubGeometry.__interfaces__ = [away3d_core_base_ISubGeometry];
away3d_core_base_CompactSubGeometry.__super__ = away3d_core_base_SubGeometryBase;
away3d_core_base_CompactSubGeometry.prototype = $extend(away3d_core_base_SubGeometryBase.prototype,{
	_vertexDataInvalid: null
	,_vertexBuffer: null
	,_bufferContext: null
	,_numVertices: null
	,_contextIndex: null
	,_activeBuffer: null
	,_activeContext: null
	,_activeDataInvalid: null
	,_isolatedVertexPositionData: null
	,_isolatedVertexPositionDataDirty: null
	,get_numVertices: function() {
		return this._numVertices;
	}
	,updateData: function(data) {
		if(this._autoDeriveVertexNormals) {
			this._vertexNormalsDirty = true;
		}
		if(this._autoDeriveVertexTangents) {
			this._vertexTangentsDirty = true;
		}
		this._faceNormalsDirty = true;
		this._faceTangentsDirty = true;
		this._isolatedVertexPositionDataDirty = true;
		this._vertexData = data;
		var numVertices = this._vertexData.get_length() / 13 | 0;
		if(numVertices != this._numVertices) {
			this.disposeVertexBuffers(this._vertexBuffer);
		}
		this._numVertices = numVertices;
		if(this._numVertices == 0) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Bad data: geometry can't have zero triangles"));
		}
		this.invalidateBuffers(this._vertexDataInvalid);
		this.invalidateBounds();
	}
	,activateVertexBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(contextIndex != this._contextIndex) {
			this.updateActiveBuffer(contextIndex);
		}
		if(this._activeBuffer == null || this._activeContext != context) {
			this.createBuffer(contextIndex,context,stage3DProxy);
		}
		if(this._activeDataInvalid) {
			this.uploadData(contextIndex);
		}
		context.setVertexBufferAt(index,this._activeBuffer,0,3);
	}
	,activateUVBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(this._uvsDirty && this._autoGenerateUVs) {
			this._vertexData = this.updateDummyUVs(this._vertexData);
			this.invalidateBuffers(this._vertexDataInvalid);
		}
		if(contextIndex != this._contextIndex) {
			this.updateActiveBuffer(contextIndex);
		}
		if(this._activeBuffer == null || this._activeContext != context) {
			this.createBuffer(contextIndex,context,stage3DProxy);
		}
		if(this._activeDataInvalid) {
			this.uploadData(contextIndex);
		}
		context.setVertexBufferAt(index,this._activeBuffer,9,2);
	}
	,activateSecondaryUVBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(contextIndex != this._contextIndex) {
			this.updateActiveBuffer(contextIndex);
		}
		if(this._activeBuffer == null || this._activeContext != context) {
			this.createBuffer(contextIndex,context,stage3DProxy);
		}
		if(this._activeDataInvalid) {
			this.uploadData(contextIndex);
		}
		context.setVertexBufferAt(index,this._activeBuffer,11,2);
	}
	,uploadData: function(contextIndex) {
		this._activeBuffer.uploadFromVector(this._vertexData,0,this._numVertices);
		this._vertexDataInvalid.set(contextIndex,this._activeDataInvalid = false);
	}
	,activateVertexNormalBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(contextIndex != this._contextIndex) {
			this.updateActiveBuffer(contextIndex);
		}
		if(this._activeBuffer == null || this._activeContext != context) {
			this.createBuffer(contextIndex,context,stage3DProxy);
		}
		if(this._activeDataInvalid) {
			this.uploadData(contextIndex);
		}
		context.setVertexBufferAt(index,this._activeBuffer,3,3);
	}
	,activateVertexTangentBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(contextIndex != this._contextIndex) {
			this.updateActiveBuffer(contextIndex);
		}
		if(this._activeBuffer == null || this._activeContext != context) {
			this.createBuffer(contextIndex,context,stage3DProxy);
		}
		if(this._activeDataInvalid) {
			this.uploadData(contextIndex);
		}
		context.setVertexBufferAt(index,this._activeBuffer,6,3);
	}
	,createBuffer: function(contextIndex,context,stage3DProxy) {
		this._vertexBuffer.set(contextIndex,this._activeBuffer = stage3DProxy.createVertexBuffer(this._numVertices,13));
		this._bufferContext.set(contextIndex,this._activeContext = context);
		this._vertexDataInvalid.set(contextIndex,this._activeDataInvalid = true);
	}
	,updateActiveBuffer: function(contextIndex) {
		this._contextIndex = contextIndex;
		this._activeDataInvalid = this._vertexDataInvalid.get(contextIndex);
		this._activeBuffer = this._vertexBuffer.get(contextIndex);
		this._activeContext = this._bufferContext.get(contextIndex);
	}
	,get_vertexData: function() {
		if(this._autoDeriveVertexNormals && this._vertexNormalsDirty) {
			this._vertexData = this.updateVertexNormals(this._vertexData);
		}
		if(this._autoDeriveVertexTangents && this._vertexTangentsDirty) {
			this._vertexData = this.updateVertexTangents(this._vertexData);
		}
		if(this._uvsDirty && this._autoGenerateUVs) {
			this._vertexData = this.updateDummyUVs(this._vertexData);
		}
		return this._vertexData;
	}
	,updateVertexNormals: function(target) {
		this.invalidateBuffers(this._vertexDataInvalid);
		return away3d_core_base_SubGeometryBase.prototype.updateVertexNormals.call(this,target);
	}
	,updateVertexTangents: function(target) {
		if(this._vertexNormalsDirty) {
			this._vertexData = this.updateVertexNormals(this._vertexData);
		}
		this.invalidateBuffers(this._vertexDataInvalid);
		return away3d_core_base_SubGeometryBase.prototype.updateVertexTangents.call(this,target);
	}
	,get_vertexNormalData: function() {
		if(this._autoDeriveVertexNormals && this._vertexNormalsDirty) {
			this._vertexData = this.updateVertexNormals(this._vertexData);
		}
		return this._vertexData;
	}
	,get_vertexTangentData: function() {
		if(this._autoDeriveVertexTangents && this._vertexTangentsDirty) {
			this._vertexData = this.updateVertexTangents(this._vertexData);
		}
		return this._vertexData;
	}
	,get_UVData: function() {
		if(this._uvsDirty && this._autoGenerateUVs) {
			this._vertexData = this.updateDummyUVs(this._vertexData);
			this.invalidateBuffers(this._vertexDataInvalid);
		}
		return this._vertexData;
	}
	,applyTransformation: function(transform) {
		away3d_core_base_SubGeometryBase.prototype.applyTransformation.call(this,transform);
		this.invalidateBuffers(this._vertexDataInvalid);
	}
	,scale: function(scale) {
		away3d_core_base_SubGeometryBase.prototype.scale.call(this,scale);
		this.invalidateBuffers(this._vertexDataInvalid);
	}
	,clone: function() {
		var clone = new away3d_core_base_CompactSubGeometry();
		clone._autoDeriveVertexNormals = this._autoDeriveVertexNormals;
		clone._autoDeriveVertexTangents = this._autoDeriveVertexTangents;
		clone.updateData(this._vertexData.concat(null));
		clone.updateIndexData(this._indices.concat(null));
		return clone;
	}
	,scaleUV: function(scaleU,scaleV) {
		if(scaleV == null) {
			scaleV = 1;
		}
		if(scaleU == null) {
			scaleU = 1;
		}
		away3d_core_base_SubGeometryBase.prototype.scaleUV.call(this,scaleU,scaleV);
		this.invalidateBuffers(this._vertexDataInvalid);
	}
	,get_vertexStride: function() {
		return 13;
	}
	,get_vertexNormalStride: function() {
		return 13;
	}
	,get_vertexTangentStride: function() {
		return 13;
	}
	,get_UVStride: function() {
		return 13;
	}
	,get_secondaryUVStride: function() {
		return 13;
	}
	,get_vertexOffset: function() {
		return 0;
	}
	,get_vertexNormalOffset: function() {
		return 3;
	}
	,get_vertexTangentOffset: function() {
		return 6;
	}
	,get_UVOffset: function() {
		return 9;
	}
	,get_secondaryUVOffset: function() {
		return 11;
	}
	,dispose: function() {
		away3d_core_base_SubGeometryBase.prototype.dispose.call(this);
		this.disposeVertexBuffers(this._vertexBuffer);
		this._vertexBuffer = null;
	}
	,disposeVertexBuffers: function(buffers) {
		away3d_core_base_SubGeometryBase.prototype.disposeVertexBuffers.call(this,buffers);
		this._activeBuffer = null;
	}
	,invalidateBuffers: function(invalid) {
		away3d_core_base_SubGeometryBase.prototype.invalidateBuffers.call(this,invalid);
		this._activeDataInvalid = true;
	}
	,cloneWithSeperateBuffers: function() {
		var clone = new away3d_core_base_SubGeometry();
		clone.updateVertexData(this._isolatedVertexPositionData != null ? this._isolatedVertexPositionData : this._isolatedVertexPositionData = this.stripBuffer(0,3));
		clone.set_autoDeriveVertexNormals(this._autoDeriveVertexNormals);
		clone.set_autoDeriveVertexTangents(this._autoDeriveVertexTangents);
		if(!this._autoDeriveVertexNormals) {
			clone.updateVertexNormalData(this.stripBuffer(3,3));
		}
		if(!this._autoDeriveVertexTangents) {
			clone.updateVertexTangentData(this.stripBuffer(6,3));
		}
		clone.updateUVData(this.stripBuffer(9,2));
		clone.updateSecondaryUVData(this.stripBuffer(11,2));
		clone.updateIndexData(this.get_indexData().concat(null));
		return clone;
	}
	,get_vertexPositionData: function() {
		if(this._isolatedVertexPositionDataDirty || this._isolatedVertexPositionData == null) {
			this._isolatedVertexPositionData = this.stripBuffer(0,3);
			this._isolatedVertexPositionDataDirty = false;
		}
		return this._isolatedVertexPositionData;
	}
	,stripBuffer: function(offset,numEntries) {
		var data = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,this._numVertices * numEntries);
		var i = 0;
		var j = offset;
		var skip = 13 - numEntries;
		var _g = 0;
		var _g1 = this._numVertices;
		while(_g < _g1) {
			var v = _g++;
			var _g2 = 0;
			var _g11 = numEntries;
			while(_g2 < _g11) {
				var k = _g2++;
				data.set(i++,this._vertexData.get(j++));
			}
			j += skip;
		}
		return data;
	}
	,fromVectors: function(verts,uvs,normals,tangents) {
		var vertLen = verts.get_length() / 3 * 13 | 0;
		var index = 0;
		var v = 0;
		var n = 0;
		var t = 0;
		var u = 0;
		var data = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,vertLen,true);
		while(index < vertLen) {
			data.set(index++,verts.get(v++));
			data.set(index++,verts.get(v++));
			data.set(index++,verts.get(v++));
			if(normals != null && normals.get_length() > 0) {
				data.set(index++,normals.get(n++));
				data.set(index++,normals.get(n++));
				data.set(index++,normals.get(n++));
			} else {
				data.set(index++,0);
				data.set(index++,0);
				data.set(index++,0);
			}
			if(tangents != null && tangents.get_length() > 0) {
				data.set(index++,tangents.get(t++));
				data.set(index++,tangents.get(t++));
				data.set(index++,tangents.get(t++));
			} else {
				data.set(index++,0);
				data.set(index++,0);
				data.set(index++,0);
			}
			if(uvs != null && uvs.get_length() > 0) {
				data.set(index++,uvs.get(u));
				data.set(index++,uvs.get(u + 1));
				data.set(index++,uvs.get(u++));
				data.set(index++,uvs.get(u++));
			} else {
				data.set(index++,0);
				data.set(index++,0);
				data.set(index++,0);
				data.set(index++,0);
			}
		}
		this.set_autoDeriveVertexNormals(!(normals != null && normals.get_length() > 0));
		this.set_autoDeriveVertexTangents(!(tangents != null && tangents.get_length() > 0));
		this.set_autoGenerateDummyUVs(!(uvs != null && uvs.get_length() > 0));
		this.updateData(data);
	}
	,__class__: away3d_core_base_CompactSubGeometry
	,__properties__: $extend(away3d_core_base_SubGeometryBase.prototype.__properties__,{get_secondaryUVOffset:"get_secondaryUVOffset",get_secondaryUVStride:"get_secondaryUVStride",get_numVertices:"get_numVertices"})
});
var away3d_core_base_Geometry = function() {
	away3d_library_assets_NamedAssetBase.call(this);
	this._subGeometries = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
};
$hxClasses["away3d.core.base.Geometry"] = away3d_core_base_Geometry;
away3d_core_base_Geometry.__name__ = "away3d.core.base.Geometry";
away3d_core_base_Geometry.__interfaces__ = [away3d_library_assets_IAsset];
away3d_core_base_Geometry.__super__ = away3d_library_assets_NamedAssetBase;
away3d_core_base_Geometry.prototype = $extend(away3d_library_assets_NamedAssetBase.prototype,{
	_subGeometries: null
	,get_assetType: function() {
		return "geometry";
	}
	,get_subGeometries: function() {
		return this._subGeometries;
	}
	,applyTransformation: function(transform) {
		var len = this._subGeometries.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			this._subGeometries.get(i).applyTransformation(transform);
		}
	}
	,addSubGeometry: function(subGeometry) {
		this._subGeometries.push(subGeometry);
		subGeometry.set_parentGeometry(this);
		if(this.hasEventListener("SubGeometryAdded")) {
			this.dispatchEvent(new away3d_events_GeometryEvent("SubGeometryAdded",subGeometry));
		}
		this.invalidateBounds(subGeometry);
	}
	,removeSubGeometry: function(subGeometry) {
		this._subGeometries.splice(this._subGeometries.indexOf(subGeometry,0),1);
		subGeometry.set_parentGeometry(null);
		if(this.hasEventListener("SubGeometryRemoved")) {
			this.dispatchEvent(new away3d_events_GeometryEvent("SubGeometryRemoved",subGeometry));
		}
		this.invalidateBounds(subGeometry);
	}
	,clone: function() {
		var clone = new away3d_core_base_Geometry();
		var len = this._subGeometries.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			clone.addSubGeometry(this._subGeometries.get(i).clone());
		}
		return clone;
	}
	,scale: function(scale) {
		var numSubGeoms = this._subGeometries.get_length();
		var _g = 0;
		var _g1 = numSubGeoms;
		while(_g < _g1) {
			var i = _g++;
			this._subGeometries.get(i).scale(scale);
		}
	}
	,dispose: function() {
		var numSubGeoms = this._subGeometries.get_length();
		var _g = 0;
		var _g1 = numSubGeoms;
		while(_g < _g1) {
			var i = _g++;
			var subGeom = this._subGeometries.get(0);
			this.removeSubGeometry(subGeom);
			subGeom.dispose();
		}
	}
	,scaleUV: function(scaleU,scaleV) {
		if(scaleV == null) {
			scaleV = 1;
		}
		if(scaleU == null) {
			scaleU = 1;
		}
		var numSubGeoms = this._subGeometries.get_length();
		var _g = 0;
		var _g1 = numSubGeoms;
		while(_g < _g1) {
			var i = _g++;
			this._subGeometries.get(i).scaleUV(scaleU,scaleV);
		}
	}
	,convertToSeparateBuffers: function() {
		var subGeom;
		var numSubGeoms = this._subGeometries.get_length();
		var _removableCompactSubGeometries = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		var _g = 0;
		var _g1 = numSubGeoms;
		while(_g < _g1) {
			var i = _g++;
			subGeom = this._subGeometries.get(i);
			if(((subGeom) instanceof away3d_core_base_SubGeometry)) {
				continue;
			}
			_removableCompactSubGeometries.push(subGeom);
			this.addSubGeometry(subGeom.cloneWithSeperateBuffers());
		}
		var s = _removableCompactSubGeometries.iterator();
		while(s.hasNext()) {
			var s1 = s.next();
			this.removeSubGeometry(s1);
			s1.dispose();
		}
	}
	,validate: function() {
	}
	,invalidateBounds: function(subGeom) {
		if(this.hasEventListener("BoundsInvalid")) {
			this.dispatchEvent(new away3d_events_GeometryEvent("BoundsInvalid",subGeom));
		}
	}
	,__class__: away3d_core_base_Geometry
	,__properties__: $extend(away3d_library_assets_NamedAssetBase.prototype.__properties__,{get_subGeometries:"get_subGeometries",get_assetType:"get_assetType"})
});
var away3d_core_base_IMaterialOwner = function() { };
$hxClasses["away3d.core.base.IMaterialOwner"] = away3d_core_base_IMaterialOwner;
away3d_core_base_IMaterialOwner.__name__ = "away3d.core.base.IMaterialOwner";
away3d_core_base_IMaterialOwner.__isInterface__ = true;
away3d_core_base_IMaterialOwner.prototype = {
	get_material: null
	,set_material: null
	,get_animator: null
	,__class__: away3d_core_base_IMaterialOwner
	,__properties__: {get_animator:"get_animator",set_material:"set_material",get_material:"get_material"}
};
var away3d_core_base_IRenderable = function() { };
$hxClasses["away3d.core.base.IRenderable"] = away3d_core_base_IRenderable;
away3d_core_base_IRenderable.__name__ = "away3d.core.base.IRenderable";
away3d_core_base_IRenderable.__isInterface__ = true;
away3d_core_base_IRenderable.__interfaces__ = [away3d_core_base_IMaterialOwner];
away3d_core_base_IRenderable.prototype = {
	get_sceneTransform: null
	,get_inverseSceneTransform: null
	,get_mouseEnabled: null
	,get_sourceEntity: null
	,get_castsShadows: null
	,get_uvTransform: null
	,get_uvTransform2: null
	,get_shaderPickingDetails: null
	,get_numVertices: null
	,get_numTriangles: null
	,get_vertexStride: null
	,get_vertexData: null
	,get_vertexNormalData: null
	,get_vertexTangentData: null
	,get_indexData: null
	,get_UVData: null
	,getRenderSceneTransform: null
	,activateVertexBuffer: null
	,activateUVBuffer: null
	,activateSecondaryUVBuffer: null
	,activateVertexNormalBuffer: null
	,activateVertexTangentBuffer: null
	,getIndexBuffer: null
	,__class__: away3d_core_base_IRenderable
	,__properties__: {get_UVData:"get_UVData",get_indexData:"get_indexData",get_vertexTangentData:"get_vertexTangentData",get_vertexNormalData:"get_vertexNormalData",get_vertexData:"get_vertexData",get_vertexStride:"get_vertexStride",get_numTriangles:"get_numTriangles",get_numVertices:"get_numVertices",get_shaderPickingDetails:"get_shaderPickingDetails",get_uvTransform2:"get_uvTransform2",get_uvTransform:"get_uvTransform",get_castsShadows:"get_castsShadows",get_sourceEntity:"get_sourceEntity",get_mouseEnabled:"get_mouseEnabled",get_inverseSceneTransform:"get_inverseSceneTransform",get_sceneTransform:"get_sceneTransform"}
};
var away3d_core_base_SkinnedSubGeometry = function(jointsPerVertex) {
	this._jointIndexContext = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._jointWeightContext = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._jointIndicesInvalid = openfl__$Vector_Vector_$Impl_$.toBoolVector(null,8,true);
	this._jointWeightsInvalid = openfl__$Vector_Vector_$Impl_$.toBoolVector(null,8,true);
	this._jointIndexBuffer = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._jointWeightsBuffer = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	away3d_core_base_CompactSubGeometry.call(this);
	this._jointsPerVertex = jointsPerVertex;
	this._bufferFormat = this.getVertexBufferFormat(this._jointsPerVertex);
};
$hxClasses["away3d.core.base.SkinnedSubGeometry"] = away3d_core_base_SkinnedSubGeometry;
away3d_core_base_SkinnedSubGeometry.__name__ = "away3d.core.base.SkinnedSubGeometry";
away3d_core_base_SkinnedSubGeometry.__super__ = away3d_core_base_CompactSubGeometry;
away3d_core_base_SkinnedSubGeometry.prototype = $extend(away3d_core_base_CompactSubGeometry.prototype,{
	_bufferFormat: null
	,_jointWeightsData: null
	,_jointIndexData: null
	,_animatedData: null
	,_jointWeightsBuffer: null
	,_jointIndexBuffer: null
	,_jointWeightsInvalid: null
	,_jointIndicesInvalid: null
	,_jointWeightContext: null
	,_jointIndexContext: null
	,_jointsPerVertex: null
	,_condensedJointIndexData: null
	,_condensedIndexLookUp: null
	,_numCondensedJoints: null
	,getVertexBufferFormat: function(size) {
		switch(size) {
		case 1:
			return 1;
		case 2:
			return 2;
		case 3:
			return 3;
		case 4:
			return 3;
		default:
			return null;
		}
	}
	,get_condensedIndexLookUp: function() {
		return this._condensedIndexLookUp;
	}
	,get_numCondensedJoints: function() {
		return this._numCondensedJoints;
	}
	,get_animatedData: function() {
		if(this._animatedData != null) {
			return this._animatedData;
		}
		return this._vertexData.concat(null);
	}
	,updateAnimatedData: function(value) {
		this._animatedData = value;
		this.invalidateBuffers(this._vertexDataInvalid);
	}
	,activateJointWeightsBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(this._jointWeightContext.get(contextIndex) != context || this._jointWeightsBuffer.get(contextIndex) == null) {
			this._jointWeightsBuffer.set(contextIndex,stage3DProxy.createVertexBuffer(this._numVertices,this._jointsPerVertex));
			this._jointWeightContext.set(contextIndex,context);
			this._jointWeightsInvalid.set(contextIndex,true);
		}
		if(this._jointWeightsInvalid.get(contextIndex)) {
			this._jointWeightsBuffer.get(contextIndex).uploadFromVector(this._jointWeightsData,0,this._jointWeightsData.get_length() / this._jointsPerVertex | 0);
			this._jointWeightsInvalid.set(contextIndex,false);
		}
		context.setVertexBufferAt(index,this._jointWeightsBuffer.get(contextIndex),0,this._bufferFormat);
	}
	,activateJointIndexBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(this._jointIndexContext.get(contextIndex) != context || this._jointIndexBuffer.get(contextIndex) == null) {
			this._jointIndexBuffer.set(contextIndex,stage3DProxy.createVertexBuffer(this._numVertices,this._jointsPerVertex));
			this._jointIndexContext.set(contextIndex,context);
			this._jointIndicesInvalid.set(contextIndex,true);
		}
		if(this._jointIndicesInvalid.get(contextIndex)) {
			this._jointIndexBuffer.get(contextIndex).uploadFromVector(this._numCondensedJoints > 0 ? this._condensedJointIndexData : this._jointIndexData,0,this._jointIndexData.get_length() / this._jointsPerVertex | 0);
			this._jointIndicesInvalid.set(contextIndex,false);
		}
		context.setVertexBufferAt(index,this._jointIndexBuffer.get(contextIndex),0,this._bufferFormat);
	}
	,uploadData: function(contextIndex) {
		if(this._animatedData != null) {
			this._activeBuffer.uploadFromVector(this._animatedData,0,this._numVertices);
			this._vertexDataInvalid.set(contextIndex,this._activeDataInvalid = false);
		} else {
			away3d_core_base_CompactSubGeometry.prototype.uploadData.call(this,contextIndex);
		}
	}
	,clone: function() {
		var clone = new away3d_core_base_SkinnedSubGeometry(this._jointsPerVertex);
		clone.updateData(this._vertexData.concat(null));
		clone.updateIndexData(this._indices.concat(null));
		clone.updateJointIndexData(this._jointIndexData.concat(null));
		clone.updateJointWeightsData(this._jointWeightsData.concat(null));
		clone._autoDeriveVertexNormals = this._autoDeriveVertexNormals;
		clone._autoDeriveVertexTangents = this._autoDeriveVertexTangents;
		clone._numCondensedJoints = this._numCondensedJoints;
		clone._condensedIndexLookUp = this._condensedIndexLookUp;
		clone._condensedJointIndexData = this._condensedJointIndexData;
		return clone;
	}
	,dispose: function() {
		away3d_core_base_CompactSubGeometry.prototype.dispose.call(this);
		this.disposeVertexBuffers(this._jointWeightsBuffer);
		this.disposeVertexBuffers(this._jointIndexBuffer);
	}
	,condenseIndexData: function() {
		var len = this._jointIndexData.get_length();
		var oldIndex;
		var newIndex = 0;
		var dic_h = { };
		this._condensedJointIndexData = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,len,true);
		this._condensedIndexLookUp = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			oldIndex = this._jointIndexData.get(i) | 0;
			if(!dic_h.hasOwnProperty(oldIndex)) {
				dic_h[oldIndex] = newIndex;
				this._condensedIndexLookUp.set(newIndex++,oldIndex);
				this._condensedIndexLookUp.set(newIndex++,oldIndex + 1);
				this._condensedIndexLookUp.set(newIndex++,oldIndex + 2);
			}
			this._condensedJointIndexData.set(i,dic_h[oldIndex]);
		}
		this._numCondensedJoints = newIndex / 3 | 0;
		this.invalidateBuffers(this._jointIndicesInvalid);
	}
	,get_jointWeightsData: function() {
		return this._jointWeightsData;
	}
	,updateJointWeightsData: function(value) {
		this._numCondensedJoints = 0;
		this._condensedIndexLookUp = null;
		this._condensedJointIndexData = null;
		this._jointWeightsData = value;
		this.invalidateBuffers(this._jointWeightsInvalid);
	}
	,get_jointIndexData: function() {
		return this._jointIndexData;
	}
	,updateJointIndexData: function(value) {
		this._jointIndexData = value;
		this.invalidateBuffers(this._jointIndicesInvalid);
	}
	,__class__: away3d_core_base_SkinnedSubGeometry
	,__properties__: $extend(away3d_core_base_CompactSubGeometry.prototype.__properties__,{get_jointIndexData:"get_jointIndexData",get_jointWeightsData:"get_jointWeightsData",get_animatedData:"get_animatedData",get_numCondensedJoints:"get_numCondensedJoints",get_condensedIndexLookUp:"get_condensedIndexLookUp"})
});
var away3d_core_base_SubGeometry = function() {
	this._vertexTangentBufferContext = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._vertexNormalBufferContext = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._secondaryUvBufferContext = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._uvBufferContext = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._vertexBufferContext = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._vertexTangentBuffer = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._vertexNormalBuffer = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._secondaryUvBuffer = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._uvBuffer = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._vertexBuffer = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._tangentsInvalid = openfl__$Vector_Vector_$Impl_$.toBoolVector(null,8,true);
	this._normalsInvalid = openfl__$Vector_Vector_$Impl_$.toBoolVector(null,8,true);
	this._secondaryUvsInvalid = openfl__$Vector_Vector_$Impl_$.toBoolVector(null,8,true);
	this._uvsInvalid = openfl__$Vector_Vector_$Impl_$.toBoolVector(null,8,true);
	this._verticesInvalid = openfl__$Vector_Vector_$Impl_$.toBoolVector(null,8,true);
	away3d_core_base_SubGeometryBase.call(this);
};
$hxClasses["away3d.core.base.SubGeometry"] = away3d_core_base_SubGeometry;
away3d_core_base_SubGeometry.__name__ = "away3d.core.base.SubGeometry";
away3d_core_base_SubGeometry.__interfaces__ = [away3d_core_base_ISubGeometry];
away3d_core_base_SubGeometry.__super__ = away3d_core_base_SubGeometryBase;
away3d_core_base_SubGeometry.prototype = $extend(away3d_core_base_SubGeometryBase.prototype,{
	_uvs: null
	,_secondaryUvs: null
	,_vertexNormals: null
	,_vertexTangents: null
	,_verticesInvalid: null
	,_uvsInvalid: null
	,_secondaryUvsInvalid: null
	,_normalsInvalid: null
	,_tangentsInvalid: null
	,_vertexBuffer: null
	,_uvBuffer: null
	,_secondaryUvBuffer: null
	,_vertexNormalBuffer: null
	,_vertexTangentBuffer: null
	,_vertexBufferContext: null
	,_uvBufferContext: null
	,_secondaryUvBufferContext: null
	,_vertexNormalBufferContext: null
	,_vertexTangentBufferContext: null
	,_numVertices: null
	,get_numVertices: function() {
		return this._numVertices;
	}
	,activateVertexBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(this._vertexBuffer.get(contextIndex) == null || this._vertexBufferContext.get(contextIndex) != context) {
			this._vertexBuffer.set(contextIndex,stage3DProxy.createVertexBuffer(this._numVertices,3));
			this._vertexBufferContext.set(contextIndex,context);
			this._verticesInvalid.set(contextIndex,true);
		}
		if(this._verticesInvalid.get(contextIndex)) {
			this._vertexBuffer.get(contextIndex).uploadFromVector(this._vertexData,0,this._numVertices);
			this._verticesInvalid.set(contextIndex,false);
		}
		context.setVertexBufferAt(index,this._vertexBuffer.get(contextIndex),0,3);
	}
	,activateUVBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(this._autoGenerateUVs && this._uvsDirty) {
			this._uvs = this.updateDummyUVs(this._uvs);
		}
		if(this._uvBuffer.get(contextIndex) == null || this._uvBufferContext.get(contextIndex) != context) {
			this._uvBuffer.set(contextIndex,stage3DProxy.createVertexBuffer(this._numVertices,2));
			this._uvBufferContext.set(contextIndex,context);
			this._uvsInvalid.set(contextIndex,true);
		}
		if(this._uvsInvalid.get(contextIndex)) {
			this._uvBuffer.get(contextIndex).uploadFromVector(this._uvs,0,this._numVertices);
			this._uvsInvalid.set(contextIndex,false);
		}
		context.setVertexBufferAt(index,this._uvBuffer.get(contextIndex),0,2);
	}
	,activateSecondaryUVBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(this._secondaryUvBuffer.get(contextIndex) == null || this._secondaryUvBufferContext.get(contextIndex) != context) {
			this._secondaryUvBuffer.set(contextIndex,stage3DProxy.createVertexBuffer(this._numVertices,2));
			this._secondaryUvBufferContext.set(contextIndex,context);
			this._secondaryUvsInvalid.set(contextIndex,true);
		}
		if(this._secondaryUvsInvalid.get(contextIndex)) {
			this._secondaryUvBuffer.get(contextIndex).uploadFromVector(this._secondaryUvs,0,this._numVertices);
			this._secondaryUvsInvalid.set(contextIndex,false);
		}
		context.setVertexBufferAt(index,this._secondaryUvBuffer.get(contextIndex),0,2);
	}
	,activateVertexNormalBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(this._autoDeriveVertexNormals && this._vertexNormalsDirty) {
			this._vertexNormals = this.updateVertexNormals(this._vertexNormals);
		}
		if(this._vertexNormalBuffer.get(contextIndex) == null || this._vertexNormalBufferContext.get(contextIndex) != context) {
			this._vertexNormalBuffer.set(contextIndex,stage3DProxy.createVertexBuffer(this._numVertices,3));
			this._vertexNormalBufferContext.set(contextIndex,context);
			this._normalsInvalid.set(contextIndex,true);
		}
		if(this._normalsInvalid.get(contextIndex)) {
			this._vertexNormalBuffer.get(contextIndex).uploadFromVector(this._vertexNormals,0,this._numVertices);
			this._normalsInvalid.set(contextIndex,false);
		}
		context.setVertexBufferAt(index,this._vertexNormalBuffer.get(contextIndex),0,3);
	}
	,activateVertexTangentBuffer: function(index,stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		if(this._vertexTangentsDirty) {
			this._vertexTangents = this.updateVertexTangents(this._vertexTangents);
		}
		if(this._vertexTangentBuffer.get(contextIndex) == null || this._vertexTangentBufferContext.get(contextIndex) != context) {
			this._vertexTangentBuffer.set(contextIndex,stage3DProxy.createVertexBuffer(this._numVertices,3));
			this._vertexTangentBufferContext.set(contextIndex,context);
			this._tangentsInvalid.set(contextIndex,true);
		}
		if(this._tangentsInvalid.get(contextIndex)) {
			this._vertexTangentBuffer.get(contextIndex).uploadFromVector(this._vertexTangents,0,this._numVertices);
			this._tangentsInvalid.set(contextIndex,false);
		}
		context.setVertexBufferAt(index,this._vertexTangentBuffer.get(contextIndex),0,3);
	}
	,applyTransformation: function(transform) {
		away3d_core_base_SubGeometryBase.prototype.applyTransformation.call(this,transform);
		this.invalidateBuffers(this._verticesInvalid);
		this.invalidateBuffers(this._normalsInvalid);
		this.invalidateBuffers(this._tangentsInvalid);
	}
	,clone: function() {
		var clone = new away3d_core_base_SubGeometry();
		clone.updateVertexData(this._vertexData.concat(null));
		clone.updateUVData(this._uvs.concat(null));
		clone.updateIndexData(this._indices.concat(null));
		if(this._secondaryUvs != null) {
			clone.updateSecondaryUVData(this._secondaryUvs.concat(null));
		}
		if(!this._autoDeriveVertexNormals) {
			clone.updateVertexNormalData(this._vertexNormals.concat(null));
		}
		if(!this._autoDeriveVertexTangents) {
			clone.updateVertexTangentData(this._vertexTangents.concat(null));
		}
		return clone;
	}
	,scale: function(scale) {
		away3d_core_base_SubGeometryBase.prototype.scale.call(this,scale);
		this.invalidateBuffers(this._verticesInvalid);
	}
	,scaleUV: function(scaleU,scaleV) {
		if(scaleV == null) {
			scaleV = 1;
		}
		if(scaleU == null) {
			scaleU = 1;
		}
		away3d_core_base_SubGeometryBase.prototype.scaleUV.call(this,scaleU,scaleV);
		this.invalidateBuffers(this._uvsInvalid);
	}
	,dispose: function() {
		away3d_core_base_SubGeometryBase.prototype.dispose.call(this);
		this.disposeAllVertexBuffers();
		this._vertexBuffer = null;
		this._vertexNormalBuffer = null;
		this._uvBuffer = null;
		this._secondaryUvBuffer = null;
		this._vertexTangentBuffer = null;
		this._indexBuffer = null;
		this._uvs = null;
		this._secondaryUvs = null;
		this._vertexNormals = null;
		this._vertexTangents = null;
		this._vertexBufferContext = null;
		this._uvBufferContext = null;
		this._secondaryUvBufferContext = null;
		this._vertexNormalBufferContext = null;
		this._vertexTangentBufferContext = null;
	}
	,disposeAllVertexBuffers: function() {
		this.disposeVertexBuffers(this._vertexBuffer);
		this.disposeVertexBuffers(this._vertexNormalBuffer);
		this.disposeVertexBuffers(this._uvBuffer);
		this.disposeVertexBuffers(this._secondaryUvBuffer);
		this.disposeVertexBuffers(this._vertexTangentBuffer);
	}
	,get_vertexData: function() {
		return this._vertexData;
	}
	,get_vertexPositionData: function() {
		return this._vertexData;
	}
	,updateVertexData: function(vertices) {
		if(this._autoDeriveVertexNormals) {
			this._vertexNormalsDirty = true;
		}
		if(this._autoDeriveVertexTangents) {
			this._vertexTangentsDirty = true;
		}
		this._faceNormalsDirty = true;
		this._vertexData = vertices;
		var numVertices = vertices.get_length() / 3 | 0;
		if(numVertices != this._numVertices) {
			this.disposeAllVertexBuffers();
		}
		this._numVertices = numVertices;
		this.invalidateBuffers(this._verticesInvalid);
		this.invalidateBounds();
	}
	,get_UVData: function() {
		if(this._uvsDirty && this._autoGenerateUVs) {
			this._uvs = this.updateDummyUVs(this._uvs);
		}
		return this._uvs;
	}
	,get_secondaryUVData: function() {
		return this._secondaryUvs;
	}
	,updateUVData: function(uvs) {
		if(this._autoDeriveVertexTangents) {
			this._vertexTangentsDirty = true;
		}
		this._faceTangentsDirty = true;
		this._uvs = uvs;
		this.invalidateBuffers(this._uvsInvalid);
	}
	,updateSecondaryUVData: function(uvs) {
		this._secondaryUvs = uvs;
		this.invalidateBuffers(this._secondaryUvsInvalid);
	}
	,get_vertexNormalData: function() {
		if(this._autoDeriveVertexNormals && this._vertexNormalsDirty) {
			this._vertexNormals = this.updateVertexNormals(this._vertexNormals);
		}
		return this._vertexNormals;
	}
	,updateVertexNormalData: function(vertexNormals) {
		this._vertexNormalsDirty = false;
		this._autoDeriveVertexNormals = vertexNormals == null;
		this._vertexNormals = vertexNormals;
		this.invalidateBuffers(this._normalsInvalid);
	}
	,get_vertexTangentData: function() {
		if(this._autoDeriveVertexTangents && this._vertexTangentsDirty) {
			this._vertexTangents = this.updateVertexTangents(this._vertexTangents);
		}
		return this._vertexTangents;
	}
	,updateVertexTangentData: function(vertexTangents) {
		this._vertexTangentsDirty = false;
		this._autoDeriveVertexTangents = vertexTangents == null;
		this._vertexTangents = vertexTangents;
		this.invalidateBuffers(this._tangentsInvalid);
	}
	,fromVectors: function(vertices,uvs,normals,tangents) {
		this.updateVertexData(vertices);
		this.updateUVData(uvs);
		this.updateVertexNormalData(normals);
		this.updateVertexTangentData(tangents);
	}
	,updateVertexNormals: function(target) {
		this.invalidateBuffers(this._normalsInvalid);
		return away3d_core_base_SubGeometryBase.prototype.updateVertexNormals.call(this,target);
	}
	,updateVertexTangents: function(target) {
		if(this._vertexNormalsDirty) {
			this._vertexNormals = this.updateVertexNormals(this._vertexNormals);
		}
		this.invalidateBuffers(this._tangentsInvalid);
		return away3d_core_base_SubGeometryBase.prototype.updateVertexTangents.call(this,target);
	}
	,updateDummyUVs: function(target) {
		this.invalidateBuffers(this._uvsInvalid);
		return away3d_core_base_SubGeometryBase.prototype.updateDummyUVs.call(this,target);
	}
	,disposeForStage3D: function(stage3DProxy) {
		var index = stage3DProxy._stage3DIndex;
		if(this._vertexBuffer.get(index) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(this._vertexBuffer.get(index));
			this._vertexBuffer.set(index,null);
		}
		if(this._uvBuffer.get(index) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(this._uvBuffer.get(index));
			this._uvBuffer.set(index,null);
		}
		if(this._secondaryUvBuffer.get(index) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(this._secondaryUvBuffer.get(index));
			this._secondaryUvBuffer.set(index,null);
		}
		if(this._vertexNormalBuffer.get(index) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(this._vertexNormalBuffer.get(index));
			this._vertexNormalBuffer.set(index,null);
		}
		if(this._vertexTangentBuffer.get(index) != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(this._vertexTangentBuffer.get(index));
			this._vertexTangentBuffer.set(index,null);
		}
		if(this._indexBuffer.get(index) != null) {
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(this._indexBuffer.get(index));
			this._indexBuffer.set(index,null);
		}
	}
	,get_vertexStride: function() {
		return 3;
	}
	,get_vertexTangentStride: function() {
		return 3;
	}
	,get_vertexNormalStride: function() {
		return 3;
	}
	,get_UVStride: function() {
		return 2;
	}
	,get_secondaryUVStride: function() {
		return 2;
	}
	,get_vertexOffset: function() {
		return 0;
	}
	,get_vertexNormalOffset: function() {
		return 0;
	}
	,get_vertexTangentOffset: function() {
		return 0;
	}
	,get_UVOffset: function() {
		return 0;
	}
	,get_secondaryUVOffset: function() {
		return 0;
	}
	,cloneWithSeperateBuffers: function() {
		return js_Boot.__cast(this.clone() , away3d_core_base_SubGeometry);
	}
	,__class__: away3d_core_base_SubGeometry
	,__properties__: $extend(away3d_core_base_SubGeometryBase.prototype.__properties__,{get_secondaryUVOffset:"get_secondaryUVOffset",get_secondaryUVStride:"get_secondaryUVStride",get_secondaryUVData:"get_secondaryUVData",get_numVertices:"get_numVertices"})
});
var away3d_core_base_SubMesh = function(subGeometry,parentMesh,material) {
	this._offsetV2 = 0;
	this._offsetU2 = 0;
	this._scaleV2 = 1;
	this._scaleU2 = 1;
	this._uvRotation2 = 0;
	this._offsetV = 0;
	this._offsetU = 0;
	this._scaleV = 1;
	this._scaleU = 1;
	this._uvRotation = 0;
	this._parentMesh = parentMesh;
	this._subGeometry = subGeometry;
	this.set_material(material);
};
$hxClasses["away3d.core.base.SubMesh"] = away3d_core_base_SubMesh;
away3d_core_base_SubMesh.__name__ = "away3d.core.base.SubMesh";
away3d_core_base_SubMesh.__interfaces__ = [away3d_core_base_IRenderable];
away3d_core_base_SubMesh.prototype = {
	_material: null
	,_parentMesh: null
	,_subGeometry: null
	,_index: null
	,_uvTransform: null
	,_uvTransformDirty: null
	,_uvRotation: null
	,_scaleU: null
	,_scaleV: null
	,_offsetU: null
	,_offsetV: null
	,_uvTransform2: null
	,_uvTransformDirty2: null
	,_uvRotation2: null
	,_scaleU2: null
	,_scaleV2: null
	,_offsetU2: null
	,_offsetV2: null
	,animationSubGeometry: null
	,animatorSubGeometry: null
	,get_shaderPickingDetails: function() {
		return this.get_sourceEntity().get_shaderPickingDetails();
	}
	,get_offsetU: function() {
		return this._offsetU;
	}
	,set_offsetU: function(value) {
		if(value == this._offsetU) {
			return value;
		}
		this._offsetU = value;
		this._uvTransformDirty = true;
		return value;
	}
	,get_offsetV: function() {
		return this._offsetV;
	}
	,set_offsetV: function(value) {
		if(value == this._offsetV) {
			return value;
		}
		this._offsetV = value;
		this._uvTransformDirty = true;
		return value;
	}
	,get_scaleU: function() {
		return this._scaleU;
	}
	,set_scaleU: function(value) {
		if(value == this._scaleU) {
			return value;
		}
		this._scaleU = value;
		this._uvTransformDirty = true;
		return value;
	}
	,get_scaleV: function() {
		return this._scaleV;
	}
	,set_scaleV: function(value) {
		if(value == this._scaleV) {
			return value;
		}
		this._scaleV = value;
		this._uvTransformDirty = true;
		return value;
	}
	,get_uvRotation: function() {
		return this._uvRotation;
	}
	,set_uvRotation: function(value) {
		if(value == this._uvRotation) {
			return value;
		}
		this._uvRotation = value;
		this._uvTransformDirty = true;
		return value;
	}
	,get_offsetU2: function() {
		return this._offsetU2;
	}
	,set_offsetU2: function(value) {
		if(value == this._offsetU2) {
			return value;
		}
		this._offsetU2 = value;
		this._uvTransformDirty2 = true;
		return value;
	}
	,get_offsetV2: function() {
		return this._offsetV2;
	}
	,set_offsetV2: function(value) {
		if(value == this._offsetV2) {
			return value;
		}
		this._offsetV2 = value;
		this._uvTransformDirty2 = true;
		return value;
	}
	,get_scaleU2: function() {
		return this._scaleU2;
	}
	,set_scaleU2: function(value) {
		if(value == this._scaleU2) {
			return value;
		}
		this._scaleU2 = value;
		this._uvTransformDirty2 = true;
		return value;
	}
	,get_scaleV2: function() {
		return this._scaleV2;
	}
	,set_scaleV2: function(value) {
		if(value == this._scaleV2) {
			return value;
		}
		this._scaleV2 = value;
		this._uvTransformDirty2 = true;
		return value;
	}
	,get_uvRotation2: function() {
		return this._uvRotation2;
	}
	,set_uvRotation2: function(value) {
		if(value == this._uvRotation2) {
			return value;
		}
		this._uvRotation2 = value;
		this._uvTransformDirty2 = true;
		return value;
	}
	,get_sourceEntity: function() {
		return this._parentMesh;
	}
	,get_subGeometry: function() {
		return this._subGeometry;
	}
	,set_subGeometry: function(value) {
		this._subGeometry = value;
		return value;
	}
	,get_material: function() {
		if(this._material != null) {
			return this._material;
		}
		return this._parentMesh.get_material();
	}
	,set_material: function(value) {
		if(this._material != null) {
			this._material.removeOwner(this);
		}
		this._material = value;
		if(this._material != null) {
			this._material.addOwner(this);
		}
		return value;
	}
	,get_sceneTransform: function() {
		return this._parentMesh.get_sceneTransform();
	}
	,get_inverseSceneTransform: function() {
		return this._parentMesh.get_inverseSceneTransform();
	}
	,activateVertexBuffer: function(index,stage3DProxy) {
		this._subGeometry.activateVertexBuffer(index,stage3DProxy);
	}
	,activateVertexNormalBuffer: function(index,stage3DProxy) {
		this._subGeometry.activateVertexNormalBuffer(index,stage3DProxy);
	}
	,activateVertexTangentBuffer: function(index,stage3DProxy) {
		this._subGeometry.activateVertexTangentBuffer(index,stage3DProxy);
	}
	,activateUVBuffer: function(index,stage3DProxy) {
		this._subGeometry.activateUVBuffer(index,stage3DProxy);
	}
	,activateSecondaryUVBuffer: function(index,stage3DProxy) {
		this._subGeometry.activateSecondaryUVBuffer(index,stage3DProxy);
	}
	,getIndexBuffer: function(stage3DProxy) {
		return this._subGeometry.getIndexBuffer(stage3DProxy);
	}
	,get_numTriangles: function() {
		return this._subGeometry.get_numTriangles();
	}
	,get_animator: function() {
		return this._parentMesh.get_animator();
	}
	,get_mouseEnabled: function() {
		if(!this._parentMesh.get_mouseEnabled()) {
			return this._parentMesh._ancestorsAllowMouseEnabled;
		} else {
			return true;
		}
	}
	,get_castsShadows: function() {
		return this._parentMesh.get_castsShadows();
	}
	,get_parentMesh: function() {
		return this._parentMesh;
	}
	,set_parentMesh: function(value) {
		this._parentMesh = value;
		return value;
	}
	,get_uvTransform: function() {
		if(this._uvTransformDirty) {
			this.updateUVTransform();
		}
		return this._uvTransform;
	}
	,get_uvTransform2: function() {
		if(this._uvTransformDirty2) {
			this.updateUVTransform2();
		}
		return this._uvTransform2;
	}
	,updateUVTransform: function() {
		if(this._uvTransform == null) {
			this._uvTransform = new openfl_geom_Matrix();
		}
		this._uvTransform.identity();
		if(this._uvRotation != 0) {
			this._uvTransform.rotate(this._uvRotation);
		}
		if(this._scaleU != 1 || this._scaleV != 1) {
			this._uvTransform.scale(this._scaleU,this._scaleV);
		}
		this._uvTransform.translate(this._offsetU,this._offsetV);
		this._uvTransformDirty = false;
	}
	,updateUVTransform2: function() {
		if(this._uvTransform2 == null) {
			this._uvTransform2 = new openfl_geom_Matrix();
		}
		this._uvTransform2.identity();
		if(this._uvRotation2 != 0) {
			this._uvTransform2.rotate(this._uvRotation2);
		}
		if(this._scaleU2 != 1 || this._scaleV2 != 1) {
			this._uvTransform2.scale(this._scaleU2,this._scaleV2);
		}
		this._uvTransform2.translate(this._offsetU2,this._offsetV2);
		this._uvTransformDirty2 = false;
	}
	,dispose: function() {
		this.set_material(null);
	}
	,get_vertexData: function() {
		return this._subGeometry.get_vertexData();
	}
	,get_indexData: function() {
		return this._subGeometry.get_indexData();
	}
	,get_UVData: function() {
		return this._subGeometry.get_UVData();
	}
	,get_bounds: function() {
		return this._parentMesh.get_bounds();
	}
	,get_visible: function() {
		return this._parentMesh.get_visible();
	}
	,get_numVertices: function() {
		return this._subGeometry.get_numVertices();
	}
	,get_vertexStride: function() {
		return this._subGeometry.get_vertexStride();
	}
	,get_UVStride: function() {
		return this._subGeometry.get_UVStride();
	}
	,get_vertexNormalData: function() {
		return this._subGeometry.get_vertexNormalData();
	}
	,get_vertexTangentData: function() {
		return this._subGeometry.get_vertexTangentData();
	}
	,get_UVOffset: function() {
		return this._subGeometry.get_UVOffset();
	}
	,get_vertexOffset: function() {
		return this._subGeometry.get_vertexOffset();
	}
	,get_vertexNormalOffset: function() {
		return this._subGeometry.get_vertexNormalOffset();
	}
	,get_vertexTangentOffset: function() {
		return this._subGeometry.get_vertexTangentOffset();
	}
	,getRenderSceneTransform: function(camera) {
		return this._parentMesh.get_sceneTransform();
	}
	,__class__: away3d_core_base_SubMesh
	,__properties__: {get_vertexTangentOffset:"get_vertexTangentOffset",get_vertexNormalOffset:"get_vertexNormalOffset",get_vertexOffset:"get_vertexOffset",get_UVOffset:"get_UVOffset",get_vertexTangentData:"get_vertexTangentData",get_vertexNormalData:"get_vertexNormalData",get_UVStride:"get_UVStride",get_vertexStride:"get_vertexStride",get_numVertices:"get_numVertices",get_visible:"get_visible",get_bounds:"get_bounds",get_UVData:"get_UVData",get_indexData:"get_indexData",get_vertexData:"get_vertexData",get_uvTransform2:"get_uvTransform2",get_uvTransform:"get_uvTransform",set_parentMesh:"set_parentMesh",get_parentMesh:"get_parentMesh",get_castsShadows:"get_castsShadows",get_mouseEnabled:"get_mouseEnabled",get_animator:"get_animator",get_numTriangles:"get_numTriangles",get_inverseSceneTransform:"get_inverseSceneTransform",get_sceneTransform:"get_sceneTransform",set_material:"set_material",get_material:"get_material",set_subGeometry:"set_subGeometry",get_subGeometry:"get_subGeometry",get_sourceEntity:"get_sourceEntity",set_uvRotation2:"set_uvRotation2",get_uvRotation2:"get_uvRotation2",set_scaleV2:"set_scaleV2",get_scaleV2:"get_scaleV2",set_scaleU2:"set_scaleU2",get_scaleU2:"get_scaleU2",set_offsetV2:"set_offsetV2",get_offsetV2:"get_offsetV2",set_offsetU2:"set_offsetU2",get_offsetU2:"get_offsetU2",set_uvRotation:"set_uvRotation",get_uvRotation:"get_uvRotation",set_scaleV:"set_scaleV",get_scaleV:"get_scaleV",set_scaleU:"set_scaleU",get_scaleU:"get_scaleU",set_offsetV:"set_offsetV",get_offsetV:"get_offsetV",set_offsetU:"set_offsetU",get_offsetU:"get_offsetU",get_shaderPickingDetails:"get_shaderPickingDetails"}
};
var away3d_core_base_data_ParticleData = function() {
};
$hxClasses["away3d.core.base.data.ParticleData"] = away3d_core_base_data_ParticleData;
away3d_core_base_data_ParticleData.__name__ = "away3d.core.base.data.ParticleData";
away3d_core_base_data_ParticleData.prototype = {
	particleIndex: null
	,numVertices: null
	,startVertexIndex: null
	,subGeometry: null
	,__class__: away3d_core_base_data_ParticleData
};
var away3d_core_data_EntityListItem = function() {
};
$hxClasses["away3d.core.data.EntityListItem"] = away3d_core_data_EntityListItem;
away3d_core_data_EntityListItem.__name__ = "away3d.core.data.EntityListItem";
away3d_core_data_EntityListItem.prototype = {
	entity: null
	,next: null
	,__class__: away3d_core_data_EntityListItem
};
var away3d_core_data_EntityListItemPool = function() {
	this._index = 0;
	this._poolSize = 0;
	this._pool = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
};
$hxClasses["away3d.core.data.EntityListItemPool"] = away3d_core_data_EntityListItemPool;
away3d_core_data_EntityListItemPool.__name__ = "away3d.core.data.EntityListItemPool";
away3d_core_data_EntityListItemPool.prototype = {
	_pool: null
	,_index: null
	,_poolSize: null
	,getItem: function() {
		var item;
		if(this._index == this._poolSize) {
			item = new away3d_core_data_EntityListItem();
			this._pool.set(this._index++,item);
			++this._poolSize;
		} else {
			item = this._pool.get(this._index++);
		}
		return item;
	}
	,freeAll: function() {
		this._index = 0;
	}
	,dispose: function() {
		this._pool.set_length(0);
	}
	,__class__: away3d_core_data_EntityListItemPool
};
var away3d_core_data_RenderableListItem = function() {
};
$hxClasses["away3d.core.data.RenderableListItem"] = away3d_core_data_RenderableListItem;
away3d_core_data_RenderableListItem.__name__ = "away3d.core.data.RenderableListItem";
away3d_core_data_RenderableListItem.prototype = {
	next: null
	,renderable: null
	,materialId: null
	,renderOrderId: null
	,zIndex: null
	,renderSceneTransform: null
	,cascaded: null
	,__class__: away3d_core_data_RenderableListItem
};
var away3d_core_data_RenderableListItemPool = function() {
	this._index = 0;
	this._poolSize = 0;
	this._pool = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
};
$hxClasses["away3d.core.data.RenderableListItemPool"] = away3d_core_data_RenderableListItemPool;
away3d_core_data_RenderableListItemPool.__name__ = "away3d.core.data.RenderableListItemPool";
away3d_core_data_RenderableListItemPool.prototype = {
	_pool: null
	,_index: null
	,_poolSize: null
	,getItem: function() {
		if(this._index == this._poolSize) {
			var item = new away3d_core_data_RenderableListItem();
			this._pool.set(this._index++,item);
			++this._poolSize;
			return item;
		} else {
			return this._pool.get(this._index++);
		}
	}
	,freeAll: function() {
		this._index = 0;
	}
	,dispose: function() {
		this._pool.set_length(0);
	}
	,__class__: away3d_core_data_RenderableListItemPool
};
var away3d_core_managers_AGALProgram3DCache = function(stage3DProxy) {
	this._stage3DProxy = stage3DProxy;
	this._program3Ds = new haxe_ds_StringMap();
	this._ids = new haxe_ds_StringMap();
	this._usages = [];
	this._keys = [];
};
$hxClasses["away3d.core.managers.AGALProgram3DCache"] = away3d_core_managers_AGALProgram3DCache;
away3d_core_managers_AGALProgram3DCache.__name__ = "away3d.core.managers.AGALProgram3DCache";
away3d_core_managers_AGALProgram3DCache.getInstance = function(stage3DProxy) {
	var index = stage3DProxy.get_stage3DIndex();
	if(away3d_core_managers_AGALProgram3DCache._instances == null) {
		away3d_core_managers_AGALProgram3DCache._instances = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8,true);
	}
	if(away3d_core_managers_AGALProgram3DCache._instances.get(index) == null) {
		away3d_core_managers_AGALProgram3DCache._instances.set(index,new away3d_core_managers_AGALProgram3DCache(stage3DProxy));
		stage3DProxy.addEventListener("Context3DDisposed",away3d_core_managers_AGALProgram3DCache.onContext3DDisposed,false,0,true);
		stage3DProxy.addEventListener("Context3DCreated",away3d_core_managers_AGALProgram3DCache.onContext3DDisposed,false,0,true);
		stage3DProxy.addEventListener("Context3DRecreated",away3d_core_managers_AGALProgram3DCache.onContext3DDisposed,false,0,true);
	}
	return away3d_core_managers_AGALProgram3DCache._instances.get(index);
};
away3d_core_managers_AGALProgram3DCache.getInstanceFromIndex = function(index) {
	if(away3d_core_managers_AGALProgram3DCache._instances.get(index) == null) {
		throw new js__$Boot_HaxeError(new openfl_errors_Error("Instance not created yet!"));
	}
	return away3d_core_managers_AGALProgram3DCache._instances.get(index);
};
away3d_core_managers_AGALProgram3DCache.onContext3DDisposed = function(event) {
	var stage3DProxy = js_Boot.__cast(event.target , away3d_core_managers_Stage3DProxy);
	var index = stage3DProxy._stage3DIndex;
	away3d_core_managers_AGALProgram3DCache._instances.get(index).dispose();
	away3d_core_managers_AGALProgram3DCache._instances.set(index,null);
	stage3DProxy.removeEventListener("Context3DDisposed",away3d_core_managers_AGALProgram3DCache.onContext3DDisposed);
	stage3DProxy.removeEventListener("Context3DCreated",away3d_core_managers_AGALProgram3DCache.onContext3DDisposed);
	stage3DProxy.removeEventListener("Context3DRecreated",away3d_core_managers_AGALProgram3DCache.onContext3DDisposed);
};
away3d_core_managers_AGALProgram3DCache.prototype = {
	_stage3DProxy: null
	,_program3Ds: null
	,_ids: null
	,_usages: null
	,_keys: null
	,dispose: function() {
		var keys = this._program3Ds.keys();
		var key = keys;
		while(key.hasNext()) {
			var key1 = key.next();
			this.destroyProgram(key1);
		}
		this._keys = null;
		this._program3Ds = null;
		this._usages = null;
	}
	,setProgram3D: function(pass,vertexCode,fragmentCode,agalVersion) {
		if(agalVersion == null) {
			agalVersion = 1;
		}
		var stageIndex = this._stage3DProxy._stage3DIndex;
		var program;
		var key = vertexCode + "---" + fragmentCode;
		var _this = this._program3Ds;
		if(!(__map_reserved[key] != null ? _this.existsReserved(key) : _this.h.hasOwnProperty(key))) {
			this._keys[away3d_core_managers_AGALProgram3DCache._currentId] = key;
			this._usages[away3d_core_managers_AGALProgram3DCache._currentId] = 0;
			var v = away3d_core_managers_AGALProgram3DCache._currentId;
			var _this1 = this._ids;
			if(__map_reserved[key] != null) {
				_this1.setReserved(key,v);
			} else {
				_this1.h[key] = v;
			}
			++away3d_core_managers_AGALProgram3DCache._currentId;
			program = this._stage3DProxy._context3D.createProgram();
			var vertexByteCode = new openfl_utils_AGALMiniAssembler(away3d_debug_Debug.active).assemble(openfl_display3D__$Context3DProgramType_Context3DProgramType_$Impl_$.toString(1),vertexCode,agalVersion);
			var fragmentByteCode = new openfl_utils_AGALMiniAssembler(away3d_debug_Debug.active).assemble(openfl_display3D__$Context3DProgramType_Context3DProgramType_$Impl_$.toString(0),fragmentCode,agalVersion);
			program.upload(vertexByteCode,fragmentByteCode);
			var _this2 = this._program3Ds;
			if(__map_reserved[key] != null) {
				_this2.setReserved(key,program);
			} else {
				_this2.h[key] = program;
			}
		}
		var oldId = pass._program3Dids.get(stageIndex);
		var _this3 = this._ids;
		var newId = __map_reserved[key] != null ? _this3.getReserved(key) : _this3.h[key];
		if(oldId != newId) {
			if(oldId >= 0) {
				this.freeProgram3D(oldId);
			}
			this._usages[newId]++;
		}
		pass._program3Dids.set(stageIndex,newId);
		var _this4 = this._program3Ds;
		pass._program3Ds.set(stageIndex,__map_reserved[key] != null ? _this4.getReserved(key) : _this4.h[key]);
	}
	,freeProgram3D: function(programId) {
		this._usages[programId]--;
		if(this._usages[programId] == 0) {
			this.destroyProgram(this._keys[programId]);
		}
	}
	,destroyProgram: function(key) {
		var _this = this._program3Ds;
		(__map_reserved[key] != null ? _this.getReserved(key) : _this.h[key]).dispose();
		this._program3Ds.remove(key);
		var _this1 = this._ids;
		if(__map_reserved[key] != null) {
			_this1.setReserved(key,-1);
		} else {
			_this1.h[key] = -1;
		}
	}
	,getKey: function(vertexCode,fragmentCode) {
		return vertexCode + "---" + fragmentCode;
	}
	,__class__: away3d_core_managers_AGALProgram3DCache
};
var openfl_events_Event = function(type,bubbles,cancelable) {
	if(cancelable == null) {
		cancelable = false;
	}
	if(bubbles == null) {
		bubbles = false;
	}
	this.type = type;
	this.bubbles = bubbles;
	this.cancelable = cancelable;
	this.eventPhase = 2;
};
$hxClasses["openfl.events.Event"] = openfl_events_Event;
openfl_events_Event.__name__ = "openfl.events.Event";
openfl_events_Event.prototype = {
	bubbles: null
	,cancelable: null
	,currentTarget: null
	,eventPhase: null
	,target: null
	,type: null
	,__isCanceled: null
	,__isCanceledNow: null
	,__preventDefault: null
	,clone: function() {
		var event = new openfl_events_Event(this.type,this.bubbles,this.cancelable);
		event.eventPhase = this.eventPhase;
		event.target = this.target;
		event.currentTarget = this.currentTarget;
		return event;
	}
	,formatToString: function(className,p1,p2,p3,p4,p5) {
		var parameters = [];
		if(p1 != null) {
			parameters.push(p1);
		}
		if(p2 != null) {
			parameters.push(p2);
		}
		if(p3 != null) {
			parameters.push(p3);
		}
		if(p4 != null) {
			parameters.push(p4);
		}
		if(p5 != null) {
			parameters.push(p5);
		}
		return $bind(this,this.__formatToString).apply(this,[className,parameters]);
	}
	,isDefaultPrevented: function() {
		return this.__preventDefault;
	}
	,preventDefault: function() {
		if(this.cancelable) {
			this.__preventDefault = true;
		}
	}
	,stopImmediatePropagation: function() {
		this.__isCanceled = true;
		this.__isCanceledNow = true;
	}
	,stopPropagation: function() {
		this.__isCanceled = true;
	}
	,toString: function() {
		return this.__formatToString("Event",["type","bubbles","cancelable"]);
	}
	,__formatToString: function(className,parameters) {
		var output = "[" + className;
		var arg = null;
		var _g = 0;
		while(_g < parameters.length) {
			var param = parameters[_g];
			++_g;
			arg = Reflect.field(this,param);
			if(typeof(arg) == "string") {
				output += " " + param + "=\"" + Std.string(arg) + "\"";
			} else {
				output += " " + param + "=" + Std.string(arg);
			}
		}
		output += "]";
		return output;
	}
	,__init: function() {
		this.target = null;
		this.currentTarget = null;
		this.bubbles = false;
		this.cancelable = false;
		this.eventPhase = 2;
		this.__isCanceled = false;
		this.__isCanceledNow = false;
		this.__preventDefault = false;
	}
	,__class__: openfl_events_Event
};
var away3d_events_MouseEvent3D = function(type) {
	this._allowedToPropagate = true;
	openfl_events_Event.call(this,type,true,true);
};
$hxClasses["away3d.events.MouseEvent3D"] = away3d_events_MouseEvent3D;
away3d_events_MouseEvent3D.__name__ = "away3d.events.MouseEvent3D";
away3d_events_MouseEvent3D.__super__ = openfl_events_Event;
away3d_events_MouseEvent3D.prototype = $extend(openfl_events_Event.prototype,{
	_allowedToPropagate: null
	,_parentEvent: null
	,screenX: null
	,screenY: null
	,view: null
	,object: null
	,renderable: null
	,material: null
	,uv: null
	,index: null
	,subGeometryIndex: null
	,localPosition: null
	,localNormal: null
	,ctrlKey: null
	,altKey: null
	,shiftKey: null
	,delta: null
	,stopPropagation: function() {
		openfl_events_Event.prototype.stopPropagation.call(this);
		this._allowedToPropagate = false;
		if(this._parentEvent != null) {
			this._parentEvent.stopPropagation();
		}
	}
	,stopImmediatePropagation: function() {
		openfl_events_Event.prototype.stopImmediatePropagation.call(this);
		this._allowedToPropagate = false;
		if(this._parentEvent != null) {
			this._parentEvent.stopImmediatePropagation();
		}
	}
	,clone: function() {
		var result = new away3d_events_MouseEvent3D(this.type);
		result.screenX = this.screenX;
		result.screenY = this.screenY;
		result.view = this.view;
		result.object = this.object;
		result.renderable = this.renderable;
		result.material = this.material;
		result.uv = this.uv;
		result.localPosition = this.localPosition;
		result.localNormal = this.localNormal;
		result.index = this.index;
		result.subGeometryIndex = this.subGeometryIndex;
		result.delta = this.delta;
		result.ctrlKey = this.ctrlKey;
		result.shiftKey = this.shiftKey;
		result._parentEvent = this;
		result._allowedToPropagate = this._allowedToPropagate;
		return result;
	}
	,get_scenePosition: function() {
		if(((this.object) instanceof away3d_containers_ObjectContainer3D)) {
			return away3d_core_math_Matrix3DUtils.transformVector((js_Boot.__cast(this.object , away3d_containers_ObjectContainer3D)).get_sceneTransform(),this.localPosition);
		} else {
			return this.localPosition;
		}
	}
	,getScenePosition: function(v) {
		if(v == null) {
			v = new openfl_geom_Vector3D();
		}
		if(((this.object) instanceof away3d_containers_ObjectContainer3D)) {
			away3d_core_math_Matrix3DUtils.transformVector((js_Boot.__cast(this.object , away3d_containers_ObjectContainer3D)).get_sceneTransform(),this.localPosition,v);
		} else {
			v.x = this.localPosition.x;
			v.y = this.localPosition.y;
			v.z = this.localPosition.z;
		}
		return v;
	}
	,get_sceneNormal: function() {
		if(((this.object) instanceof away3d_containers_ObjectContainer3D)) {
			var sceneNormal = away3d_core_math_Matrix3DUtils.deltaTransformVector((js_Boot.__cast(this.object , away3d_containers_ObjectContainer3D)).get_sceneTransform(),this.localNormal);
			sceneNormal.normalize();
			return sceneNormal;
		} else {
			return this.localNormal;
		}
	}
	,getSceneNormal: function(v) {
		if(v == null) {
			v = new openfl_geom_Vector3D();
		}
		if(((this.object) instanceof away3d_containers_ObjectContainer3D)) {
			away3d_core_math_Matrix3DUtils.deltaTransformVector((js_Boot.__cast(this.object , away3d_containers_ObjectContainer3D)).get_sceneTransform(),this.localNormal,v);
			v.normalize();
		} else {
			v.x = this.localNormal.x;
			v.y = this.localNormal.y;
			v.z = this.localNormal.z;
		}
		return v;
	}
	,__class__: away3d_events_MouseEvent3D
	,__properties__: {get_sceneNormal:"get_sceneNormal",get_scenePosition:"get_scenePosition"}
});
var away3d_core_managers_Mouse3DManager = function() {
	this._childDepth = 0;
	this._mousePicker = away3d_core_pick_PickingType.RAYCAST_FIRST_ENCOUNTERED;
	this._mouseMoveEvent = new openfl_events_MouseEvent("mouseMove");
	this._nullVector = new openfl_geom_Vector3D();
	this._updateDirty = true;
	if(away3d_core_managers_Mouse3DManager._view3Ds == null) {
		away3d_core_managers_Mouse3DManager._view3Ds = new haxe_ds_ObjectMap();
		away3d_core_managers_Mouse3DManager._view3DLookup = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	}
};
$hxClasses["away3d.core.managers.Mouse3DManager"] = away3d_core_managers_Mouse3DManager;
away3d_core_managers_Mouse3DManager.__name__ = "away3d.core.managers.Mouse3DManager";
away3d_core_managers_Mouse3DManager.prototype = {
	_activeView: null
	,_updateDirty: null
	,_nullVector: null
	,_mouseMoveEvent: null
	,_forceMouseMove: null
	,_mousePicker: null
	,_childDepth: null
	,_collidingDownObject: null
	,_collidingUpObject: null
	,updateCollider: function(view) {
		away3d_core_managers_Mouse3DManager._previousCollidingView = away3d_core_managers_Mouse3DManager._collidingView;
		if(view != null) {
			if(view.get_stage3DProxy().get_bufferClear()) {
				away3d_core_managers_Mouse3DManager._collidingViewObjects = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,away3d_core_managers_Mouse3DManager._viewCount);
			}
			var p = view.localToGlobal(new openfl_geom_Point(view.get_mouseX(),view.get_mouseY()));
			if(!view.get_shareContext()) {
				if(view == this._activeView && (this._forceMouseMove || this._updateDirty)) {
					away3d_core_managers_Mouse3DManager._collidingObject = this._mousePicker.getViewCollision(p.x,p.y,view);
				}
			} else {
				if(away3d_core_managers_Mouse3DManager._collidingViewObjects == null) {
					away3d_core_managers_Mouse3DManager._collidingViewObjects = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,away3d_core_managers_Mouse3DManager._viewCount);
				}
				away3d_core_managers_Mouse3DManager._collidingObject = away3d_core_managers_Mouse3DManager._collidingViewObjects.set(away3d_core_managers_Mouse3DManager._view3Ds.h[view.__id__],this._mousePicker.getViewCollision(p.x,p.y,view));
			}
		}
	}
	,fireMouseEvents: function() {
		var i = 0;
		var event;
		var dispatcher;
		if(away3d_core_managers_Mouse3DManager._collidingViewObjects != null) {
			away3d_core_managers_Mouse3DManager._collidingObject = null;
			var distance = Infinity;
			var view;
			var v = away3d_core_managers_Mouse3DManager._viewCount - 1;
			while(v >= 0) {
				view = away3d_core_managers_Mouse3DManager._view3DLookup.get(v);
				if(away3d_core_managers_Mouse3DManager._collidingViewObjects.get(v) != null && (view.get_layeredView() || away3d_core_managers_Mouse3DManager._collidingViewObjects.get(v).rayEntryDistance < distance)) {
					distance = away3d_core_managers_Mouse3DManager._collidingViewObjects.get(v).rayEntryDistance;
					away3d_core_managers_Mouse3DManager._collidingObject = away3d_core_managers_Mouse3DManager._collidingViewObjects.get(v);
					if(view.get_layeredView()) {
						break;
					}
				}
				--v;
			}
		}
		if(away3d_core_managers_Mouse3DManager._collidingObject != away3d_core_managers_Mouse3DManager._previousCollidingObject) {
			if(away3d_core_managers_Mouse3DManager._previousCollidingObject != null) {
				this.queueDispatch(away3d_core_managers_Mouse3DManager._mouseOut,this._mouseMoveEvent,away3d_core_managers_Mouse3DManager._previousCollidingObject);
			}
			if(away3d_core_managers_Mouse3DManager._collidingObject != null) {
				this.queueDispatch(away3d_core_managers_Mouse3DManager._mouseOver,this._mouseMoveEvent,away3d_core_managers_Mouse3DManager._collidingObject);
			}
		}
		if(this._forceMouseMove && away3d_core_managers_Mouse3DManager._collidingObject != null) {
			this.queueDispatch(away3d_core_managers_Mouse3DManager._mouseMove,this._mouseMoveEvent,away3d_core_managers_Mouse3DManager._collidingObject);
		}
		var len = away3d_core_managers_Mouse3DManager._queuedEvents.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i1 = _g++;
			event = away3d_core_managers_Mouse3DManager._queuedEvents.get(i1);
			dispatcher = event.object;
			while(dispatcher != null && !dispatcher._ancestorsAllowMouseEnabled) dispatcher = dispatcher.get_parent();
			if(dispatcher != null) {
				dispatcher.dispatchEvent(event);
			}
		}
		away3d_core_managers_Mouse3DManager._queuedEvents.set_length(0);
		this._updateDirty = false;
		away3d_core_managers_Mouse3DManager._previousCollidingObject = away3d_core_managers_Mouse3DManager._collidingObject;
	}
	,addViewLayer: function(view) {
		var stg = view.stage;
		if(view.get_stage3DProxy().get_mouse3DManager() == null) {
			view.get_stage3DProxy().set_mouse3DManager(this);
		}
		if(!this.hasKey(view)) {
			away3d_core_managers_Mouse3DManager._view3Ds.set(view,0);
		}
		this._childDepth = 0;
		this.traverseDisplayObjects(stg);
		away3d_core_managers_Mouse3DManager._viewCount = this._childDepth;
	}
	,enableMouseListeners: function(view) {
		view.addEventListener("click",$bind(this,this.onClick));
		view.addEventListener("doubleClick",$bind(this,this.onDoubleClick));
		view.addEventListener("mouseDown",$bind(this,this.onMouseDown));
		view.addEventListener("mouseMove",$bind(this,this.onMouseMove));
		view.addEventListener("mouseUp",$bind(this,this.onMouseUp));
		view.addEventListener("mouseWheel",$bind(this,this.onMouseWheel));
		view.addEventListener("mouseOver",$bind(this,this.onMouseOver));
		view.addEventListener("mouseOut",$bind(this,this.onMouseOut));
	}
	,disableMouseListeners: function(view) {
		view.removeEventListener("click",$bind(this,this.onClick));
		view.removeEventListener("doubleClick",$bind(this,this.onDoubleClick));
		view.removeEventListener("mouseDown",$bind(this,this.onMouseDown));
		view.removeEventListener("mouseMove",$bind(this,this.onMouseMove));
		view.removeEventListener("mouseUp",$bind(this,this.onMouseUp));
		view.removeEventListener("mouseWheel",$bind(this,this.onMouseWheel));
		view.removeEventListener("mouseOver",$bind(this,this.onMouseOver));
		view.removeEventListener("mouseOut",$bind(this,this.onMouseOut));
	}
	,dispose: function() {
		this._mousePicker.dispose();
	}
	,queueDispatch: function(event,sourceEvent,collider) {
		event.ctrlKey = sourceEvent.ctrlKey;
		event.altKey = sourceEvent.altKey;
		event.shiftKey = sourceEvent.shiftKey;
		event.delta = sourceEvent.delta;
		event.screenX = sourceEvent.localX;
		event.screenY = sourceEvent.localY;
		if(collider == null) {
			collider = away3d_core_managers_Mouse3DManager._collidingObject;
		}
		if(collider != null) {
			event.object = collider.entity;
			event.renderable = collider.renderable;
			event.uv = collider.uv;
			event.localPosition = collider.localPosition != null ? collider.localPosition.clone() : null;
			event.localNormal = collider.localNormal != null ? collider.localNormal.clone() : null;
			event.index = collider.index;
			event.subGeometryIndex = collider.subGeometryIndex;
		} else {
			event.uv = null;
			event.object = null;
			event.localPosition = this._nullVector;
			event.localNormal = this._nullVector;
			event.index = 0;
			event.subGeometryIndex = 0;
		}
		away3d_core_managers_Mouse3DManager._queuedEvents.push(event);
	}
	,reThrowEvent: function(event) {
		if(this._activeView == null || this._activeView != null && !this._activeView.get_shareContext()) {
			return;
		}
		var keys = away3d_core_managers_Mouse3DManager._view3Ds.keys();
		var v = keys;
		while(v.hasNext()) {
			var v1 = v.next();
			if(v1 != this._activeView && away3d_core_managers_Mouse3DManager._view3Ds.h[v1.__id__] == away3d_core_managers_Mouse3DManager._view3Ds.h[this._activeView.__id__] - 1) {
				if(event.bubbles == true) {
					v1.dispatchEvent(new openfl_events_MouseEvent(event.type,false,event.cancelable,event.localX,event.localY,event.relatedObject,event.ctrlKey,event.altKey,event.shiftKey,event.buttonDown,event.delta,event.commandKey,event.clickCount));
				} else {
					v1.dispatchEvent(event);
				}
			}
		}
	}
	,hasKey: function(view) {
		return away3d_core_managers_Mouse3DManager._view3Ds.h.__keys__[view.__id__] != null;
	}
	,traverseDisplayObjects: function(container) {
		var childCount = container.get_numChildren();
		var c = 0;
		var child;
		var _g = 0;
		var _g1 = childCount;
		while(_g < _g1) {
			var c1 = _g++;
			child = container.getChildAt(c1);
			if(((child) instanceof away3d_containers_View3D) && away3d_core_managers_Mouse3DManager._view3Ds.h.__keys__[child.__id__] != null) {
				var v = this._childDepth;
				away3d_core_managers_Mouse3DManager._view3Ds.set(child,v);
				away3d_core_managers_Mouse3DManager._view3DLookup.set(this._childDepth,child);
				this._childDepth++;
			}
			if(((child) instanceof openfl_display_DisplayObjectContainer)) {
				this.traverseDisplayObjects(js_Boot.__cast(child , openfl_display_DisplayObjectContainer));
			}
		}
	}
	,onMouseMove: function(event) {
		if(away3d_core_managers_Mouse3DManager._collidingObject != null) {
			this.queueDispatch(away3d_core_managers_Mouse3DManager._mouseMove,this._mouseMoveEvent = event);
		} else {
			this.reThrowEvent(event);
		}
		this._updateDirty = true;
	}
	,onMouseOut: function(event) {
		this._activeView = null;
		if(away3d_core_managers_Mouse3DManager._collidingObject != null) {
			this.queueDispatch(away3d_core_managers_Mouse3DManager._mouseOut,event,away3d_core_managers_Mouse3DManager._collidingObject);
		}
		this._updateDirty = true;
	}
	,onMouseOver: function(event) {
		this._activeView = js_Boot.__cast(event.currentTarget , away3d_containers_View3D);
		if(away3d_core_managers_Mouse3DManager._collidingObject != null && away3d_core_managers_Mouse3DManager._previousCollidingObject != away3d_core_managers_Mouse3DManager._collidingObject) {
			this.queueDispatch(away3d_core_managers_Mouse3DManager._mouseOver,event,away3d_core_managers_Mouse3DManager._collidingObject);
		} else {
			this.reThrowEvent(event);
		}
		this._updateDirty = true;
	}
	,onClick: function(event) {
		if(away3d_core_managers_Mouse3DManager._collidingObject != null) {
			this.queueDispatch(away3d_core_managers_Mouse3DManager._mouseClick,event);
		} else {
			this.reThrowEvent(event);
		}
		this._updateDirty = true;
	}
	,onDoubleClick: function(event) {
		if(away3d_core_managers_Mouse3DManager._collidingObject != null) {
			this.queueDispatch(away3d_core_managers_Mouse3DManager._mouseDoubleClick,event);
		} else {
			this.reThrowEvent(event);
		}
		this._updateDirty = true;
	}
	,onMouseDown: function(event) {
		this._activeView = js_Boot.__cast(event.currentTarget , away3d_containers_View3D);
		this.updateCollider(this._activeView);
		if(away3d_core_managers_Mouse3DManager._collidingObject != null) {
			this.queueDispatch(away3d_core_managers_Mouse3DManager._mouseDown,event);
			away3d_core_managers_Mouse3DManager._previousCollidingObject = away3d_core_managers_Mouse3DManager._collidingObject;
		} else {
			this.reThrowEvent(event);
		}
		this._updateDirty = true;
	}
	,onMouseUp: function(event) {
		if(away3d_core_managers_Mouse3DManager._collidingObject != null) {
			this.queueDispatch(away3d_core_managers_Mouse3DManager._mouseUp,event);
			away3d_core_managers_Mouse3DManager._previousCollidingObject = away3d_core_managers_Mouse3DManager._collidingObject;
		} else {
			this.reThrowEvent(event);
		}
		this._updateDirty = true;
	}
	,onMouseWheel: function(event) {
		if(away3d_core_managers_Mouse3DManager._collidingObject != null) {
			this.queueDispatch(away3d_core_managers_Mouse3DManager._mouseWheel,event);
		} else {
			this.reThrowEvent(event);
		}
		this._updateDirty = true;
	}
	,get_forceMouseMove: function() {
		return this._forceMouseMove;
	}
	,set_forceMouseMove: function(value) {
		this._forceMouseMove = value;
		return value;
	}
	,get_mousePicker: function() {
		return this._mousePicker;
	}
	,set_mousePicker: function(value) {
		this._mousePicker = value;
		return value;
	}
	,__class__: away3d_core_managers_Mouse3DManager
	,__properties__: {set_mousePicker:"set_mousePicker",get_mousePicker:"get_mousePicker",set_forceMouseMove:"set_forceMouseMove",get_forceMouseMove:"get_forceMouseMove"}
};
var away3d_core_managers_RTTBufferManager = function(stage3DProxy) {
	this._buffersInvalid = true;
	this._textureHeight = -1;
	this._textureWidth = -1;
	this._viewHeight = -1;
	this._viewWidth = -1;
	this._renderToTextureRect = new openfl_geom_Rectangle();
	this._stage3DProxy = stage3DProxy;
	this._stage3DProxy.addEventListener("Context3DRecreated",$bind(this,this.onContextRecreated));
	openfl_events_EventDispatcher.call(this);
};
$hxClasses["away3d.core.managers.RTTBufferManager"] = away3d_core_managers_RTTBufferManager;
away3d_core_managers_RTTBufferManager.__name__ = "away3d.core.managers.RTTBufferManager";
away3d_core_managers_RTTBufferManager.getInstance = function(stage3DProxy) {
	if(stage3DProxy == null) {
		throw new js__$Boot_HaxeError(new openfl_errors_Error("stage3DProxy key cannot be null!"));
	}
	if(away3d_core_managers_RTTBufferManager._instances == null) {
		away3d_core_managers_RTTBufferManager._instances = new haxe_ds_ObjectMap();
	}
	var rttb = away3d_core_managers_RTTBufferManager._instances.h[stage3DProxy.__id__];
	if(rttb == null) {
		rttb = new away3d_core_managers_RTTBufferManager(stage3DProxy);
		away3d_core_managers_RTTBufferManager._instances.set(stage3DProxy,rttb);
	}
	return rttb;
};
away3d_core_managers_RTTBufferManager.__super__ = openfl_events_EventDispatcher;
away3d_core_managers_RTTBufferManager.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	_renderToTextureVertexBuffer: null
	,_renderToScreenVertexBuffer: null
	,_indexBuffer: null
	,_stage3DProxy: null
	,_viewWidth: null
	,_viewHeight: null
	,_textureWidth: null
	,_textureHeight: null
	,_renderToTextureRect: null
	,_buffersInvalid: null
	,_textureRatioX: null
	,_textureRatioY: null
	,get_textureRatioX: function() {
		if(this._buffersInvalid) {
			this.updateRTTBuffers();
		}
		return this._textureRatioX;
	}
	,get_textureRatioY: function() {
		if(this._buffersInvalid) {
			this.updateRTTBuffers();
		}
		return this._textureRatioY;
	}
	,get_viewWidth: function() {
		return this._viewWidth;
	}
	,set_viewWidth: function(value) {
		if(value == this._viewWidth) {
			return value;
		}
		this._viewWidth = value;
		this._buffersInvalid = true;
		this._textureWidth = away3d_tools_utils_TextureUtils.getBestPowerOf2(this._viewWidth);
		if(this._textureWidth > this._viewWidth) {
			this._renderToTextureRect.x = (this._textureWidth - this._viewWidth) * .5 | 0;
			this._renderToTextureRect.width = this._viewWidth;
		} else {
			this._renderToTextureRect.x = 0;
			this._renderToTextureRect.width = this._textureWidth;
		}
		this.dispatchEvent(new openfl_events_Event("resize"));
		return value;
	}
	,get_viewHeight: function() {
		return this._viewHeight;
	}
	,set_viewHeight: function(value) {
		if(value == this._viewHeight) {
			return value;
		}
		this._viewHeight = value;
		this._buffersInvalid = true;
		this._textureHeight = away3d_tools_utils_TextureUtils.getBestPowerOf2(this._viewHeight);
		if(this._textureHeight > this._viewHeight) {
			this._renderToTextureRect.y = (this._textureHeight - this._viewHeight) * .5 | 0;
			this._renderToTextureRect.height = this._viewHeight;
		} else {
			this._renderToTextureRect.y = 0;
			this._renderToTextureRect.height = this._textureHeight;
		}
		this.dispatchEvent(new openfl_events_Event("resize"));
		return value;
	}
	,get_renderToTextureVertexBuffer: function() {
		if(this._buffersInvalid) {
			this.updateRTTBuffers();
		}
		return this._renderToTextureVertexBuffer;
	}
	,get_renderToScreenVertexBuffer: function() {
		if(this._buffersInvalid) {
			this.updateRTTBuffers();
		}
		return this._renderToScreenVertexBuffer;
	}
	,get_indexBuffer: function() {
		return this._indexBuffer;
	}
	,get_renderToTextureRect: function() {
		if(this._buffersInvalid) {
			this.updateRTTBuffers();
		}
		return this._renderToTextureRect;
	}
	,get_textureWidth: function() {
		return this._textureWidth;
	}
	,get_textureHeight: function() {
		return this._textureHeight;
	}
	,dispose: function() {
		away3d_core_managers_RTTBufferManager._instances.remove(this._stage3DProxy);
		this._stage3DProxy.removeEventListener("Context3DRecreated",$bind(this,this.onContextRecreated));
		if(this._indexBuffer != null) {
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(this._indexBuffer);
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(this._renderToScreenVertexBuffer);
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(this._renderToTextureVertexBuffer);
			this._renderToScreenVertexBuffer = null;
			this._renderToTextureVertexBuffer = null;
			this._indexBuffer = null;
		}
	}
	,onContextRecreated: function(event) {
		this._indexBuffer = null;
		this._renderToTextureVertexBuffer = null;
		this._renderToScreenVertexBuffer = null;
		this.updateRTTBuffers();
	}
	,updateRTTBuffers: function() {
		var context = this._stage3DProxy.get_context3D();
		if(this._renderToTextureVertexBuffer == null) {
			this._renderToTextureVertexBuffer = this._stage3DProxy.createVertexBuffer(4,5);
		}
		if(this._renderToScreenVertexBuffer == null) {
			this._renderToScreenVertexBuffer = this._stage3DProxy.createVertexBuffer(4,5);
		}
		if(this._indexBuffer == null) {
			this._indexBuffer = this._stage3DProxy.createIndexBuffer(6);
			var array = [2,1,0,3,2,0];
			var vector = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
			var _g = 0;
			var _g1 = array.length;
			while(_g < _g1) {
				var i = _g++;
				vector.set(i,array[i]);
			}
			var v = vector;
			this._indexBuffer.uploadFromVector(v,0,6);
		}
		var x = Math.min(this._viewWidth / this._textureWidth,1);
		this._textureRatioX = x;
		var y = Math.min(this._viewHeight / this._textureHeight,1);
		this._textureRatioY = y;
		var u1 = (1 - x) * .5;
		var u2 = (x + 1) * .5;
		var v1 = (y + 1) * .5;
		var v2 = (1 - y) * .5;
		var array1 = [-x,-y,u1,v1,0,x,-y,u2,v1,1,x,y,u2,v2,2,-x,y,u1,v2,3];
		var vector1 = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
		var _g2 = 0;
		var _g11 = array1.length;
		while(_g2 < _g11) {
			var i1 = _g2++;
			vector1.set(i1,array1[i1]);
		}
		var textureVerts = vector1;
		var array2 = [-1,-1,u1,v1,0,1,-1,u2,v1,1,1,1,u2,v2,2,-1,1,u1,v2,3];
		var vector2 = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
		var _g3 = 0;
		var _g12 = array2.length;
		while(_g3 < _g12) {
			var i2 = _g3++;
			vector2.set(i2,array2[i2]);
		}
		var screenVerts = vector2;
		this._renderToTextureVertexBuffer.uploadFromVector(textureVerts,0,4);
		this._renderToScreenVertexBuffer.uploadFromVector(screenVerts,0,4);
		this._buffersInvalid = false;
	}
	,__class__: away3d_core_managers_RTTBufferManager
	,__properties__: {get_textureHeight:"get_textureHeight",get_textureWidth:"get_textureWidth",get_renderToTextureRect:"get_renderToTextureRect",get_indexBuffer:"get_indexBuffer",get_renderToScreenVertexBuffer:"get_renderToScreenVertexBuffer",get_renderToTextureVertexBuffer:"get_renderToTextureVertexBuffer",set_viewHeight:"set_viewHeight",get_viewHeight:"get_viewHeight",set_viewWidth:"set_viewWidth",get_viewWidth:"get_viewWidth",get_textureRatioY:"get_textureRatioY",get_textureRatioX:"get_textureRatioX"}
});
var away3d_core_managers_Stage3DManager = function(stage) {
	this._stage = stage;
	if(away3d_core_managers_Stage3DManager._stageProxies == null) {
		away3d_core_managers_Stage3DManager._stageProxies = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,this._stage.stage3Ds.get_length(),true);
	}
};
$hxClasses["away3d.core.managers.Stage3DManager"] = away3d_core_managers_Stage3DManager;
away3d_core_managers_Stage3DManager.__name__ = "away3d.core.managers.Stage3DManager";
away3d_core_managers_Stage3DManager.getInstance = function(stage) {
	if(away3d_core_managers_Stage3DManager._instances == null) {
		away3d_core_managers_Stage3DManager._instances = new haxe_ds_ObjectMap();
	}
	var manager = away3d_core_managers_Stage3DManager._instances.h[stage.__id__];
	if(manager == null) {
		manager = new away3d_core_managers_Stage3DManager(stage);
		away3d_core_managers_Stage3DManager._instances.set(stage,manager);
	}
	return manager;
};
away3d_core_managers_Stage3DManager.prototype = {
	_stage: null
	,getStage3DProxy: function(index,forceSoftware,profile) {
		if(profile == null) {
			profile = "baseline";
		}
		if(forceSoftware == null) {
			forceSoftware = false;
		}
		if(away3d_core_managers_Stage3DManager._stageProxies.get(index) == null) {
			away3d_core_managers_Stage3DManager._numStageProxies++;
			away3d_core_managers_Stage3DManager._stageProxies.set(index,new away3d_core_managers_Stage3DProxy(index,this._stage.stage3Ds.get(index),this,forceSoftware,profile));
		}
		return away3d_core_managers_Stage3DManager._stageProxies.get(index);
	}
	,removeStage3DProxy: function(stage3DProxy) {
		away3d_core_managers_Stage3DManager._numStageProxies--;
		away3d_core_managers_Stage3DManager._stageProxies.set(stage3DProxy.get_stage3DIndex(),null);
	}
	,getFreeStage3DProxy: function(forceSoftware,profile) {
		if(profile == null) {
			profile = "baseline";
		}
		if(forceSoftware == null) {
			forceSoftware = false;
		}
		var i = 0;
		var len = away3d_core_managers_Stage3DManager._stageProxies.get_length();
		while(i < len) {
			if(away3d_core_managers_Stage3DManager._stageProxies.get(i) == null) {
				this.getStage3DProxy(i,forceSoftware,profile);
				away3d_core_managers_Stage3DManager._stageProxies.get(i).set_width(this._stage.stageWidth);
				away3d_core_managers_Stage3DManager._stageProxies.get(i).set_height(this._stage.stageHeight);
				return away3d_core_managers_Stage3DManager._stageProxies.get(i);
			}
			++i;
		}
		throw new js__$Boot_HaxeError(new openfl_errors_Error("Too many Stage3D instances used!"));
	}
	,get_hasFreeStage3DProxy: function() {
		if(away3d_core_managers_Stage3DManager._numStageProxies < away3d_core_managers_Stage3DManager._stageProxies.get_length()) {
			return true;
		} else {
			return false;
		}
	}
	,get_numProxySlotsFree: function() {
		return away3d_core_managers_Stage3DManager._stageProxies.get_length() - away3d_core_managers_Stage3DManager._numStageProxies;
	}
	,get_numProxySlotsUsed: function() {
		return away3d_core_managers_Stage3DManager._numStageProxies;
	}
	,get_numProxySlotsTotal: function() {
		return away3d_core_managers_Stage3DManager._stageProxies.get_length();
	}
	,__class__: away3d_core_managers_Stage3DManager
	,__properties__: {get_numProxySlotsTotal:"get_numProxySlotsTotal",get_numProxySlotsUsed:"get_numProxySlotsUsed",get_numProxySlotsFree:"get_numProxySlotsFree",get_hasFreeStage3DProxy:"get_hasFreeStage3DProxy"}
};
var openfl_display_Shape = function() {
	openfl_display_DisplayObject.call(this);
};
$hxClasses["openfl.display.Shape"] = openfl_display_Shape;
openfl_display_Shape.__name__ = "openfl.display.Shape";
openfl_display_Shape.__super__ = openfl_display_DisplayObject;
openfl_display_Shape.prototype = $extend(openfl_display_DisplayObject.prototype,{
	get_graphics: function() {
		if(this.__graphics == null) {
			this.__graphics = new openfl_display_Graphics(this);
		}
		return this.__graphics;
	}
	,__class__: openfl_display_Shape
	,__properties__: $extend(openfl_display_DisplayObject.prototype.__properties__,{get_graphics:"get_graphics"})
});
var lime_math_Matrix3 = function(a,b,c,d,tx,ty) {
	if(ty == null) {
		ty = 0;
	}
	if(tx == null) {
		tx = 0;
	}
	if(d == null) {
		d = 1;
	}
	if(c == null) {
		c = 0;
	}
	if(b == null) {
		b = 0;
	}
	if(a == null) {
		a = 1;
	}
	this.a = a;
	this.b = b;
	this.c = c;
	this.d = d;
	this.tx = tx;
	this.ty = ty;
};
$hxClasses["lime.math.Matrix3"] = lime_math_Matrix3;
lime_math_Matrix3.__name__ = "lime.math.Matrix3";
lime_math_Matrix3.prototype = {
	a: null
	,b: null
	,c: null
	,d: null
	,tx: null
	,ty: null
	,clone: function() {
		return new lime_math_Matrix3(this.a,this.b,this.c,this.d,this.tx,this.ty);
	}
	,concat: function(m) {
		var a1 = this.a * m.a + this.b * m.c;
		this.b = this.a * m.b + this.b * m.d;
		this.a = a1;
		var c1 = this.c * m.a + this.d * m.c;
		this.d = this.c * m.b + this.d * m.d;
		this.c = c1;
		var tx1 = this.tx * m.a + this.ty * m.c + m.tx;
		this.ty = this.tx * m.b + this.ty * m.d + m.ty;
		this.tx = tx1;
	}
	,copyColumnFrom: function(column,vector4) {
		if(column > 2) {
			throw new js__$Boot_HaxeError("Column " + column + " out of bounds (2)");
		} else if(column == 0) {
			this.a = vector4.x;
			this.b = vector4.y;
		} else if(column == 1) {
			this.c = vector4.x;
			this.d = vector4.y;
		} else {
			this.tx = vector4.x;
			this.ty = vector4.y;
		}
	}
	,copyColumnTo: function(column,vector4) {
		if(column > 2) {
			throw new js__$Boot_HaxeError("Column " + column + " out of bounds (2)");
		} else if(column == 0) {
			vector4.x = this.a;
			vector4.y = this.b;
			vector4.z = 0;
		} else if(column == 1) {
			vector4.x = this.c;
			vector4.y = this.d;
			vector4.z = 0;
		} else {
			vector4.x = this.tx;
			vector4.y = this.ty;
			vector4.z = 1;
		}
	}
	,copyFrom: function(sourceMatrix3) {
		this.a = sourceMatrix3.a;
		this.b = sourceMatrix3.b;
		this.c = sourceMatrix3.c;
		this.d = sourceMatrix3.d;
		this.tx = sourceMatrix3.tx;
		this.ty = sourceMatrix3.ty;
	}
	,copyRowFrom: function(row,vector4) {
		if(row > 2) {
			throw new js__$Boot_HaxeError("Row " + row + " out of bounds (2)");
		} else if(row == 0) {
			this.a = vector4.x;
			this.c = vector4.y;
			this.tx = vector4.z;
		} else if(row == 1) {
			this.b = vector4.x;
			this.d = vector4.y;
			this.ty = vector4.z;
		}
	}
	,copyRowTo: function(row,vector4) {
		if(row > 2) {
			throw new js__$Boot_HaxeError("Row " + row + " out of bounds (2)");
		} else if(row == 0) {
			vector4.x = this.a;
			vector4.y = this.c;
			vector4.z = this.tx;
		} else if(row == 1) {
			vector4.x = this.b;
			vector4.y = this.d;
			vector4.z = this.ty;
		} else {
			vector4.x = 0;
			vector4.y = 0;
			vector4.z = 1;
		}
	}
	,createBox: function(scaleX,scaleY,rotation,tx,ty) {
		if(ty == null) {
			ty = 0;
		}
		if(tx == null) {
			tx = 0;
		}
		if(rotation == null) {
			rotation = 0;
		}
		if(rotation != 0) {
			var cos = Math.cos(rotation);
			var sin = Math.sin(rotation);
			this.a = cos * scaleX;
			this.b = sin * scaleY;
			this.c = -sin * scaleX;
			this.d = cos * scaleY;
		} else {
			this.a = scaleX;
			this.b = 0;
			this.c = 0;
			this.d = scaleY;
		}
		this.tx = tx;
		this.ty = ty;
	}
	,createGradientBox: function(width,height,rotation,tx,ty) {
		if(ty == null) {
			ty = 0;
		}
		if(tx == null) {
			tx = 0;
		}
		if(rotation == null) {
			rotation = 0;
		}
		this.a = width / 1638.4;
		this.d = height / 1638.4;
		if(rotation != 0) {
			var cos = Math.cos(rotation);
			var sin = Math.sin(rotation);
			this.b = sin * this.d;
			this.c = -sin * this.a;
			this.a *= cos;
			this.d *= cos;
		} else {
			this.b = 0;
			this.c = 0;
		}
		this.tx = tx + width / 2;
		this.ty = ty + height / 2;
	}
	,equals: function(matrix3) {
		if(matrix3 != null && this.tx == matrix3.tx && this.ty == matrix3.ty && this.a == matrix3.a && this.b == matrix3.b && this.c == matrix3.c) {
			return this.d == matrix3.d;
		} else {
			return false;
		}
	}
	,deltaTransformVector: function(Vector2,result) {
		if(result == null) {
			result = new lime_math_Vector2();
		}
		result.x = Vector2.x * this.a + Vector2.y * this.c;
		result.y = Vector2.x * this.b + Vector2.y * this.d;
		return result;
	}
	,identity: function() {
		this.a = 1;
		this.b = 0;
		this.c = 0;
		this.d = 1;
		this.tx = 0;
		this.ty = 0;
	}
	,invert: function() {
		var norm = this.a * this.d - this.b * this.c;
		if(norm == 0) {
			this.a = this.b = this.c = this.d = 0;
			this.tx = -this.tx;
			this.ty = -this.ty;
		} else {
			norm = 1.0 / norm;
			var a1 = this.d * norm;
			this.d = this.a * norm;
			this.a = a1;
			this.b *= -norm;
			this.c *= -norm;
			var tx1 = -this.a * this.tx - this.c * this.ty;
			this.ty = -this.b * this.tx - this.d * this.ty;
			this.tx = tx1;
		}
		return this;
	}
	,rotate: function(theta) {
		var cos = Math.cos(theta);
		var sin = Math.sin(theta);
		var a1 = this.a * cos - this.b * sin;
		this.b = this.a * sin + this.b * cos;
		this.a = a1;
		var c1 = this.c * cos - this.d * sin;
		this.d = this.c * sin + this.d * cos;
		this.c = c1;
		var tx1 = this.tx * cos - this.ty * sin;
		this.ty = this.tx * sin + this.ty * cos;
		this.tx = tx1;
	}
	,scale: function(sx,sy) {
		this.a *= sx;
		this.b *= sy;
		this.c *= sx;
		this.d *= sy;
		this.tx *= sx;
		this.ty *= sy;
	}
	,setRotation: function(theta,scale) {
		if(scale == null) {
			scale = 1;
		}
		this.a = Math.cos(theta) * scale;
		this.c = Math.sin(theta) * scale;
		this.b = -this.c;
		this.d = this.a;
	}
	,setTo: function(a,b,c,d,tx,ty) {
		this.a = a;
		this.b = b;
		this.c = c;
		this.d = d;
		this.tx = tx;
		this.ty = ty;
	}
	,to3DString: function(roundPixels) {
		if(roundPixels == null) {
			roundPixels = false;
		}
		if(roundPixels) {
			return "matrix3d(" + this.a + ", " + this.b + ", " + "0, 0, " + this.c + ", " + this.d + ", " + "0, 0, 0, 0, 1, 0, " + (this.tx | 0) + ", " + (this.ty | 0) + ", 0, 1)";
		} else {
			return "matrix3d(" + this.a + ", " + this.b + ", " + "0, 0, " + this.c + ", " + this.d + ", " + "0, 0, 0, 0, 1, 0, " + this.tx + ", " + this.ty + ", 0, 1)";
		}
	}
	,toString: function() {
		return "matrix(" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ", " + this.tx + ", " + this.ty + ")";
	}
	,transformRect: function(rect,result) {
		if(result == null) {
			result = new lime_math_Rectangle();
		}
		var tx0 = this.a * rect.x + this.c * rect.y;
		var tx1 = tx0;
		var ty0 = this.b * rect.x + this.d * rect.y;
		var ty1 = ty0;
		var tx = this.a * (rect.x + rect.width) + this.c * rect.y;
		var ty = this.b * (rect.x + rect.width) + this.d * rect.y;
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		tx = this.a * (rect.x + rect.width) + this.c * (rect.y + rect.height);
		ty = this.b * (rect.x + rect.width) + this.d * (rect.y + rect.height);
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		tx = this.a * rect.x + this.c * (rect.y + rect.height);
		ty = this.b * rect.x + this.d * (rect.y + rect.height);
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		result.setTo(tx0 + tx,ty0 + ty,tx1 - tx0,ty1 - ty0);
		return result;
	}
	,transformVector: function(pos,result) {
		if(result == null) {
			result = new lime_math_Vector2();
		}
		result.x = pos.x * this.a + pos.y * this.c + this.tx;
		result.y = pos.x * this.b + pos.y * this.d + this.ty;
		return result;
	}
	,translate: function(dx,dy) {
		this.tx += dx;
		this.ty += dy;
	}
	,__class__: lime_math_Matrix3
};
var openfl_geom_Matrix = function(a,b,c,d,tx,ty) {
	if(ty == null) {
		ty = 0;
	}
	if(tx == null) {
		tx = 0;
	}
	if(d == null) {
		d = 1;
	}
	if(c == null) {
		c = 0;
	}
	if(b == null) {
		b = 0;
	}
	if(a == null) {
		a = 1;
	}
	this.a = a;
	this.b = b;
	this.c = c;
	this.d = d;
	this.tx = tx;
	this.ty = ty;
};
$hxClasses["openfl.geom.Matrix"] = openfl_geom_Matrix;
openfl_geom_Matrix.__name__ = "openfl.geom.Matrix";
openfl_geom_Matrix.prototype = {
	a: null
	,b: null
	,c: null
	,d: null
	,tx: null
	,ty: null
	,__array: null
	,clone: function() {
		return new openfl_geom_Matrix(this.a,this.b,this.c,this.d,this.tx,this.ty);
	}
	,concat: function(m) {
		var a1 = this.a * m.a + this.b * m.c;
		this.b = this.a * m.b + this.b * m.d;
		this.a = a1;
		var c1 = this.c * m.a + this.d * m.c;
		this.d = this.c * m.b + this.d * m.d;
		this.c = c1;
		var tx1 = this.tx * m.a + this.ty * m.c + m.tx;
		this.ty = this.tx * m.b + this.ty * m.d + m.ty;
		this.tx = tx1;
	}
	,copyColumnFrom: function(column,vector3D) {
		if(column > 2) {
			throw new js__$Boot_HaxeError("Column " + column + " out of bounds (2)");
		} else if(column == 0) {
			this.a = vector3D.x;
			this.b = vector3D.y;
		} else if(column == 1) {
			this.c = vector3D.x;
			this.d = vector3D.y;
		} else {
			this.tx = vector3D.x;
			this.ty = vector3D.y;
		}
	}
	,copyColumnTo: function(column,vector3D) {
		if(column > 2) {
			throw new js__$Boot_HaxeError("Column " + column + " out of bounds (2)");
		} else if(column == 0) {
			vector3D.x = this.a;
			vector3D.y = this.b;
			vector3D.z = 0;
		} else if(column == 1) {
			vector3D.x = this.c;
			vector3D.y = this.d;
			vector3D.z = 0;
		} else {
			vector3D.x = this.tx;
			vector3D.y = this.ty;
			vector3D.z = 1;
		}
	}
	,copyFrom: function(sourceMatrix) {
		this.a = sourceMatrix.a;
		this.b = sourceMatrix.b;
		this.c = sourceMatrix.c;
		this.d = sourceMatrix.d;
		this.tx = sourceMatrix.tx;
		this.ty = sourceMatrix.ty;
	}
	,copyRowFrom: function(row,vector3D) {
		if(row > 2) {
			throw new js__$Boot_HaxeError("Row " + row + " out of bounds (2)");
		} else if(row == 0) {
			this.a = vector3D.x;
			this.c = vector3D.y;
			this.tx = vector3D.z;
		} else if(row == 1) {
			this.b = vector3D.x;
			this.d = vector3D.y;
			this.ty = vector3D.z;
		}
	}
	,copyRowTo: function(row,vector3D) {
		if(row > 2) {
			throw new js__$Boot_HaxeError("Row " + row + " out of bounds (2)");
		} else if(row == 0) {
			vector3D.x = this.a;
			vector3D.y = this.c;
			vector3D.z = this.tx;
		} else if(row == 1) {
			vector3D.x = this.b;
			vector3D.y = this.d;
			vector3D.z = this.ty;
		} else {
			vector3D.setTo(0,0,1);
		}
	}
	,createBox: function(scaleX,scaleY,rotation,tx,ty) {
		if(ty == null) {
			ty = 0;
		}
		if(tx == null) {
			tx = 0;
		}
		if(rotation == null) {
			rotation = 0;
		}
		if(rotation != 0) {
			var cos = Math.cos(rotation);
			var sin = Math.sin(rotation);
			this.a = cos * scaleX;
			this.b = sin * scaleY;
			this.c = -sin * scaleX;
			this.d = cos * scaleY;
		} else {
			this.a = scaleX;
			this.b = 0;
			this.c = 0;
			this.d = scaleY;
		}
		this.tx = tx;
		this.ty = ty;
	}
	,createGradientBox: function(width,height,rotation,tx,ty) {
		if(ty == null) {
			ty = 0;
		}
		if(tx == null) {
			tx = 0;
		}
		if(rotation == null) {
			rotation = 0;
		}
		this.a = width / 1638.4;
		this.d = height / 1638.4;
		if(rotation != 0) {
			var cos = Math.cos(rotation);
			var sin = Math.sin(rotation);
			this.b = sin * this.d;
			this.c = -sin * this.a;
			this.a *= cos;
			this.d *= cos;
		} else {
			this.b = 0;
			this.c = 0;
		}
		this.tx = tx + width / 2;
		this.ty = ty + height / 2;
	}
	,deltaTransformPoint: function(point) {
		return new openfl_geom_Point(point.x * this.a + point.y * this.c,point.x * this.b + point.y * this.d);
	}
	,equals: function(matrix) {
		if(matrix != null && this.tx == matrix.tx && this.ty == matrix.ty && this.a == matrix.a && this.b == matrix.b && this.c == matrix.c) {
			return this.d == matrix.d;
		} else {
			return false;
		}
	}
	,identity: function() {
		this.a = 1;
		this.b = 0;
		this.c = 0;
		this.d = 1;
		this.tx = 0;
		this.ty = 0;
	}
	,invert: function() {
		var norm = this.a * this.d - this.b * this.c;
		if(norm == 0) {
			this.a = this.b = this.c = this.d = 0;
			this.tx = -this.tx;
			this.ty = -this.ty;
		} else {
			norm = 1.0 / norm;
			var a1 = this.d * norm;
			this.d = this.a * norm;
			this.a = a1;
			this.b *= -norm;
			this.c *= -norm;
			var tx1 = -this.a * this.tx - this.c * this.ty;
			this.ty = -this.b * this.tx - this.d * this.ty;
			this.tx = tx1;
		}
		return this;
	}
	,rotate: function(theta) {
		var cos = Math.cos(theta);
		var sin = Math.sin(theta);
		var a1 = this.a * cos - this.b * sin;
		this.b = this.a * sin + this.b * cos;
		this.a = a1;
		var c1 = this.c * cos - this.d * sin;
		this.d = this.c * sin + this.d * cos;
		this.c = c1;
		var tx1 = this.tx * cos - this.ty * sin;
		this.ty = this.tx * sin + this.ty * cos;
		this.tx = tx1;
	}
	,scale: function(sx,sy) {
		this.a *= sx;
		this.b *= sy;
		this.c *= sx;
		this.d *= sy;
		this.tx *= sx;
		this.ty *= sy;
	}
	,setRotation: function(theta,scale) {
		if(scale == null) {
			scale = 1;
		}
		this.a = Math.cos(theta) * scale;
		this.c = Math.sin(theta) * scale;
		this.b = -this.c;
		this.d = this.a;
	}
	,setTo: function(a,b,c,d,tx,ty) {
		this.a = a;
		this.b = b;
		this.c = c;
		this.d = d;
		this.tx = tx;
		this.ty = ty;
	}
	,to3DString: function(roundPixels) {
		if(roundPixels == null) {
			roundPixels = false;
		}
		if(roundPixels) {
			return "matrix3d(" + this.a + ", " + this.b + ", 0, 0, " + this.c + ", " + this.d + ", 0, 0, 0, 0, 1, 0, " + (this.tx | 0) + ", " + (this.ty | 0) + ", 0, 1)";
		} else {
			return "matrix3d(" + this.a + ", " + this.b + ", 0, 0, " + this.c + ", " + this.d + ", 0, 0, 0, 0, 1, 0, " + this.tx + ", " + this.ty + ", 0, 1)";
		}
	}
	,toMozString: function() {
		return "matrix(" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ", " + this.tx + "px, " + this.ty + "px)";
	}
	,toString: function() {
		return "matrix(" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ", " + this.tx + ", " + this.ty + ")";
	}
	,transformPoint: function(pos) {
		return new openfl_geom_Point(pos.x * this.a + pos.y * this.c + this.tx,pos.x * this.b + pos.y * this.d + this.ty);
	}
	,translate: function(dx,dy) {
		this.tx += dx;
		this.ty += dy;
	}
	,toArray: function(transpose) {
		if(transpose == null) {
			transpose = false;
		}
		if(this.__array == null) {
			var array = null;
			var vector = null;
			var view = null;
			var buffer = null;
			var len = null;
			var this1 = new Float32Array(9);
			this.__array = this1;
		}
		if(transpose) {
			this.__array[0] = this.a;
			this.__array[1] = this.b;
			this.__array[2] = 0;
			this.__array[3] = this.c;
			this.__array[4] = this.d;
			this.__array[5] = 0;
			this.__array[6] = this.tx;
			this.__array[7] = this.ty;
			this.__array[8] = 1;
		} else {
			this.__array[0] = this.a;
			this.__array[1] = this.c;
			this.__array[2] = this.tx;
			this.__array[3] = this.b;
			this.__array[4] = this.d;
			this.__array[5] = this.ty;
			this.__array[6] = 0;
			this.__array[7] = 0;
			this.__array[8] = 1;
		}
		return this.__array;
	}
	,__cleanValues: function() {
		this.a = Math.round(this.a * 1000) / 1000;
		this.b = Math.round(this.b * 1000) / 1000;
		this.c = Math.round(this.c * 1000) / 1000;
		this.d = Math.round(this.d * 1000) / 1000;
		this.tx = Math.round(this.tx * 10) / 10;
		this.ty = Math.round(this.ty * 10) / 10;
	}
	,__toMatrix3: function() {
		openfl_geom_Matrix.__matrix3.setTo(this.a,this.b,this.c,this.d,this.tx,this.ty);
		return openfl_geom_Matrix.__matrix3;
	}
	,__transformInversePoint: function(point) {
		var norm = this.a * this.d - this.b * this.c;
		if(norm == 0) {
			point.x = -this.tx;
			point.y = -this.ty;
		} else {
			var px = 1.0 / norm * (this.c * (this.ty - point.y) + this.d * (point.x - this.tx));
			point.y = 1.0 / norm * (this.a * (point.y - this.ty) + this.b * (this.tx - point.x));
			point.x = px;
		}
	}
	,__transformInverseX: function(px,py) {
		var norm = this.a * this.d - this.b * this.c;
		if(norm == 0) {
			return -this.tx;
		} else {
			return 1.0 / norm * (this.c * (this.ty - py) + this.d * (px - this.tx));
		}
	}
	,__transformInverseY: function(px,py) {
		var norm = this.a * this.d - this.b * this.c;
		if(norm == 0) {
			return -this.ty;
		} else {
			return 1.0 / norm * (this.a * (py - this.ty) + this.b * (this.tx - px));
		}
	}
	,__transformPoint: function(point) {
		var px = point.x;
		var py = point.y;
		point.x = px * this.a + py * this.c + this.tx;
		point.y = px * this.b + py * this.d + this.ty;
	}
	,__transformX: function(px,py) {
		return px * this.a + py * this.c + this.tx;
	}
	,__transformY: function(px,py) {
		return px * this.b + py * this.d + this.ty;
	}
	,__translateTransformed: function(px,py) {
		this.tx = px * this.a + py * this.c + this.tx;
		this.ty = px * this.b + py * this.d + this.ty;
	}
	,__class__: openfl_geom_Matrix
};
var openfl_geom_ColorTransform = function(redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier,redOffset,greenOffset,blueOffset,alphaOffset) {
	if(alphaOffset == null) {
		alphaOffset = 0;
	}
	if(blueOffset == null) {
		blueOffset = 0;
	}
	if(greenOffset == null) {
		greenOffset = 0;
	}
	if(redOffset == null) {
		redOffset = 0;
	}
	if(alphaMultiplier == null) {
		alphaMultiplier = 1;
	}
	if(blueMultiplier == null) {
		blueMultiplier = 1;
	}
	if(greenMultiplier == null) {
		greenMultiplier = 1;
	}
	if(redMultiplier == null) {
		redMultiplier = 1;
	}
	this.redMultiplier = redMultiplier;
	this.greenMultiplier = greenMultiplier;
	this.blueMultiplier = blueMultiplier;
	this.alphaMultiplier = alphaMultiplier;
	this.redOffset = redOffset;
	this.greenOffset = greenOffset;
	this.blueOffset = blueOffset;
	this.alphaOffset = alphaOffset;
};
$hxClasses["openfl.geom.ColorTransform"] = openfl_geom_ColorTransform;
openfl_geom_ColorTransform.__name__ = "openfl.geom.ColorTransform";
openfl_geom_ColorTransform.prototype = {
	alphaMultiplier: null
	,alphaOffset: null
	,blueMultiplier: null
	,blueOffset: null
	,greenMultiplier: null
	,greenOffset: null
	,redMultiplier: null
	,redOffset: null
	,concat: function(second) {
		this.redOffset = second.redOffset * this.redMultiplier + this.redOffset;
		this.greenOffset = second.greenOffset * this.greenMultiplier + this.greenOffset;
		this.blueOffset = second.blueOffset * this.blueMultiplier + this.blueOffset;
		this.alphaOffset = second.alphaOffset * this.alphaMultiplier + this.alphaOffset;
		this.redMultiplier *= second.redMultiplier;
		this.greenMultiplier *= second.greenMultiplier;
		this.blueMultiplier *= second.blueMultiplier;
		this.alphaMultiplier *= second.alphaMultiplier;
	}
	,toString: function() {
		return "(redMultiplier=" + this.redMultiplier + ", greenMultiplier=" + this.greenMultiplier + ", blueMultiplier=" + this.blueMultiplier + ", alphaMultiplier=" + this.alphaMultiplier + ", redOffset=" + this.redOffset + ", greenOffset=" + this.greenOffset + ", blueOffset=" + this.blueOffset + ", alphaOffset=" + this.alphaOffset + ")";
	}
	,__clone: function() {
		return new openfl_geom_ColorTransform(this.redMultiplier,this.greenMultiplier,this.blueMultiplier,this.alphaMultiplier,this.redOffset,this.greenOffset,this.blueOffset,this.alphaOffset);
	}
	,__copyFrom: function(ct) {
		this.redMultiplier = ct.redMultiplier;
		this.greenMultiplier = ct.greenMultiplier;
		this.blueMultiplier = ct.blueMultiplier;
		this.alphaMultiplier = ct.alphaMultiplier;
		this.redOffset = ct.redOffset;
		this.greenOffset = ct.greenOffset;
		this.blueOffset = ct.blueOffset;
		this.alphaOffset = ct.alphaOffset;
	}
	,__combine: function(ct) {
		this.redMultiplier *= ct.redMultiplier;
		this.greenMultiplier *= ct.greenMultiplier;
		this.blueMultiplier *= ct.blueMultiplier;
		this.alphaMultiplier *= ct.alphaMultiplier;
		this.redOffset += ct.redOffset;
		this.greenOffset += ct.greenOffset;
		this.blueOffset += ct.blueOffset;
		this.alphaOffset += ct.alphaOffset;
	}
	,__identity: function() {
		this.redMultiplier = 1;
		this.greenMultiplier = 1;
		this.blueMultiplier = 1;
		this.alphaMultiplier = 1;
		this.redOffset = 0;
		this.greenOffset = 0;
		this.blueOffset = 0;
		this.alphaOffset = 0;
	}
	,__invert: function() {
		this.redMultiplier = this.redMultiplier != 0 ? 1 / this.redMultiplier : 1;
		this.greenMultiplier = this.greenMultiplier != 0 ? 1 / this.greenMultiplier : 1;
		this.blueMultiplier = this.blueMultiplier != 0 ? 1 / this.blueMultiplier : 1;
		this.alphaMultiplier = this.alphaMultiplier != 0 ? 1 / this.alphaMultiplier : 1;
		this.redOffset = -this.redOffset;
		this.greenOffset = -this.greenOffset;
		this.blueOffset = -this.blueOffset;
		this.alphaOffset = -this.alphaOffset;
	}
	,__equals: function(ct,ignoreAlphaMultiplier) {
		if(ct != null && this.redMultiplier == ct.redMultiplier && this.greenMultiplier == ct.greenMultiplier && this.blueMultiplier == ct.blueMultiplier && (ignoreAlphaMultiplier || this.alphaMultiplier == ct.alphaMultiplier) && this.redOffset == ct.redOffset && this.greenOffset == ct.greenOffset && this.blueOffset == ct.blueOffset) {
			return this.alphaOffset == ct.alphaOffset;
		} else {
			return false;
		}
	}
	,__isDefault: function(ignoreAlphaMultiplier) {
		if(ignoreAlphaMultiplier) {
			if(this.redMultiplier == 1 && this.greenMultiplier == 1 && this.blueMultiplier == 1 && this.redOffset == 0 && this.greenOffset == 0 && this.blueOffset == 0) {
				return this.alphaOffset == 0;
			} else {
				return false;
			}
		} else if(this.redMultiplier == 1 && this.greenMultiplier == 1 && this.blueMultiplier == 1 && this.alphaMultiplier == 1 && this.redOffset == 0 && this.greenOffset == 0 && this.blueOffset == 0) {
			return this.alphaOffset == 0;
		} else {
			return false;
		}
	}
	,__setArrays: function(colorMultipliers,colorOffsets) {
		colorMultipliers[0] = this.redMultiplier;
		colorMultipliers[1] = this.greenMultiplier;
		colorMultipliers[2] = this.blueMultiplier;
		colorMultipliers[3] = this.alphaMultiplier;
		colorOffsets[0] = this.redOffset;
		colorOffsets[1] = this.greenOffset;
		colorOffsets[2] = this.blueOffset;
		colorOffsets[3] = this.alphaOffset;
	}
	,get_color: function() {
		return (this.redOffset | 0) << 16 | (this.greenOffset | 0) << 8 | (this.blueOffset | 0);
	}
	,set_color: function(value) {
		this.redOffset = value >> 16 & 255;
		this.greenOffset = value >> 8 & 255;
		this.blueOffset = value & 255;
		this.redMultiplier = 0;
		this.greenMultiplier = 0;
		this.blueMultiplier = 0;
		return this.get_color();
	}
	,__toLimeColorMatrix: function() {
		if(openfl_geom_ColorTransform.__limeColorMatrix == null) {
			var array = null;
			var vector = null;
			var view = null;
			var buffer = null;
			var len = null;
			var this1 = new Float32Array(20);
			openfl_geom_ColorTransform.__limeColorMatrix = this1;
		}
		openfl_geom_ColorTransform.__limeColorMatrix[0] = this.redMultiplier;
		openfl_geom_ColorTransform.__limeColorMatrix[4] = this.redOffset / 255;
		openfl_geom_ColorTransform.__limeColorMatrix[6] = this.greenMultiplier;
		openfl_geom_ColorTransform.__limeColorMatrix[9] = this.greenOffset / 255;
		openfl_geom_ColorTransform.__limeColorMatrix[12] = this.blueMultiplier;
		openfl_geom_ColorTransform.__limeColorMatrix[14] = this.blueOffset / 255;
		openfl_geom_ColorTransform.__limeColorMatrix[18] = this.alphaMultiplier;
		openfl_geom_ColorTransform.__limeColorMatrix[19] = this.alphaOffset / 255;
		return openfl_geom_ColorTransform.__limeColorMatrix;
	}
	,__class__: openfl_geom_ColorTransform
	,__properties__: {set_color:"set_color",get_color:"get_color"}
};
var away3d_core_managers_Stage3DProxy = function(stage3DIndex,stage3D,stage3DManager,forceSoftware,profile) {
	if(profile == null) {
		profile = "baseline";
	}
	if(forceSoftware == null) {
		forceSoftware = false;
	}
	this._backBufferEnableDepthAndStencil = true;
	this._stage3DIndex = -1;
	away3d_core_managers_Stage3DProxy.vertexBufferCount = away3d_core_managers_Stage3DProxy.indexBufferCount = away3d_core_managers_Stage3DProxy.drawTriangleCount = 0;
	this._stage3DIndex = stage3DIndex;
	this._stage3D = stage3D;
	this._stage3D.set_x(0);
	this._stage3D.set_y(0);
	this._stage3D.visible = true;
	this._stage3DManager = stage3DManager;
	this._viewPort = new openfl_geom_Rectangle();
	this._enableDepthAndStencil = true;
	openfl_events_EventDispatcher.call(this);
	this._stage3D.addEventListener("context3DCreate",$bind(this,this.onContext3DUpdate),false,1000,false);
	this.forceSoftware = forceSoftware;
	this._profile = profile;
	if(this._stage3D.context3D != null) {
		this.onContext3DUpdate(null);
	} else {
		this.requestContext(forceSoftware,this._profile);
	}
};
$hxClasses["away3d.core.managers.Stage3DProxy"] = away3d_core_managers_Stage3DProxy;
away3d_core_managers_Stage3DProxy.__name__ = "away3d.core.managers.Stage3DProxy";
away3d_core_managers_Stage3DProxy.disposeVertexBuffer = function(vb) {
	vb.dispose();
	away3d_core_managers_Stage3DProxy.vertexBufferCount--;
};
away3d_core_managers_Stage3DProxy.disposeIndexBuffer = function(ib) {
	ib.dispose();
	away3d_core_managers_Stage3DProxy.indexBufferCount--;
};
away3d_core_managers_Stage3DProxy.uploadVertexBufferFromVector = function(vb,data,startVertex,numVertices) {
	vb.uploadFromVector(data,startVertex,numVertices);
	away3d_core_managers_Stage3DProxy._vbUploadCount++;
};
away3d_core_managers_Stage3DProxy.uploadIndexBufferFromVector = function(ib,data,startOffset,count) {
	ib.uploadFromVector(data,startOffset,count);
	away3d_core_managers_Stage3DProxy._ibUploadCount++;
};
away3d_core_managers_Stage3DProxy.__super__ = openfl_events_EventDispatcher;
away3d_core_managers_Stage3DProxy.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	_context3D: null
	,_stage3DIndex: null
	,_usesSoftwareRendering: null
	,_profile: null
	,_stage3D: null
	,_activeProgram3D: null
	,_stage3DManager: null
	,_backBufferWidth: null
	,_backBufferHeight: null
	,_antiAlias: null
	,_enableDepthAndStencil: null
	,_backBufferEnableDepthAndStencil: null
	,_contextRequested: null
	,_renderTarget: null
	,_renderSurfaceSelector: null
	,_scissorRect: null
	,_color: null
	,_backBufferDirty: null
	,_viewPort: null
	,_enterFrame: null
	,_exitFrame: null
	,_viewportUpdated: null
	,_viewportDirty: null
	,_bufferClear: null
	,_mouse3DManager: null
	,_touch3DManager: null
	,notifyViewportUpdated: function() {
		if(this._viewportDirty) {
			return;
		}
		this._viewportDirty = true;
		if(!this.hasEventListener("ViewportUpdated")) {
			return;
		}
		this._viewportUpdated = new away3d_events_Stage3DEvent("ViewportUpdated");
		this.dispatchEvent(this._viewportUpdated);
	}
	,notifyEnterFrame: function() {
		if(!this.hasEventListener("enterFrame")) {
			return;
		}
		if(this._enterFrame == null) {
			this._enterFrame = new openfl_events_Event("enterFrame");
		}
		this.dispatchEvent(this._enterFrame);
	}
	,notifyExitFrame: function() {
		if(!this.hasEventListener("exitFrame")) {
			return;
		}
		if(this._exitFrame == null) {
			this._exitFrame = new openfl_events_Event("exitFrame");
		}
		this.dispatchEvent(this._exitFrame);
	}
	,forceSoftware: null
	,get_profile: function() {
		return this._profile;
	}
	,dispose: function() {
		this._stage3DManager.removeStage3DProxy(this);
		this._stage3D.removeEventListener("context3DCreate",$bind(this,this.onContext3DUpdate));
		this.freeContext3D();
		this._stage3D = null;
		this._stage3DManager = null;
		this._stage3DIndex = -1;
	}
	,configureBackBuffer: function(backBufferWidth,backBufferHeight,antiAlias,enableDepthAndStencil) {
		if(backBufferWidth < 50) {
			backBufferWidth = 50;
		}
		if(backBufferHeight < 50) {
			backBufferHeight = 50;
		}
		var oldWidth = this._backBufferWidth;
		var oldHeight = this._backBufferHeight;
		this._backBufferWidth = backBufferWidth;
		this._backBufferHeight = backBufferHeight;
		this._viewPort.width = backBufferWidth;
		this._viewPort.height = backBufferHeight;
		if(oldWidth != this._backBufferWidth || oldHeight != this._backBufferHeight) {
			this.notifyViewportUpdated();
		}
		this._antiAlias = antiAlias;
		this._enableDepthAndStencil = enableDepthAndStencil;
		if(this._context3D != null) {
			this._context3D.configureBackBuffer(backBufferWidth,backBufferHeight,antiAlias,enableDepthAndStencil);
		}
	}
	,get_enableDepthAndStencil: function() {
		return this._enableDepthAndStencil;
	}
	,set_enableDepthAndStencil: function(enableDepthAndStencil) {
		this._enableDepthAndStencil = enableDepthAndStencil;
		this._backBufferDirty = true;
		return enableDepthAndStencil;
	}
	,get_renderTarget: function() {
		return this._renderTarget;
	}
	,get_renderSurfaceSelector: function() {
		return this._renderSurfaceSelector;
	}
	,setRenderTarget: function(target,enableDepthAndStencil,surfaceSelector) {
		if(surfaceSelector == null) {
			surfaceSelector = 0;
		}
		if(enableDepthAndStencil == null) {
			enableDepthAndStencil = false;
		}
		if(this._renderTarget == target && surfaceSelector == this._renderSurfaceSelector && this._enableDepthAndStencil == enableDepthAndStencil) {
			return;
		}
		this._renderTarget = target;
		this._renderSurfaceSelector = surfaceSelector;
		this._enableDepthAndStencil = enableDepthAndStencil;
		if(target != null) {
			this._context3D.setRenderToTexture(target,enableDepthAndStencil,this._antiAlias,surfaceSelector);
		} else {
			this._context3D.setRenderToBackBuffer();
		}
	}
	,clear: function() {
		if(this._context3D == null) {
			return;
		}
		if(this._backBufferDirty) {
			this.configureBackBuffer(this._backBufferWidth,this._backBufferHeight,this._antiAlias,this._enableDepthAndStencil);
			this._backBufferDirty = false;
		}
		this._context3D.clear((this._color >> 16 & 255) / 255.0,(this._color >> 8 & 255) / 255.0,(this._color & 255) / 255.0,(this._color >> 24 & 255) / 255.0);
		this._bufferClear = true;
	}
	,present: function() {
		if(this._context3D == null) {
			return;
		}
		this._context3D.present();
		this._activeProgram3D = null;
		if(this._mouse3DManager != null) {
			this._mouse3DManager.fireMouseEvents();
		}
	}
	,addEventListener: function(type,listener,useCapture,priority,useWeakReference) {
		if(useWeakReference == null) {
			useWeakReference = false;
		}
		if(priority == null) {
			priority = 0;
		}
		if(useCapture == null) {
			useCapture = false;
		}
		openfl_events_EventDispatcher.prototype.addEventListener.call(this,type,listener,useCapture,priority,useWeakReference);
		if((type == "enterFrame" || type == "exitFrame") && !away3d_core_managers_Stage3DProxy._frameEventDriver.hasEventListener("enterFrame")) {
			away3d_core_managers_Stage3DProxy._frameEventDriver.addEventListener("enterFrame",$bind(this,this.onEnterFrame),useCapture,priority,useWeakReference);
		}
	}
	,removeEventListener: function(type,listener,useCapture) {
		if(useCapture == null) {
			useCapture = false;
		}
		openfl_events_EventDispatcher.prototype.removeEventListener.call(this,type,listener,useCapture);
		if(!this.hasEventListener("enterFrame") && !this.hasEventListener("exitFrame") && away3d_core_managers_Stage3DProxy._frameEventDriver.hasEventListener("enterFrame")) {
			away3d_core_managers_Stage3DProxy._frameEventDriver.removeEventListener("enterFrame",$bind(this,this.onEnterFrame),useCapture);
		}
	}
	,get_scissorRect: function() {
		return this._scissorRect;
	}
	,set_scissorRect: function(value) {
		this._scissorRect = value;
		this._context3D.setScissorRectangle(this._scissorRect);
		return value;
	}
	,get_stage3DIndex: function() {
		return this._stage3DIndex;
	}
	,get_stage3D: function() {
		return this._stage3D;
	}
	,get_context3D: function() {
		return this._context3D;
	}
	,get_driverInfo: function() {
		if(this._context3D != null) {
			return this._context3D.driverInfo;
		} else {
			return null;
		}
	}
	,get_usesSoftwareRendering: function() {
		return this._usesSoftwareRendering;
	}
	,get_x: function() {
		return this._stage3D.get_x();
	}
	,set_x: function(value) {
		if(this._viewPort.x == value) {
			return value;
		}
		this._stage3D.set_x(this._viewPort.x = value);
		this.notifyViewportUpdated();
		return value;
	}
	,get_y: function() {
		return this._stage3D.get_y();
	}
	,set_y: function(value) {
		if(this._viewPort.y == value) {
			return value;
		}
		this._stage3D.set_y(this._viewPort.y = value);
		this.notifyViewportUpdated();
		return value;
	}
	,get_width: function() {
		return this._backBufferWidth;
	}
	,set_width: function(width) {
		if(this._viewPort.width == width) {
			return width;
		}
		if(width < 50) {
			width = 50;
		}
		this._viewPort.width = this._backBufferWidth = width;
		this._backBufferDirty = true;
		this.notifyViewportUpdated();
		return width;
	}
	,get_height: function() {
		return this._backBufferHeight;
	}
	,set_height: function(height) {
		if(this._viewPort.height == height) {
			return height;
		}
		if(height < 50) {
			height = 50;
		}
		this._viewPort.height = this._backBufferHeight = height;
		this._backBufferDirty = true;
		this.notifyViewportUpdated();
		return height;
	}
	,get_antiAlias: function() {
		return this._antiAlias;
	}
	,set_antiAlias: function(antiAlias) {
		this._antiAlias = antiAlias;
		this._backBufferDirty = true;
		return antiAlias;
	}
	,get_viewPort: function() {
		this._viewportDirty = false;
		return this._viewPort;
	}
	,get_color: function() {
		return this._color;
	}
	,set_color: function(color) {
		this._color = color;
		return color;
	}
	,get_visible: function() {
		return this._stage3D.visible;
	}
	,set_visible: function(value) {
		this._stage3D.visible = value;
		return value;
	}
	,get_bufferClear: function() {
		return this._bufferClear;
	}
	,set_bufferClear: function(newBufferClear) {
		this._bufferClear = newBufferClear;
		return newBufferClear;
	}
	,get_mouse3DManager: function() {
		return this._mouse3DManager;
	}
	,set_mouse3DManager: function(value) {
		this._mouse3DManager = value;
		return value;
	}
	,get_touch3DManager: function() {
		return this._touch3DManager;
	}
	,set_touch3DManager: function(value) {
		this._touch3DManager = value;
		return value;
	}
	,freeContext3D: function() {
		if(this._context3D != null) {
			this._context3D.dispose();
			this.dispatchEvent(new away3d_events_Stage3DEvent("Context3DDisposed"));
		}
		this._context3D = null;
	}
	,onContext3DUpdate: function(event) {
		if(this._stage3D.context3D != null) {
			var hadContext = this._context3D != null;
			this._context3D = this._stage3D.context3D;
			this._context3D.set_enableErrorChecking(away3d_debug_Debug.active);
			this._usesSoftwareRendering = this._context3D.driverInfo.indexOf("Software") == 0;
			if(this._backBufferWidth > 0 && this._backBufferHeight > 0) {
				this._context3D.configureBackBuffer(this._backBufferWidth,this._backBufferHeight,this._antiAlias,this._enableDepthAndStencil);
			}
			this.dispatchEvent(new away3d_events_Stage3DEvent(hadContext ? "Context3DRecreated" : "Context3DCreated"));
		} else {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Rendering context lost!"));
		}
	}
	,requestContext: function(forceSoftware,profile) {
		if(profile == null) {
			profile = "baseline";
		}
		if(forceSoftware == null) {
			forceSoftware = false;
		}
		if(!this._usesSoftwareRendering) {
			this._usesSoftwareRendering = forceSoftware;
		}
		this._profile = profile;
		var renderMode = forceSoftware ? 1 : 0;
		if(profile == "baseline") {
			this._stage3D.requestContext3D(renderMode);
		} else {
			try {
				this._stage3D.requestContext3D(renderMode,openfl_display3D__$Context3DProfile_Context3DProfile_$Impl_$.fromString(profile));
			} catch( error ) {
				haxe_CallStack.lastException = error;
				var error1 = ((error) instanceof js__$Boot_HaxeError) ? error.val : error;
				throw new js__$Boot_HaxeError("An error occurred creating a context using the given profile. Profiles are not supported for the SDK this was compiled with.");
			}
		}
		this._contextRequested = true;
	}
	,onEnterFrame: function(event) {
		if(this._context3D == null) {
			return;
		}
		this.clear();
		this.notifyEnterFrame();
		this.present();
		this.notifyExitFrame();
	}
	,recoverFromDisposal: function() {
		if(this._context3D == null) {
			return false;
		}
		if(this._context3D.driverInfo == "Disposed") {
			this._context3D = null;
			this.dispatchEvent(new away3d_events_Stage3DEvent("Context3DDisposed"));
			return false;
		}
		return true;
	}
	,clearDepthBuffer: function() {
		if(this._context3D == null) {
			return;
		}
		this._context3D.clear(0,0,0,1,1,0,2);
	}
	,createVertexBuffer: function(numVertices,data32PerVertex) {
		away3d_core_managers_Stage3DProxy.vertexBufferCount++;
		return this._context3D.createVertexBuffer(numVertices,data32PerVertex);
	}
	,createIndexBuffer: function(numIndices) {
		away3d_core_managers_Stage3DProxy.indexBufferCount++;
		return this._context3D.createIndexBuffer(numIndices);
	}
	,drawTriangles: function(indexBuffer,firstIndex,numTriangles) {
		if(numTriangles == null) {
			numTriangles = -1;
		}
		if(firstIndex == null) {
			firstIndex = 0;
		}
		away3d_core_managers_Stage3DProxy.drawTriangleCount++;
		this._context3D.drawTriangles(indexBuffer,firstIndex,numTriangles);
	}
	,__class__: away3d_core_managers_Stage3DProxy
	,__properties__: {set_touch3DManager:"set_touch3DManager",get_touch3DManager:"get_touch3DManager",set_mouse3DManager:"set_mouse3DManager",get_mouse3DManager:"get_mouse3DManager",set_bufferClear:"set_bufferClear",get_bufferClear:"get_bufferClear",set_visible:"set_visible",get_visible:"get_visible",set_color:"set_color",get_color:"get_color",get_viewPort:"get_viewPort",set_antiAlias:"set_antiAlias",get_antiAlias:"get_antiAlias",set_height:"set_height",get_height:"get_height",set_width:"set_width",get_width:"get_width",set_y:"set_y",get_y:"get_y",set_x:"set_x",get_x:"get_x",get_usesSoftwareRendering:"get_usesSoftwareRendering",get_driverInfo:"get_driverInfo",get_context3D:"get_context3D",get_stage3D:"get_stage3D",get_stage3DIndex:"get_stage3DIndex",set_scissorRect:"set_scissorRect",get_scissorRect:"get_scissorRect",get_renderSurfaceSelector:"get_renderSurfaceSelector",get_renderTarget:"get_renderTarget",set_enableDepthAndStencil:"set_enableDepthAndStencil",get_enableDepthAndStencil:"get_enableDepthAndStencil",get_profile:"get_profile"}
});
var away3d_core_managers_Touch3DManager = function() {
	this._touchPicker = away3d_core_pick_PickingType.RAYCAST_FIRST_ENCOUNTERED;
	this._touchMoveEvent = new openfl_events_TouchEvent("touchMove");
	this._nullVector = new openfl_geom_Vector3D();
	this._updateDirty = true;
	this._touchPoints = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this._touchPointFromId = new haxe_ds_IntMap();
	away3d_core_managers_Touch3DManager._collidingObjectFromTouchId = new haxe_ds_IntMap();
	away3d_core_managers_Touch3DManager._previousCollidingObjectFromTouchId = new haxe_ds_IntMap();
};
$hxClasses["away3d.core.managers.Touch3DManager"] = away3d_core_managers_Touch3DManager;
away3d_core_managers_Touch3DManager.__name__ = "away3d.core.managers.Touch3DManager";
away3d_core_managers_Touch3DManager.prototype = {
	_updateDirty: null
	,_nullVector: null
	,_numTouchPoints: null
	,_touchPoint: null
	,_collidingObject: null
	,_previousCollidingObject: null
	,_touchPoints: null
	,_touchPointFromId: null
	,_touchMoveEvent: null
	,_forceTouchMove: null
	,_touchPicker: null
	,_view: null
	,updateCollider: function() {
		if(this._forceTouchMove || this._updateDirty) {
			var _g = 0;
			var _g1 = this._numTouchPoints;
			while(_g < _g1) {
				var i = _g++;
				this._touchPoint = this._touchPoints.get(i);
				this._collidingObject = this._touchPicker.getViewCollision(this._touchPoint.x,this._touchPoint.y,this._view);
				var v = this._collidingObject;
				away3d_core_managers_Touch3DManager._collidingObjectFromTouchId.h[this._touchPoint.id] = v;
			}
		}
	}
	,fireTouchEvents: function() {
		var i;
		var event;
		var dispatcher;
		var _g = 0;
		var _g1 = this._numTouchPoints;
		while(_g < _g1) {
			var i1 = _g++;
			this._touchPoint = this._touchPoints.get(i1);
			this._collidingObject = away3d_core_managers_Touch3DManager._collidingObjectFromTouchId.h[this._touchPoint.id];
			this._previousCollidingObject = away3d_core_managers_Touch3DManager._previousCollidingObjectFromTouchId.h[this._touchPoint.id];
			if(this._collidingObject != this._previousCollidingObject) {
				if(this._previousCollidingObject != null) {
					this.queueDispatch("touchOut3d",this._touchMoveEvent,this._previousCollidingObject,this._touchPoint);
				}
				if(this._collidingObject != null) {
					this.queueDispatch("touchOver3d",this._touchMoveEvent,this._collidingObject,this._touchPoint);
				}
			}
			if(this._forceTouchMove && this._collidingObject != null) {
				this.queueDispatch("touchMove3d",this._touchMoveEvent,this._collidingObject,this._touchPoint);
			}
		}
		var len = away3d_core_managers_Touch3DManager._queuedEvents.get_length();
		var _g2 = 0;
		var _g3 = len;
		while(_g2 < _g3) {
			var i2 = _g2++;
			event = away3d_core_managers_Touch3DManager._queuedEvents.get(i2);
			dispatcher = event.object;
			while(dispatcher != null && !dispatcher._ancestorsAllowMouseEnabled) dispatcher = dispatcher.get_parent();
			if(dispatcher != null) {
				dispatcher.dispatchEvent(event);
			}
		}
		away3d_core_managers_Touch3DManager._queuedEvents.set_length(0);
		this._updateDirty = false;
		var _g4 = 0;
		var _g5 = this._numTouchPoints;
		while(_g4 < _g5) {
			var i3 = _g4++;
			this._touchPoint = this._touchPoints.get(i3);
			var v = away3d_core_managers_Touch3DManager._collidingObjectFromTouchId.h[this._touchPoint.id];
			away3d_core_managers_Touch3DManager._previousCollidingObjectFromTouchId.h[this._touchPoint.id] = v;
		}
	}
	,enableTouchListeners: function(view) {
		view.addEventListener("touchBegin",$bind(this,this.onTouchBegin));
		view.addEventListener("touchMove",$bind(this,this.onTouchMove));
		view.addEventListener("touchEnd",$bind(this,this.onTouchEnd));
	}
	,disableTouchListeners: function(view) {
		view.removeEventListener("touchBegin",$bind(this,this.onTouchBegin));
		view.removeEventListener("touchMove",$bind(this,this.onTouchMove));
		view.removeEventListener("touchEnd",$bind(this,this.onTouchEnd));
	}
	,dispose: function() {
		this._touchPicker.dispose();
		this._touchPoints = null;
		this._touchPointFromId = null;
		away3d_core_managers_Touch3DManager._collidingObjectFromTouchId = null;
		away3d_core_managers_Touch3DManager._previousCollidingObjectFromTouchId = null;
	}
	,queueDispatch: function(emitType,sourceEvent,collider,touch) {
		var event = new away3d_events_TouchEvent3D(emitType);
		event.ctrlKey = sourceEvent.ctrlKey;
		event.altKey = sourceEvent.altKey;
		event.shiftKey = sourceEvent.shiftKey;
		event.screenX = touch.x;
		event.screenY = touch.y;
		event.touchPointID = touch.id;
		if(collider != null) {
			event.object = collider.entity;
			event.renderable = collider.renderable;
			event.uv = collider.uv;
			event.localPosition = collider.localPosition != null ? collider.localPosition.clone() : null;
			event.localNormal = collider.localNormal != null ? collider.localNormal.clone() : null;
			event.index = collider.index;
			event.subGeometryIndex = collider.subGeometryIndex;
		} else {
			event.uv = null;
			event.object = null;
			event.localPosition = this._nullVector;
			event.localNormal = this._nullVector;
			event.index = 0;
			event.subGeometryIndex = 0;
		}
		away3d_core_managers_Touch3DManager._queuedEvents.push(event);
	}
	,onTouchBegin: function(event) {
		var touch = new away3d_core_managers_TouchPoint();
		touch.id = event.touchPointID;
		touch.x = event.stageX;
		touch.y = event.stageY;
		this._numTouchPoints++;
		this._touchPoints.push(touch);
		this._touchPointFromId.h[touch.id] = touch;
		this.updateCollider();
		this._collidingObject = away3d_core_managers_Touch3DManager._collidingObjectFromTouchId.h[touch.id];
		if(this._collidingObject != null) {
			this.queueDispatch("touchBegin3d",event,this._collidingObject,touch);
		}
		this._updateDirty = true;
	}
	,onTouchMove: function(event) {
		var touch = this._touchPointFromId.h[event.touchPointID];
		if(touch == null) {
			return;
		}
		touch.x = event.stageX;
		touch.y = event.stageY;
		this._collidingObject = away3d_core_managers_Touch3DManager._collidingObjectFromTouchId.h[touch.id];
		if(this._collidingObject != null) {
			this.queueDispatch("touchMove3d",this._touchMoveEvent = event,this._collidingObject,touch);
		}
		this._updateDirty = true;
	}
	,onTouchEnd: function(event) {
		var touch = this._touchPointFromId.h[event.touchPointID];
		if(touch == null) {
			return;
		}
		this._collidingObject = away3d_core_managers_Touch3DManager._collidingObjectFromTouchId.h[touch.id];
		if(this._collidingObject != null) {
			this.queueDispatch("touchEnd3d",event,this._collidingObject,touch);
		}
		this._touchPointFromId.remove(touch.id);
		this._numTouchPoints--;
		this._touchPoints.splice(this._touchPoints.indexOf(touch,0),1);
		this._updateDirty = true;
	}
	,get_forceTouchMove: function() {
		return this._forceTouchMove;
	}
	,set_forceTouchMove: function(value) {
		this._forceTouchMove = value;
		return value;
	}
	,get_touchPicker: function() {
		return this._touchPicker;
	}
	,set_touchPicker: function(value) {
		this._touchPicker = value;
		return value;
	}
	,set_view: function(value) {
		this._view = value;
		return value;
	}
	,__class__: away3d_core_managers_Touch3DManager
	,__properties__: {set_view:"set_view",set_touchPicker:"set_touchPicker",get_touchPicker:"get_touchPicker",set_forceTouchMove:"set_forceTouchMove",get_forceTouchMove:"get_forceTouchMove"}
};
var away3d_core_managers_TouchPoint = function() {
};
$hxClasses["away3d.core.managers.TouchPoint"] = away3d_core_managers_TouchPoint;
away3d_core_managers_TouchPoint.__name__ = "away3d.core.managers.TouchPoint";
away3d_core_managers_TouchPoint.prototype = {
	id: null
	,x: null
	,y: null
	,__class__: away3d_core_managers_TouchPoint
};
var away3d_core_math_MathConsts = function() { };
$hxClasses["away3d.core.math.MathConsts"] = away3d_core_math_MathConsts;
away3d_core_math_MathConsts.__name__ = "away3d.core.math.MathConsts";
var openfl_geom_Vector3D = function(x,y,z,w) {
	if(w == null) {
		w = 0;
	}
	if(z == null) {
		z = 0;
	}
	if(y == null) {
		y = 0;
	}
	if(x == null) {
		x = 0;
	}
	this.w = w;
	this.x = x;
	this.y = y;
	this.z = z;
};
$hxClasses["openfl.geom.Vector3D"] = openfl_geom_Vector3D;
openfl_geom_Vector3D.__name__ = "openfl.geom.Vector3D";
openfl_geom_Vector3D.__properties__ = {get_Z_AXIS:"get_Z_AXIS",get_Y_AXIS:"get_Y_AXIS",get_X_AXIS:"get_X_AXIS"};
openfl_geom_Vector3D.angleBetween = function(a,b) {
	var la = a.get_length();
	var lb = b.get_length();
	var dot = a.dotProduct(b);
	if(la != 0) {
		dot /= la;
	}
	if(lb != 0) {
		dot /= lb;
	}
	return Math.acos(dot);
};
openfl_geom_Vector3D.distance = function(pt1,pt2) {
	var x = pt2.x - pt1.x;
	var y = pt2.y - pt1.y;
	var z = pt2.z - pt1.z;
	return Math.sqrt(x * x + y * y + z * z);
};
openfl_geom_Vector3D.get_X_AXIS = function() {
	return new openfl_geom_Vector3D(1,0,0);
};
openfl_geom_Vector3D.get_Y_AXIS = function() {
	return new openfl_geom_Vector3D(0,1,0);
};
openfl_geom_Vector3D.get_Z_AXIS = function() {
	return new openfl_geom_Vector3D(0,0,1);
};
openfl_geom_Vector3D.prototype = {
	w: null
	,x: null
	,y: null
	,z: null
	,add: function(a) {
		return new openfl_geom_Vector3D(this.x + a.x,this.y + a.y,this.z + a.z);
	}
	,clone: function() {
		return new openfl_geom_Vector3D(this.x,this.y,this.z,this.w);
	}
	,copyFrom: function(sourceVector3D) {
		this.x = sourceVector3D.x;
		this.y = sourceVector3D.y;
		this.z = sourceVector3D.z;
	}
	,crossProduct: function(a) {
		return new openfl_geom_Vector3D(this.y * a.z - this.z * a.y,this.z * a.x - this.x * a.z,this.x * a.y - this.y * a.x,1);
	}
	,decrementBy: function(a) {
		this.x -= a.x;
		this.y -= a.y;
		this.z -= a.z;
	}
	,dotProduct: function(a) {
		return this.x * a.x + this.y * a.y + this.z * a.z;
	}
	,equals: function(toCompare,allFour) {
		if(allFour == null) {
			allFour = false;
		}
		if(this.x == toCompare.x && this.y == toCompare.y && this.z == toCompare.z) {
			if(!(!allFour)) {
				return this.w == toCompare.w;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	,incrementBy: function(a) {
		this.x += a.x;
		this.y += a.y;
		this.z += a.z;
	}
	,nearEquals: function(toCompare,tolerance,allFour) {
		if(allFour == null) {
			allFour = false;
		}
		if(Math.abs(this.x - toCompare.x) < tolerance && Math.abs(this.y - toCompare.y) < tolerance && Math.abs(this.z - toCompare.z) < tolerance) {
			if(!(!allFour)) {
				return Math.abs(this.w - toCompare.w) < tolerance;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	,negate: function() {
		this.x *= -1;
		this.y *= -1;
		this.z *= -1;
	}
	,normalize: function() {
		var l = this.get_length();
		if(l != 0) {
			this.x /= l;
			this.y /= l;
			this.z /= l;
		}
		return l;
	}
	,project: function() {
		this.x /= this.w;
		this.y /= this.w;
		this.z /= this.w;
	}
	,scaleBy: function(s) {
		this.x *= s;
		this.y *= s;
		this.z *= s;
	}
	,setTo: function(xa,ya,za) {
		this.x = xa;
		this.y = ya;
		this.z = za;
	}
	,subtract: function(a) {
		return new openfl_geom_Vector3D(this.x - a.x,this.y - a.y,this.z - a.z);
	}
	,toString: function() {
		return "Vector3D(" + this.x + ", " + this.y + ", " + this.z + ")";
	}
	,get_length: function() {
		return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
	}
	,get_lengthSquared: function() {
		return this.x * this.x + this.y * this.y + this.z * this.z;
	}
	,__class__: openfl_geom_Vector3D
	,__properties__: {get_lengthSquared:"get_lengthSquared",get_length:"get_length"}
};
var openfl_geom_Matrix3D = function(v) {
	if(v != null && v.get_length() == 16) {
		this.rawData = v.concat(null);
	} else {
		this.rawData = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,null,null,[1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0]);
	}
};
$hxClasses["openfl.geom.Matrix3D"] = openfl_geom_Matrix3D;
openfl_geom_Matrix3D.__name__ = "openfl.geom.Matrix3D";
openfl_geom_Matrix3D.create2D = function(x,y,scale,rotation) {
	if(rotation == null) {
		rotation = 0;
	}
	if(scale == null) {
		scale = 1;
	}
	var theta = rotation * Math.PI / 180.0;
	var c = Math.cos(theta);
	var s = Math.sin(theta);
	return new openfl_geom_Matrix3D(openfl__$Vector_Vector_$Impl_$.toFloatVector(null,null,null,[c * scale,-s * scale,0,0,s * scale,c * scale,0,0,0,0,1,0,x,y,0,1]));
};
openfl_geom_Matrix3D.createABCD = function(a,b,c,d,tx,ty) {
	return new openfl_geom_Matrix3D(openfl__$Vector_Vector_$Impl_$.toFloatVector(null,null,null,[a,b,0,0,c,d,0,0,0,0,1,0,tx,ty,0,1]));
};
openfl_geom_Matrix3D.createOrtho = function(x0,x1,y0,y1,zNear,zFar) {
	var sx = 1.0 / (x1 - x0);
	var sy = 1.0 / (y1 - y0);
	var sz = 1.0 / (zFar - zNear);
	return new openfl_geom_Matrix3D(openfl__$Vector_Vector_$Impl_$.toFloatVector(null,null,null,[2.0 * sx,0,0,0,0,2.0 * sy,0,0,0,0,-2.0 * sz,0,-(x0 + x1) * sx,-(y0 + y1) * sy,-(zNear + zFar) * sz,1]));
};
openfl_geom_Matrix3D.interpolate = function(thisMat,toMat,percent) {
	var m = new openfl_geom_Matrix3D();
	var _g = 0;
	while(_g < 16) {
		var i = _g++;
		m.rawData.set(i,thisMat.rawData.get(i) + (toMat.rawData.get(i) - thisMat.rawData.get(i)) * percent);
	}
	return m;
};
openfl_geom_Matrix3D.__getAxisRotation = function(x,y,z,degrees) {
	var m = new openfl_geom_Matrix3D();
	var a1 = new openfl_geom_Vector3D(x,y,z);
	var rad = -degrees * (Math.PI / 180);
	var c = Math.cos(rad);
	var s = Math.sin(rad);
	var t = 1.0 - c;
	m.rawData.set(0,c + a1.x * a1.x * t);
	m.rawData.set(5,c + a1.y * a1.y * t);
	m.rawData.set(10,c + a1.z * a1.z * t);
	var tmp1 = a1.x * a1.y * t;
	var tmp2 = a1.z * s;
	m.rawData.set(4,tmp1 + tmp2);
	m.rawData.set(1,tmp1 - tmp2);
	tmp1 = a1.x * a1.z * t;
	tmp2 = a1.y * s;
	m.rawData.set(8,tmp1 - tmp2);
	m.rawData.set(2,tmp1 + tmp2);
	tmp1 = a1.y * a1.z * t;
	tmp2 = a1.x * s;
	m.rawData.set(9,tmp1 + tmp2);
	m.rawData.set(6,tmp1 - tmp2);
	return m;
};
openfl_geom_Matrix3D.prototype = {
	rawData: null
	,append: function(lhs) {
		var m111 = this.rawData.get(0);
		var m121 = this.rawData.get(4);
		var m131 = this.rawData.get(8);
		var m141 = this.rawData.get(12);
		var m112 = this.rawData.get(1);
		var m122 = this.rawData.get(5);
		var m132 = this.rawData.get(9);
		var m142 = this.rawData.get(13);
		var m113 = this.rawData.get(2);
		var m123 = this.rawData.get(6);
		var m133 = this.rawData.get(10);
		var m143 = this.rawData.get(14);
		var m114 = this.rawData.get(3);
		var m124 = this.rawData.get(7);
		var m134 = this.rawData.get(11);
		var m144 = this.rawData.get(15);
		var m211 = lhs.rawData.get(0);
		var m221 = lhs.rawData.get(4);
		var m231 = lhs.rawData.get(8);
		var m241 = lhs.rawData.get(12);
		var m212 = lhs.rawData.get(1);
		var m222 = lhs.rawData.get(5);
		var m232 = lhs.rawData.get(9);
		var m242 = lhs.rawData.get(13);
		var m213 = lhs.rawData.get(2);
		var m223 = lhs.rawData.get(6);
		var m233 = lhs.rawData.get(10);
		var m243 = lhs.rawData.get(14);
		var m214 = lhs.rawData.get(3);
		var m224 = lhs.rawData.get(7);
		var m234 = lhs.rawData.get(11);
		var m244 = lhs.rawData.get(15);
		this.rawData.set(0,m111 * m211 + m112 * m221 + m113 * m231 + m114 * m241);
		this.rawData.set(1,m111 * m212 + m112 * m222 + m113 * m232 + m114 * m242);
		this.rawData.set(2,m111 * m213 + m112 * m223 + m113 * m233 + m114 * m243);
		this.rawData.set(3,m111 * m214 + m112 * m224 + m113 * m234 + m114 * m244);
		this.rawData.set(4,m121 * m211 + m122 * m221 + m123 * m231 + m124 * m241);
		this.rawData.set(5,m121 * m212 + m122 * m222 + m123 * m232 + m124 * m242);
		this.rawData.set(6,m121 * m213 + m122 * m223 + m123 * m233 + m124 * m243);
		this.rawData.set(7,m121 * m214 + m122 * m224 + m123 * m234 + m124 * m244);
		this.rawData.set(8,m131 * m211 + m132 * m221 + m133 * m231 + m134 * m241);
		this.rawData.set(9,m131 * m212 + m132 * m222 + m133 * m232 + m134 * m242);
		this.rawData.set(10,m131 * m213 + m132 * m223 + m133 * m233 + m134 * m243);
		this.rawData.set(11,m131 * m214 + m132 * m224 + m133 * m234 + m134 * m244);
		this.rawData.set(12,m141 * m211 + m142 * m221 + m143 * m231 + m144 * m241);
		this.rawData.set(13,m141 * m212 + m142 * m222 + m143 * m232 + m144 * m242);
		this.rawData.set(14,m141 * m213 + m142 * m223 + m143 * m233 + m144 * m243);
		this.rawData.set(15,m141 * m214 + m142 * m224 + m143 * m234 + m144 * m244);
	}
	,appendRotation: function(degrees,axis,pivotPoint) {
		var tz = 0;
		var ty = tz;
		var tx = ty;
		if(pivotPoint != null) {
			tx = pivotPoint.x;
			ty = pivotPoint.y;
			tz = pivotPoint.z;
		}
		var radian = degrees * Math.PI / 180;
		var cos = Math.cos(radian);
		var sin = Math.sin(radian);
		var x = axis.x;
		var y = axis.y;
		var z = axis.z;
		var x2 = x * x;
		var y2 = y * y;
		var z2 = z * z;
		var ls = x2 + y2 + z2;
		if(ls != 0) {
			var l = Math.sqrt(ls);
			x /= l;
			y /= l;
			z /= l;
			x2 /= ls;
			y2 /= ls;
			z2 /= ls;
		}
		var ccos = 1 - cos;
		var m = new openfl_geom_Matrix3D();
		var d = m.rawData;
		d.set(0,x2 + (y2 + z2) * cos);
		d.set(1,x * y * ccos + z * sin);
		d.set(2,x * z * ccos - y * sin);
		d.set(4,x * y * ccos - z * sin);
		d.set(5,y2 + (x2 + z2) * cos);
		d.set(6,y * z * ccos + x * sin);
		d.set(8,x * z * ccos + y * sin);
		d.set(9,y * z * ccos - x * sin);
		d.set(10,z2 + (x2 + y2) * cos);
		d.set(12,(tx * (y2 + z2) - x * (ty * y + tz * z)) * ccos + (ty * z - tz * y) * sin);
		d.set(13,(ty * (x2 + z2) - y * (tx * x + tz * z)) * ccos + (tz * x - tx * z) * sin);
		d.set(14,(tz * (x2 + y2) - z * (tx * x + ty * y)) * ccos + (tx * y - ty * x) * sin);
		this.append(m);
	}
	,appendScale: function(xScale,yScale,zScale) {
		this.append(new openfl_geom_Matrix3D(openfl__$Vector_Vector_$Impl_$.toFloatVector(null,null,null,[xScale,0.0,0.0,0.0,0.0,yScale,0.0,0.0,0.0,0.0,zScale,0.0,0.0,0.0,0.0,1.0])));
	}
	,appendTranslation: function(x,y,z) {
		var _g = this.rawData;
		_g.set(12,_g.get(12) + x);
		var _g1 = this.rawData;
		_g1.set(13,_g1.get(13) + y);
		var _g2 = this.rawData;
		_g2.set(14,_g2.get(14) + z);
	}
	,clone: function() {
		return new openfl_geom_Matrix3D(this.rawData.copy());
	}
	,copyColumnFrom: function(column,vector3D) {
		switch(column) {
		case 0:
			this.rawData.set(0,vector3D.x);
			this.rawData.set(1,vector3D.y);
			this.rawData.set(2,vector3D.z);
			this.rawData.set(3,vector3D.w);
			break;
		case 1:
			this.rawData.set(4,vector3D.x);
			this.rawData.set(5,vector3D.y);
			this.rawData.set(6,vector3D.z);
			this.rawData.set(7,vector3D.w);
			break;
		case 2:
			this.rawData.set(8,vector3D.x);
			this.rawData.set(9,vector3D.y);
			this.rawData.set(10,vector3D.z);
			this.rawData.set(11,vector3D.w);
			break;
		case 3:
			this.rawData.set(12,vector3D.x);
			this.rawData.set(13,vector3D.y);
			this.rawData.set(14,vector3D.z);
			this.rawData.set(15,vector3D.w);
			break;
		default:
		}
	}
	,copyColumnTo: function(column,vector3D) {
		switch(column) {
		case 0:
			vector3D.x = this.rawData.get(0);
			vector3D.y = this.rawData.get(1);
			vector3D.z = this.rawData.get(2);
			vector3D.w = this.rawData.get(3);
			break;
		case 1:
			vector3D.x = this.rawData.get(4);
			vector3D.y = this.rawData.get(5);
			vector3D.z = this.rawData.get(6);
			vector3D.w = this.rawData.get(7);
			break;
		case 2:
			vector3D.x = this.rawData.get(8);
			vector3D.y = this.rawData.get(9);
			vector3D.z = this.rawData.get(10);
			vector3D.w = this.rawData.get(11);
			break;
		case 3:
			vector3D.x = this.rawData.get(12);
			vector3D.y = this.rawData.get(13);
			vector3D.z = this.rawData.get(14);
			vector3D.w = this.rawData.get(15);
			break;
		default:
		}
	}
	,copyFrom: function(other) {
		this.rawData = other.rawData.copy();
	}
	,copyRawDataFrom: function(vector,index,transpose) {
		if(transpose == null) {
			transpose = false;
		}
		if(index == null) {
			index = 0;
		}
		if(transpose) {
			this.transpose();
		}
		var length = vector.get_length() - index;
		var _g = 0;
		var _g1 = length;
		while(_g < _g1) {
			var i = _g++;
			this.rawData.set(i,vector.get(i + index));
		}
		if(transpose) {
			this.transpose();
		}
	}
	,copyRawDataTo: function(vector,index,transpose) {
		if(transpose == null) {
			transpose = false;
		}
		if(index == null) {
			index = 0;
		}
		if(transpose) {
			this.transpose();
		}
		var _g = 0;
		var _g1 = this.rawData.get_length();
		while(_g < _g1) {
			var i = _g++;
			vector.set(i + index,this.rawData.get(i));
		}
		if(transpose) {
			this.transpose();
		}
	}
	,copyRowFrom: function(row,vector3D) {
		switch(row) {
		case 0:
			this.rawData.set(0,vector3D.x);
			this.rawData.set(4,vector3D.y);
			this.rawData.set(8,vector3D.z);
			this.rawData.set(12,vector3D.w);
			break;
		case 1:
			this.rawData.set(1,vector3D.x);
			this.rawData.set(5,vector3D.y);
			this.rawData.set(9,vector3D.z);
			this.rawData.set(13,vector3D.w);
			break;
		case 2:
			this.rawData.set(2,vector3D.x);
			this.rawData.set(6,vector3D.y);
			this.rawData.set(10,vector3D.z);
			this.rawData.set(14,vector3D.w);
			break;
		case 3:
			this.rawData.set(3,vector3D.x);
			this.rawData.set(7,vector3D.y);
			this.rawData.set(11,vector3D.z);
			this.rawData.set(15,vector3D.w);
			break;
		default:
		}
	}
	,copyRowTo: function(row,vector3D) {
		switch(row) {
		case 0:
			vector3D.x = this.rawData.get(0);
			vector3D.y = this.rawData.get(4);
			vector3D.z = this.rawData.get(8);
			vector3D.w = this.rawData.get(12);
			break;
		case 1:
			vector3D.x = this.rawData.get(1);
			vector3D.y = this.rawData.get(5);
			vector3D.z = this.rawData.get(9);
			vector3D.w = this.rawData.get(13);
			break;
		case 2:
			vector3D.x = this.rawData.get(2);
			vector3D.y = this.rawData.get(6);
			vector3D.z = this.rawData.get(10);
			vector3D.w = this.rawData.get(14);
			break;
		case 3:
			vector3D.x = this.rawData.get(3);
			vector3D.y = this.rawData.get(7);
			vector3D.z = this.rawData.get(11);
			vector3D.w = this.rawData.get(15);
			break;
		default:
		}
	}
	,copyToMatrix3D: function(other) {
		other.rawData = this.rawData.copy();
	}
	,decompose: function(orientationStyle) {
		if(orientationStyle == null) {
			orientationStyle = 1;
		}
		var vec = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		var m = this.clone();
		var mr = m.rawData.copy();
		var pos = new openfl_geom_Vector3D(mr.get(12),mr.get(13),mr.get(14));
		mr.set(12,0);
		mr.set(13,0);
		mr.set(14,0);
		var scale = new openfl_geom_Vector3D();
		scale.x = Math.sqrt(mr.get(0) * mr.get(0) + mr.get(1) * mr.get(1) + mr.get(2) * mr.get(2));
		scale.y = Math.sqrt(mr.get(4) * mr.get(4) + mr.get(5) * mr.get(5) + mr.get(6) * mr.get(6));
		scale.z = Math.sqrt(mr.get(8) * mr.get(8) + mr.get(9) * mr.get(9) + mr.get(10) * mr.get(10));
		if(mr.get(0) * (mr.get(5) * mr.get(10) - mr.get(6) * mr.get(9)) - mr.get(1) * (mr.get(4) * mr.get(10) - mr.get(6) * mr.get(8)) + mr.get(2) * (mr.get(4) * mr.get(9) - mr.get(5) * mr.get(8)) < 0) {
			scale.z = -scale.z;
		}
		var _g = mr;
		_g.set(0,_g.get(0) / scale.x);
		var _g1 = mr;
		_g1.set(1,_g1.get(1) / scale.x);
		var _g2 = mr;
		_g2.set(2,_g2.get(2) / scale.x);
		var _g3 = mr;
		_g3.set(4,_g3.get(4) / scale.y);
		var _g4 = mr;
		_g4.set(5,_g4.get(5) / scale.y);
		var _g5 = mr;
		_g5.set(6,_g5.get(6) / scale.y);
		var _g6 = mr;
		_g6.set(8,_g6.get(8) / scale.z);
		var _g7 = mr;
		_g7.set(9,_g7.get(9) / scale.z);
		var _g8 = mr;
		_g8.set(10,_g8.get(10) / scale.z);
		var rot = new openfl_geom_Vector3D();
		switch(orientationStyle) {
		case 0:
			rot.w = Math.acos((mr.get(0) + mr.get(5) + mr.get(10) - 1) / 2);
			var len = Math.sqrt((mr.get(6) - mr.get(9)) * (mr.get(6) - mr.get(9)) + (mr.get(8) - mr.get(2)) * (mr.get(8) - mr.get(2)) + (mr.get(1) - mr.get(4)) * (mr.get(1) - mr.get(4)));
			if(len != 0) {
				rot.x = (mr.get(6) - mr.get(9)) / len;
				rot.y = (mr.get(8) - mr.get(2)) / len;
				rot.z = (mr.get(1) - mr.get(4)) / len;
			} else {
				rot.x = rot.y = rot.z = 0;
			}
			break;
		case 1:
			rot.y = Math.asin(-mr.get(2));
			if(mr.get(2) != 1 && mr.get(2) != -1) {
				rot.x = Math.atan2(mr.get(6),mr.get(10));
				rot.z = Math.atan2(mr.get(1),mr.get(0));
			} else {
				rot.z = 0;
				rot.x = Math.atan2(mr.get(4),mr.get(5));
			}
			break;
		case 2:
			var tr = mr.get(0) + mr.get(5) + mr.get(10);
			if(tr > 0) {
				rot.w = Math.sqrt(1 + tr) / 2;
				rot.x = (mr.get(6) - mr.get(9)) / (4 * rot.w);
				rot.y = (mr.get(8) - mr.get(2)) / (4 * rot.w);
				rot.z = (mr.get(1) - mr.get(4)) / (4 * rot.w);
			} else if(mr.get(0) > mr.get(5) && mr.get(0) > mr.get(10)) {
				rot.x = Math.sqrt(1 + mr.get(0) - mr.get(5) - mr.get(10)) / 2;
				rot.w = (mr.get(6) - mr.get(9)) / (4 * rot.x);
				rot.y = (mr.get(1) + mr.get(4)) / (4 * rot.x);
				rot.z = (mr.get(8) + mr.get(2)) / (4 * rot.x);
			} else if(mr.get(5) > mr.get(10)) {
				rot.y = Math.sqrt(1 + mr.get(5) - mr.get(0) - mr.get(10)) / 2;
				rot.x = (mr.get(1) + mr.get(4)) / (4 * rot.y);
				rot.w = (mr.get(8) - mr.get(2)) / (4 * rot.y);
				rot.z = (mr.get(6) + mr.get(9)) / (4 * rot.y);
			} else {
				rot.z = Math.sqrt(1 + mr.get(10) - mr.get(0) - mr.get(5)) / 2;
				rot.x = (mr.get(8) + mr.get(2)) / (4 * rot.z);
				rot.y = (mr.get(6) + mr.get(9)) / (4 * rot.z);
				rot.w = (mr.get(1) - mr.get(4)) / (4 * rot.z);
			}
			break;
		}
		vec.push(pos);
		vec.push(rot);
		vec.push(scale);
		return vec;
	}
	,deltaTransformVector: function(v) {
		var x = v.x;
		var y = v.y;
		var z = v.z;
		return new openfl_geom_Vector3D(x * this.rawData.get(0) + y * this.rawData.get(4) + z * this.rawData.get(8),x * this.rawData.get(1) + y * this.rawData.get(5) + z * this.rawData.get(9),x * this.rawData.get(2) + y * this.rawData.get(6) + z * this.rawData.get(10),x * this.rawData.get(3) + y * this.rawData.get(7) + z * this.rawData.get(11));
	}
	,identity: function() {
		this.rawData = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,null,null,[1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,1.0]);
	}
	,interpolateTo: function(toMat,percent) {
		var _g = 0;
		while(_g < 16) {
			var i = _g++;
			this.rawData.set(i,this.rawData.get(i) + (toMat.rawData.get(i) - this.rawData.get(i)) * percent);
		}
	}
	,invert: function() {
		var d = this.get_determinant();
		var invertable = Math.abs(d) > 0.00000000001;
		if(invertable) {
			d = 1 / d;
			var m11 = this.rawData.get(0);
			var m21 = this.rawData.get(4);
			var m31 = this.rawData.get(8);
			var m41 = this.rawData.get(12);
			var m12 = this.rawData.get(1);
			var m22 = this.rawData.get(5);
			var m32 = this.rawData.get(9);
			var m42 = this.rawData.get(13);
			var m13 = this.rawData.get(2);
			var m23 = this.rawData.get(6);
			var m33 = this.rawData.get(10);
			var m43 = this.rawData.get(14);
			var m14 = this.rawData.get(3);
			var m24 = this.rawData.get(7);
			var m34 = this.rawData.get(11);
			var m44 = this.rawData.get(15);
			this.rawData.set(0,d * (m22 * (m33 * m44 - m43 * m34) - m32 * (m23 * m44 - m43 * m24) + m42 * (m23 * m34 - m33 * m24)));
			this.rawData.set(1,-d * (m12 * (m33 * m44 - m43 * m34) - m32 * (m13 * m44 - m43 * m14) + m42 * (m13 * m34 - m33 * m14)));
			this.rawData.set(2,d * (m12 * (m23 * m44 - m43 * m24) - m22 * (m13 * m44 - m43 * m14) + m42 * (m13 * m24 - m23 * m14)));
			this.rawData.set(3,-d * (m12 * (m23 * m34 - m33 * m24) - m22 * (m13 * m34 - m33 * m14) + m32 * (m13 * m24 - m23 * m14)));
			this.rawData.set(4,-d * (m21 * (m33 * m44 - m43 * m34) - m31 * (m23 * m44 - m43 * m24) + m41 * (m23 * m34 - m33 * m24)));
			this.rawData.set(5,d * (m11 * (m33 * m44 - m43 * m34) - m31 * (m13 * m44 - m43 * m14) + m41 * (m13 * m34 - m33 * m14)));
			this.rawData.set(6,-d * (m11 * (m23 * m44 - m43 * m24) - m21 * (m13 * m44 - m43 * m14) + m41 * (m13 * m24 - m23 * m14)));
			this.rawData.set(7,d * (m11 * (m23 * m34 - m33 * m24) - m21 * (m13 * m34 - m33 * m14) + m31 * (m13 * m24 - m23 * m14)));
			this.rawData.set(8,d * (m21 * (m32 * m44 - m42 * m34) - m31 * (m22 * m44 - m42 * m24) + m41 * (m22 * m34 - m32 * m24)));
			this.rawData.set(9,-d * (m11 * (m32 * m44 - m42 * m34) - m31 * (m12 * m44 - m42 * m14) + m41 * (m12 * m34 - m32 * m14)));
			this.rawData.set(10,d * (m11 * (m22 * m44 - m42 * m24) - m21 * (m12 * m44 - m42 * m14) + m41 * (m12 * m24 - m22 * m14)));
			this.rawData.set(11,-d * (m11 * (m22 * m34 - m32 * m24) - m21 * (m12 * m34 - m32 * m14) + m31 * (m12 * m24 - m22 * m14)));
			this.rawData.set(12,-d * (m21 * (m32 * m43 - m42 * m33) - m31 * (m22 * m43 - m42 * m23) + m41 * (m22 * m33 - m32 * m23)));
			this.rawData.set(13,d * (m11 * (m32 * m43 - m42 * m33) - m31 * (m12 * m43 - m42 * m13) + m41 * (m12 * m33 - m32 * m13)));
			this.rawData.set(14,-d * (m11 * (m22 * m43 - m42 * m23) - m21 * (m12 * m43 - m42 * m13) + m41 * (m12 * m23 - m22 * m13)));
			this.rawData.set(15,d * (m11 * (m22 * m33 - m32 * m23) - m21 * (m12 * m33 - m32 * m13) + m31 * (m12 * m23 - m22 * m13)));
		}
		return invertable;
	}
	,pointAt: function(pos,at,up) {
		if(at == null) {
			at = new openfl_geom_Vector3D(0,0,-1);
		}
		if(up == null) {
			up = new openfl_geom_Vector3D(0,-1,0);
		}
		var dir = at.subtract(pos);
		var vup = up.clone();
		dir.normalize();
		vup.normalize();
		var dir2 = dir.clone();
		dir2.scaleBy(vup.dotProduct(dir));
		vup = vup.subtract(dir2);
		if(vup.get_length() > 0) {
			vup.normalize();
		} else if(dir.x != 0) {
			vup = new openfl_geom_Vector3D(-dir.y,dir.x,0);
		} else {
			vup = new openfl_geom_Vector3D(1,0,0);
		}
		var right = vup.crossProduct(dir);
		right.normalize();
		this.rawData.set(0,right.x);
		this.rawData.set(4,right.y);
		this.rawData.set(8,right.z);
		this.rawData.set(12,0.0);
		this.rawData.set(1,vup.x);
		this.rawData.set(5,vup.y);
		this.rawData.set(9,vup.z);
		this.rawData.set(13,0.0);
		this.rawData.set(2,dir.x);
		this.rawData.set(6,dir.y);
		this.rawData.set(10,dir.z);
		this.rawData.set(14,0.0);
		this.rawData.set(3,pos.x);
		this.rawData.set(7,pos.y);
		this.rawData.set(11,pos.z);
		this.rawData.set(15,1.0);
	}
	,prepend: function(rhs) {
		var m111 = rhs.rawData.get(0);
		var m121 = rhs.rawData.get(4);
		var m131 = rhs.rawData.get(8);
		var m141 = rhs.rawData.get(12);
		var m112 = rhs.rawData.get(1);
		var m122 = rhs.rawData.get(5);
		var m132 = rhs.rawData.get(9);
		var m142 = rhs.rawData.get(13);
		var m113 = rhs.rawData.get(2);
		var m123 = rhs.rawData.get(6);
		var m133 = rhs.rawData.get(10);
		var m143 = rhs.rawData.get(14);
		var m114 = rhs.rawData.get(3);
		var m124 = rhs.rawData.get(7);
		var m134 = rhs.rawData.get(11);
		var m144 = rhs.rawData.get(15);
		var m211 = this.rawData.get(0);
		var m221 = this.rawData.get(4);
		var m231 = this.rawData.get(8);
		var m241 = this.rawData.get(12);
		var m212 = this.rawData.get(1);
		var m222 = this.rawData.get(5);
		var m232 = this.rawData.get(9);
		var m242 = this.rawData.get(13);
		var m213 = this.rawData.get(2);
		var m223 = this.rawData.get(6);
		var m233 = this.rawData.get(10);
		var m243 = this.rawData.get(14);
		var m214 = this.rawData.get(3);
		var m224 = this.rawData.get(7);
		var m234 = this.rawData.get(11);
		var m244 = this.rawData.get(15);
		this.rawData.set(0,m111 * m211 + m112 * m221 + m113 * m231 + m114 * m241);
		this.rawData.set(1,m111 * m212 + m112 * m222 + m113 * m232 + m114 * m242);
		this.rawData.set(2,m111 * m213 + m112 * m223 + m113 * m233 + m114 * m243);
		this.rawData.set(3,m111 * m214 + m112 * m224 + m113 * m234 + m114 * m244);
		this.rawData.set(4,m121 * m211 + m122 * m221 + m123 * m231 + m124 * m241);
		this.rawData.set(5,m121 * m212 + m122 * m222 + m123 * m232 + m124 * m242);
		this.rawData.set(6,m121 * m213 + m122 * m223 + m123 * m233 + m124 * m243);
		this.rawData.set(7,m121 * m214 + m122 * m224 + m123 * m234 + m124 * m244);
		this.rawData.set(8,m131 * m211 + m132 * m221 + m133 * m231 + m134 * m241);
		this.rawData.set(9,m131 * m212 + m132 * m222 + m133 * m232 + m134 * m242);
		this.rawData.set(10,m131 * m213 + m132 * m223 + m133 * m233 + m134 * m243);
		this.rawData.set(11,m131 * m214 + m132 * m224 + m133 * m234 + m134 * m244);
		this.rawData.set(12,m141 * m211 + m142 * m221 + m143 * m231 + m144 * m241);
		this.rawData.set(13,m141 * m212 + m142 * m222 + m143 * m232 + m144 * m242);
		this.rawData.set(14,m141 * m213 + m142 * m223 + m143 * m233 + m144 * m243);
		this.rawData.set(15,m141 * m214 + m142 * m224 + m143 * m234 + m144 * m244);
	}
	,prependRotation: function(degrees,axis,pivotPoint) {
		var tz = 0;
		var ty = tz;
		var tx = ty;
		if(pivotPoint != null) {
			tx = pivotPoint.x;
			ty = pivotPoint.y;
			tz = pivotPoint.z;
		}
		var radian = degrees * Math.PI / 180;
		var cos = Math.cos(radian);
		var sin = Math.sin(radian);
		var x = axis.x;
		var y = axis.y;
		var z = axis.z;
		var x2 = x * x;
		var y2 = y * y;
		var z2 = z * z;
		var ls = x2 + y2 + z2;
		if(ls != 0) {
			var l = Math.sqrt(ls);
			x /= l;
			y /= l;
			z /= l;
			x2 /= ls;
			y2 /= ls;
			z2 /= ls;
		}
		var ccos = 1 - cos;
		var m = new openfl_geom_Matrix3D();
		var d = m.rawData;
		d.set(0,x2 + (y2 + z2) * cos);
		d.set(1,x * y * ccos + z * sin);
		d.set(2,x * z * ccos - y * sin);
		d.set(4,x * y * ccos - z * sin);
		d.set(5,y2 + (x2 + z2) * cos);
		d.set(6,y * z * ccos + x * sin);
		d.set(8,x * z * ccos + y * sin);
		d.set(9,y * z * ccos - x * sin);
		d.set(10,z2 + (x2 + y2) * cos);
		d.set(12,(tx * (y2 + z2) - x * (ty * y + tz * z)) * ccos + (ty * z - tz * y) * sin);
		d.set(13,(ty * (x2 + z2) - y * (tx * x + tz * z)) * ccos + (tz * x - tx * z) * sin);
		d.set(14,(tz * (x2 + y2) - z * (tx * x + ty * y)) * ccos + (tx * y - ty * x) * sin);
		this.prepend(m);
	}
	,prependScale: function(xScale,yScale,zScale) {
		this.prepend(new openfl_geom_Matrix3D(openfl__$Vector_Vector_$Impl_$.toFloatVector(null,null,null,[xScale,0.0,0.0,0.0,0.0,yScale,0.0,0.0,0.0,0.0,zScale,0.0,0.0,0.0,0.0,1.0])));
	}
	,prependTranslation: function(x,y,z) {
		var m = new openfl_geom_Matrix3D();
		m.set_position(new openfl_geom_Vector3D(x,y,z));
		this.prepend(m);
	}
	,recompose: function(components,orientationStyle) {
		if(orientationStyle == null) {
			orientationStyle = 1;
		}
		if(components.get_length() < 3 || components.get(2).x == 0 || components.get(2).y == 0 || components.get(2).z == 0) {
			return false;
		}
		this.identity();
		var scale = [];
		scale[0] = scale[1] = scale[2] = components.get(2).x;
		scale[4] = scale[5] = scale[6] = components.get(2).y;
		scale[8] = scale[9] = scale[10] = components.get(2).z;
		if(orientationStyle == 1) {
			var cx = Math.cos(components.get(1).x);
			var cy = Math.cos(components.get(1).y);
			var cz = Math.cos(components.get(1).z);
			var sx = Math.sin(components.get(1).x);
			var sy = Math.sin(components.get(1).y);
			var sz = Math.sin(components.get(1).z);
			this.rawData.set(0,cy * cz * scale[0]);
			this.rawData.set(1,cy * sz * scale[1]);
			this.rawData.set(2,-sy * scale[2]);
			this.rawData.set(3,0);
			this.rawData.set(4,(sx * sy * cz - cx * sz) * scale[4]);
			this.rawData.set(5,(sx * sy * sz + cx * cz) * scale[5]);
			this.rawData.set(6,sx * cy * scale[6]);
			this.rawData.set(7,0);
			this.rawData.set(8,(cx * sy * cz + sx * sz) * scale[8]);
			this.rawData.set(9,(cx * sy * sz - sx * cz) * scale[9]);
			this.rawData.set(10,cx * cy * scale[10]);
			this.rawData.set(11,0);
			this.rawData.set(12,components.get(0).x);
			this.rawData.set(13,components.get(0).y);
			this.rawData.set(14,components.get(0).z);
			this.rawData.set(15,1);
		} else {
			var x = components.get(1).x;
			var y = components.get(1).y;
			var z = components.get(1).z;
			var w = components.get(1).w;
			if(orientationStyle == 0) {
				x *= Math.sin(w / 2);
				y *= Math.sin(w / 2);
				z *= Math.sin(w / 2);
				w = Math.cos(w / 2);
			}
			this.rawData.set(0,(1 - 2 * y * y - 2 * z * z) * scale[0]);
			this.rawData.set(1,(2 * x * y + 2 * w * z) * scale[1]);
			this.rawData.set(2,(2 * x * z - 2 * w * y) * scale[2]);
			this.rawData.set(3,0);
			this.rawData.set(4,(2 * x * y - 2 * w * z) * scale[4]);
			this.rawData.set(5,(1 - 2 * x * x - 2 * z * z) * scale[5]);
			this.rawData.set(6,(2 * y * z + 2 * w * x) * scale[6]);
			this.rawData.set(7,0);
			this.rawData.set(8,(2 * x * z + 2 * w * y) * scale[8]);
			this.rawData.set(9,(2 * y * z - 2 * w * x) * scale[9]);
			this.rawData.set(10,(1 - 2 * x * x - 2 * y * y) * scale[10]);
			this.rawData.set(11,0);
			this.rawData.set(12,components.get(0).x);
			this.rawData.set(13,components.get(0).y);
			this.rawData.set(14,components.get(0).z);
			this.rawData.set(15,1);
		}
		if(components.get(2).x == 0) {
			this.rawData.set(0,1e-15);
		}
		if(components.get(2).y == 0) {
			this.rawData.set(5,1e-15);
		}
		if(components.get(2).z == 0) {
			this.rawData.set(10,1e-15);
		}
		return !(components.get(2).x == 0 || components.get(2).y == 0 || components.get(2).y == 0);
	}
	,transformVector: function(v) {
		var x = v.x;
		var y = v.y;
		var z = v.z;
		return new openfl_geom_Vector3D(x * this.rawData.get(0) + y * this.rawData.get(4) + z * this.rawData.get(8) + this.rawData.get(12),x * this.rawData.get(1) + y * this.rawData.get(5) + z * this.rawData.get(9) + this.rawData.get(13),x * this.rawData.get(2) + y * this.rawData.get(6) + z * this.rawData.get(10) + this.rawData.get(14),x * this.rawData.get(3) + y * this.rawData.get(7) + z * this.rawData.get(11) + this.rawData.get(15));
	}
	,transformVectors: function(vin,vout) {
		var i = 0;
		var x;
		var y;
		var z;
		while(i + 3 <= vin.get_length()) {
			x = vin.get(i);
			y = vin.get(i + 1);
			z = vin.get(i + 2);
			vout.set(i,x * this.rawData.get(0) + y * this.rawData.get(4) + z * this.rawData.get(8) + this.rawData.get(12));
			vout.set(i + 1,x * this.rawData.get(1) + y * this.rawData.get(5) + z * this.rawData.get(9) + this.rawData.get(13));
			vout.set(i + 2,x * this.rawData.get(2) + y * this.rawData.get(6) + z * this.rawData.get(10) + this.rawData.get(14));
			i += 3;
		}
	}
	,transpose: function() {
		var oRawData = this.rawData.copy();
		this.rawData.set(1,oRawData.get(4));
		this.rawData.set(2,oRawData.get(8));
		this.rawData.set(3,oRawData.get(12));
		this.rawData.set(4,oRawData.get(1));
		this.rawData.set(6,oRawData.get(9));
		this.rawData.set(7,oRawData.get(13));
		this.rawData.set(8,oRawData.get(2));
		this.rawData.set(9,oRawData.get(6));
		this.rawData.set(11,oRawData.get(14));
		this.rawData.set(12,oRawData.get(3));
		this.rawData.set(13,oRawData.get(7));
		this.rawData.set(14,oRawData.get(11));
	}
	,get_determinant: function() {
		return (this.rawData.get(0) * this.rawData.get(5) - this.rawData.get(4) * this.rawData.get(1)) * (this.rawData.get(10) * this.rawData.get(15) - this.rawData.get(14) * this.rawData.get(11)) - (this.rawData.get(0) * this.rawData.get(9) - this.rawData.get(8) * this.rawData.get(1)) * (this.rawData.get(6) * this.rawData.get(15) - this.rawData.get(14) * this.rawData.get(7)) + (this.rawData.get(0) * this.rawData.get(13) - this.rawData.get(12) * this.rawData.get(1)) * (this.rawData.get(6) * this.rawData.get(11) - this.rawData.get(10) * this.rawData.get(7)) + (this.rawData.get(4) * this.rawData.get(9) - this.rawData.get(8) * this.rawData.get(5)) * (this.rawData.get(2) * this.rawData.get(15) - this.rawData.get(14) * this.rawData.get(3)) - (this.rawData.get(4) * this.rawData.get(13) - this.rawData.get(12) * this.rawData.get(5)) * (this.rawData.get(2) * this.rawData.get(11) - this.rawData.get(10) * this.rawData.get(3)) + (this.rawData.get(8) * this.rawData.get(13) - this.rawData.get(12) * this.rawData.get(9)) * (this.rawData.get(2) * this.rawData.get(7) - this.rawData.get(6) * this.rawData.get(3));
	}
	,get_position: function() {
		return new openfl_geom_Vector3D(this.rawData.get(12),this.rawData.get(13),this.rawData.get(14));
	}
	,set_position: function(val) {
		this.rawData.set(12,val.x);
		this.rawData.set(13,val.y);
		this.rawData.set(14,val.z);
		return val;
	}
	,__class__: openfl_geom_Matrix3D
	,__properties__: {set_position:"set_position",get_position:"get_position",get_determinant:"get_determinant"}
};
var away3d_core_math_Matrix3DUtils = function() { };
$hxClasses["away3d.core.math.Matrix3DUtils"] = away3d_core_math_Matrix3DUtils;
away3d_core_math_Matrix3DUtils.__name__ = "away3d.core.math.Matrix3DUtils";
away3d_core_math_Matrix3DUtils.quaternion2matrix = function(quarternion,m) {
	var x = quarternion.x;
	var y = quarternion.y;
	var z = quarternion.z;
	var w = quarternion.w;
	var xx = x * x;
	var xy = x * y;
	var xz = x * z;
	var xw = x * w;
	var yy = y * y;
	var yz = y * z;
	var yw = y * w;
	var zz = z * z;
	var zw = z * w;
	var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
	raw.set(0,1 - 2 * (yy + zz));
	raw.set(1,2 * (xy + zw));
	raw.set(2,2 * (xz - yw));
	raw.set(4,2 * (xy - zw));
	raw.set(5,1 - 2 * (xx + zz));
	raw.set(6,2 * (yz + xw));
	raw.set(8,2 * (xz + yw));
	raw.set(9,2 * (yz - xw));
	raw.set(10,1 - 2 * (xx + yy));
	raw.set(3,raw.set(7,raw.set(11,raw.set(12,raw.set(13,raw.set(14,0))))));
	raw.set(15,1);
	if(m != null) {
		m.copyRawDataFrom(raw);
		return m;
	} else {
		return new openfl_geom_Matrix3D(raw);
	}
};
away3d_core_math_Matrix3DUtils.getForward = function(m,v) {
	if(v == null) {
		v = new openfl_geom_Vector3D(0.0,0.0,0.0);
	}
	m.copyColumnTo(2,v);
	v.normalize();
	return v;
};
away3d_core_math_Matrix3DUtils.getUp = function(m,v) {
	if(v == null) {
		v = new openfl_geom_Vector3D(0.0,0.0,0.0);
	}
	m.copyColumnTo(1,v);
	v.normalize();
	return v;
};
away3d_core_math_Matrix3DUtils.getRight = function(m,v) {
	if(v == null) {
		v = new openfl_geom_Vector3D(0.0,0.0,0.0);
	}
	m.copyColumnTo(0,v);
	v.normalize();
	return v;
};
away3d_core_math_Matrix3DUtils.compare = function(m1,m2) {
	var r1 = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
	var r2 = m2.rawData;
	m1.copyRawDataTo(r1);
	if(r1.get(0) != r2.get(0)) {
		return false;
	}
	if(r1.get(1) != r2.get(1)) {
		return false;
	}
	if(r1.get(2) != r2.get(2)) {
		return false;
	}
	if(r1.get(3) != r2.get(3)) {
		return false;
	}
	if(r1.get(4) != r2.get(4)) {
		return false;
	}
	if(r1.get(5) != r2.get(5)) {
		return false;
	}
	if(r1.get(6) != r2.get(6)) {
		return false;
	}
	if(r1.get(7) != r2.get(7)) {
		return false;
	}
	if(r1.get(8) != r2.get(8)) {
		return false;
	}
	if(r1.get(9) != r2.get(9)) {
		return false;
	}
	if(r1.get(10) != r2.get(10)) {
		return false;
	}
	if(r1.get(11) != r2.get(11)) {
		return false;
	}
	if(r1.get(12) != r2.get(12)) {
		return false;
	}
	if(r1.get(13) != r2.get(13)) {
		return false;
	}
	if(r1.get(14) != r2.get(14)) {
		return false;
	}
	if(r1.get(15) != r2.get(15)) {
		return false;
	}
	return true;
};
away3d_core_math_Matrix3DUtils.lookAt = function(matrix,pos,dir,up) {
	var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
	var lftN = dir.crossProduct(up);
	lftN.normalize();
	var upN = lftN.crossProduct(dir);
	upN.normalize();
	var dirN = dir.clone();
	dirN.normalize();
	raw.set(0,lftN.x);
	raw.set(1,upN.x);
	raw.set(2,-dirN.x);
	raw.set(3,0.0);
	raw.set(4,lftN.y);
	raw.set(5,upN.y);
	raw.set(6,-dirN.y);
	raw.set(7,0.0);
	raw.set(8,lftN.z);
	raw.set(9,upN.z);
	raw.set(10,-dirN.z);
	raw.set(11,0.0);
	raw.set(12,-lftN.dotProduct(pos));
	raw.set(13,-upN.dotProduct(pos));
	raw.set(14,dirN.dotProduct(pos));
	raw.set(15,1.0);
	matrix.copyRawDataFrom(raw);
};
away3d_core_math_Matrix3DUtils.reflection = function(plane,target) {
	if(target == null) {
		target = new openfl_geom_Matrix3D();
	}
	var a = plane.a;
	var b = plane.b;
	var c = plane.c;
	var d = plane.d;
	var rawData = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
	var ab2 = -2 * a * b;
	var ac2 = -2 * a * c;
	var bc2 = -2 * b * c;
	rawData.set(0,1 - 2 * a * a);
	rawData.set(4,ab2);
	rawData.set(8,ac2);
	rawData.set(12,-2 * a * d);
	rawData.set(1,ab2);
	rawData.set(5,1 - 2 * b * b);
	rawData.set(9,bc2);
	rawData.set(13,-2 * b * d);
	rawData.set(2,ac2);
	rawData.set(6,bc2);
	rawData.set(10,1 - 2 * c * c);
	rawData.set(14,-2 * c * d);
	rawData.set(3,0);
	rawData.set(7,0);
	rawData.set(11,0);
	rawData.set(15,1);
	target.copyRawDataFrom(rawData);
	return target;
};
away3d_core_math_Matrix3DUtils.decompose = function(sourceMatrix,orientationStyle) {
	if(orientationStyle == null) {
		orientationStyle = 1;
	}
	var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
	sourceMatrix.copyRawDataTo(raw);
	var a = raw.get(0);
	var e = raw.get(1);
	var i = raw.get(2);
	var b = raw.get(4);
	var f = raw.get(5);
	var j = raw.get(6);
	var c = raw.get(8);
	var g = raw.get(9);
	var k = raw.get(10);
	var x = raw.get(12);
	var y = raw.get(13);
	var z = raw.get(14);
	var tx = Math.sqrt(a * a + e * e + i * i);
	var ty = Math.sqrt(b * b + f * f + j * j);
	var tz = Math.sqrt(c * c + g * g + k * k);
	var tw = 0;
	var scaleX = tx;
	var scaleY = ty;
	var scaleZ = tz;
	if(a * (f * k - j * g) - e * (b * k - j * c) + i * (b * g - f * c) < 0) {
		scaleZ = -scaleZ;
	}
	a /= scaleX;
	e /= scaleX;
	i /= scaleX;
	b /= scaleY;
	f /= scaleY;
	j /= scaleY;
	c /= scaleZ;
	g /= scaleZ;
	k /= scaleZ;
	if(orientationStyle == 1) {
		tx = Math.atan2(j,k);
		ty = Math.atan2(-i,Math.sqrt(a * a + e * e));
		var s1 = Math.sin(tx);
		var c1 = Math.cos(tx);
		tz = Math.atan2(s1 * c - c1 * b,c1 * f - s1 * g);
	} else if(orientationStyle == 0) {
		tw = Math.acos((a + f + k - 1) / 2);
		var len = Math.sqrt((j - g) * (j - g) + (c - i) * (c - i) + (e - b) * (e - b));
		tx = (j - g) / len;
		ty = (c - i) / len;
		tz = (e - b) / len;
	} else {
		var tr = a + f + k;
		if(tr > 0) {
			tw = Math.sqrt(1 + tr) / 2;
			tx = (j - g) / (4 * tw);
			ty = (c - i) / (4 * tw);
			tz = (e - b) / (4 * tw);
		} else if(a > f && a > k) {
			tx = Math.sqrt(1 + a - f - k) / 2;
			tw = (j - g) / (4 * tx);
			ty = (e + b) / (4 * tx);
			tz = (c + i) / (4 * tx);
		} else if(f > k) {
			ty = Math.sqrt(1 + f - a - k) / 2;
			tx = (e + b) / (4 * ty);
			tw = (c - i) / (4 * ty);
			tz = (j + g) / (4 * ty);
		} else {
			tz = Math.sqrt(1 + k - a - f) / 2;
			tx = (c + i) / (4 * tz);
			ty = (j + g) / (4 * tz);
			tw = (e - b) / (4 * tz);
		}
	}
	var v = away3d_core_math_Matrix3DUtils.CALCULATION_DECOMPOSE;
	v.get(0).x = x;
	v.get(0).y = y;
	v.get(0).z = z;
	v.get(1).x = tx;
	v.get(1).y = ty;
	v.get(1).z = tz;
	v.get(1).w = tw;
	v.get(2).x = scaleX;
	v.get(2).y = scaleY;
	v.get(2).z = scaleZ;
	return v;
};
away3d_core_math_Matrix3DUtils.transformVector = function(matrix,vector,result) {
	if(result == null) {
		result = new openfl_geom_Vector3D();
	}
	var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
	matrix.copyRawDataTo(raw);
	var a = raw.get(0);
	var e = raw.get(1);
	var i = raw.get(2);
	var m = raw.get(3);
	var b = raw.get(4);
	var f = raw.get(5);
	var j = raw.get(6);
	var n = raw.get(7);
	var c = raw.get(8);
	var g = raw.get(9);
	var k = raw.get(10);
	var o = raw.get(11);
	var d = raw.get(12);
	var h = raw.get(13);
	var l = raw.get(14);
	var p = raw.get(15);
	var x = vector.x;
	var y = vector.y;
	var z = vector.z;
	result.x = a * x + b * y + c * z + d;
	result.y = e * x + f * y + g * z + h;
	result.z = i * x + j * y + k * z + l;
	result.w = m * x + n * y + o * z + p;
	return result;
};
away3d_core_math_Matrix3DUtils.deltaTransformVector = function(matrix,vector,result) {
	if(result == null) {
		result = new openfl_geom_Vector3D();
	}
	var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
	matrix.copyRawDataTo(raw);
	var a = raw.get(0);
	var e = raw.get(1);
	var i = raw.get(2);
	var m = raw.get(3);
	var b = raw.get(4);
	var f = raw.get(5);
	var j = raw.get(6);
	var n = raw.get(7);
	var c = raw.get(8);
	var g = raw.get(9);
	var k = raw.get(10);
	var o = raw.get(11);
	var x = vector.x;
	var y = vector.y;
	var z = vector.z;
	result.x = a * x + b * y + c * z;
	result.y = e * x + f * y + g * z;
	result.z = i * x + j * y + k * z;
	result.w = m * x + n * y + o * z;
	return result;
};
away3d_core_math_Matrix3DUtils.getTranslation = function(transform,result) {
	if(result == null) {
		result = new openfl_geom_Vector3D();
	}
	transform.copyColumnTo(3,result);
	return result;
};
away3d_core_math_Matrix3DUtils.deltaTransformVectors = function(matrix,vin,vout) {
	var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
	matrix.copyRawDataTo(raw);
	var a = raw.get(0);
	var e = raw.get(1);
	var i = raw.get(2);
	var m = raw.get(3);
	var b = raw.get(4);
	var f = raw.get(5);
	var j = raw.get(6);
	var n = raw.get(7);
	var c = raw.get(8);
	var g = raw.get(9);
	var k = raw.get(10);
	var o = raw.get(11);
	var outIndex = 0;
	var length = vin.get_length();
	var index = 0;
	while(index < length) {
		var x = vin.get(index);
		var y = vin.get(index + 1);
		var z = vin.get(index + 2);
		vout.set(outIndex++,a * x + b * y + c * z);
		vout.set(outIndex++,e * x + f * y + g * z);
		vout.set(outIndex++,i * x + j * y + k * z);
		index += 3;
	}
};
var away3d_core_math_Plane3D = function(a,b,c,d) {
	if(d == null) {
		d = 0;
	}
	if(c == null) {
		c = 0;
	}
	if(b == null) {
		b = 0;
	}
	if(a == null) {
		a = 0;
	}
	this.a = a;
	this.b = b;
	this.c = c;
	this.d = d;
	if(a == 0 && b == 0) {
		this._alignment = 1;
	} else if(b == 0 && c == 0) {
		this._alignment = 2;
	} else if(a == 0 && c == 0) {
		this._alignment = 3;
	} else {
		this._alignment = 0;
	}
};
$hxClasses["away3d.core.math.Plane3D"] = away3d_core_math_Plane3D;
away3d_core_math_Plane3D.__name__ = "away3d.core.math.Plane3D";
away3d_core_math_Plane3D.prototype = {
	a: null
	,b: null
	,c: null
	,d: null
	,_alignment: null
	,fromPoints: function(p0,p1,p2) {
		var d1x = p1.x - p0.x;
		var d1y = p1.y - p0.y;
		var d1z = p1.z - p0.z;
		var d2x = p2.x - p0.x;
		var d2y = p2.y - p0.y;
		var d2z = p2.z - p0.z;
		this.a = d1y * d2z - d1z * d2y;
		this.b = d1z * d2x - d1x * d2z;
		this.c = d1x * d2y - d1y * d2x;
		this.d = this.a * p0.x + this.b * p0.y + this.c * p0.z;
		if(this.a == 0 && this.b == 0) {
			this._alignment = 1;
		} else if(this.b == 0 && this.c == 0) {
			this._alignment = 2;
		} else if(this.a == 0 && this.c == 0) {
			this._alignment = 3;
		} else {
			this._alignment = 0;
		}
	}
	,fromNormalAndPoint: function(normal,point) {
		this.a = normal.x;
		this.b = normal.y;
		this.c = normal.z;
		this.d = this.a * point.x + this.b * point.y + this.c * point.z;
		if(this.a == 0 && this.b == 0) {
			this._alignment = 1;
		} else if(this.b == 0 && this.c == 0) {
			this._alignment = 2;
		} else if(this.a == 0 && this.c == 0) {
			this._alignment = 3;
		} else {
			this._alignment = 0;
		}
	}
	,normalize: function() {
		var len = 1 / Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c);
		this.a *= len;
		this.b *= len;
		this.c *= len;
		this.d *= len;
		return this;
	}
	,distance: function(p) {
		if(this._alignment == 2) {
			return this.a * p.x - this.d;
		} else if(this._alignment == 3) {
			return this.b * p.y - this.d;
		} else if(this._alignment == 1) {
			return this.c * p.z - this.d;
		} else {
			return this.a * p.x + this.b * p.y + this.c * p.z - this.d;
		}
	}
	,classifyPoint: function(p,epsilon) {
		if(epsilon == null) {
			epsilon = 0.01;
		}
		if(this.d != this.d) {
			return 1;
		}
		var len;
		if(this._alignment == 2) {
			len = this.a * p.x - this.d;
		} else if(this._alignment == 3) {
			len = this.b * p.y - this.d;
		} else if(this._alignment == 1) {
			len = this.c * p.z - this.d;
		} else {
			len = this.a * p.x + this.b * p.y + this.c * p.z - this.d;
		}
		if(len < -epsilon) {
			return 0;
		} else if(len > epsilon) {
			return 1;
		} else {
			return 2;
		}
	}
	,toString: function() {
		return "Plane3D [a:" + this.a + ", b:" + this.b + ", c:" + this.c + ", d:" + this.d + "].";
	}
	,__class__: away3d_core_math_Plane3D
};
var away3d_core_math_PlaneClassification = function() { };
$hxClasses["away3d.core.math.PlaneClassification"] = away3d_core_math_PlaneClassification;
away3d_core_math_PlaneClassification.__name__ = "away3d.core.math.PlaneClassification";
var away3d_core_math_Quaternion = function(x,y,z,w) {
	if(w == null) {
		w = 1;
	}
	if(z == null) {
		z = 0;
	}
	if(y == null) {
		y = 0;
	}
	if(x == null) {
		x = 0;
	}
	this.x = x;
	this.y = y;
	this.z = z;
	this.w = w;
};
$hxClasses["away3d.core.math.Quaternion"] = away3d_core_math_Quaternion;
away3d_core_math_Quaternion.__name__ = "away3d.core.math.Quaternion";
away3d_core_math_Quaternion.prototype = {
	x: null
	,y: null
	,z: null
	,w: null
	,get_magnitude: function() {
		return Math.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
	}
	,multiply: function(qa,qb) {
		var w1 = qa.w;
		var x1 = qa.x;
		var y1 = qa.y;
		var z1 = qa.z;
		var w2 = qb.w;
		var x2 = qb.x;
		var y2 = qb.y;
		var z2 = qb.z;
		this.w = w1 * w2 - x1 * x2 - y1 * y2 - z1 * z2;
		this.x = w1 * x2 + x1 * w2 + y1 * z2 - z1 * y2;
		this.y = w1 * y2 - x1 * z2 + y1 * w2 + z1 * x2;
		this.z = w1 * z2 + x1 * y2 - y1 * x2 + z1 * w2;
	}
	,multiplyVector: function(vector,target) {
		if(target == null) {
			target = new away3d_core_math_Quaternion();
		}
		var x2 = vector.x;
		var y2 = vector.y;
		var z2 = vector.z;
		target.w = -this.x * x2 - this.y * y2 - this.z * z2;
		target.x = this.w * x2 + this.y * z2 - this.z * y2;
		target.y = this.w * y2 - this.x * z2 + this.z * x2;
		target.z = this.w * z2 + this.x * y2 - this.y * x2;
		return target;
	}
	,fromAxisAngle: function(axis,angle) {
		var sin_a = Math.sin(angle / 2);
		var cos_a = Math.cos(angle / 2);
		this.x = axis.x * sin_a;
		this.y = axis.y * sin_a;
		this.z = axis.z * sin_a;
		this.w = cos_a;
		this.normalize();
	}
	,slerp: function(qa,qb,t) {
		var w1 = qa.w;
		var x1 = qa.x;
		var y1 = qa.y;
		var z1 = qa.z;
		var w2 = qb.w;
		var x2 = qb.x;
		var y2 = qb.y;
		var z2 = qb.z;
		var dot = w1 * w2 + x1 * x2 + y1 * y2 + z1 * z2;
		if(dot < 0) {
			dot = -dot;
			w2 = -w2;
			x2 = -x2;
			y2 = -y2;
			z2 = -z2;
		}
		if(dot < 0.95) {
			var angle = Math.acos(dot);
			var s = 1 / Math.sin(angle);
			var s1 = Math.sin(angle * (1 - t)) * s;
			var s2 = Math.sin(angle * t) * s;
			this.w = w1 * s1 + w2 * s2;
			this.x = x1 * s1 + x2 * s2;
			this.y = y1 * s1 + y2 * s2;
			this.z = z1 * s1 + z2 * s2;
		} else {
			this.w = w1 + t * (w2 - w1);
			this.x = x1 + t * (x2 - x1);
			this.y = y1 + t * (y2 - y1);
			this.z = z1 + t * (z2 - z1);
			var len = 1.0 / Math.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
			this.w *= len;
			this.x *= len;
			this.y *= len;
			this.z *= len;
		}
	}
	,lerp: function(qa,qb,t) {
		var w1 = qa.w;
		var x1 = qa.x;
		var y1 = qa.y;
		var z1 = qa.z;
		var w2 = qb.w;
		var x2 = qb.x;
		var y2 = qb.y;
		var z2 = qb.z;
		if(w1 * w2 + x1 * x2 + y1 * y2 + z1 * z2 < 0) {
			w2 = -w2;
			x2 = -x2;
			y2 = -y2;
			z2 = -z2;
		}
		this.w = w1 + t * (w2 - w1);
		this.x = x1 + t * (x2 - x1);
		this.y = y1 + t * (y2 - y1);
		this.z = z1 + t * (z2 - z1);
		var len = 1.0 / Math.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
		this.w *= len;
		this.x *= len;
		this.y *= len;
		this.z *= len;
	}
	,fromEulerAngles: function(ax,ay,az) {
		var halfX = ax * .5;
		var halfY = ay * .5;
		var halfZ = az * .5;
		var cosX = Math.cos(halfX);
		var sinX = Math.sin(halfX);
		var cosY = Math.cos(halfY);
		var sinY = Math.sin(halfY);
		var cosZ = Math.cos(halfZ);
		var sinZ = Math.sin(halfZ);
		this.w = cosX * cosY * cosZ + sinX * sinY * sinZ;
		this.x = sinX * cosY * cosZ - cosX * sinY * sinZ;
		this.y = cosX * sinY * cosZ + sinX * cosY * sinZ;
		this.z = cosX * cosY * sinZ - sinX * sinY * cosZ;
	}
	,toEulerAngles: function(target) {
		if(target == null) {
			target = new openfl_geom_Vector3D();
		}
		target.x = Math.atan2(2 * (this.w * this.x + this.y * this.z),1 - 2 * (this.x * this.x + this.y * this.y));
		target.y = Math.asin(2 * (this.w * this.y - this.z * this.x));
		target.z = Math.atan2(2 * (this.w * this.z + this.x * this.y),1 - 2 * (this.y * this.y + this.z * this.z));
		return target;
	}
	,normalize: function(val) {
		if(val == null) {
			val = 1;
		}
		var mag = val / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
		this.x *= mag;
		this.y *= mag;
		this.z *= mag;
		this.w *= mag;
	}
	,toString: function() {
		return "{x:" + this.x + " y:" + this.y + " z:" + this.z + " w:" + this.w + "}";
	}
	,toMatrix3D: function(target) {
		var rawData = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
		var xy2 = 2.0 * this.x * this.y;
		var xz2 = 2.0 * this.x * this.z;
		var xw2 = 2.0 * this.x * this.w;
		var yz2 = 2.0 * this.y * this.z;
		var yw2 = 2.0 * this.y * this.w;
		var zw2 = 2.0 * this.z * this.w;
		var xx = this.x * this.x;
		var yy = this.y * this.y;
		var zz = this.z * this.z;
		var ww = this.w * this.w;
		rawData.set(0,xx - yy - zz + ww);
		rawData.set(4,xy2 - zw2);
		rawData.set(8,xz2 + yw2);
		rawData.set(12,0);
		rawData.set(1,xy2 + zw2);
		rawData.set(5,-xx + yy - zz + ww);
		rawData.set(9,yz2 - xw2);
		rawData.set(13,0);
		rawData.set(2,xz2 - yw2);
		rawData.set(6,yz2 + xw2);
		rawData.set(10,-xx - yy + zz + ww);
		rawData.set(14,0);
		rawData.set(3,0.0);
		rawData.set(7,0.0);
		rawData.set(11,0);
		rawData.set(15,1);
		if(target == null) {
			return new openfl_geom_Matrix3D(rawData);
		}
		target.copyRawDataFrom(rawData);
		return target;
	}
	,fromMatrix: function(matrix) {
		var v = matrix.decompose(2).get(1);
		this.x = v.x;
		this.y = v.y;
		this.z = v.z;
		this.w = v.w;
	}
	,toRawData: function(target,exclude4thRow) {
		if(exclude4thRow == null) {
			exclude4thRow = false;
		}
		var xy2 = 2.0 * this.x * this.y;
		var xz2 = 2.0 * this.x * this.z;
		var xw2 = 2.0 * this.x * this.w;
		var yz2 = 2.0 * this.y * this.z;
		var yw2 = 2.0 * this.y * this.w;
		var zw2 = 2.0 * this.z * this.w;
		var xx = this.x * this.x;
		var yy = this.y * this.y;
		var zz = this.z * this.z;
		var ww = this.w * this.w;
		target.set(0,xx - yy - zz + ww);
		target.set(1,xy2 - zw2);
		target.set(2,xz2 + yw2);
		target.set(4,xy2 + zw2);
		target.set(5,-xx + yy - zz + ww);
		target.set(6,yz2 - xw2);
		target.set(8,xz2 - yw2);
		target.set(9,yz2 + xw2);
		target.set(10,-xx - yy + zz + ww);
		target.set(3,target.set(7,target.set(11,0)));
		if(!exclude4thRow) {
			target.set(12,target.set(13,target.set(14,0)));
			target.set(15,1);
		}
	}
	,clone: function() {
		return new away3d_core_math_Quaternion(this.x,this.y,this.z,this.w);
	}
	,rotatePoint: function(vector,target) {
		var x2 = vector.x;
		var y2 = vector.y;
		var z2 = vector.z;
		if(target == null) {
			target = new openfl_geom_Vector3D();
		}
		var w1 = -this.x * x2 - this.y * y2 - this.z * z2;
		var x1 = this.w * x2 + this.y * z2 - this.z * y2;
		var y1 = this.w * y2 - this.x * z2 + this.z * x2;
		var z1 = this.w * z2 + this.x * y2 - this.y * x2;
		target.x = -w1 * this.x + x1 * this.w - y1 * this.z + z1 * this.y;
		target.y = -w1 * this.y + x1 * this.z + y1 * this.w - z1 * this.x;
		target.z = -w1 * this.z - x1 * this.y + y1 * this.x + z1 * this.w;
		return target;
	}
	,copyFrom: function(q) {
		this.x = q.x;
		this.y = q.y;
		this.z = q.z;
		this.w = q.w;
	}
	,__class__: away3d_core_math_Quaternion
	,__properties__: {get_magnitude:"get_magnitude"}
};
var away3d_core_partition_NodeBase = function() {
	this._childNodes = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this._numEntities = 0;
	this._collectionMark = 0;
	this._numChildNodes = 0;
};
$hxClasses["away3d.core.partition.NodeBase"] = away3d_core_partition_NodeBase;
away3d_core_partition_NodeBase.__name__ = "away3d.core.partition.NodeBase";
away3d_core_partition_NodeBase.prototype = {
	_parent: null
	,_childNodes: null
	,_numChildNodes: null
	,_debugPrimitive: null
	,_numEntities: null
	,_collectionMark: null
	,get_showDebugBounds: function() {
		return this._debugPrimitive != null;
	}
	,set_showDebugBounds: function(value) {
		if(this._debugPrimitive != null == value) {
			return value;
		}
		if(value) {
			this._debugPrimitive = this.createDebugBounds();
		} else {
			this._debugPrimitive.dispose();
			this._debugPrimitive = null;
		}
		var _g = 0;
		var _g1 = this._numChildNodes;
		while(_g < _g1) {
			var i = _g++;
			this._childNodes.get(i).set_showDebugBounds(value);
		}
		return value;
	}
	,get_parent: function() {
		return this._parent;
	}
	,addNode: function(node) {
		node._parent = this;
		this._numEntities += node._numEntities;
		this._childNodes.set(this._numChildNodes++,node);
		node.set_showDebugBounds(this._debugPrimitive != null);
		var numEntities = node._numEntities;
		node = this;
		while(true) {
			node._numEntities += numEntities;
			node = node._parent;
			if(!(node != null)) {
				break;
			}
		}
	}
	,removeNode: function(node) {
		var index = this._childNodes.indexOf(node,0);
		this._childNodes.set(index,this._childNodes.get(--this._numChildNodes));
		this._childNodes.pop();
		var numEntities = node._numEntities;
		node = this;
		while(true) {
			node._numEntities -= numEntities;
			node = node._parent;
			if(!(node != null)) {
				break;
			}
		}
	}
	,isInFrustum: function(planes,numPlanes) {
		return true;
	}
	,isIntersectingRay: function(rayPosition,rayDirection) {
		return true;
	}
	,findPartitionForEntity: function(entity) {
		return this;
	}
	,acceptTraverser: function(traverser) {
		if(this._numEntities == 0 && this._debugPrimitive == null) {
			return;
		}
		if(traverser.enterNode(this)) {
			var i = 0;
			while(i < this._numChildNodes) this._childNodes.get(i++).acceptTraverser(traverser);
			if(this._debugPrimitive != null) {
				traverser.applyRenderable(this._debugPrimitive);
			}
		}
	}
	,createDebugBounds: function() {
		return null;
	}
	,get_numEntities: function() {
		return this._numEntities;
	}
	,updateNumEntities: function(value) {
		var diff = value - this._numEntities;
		var node = this;
		while(true) {
			node._numEntities += diff;
			node = node._parent;
			if(!(node != null)) {
				break;
			}
		}
	}
	,__class__: away3d_core_partition_NodeBase
	,__properties__: {get_numEntities:"get_numEntities",get_parent:"get_parent",set_showDebugBounds:"set_showDebugBounds",get_showDebugBounds:"get_showDebugBounds"}
};
var away3d_core_partition_EntityNode = function(entity) {
	away3d_core_partition_NodeBase.call(this);
	this._entity = entity;
	this._numEntities = 1;
};
$hxClasses["away3d.core.partition.EntityNode"] = away3d_core_partition_EntityNode;
away3d_core_partition_EntityNode.__name__ = "away3d.core.partition.EntityNode";
away3d_core_partition_EntityNode.__super__ = away3d_core_partition_NodeBase;
away3d_core_partition_EntityNode.prototype = $extend(away3d_core_partition_NodeBase.prototype,{
	_entity: null
	,_updateQueueNext: null
	,get_entity: function() {
		return this._entity;
	}
	,acceptTraverser: function(traverser) {
		traverser.applyEntity(this._entity);
	}
	,removeFromParent: function() {
		if(this._parent != null) {
			this._parent.removeNode(this);
		}
		this._parent = null;
	}
	,isInFrustum: function(planes,numPlanes) {
		if(!this._entity.get_isVisible()) {
			return false;
		}
		return this._entity.get_worldBounds().isInFrustum(planes,numPlanes);
	}
	,isIntersectingRay: function(rayPosition,rayDirection) {
		if(!this._entity.get_isVisible()) {
			return false;
		}
		return this._entity.isIntersectingRay(rayPosition,rayDirection);
	}
	,__class__: away3d_core_partition_EntityNode
	,__properties__: $extend(away3d_core_partition_NodeBase.prototype.__properties__,{get_entity:"get_entity"})
});
var away3d_core_partition_CameraNode = function(camera) {
	away3d_core_partition_EntityNode.call(this,camera);
};
$hxClasses["away3d.core.partition.CameraNode"] = away3d_core_partition_CameraNode;
away3d_core_partition_CameraNode.__name__ = "away3d.core.partition.CameraNode";
away3d_core_partition_CameraNode.__super__ = away3d_core_partition_EntityNode;
away3d_core_partition_CameraNode.prototype = $extend(away3d_core_partition_EntityNode.prototype,{
	acceptTraverser: function(traverser) {
	}
	,__class__: away3d_core_partition_CameraNode
});
var away3d_core_partition_DirectionalLightNode = function(light) {
	away3d_core_partition_EntityNode.call(this,light);
	this._light = light;
};
$hxClasses["away3d.core.partition.DirectionalLightNode"] = away3d_core_partition_DirectionalLightNode;
away3d_core_partition_DirectionalLightNode.__name__ = "away3d.core.partition.DirectionalLightNode";
away3d_core_partition_DirectionalLightNode.__super__ = away3d_core_partition_EntityNode;
away3d_core_partition_DirectionalLightNode.prototype = $extend(away3d_core_partition_EntityNode.prototype,{
	_light: null
	,get_light: function() {
		return this._light;
	}
	,acceptTraverser: function(traverser) {
		if(traverser.enterNode(this)) {
			away3d_core_partition_EntityNode.prototype.acceptTraverser.call(this,traverser);
			traverser.applyDirectionalLight(this._light);
		}
	}
	,__class__: away3d_core_partition_DirectionalLightNode
	,__properties__: $extend(away3d_core_partition_EntityNode.prototype.__properties__,{get_light:"get_light"})
});
var away3d_core_partition_LightNode = function(light) {
	away3d_core_partition_EntityNode.call(this,light);
	this._light = light;
};
$hxClasses["away3d.core.partition.LightNode"] = away3d_core_partition_LightNode;
away3d_core_partition_LightNode.__name__ = "away3d.core.partition.LightNode";
away3d_core_partition_LightNode.__super__ = away3d_core_partition_EntityNode;
away3d_core_partition_LightNode.prototype = $extend(away3d_core_partition_EntityNode.prototype,{
	_light: null
	,get_light: function() {
		return this._light;
	}
	,acceptTraverser: function(traverser) {
		if(traverser.enterNode(this)) {
			away3d_core_partition_EntityNode.prototype.acceptTraverser.call(this,traverser);
			traverser.applyUnknownLight(this._light);
		}
	}
	,__class__: away3d_core_partition_LightNode
	,__properties__: $extend(away3d_core_partition_EntityNode.prototype.__properties__,{get_light:"get_light"})
});
var away3d_core_partition_LightProbeNode = function(light) {
	away3d_core_partition_EntityNode.call(this,light);
	this._light = light;
};
$hxClasses["away3d.core.partition.LightProbeNode"] = away3d_core_partition_LightProbeNode;
away3d_core_partition_LightProbeNode.__name__ = "away3d.core.partition.LightProbeNode";
away3d_core_partition_LightProbeNode.__super__ = away3d_core_partition_EntityNode;
away3d_core_partition_LightProbeNode.prototype = $extend(away3d_core_partition_EntityNode.prototype,{
	_light: null
	,get_light: function() {
		return this._light;
	}
	,acceptTraverser: function(traverser) {
		if(traverser.enterNode(this)) {
			away3d_core_partition_EntityNode.prototype.acceptTraverser.call(this,traverser);
			traverser.applyLightProbe(this._light);
		}
	}
	,__class__: away3d_core_partition_LightProbeNode
	,__properties__: $extend(away3d_core_partition_EntityNode.prototype.__properties__,{get_light:"get_light"})
});
var away3d_core_partition_MeshNode = function(mesh) {
	away3d_core_partition_EntityNode.call(this,mesh);
	this._mesh = mesh;
};
$hxClasses["away3d.core.partition.MeshNode"] = away3d_core_partition_MeshNode;
away3d_core_partition_MeshNode.__name__ = "away3d.core.partition.MeshNode";
away3d_core_partition_MeshNode.__super__ = away3d_core_partition_EntityNode;
away3d_core_partition_MeshNode.prototype = $extend(away3d_core_partition_EntityNode.prototype,{
	_mesh: null
	,get_mesh: function() {
		return this._mesh;
	}
	,acceptTraverser: function(traverser) {
		if(traverser.enterNode(this)) {
			away3d_core_partition_EntityNode.prototype.acceptTraverser.call(this,traverser);
			var subs = this._mesh.get_subMeshes();
			var i = 0;
			var len = subs.get_length();
			while(i < len) traverser.applyRenderable(subs.get(i++));
		}
	}
	,__class__: away3d_core_partition_MeshNode
	,__properties__: $extend(away3d_core_partition_EntityNode.prototype.__properties__,{get_mesh:"get_mesh"})
});
var away3d_core_partition_NullNode = function() {
	away3d_core_partition_NodeBase.call(this);
};
$hxClasses["away3d.core.partition.NullNode"] = away3d_core_partition_NullNode;
away3d_core_partition_NullNode.__name__ = "away3d.core.partition.NullNode";
away3d_core_partition_NullNode.__super__ = away3d_core_partition_NodeBase;
away3d_core_partition_NullNode.prototype = $extend(away3d_core_partition_NodeBase.prototype,{
	__class__: away3d_core_partition_NullNode
});
var away3d_core_partition_Partition3D = function(rootNode) {
	this._rootNode = rootNode;
	if(rootNode == null) {
		this._rootNode = new away3d_core_partition_NullNode();
	}
};
$hxClasses["away3d.core.partition.Partition3D"] = away3d_core_partition_Partition3D;
away3d_core_partition_Partition3D.__name__ = "away3d.core.partition.Partition3D";
away3d_core_partition_Partition3D.prototype = {
	_rootNode: null
	,_updatesMade: null
	,_updateQueue: null
	,get_showDebugBounds: function() {
		return this._rootNode.get_showDebugBounds();
	}
	,set_showDebugBounds: function(value) {
		this._rootNode.set_showDebugBounds(value);
		return value;
	}
	,traverse: function(traverser) {
		if(this._updatesMade) {
			this.updateEntities();
		}
		++away3d_core_traverse_PartitionTraverser._collectionMark;
		this._rootNode.acceptTraverser(traverser);
	}
	,markForUpdate: function(entity) {
		var node = entity.getEntityPartitionNode();
		var t = this._updateQueue;
		while(t != null) {
			if(node == t) {
				return;
			}
			t = t._updateQueueNext;
		}
		node._updateQueueNext = this._updateQueue;
		this._updateQueue = node;
		this._updatesMade = true;
	}
	,removeEntity: function(entity) {
		var node = entity.getEntityPartitionNode();
		var t;
		node.removeFromParent();
		if(node == this._updateQueue) {
			this._updateQueue = node._updateQueueNext;
		} else {
			t = this._updateQueue;
			while(t != null && t._updateQueueNext != node) t = t._updateQueueNext;
			if(t != null) {
				t._updateQueueNext = node._updateQueueNext;
			}
		}
		node._updateQueueNext = null;
		if(this._updateQueue == null) {
			this._updatesMade = false;
		}
	}
	,updateEntities: function() {
		var node = this._updateQueue;
		var targetNode;
		var t;
		this._updateQueue = null;
		this._updatesMade = false;
		while(true) {
			targetNode = this._rootNode.findPartitionForEntity(node.get_entity());
			if(node.get_parent() != targetNode) {
				if(node != null) {
					node.removeFromParent();
				}
				targetNode.addNode(node);
			}
			t = node._updateQueueNext;
			node._updateQueueNext = null;
			node.get_entity().internalUpdate();
			node = t;
			if(!(node != null)) {
				break;
			}
		}
	}
	,__class__: away3d_core_partition_Partition3D
	,__properties__: {set_showDebugBounds:"set_showDebugBounds",get_showDebugBounds:"get_showDebugBounds"}
};
var away3d_core_partition_PointLightNode = function(light) {
	away3d_core_partition_EntityNode.call(this,light);
	this._light = light;
};
$hxClasses["away3d.core.partition.PointLightNode"] = away3d_core_partition_PointLightNode;
away3d_core_partition_PointLightNode.__name__ = "away3d.core.partition.PointLightNode";
away3d_core_partition_PointLightNode.__super__ = away3d_core_partition_EntityNode;
away3d_core_partition_PointLightNode.prototype = $extend(away3d_core_partition_EntityNode.prototype,{
	_light: null
	,get_light: function() {
		return this._light;
	}
	,acceptTraverser: function(traverser) {
		if(traverser.enterNode(this)) {
			away3d_core_partition_EntityNode.prototype.acceptTraverser.call(this,traverser);
			traverser.applyPointLight(this._light);
		}
	}
	,__class__: away3d_core_partition_PointLightNode
	,__properties__: $extend(away3d_core_partition_EntityNode.prototype.__properties__,{get_light:"get_light"})
});
var away3d_core_partition_RenderableNode = function(renderable) {
	away3d_core_partition_EntityNode.call(this,js_Boot.__cast(renderable , away3d_entities_Entity));
	this._renderable = renderable;
};
$hxClasses["away3d.core.partition.RenderableNode"] = away3d_core_partition_RenderableNode;
away3d_core_partition_RenderableNode.__name__ = "away3d.core.partition.RenderableNode";
away3d_core_partition_RenderableNode.__super__ = away3d_core_partition_EntityNode;
away3d_core_partition_RenderableNode.prototype = $extend(away3d_core_partition_EntityNode.prototype,{
	_renderable: null
	,acceptTraverser: function(traverser) {
		if(traverser.enterNode(this)) {
			away3d_core_partition_EntityNode.prototype.acceptTraverser.call(this,traverser);
			traverser.applyRenderable(this._renderable);
		}
	}
	,__class__: away3d_core_partition_RenderableNode
});
var away3d_core_pick_IPicker = function() { };
$hxClasses["away3d.core.pick.IPicker"] = away3d_core_pick_IPicker;
away3d_core_pick_IPicker.__name__ = "away3d.core.pick.IPicker";
away3d_core_pick_IPicker.__isInterface__ = true;
away3d_core_pick_IPicker.prototype = {
	get_onlyMouseEnabled: null
	,set_onlyMouseEnabled: null
	,getViewCollision: null
	,getSceneCollision: null
	,dispose: null
	,__class__: away3d_core_pick_IPicker
	,__properties__: {set_onlyMouseEnabled:"set_onlyMouseEnabled",get_onlyMouseEnabled:"get_onlyMouseEnabled"}
};
var away3d_core_pick_IPickingCollider = function() { };
$hxClasses["away3d.core.pick.IPickingCollider"] = away3d_core_pick_IPickingCollider;
away3d_core_pick_IPickingCollider.__name__ = "away3d.core.pick.IPickingCollider";
away3d_core_pick_IPickingCollider.__isInterface__ = true;
away3d_core_pick_IPickingCollider.prototype = {
	setLocalRay: null
	,testSubMeshCollision: null
	,__class__: away3d_core_pick_IPickingCollider
};
var away3d_core_pick_PickingCollisionVO = function(entity) {
	this.entity = entity;
};
$hxClasses["away3d.core.pick.PickingCollisionVO"] = away3d_core_pick_PickingCollisionVO;
away3d_core_pick_PickingCollisionVO.__name__ = "away3d.core.pick.PickingCollisionVO";
away3d_core_pick_PickingCollisionVO.prototype = {
	entity: null
	,localPosition: null
	,localNormal: null
	,uv: null
	,index: null
	,subGeometryIndex: null
	,localRayPosition: null
	,localRayDirection: null
	,rayPosition: null
	,rayDirection: null
	,rayOriginIsInsideBounds: null
	,rayEntryDistance: null
	,renderable: null
	,__class__: away3d_core_pick_PickingCollisionVO
};
var away3d_core_pick_RaycastPicker = function(findClosestCollision) {
	this._onlyMouseEnabled = true;
	this._ignoredEntities = [];
	this._raycastCollector = new away3d_core_traverse_RaycastCollector();
	this._findClosestCollision = findClosestCollision;
	this._entities = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
};
$hxClasses["away3d.core.pick.RaycastPicker"] = away3d_core_pick_RaycastPicker;
away3d_core_pick_RaycastPicker.__name__ = "away3d.core.pick.RaycastPicker";
away3d_core_pick_RaycastPicker.__interfaces__ = [away3d_core_pick_IPicker];
away3d_core_pick_RaycastPicker.prototype = {
	_findClosestCollision: null
	,_raycastCollector: null
	,_ignoredEntities: null
	,_onlyMouseEnabled: null
	,_entities: null
	,_numEntities: null
	,_hasCollisions: null
	,get_onlyMouseEnabled: function() {
		return this._onlyMouseEnabled;
	}
	,set_onlyMouseEnabled: function(value) {
		this._onlyMouseEnabled = value;
		return value;
	}
	,getViewCollision: function(x,y,view) {
		var collector = view.get_entityCollector();
		if(collector.get_numMouseEnableds() == 0) {
			return null;
		}
		var rayPosition = view.unproject(x,y,0,away3d_core_pick_RaycastPicker.tempRayPosition);
		var rayDirection = view.unproject(x,y,1,away3d_core_pick_RaycastPicker.tempRayDirection);
		rayDirection.x -= rayPosition.x;
		rayDirection.y -= rayPosition.y;
		rayDirection.z -= rayPosition.z;
		this._numEntities = 0;
		var node = collector.get_entityHead();
		var entity;
		while(node != null) {
			entity = node.entity;
			if(this.isIgnored(entity)) {
				node = node.next;
				continue;
			}
			if(entity.get_isVisible() && entity.isIntersectingRay(rayPosition,rayDirection)) {
				this._entities.set(this._numEntities++,entity);
			}
			node = node.next;
		}
		if(this._numEntities == 0) {
			return null;
		}
		return this.getPickingCollisionVO();
	}
	,getSceneCollision: function(position,direction,scene) {
		this._raycastCollector.clear();
		this._raycastCollector.set_rayPosition(position);
		this._raycastCollector.set_rayDirection(direction);
		scene.traversePartitions(this._raycastCollector);
		this._numEntities = 0;
		var node = this._raycastCollector.get_entityHead();
		var entity;
		while(node != null) {
			entity = node.entity;
			if(this.isIgnored(entity)) {
				node = node.next;
				continue;
			}
			this._entities.set(this._numEntities++,entity);
			node = node.next;
		}
		if(this._numEntities == 0) {
			return null;
		}
		return this.getPickingCollisionVO();
	}
	,getEntityCollision: function(position,direction,entities) {
		this._numEntities = 0;
		var entity;
		var _g = 0;
		while(_g < entities.length) {
			var entity1 = entities[_g];
			++_g;
			if(entity1.isIntersectingRay(position,direction)) {
				this._entities.set(this._numEntities++,entity1);
			}
		}
		return this.getPickingCollisionVO();
	}
	,setIgnoreList: function(entities) {
		this._ignoredEntities = entities;
	}
	,isIgnored: function(entity) {
		if(this._onlyMouseEnabled && (!entity._ancestorsAllowMouseEnabled || !entity.get_mouseEnabled())) {
			return true;
		}
		var ignoredEntity;
		var _g = 0;
		var _g1 = this._ignoredEntities;
		while(_g < _g1.length) {
			var ignoredEntity1 = _g1[_g];
			++_g;
			if(ignoredEntity1 == entity) {
				return true;
			}
		}
		return false;
	}
	,sortOnNearT: function(entity1,entity2) {
		if(entity1.get_pickingCollisionVO().rayEntryDistance > entity2.get_pickingCollisionVO().rayEntryDistance) {
			return 1;
		} else {
			return -1;
		}
	}
	,getPickingCollisionVO: function() {
		this._entities.set_length(this._numEntities);
		this._entities.sort($bind(this,this.sortOnNearT));
		var shortestCollisionDistance = Infinity;
		var bestCollisionVO = null;
		var pickingCollisionVO;
		var entity;
		var i;
		var _g = 0;
		var _g1 = this._numEntities;
		while(_g < _g1) {
			var i1 = _g++;
			entity = this._entities.get(i1);
			pickingCollisionVO = entity._pickingCollisionVO;
			if(entity.get_pickingCollider() != null) {
				if((bestCollisionVO == null || pickingCollisionVO.rayEntryDistance < bestCollisionVO.rayEntryDistance) && entity.collidesBefore(shortestCollisionDistance,this._findClosestCollision)) {
					shortestCollisionDistance = pickingCollisionVO.rayEntryDistance;
					bestCollisionVO = pickingCollisionVO;
					if(!this._findClosestCollision) {
						this.updateLocalPosition(pickingCollisionVO);
						return pickingCollisionVO;
					}
				}
			} else if(bestCollisionVO == null || pickingCollisionVO.rayEntryDistance < bestCollisionVO.rayEntryDistance) {
				if(!pickingCollisionVO.rayOriginIsInsideBounds) {
					this.updateLocalPosition(pickingCollisionVO);
					return pickingCollisionVO;
				}
			}
		}
		return bestCollisionVO;
	}
	,updateLocalPosition: function(pickingCollisionVO) {
		if(pickingCollisionVO.localPosition == null) {
			pickingCollisionVO.localPosition = new openfl_geom_Vector3D();
		}
		var collisionPos = pickingCollisionVO.localPosition;
		var rayDir = pickingCollisionVO.localRayDirection;
		var rayPos = pickingCollisionVO.localRayPosition;
		var t = pickingCollisionVO.rayEntryDistance;
		collisionPos.x = rayPos.x + t * rayDir.x;
		collisionPos.y = rayPos.y + t * rayDir.y;
		collisionPos.z = rayPos.z + t * rayDir.z;
	}
	,dispose: function() {
	}
	,__class__: away3d_core_pick_RaycastPicker
	,__properties__: {set_onlyMouseEnabled:"set_onlyMouseEnabled",get_onlyMouseEnabled:"get_onlyMouseEnabled"}
};
var openfl_geom_Rectangle = function(x,y,width,height) {
	if(height == null) {
		height = 0;
	}
	if(width == null) {
		width = 0;
	}
	if(y == null) {
		y = 0;
	}
	if(x == null) {
		x = 0;
	}
	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;
};
$hxClasses["openfl.geom.Rectangle"] = openfl_geom_Rectangle;
openfl_geom_Rectangle.__name__ = "openfl.geom.Rectangle";
openfl_geom_Rectangle.prototype = {
	height: null
	,width: null
	,x: null
	,y: null
	,clone: function() {
		return new openfl_geom_Rectangle(this.x,this.y,this.width,this.height);
	}
	,contains: function(x,y) {
		if(x >= this.x && y >= this.y && x < this.get_right()) {
			return y < this.get_bottom();
		} else {
			return false;
		}
	}
	,containsPoint: function(point) {
		return this.contains(point.x,point.y);
	}
	,containsRect: function(rect) {
		if(rect.width <= 0 || rect.height <= 0) {
			if(rect.x > this.x && rect.y > this.y && rect.get_right() < this.get_right()) {
				return rect.get_bottom() < this.get_bottom();
			} else {
				return false;
			}
		} else if(rect.x >= this.x && rect.y >= this.y && rect.get_right() <= this.get_right()) {
			return rect.get_bottom() <= this.get_bottom();
		} else {
			return false;
		}
	}
	,copyFrom: function(sourceRect) {
		this.x = sourceRect.x;
		this.y = sourceRect.y;
		this.width = sourceRect.width;
		this.height = sourceRect.height;
	}
	,equals: function(toCompare) {
		if(toCompare == this) {
			return true;
		} else if(toCompare != null && this.x == toCompare.x && this.y == toCompare.y && this.width == toCompare.width) {
			return this.height == toCompare.height;
		} else {
			return false;
		}
	}
	,inflate: function(dx,dy) {
		this.x -= dx;
		this.width += dx * 2;
		this.y -= dy;
		this.height += dy * 2;
	}
	,inflatePoint: function(point) {
		this.inflate(point.x,point.y);
	}
	,intersection: function(toIntersect) {
		var x0 = this.x < toIntersect.x ? toIntersect.x : this.x;
		var x1 = this.get_right() > toIntersect.get_right() ? toIntersect.get_right() : this.get_right();
		if(x1 <= x0) {
			return new openfl_geom_Rectangle();
		}
		var y0 = this.y < toIntersect.y ? toIntersect.y : this.y;
		var y1 = this.get_bottom() > toIntersect.get_bottom() ? toIntersect.get_bottom() : this.get_bottom();
		if(y1 <= y0) {
			return new openfl_geom_Rectangle();
		}
		return new openfl_geom_Rectangle(x0,y0,x1 - x0,y1 - y0);
	}
	,intersects: function(toIntersect) {
		var x0 = this.x < toIntersect.x ? toIntersect.x : this.x;
		var x1 = this.get_right() > toIntersect.get_right() ? toIntersect.get_right() : this.get_right();
		if(x1 <= x0) {
			return false;
		}
		var y0 = this.y < toIntersect.y ? toIntersect.y : this.y;
		var y1 = this.get_bottom() > toIntersect.get_bottom() ? toIntersect.get_bottom() : this.get_bottom();
		return y1 > y0;
	}
	,isEmpty: function() {
		if(!(this.width <= 0)) {
			return this.height <= 0;
		} else {
			return true;
		}
	}
	,offset: function(dx,dy) {
		this.x += dx;
		this.y += dy;
	}
	,offsetPoint: function(point) {
		this.x += point.x;
		this.y += point.y;
	}
	,setEmpty: function() {
		this.x = this.y = this.width = this.height = 0;
	}
	,setTo: function(xa,ya,widtha,heighta) {
		this.x = xa;
		this.y = ya;
		this.width = widtha;
		this.height = heighta;
	}
	,toString: function() {
		return "(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ")";
	}
	,union: function(toUnion) {
		if(this.width == 0 || this.height == 0) {
			return toUnion.clone();
		} else if(toUnion.width == 0 || toUnion.height == 0) {
			return this.clone();
		}
		var x0 = this.x > toUnion.x ? toUnion.x : this.x;
		var x1 = this.get_right() < toUnion.get_right() ? toUnion.get_right() : this.get_right();
		var y0 = this.y > toUnion.y ? toUnion.y : this.y;
		var y1 = this.get_bottom() < toUnion.get_bottom() ? toUnion.get_bottom() : this.get_bottom();
		return new openfl_geom_Rectangle(x0,y0,x1 - x0,y1 - y0);
	}
	,__contract: function(x,y,width,height) {
		if(this.width == 0 && this.height == 0) {
			return;
		}
		var offsetX = 0.0;
		var offsetY = 0.0;
		var offsetRight = 0.0;
		var offsetBottom = 0.0;
		if(this.x < x) {
			offsetX = x - this.x;
		}
		if(this.y < y) {
			offsetY = y - this.y;
		}
		if(this.get_right() > x + width) {
			offsetRight = x + width - this.get_right();
		}
		if(this.get_bottom() > y + height) {
			offsetBottom = y + height - this.get_bottom();
		}
		this.x += offsetX;
		this.y += offsetY;
		this.width += offsetRight - offsetX;
		this.height += offsetBottom - offsetY;
	}
	,__expand: function(x,y,width,height) {
		if(this.width == 0 && this.height == 0) {
			this.x = x;
			this.y = y;
			this.width = width;
			this.height = height;
			return;
		}
		var cacheRight = this.get_right();
		var cacheBottom = this.get_bottom();
		if(this.x > x) {
			this.x = x;
			this.width = cacheRight - x;
		}
		if(this.y > y) {
			this.y = y;
			this.height = cacheBottom - y;
		}
		if(cacheRight < x + width) {
			this.width = x + width - this.x;
		}
		if(cacheBottom < y + height) {
			this.height = y + height - this.y;
		}
	}
	,__toLimeRectangle: function() {
		if(openfl_geom_Rectangle.__limeRectangle == null) {
			openfl_geom_Rectangle.__limeRectangle = new lime_math_Rectangle();
		}
		openfl_geom_Rectangle.__limeRectangle.setTo(this.x,this.y,this.width,this.height);
		return openfl_geom_Rectangle.__limeRectangle;
	}
	,__transform: function(rect,m) {
		var tx0 = m.a * this.x + m.c * this.y;
		var tx1 = tx0;
		var ty0 = m.b * this.x + m.d * this.y;
		var ty1 = ty0;
		var tx = m.a * (this.x + this.width) + m.c * this.y;
		var ty = m.b * (this.x + this.width) + m.d * this.y;
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		tx = m.a * (this.x + this.width) + m.c * (this.y + this.height);
		ty = m.b * (this.x + this.width) + m.d * (this.y + this.height);
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		tx = m.a * this.x + m.c * (this.y + this.height);
		ty = m.b * this.x + m.d * (this.y + this.height);
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		rect.setTo(tx0 + m.tx,ty0 + m.ty,tx1 - tx0,ty1 - ty0);
	}
	,get_bottom: function() {
		return this.y + this.height;
	}
	,set_bottom: function(b) {
		this.height = b - this.y;
		return b;
	}
	,get_bottomRight: function() {
		return new openfl_geom_Point(this.x + this.width,this.y + this.height);
	}
	,set_bottomRight: function(p) {
		this.width = p.x - this.x;
		this.height = p.y - this.y;
		return p.clone();
	}
	,get_left: function() {
		return this.x;
	}
	,set_left: function(l) {
		this.width -= l - this.x;
		this.x = l;
		return l;
	}
	,get_right: function() {
		return this.x + this.width;
	}
	,set_right: function(r) {
		this.width = r - this.x;
		return r;
	}
	,get_size: function() {
		return new openfl_geom_Point(this.width,this.height);
	}
	,set_size: function(p) {
		this.width = p.x;
		this.height = p.y;
		return p.clone();
	}
	,get_top: function() {
		return this.y;
	}
	,set_top: function(t) {
		this.height -= t - this.y;
		this.y = t;
		return t;
	}
	,get_topLeft: function() {
		return new openfl_geom_Point(this.x,this.y);
	}
	,set_topLeft: function(p) {
		this.x = p.x;
		this.y = p.y;
		return p.clone();
	}
	,__class__: openfl_geom_Rectangle
	,__properties__: {set_topLeft:"set_topLeft",get_topLeft:"get_topLeft",set_top:"set_top",get_top:"get_top",set_size:"set_size",get_size:"get_size",set_right:"set_right",get_right:"get_right",set_left:"set_left",get_left:"get_left",set_bottomRight:"set_bottomRight",get_bottomRight:"get_bottomRight",set_bottom:"set_bottom",get_bottom:"get_bottom"}
};
var away3d_core_pick_ShaderPicker = function() {
	this._rayDir = new openfl_geom_Vector3D();
	this._rayPos = new openfl_geom_Vector3D();
	this._localHitNormal = new openfl_geom_Vector3D();
	this._hitUV = new openfl_geom_Point();
	this._localHitPosition = new openfl_geom_Vector3D();
	this._interactives = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this._onlyMouseEnabled = true;
	this._id = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,4,true);
	this._viewportData = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,4,true);
	this._boundOffsetScale = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,8,true);
	this._boundOffsetScale.set(3,0);
	this._boundOffsetScale.set(7,1);
};
$hxClasses["away3d.core.pick.ShaderPicker"] = away3d_core_pick_ShaderPicker;
away3d_core_pick_ShaderPicker.__name__ = "away3d.core.pick.ShaderPicker";
away3d_core_pick_ShaderPicker.__interfaces__ = [away3d_core_pick_IPicker];
away3d_core_pick_ShaderPicker.prototype = {
	_stage3DProxy: null
	,_context: null
	,_onlyMouseEnabled: null
	,_objectProgram3D: null
	,_triangleProgram3D: null
	,_bitmapData: null
	,_viewportData: null
	,_boundOffsetScale: null
	,_id: null
	,_interactives: null
	,_interactiveId: null
	,_hitColor: null
	,_projX: null
	,_projY: null
	,_hitRenderable: null
	,_hitEntity: null
	,_localHitPosition: null
	,_hitUV: null
	,_faceIndex: null
	,_subGeometryIndex: null
	,_localHitNormal: null
	,_rayPos: null
	,_rayDir: null
	,_potentialFound: null
	,get_onlyMouseEnabled: function() {
		return this._onlyMouseEnabled;
	}
	,set_onlyMouseEnabled: function(value) {
		this._onlyMouseEnabled = value;
		return value;
	}
	,getViewCollision: function(x,y,view) {
		var collector = view.get_entityCollector();
		this._stage3DProxy = view.get_stage3DProxy();
		if(this._stage3DProxy == null) {
			return null;
		}
		this._context = this._stage3DProxy._context3D;
		this._viewportData.set(0,view.get_width());
		this._viewportData.set(1,view.get_height());
		this._viewportData.set(2,-(this._projX = 2 * x / view.get_width() - 1));
		this._viewportData.set(3,this._projY = 2 * y / view.get_height() - 1);
		this._potentialFound = false;
		this.draw(collector,null);
		this._context.setVertexBufferAt(0,null);
		if(this._context == null || !this._potentialFound) {
			return null;
		}
		if(this._bitmapData == null) {
			this._bitmapData = new openfl_display_BitmapData(1,1,false,0);
		}
		this._context.drawToBitmapData(this._bitmapData);
		this._hitColor = this._bitmapData.getPixel(0,0);
		if(this._hitColor == 0) {
			this._context.present();
			return null;
		}
		this._hitRenderable = this._interactives.get(this._hitColor - 1);
		this._hitEntity = this._hitRenderable.get_sourceEntity();
		if(this._onlyMouseEnabled && (!this._hitEntity._ancestorsAllowMouseEnabled || !this._hitEntity.get_mouseEnabled())) {
			return null;
		}
		var _collisionVO = this._hitEntity.get_pickingCollisionVO();
		if(this._hitRenderable.get_shaderPickingDetails()) {
			this.getHitDetails(view.get_camera());
			_collisionVO.localPosition = this._localHitPosition;
			_collisionVO.localNormal = this._localHitNormal;
			_collisionVO.uv = this._hitUV;
			_collisionVO.index = this._faceIndex;
			_collisionVO.subGeometryIndex = this._subGeometryIndex;
		} else {
			_collisionVO.localPosition = null;
			_collisionVO.localNormal = null;
			_collisionVO.uv = null;
			_collisionVO.index = 0;
			_collisionVO.subGeometryIndex = 0;
		}
		return _collisionVO;
	}
	,getSceneCollision: function(position,direction,scene) {
		return null;
	}
	,draw: function(entityCollector,target) {
		var camera = entityCollector.get_camera();
		this._context.clear(0,0,0,1);
		this._stage3DProxy.set_scissorRect(away3d_core_pick_ShaderPicker.MOUSE_SCISSOR_RECT);
		this._interactives.set_length(this._interactiveId = 0);
		if(this._objectProgram3D == null) {
			this.initObjectProgram3D();
		}
		this._context.setBlendFactors(2,9);
		this._context.setDepthTest(true,4);
		this._context.setProgram(this._objectProgram3D);
		this._context.setProgramConstantsFromVector(1,4,this._viewportData,1);
		this.drawRenderables(entityCollector.get_opaqueRenderableHead(),camera);
		this.drawRenderables(entityCollector.get_blendedRenderableHead(),camera);
	}
	,drawRenderables: function(item,camera) {
		var matrix = away3d_core_math_Matrix3DUtils.CALCULATION_MATRIX;
		var renderable;
		var viewProjection = camera.get_viewProjection();
		while(item != null) {
			renderable = item.renderable;
			if(renderable.get_sourceEntity().get_scene() == null || !renderable.get_mouseEnabled() && this._onlyMouseEnabled) {
				item = item.next;
				continue;
			}
			this._potentialFound = true;
			this._context.setCulling(renderable.get_material() != null && renderable.get_material().get_bothSides() ? 3 : 0);
			this._interactives.set(this._interactiveId++,renderable);
			this._id.set(1,(this._interactiveId >> 8) / 255);
			this._id.set(2,(this._interactiveId & 255) / 255);
			matrix.copyFrom(renderable.getRenderSceneTransform(camera));
			matrix.append(viewProjection);
			this._context.setProgramConstantsFromMatrix(1,0,matrix,true);
			this._context.setProgramConstantsFromVector(0,0,this._id,1);
			renderable.activateVertexBuffer(0,this._stage3DProxy);
			this._stage3DProxy.drawTriangles(renderable.getIndexBuffer(this._stage3DProxy),0,renderable.get_numTriangles());
			item = item.next;
		}
	}
	,updateRay: function(camera) {
		this._rayPos = camera.get_scenePosition();
		this._rayDir = camera.getRay(this._projX,this._projY,1);
		this._rayDir.normalize();
	}
	,initObjectProgram3D: function() {
		this._objectProgram3D = this._context.createProgram();
		var vertexCode = "m44 vt0, va0, vc0\t\t\t\n" + "mul vt1.xy, vt0.w, vc4.zw\t\n" + "add vt0.xy, vt0.xy, vt1.xy\t\n" + "mul vt0.xy, vt0.xy, vc4.xy\t\n" + "mov op, vt0\t\n";
		var fragmentCode = "mov oc, fc0";
		this._objectProgram3D.upload(new openfl_utils_AGALMiniAssembler().assemble(openfl_display3D__$Context3DProgramType_Context3DProgramType_$Impl_$.toString(1),vertexCode),new openfl_utils_AGALMiniAssembler().assemble(openfl_display3D__$Context3DProgramType_Context3DProgramType_$Impl_$.toString(0),fragmentCode));
	}
	,initTriangleProgram3D: function() {
		this._triangleProgram3D = this._context.createProgram();
		var vertexCode = "add vt0, va0, vc5 \t\t\t\n" + "mul vt0, vt0, vc6 \t\t\t\n" + "mov v0, vt0\t\t\t\t\n" + "m44 vt0, va0, vc0\t\t\t\n" + "mul vt1.xy, vt0.w, vc4.zw\t\n" + "add vt0.xy, vt0.xy, vt1.xy\t\n" + "mul vt0.xy, vt0.xy, vc4.xy\t\n" + "mov op, vt0\t\n";
		var fragmentCode = "mov oc, v0";
		this._triangleProgram3D.upload(new openfl_utils_AGALMiniAssembler().assemble(openfl_display3D__$Context3DProgramType_Context3DProgramType_$Impl_$.toString(1),vertexCode),new openfl_utils_AGALMiniAssembler().assemble(openfl_display3D__$Context3DProgramType_Context3DProgramType_$Impl_$.toString(0),fragmentCode));
	}
	,getHitDetails: function(camera) {
		this.getApproximatePosition(camera);
		this.getPreciseDetails(camera);
	}
	,getApproximatePosition: function(camera) {
		var entity = this._hitRenderable.get_sourceEntity();
		var scX;
		var scY;
		var scZ;
		var offsX;
		var offsY;
		var offsZ;
		var localViewProjection = away3d_core_math_Matrix3DUtils.CALCULATION_MATRIX;
		localViewProjection.copyFrom(this._hitRenderable.getRenderSceneTransform(camera));
		localViewProjection.append(camera.get_viewProjection());
		if(this._triangleProgram3D == null) {
			this.initTriangleProgram3D();
		}
		var this1 = this._boundOffsetScale;
		scX = entity.get_maxX() - entity.get_minX();
		this1.set(4,1 / scX);
		var this2 = this._boundOffsetScale;
		scY = entity.get_maxY() - entity.get_minY();
		this2.set(5,1 / scY);
		var this3 = this._boundOffsetScale;
		scZ = entity.get_maxZ() - entity.get_minZ();
		this3.set(6,1 / scZ);
		var this4 = this._boundOffsetScale;
		offsX = -entity.get_minX();
		this4.set(0,offsX);
		var this5 = this._boundOffsetScale;
		offsY = -entity.get_minY();
		this5.set(1,offsY);
		var this6 = this._boundOffsetScale;
		offsZ = -entity.get_minZ();
		this6.set(2,offsZ);
		this._context.setProgram(this._triangleProgram3D);
		this._context.clear(0,0,0,0,1,0,2);
		this._context.setScissorRectangle(away3d_core_pick_ShaderPicker.MOUSE_SCISSOR_RECT);
		this._context.setProgramConstantsFromMatrix(1,0,localViewProjection,true);
		this._context.setProgramConstantsFromVector(1,5,this._boundOffsetScale,2);
		this._hitRenderable.activateVertexBuffer(0,this._stage3DProxy);
		this._stage3DProxy.drawTriangles(this._hitRenderable.getIndexBuffer(this._stage3DProxy),0,this._hitRenderable.get_numTriangles());
		this._context.drawToBitmapData(this._bitmapData);
		var col = this._bitmapData.getPixel(0,0);
		this._localHitPosition.x = (col >> 16 & 255) * scX / 255 - offsX;
		this._localHitPosition.y = (col >> 8 & 255) * scY / 255 - offsY;
		this._localHitPosition.z = (col & 255) * scZ / 255 - offsZ;
	}
	,getPreciseDetails: function(camera) {
		var subGeom = (js_Boot.__cast(this._hitRenderable , away3d_core_base_SubMesh)).get_subGeometry();
		var indices = subGeom.get_indexData();
		var vertices = subGeom.get_vertexData();
		var len = indices.get_length();
		var x1;
		var y1;
		var z1;
		var x2;
		var y2;
		var z2;
		var x3;
		var y3;
		var z3;
		var i = 0;
		var j = 1;
		var k = 2;
		var t1;
		var t2;
		var t3;
		var v0x;
		var v0y;
		var v0z;
		var v1x;
		var v1y;
		var v1z;
		var v2x;
		var v2y;
		var v2z;
		var dot00;
		var dot01;
		var dot02;
		var dot11;
		var dot12;
		var s;
		var t;
		var invDenom;
		var uvs = subGeom.get_UVData();
		var normals = subGeom.get_faceNormals();
		var x = this._localHitPosition.x;
		var y = this._localHitPosition.y;
		var z = this._localHitPosition.z;
		var u;
		var v;
		var ui1;
		var ui2;
		var ui3;
		var s0x;
		var s0y;
		var s0z;
		var s1x;
		var s1y;
		var s1z;
		var nl;
		var stride = subGeom.get_vertexStride();
		var vertexOffset = subGeom.get_vertexOffset();
		this.updateRay(camera);
		while(i < len) {
			t1 = vertexOffset + indices.get(i) * stride;
			t2 = vertexOffset + indices.get(j) * stride;
			t3 = vertexOffset + indices.get(k) * stride;
			x1 = vertices.get(t1);
			y1 = vertices.get(t1 + 1);
			z1 = vertices.get(t1 + 2);
			x2 = vertices.get(t2);
			y2 = vertices.get(t2 + 1);
			z2 = vertices.get(t2 + 2);
			x3 = vertices.get(t3);
			y3 = vertices.get(t3 + 1);
			z3 = vertices.get(t3 + 2);
			if(!(x < x1 && x < x2 && x < x3 || y < y1 && y < y2 && y < y3 || z < z1 && z < z2 && z < z3 || x > x1 && x > x2 && x > x3 || y > y1 && y > y2 && y > y3 || z > z1 && z > z2 && z > z3)) {
				v0x = x3 - x1;
				v0y = y3 - y1;
				v0z = z3 - z1;
				v1x = x2 - x1;
				v1y = y2 - y1;
				v1z = z2 - z1;
				v2x = x - x1;
				v2y = y - y1;
				v2z = z - z1;
				dot00 = v0x * v0x + v0y * v0y + v0z * v0z;
				dot01 = v0x * v1x + v0y * v1y + v0z * v1z;
				dot02 = v0x * v2x + v0y * v2y + v0z * v2z;
				dot11 = v1x * v1x + v1y * v1y + v1z * v1z;
				dot12 = v1x * v2x + v1y * v2y + v1z * v2z;
				invDenom = 1 / (dot00 * dot11 - dot01 * dot01);
				s = (dot11 * dot02 - dot01 * dot12) * invDenom;
				t = (dot00 * dot12 - dot01 * dot02) * invDenom;
				if(s >= 0 && t >= 0 && s + t <= 1) {
					this.getPrecisePosition(this._hitRenderable.get_inverseSceneTransform(),normals.get(i),normals.get(i + 1),normals.get(i + 2),x1,y1,z1);
					v2x = this._localHitPosition.x - x1;
					v2y = this._localHitPosition.y - y1;
					v2z = this._localHitPosition.z - z1;
					s0x = x2 - x1;
					s0y = y2 - y1;
					s0z = z2 - z1;
					s1x = x3 - x1;
					s1y = y3 - y1;
					s1z = z3 - z1;
					this._localHitNormal.x = s0y * s1z - s0z * s1y;
					this._localHitNormal.y = s0z * s1x - s0x * s1z;
					this._localHitNormal.z = s0x * s1y - s0y * s1x;
					nl = 1 / Math.sqrt(this._localHitNormal.x * this._localHitNormal.x + this._localHitNormal.y * this._localHitNormal.y + this._localHitNormal.z * this._localHitNormal.z);
					this._localHitNormal.x *= nl;
					this._localHitNormal.y *= nl;
					this._localHitNormal.z *= nl;
					dot02 = v0x * v2x + v0y * v2y + v0z * v2z;
					dot12 = v1x * v2x + v1y * v2y + v1z * v2z;
					s = (dot11 * dot02 - dot01 * dot12) * invDenom;
					t = (dot00 * dot12 - dot01 * dot02) * invDenom;
					ui1 = indices.get(i) << 1;
					ui2 = indices.get(j) << 1;
					ui3 = indices.get(k) << 1;
					u = uvs.get(ui1);
					v = uvs.get(ui1 + 1);
					var tmp = u + t * (uvs.get(ui2) - u);
					var tmp1 = s * (uvs.get(ui3) - u);
					this._hitUV.x = tmp + tmp1;
					var tmp2 = v + t * (uvs.get(ui2 + 1) - v);
					var tmp3 = s * (uvs.get(ui3 + 1) - v);
					this._hitUV.y = tmp2 + tmp3;
					this._faceIndex = i;
					this._subGeometryIndex = away3d_tools_utils_GeomUtil.getMeshSubMeshIndex(js_Boot.__cast(this._hitRenderable , away3d_core_base_SubMesh));
					return;
				}
			}
			i += 3;
			j += 3;
			k += 3;
		}
	}
	,getPrecisePosition: function(invSceneTransform,nx,ny,nz,px,py,pz) {
		var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
		var cx = this._rayPos.x;
		var cy = this._rayPos.y;
		var cz = this._rayPos.z;
		var ox = this._rayDir.x;
		var oy = this._rayDir.y;
		var oz = this._rayDir.z;
		invSceneTransform.copyRawDataTo(raw);
		var rx = raw.get(0) * ox + raw.get(4) * oy + raw.get(8) * oz;
		var ry = raw.get(1) * ox + raw.get(5) * oy + raw.get(9) * oz;
		var rz = raw.get(2) * ox + raw.get(6) * oy + raw.get(10) * oz;
		ox = raw.get(0) * cx + raw.get(4) * cy + raw.get(8) * cz + raw.get(12);
		oy = raw.get(1) * cx + raw.get(5) * cy + raw.get(9) * cz + raw.get(13);
		oz = raw.get(2) * cx + raw.get(6) * cy + raw.get(10) * cz + raw.get(14);
		var t = ((px - ox) * nx + (py - oy) * ny + (pz - oz) * nz) / (rx * nx + ry * ny + rz * nz);
		this._localHitPosition.x = ox + rx * t;
		this._localHitPosition.y = oy + ry * t;
		this._localHitPosition.z = oz + rz * t;
	}
	,dispose: function() {
		this._bitmapData.dispose();
		if(this._triangleProgram3D != null) {
			this._triangleProgram3D.dispose();
		}
		if(this._objectProgram3D != null) {
			this._objectProgram3D.dispose();
		}
		this._triangleProgram3D = null;
		this._objectProgram3D = null;
		this._bitmapData = null;
		this._hitRenderable = null;
		this._hitEntity = null;
	}
	,__class__: away3d_core_pick_ShaderPicker
	,__properties__: {set_onlyMouseEnabled:"set_onlyMouseEnabled",get_onlyMouseEnabled:"get_onlyMouseEnabled"}
};
var away3d_core_pick_PickingType = function() { };
$hxClasses["away3d.core.pick.PickingType"] = away3d_core_pick_PickingType;
away3d_core_pick_PickingType.__name__ = "away3d.core.pick.PickingType";
var away3d_core_render_BackgroundImageRenderer = function(stage3DProxy) {
	this.set_stage3DProxy(stage3DProxy);
};
$hxClasses["away3d.core.render.BackgroundImageRenderer"] = away3d_core_render_BackgroundImageRenderer;
away3d_core_render_BackgroundImageRenderer.__name__ = "away3d.core.render.BackgroundImageRenderer";
away3d_core_render_BackgroundImageRenderer.prototype = {
	_program3d: null
	,_texture: null
	,_indexBuffer: null
	,_vertexBuffer: null
	,_stage3DProxy: null
	,_context: null
	,get_stage3DProxy: function() {
		return this._stage3DProxy;
	}
	,set_stage3DProxy: function(value) {
		if(value == this._stage3DProxy) {
			return value;
		}
		this._stage3DProxy = value;
		this.removeBuffers();
		return value;
	}
	,removeBuffers: function() {
		if(this._vertexBuffer != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(this._vertexBuffer);
			this._vertexBuffer = null;
			this._program3d.dispose();
			this._program3d = null;
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(this._indexBuffer);
			this._indexBuffer = null;
		}
	}
	,getVertexCode: function() {
		return "mov op, va0\n" + "mov v0, va1";
	}
	,getFragmentCode: function() {
		var format;
		switch(this._texture.get_format()) {
		case 3:
			format = "dxt1,";
			break;
		case 4:
			format = "dxt5,";
			break;
		default:
			format = "";
		}
		return "tex ft0, v0, fs0 <2d, " + format + "linear>\t\n" + "mov oc, ft0";
	}
	,dispose: function() {
		this.removeBuffers();
	}
	,render: function() {
		var context = this._stage3DProxy.get_context3D();
		if(context != this._context) {
			this.removeBuffers();
			this._context = context;
		}
		if(context == null) {
			return;
		}
		if(this._vertexBuffer == null) {
			this.initBuffers(context);
		}
		context.setBlendFactors(2,9);
		context.setProgram(this._program3d);
		context.setTextureAt(0,this._texture.getTextureForStage3D(this._stage3DProxy));
		context.setVertexBufferAt(0,this._vertexBuffer,0,2);
		context.setVertexBufferAt(1,this._vertexBuffer,2,2);
		context.drawTriangles(this._indexBuffer,0,2);
		context.setVertexBufferAt(0,null);
		context.setVertexBufferAt(1,null);
		context.setTextureAt(0,null);
	}
	,initBuffers: function(context) {
		this._vertexBuffer = this._stage3DProxy.createVertexBuffer(4,4);
		this._program3d = context.createProgram();
		this._indexBuffer = this._stage3DProxy.createIndexBuffer(6);
		var array = [2,1,0,3,2,0];
		var vector = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
		var _g = 0;
		var _g1 = array.length;
		while(_g < _g1) {
			var i = _g++;
			vector.set(i,array[i]);
		}
		var v = vector;
		this._indexBuffer.uploadFromVector(v,0,6);
		this._program3d.upload(new openfl_utils_AGALMiniAssembler(away3d_debug_Debug.active).assemble(openfl_display3D__$Context3DProgramType_Context3DProgramType_$Impl_$.toString(1),this.getVertexCode()),new openfl_utils_AGALMiniAssembler(away3d_debug_Debug.active).assemble(openfl_display3D__$Context3DProgramType_Context3DProgramType_$Impl_$.toString(0),this.getFragmentCode()));
		var w = 2;
		var h = 2;
		var x = -1;
		var y = 1;
		if(this._stage3DProxy.get_scissorRect() != null) {
			x = (this._stage3DProxy.get_scissorRect().x * 2 - this._stage3DProxy.get_viewPort().width) / this._stage3DProxy.get_viewPort().width;
			y = (this._stage3DProxy.get_scissorRect().y * 2 - this._stage3DProxy.get_viewPort().height) / this._stage3DProxy.get_viewPort().height * -1;
			w = 2 / (this._stage3DProxy.get_viewPort().width / this._stage3DProxy.get_scissorRect().width);
			h = 2 / (this._stage3DProxy.get_viewPort().height / this._stage3DProxy.get_scissorRect().height);
		}
		var tmp = this._vertexBuffer;
		var array1 = [x,y - h,0,1,x + w,y - h,1,1,x + w,y,1,0,x,y,0,0];
		var vector1 = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
		var _g2 = 0;
		var _g11 = array1.length;
		while(_g2 < _g11) {
			var i1 = _g2++;
			vector1.set(i1,array1[i1]);
		}
		tmp.uploadFromVector(vector1,0,4);
	}
	,get_texture: function() {
		return this._texture;
	}
	,set_texture: function(value) {
		this._texture = value;
		return value;
	}
	,__class__: away3d_core_render_BackgroundImageRenderer
	,__properties__: {set_texture:"set_texture",get_texture:"get_texture",set_stage3DProxy:"set_stage3DProxy",get_stage3DProxy:"get_stage3DProxy"}
};
var away3d_core_render_RendererBase = function(renderToTexture) {
	if(renderToTexture == null) {
		renderToTexture = false;
	}
	this._rttViewProjectionMatrix = new openfl_geom_Matrix3D();
	this._clearOnRender = true;
	this._textureRatioY = 1;
	this._textureRatioX = 1;
	this._shareContext = false;
	this._backgroundAlpha = 1;
	this._backgroundB = 0;
	this._backgroundG = 0;
	this._backgroundR = 0;
	this._renderableSorter = new away3d_core_sort_RenderableMergeSort();
	this._renderToTexture = renderToTexture;
};
$hxClasses["away3d.core.render.RendererBase"] = away3d_core_render_RendererBase;
away3d_core_render_RendererBase.__name__ = "away3d.core.render.RendererBase";
away3d_core_render_RendererBase.prototype = {
	_context: null
	,_stage3DProxy: null
	,_backgroundR: null
	,_backgroundG: null
	,_backgroundB: null
	,_backgroundAlpha: null
	,_shareContext: null
	,_renderTarget: null
	,_renderTargetSurface: null
	,_viewWidth: null
	,_viewHeight: null
	,_renderableSorter: null
	,_backgroundImageRenderer: null
	,_background: null
	,_renderToTexture: null
	,_antiAlias: null
	,_textureRatioX: null
	,_textureRatioY: null
	,_snapshotBitmapData: null
	,_snapshotRequired: null
	,_clearOnRender: null
	,_rttViewProjectionMatrix: null
	,createEntityCollector: function() {
		return new away3d_core_traverse_EntityCollector();
	}
	,get_viewWidth: function() {
		return this._viewWidth;
	}
	,set_viewWidth: function(value) {
		this._viewWidth = value;
		return value;
	}
	,get_viewHeight: function() {
		return this._viewHeight;
	}
	,set_viewHeight: function(value) {
		this._viewHeight = value;
		return value;
	}
	,get_renderToTexture: function() {
		return this._renderToTexture;
	}
	,get_renderableSorter: function() {
		return this._renderableSorter;
	}
	,set_renderableSorter: function(value) {
		this._renderableSorter = value;
		return value;
	}
	,get_clearOnRender: function() {
		return this._clearOnRender;
	}
	,set_clearOnRender: function(value) {
		this._clearOnRender = value;
		return value;
	}
	,get_backgroundR: function() {
		return this._backgroundR;
	}
	,set_backgroundR: function(value) {
		this._backgroundR = value;
		return value;
	}
	,get_backgroundG: function() {
		return this._backgroundG;
	}
	,set_backgroundG: function(value) {
		this._backgroundG = value;
		return value;
	}
	,get_backgroundB: function() {
		return this._backgroundB;
	}
	,set_backgroundB: function(value) {
		this._backgroundB = value;
		return value;
	}
	,get_stage3DProxy: function() {
		return this._stage3DProxy;
	}
	,set_stage3DProxy: function(value) {
		if(value == this._stage3DProxy) {
			return value;
		}
		if(value == null) {
			if(this._stage3DProxy != null) {
				this._stage3DProxy.removeEventListener("Context3DCreated",$bind(this,this.onContextUpdate));
				this._stage3DProxy.removeEventListener("Context3DRecreated",$bind(this,this.onContextUpdate));
			}
			this._stage3DProxy = null;
			this._context = null;
			return null;
		}
		this._stage3DProxy = value;
		this._stage3DProxy.addEventListener("Context3DCreated",$bind(this,this.onContextUpdate));
		this._stage3DProxy.addEventListener("Context3DRecreated",$bind(this,this.onContextUpdate));
		if(this._backgroundImageRenderer != null) {
			this._backgroundImageRenderer.set_stage3DProxy(value);
		}
		if(value.get_context3D() != null) {
			this._context = value.get_context3D();
		}
		return value;
	}
	,get_shareContext: function() {
		return this._shareContext;
	}
	,set_shareContext: function(value) {
		this._shareContext = value;
		return value;
	}
	,dispose: function() {
		this.set_stage3DProxy(null);
		if(this._backgroundImageRenderer != null) {
			this._backgroundImageRenderer.dispose();
			this._backgroundImageRenderer = null;
		}
	}
	,render: function(entityCollector,target,scissorRect,surfaceSelector) {
		if(surfaceSelector == null) {
			surfaceSelector = 0;
		}
		if(this._stage3DProxy == null || this._context == null) {
			return;
		}
		this._rttViewProjectionMatrix.copyFrom(entityCollector.get_camera().get_viewProjection());
		this._rttViewProjectionMatrix.appendScale(this._textureRatioX,this._textureRatioY,1);
		this.executeRender(entityCollector,target,scissorRect,surfaceSelector);
		this._context.setVertexBufferAt(0,null);
		this._context.setTextureAt(0,null);
		this._context.setVertexBufferAt(1,null);
		this._context.setTextureAt(1,null);
		this._context.setVertexBufferAt(2,null);
		this._context.setTextureAt(2,null);
		this._context.setVertexBufferAt(3,null);
		this._context.setTextureAt(3,null);
		this._context.setVertexBufferAt(4,null);
		this._context.setTextureAt(4,null);
		this._context.setVertexBufferAt(5,null);
		this._context.setTextureAt(5,null);
		this._context.setVertexBufferAt(6,null);
		this._context.setTextureAt(6,null);
		this._context.setVertexBufferAt(7,null);
		this._context.setTextureAt(7,null);
	}
	,executeRender: function(entityCollector,target,scissorRect,surfaceSelector) {
		if(surfaceSelector == null) {
			surfaceSelector = 0;
		}
		this._renderTarget = target;
		this._renderTargetSurface = surfaceSelector;
		if(this._renderableSorter != null) {
			this._renderableSorter.sort(entityCollector);
		}
		if(this._renderToTexture) {
			this.executeRenderToTexturePass(entityCollector);
		}
		this._stage3DProxy.setRenderTarget(target,true,surfaceSelector);
		if((target != null || !this._shareContext) && this._clearOnRender) {
			this._context.clear(this._backgroundR,this._backgroundG,this._backgroundB,this._backgroundAlpha,1,0);
		}
		this._context.setDepthTest(false,0);
		this._stage3DProxy.set_scissorRect(scissorRect);
		if(this._backgroundImageRenderer != null) {
			this._backgroundImageRenderer.render();
		}
		this.draw(entityCollector,target);
		this._context.setDepthTest(false,5);
		if(!this._shareContext) {
			if(this._snapshotRequired && this._snapshotBitmapData != null) {
				this._context.drawToBitmapData(this._snapshotBitmapData);
				this._snapshotRequired = false;
			}
		}
		this._stage3DProxy.set_scissorRect(null);
	}
	,queueSnapshot: function(bmd) {
		this._snapshotRequired = true;
		this._snapshotBitmapData = bmd;
	}
	,executeRenderToTexturePass: function(entityCollector) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,draw: function(entityCollector,target) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,onContextUpdate: function(event) {
		this._context = this._stage3DProxy.get_context3D();
	}
	,get_backgroundAlpha: function() {
		return this._backgroundAlpha;
	}
	,set_backgroundAlpha: function(value) {
		this._backgroundAlpha = value;
		return value;
	}
	,get_background: function() {
		return this._background;
	}
	,set_background: function(value) {
		if(this._backgroundImageRenderer != null && value == null) {
			this._backgroundImageRenderer.dispose();
			this._backgroundImageRenderer = null;
		}
		if(this._backgroundImageRenderer == null && value != null) {
			this._backgroundImageRenderer = new away3d_core_render_BackgroundImageRenderer(this._stage3DProxy);
		}
		this._background = value;
		if(this._backgroundImageRenderer != null) {
			this._backgroundImageRenderer.set_texture(value);
		}
		return value;
	}
	,get_backgroundImageRenderer: function() {
		return this._backgroundImageRenderer;
	}
	,get_antiAlias: function() {
		return this._antiAlias;
	}
	,set_antiAlias: function(antiAlias) {
		this._antiAlias = antiAlias;
		return antiAlias;
	}
	,get_textureRatioX: function() {
		return this._textureRatioX;
	}
	,set_textureRatioX: function(value) {
		this._textureRatioX = value;
		return value;
	}
	,get_textureRatioY: function() {
		return this._textureRatioY;
	}
	,set_textureRatioY: function(value) {
		this._textureRatioY = value;
		return value;
	}
	,__class__: away3d_core_render_RendererBase
	,__properties__: {set_textureRatioY:"set_textureRatioY",get_textureRatioY:"get_textureRatioY",set_textureRatioX:"set_textureRatioX",get_textureRatioX:"get_textureRatioX",set_antiAlias:"set_antiAlias",get_antiAlias:"get_antiAlias",get_backgroundImageRenderer:"get_backgroundImageRenderer",set_background:"set_background",get_background:"get_background",set_backgroundAlpha:"set_backgroundAlpha",get_backgroundAlpha:"get_backgroundAlpha",set_shareContext:"set_shareContext",get_shareContext:"get_shareContext",set_stage3DProxy:"set_stage3DProxy",get_stage3DProxy:"get_stage3DProxy",set_backgroundB:"set_backgroundB",get_backgroundB:"get_backgroundB",set_backgroundG:"set_backgroundG",get_backgroundG:"get_backgroundG",set_backgroundR:"set_backgroundR",get_backgroundR:"get_backgroundR",set_clearOnRender:"set_clearOnRender",get_clearOnRender:"get_clearOnRender",set_renderableSorter:"set_renderableSorter",get_renderableSorter:"get_renderableSorter",get_renderToTexture:"get_renderToTexture",set_viewHeight:"set_viewHeight",get_viewHeight:"get_viewHeight",set_viewWidth:"set_viewWidth",get_viewWidth:"get_viewWidth"}
};
var away3d_core_render_DefaultRenderer = function() {
	this._skyboxTempVector = new openfl_geom_Vector3D();
	this._tempSkyboxMatrix = new openfl_geom_Matrix3D();
	this._skyboxProjection = new openfl_geom_Matrix3D();
	away3d_core_render_RendererBase.call(this);
	this._depthRenderer = new away3d_core_render_DepthRenderer();
	this._distanceRenderer = new away3d_core_render_DepthRenderer(false,true);
};
$hxClasses["away3d.core.render.DefaultRenderer"] = away3d_core_render_DefaultRenderer;
away3d_core_render_DefaultRenderer.__name__ = "away3d.core.render.DefaultRenderer";
away3d_core_render_DefaultRenderer.__super__ = away3d_core_render_RendererBase;
away3d_core_render_DefaultRenderer.prototype = $extend(away3d_core_render_RendererBase.prototype,{
	_activeMaterial: null
	,_distanceRenderer: null
	,_depthRenderer: null
	,_skyboxProjection: null
	,_tempSkyboxMatrix: null
	,_skyboxTempVector: null
	,set_stage3DProxy: function(value) {
		away3d_core_render_RendererBase.prototype.set_stage3DProxy.call(this,value);
		this._distanceRenderer.set_stage3DProxy(this._depthRenderer.set_stage3DProxy(value));
		return value;
	}
	,executeRender: function(entityCollector,target,scissorRect,surfaceSelector) {
		if(surfaceSelector == null) {
			surfaceSelector = 0;
		}
		this.updateLights(entityCollector);
		if(target != null) {
			this.drawRenderables(entityCollector.get_opaqueRenderableHead(),entityCollector,away3d_core_render_DefaultRenderer.RTT_PASSES);
			this.drawRenderables(entityCollector.get_blendedRenderableHead(),entityCollector,away3d_core_render_DefaultRenderer.RTT_PASSES);
		}
		away3d_core_render_RendererBase.prototype.executeRender.call(this,entityCollector,target,scissorRect,surfaceSelector);
	}
	,updateLights: function(entityCollector) {
		var dirLights = entityCollector.get_directionalLights();
		var pointLights = entityCollector.get_pointLights();
		var i;
		var light;
		var shadowMapper;
		var len = dirLights.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i1 = _g++;
			light = dirLights.get(i1);
			shadowMapper = light.get_shadowMapper();
			if(light.get_castsShadows() && (shadowMapper.get_autoUpdateShadows() || shadowMapper._shadowsInvalid)) {
				shadowMapper.renderDepthMap(this._stage3DProxy,entityCollector,this._depthRenderer);
			}
		}
		len = pointLights.get_length();
		var _g2 = 0;
		var _g3 = len;
		while(_g2 < _g3) {
			var i2 = _g2++;
			light = pointLights.get(i2);
			shadowMapper = light.get_shadowMapper();
			if(light.get_castsShadows() && (shadowMapper.get_autoUpdateShadows() || shadowMapper._shadowsInvalid)) {
				shadowMapper.renderDepthMap(this._stage3DProxy,entityCollector,this._distanceRenderer);
			}
		}
	}
	,draw: function(entityCollector,target) {
		this._context.setBlendFactors(2,9);
		if(entityCollector.get_skyBox() != null) {
			if(this._activeMaterial != null) {
				this._activeMaterial.deactivate(this._stage3DProxy);
			}
			this._activeMaterial = null;
			this._context.setDepthTest(false,0);
			this.drawSkyBox(entityCollector);
		}
		this._context.setDepthTest(true,5);
		var which = target != null ? away3d_core_render_DefaultRenderer.SCREEN_PASSES : away3d_core_render_DefaultRenderer.ALL_PASSES;
		this.drawRenderables(entityCollector.get_opaqueRenderableHead(),entityCollector,which);
		this.drawRenderables(entityCollector.get_blendedRenderableHead(),entityCollector,which);
		this._context.setDepthTest(false,5);
		if(this._activeMaterial != null) {
			this._activeMaterial.deactivate(this._stage3DProxy);
		}
		this._activeMaterial = null;
	}
	,drawSkyBox: function(entityCollector) {
		var skyBox = entityCollector.get_skyBox();
		var material = skyBox.get_material();
		var camera = entityCollector.get_camera();
		this.updateSkyBoxProjection(camera);
		material.activatePass(0,this._stage3DProxy,camera);
		material.renderPass(0,skyBox,this._stage3DProxy,entityCollector,this._skyboxProjection);
		material.deactivatePass(0,this._stage3DProxy);
	}
	,updateSkyBoxProjection: function(camera) {
		this._skyboxProjection.copyFrom(this._rttViewProjectionMatrix);
		this._skyboxProjection.copyRowTo(2,this._skyboxTempVector);
		var camPos = camera.get_scenePosition();
		var cx = this._skyboxTempVector.x;
		var cy = this._skyboxTempVector.y;
		var cz = this._skyboxTempVector.z;
		var length = Math.sqrt(cx * cx + cy * cy + cz * cz);
		this._skyboxTempVector.x = 0;
		this._skyboxTempVector.y = 0;
		this._skyboxTempVector.z = 0;
		this._skyboxTempVector.w = 1;
		this._tempSkyboxMatrix.copyFrom(camera.get_sceneTransform());
		this._tempSkyboxMatrix.copyColumnFrom(3,this._skyboxTempVector);
		this._skyboxTempVector.x = 0;
		this._skyboxTempVector.y = 0;
		this._skyboxTempVector.z = 1;
		this._skyboxTempVector.w = 0;
		away3d_core_math_Matrix3DUtils.transformVector(this._tempSkyboxMatrix,this._skyboxTempVector,this._skyboxTempVector);
		this._skyboxTempVector.normalize();
		var angle = Math.acos(this._skyboxTempVector.x * (cx / length) + this._skyboxTempVector.y * (cy / length) + this._skyboxTempVector.z * (cz / length));
		if(Math.abs(angle) > 0.000001) {
			return;
		}
		var cw = -(cx * camPos.x + cy * camPos.y + cz * camPos.z + length);
		var signX = cx >= 0 ? 1 : -1;
		var signY = cy >= 0 ? 1 : -1;
		var p = this._skyboxTempVector;
		p.x = signX;
		p.y = signY;
		p.z = 1;
		p.w = 1;
		this._tempSkyboxMatrix.copyFrom(this._skyboxProjection);
		this._tempSkyboxMatrix.invert();
		var q = away3d_core_math_Matrix3DUtils.transformVector(this._tempSkyboxMatrix,p,away3d_core_math_Matrix3DUtils.CALCULATION_VECTOR3D);
		this._skyboxProjection.copyRowTo(3,p);
		var a = (q.x * p.x + q.y * p.y + q.z * p.z + q.w * p.w) / (cx * q.x + cy * q.y + cz * q.z + cw * q.w);
		this._skyboxTempVector.x = cx * a;
		this._skyboxTempVector.y = cy * a;
		this._skyboxTempVector.z = cz * a;
		this._skyboxTempVector.w = cw * a;
		this._skyboxProjection.copyRowFrom(2,this._skyboxTempVector);
	}
	,drawRenderables: function(item,entityCollector,which) {
		var numPasses;
		var j;
		var camera = entityCollector.get_camera();
		var item2;
		while(item != null) {
			this._activeMaterial = item.renderable.get_material();
			this._activeMaterial.updateMaterial(this._context);
			numPasses = this._activeMaterial.get_numPasses();
			j = 0;
			while(true) {
				item2 = item;
				var rttMask = this._activeMaterial.passRendersToTexture(j) ? 1 : 2;
				if((rttMask & which) != 0) {
					this._activeMaterial.activatePass(j,this._stage3DProxy,camera);
					while(true) {
						this._activeMaterial.renderPass(j,item2.renderable,this._stage3DProxy,entityCollector,this._rttViewProjectionMatrix);
						item2 = item2.next;
						if(!(item2 != null && item2.renderable.get_material() == this._activeMaterial)) {
							break;
						}
					}
					this._activeMaterial.deactivatePass(j,this._stage3DProxy);
				} else {
					while(true) {
						item2 = item2.next;
						if(!(item2 != null && item2.renderable.get_material() == this._activeMaterial)) {
							break;
						}
					}
				}
				if(!(++j < numPasses)) {
					break;
				}
			}
			item = item2;
		}
	}
	,dispose: function() {
		away3d_core_render_RendererBase.prototype.dispose.call(this);
		this._depthRenderer.dispose();
		this._distanceRenderer.dispose();
		this._depthRenderer = null;
		this._distanceRenderer = null;
	}
	,__class__: away3d_core_render_DefaultRenderer
});
var away3d_core_render_DepthRenderer = function(renderBlended,distanceBased) {
	if(distanceBased == null) {
		distanceBased = false;
	}
	if(renderBlended == null) {
		renderBlended = false;
	}
	away3d_core_render_RendererBase.call(this);
	this._renderBlended = renderBlended;
	this._distanceBased = distanceBased;
	this._backgroundR = 1;
	this._backgroundG = 1;
	this._backgroundB = 1;
};
$hxClasses["away3d.core.render.DepthRenderer"] = away3d_core_render_DepthRenderer;
away3d_core_render_DepthRenderer.__name__ = "away3d.core.render.DepthRenderer";
away3d_core_render_DepthRenderer.__super__ = away3d_core_render_RendererBase;
away3d_core_render_DepthRenderer.prototype = $extend(away3d_core_render_RendererBase.prototype,{
	_activeMaterial: null
	,_renderBlended: null
	,_distanceBased: null
	,_disableColor: null
	,get_disableColor: function() {
		return this._disableColor;
	}
	,set_disableColor: function(value) {
		this._disableColor = value;
		return value;
	}
	,set_backgroundR: function(value) {
		return value;
	}
	,set_backgroundG: function(value) {
		return value;
	}
	,set_backgroundB: function(value) {
		return value;
	}
	,renderCascades: function(entityCollector,target,numCascades,scissorRects,cameras) {
		this._renderTarget = target;
		this._renderTargetSurface = 0;
		this._renderableSorter.sort(entityCollector);
		this._stage3DProxy.setRenderTarget(target,true,0);
		this._context.clear(1,1,1,1,1,0);
		this._context.setBlendFactors(2,9);
		this._context.setDepthTest(true,4);
		var head = entityCollector.get_opaqueRenderableHead();
		var first = true;
		var i = numCascades - 1;
		while(i >= 0) {
			this._stage3DProxy.set_scissorRect(scissorRects.get(i));
			this.drawCascadeRenderables(head,cameras.get(i),first ? null : cameras.get(i).get_frustumPlanes());
			first = false;
			--i;
		}
		if(this._activeMaterial != null) {
			this._activeMaterial.deactivateForDepth(this._stage3DProxy);
		}
		this._activeMaterial = null;
		this._context.setDepthTest(false,5);
		this._stage3DProxy.set_scissorRect(null);
	}
	,drawCascadeRenderables: function(item,camera,cullPlanes) {
		var material;
		while(item != null) {
			if(item.cascaded) {
				item = item.next;
				continue;
			}
			var renderable = item.renderable;
			var entity = renderable.get_sourceEntity();
			if(cullPlanes == null || entity.get_worldBounds().isInFrustum(cullPlanes,4)) {
				material = renderable.get_material();
				if(this._activeMaterial != material) {
					if(this._activeMaterial != null) {
						this._activeMaterial.deactivateForDepth(this._stage3DProxy);
					}
					this._activeMaterial = material;
					this._activeMaterial.activateForDepth(this._stage3DProxy,camera,false);
				}
				this._activeMaterial.renderDepth(renderable,this._stage3DProxy,camera,camera.get_viewProjection());
			} else {
				item.cascaded = true;
			}
			item = item.next;
		}
	}
	,draw: function(entityCollector,target) {
		this._context.setBlendFactors(2,9);
		this._context.setDepthTest(true,4);
		this.drawRenderables(entityCollector.get_opaqueRenderableHead(),entityCollector);
		if(this._disableColor) {
			this._context.setColorMask(false,false,false,false);
		}
		if(this._renderBlended) {
			this.drawRenderables(entityCollector.get_blendedRenderableHead(),entityCollector);
		}
		if(this._activeMaterial != null) {
			this._activeMaterial.deactivateForDepth(this._stage3DProxy);
		}
		if(this._disableColor) {
			this._context.setColorMask(true,true,true,true);
		}
		this._activeMaterial = null;
	}
	,drawRenderables: function(item,entityCollector) {
		var camera = entityCollector.get_camera();
		var item2;
		while(item != null) {
			this._activeMaterial = item.renderable.get_material();
			if(this._disableColor && this._activeMaterial.hasDepthAlphaThreshold()) {
				item2 = item;
				while(true) {
					item2 = item2.next;
					if(!(item2 != null && item2.renderable.get_material() == this._activeMaterial)) {
						break;
					}
				}
			} else {
				this._activeMaterial.activateForDepth(this._stage3DProxy,camera,this._distanceBased);
				item2 = item;
				while(true) {
					this._activeMaterial.renderDepth(item2.renderable,this._stage3DProxy,camera,this._rttViewProjectionMatrix);
					item2 = item2.next;
					if(!(item2 != null && item2.renderable.get_material() == this._activeMaterial)) {
						break;
					}
				}
				this._activeMaterial.deactivateForDepth(this._stage3DProxy);
			}
			item = item2;
		}
	}
	,__class__: away3d_core_render_DepthRenderer
	,__properties__: $extend(away3d_core_render_RendererBase.prototype.__properties__,{set_disableColor:"set_disableColor",get_disableColor:"get_disableColor"})
});
var away3d_core_render_Filter3DRenderer = function(stage3DProxy) {
	this._filterSizesInvalid = true;
	this._stage3DProxy = stage3DProxy;
	this._stage3DProxy.addEventListener("Context3DRecreated",$bind(this,this.onContext3DRecreated));
	this._rttManager = away3d_core_managers_RTTBufferManager.getInstance(stage3DProxy);
	this._rttManager.addEventListener("resize",$bind(this,this.onRTTResize));
};
$hxClasses["away3d.core.render.Filter3DRenderer"] = away3d_core_render_Filter3DRenderer;
away3d_core_render_Filter3DRenderer.__name__ = "away3d.core.render.Filter3DRenderer";
away3d_core_render_Filter3DRenderer.prototype = {
	_filters: null
	,_tasks: null
	,_filterTasksInvalid: null
	,_mainInputTexture: null
	,_requireDepthRender: null
	,_rttManager: null
	,_stage3DProxy: null
	,_filterSizesInvalid: null
	,onContext3DRecreated: function(event) {
		this._filterSizesInvalid = true;
	}
	,onRTTResize: function(event) {
		this._filterSizesInvalid = true;
	}
	,get_requireDepthRender: function() {
		return this._requireDepthRender;
	}
	,getMainInputTexture: function(stage3DProxy) {
		if(this._filterTasksInvalid) {
			this.updateFilterTasks(stage3DProxy);
		}
		return this._mainInputTexture;
	}
	,get_filters: function() {
		return this._filters;
	}
	,set_filters: function(value) {
		this._filters = value;
		this._filterTasksInvalid = true;
		this._requireDepthRender = false;
		if(this._filters == null) {
			return null;
		}
		var _g = 0;
		var _g1 = this.get_filters().length;
		while(_g < _g1) {
			var i = _g++;
			if(!this._requireDepthRender) {
				this._requireDepthRender = this._filters[i].get_requireDepthRender();
			}
		}
		this._filterSizesInvalid = true;
		return value;
	}
	,updateFilterTasks: function(stage3DProxy) {
		if(this._filterSizesInvalid) {
			this.updateFilterSizes();
		}
		if(this._filters == null) {
			this._tasks = null;
			return;
		}
		this._tasks = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		var len = this._filters.length - 1;
		var filter;
		var _g = 0;
		var _g1 = len + 1;
		while(_g < _g1) {
			var i = _g++;
			filter = this._filters[i];
			filter.setRenderTargets(i == len ? null : this._filters[i + 1].getMainInputTexture(stage3DProxy),stage3DProxy);
			this._tasks = this._tasks.concat(filter.get_tasks());
		}
		this._mainInputTexture = this._filters[0].getMainInputTexture(stage3DProxy);
	}
	,render: function(stage3DProxy,camera3D,depthTexture) {
		var i;
		var task;
		var context = stage3DProxy.get_context3D();
		var indexBuffer = this._rttManager.get_indexBuffer();
		var vertexBuffer = this._rttManager.get_renderToTextureVertexBuffer();
		if(this._filters == null) {
			return;
		}
		if(this._filterSizesInvalid) {
			this.updateFilterSizes();
		}
		if(this._filterTasksInvalid) {
			this.updateFilterTasks(stage3DProxy);
		}
		var len = this._filters.length;
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i1 = _g++;
			this._filters[i1].update(stage3DProxy,camera3D);
		}
		len = this._tasks.get_length();
		if(len > 1) {
			context.setVertexBufferAt(0,vertexBuffer,0,2);
			context.setVertexBufferAt(1,vertexBuffer,2,2);
		}
		var _g2 = 0;
		var _g3 = len;
		while(_g2 < _g3) {
			var i2 = _g2++;
			task = this._tasks.get(i2);
			stage3DProxy.setRenderTarget(task.get_target());
			if(task.get_target() == null) {
				stage3DProxy.set_scissorRect(null);
				vertexBuffer = this._rttManager.get_renderToScreenVertexBuffer();
				context.setVertexBufferAt(0,vertexBuffer,0,2);
				context.setVertexBufferAt(1,vertexBuffer,2,2);
			}
			context.setTextureAt(0,task.getMainInputTexture(stage3DProxy));
			context.setProgram(task.getProgram3D(stage3DProxy));
			context.clear(0.0,0.0,0.0,0.0);
			task.activate(stage3DProxy,camera3D,depthTexture);
			context.setBlendFactors(2,9);
			stage3DProxy.drawTriangles(indexBuffer,0,2);
			task.deactivate(stage3DProxy);
		}
		context.setTextureAt(0,null);
		context.setVertexBufferAt(0,null);
		context.setVertexBufferAt(1,null);
	}
	,updateFilterSizes: function() {
		var _g = 0;
		var _g1 = this._filters.length;
		while(_g < _g1) {
			var i = _g++;
			this._filters[i].set_textureWidth(this._rttManager.get_textureWidth());
			this._filters[i].set_textureHeight(this._rttManager.get_textureHeight());
		}
		this._filterSizesInvalid = true;
	}
	,dispose: function() {
		this._rttManager.removeEventListener("resize",$bind(this,this.onRTTResize));
		this._rttManager = null;
		this._stage3DProxy.removeEventListener("Context3DRecreated",$bind(this,this.onContext3DRecreated));
		this._stage3DProxy = null;
	}
	,__class__: away3d_core_render_Filter3DRenderer
	,__properties__: {set_filters:"set_filters",get_filters:"get_filters",get_requireDepthRender:"get_requireDepthRender"}
};
var away3d_core_sort_IEntitySorter = function() { };
$hxClasses["away3d.core.sort.IEntitySorter"] = away3d_core_sort_IEntitySorter;
away3d_core_sort_IEntitySorter.__name__ = "away3d.core.sort.IEntitySorter";
away3d_core_sort_IEntitySorter.__isInterface__ = true;
away3d_core_sort_IEntitySorter.prototype = {
	sort: null
	,__class__: away3d_core_sort_IEntitySorter
};
var away3d_core_sort_RenderableMergeSort = function() {
};
$hxClasses["away3d.core.sort.RenderableMergeSort"] = away3d_core_sort_RenderableMergeSort;
away3d_core_sort_RenderableMergeSort.__name__ = "away3d.core.sort.RenderableMergeSort";
away3d_core_sort_RenderableMergeSort.__interfaces__ = [away3d_core_sort_IEntitySorter];
away3d_core_sort_RenderableMergeSort.prototype = {
	sort: function(collector) {
		collector.set_opaqueRenderableHead(this.mergeSortByMaterial(collector.get_opaqueRenderableHead()));
		collector.set_blendedRenderableHead(this.mergeSortByDepth(collector.get_blendedRenderableHead()));
	}
	,mergeSortByDepth: function(head) {
		if(head == null || head.next == null) {
			return head;
		}
		var slow = head;
		var fast = head.next;
		while(fast != null) {
			fast = fast.next;
			if(fast != null) {
				slow = slow.next;
				fast = fast.next;
			}
		}
		var headB = slow.next;
		slow.next = null;
		head = this.mergeSortByDepth(head);
		headB = this.mergeSortByDepth(headB);
		var result = null;
		var curr = null;
		var l = null;
		if(head == null) {
			return headB;
		}
		if(headB == null) {
			return head;
		}
		while(head != null && headB != null) {
			if(head.zIndex < headB.zIndex) {
				l = head;
				head = head.next;
			} else {
				l = headB;
				headB = headB.next;
			}
			if(result == null) {
				result = l;
			} else {
				curr.next = l;
			}
			curr = l;
		}
		if(head != null) {
			curr.next = head;
		} else if(headB != null) {
			curr.next = headB;
		}
		return result;
	}
	,mergeSortByMaterial: function(head) {
		if(head == null || head.next == null) {
			return head;
		}
		var slow = head;
		var fast = head.next;
		while(fast != null) {
			fast = fast.next;
			if(fast != null) {
				slow = slow.next;
				fast = fast.next;
			}
		}
		var headB = slow.next;
		slow.next = null;
		head = this.mergeSortByMaterial(head);
		headB = this.mergeSortByMaterial(headB);
		var result = null;
		var curr = null;
		var l = null;
		var cmp;
		if(head == null) {
			return headB;
		}
		if(headB == null) {
			return head;
		}
		while(head != null && headB != null && head != null && headB != null) {
			var aid = head.renderOrderId;
			var bid = headB.renderOrderId;
			if(aid == bid) {
				var ma = head.materialId;
				var mb = headB.materialId;
				if(ma == mb) {
					if(head.zIndex < headB.zIndex) {
						cmp = 1;
					} else {
						cmp = -1;
					}
				} else if(ma > mb) {
					cmp = 1;
				} else {
					cmp = -1;
				}
			} else if(aid > bid) {
				cmp = 1;
			} else {
				cmp = -1;
			}
			if(cmp < 0) {
				l = head;
				head = head.next;
			} else {
				l = headB;
				headB = headB.next;
			}
			if(result == null) {
				result = l;
				curr = l;
			} else {
				curr.next = l;
				curr = l;
			}
		}
		if(head != null) {
			curr.next = head;
		} else if(headB != null) {
			curr.next = headB;
		}
		return result;
	}
	,__class__: away3d_core_sort_RenderableMergeSort
};
var away3d_core_traverse_PartitionTraverser = function() {
};
$hxClasses["away3d.core.traverse.PartitionTraverser"] = away3d_core_traverse_PartitionTraverser;
away3d_core_traverse_PartitionTraverser.__name__ = "away3d.core.traverse.PartitionTraverser";
away3d_core_traverse_PartitionTraverser.prototype = {
	scene: null
	,_entryPoint: null
	,enterNode: function(node) {
		return true;
	}
	,applySkyBox: function(renderable) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,applyRenderable: function(renderable) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,applyUnknownLight: function(light) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,applyDirectionalLight: function(light) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,applyPointLight: function(light) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,applyLightProbe: function(light) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,applyEntity: function(entity) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_entryPoint: function() {
		return this._entryPoint;
	}
	,__class__: away3d_core_traverse_PartitionTraverser
	,__properties__: {get_entryPoint:"get_entryPoint"}
};
var away3d_core_traverse_EntityCollector = function() {
	away3d_core_traverse_PartitionTraverser.call(this);
	this.init();
};
$hxClasses["away3d.core.traverse.EntityCollector"] = away3d_core_traverse_EntityCollector;
away3d_core_traverse_EntityCollector.__name__ = "away3d.core.traverse.EntityCollector";
away3d_core_traverse_EntityCollector.__super__ = away3d_core_traverse_PartitionTraverser;
away3d_core_traverse_EntityCollector.prototype = $extend(away3d_core_traverse_PartitionTraverser.prototype,{
	_skyBox: null
	,_opaqueRenderableHead: null
	,_blendedRenderableHead: null
	,_entityHead: null
	,_renderableListItemPool: null
	,_entityListItemPool: null
	,_lights: null
	,_directionalLights: null
	,_pointLights: null
	,_lightProbes: null
	,_numEntities: null
	,_numLights: null
	,_numTriangles: null
	,_numMouseEnableds: null
	,_camera: null
	,_numDirectionalLights: null
	,_numPointLights: null
	,_numLightProbes: null
	,_cameraForward: null
	,_customCullPlanes: null
	,_cullPlanes: null
	,_numCullPlanes: null
	,init: function() {
		this._lights = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		this._directionalLights = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		this._pointLights = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		this._lightProbes = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		this._renderableListItemPool = new away3d_core_data_RenderableListItemPool();
		this._entityListItemPool = new away3d_core_data_EntityListItemPool();
		this._numEntities = 0;
		this._numLights = 0;
		this._numTriangles = 0;
		this._numMouseEnableds = 0;
		this._numDirectionalLights = 0;
		this._numPointLights = 0;
		this._numLightProbes = 0;
		this._numCullPlanes = 0;
	}
	,get_camera: function() {
		return this._camera;
	}
	,set_camera: function(value) {
		this._camera = value;
		this._entryPoint = this._camera.get_scenePosition();
		this._cameraForward = away3d_core_math_Matrix3DUtils.getForward(this._camera.get_transform(),this._cameraForward);
		this._cullPlanes = this._camera.get_frustumPlanes();
		return value;
	}
	,get_cullPlanes: function() {
		return this._customCullPlanes;
	}
	,set_cullPlanes: function(value) {
		this._customCullPlanes = value;
		return value;
	}
	,get_numMouseEnableds: function() {
		return this._numMouseEnableds;
	}
	,get_skyBox: function() {
		return this._skyBox;
	}
	,get_opaqueRenderableHead: function() {
		return this._opaqueRenderableHead;
	}
	,set_opaqueRenderableHead: function(value) {
		this._opaqueRenderableHead = value;
		return value;
	}
	,get_blendedRenderableHead: function() {
		return this._blendedRenderableHead;
	}
	,set_blendedRenderableHead: function(value) {
		this._blendedRenderableHead = value;
		return value;
	}
	,get_entityHead: function() {
		return this._entityHead;
	}
	,get_lights: function() {
		return this._lights;
	}
	,get_directionalLights: function() {
		return this._directionalLights;
	}
	,get_pointLights: function() {
		return this._pointLights;
	}
	,get_lightProbes: function() {
		return this._lightProbes;
	}
	,clear: function() {
		if(this._camera != null) {
			this._entryPoint = this._camera.get_scenePosition();
			this._cameraForward = away3d_core_math_Matrix3DUtils.getForward(this._camera.get_transform(),this._cameraForward);
		}
		this._cullPlanes = this._customCullPlanes != null ? this._customCullPlanes : this._camera != null ? this._camera.get_frustumPlanes() : null;
		this._numCullPlanes = this._cullPlanes != null ? this._cullPlanes.get_length() : 0;
		this._numTriangles = this._numMouseEnableds = 0;
		this._blendedRenderableHead = null;
		this._opaqueRenderableHead = null;
		this._entityHead = null;
		this._renderableListItemPool.freeAll();
		this._entityListItemPool.freeAll();
		this._skyBox = null;
		if(this._numLights > 0) {
			this._lights.set_length(this._numLights = 0);
		}
		if(this._numDirectionalLights > 0) {
			this._directionalLights.set_length(this._numDirectionalLights = 0);
		}
		if(this._numPointLights > 0) {
			this._pointLights.set_length(this._numPointLights = 0);
		}
		if(this._numLightProbes > 0) {
			this._lightProbes.set_length(this._numLightProbes = 0);
		}
	}
	,enterNode: function(node) {
		var enter = away3d_core_traverse_PartitionTraverser._collectionMark != node._collectionMark && node.isInFrustum(this._cullPlanes,this._numCullPlanes);
		node._collectionMark = away3d_core_traverse_PartitionTraverser._collectionMark;
		return enter;
	}
	,applySkyBox: function(renderable) {
		this._skyBox = renderable;
	}
	,applyRenderable: function(renderable) {
		var entity = renderable.get_sourceEntity();
		if(renderable.get_mouseEnabled()) {
			++this._numMouseEnableds;
		}
		this._numTriangles += renderable.get_numTriangles();
		var material = renderable.get_material();
		if(material != null) {
			var item = this._renderableListItemPool.getItem();
			item.renderable = renderable;
			item.materialId = material._uniqueId;
			item.renderOrderId = material._renderOrderId;
			item.cascaded = false;
			var entityScenePos = entity.get_scenePosition();
			var dx = this._entryPoint.x - entityScenePos.x;
			var dy = this._entryPoint.y - entityScenePos.y;
			var dz = this._entryPoint.z - entityScenePos.z;
			item.zIndex = dx * this._cameraForward.x + dy * this._cameraForward.y + dz * this._cameraForward.z + entity.get_zOffset();
			item.renderSceneTransform = renderable.getRenderSceneTransform(this._camera);
			if(material.get_requiresBlending()) {
				item.next = this._blendedRenderableHead;
				this._blendedRenderableHead = item;
			} else {
				item.next = this._opaqueRenderableHead;
				this._opaqueRenderableHead = item;
			}
		}
	}
	,applyEntity: function(entity) {
		++this._numEntities;
		var item = this._entityListItemPool.getItem();
		item.entity = entity;
		item.next = this._entityHead;
		this._entityHead = item;
	}
	,applyUnknownLight: function(light) {
		this._lights.set(this._numLights++,light);
	}
	,applyDirectionalLight: function(light) {
		this._lights.set(this._numLights++,light);
		this._directionalLights.set(this._numDirectionalLights++,light);
	}
	,applyPointLight: function(light) {
		this._lights.set(this._numLights++,light);
		this._pointLights.set(this._numPointLights++,light);
	}
	,applyLightProbe: function(light) {
		this._lights.set(this._numLights++,light);
		this._lightProbes.set(this._numLightProbes++,light);
	}
	,get_numTriangles: function() {
		return this._numTriangles;
	}
	,cleanUp: function() {
	}
	,__class__: away3d_core_traverse_EntityCollector
	,__properties__: $extend(away3d_core_traverse_PartitionTraverser.prototype.__properties__,{get_numTriangles:"get_numTriangles",get_lightProbes:"get_lightProbes",get_pointLights:"get_pointLights",get_directionalLights:"get_directionalLights",get_lights:"get_lights",get_entityHead:"get_entityHead",set_blendedRenderableHead:"set_blendedRenderableHead",get_blendedRenderableHead:"get_blendedRenderableHead",set_opaqueRenderableHead:"set_opaqueRenderableHead",get_opaqueRenderableHead:"get_opaqueRenderableHead",get_skyBox:"get_skyBox",get_numMouseEnableds:"get_numMouseEnableds",set_cullPlanes:"set_cullPlanes",get_cullPlanes:"get_cullPlanes",set_camera:"set_camera",get_camera:"get_camera"})
});
var away3d_core_traverse_RaycastCollector = function() {
	this._rayDirection = new openfl_geom_Vector3D();
	this._rayPosition = new openfl_geom_Vector3D();
	away3d_core_traverse_EntityCollector.call(this);
};
$hxClasses["away3d.core.traverse.RaycastCollector"] = away3d_core_traverse_RaycastCollector;
away3d_core_traverse_RaycastCollector.__name__ = "away3d.core.traverse.RaycastCollector";
away3d_core_traverse_RaycastCollector.__super__ = away3d_core_traverse_EntityCollector;
away3d_core_traverse_RaycastCollector.prototype = $extend(away3d_core_traverse_EntityCollector.prototype,{
	_rayPosition: null
	,_rayDirection: null
	,get_rayPosition: function() {
		return this._rayPosition;
	}
	,set_rayPosition: function(value) {
		this._rayPosition = value;
		return value;
	}
	,get_rayDirection: function() {
		return this._rayDirection;
	}
	,set_rayDirection: function(value) {
		this._rayDirection = value;
		return value;
	}
	,enterNode: function(node) {
		return node.isIntersectingRay(this._rayPosition,this._rayDirection);
	}
	,applySkyBox: function(renderable) {
	}
	,applyRenderable: function(renderable) {
	}
	,applyUnknownLight: function(light) {
	}
	,__class__: away3d_core_traverse_RaycastCollector
	,__properties__: $extend(away3d_core_traverse_EntityCollector.prototype.__properties__,{set_rayDirection:"set_rayDirection",get_rayDirection:"get_rayDirection",set_rayPosition:"set_rayPosition",get_rayPosition:"get_rayPosition"})
});
var away3d_core_traverse_ShadowCasterCollector = function() {
	away3d_core_traverse_EntityCollector.call(this);
};
$hxClasses["away3d.core.traverse.ShadowCasterCollector"] = away3d_core_traverse_ShadowCasterCollector;
away3d_core_traverse_ShadowCasterCollector.__name__ = "away3d.core.traverse.ShadowCasterCollector";
away3d_core_traverse_ShadowCasterCollector.__super__ = away3d_core_traverse_EntityCollector;
away3d_core_traverse_ShadowCasterCollector.prototype = $extend(away3d_core_traverse_EntityCollector.prototype,{
	applyRenderable: function(renderable) {
		var material = renderable.get_material();
		var entity = renderable.get_sourceEntity();
		if(renderable.get_castsShadows() && material != null) {
			var item = this._renderableListItemPool.getItem();
			item.renderable = renderable;
			item.next = this._opaqueRenderableHead;
			item.cascaded = false;
			var entityScenePos = entity.get_scenePosition();
			var dx = this._entryPoint.x - entityScenePos.x;
			var dy = this._entryPoint.y - entityScenePos.y;
			var dz = this._entryPoint.z - entityScenePos.z;
			item.zIndex = dx * this._cameraForward.x + dy * this._cameraForward.y + dz * this._cameraForward.z;
			item.renderSceneTransform = renderable.getRenderSceneTransform(this._camera);
			item.renderOrderId = material._depthPassId;
			this._opaqueRenderableHead = item;
		}
	}
	,applyUnknownLight: function(light) {
	}
	,applyDirectionalLight: function(light) {
	}
	,applyPointLight: function(light) {
	}
	,applyLightProbe: function(light) {
	}
	,applySkyBox: function(renderable) {
	}
	,__class__: away3d_core_traverse_ShadowCasterCollector
});
var away3d_debug_Debug = function() { };
$hxClasses["away3d.debug.Debug"] = away3d_debug_Debug;
away3d_debug_Debug.__name__ = "away3d.debug.Debug";
away3d_debug_Debug.clear = function() {
};
away3d_debug_Debug.delimiter = function() {
};
away3d_debug_Debug.trace = function(message) {
	if(away3d_debug_Debug.active) {
		haxe_Log.trace(message,{ fileName : "away3d/debug/Debug.hx", lineNumber : 24, className : "away3d.debug.Debug", methodName : "trace"});
	}
};
away3d_debug_Debug.warning = function(message) {
	if(away3d_debug_Debug.warningsAsErrors) {
		away3d_debug_Debug.error(message);
		return;
	}
	haxe_Log.trace("WARNING: " + Std.string(message),{ fileName : "away3d/debug/Debug.hx", lineNumber : 33, className : "away3d.debug.Debug", methodName : "warning"});
};
away3d_debug_Debug.error = function(message) {
	haxe_Log.trace("ERROR: " + Std.string(message),{ fileName : "away3d/debug/Debug.hx", lineNumber : 38, className : "away3d.debug.Debug", methodName : "error"});
	throw new js__$Boot_HaxeError(new openfl_errors_Error(message));
};
var away3d_entities_Mesh = function(geometry,material) {
	this._shareAnimationGeometry = true;
	this._castsShadows = true;
	away3d_entities_Entity.call(this);
	this._subMeshes = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this.set_geometry(geometry != null ? geometry : new away3d_core_base_Geometry());
	this.set_material(material != null ? material : away3d_materials_utils_DefaultMaterialManager.getDefaultMaterial(this));
};
$hxClasses["away3d.entities.Mesh"] = away3d_entities_Mesh;
away3d_entities_Mesh.__name__ = "away3d.entities.Mesh";
away3d_entities_Mesh.__interfaces__ = [away3d_library_assets_IAsset,away3d_core_base_IMaterialOwner];
away3d_entities_Mesh.__super__ = away3d_entities_Entity;
away3d_entities_Mesh.prototype = $extend(away3d_entities_Entity.prototype,{
	_subMeshes: null
	,_geometry: null
	,_material: null
	,_animator: null
	,_castsShadows: null
	,_shareAnimationGeometry: null
	,bakeTransformations: function() {
		this.get_geometry().applyTransformation(this.get_transform());
		this.get_transform().identity();
	}
	,get_assetType: function() {
		return "mesh";
	}
	,onGeometryBoundsInvalid: function(event) {
		this.invalidateBounds();
	}
	,get_castsShadows: function() {
		return this._castsShadows;
	}
	,set_castsShadows: function(value) {
		this._castsShadows = value;
		return value;
	}
	,get_animator: function() {
		return this._animator;
	}
	,set_animator: function(value) {
		if(this._animator != null) {
			this._animator.removeOwner(this);
		}
		this._animator = value;
		var oldMaterial = this.get_material();
		this.set_material(null);
		this.set_material(oldMaterial);
		var len = this._subMeshes.get_length();
		var subMesh;
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			subMesh = this._subMeshes.get(i);
			oldMaterial = subMesh._material;
			if(oldMaterial != null) {
				subMesh.set_material(null);
				subMesh.set_material(oldMaterial);
			}
		}
		if(this._animator != null) {
			this._animator.addOwner(this);
		}
		return value;
	}
	,get_geometry: function() {
		return this._geometry;
	}
	,set_geometry: function(value) {
		var i;
		if(this._geometry != null) {
			this._geometry.removeEventListener("BoundsInvalid",$bind(this,this.onGeometryBoundsInvalid));
			this._geometry.removeEventListener("SubGeometryAdded",$bind(this,this.onSubGeometryAdded));
			this._geometry.removeEventListener("SubGeometryRemoved",$bind(this,this.onSubGeometryRemoved));
			var _g = 0;
			var _g1 = this._subMeshes.get_length();
			while(_g < _g1) {
				var i1 = _g++;
				this._subMeshes.get(i1).dispose();
			}
			this._subMeshes.set_length(0);
		}
		this._geometry = value;
		if(this._geometry != null) {
			this._geometry.addEventListener("BoundsInvalid",$bind(this,this.onGeometryBoundsInvalid));
			this._geometry.addEventListener("SubGeometryAdded",$bind(this,this.onSubGeometryAdded));
			this._geometry.addEventListener("SubGeometryRemoved",$bind(this,this.onSubGeometryRemoved));
			var subGeoms = this._geometry.get_subGeometries();
			var _g2 = 0;
			var _g11 = subGeoms.get_length();
			while(_g2 < _g11) {
				var i2 = _g2++;
				this.addSubMesh(subGeoms.get(i2));
			}
		}
		if(this._material != null) {
			this._material.removeOwner(this);
			this._material.addOwner(this);
		}
		return value;
	}
	,get_material: function() {
		return this._material;
	}
	,set_material: function(value) {
		if(value == this._material) {
			return value;
		}
		if(this._material != null) {
			this._material.removeOwner(this);
		}
		this._material = value;
		if(this._material != null) {
			this._material.addOwner(this);
		}
		return value;
	}
	,get_subMeshes: function() {
		this._geometry.validate();
		return this._subMeshes;
	}
	,get_shareAnimationGeometry: function() {
		return this._shareAnimationGeometry;
	}
	,set_shareAnimationGeometry: function(value) {
		this._shareAnimationGeometry = value;
		return value;
	}
	,clearAnimationGeometry: function() {
		var len = this._subMeshes.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			this._subMeshes.get(i).animationSubGeometry = null;
		}
	}
	,dispose: function() {
		away3d_entities_Entity.prototype.dispose.call(this);
		this.set_material(null);
		this.set_geometry(null);
	}
	,disposeWithAnimatorAndChildren: function() {
		this.disposeWithChildren();
		if(this._animator != null) {
			this._animator.dispose();
		}
	}
	,clone: function() {
		var clone = new away3d_entities_Mesh(this._geometry,this._material);
		clone.set_transform(this.get_transform());
		clone.set_pivotPoint(this.get_pivotPoint());
		clone.set_partition(this.get_partition());
		clone.set_bounds(this._bounds.clone());
		clone.set_name(this.get_name());
		clone.set_castsShadows(this.get_castsShadows());
		clone.set_shareAnimationGeometry(this.get_shareAnimationGeometry());
		clone.set_mouseEnabled(this.get_mouseEnabled());
		clone.set_mouseChildren(this.get_mouseChildren());
		clone.extra = this.extra;
		var len = this._subMeshes.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			clone._subMeshes.get(i)._material = this._subMeshes.get(i)._material;
		}
		len = this.get_numChildren();
		var _g2 = 0;
		var _g3 = len;
		while(_g2 < _g3) {
			var i1 = _g2++;
			clone.addChild(js_Boot.__cast(this.getChildAt(i1).clone() , away3d_containers_ObjectContainer3D));
		}
		if(this._animator != null) {
			clone.set_animator(this._animator.clone());
		}
		return clone;
	}
	,updateBounds: function() {
		this._bounds.fromGeometry(this._geometry);
		this._boundsInvalid = false;
	}
	,createEntityPartitionNode: function() {
		return new away3d_core_partition_MeshNode(this);
	}
	,onSubGeometryAdded: function(event) {
		this.addSubMesh(event.get_subGeometry());
	}
	,onSubGeometryRemoved: function(event) {
		var subMesh;
		var subGeom = event.get_subGeometry();
		var len = this._subMeshes.get_length();
		var i = 0;
		while(i < len) {
			subMesh = this._subMeshes.get(i);
			if(subMesh.get_subGeometry() == subGeom) {
				subMesh.dispose();
				this._subMeshes.splice(i,1);
				break;
			}
			++i;
		}
		--len;
		while(i < len) {
			this._subMeshes.get(i)._index = i;
			++i;
		}
	}
	,addSubMesh: function(subGeometry) {
		var subMesh = new away3d_core_base_SubMesh(subGeometry,this,null);
		var len = this._subMeshes.get_length();
		subMesh._index = len;
		this._subMeshes.set(len,subMesh);
		this.invalidateBounds();
	}
	,getSubMeshForSubGeometry: function(subGeometry) {
		return this._subMeshes.get(this._geometry.get_subGeometries().indexOf(subGeometry,0));
	}
	,collidesBefore: function(shortestCollisionDistance,findClosest) {
		this._pickingCollider.setLocalRay(this._pickingCollisionVO.localRayPosition,this._pickingCollisionVO.localRayDirection);
		this._pickingCollisionVO.renderable = null;
		var len = this._subMeshes.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			var subMesh = this._subMeshes.get(i);
			if(this._pickingCollider.testSubMeshCollision(subMesh,this._pickingCollisionVO,shortestCollisionDistance)) {
				shortestCollisionDistance = this._pickingCollisionVO.rayEntryDistance;
				this._pickingCollisionVO.renderable = subMesh;
				if(!findClosest) {
					return true;
				}
			}
		}
		return this._pickingCollisionVO.renderable != null;
	}
	,__class__: away3d_entities_Mesh
	,__properties__: $extend(away3d_entities_Entity.prototype.__properties__,{set_shareAnimationGeometry:"set_shareAnimationGeometry",get_shareAnimationGeometry:"get_shareAnimationGeometry",get_subMeshes:"get_subMeshes",set_material:"set_material",get_material:"get_material",set_geometry:"set_geometry",get_geometry:"get_geometry",set_animator:"set_animator",get_animator:"get_animator",set_castsShadows:"set_castsShadows",get_castsShadows:"get_castsShadows"})
});
var away3d_entities_SegmentSet = function() {
	this._indexSegments = 0;
	this._numIndices = 0;
	this._subSetCount = 0;
	away3d_entities_Entity.call(this);
	this._subSetCount = 0;
	this._subSets = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this.addSubSet();
	this._segments = new haxe_ds_IntMap();
	this.set_material(new away3d_materials_SegmentMaterial());
};
$hxClasses["away3d.entities.SegmentSet"] = away3d_entities_SegmentSet;
away3d_entities_SegmentSet.__name__ = "away3d.entities.SegmentSet";
away3d_entities_SegmentSet.__interfaces__ = [away3d_core_base_IRenderable];
away3d_entities_SegmentSet.__super__ = away3d_entities_Entity;
away3d_entities_SegmentSet.prototype = $extend(away3d_entities_Entity.prototype,{
	_activeSubSet: null
	,_subSets: null
	,_subSetCount: null
	,_numIndices: null
	,_material: null
	,_animator: null
	,_hasData: null
	,_segments: null
	,_indexSegments: null
	,addSegment: function(segment) {
		segment.set_segmentsBase(this);
		this._hasData = true;
		var subSetIndex = this._subSets.get_length() - 1;
		var subSet = this._subSets.get(subSetIndex);
		if(subSet.vertices.get_length() + 44 > away3d_entities_SegmentSet.LIMIT) {
			subSet = this.addSubSet();
			++subSetIndex;
		}
		segment.set_index(subSet.vertices.get_length());
		segment.set_subSetIndex(subSetIndex);
		this.updateSegment(segment);
		var index = subSet.lineCount << 2;
		subSet.indices.push(index);
		subSet.indices.push(index + 1);
		subSet.indices.push(index + 2);
		subSet.indices.push(index + 3);
		subSet.indices.push(index + 2);
		subSet.indices.push(index + 1);
		subSet.numVertices = subSet.vertices.get_length() / 11 | 0;
		subSet.numIndices = subSet.indices.get_length();
		subSet.lineCount++;
		subSet.indexBufferDirty = true;
		var segRef = new away3d_entities_SegRef();
		segRef.index = index;
		segRef.subSetIndex = subSetIndex;
		segRef.segment = segment;
		this._segments.h[this._indexSegments] = segRef;
		this._indexSegments++;
	}
	,removeSegmentByIndex: function(index,dispose) {
		if(dispose == null) {
			dispose = false;
		}
		var segRef;
		if(index >= this._indexSegments) {
			return;
		}
		if(this._segments.h.hasOwnProperty(index)) {
			segRef = this._segments.h[index];
		} else {
			return;
		}
		if(this._subSets.get(segRef.subSetIndex) == null) {
			return;
		}
		var subSetIndex = segRef.subSetIndex;
		var subSet = this._subSets.get(segRef.subSetIndex);
		var segment = segRef.segment;
		var indices = subSet.indices;
		var ind = index * 6;
		var _g = ind;
		var _g1 = indices.get_length();
		while(_g < _g1) {
			var i = _g++;
			var _g2 = i;
			var _g11 = indices;
			_g11.set(_g2,_g11.get(_g2) - 4);
		}
		subSet.indices.splice(index * 6,6);
		subSet.vertices.splice(index * 44,44);
		subSet.numVertices = subSet.vertices.get_length() / 11 | 0;
		subSet.numIndices = indices.get_length();
		subSet.vertexBufferDirty = true;
		subSet.indexBufferDirty = true;
		subSet.lineCount--;
		if(dispose) {
			segment.dispose();
			segment = null;
		} else {
			segment.set_index(-1);
			segment.set_segmentsBase(null);
		}
		if(subSet.lineCount == 0) {
			if(subSetIndex == 0) {
				this._hasData = false;
			} else {
				subSet.dispose();
				this._subSets.set(subSetIndex,null);
				this._subSets.splice(subSetIndex,1);
			}
		}
		this.reOrderIndices(subSetIndex,index);
		segRef = null;
		this._segments.remove(this._indexSegments);
		this._indexSegments--;
	}
	,removeSegment: function(segment,dispose) {
		if(dispose == null) {
			dispose = false;
		}
		if(segment.get_index() == -1) {
			return;
		}
		this.removeSegmentByIndex(segment.get_index() / 44 | 0);
	}
	,removeAllSegments: function() {
		var subSet;
		var _g = 0;
		var _g1 = this._subSetCount;
		while(_g < _g1) {
			var i = _g++;
			subSet = this._subSets.get(i);
			subSet.vertices = null;
			subSet.indices = null;
			if(subSet.vertexBuffer != null) {
				away3d_core_managers_Stage3DProxy.disposeVertexBuffer(subSet.vertexBuffer);
			}
			if(subSet.indexBuffer != null) {
				away3d_core_managers_Stage3DProxy.disposeIndexBuffer(subSet.indexBuffer);
			}
			subSet = null;
		}
		var segReg = this._segments.iterator();
		while(segReg.hasNext()) {
			var segReg1 = segReg.next();
			segReg1 = null;
		}
		this._segments = null;
		this._subSetCount = 0;
		this._activeSubSet = null;
		this._indexSegments = 0;
		this._subSets = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		this._segments = new haxe_ds_IntMap();
		this.addSubSet();
		this._hasData = false;
	}
	,getSegment: function(index) {
		if(index > this._indexSegments - 1) {
			return null;
		}
		return this._segments.h[index].segment;
	}
	,get_segmentCount: function() {
		return this._indexSegments;
	}
	,get_subSetCount: function() {
		return this._subSetCount;
	}
	,updateSegment: function(segment) {
		var start = segment._start;
		var end = segment._end;
		var startX = start.x;
		var startY = start.y;
		var startZ = start.z;
		var endX = end.x;
		var endY = end.y;
		var endZ = end.z;
		var startR = segment._startR;
		var startG = segment._startG;
		var startB = segment._startB;
		var endR = segment._endR;
		var endG = segment._endG;
		var endB = segment._endB;
		var index = segment.get_index();
		var t = segment.get_thickness();
		var subSet = this._subSets.get(segment.get_subSetIndex());
		var vertices = subSet.vertices;
		vertices.set(index++,startX);
		vertices.set(index++,startY);
		vertices.set(index++,startZ);
		vertices.set(index++,endX);
		vertices.set(index++,endY);
		vertices.set(index++,endZ);
		vertices.set(index++,t);
		vertices.set(index++,startR);
		vertices.set(index++,startG);
		vertices.set(index++,startB);
		vertices.set(index++,1);
		vertices.set(index++,endX);
		vertices.set(index++,endY);
		vertices.set(index++,endZ);
		vertices.set(index++,startX);
		vertices.set(index++,startY);
		vertices.set(index++,startZ);
		vertices.set(index++,-t);
		vertices.set(index++,endR);
		vertices.set(index++,endG);
		vertices.set(index++,endB);
		vertices.set(index++,1);
		vertices.set(index++,startX);
		vertices.set(index++,startY);
		vertices.set(index++,startZ);
		vertices.set(index++,endX);
		vertices.set(index++,endY);
		vertices.set(index++,endZ);
		vertices.set(index++,-t);
		vertices.set(index++,startR);
		vertices.set(index++,startG);
		vertices.set(index++,startB);
		vertices.set(index++,1);
		vertices.set(index++,endX);
		vertices.set(index++,endY);
		vertices.set(index++,endZ);
		vertices.set(index++,startX);
		vertices.set(index++,startY);
		vertices.set(index++,startZ);
		vertices.set(index++,t);
		vertices.set(index++,endR);
		vertices.set(index++,endG);
		vertices.set(index++,endB);
		vertices.set(index++,1);
		subSet.vertexBufferDirty = true;
		this.invalidateBounds();
	}
	,get_hasData: function() {
		return this._hasData;
	}
	,getIndexBuffer: function(stage3DProxy) {
		if(this._activeSubSet.indexContext3D != stage3DProxy.get_context3D() || this._activeSubSet.indexBufferDirty) {
			this._activeSubSet.indexBuffer = stage3DProxy.createIndexBuffer(this._activeSubSet.numIndices);
			this._activeSubSet.indexBuffer.uploadFromVector(this._activeSubSet.indices,0,this._activeSubSet.numIndices);
			this._activeSubSet.indexBufferDirty = false;
			this._activeSubSet.indexContext3D = stage3DProxy.get_context3D();
		}
		return this._activeSubSet.indexBuffer;
	}
	,activateVertexBuffer: function(index,stage3DProxy) {
		var subSet = this._subSets.get(index);
		this._activeSubSet = subSet;
		this._numIndices = subSet.numIndices;
		if(subSet.vertexContext3D != stage3DProxy.get_context3D() || subSet.vertexBufferDirty) {
			if(subSet.vertexBuffer != null) {
				away3d_core_managers_Stage3DProxy.disposeVertexBuffer(subSet.vertexBuffer);
			}
			subSet.vertexBuffer = stage3DProxy.createVertexBuffer(subSet.numVertices,11);
			subSet.vertexBuffer.uploadFromVector(subSet.vertices,0,subSet.numVertices);
			subSet.vertexBufferDirty = false;
			subSet.vertexContext3D = stage3DProxy.get_context3D();
		}
		var vertexBuffer = subSet.vertexBuffer;
		var context3d = stage3DProxy._context3D;
		context3d.setVertexBufferAt(0,vertexBuffer,0,3);
		context3d.setVertexBufferAt(1,vertexBuffer,3,3);
		context3d.setVertexBufferAt(2,vertexBuffer,6,1);
		context3d.setVertexBufferAt(3,vertexBuffer,7,4);
	}
	,activateUVBuffer: function(index,stage3DProxy) {
	}
	,activateVertexNormalBuffer: function(index,stage3DProxy) {
	}
	,activateVertexTangentBuffer: function(index,stage3DProxy) {
	}
	,activateSecondaryUVBuffer: function(index,stage3DProxy) {
	}
	,reOrderIndices: function(subSetIndex,index) {
		var segRef;
		var _g = index;
		var _g1 = this._indexSegments - 1;
		while(_g < _g1) {
			var i = _g++;
			segRef = this._segments.h[i + 1];
			segRef.index = i;
			if(segRef.subSetIndex == subSetIndex) {
				var _g2 = segRef.segment;
				_g2.set_index(_g2.get_index() - 44);
			}
			this._segments.h[i] = segRef;
		}
	}
	,addSubSet: function() {
		var subSet = new away3d_entities_SubSet();
		this._subSets.push(subSet);
		subSet.vertices = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
		subSet.numVertices = 0;
		subSet.indices = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
		subSet.numIndices = 0;
		subSet.vertexBufferDirty = true;
		subSet.indexBufferDirty = true;
		subSet.lineCount = 0;
		this._subSetCount++;
		return subSet;
	}
	,dispose: function() {
		away3d_entities_Entity.prototype.dispose.call(this);
		this.removeAllSegments();
		this._segments = null;
		this._material = null;
		var subSet = this._subSets.get(0);
		subSet.vertices = null;
		subSet.indices = null;
		this._subSets = null;
	}
	,get_mouseEnabled: function() {
		return false;
	}
	,getDefaultBoundingVolume: function() {
		return new away3d_bounds_BoundingSphere();
	}
	,updateBounds: function() {
		var subSet;
		var len;
		var v;
		var index;
		var minX = Infinity;
		var minY = Infinity;
		var minZ = Infinity;
		var maxX = -Infinity;
		var maxY = -Infinity;
		var maxZ = -Infinity;
		var vertices;
		var i = 0;
		while(i < this._subSetCount) {
			subSet = this._subSets.get(i);
			index = 0;
			vertices = subSet.vertices;
			len = vertices.get_length();
			if(len == 0) {
				++i;
				continue;
			}
			while(index < len) {
				v = vertices.get(index++);
				if(v < minX) {
					minX = v;
				} else if(v > maxX) {
					maxX = v;
				}
				v = vertices.get(index++);
				if(v < minY) {
					minY = v;
				} else if(v > maxY) {
					maxY = v;
				}
				v = vertices.get(index++);
				if(v < minZ) {
					minZ = v;
				} else if(v > maxZ) {
					maxZ = v;
				}
				index += 8;
			}
			++i;
		}
		if(minX != Infinity) {
			this._bounds.fromExtremes(minX,minY,minZ,maxX,maxY,maxZ);
		} else {
			var min = .5;
			this._bounds.fromExtremes(-min,-min,-min,min,min,min);
		}
		this._boundsInvalid = false;
	}
	,createEntityPartitionNode: function() {
		return new away3d_core_partition_RenderableNode(this);
	}
	,get_numTriangles: function() {
		return this._numIndices / 3 | 0;
	}
	,get_sourceEntity: function() {
		return this;
	}
	,get_castsShadows: function() {
		return false;
	}
	,get_material: function() {
		return this._material;
	}
	,get_animator: function() {
		return this._animator;
	}
	,set_material: function(value) {
		if(value == this._material) {
			return value;
		}
		if(this._material != null) {
			this._material.removeOwner(this);
		}
		this._material = value;
		if(this._material != null) {
			this._material.addOwner(this);
		}
		return value;
	}
	,get_uvTransform: function() {
		return null;
	}
	,get_uvTransform2: function() {
		return null;
	}
	,get_vertexData: function() {
		return null;
	}
	,get_indexData: function() {
		return null;
	}
	,get_UVData: function() {
		return null;
	}
	,get_numVertices: function() {
		return 0;
	}
	,get_vertexStride: function() {
		return 11;
	}
	,get_vertexNormalData: function() {
		return null;
	}
	,get_vertexTangentData: function() {
		return null;
	}
	,get_vertexOffset: function() {
		return 0;
	}
	,get_vertexNormalOffset: function() {
		return 0;
	}
	,get_vertexTangentOffset: function() {
		return 0;
	}
	,get_assetType: function() {
		return "segmentSet";
	}
	,getRenderSceneTransform: function(camera) {
		return this._sceneTransform;
	}
	,__class__: away3d_entities_SegmentSet
	,__properties__: $extend(away3d_entities_Entity.prototype.__properties__,{get_vertexTangentOffset:"get_vertexTangentOffset",get_vertexNormalOffset:"get_vertexNormalOffset",get_vertexOffset:"get_vertexOffset",get_vertexTangentData:"get_vertexTangentData",get_vertexNormalData:"get_vertexNormalData",get_vertexStride:"get_vertexStride",get_numVertices:"get_numVertices",get_UVData:"get_UVData",get_indexData:"get_indexData",get_vertexData:"get_vertexData",get_uvTransform2:"get_uvTransform2",get_uvTransform:"get_uvTransform",get_animator:"get_animator",set_material:"set_material",get_material:"get_material",get_castsShadows:"get_castsShadows",get_sourceEntity:"get_sourceEntity",get_numTriangles:"get_numTriangles",get_hasData:"get_hasData",get_subSetCount:"get_subSetCount",get_segmentCount:"get_segmentCount"})
});
var away3d_entities_SegRef = function() {
};
$hxClasses["away3d.entities.SegRef"] = away3d_entities_SegRef;
away3d_entities_SegRef.__name__ = "away3d.entities.SegRef";
away3d_entities_SegRef.prototype = {
	index: null
	,subSetIndex: null
	,segment: null
	,__class__: away3d_entities_SegRef
};
var away3d_entities_SubSet = function() {
};
$hxClasses["away3d.entities.SubSet"] = away3d_entities_SubSet;
away3d_entities_SubSet.__name__ = "away3d.entities.SubSet";
away3d_entities_SubSet.prototype = {
	vertices: null
	,numVertices: null
	,indices: null
	,numIndices: null
	,vertexBufferDirty: null
	,indexBufferDirty: null
	,vertexContext3D: null
	,indexContext3D: null
	,vertexBuffer: null
	,indexBuffer: null
	,lineCount: null
	,dispose: function() {
		this.vertices = null;
		if(this.vertexBuffer != null) {
			away3d_core_managers_Stage3DProxy.disposeVertexBuffer(this.vertexBuffer);
		}
		if(this.indexBuffer != null) {
			away3d_core_managers_Stage3DProxy.disposeIndexBuffer(this.indexBuffer);
		}
	}
	,__class__: away3d_entities_SubSet
};
var openfl_errors_Error = function(message,id) {
	if(id == null) {
		id = 0;
	}
	if(message == null) {
		message = "";
	}
	this.message = message;
	this.errorID = id;
	this.name = "Error";
};
$hxClasses["openfl.errors.Error"] = openfl_errors_Error;
openfl_errors_Error.__name__ = "openfl.errors.Error";
openfl_errors_Error.prototype = {
	errorID: null
	,message: null
	,name: null
	,getStackTrace: function() {
		return haxe_CallStack.toString(haxe_CallStack.exceptionStack());
	}
	,toString: function() {
		if(this.message != null) {
			return this.message;
		} else {
			return "Error";
		}
	}
	,__class__: openfl_errors_Error
};
var away3d_errors_AbstractMethodError = function(message,id) {
	if(id == null) {
		id = 0;
	}
	if(message == null) {
		message = "An abstract method was called! Either an instance of an abstract class was created, or an abstract method was not overridden by the subclass.";
	}
	openfl_errors_Error.call(this,message,id);
};
$hxClasses["away3d.errors.AbstractMethodError"] = away3d_errors_AbstractMethodError;
away3d_errors_AbstractMethodError.__name__ = "away3d.errors.AbstractMethodError";
away3d_errors_AbstractMethodError.__super__ = openfl_errors_Error;
away3d_errors_AbstractMethodError.prototype = $extend(openfl_errors_Error.prototype,{
	__class__: away3d_errors_AbstractMethodError
});
var away3d_errors_CastError = function(message) {
	openfl_errors_Error.call(this,message);
};
$hxClasses["away3d.errors.CastError"] = away3d_errors_CastError;
away3d_errors_CastError.__name__ = "away3d.errors.CastError";
away3d_errors_CastError.__super__ = openfl_errors_Error;
away3d_errors_CastError.prototype = $extend(openfl_errors_Error.prototype,{
	__class__: away3d_errors_CastError
});
var away3d_events_AnimatorEvent = function(type,animator) {
	openfl_events_Event.call(this,type,false,false);
	this._animator = animator;
};
$hxClasses["away3d.events.AnimatorEvent"] = away3d_events_AnimatorEvent;
away3d_events_AnimatorEvent.__name__ = "away3d.events.AnimatorEvent";
away3d_events_AnimatorEvent.__super__ = openfl_events_Event;
away3d_events_AnimatorEvent.prototype = $extend(openfl_events_Event.prototype,{
	_animator: null
	,get_animator: function() {
		return this._animator;
	}
	,clone: function() {
		return new away3d_events_AnimatorEvent(this.type,this._animator);
	}
	,__class__: away3d_events_AnimatorEvent
	,__properties__: {get_animator:"get_animator"}
});
var away3d_events_Asset3DEvent = function(type,asset,prevName) {
	openfl_events_Event.call(this,type);
	this._asset = asset;
	if(prevName != null) {
		this._prevName = prevName;
	} else {
		this._prevName = this._asset != null ? this._asset.get_name() : null;
	}
};
$hxClasses["away3d.events.Asset3DEvent"] = away3d_events_Asset3DEvent;
away3d_events_Asset3DEvent.__name__ = "away3d.events.Asset3DEvent";
away3d_events_Asset3DEvent.__super__ = openfl_events_Event;
away3d_events_Asset3DEvent.prototype = $extend(openfl_events_Event.prototype,{
	_asset: null
	,_prevName: null
	,get_asset: function() {
		return this._asset;
	}
	,get_assetPrevName: function() {
		return this._prevName;
	}
	,clone: function() {
		return new away3d_events_Asset3DEvent(this.type,this.get_asset(),this.get_assetPrevName());
	}
	,__class__: away3d_events_Asset3DEvent
	,__properties__: {get_assetPrevName:"get_assetPrevName",get_asset:"get_asset"}
});
var away3d_events_CameraEvent = function(type,camera,bubbles,cancelable) {
	if(cancelable == null) {
		cancelable = false;
	}
	if(bubbles == null) {
		bubbles = false;
	}
	openfl_events_Event.call(this,type,bubbles,cancelable);
	this._camera = camera;
};
$hxClasses["away3d.events.CameraEvent"] = away3d_events_CameraEvent;
away3d_events_CameraEvent.__name__ = "away3d.events.CameraEvent";
away3d_events_CameraEvent.__super__ = openfl_events_Event;
away3d_events_CameraEvent.prototype = $extend(openfl_events_Event.prototype,{
	_camera: null
	,get_camera: function() {
		return this._camera;
	}
	,clone: function() {
		return new away3d_events_CameraEvent(this.type,this._camera,this.bubbles,this.cancelable);
	}
	,__class__: away3d_events_CameraEvent
	,__properties__: {get_camera:"get_camera"}
});
var away3d_events_GeometryEvent = function(type,subGeometry) {
	openfl_events_Event.call(this,type,false,false);
	this._subGeometry = subGeometry;
};
$hxClasses["away3d.events.GeometryEvent"] = away3d_events_GeometryEvent;
away3d_events_GeometryEvent.__name__ = "away3d.events.GeometryEvent";
away3d_events_GeometryEvent.__super__ = openfl_events_Event;
away3d_events_GeometryEvent.prototype = $extend(openfl_events_Event.prototype,{
	_subGeometry: null
	,get_subGeometry: function() {
		return this._subGeometry;
	}
	,clone: function() {
		return new away3d_events_GeometryEvent(this.type,this._subGeometry);
	}
	,__class__: away3d_events_GeometryEvent
	,__properties__: {get_subGeometry:"get_subGeometry"}
});
var away3d_events_LensEvent = function(type,lens,bubbles,cancelable) {
	if(cancelable == null) {
		cancelable = false;
	}
	if(bubbles == null) {
		bubbles = false;
	}
	openfl_events_Event.call(this,type,bubbles,cancelable);
	this._lens = lens;
};
$hxClasses["away3d.events.LensEvent"] = away3d_events_LensEvent;
away3d_events_LensEvent.__name__ = "away3d.events.LensEvent";
away3d_events_LensEvent.__super__ = openfl_events_Event;
away3d_events_LensEvent.prototype = $extend(openfl_events_Event.prototype,{
	_lens: null
	,get_lens: function() {
		return this._lens;
	}
	,clone: function() {
		return new away3d_events_LensEvent(this.type,this._lens,this.bubbles,this.cancelable);
	}
	,__class__: away3d_events_LensEvent
	,__properties__: {get_lens:"get_lens"}
});
var away3d_events_LightEvent = function(type) {
	openfl_events_Event.call(this,type);
};
$hxClasses["away3d.events.LightEvent"] = away3d_events_LightEvent;
away3d_events_LightEvent.__name__ = "away3d.events.LightEvent";
away3d_events_LightEvent.__super__ = openfl_events_Event;
away3d_events_LightEvent.prototype = $extend(openfl_events_Event.prototype,{
	clone: function() {
		return new away3d_events_LightEvent(this.type);
	}
	,__class__: away3d_events_LightEvent
});
var away3d_events_Object3DEvent = function(type,object) {
	openfl_events_Event.call(this,type);
	this.object = object;
};
$hxClasses["away3d.events.Object3DEvent"] = away3d_events_Object3DEvent;
away3d_events_Object3DEvent.__name__ = "away3d.events.Object3DEvent";
away3d_events_Object3DEvent.__super__ = openfl_events_Event;
away3d_events_Object3DEvent.prototype = $extend(openfl_events_Event.prototype,{
	object: null
	,clone: function() {
		return new away3d_events_Object3DEvent(this.type,this.object);
	}
	,__class__: away3d_events_Object3DEvent
});
var away3d_events_Scene3DEvent = function(type,objectContainer) {
	this.objectContainer3D = objectContainer;
	openfl_events_Event.call(this,type);
};
$hxClasses["away3d.events.Scene3DEvent"] = away3d_events_Scene3DEvent;
away3d_events_Scene3DEvent.__name__ = "away3d.events.Scene3DEvent";
away3d_events_Scene3DEvent.__super__ = openfl_events_Event;
away3d_events_Scene3DEvent.prototype = $extend(openfl_events_Event.prototype,{
	objectContainer3D: null
	,clone: function() {
		return new away3d_events_Scene3DEvent(this.type,this.objectContainer3D);
	}
	,__class__: away3d_events_Scene3DEvent
});
var away3d_events_ShadingMethodEvent = function(type,bubbles,cancelable) {
	if(cancelable == null) {
		cancelable = false;
	}
	if(bubbles == null) {
		bubbles = false;
	}
	openfl_events_Event.call(this,type,bubbles,cancelable);
};
$hxClasses["away3d.events.ShadingMethodEvent"] = away3d_events_ShadingMethodEvent;
away3d_events_ShadingMethodEvent.__name__ = "away3d.events.ShadingMethodEvent";
away3d_events_ShadingMethodEvent.__super__ = openfl_events_Event;
away3d_events_ShadingMethodEvent.prototype = $extend(openfl_events_Event.prototype,{
	__class__: away3d_events_ShadingMethodEvent
});
var away3d_events_Stage3DEvent = function(type,bubbles,cancelable) {
	if(cancelable == null) {
		cancelable = false;
	}
	if(bubbles == null) {
		bubbles = false;
	}
	openfl_events_Event.call(this,type,bubbles,cancelable);
};
$hxClasses["away3d.events.Stage3DEvent"] = away3d_events_Stage3DEvent;
away3d_events_Stage3DEvent.__name__ = "away3d.events.Stage3DEvent";
away3d_events_Stage3DEvent.__super__ = openfl_events_Event;
away3d_events_Stage3DEvent.prototype = $extend(openfl_events_Event.prototype,{
	__class__: away3d_events_Stage3DEvent
});
var away3d_events_TouchEvent3D = function(type) {
	this._allowedToPropagate = true;
	openfl_events_Event.call(this,type,true,true);
};
$hxClasses["away3d.events.TouchEvent3D"] = away3d_events_TouchEvent3D;
away3d_events_TouchEvent3D.__name__ = "away3d.events.TouchEvent3D";
away3d_events_TouchEvent3D.__super__ = openfl_events_Event;
away3d_events_TouchEvent3D.prototype = $extend(openfl_events_Event.prototype,{
	_allowedToPropagate: null
	,_parentEvent: null
	,screenX: null
	,screenY: null
	,view: null
	,object: null
	,renderable: null
	,material: null
	,uv: null
	,index: null
	,subGeometryIndex: null
	,localPosition: null
	,localNormal: null
	,ctrlKey: null
	,altKey: null
	,shiftKey: null
	,touchPointID: null
	,stopPropagation: function() {
		openfl_events_Event.prototype.stopPropagation.call(this);
		this._allowedToPropagate = false;
		if(this._parentEvent != null) {
			this._parentEvent._allowedToPropagate = false;
		}
	}
	,stopImmediatePropagation: function() {
		openfl_events_Event.prototype.stopImmediatePropagation.call(this);
		this._allowedToPropagate = false;
		if(this._parentEvent != null) {
			this._parentEvent._allowedToPropagate = false;
		}
	}
	,clone: function() {
		var result = new away3d_events_TouchEvent3D(this.type);
		result.screenX = this.screenX;
		result.screenY = this.screenY;
		result.view = this.view;
		result.object = this.object;
		result.renderable = this.renderable;
		result.material = this.material;
		result.uv = this.uv;
		result.localPosition = this.localPosition;
		result.localNormal = this.localNormal;
		result.index = this.index;
		result.subGeometryIndex = this.subGeometryIndex;
		result.ctrlKey = this.ctrlKey;
		result.shiftKey = this.shiftKey;
		result._parentEvent = this;
		return result;
	}
	,get_scenePosition: function() {
		if(((this.object) instanceof away3d_containers_ObjectContainer3D)) {
			return (js_Boot.__cast(this.object , away3d_containers_ObjectContainer3D)).get_sceneTransform().transformVector(this.localPosition);
		} else {
			return this.localPosition;
		}
	}
	,get_sceneNormal: function() {
		if(((this.object) instanceof away3d_containers_ObjectContainer3D)) {
			var sceneNormal = (js_Boot.__cast(this.object , away3d_containers_ObjectContainer3D)).get_sceneTransform().deltaTransformVector(this.localNormal);
			sceneNormal.normalize();
			return sceneNormal;
		} else {
			return this.localNormal;
		}
	}
	,__class__: away3d_events_TouchEvent3D
	,__properties__: {get_sceneNormal:"get_sceneNormal",get_scenePosition:"get_scenePosition"}
});
var away3d_filters_Filter3DBase = function() {
	this._tasks = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
};
$hxClasses["away3d.filters.Filter3DBase"] = away3d_filters_Filter3DBase;
away3d_filters_Filter3DBase.__name__ = "away3d.filters.Filter3DBase";
away3d_filters_Filter3DBase.prototype = {
	_tasks: null
	,_requireDepthRender: null
	,_textureWidth: null
	,_textureHeight: null
	,get_requireDepthRender: function() {
		return this._requireDepthRender;
	}
	,addTask: function(filter) {
		this._tasks.push(filter);
		if(!this._requireDepthRender) {
			this._requireDepthRender = filter.get_requireDepthRender();
		}
	}
	,get_tasks: function() {
		return this._tasks;
	}
	,getMainInputTexture: function(stage3DProxy) {
		return this._tasks.get(0).getMainInputTexture(stage3DProxy);
	}
	,get_textureWidth: function() {
		return this._textureWidth;
	}
	,set_textureWidth: function(value) {
		this._textureWidth = value;
		var _g = 0;
		var _g1 = this._tasks.get_length();
		while(_g < _g1) {
			var i = _g++;
			this._tasks.get(i).set_textureWidth(value);
		}
		return value;
	}
	,get_textureHeight: function() {
		return this._textureHeight;
	}
	,set_textureHeight: function(value) {
		this._textureHeight = value;
		var _g = 0;
		var _g1 = this._tasks.get_length();
		while(_g < _g1) {
			var i = _g++;
			this._tasks.get(i).set_textureHeight(value);
		}
		return value;
	}
	,setRenderTargets: function(mainTarget,stage3DProxy) {
		this._tasks.get(this._tasks.get_length() - 1).set_target(mainTarget);
	}
	,dispose: function() {
		var _g = 0;
		var _g1 = this._tasks.get_length();
		while(_g < _g1) {
			var i = _g++;
			this._tasks.get(i).dispose();
		}
	}
	,update: function(stage,camera) {
	}
	,__class__: away3d_filters_Filter3DBase
	,__properties__: {set_textureHeight:"set_textureHeight",get_textureHeight:"get_textureHeight",set_textureWidth:"set_textureWidth",get_textureWidth:"get_textureWidth",get_tasks:"get_tasks",get_requireDepthRender:"get_requireDepthRender"}
};
var away3d_filters_tasks_Filter3DTaskBase = function(requireDepthRender) {
	if(requireDepthRender == null) {
		requireDepthRender = false;
	}
	this._textureScale = 0;
	this._program3DInvalid = true;
	this._textureDimensionsInvalid = true;
	this._textureHeight = -1;
	this._textureWidth = -1;
	this._scaledTextureHeight = -1;
	this._scaledTextureWidth = -1;
	this._requireDepthRender = requireDepthRender;
};
$hxClasses["away3d.filters.tasks.Filter3DTaskBase"] = away3d_filters_tasks_Filter3DTaskBase;
away3d_filters_tasks_Filter3DTaskBase.__name__ = "away3d.filters.tasks.Filter3DTaskBase";
away3d_filters_tasks_Filter3DTaskBase.prototype = {
	_mainInputTexture: null
	,_mainInputTextureContext: null
	,_scaledTextureWidth: null
	,_scaledTextureHeight: null
	,_textureWidth: null
	,_textureHeight: null
	,_textureDimensionsInvalid: null
	,_program3DInvalid: null
	,_program3D: null
	,_program3DContext: null
	,_target: null
	,_requireDepthRender: null
	,_textureScale: null
	,get_textureScale: function() {
		return this._textureScale;
	}
	,set_textureScale: function(value) {
		if(this._textureScale == value) {
			return value;
		}
		this._textureScale = value;
		this._scaledTextureWidth = this._textureWidth >> this._textureScale;
		this._scaledTextureHeight = this._textureHeight >> this._textureScale;
		this._textureDimensionsInvalid = true;
		return value;
	}
	,get_target: function() {
		return this._target;
	}
	,set_target: function(value) {
		this._target = value;
		return value;
	}
	,get_textureWidth: function() {
		return this._textureWidth;
	}
	,set_textureWidth: function(value) {
		if(this._textureWidth == value) {
			return value;
		}
		this._textureWidth = value;
		this._scaledTextureWidth = this._textureWidth >> this._textureScale;
		if(this._scaledTextureWidth < 1) {
			this._scaledTextureWidth = 1;
		}
		this._textureDimensionsInvalid = true;
		return value;
	}
	,get_textureHeight: function() {
		return this._textureHeight;
	}
	,set_textureHeight: function(value) {
		if(this._textureHeight == value) {
			return value;
		}
		this._textureHeight = value;
		this._scaledTextureHeight = this._textureHeight >> this._textureScale;
		if(this._scaledTextureHeight < 1) {
			this._scaledTextureHeight = 1;
		}
		this._textureDimensionsInvalid = true;
		return value;
	}
	,getMainInputTexture: function(stage) {
		if(stage.get_context3D() != this._mainInputTextureContext) {
			this._textureDimensionsInvalid = true;
		}
		if(this._textureDimensionsInvalid) {
			this.updateTextures(stage);
		}
		return this._mainInputTexture;
	}
	,dispose: function() {
		if(this._mainInputTexture != null) {
			this._mainInputTexture.dispose();
		}
		if(this._program3D != null) {
			this._program3D.dispose();
		}
		this._program3DContext = null;
	}
	,invalidateProgram3D: function() {
		this._program3DInvalid = true;
	}
	,updateProgram3D: function(stage) {
		if(this._program3D != null) {
			this._program3D.dispose();
		}
		this._program3DContext = stage.get_context3D();
		this._program3D = this._program3DContext.createProgram();
		this._program3D.upload(new openfl_utils_AGALMiniAssembler(away3d_debug_Debug.active).assemble(openfl_display3D__$Context3DProgramType_Context3DProgramType_$Impl_$.toString(1),this.getVertexCode()),new openfl_utils_AGALMiniAssembler(away3d_debug_Debug.active).assemble(openfl_display3D__$Context3DProgramType_Context3DProgramType_$Impl_$.toString(0),this.getFragmentCode()));
		this._program3DInvalid = false;
	}
	,getVertexCode: function() {
		return "mov op, va0\n" + "mov v0, va1\n";
	}
	,getFragmentCode: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,updateTextures: function(stage) {
		if(this._mainInputTexture != null) {
			this._mainInputTexture.dispose();
		}
		this._mainInputTextureContext = stage.get_context3D();
		this._mainInputTexture = this._mainInputTextureContext.createTexture(this._scaledTextureWidth,this._scaledTextureHeight,1,true);
		this._textureDimensionsInvalid = false;
	}
	,getProgram3D: function(stage3DProxy) {
		if(this._program3DContext != stage3DProxy.get_context3D()) {
			this._program3DInvalid = true;
		}
		if(this._program3DInvalid) {
			this.updateProgram3D(stage3DProxy);
		}
		return this._program3D;
	}
	,activate: function(stage3DProxy,camera,depthTexture) {
	}
	,deactivate: function(stage3DProxy) {
	}
	,get_requireDepthRender: function() {
		return this._requireDepthRender;
	}
	,__class__: away3d_filters_tasks_Filter3DTaskBase
	,__properties__: {get_requireDepthRender:"get_requireDepthRender",set_textureHeight:"set_textureHeight",get_textureHeight:"get_textureHeight",set_textureWidth:"set_textureWidth",get_textureWidth:"get_textureWidth",set_target:"set_target",get_target:"get_target",set_textureScale:"set_textureScale",get_textureScale:"get_textureScale"}
};
var away3d_library_assets_Asset3DType = function() { };
$hxClasses["away3d.library.assets.Asset3DType"] = away3d_library_assets_Asset3DType;
away3d_library_assets_Asset3DType.__name__ = "away3d.library.assets.Asset3DType";
var away3d_lights_LightBase = function() {
	this._diffuseB = 1;
	this._diffuseG = 1;
	this._diffuseR = 1;
	this._diffuse = 1;
	this._specularB = 1;
	this._specularG = 1;
	this._specularR = 1;
	this._specular = 1;
	this._ambientB = 0;
	this._ambientG = 0;
	this._ambientR = 0;
	this._ambient = 0;
	this._ambientColor = 16777215;
	this._colorB = 1;
	this._colorG = 1;
	this._colorR = 1;
	this._color = 16777215;
	away3d_entities_Entity.call(this);
};
$hxClasses["away3d.lights.LightBase"] = away3d_lights_LightBase;
away3d_lights_LightBase.__name__ = "away3d.lights.LightBase";
away3d_lights_LightBase.__super__ = away3d_entities_Entity;
away3d_lights_LightBase.prototype = $extend(away3d_entities_Entity.prototype,{
	_color: null
	,_colorR: null
	,_colorG: null
	,_colorB: null
	,_ambientColor: null
	,_ambient: null
	,_ambientR: null
	,_ambientG: null
	,_ambientB: null
	,_specular: null
	,_specularR: null
	,_specularG: null
	,_specularB: null
	,_diffuse: null
	,_diffuseR: null
	,_diffuseG: null
	,_diffuseB: null
	,_castsShadows: null
	,_shadowMapper: null
	,get_castsShadows: function() {
		return this._castsShadows;
	}
	,set_castsShadows: function(value) {
		if(this._castsShadows == value) {
			return value;
		}
		this._castsShadows = value;
		if(value) {
			if(this._shadowMapper == null) {
				this._shadowMapper = this.createShadowMapper();
			}
			this._shadowMapper.set_light(this);
		} else {
			if(this._shadowMapper != null) {
				this._shadowMapper.dispose();
			}
			this._shadowMapper = null;
		}
		this.dispatchEvent(new away3d_events_LightEvent("castsShadowChange"));
		return value;
	}
	,createShadowMapper: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,get_specular: function() {
		return this._specular;
	}
	,set_specular: function(value) {
		if(value < 0) {
			value = 0;
		}
		this._specular = value;
		this.updateSpecular();
		return value;
	}
	,get_diffuse: function() {
		return this._diffuse;
	}
	,set_diffuse: function(value) {
		if(value < 0) {
			value = 0;
		}
		this._diffuse = value;
		this.updateDiffuse();
		return value;
	}
	,get_color: function() {
		return this._color;
	}
	,set_color: function(value) {
		this._color = value;
		this._colorR = (this._color >> 16 & 255) / 255;
		this._colorG = (this._color >> 8 & 255) / 255;
		this._colorB = (this._color & 255) / 255;
		this.updateDiffuse();
		this.updateSpecular();
		return value;
	}
	,get_ambient: function() {
		return this._ambient;
	}
	,set_ambient: function(value) {
		if(value < 0) {
			value = 0;
		} else if(value > 1) {
			value = 1;
		}
		this._ambient = value;
		this.updateAmbient();
		return value;
	}
	,get_ambientColor: function() {
		return this._ambientColor;
	}
	,set_ambientColor: function(value) {
		this._ambientColor = value;
		this.updateAmbient();
		return value;
	}
	,updateAmbient: function() {
		this._ambientR = (this._ambientColor >> 16 & 255) / 255 * this._ambient;
		this._ambientG = (this._ambientColor >> 8 & 255) / 255 * this._ambient;
		this._ambientB = (this._ambientColor & 255) / 255 * this._ambient;
	}
	,getObjectProjectionMatrix: function(renderable,camera,target) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,createEntityPartitionNode: function() {
		return new away3d_core_partition_LightNode(this);
	}
	,get_assetType: function() {
		return "light";
	}
	,updateSpecular: function() {
		this._specularR = this._colorR * this._specular;
		this._specularG = this._colorG * this._specular;
		this._specularB = this._colorB * this._specular;
	}
	,updateDiffuse: function() {
		this._diffuseR = this._colorR * this._diffuse;
		this._diffuseG = this._colorG * this._diffuse;
		this._diffuseB = this._colorB * this._diffuse;
	}
	,get_shadowMapper: function() {
		return this._shadowMapper;
	}
	,set_shadowMapper: function(value) {
		this._shadowMapper = value;
		this._shadowMapper.set_light(this);
		return value;
	}
	,__class__: away3d_lights_LightBase
	,__properties__: $extend(away3d_entities_Entity.prototype.__properties__,{set_shadowMapper:"set_shadowMapper",get_shadowMapper:"get_shadowMapper",set_ambientColor:"set_ambientColor",get_ambientColor:"get_ambientColor",set_ambient:"set_ambient",get_ambient:"get_ambient",set_color:"set_color",get_color:"get_color",set_diffuse:"set_diffuse",get_diffuse:"get_diffuse",set_specular:"set_specular",get_specular:"get_specular",set_castsShadows:"set_castsShadows",get_castsShadows:"get_castsShadows"})
});
var away3d_lights_DirectionalLight = function(xDir,yDir,zDir) {
	if(zDir == null) {
		zDir = 1;
	}
	if(yDir == null) {
		yDir = -1;
	}
	if(xDir == null) {
		xDir = 0;
	}
	away3d_lights_LightBase.call(this);
	this.set_direction(new openfl_geom_Vector3D(xDir,yDir,zDir));
	this._sceneDirection = new openfl_geom_Vector3D();
};
$hxClasses["away3d.lights.DirectionalLight"] = away3d_lights_DirectionalLight;
away3d_lights_DirectionalLight.__name__ = "away3d.lights.DirectionalLight";
away3d_lights_DirectionalLight.__super__ = away3d_lights_LightBase;
away3d_lights_DirectionalLight.prototype = $extend(away3d_lights_LightBase.prototype,{
	_direction: null
	,_tmpLookAt: null
	,_sceneDirection: null
	,_projAABBPoints: null
	,createEntityPartitionNode: function() {
		return new away3d_core_partition_DirectionalLightNode(this);
	}
	,get_sceneDirection: function() {
		if(this._sceneTransformDirty) {
			this.updateSceneTransform();
		}
		return this._sceneDirection;
	}
	,get_direction: function() {
		return this._direction;
	}
	,set_direction: function(value) {
		this._direction = value;
		if(this._tmpLookAt == null) {
			this._tmpLookAt = new openfl_geom_Vector3D();
		}
		var tmp = this.get_x();
		this._tmpLookAt.x = tmp + this._direction.x;
		var tmp1 = this.get_y();
		this._tmpLookAt.y = tmp1 + this._direction.y;
		var tmp2 = this.get_z();
		this._tmpLookAt.z = tmp2 + this._direction.z;
		this.lookAt(this._tmpLookAt);
		return value;
	}
	,getDefaultBoundingVolume: function() {
		return new away3d_bounds_NullBounds();
	}
	,updateBounds: function() {
	}
	,updateSceneTransform: function() {
		away3d_lights_LightBase.prototype.updateSceneTransform.call(this);
		this.get_sceneTransform().copyColumnTo(2,this._sceneDirection);
		this._sceneDirection.normalize();
	}
	,createShadowMapper: function() {
		return new away3d_lights_shadowmaps_DirectionalShadowMapper();
	}
	,getObjectProjectionMatrix: function(renderable,camera,target) {
		var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
		var bounds = renderable.get_sourceEntity().get_bounds();
		var m = new openfl_geom_Matrix3D();
		m.copyFrom(renderable.getRenderSceneTransform(camera));
		m.append(this.get_inverseSceneTransform());
		if(this._projAABBPoints == null) {
			this._projAABBPoints = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
		}
		m.transformVectors(bounds.get_aabbPoints(),this._projAABBPoints);
		var xMin = Infinity;
		var xMax = -Infinity;
		var yMin = Infinity;
		var yMax = -Infinity;
		var zMin = Infinity;
		var zMax = -Infinity;
		var d;
		var i = 0;
		while(i < 24) {
			d = this._projAABBPoints.get(i++);
			if(d < xMin) {
				xMin = d;
			}
			if(d > xMax) {
				xMax = d;
			}
			d = this._projAABBPoints.get(i++);
			if(d < yMin) {
				yMin = d;
			}
			if(d > yMax) {
				yMax = d;
			}
			d = this._projAABBPoints.get(i++);
			if(d < zMin) {
				zMin = d;
			}
			if(d > zMax) {
				zMax = d;
			}
		}
		var invXRange = 1 / (xMax - xMin);
		var invYRange = 1 / (yMax - yMin);
		var invZRange = 1 / (zMax - zMin);
		raw.set(0,2 * invXRange);
		raw.set(5,2 * invYRange);
		raw.set(10,invZRange);
		raw.set(12,-(xMax + xMin) * invXRange);
		raw.set(13,-(yMax + yMin) * invYRange);
		raw.set(14,-zMin * invZRange);
		raw.set(1,raw.set(2,raw.set(3,raw.set(4,raw.set(6,raw.set(7,raw.set(8,raw.set(9,raw.set(11,0)))))))));
		raw.set(15,1);
		if(target == null) {
			target = new openfl_geom_Matrix3D();
		}
		target.copyRawDataFrom(raw);
		target.prepend(m);
		return target;
	}
	,__class__: away3d_lights_DirectionalLight
	,__properties__: $extend(away3d_lights_LightBase.prototype.__properties__,{set_direction:"set_direction",get_direction:"get_direction",get_sceneDirection:"get_sceneDirection"})
});
var away3d_lights_LightProbe = function(diffuseMap,specularMap) {
	away3d_lights_LightBase.call(this);
	this._diffuseMap = diffuseMap;
	this._specularMap = specularMap;
};
$hxClasses["away3d.lights.LightProbe"] = away3d_lights_LightProbe;
away3d_lights_LightProbe.__name__ = "away3d.lights.LightProbe";
away3d_lights_LightProbe.__super__ = away3d_lights_LightBase;
away3d_lights_LightProbe.prototype = $extend(away3d_lights_LightBase.prototype,{
	_diffuseMap: null
	,_specularMap: null
	,createEntityPartitionNode: function() {
		return new away3d_core_partition_LightProbeNode(this);
	}
	,get_diffuseMap: function() {
		return this._diffuseMap;
	}
	,set_diffuseMap: function(value) {
		this._diffuseMap = value;
		return value;
	}
	,get_specularMap: function() {
		return this._specularMap;
	}
	,set_specularMap: function(value) {
		this._specularMap = value;
		return value;
	}
	,updateBounds: function() {
		this._boundsInvalid = false;
	}
	,getDefaultBoundingVolume: function() {
		return new away3d_bounds_NullBounds();
	}
	,getObjectProjectionMatrix: function(renderable,camera,target) {
		throw new js__$Boot_HaxeError(new openfl_errors_Error("Object projection matrices are not supported for LightProbe objects!"));
	}
	,__class__: away3d_lights_LightProbe
	,__properties__: $extend(away3d_lights_LightBase.prototype.__properties__,{set_specularMap:"set_specularMap",get_specularMap:"get_specularMap",set_diffuseMap:"set_diffuseMap",get_diffuseMap:"get_diffuseMap"})
});
var away3d_lights_PointLight = function() {
	this._fallOff = 100000;
	this._radius = 90000;
	away3d_lights_LightBase.call(this);
	this._fallOffFactor = 1 / (this._fallOff * this._fallOff - this._radius * this._radius);
};
$hxClasses["away3d.lights.PointLight"] = away3d_lights_PointLight;
away3d_lights_PointLight.__name__ = "away3d.lights.PointLight";
away3d_lights_PointLight.__super__ = away3d_lights_LightBase;
away3d_lights_PointLight.prototype = $extend(away3d_lights_LightBase.prototype,{
	_radius: null
	,_fallOff: null
	,_fallOffFactor: null
	,createShadowMapper: function() {
		return new away3d_lights_shadowmaps_CubeMapShadowMapper();
	}
	,createEntityPartitionNode: function() {
		return new away3d_core_partition_PointLightNode(this);
	}
	,get_radius: function() {
		return this._radius;
	}
	,set_radius: function(value) {
		this._radius = value;
		if(this._radius < 0) {
			this._radius = 0;
		} else if(this._radius > this._fallOff) {
			this._fallOff = this._radius;
			this.invalidateBounds();
		}
		this._fallOffFactor = 1 / (this._fallOff * this._fallOff - this._radius * this._radius);
		return value;
	}
	,fallOffFactor: function() {
		return this._fallOffFactor;
	}
	,get_fallOff: function() {
		return this._fallOff;
	}
	,set_fallOff: function(value) {
		this._fallOff = value;
		if(this._fallOff < 0) {
			this._fallOff = 0;
		}
		if(this._fallOff < this._radius) {
			this._radius = this._fallOff;
		}
		this._fallOffFactor = 1 / (this._fallOff * this._fallOff - this._radius * this._radius);
		this.invalidateBounds();
		return value;
	}
	,updateBounds: function() {
		this._bounds.fromSphere(new openfl_geom_Vector3D(),this._fallOff);
		this._boundsInvalid = false;
	}
	,getDefaultBoundingVolume: function() {
		return new away3d_bounds_BoundingSphere();
	}
	,getObjectProjectionMatrix: function(renderable,camera,target) {
		var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
		var bounds = renderable.get_sourceEntity().get_bounds();
		var m = new openfl_geom_Matrix3D();
		m.copyFrom(renderable.getRenderSceneTransform(camera));
		m.append(this._parent.get_inverseSceneTransform());
		this.lookAt(m.get_position());
		m.copyFrom(renderable.getRenderSceneTransform(camera));
		m.append(this.get_inverseSceneTransform());
		m.copyColumnTo(3,this._pos);
		var v1 = m.deltaTransformVector(bounds.get_min());
		var v2 = m.deltaTransformVector(bounds.get_max());
		var z = this._pos.z;
		var d1 = v1.x * v1.x + v1.y * v1.y + v1.z * v1.z;
		var d2 = v2.x * v2.x + v2.y * v2.y + v2.z * v2.z;
		var d = Math.sqrt(d1 > d2 ? d1 : d2);
		var zMin = z - d;
		var zMax = z + d;
		raw.set(5,raw.set(0,zMin / d));
		raw.set(10,zMax / (zMax - zMin));
		raw.set(11,1);
		raw.set(1,raw.set(2,raw.set(3,raw.set(4,raw.set(6,raw.set(7,raw.set(8,raw.set(9,raw.set(12,raw.set(13,raw.set(15,0)))))))))));
		raw.set(14,-zMin * raw.get(10));
		if(target == null) {
			target = new openfl_geom_Matrix3D();
		}
		target.copyRawDataFrom(raw);
		target.prepend(m);
		return target;
	}
	,__class__: away3d_lights_PointLight
	,__properties__: $extend(away3d_lights_LightBase.prototype.__properties__,{set_fallOff:"set_fallOff",get_fallOff:"get_fallOff",set_radius:"set_radius",get_radius:"get_radius"})
});
var away3d_lights_shadowmaps_ShadowMapperBase = function() {
	this._autoUpdateShadows = true;
	this._depthMapSize = 2048;
	this._casterCollector = this.createCasterCollector();
};
$hxClasses["away3d.lights.shadowmaps.ShadowMapperBase"] = away3d_lights_shadowmaps_ShadowMapperBase;
away3d_lights_shadowmaps_ShadowMapperBase.__name__ = "away3d.lights.shadowmaps.ShadowMapperBase";
away3d_lights_shadowmaps_ShadowMapperBase.prototype = {
	_casterCollector: null
	,_depthMap: null
	,_depthMapSize: null
	,_light: null
	,_explicitDepthMap: null
	,_autoUpdateShadows: null
	,_shadowsInvalid: null
	,createCasterCollector: function() {
		return new away3d_core_traverse_ShadowCasterCollector();
	}
	,get_autoUpdateShadows: function() {
		return this._autoUpdateShadows;
	}
	,set_autoUpdateShadows: function(value) {
		this._autoUpdateShadows = value;
		return value;
	}
	,updateShadows: function() {
		this._shadowsInvalid = true;
	}
	,setDepthMap: function(depthMap) {
		if(this._depthMap == depthMap) {
			return;
		}
		if(this._depthMap != null && !this._explicitDepthMap) {
			this._depthMap.dispose();
		}
		this._depthMap = depthMap;
		if(this._depthMap != null) {
			this._explicitDepthMap = true;
			this._depthMapSize = this._depthMap.get_width();
		} else {
			this._explicitDepthMap = false;
		}
	}
	,get_light: function() {
		return this._light;
	}
	,set_light: function(value) {
		this._light = value;
		return value;
	}
	,get_depthMap: function() {
		if(this._depthMap == null) {
			this._depthMap = this.createDepthTexture();
		}
		return this._depthMap;
	}
	,get_depthMapSize: function() {
		return this._depthMapSize;
	}
	,set_depthMapSize: function(value) {
		if(value == this._depthMapSize) {
			return value;
		}
		this._depthMapSize = value;
		if(this._explicitDepthMap) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Cannot set depth map size for the current renderer."));
		} else if(this._depthMap != null) {
			this._depthMap.dispose();
			this._depthMap = null;
		}
		return value;
	}
	,dispose: function() {
		this._casterCollector = null;
		if(this._depthMap != null && !this._explicitDepthMap) {
			this._depthMap.dispose();
		}
		this._depthMap = null;
	}
	,createDepthTexture: function() {
		return new away3d_textures_RenderTexture(this._depthMapSize,this._depthMapSize);
	}
	,renderDepthMap: function(stage3DProxy,entityCollector,renderer) {
		this._shadowsInvalid = false;
		this.updateDepthProjection(entityCollector.get_camera());
		if(this._depthMap == null) {
			this._depthMap = this.createDepthTexture();
		}
		this.drawDepthMap(this._depthMap.getTextureForStage3D(stage3DProxy),entityCollector.scene,renderer);
	}
	,updateDepthProjection: function(viewCamera) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,drawDepthMap: function(target,scene,renderer) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,__class__: away3d_lights_shadowmaps_ShadowMapperBase
	,__properties__: {set_depthMapSize:"set_depthMapSize",get_depthMapSize:"get_depthMapSize",get_depthMap:"get_depthMap",set_light:"set_light",get_light:"get_light",set_autoUpdateShadows:"set_autoUpdateShadows",get_autoUpdateShadows:"get_autoUpdateShadows"}
};
var away3d_lights_shadowmaps_CubeMapShadowMapper = function() {
	away3d_lights_shadowmaps_ShadowMapperBase.call(this);
	this._depthMapSize = 512;
	this._needsRender = openfl__$Vector_Vector_$Impl_$.toBoolVector(null,6,true);
	this.initCameras();
};
$hxClasses["away3d.lights.shadowmaps.CubeMapShadowMapper"] = away3d_lights_shadowmaps_CubeMapShadowMapper;
away3d_lights_shadowmaps_CubeMapShadowMapper.__name__ = "away3d.lights.shadowmaps.CubeMapShadowMapper";
away3d_lights_shadowmaps_CubeMapShadowMapper.__super__ = away3d_lights_shadowmaps_ShadowMapperBase;
away3d_lights_shadowmaps_CubeMapShadowMapper.prototype = $extend(away3d_lights_shadowmaps_ShadowMapperBase.prototype,{
	_depthCameras: null
	,_lenses: null
	,_needsRender: null
	,initCameras: function() {
		this._depthCameras = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		this._lenses = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		this.addCamera(0,90,0);
		this.addCamera(0,-90,0);
		this.addCamera(-90,0,0);
		this.addCamera(90,0,0);
		this.addCamera(0,0,0);
		this.addCamera(0,180,0);
	}
	,addCamera: function(rotationX,rotationY,rotationZ) {
		var cam = new away3d_cameras_Camera3D();
		cam.set_rotationX(rotationX);
		cam.set_rotationY(rotationY);
		cam.set_rotationZ(rotationZ);
		cam.get_lens().set_near(.01);
		(js_Boot.__cast(cam.get_lens() , away3d_cameras_lenses_PerspectiveLens)).set_fieldOfView(90);
		this._lenses.push(js_Boot.__cast(cam.get_lens() , away3d_cameras_lenses_PerspectiveLens));
		cam.get_lens().set_aspectRatio(1);
		this._depthCameras.push(cam);
	}
	,createDepthTexture: function() {
		return new away3d_textures_RenderCubeTexture(this._depthMapSize);
	}
	,updateDepthProjection: function(viewCamera) {
		var maxDistance = (js_Boot.__cast(this._light , away3d_lights_PointLight))._fallOff;
		var pos = this._light.get_scenePosition();
		this._lenses.get(0).set_far(maxDistance);
		this._depthCameras.get(0).set_position(pos);
		this._needsRender.set(0,true);
		this._lenses.get(1).set_far(maxDistance);
		this._depthCameras.get(1).set_position(pos);
		this._needsRender.set(1,true);
		this._lenses.get(2).set_far(maxDistance);
		this._depthCameras.get(2).set_position(pos);
		this._needsRender.set(2,true);
		this._lenses.get(3).set_far(maxDistance);
		this._depthCameras.get(3).set_position(pos);
		this._needsRender.set(3,true);
		this._lenses.get(4).set_far(maxDistance);
		this._depthCameras.get(4).set_position(pos);
		this._needsRender.set(4,true);
		this._lenses.get(5).set_far(maxDistance);
		this._depthCameras.get(5).set_position(pos);
		this._needsRender.set(5,true);
	}
	,drawDepthMap: function(target,scene,renderer) {
		if(this._needsRender.get(0)) {
			this._casterCollector.set_camera(this._depthCameras.get(0));
			this._casterCollector.clear();
			scene.traversePartitions(this._casterCollector);
			renderer.render(this._casterCollector,target,null,0);
			this._casterCollector.cleanUp();
		}
		if(this._needsRender.get(1)) {
			this._casterCollector.set_camera(this._depthCameras.get(1));
			this._casterCollector.clear();
			scene.traversePartitions(this._casterCollector);
			renderer.render(this._casterCollector,target,null,1);
			this._casterCollector.cleanUp();
		}
		if(this._needsRender.get(2)) {
			this._casterCollector.set_camera(this._depthCameras.get(2));
			this._casterCollector.clear();
			scene.traversePartitions(this._casterCollector);
			renderer.render(this._casterCollector,target,null,2);
			this._casterCollector.cleanUp();
		}
		if(this._needsRender.get(3)) {
			this._casterCollector.set_camera(this._depthCameras.get(3));
			this._casterCollector.clear();
			scene.traversePartitions(this._casterCollector);
			renderer.render(this._casterCollector,target,null,3);
			this._casterCollector.cleanUp();
		}
		if(this._needsRender.get(4)) {
			this._casterCollector.set_camera(this._depthCameras.get(4));
			this._casterCollector.clear();
			scene.traversePartitions(this._casterCollector);
			renderer.render(this._casterCollector,target,null,4);
			this._casterCollector.cleanUp();
		}
		if(this._needsRender.get(5)) {
			this._casterCollector.set_camera(this._depthCameras.get(5));
			this._casterCollector.clear();
			scene.traversePartitions(this._casterCollector);
			renderer.render(this._casterCollector,target,null,5);
			this._casterCollector.cleanUp();
		}
	}
	,__class__: away3d_lights_shadowmaps_CubeMapShadowMapper
});
var away3d_lights_shadowmaps_DirectionalShadowMapper = function() {
	this._snap = 64;
	this._lightOffset = 10000;
	away3d_lights_shadowmaps_ShadowMapperBase.call(this);
	this._cullPlanes = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this._overallDepthLens = new away3d_cameras_lenses_FreeMatrixLens();
	this._overallDepthCamera = new away3d_cameras_Camera3D(this._overallDepthLens);
	this._localFrustum = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,24);
	this._matrix = new openfl_geom_Matrix3D();
};
$hxClasses["away3d.lights.shadowmaps.DirectionalShadowMapper"] = away3d_lights_shadowmaps_DirectionalShadowMapper;
away3d_lights_shadowmaps_DirectionalShadowMapper.__name__ = "away3d.lights.shadowmaps.DirectionalShadowMapper";
away3d_lights_shadowmaps_DirectionalShadowMapper.__super__ = away3d_lights_shadowmaps_ShadowMapperBase;
away3d_lights_shadowmaps_DirectionalShadowMapper.prototype = $extend(away3d_lights_shadowmaps_ShadowMapperBase.prototype,{
	_overallDepthCamera: null
	,_localFrustum: null
	,_lightOffset: null
	,_matrix: null
	,_overallDepthLens: null
	,_snap: null
	,_cullPlanes: null
	,_minZ: null
	,_maxZ: null
	,get_snap: function() {
		return this._snap;
	}
	,set_snap: function(value) {
		this._snap = value;
		return value;
	}
	,get_lightOffset: function() {
		return this._lightOffset;
	}
	,set_lightOffset: function(value) {
		this._lightOffset = value;
		return value;
	}
	,get_depthProjection: function() {
		return this._overallDepthCamera.get_viewProjection();
	}
	,get_depth: function() {
		return this._maxZ - this._minZ;
	}
	,drawDepthMap: function(target,scene,renderer) {
		this._casterCollector.set_camera(this._overallDepthCamera);
		this._casterCollector.set_cullPlanes(this._cullPlanes);
		this._casterCollector.clear();
		scene.traversePartitions(this._casterCollector);
		renderer.render(this._casterCollector,target);
		this._casterCollector.cleanUp();
	}
	,updateCullPlanes: function(viewCamera) {
		var lightFrustumPlanes = this._overallDepthCamera.get_frustumPlanes();
		var viewFrustumPlanes = viewCamera.get_frustumPlanes();
		this._cullPlanes.set_length(4);
		this._cullPlanes.set(0,lightFrustumPlanes.get(0));
		this._cullPlanes.set(1,lightFrustumPlanes.get(1));
		this._cullPlanes.set(2,lightFrustumPlanes.get(2));
		this._cullPlanes.set(3,lightFrustumPlanes.get(3));
		var dir = (js_Boot.__cast(this._light , away3d_lights_DirectionalLight)).get_sceneDirection();
		var dirX = dir.x;
		var dirY = dir.y;
		var dirZ = dir.z;
		var j = 4;
		var plane = viewFrustumPlanes.get(0);
		if(plane.a * dirX + plane.b * dirY + plane.c * dirZ < 0) {
			this._cullPlanes.set(j++,plane);
		}
		var plane1 = viewFrustumPlanes.get(1);
		if(plane1.a * dirX + plane1.b * dirY + plane1.c * dirZ < 0) {
			this._cullPlanes.set(j++,plane1);
		}
		var plane2 = viewFrustumPlanes.get(2);
		if(plane2.a * dirX + plane2.b * dirY + plane2.c * dirZ < 0) {
			this._cullPlanes.set(j++,plane2);
		}
		var plane3 = viewFrustumPlanes.get(3);
		if(plane3.a * dirX + plane3.b * dirY + plane3.c * dirZ < 0) {
			this._cullPlanes.set(j++,plane3);
		}
		var plane4 = viewFrustumPlanes.get(4);
		if(plane4.a * dirX + plane4.b * dirY + plane4.c * dirZ < 0) {
			this._cullPlanes.set(j++,plane4);
		}
		var plane5 = viewFrustumPlanes.get(5);
		if(plane5.a * dirX + plane5.b * dirY + plane5.c * dirZ < 0) {
			this._cullPlanes.set(j++,plane5);
		}
	}
	,updateDepthProjection: function(viewCamera) {
		this.updateProjectionFromFrustumCorners(viewCamera,viewCamera.get_lens().get_frustumCorners(),this._matrix);
		this._overallDepthLens.set_matrix(this._matrix);
		this.updateCullPlanes(viewCamera);
	}
	,updateProjectionFromFrustumCorners: function(viewCamera,corners,matrix) {
		var raw = away3d_core_math_Matrix3DUtils.RAW_DATA_CONTAINER;
		var dir = (js_Boot.__cast(this._light , away3d_lights_DirectionalLight)).get_sceneDirection();
		this._overallDepthCamera.set_transform(this._light.get_sceneTransform());
		var x = ((viewCamera.get_x() - dir.x * this._lightOffset) / this._snap | 0) * this._snap;
		var y = ((viewCamera.get_y() - dir.y * this._lightOffset) / this._snap | 0) * this._snap;
		var z = ((viewCamera.get_z() - dir.z * this._lightOffset) / this._snap | 0) * this._snap;
		this._overallDepthCamera.set_x(x);
		this._overallDepthCamera.set_y(y);
		this._overallDepthCamera.set_z(z);
		this._matrix.copyFrom(this._overallDepthCamera.get_inverseSceneTransform());
		this._matrix.prepend(viewCamera.get_sceneTransform());
		this._matrix.transformVectors(corners,this._localFrustum);
		var maxX = this._localFrustum.get(0);
		var minX = maxX;
		var maxY = this._localFrustum.get(1);
		var minY = maxY;
		this._maxZ = this._localFrustum.get(2);
		var i = 3;
		while(i < 24) {
			x = this._localFrustum.get(i);
			y = this._localFrustum.get(i + 1);
			z = this._localFrustum.get(i + 2);
			if(x < minX) {
				minX = x;
			}
			if(x > maxX) {
				maxX = x;
			}
			if(y < minY) {
				minY = y;
			}
			if(y > maxY) {
				maxY = y;
			}
			if(z > this._maxZ) {
				this._maxZ = z;
			}
			i += 3;
		}
		this._minZ = 1;
		var w = maxX - minX;
		var h = maxY - minY;
		var d = 1 / (this._maxZ - this._minZ);
		if(minX < 0) {
			minX -= this._snap;
		}
		if(minY < 0) {
			minY -= this._snap;
		}
		minX = (minX / this._snap | 0) * this._snap;
		minY = (minY / this._snap | 0) * this._snap;
		var snap2 = 2 * this._snap;
		w = (w / snap2 + 2 | 0) * snap2;
		h = (h / snap2 + 2 | 0) * snap2;
		maxX = minX + w;
		maxY = minY + h;
		w = 1 / w;
		h = 1 / h;
		raw.set(0,2 * w);
		raw.set(5,2 * h);
		raw.set(10,d);
		raw.set(12,-(maxX + minX) * w);
		raw.set(13,-(maxY + minY) * h);
		raw.set(14,-this._minZ * d);
		raw.set(15,1);
		raw.set(1,raw.set(2,raw.set(3,raw.set(4,raw.set(6,raw.set(7,raw.set(8,raw.set(9,raw.set(11,0)))))))));
		matrix.copyRawDataFrom(raw);
	}
	,__class__: away3d_lights_shadowmaps_DirectionalShadowMapper
	,__properties__: $extend(away3d_lights_shadowmaps_ShadowMapperBase.prototype.__properties__,{get_depth:"get_depth",get_depthProjection:"get_depthProjection",set_lightOffset:"set_lightOffset",get_lightOffset:"get_lightOffset",set_snap:"set_snap",get_snap:"get_snap"})
});
var away3d_materials_LightSources = function() { };
$hxClasses["away3d.materials.LightSources"] = away3d_materials_LightSources;
away3d_materials_LightSources.__name__ = "away3d.materials.LightSources";
var away3d_materials_MaterialBase = function() {
	this._depthCompareMode = 5;
	this._anisotropy = 1;
	this._smooth = true;
	this._mipmap = true;
	this._numPasses = 0;
	this._blendMode = 10;
	this._owners = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this._passes = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this._depthPass = new away3d_materials_passes_DepthMapPass();
	this._distancePass = new away3d_materials_passes_DistanceMapPass();
	this._depthPass.addEventListener("change",$bind(this,this.onDepthPassChange));
	this._distancePass.addEventListener("change",$bind(this,this.onDistancePassChange));
	this.set_alphaPremultiplied(true);
	this._uniqueId = away3d_materials_MaterialBase.MATERIAL_ID_COUNT++;
	away3d_library_assets_NamedAssetBase.call(this);
};
$hxClasses["away3d.materials.MaterialBase"] = away3d_materials_MaterialBase;
away3d_materials_MaterialBase.__name__ = "away3d.materials.MaterialBase";
away3d_materials_MaterialBase.__interfaces__ = [away3d_library_assets_IAsset];
away3d_materials_MaterialBase.__super__ = away3d_library_assets_NamedAssetBase;
away3d_materials_MaterialBase.prototype = $extend(away3d_library_assets_NamedAssetBase.prototype,{
	extra: null
	,_classification: null
	,_uniqueId: null
	,_renderOrderId: null
	,_depthPassId: null
	,_bothSides: null
	,_animationSet: null
	,_owners: null
	,_alphaPremultiplied: null
	,_blendMode: null
	,_numPasses: null
	,_passes: null
	,_mipmap: null
	,_smooth: null
	,_repeat: null
	,_anisotropy: null
	,_depthPass: null
	,_distancePass: null
	,_lightPicker: null
	,_distanceBasedDepthRender: null
	,_depthCompareMode: null
	,get_assetType: function() {
		return "material";
	}
	,get_lightPicker: function() {
		return this._lightPicker;
	}
	,set_lightPicker: function(value) {
		if(value != this._lightPicker) {
			this._lightPicker = value;
			var len = this._passes.get_length();
			var _g = 0;
			var _g1 = len;
			while(_g < _g1) {
				var i = _g++;
				this._passes.get(i).set_lightPicker(this._lightPicker);
			}
		}
		return value;
	}
	,get_mipmap: function() {
		return this._mipmap;
	}
	,set_mipmap: function(value) {
		this._mipmap = value;
		var _g = 0;
		var _g1 = this._numPasses;
		while(_g < _g1) {
			var i = _g++;
			this._passes.get(i).set_mipmap(value);
		}
		return value;
	}
	,get_smooth: function() {
		return this._smooth;
	}
	,set_smooth: function(value) {
		this._smooth = value;
		var _g = 0;
		var _g1 = this._numPasses;
		while(_g < _g1) {
			var i = _g++;
			this._passes.get(i).set_smooth(value);
		}
		return value;
	}
	,get_depthCompareMode: function() {
		return this._depthCompareMode;
	}
	,set_depthCompareMode: function(value) {
		this._depthCompareMode = value;
		return value;
	}
	,get_repeat: function() {
		return this._repeat;
	}
	,set_repeat: function(value) {
		this._repeat = value;
		var _g = 0;
		var _g1 = this._numPasses;
		while(_g < _g1) {
			var i = _g++;
			this._passes.get(i).set_repeat(value);
		}
		return value;
	}
	,get_anisotropy: function() {
		return this._anisotropy;
	}
	,set_anisotropy: function(value) {
		this._anisotropy = value;
		var _g = 0;
		var _g1 = this._numPasses;
		while(_g < _g1) {
			var i = _g++;
			this._passes.get(i).set_anisotropy(this._anisotropy);
		}
		return value;
	}
	,dispose: function() {
		var _g = 0;
		var _g1 = this._numPasses;
		while(_g < _g1) {
			var i = _g++;
			this._passes.get(i).dispose();
		}
		this._depthPass.dispose();
		this._distancePass.dispose();
		this._depthPass.removeEventListener("change",$bind(this,this.onDepthPassChange));
		this._distancePass.removeEventListener("change",$bind(this,this.onDistancePassChange));
	}
	,get_bothSides: function() {
		return this._bothSides;
	}
	,set_bothSides: function(value) {
		this._bothSides = value;
		var _g = 0;
		var _g1 = this._numPasses;
		while(_g < _g1) {
			var i = _g++;
			this._passes.get(i).set_bothSides(value);
		}
		this._depthPass.set_bothSides(value);
		this._distancePass.set_bothSides(value);
		return value;
	}
	,get_blendMode: function() {
		return this._blendMode;
	}
	,set_blendMode: function(value) {
		this._blendMode = value;
		return value;
	}
	,get_alphaPremultiplied: function() {
		return this._alphaPremultiplied;
	}
	,set_alphaPremultiplied: function(value) {
		this._alphaPremultiplied = value;
		var _g = 0;
		var _g1 = this._numPasses;
		while(_g < _g1) {
			var i = _g++;
			this._passes.get(i).set_alphaPremultiplied(value);
		}
		return value;
	}
	,get_requiresBlending: function() {
		return this._blendMode != 10;
	}
	,get_uniqueId: function() {
		return this._uniqueId;
	}
	,get_numPasses: function() {
		return this._numPasses;
	}
	,hasDepthAlphaThreshold: function() {
		return this._depthPass.get_alphaThreshold() > 0;
	}
	,activateForDepth: function(stage3DProxy,camera,distanceBased) {
		if(distanceBased == null) {
			distanceBased = false;
		}
		this._distanceBasedDepthRender = distanceBased;
		if(distanceBased) {
			this._distancePass.activate(stage3DProxy,camera);
		} else {
			this._depthPass.activate(stage3DProxy,camera);
		}
	}
	,deactivateForDepth: function(stage3DProxy) {
		if(this._distanceBasedDepthRender) {
			this._distancePass.deactivate(stage3DProxy);
		} else {
			this._depthPass.deactivate(stage3DProxy);
		}
	}
	,renderDepth: function(renderable,stage3DProxy,camera,viewProjection) {
		if(this._distanceBasedDepthRender) {
			if(renderable.get_animator() != null) {
				this._distancePass.updateAnimationState(renderable,stage3DProxy,camera);
			}
			this._distancePass.render(renderable,stage3DProxy,camera,viewProjection);
		} else {
			if(renderable.get_animator() != null) {
				this._depthPass.updateAnimationState(renderable,stage3DProxy,camera);
			}
			this._depthPass.render(renderable,stage3DProxy,camera,viewProjection);
		}
	}
	,passRendersToTexture: function(index) {
		return this._passes.get(index).get_renderToTexture();
	}
	,activatePass: function(index,stage3DProxy,camera) {
		this._passes.get(index).activate(stage3DProxy,camera);
	}
	,deactivatePass: function(index,stage3DProxy) {
		this._passes.get(index).deactivate(stage3DProxy);
	}
	,renderPass: function(index,renderable,stage3DProxy,entityCollector,viewProjection) {
		if(this._lightPicker != null) {
			this._lightPicker.collectLights(renderable,entityCollector);
		}
		var pass = this._passes.get(index);
		if(renderable.get_animator() != null) {
			pass.updateAnimationState(renderable,stage3DProxy,entityCollector.get_camera());
		}
		pass.render(renderable,stage3DProxy,entityCollector.get_camera(),viewProjection);
	}
	,addOwner: function(owner) {
		this._owners.push(owner);
		if(owner.get_animator() != null) {
			if(this._animationSet != null && owner.get_animator().get_animationSet() != this._animationSet) {
				throw new js__$Boot_HaxeError(new openfl_errors_Error("A Material instance cannot be shared across renderables with different animator libraries"));
			} else if(this._animationSet != owner.get_animator().get_animationSet()) {
				this._animationSet = owner.get_animator().get_animationSet();
				var _g = 0;
				var _g1 = this._numPasses;
				while(_g < _g1) {
					var i = _g++;
					this._passes.get(i).set_animationSet(this._animationSet);
				}
				this._depthPass.set_animationSet(this._animationSet);
				this._distancePass.set_animationSet(this._animationSet);
				this.invalidatePasses(null);
			}
		}
	}
	,removeOwner: function(owner) {
		this._owners.splice(this._owners.indexOf(owner,0),1);
		if(this._owners.get_length() == 0) {
			this._animationSet = null;
			var _g = 0;
			var _g1 = this._numPasses;
			while(_g < _g1) {
				var i = _g++;
				this._passes.get(i).set_animationSet(this._animationSet);
			}
			this._depthPass.set_animationSet(this._animationSet);
			this._distancePass.set_animationSet(this._animationSet);
			this.invalidatePasses(null);
		}
	}
	,get_owners: function() {
		return this._owners;
	}
	,updateMaterial: function(context) {
	}
	,deactivate: function(stage3DProxy) {
		this._passes.get(this._numPasses - 1).deactivate(stage3DProxy);
	}
	,invalidatePasses: function(triggerPass) {
		var owner;
		this._depthPass.invalidateShaderProgram();
		this._distancePass.invalidateShaderProgram();
		if(this._animationSet != null) {
			this._animationSet.resetGPUCompatibility();
			var owner1 = this._owners.iterator();
			while(owner1.hasNext()) {
				var owner2 = owner1.next();
				if(owner2.get_animator() != null) {
					owner2.get_animator().testGPUCompatibility(this._depthPass);
					owner2.get_animator().testGPUCompatibility(this._distancePass);
				}
			}
		}
		var _g = 0;
		var _g1 = this._numPasses;
		while(_g < _g1) {
			var i = _g++;
			if(this._passes.get(i) != triggerPass) {
				this._passes.get(i).invalidateShaderProgram(false);
			}
			if(this._animationSet != null) {
				var owner3 = this._owners.iterator();
				while(owner3.hasNext()) {
					var owner4 = owner3.next();
					if(owner4.get_animator() != null) {
						owner4.get_animator().testGPUCompatibility(this._passes.get(i));
					}
				}
			}
		}
	}
	,removePass: function(pass) {
		this._passes.splice(this._passes.indexOf(pass,0),1);
		--this._numPasses;
	}
	,clearPasses: function() {
		var _g = 0;
		var _g1 = this._numPasses;
		while(_g < _g1) {
			var i = _g++;
			this._passes.get(i).removeEventListener("change",$bind(this,this.onPassChange));
		}
		this._passes.set_length(0);
		this._numPasses = 0;
	}
	,addPass: function(pass) {
		this._passes.set(this._numPasses++,pass);
		pass.set_animationSet(this._animationSet);
		pass.set_alphaPremultiplied(this._alphaPremultiplied);
		pass.set_mipmap(this._mipmap);
		pass.set_smooth(this._smooth);
		pass.set_repeat(this._repeat);
		pass.set_anisotropy(this._anisotropy);
		pass.set_lightPicker(this._lightPicker);
		pass.set_bothSides(this._bothSides);
		pass.addEventListener("change",$bind(this,this.onPassChange));
		this.invalidatePasses(null);
	}
	,onPassChange: function(event) {
		var mult = 1;
		var ids;
		var len;
		this._renderOrderId = 0;
		var _g = 0;
		var _g1 = this._numPasses;
		while(_g < _g1) {
			var i = _g++;
			ids = this._passes.get(i)._program3Dids;
			len = ids.get_length();
			var _g2 = 0;
			var _g11 = len;
			while(_g2 < _g11) {
				var j = _g2++;
				if(ids.get(j) != -1) {
					this._renderOrderId += mult * ids.get(j) | 0;
					break;
				}
			}
			mult *= 1000;
		}
	}
	,onDistancePassChange: function(event) {
		var ids = this._distancePass._program3Dids;
		var len = ids.get_length();
		this._depthPassId = 0;
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var j = _g++;
			if(ids.get(j) != -1) {
				this._depthPassId += ids.get(j);
				break;
			}
		}
	}
	,onDepthPassChange: function(event) {
		var ids = this._depthPass._program3Dids;
		var len = ids.get_length();
		this._depthPassId = 0;
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var j = _g++;
			if(ids.get(j) != -1) {
				this._depthPassId += ids.get(j);
				break;
			}
		}
	}
	,__class__: away3d_materials_MaterialBase
	,__properties__: $extend(away3d_library_assets_NamedAssetBase.prototype.__properties__,{get_owners:"get_owners",get_numPasses:"get_numPasses",get_uniqueId:"get_uniqueId",get_requiresBlending:"get_requiresBlending",set_alphaPremultiplied:"set_alphaPremultiplied",get_alphaPremultiplied:"get_alphaPremultiplied",set_blendMode:"set_blendMode",get_blendMode:"get_blendMode",set_bothSides:"set_bothSides",get_bothSides:"get_bothSides",set_anisotropy:"set_anisotropy",get_anisotropy:"get_anisotropy",set_repeat:"set_repeat",get_repeat:"get_repeat",set_depthCompareMode:"set_depthCompareMode",get_depthCompareMode:"get_depthCompareMode",set_smooth:"set_smooth",get_smooth:"get_smooth",set_mipmap:"set_mipmap",get_mipmap:"get_mipmap",set_lightPicker:"set_lightPicker",get_lightPicker:"get_lightPicker",get_assetType:"get_assetType"})
});
var away3d_materials_SegmentMaterial = function(thickness) {
	if(thickness == null) {
		thickness = 1.25;
	}
	away3d_materials_MaterialBase.call(this);
	this.set_bothSides(true);
	this.addPass(this._screenPass = new away3d_materials_passes_SegmentPass(thickness));
	this._screenPass.set_material(this);
};
$hxClasses["away3d.materials.SegmentMaterial"] = away3d_materials_SegmentMaterial;
away3d_materials_SegmentMaterial.__name__ = "away3d.materials.SegmentMaterial";
away3d_materials_SegmentMaterial.__super__ = away3d_materials_MaterialBase;
away3d_materials_SegmentMaterial.prototype = $extend(away3d_materials_MaterialBase.prototype,{
	_screenPass: null
	,__class__: away3d_materials_SegmentMaterial
});
var away3d_materials_SinglePassMaterialBase = function() {
	away3d_materials_MaterialBase.call(this);
	this.addPass(this._screenPass = new away3d_materials_passes_SuperShaderPass(this));
};
$hxClasses["away3d.materials.SinglePassMaterialBase"] = away3d_materials_SinglePassMaterialBase;
away3d_materials_SinglePassMaterialBase.__name__ = "away3d.materials.SinglePassMaterialBase";
away3d_materials_SinglePassMaterialBase.__super__ = away3d_materials_MaterialBase;
away3d_materials_SinglePassMaterialBase.prototype = $extend(away3d_materials_MaterialBase.prototype,{
	_screenPass: null
	,_alphaBlending: null
	,get_enableLightFallOff: function() {
		return this._screenPass.get_enableLightFallOff();
	}
	,set_enableLightFallOff: function(value) {
		this._screenPass.set_enableLightFallOff(value);
		return value;
	}
	,get_alphaThreshold: function() {
		return this._screenPass.get_diffuseMethod().get_alphaThreshold();
	}
	,set_alphaThreshold: function(value) {
		this._screenPass.get_diffuseMethod().set_alphaThreshold(value);
		this._depthPass.set_alphaThreshold(value);
		this._distancePass.set_alphaThreshold(value);
		return value;
	}
	,set_blendMode: function(value) {
		away3d_materials_MaterialBase.prototype.set_blendMode.call(this,value);
		this._screenPass.setBlendMode(this.get_blendMode() == 10 && this.get_requiresBlending() ? 7 : this.get_blendMode());
		return value;
	}
	,set_depthCompareMode: function(value) {
		away3d_materials_MaterialBase.prototype.set_depthCompareMode.call(this,value);
		this._screenPass.set_depthCompareMode(value);
		return value;
	}
	,activateForDepth: function(stage3DProxy,camera,distanceBased) {
		if(distanceBased == null) {
			distanceBased = false;
		}
		if(distanceBased) {
			this._distancePass.set_alphaMask(this._screenPass.get_diffuseMethod().get_texture());
		} else {
			this._depthPass.set_alphaMask(this._screenPass.get_diffuseMethod().get_texture());
		}
		away3d_materials_MaterialBase.prototype.activateForDepth.call(this,stage3DProxy,camera,distanceBased);
	}
	,get_specularLightSources: function() {
		return this._screenPass.get_specularLightSources();
	}
	,set_specularLightSources: function(value) {
		this._screenPass.set_specularLightSources(value);
		return value;
	}
	,get_diffuseLightSources: function() {
		return this._screenPass.get_diffuseLightSources();
	}
	,set_diffuseLightSources: function(value) {
		this._screenPass.set_diffuseLightSources(value);
		return value;
	}
	,get_requiresBlending: function() {
		if(!(away3d_materials_MaterialBase.prototype.get_requiresBlending.call(this) || this._alphaBlending)) {
			if(this._screenPass.get_colorTransform() != null) {
				return this._screenPass.get_colorTransform().alphaMultiplier < 1;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,get_colorTransform: function() {
		return this._screenPass.get_colorTransform();
	}
	,set_colorTransform: function(value) {
		this._screenPass.set_colorTransform(value);
		return value;
	}
	,get_ambientMethod: function() {
		return this._screenPass.get_ambientMethod();
	}
	,set_ambientMethod: function(value) {
		this._screenPass.set_ambientMethod(value);
		return value;
	}
	,get_shadowMethod: function() {
		return this._screenPass.get_shadowMethod();
	}
	,set_shadowMethod: function(value) {
		this._screenPass.set_shadowMethod(value);
		return value;
	}
	,get_diffuseMethod: function() {
		return this._screenPass.get_diffuseMethod();
	}
	,set_diffuseMethod: function(value) {
		this._screenPass.set_diffuseMethod(value);
		return value;
	}
	,get_normalMethod: function() {
		return this._screenPass.get_normalMethod();
	}
	,set_normalMethod: function(value) {
		this._screenPass.set_normalMethod(value);
		return value;
	}
	,get_specularMethod: function() {
		return this._screenPass.get_specularMethod();
	}
	,set_specularMethod: function(value) {
		this._screenPass.set_specularMethod(value);
		return value;
	}
	,addMethod: function(method) {
		this._screenPass.addMethod(method);
	}
	,get_numMethods: function() {
		return this._screenPass.get_numMethods();
	}
	,hasMethod: function(method) {
		return this._screenPass.hasMethod(method);
	}
	,getMethodAt: function(index) {
		return this._screenPass.getMethodAt(index);
	}
	,addMethodAt: function(method,index) {
		this._screenPass.addMethodAt(method,index);
	}
	,removeMethod: function(method) {
		this._screenPass.removeMethod(method);
	}
	,set_mipmap: function(value) {
		if(this._mipmap == value) {
			return value;
		}
		away3d_materials_MaterialBase.prototype.set_mipmap.call(this,value);
		return value;
	}
	,get_normalMap: function() {
		return this._screenPass.get_normalMap();
	}
	,set_normalMap: function(value) {
		this._screenPass.set_normalMap(value);
		return value;
	}
	,get_specularMap: function() {
		return this._screenPass.get_specularMethod().get_texture();
	}
	,set_specularMap: function(value) {
		if(this._screenPass.get_specularMethod() != null) {
			this._screenPass.get_specularMethod().set_texture(value);
		} else {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("No specular method was set to assign the specularGlossMap to"));
		}
		return value;
	}
	,get_gloss: function() {
		if(this._screenPass.get_specularMethod() != null) {
			return this._screenPass.get_specularMethod().get_gloss();
		} else {
			return 0;
		}
	}
	,set_gloss: function(value) {
		if(this._screenPass.get_specularMethod() != null) {
			this._screenPass.get_specularMethod().set_gloss(value);
		}
		return value;
	}
	,get_ambient: function() {
		return this._screenPass.get_ambientMethod().get_ambient();
	}
	,set_ambient: function(value) {
		this._screenPass.get_ambientMethod().set_ambient(value);
		return value;
	}
	,get_specular: function() {
		if(this._screenPass.get_specularMethod() != null) {
			return this._screenPass.get_specularMethod().get_specular();
		} else {
			return 0;
		}
	}
	,set_specular: function(value) {
		if(this._screenPass.get_specularMethod() != null) {
			this._screenPass.get_specularMethod().set_specular(value);
		}
		return value;
	}
	,get_ambientColor: function() {
		return this._screenPass.get_ambientMethod().get_ambientColor();
	}
	,set_ambientColor: function(value) {
		this._screenPass.get_ambientMethod().set_ambientColor(value);
		return value;
	}
	,get_specularColor: function() {
		return this._screenPass.get_specularMethod().get_specularColor();
	}
	,set_specularColor: function(value) {
		this._screenPass.get_specularMethod().set_specularColor(value);
		return value;
	}
	,get_alphaBlending: function() {
		return this._alphaBlending;
	}
	,set_alphaBlending: function(value) {
		this._alphaBlending = value;
		this._screenPass.setBlendMode(this.get_blendMode() == 10 && this.get_requiresBlending() ? 7 : this.get_blendMode());
		this._screenPass.set_preserveAlpha(this.get_requiresBlending());
		return value;
	}
	,updateMaterial: function(context) {
		if(this._screenPass._passesDirty) {
			this.clearPasses();
			if(this._screenPass._passes != null) {
				var len = this._screenPass._passes.get_length();
				var _g = 0;
				var _g1 = len;
				while(_g < _g1) {
					var i = _g++;
					this.addPass(this._screenPass._passes.get(i));
				}
			}
			this.addPass(this._screenPass);
			this._screenPass._passesDirty = false;
		}
	}
	,set_lightPicker: function(value) {
		away3d_materials_MaterialBase.prototype.set_lightPicker.call(this,value);
		this._screenPass.set_lightPicker(value);
		return value;
	}
	,__class__: away3d_materials_SinglePassMaterialBase
	,__properties__: $extend(away3d_materials_MaterialBase.prototype.__properties__,{set_alphaBlending:"set_alphaBlending",get_alphaBlending:"get_alphaBlending",set_specularColor:"set_specularColor",get_specularColor:"get_specularColor",set_ambientColor:"set_ambientColor",get_ambientColor:"get_ambientColor",set_specular:"set_specular",get_specular:"get_specular",set_ambient:"set_ambient",get_ambient:"get_ambient",set_gloss:"set_gloss",get_gloss:"get_gloss",set_specularMap:"set_specularMap",get_specularMap:"get_specularMap",set_normalMap:"set_normalMap",get_normalMap:"get_normalMap",get_numMethods:"get_numMethods",set_specularMethod:"set_specularMethod",get_specularMethod:"get_specularMethod",set_normalMethod:"set_normalMethod",get_normalMethod:"get_normalMethod",set_diffuseMethod:"set_diffuseMethod",get_diffuseMethod:"get_diffuseMethod",set_shadowMethod:"set_shadowMethod",get_shadowMethod:"get_shadowMethod",set_ambientMethod:"set_ambientMethod",get_ambientMethod:"get_ambientMethod",set_colorTransform:"set_colorTransform",get_colorTransform:"get_colorTransform",set_diffuseLightSources:"set_diffuseLightSources",get_diffuseLightSources:"get_diffuseLightSources",set_specularLightSources:"set_specularLightSources",get_specularLightSources:"get_specularLightSources",set_alphaThreshold:"set_alphaThreshold",get_alphaThreshold:"get_alphaThreshold",set_enableLightFallOff:"set_enableLightFallOff",get_enableLightFallOff:"get_enableLightFallOff"})
});
var away3d_materials_TextureMaterial = function(texture,smooth,repeat,mipmap,anisotropy) {
	if(anisotropy == null) {
		anisotropy = 1;
	}
	if(mipmap == null) {
		mipmap = true;
	}
	if(repeat == null) {
		repeat = false;
	}
	if(smooth == null) {
		smooth = true;
	}
	away3d_materials_SinglePassMaterialBase.call(this);
	this.set_texture(texture);
	this.set_smooth(smooth);
	this.set_repeat(repeat);
	this.set_mipmap(mipmap);
	this.set_anisotropy(anisotropy);
};
$hxClasses["away3d.materials.TextureMaterial"] = away3d_materials_TextureMaterial;
away3d_materials_TextureMaterial.__name__ = "away3d.materials.TextureMaterial";
away3d_materials_TextureMaterial.__super__ = away3d_materials_SinglePassMaterialBase;
away3d_materials_TextureMaterial.prototype = $extend(away3d_materials_SinglePassMaterialBase.prototype,{
	get_animateUVs: function() {
		return this._screenPass.get_animateUVs();
	}
	,set_animateUVs: function(value) {
		this._screenPass.set_animateUVs(value);
		return value;
	}
	,get_animateUVs2: function() {
		return this._screenPass.get_animateUVs2();
	}
	,set_animateUVs2: function(value) {
		this._screenPass.set_animateUVs2(value);
		return value;
	}
	,get_alpha: function() {
		if(this._screenPass.get_colorTransform() != null) {
			return this._screenPass.get_colorTransform().alphaMultiplier;
		} else {
			return 1;
		}
	}
	,set_alpha: function(value) {
		if(value > 1) {
			value = 1;
		} else if(value < 0) {
			value = 0;
		}
		if(this.get_colorTransform() == null) {
			this.set_colorTransform(new openfl_geom_ColorTransform());
		}
		this.get_colorTransform().alphaMultiplier = value;
		this._screenPass.set_preserveAlpha(this.get_requiresBlending());
		this._screenPass.setBlendMode(this.get_blendMode() == 10 && this.get_requiresBlending() ? 7 : this.get_blendMode());
		return value;
	}
	,get_texture: function() {
		return this._screenPass.get_diffuseMethod().get_texture();
	}
	,set_texture: function(value) {
		this._screenPass.get_diffuseMethod().set_texture(value);
		return value;
	}
	,get_ambientTexture: function() {
		return this._screenPass.get_ambientMethod().get_texture();
	}
	,set_ambientTexture: function(value) {
		this._screenPass.get_ambientMethod().set_texture(value);
		this._screenPass.get_diffuseMethod().set_useAmbientTexture(value != null);
		return value;
	}
	,__class__: away3d_materials_TextureMaterial
	,__properties__: $extend(away3d_materials_SinglePassMaterialBase.prototype.__properties__,{set_ambientTexture:"set_ambientTexture",get_ambientTexture:"get_ambientTexture",set_texture:"set_texture",get_texture:"get_texture",set_alpha:"set_alpha",get_alpha:"get_alpha",set_animateUVs2:"set_animateUVs2",get_animateUVs2:"get_animateUVs2",set_animateUVs:"set_animateUVs",get_animateUVs:"get_animateUVs"})
});
var away3d_materials_compilation_MethodDependencyCounter = function() {
	this._usesGlobalPosFragment = false;
};
$hxClasses["away3d.materials.compilation.MethodDependencyCounter"] = away3d_materials_compilation_MethodDependencyCounter;
away3d_materials_compilation_MethodDependencyCounter.__name__ = "away3d.materials.compilation.MethodDependencyCounter";
away3d_materials_compilation_MethodDependencyCounter.prototype = {
	_projectionDependencies: null
	,_normalDependencies: null
	,_viewDirDependencies: null
	,_uvDependencies: null
	,_secondaryUVDependencies: null
	,_globalPosDependencies: null
	,_tangentDependencies: null
	,_usesGlobalPosFragment: null
	,_numPointLights: null
	,_lightSourceMask: null
	,reset: function() {
		this._projectionDependencies = 0;
		this._normalDependencies = 0;
		this._viewDirDependencies = 0;
		this._uvDependencies = 0;
		this._secondaryUVDependencies = 0;
		this._globalPosDependencies = 0;
		this._tangentDependencies = 0;
		this._usesGlobalPosFragment = false;
	}
	,setPositionedLights: function(numPointLights,lightSourceMask) {
		this._numPointLights = numPointLights;
		this._lightSourceMask = lightSourceMask;
	}
	,includeMethodVO: function(methodVO) {
		if(methodVO.needsProjection) {
			++this._projectionDependencies;
		}
		if(methodVO.needsGlobalVertexPos) {
			++this._globalPosDependencies;
			if(methodVO.needsGlobalFragmentPos) {
				this._usesGlobalPosFragment = true;
			}
		} else if(methodVO.needsGlobalFragmentPos) {
			++this._globalPosDependencies;
			this._usesGlobalPosFragment = true;
		}
		if(methodVO.needsNormals) {
			++this._normalDependencies;
		}
		if(methodVO.needsTangents) {
			++this._tangentDependencies;
		}
		if(methodVO.needsView) {
			++this._viewDirDependencies;
		}
		if(methodVO.needsUV) {
			++this._uvDependencies;
		}
		if(methodVO.needsSecondaryUV) {
			++this._secondaryUVDependencies;
		}
	}
	,get_tangentDependencies: function() {
		return this._tangentDependencies;
	}
	,get_usesGlobalPosFragment: function() {
		return this._usesGlobalPosFragment;
	}
	,get_projectionDependencies: function() {
		return this._projectionDependencies;
	}
	,get_normalDependencies: function() {
		return this._normalDependencies;
	}
	,get_viewDirDependencies: function() {
		return this._viewDirDependencies;
	}
	,get_uvDependencies: function() {
		return this._uvDependencies;
	}
	,get_secondaryUVDependencies: function() {
		return this._secondaryUVDependencies;
	}
	,get_globalPosDependencies: function() {
		return this._globalPosDependencies;
	}
	,addWorldSpaceDependencies: function(fragmentLights) {
		if(this._viewDirDependencies > 0) {
			++this._globalPosDependencies;
		}
		if(this._numPointLights > 0 && (this._lightSourceMask & 1) != 0) {
			++this._globalPosDependencies;
			if(fragmentLights) {
				this._usesGlobalPosFragment = true;
			}
		}
	}
	,__class__: away3d_materials_compilation_MethodDependencyCounter
	,__properties__: {get_globalPosDependencies:"get_globalPosDependencies",get_secondaryUVDependencies:"get_secondaryUVDependencies",get_uvDependencies:"get_uvDependencies",get_viewDirDependencies:"get_viewDirDependencies",get_normalDependencies:"get_normalDependencies",get_projectionDependencies:"get_projectionDependencies",get_usesGlobalPosFragment:"get_usesGlobalPosFragment",get_tangentDependencies:"get_tangentDependencies"}
};
var away3d_materials_compilation_RegisterPool = function(regName,regCount,persistent) {
	if(persistent == null) {
		persistent = true;
	}
	this._regName = regName;
	this._regCount = regCount;
	this._persistent = persistent;
	this.initRegisters(regName,regCount);
};
$hxClasses["away3d.materials.compilation.RegisterPool"] = away3d_materials_compilation_RegisterPool;
away3d_materials_compilation_RegisterPool.__name__ = "away3d.materials.compilation.RegisterPool";
away3d_materials_compilation_RegisterPool._initPool = function(regName,regCount) {
	var hash = regName + regCount;
	var _this = away3d_materials_compilation_RegisterPool._regPool;
	if(__map_reserved[hash] != null ? _this.existsReserved(hash) : _this.h.hasOwnProperty(hash)) {
		return hash;
	}
	var vectorRegisters = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,regCount,true);
	var _this1 = away3d_materials_compilation_RegisterPool._regPool;
	if(__map_reserved[hash] != null) {
		_this1.setReserved(hash,vectorRegisters);
	} else {
		_this1.h[hash] = vectorRegisters;
	}
	var registerComponents = [[],[],[],[]];
	var _this2 = away3d_materials_compilation_RegisterPool._regCompsPool;
	if(__map_reserved[hash] != null) {
		_this2.setReserved(hash,registerComponents);
	} else {
		_this2.h[hash] = registerComponents;
	}
	var _g = 0;
	var _g1 = regCount;
	while(_g < _g1) {
		var i = _g++;
		vectorRegisters.set(i,new away3d_materials_compilation_ShaderRegisterElement(regName,i));
		registerComponents[0][i] = new away3d_materials_compilation_ShaderRegisterElement(regName,i,0);
		registerComponents[1][i] = new away3d_materials_compilation_ShaderRegisterElement(regName,i,1);
		registerComponents[2][i] = new away3d_materials_compilation_ShaderRegisterElement(regName,i,2);
		registerComponents[3][i] = new away3d_materials_compilation_ShaderRegisterElement(regName,i,3);
	}
	return hash;
};
away3d_materials_compilation_RegisterPool.prototype = {
	_vectorRegisters: null
	,_registerComponents: null
	,_regName: null
	,_usedSingleCount: null
	,_usedVectorCount: null
	,_regCount: null
	,_persistent: null
	,requestFreeVectorReg: function() {
		var _g = 0;
		var _g1 = this._regCount;
		while(_g < _g1) {
			var i = _g++;
			if(!this.isRegisterUsed(i)) {
				if(this._persistent) {
					var _g2 = i;
					var _g11 = this._usedVectorCount;
					_g11.set(_g2,_g11.get(_g2) + 1);
				}
				return this._vectorRegisters.get(i);
			}
		}
		throw new js__$Boot_HaxeError(new openfl_errors_Error("Register overflow!"));
	}
	,requestFreeRegComponent: function() {
		var _g = 0;
		var _g1 = this._regCount;
		while(_g < _g1) {
			var i = _g++;
			if(_$UInt_UInt_$Impl_$.gt(this._usedVectorCount.get(i),0)) {
				continue;
			}
			if(this._usedSingleCount.get(0).get(i) == 0) {
				if(this._persistent) {
					var _g2 = i;
					var _g11 = this._usedSingleCount.get(0);
					_g11.set(_g2,_g11.get(_g2) + 1);
				}
				return this._registerComponents[0][i];
			}
			if(this._usedSingleCount.get(1).get(i) == 0) {
				if(this._persistent) {
					var _g3 = i;
					var _g12 = this._usedSingleCount.get(1);
					_g12.set(_g3,_g12.get(_g3) + 1);
				}
				return this._registerComponents[1][i];
			}
			if(this._usedSingleCount.get(2).get(i) == 0) {
				if(this._persistent) {
					var _g4 = i;
					var _g13 = this._usedSingleCount.get(2);
					_g13.set(_g4,_g13.get(_g4) + 1);
				}
				return this._registerComponents[2][i];
			}
			if(this._usedSingleCount.get(3).get(i) == 0) {
				if(this._persistent) {
					var _g5 = i;
					var _g14 = this._usedSingleCount.get(3);
					_g14.set(_g5,_g14.get(_g5) + 1);
				}
				return this._registerComponents[3][i];
			}
		}
		throw new js__$Boot_HaxeError(new openfl_errors_Error("Register overflow!"));
	}
	,addUsage: function(register,usageCount) {
		if(register._component > -1) {
			var _g = register.get_index();
			var _g1 = this._usedSingleCount.get(register._component);
			_g1.set(_g,_g1.get(_g) + usageCount);
		} else {
			var _g2 = register.get_index();
			var _g11 = this._usedVectorCount;
			_g11.set(_g2,_g11.get(_g2) + usageCount);
		}
	}
	,removeUsage: function(register) {
		if(register._component > -1) {
			var _g = register.get_index();
			var _g1 = this._usedSingleCount.get(register._component);
			var count = _g1.set(_g,_g1.get(_g) - 1);
			if(_$UInt_UInt_$Impl_$.gt(0,count)) {
				throw new js__$Boot_HaxeError(new openfl_errors_Error("More usages removed than exist!"));
			}
		} else {
			var _g2 = register.get_index();
			var _g11 = this._usedVectorCount;
			var count1 = _g11.set(_g2,_g11.get(_g2) - 1);
			if(_$UInt_UInt_$Impl_$.gt(0,count1)) {
				throw new js__$Boot_HaxeError(new openfl_errors_Error("More usages removed than exist!"));
			}
		}
	}
	,dispose: function() {
		this._vectorRegisters = null;
		this._registerComponents = null;
		this._usedSingleCount = null;
		this._usedVectorCount = null;
	}
	,hasRegisteredRegs: function() {
		var _g = 0;
		var _g1 = this._regCount;
		while(_g < _g1) {
			var i = _g++;
			if(this.isRegisterUsed(i)) {
				return true;
			}
		}
		return false;
	}
	,initRegisters: function(regName,regCount) {
		var hash = away3d_materials_compilation_RegisterPool._initPool(regName,regCount);
		var _this = away3d_materials_compilation_RegisterPool._regPool;
		this._vectorRegisters = __map_reserved[hash] != null ? _this.getReserved(hash) : _this.h[hash];
		var _this1 = away3d_materials_compilation_RegisterPool._regCompsPool;
		this._registerComponents = __map_reserved[hash] != null ? _this1.getReserved(hash) : _this1.h[hash];
		this._usedVectorCount = openfl__$Vector_Vector_$Impl_$.toIntVector(null,regCount,true);
		this._usedSingleCount = openfl__$Vector_Vector_$Impl_$.toNullVector(null,4,true);
		this._usedSingleCount.set(0,openfl__$Vector_Vector_$Impl_$.toIntVector(null,regCount,true));
		this._usedSingleCount.set(1,openfl__$Vector_Vector_$Impl_$.toIntVector(null,regCount,true));
		this._usedSingleCount.set(2,openfl__$Vector_Vector_$Impl_$.toIntVector(null,regCount,true));
		this._usedSingleCount.set(3,openfl__$Vector_Vector_$Impl_$.toIntVector(null,regCount,true));
	}
	,isRegisterUsed: function(index) {
		if(_$UInt_UInt_$Impl_$.gt(this._usedVectorCount.get(index),0)) {
			return true;
		}
		if(_$UInt_UInt_$Impl_$.gt(this._usedSingleCount.get(0).get(index),0)) {
			return true;
		}
		if(_$UInt_UInt_$Impl_$.gt(this._usedSingleCount.get(1).get(index),0)) {
			return true;
		}
		if(_$UInt_UInt_$Impl_$.gt(this._usedSingleCount.get(2).get(index),0)) {
			return true;
		}
		if(_$UInt_UInt_$Impl_$.gt(this._usedSingleCount.get(3).get(index),0)) {
			return true;
		}
		return false;
	}
	,__class__: away3d_materials_compilation_RegisterPool
};
var away3d_materials_compilation_ShaderCompiler = function(profile) {
	this._probeWeightsIndex = -1;
	this._cameraPositionIndex = -1;
	this._sceneNormalMatrixIndex = -1;
	this._sceneMatrixIndex = -1;
	this._lightFragmentConstantIndex = -1;
	this._tangentBufferIndex = -1;
	this._normalBufferIndex = -1;
	this._secondaryUVBufferIndex = -1;
	this._uvTransformIndex2 = -1;
	this._uvTransformIndex = -1;
	this._uvBufferIndex = -1;
	this._commonsDataIndex = -1;
	this._preserveAlpha = true;
	this._sharedRegisters = new away3d_materials_compilation_ShaderRegisterData();
	this._dependencyCounter = new away3d_materials_compilation_MethodDependencyCounter();
	this._profile = profile;
	this.initRegisterCache(profile);
};
$hxClasses["away3d.materials.compilation.ShaderCompiler"] = away3d_materials_compilation_ShaderCompiler;
away3d_materials_compilation_ShaderCompiler.__name__ = "away3d.materials.compilation.ShaderCompiler";
away3d_materials_compilation_ShaderCompiler.prototype = {
	_sharedRegisters: null
	,_registerCache: null
	,_dependencyCounter: null
	,_methodSetup: null
	,_smooth: null
	,_repeat: null
	,_mipmap: null
	,_anisotropy: null
	,_enableLightFallOff: null
	,_preserveAlpha: null
	,_animateUVs: null
	,_animateUVs2: null
	,_alphaPremultiplied: null
	,_vertexConstantData: null
	,_fragmentConstantData: null
	,_vertexCode: null
	,_fragmentCode: null
	,_fragmentLightCode: null
	,_fragmentPostLightCode: null
	,_commonsDataIndex: null
	,_animatableAttributes: null
	,_animationTargetRegisters: null
	,_lightProbeDiffuseIndices: null
	,_lightProbeSpecularIndices: null
	,_uvBufferIndex: null
	,_uvTransformIndex: null
	,_uvTransformIndex2: null
	,_secondaryUVBufferIndex: null
	,_normalBufferIndex: null
	,_tangentBufferIndex: null
	,_lightFragmentConstantIndex: null
	,_sceneMatrixIndex: null
	,_sceneNormalMatrixIndex: null
	,_cameraPositionIndex: null
	,_probeWeightsIndex: null
	,_specularLightSources: null
	,_diffuseLightSources: null
	,_numLights: null
	,_numLightProbes: null
	,_numPointLights: null
	,_numDirectionalLights: null
	,_numProbeRegisters: null
	,_combinedLightSources: null
	,_usingSpecularMethod: null
	,_needUVAnimation: null
	,_UVTarget: null
	,_UVSource: null
	,_profile: null
	,_forceSeperateMVP: null
	,get_enableLightFallOff: function() {
		return this._enableLightFallOff;
	}
	,set_enableLightFallOff: function(value) {
		this._enableLightFallOff = value;
		return value;
	}
	,get_needUVAnimation: function() {
		return this._needUVAnimation;
	}
	,get_UVTarget: function() {
		return this._UVTarget;
	}
	,get_UVSource: function() {
		return this._UVSource;
	}
	,get_forceSeperateMVP: function() {
		return this._forceSeperateMVP;
	}
	,set_forceSeperateMVP: function(value) {
		this._forceSeperateMVP = value;
		return value;
	}
	,initRegisterCache: function(profile) {
		this._registerCache = new away3d_materials_compilation_ShaderRegisterCache(profile);
		this._registerCache.set_vertexAttributesOffset(1);
		this._registerCache.reset();
	}
	,get_animateUVs: function() {
		return this._animateUVs;
	}
	,set_animateUVs: function(value) {
		this._animateUVs = value;
		return value;
	}
	,get_animateUVs2: function() {
		return this._animateUVs2;
	}
	,set_animateUVs2: function(value) {
		this._animateUVs2 = value;
		return value;
	}
	,get_alphaPremultiplied: function() {
		return this._alphaPremultiplied;
	}
	,set_alphaPremultiplied: function(value) {
		this._alphaPremultiplied = value;
		return value;
	}
	,get_preserveAlpha: function() {
		return this._preserveAlpha;
	}
	,set_preserveAlpha: function(value) {
		this._preserveAlpha = value;
		return value;
	}
	,setTextureSampling: function(smooth,repeat,mipmap,anisotropy) {
		this._smooth = smooth;
		this._repeat = repeat;
		this._mipmap = mipmap;
		this._anisotropy = anisotropy;
	}
	,setConstantDataBuffers: function(vertexConstantData,fragmentConstantData) {
		this._vertexConstantData = vertexConstantData;
		this._fragmentConstantData = fragmentConstantData;
	}
	,get_methodSetup: function() {
		return this._methodSetup;
	}
	,set_methodSetup: function(value) {
		this._methodSetup = value;
		return value;
	}
	,compile: function() {
		this.initRegisterIndices();
		this.initLightData();
		var array = ["va0"];
		var vector = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		var _g = 0;
		var _g1 = array.length;
		while(_g < _g1) {
			var i = _g++;
			vector.set(i,array[i]);
		}
		this._animatableAttributes = vector;
		var array1 = ["vt0"];
		var vector1 = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		var _g2 = 0;
		var _g11 = array1.length;
		while(_g2 < _g11) {
			var i1 = _g2++;
			vector1.set(i1,array1[i1]);
		}
		this._animationTargetRegisters = vector1;
		this._vertexCode = "";
		this._fragmentCode = "";
		this._sharedRegisters.localPosition = this._registerCache.getFreeVertexVectorTemp();
		this._registerCache.addVertexTempUsages(this._sharedRegisters.localPosition,1);
		this.createCommons();
		this.calculateDependencies();
		this.updateMethodRegisters();
		this._registerCache.getFreeVertexConstant();
		this._registerCache.getFreeVertexConstant();
		this._registerCache.getFreeVertexConstant();
		this._registerCache.getFreeVertexConstant();
		this.createNormalRegisters();
		if(this._dependencyCounter.get_globalPosDependencies() > 0 || this._forceSeperateMVP) {
			this.compileGlobalPositionCode();
		}
		this.compileProjectionCode();
		this.compileMethodsCode();
		this.compileFragmentOutput();
		this._fragmentPostLightCode = this.get_fragmentCode();
	}
	,createNormalRegisters: function() {
	}
	,compileMethodsCode: function() {
		if(this._dependencyCounter.get_uvDependencies() > 0) {
			this.compileUVCode();
		}
		if(this._dependencyCounter.get_secondaryUVDependencies() > 0) {
			this.compileSecondaryUVCode();
		}
		if(this._dependencyCounter.get_normalDependencies() > 0) {
			this.compileNormalCode();
		}
		if(this._dependencyCounter.get_viewDirDependencies() > 0) {
			this.compileViewDirCode();
		}
		this.compileLightingCode();
		this._fragmentLightCode = this._fragmentCode;
		this._fragmentCode = "";
		this.compileMethods();
	}
	,compileLightingCode: function() {
	}
	,compileViewDirCode: function() {
	}
	,compileNormalCode: function() {
	}
	,compileUVCode: function() {
		var uvAttributeReg = this._registerCache.getFreeVertexAttribute();
		this._uvBufferIndex = uvAttributeReg.get_index();
		var varying = this._registerCache.getFreeVarying();
		this._sharedRegisters.uvVarying = varying;
		if(this.get_animateUVs()) {
			var uvTransform1 = this._registerCache.getFreeVertexConstant();
			var uvTransform2 = this._registerCache.getFreeVertexConstant();
			this._uvTransformIndex = uvTransform1.get_index() * 4;
			this._vertexCode += "dp4 " + Std.string(varying) + ".x, " + Std.string(uvAttributeReg) + ", " + Std.string(uvTransform1) + "\n" + "dp4 " + Std.string(varying) + ".y, " + Std.string(uvAttributeReg) + ", " + Std.string(uvTransform2) + "\n" + "mov " + Std.string(varying) + ".zw, " + Std.string(uvAttributeReg) + ".zw \n";
		} else {
			this._uvTransformIndex = -1;
			this._needUVAnimation = true;
			this._UVTarget = varying.toString();
			this._UVSource = uvAttributeReg.toString();
		}
	}
	,compileSecondaryUVCode: function() {
		var uvAttributeReg = this._registerCache.getFreeVertexAttribute();
		this._secondaryUVBufferIndex = uvAttributeReg.get_index();
		var varying = this._registerCache.getFreeVarying();
		this._sharedRegisters.secondaryUVVarying = varying;
		if(this.get_animateUVs2()) {
			var uvTransformX = this._registerCache.getFreeVertexConstant();
			var uvTransformY = this._registerCache.getFreeVertexConstant();
			this._uvTransformIndex2 = uvTransformX.get_index() * 4;
			this._vertexCode += "dp4 " + Std.string(varying) + ".x, " + Std.string(uvAttributeReg) + ", " + Std.string(uvTransformX) + "\n";
			this._vertexCode += "dp4 " + Std.string(varying) + ".y, " + Std.string(uvAttributeReg) + ", " + Std.string(uvTransformY) + "\n";
			this._vertexCode += "mov " + Std.string(varying) + ".zw, " + Std.string(uvAttributeReg) + ".zw" + "\n";
		} else {
			this._uvTransformIndex2 = -1;
			this._vertexCode += "mov " + Std.string(varying) + ", " + Std.string(uvAttributeReg) + "\n";
		}
	}
	,compileGlobalPositionCode: function() {
		this._sharedRegisters.globalPositionVertex = this._registerCache.getFreeVertexVectorTemp();
		this._registerCache.addVertexTempUsages(this._sharedRegisters.globalPositionVertex,this._dependencyCounter.get_globalPosDependencies());
		var positionMatrixReg = this._registerCache.getFreeVertexConstant();
		this._registerCache.getFreeVertexConstant();
		this._registerCache.getFreeVertexConstant();
		this._registerCache.getFreeVertexConstant();
		this._sceneMatrixIndex = positionMatrixReg.get_index() * 4;
		this._vertexCode += "m44 " + Std.string(this._sharedRegisters.globalPositionVertex) + ", " + Std.string(this._sharedRegisters.localPosition) + ", " + Std.string(positionMatrixReg) + "\n";
		if(this._dependencyCounter.get_usesGlobalPosFragment()) {
			this._sharedRegisters.globalPositionVarying = this._registerCache.getFreeVarying();
			this._vertexCode += "mov " + Std.string(this._sharedRegisters.globalPositionVarying) + ", " + Std.string(this._sharedRegisters.globalPositionVertex) + "\n";
		}
	}
	,compileProjectionCode: function() {
		var pos = this._dependencyCounter.get_globalPosDependencies() > 0 || this._forceSeperateMVP ? this._sharedRegisters.globalPositionVertex.toString() : this._animationTargetRegisters.get(0);
		var code;
		if(this._dependencyCounter.get_projectionDependencies() > 0) {
			this._sharedRegisters.projectionFragment = this._registerCache.getFreeVarying();
			code = "m44 vt5, " + pos + ", vc0\t\t\n" + "mov " + Std.string(this._sharedRegisters.projectionFragment) + ", vt5\n" + "mov op, vt5\n";
		} else {
			code = "m44 op, " + pos + ", vc0\t\t\n";
		}
		this._vertexCode += code;
	}
	,compileFragmentOutput: function() {
		this._fragmentCode += "mov " + Std.string(this._registerCache.get_fragmentOutputRegister()) + ", " + Std.string(this._sharedRegisters.shadedTarget) + "\n";
		this._registerCache.removeFragmentTempUsage(this._sharedRegisters.shadedTarget);
	}
	,initRegisterIndices: function() {
		this._commonsDataIndex = -1;
		this._cameraPositionIndex = -1;
		this._uvBufferIndex = -1;
		this._uvTransformIndex = -1;
		this._uvTransformIndex2 = -1;
		this._secondaryUVBufferIndex = -1;
		this._normalBufferIndex = -1;
		this._tangentBufferIndex = -1;
		this._lightFragmentConstantIndex = -1;
		this._sceneMatrixIndex = -1;
		this._sceneNormalMatrixIndex = -1;
		this._probeWeightsIndex = -1;
	}
	,initLightData: function() {
		this._numLights = this._numPointLights + this._numDirectionalLights;
		this._numProbeRegisters = Math.ceil(this._numLightProbes / 4);
		if(this._methodSetup._specularMethod != null) {
			this._combinedLightSources = this._specularLightSources | this._diffuseLightSources;
		} else {
			this._combinedLightSources = this._diffuseLightSources;
		}
		this._usingSpecularMethod = this._methodSetup._specularMethod != null && (this.usesLightsForSpecular() || this.usesProbesForSpecular());
	}
	,createCommons: function() {
		this._sharedRegisters.commons = this._registerCache.getFreeFragmentConstant();
		this._commonsDataIndex = this._sharedRegisters.commons.get_index() * 4;
	}
	,calculateDependencies: function() {
		this._dependencyCounter.reset();
		var methods = this._methodSetup._methods;
		this.setupAndCountMethodDependencies(this._methodSetup._diffuseMethod,this._methodSetup._diffuseMethodVO);
		if(this._methodSetup._shadowMethod != null) {
			this.setupAndCountMethodDependencies(this._methodSetup._shadowMethod,this._methodSetup._shadowMethodVO);
		}
		this.setupAndCountMethodDependencies(this._methodSetup._ambientMethod,this._methodSetup._ambientMethodVO);
		if(this._usingSpecularMethod) {
			this.setupAndCountMethodDependencies(this._methodSetup._specularMethod,this._methodSetup._specularMethodVO);
		}
		if(this._methodSetup._colorTransformMethod != null) {
			this.setupAndCountMethodDependencies(this._methodSetup._colorTransformMethod,this._methodSetup._colorTransformMethodVO);
		}
		var len = methods.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			this.setupAndCountMethodDependencies(methods.get(i).method,methods.get(i).data);
		}
		if(this.get_usesNormals()) {
			this.setupAndCountMethodDependencies(this._methodSetup._normalMethod,this._methodSetup._normalMethodVO);
		}
		this._dependencyCounter.setPositionedLights(this._numPointLights,this._combinedLightSources);
	}
	,setupAndCountMethodDependencies: function(method,methodVO) {
		this.setupMethod(method,methodVO);
		this._dependencyCounter.includeMethodVO(methodVO);
	}
	,setupMethod: function(method,methodVO) {
		method.reset();
		methodVO.reset();
		methodVO.vertexData = this._vertexConstantData;
		methodVO.fragmentData = this._fragmentConstantData;
		methodVO.useSmoothTextures = this._smooth;
		methodVO.repeatTextures = this._repeat;
		methodVO.useMipmapping = this._mipmap;
		methodVO.anisotropy = this._anisotropy;
		methodVO.useLightFallOff = this._enableLightFallOff && this._profile != "baselineConstrained";
		methodVO.numLights = this._numLights + this._numLightProbes;
		method.initVO(methodVO);
	}
	,get_commonsDataIndex: function() {
		return this._commonsDataIndex;
	}
	,updateMethodRegisters: function() {
		this._methodSetup._normalMethod.set_sharedRegisters(this._sharedRegisters);
		this._methodSetup._diffuseMethod.set_sharedRegisters(this._sharedRegisters);
		if(this._methodSetup._shadowMethod != null) {
			this._methodSetup._shadowMethod.set_sharedRegisters(this._sharedRegisters);
		}
		this._methodSetup._ambientMethod.set_sharedRegisters(this._sharedRegisters);
		if(this._methodSetup._specularMethod != null) {
			this._methodSetup._specularMethod.set_sharedRegisters(this._sharedRegisters);
		}
		if(this._methodSetup._colorTransformMethod != null) {
			this._methodSetup._colorTransformMethod.set_sharedRegisters(this._sharedRegisters);
		}
		var methods = this._methodSetup._methods;
		var len = methods.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			methods.get(i).method.set_sharedRegisters(this._sharedRegisters);
		}
	}
	,get_numUsedVertexConstants: function() {
		return this._registerCache.get_numUsedVertexConstants();
	}
	,get_numUsedFragmentConstants: function() {
		return this._registerCache.get_numUsedFragmentConstants();
	}
	,get_numUsedStreams: function() {
		return this._registerCache.get_numUsedStreams();
	}
	,get_numUsedTextures: function() {
		return this._registerCache.get_numUsedTextures();
	}
	,get_numUsedVaryings: function() {
		return this._registerCache.get_numUsedVaryings();
	}
	,usesLightsForSpecular: function() {
		if(this._numLights > 0) {
			return (this._specularLightSources & 1) != 0;
		} else {
			return false;
		}
	}
	,usesLightsForDiffuse: function() {
		if(this._numLights > 0) {
			return (this._diffuseLightSources & 1) != 0;
		} else {
			return false;
		}
	}
	,dispose: function() {
		this.cleanUpMethods();
		this._registerCache.dispose();
		this._registerCache = null;
		this._sharedRegisters = null;
	}
	,cleanUpMethods: function() {
		if(this._methodSetup._normalMethod != null) {
			this._methodSetup._normalMethod.cleanCompilationData();
		}
		if(this._methodSetup._diffuseMethod != null) {
			this._methodSetup._diffuseMethod.cleanCompilationData();
		}
		if(this._methodSetup._ambientMethod != null) {
			this._methodSetup._ambientMethod.cleanCompilationData();
		}
		if(this._methodSetup._specularMethod != null) {
			this._methodSetup._specularMethod.cleanCompilationData();
		}
		if(this._methodSetup._shadowMethod != null) {
			this._methodSetup._shadowMethod.cleanCompilationData();
		}
		if(this._methodSetup._colorTransformMethod != null) {
			this._methodSetup._colorTransformMethod.cleanCompilationData();
		}
		var methods = this._methodSetup._methods;
		var len = methods.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			methods.get(i).method.cleanCompilationData();
		}
	}
	,get_specularLightSources: function() {
		return this._specularLightSources;
	}
	,set_specularLightSources: function(value) {
		this._specularLightSources = value;
		return value;
	}
	,get_diffuseLightSources: function() {
		return this._diffuseLightSources;
	}
	,set_diffuseLightSources: function(value) {
		this._diffuseLightSources = value;
		return value;
	}
	,usesProbesForSpecular: function() {
		if(this._numLightProbes > 0) {
			return (this._specularLightSources & 2) != 0;
		} else {
			return false;
		}
	}
	,usesProbesForDiffuse: function() {
		if(this._numLightProbes > 0) {
			return (this._diffuseLightSources & 2) != 0;
		} else {
			return false;
		}
	}
	,usesProbes: function() {
		if(this._numLightProbes > 0) {
			return ((this._diffuseLightSources | this._specularLightSources) & 2) != 0;
		} else {
			return false;
		}
	}
	,get_uvBufferIndex: function() {
		return this._uvBufferIndex;
	}
	,get_uvTransformIndex: function() {
		return this._uvTransformIndex;
	}
	,get_uvTransformIndex2: function() {
		return this._uvTransformIndex2;
	}
	,get_secondaryUVBufferIndex: function() {
		return this._secondaryUVBufferIndex;
	}
	,get_normalBufferIndex: function() {
		return this._normalBufferIndex;
	}
	,get_tangentBufferIndex: function() {
		return this._tangentBufferIndex;
	}
	,get_lightFragmentConstantIndex: function() {
		return this._lightFragmentConstantIndex;
	}
	,get_cameraPositionIndex: function() {
		return this._cameraPositionIndex;
	}
	,get_sceneMatrixIndex: function() {
		return this._sceneMatrixIndex;
	}
	,get_sceneNormalMatrixIndex: function() {
		return this._sceneNormalMatrixIndex;
	}
	,get_probeWeightsIndex: function() {
		return this._probeWeightsIndex;
	}
	,get_vertexCode: function() {
		return this._vertexCode;
	}
	,get_fragmentCode: function() {
		return this._fragmentCode;
	}
	,get_fragmentLightCode: function() {
		return this._fragmentLightCode;
	}
	,get_fragmentPostLightCode: function() {
		return this._fragmentPostLightCode;
	}
	,get_shadedTarget: function() {
		return this._sharedRegisters.shadedTarget.toString();
	}
	,get_numPointLights: function() {
		return this._numPointLights;
	}
	,set_numPointLights: function(numPointLights) {
		this._numPointLights = numPointLights;
		return numPointLights;
	}
	,get_numDirectionalLights: function() {
		return this._numDirectionalLights;
	}
	,set_numDirectionalLights: function(value) {
		this._numDirectionalLights = value;
		return value;
	}
	,get_numLightProbes: function() {
		return this._numLightProbes;
	}
	,set_numLightProbes: function(value) {
		this._numLightProbes = value;
		return value;
	}
	,get_usingSpecularMethod: function() {
		return this._usingSpecularMethod;
	}
	,get_animatableAttributes: function() {
		return this._animatableAttributes;
	}
	,get_animationTargetRegisters: function() {
		return this._animationTargetRegisters;
	}
	,get_usesNormals: function() {
		if(this._dependencyCounter.get_normalDependencies() > 0) {
			return this._methodSetup._normalMethod.get_hasOutput();
		} else {
			return false;
		}
	}
	,usesLights: function() {
		if(this._numLights > 0) {
			return (this._combinedLightSources & 1) != 0;
		} else {
			return false;
		}
	}
	,compileMethods: function() {
		var methods = this._methodSetup._methods;
		var numMethods = methods.get_length();
		var method;
		var data;
		var alphaReg = null;
		if(this._preserveAlpha) {
			alphaReg = this._registerCache.getFreeFragmentSingleTemp();
			this._registerCache.addFragmentTempUsages(alphaReg,1);
			this._fragmentCode += "mov " + Std.string(alphaReg) + ", " + Std.string(this._sharedRegisters.shadedTarget) + ".w\n";
		}
		var _g = 0;
		var _g1 = numMethods;
		while(_g < _g1) {
			var i = _g++;
			method = methods.get(i).method;
			data = methods.get(i).data;
			this._vertexCode += method.getVertexCode(data,this._registerCache);
			if(data.needsGlobalVertexPos || data.needsGlobalFragmentPos) {
				this._registerCache.removeVertexTempUsage(this._sharedRegisters.globalPositionVertex);
			}
			this._fragmentCode += method.getFragmentCode(data,this._registerCache,this._sharedRegisters.shadedTarget);
			if(data.needsNormals) {
				this._registerCache.removeFragmentTempUsage(this._sharedRegisters.normalFragment);
			}
			if(data.needsView) {
				this._registerCache.removeFragmentTempUsage(this._sharedRegisters.viewDirFragment);
			}
		}
		if(this._preserveAlpha) {
			this._fragmentCode += "mov " + Std.string(this._sharedRegisters.shadedTarget) + ".w, " + Std.string(alphaReg) + "\n";
			this._registerCache.removeFragmentTempUsage(alphaReg);
		}
		if(this._methodSetup._colorTransformMethod != null) {
			this._vertexCode += this._methodSetup._colorTransformMethod.getVertexCode(this._methodSetup._colorTransformMethodVO,this._registerCache);
			this._fragmentCode += this._methodSetup._colorTransformMethod.getFragmentCode(this._methodSetup._colorTransformMethodVO,this._registerCache,this._sharedRegisters.shadedTarget);
		}
	}
	,get_lightProbeDiffuseIndices: function() {
		return this._lightProbeDiffuseIndices;
	}
	,get_lightProbeSpecularIndices: function() {
		return this._lightProbeSpecularIndices;
	}
	,__class__: away3d_materials_compilation_ShaderCompiler
	,__properties__: {get_lightProbeSpecularIndices:"get_lightProbeSpecularIndices",get_lightProbeDiffuseIndices:"get_lightProbeDiffuseIndices",get_usesNormals:"get_usesNormals",get_animationTargetRegisters:"get_animationTargetRegisters",get_animatableAttributes:"get_animatableAttributes",get_usingSpecularMethod:"get_usingSpecularMethod",set_numLightProbes:"set_numLightProbes",get_numLightProbes:"get_numLightProbes",set_numDirectionalLights:"set_numDirectionalLights",get_numDirectionalLights:"get_numDirectionalLights",set_numPointLights:"set_numPointLights",get_numPointLights:"get_numPointLights",get_shadedTarget:"get_shadedTarget",get_fragmentPostLightCode:"get_fragmentPostLightCode",get_fragmentLightCode:"get_fragmentLightCode",get_fragmentCode:"get_fragmentCode",get_vertexCode:"get_vertexCode",get_probeWeightsIndex:"get_probeWeightsIndex",get_sceneNormalMatrixIndex:"get_sceneNormalMatrixIndex",get_sceneMatrixIndex:"get_sceneMatrixIndex",get_cameraPositionIndex:"get_cameraPositionIndex",get_lightFragmentConstantIndex:"get_lightFragmentConstantIndex",get_tangentBufferIndex:"get_tangentBufferIndex",get_normalBufferIndex:"get_normalBufferIndex",get_secondaryUVBufferIndex:"get_secondaryUVBufferIndex",get_uvTransformIndex2:"get_uvTransformIndex2",get_uvTransformIndex:"get_uvTransformIndex",get_uvBufferIndex:"get_uvBufferIndex",set_diffuseLightSources:"set_diffuseLightSources",get_diffuseLightSources:"get_diffuseLightSources",set_specularLightSources:"set_specularLightSources",get_specularLightSources:"get_specularLightSources",get_numUsedVaryings:"get_numUsedVaryings",get_numUsedTextures:"get_numUsedTextures",get_numUsedStreams:"get_numUsedStreams",get_numUsedFragmentConstants:"get_numUsedFragmentConstants",get_numUsedVertexConstants:"get_numUsedVertexConstants",get_commonsDataIndex:"get_commonsDataIndex",set_methodSetup:"set_methodSetup",get_methodSetup:"get_methodSetup",set_preserveAlpha:"set_preserveAlpha",get_preserveAlpha:"get_preserveAlpha",set_alphaPremultiplied:"set_alphaPremultiplied",get_alphaPremultiplied:"get_alphaPremultiplied",set_animateUVs2:"set_animateUVs2",get_animateUVs2:"get_animateUVs2",set_animateUVs:"set_animateUVs",get_animateUVs:"get_animateUVs",set_forceSeperateMVP:"set_forceSeperateMVP",get_forceSeperateMVP:"get_forceSeperateMVP",get_UVSource:"get_UVSource",get_UVTarget:"get_UVTarget",get_needUVAnimation:"get_needUVAnimation",set_enableLightFallOff:"set_enableLightFallOff",get_enableLightFallOff:"get_enableLightFallOff"}
};
var away3d_materials_compilation_ShaderRegisterData = function() {
};
$hxClasses["away3d.materials.compilation.ShaderRegisterData"] = away3d_materials_compilation_ShaderRegisterData;
away3d_materials_compilation_ShaderRegisterData.__name__ = "away3d.materials.compilation.ShaderRegisterData";
away3d_materials_compilation_ShaderRegisterData.prototype = {
	normalVarying: null
	,tangentVarying: null
	,bitangentVarying: null
	,uvVarying: null
	,secondaryUVVarying: null
	,viewDirVarying: null
	,shadedTarget: null
	,globalPositionVertex: null
	,globalPositionVarying: null
	,localPosition: null
	,normalInput: null
	,tangentInput: null
	,animatedNormal: null
	,animatedTangent: null
	,commons: null
	,projectionFragment: null
	,normalFragment: null
	,viewDirFragment: null
	,bitangent: null
	,__class__: away3d_materials_compilation_ShaderRegisterData
};
var away3d_materials_compilation_ShaderRegisterElement = function(regName,index,component) {
	if(component == null) {
		component = -1;
	}
	this._component = component;
	this._regName = regName;
	this._index = index;
	this._toStr = this._regName;
	if(this._index >= 0) {
		this._toStr += this._index;
	}
	if(component > -1) {
		this._toStr += "." + away3d_materials_compilation_ShaderRegisterElement.COMPONENTS[component];
	}
};
$hxClasses["away3d.materials.compilation.ShaderRegisterElement"] = away3d_materials_compilation_ShaderRegisterElement;
away3d_materials_compilation_ShaderRegisterElement.__name__ = "away3d.materials.compilation.ShaderRegisterElement";
away3d_materials_compilation_ShaderRegisterElement.prototype = {
	_regName: null
	,_index: null
	,_toStr: null
	,_component: null
	,toString: function() {
		return this._toStr;
	}
	,get_regName: function() {
		return this._regName;
	}
	,get_index: function() {
		return this._index;
	}
	,__class__: away3d_materials_compilation_ShaderRegisterElement
	,__properties__: {get_index:"get_index",get_regName:"get_regName"}
};
var away3d_materials_compilation_SuperShaderCompiler = function(profile) {
	away3d_materials_compilation_ShaderCompiler.call(this,profile);
};
$hxClasses["away3d.materials.compilation.SuperShaderCompiler"] = away3d_materials_compilation_SuperShaderCompiler;
away3d_materials_compilation_SuperShaderCompiler.__name__ = "away3d.materials.compilation.SuperShaderCompiler";
away3d_materials_compilation_SuperShaderCompiler.__super__ = away3d_materials_compilation_ShaderCompiler;
away3d_materials_compilation_SuperShaderCompiler.prototype = $extend(away3d_materials_compilation_ShaderCompiler.prototype,{
	_pointLightRegisters: null
	,_dirLightRegisters: null
	,initLightData: function() {
		away3d_materials_compilation_ShaderCompiler.prototype.initLightData.call(this);
		this._pointLightRegisters = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,this._numPointLights * 3,true);
		this._dirLightRegisters = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,this._numDirectionalLights * 3,true);
	}
	,calculateDependencies: function() {
		away3d_materials_compilation_ShaderCompiler.prototype.calculateDependencies.call(this);
		this._dependencyCounter.addWorldSpaceDependencies(true);
	}
	,compileNormalCode: function() {
		var normalMatrix = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,3,true);
		this._sharedRegisters.normalFragment = this._registerCache.getFreeFragmentVectorTemp();
		this._registerCache.addFragmentTempUsages(this._sharedRegisters.normalFragment,this._dependencyCounter.get_normalDependencies());
		if(this._methodSetup._normalMethod.get_hasOutput() && !this._methodSetup._normalMethod.get_tangentSpace()) {
			this._vertexCode += this._methodSetup._normalMethod.getVertexCode(this._methodSetup._normalMethodVO,this._registerCache);
			this._fragmentCode += this._methodSetup._normalMethod.getFragmentCode(this._methodSetup._normalMethodVO,this._registerCache,this._sharedRegisters.normalFragment);
			return;
		}
		this._sharedRegisters.normalVarying = this._registerCache.getFreeVarying();
		normalMatrix.set(0,this._registerCache.getFreeVertexConstant());
		normalMatrix.set(1,this._registerCache.getFreeVertexConstant());
		normalMatrix.set(2,this._registerCache.getFreeVertexConstant());
		this._registerCache.getFreeVertexConstant();
		this._sceneNormalMatrixIndex = normalMatrix.get(0).get_index() * 4;
		if(this._methodSetup._normalMethod.get_hasOutput()) {
			this.compileTangentVertexCode(normalMatrix);
			this.compileTangentNormalMapFragmentCode();
		} else {
			this._vertexCode += "m33 " + Std.string(this._sharedRegisters.normalVarying) + ".xyz, " + Std.string(this._sharedRegisters.animatedNormal) + ", " + Std.string(normalMatrix.get(0)) + "\n" + "mov " + Std.string(this._sharedRegisters.normalVarying) + ".w, " + Std.string(this._sharedRegisters.animatedNormal) + ".w\t\n";
			this._fragmentCode += "nrm " + Std.string(this._sharedRegisters.normalFragment) + ".xyz, " + Std.string(this._sharedRegisters.normalVarying) + "\n" + "mov " + Std.string(this._sharedRegisters.normalFragment) + ".w, " + Std.string(this._sharedRegisters.normalVarying) + ".w\t\t\n";
			if(this._dependencyCounter.get_tangentDependencies() > 0) {
				this._sharedRegisters.tangentInput = this._registerCache.getFreeVertexAttribute();
				this._tangentBufferIndex = this._sharedRegisters.tangentInput.get_index();
				this._sharedRegisters.tangentVarying = this._registerCache.getFreeVarying();
				this._vertexCode += "mov " + Std.string(this._sharedRegisters.tangentVarying) + ", " + Std.string(this._sharedRegisters.tangentInput) + "\n";
			}
		}
		this._registerCache.removeVertexTempUsage(this._sharedRegisters.animatedNormal);
	}
	,createNormalRegisters: function() {
		if(this._dependencyCounter.get_normalDependencies() > 0) {
			this._sharedRegisters.normalInput = this._registerCache.getFreeVertexAttribute();
			this._normalBufferIndex = this._sharedRegisters.normalInput.get_index();
			this._sharedRegisters.animatedNormal = this._registerCache.getFreeVertexVectorTemp();
			this._registerCache.addVertexTempUsages(this._sharedRegisters.animatedNormal,1);
			this._animatableAttributes.push(this._sharedRegisters.normalInput.toString());
			this._animationTargetRegisters.push(this._sharedRegisters.animatedNormal.toString());
		}
		if(this._methodSetup._normalMethod.get_hasOutput()) {
			this._sharedRegisters.tangentInput = this._registerCache.getFreeVertexAttribute();
			this._tangentBufferIndex = this._sharedRegisters.tangentInput.get_index();
			this._sharedRegisters.animatedTangent = this._registerCache.getFreeVertexVectorTemp();
			this._registerCache.addVertexTempUsages(this._sharedRegisters.animatedTangent,1);
			this._animatableAttributes.push(this._sharedRegisters.tangentInput.toString());
			this._animationTargetRegisters.push(this._sharedRegisters.animatedTangent.toString());
		}
	}
	,compileTangentVertexCode: function(matrix) {
		this._sharedRegisters.tangentVarying = this._registerCache.getFreeVarying();
		this._sharedRegisters.bitangentVarying = this._registerCache.getFreeVarying();
		this._vertexCode += "m33 " + Std.string(this._sharedRegisters.animatedNormal) + ".xyz, " + Std.string(this._sharedRegisters.animatedNormal) + ", " + Std.string(matrix.get(0)) + "\n" + "nrm " + Std.string(this._sharedRegisters.animatedNormal) + ".xyz, " + Std.string(this._sharedRegisters.animatedNormal) + "\n";
		this._vertexCode += "m33 " + Std.string(this._sharedRegisters.animatedTangent) + ".xyz, " + Std.string(this._sharedRegisters.animatedTangent) + ", " + Std.string(matrix.get(0)) + "\n" + "nrm " + Std.string(this._sharedRegisters.animatedTangent) + ".xyz, " + Std.string(this._sharedRegisters.animatedTangent) + "\n";
		var bitanTemp = this._registerCache.getFreeVertexVectorTemp();
		this._vertexCode += "mov " + Std.string(this._sharedRegisters.tangentVarying) + ".x, " + Std.string(this._sharedRegisters.animatedTangent) + ".x  \n" + "mov " + Std.string(this._sharedRegisters.tangentVarying) + ".z, " + Std.string(this._sharedRegisters.animatedNormal) + ".x  \n" + "mov " + Std.string(this._sharedRegisters.tangentVarying) + ".w, " + Std.string(this._sharedRegisters.normalInput) + ".w  \n" + "mov " + Std.string(this._sharedRegisters.bitangentVarying) + ".x, " + Std.string(this._sharedRegisters.animatedTangent) + ".y  \n" + "mov " + Std.string(this._sharedRegisters.bitangentVarying) + ".z, " + Std.string(this._sharedRegisters.animatedNormal) + ".y  \n" + "mov " + Std.string(this._sharedRegisters.bitangentVarying) + ".w, " + Std.string(this._sharedRegisters.normalInput) + ".w  \n" + "mov " + Std.string(this._sharedRegisters.normalVarying) + ".x, " + Std.string(this._sharedRegisters.animatedTangent) + ".z  \n" + "mov " + Std.string(this._sharedRegisters.normalVarying) + ".z, " + Std.string(this._sharedRegisters.animatedNormal) + ".z  \n" + "mov " + Std.string(this._sharedRegisters.normalVarying) + ".w, " + Std.string(this._sharedRegisters.normalInput) + ".w  \n" + "crs " + Std.string(bitanTemp) + ".xyz, " + Std.string(this._sharedRegisters.animatedNormal) + ", " + Std.string(this._sharedRegisters.animatedTangent) + "\n" + "mov " + Std.string(this._sharedRegisters.tangentVarying) + ".y, " + Std.string(bitanTemp) + ".x    \n" + "mov " + Std.string(this._sharedRegisters.bitangentVarying) + ".y, " + Std.string(bitanTemp) + ".y  \n" + "mov " + Std.string(this._sharedRegisters.normalVarying) + ".y, " + Std.string(bitanTemp) + ".z    \n";
		this._registerCache.removeVertexTempUsage(this._sharedRegisters.animatedTangent);
	}
	,compileTangentNormalMapFragmentCode: function() {
		var t = this._registerCache.getFreeFragmentVectorTemp();
		this._registerCache.addFragmentTempUsages(t,1);
		var b = this._registerCache.getFreeFragmentVectorTemp();
		this._registerCache.addFragmentTempUsages(b,1);
		var n = this._registerCache.getFreeFragmentVectorTemp();
		this._registerCache.addFragmentTempUsages(n,1);
		this._fragmentCode += "nrm " + Std.string(t) + ".xyz, " + Std.string(this._sharedRegisters.tangentVarying) + "\n" + "mov " + Std.string(t) + ".w, " + Std.string(this._sharedRegisters.tangentVarying) + ".w\t\n" + "nrm " + Std.string(b) + ".xyz, " + Std.string(this._sharedRegisters.bitangentVarying) + "\n" + "nrm " + Std.string(n) + ".xyz, " + Std.string(this._sharedRegisters.normalVarying) + "\n";
		var temp = this._registerCache.getFreeFragmentVectorTemp();
		this._registerCache.addFragmentTempUsages(temp,1);
		this._fragmentCode += this._methodSetup._normalMethod.getFragmentCode(this._methodSetup._normalMethodVO,this._registerCache,temp) + "m33 " + Std.string(this._sharedRegisters.normalFragment) + ".xyz, " + Std.string(temp) + ", " + Std.string(t) + "\t\n" + "mov " + Std.string(this._sharedRegisters.normalFragment) + ".w,   " + Std.string(this._sharedRegisters.normalVarying) + ".w\t\t\t\n";
		this._registerCache.removeFragmentTempUsage(temp);
		if(this._methodSetup._normalMethodVO.needsView) {
			this._registerCache.removeFragmentTempUsage(this._sharedRegisters.viewDirFragment);
		}
		if(this._methodSetup._normalMethodVO.needsGlobalVertexPos || this._methodSetup._normalMethodVO.needsGlobalFragmentPos) {
			this._registerCache.removeVertexTempUsage(this._sharedRegisters.globalPositionVertex);
		}
		this._registerCache.removeFragmentTempUsage(b);
		this._registerCache.removeFragmentTempUsage(t);
		this._registerCache.removeFragmentTempUsage(n);
	}
	,compileViewDirCode: function() {
		var cameraPositionReg = this._registerCache.getFreeVertexConstant();
		this._sharedRegisters.viewDirVarying = this._registerCache.getFreeVarying();
		this._sharedRegisters.viewDirFragment = this._registerCache.getFreeFragmentVectorTemp();
		this._registerCache.addFragmentTempUsages(this._sharedRegisters.viewDirFragment,this._dependencyCounter.get_viewDirDependencies());
		this._cameraPositionIndex = cameraPositionReg.get_index() * 4;
		this._vertexCode += "sub " + Std.string(this._sharedRegisters.viewDirVarying) + ", " + Std.string(cameraPositionReg) + ", " + Std.string(this._sharedRegisters.globalPositionVertex) + "\n";
		this._fragmentCode += "nrm " + Std.string(this._sharedRegisters.viewDirFragment) + ".xyz, " + Std.string(this._sharedRegisters.viewDirVarying) + "\n" + "mov " + Std.string(this._sharedRegisters.viewDirFragment) + ".w,   " + Std.string(this._sharedRegisters.viewDirVarying) + ".w \t\t\n";
		this._registerCache.removeVertexTempUsage(this._sharedRegisters.globalPositionVertex);
	}
	,compileLightingCode: function() {
		var shadowReg = null;
		this._sharedRegisters.shadedTarget = this._registerCache.getFreeFragmentVectorTemp();
		this._registerCache.addFragmentTempUsages(this._sharedRegisters.shadedTarget,1);
		this._vertexCode += this._methodSetup._diffuseMethod.getVertexCode(this._methodSetup._diffuseMethodVO,this._registerCache);
		this._fragmentCode += this._methodSetup._diffuseMethod.getFragmentPreLightingCode(this._methodSetup._diffuseMethodVO,this._registerCache);
		if(this._usingSpecularMethod) {
			this._vertexCode += this._methodSetup._specularMethod.getVertexCode(this._methodSetup._specularMethodVO,this._registerCache);
			this._fragmentCode += this._methodSetup._specularMethod.getFragmentPreLightingCode(this._methodSetup._specularMethodVO,this._registerCache);
		}
		if(this.usesLights()) {
			this.initLightRegisters();
			this.compileDirectionalLightCode();
			this.compilePointLightCode();
		}
		if(this.usesProbes()) {
			this.compileLightProbeCode();
		}
		this._vertexCode += this._methodSetup._ambientMethod.getVertexCode(this._methodSetup._ambientMethodVO,this._registerCache);
		this._fragmentCode += this._methodSetup._ambientMethod.getFragmentCode(this._methodSetup._ambientMethodVO,this._registerCache,this._sharedRegisters.shadedTarget);
		if(this._methodSetup._ambientMethodVO.needsNormals) {
			this._registerCache.removeFragmentTempUsage(this._sharedRegisters.normalFragment);
		}
		if(this._methodSetup._ambientMethodVO.needsView) {
			this._registerCache.removeFragmentTempUsage(this._sharedRegisters.viewDirFragment);
		}
		if(this._methodSetup._shadowMethod != null) {
			this._vertexCode += this._methodSetup._shadowMethod.getVertexCode(this._methodSetup._shadowMethodVO,this._registerCache);
			if(this._dependencyCounter.get_normalDependencies() == 0) {
				shadowReg = this._registerCache.getFreeFragmentVectorTemp();
				this._registerCache.addFragmentTempUsages(shadowReg,1);
			} else {
				shadowReg = this._sharedRegisters.normalFragment;
			}
			this._methodSetup._diffuseMethod.set_shadowRegister(shadowReg);
			this._fragmentCode += this._methodSetup._shadowMethod.getFragmentCode(this._methodSetup._shadowMethodVO,this._registerCache,shadowReg);
		}
		this._fragmentCode += this._methodSetup._diffuseMethod.getFragmentPostLightingCode(this._methodSetup._diffuseMethodVO,this._registerCache,this._sharedRegisters.shadedTarget);
		if(this._alphaPremultiplied) {
			this._fragmentCode += "add " + Std.string(this._sharedRegisters.shadedTarget) + ".w, " + Std.string(this._sharedRegisters.shadedTarget) + ".w, " + Std.string(this._sharedRegisters.commons) + ".z\n" + "div " + Std.string(this._sharedRegisters.shadedTarget) + ".xyz, " + Std.string(this._sharedRegisters.shadedTarget) + ", " + Std.string(this._sharedRegisters.shadedTarget) + ".w\n" + "sub " + Std.string(this._sharedRegisters.shadedTarget) + ".w, " + Std.string(this._sharedRegisters.shadedTarget) + ".w, " + Std.string(this._sharedRegisters.commons) + ".z\n" + "sat " + Std.string(this._sharedRegisters.shadedTarget) + ".xyz, " + Std.string(this._sharedRegisters.shadedTarget) + "\n";
		}
		if(this._methodSetup._diffuseMethodVO.needsNormals) {
			this._registerCache.removeFragmentTempUsage(this._sharedRegisters.normalFragment);
		}
		if(this._methodSetup._diffuseMethodVO.needsView) {
			this._registerCache.removeFragmentTempUsage(this._sharedRegisters.viewDirFragment);
		}
		if(this._usingSpecularMethod) {
			this._methodSetup._specularMethod.set_shadowRegister(shadowReg);
			this._fragmentCode += this._methodSetup._specularMethod.getFragmentPostLightingCode(this._methodSetup._specularMethodVO,this._registerCache,this._sharedRegisters.shadedTarget);
			if(this._methodSetup._specularMethodVO.needsNormals) {
				this._registerCache.removeFragmentTempUsage(this._sharedRegisters.normalFragment);
			}
			if(this._methodSetup._specularMethodVO.needsView) {
				this._registerCache.removeFragmentTempUsage(this._sharedRegisters.viewDirFragment);
			}
		}
	}
	,initLightRegisters: function() {
		var len = this._dirLightRegisters.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			this._dirLightRegisters.set(i,this._registerCache.getFreeFragmentConstant());
			if(this._lightFragmentConstantIndex == -1) {
				this._lightFragmentConstantIndex = this._dirLightRegisters.get(i).get_index() * 4;
			}
		}
		len = this._pointLightRegisters.get_length();
		var _g2 = 0;
		var _g3 = len;
		while(_g2 < _g3) {
			var i1 = _g2++;
			this._pointLightRegisters.set(i1,this._registerCache.getFreeFragmentConstant());
			if(this._lightFragmentConstantIndex == -1) {
				this._lightFragmentConstantIndex = this._pointLightRegisters.get(i1).get_index() * 4;
			}
		}
	}
	,compileDirectionalLightCode: function() {
		var diffuseColorReg;
		var specularColorReg;
		var lightDirReg;
		var regIndex = 0;
		var addSpec = this._usingSpecularMethod && this.usesLightsForSpecular();
		var addDiff = this.usesLightsForDiffuse();
		if(!(addSpec || addDiff)) {
			return;
		}
		var _g = 0;
		var _g1 = this._numDirectionalLights;
		while(_g < _g1) {
			var i = _g++;
			lightDirReg = this._dirLightRegisters.get(regIndex++);
			diffuseColorReg = this._dirLightRegisters.get(regIndex++);
			specularColorReg = this._dirLightRegisters.get(regIndex++);
			if(addDiff) {
				this._fragmentCode += this._methodSetup._diffuseMethod.getFragmentCodePerLight(this._methodSetup._diffuseMethodVO,lightDirReg,diffuseColorReg,this._registerCache);
			}
			if(addSpec) {
				this._fragmentCode += this._methodSetup._specularMethod.getFragmentCodePerLight(this._methodSetup._specularMethodVO,lightDirReg,specularColorReg,this._registerCache);
			}
		}
	}
	,compilePointLightCode: function() {
		var diffuseColorReg;
		var specularColorReg;
		var lightPosReg;
		var lightDirReg;
		var regIndex = 0;
		var addSpec = this._usingSpecularMethod && this.usesLightsForSpecular();
		var addDiff = this.usesLightsForDiffuse();
		if(!(addSpec || addDiff)) {
			return;
		}
		var _g = 0;
		var _g1 = this._numPointLights;
		while(_g < _g1) {
			var i = _g++;
			lightPosReg = this._pointLightRegisters.get(regIndex++);
			diffuseColorReg = this._pointLightRegisters.get(regIndex++);
			specularColorReg = this._pointLightRegisters.get(regIndex++);
			lightDirReg = this._registerCache.getFreeFragmentVectorTemp();
			this._registerCache.addFragmentTempUsages(lightDirReg,1);
			this._fragmentCode += "sub " + Std.string(lightDirReg) + ", " + Std.string(lightPosReg) + ", " + Std.string(this._sharedRegisters.globalPositionVarying) + "\n" + "dp3 " + Std.string(lightDirReg) + ".w, " + Std.string(lightDirReg) + ", " + Std.string(lightDirReg) + "\n" + "sub " + Std.string(lightDirReg) + ".w, " + Std.string(lightDirReg) + ".w, " + Std.string(diffuseColorReg) + ".w\n" + "mul " + Std.string(lightDirReg) + ".w, " + Std.string(lightDirReg) + ".w, " + Std.string(specularColorReg) + ".w\n" + "sat " + Std.string(lightDirReg) + ".w, " + Std.string(lightDirReg) + ".w\n" + "sub " + Std.string(lightDirReg) + ".w, " + Std.string(lightPosReg) + ".w, " + Std.string(lightDirReg) + ".w\n" + "nrm " + Std.string(lightDirReg) + ".xyz, " + Std.string(lightDirReg) + "\n";
			if(this._lightFragmentConstantIndex == -1) {
				this._lightFragmentConstantIndex = lightPosReg.get_index() * 4;
			}
			if(addDiff) {
				this._fragmentCode += this._methodSetup._diffuseMethod.getFragmentCodePerLight(this._methodSetup._diffuseMethodVO,lightDirReg,diffuseColorReg,this._registerCache);
			}
			if(addSpec) {
				this._fragmentCode += this._methodSetup._specularMethod.getFragmentCodePerLight(this._methodSetup._specularMethodVO,lightDirReg,specularColorReg,this._registerCache);
			}
			this._registerCache.removeFragmentTempUsage(lightDirReg);
		}
	}
	,compileLightProbeCode: function() {
		var weightReg;
		var weightComponents = [".x",".y",".z",".w"];
		var weightRegisters = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		var i = 0;
		var texReg;
		var addSpec = this._usingSpecularMethod && this.usesProbesForSpecular();
		var addDiff = this.usesProbesForDiffuse();
		if(!(addSpec || addDiff)) {
			return;
		}
		if(addDiff) {
			this._lightProbeDiffuseIndices = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
		}
		if(addSpec) {
			this._lightProbeSpecularIndices = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
		}
		var _g = 0;
		var _g1 = this._numProbeRegisters;
		while(_g < _g1) {
			var i1 = _g++;
			weightRegisters.set(i1,this._registerCache.getFreeFragmentConstant());
			if(i1 == 0) {
				this._probeWeightsIndex = weightRegisters.get(i1).get_index() * 4;
			}
		}
		var _g2 = 0;
		var _g3 = this._numLightProbes;
		while(_g2 < _g3) {
			var i2 = _g2++;
			weightReg = weightRegisters.get(Math.floor(i2 / 4)).toString() + weightComponents[i2 % 4];
			if(addDiff) {
				texReg = this._registerCache.getFreeTextureReg();
				this._lightProbeDiffuseIndices.set(i2,texReg.get_index());
				this._fragmentCode += this._methodSetup._diffuseMethod.getFragmentCodePerProbe(this._methodSetup._diffuseMethodVO,texReg,weightReg,this._registerCache);
			}
			if(addSpec) {
				texReg = this._registerCache.getFreeTextureReg();
				this._lightProbeSpecularIndices.set(i2,texReg.get_index());
				this._fragmentCode += this._methodSetup._specularMethod.getFragmentCodePerProbe(this._methodSetup._specularMethodVO,texReg,weightReg,this._registerCache);
			}
		}
	}
	,__class__: away3d_materials_compilation_SuperShaderCompiler
});
var away3d_materials_lightpickers_LightPickerBase = function() {
	away3d_library_assets_NamedAssetBase.call(this);
};
$hxClasses["away3d.materials.lightpickers.LightPickerBase"] = away3d_materials_lightpickers_LightPickerBase;
away3d_materials_lightpickers_LightPickerBase.__name__ = "away3d.materials.lightpickers.LightPickerBase";
away3d_materials_lightpickers_LightPickerBase.__interfaces__ = [away3d_library_assets_IAsset];
away3d_materials_lightpickers_LightPickerBase.__super__ = away3d_library_assets_NamedAssetBase;
away3d_materials_lightpickers_LightPickerBase.prototype = $extend(away3d_library_assets_NamedAssetBase.prototype,{
	_numPointLights: null
	,_numDirectionalLights: null
	,_numCastingPointLights: null
	,_numCastingDirectionalLights: null
	,_numLightProbes: null
	,_allPickedLights: null
	,_pointLights: null
	,_castingPointLights: null
	,_directionalLights: null
	,_castingDirectionalLights: null
	,_lightProbes: null
	,_lightProbeWeights: null
	,dispose: function() {
	}
	,get_assetType: function() {
		return "lightPicker";
	}
	,get_numDirectionalLights: function() {
		return this._numDirectionalLights;
	}
	,get_numPointLights: function() {
		return this._numPointLights;
	}
	,get_numCastingDirectionalLights: function() {
		return this._numCastingDirectionalLights;
	}
	,get_numCastingPointLights: function() {
		return this._numCastingPointLights;
	}
	,get_numLightProbes: function() {
		return this._numLightProbes;
	}
	,get_pointLights: function() {
		return this._pointLights;
	}
	,get_directionalLights: function() {
		return this._directionalLights;
	}
	,get_castingPointLights: function() {
		return this._castingPointLights;
	}
	,get_castingDirectionalLights: function() {
		return this._castingDirectionalLights;
	}
	,get_lightProbes: function() {
		return this._lightProbes;
	}
	,get_lightProbeWeights: function() {
		return this._lightProbeWeights;
	}
	,get_allPickedLights: function() {
		return this._allPickedLights;
	}
	,collectLights: function(renderable,entityCollector) {
		this.updateProbeWeights(renderable);
	}
	,updateProbeWeights: function(renderable) {
		var objectPos = renderable.get_sourceEntity().get_scenePosition();
		var lightPos;
		var rx = objectPos.x;
		var ry = objectPos.y;
		var rz = objectPos.z;
		var dx;
		var dy;
		var dz;
		var w;
		var total = 0;
		var _g = 0;
		var _g1 = this._numLightProbes;
		while(_g < _g1) {
			var i = _g++;
			lightPos = this._lightProbes.get(i).get_scenePosition();
			dx = rx - lightPos.x;
			dy = ry - lightPos.y;
			dz = rz - lightPos.z;
			w = dx * dx + dy * dy + dz * dz;
			w = w > .00001 ? 1 / w : 50000000;
			this._lightProbeWeights.set(i,w);
			total += w;
		}
		total = 1 / total;
		var _g2 = 0;
		var _g3 = this._numLightProbes;
		while(_g2 < _g3) {
			var i1 = _g2++;
			var _g21 = i1;
			var _g31 = this._lightProbeWeights;
			_g31.set(_g21,_g31.get(_g21) * total);
		}
	}
	,__class__: away3d_materials_lightpickers_LightPickerBase
	,__properties__: $extend(away3d_library_assets_NamedAssetBase.prototype.__properties__,{get_allPickedLights:"get_allPickedLights",get_lightProbeWeights:"get_lightProbeWeights",get_lightProbes:"get_lightProbes",get_castingDirectionalLights:"get_castingDirectionalLights",get_castingPointLights:"get_castingPointLights",get_directionalLights:"get_directionalLights",get_pointLights:"get_pointLights",get_numLightProbes:"get_numLightProbes",get_numCastingPointLights:"get_numCastingPointLights",get_numCastingDirectionalLights:"get_numCastingDirectionalLights",get_numPointLights:"get_numPointLights",get_numDirectionalLights:"get_numDirectionalLights",get_assetType:"get_assetType"})
});
var away3d_materials_methods_ShadingMethodBase = function() {
	away3d_library_assets_NamedAssetBase.call(this);
};
$hxClasses["away3d.materials.methods.ShadingMethodBase"] = away3d_materials_methods_ShadingMethodBase;
away3d_materials_methods_ShadingMethodBase.__name__ = "away3d.materials.methods.ShadingMethodBase";
away3d_materials_methods_ShadingMethodBase.__super__ = away3d_library_assets_NamedAssetBase;
away3d_materials_methods_ShadingMethodBase.prototype = $extend(away3d_library_assets_NamedAssetBase.prototype,{
	_sharedRegisters: null
	,_passes: null
	,initVO: function(vo) {
	}
	,initConstants: function(vo) {
	}
	,get_sharedRegisters: function() {
		return this._sharedRegisters;
	}
	,set_sharedRegisters: function(value) {
		this._sharedRegisters = value;
		return value;
	}
	,get_passes: function() {
		return this._passes;
	}
	,dispose: function() {
	}
	,createMethodVO: function() {
		return new away3d_materials_methods_MethodVO();
	}
	,reset: function() {
		this.cleanCompilationData();
	}
	,cleanCompilationData: function() {
	}
	,getVertexCode: function(vo,regCache) {
		return "";
	}
	,activate: function(vo,stage3DProxy) {
	}
	,setRenderState: function(vo,renderable,stage3DProxy,camera) {
	}
	,deactivate: function(vo,stage3DProxy) {
	}
	,getTex2DSampleCode: function(vo,targetReg,inputReg,texture,uvReg,forceWrap) {
		var wrap = vo.repeatTextures ? "wrap" : "clamp";
		if(forceWrap != null) {
			wrap = forceWrap;
		}
		var filter;
		var format = this.getFormatStringForTexture(texture);
		var enableMipMaps = vo.useMipmapping && texture.get_hasMipMaps();
		if(vo.useSmoothTextures) {
			filter = enableMipMaps ? "linear,miplinear" : "linear";
		} else {
			filter = enableMipMaps ? "nearest,mipnearest" : "nearest";
		}
		if(uvReg == null) {
			uvReg = this._sharedRegisters.uvVarying;
		}
		return "tex " + Std.string(targetReg) + ", " + Std.string(uvReg) + ", " + Std.string(inputReg) + " <2d," + filter + "," + format + wrap + ">\n";
	}
	,getTexCubeSampleCode: function(vo,targetReg,inputReg,texture,uvReg) {
		var filter;
		var format = this.getFormatStringForTexture(texture);
		var enableMipMaps = vo.useMipmapping && texture.get_hasMipMaps();
		if(vo.useSmoothTextures) {
			filter = enableMipMaps ? "linear,miplinear" : "linear";
		} else {
			filter = enableMipMaps ? "nearest,mipnearest" : "nearest";
		}
		return "tex " + Std.string(targetReg) + ", " + Std.string(uvReg) + ", " + Std.string(inputReg) + " <cube," + format + filter + ">\n";
	}
	,getFormatStringForTexture: function(texture) {
		switch(texture.get_format()) {
		case 3:
			return "dxt1,";
		case 4:
			return "dxt5,";
		default:
			return "";
		}
	}
	,invalidateShaderProgram: function() {
		this.dispatchEvent(new away3d_events_ShadingMethodEvent("ShaderInvalidated"));
	}
	,copyFrom: function(method) {
	}
	,getSmoothingFilter: function(smooth,anisotropy) {
		if(smooth) {
			switch(anisotropy) {
			case 0:
				return 4;
			case 1:
				return 1;
			case 2:
				return 2;
			case 3:
				return 3;
			case 4:
				return 0;
			}
		} else {
			return 5;
		}
	}
	,__class__: away3d_materials_methods_ShadingMethodBase
	,__properties__: $extend(away3d_library_assets_NamedAssetBase.prototype.__properties__,{get_passes:"get_passes",set_sharedRegisters:"set_sharedRegisters",get_sharedRegisters:"get_sharedRegisters"})
});
var away3d_materials_methods_BasicAmbientMethod = function() {
	this._lightAmbientB = 0;
	this._lightAmbientG = 0;
	this._lightAmbientR = 0;
	this._ambient = 1;
	this._ambientB = 0;
	this._ambientG = 0;
	this._ambientR = 0;
	this._ambientColor = 16777215;
	away3d_materials_methods_ShadingMethodBase.call(this);
};
$hxClasses["away3d.materials.methods.BasicAmbientMethod"] = away3d_materials_methods_BasicAmbientMethod;
away3d_materials_methods_BasicAmbientMethod.__name__ = "away3d.materials.methods.BasicAmbientMethod";
away3d_materials_methods_BasicAmbientMethod.__super__ = away3d_materials_methods_ShadingMethodBase;
away3d_materials_methods_BasicAmbientMethod.prototype = $extend(away3d_materials_methods_ShadingMethodBase.prototype,{
	_useTexture: null
	,_texture: null
	,_ambientInputRegister: null
	,_ambientColor: null
	,_ambientR: null
	,_ambientG: null
	,_ambientB: null
	,_ambient: null
	,_lightAmbientR: null
	,_lightAmbientG: null
	,_lightAmbientB: null
	,initVO: function(vo) {
		vo.needsUV = this._useTexture;
	}
	,initConstants: function(vo) {
		vo.fragmentData.set(vo.fragmentConstantsIndex + 3,1);
	}
	,get_ambient: function() {
		return this._ambient;
	}
	,set_ambient: function(value) {
		this._ambient = value;
		return value;
	}
	,get_ambientColor: function() {
		return this._ambientColor;
	}
	,set_ambientColor: function(value) {
		this._ambientColor = value;
		return value;
	}
	,get_texture: function() {
		return this._texture;
	}
	,set_texture: function(value) {
		if(value != null != this._useTexture || value != null && this._texture != null && (value.get_hasMipMaps() != this._texture.get_hasMipMaps() || value.get_format() != this._texture.get_format())) {
			this.invalidateShaderProgram();
		}
		this._useTexture = value != null;
		this._texture = value;
		return value;
	}
	,copyFrom: function(method) {
		var diff = js_Boot.__cast(method , away3d_materials_methods_BasicAmbientMethod);
		this.set_ambient(diff.get_ambient());
		this.set_ambientColor(diff.get_ambientColor());
	}
	,cleanCompilationData: function() {
		away3d_materials_methods_ShadingMethodBase.prototype.cleanCompilationData.call(this);
		this._ambientInputRegister = null;
	}
	,getFragmentCode: function(vo,regCache,targetReg) {
		var code = "";
		if(this._useTexture) {
			this._ambientInputRegister = regCache.getFreeTextureReg();
			vo.texturesIndex = this._ambientInputRegister.get_index();
			code += this.getTex2DSampleCode(vo,targetReg,this._ambientInputRegister,this._texture) + "div " + Std.string(targetReg) + ".xyz, " + Std.string(targetReg) + ".xyz, " + Std.string(targetReg) + ".w\n";
		} else {
			this._ambientInputRegister = regCache.getFreeFragmentConstant();
			vo.fragmentConstantsIndex = this._ambientInputRegister.get_index() * 4;
			code += "mov " + Std.string(targetReg) + ", " + Std.string(this._ambientInputRegister) + "\n";
		}
		return code;
	}
	,activate: function(vo,stage3DProxy) {
		if(this._useTexture) {
			stage3DProxy.get_context3D().setSamplerStateAt(vo.texturesIndex,vo.repeatTextures ? 2 : 0,this.getSmoothingFilter(vo.useSmoothTextures,vo.anisotropy),vo.useMipmapping ? 0 : 2);
			stage3DProxy._context3D.setTextureAt(vo.texturesIndex,this._texture.getTextureForStage3D(stage3DProxy));
		}
	}
	,updateAmbient: function() {
		this._ambientR = (this._ambientColor >> 16 & 255) / 255 * this._ambient * this._lightAmbientR;
		this._ambientG = (this._ambientColor >> 8 & 255) / 255 * this._ambient * this._lightAmbientG;
		this._ambientB = (this._ambientColor & 255) / 255 * this._ambient * this._lightAmbientB;
	}
	,setRenderState: function(vo,renderable,stage3DProxy,camera) {
		this.updateAmbient();
		if(!this._useTexture) {
			var index = vo.fragmentConstantsIndex;
			var data = vo.fragmentData;
			data.set(index,this._ambientR);
			data.set(index + 1,this._ambientG);
			data.set(index + 2,this._ambientB);
		}
	}
	,__class__: away3d_materials_methods_BasicAmbientMethod
	,__properties__: $extend(away3d_materials_methods_ShadingMethodBase.prototype.__properties__,{set_texture:"set_texture",get_texture:"get_texture",set_ambientColor:"set_ambientColor",get_ambientColor:"get_ambientColor",set_ambient:"set_ambient",get_ambient:"get_ambient"})
});
var away3d_materials_methods_LightingMethodBase = function() {
	away3d_materials_methods_ShadingMethodBase.call(this);
};
$hxClasses["away3d.materials.methods.LightingMethodBase"] = away3d_materials_methods_LightingMethodBase;
away3d_materials_methods_LightingMethodBase.__name__ = "away3d.materials.methods.LightingMethodBase";
away3d_materials_methods_LightingMethodBase.__super__ = away3d_materials_methods_ShadingMethodBase;
away3d_materials_methods_LightingMethodBase.prototype = $extend(away3d_materials_methods_ShadingMethodBase.prototype,{
	_modulateMethod: null
	,getFragmentPreLightingCode: function(vo,regCache) {
		return "";
	}
	,getFragmentCodePerLight: function(vo,lightDirReg,lightColReg,regCache) {
		return "";
	}
	,getFragmentCodePerProbe: function(vo,cubeMapReg,weightRegister,regCache) {
		return "";
	}
	,getFragmentPostLightingCode: function(vo,regCache,targetReg) {
		return "";
	}
	,__class__: away3d_materials_methods_LightingMethodBase
});
var away3d_materials_methods_BasicDiffuseMethod = function() {
	this._alphaThreshold = 0;
	this._diffuseA = 1;
	this._diffuseB = 1;
	this._diffuseG = 1;
	this._diffuseR = 1;
	this._diffuseColor = 16777215;
	away3d_materials_methods_LightingMethodBase.call(this);
};
$hxClasses["away3d.materials.methods.BasicDiffuseMethod"] = away3d_materials_methods_BasicDiffuseMethod;
away3d_materials_methods_BasicDiffuseMethod.__name__ = "away3d.materials.methods.BasicDiffuseMethod";
away3d_materials_methods_BasicDiffuseMethod.__super__ = away3d_materials_methods_LightingMethodBase;
away3d_materials_methods_BasicDiffuseMethod.prototype = $extend(away3d_materials_methods_LightingMethodBase.prototype,{
	_useAmbientTexture: null
	,_useTexture: null
	,_totalLightColorReg: null
	,_diffuseInputRegister: null
	,_texture: null
	,_diffuseColor: null
	,_diffuseR: null
	,_diffuseG: null
	,_diffuseB: null
	,_diffuseA: null
	,_shadowRegister: null
	,_alphaThreshold: null
	,_isFirstLight: null
	,get_useAmbientTexture: function() {
		return this._useAmbientTexture;
	}
	,set_useAmbientTexture: function(value) {
		if(this._useAmbientTexture == value) {
			return value;
		}
		this._useAmbientTexture = value;
		this.invalidateShaderProgram();
		return value;
	}
	,initVO: function(vo) {
		vo.needsUV = this._useTexture;
		vo.needsNormals = vo.numLights > 0;
	}
	,generateMip: function(stage3DProxy) {
		if(this._useTexture) {
			this._texture.getTextureForStage3D(stage3DProxy);
		}
	}
	,get_diffuseAlpha: function() {
		return this._diffuseA;
	}
	,set_diffuseAlpha: function(value) {
		this._diffuseA = value;
		return value;
	}
	,get_diffuseColor: function() {
		return this._diffuseColor;
	}
	,set_diffuseColor: function(diffuseColor) {
		this._diffuseColor = diffuseColor;
		this.updateDiffuse();
		return diffuseColor;
	}
	,get_texture: function() {
		return this._texture;
	}
	,set_texture: function(value) {
		if(value != null != this._useTexture || value != null && this._texture != null && (value.get_hasMipMaps() != this._texture.get_hasMipMaps() || value.get_format() != this._texture.get_format())) {
			this.invalidateShaderProgram();
		}
		this._useTexture = value != null;
		this._texture = value;
		return value;
	}
	,get_alphaThreshold: function() {
		return this._alphaThreshold;
	}
	,set_alphaThreshold: function(value) {
		if(value < 0) {
			value = 0;
		} else if(value > 1) {
			value = 1;
		}
		if(value == this._alphaThreshold) {
			return value;
		}
		if(value == 0 || this._alphaThreshold == 0) {
			this.invalidateShaderProgram();
		}
		this._alphaThreshold = value;
		return value;
	}
	,dispose: function() {
		this._texture = null;
	}
	,copyFrom: function(method) {
		var diff = js_Boot.__cast(method , away3d_materials_methods_BasicDiffuseMethod);
		this.set_alphaThreshold(diff.get_alphaThreshold());
		this.set_texture(diff.get_texture());
		this.set_useAmbientTexture(diff.get_useAmbientTexture());
		this.set_diffuseAlpha(diff.get_diffuseAlpha());
		this.set_diffuseColor(diff.get_diffuseColor());
	}
	,cleanCompilationData: function() {
		away3d_materials_methods_LightingMethodBase.prototype.cleanCompilationData.call(this);
		this._shadowRegister = null;
		this._totalLightColorReg = null;
		this._diffuseInputRegister = null;
	}
	,getFragmentPreLightingCode: function(vo,regCache) {
		var code = "";
		this._isFirstLight = true;
		if(vo.numLights > 0) {
			this._totalLightColorReg = regCache.getFreeFragmentVectorTemp();
			regCache.addFragmentTempUsages(this._totalLightColorReg,1);
		}
		return code;
	}
	,getFragmentCodePerLight: function(vo,lightDirReg,lightColReg,regCache) {
		var code = "";
		var t;
		if(this._isFirstLight) {
			t = this._totalLightColorReg;
		} else {
			t = regCache.getFreeFragmentVectorTemp();
			regCache.addFragmentTempUsages(t,1);
		}
		code += "dp3 " + Std.string(t) + ".x, " + Std.string(lightDirReg) + ", " + Std.string(this._sharedRegisters.normalFragment) + "\n" + "max " + Std.string(t) + ".w, " + Std.string(t) + ".x, " + Std.string(this._sharedRegisters.commons) + ".y\n";
		if(vo.useLightFallOff) {
			code += "mul " + Std.string(t) + ".w, " + Std.string(t) + ".w, " + Std.string(lightDirReg) + ".w\n";
		}
		if(this._modulateMethod != null) {
			code += Std.string(this._modulateMethod(vo,t,regCache,this._sharedRegisters));
		}
		code += "mul " + Std.string(t) + ", " + Std.string(t) + ".w, " + Std.string(lightColReg) + "\n";
		if(!this._isFirstLight) {
			code += "add " + Std.string(this._totalLightColorReg) + ".xyz, " + Std.string(this._totalLightColorReg) + ", " + Std.string(t) + "\n";
			regCache.removeFragmentTempUsage(t);
		}
		this._isFirstLight = false;
		return code;
	}
	,getFragmentCodePerProbe: function(vo,cubeMapReg,weightRegister,regCache) {
		var code = "";
		var t;
		if(this._isFirstLight) {
			t = this._totalLightColorReg;
		} else {
			t = regCache.getFreeFragmentVectorTemp();
			regCache.addFragmentTempUsages(t,1);
		}
		code += "tex " + Std.string(t) + ", " + Std.string(this._sharedRegisters.normalFragment) + ", " + Std.string(cubeMapReg) + " <cube,linear,miplinear>\n" + "mul " + Std.string(t) + ".xyz, " + Std.string(t) + ".xyz, " + weightRegister + "\n";
		if(this._modulateMethod != null) {
			code += Std.string(this._modulateMethod(vo,t,regCache,this._sharedRegisters));
		}
		if(!this._isFirstLight) {
			code += "add " + Std.string(this._totalLightColorReg) + ".xyz, " + Std.string(this._totalLightColorReg) + ", " + Std.string(t) + "\n";
			regCache.removeFragmentTempUsage(t);
		}
		this._isFirstLight = false;
		return code;
	}
	,getFragmentPostLightingCode: function(vo,regCache,targetReg) {
		var code = "";
		var albedo;
		var cutOffReg;
		if(vo.numLights > 0) {
			if(this._shadowRegister != null) {
				code += this.applyShadow(vo,regCache);
			}
			albedo = regCache.getFreeFragmentVectorTemp();
			regCache.addFragmentTempUsages(albedo,1);
		} else {
			albedo = targetReg;
		}
		if(this._useTexture) {
			this._diffuseInputRegister = regCache.getFreeTextureReg();
			vo.texturesIndex = this._diffuseInputRegister.get_index();
			code += this.getTex2DSampleCode(vo,albedo,this._diffuseInputRegister,this._texture);
			if(this._alphaThreshold > 0) {
				cutOffReg = regCache.getFreeFragmentConstant();
				vo.fragmentConstantsIndex = cutOffReg.get_index() * 4;
				code += "sub " + Std.string(albedo) + ".w, " + Std.string(albedo) + ".w, " + Std.string(cutOffReg) + ".x\n" + "kil " + Std.string(albedo) + ".w\n" + "add " + Std.string(albedo) + ".w, " + Std.string(albedo) + ".w, " + Std.string(cutOffReg) + ".x\n";
			}
		} else {
			this._diffuseInputRegister = regCache.getFreeFragmentConstant();
			vo.fragmentConstantsIndex = this._diffuseInputRegister.get_index() * 4;
			code += "mov " + Std.string(albedo) + ", " + Std.string(this._diffuseInputRegister) + "\n";
		}
		if(vo.numLights == 0) {
			return code;
		}
		code += "sat " + Std.string(this._totalLightColorReg) + ", " + Std.string(this._totalLightColorReg) + "\n";
		if(this._useAmbientTexture) {
			code += "mul " + Std.string(albedo) + ".xyz, " + Std.string(albedo) + ", " + Std.string(this._totalLightColorReg) + "\n" + "mul " + Std.string(this._totalLightColorReg) + ".xyz, " + Std.string(targetReg) + ", " + Std.string(this._totalLightColorReg) + "\n" + "sub " + Std.string(targetReg) + ".xyz, " + Std.string(targetReg) + ", " + Std.string(this._totalLightColorReg) + "\n" + "add " + Std.string(targetReg) + ".xyz, " + Std.string(albedo) + ", " + Std.string(targetReg) + "\n";
		} else {
			code += "add " + Std.string(targetReg) + ".xyz, " + Std.string(this._totalLightColorReg) + ", " + Std.string(targetReg) + "\n";
			if(this._useTexture) {
				code += "mul " + Std.string(targetReg) + ".xyz, " + Std.string(albedo) + ", " + Std.string(targetReg) + "\n" + "mov " + Std.string(targetReg) + ".w, " + Std.string(albedo) + ".w\n";
			} else {
				code += "mul " + Std.string(targetReg) + ".xyz, " + Std.string(this._diffuseInputRegister) + ", " + Std.string(targetReg) + "\n" + "mov " + Std.string(targetReg) + ".w, " + Std.string(this._diffuseInputRegister) + ".w\n";
			}
		}
		regCache.removeFragmentTempUsage(this._totalLightColorReg);
		regCache.removeFragmentTempUsage(albedo);
		return code;
	}
	,applyShadow: function(vo,regCache) {
		return "mul " + Std.string(this._totalLightColorReg) + ".xyz, " + Std.string(this._totalLightColorReg) + ", " + Std.string(this._shadowRegister) + ".w\n";
	}
	,activate: function(vo,stage3DProxy) {
		if(this._useTexture) {
			stage3DProxy._context3D.setSamplerStateAt(vo.texturesIndex,vo.repeatTextures ? 2 : 0,this.getSmoothingFilter(vo.useSmoothTextures,vo.anisotropy),vo.useMipmapping ? 0 : 2);
			stage3DProxy._context3D.setTextureAt(vo.texturesIndex,this._texture.getTextureForStage3D(stage3DProxy));
			if(this._alphaThreshold > 0) {
				vo.fragmentData.set(vo.fragmentConstantsIndex,this._alphaThreshold);
			}
		} else {
			var index = vo.fragmentConstantsIndex;
			var data = vo.fragmentData;
			data.set(index,this._diffuseR);
			data.set(index + 1,this._diffuseG);
			data.set(index + 2,this._diffuseB);
			data.set(index + 3,this._diffuseA);
		}
	}
	,updateDiffuse: function() {
		this._diffuseR = (this._diffuseColor >> 16 & 255) / 255;
		this._diffuseG = (this._diffuseColor >> 8 & 255) / 255;
		this._diffuseB = (this._diffuseColor & 255) / 255;
	}
	,set_shadowRegister: function(value) {
		this._shadowRegister = value;
		return value;
	}
	,__class__: away3d_materials_methods_BasicDiffuseMethod
	,__properties__: $extend(away3d_materials_methods_LightingMethodBase.prototype.__properties__,{set_shadowRegister:"set_shadowRegister",set_alphaThreshold:"set_alphaThreshold",get_alphaThreshold:"get_alphaThreshold",set_texture:"set_texture",get_texture:"get_texture",set_diffuseColor:"set_diffuseColor",get_diffuseColor:"get_diffuseColor",set_diffuseAlpha:"set_diffuseAlpha",get_diffuseAlpha:"get_diffuseAlpha",set_useAmbientTexture:"set_useAmbientTexture",get_useAmbientTexture:"get_useAmbientTexture"})
});
var away3d_materials_methods_BasicNormalMethod = function() {
	away3d_materials_methods_ShadingMethodBase.call(this);
};
$hxClasses["away3d.materials.methods.BasicNormalMethod"] = away3d_materials_methods_BasicNormalMethod;
away3d_materials_methods_BasicNormalMethod.__name__ = "away3d.materials.methods.BasicNormalMethod";
away3d_materials_methods_BasicNormalMethod.__super__ = away3d_materials_methods_ShadingMethodBase;
away3d_materials_methods_BasicNormalMethod.prototype = $extend(away3d_materials_methods_ShadingMethodBase.prototype,{
	_texture: null
	,_useTexture: null
	,_normalTextureRegister: null
	,initVO: function(vo) {
		vo.needsUV = this._texture != null;
	}
	,get_tangentSpace: function() {
		return true;
	}
	,get_hasOutput: function() {
		return this._useTexture;
	}
	,copyFrom: function(method) {
		this.set_normalMap((js_Boot.__cast(method , away3d_materials_methods_BasicNormalMethod)).get_normalMap());
	}
	,get_normalMap: function() {
		return this._texture;
	}
	,set_normalMap: function(value) {
		if(value != null != this._useTexture || value != null && this._texture != null && (value.get_hasMipMaps() != this._texture.get_hasMipMaps() || value.get_format() != this._texture.get_format())) {
			this.invalidateShaderProgram();
		}
		this._useTexture = value != null;
		this._texture = value;
		return value;
	}
	,cleanCompilationData: function() {
		away3d_materials_methods_ShadingMethodBase.prototype.cleanCompilationData.call(this);
		this._normalTextureRegister = null;
	}
	,dispose: function() {
		if(this._texture != null) {
			this._texture = null;
		}
	}
	,activate: function(vo,stage3DProxy) {
		if(vo.texturesIndex >= 0) {
			stage3DProxy._context3D.setSamplerStateAt(vo.texturesIndex,vo.repeatTextures ? 2 : 0,this.getSmoothingFilter(vo.useSmoothTextures,vo.anisotropy),vo.useMipmapping ? 0 : 2);
			stage3DProxy._context3D.setTextureAt(vo.texturesIndex,this._texture.getTextureForStage3D(stage3DProxy));
		}
	}
	,getFragmentCode: function(vo,regCache,targetReg) {
		this._normalTextureRegister = regCache.getFreeTextureReg();
		vo.texturesIndex = this._normalTextureRegister.get_index();
		return this.getTex2DSampleCode(vo,targetReg,this._normalTextureRegister,this._texture) + "sub " + Std.string(targetReg) + ".xyz, " + Std.string(targetReg) + ".xyz, " + Std.string(this._sharedRegisters.commons) + ".xxx\t\n" + "nrm " + Std.string(targetReg) + ".xyz, " + Std.string(targetReg) + ".xyz\t\t\t\t\t\t\t\n";
	}
	,__class__: away3d_materials_methods_BasicNormalMethod
	,__properties__: $extend(away3d_materials_methods_ShadingMethodBase.prototype.__properties__,{set_normalMap:"set_normalMap",get_normalMap:"get_normalMap",get_hasOutput:"get_hasOutput",get_tangentSpace:"get_tangentSpace"})
});
var away3d_materials_methods_BasicSpecularMethod = function() {
	this._specularB = 1;
	this._specularG = 1;
	this._specularR = 1;
	this._specularColor = 16777215;
	this._specular = 1;
	this._gloss = 50;
	away3d_materials_methods_LightingMethodBase.call(this);
};
$hxClasses["away3d.materials.methods.BasicSpecularMethod"] = away3d_materials_methods_BasicSpecularMethod;
away3d_materials_methods_BasicSpecularMethod.__name__ = "away3d.materials.methods.BasicSpecularMethod";
away3d_materials_methods_BasicSpecularMethod.__super__ = away3d_materials_methods_LightingMethodBase;
away3d_materials_methods_BasicSpecularMethod.prototype = $extend(away3d_materials_methods_LightingMethodBase.prototype,{
	_useTexture: null
	,_totalLightColorReg: null
	,_specularTextureRegister: null
	,_specularTexData: null
	,_specularDataRegister: null
	,_texture: null
	,_gloss: null
	,_specular: null
	,_specularColor: null
	,_specularR: null
	,_specularG: null
	,_specularB: null
	,_shadowRegister: null
	,_isFirstLight: null
	,initVO: function(vo) {
		vo.needsUV = this._useTexture;
		vo.needsNormals = vo.numLights > 0;
		vo.needsView = vo.numLights > 0;
	}
	,get_gloss: function() {
		return this._gloss;
	}
	,set_gloss: function(value) {
		this._gloss = value;
		return value;
	}
	,get_specular: function() {
		return this._specular;
	}
	,set_specular: function(value) {
		if(value == this._specular) {
			return value;
		}
		this._specular = value;
		this.updateSpecular();
		return value;
	}
	,get_specularColor: function() {
		return this._specularColor;
	}
	,set_specularColor: function(value) {
		if(this._specularColor == value) {
			return value;
		}
		if(this._specularColor == 0 || value == 0) {
			this.invalidateShaderProgram();
		}
		this._specularColor = value;
		this.updateSpecular();
		return value;
	}
	,get_texture: function() {
		return this._texture;
	}
	,set_texture: function(value) {
		if(value != null != this._useTexture || value != null && this._texture != null && (value.get_hasMipMaps() != this._texture.get_hasMipMaps() || value.get_format() != this._texture.get_format())) {
			this.invalidateShaderProgram();
		}
		this._useTexture = value != null;
		this._texture = value;
		return value;
	}
	,copyFrom: function(method) {
		var spec = js_Boot.__cast(method , away3d_materials_methods_BasicSpecularMethod);
		this.set_texture(spec.get_texture());
		this.set_specular(spec.get_specular());
		this.set_specularColor(spec.get_specularColor());
		this.set_gloss(spec.get_gloss());
	}
	,cleanCompilationData: function() {
		away3d_materials_methods_LightingMethodBase.prototype.cleanCompilationData.call(this);
		this._shadowRegister = null;
		this._totalLightColorReg = null;
		this._specularTextureRegister = null;
		this._specularTexData = null;
		this._specularDataRegister = null;
	}
	,getFragmentPreLightingCode: function(vo,regCache) {
		var code = "";
		this._isFirstLight = true;
		if(vo.numLights > 0) {
			this._specularDataRegister = regCache.getFreeFragmentConstant();
			vo.fragmentConstantsIndex = this._specularDataRegister.get_index() * 4;
			if(this._useTexture) {
				this._specularTexData = regCache.getFreeFragmentVectorTemp();
				regCache.addFragmentTempUsages(this._specularTexData,1);
				this._specularTextureRegister = regCache.getFreeTextureReg();
				vo.texturesIndex = this._specularTextureRegister.get_index();
				code = this.getTex2DSampleCode(vo,this._specularTexData,this._specularTextureRegister,this._texture);
			} else {
				this._specularTextureRegister = null;
			}
			this._totalLightColorReg = regCache.getFreeFragmentVectorTemp();
			regCache.addFragmentTempUsages(this._totalLightColorReg,1);
		}
		return code;
	}
	,getFragmentCodePerLight: function(vo,lightDirReg,lightColReg,regCache) {
		var code = "";
		var t;
		if(this._isFirstLight) {
			t = this._totalLightColorReg;
		} else {
			t = regCache.getFreeFragmentVectorTemp();
			regCache.addFragmentTempUsages(t,1);
		}
		var viewDirReg = this._sharedRegisters.viewDirFragment;
		var normalReg = this._sharedRegisters.normalFragment;
		code += "add " + Std.string(t) + ", " + Std.string(lightDirReg) + ", " + Std.string(viewDirReg) + "\n" + "nrm " + Std.string(t) + ".xyz, " + Std.string(t) + "\n" + "dp3 " + Std.string(t) + ".w, " + Std.string(normalReg) + ", " + Std.string(t) + "\n" + "sat " + Std.string(t) + ".w, " + Std.string(t) + ".w\n";
		if(this._useTexture) {
			code += "mul " + Std.string(this._specularTexData) + ".w, " + Std.string(this._specularTexData) + ".y, " + Std.string(this._specularDataRegister) + ".w\n" + "pow " + Std.string(t) + ".w, " + Std.string(t) + ".w, " + Std.string(this._specularTexData) + ".w\n";
		} else {
			code += "pow " + Std.string(t) + ".w, " + Std.string(t) + ".w, " + Std.string(this._specularDataRegister) + ".w\n";
		}
		if(vo.useLightFallOff) {
			code += "mul " + Std.string(t) + ".w, " + Std.string(t) + ".w, " + Std.string(lightDirReg) + ".w\n";
		}
		if(this._modulateMethod != null) {
			code += Std.string(this._modulateMethod(vo,t,regCache,this._sharedRegisters));
		}
		code += "mul " + Std.string(t) + ".xyz, " + Std.string(lightColReg) + ", " + Std.string(t) + ".w\n";
		if(!this._isFirstLight) {
			code += "add " + Std.string(this._totalLightColorReg) + ".xyz, " + Std.string(this._totalLightColorReg) + ", " + Std.string(t) + "\n";
			regCache.removeFragmentTempUsage(t);
		}
		this._isFirstLight = false;
		return code;
	}
	,getFragmentCodePerProbe: function(vo,cubeMapReg,weightRegister,regCache) {
		var code = "";
		var t;
		if(this._isFirstLight) {
			t = this._totalLightColorReg;
		} else {
			t = regCache.getFreeFragmentVectorTemp();
			regCache.addFragmentTempUsages(t,1);
		}
		var normalReg = this._sharedRegisters.normalFragment;
		var viewDirReg = this._sharedRegisters.viewDirFragment;
		code += "dp3 " + Std.string(t) + ".w, " + Std.string(normalReg) + ", " + Std.string(viewDirReg) + "\n" + "add " + Std.string(t) + ".w, " + Std.string(t) + ".w, " + Std.string(t) + ".w\n" + "mul " + Std.string(t) + ", " + Std.string(t) + ".w, " + Std.string(normalReg) + "\n" + "sub " + Std.string(t) + ", " + Std.string(t) + ", " + Std.string(viewDirReg) + "\n" + "tex " + Std.string(t) + ", " + Std.string(t) + ", " + Std.string(cubeMapReg) + " <cube," + (vo.useSmoothTextures ? "linear" : "nearest") + ",miplinear>\n" + "mul " + Std.string(t) + ".xyz, " + Std.string(t) + ", " + weightRegister + "\n";
		if(this._modulateMethod != null) {
			code += Std.string(this._modulateMethod(vo,t,regCache,this._sharedRegisters));
		}
		if(!this._isFirstLight) {
			code += "add " + Std.string(this._totalLightColorReg) + ".xyz, " + Std.string(this._totalLightColorReg) + ", " + Std.string(t) + "\n";
			regCache.removeFragmentTempUsage(t);
		}
		this._isFirstLight = false;
		return code;
	}
	,getFragmentPostLightingCode: function(vo,regCache,targetReg) {
		var code = "";
		if(vo.numLights == 0) {
			return code;
		}
		if(this._shadowRegister != null) {
			code += "mul " + Std.string(this._totalLightColorReg) + ".xyz, " + Std.string(this._totalLightColorReg) + ", " + Std.string(this._shadowRegister) + ".w\n";
		}
		if(this._useTexture) {
			code += "mul " + Std.string(this._totalLightColorReg) + ".xyz, " + Std.string(this._totalLightColorReg) + ", " + Std.string(this._specularTexData) + ".x\n";
			regCache.removeFragmentTempUsage(this._specularTexData);
		}
		code += "mul " + Std.string(this._totalLightColorReg) + ".xyz, " + Std.string(this._totalLightColorReg) + ", " + Std.string(this._specularDataRegister) + "\n" + "add " + Std.string(targetReg) + ".xyz, " + Std.string(targetReg) + ", " + Std.string(this._totalLightColorReg) + "\n";
		regCache.removeFragmentTempUsage(this._totalLightColorReg);
		return code;
	}
	,activate: function(vo,stage3DProxy) {
		if(vo.numLights == 0) {
			return;
		}
		if(this._useTexture) {
			stage3DProxy._context3D.setSamplerStateAt(vo.texturesIndex,vo.repeatTextures ? 2 : 0,this.getSmoothingFilter(vo.useSmoothTextures,vo.anisotropy),vo.useMipmapping ? 0 : 2);
			stage3DProxy._context3D.setTextureAt(vo.texturesIndex,this._texture.getTextureForStage3D(stage3DProxy));
		}
		var index = vo.fragmentConstantsIndex;
		var data = vo.fragmentData;
		data.set(index,this._specularR);
		data.set(index + 1,this._specularG);
		data.set(index + 2,this._specularB);
		data.set(index + 3,this._gloss);
	}
	,updateSpecular: function() {
		this._specularR = _$UInt_UInt_$Impl_$.toFloat(this._specularColor >>> 16 & 255) / _$UInt_UInt_$Impl_$.toFloat(255) * this._specular;
		this._specularG = _$UInt_UInt_$Impl_$.toFloat(this._specularColor >>> 8 & 255) / _$UInt_UInt_$Impl_$.toFloat(255) * this._specular;
		this._specularB = _$UInt_UInt_$Impl_$.toFloat(this._specularColor & 255) / _$UInt_UInt_$Impl_$.toFloat(255) * this._specular;
	}
	,set_shadowRegister: function(shadowReg) {
		this._shadowRegister = shadowReg;
		return shadowReg;
	}
	,__class__: away3d_materials_methods_BasicSpecularMethod
	,__properties__: $extend(away3d_materials_methods_LightingMethodBase.prototype.__properties__,{set_shadowRegister:"set_shadowRegister",set_texture:"set_texture",get_texture:"get_texture",set_specularColor:"set_specularColor",get_specularColor:"get_specularColor",set_specular:"set_specular",get_specular:"get_specular",set_gloss:"set_gloss",get_gloss:"get_gloss"})
});
var away3d_materials_methods_EffectMethodBase = function() {
	away3d_materials_methods_ShadingMethodBase.call(this);
};
$hxClasses["away3d.materials.methods.EffectMethodBase"] = away3d_materials_methods_EffectMethodBase;
away3d_materials_methods_EffectMethodBase.__name__ = "away3d.materials.methods.EffectMethodBase";
away3d_materials_methods_EffectMethodBase.__interfaces__ = [away3d_library_assets_IAsset];
away3d_materials_methods_EffectMethodBase.__super__ = away3d_materials_methods_ShadingMethodBase;
away3d_materials_methods_EffectMethodBase.prototype = $extend(away3d_materials_methods_ShadingMethodBase.prototype,{
	get_assetType: function() {
		return "effectsMethod";
	}
	,getFragmentCode: function(vo,regCache,targetReg) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,__class__: away3d_materials_methods_EffectMethodBase
	,__properties__: $extend(away3d_materials_methods_ShadingMethodBase.prototype.__properties__,{get_assetType:"get_assetType"})
});
var away3d_materials_methods_ColorTransformMethod = function() {
	away3d_materials_methods_EffectMethodBase.call(this);
};
$hxClasses["away3d.materials.methods.ColorTransformMethod"] = away3d_materials_methods_ColorTransformMethod;
away3d_materials_methods_ColorTransformMethod.__name__ = "away3d.materials.methods.ColorTransformMethod";
away3d_materials_methods_ColorTransformMethod.__super__ = away3d_materials_methods_EffectMethodBase;
away3d_materials_methods_ColorTransformMethod.prototype = $extend(away3d_materials_methods_EffectMethodBase.prototype,{
	_colorTransform: null
	,get_colorTransform: function() {
		return this._colorTransform;
	}
	,set_colorTransform: function(value) {
		this._colorTransform = value;
		return value;
	}
	,getFragmentCode: function(vo,regCache,targetReg) {
		var code = "";
		var colorMultReg = regCache.getFreeFragmentConstant();
		var colorOffsReg = regCache.getFreeFragmentConstant();
		vo.fragmentConstantsIndex = colorMultReg.get_index() * 4;
		code += "mul " + Std.string(targetReg) + ", " + targetReg.toString() + ", " + Std.string(colorMultReg) + "\n" + "add " + Std.string(targetReg) + ", " + targetReg.toString() + ", " + Std.string(colorOffsReg) + "\n";
		return code;
	}
	,activate: function(vo,stage3DProxy) {
		var inv = 0.00392156862745098;
		var index = vo.fragmentConstantsIndex;
		var data = vo.fragmentData;
		data.set(index,this._colorTransform.redMultiplier);
		data.set(index + 1,this._colorTransform.greenMultiplier);
		data.set(index + 2,this._colorTransform.blueMultiplier);
		data.set(index + 3,this._colorTransform.alphaMultiplier);
		data.set(index + 4,this._colorTransform.redOffset * inv);
		data.set(index + 5,this._colorTransform.greenOffset * inv);
		data.set(index + 6,this._colorTransform.blueOffset * inv);
		data.set(index + 7,this._colorTransform.alphaOffset * inv);
	}
	,__class__: away3d_materials_methods_ColorTransformMethod
	,__properties__: $extend(away3d_materials_methods_EffectMethodBase.prototype.__properties__,{set_colorTransform:"set_colorTransform",get_colorTransform:"get_colorTransform"})
});
var away3d_materials_methods_MethodVO = function() {
	this.useLightFallOff = true;
};
$hxClasses["away3d.materials.methods.MethodVO"] = away3d_materials_methods_MethodVO;
away3d_materials_methods_MethodVO.__name__ = "away3d.materials.methods.MethodVO";
away3d_materials_methods_MethodVO.prototype = {
	vertexData: null
	,fragmentData: null
	,texturesIndex: null
	,secondaryTexturesIndex: null
	,vertexConstantsIndex: null
	,secondaryVertexConstantsIndex: null
	,fragmentConstantsIndex: null
	,secondaryFragmentConstantsIndex: null
	,useMipmapping: null
	,useSmoothTextures: null
	,repeatTextures: null
	,anisotropy: null
	,needsProjection: null
	,needsView: null
	,needsNormals: null
	,needsTangents: null
	,needsUV: null
	,needsSecondaryUV: null
	,needsGlobalVertexPos: null
	,needsGlobalFragmentPos: null
	,numLights: null
	,useLightFallOff: null
	,reset: function() {
		this.texturesIndex = -1;
		this.vertexConstantsIndex = -1;
		this.fragmentConstantsIndex = -1;
		this.useMipmapping = true;
		this.anisotropy = 1;
		this.useSmoothTextures = true;
		this.repeatTextures = false;
		this.needsProjection = false;
		this.needsView = false;
		this.needsNormals = false;
		this.needsTangents = false;
		this.needsUV = false;
		this.needsSecondaryUV = false;
		this.needsGlobalVertexPos = false;
		this.needsGlobalFragmentPos = false;
		this.numLights = 0;
		this.useLightFallOff = true;
	}
	,__class__: away3d_materials_methods_MethodVO
};
var away3d_materials_methods_MethodVOSet = function(method) {
	this.method = method;
	this.data = method.createMethodVO();
};
$hxClasses["away3d.materials.methods.MethodVOSet"] = away3d_materials_methods_MethodVOSet;
away3d_materials_methods_MethodVOSet.__name__ = "away3d.materials.methods.MethodVOSet";
away3d_materials_methods_MethodVOSet.prototype = {
	method: null
	,data: null
	,__class__: away3d_materials_methods_MethodVOSet
};
var away3d_materials_methods_ShaderMethodSetup = function() {
	this._methods = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	this._normalMethod = new away3d_materials_methods_BasicNormalMethod();
	this._ambientMethod = new away3d_materials_methods_BasicAmbientMethod();
	this._diffuseMethod = new away3d_materials_methods_BasicDiffuseMethod();
	this._specularMethod = new away3d_materials_methods_BasicSpecularMethod();
	this._normalMethod.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
	this._diffuseMethod.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
	this._specularMethod.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
	this._ambientMethod.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
	this._normalMethodVO = this._normalMethod.createMethodVO();
	this._ambientMethodVO = this._ambientMethod.createMethodVO();
	this._diffuseMethodVO = this._diffuseMethod.createMethodVO();
	this._specularMethodVO = this._specularMethod.createMethodVO();
	openfl_events_EventDispatcher.call(this);
};
$hxClasses["away3d.materials.methods.ShaderMethodSetup"] = away3d_materials_methods_ShaderMethodSetup;
away3d_materials_methods_ShaderMethodSetup.__name__ = "away3d.materials.methods.ShaderMethodSetup";
away3d_materials_methods_ShaderMethodSetup.__super__ = openfl_events_EventDispatcher;
away3d_materials_methods_ShaderMethodSetup.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	_colorTransformMethod: null
	,_colorTransformMethodVO: null
	,_normalMethod: null
	,_normalMethodVO: null
	,_ambientMethod: null
	,_ambientMethodVO: null
	,_shadowMethod: null
	,_shadowMethodVO: null
	,_diffuseMethod: null
	,_diffuseMethodVO: null
	,_specularMethod: null
	,_specularMethodVO: null
	,_methods: null
	,onShaderInvalidated: function(event) {
		this.invalidateShaderProgram();
	}
	,invalidateShaderProgram: function() {
		this.dispatchEvent(new away3d_events_ShadingMethodEvent("ShaderInvalidated"));
	}
	,get_normalMethod: function() {
		return this._normalMethod;
	}
	,set_normalMethod: function(value) {
		if(this._normalMethod != null) {
			this._normalMethod.removeEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
		}
		if(value != null) {
			if(this._normalMethod != null) {
				value.copyFrom(this._normalMethod);
			}
			this._normalMethodVO = value.createMethodVO();
			value.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
		}
		this._normalMethod = value;
		if(value != null) {
			this.invalidateShaderProgram();
		}
		return value;
	}
	,get_ambientMethod: function() {
		return this._ambientMethod;
	}
	,set_ambientMethod: function(value) {
		if(this._ambientMethod != null) {
			this._ambientMethod.removeEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
		}
		if(value != null) {
			if(this._ambientMethod != null) {
				value.copyFrom(this._ambientMethod);
			}
			value.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
			this._ambientMethodVO = value.createMethodVO();
		}
		this._ambientMethod = value;
		if(value != null) {
			this.invalidateShaderProgram();
		}
		return value;
	}
	,get_shadowMethod: function() {
		return this._shadowMethod;
	}
	,set_shadowMethod: function(value) {
		if(this._shadowMethod != null) {
			this._shadowMethod.removeEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
		}
		this._shadowMethod = value;
		if(this._shadowMethod != null) {
			this._shadowMethod.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
			this._shadowMethodVO = this._shadowMethod.createMethodVO();
		} else {
			this._shadowMethodVO = null;
		}
		this.invalidateShaderProgram();
		return value;
	}
	,get_diffuseMethod: function() {
		return this._diffuseMethod;
	}
	,set_diffuseMethod: function(value) {
		if(this._diffuseMethod != null) {
			this._diffuseMethod.removeEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
		}
		if(value != null) {
			if(this._diffuseMethod != null) {
				value.copyFrom(this._diffuseMethod);
			}
			value.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
			this._diffuseMethodVO = value.createMethodVO();
		}
		this._diffuseMethod = value;
		if(value != null) {
			this.invalidateShaderProgram();
		}
		return value;
	}
	,get_specularMethod: function() {
		return this._specularMethod;
	}
	,set_specularMethod: function(value) {
		if(this._specularMethod != null) {
			this._specularMethod.removeEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
			if(value != null) {
				value.copyFrom(this._specularMethod);
			}
		}
		this._specularMethod = value;
		if(this._specularMethod != null) {
			this._specularMethod.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
			this._specularMethodVO = this._specularMethod.createMethodVO();
		} else {
			this._specularMethodVO = null;
		}
		this.invalidateShaderProgram();
		return value;
	}
	,get_colorTransformMethod: function() {
		return this._colorTransformMethod;
	}
	,set_colorTransformMethod: function(value) {
		if(this._colorTransformMethod == value) {
			return value;
		}
		if(this._colorTransformMethod != null) {
			this._colorTransformMethod.removeEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
		}
		if(this._colorTransformMethod == null || value == null) {
			this.invalidateShaderProgram();
		}
		this._colorTransformMethod = value;
		if(this._colorTransformMethod != null) {
			this._colorTransformMethod.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
			this._colorTransformMethodVO = this._colorTransformMethod.createMethodVO();
		} else {
			this._colorTransformMethodVO = null;
		}
		return value;
	}
	,dispose: function() {
		this.clearListeners(this._normalMethod);
		this.clearListeners(this._diffuseMethod);
		this.clearListeners(this._shadowMethod);
		this.clearListeners(this._ambientMethod);
		this.clearListeners(this._specularMethod);
		var _g = 0;
		var _g1 = this._methods.get_length();
		while(_g < _g1) {
			var i = _g++;
			this.clearListeners(this._methods.get(i).method);
		}
		this._methods = null;
	}
	,clearListeners: function(method) {
		if(method != null) {
			method.removeEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
		}
	}
	,addMethod: function(method) {
		this._methods.push(new away3d_materials_methods_MethodVOSet(method));
		method.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
		this.invalidateShaderProgram();
	}
	,hasMethod: function(method) {
		return this.getMethodSetForMethod(method) != null;
	}
	,addMethodAt: function(method,index) {
		this._methods.insertAt(index,new away3d_materials_methods_MethodVOSet(method));
		method.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
		this.invalidateShaderProgram();
	}
	,getMethodAt: function(index) {
		if(index > this._methods.get_length() - 1) {
			return null;
		}
		return this._methods.get(index).method;
	}
	,get_numMethods: function() {
		return this._methods.get_length();
	}
	,removeMethod: function(method) {
		var methodSet = this.getMethodSetForMethod(method);
		if(methodSet != null) {
			var index = this._methods.indexOf(methodSet,0);
			this._methods.splice(index,1);
			method.removeEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
			this.invalidateShaderProgram();
		}
	}
	,getMethodSetForMethod: function(method) {
		var len = this._methods.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			if(this._methods.get(i).method == method) {
				return this._methods.get(i);
			}
		}
		return null;
	}
	,__class__: away3d_materials_methods_ShaderMethodSetup
	,__properties__: {get_numMethods:"get_numMethods",set_colorTransformMethod:"set_colorTransformMethod",get_colorTransformMethod:"get_colorTransformMethod",set_specularMethod:"set_specularMethod",get_specularMethod:"get_specularMethod",set_diffuseMethod:"set_diffuseMethod",get_diffuseMethod:"get_diffuseMethod",set_shadowMethod:"set_shadowMethod",get_shadowMethod:"get_shadowMethod",set_ambientMethod:"set_ambientMethod",get_ambientMethod:"get_ambientMethod",set_normalMethod:"set_normalMethod",get_normalMethod:"get_normalMethod"}
});
var away3d_materials_methods_ShadowMapMethodBase = function(castingLight) {
	this._alpha = 1;
	this._epsilon = .02;
	away3d_materials_methods_ShadingMethodBase.call(this);
	this._castingLight = castingLight;
	castingLight.set_castsShadows(true);
	this._shadowMapper = castingLight.get_shadowMapper();
};
$hxClasses["away3d.materials.methods.ShadowMapMethodBase"] = away3d_materials_methods_ShadowMapMethodBase;
away3d_materials_methods_ShadowMapMethodBase.__name__ = "away3d.materials.methods.ShadowMapMethodBase";
away3d_materials_methods_ShadowMapMethodBase.__interfaces__ = [away3d_library_assets_IAsset];
away3d_materials_methods_ShadowMapMethodBase.__super__ = away3d_materials_methods_ShadingMethodBase;
away3d_materials_methods_ShadowMapMethodBase.prototype = $extend(away3d_materials_methods_ShadingMethodBase.prototype,{
	_castingLight: null
	,_shadowMapper: null
	,_epsilon: null
	,_alpha: null
	,get_assetType: function() {
		return "shadowMapMethod";
	}
	,get_alpha: function() {
		return this._alpha;
	}
	,set_alpha: function(value) {
		this._alpha = value;
		return value;
	}
	,get_castingLight: function() {
		return this._castingLight;
	}
	,get_epsilon: function() {
		return this._epsilon;
	}
	,set_epsilon: function(value) {
		this._epsilon = value;
		return value;
	}
	,getFragmentCode: function(vo,regCache,targetReg) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,__class__: away3d_materials_methods_ShadowMapMethodBase
	,__properties__: $extend(away3d_materials_methods_ShadingMethodBase.prototype.__properties__,{set_epsilon:"set_epsilon",get_epsilon:"get_epsilon",get_castingLight:"get_castingLight",set_alpha:"set_alpha",get_alpha:"get_alpha",get_assetType:"get_assetType"})
});
var away3d_materials_passes_MaterialPassBase = function(renderToTexture) {
	if(renderToTexture == null) {
		renderToTexture = false;
	}
	this._writeDepth = true;
	this._agalVersion = 1;
	this._defaultCulling = 0;
	this._shadedTarget = "ft0";
	var array = ["vt0"];
	var vector = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	var _g = 0;
	var _g1 = array.length;
	while(_g < _g1) {
		var i = _g++;
		vector.set(i,array[i]);
	}
	this._animationTargetRegisters = vector;
	var array1 = ["va0"];
	var vector1 = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	var _g2 = 0;
	var _g11 = array1.length;
	while(_g2 < _g11) {
		var i1 = _g2++;
		vector1.set(i1,array1[i1]);
	}
	this._animatableAttributes = vector1;
	this._blendFactorDest = 9;
	this._blendFactorSource = 2;
	this._depthCompareMode = 5;
	this._anisotropy = 1;
	this._mipmap = true;
	this._repeat = false;
	this._smooth = true;
	this._numUsedVaryings = 0;
	this._numUsedFragmentConstants = 0;
	this._numUsedVertexConstants = 0;
	this._numUsedTextures = 0;
	this._numUsedStreams = 0;
	this._context3Ds = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	var array2 = [-1,-1,-1,-1,-1,-1,-1,-1];
	var vector2 = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
	var _g3 = 0;
	var _g12 = array2.length;
	while(_g3 < _g12) {
		var i2 = _g3++;
		vector2.set(i2,array2[i2]);
	}
	this._program3Dids = vector2;
	this._program3Ds = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	openfl_events_EventDispatcher.call(this);
	this._renderToTexture = renderToTexture;
	this._numUsedStreams = 1;
	this._numUsedVertexConstants = 5;
};
$hxClasses["away3d.materials.passes.MaterialPassBase"] = away3d_materials_passes_MaterialPassBase;
away3d_materials_passes_MaterialPassBase.__name__ = "away3d.materials.passes.MaterialPassBase";
away3d_materials_passes_MaterialPassBase.__super__ = openfl_events_EventDispatcher;
away3d_materials_passes_MaterialPassBase.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	_material: null
	,_animationSet: null
	,_program3Ds: null
	,_program3Dids: null
	,_context3Ds: null
	,_numUsedStreams: null
	,_numUsedTextures: null
	,_numUsedVertexConstants: null
	,_numUsedFragmentConstants: null
	,_numUsedVaryings: null
	,_smooth: null
	,_repeat: null
	,_mipmap: null
	,_anisotropy: null
	,_depthCompareMode: null
	,_blendFactorSource: null
	,_blendFactorDest: null
	,_enableBlending: null
	,_bothSides: null
	,_lightPicker: null
	,_animatableAttributes: null
	,_animationTargetRegisters: null
	,_shadedTarget: null
	,_defaultCulling: null
	,_renderToTexture: null
	,_oldTarget: null
	,_oldSurface: null
	,_oldDepthStencil: null
	,_oldRect: null
	,_alphaPremultiplied: null
	,_needFragmentAnimation: null
	,_needUVAnimation: null
	,_UVTarget: null
	,_UVSource: null
	,_agalVersion: null
	,_writeDepth: null
	,animationRegisterCache: null
	,get_material: function() {
		return this._material;
	}
	,set_material: function(value) {
		this._material = value;
		return this._material;
	}
	,get_writeDepth: function() {
		return this._writeDepth;
	}
	,set_writeDepth: function(value) {
		this._writeDepth = value;
		return this._writeDepth;
	}
	,get_mipmap: function() {
		return this._mipmap;
	}
	,set_mipmap: function(value) {
		if(this._mipmap == value) {
			return this._mipmap;
		}
		this._mipmap = value;
		this.invalidateShaderProgram();
		return this._mipmap;
	}
	,get_anisotropy: function() {
		return this._anisotropy;
	}
	,set_anisotropy: function(value) {
		if(this._anisotropy == value) {
			return value;
		}
		this._anisotropy = value;
		this.invalidateShaderProgram();
		return value;
	}
	,get_smooth: function() {
		return this._smooth;
	}
	,set_smooth: function(value) {
		if(this._smooth == value) {
			return this._smooth;
		}
		this._smooth = value;
		this.invalidateShaderProgram();
		return this._smooth;
	}
	,get_repeat: function() {
		return this._repeat;
	}
	,set_repeat: function(value) {
		if(this._repeat == value) {
			return this._repeat;
		}
		this._repeat = value;
		this.invalidateShaderProgram();
		return this._repeat;
	}
	,get_bothSides: function() {
		return this._bothSides;
	}
	,set_bothSides: function(value) {
		this._bothSides = value;
		return this._bothSides;
	}
	,get_depthCompareMode: function() {
		return this._depthCompareMode;
	}
	,set_depthCompareMode: function(value) {
		this._depthCompareMode = value;
		return value;
	}
	,get_animationSet: function() {
		return this._animationSet;
	}
	,set_animationSet: function(value) {
		if(this._animationSet == value) {
			return this._animationSet;
		}
		this._animationSet = value;
		this.invalidateShaderProgram();
		return this._animationSet;
	}
	,get_renderToTexture: function() {
		return this._renderToTexture;
	}
	,dispose: function() {
		if(this._lightPicker != null) {
			this._lightPicker.removeEventListener("change",$bind(this,this.onLightsChange));
		}
		if(this._program3Ds.get(0) != null) {
			away3d_core_managers_AGALProgram3DCache.getInstanceFromIndex(0).freeProgram3D(this._program3Dids.get(0));
			this._program3Ds.set(0,null);
		}
		if(this._program3Ds.get(1) != null) {
			away3d_core_managers_AGALProgram3DCache.getInstanceFromIndex(1).freeProgram3D(this._program3Dids.get(1));
			this._program3Ds.set(1,null);
		}
		if(this._program3Ds.get(2) != null) {
			away3d_core_managers_AGALProgram3DCache.getInstanceFromIndex(2).freeProgram3D(this._program3Dids.get(2));
			this._program3Ds.set(2,null);
		}
		if(this._program3Ds.get(3) != null) {
			away3d_core_managers_AGALProgram3DCache.getInstanceFromIndex(3).freeProgram3D(this._program3Dids.get(3));
			this._program3Ds.set(3,null);
		}
		if(this._program3Ds.get(4) != null) {
			away3d_core_managers_AGALProgram3DCache.getInstanceFromIndex(4).freeProgram3D(this._program3Dids.get(4));
			this._program3Ds.set(4,null);
		}
		if(this._program3Ds.get(5) != null) {
			away3d_core_managers_AGALProgram3DCache.getInstanceFromIndex(5).freeProgram3D(this._program3Dids.get(5));
			this._program3Ds.set(5,null);
		}
		if(this._program3Ds.get(6) != null) {
			away3d_core_managers_AGALProgram3DCache.getInstanceFromIndex(6).freeProgram3D(this._program3Dids.get(6));
			this._program3Ds.set(6,null);
		}
		if(this._program3Ds.get(7) != null) {
			away3d_core_managers_AGALProgram3DCache.getInstanceFromIndex(7).freeProgram3D(this._program3Dids.get(7));
			this._program3Ds.set(7,null);
		}
	}
	,get_numUsedStreams: function() {
		return this._numUsedStreams;
	}
	,get_numUsedVertexConstants: function() {
		return this._numUsedVertexConstants;
	}
	,get_numUsedVaryings: function() {
		return this._numUsedVaryings;
	}
	,get_numUsedFragmentConstants: function() {
		return this._numUsedFragmentConstants;
	}
	,get_needFragmentAnimation: function() {
		return this._needFragmentAnimation;
	}
	,get_needUVAnimation: function() {
		return this._needUVAnimation;
	}
	,updateAnimationState: function(renderable,stage3DProxy,camera) {
		renderable.get_animator().setRenderState(stage3DProxy,renderable,this._numUsedVertexConstants,this._numUsedStreams,camera);
	}
	,render: function(renderable,stage3DProxy,camera,viewProjection) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,getVertexCode: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,getFragmentCode: function(fragmentAnimatorCode) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,setBlendMode: function(value) {
		switch(value) {
		case 0:
			this._blendFactorSource = 7;
			this._blendFactorDest = 2;
			this._enableBlending = true;
			break;
		case 1:
			this._blendFactorSource = 9;
			this._blendFactorDest = 7;
			this._enableBlending = true;
			break;
		case 7:
			this._blendFactorSource = 7;
			this._blendFactorDest = 5;
			this._enableBlending = true;
			break;
		case 9:
			this._blendFactorSource = 9;
			this._blendFactorDest = 8;
			this._enableBlending = true;
			break;
		case 10:
			this._blendFactorSource = 2;
			this._blendFactorDest = 9;
			this._enableBlending = false;
			break;
		case 12:
			this._blendFactorSource = 2;
			this._blendFactorDest = 6;
			this._enableBlending = true;
			break;
		default:
			throw new js__$Boot_HaxeError(new openfl_errors_ArgumentError("Unsupported blend mode!"));
		}
	}
	,activate: function(stage3DProxy,camera) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var context = stage3DProxy._context3D;
		context.setDepthTest(this._writeDepth && !this._enableBlending,this._depthCompareMode);
		if(this._enableBlending) {
			context.setBlendFactors(this._blendFactorSource,this._blendFactorDest);
		}
		if(this._context3Ds.get(contextIndex) != context || this._program3Ds.get(contextIndex) == null) {
			this._context3Ds.set(contextIndex,context);
			this.updateProgram(stage3DProxy);
			this.dispatchEvent(new openfl_events_Event("change"));
		}
		var prevUsed = away3d_materials_passes_MaterialPassBase._previousUsedStreams.get(contextIndex);
		var _g = this._numUsedStreams;
		var _g1 = prevUsed;
		while(_g < _g1) {
			var i = _g++;
			context.setVertexBufferAt(i,null);
		}
		prevUsed = away3d_materials_passes_MaterialPassBase._previousUsedTexs.get(contextIndex);
		var _g2 = this._numUsedTextures;
		var _g3 = prevUsed;
		while(_g2 < _g3) {
			var i1 = _g2++;
			context.setTextureAt(i1,null);
		}
		if(this._animationSet != null && !this._animationSet.get_usesCPU()) {
			this._animationSet.activate(stage3DProxy,this);
		}
		context.setProgram(this._program3Ds.get(contextIndex));
		context.setCulling(this._bothSides ? 3 : this._defaultCulling);
		if(this._renderToTexture) {
			this._oldTarget = stage3DProxy.get_renderTarget();
			this._oldSurface = stage3DProxy.get_renderSurfaceSelector();
			this._oldDepthStencil = stage3DProxy.get_enableDepthAndStencil();
			this._oldRect = stage3DProxy.get_scissorRect();
		}
	}
	,deactivate: function(stage3DProxy) {
		var index = stage3DProxy._stage3DIndex;
		away3d_materials_passes_MaterialPassBase._previousUsedStreams.set(index,this._numUsedStreams);
		away3d_materials_passes_MaterialPassBase._previousUsedTexs.set(index,this._numUsedTextures);
		if(this._animationSet != null && !this._animationSet.get_usesCPU()) {
			this._animationSet.deactivate(stage3DProxy,this);
		}
		if(this._renderToTexture) {
			stage3DProxy.setRenderTarget(this._oldTarget,this._oldDepthStencil,this._oldSurface);
			stage3DProxy.set_scissorRect(this._oldRect);
		}
		if(this._enableBlending) {
			stage3DProxy._context3D.setBlendFactors(2,9);
		}
		stage3DProxy._context3D.setDepthTest(true,5);
	}
	,invalidateShaderProgram: function(updateMaterial) {
		if(updateMaterial == null) {
			updateMaterial = true;
		}
		this._program3Ds.set(0,null);
		this._program3Ds.set(1,null);
		this._program3Ds.set(2,null);
		this._program3Ds.set(3,null);
		this._program3Ds.set(4,null);
		this._program3Ds.set(5,null);
		this._program3Ds.set(6,null);
		this._program3Ds.set(7,null);
		if(this._material != null && updateMaterial) {
			this._material.invalidatePasses(this);
		}
	}
	,updateProgram: function(stage3DProxy) {
		var animatorCode = "";
		var UVAnimatorCode = "";
		var fragmentAnimatorCode = "";
		var vertexCode = this.getVertexCode();
		if(this._animationSet != null && !this._animationSet.get_usesCPU()) {
			animatorCode = this._animationSet.getAGALVertexCode(this,this._animatableAttributes,this._animationTargetRegisters,stage3DProxy.get_profile());
			if(this._needFragmentAnimation) {
				fragmentAnimatorCode = this._animationSet.getAGALFragmentCode(this,this._shadedTarget,stage3DProxy.get_profile());
			}
			if(this._needUVAnimation) {
				UVAnimatorCode = this._animationSet.getAGALUVCode(this,this._UVSource,this._UVTarget);
			}
			this._animationSet.doneAGALCode(this);
		} else {
			var len = this._animatableAttributes.get_length();
			var _g = 0;
			var _g1 = len;
			while(_g < _g1) {
				var i = _g++;
				animatorCode += "mov " + this._animationTargetRegisters.get(i) + ", " + this._animatableAttributes.get(i) + "\n";
			}
			if(this._needUVAnimation) {
				UVAnimatorCode = "mov " + this._UVTarget + "," + this._UVSource + "\n";
			}
		}
		vertexCode = animatorCode + UVAnimatorCode + vertexCode;
		var fragmentCode = this.getFragmentCode(fragmentAnimatorCode);
		if(away3d_debug_Debug.active) {
			haxe_Log.trace("Compiling AGAL Code:",{ fileName : "away3d/materials/passes/MaterialPassBase.hx", lineNumber : 537, className : "away3d.materials.passes.MaterialPassBase", methodName : "updateProgram"});
			haxe_Log.trace("--------------------",{ fileName : "away3d/materials/passes/MaterialPassBase.hx", lineNumber : 538, className : "away3d.materials.passes.MaterialPassBase", methodName : "updateProgram"});
			haxe_Log.trace(vertexCode,{ fileName : "away3d/materials/passes/MaterialPassBase.hx", lineNumber : 539, className : "away3d.materials.passes.MaterialPassBase", methodName : "updateProgram"});
			haxe_Log.trace("--------------------",{ fileName : "away3d/materials/passes/MaterialPassBase.hx", lineNumber : 540, className : "away3d.materials.passes.MaterialPassBase", methodName : "updateProgram"});
			haxe_Log.trace(fragmentCode,{ fileName : "away3d/materials/passes/MaterialPassBase.hx", lineNumber : 541, className : "away3d.materials.passes.MaterialPassBase", methodName : "updateProgram"});
		}
		away3d_core_managers_AGALProgram3DCache.getInstance(stage3DProxy).setProgram3D(this,vertexCode,fragmentCode,this._agalVersion);
	}
	,get_lightPicker: function() {
		return this._lightPicker;
	}
	,set_lightPicker: function(value) {
		if(this._lightPicker != null) {
			this._lightPicker.removeEventListener("change",$bind(this,this.onLightsChange));
		}
		this._lightPicker = value;
		if(this._lightPicker != null) {
			this._lightPicker.addEventListener("change",$bind(this,this.onLightsChange));
		}
		this.updateLights();
		return this._lightPicker;
	}
	,onLightsChange: function(event) {
		this.updateLights();
	}
	,updateLights: function() {
	}
	,get_alphaPremultiplied: function() {
		return this._alphaPremultiplied;
	}
	,set_alphaPremultiplied: function(value) {
		this._alphaPremultiplied = value;
		this.invalidateShaderProgram(false);
		return this._alphaPremultiplied;
	}
	,__class__: away3d_materials_passes_MaterialPassBase
	,__properties__: {set_alphaPremultiplied:"set_alphaPremultiplied",get_alphaPremultiplied:"get_alphaPremultiplied",set_lightPicker:"set_lightPicker",get_lightPicker:"get_lightPicker",get_needUVAnimation:"get_needUVAnimation",get_needFragmentAnimation:"get_needFragmentAnimation",get_numUsedFragmentConstants:"get_numUsedFragmentConstants",get_numUsedVaryings:"get_numUsedVaryings",get_numUsedVertexConstants:"get_numUsedVertexConstants",get_numUsedStreams:"get_numUsedStreams",get_renderToTexture:"get_renderToTexture",set_animationSet:"set_animationSet",get_animationSet:"get_animationSet",set_depthCompareMode:"set_depthCompareMode",get_depthCompareMode:"get_depthCompareMode",set_bothSides:"set_bothSides",get_bothSides:"get_bothSides",set_anisotropy:"set_anisotropy",get_anisotropy:"get_anisotropy",set_repeat:"set_repeat",get_repeat:"get_repeat",set_smooth:"set_smooth",get_smooth:"get_smooth",set_mipmap:"set_mipmap",get_mipmap:"get_mipmap",set_writeDepth:"set_writeDepth",get_writeDepth:"get_writeDepth",set_material:"set_material",get_material:"get_material"}
});
var away3d_materials_passes_CompiledPass = function(material) {
	this._enableLightFallOff = true;
	this._preserveAlpha = true;
	this._fragmentConstantData = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
	this._vertexConstantData = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
	this._diffuseLightSources = 3;
	this._specularLightSources = 1;
	this._material = material;
	this.init();
	away3d_materials_passes_MaterialPassBase.call(this);
};
$hxClasses["away3d.materials.passes.CompiledPass"] = away3d_materials_passes_CompiledPass;
away3d_materials_passes_CompiledPass.__name__ = "away3d.materials.passes.CompiledPass";
away3d_materials_passes_CompiledPass.__super__ = away3d_materials_passes_MaterialPassBase;
away3d_materials_passes_CompiledPass.prototype = $extend(away3d_materials_passes_MaterialPassBase.prototype,{
	_passes: null
	,_passesDirty: null
	,_specularLightSources: null
	,_diffuseLightSources: null
	,_vertexCode: null
	,_fragmentLightCode: null
	,_framentPostLightCode: null
	,_vertexConstantData: null
	,_fragmentConstantData: null
	,_commonsDataIndex: null
	,_probeWeightsIndex: null
	,_uvBufferIndex: null
	,_secondaryUVBufferIndex: null
	,_normalBufferIndex: null
	,_tangentBufferIndex: null
	,_sceneMatrixIndex: null
	,_sceneNormalMatrixIndex: null
	,_lightFragmentConstantIndex: null
	,_cameraPositionIndex: null
	,_uvTransformIndex: null
	,_uvTransformIndex2: null
	,_lightProbeDiffuseIndices: null
	,_lightProbeSpecularIndices: null
	,_ambientLightR: null
	,_ambientLightG: null
	,_ambientLightB: null
	,_compiler: null
	,_methodSetup: null
	,_usingSpecularMethod: null
	,_usesNormals: null
	,_preserveAlpha: null
	,_animateUVs: null
	,_animateUVs2: null
	,_numPointLights: null
	,_numDirectionalLights: null
	,_numLightProbes: null
	,_enableLightFallOff: null
	,_forceSeparateMVP: null
	,get_enableLightFallOff: function() {
		return this._enableLightFallOff;
	}
	,set_enableLightFallOff: function(value) {
		if(value != this._enableLightFallOff) {
			this.invalidateShaderProgram(true);
		}
		this._enableLightFallOff = value;
		return value;
	}
	,get_forceSeparateMVP: function() {
		return this._forceSeparateMVP;
	}
	,set_forceSeparateMVP: function(value) {
		this._forceSeparateMVP = value;
		return value;
	}
	,get_numPointLights: function() {
		return this._numPointLights;
	}
	,get_numDirectionalLights: function() {
		return this._numDirectionalLights;
	}
	,get_numLightProbes: function() {
		return this._numLightProbes;
	}
	,updateProgram: function(stage3DProxy) {
		this.reset(stage3DProxy.get_profile());
		away3d_materials_passes_MaterialPassBase.prototype.updateProgram.call(this,stage3DProxy);
	}
	,reset: function(profile) {
		this.initCompiler(profile);
		this.updateShaderProperties();
		this.initConstantData();
		this.cleanUp();
	}
	,updateUsedOffsets: function() {
		this._numUsedVertexConstants = this._compiler.get_numUsedVertexConstants();
		this._numUsedFragmentConstants = this._compiler.get_numUsedFragmentConstants();
		this._numUsedStreams = this._compiler.get_numUsedStreams();
		this._numUsedTextures = this._compiler.get_numUsedTextures();
		this._numUsedVaryings = this._compiler.get_numUsedVaryings();
		this._numUsedFragmentConstants = this._compiler.get_numUsedFragmentConstants();
	}
	,initConstantData: function() {
		this._vertexConstantData.set_length(this._numUsedVertexConstants * 4);
		this._fragmentConstantData.set_length(this._numUsedFragmentConstants * 4);
		this.initCommonsData();
		if(this._uvTransformIndex >= 0) {
			this.initUVTransformData();
		}
		if(this._cameraPositionIndex >= 0) {
			this._vertexConstantData.set(this._cameraPositionIndex + 3,1);
		}
		this.updateMethodConstants();
	}
	,initCompiler: function(profile) {
		this._compiler = this.createCompiler(profile);
		this._compiler.set_forceSeperateMVP(this._forceSeparateMVP);
		this._compiler.set_numPointLights(this._numPointLights);
		this._compiler.set_numDirectionalLights(this._numDirectionalLights);
		this._compiler.set_numLightProbes(this._numLightProbes);
		this._compiler.set_methodSetup(this._methodSetup);
		this._compiler.set_diffuseLightSources(this._diffuseLightSources);
		this._compiler.set_specularLightSources(this._specularLightSources);
		this._compiler.setTextureSampling(this._smooth,this._repeat,this._mipmap,this._anisotropy);
		this._compiler.setConstantDataBuffers(this._vertexConstantData,this._fragmentConstantData);
		this._compiler.set_animateUVs(this._animateUVs);
		this._compiler.set_animateUVs2(this._animateUVs2);
		this._compiler.set_alphaPremultiplied(this._alphaPremultiplied && this._enableBlending);
		this._compiler.set_preserveAlpha(this._preserveAlpha && this._enableBlending);
		this._compiler.set_enableLightFallOff(this._enableLightFallOff);
		this._compiler.compile();
	}
	,createCompiler: function(profile) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,updateShaderProperties: function() {
		this._animatableAttributes = this._compiler.get_animatableAttributes();
		this._animationTargetRegisters = this._compiler.get_animationTargetRegisters();
		this._vertexCode = this._compiler.get_vertexCode();
		this._fragmentLightCode = this._compiler.get_fragmentLightCode();
		this._framentPostLightCode = this._compiler.get_fragmentPostLightCode();
		this._shadedTarget = this._compiler.get_shadedTarget();
		this._usingSpecularMethod = this._compiler.get_usingSpecularMethod();
		this._usesNormals = this._compiler.get_usesNormals();
		this._needUVAnimation = this._compiler.get_needUVAnimation();
		this._UVSource = this._compiler.get_UVSource();
		this._UVTarget = this._compiler.get_UVTarget();
		this.updateRegisterIndices();
		this.updateUsedOffsets();
	}
	,updateRegisterIndices: function() {
		this._uvBufferIndex = this._compiler.get_uvBufferIndex();
		this._uvTransformIndex = this._compiler.get_uvTransformIndex();
		this._uvTransformIndex2 = this._compiler.get_uvTransformIndex2();
		this._secondaryUVBufferIndex = this._compiler.get_secondaryUVBufferIndex();
		this._normalBufferIndex = this._compiler.get_normalBufferIndex();
		this._tangentBufferIndex = this._compiler.get_tangentBufferIndex();
		this._lightFragmentConstantIndex = this._compiler.get_lightFragmentConstantIndex();
		this._cameraPositionIndex = this._compiler.get_cameraPositionIndex();
		this._commonsDataIndex = this._compiler.get_commonsDataIndex();
		this._sceneMatrixIndex = this._compiler.get_sceneMatrixIndex();
		this._sceneNormalMatrixIndex = this._compiler.get_sceneNormalMatrixIndex();
		this._probeWeightsIndex = this._compiler.get_probeWeightsIndex();
		this._lightProbeDiffuseIndices = this._compiler.get_lightProbeDiffuseIndices();
		this._lightProbeSpecularIndices = this._compiler.get_lightProbeSpecularIndices();
	}
	,get_preserveAlpha: function() {
		return this._preserveAlpha;
	}
	,set_preserveAlpha: function(value) {
		if(this._preserveAlpha == value) {
			return value;
		}
		this._preserveAlpha = value;
		this.invalidateShaderProgram();
		return value;
	}
	,get_animateUVs: function() {
		return this._animateUVs;
	}
	,set_animateUVs: function(value) {
		if(this._animateUVs == value) {
			return value;
		}
		this._animateUVs = value;
		this.invalidateShaderProgram();
		return value;
	}
	,get_animateUVs2: function() {
		return this._animateUVs2;
	}
	,set_animateUVs2: function(value) {
		if(this._animateUVs2 == value) {
			return value;
		}
		this._animateUVs2 = value;
		this.invalidateShaderProgram();
		return value;
	}
	,set_mipmap: function(value) {
		if(this._mipmap == value) {
			return value;
		}
		away3d_materials_passes_MaterialPassBase.prototype.set_mipmap.call(this,value);
		return value;
	}
	,set_anisotropy: function(value) {
		if(this._anisotropy == value) {
			return value;
		}
		away3d_materials_passes_MaterialPassBase.prototype.set_anisotropy.call(this,value);
		return value;
	}
	,get_normalMap: function() {
		return this._methodSetup._normalMethod.get_normalMap();
	}
	,set_normalMap: function(value) {
		this._methodSetup._normalMethod.set_normalMap(value);
		return value;
	}
	,get_normalMethod: function() {
		return this._methodSetup.get_normalMethod();
	}
	,set_normalMethod: function(value) {
		this._methodSetup.set_normalMethod(value);
		return value;
	}
	,get_ambientMethod: function() {
		return this._methodSetup.get_ambientMethod();
	}
	,set_ambientMethod: function(value) {
		this._methodSetup.set_ambientMethod(value);
		return value;
	}
	,get_shadowMethod: function() {
		return this._methodSetup.get_shadowMethod();
	}
	,set_shadowMethod: function(value) {
		this._methodSetup.set_shadowMethod(value);
		return value;
	}
	,get_diffuseMethod: function() {
		return this._methodSetup.get_diffuseMethod();
	}
	,set_diffuseMethod: function(value) {
		this._methodSetup.set_diffuseMethod(value);
		return value;
	}
	,get_specularMethod: function() {
		return this._methodSetup.get_specularMethod();
	}
	,set_specularMethod: function(value) {
		this._methodSetup.set_specularMethod(value);
		return value;
	}
	,init: function() {
		this._methodSetup = new away3d_materials_methods_ShaderMethodSetup();
		this._methodSetup.addEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
	}
	,dispose: function() {
		away3d_materials_passes_MaterialPassBase.prototype.dispose.call(this);
		this._methodSetup.removeEventListener("ShaderInvalidated",$bind(this,this.onShaderInvalidated));
		this._methodSetup.dispose();
		this._methodSetup = null;
	}
	,invalidateShaderProgram: function(updateMaterial) {
		if(updateMaterial == null) {
			updateMaterial = true;
		}
		var oldPasses = this._passes;
		this._passes = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
		if(this._methodSetup != null) {
			this.addPassesFromMethods();
		}
		if(oldPasses == null || this._passes.get_length() != oldPasses.get_length()) {
			this._passesDirty = true;
			return;
		}
		var _g = 0;
		var _g1 = this._passes.get_length();
		while(_g < _g1) {
			var i = _g++;
			if(this._passes.get(i) != oldPasses.get(i)) {
				this._passesDirty = true;
				return;
			}
		}
		away3d_materials_passes_MaterialPassBase.prototype.invalidateShaderProgram.call(this,updateMaterial);
	}
	,addPassesFromMethods: function() {
		if(this._methodSetup._normalMethod != null && this._methodSetup._normalMethod.get_hasOutput()) {
			this.addPasses(this._methodSetup._normalMethod.get_passes());
		}
		if(this._methodSetup._ambientMethod != null) {
			this.addPasses(this._methodSetup._ambientMethod.get_passes());
		}
		if(this._methodSetup._shadowMethod != null) {
			this.addPasses(this._methodSetup._shadowMethod.get_passes());
		}
		if(this._methodSetup._diffuseMethod != null) {
			this.addPasses(this._methodSetup._diffuseMethod.get_passes());
		}
		if(this._methodSetup._specularMethod != null) {
			this.addPasses(this._methodSetup._specularMethod.get_passes());
		}
	}
	,addPasses: function(passes) {
		if(passes == null) {
			return;
		}
		var len = passes.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			passes.get(i).set_material(this.get_material());
			passes.get(i).set_lightPicker(this._lightPicker);
			this._passes.push(passes.get(i));
		}
	}
	,initUVTransformData: function() {
		this._vertexConstantData.set(this._uvTransformIndex,1);
		this._vertexConstantData.set(this._uvTransformIndex + 1,0);
		this._vertexConstantData.set(this._uvTransformIndex + 2,0);
		this._vertexConstantData.set(this._uvTransformIndex + 3,0);
		this._vertexConstantData.set(this._uvTransformIndex + 4,0);
		this._vertexConstantData.set(this._uvTransformIndex + 5,1);
		this._vertexConstantData.set(this._uvTransformIndex + 6,0);
		this._vertexConstantData.set(this._uvTransformIndex + 7,0);
	}
	,initUVTransformData2: function() {
		this._vertexConstantData.set(this._uvTransformIndex2,1);
		this._vertexConstantData.set(this._uvTransformIndex2 + 1,0);
		this._vertexConstantData.set(this._uvTransformIndex2 + 2,0);
		this._vertexConstantData.set(this._uvTransformIndex2 + 3,0);
		this._vertexConstantData.set(this._uvTransformIndex2 + 4,0);
		this._vertexConstantData.set(this._uvTransformIndex2 + 5,1);
		this._vertexConstantData.set(this._uvTransformIndex2 + 6,0);
		this._vertexConstantData.set(this._uvTransformIndex2 + 7,0);
	}
	,initCommonsData: function() {
		this._fragmentConstantData.set(this._commonsDataIndex,.5);
		this._fragmentConstantData.set(this._commonsDataIndex + 1,0);
		this._fragmentConstantData.set(this._commonsDataIndex + 2,0.00392156862745098);
		this._fragmentConstantData.set(this._commonsDataIndex + 3,1);
	}
	,cleanUp: function() {
		this._compiler.dispose();
		this._compiler = null;
	}
	,updateMethodConstants: function() {
		if(this._methodSetup._normalMethod != null) {
			this._methodSetup._normalMethod.initConstants(this._methodSetup._normalMethodVO);
		}
		if(this._methodSetup._diffuseMethod != null) {
			this._methodSetup._diffuseMethod.initConstants(this._methodSetup._diffuseMethodVO);
		}
		if(this._methodSetup._ambientMethod != null) {
			this._methodSetup._ambientMethod.initConstants(this._methodSetup._ambientMethodVO);
		}
		if(this._usingSpecularMethod) {
			this._methodSetup._specularMethod.initConstants(this._methodSetup._specularMethodVO);
		}
		if(this._methodSetup._shadowMethod != null) {
			this._methodSetup._shadowMethod.initConstants(this._methodSetup._shadowMethodVO);
		}
	}
	,updateLightConstants: function() {
	}
	,updateProbes: function(stage3DProxy) {
	}
	,onShaderInvalidated: function(event) {
		this.invalidateShaderProgram();
	}
	,getVertexCode: function() {
		return this._vertexCode;
	}
	,getFragmentCode: function(animatorCode) {
		return this._fragmentLightCode + animatorCode + this._framentPostLightCode;
	}
	,activate: function(stage3DProxy,camera) {
		away3d_materials_passes_MaterialPassBase.prototype.activate.call(this,stage3DProxy,camera);
		if(this._usesNormals) {
			this._methodSetup._normalMethod.activate(this._methodSetup._normalMethodVO,stage3DProxy);
		}
		this._methodSetup._ambientMethod.activate(this._methodSetup._ambientMethodVO,stage3DProxy);
		if(this._methodSetup._shadowMethod != null) {
			this._methodSetup._shadowMethod.activate(this._methodSetup._shadowMethodVO,stage3DProxy);
		}
		this._methodSetup._diffuseMethod.activate(this._methodSetup._diffuseMethodVO,stage3DProxy);
		if(this._usingSpecularMethod) {
			this._methodSetup._specularMethod.activate(this._methodSetup._specularMethodVO,stage3DProxy);
		}
	}
	,render: function(renderable,stage3DProxy,camera,viewProjection) {
		var i = 0;
		var context = stage3DProxy._context3D;
		if(this._uvBufferIndex >= 0) {
			renderable.activateUVBuffer(this._uvBufferIndex,stage3DProxy);
		}
		if(this._secondaryUVBufferIndex >= 0) {
			renderable.activateSecondaryUVBuffer(this._secondaryUVBufferIndex,stage3DProxy);
		}
		if(this._normalBufferIndex >= 0) {
			renderable.activateVertexNormalBuffer(this._normalBufferIndex,stage3DProxy);
		}
		if(this._tangentBufferIndex >= 0) {
			renderable.activateVertexTangentBuffer(this._tangentBufferIndex,stage3DProxy);
		}
		if(this._animateUVs) {
			var uvTransform = renderable.get_uvTransform();
			if(uvTransform != null) {
				this._vertexConstantData.set(this._uvTransformIndex,uvTransform.a);
				this._vertexConstantData.set(this._uvTransformIndex + 1,uvTransform.b);
				this._vertexConstantData.set(this._uvTransformIndex + 3,uvTransform.tx);
				this._vertexConstantData.set(this._uvTransformIndex + 4,uvTransform.c);
				this._vertexConstantData.set(this._uvTransformIndex + 5,uvTransform.d);
				this._vertexConstantData.set(this._uvTransformIndex + 7,uvTransform.ty);
			} else {
				this._vertexConstantData.set(this._uvTransformIndex,1);
				this._vertexConstantData.set(this._uvTransformIndex + 1,0);
				this._vertexConstantData.set(this._uvTransformIndex + 3,0);
				this._vertexConstantData.set(this._uvTransformIndex + 4,0);
				this._vertexConstantData.set(this._uvTransformIndex + 5,1);
				this._vertexConstantData.set(this._uvTransformIndex + 7,0);
			}
		}
		if(this._animateUVs2) {
			var uvTransform2 = renderable.get_uvTransform2();
			if(uvTransform2 != null) {
				this._vertexConstantData.set(this._uvTransformIndex2,uvTransform2.a);
				this._vertexConstantData.set(this._uvTransformIndex2 + 1,uvTransform2.b);
				this._vertexConstantData.set(this._uvTransformIndex2 + 3,uvTransform2.tx);
				this._vertexConstantData.set(this._uvTransformIndex2 + 4,uvTransform2.c);
				this._vertexConstantData.set(this._uvTransformIndex2 + 5,uvTransform2.d);
				this._vertexConstantData.set(this._uvTransformIndex2 + 7,uvTransform2.ty);
			} else {
				this._vertexConstantData.set(this._uvTransformIndex2,1);
				this._vertexConstantData.set(this._uvTransformIndex2 + 1,0);
				this._vertexConstantData.set(this._uvTransformIndex2 + 3,0);
				this._vertexConstantData.set(this._uvTransformIndex2 + 4,0);
				this._vertexConstantData.set(this._uvTransformIndex2 + 5,1);
				this._vertexConstantData.set(this._uvTransformIndex2 + 7,0);
			}
		}
		this._ambientLightR = this._ambientLightG = this._ambientLightB = 0;
		if(this.usesLights()) {
			this.updateLightConstants();
		}
		if(this.usesProbes()) {
			this.updateProbes(stage3DProxy);
		}
		if(this._sceneMatrixIndex >= 0) {
			renderable.getRenderSceneTransform(camera).copyRawDataTo(this._vertexConstantData,this._sceneMatrixIndex,true);
			viewProjection.copyRawDataTo(this._vertexConstantData,0,true);
		} else {
			var matrix3D = away3d_core_math_Matrix3DUtils.CALCULATION_MATRIX;
			matrix3D.copyFrom(renderable.getRenderSceneTransform(camera));
			matrix3D.append(viewProjection);
			matrix3D.copyRawDataTo(this._vertexConstantData,0,true);
		}
		if(this._sceneNormalMatrixIndex >= 0) {
			renderable.get_inverseSceneTransform().copyRawDataTo(this._vertexConstantData,this._sceneNormalMatrixIndex,false);
		}
		if(this._usesNormals) {
			this._methodSetup._normalMethod.setRenderState(this._methodSetup._normalMethodVO,renderable,stage3DProxy,camera);
		}
		var ambientMethod = this._methodSetup._ambientMethod;
		ambientMethod._lightAmbientR = this._ambientLightR;
		ambientMethod._lightAmbientG = this._ambientLightG;
		ambientMethod._lightAmbientB = this._ambientLightB;
		ambientMethod.setRenderState(this._methodSetup._ambientMethodVO,renderable,stage3DProxy,camera);
		if(this._methodSetup._shadowMethod != null) {
			this._methodSetup._shadowMethod.setRenderState(this._methodSetup._shadowMethodVO,renderable,stage3DProxy,camera);
		}
		this._methodSetup._diffuseMethod.setRenderState(this._methodSetup._diffuseMethodVO,renderable,stage3DProxy,camera);
		if(this._usingSpecularMethod) {
			this._methodSetup._specularMethod.setRenderState(this._methodSetup._specularMethodVO,renderable,stage3DProxy,camera);
		}
		if(this._methodSetup._colorTransformMethod != null) {
			this._methodSetup._colorTransformMethod.setRenderState(this._methodSetup._colorTransformMethodVO,renderable,stage3DProxy,camera);
		}
		var methods = this._methodSetup._methods;
		var len = methods.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i1 = _g++;
			var set = methods.get(i1);
			set.method.setRenderState(set.data,renderable,stage3DProxy,camera);
		}
		context.setProgramConstantsFromVector(1,0,this._vertexConstantData,this._numUsedVertexConstants);
		context.setProgramConstantsFromVector(0,0,this._fragmentConstantData,this._numUsedFragmentConstants);
		renderable.activateVertexBuffer(0,stage3DProxy);
		stage3DProxy.drawTriangles(renderable.getIndexBuffer(stage3DProxy),0,renderable.get_numTriangles());
	}
	,usesProbes: function() {
		if(this._numLightProbes > 0) {
			return ((this._diffuseLightSources | this._specularLightSources) & 2) != 0;
		} else {
			return false;
		}
	}
	,usesLights: function() {
		if(this._numPointLights > 0 || this._numDirectionalLights > 0) {
			return ((this._diffuseLightSources | this._specularLightSources) & 1) != 0;
		} else {
			return false;
		}
	}
	,deactivate: function(stage3DProxy) {
		away3d_materials_passes_MaterialPassBase.prototype.deactivate.call(this,stage3DProxy);
		if(this._usesNormals) {
			this._methodSetup._normalMethod.deactivate(this._methodSetup._normalMethodVO,stage3DProxy);
		}
		this._methodSetup._ambientMethod.deactivate(this._methodSetup._ambientMethodVO,stage3DProxy);
		if(this._methodSetup._shadowMethod != null) {
			this._methodSetup._shadowMethod.deactivate(this._methodSetup._shadowMethodVO,stage3DProxy);
		}
		this._methodSetup._diffuseMethod.deactivate(this._methodSetup._diffuseMethodVO,stage3DProxy);
		if(this._usingSpecularMethod) {
			this._methodSetup._specularMethod.deactivate(this._methodSetup._specularMethodVO,stage3DProxy);
		}
	}
	,get_specularLightSources: function() {
		return this._specularLightSources;
	}
	,set_specularLightSources: function(value) {
		this._specularLightSources = value;
		return value;
	}
	,get_diffuseLightSources: function() {
		return this._diffuseLightSources;
	}
	,set_diffuseLightSources: function(value) {
		this._diffuseLightSources = value;
		return value;
	}
	,__class__: away3d_materials_passes_CompiledPass
	,__properties__: $extend(away3d_materials_passes_MaterialPassBase.prototype.__properties__,{set_diffuseLightSources:"set_diffuseLightSources",get_diffuseLightSources:"get_diffuseLightSources",set_specularLightSources:"set_specularLightSources",get_specularLightSources:"get_specularLightSources",set_specularMethod:"set_specularMethod",get_specularMethod:"get_specularMethod",set_diffuseMethod:"set_diffuseMethod",get_diffuseMethod:"get_diffuseMethod",set_shadowMethod:"set_shadowMethod",get_shadowMethod:"get_shadowMethod",set_ambientMethod:"set_ambientMethod",get_ambientMethod:"get_ambientMethod",set_normalMethod:"set_normalMethod",get_normalMethod:"get_normalMethod",set_normalMap:"set_normalMap",get_normalMap:"get_normalMap",set_animateUVs2:"set_animateUVs2",get_animateUVs2:"get_animateUVs2",set_animateUVs:"set_animateUVs",get_animateUVs:"get_animateUVs",set_preserveAlpha:"set_preserveAlpha",get_preserveAlpha:"get_preserveAlpha",get_numLightProbes:"get_numLightProbes",get_numDirectionalLights:"get_numDirectionalLights",get_numPointLights:"get_numPointLights",set_forceSeparateMVP:"set_forceSeparateMVP",get_forceSeparateMVP:"get_forceSeparateMVP",set_enableLightFallOff:"set_enableLightFallOff",get_enableLightFallOff:"get_enableLightFallOff"})
});
var away3d_materials_passes_DepthMapPass = function() {
	this._alphaThreshold = 0;
	away3d_materials_passes_MaterialPassBase.call(this);
	var array = [1.0,255.0,65025.0,16581375.0,0.00392156862745098,0.00392156862745098,0.00392156862745098,0.0,0.0,0.0,0.0,0.0];
	var vector = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
	var _g = 0;
	var _g1 = array.length;
	while(_g < _g1) {
		var i = _g++;
		vector.set(i,array[i]);
	}
	this._data = vector;
};
$hxClasses["away3d.materials.passes.DepthMapPass"] = away3d_materials_passes_DepthMapPass;
away3d_materials_passes_DepthMapPass.__name__ = "away3d.materials.passes.DepthMapPass";
away3d_materials_passes_DepthMapPass.__super__ = away3d_materials_passes_MaterialPassBase;
away3d_materials_passes_DepthMapPass.prototype = $extend(away3d_materials_passes_MaterialPassBase.prototype,{
	_data: null
	,_alphaThreshold: null
	,_alphaMask: null
	,get_alphaThreshold: function() {
		return this._alphaThreshold;
	}
	,set_alphaThreshold: function(value) {
		if(value < 0) {
			value = 0;
		} else if(value > 1) {
			value = 1;
		}
		if(value == this._alphaThreshold) {
			return value;
		}
		if(value == 0 || this._alphaThreshold == 0) {
			this.invalidateShaderProgram();
		}
		this._alphaThreshold = value;
		this._data.set(8,this._alphaThreshold);
		return value;
	}
	,get_alphaMask: function() {
		return this._alphaMask;
	}
	,set_alphaMask: function(value) {
		this._alphaMask = value;
		return value;
	}
	,getVertexCode: function() {
		var code = "m44 vt1, vt0, vc0\t\t\n" + "mov op, vt1\t\n";
		if(this._alphaThreshold > 0) {
			this._numUsedTextures = 1;
			this._numUsedStreams = 2;
			code += "mov v0, vt1\n" + "mov v1, va1\n";
		} else {
			this._numUsedTextures = 0;
			this._numUsedStreams = 1;
			code += "mov v0, vt1\n";
		}
		return code;
	}
	,getFragmentCode: function(code) {
		var codeF = "div ft2, v0, v0.w\t\t\n" + "mul ft0, fc0, ft2.z\t\n" + "frc ft0, ft0\t\t\t\n" + "mul ft1, ft0.yzww, fc1\t\n";
		if(this._alphaThreshold > 0) {
			var wrap = this._repeat ? "wrap" : "clamp";
			var filter;
			var format;
			var enableMipMaps = this._mipmap && this._alphaMask.get_hasMipMaps();
			if(this._smooth) {
				filter = enableMipMaps ? "linear,miplinear" : "linear";
			} else {
				filter = enableMipMaps ? "nearest,mipnearest" : "nearest";
			}
			switch(this._alphaMask.get_format()) {
			case 3:
				format = "dxt1,";
				break;
			case 4:
				format = "dxt5,";
				break;
			default:
				format = "";
			}
			codeF += "tex ft3, v1, fs0 <2d," + filter + "," + format + wrap + ">\n" + "sub ft3.w, ft3.w, fc2.x\n" + "kil ft3.w\n";
		}
		codeF += "sub oc, ft0, ft1\t\t\n";
		return codeF;
	}
	,render: function(renderable,stage3DProxy,camera,viewProjection) {
		if(this._alphaThreshold > 0) {
			renderable.activateUVBuffer(1,stage3DProxy);
		}
		var context = stage3DProxy._context3D;
		var matrix = away3d_core_math_Matrix3DUtils.CALCULATION_MATRIX;
		matrix.copyFrom(renderable.getRenderSceneTransform(camera));
		matrix.append(viewProjection);
		context.setProgramConstantsFromMatrix(1,0,matrix,true);
		renderable.activateVertexBuffer(0,stage3DProxy);
		stage3DProxy.drawTriangles(renderable.getIndexBuffer(stage3DProxy),0,renderable.get_numTriangles());
	}
	,activate: function(stage3DProxy,camera) {
		var context = stage3DProxy._context3D;
		away3d_materials_passes_MaterialPassBase.prototype.activate.call(this,stage3DProxy,camera);
		if(this._alphaThreshold > 0) {
			context.setTextureAt(0,this._alphaMask.getTextureForStage3D(stage3DProxy));
			context.setProgramConstantsFromVector(0,0,this._data,3);
		} else {
			context.setProgramConstantsFromVector(0,0,this._data,2);
		}
	}
	,__class__: away3d_materials_passes_DepthMapPass
	,__properties__: $extend(away3d_materials_passes_MaterialPassBase.prototype.__properties__,{set_alphaMask:"set_alphaMask",get_alphaMask:"get_alphaMask",set_alphaThreshold:"set_alphaThreshold",get_alphaThreshold:"get_alphaThreshold"})
});
var away3d_materials_passes_DistanceMapPass = function() {
	away3d_materials_passes_MaterialPassBase.call(this);
	var array = [1.0,255.0,65025.0,16581375.0,0.00392156862745098,0.00392156862745098,0.00392156862745098,0.0,0.0,0.0,0.0,0.0];
	var vector = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
	var _g = 0;
	var _g1 = array.length;
	while(_g < _g1) {
		var i = _g++;
		vector.set(i,array[i]);
	}
	this._fragmentData = vector;
	this._vertexData = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,4,true);
	this._vertexData.set(3,1);
	this._numUsedVertexConstants = 9;
};
$hxClasses["away3d.materials.passes.DistanceMapPass"] = away3d_materials_passes_DistanceMapPass;
away3d_materials_passes_DistanceMapPass.__name__ = "away3d.materials.passes.DistanceMapPass";
away3d_materials_passes_DistanceMapPass.__super__ = away3d_materials_passes_MaterialPassBase;
away3d_materials_passes_DistanceMapPass.prototype = $extend(away3d_materials_passes_MaterialPassBase.prototype,{
	_fragmentData: null
	,_vertexData: null
	,_alphaThreshold: null
	,_alphaMask: null
	,get_alphaThreshold: function() {
		return this._alphaThreshold;
	}
	,set_alphaThreshold: function(value) {
		if(value < 0) {
			value = 0;
		} else if(value > 1) {
			value = 1;
		}
		if(value == this._alphaThreshold) {
			return value;
		}
		if(value == 0 || this._alphaThreshold == 0) {
			this.invalidateShaderProgram();
		}
		this._alphaThreshold = value;
		this._fragmentData.set(8,this._alphaThreshold);
		return value;
	}
	,get_alphaMask: function() {
		return this._alphaMask;
	}
	,set_alphaMask: function(value) {
		this._alphaMask = value;
		return value;
	}
	,getVertexCode: function() {
		var code = "m44 op, vt0, vc0\t\t\n" + "m44 vt1, vt0, vc5\t\t\n" + "sub v0, vt1, vc9\t\t\n";
		if(this._alphaThreshold > 0) {
			code += "mov v1, va1\n";
			this._numUsedTextures = 1;
			this._numUsedStreams = 2;
		} else {
			this._numUsedTextures = 0;
			this._numUsedStreams = 1;
		}
		return code;
	}
	,getFragmentCode: function(animationCode) {
		var wrap = this._repeat ? "wrap" : "clamp";
		var filter;
		if(this._smooth) {
			filter = this._mipmap ? "linear,miplinear" : "linear";
		} else {
			filter = this._mipmap ? "nearest,mipnearest" : "nearest";
		}
		var code = "dp3 ft2.z, v0.xyz, v0.xyz\t\n" + "mul ft0, fc0, ft2.z\t\n" + "frc ft0, ft0\t\t\t\n" + "mul ft1, ft0.yzww, fc1\t\n";
		if(this._alphaThreshold > 0) {
			var format;
			switch(this._alphaMask.get_format()) {
			case 3:
				format = "dxt1,";
				break;
			case 4:
				format = "dxt5,";
				break;
			default:
				format = "";
			}
			code += "tex ft3, v1, fs0 <2d," + filter + "," + format + wrap + ">\n" + "sub ft3.w, ft3.w, fc2.x\n" + "kil ft3.w\n";
		}
		code += "sub oc, ft0, ft1\t\t\n";
		return code;
	}
	,render: function(renderable,stage3DProxy,camera,viewProjection) {
		var context = stage3DProxy._context3D;
		var pos = camera.get_scenePosition();
		this._vertexData.set(0,pos.x);
		this._vertexData.set(1,pos.y);
		this._vertexData.set(2,pos.z);
		this._vertexData.set(3,1);
		var sceneTransform = renderable.getRenderSceneTransform(camera);
		context.setProgramConstantsFromMatrix(1,5,sceneTransform,true);
		context.setProgramConstantsFromVector(1,9,this._vertexData,1);
		if(this._alphaThreshold > 0) {
			renderable.activateUVBuffer(1,stage3DProxy);
		}
		var matrix = away3d_core_math_Matrix3DUtils.CALCULATION_MATRIX;
		matrix.copyFrom(sceneTransform);
		matrix.append(viewProjection);
		context.setProgramConstantsFromMatrix(1,0,matrix,true);
		renderable.activateVertexBuffer(0,stage3DProxy);
		stage3DProxy.drawTriangles(renderable.getIndexBuffer(stage3DProxy),0,renderable.get_numTriangles());
	}
	,activate: function(stage3DProxy,camera) {
		var context = stage3DProxy._context3D;
		away3d_materials_passes_MaterialPassBase.prototype.activate.call(this,stage3DProxy,camera);
		var f = camera.get_lens().get_far();
		f = 1 / (2 * f * f);
		this._fragmentData.set(0,f);
		this._fragmentData.set(1,255.0 * f);
		this._fragmentData.set(2,65025.0 * f);
		this._fragmentData.set(3,16581375.0 * f);
		if(this._alphaThreshold > 0) {
			context.setTextureAt(0,this._alphaMask.getTextureForStage3D(stage3DProxy));
			context.setProgramConstantsFromVector(0,0,this._fragmentData,3);
		} else {
			context.setProgramConstantsFromVector(0,0,this._fragmentData,2);
		}
	}
	,__class__: away3d_materials_passes_DistanceMapPass
	,__properties__: $extend(away3d_materials_passes_MaterialPassBase.prototype.__properties__,{set_alphaMask:"set_alphaMask",get_alphaMask:"get_alphaMask",set_alphaThreshold:"set_alphaThreshold",get_alphaThreshold:"get_alphaThreshold"})
});
var away3d_materials_passes_SegmentPass = function(thickness) {
	this._constants = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,4,true);
	this._calcMatrix = new openfl_geom_Matrix3D();
	this._thickness = thickness;
	this._constants.set(1,0.00392156862745098);
	away3d_materials_passes_MaterialPassBase.call(this);
};
$hxClasses["away3d.materials.passes.SegmentPass"] = away3d_materials_passes_SegmentPass;
away3d_materials_passes_SegmentPass.__name__ = "away3d.materials.passes.SegmentPass";
away3d_materials_passes_SegmentPass.__super__ = away3d_materials_passes_MaterialPassBase;
away3d_materials_passes_SegmentPass.prototype = $extend(away3d_materials_passes_MaterialPassBase.prototype,{
	_constants: null
	,_calcMatrix: null
	,_thickness: null
	,getVertexCode: function() {
		return "m44 vt0, va0, vc8\t\t\t\n" + "m44 vt1, va1, vc8\t\t\t\n" + "sub vt2, vt1, vt0 \t\t\t\n" + "slt vt5.x, vt0.z, vc7.z\t\t\t\n" + "sub vt5.y, vc5.x, vt5.x\t\t\t\n" + "add vt4.x, vt0.z, vc7.z\t\t\t\n" + "sub vt4.y, vt0.z, vt1.z\t\t\t\n" + "seq vt4.z, vt4.y vc6.x\t\t\t\n" + "add vt4.y, vt4.y, vt4.z\t\t\t\n" + "div vt4.z, vt4.x, vt4.y\t\t\t\n" + "mul vt4.xyz, vt4.zzz, vt2.xyz\t\n" + "add vt3.xyz, vt0.xyz, vt4.xyz\t\n" + "mov vt3.w, vc5.x\t\t\t\n" + "mul vt0, vt0, vt5.yyyy\t\t\t\n" + "mul vt3, vt3, vt5.xxxx\t\t\t\n" + "add vt0, vt0, vt3\t\t\t\t\n" + "sub vt2, vt1, vt0 \t\t\t\n" + "nrm vt2.xyz, vt2.xyz\t\t\t\n" + "nrm vt5.xyz, vt0.xyz\t\t\t\n" + "mov vt5.w, vc5.x\t\t\t\t\n" + "crs vt3.xyz, vt2, vt5\t\t\t\n" + "nrm vt3.xyz, vt3.xyz\t\t\t\n" + "mul vt3.xyz, vt3.xyz, va2.xxx\t\n" + "mov vt3.w, vc5.x\t\t\t\n" + "dp3 vt4.x, vt0, vc6\t\t\t\n" + "mul vt4.x, vt4.x, vc7.x\t\t\t\n" + "mul vt3.xyz, vt3.xyz, vt4.xxx\t\n" + "add vt0.xyz, vt0.xyz, vt3.xyz\t\n" + "m44 op, vt0, vc0\t\t\t\n" + "mov v0, va3\t\t\t\t\n";
	}
	,getFragmentCode: function(animationCode) {
		return "mov oc, v0\n";
	}
	,render: function(renderable,stage3DProxy,camera,viewProjection) {
		var context = stage3DProxy._context3D;
		this._calcMatrix.copyFrom(renderable.get_sourceEntity().get_sceneTransform());
		this._calcMatrix.append(camera.get_inverseSceneTransform());
		var subSetCount = (js_Boot.__cast(renderable , away3d_entities_SegmentSet)).get_subSetCount();
		if((js_Boot.__cast(renderable , away3d_entities_SegmentSet)).get_hasData()) {
			var _g = 0;
			var _g1 = subSetCount;
			while(_g < _g1) {
				var i = _g++;
				renderable.activateVertexBuffer(i,stage3DProxy);
				context.setProgramConstantsFromMatrix(1,8,this._calcMatrix,true);
				stage3DProxy.drawTriangles(renderable.getIndexBuffer(stage3DProxy),0,renderable.get_numTriangles());
			}
		}
	}
	,activate: function(stage3DProxy,camera) {
		var context = stage3DProxy._context3D;
		away3d_materials_passes_MaterialPassBase.prototype.activate.call(this,stage3DProxy,camera);
		if(stage3DProxy.get_scissorRect() != null) {
			this._constants.set(0,this._thickness / Math.min(stage3DProxy.get_scissorRect().width,stage3DProxy.get_scissorRect().height));
		} else {
			this._constants.set(0,this._thickness / Math.min(stage3DProxy.get_width(),stage3DProxy.get_height()));
		}
		this._constants.set(2,camera.get_lens().get_near());
		context.setProgramConstantsFromVector(1,5,away3d_materials_passes_SegmentPass.ONE_VECTOR);
		context.setProgramConstantsFromVector(1,6,away3d_materials_passes_SegmentPass.FRONT_VECTOR);
		context.setProgramConstantsFromVector(1,7,this._constants);
		if(stage3DProxy.get_renderTarget() == null) {
			context.setProgramConstantsFromMatrix(1,0,camera.get_lens().get_matrix(),true);
		} else {
			this._calcMatrix.copyFrom(camera.get_lens().get_matrix());
			var rttBufferManager = away3d_core_managers_RTTBufferManager.getInstance(stage3DProxy);
			this._calcMatrix.appendScale(rttBufferManager.get_textureRatioX(),rttBufferManager.get_textureRatioY(),1);
			context.setProgramConstantsFromMatrix(1,0,this._calcMatrix,true);
		}
	}
	,deactivate: function(stage3DProxy) {
		var context = stage3DProxy._context3D;
		context.setVertexBufferAt(0,null);
		context.setVertexBufferAt(1,null);
		context.setVertexBufferAt(2,null);
		context.setVertexBufferAt(3,null);
	}
	,__class__: away3d_materials_passes_SegmentPass
});
var away3d_materials_passes_SuperShaderPass = function(material) {
	this._includeCasters = true;
	away3d_materials_passes_CompiledPass.call(this,material);
	this._needFragmentAnimation = true;
};
$hxClasses["away3d.materials.passes.SuperShaderPass"] = away3d_materials_passes_SuperShaderPass;
away3d_materials_passes_SuperShaderPass.__name__ = "away3d.materials.passes.SuperShaderPass";
away3d_materials_passes_SuperShaderPass.__super__ = away3d_materials_passes_CompiledPass;
away3d_materials_passes_SuperShaderPass.prototype = $extend(away3d_materials_passes_CompiledPass.prototype,{
	_includeCasters: null
	,_ignoreLights: null
	,createCompiler: function(profile) {
		return new away3d_materials_compilation_SuperShaderCompiler(profile);
	}
	,get_includeCasters: function() {
		return this._includeCasters;
	}
	,set_includeCasters: function(value) {
		if(this._includeCasters == value) {
			return value;
		}
		this._includeCasters = value;
		this.invalidateShaderProgram();
		return value;
	}
	,get_colorTransform: function() {
		if(this._methodSetup.get_colorTransformMethod() != null) {
			return this._methodSetup._colorTransformMethod.get_colorTransform();
		} else {
			return null;
		}
	}
	,set_colorTransform: function(value) {
		if(value != null) {
			if(this.get_colorTransformMethod() == null) {
				this.set_colorTransformMethod(new away3d_materials_methods_ColorTransformMethod());
			}
			this._methodSetup._colorTransformMethod.set_colorTransform(value);
		} else if(value == null) {
			if(this._methodSetup._colorTransformMethod != null) {
				this.set_colorTransformMethod(null);
			}
			this.set_colorTransformMethod(this._methodSetup._colorTransformMethod = null);
		}
		return value;
	}
	,get_colorTransformMethod: function() {
		return this._methodSetup.get_colorTransformMethod();
	}
	,set_colorTransformMethod: function(value) {
		this._methodSetup.set_colorTransformMethod(value);
		return value;
	}
	,addMethod: function(method) {
		this._methodSetup.addMethod(method);
	}
	,numMethods: null
	,get_numMethods: function() {
		return this._methodSetup.get_numMethods();
	}
	,hasMethod: function(method) {
		return this._methodSetup.hasMethod(method);
	}
	,getMethodAt: function(index) {
		return this._methodSetup.getMethodAt(index);
	}
	,addMethodAt: function(method,index) {
		this._methodSetup.addMethodAt(method,index);
	}
	,removeMethod: function(method) {
		this._methodSetup.removeMethod(method);
	}
	,updateLights: function() {
		if(this._lightPicker != null && !this._ignoreLights) {
			this._numPointLights = this._lightPicker.get_numPointLights();
			this._numDirectionalLights = this._lightPicker.get_numDirectionalLights();
			this._numLightProbes = this._lightPicker.get_numLightProbes();
			if(this._includeCasters) {
				this._numPointLights += this._lightPicker.get_numCastingPointLights();
				this._numDirectionalLights += this._lightPicker.get_numCastingDirectionalLights();
			}
		} else {
			this._numPointLights = 0;
			this._numDirectionalLights = 0;
			this._numLightProbes = 0;
		}
		this.invalidateShaderProgram();
	}
	,activate: function(stage3DProxy,camera) {
		away3d_materials_passes_CompiledPass.prototype.activate.call(this,stage3DProxy,camera);
		if(this._methodSetup._colorTransformMethod != null) {
			this._methodSetup._colorTransformMethod.activate(this._methodSetup._colorTransformMethodVO,stage3DProxy);
		}
		var methods = this._methodSetup._methods;
		var len = methods.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			var set = methods.get(i);
			set.method.activate(set.data,stage3DProxy);
		}
		if(this._cameraPositionIndex >= 0) {
			var pos = camera.get_scenePosition();
			this._vertexConstantData.set(this._cameraPositionIndex,pos.x);
			this._vertexConstantData.set(this._cameraPositionIndex + 1,pos.y);
			this._vertexConstantData.set(this._cameraPositionIndex + 2,pos.z);
		}
	}
	,deactivate: function(stage3DProxy) {
		away3d_materials_passes_CompiledPass.prototype.deactivate.call(this,stage3DProxy);
		if(this._methodSetup._colorTransformMethod != null) {
			this._methodSetup._colorTransformMethod.deactivate(this._methodSetup._colorTransformMethodVO,stage3DProxy);
		}
		var set;
		var methods = this._methodSetup._methods;
		var len = methods.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			set = methods.get(i);
			set.method.deactivate(set.data,stage3DProxy);
		}
	}
	,addPassesFromMethods: function() {
		away3d_materials_passes_CompiledPass.prototype.addPassesFromMethods.call(this);
		if(this._methodSetup._colorTransformMethod != null) {
			this.addPasses(this._methodSetup._colorTransformMethod.get_passes());
		}
		var methods = this._methodSetup._methods;
		var _g = 0;
		var _g1 = methods.get_length();
		while(_g < _g1) {
			var i = _g++;
			this.addPasses(methods.get(i).method.get_passes());
		}
	}
	,usesProbesForSpecular: function() {
		if(this._numLightProbes > 0) {
			return (this._specularLightSources & 2) != 0;
		} else {
			return false;
		}
	}
	,usesProbesForDiffuse: function() {
		if(this._numLightProbes > 0) {
			return (this._diffuseLightSources & 2) != 0;
		} else {
			return false;
		}
	}
	,updateMethodConstants: function() {
		away3d_materials_passes_CompiledPass.prototype.updateMethodConstants.call(this);
		if(this._methodSetup._colorTransformMethod != null) {
			this._methodSetup._colorTransformMethod.initConstants(this._methodSetup._colorTransformMethodVO);
		}
		var methods = this._methodSetup._methods;
		var len = methods.get_length();
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			methods.get(i).method.initConstants(methods.get(i).data);
		}
	}
	,updateLightConstants: function() {
		var dirLight;
		var pointLight;
		var i;
		var len;
		var dirPos;
		var total = 0;
		var numLightTypes = this._includeCasters ? 2 : 1;
		var k = this._lightFragmentConstantIndex;
		var _g = 0;
		var _g1 = numLightTypes;
		while(_g < _g1) {
			var caster = _g++;
			var dirLights = caster != 0 ? this._lightPicker.get_castingDirectionalLights() : this._lightPicker.get_directionalLights();
			len = dirLights.get_length();
			total += len;
			var _g2 = 0;
			var _g11 = len;
			while(_g2 < _g11) {
				var i1 = _g2++;
				dirLight = dirLights.get(i1);
				dirPos = dirLight.get_sceneDirection();
				this._ambientLightR += dirLight._ambientR;
				this._ambientLightG += dirLight._ambientG;
				this._ambientLightB += dirLight._ambientB;
				this._fragmentConstantData.set(k++,-dirPos.x);
				this._fragmentConstantData.set(k++,-dirPos.y);
				this._fragmentConstantData.set(k++,-dirPos.z);
				this._fragmentConstantData.set(k++,1);
				this._fragmentConstantData.set(k++,dirLight._diffuseR);
				this._fragmentConstantData.set(k++,dirLight._diffuseG);
				this._fragmentConstantData.set(k++,dirLight._diffuseB);
				this._fragmentConstantData.set(k++,1);
				this._fragmentConstantData.set(k++,dirLight._specularR);
				this._fragmentConstantData.set(k++,dirLight._specularG);
				this._fragmentConstantData.set(k++,dirLight._specularB);
				this._fragmentConstantData.set(k++,1);
			}
		}
		if(this._numDirectionalLights > total) {
			i = k + (this._numDirectionalLights - total) * 12;
			while(_$UInt_UInt_$Impl_$.gt(i,k)) this._fragmentConstantData.set(k++,0);
		}
		total = 0;
		var _g21 = 0;
		var _g3 = numLightTypes;
		while(_g21 < _g3) {
			var caster1 = _g21++;
			var pointLights = caster1 != 0 ? this._lightPicker.get_castingPointLights() : this._lightPicker.get_pointLights();
			len = pointLights.get_length();
			var _g22 = 0;
			var _g31 = len;
			while(_g22 < _g31) {
				var i2 = _g22++;
				pointLight = pointLights.get(i2);
				dirPos = pointLight.get_scenePosition();
				this._ambientLightR += pointLight._ambientR;
				this._ambientLightG += pointLight._ambientG;
				this._ambientLightB += pointLight._ambientB;
				this._fragmentConstantData.set(k++,dirPos.x);
				this._fragmentConstantData.set(k++,dirPos.y);
				this._fragmentConstantData.set(k++,dirPos.z);
				this._fragmentConstantData.set(k++,1);
				this._fragmentConstantData.set(k++,pointLight._diffuseR);
				this._fragmentConstantData.set(k++,pointLight._diffuseG);
				this._fragmentConstantData.set(k++,pointLight._diffuseB);
				this._fragmentConstantData.set(k++,pointLight._radius * pointLight._radius);
				this._fragmentConstantData.set(k++,pointLight._specularR);
				this._fragmentConstantData.set(k++,pointLight._specularG);
				this._fragmentConstantData.set(k++,pointLight._specularB);
				this._fragmentConstantData.set(k++,pointLight._fallOffFactor);
			}
		}
		if(this._numPointLights > total) {
			i = k + (total - this._numPointLights) * 12;
			while(_$UInt_UInt_$Impl_$.gt(i,k)) {
				this._fragmentConstantData.set(k,0);
				++k;
			}
		}
	}
	,updateProbes: function(stage3DProxy) {
		var probe;
		var lightProbes = this._lightPicker.get_lightProbes();
		var weights = this._lightPicker.get_lightProbeWeights();
		var len = lightProbes.get_length();
		var addDiff = this.usesProbesForDiffuse();
		var addSpec = this._methodSetup._specularMethod != null && this.usesProbesForSpecular();
		var context = stage3DProxy._context3D;
		if(!(addDiff || addSpec)) {
			return;
		}
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			probe = lightProbes.get(i);
			if(addDiff) {
				context.setTextureAt(this._lightProbeDiffuseIndices.get(i),probe.get_diffuseMap().getTextureForStage3D(stage3DProxy));
			}
			if(addSpec) {
				context.setTextureAt(this._lightProbeSpecularIndices.get(i),probe.get_specularMap().getTextureForStage3D(stage3DProxy));
			}
		}
		this._fragmentConstantData.set(this._probeWeightsIndex,weights.get(0));
		this._fragmentConstantData.set(this._probeWeightsIndex + 1,weights.get(1));
		this._fragmentConstantData.set(this._probeWeightsIndex + 2,weights.get(2));
		this._fragmentConstantData.set(this._probeWeightsIndex + 3,weights.get(3));
	}
	,set_ignoreLights: function(ignoreLights) {
		this._ignoreLights = ignoreLights;
		return this._ignoreLights;
	}
	,get_ignoreLights: function() {
		return this._ignoreLights;
	}
	,__class__: away3d_materials_passes_SuperShaderPass
	,__properties__: $extend(away3d_materials_passes_CompiledPass.prototype.__properties__,{set_ignoreLights:"set_ignoreLights",get_ignoreLights:"get_ignoreLights",get_numMethods:"get_numMethods",set_colorTransformMethod:"set_colorTransformMethod",get_colorTransformMethod:"get_colorTransformMethod",set_colorTransform:"set_colorTransform",get_colorTransform:"get_colorTransform",set_includeCasters:"set_includeCasters",get_includeCasters:"get_includeCasters"})
});
var away3d_materials_utils_DefaultMaterialManager = function() { };
$hxClasses["away3d.materials.utils.DefaultMaterialManager"] = away3d_materials_utils_DefaultMaterialManager;
away3d_materials_utils_DefaultMaterialManager.__name__ = "away3d.materials.utils.DefaultMaterialManager";
away3d_materials_utils_DefaultMaterialManager.getDefaultMaterial = function(renderable) {
	if(away3d_materials_utils_DefaultMaterialManager._defaultTexture == null) {
		away3d_materials_utils_DefaultMaterialManager.createDefaultTexture();
	}
	if(away3d_materials_utils_DefaultMaterialManager._defaultMaterial == null) {
		away3d_materials_utils_DefaultMaterialManager.createDefaultMaterial();
	}
	return away3d_materials_utils_DefaultMaterialManager._defaultMaterial;
};
away3d_materials_utils_DefaultMaterialManager.getDefaultTexture = function(renderable) {
	if(away3d_materials_utils_DefaultMaterialManager._defaultTexture == null) {
		away3d_materials_utils_DefaultMaterialManager.createDefaultTexture();
	}
	return away3d_materials_utils_DefaultMaterialManager._defaultTexture;
};
away3d_materials_utils_DefaultMaterialManager.createDefaultTexture = function() {
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData = new openfl_display_BitmapData(8,8,false,0);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(0,1,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(0,3,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(0,5,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(0,7,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(1,0,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(1,2,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(1,4,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(1,6,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(2,1,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(2,3,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(2,5,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(2,7,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(3,0,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(3,2,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(3,4,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(3,6,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(4,1,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(4,3,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(4,5,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(4,7,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(5,0,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(5,2,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(5,4,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(5,6,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(6,1,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(6,3,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(6,5,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(6,7,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(7,0,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(7,2,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(7,4,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData.setPixel(7,6,16777215);
	away3d_materials_utils_DefaultMaterialManager._defaultTexture = new away3d_textures_BitmapTexture(away3d_materials_utils_DefaultMaterialManager._defaultTextureBitmapData);
	away3d_materials_utils_DefaultMaterialManager._defaultTexture.set_name("defaultTexture");
};
away3d_materials_utils_DefaultMaterialManager.createDefaultMaterial = function() {
	away3d_materials_utils_DefaultMaterialManager._defaultMaterial = new away3d_materials_TextureMaterial(away3d_materials_utils_DefaultMaterialManager._defaultTexture);
	away3d_materials_utils_DefaultMaterialManager._defaultMaterial.set_mipmap(false);
	away3d_materials_utils_DefaultMaterialManager._defaultMaterial.set_smooth(false);
	away3d_materials_utils_DefaultMaterialManager._defaultMaterial.set_name("defaultMaterial");
};
var away3d_materials_utils_MipmapGenerator = function() { };
$hxClasses["away3d.materials.utils.MipmapGenerator"] = away3d_materials_utils_MipmapGenerator;
away3d_materials_utils_MipmapGenerator.__name__ = "away3d.materials.utils.MipmapGenerator";
away3d_materials_utils_MipmapGenerator.generateMipMaps = function(source,target,mipmap,alpha,side) {
	if(side == null) {
		side = -1;
	}
	if(alpha == null) {
		alpha = false;
	}
	var w = source.width;
	var h = source.height;
	var i = 0;
	var regen = mipmap != null;
	if(mipmap == null) {
		mipmap = new openfl_display_BitmapData(w,h,alpha);
	}
	away3d_materials_utils_MipmapGenerator._rect.width = _$UInt_UInt_$Impl_$.toFloat(w);
	away3d_materials_utils_MipmapGenerator._rect.height = _$UInt_UInt_$Impl_$.toFloat(h);
	while(_$UInt_UInt_$Impl_$.gte(w,1) || _$UInt_UInt_$Impl_$.gte(h,1)) {
		if(alpha) {
			mipmap.fillRect(away3d_materials_utils_MipmapGenerator._rect,0);
		}
		away3d_materials_utils_MipmapGenerator._matrix.a = away3d_materials_utils_MipmapGenerator._rect.width / source.width;
		away3d_materials_utils_MipmapGenerator._matrix.d = away3d_materials_utils_MipmapGenerator._rect.height / source.height;
		mipmap.draw(source,away3d_materials_utils_MipmapGenerator._matrix,null,null,null,true);
		if(((target) instanceof openfl_display3D_textures_Texture)) {
			(js_Boot.__cast(target , openfl_display3D_textures_Texture)).uploadFromBitmapData(mipmap,i++);
		} else {
			(js_Boot.__cast(target , openfl_display3D_textures_CubeTexture)).uploadFromBitmapData(mipmap,side,i++);
		}
		w = w >>> 1;
		h = h >>> 1;
		var tmp = _$UInt_UInt_$Impl_$.gt(w,1) ? _$UInt_UInt_$Impl_$.toFloat(w) : 1;
		away3d_materials_utils_MipmapGenerator._rect.width = tmp;
		var tmp1 = _$UInt_UInt_$Impl_$.gt(h,1) ? _$UInt_UInt_$Impl_$.toFloat(h) : 1;
		away3d_materials_utils_MipmapGenerator._rect.height = tmp1;
	}
	if(!regen) {
		mipmap.dispose();
	}
};
var away3d_primitives_PrimitiveBase = function() {
	this._uvDirty = true;
	this._geomDirty = true;
	away3d_core_base_Geometry.call(this);
	this._subGeometry = new away3d_core_base_CompactSubGeometry();
	this._subGeometry.set_autoGenerateDummyUVs(false);
	this.addSubGeometry(this._subGeometry);
};
$hxClasses["away3d.primitives.PrimitiveBase"] = away3d_primitives_PrimitiveBase;
away3d_primitives_PrimitiveBase.__name__ = "away3d.primitives.PrimitiveBase";
away3d_primitives_PrimitiveBase.__super__ = away3d_core_base_Geometry;
away3d_primitives_PrimitiveBase.prototype = $extend(away3d_core_base_Geometry.prototype,{
	_geomDirty: null
	,_uvDirty: null
	,_subGeometry: null
	,get_subGeometries: function() {
		if(this._geomDirty) {
			this.updateGeometry();
		}
		if(this._uvDirty) {
			this.updateUVs();
		}
		return away3d_core_base_Geometry.prototype.get_subGeometries.call(this);
	}
	,clone: function() {
		if(this._geomDirty) {
			this.updateGeometry();
		}
		if(this._uvDirty) {
			this.updateUVs();
		}
		return away3d_core_base_Geometry.prototype.clone.call(this);
	}
	,scale: function(scale) {
		if(this._geomDirty) {
			this.updateGeometry();
		}
		away3d_core_base_Geometry.prototype.scale.call(this,scale);
	}
	,scaleUV: function(scaleU,scaleV) {
		if(scaleV == null) {
			scaleV = 1;
		}
		if(scaleU == null) {
			scaleU = 1;
		}
		if(this._uvDirty) {
			this.updateUVs();
		}
		away3d_core_base_Geometry.prototype.scaleUV.call(this,scaleU,scaleV);
	}
	,applyTransformation: function(transform) {
		if(this._geomDirty) {
			this.updateGeometry();
		}
		away3d_core_base_Geometry.prototype.applyTransformation.call(this,transform);
	}
	,buildGeometry: function(target) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,buildUVs: function(target) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,invalidateGeometry: function() {
		this._geomDirty = true;
	}
	,invalidateUVs: function() {
		this._uvDirty = true;
	}
	,updateGeometry: function() {
		this.buildGeometry(this._subGeometry);
		this._geomDirty = false;
	}
	,updateUVs: function() {
		this.buildUVs(this._subGeometry);
		this._uvDirty = false;
	}
	,validate: function() {
		if(this._geomDirty) {
			this.updateGeometry();
		}
		if(this._uvDirty) {
			this.updateUVs();
		}
	}
	,__class__: away3d_primitives_PrimitiveBase
});
var away3d_primitives_CubeGeometry = function(width,height,depth,segmentsW,segmentsH,segmentsD,tile6) {
	if(tile6 == null) {
		tile6 = true;
	}
	if(segmentsD == null) {
		segmentsD = 1;
	}
	if(segmentsH == null) {
		segmentsH = 1;
	}
	if(segmentsW == null) {
		segmentsW = 1;
	}
	if(depth == null) {
		depth = 100;
	}
	if(height == null) {
		height = 100;
	}
	if(width == null) {
		width = 100;
	}
	away3d_primitives_PrimitiveBase.call(this);
	this._width = width;
	this._height = height;
	this._depth = depth;
	this._segmentsW = segmentsW;
	this._segmentsH = segmentsH;
	this._segmentsD = segmentsD;
	this._tile6 = tile6;
};
$hxClasses["away3d.primitives.CubeGeometry"] = away3d_primitives_CubeGeometry;
away3d_primitives_CubeGeometry.__name__ = "away3d.primitives.CubeGeometry";
away3d_primitives_CubeGeometry.__super__ = away3d_primitives_PrimitiveBase;
away3d_primitives_CubeGeometry.prototype = $extend(away3d_primitives_PrimitiveBase.prototype,{
	_width: null
	,_height: null
	,_depth: null
	,_tile6: null
	,_segmentsW: null
	,_segmentsH: null
	,_segmentsD: null
	,get_width: function() {
		return this._width;
	}
	,set_width: function(value) {
		this._width = value;
		this.invalidateGeometry();
		return value;
	}
	,get_height: function() {
		return this._height;
	}
	,set_height: function(value) {
		this._height = value;
		this.invalidateGeometry();
		return value;
	}
	,get_depth: function() {
		return this._depth;
	}
	,set_depth: function(value) {
		this._depth = value;
		this.invalidateGeometry();
		return value;
	}
	,get_tile6: function() {
		return this._tile6;
	}
	,set_tile6: function(value) {
		this._tile6 = value;
		this.invalidateUVs();
		return value;
	}
	,get_segmentsW: function() {
		return this._segmentsW;
	}
	,set_segmentsW: function(value) {
		this._segmentsW = value;
		this.invalidateGeometry();
		this.invalidateUVs();
		return value;
	}
	,get_segmentsH: function() {
		return this._segmentsH;
	}
	,set_segmentsH: function(value) {
		this._segmentsH = value;
		this.invalidateGeometry();
		this.invalidateUVs();
		return value;
	}
	,get_segmentsD: function() {
		return this._segmentsD;
	}
	,set_segmentsD: function(value) {
		this._segmentsD = value;
		this.invalidateGeometry();
		this.invalidateUVs();
		return value;
	}
	,buildGeometry: function(target) {
		var data;
		var indices;
		var tl = 0;
		var tr = 0;
		var bl = 0;
		var br = 0;
		var i = 0;
		var j = 0;
		var inc = 0;
		var vidx = 0;
		var fidx = 0;
		var hw = 0;
		var hh = 0;
		var hd = 0;
		var dw = 0;
		var dh = 0;
		var dd = 0;
		var outer_pos;
		var numVerts = ((this._segmentsW + 1) * (this._segmentsH + 1) + (this._segmentsW + 1) * (this._segmentsD + 1) + (this._segmentsH + 1) * (this._segmentsD + 1)) * 2;
		var stride = target.get_vertexStride();
		var skip = stride - 9;
		if(numVerts == target.get_numVertices()) {
			data = target.get_vertexData();
			indices = target.get_indexData();
			if(indices == null) {
				indices = openfl__$Vector_Vector_$Impl_$.toIntVector(null,(this._segmentsW * this._segmentsH + this._segmentsW * this._segmentsD + this._segmentsH * this._segmentsD) * 12,true);
			}
		} else {
			data = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,numVerts * stride,true);
			indices = openfl__$Vector_Vector_$Impl_$.toIntVector(null,(this._segmentsW * this._segmentsH + this._segmentsW * this._segmentsD + this._segmentsH * this._segmentsD) * 12,true);
			this.invalidateUVs();
		}
		vidx = target.get_vertexOffset();
		fidx = 0;
		hw = this._width / 2;
		hh = this._height / 2;
		hd = this._depth / 2;
		dw = this._width / this._segmentsW;
		dh = this._height / this._segmentsH;
		dd = this._depth / this._segmentsD;
		var _g = 0;
		var _g1 = this._segmentsW + 1;
		while(_g < _g1) {
			var i1 = _g++;
			outer_pos = -hw + i1 * dw;
			var _g2 = 0;
			var _g11 = this._segmentsH + 1;
			while(_g2 < _g11) {
				var j1 = _g2++;
				data.set(vidx++,outer_pos);
				data.set(vidx++,-hh + j1 * dh);
				data.set(vidx++,-hd);
				data.set(vidx++,0);
				data.set(vidx++,0);
				data.set(vidx++,-1);
				data.set(vidx++,1);
				data.set(vidx++,0);
				data.set(vidx++,0);
				vidx += skip;
				data.set(vidx++,outer_pos);
				data.set(vidx++,-hh + j1 * dh);
				data.set(vidx++,hd);
				data.set(vidx++,0);
				data.set(vidx++,0);
				data.set(vidx++,1);
				data.set(vidx++,-1);
				data.set(vidx++,0);
				data.set(vidx++,0);
				vidx += skip;
				if(i1 > 0 && j1 > 0) {
					tl = 2 * ((i1 - 1) * (this._segmentsH + 1) + (j1 - 1)) | 0;
					tr = 2 * (i1 * (this._segmentsH + 1) + (j1 - 1)) | 0;
					bl = tl + 2;
					br = tr + 2;
					indices.set(fidx++,tl);
					indices.set(fidx++,bl);
					indices.set(fidx++,br);
					indices.set(fidx++,tl);
					indices.set(fidx++,br);
					indices.set(fidx++,tr);
					indices.set(fidx++,tr + 1);
					indices.set(fidx++,br + 1);
					indices.set(fidx++,bl + 1);
					indices.set(fidx++,tr + 1);
					indices.set(fidx++,bl + 1);
					indices.set(fidx++,tl + 1);
				}
			}
		}
		inc += 2 * (this._segmentsW + 1) * (this._segmentsH + 1) | 0;
		var _g21 = 0;
		var _g3 = this._segmentsW + 1;
		while(_g21 < _g3) {
			var i2 = _g21++;
			outer_pos = -hw + i2 * dw;
			var _g22 = 0;
			var _g31 = this._segmentsD + 1;
			while(_g22 < _g31) {
				var j2 = _g22++;
				data.set(vidx++,outer_pos);
				data.set(vidx++,hh);
				data.set(vidx++,-hd + j2 * dd);
				data.set(vidx++,0);
				data.set(vidx++,1);
				data.set(vidx++,0);
				data.set(vidx++,1);
				data.set(vidx++,0);
				data.set(vidx++,0);
				vidx += skip;
				data.set(vidx++,outer_pos);
				data.set(vidx++,-hh);
				data.set(vidx++,-hd + j2 * dd);
				data.set(vidx++,0);
				data.set(vidx++,-1);
				data.set(vidx++,0);
				data.set(vidx++,1);
				data.set(vidx++,0);
				data.set(vidx++,0);
				vidx += skip;
				if(i2 > 0 && j2 > 0) {
					tl = inc + 2 * ((i2 - 1) * (this._segmentsD + 1) + (j2 - 1)) | 0;
					tr = inc + 2 * (i2 * (this._segmentsD + 1) + (j2 - 1)) | 0;
					bl = tl + 2;
					br = tr + 2;
					indices.set(fidx++,tl);
					indices.set(fidx++,bl);
					indices.set(fidx++,br);
					indices.set(fidx++,tl);
					indices.set(fidx++,br);
					indices.set(fidx++,tr);
					indices.set(fidx++,tr + 1);
					indices.set(fidx++,br + 1);
					indices.set(fidx++,bl + 1);
					indices.set(fidx++,tr + 1);
					indices.set(fidx++,bl + 1);
					indices.set(fidx++,tl + 1);
				}
			}
		}
		inc += 2 * (this._segmentsW + 1) * (this._segmentsD + 1) | 0;
		var _g4 = 0;
		var _g5 = this._segmentsD + 1;
		while(_g4 < _g5) {
			var i3 = _g4++;
			outer_pos = hd - i3 * dd;
			var _g41 = 0;
			var _g51 = this._segmentsH + 1;
			while(_g41 < _g51) {
				var j3 = _g41++;
				data.set(vidx++,-hw);
				data.set(vidx++,-hh + j3 * dh);
				data.set(vidx++,outer_pos);
				data.set(vidx++,-1);
				data.set(vidx++,0);
				data.set(vidx++,0);
				data.set(vidx++,0);
				data.set(vidx++,0);
				data.set(vidx++,-1);
				vidx += skip;
				data.set(vidx++,hw);
				data.set(vidx++,-hh + j3 * dh);
				data.set(vidx++,outer_pos);
				data.set(vidx++,1);
				data.set(vidx++,0);
				data.set(vidx++,0);
				data.set(vidx++,0);
				data.set(vidx++,0);
				data.set(vidx++,1);
				vidx += skip;
				if(i3 > 0 && j3 > 0) {
					tl = inc + 2 * ((i3 - 1) * (this._segmentsH + 1) + (j3 - 1)) | 0;
					tr = inc + 2 * (i3 * (this._segmentsH + 1) + (j3 - 1)) | 0;
					bl = tl + 2;
					br = tr + 2;
					indices.set(fidx++,tl);
					indices.set(fidx++,bl);
					indices.set(fidx++,br);
					indices.set(fidx++,tl);
					indices.set(fidx++,br);
					indices.set(fidx++,tr);
					indices.set(fidx++,tr + 1);
					indices.set(fidx++,br + 1);
					indices.set(fidx++,bl + 1);
					indices.set(fidx++,tr + 1);
					indices.set(fidx++,bl + 1);
					indices.set(fidx++,tl + 1);
				}
			}
		}
		target.updateData(data);
		target.updateIndexData(indices);
	}
	,buildUVs: function(target) {
		var i = 0;
		var j = 0;
		var data;
		var u_tile_dim;
		var v_tile_dim;
		var u_tile_step;
		var v_tile_step;
		var stride = target.get_UVStride();
		var numUvs = ((this._segmentsW + 1) * (this._segmentsH + 1) + (this._segmentsW + 1) * (this._segmentsD + 1) + (this._segmentsH + 1) * (this._segmentsD + 1)) * 2 * stride | 0;
		var skip = stride - 2;
		if(target.get_UVData() != null && numUvs == target.get_UVData().get_length()) {
			data = target.get_UVData();
		} else {
			data = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,numUvs,true);
			this.invalidateGeometry();
		}
		if(this._tile6) {
			u_tile_step = 0.333333333333333315;
			u_tile_dim = u_tile_step;
			v_tile_step = 0.5;
			v_tile_dim = v_tile_step;
		} else {
			v_tile_dim = 1;
			u_tile_dim = v_tile_dim;
			v_tile_step = 0;
			u_tile_step = v_tile_step;
		}
		var uidx = target.get_UVOffset();
		var tl0u = u_tile_step;
		var tl0v = v_tile_step;
		var tl1u = 2 * u_tile_step;
		var tl1v = 0 * v_tile_step;
		var du = u_tile_dim / this._segmentsW;
		var dv = v_tile_dim / this._segmentsH;
		var _g = 0;
		var _g1 = this._segmentsW + 1;
		while(_g < _g1) {
			var i1 = _g++;
			var _g2 = 0;
			var _g11 = this._segmentsH + 1;
			while(_g2 < _g11) {
				var j1 = _g2++;
				data.set(uidx++,(tl0u + i1 * du) * target.get_scaleU());
				data.set(uidx++,(tl0v + (v_tile_dim - j1 * dv)) * target.get_scaleV());
				uidx += skip;
				data.set(uidx++,(tl1u + (u_tile_dim - i1 * du)) * target.get_scaleU());
				data.set(uidx++,(tl1v + (v_tile_dim - j1 * dv)) * target.get_scaleV());
				uidx += skip;
			}
		}
		tl0u = u_tile_step;
		tl0v = 0 * v_tile_step;
		tl1u = 0 * u_tile_step;
		tl1v = 0 * v_tile_step;
		du = u_tile_dim / this._segmentsW;
		dv = v_tile_dim / this._segmentsD;
		var _g21 = 0;
		var _g3 = this._segmentsW + 1;
		while(_g21 < _g3) {
			var i2 = _g21++;
			var _g22 = 0;
			var _g31 = this._segmentsD + 1;
			while(_g22 < _g31) {
				var j2 = _g22++;
				data.set(uidx++,(tl0u + i2 * du) * target.get_scaleU());
				data.set(uidx++,(tl0v + (v_tile_dim - j2 * dv)) * target.get_scaleV());
				uidx += skip;
				data.set(uidx++,(tl1u + i2 * du) * target.get_scaleU());
				data.set(uidx++,(tl1v + j2 * dv) * target.get_scaleV());
				uidx += skip;
			}
		}
		tl0u = 0 * u_tile_step;
		tl0v = v_tile_step;
		tl1u = 2 * u_tile_step;
		tl1v = v_tile_step;
		du = u_tile_dim / this._segmentsD;
		dv = v_tile_dim / this._segmentsH;
		var _g4 = 0;
		var _g5 = this._segmentsD + 1;
		while(_g4 < _g5) {
			var i3 = _g4++;
			var _g41 = 0;
			var _g51 = this._segmentsH + 1;
			while(_g41 < _g51) {
				var j3 = _g41++;
				data.set(uidx++,(tl0u + i3 * du) * target.get_scaleU());
				data.set(uidx++,(tl0v + (v_tile_dim - j3 * dv)) * target.get_scaleV());
				uidx += skip;
				data.set(uidx++,(tl1u + (u_tile_dim - i3 * du)) * target.get_scaleU());
				data.set(uidx++,(tl1v + (v_tile_dim - j3 * dv)) * target.get_scaleV());
				uidx += skip;
			}
		}
		target.updateData(data);
	}
	,__class__: away3d_primitives_CubeGeometry
	,__properties__: $extend(away3d_primitives_PrimitiveBase.prototype.__properties__,{set_segmentsD:"set_segmentsD",get_segmentsD:"get_segmentsD",set_segmentsH:"set_segmentsH",get_segmentsH:"get_segmentsH",set_segmentsW:"set_segmentsW",get_segmentsW:"get_segmentsW",set_tile6:"set_tile6",get_tile6:"get_tile6",set_depth:"set_depth",get_depth:"get_depth",set_height:"set_height",get_height:"get_height",set_width:"set_width",get_width:"get_width"})
});
var away3d_primitives_data_Segment = function(start,end,anchor,colorStart,colorEnd,thickness) {
	if(thickness == null) {
		thickness = 1;
	}
	if(colorEnd == null) {
		colorEnd = 3355443;
	}
	if(colorStart == null) {
		colorStart = 3355443;
	}
	this._subSetIndex = -1;
	this._index = -1;
	anchor = null;
	this._thickness = thickness * .5;
	this._start = start;
	this._end = end;
	this.set_startColor(colorStart);
	this.set_endColor(colorEnd);
};
$hxClasses["away3d.primitives.data.Segment"] = away3d_primitives_data_Segment;
away3d_primitives_data_Segment.__name__ = "away3d.primitives.data.Segment";
away3d_primitives_data_Segment.prototype = {
	_segmentsBase: null
	,_thickness: null
	,_start: null
	,_end: null
	,_startR: null
	,_startG: null
	,_startB: null
	,_endR: null
	,_endG: null
	,_endB: null
	,_index: null
	,_subSetIndex: null
	,_startColor: null
	,_endColor: null
	,updateSegment: function(start,end,anchor,colorStart,colorEnd,thickness) {
		if(thickness == null) {
			thickness = 1;
		}
		if(colorEnd == null) {
			colorEnd = 3355443;
		}
		if(colorStart == null) {
			colorStart = 3355443;
		}
		anchor = null;
		this._start = start;
		this._end = end;
		if(this._startColor != colorStart) {
			this.set_startColor(colorStart);
		}
		if(this._endColor != colorEnd) {
			this.set_endColor(colorEnd);
		}
		this._thickness = thickness * .5;
		this.update();
	}
	,get_start: function() {
		return this._start;
	}
	,set_start: function(value) {
		this._start = value;
		this.update();
		return value;
	}
	,get_end: function() {
		return this._end;
	}
	,set_end: function(value) {
		this._end = value;
		this.update();
		return value;
	}
	,get_thickness: function() {
		return this._thickness * 2;
	}
	,set_thickness: function(value) {
		this._thickness = value * .5;
		this.update();
		return value;
	}
	,get_startColor: function() {
		return this._startColor;
	}
	,set_startColor: function(color) {
		this._startR = (color >> 16 & 255) / 255;
		this._startG = (color >> 8 & 255) / 255;
		this._startB = (color & 255) / 255;
		this._startColor = color;
		this.update();
		return color;
	}
	,get_endColor: function() {
		return this._endColor;
	}
	,set_endColor: function(color) {
		this._endR = (color >> 16 & 255) / 255;
		this._endG = (color >> 8 & 255) / 255;
		this._endB = (color & 255) / 255;
		this._endColor = color;
		this.update();
		return color;
	}
	,dispose: function() {
		this._start = null;
		this._end = null;
	}
	,get_index: function() {
		return this._index;
	}
	,set_index: function(ind) {
		this._index = ind;
		return ind;
	}
	,get_subSetIndex: function() {
		return this._subSetIndex;
	}
	,set_subSetIndex: function(ind) {
		this._subSetIndex = ind;
		return ind;
	}
	,set_segmentsBase: function(segBase) {
		this._segmentsBase = segBase;
		return segBase;
	}
	,update: function() {
		if(this._segmentsBase == null) {
			return;
		}
		this._segmentsBase.updateSegment(this);
	}
	,__class__: away3d_primitives_data_Segment
	,__properties__: {set_segmentsBase:"set_segmentsBase",set_subSetIndex:"set_subSetIndex",get_subSetIndex:"get_subSetIndex",set_index:"set_index",get_index:"get_index",set_endColor:"set_endColor",get_endColor:"get_endColor",set_startColor:"set_startColor",get_startColor:"get_startColor",set_thickness:"set_thickness",get_thickness:"get_thickness",set_end:"set_end",get_end:"get_end",set_start:"set_start",get_start:"get_start"}
};
var away3d_primitives_LineSegment = function(v0,v1,color0,color1,thickness) {
	if(thickness == null) {
		thickness = 1;
	}
	if(color1 == null) {
		color1 = 3355443;
	}
	if(color0 == null) {
		color0 = 3355443;
	}
	away3d_primitives_data_Segment.call(this,v0,v1,null,color0,color1,thickness);
};
$hxClasses["away3d.primitives.LineSegment"] = away3d_primitives_LineSegment;
away3d_primitives_LineSegment.__name__ = "away3d.primitives.LineSegment";
away3d_primitives_LineSegment.__super__ = away3d_primitives_data_Segment;
away3d_primitives_LineSegment.prototype = $extend(away3d_primitives_data_Segment.prototype,{
	__class__: away3d_primitives_LineSegment
});
var away3d_primitives_PlaneGeometry = function(width,height,segmentsW,segmentsH,yUp,doubleSided) {
	if(doubleSided == null) {
		doubleSided = false;
	}
	if(yUp == null) {
		yUp = true;
	}
	if(segmentsH == null) {
		segmentsH = 1;
	}
	if(segmentsW == null) {
		segmentsW = 1;
	}
	if(height == null) {
		height = 100;
	}
	if(width == null) {
		width = 100;
	}
	away3d_primitives_PrimitiveBase.call(this);
	this._segmentsW = segmentsW;
	this._segmentsH = segmentsH;
	this._yUp = yUp;
	this._width = width;
	this._height = height;
	this._doubleSided = doubleSided;
};
$hxClasses["away3d.primitives.PlaneGeometry"] = away3d_primitives_PlaneGeometry;
away3d_primitives_PlaneGeometry.__name__ = "away3d.primitives.PlaneGeometry";
away3d_primitives_PlaneGeometry.__super__ = away3d_primitives_PrimitiveBase;
away3d_primitives_PlaneGeometry.prototype = $extend(away3d_primitives_PrimitiveBase.prototype,{
	_segmentsW: null
	,_segmentsH: null
	,_yUp: null
	,_width: null
	,_height: null
	,_doubleSided: null
	,get_segmentsW: function() {
		return this._segmentsW;
	}
	,set_segmentsW: function(value) {
		this._segmentsW = value;
		this.invalidateGeometry();
		this.invalidateUVs();
		return value;
	}
	,get_segmentsH: function() {
		return this._segmentsH;
	}
	,set_segmentsH: function(value) {
		this._segmentsH = value;
		this.invalidateGeometry();
		this.invalidateUVs();
		return value;
	}
	,get_yUp: function() {
		return this._yUp;
	}
	,set_yUp: function(value) {
		this._yUp = value;
		this.invalidateGeometry();
		return value;
	}
	,get_doubleSided: function() {
		return this._doubleSided;
	}
	,set_doubleSided: function(value) {
		this._doubleSided = value;
		this.invalidateGeometry();
		return value;
	}
	,get_width: function() {
		return this._width;
	}
	,set_width: function(value) {
		this._width = value;
		this.invalidateGeometry();
		return value;
	}
	,get_height: function() {
		return this._height;
	}
	,set_height: function(value) {
		this._height = value;
		this.invalidateGeometry();
		return value;
	}
	,buildGeometry: function(target) {
		var data;
		var indices;
		var x;
		var y;
		var base;
		var tw = this._segmentsW + 1;
		var numVertices = (this._segmentsH + 1) * tw;
		var stride = target.get_vertexStride();
		var skip = stride - 9;
		if(this._doubleSided) {
			numVertices *= 2;
		}
		var numIndices = this._segmentsH * this._segmentsW * 6;
		if(this._doubleSided) {
			numIndices <<= 1;
		}
		if(numVertices == target.get_numVertices()) {
			data = target.get_vertexData();
			indices = target.get_indexData();
			if(indices == null) {
				indices = openfl__$Vector_Vector_$Impl_$.toIntVector(null,numIndices,true);
			}
		} else {
			data = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,numVertices * stride,true);
			indices = openfl__$Vector_Vector_$Impl_$.toIntVector(null,numIndices,true);
			this.invalidateUVs();
		}
		numIndices = 0;
		var index = target.get_vertexOffset();
		var _g = 0;
		var _g1 = this._segmentsH + 1;
		while(_g < _g1) {
			var yi = _g++;
			var _g2 = 0;
			var _g11 = this._segmentsW + 1;
			while(_g2 < _g11) {
				var xi = _g2++;
				x = (xi / this._segmentsW - .5) * this._width;
				y = (yi / this._segmentsH - .5) * this._height;
				data.set(index++,x);
				if(this._yUp) {
					data.set(index++,0);
					data.set(index++,y);
				} else {
					data.set(index++,y);
					data.set(index++,0);
				}
				data.set(index++,0);
				if(this._yUp) {
					data.set(index++,1);
					data.set(index++,0);
				} else {
					data.set(index++,0);
					data.set(index++,-1);
				}
				data.set(index++,1);
				data.set(index++,0);
				data.set(index++,0);
				index += skip;
				if(this._doubleSided) {
					data.set(index,data.get(index - stride));
					++index;
					data.set(index,data.get(index - stride));
					++index;
					data.set(index,data.get(index - stride));
					++index;
					data.set(index,-data.get(index - stride));
					++index;
					data.set(index,-data.get(index - stride));
					++index;
					data.set(index,-data.get(index - stride));
					++index;
					data.set(index,-data.get(index - stride));
					++index;
					data.set(index,-data.get(index - stride));
					++index;
					data.set(index,-data.get(index - stride));
					++index;
					index += skip;
				}
				if(xi != this._segmentsW && yi != this._segmentsH) {
					base = xi + yi * tw;
					var mult = this._doubleSided ? 2 : 1;
					indices.set(numIndices++,base * mult);
					indices.set(numIndices++,(base + tw) * mult);
					indices.set(numIndices++,(base + tw + 1) * mult);
					indices.set(numIndices++,base * mult);
					indices.set(numIndices++,(base + tw + 1) * mult);
					indices.set(numIndices++,(base + 1) * mult);
					if(this._doubleSided) {
						indices.set(numIndices++,(base + tw + 1) * mult + 1);
						indices.set(numIndices++,(base + tw) * mult + 1);
						indices.set(numIndices++,base * mult + 1);
						indices.set(numIndices++,(base + 1) * mult + 1);
						indices.set(numIndices++,(base + tw + 1) * mult + 1);
						indices.set(numIndices++,base * mult + 1);
					}
				}
			}
		}
		target.updateData(data);
		target.updateIndexData(indices);
	}
	,buildUVs: function(target) {
		var data;
		var stride = target.get_UVStride();
		var numUvs = (this._segmentsH + 1) * (this._segmentsW + 1) * stride;
		var skip = stride - 2;
		if(this._doubleSided) {
			numUvs *= 2;
		}
		if(target.get_UVData() != null && numUvs == target.get_UVData().get_length()) {
			data = target.get_UVData();
		} else {
			data = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,numUvs,true);
			this.invalidateGeometry();
		}
		var index = target.get_UVOffset();
		var _g = 0;
		var _g1 = this._segmentsH + 1;
		while(_g < _g1) {
			var yi = _g++;
			var _g2 = 0;
			var _g11 = this._segmentsW + 1;
			while(_g2 < _g11) {
				var xi = _g2++;
				data.set(index++,xi / this._segmentsW * target.get_scaleU());
				data.set(index++,(1 - yi / this._segmentsH) * target.get_scaleV());
				index += skip;
				if(this._doubleSided) {
					data.set(index++,xi / this._segmentsW * target.get_scaleU());
					data.set(index++,(1 - yi / this._segmentsH) * target.get_scaleV());
					index += skip;
				}
			}
		}
		target.updateData(data);
	}
	,__class__: away3d_primitives_PlaneGeometry
	,__properties__: $extend(away3d_primitives_PrimitiveBase.prototype.__properties__,{set_height:"set_height",get_height:"get_height",set_width:"set_width",get_width:"get_width",set_doubleSided:"set_doubleSided",get_doubleSided:"get_doubleSided",set_yUp:"set_yUp",get_yUp:"get_yUp",set_segmentsH:"set_segmentsH",get_segmentsH:"get_segmentsH",set_segmentsW:"set_segmentsW",get_segmentsW:"get_segmentsW"})
});
var away3d_primitives_SphereGeometry = function(radius,segmentsW,segmentsH,yUp) {
	if(yUp == null) {
		yUp = true;
	}
	if(segmentsH == null) {
		segmentsH = 12;
	}
	if(segmentsW == null) {
		segmentsW = 16;
	}
	if(radius == null) {
		radius = 50;
	}
	away3d_primitives_PrimitiveBase.call(this);
	this._radius = radius;
	this._segmentsW = segmentsW;
	this._segmentsH = segmentsH;
	this._yUp = yUp;
};
$hxClasses["away3d.primitives.SphereGeometry"] = away3d_primitives_SphereGeometry;
away3d_primitives_SphereGeometry.__name__ = "away3d.primitives.SphereGeometry";
away3d_primitives_SphereGeometry.__super__ = away3d_primitives_PrimitiveBase;
away3d_primitives_SphereGeometry.prototype = $extend(away3d_primitives_PrimitiveBase.prototype,{
	_radius: null
	,_segmentsW: null
	,_segmentsH: null
	,_yUp: null
	,buildGeometry: function(target) {
		var vertices;
		var indices;
		var i = 0;
		var j = 0;
		var triIndex = 0;
		var numVerts = (this._segmentsH + 1) * (this._segmentsW + 1);
		var stride = target.get_vertexStride();
		var skip = stride - 9;
		if(numVerts == target.get_numVertices()) {
			vertices = target.get_vertexData();
			indices = target.get_indexData();
			if(indices == null) {
				indices = openfl__$Vector_Vector_$Impl_$.toIntVector(null,(this._segmentsH - 1) * this._segmentsW * 6);
			}
		} else {
			vertices = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,numVerts * stride,true);
			indices = openfl__$Vector_Vector_$Impl_$.toIntVector(null,(this._segmentsH - 1) * this._segmentsW * 6);
			this.invalidateGeometry();
		}
		var startIndex;
		var index = target.get_vertexOffset();
		var comp1;
		var comp2;
		var t1;
		var t2;
		var _g = 0;
		var _g1 = this._segmentsH + 1;
		while(_g < _g1) {
			var j1 = _g++;
			startIndex = index;
			var horangle = Math.PI * j1 / this._segmentsH;
			var z = -this._radius * Math.cos(horangle);
			var ringradius = this._radius * Math.sin(horangle);
			var _g2 = 0;
			var _g11 = this._segmentsW + 1;
			while(_g2 < _g11) {
				var i1 = _g2++;
				var verangle = 2 * Math.PI * i1 / this._segmentsW;
				var x = ringradius * Math.cos(verangle);
				var y = ringradius * Math.sin(verangle);
				var normLen = 1 / Math.sqrt(x * x + y * y + z * z);
				var tanLen = Math.sqrt(y * y + x * x);
				if(this._yUp) {
					t1 = 0;
					t2 = tanLen > .007 ? x / tanLen : 0;
					comp1 = -z;
					comp2 = y;
				} else {
					t1 = tanLen > .007 ? x / tanLen : 0;
					t2 = 0;
					comp1 = y;
					comp2 = z;
				}
				if(i1 == this._segmentsW) {
					vertices.set(index++,vertices.get(startIndex));
					vertices.set(index++,vertices.get(startIndex + 1));
					vertices.set(index++,vertices.get(startIndex + 2));
					vertices.set(index++,vertices.get(startIndex + 3) + x * normLen * .5);
					vertices.set(index++,vertices.get(startIndex + 4) + comp1 * normLen * .5);
					vertices.set(index++,vertices.get(startIndex + 5) + comp2 * normLen * .5);
					vertices.set(index++,tanLen > .007 ? -y / tanLen : 1);
					vertices.set(index++,t1);
					vertices.set(index++,t2);
				} else {
					vertices.set(index++,x);
					vertices.set(index++,comp1);
					vertices.set(index++,comp2);
					vertices.set(index++,x * normLen);
					vertices.set(index++,comp1 * normLen);
					vertices.set(index++,comp2 * normLen);
					vertices.set(index++,tanLen > .007 ? -y / tanLen : 1);
					vertices.set(index++,t1);
					vertices.set(index++,t2);
				}
				if(i1 > 0 && j1 > 0) {
					var a = (this._segmentsW + 1) * j1 + i1;
					var b = (this._segmentsW + 1) * j1 + i1 - 1;
					var c = (this._segmentsW + 1) * (j1 - 1) + i1 - 1;
					var d = (this._segmentsW + 1) * (j1 - 1) + i1;
					if(j1 == this._segmentsH) {
						vertices.set(index - 9,vertices.get(startIndex));
						vertices.set(index - 8,vertices.get(startIndex + 1));
						vertices.set(index - 7,vertices.get(startIndex + 2));
						indices.set(triIndex++,a);
						indices.set(triIndex++,c);
						indices.set(triIndex++,d);
					} else if(j1 == 1) {
						indices.set(triIndex++,a);
						indices.set(triIndex++,b);
						indices.set(triIndex++,c);
					} else {
						indices.set(triIndex++,a);
						indices.set(triIndex++,b);
						indices.set(triIndex++,c);
						indices.set(triIndex++,a);
						indices.set(triIndex++,c);
						indices.set(triIndex++,d);
					}
				}
				index += skip;
			}
		}
		target.updateData(vertices);
		target.updateIndexData(indices);
	}
	,buildUVs: function(target) {
		var i;
		var j;
		var stride = target.get_UVStride();
		var numUvs = (this._segmentsH + 1) * (this._segmentsW + 1) * stride;
		var data;
		var skip = stride - 2;
		if(target.get_UVData() != null && numUvs == target.get_UVData().get_length()) {
			data = target.get_UVData();
		} else {
			data = openfl__$Vector_Vector_$Impl_$.toFloatVector(null,numUvs,true);
			this.invalidateGeometry();
		}
		var index = target.get_UVOffset();
		var _g = 0;
		var _g1 = this._segmentsH + 1;
		while(_g < _g1) {
			var j1 = _g++;
			var _g2 = 0;
			var _g11 = this._segmentsW + 1;
			while(_g2 < _g11) {
				var i1 = _g2++;
				data.set(index++,i1 / this._segmentsW * target.get_scaleU());
				data.set(index++,j1 / this._segmentsH * target.get_scaleV());
				index += skip;
			}
		}
		target.updateData(data);
	}
	,get_radius: function() {
		return this._radius;
	}
	,set_radius: function(value) {
		this._radius = value;
		this.invalidateGeometry();
		return value;
	}
	,get_segmentsW: function() {
		return this._segmentsW;
	}
	,set_segmentsW: function(value) {
		this._segmentsW = value;
		this.invalidateGeometry();
		this.invalidateUVs();
		return value;
	}
	,get_segmentsH: function() {
		return this._segmentsH;
	}
	,set_segmentsH: function(value) {
		this._segmentsH = value;
		this.invalidateGeometry();
		this.invalidateUVs();
		return value;
	}
	,get_yUp: function() {
		return this._yUp;
	}
	,set_yUp: function(value) {
		this._yUp = value;
		this.invalidateGeometry();
		return value;
	}
	,__class__: away3d_primitives_SphereGeometry
	,__properties__: $extend(away3d_primitives_PrimitiveBase.prototype.__properties__,{set_yUp:"set_yUp",get_yUp:"get_yUp",set_segmentsH:"set_segmentsH",get_segmentsH:"get_segmentsH",set_segmentsW:"set_segmentsW",get_segmentsW:"get_segmentsW",set_radius:"set_radius",get_radius:"get_radius"})
});
var away3d_primitives_WireframePrimitiveBase = function(color,thickness) {
	if(thickness == null) {
		thickness = 1;
	}
	if(color == null) {
		color = 16777215;
	}
	this._geomDirty = true;
	if(thickness <= 0) {
		thickness = 1;
	}
	this._color = color;
	this._thickness = thickness;
	this.set_mouseEnabled(this.set_mouseChildren(false));
	away3d_entities_SegmentSet.call(this);
};
$hxClasses["away3d.primitives.WireframePrimitiveBase"] = away3d_primitives_WireframePrimitiveBase;
away3d_primitives_WireframePrimitiveBase.__name__ = "away3d.primitives.WireframePrimitiveBase";
away3d_primitives_WireframePrimitiveBase.__super__ = away3d_entities_SegmentSet;
away3d_primitives_WireframePrimitiveBase.prototype = $extend(away3d_entities_SegmentSet.prototype,{
	_geomDirty: null
	,_color: null
	,_thickness: null
	,get_color: function() {
		return this._color;
	}
	,set_color: function(value) {
		this._color = value;
		var segRef = this._segments.iterator();
		while(segRef.hasNext()) {
			var segRef1 = segRef.next();
			segRef1.segment.set_startColor(segRef1.segment.set_endColor(value));
		}
		return value;
	}
	,get_thickness: function() {
		return this._thickness;
	}
	,set_thickness: function(value) {
		this._thickness = value;
		var segRef = this._segments.iterator();
		while(segRef.hasNext()) {
			var segRef1 = segRef.next();
			segRef1.segment.set_thickness(segRef1.segment.set_thickness(value));
		}
		return value;
	}
	,removeAllSegments: function() {
		away3d_entities_SegmentSet.prototype.removeAllSegments.call(this);
	}
	,get_bounds: function() {
		if(this._geomDirty) {
			this.updateGeometry();
		}
		return away3d_entities_SegmentSet.prototype.get_bounds.call(this);
	}
	,buildGeometry: function() {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,invalidateGeometry: function() {
		this._geomDirty = true;
		this.invalidateBounds();
	}
	,updateGeometry: function() {
		this.buildGeometry();
		this._geomDirty = false;
	}
	,updateOrAddSegment: function(index,v0,v1) {
		var s;
		var e;
		var segment = this.getSegment(index);
		if(segment != null) {
			s = segment.get_start();
			e = segment.get_end();
			s.x = v0.x;
			s.y = v0.y;
			s.z = v0.z;
			e.x = v1.x;
			e.y = v1.y;
			e.z = v1.z;
			segment.updateSegment(s,e,null,this._color,this._color,this._thickness);
		} else {
			this.addSegment(new away3d_primitives_LineSegment(v0.clone(),v1.clone(),this._color,this._color,this._thickness));
		}
	}
	,updateMouseChildren: function() {
		this._ancestorsAllowMouseEnabled = false;
	}
	,__class__: away3d_primitives_WireframePrimitiveBase
	,__properties__: $extend(away3d_entities_SegmentSet.prototype.__properties__,{set_thickness:"set_thickness",get_thickness:"get_thickness",set_color:"set_color",get_color:"get_color"})
});
var away3d_primitives_WireframeCube = function(width,height,depth,color,thickness) {
	if(thickness == null) {
		thickness = 1;
	}
	if(color == null) {
		color = 16777215;
	}
	if(depth == null) {
		depth = 100;
	}
	if(height == null) {
		height = 100;
	}
	if(width == null) {
		width = 100;
	}
	away3d_primitives_WireframePrimitiveBase.call(this,color,thickness);
	this._width = width;
	this._height = height;
	this._depth = depth;
};
$hxClasses["away3d.primitives.WireframeCube"] = away3d_primitives_WireframeCube;
away3d_primitives_WireframeCube.__name__ = "away3d.primitives.WireframeCube";
away3d_primitives_WireframeCube.__super__ = away3d_primitives_WireframePrimitiveBase;
away3d_primitives_WireframeCube.prototype = $extend(away3d_primitives_WireframePrimitiveBase.prototype,{
	_width: null
	,_height: null
	,_depth: null
	,get_width: function() {
		return this._width;
	}
	,set_width: function(value) {
		this._width = value;
		this.invalidateGeometry();
		return value;
	}
	,get_height: function() {
		return this._height;
	}
	,set_height: function(value) {
		if(value <= 0) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Value needs to be greater than 0"));
		}
		this._height = value;
		this.invalidateGeometry();
		return value;
	}
	,get_depth: function() {
		return this._depth;
	}
	,set_depth: function(value) {
		this._depth = value;
		this.invalidateGeometry();
		return value;
	}
	,buildGeometry: function() {
		var v0 = new openfl_geom_Vector3D();
		var v1 = new openfl_geom_Vector3D();
		var hw = this._width * .5;
		var hh = this._height * .5;
		var hd = this._depth * .5;
		v0.x = -hw;
		v0.y = hh;
		v0.z = -hd;
		v1.x = -hw;
		v1.y = -hh;
		v1.z = -hd;
		this.updateOrAddSegment(0,v0,v1);
		v0.z = hd;
		v1.z = hd;
		this.updateOrAddSegment(1,v0,v1);
		v0.x = hw;
		v1.x = hw;
		this.updateOrAddSegment(2,v0,v1);
		v0.z = -hd;
		v1.z = -hd;
		this.updateOrAddSegment(3,v0,v1);
		v0.x = -hw;
		v0.y = -hh;
		v0.z = -hd;
		v1.x = hw;
		v1.y = -hh;
		v1.z = -hd;
		this.updateOrAddSegment(4,v0,v1);
		v0.y = hh;
		v1.y = hh;
		this.updateOrAddSegment(5,v0,v1);
		v0.z = hd;
		v1.z = hd;
		this.updateOrAddSegment(6,v0,v1);
		v0.y = -hh;
		v1.y = -hh;
		this.updateOrAddSegment(7,v0,v1);
		v0.x = -hw;
		v0.y = -hh;
		v0.z = -hd;
		v1.x = -hw;
		v1.y = -hh;
		v1.z = hd;
		this.updateOrAddSegment(8,v0,v1);
		v0.y = hh;
		v1.y = hh;
		this.updateOrAddSegment(9,v0,v1);
		v0.x = hw;
		v1.x = hw;
		this.updateOrAddSegment(10,v0,v1);
		v0.y = -hh;
		v1.y = -hh;
		this.updateOrAddSegment(11,v0,v1);
	}
	,__class__: away3d_primitives_WireframeCube
	,__properties__: $extend(away3d_primitives_WireframePrimitiveBase.prototype.__properties__,{set_depth:"set_depth",get_depth:"get_depth",set_height:"set_height",get_height:"get_height",set_width:"set_width",get_width:"get_width"})
});
var away3d_primitives_WireframeSphere = function(radius,segmentsW,segmentsH,color,thickness) {
	if(thickness == null) {
		thickness = 1;
	}
	if(color == null) {
		color = 16777215;
	}
	if(segmentsH == null) {
		segmentsH = 12;
	}
	if(segmentsW == null) {
		segmentsW = 16;
	}
	if(radius == null) {
		radius = 50;
	}
	away3d_primitives_WireframePrimitiveBase.call(this,color,thickness);
	this._radius = radius;
	this._segmentsW = segmentsW;
	this._segmentsH = segmentsH;
};
$hxClasses["away3d.primitives.WireframeSphere"] = away3d_primitives_WireframeSphere;
away3d_primitives_WireframeSphere.__name__ = "away3d.primitives.WireframeSphere";
away3d_primitives_WireframeSphere.__super__ = away3d_primitives_WireframePrimitiveBase;
away3d_primitives_WireframeSphere.prototype = $extend(away3d_primitives_WireframePrimitiveBase.prototype,{
	_segmentsW: null
	,_segmentsH: null
	,_radius: null
	,buildGeometry: function() {
		var vertices = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
		var v0 = new openfl_geom_Vector3D();
		var v1 = new openfl_geom_Vector3D();
		var numVerts = 0;
		var index = 0;
		var horangle;
		var z;
		var ringradius;
		var verangle;
		var x;
		var y;
		var _g = 0;
		var _g1 = this._segmentsH + 1;
		while(_g < _g1) {
			var j = _g++;
			horangle = Math.PI * j / this._segmentsH;
			z = -this._radius * Math.cos(horangle);
			ringradius = this._radius * Math.sin(horangle);
			var _g2 = 0;
			var _g11 = this._segmentsW + 1;
			while(_g2 < _g11) {
				var i = _g2++;
				verangle = 2 * Math.PI * i / this._segmentsW;
				x = ringradius * Math.cos(verangle);
				y = ringradius * Math.sin(verangle);
				vertices.set(numVerts++,x);
				vertices.set(numVerts++,-z);
				vertices.set(numVerts++,y);
			}
		}
		var a;
		var b;
		var c;
		var d;
		var _g21 = 1;
		var _g3 = this._segmentsH + 1;
		while(_g21 < _g3) {
			var j1 = _g21++;
			var _g22 = 1;
			var _g31 = this._segmentsH + 1;
			while(_g22 < _g31) {
				var i1 = _g22++;
				a = ((this._segmentsW + 1) * j1 + i1) * 3;
				b = ((this._segmentsW + 1) * j1 + i1 - 1) * 3;
				c = ((this._segmentsW + 1) * (j1 - 1) + i1 - 1) * 3;
				d = ((this._segmentsW + 1) * (j1 - 1) + i1) * 3;
				if(j1 == this._segmentsH) {
					v0.x = vertices.get(c);
					v0.y = vertices.get(c + 1);
					v0.z = vertices.get(c + 2);
					v1.x = vertices.get(d);
					v1.y = vertices.get(d + 1);
					v1.z = vertices.get(d + 2);
					this.updateOrAddSegment(index++,v0,v1);
					v0.x = vertices.get(a);
					v0.y = vertices.get(a + 1);
					v0.z = vertices.get(a + 2);
					this.updateOrAddSegment(index++,v0,v1);
				} else if(j1 == 1) {
					v1.x = vertices.get(b);
					v1.y = vertices.get(b + 1);
					v1.z = vertices.get(b + 2);
					v0.x = vertices.get(c);
					v0.y = vertices.get(c + 1);
					v0.z = vertices.get(c + 2);
					this.updateOrAddSegment(index++,v0,v1);
				} else {
					v1.x = vertices.get(b);
					v1.y = vertices.get(b + 1);
					v1.z = vertices.get(b + 2);
					v0.x = vertices.get(c);
					v0.y = vertices.get(c + 1);
					v0.z = vertices.get(c + 2);
					this.updateOrAddSegment(index++,v0,v1);
					v1.x = vertices.get(d);
					v1.y = vertices.get(d + 1);
					v1.z = vertices.get(d + 2);
					this.updateOrAddSegment(index++,v0,v1);
				}
			}
		}
	}
	,__class__: away3d_primitives_WireframeSphere
});
var away3d_textfield_BitmapChar = function(id,x,y,width,height,xOffset,yOffset,xAdvance) {
	this.mCharID = id;
	this.mXOffset = xOffset;
	this.mYOffset = yOffset;
	this.mXAdvance = xAdvance;
	this.mKernings = null;
	this.mX = x;
	this.mY = y;
	this.mWidth = width;
	this.mHeight = height;
};
$hxClasses["away3d.textfield.BitmapChar"] = away3d_textfield_BitmapChar;
away3d_textfield_BitmapChar.__name__ = "away3d.textfield.BitmapChar";
away3d_textfield_BitmapChar.prototype = {
	mCharID: null
	,mXOffset: null
	,mYOffset: null
	,mXAdvance: null
	,mKernings: null
	,mX: null
	,mY: null
	,mWidth: null
	,mHeight: null
	,addKerning: function(charID,amount) {
		if(this.mKernings == null) {
			this.mKernings = new haxe_ds_IntMap();
		}
		this.mKernings.h[charID] = amount;
	}
	,getKerning: function(charID) {
		if(this.mKernings == null || this.mKernings.h[charID] == null) {
			return 0.0;
		} else {
			return this.mKernings.h[charID];
		}
	}
	,charID: null
	,get_charID: function() {
		return this.mCharID;
	}
	,xOffset: null
	,get_xOffset: function() {
		return this.mXOffset;
	}
	,yOffset: null
	,get_yOffset: function() {
		return this.mYOffset;
	}
	,xAdvance: null
	,get_xAdvance: function() {
		return this.mXAdvance;
	}
	,width: null
	,get_width: function() {
		return this.mWidth;
	}
	,height: null
	,get_height: function() {
		return this.mHeight;
	}
	,x: null
	,get_x: function() {
		return this.mX;
	}
	,y: null
	,get_y: function() {
		return this.mY;
	}
	,__class__: away3d_textfield_BitmapChar
	,__properties__: {get_y:"get_y",get_x:"get_x",get_height:"get_height",get_width:"get_width",get_xAdvance:"get_xAdvance",get_yOffset:"get_yOffset",get_xOffset:"get_xOffset",get_charID:"get_charID"}
};
var away3d_textfield_BitmapFont = function(texture,fontXml) {
	if(texture == null && fontXml == null) {
		texture = away3d_textfield_MiniBitmapFont.get_texture();
		fontXml = away3d_textfield_MiniBitmapFont.get_xml();
	}
	this.mName = "unknown";
	this.mLineHeight = this.mSize = this.mBaseline = 14;
	this.mOffsetX = this.mOffsetY = 0.0;
	this.mFontMaterial = texture;
	this.mChars = new haxe_ds_IntMap();
	this.parseFontXml(fontXml);
};
$hxClasses["away3d.textfield.BitmapFont"] = away3d_textfield_BitmapFont;
away3d_textfield_BitmapFont.__name__ = "away3d.textfield.BitmapFont";
away3d_textfield_BitmapFont.prototype = {
	mFontMaterial: null
	,mChars: null
	,mName: null
	,mSize: null
	,mLineHeight: null
	,mBaseline: null
	,mOffsetX: null
	,mOffsetY: null
	,dispose: function() {
		if(this.mFontMaterial != null) {
			this.mFontMaterial.dispose();
		}
	}
	,parseFontXml: function(fontXml) {
		var frameX = 0;
		var frameY = 0;
		var scale = 1;
		var font = fontXml.elementsNamed("font");
		while(font.hasNext()) {
			var font1 = font.next();
			if(font1.nodeType == Xml.Element) {
				var info = font1.elementsNamed("info");
				while(info.hasNext()) {
					var info1 = info.next();
					if(info1.nodeType == Xml.Element) {
						this.mName = info1.get("face");
						this.mSize = parseFloat(info1.get("size")) / scale;
					}
				}
				var common = font1.elementsNamed("common");
				while(common.hasNext()) {
					var common1 = common.next();
					if(common1.nodeType == Xml.Element) {
						this.mLineHeight = parseFloat(common1.get("lineHeight")) / scale;
						this.mBaseline = parseFloat(common1.get("base")) / scale;
					}
				}
				var chars = font1.elementsNamed("chars");
				while(chars.hasNext()) {
					var chars1 = chars.next();
					if(chars1.nodeType == Xml.Element) {
						var char = chars1.elementsNamed("char");
						while(char.hasNext()) {
							var char1 = char.next();
							if(char1.nodeType == Xml.Element) {
								var id = Std.parseInt(char1.get("id"));
								var xOffset = parseFloat(char1.get("xoffset")) / scale;
								var yOffset = parseFloat(char1.get("yoffset")) / scale;
								var xAdvance = parseFloat(char1.get("xadvance")) / scale;
								var region = new openfl_geom_Rectangle();
								region.x = parseFloat(char1.get("x")) / scale + frameX;
								region.y = parseFloat(char1.get("y")) / scale + frameY;
								region.width = parseFloat(char1.get("width")) / scale;
								region.height = parseFloat(char1.get("height")) / scale;
								var bitmapChar = new away3d_textfield_BitmapChar(id,region.x,region.y,region.width,region.height,xOffset,yOffset,xAdvance);
								this.addChar(id,bitmapChar);
							}
						}
					}
				}
				var kernings = font1.elementsNamed("kernings");
				while(kernings.hasNext()) {
					var kernings1 = kernings.next();
					if(kernings1.nodeType == Xml.Element) {
						var kerning = kernings1.elementsNamed("kerning");
						while(kerning.hasNext()) {
							var kerning1 = kerning.next();
							if(kerning1.nodeType == Xml.Element) {
								var first = Std.parseInt(kerning1.get("first"));
								var second = Std.parseInt(kerning1.get("second"));
								var amount = parseFloat(kerning1.get("amount")) / scale;
								if(this.mChars.h.hasOwnProperty(second)) {
									this.getChar(second).addKerning(first,amount);
								}
							}
						}
					}
				}
			}
		}
	}
	,getChar: function(charID) {
		return this.mChars.h[charID];
	}
	,addChar: function(charID,bitmapChar) {
		this.mChars.h[charID] = bitmapChar;
	}
	,getCharIDs: function(result) {
		if(result == null) {
			result = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
		}
		var keys = this.mChars.keys();
		var k = keys;
		while(k.hasNext()) {
			var k1 = k.next();
			var key = k1;
			result.set(result.get_length(),key);
		}
		return result;
	}
	,hasChars: function(text) {
		if(text == null) {
			return true;
		}
		var charID;
		var numChars = text.length;
		var _g = 0;
		var _g1 = numChars;
		while(_g < _g1) {
			var i = _g++;
			charID = HxOverrides.cca(text,i);
			if(charID != away3d_textfield_BitmapFont.CHAR_SPACE && charID != away3d_textfield_BitmapFont.CHAR_TAB && charID != away3d_textfield_BitmapFont.CHAR_NEWLINE && charID != away3d_textfield_BitmapFont.CHAR_CARRIAGE_RETURN && this.getChar(charID) == null) {
				return false;
			}
		}
		return true;
	}
	,fillBatched: function(data,indices,width,height,text,fontSize,hAlign,vAlign,autoScale,kerning,letterSpacing) {
		if(letterSpacing == null) {
			letterSpacing = 0;
		}
		if(kerning == null) {
			kerning = true;
		}
		if(autoScale == null) {
			autoScale = true;
		}
		if(vAlign == null) {
			vAlign = "center";
		}
		if(hAlign == null) {
			hAlign = "center";
		}
		if(fontSize == null) {
			fontSize = -1;
		}
		var charLocations = this.arrangeChars(width,height,text,fontSize,hAlign,vAlign,autoScale,kerning,letterSpacing);
		data.set_length(0);
		indices.set_length(0);
		var k = 0;
		var indicesCount = 0;
		var numChars = charLocations.get_length();
		var _g = 0;
		var _g1 = numChars;
		while(_g < _g1) {
			var i = _g++;
			indices.set(indicesCount++,i * 4);
			indices.set(indicesCount++,i * 4 + 1);
			indices.set(indicesCount++,i * 4 + 2);
			indices.set(indicesCount++,i * 4);
			indices.set(indicesCount++,i * 4 + 2);
			indices.set(indicesCount++,i * 4 + 3);
			var charLocation = charLocations.get(i);
			var x = charLocation.x;
			var y = charLocation.y;
			var scale = charLocation.scale;
			var char = charLocation.char;
			var width1 = char.get_width() * scale;
			var height1 = char.get_height() * scale;
			var u1 = char.get_x() / this.mFontMaterial.get_texture().get_width();
			var u2 = (char.get_x() + char.get_width()) / this.mFontMaterial.get_texture().get_width();
			var v1 = char.get_y() / this.mFontMaterial.get_texture().get_height();
			var v2 = (char.get_y() + char.get_height()) / this.mFontMaterial.get_texture().get_height();
			data.set(k++,x);
			data.set(k++,0);
			data.set(k++,y + height1);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,u1);
			data.set(k++,v2);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,x);
			data.set(k++,0);
			data.set(k++,y);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,u1);
			data.set(k++,v1);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,x + width1);
			data.set(k++,0);
			data.set(k++,y);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,u2);
			data.set(k++,v1);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,x + width1);
			data.set(k++,0);
			data.set(k++,y + height1);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,0);
			data.set(k++,u2);
			data.set(k++,v2);
			data.set(k++,0);
			data.set(k++,0);
		}
		away3d_textfield_CharLocation.rechargePool();
	}
	,getMaterialClone: function() {
		return new away3d_materials_TextureMaterial(this.mFontMaterial.get_texture(),this.mFontMaterial.get_smooth(),this.mFontMaterial.get_repeat(),this.mFontMaterial.get_mipmap());
	}
	,arrangeChars: function(width,height,text,fontSize,hAlign,vAlign,autoScale,kerning,letterSpacing) {
		if(letterSpacing == null) {
			letterSpacing = 0;
		}
		if(kerning == null) {
			kerning = true;
		}
		if(autoScale == null) {
			autoScale = true;
		}
		if(vAlign == null) {
			vAlign = "center";
		}
		if(hAlign == null) {
			hAlign = "center";
		}
		if(fontSize == null) {
			fontSize = -1;
		}
		if(hAlign == null) {
			hAlign = away3d_textfield_HAlign.CENTER;
		}
		if(vAlign == null) {
			vAlign = away3d_textfield_VAlign.CENTER;
		}
		if(text == null || text.length == 0) {
			return away3d_textfield_CharLocation.vectorFromPool();
		}
		if(fontSize < 0) {
			fontSize *= -this.mSize;
		}
		var finished = false;
		var charLocation;
		var numChars;
		var containerWidth = 0;
		var containerHeight = 0;
		var scale = 1;
		var currentX = 0;
		var currentY = 0;
		while(!finished) {
			away3d_textfield_BitmapFont.sLines = openfl__$Vector_Vector_$Impl_$.toNullVector(null);
			scale = fontSize / this.mSize;
			containerWidth = width / scale;
			containerHeight = height / scale;
			if(this.mLineHeight <= containerHeight) {
				var lastWhiteSpace = -1;
				var lastCharID = -1;
				currentX = 0;
				currentY = 0;
				var currentLine = away3d_textfield_CharLocation.vectorFromPool();
				numChars = text.length;
				var _g = 0;
				var _g1 = numChars;
				while(_g < _g1) {
					var i = _g++;
					var lineFull = false;
					var charID = HxOverrides.cca(text,i);
					var char = this.getChar(charID);
					if(charID == away3d_textfield_BitmapFont.CHAR_NEWLINE || charID == away3d_textfield_BitmapFont.CHAR_CARRIAGE_RETURN) {
						lineFull = true;
					} else if(char == null) {
						haxe_Log.trace("[BitmapFont] Missing character: " + charID,{ fileName : "away3d/textfield/BitmapFont.hx", lineNumber : 389, className : "away3d.textfield.BitmapFont", methodName : "arrangeChars"});
					} else {
						if(charID == away3d_textfield_BitmapFont.CHAR_SPACE || charID == away3d_textfield_BitmapFont.CHAR_TAB) {
							lastWhiteSpace = i;
						}
						if(kerning) {
							currentX += char.getKerning(lastCharID);
						}
						charLocation = away3d_textfield_CharLocation.instanceFromPool(char);
						charLocation.x = currentX + char.get_xOffset();
						charLocation.y = currentY + char.get_yOffset();
						currentLine.set(currentLine.get_length(),charLocation);
						currentX += char.get_xAdvance();
						lastCharID = charID;
						if(charLocation.x + char.get_width() > containerWidth) {
							if(autoScale && lastWhiteSpace == -1) {
								break;
							}
							var numCharsToRemove = lastWhiteSpace == -1 ? 1 : i - lastWhiteSpace;
							var removeIndex = currentLine.get_length() - numCharsToRemove;
							currentLine.splice(removeIndex,numCharsToRemove);
							if(currentLine.get_length() == 0) {
								break;
							}
							lineFull = true;
						}
					}
					if(i == numChars - 1) {
						away3d_textfield_BitmapFont.sLines.set(away3d_textfield_BitmapFont.sLines.get_length(),currentLine);
						finished = true;
					} else if(lineFull) {
						away3d_textfield_BitmapFont.sLines.set(away3d_textfield_BitmapFont.sLines.get_length(),currentLine);
						if(lastWhiteSpace == i) {
							currentLine.pop();
						}
						if(currentY + 2 * this.mLineHeight <= containerHeight) {
							currentLine = away3d_textfield_CharLocation.vectorFromPool();
							currentX = 0;
							currentY += this.mLineHeight;
							lastWhiteSpace = -1;
							lastCharID = -1;
						} else {
							break;
						}
					}
				}
			}
			if(autoScale && !finished && fontSize > 3) {
				--fontSize;
			} else {
				finished = true;
			}
		}
		var finalLocations = away3d_textfield_CharLocation.vectorFromPool();
		var numLines = away3d_textfield_BitmapFont.sLines.get_length();
		var bottom = currentY + this.mLineHeight;
		var yOffset = 0;
		if(vAlign == away3d_textfield_VAlign.BOTTOM) {
			yOffset = containerHeight - bottom | 0;
		} else if(vAlign == away3d_textfield_VAlign.CENTER) {
			yOffset = (containerHeight - bottom) / 2 | 0;
		}
		var _g2 = 0;
		var _g11 = numLines;
		while(_g2 < _g11) {
			var lineID = _g2++;
			var line = away3d_textfield_BitmapFont.sLines.get(lineID);
			numChars = line.get_length();
			if(numChars == 0) {
				continue;
			}
			var xOffset = 0;
			var lastLocation = line.get(line.get_length() - 1);
			var right = lastLocation.x - lastLocation.char.get_xOffset() + lastLocation.char.get_xAdvance();
			if(hAlign == away3d_textfield_HAlign.RIGHT) {
				xOffset = containerWidth - right | 0;
			} else if(hAlign == away3d_textfield_HAlign.CENTER) {
				xOffset = (containerWidth - right) / 2 | 0;
			}
			var _g3 = 0;
			var _g12 = numChars;
			while(_g3 < _g12) {
				var c = _g3++;
				charLocation = line.get(c);
				charLocation.x = scale * (charLocation.x + xOffset + this.mOffsetX);
				charLocation.y = scale * (charLocation.y + yOffset + this.mOffsetY);
				charLocation.scale = scale;
				if(charLocation.char.get_width() > 0 && charLocation.char.get_height() > 0) {
					finalLocations.set(finalLocations.get_length(),charLocation);
				}
			}
		}
		return finalLocations;
	}
	,name: null
	,get_name: function() {
		return this.mName;
	}
	,size: null
	,get_size: function() {
		return this.mSize;
	}
	,get_lineHeight: function() {
		return this.mLineHeight;
	}
	,set_lineHeight: function(value) {
		return this.mLineHeight = value;
	}
	,get_baseline: function() {
		return this.mBaseline;
	}
	,set_baseline: function(value) {
		return this.mBaseline = value;
	}
	,get_offsetX: function() {
		return this.mOffsetX;
	}
	,set_offsetX: function(value) {
		return this.mOffsetX = value;
	}
	,get_offsetY: function() {
		return this.mOffsetY;
	}
	,set_offsetY: function(value) {
		return this.mOffsetY = value;
	}
	,fontMaterial: null
	,get_fontMaterial: function() {
		return this.mFontMaterial;
	}
	,__class__: away3d_textfield_BitmapFont
	,__properties__: {get_fontMaterial:"get_fontMaterial",set_offsetY:"set_offsetY",get_offsetY:"get_offsetY",set_offsetX:"set_offsetX",get_offsetX:"get_offsetX",set_baseline:"set_baseline",get_baseline:"get_baseline",set_lineHeight:"set_lineHeight",get_lineHeight:"get_lineHeight",get_size:"get_size",get_name:"get_name"}
};
var away3d_textfield_CharLocation = function(char) {
	this.reset(char);
};
$hxClasses["away3d.textfield.CharLocation"] = away3d_textfield_CharLocation;
away3d_textfield_CharLocation.__name__ = "away3d.textfield.CharLocation";
away3d_textfield_CharLocation.instanceFromPool = function(char) {
	var instance = away3d_textfield_CharLocation.sInstancePool.length > 0 ? away3d_textfield_CharLocation.sInstancePool.pop() : new away3d_textfield_CharLocation(char);
	instance.reset(char);
	away3d_textfield_CharLocation.sInstanceLoan[away3d_textfield_CharLocation.sInstanceLoan.length] = instance;
	return instance;
};
away3d_textfield_CharLocation.vectorFromPool = function() {
	var vector = away3d_textfield_CharLocation.sVectorPool.length > 0 ? away3d_textfield_CharLocation.sVectorPool.pop() : openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	vector.set_length(0);
	away3d_textfield_CharLocation.sVectorLoan[away3d_textfield_CharLocation.sVectorLoan.length] = vector;
	return vector;
};
away3d_textfield_CharLocation.rechargePool = function() {
	var instance;
	var vector;
	while(away3d_textfield_CharLocation.sInstanceLoan.length > 0) {
		instance = away3d_textfield_CharLocation.sInstanceLoan.pop();
		instance.char = null;
		away3d_textfield_CharLocation.sInstancePool[away3d_textfield_CharLocation.sInstancePool.length] = instance;
	}
	while(away3d_textfield_CharLocation.sVectorLoan.length > 0) {
		vector = away3d_textfield_CharLocation.sVectorLoan.pop();
		vector.set_length(0);
		away3d_textfield_CharLocation.sVectorPool[away3d_textfield_CharLocation.sVectorPool.length] = vector;
	}
};
away3d_textfield_CharLocation.prototype = {
	char: null
	,scale: null
	,x: null
	,y: null
	,reset: function(char) {
		this.char = char;
		return this;
	}
	,getChar: function() {
		return this.char;
	}
	,__class__: away3d_textfield_CharLocation
};
var away3d_textfield_HAlign = function() {
	throw new js__$Boot_HaxeError(new openfl_errors_Error());
};
$hxClasses["away3d.textfield.HAlign"] = away3d_textfield_HAlign;
away3d_textfield_HAlign.__name__ = "away3d.textfield.HAlign";
away3d_textfield_HAlign.isValid = function(hAlign) {
	if(!(hAlign == away3d_textfield_HAlign.LEFT || hAlign == away3d_textfield_HAlign.CENTER)) {
		return hAlign == away3d_textfield_HAlign.RIGHT;
	} else {
		return true;
	}
};
away3d_textfield_HAlign.prototype = {
	__class__: away3d_textfield_HAlign
};
var haxe_ds_StringMap = function() {
	this.h = { };
};
$hxClasses["haxe.ds.StringMap"] = haxe_ds_StringMap;
haxe_ds_StringMap.__name__ = "haxe.ds.StringMap";
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.prototype = {
	h: null
	,rh: null
	,set: function(key,value) {
		if(__map_reserved[key] != null) {
			this.setReserved(key,value);
		} else {
			this.h[key] = value;
		}
	}
	,exists: function(key) {
		if(__map_reserved[key] != null) {
			return this.existsReserved(key);
		}
		return this.h.hasOwnProperty(key);
	}
	,setReserved: function(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	,getReserved: function(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	,existsReserved: function(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	,remove: function(key) {
		if(__map_reserved[key] != null) {
			key = "$" + key;
			if(this.rh == null || !this.rh.hasOwnProperty(key)) {
				return false;
			}
			delete(this.rh[key]);
			return true;
		} else {
			if(!this.h.hasOwnProperty(key)) {
				return false;
			}
			delete(this.h[key]);
			return true;
		}
	}
	,keys: function() {
		return HxOverrides.iter(this.arrayKeys());
	}
	,arrayKeys: function() {
		var out = [];
		for( var key in this.h ) {
		if(this.h.hasOwnProperty(key)) {
			out.push(key);
		}
		}
		if(this.rh != null) {
			for( var key in this.rh ) {
			if(key.charCodeAt(0) == 36) {
				out.push(key.substr(1));
			}
			}
		}
		return out;
	}
	,__class__: haxe_ds_StringMap
};
var haxe_xml_Parser = function() { };
$hxClasses["haxe.xml.Parser"] = haxe_xml_Parser;
haxe_xml_Parser.__name__ = "haxe.xml.Parser";
haxe_xml_Parser.parse = function(str,strict) {
	if(strict == null) {
		strict = false;
	}
	var doc = Xml.createDocument();
	haxe_xml_Parser.doParse(str,strict,0,doc);
	return doc;
};
haxe_xml_Parser.doParse = function(str,strict,p,parent) {
	if(p == null) {
		p = 0;
	}
	var xml = null;
	var state = 1;
	var next = 1;
	var aname = null;
	var start = 0;
	var nsubs = 0;
	var nbrackets = 0;
	var c = str.charCodeAt(p);
	var buf = new StringBuf();
	var escapeNext = 1;
	var attrValQuote = -1;
	while(c == c) {
		switch(state) {
		case 0:
			switch(c) {
			case 9:case 10:case 13:case 32:
				break;
			default:
				state = next;
				continue;
			}
			break;
		case 1:
			if(c == 60) {
				state = 0;
				next = 2;
			} else {
				start = p;
				state = 13;
				continue;
			}
			break;
		case 2:
			switch(c) {
			case 33:
				if(str.charCodeAt(p + 1) == 91) {
					p += 2;
					if(HxOverrides.substr(str,p,6).toUpperCase() != "CDATA[") {
						throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected <![CDATA[",str,p));
					}
					p += 5;
					state = 17;
					start = p + 1;
				} else if(str.charCodeAt(p + 1) == 68 || str.charCodeAt(p + 1) == 100) {
					if(HxOverrides.substr(str,p + 2,6).toUpperCase() != "OCTYPE") {
						throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected <!DOCTYPE",str,p));
					}
					p += 8;
					state = 16;
					start = p + 1;
				} else if(str.charCodeAt(p + 1) != 45 || str.charCodeAt(p + 2) != 45) {
					throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected <!--",str,p));
				} else {
					p += 2;
					state = 15;
					start = p + 1;
				}
				break;
			case 47:
				if(parent == null) {
					throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected node name",str,p));
				}
				start = p + 1;
				state = 0;
				next = 10;
				break;
			case 63:
				state = 14;
				start = p;
				break;
			default:
				state = 3;
				start = p;
				continue;
			}
			break;
		case 3:
			if(!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 58 || c == 46 || c == 95 || c == 45)) {
				if(p == start) {
					throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected node name",str,p));
				}
				xml = Xml.createElement(HxOverrides.substr(str,start,p - start));
				parent.addChild(xml);
				++nsubs;
				state = 0;
				next = 4;
				continue;
			}
			break;
		case 4:
			switch(c) {
			case 47:
				state = 11;
				break;
			case 62:
				state = 9;
				break;
			default:
				state = 5;
				start = p;
				continue;
			}
			break;
		case 5:
			if(!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 58 || c == 46 || c == 95 || c == 45)) {
				if(start == p) {
					throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected attribute name",str,p));
				}
				var tmp = HxOverrides.substr(str,start,p - start);
				aname = tmp;
				if(xml.exists(aname)) {
					throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Duplicate attribute [" + aname + "]",str,p));
				}
				state = 0;
				next = 6;
				continue;
			}
			break;
		case 6:
			if(c == 61) {
				state = 0;
				next = 7;
			} else {
				throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected =",str,p));
			}
			break;
		case 7:
			switch(c) {
			case 34:case 39:
				buf = new StringBuf();
				state = 8;
				start = p + 1;
				attrValQuote = c;
				break;
			default:
				throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected \"",str,p));
			}
			break;
		case 8:
			switch(c) {
			case 38:
				var len = p - start;
				buf.b += len == null ? HxOverrides.substr(str,start,null) : HxOverrides.substr(str,start,len);
				state = 18;
				escapeNext = 8;
				start = p + 1;
				break;
			case 60:case 62:
				if(strict) {
					throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Invalid unescaped " + String.fromCodePoint(c) + " in attribute value",str,p));
				} else if(c == attrValQuote) {
					var len1 = p - start;
					buf.b += len1 == null ? HxOverrides.substr(str,start,null) : HxOverrides.substr(str,start,len1);
					var val = buf.b;
					buf = new StringBuf();
					xml.set(aname,val);
					state = 0;
					next = 4;
				}
				break;
			default:
				if(c == attrValQuote) {
					var len2 = p - start;
					buf.b += len2 == null ? HxOverrides.substr(str,start,null) : HxOverrides.substr(str,start,len2);
					var val1 = buf.b;
					buf = new StringBuf();
					xml.set(aname,val1);
					state = 0;
					next = 4;
				}
			}
			break;
		case 9:
			p = haxe_xml_Parser.doParse(str,strict,p,xml);
			start = p;
			state = 1;
			break;
		case 10:
			if(!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 58 || c == 46 || c == 95 || c == 45)) {
				if(start == p) {
					throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected node name",str,p));
				}
				var v = HxOverrides.substr(str,start,p - start);
				if(parent == null || parent.nodeType != 0) {
					throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Unexpected </" + v + ">, tag is not open",str,p));
				}
				if(parent.nodeType != Xml.Element) {
					throw new js__$Boot_HaxeError("Bad node type, expected Element but found " + _$Xml_XmlType_$Impl_$.toString(parent.nodeType));
				}
				if(v != parent.nodeName) {
					if(parent.nodeType != Xml.Element) {
						throw new js__$Boot_HaxeError("Bad node type, expected Element but found " + _$Xml_XmlType_$Impl_$.toString(parent.nodeType));
					}
					throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected </" + parent.nodeName + ">",str,p));
				}
				state = 0;
				next = 12;
				continue;
			}
			break;
		case 11:
			if(c == 62) {
				state = 1;
			} else {
				throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected >",str,p));
			}
			break;
		case 12:
			if(c == 62) {
				if(nsubs == 0) {
					parent.addChild(Xml.createPCData(""));
				}
				return p;
			} else {
				throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Expected >",str,p));
			}
			break;
		case 13:
			if(c == 60) {
				var len3 = p - start;
				buf.b += len3 == null ? HxOverrides.substr(str,start,null) : HxOverrides.substr(str,start,len3);
				var child = Xml.createPCData(buf.b);
				buf = new StringBuf();
				parent.addChild(child);
				++nsubs;
				state = 0;
				next = 2;
			} else if(c == 38) {
				var len4 = p - start;
				buf.b += len4 == null ? HxOverrides.substr(str,start,null) : HxOverrides.substr(str,start,len4);
				state = 18;
				escapeNext = 13;
				start = p + 1;
			}
			break;
		case 14:
			if(c == 63 && str.charCodeAt(p + 1) == 62) {
				++p;
				var str1 = HxOverrides.substr(str,start + 1,p - start - 2);
				parent.addChild(Xml.createProcessingInstruction(str1));
				++nsubs;
				state = 1;
			}
			break;
		case 15:
			if(c == 45 && str.charCodeAt(p + 1) == 45 && str.charCodeAt(p + 2) == 62) {
				parent.addChild(Xml.createComment(HxOverrides.substr(str,start,p - start)));
				++nsubs;
				p += 2;
				state = 1;
			}
			break;
		case 16:
			if(c == 91) {
				++nbrackets;
			} else if(c == 93) {
				--nbrackets;
			} else if(c == 62 && nbrackets == 0) {
				parent.addChild(Xml.createDocType(HxOverrides.substr(str,start,p - start)));
				++nsubs;
				state = 1;
			}
			break;
		case 17:
			if(c == 93 && str.charCodeAt(p + 1) == 93 && str.charCodeAt(p + 2) == 62) {
				var child1 = Xml.createCData(HxOverrides.substr(str,start,p - start));
				parent.addChild(child1);
				++nsubs;
				p += 2;
				state = 1;
			}
			break;
		case 18:
			if(c == 59) {
				var s = HxOverrides.substr(str,start,p - start);
				if(s.charCodeAt(0) == 35) {
					var c1 = s.charCodeAt(1) == 120 ? Std.parseInt("0" + HxOverrides.substr(s,1,s.length - 1)) : Std.parseInt(HxOverrides.substr(s,1,s.length - 1));
					buf.b += String.fromCodePoint(c1);
				} else {
					var _this = haxe_xml_Parser.escapes;
					if(!(__map_reserved[s] != null ? _this.existsReserved(s) : _this.h.hasOwnProperty(s))) {
						if(strict) {
							throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Undefined entity: " + s,str,p));
						}
						buf.b += Std.string("&" + s + ";");
					} else {
						var _this1 = haxe_xml_Parser.escapes;
						var x = __map_reserved[s] != null ? _this1.getReserved(s) : _this1.h[s];
						buf.b += Std.string(x);
					}
				}
				start = p + 1;
				state = escapeNext;
			} else if(!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 58 || c == 46 || c == 95 || c == 45) && c != 35) {
				if(strict) {
					throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Invalid character in entity: " + String.fromCodePoint(c),str,p));
				}
				buf.b += String.fromCodePoint(38);
				var len5 = p - start;
				buf.b += len5 == null ? HxOverrides.substr(str,start,null) : HxOverrides.substr(str,start,len5);
				--p;
				start = p + 1;
				state = escapeNext;
			}
			break;
		}
		c = str.charCodeAt(++p);
	}
	if(state == 1) {
		start = p;
		state = 13;
	}
	if(state == 13) {
		if(parent.nodeType == 0) {
			if(parent.nodeType != Xml.Element) {
				throw new js__$Boot_HaxeError("Bad node type, expected Element but found " + _$Xml_XmlType_$Impl_$.toString(parent.nodeType));
			}
			throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Unclosed node <" + parent.nodeName + ">",str,p));
		}
		if(p != start || nsubs == 0) {
			var len6 = p - start;
			buf.b += len6 == null ? HxOverrides.substr(str,start,null) : HxOverrides.substr(str,start,len6);
			parent.addChild(Xml.createPCData(buf.b));
			++nsubs;
		}
		return p;
	}
	if(!strict && state == 18 && escapeNext == 13) {
		buf.b += String.fromCodePoint(38);
		var len7 = p - start;
		buf.b += len7 == null ? HxOverrides.substr(str,start,null) : HxOverrides.substr(str,start,len7);
		parent.addChild(Xml.createPCData(buf.b));
		++nsubs;
		return p;
	}
	throw new js__$Boot_HaxeError(new haxe_xml_XmlParserException("Unexpected end",str,p));
};
var haxe_xml_XmlParserException = function(message,xml,position) {
	this.xml = xml;
	this.message = message;
	this.position = position;
	this.lineNumber = 1;
	this.positionAtLine = 0;
	var _g = 0;
	var _g1 = position;
	while(_g < _g1) {
		var i = _g++;
		var c = xml.charCodeAt(i);
		if(c == 10) {
			this.lineNumber++;
			this.positionAtLine = 0;
		} else if(c != 13) {
			this.positionAtLine++;
		}
	}
};
$hxClasses["haxe.xml.XmlParserException"] = haxe_xml_XmlParserException;
haxe_xml_XmlParserException.__name__ = "haxe.xml.XmlParserException";
haxe_xml_XmlParserException.prototype = {
	message: null
	,lineNumber: null
	,positionAtLine: null
	,position: null
	,xml: null
	,toString: function() {
		var c = js_Boot.getClass(this);
		return c.__name__ + ": " + this.message + " at line " + this.lineNumber + " char " + this.positionAtLine;
	}
	,__class__: haxe_xml_XmlParserException
};
var js_Boot = function() { };
$hxClasses["js.Boot"] = js_Boot;
js_Boot.__name__ = "js.Boot";
js_Boot.getClass = function(o) {
	if(o == null) {
		return null;
	} else if(((o) instanceof Array)) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o.__enum__) {
			var e = $hxEnums[o.__enum__];
			var n = e.__constructs__[o._hx_index];
			var con = e[n];
			if(con.__params__) {
				s = s + "\t";
				return n + "(" + ((function($this) {
					var $r;
					var _g = [];
					{
						var _g1 = 0;
						var _g2 = con.__params__;
						while(true) {
							if(!(_g1 < _g2.length)) {
								break;
							}
							var p = _g2[_g1];
							_g1 = _g1 + 1;
							_g.push(js_Boot.__string_rec(o[p],s));
						}
					}
					$r = _g;
					return $r;
				}(this))).join(",") + ")";
			} else {
				return n;
			}
		}
		if(((o) instanceof Array)) {
			var str = "[";
			s += "\t";
			var _g3 = 0;
			var _g11 = o.length;
			while(_g3 < _g11) {
				var i = _g3++;
				str += (i > 0 ? "," : "") + js_Boot.__string_rec(o[i],s);
			}
			str += "]";
			return str;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e1 ) {
			haxe_CallStack.lastException = e1;
			var e2 = ((e1) instanceof js__$Boot_HaxeError) ? e1.val : e1;
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var str1 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		var k = null;
		for( k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str1.length != 2) {
			str1 += ", \n";
		}
		str1 += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str1 += "\n" + s + "}";
		return str1;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	if(Object.prototype.hasOwnProperty.call(cc,"__interfaces__")) {
		var intf = cc.__interfaces__;
		var _g = 0;
		var _g1 = intf.length;
		while(_g < _g1) {
			var i = _g++;
			var i1 = intf[i];
			if(i1 == cl || js_Boot.__interfLoop(i1,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		return ((o) instanceof Array);
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return o != null;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return ((o | 0) === o);
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(js_Boot.__downcastCheck(o,cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(((o) instanceof cl)) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class ? o.__name__ != null : false) {
			return true;
		}
		if(cl == Enum ? o.__ename__ != null : false) {
			return true;
		}
		return o.__enum__ != null ? $hxEnums[o.__enum__] == cl : false;
	}
};
js_Boot.__downcastCheck = function(o,cl) {
	if(!((o) instanceof cl)) {
		if(cl.__isInterface__) {
			return js_Boot.__interfLoop(js_Boot.getClass(o),cl);
		} else {
			return false;
		}
	} else {
		return true;
	}
};
js_Boot.__implements = function(o,iface) {
	return js_Boot.__interfLoop(js_Boot.getClass(o),iface);
};
js_Boot.__cast = function(o,t) {
	if(o == null || js_Boot.__instanceof(o,t)) {
		return o;
	} else {
		throw new js__$Boot_HaxeError("Cannot cast " + Std.string(o) + " to " + Std.string(t));
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var away3d_textfield_MiniBitmapFont = function() { };
$hxClasses["away3d.textfield.MiniBitmapFont"] = away3d_textfield_MiniBitmapFont;
away3d_textfield_MiniBitmapFont.__name__ = "away3d.textfield.MiniBitmapFont";
away3d_textfield_MiniBitmapFont.__properties__ = {get_xml:"get_xml",get_texture:"get_texture"};
away3d_textfield_MiniBitmapFont.get_texture = function() {
	var bitmapData = away3d_textfield_MiniBitmapFont.getBitmapData();
	var texture = new away3d_materials_TextureMaterial(new away3d_textures_BitmapTexture(bitmapData));
	bitmapData.dispose();
	bitmapData = null;
	return texture;
};
away3d_textfield_MiniBitmapFont.getBitmapData = function() {
	var bmpData = new openfl_display_BitmapData(away3d_textfield_MiniBitmapFont.BITMAP_WIDTH,away3d_textfield_MiniBitmapFont.BITMAP_HEIGHT,true,-65536);
	var this1 = new openfl_utils_ByteArrayData(0);
	var bmpBytes = this1;
	var numBytes = away3d_textfield_MiniBitmapFont.BITMAP_DATA.length;
	var _g = 0;
	var _g1 = numBytes;
	while(_g < _g1) {
		var i = _g++;
		bmpBytes.writeUnsignedInt(away3d_textfield_MiniBitmapFont.BITMAP_DATA[i]);
	}
	bmpBytes.uncompress(null);
	bmpData.setPixels(new openfl_geom_Rectangle(0,0,away3d_textfield_MiniBitmapFont.BITMAP_WIDTH,away3d_textfield_MiniBitmapFont.BITMAP_HEIGHT),bmpBytes);
	bmpBytes.clear();
	return bmpData;
};
away3d_textfield_MiniBitmapFont.get_xml = function() {
	return away3d_textfield_MiniBitmapFont.Xml_DATA;
};
var away3d_textfield_TextField = function(width,height,text,bitmapFont,fontSize,color,bold,_hAlign) {
	if(_hAlign == null) {
		_hAlign = "left";
	}
	if(bold == null) {
		bold = false;
	}
	if(color == null) {
		color = 0;
	}
	if(fontSize == null) {
		fontSize = 12;
	}
	this._boundsRect = new openfl_geom_Rectangle();
	this.disposeMaterial = true;
	this.mLetterSpacing = 0;
	this.mText = "";
	this.indexData = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
	this.vertexData = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
	away3d_entities_Mesh.call(this,new away3d_core_base_Geometry(),bitmapFont.get_fontMaterial());
	this.mText = text;
	this.mBitmapFont = bitmapFont;
	this.mWidth = width;
	this.mHeight = height;
	this.mFontSize = fontSize;
	this.mColor = color;
	this.mHAlign = _hAlign;
	this.mVAlign = away3d_textfield_VAlign.TOP;
	this.mBorder = null;
	this.mKerning = true;
	this.mBold = bold;
	this.mAutoSize = 2;
	this._subGeometry = new away3d_core_base_CompactSubGeometry();
	this._subGeometry.set_autoDeriveVertexNormals(true);
	this._subGeometry.set_autoDeriveVertexTangents(true);
	this.get_geometry().addSubGeometry(this._subGeometry);
	this.textureMaterial = bitmapFont.get_fontMaterial();
	var rgb = this.HexToRGB(color);
	if(this.textureMaterial.get_colorTransform() == null) {
		this.textureMaterial.set_colorTransform(new openfl_geom_ColorTransform());
	}
	var tmp = _$UInt_UInt_$Impl_$.toFloat(rgb.get(0)) / _$UInt_UInt_$Impl_$.toFloat(255);
	this.textureMaterial.get_colorTransform().redMultiplier = tmp;
	var tmp1 = _$UInt_UInt_$Impl_$.toFloat(rgb.get(1)) / _$UInt_UInt_$Impl_$.toFloat(255);
	this.textureMaterial.get_colorTransform().greenMultiplier = tmp1;
	var tmp2 = _$UInt_UInt_$Impl_$.toFloat(rgb.get(2)) / _$UInt_UInt_$Impl_$.toFloat(255);
	this.textureMaterial.get_colorTransform().blueMultiplier = tmp2;
	this.textureMaterial.get_colorTransform().alphaMultiplier = this.textureMaterial.get_alpha();
	this.set_material(this.textureMaterial);
	this.get_material().set_alphaPremultiplied(true);
	var castMat = ((this.get_material()) instanceof away3d_materials_SinglePassMaterialBase) ? this.get_material() : null;
	if(castMat != null) {
		castMat.set_alphaBlending(true);
	}
	this.updateText();
};
$hxClasses["away3d.textfield.TextField"] = away3d_textfield_TextField;
away3d_textfield_TextField.__name__ = "away3d.textfield.TextField";
away3d_textfield_TextField.__super__ = away3d_entities_Mesh;
away3d_textfield_TextField.prototype = $extend(away3d_entities_Mesh.prototype,{
	vertexData: null
	,indexData: null
	,mText: null
	,mBitmapFont: null
	,mFontSize: null
	,mColor: null
	,mHAlign: null
	,mVAlign: null
	,mBold: null
	,mItalic: null
	,mUnderline: null
	,mAutoScale: null
	,mAutoSize: null
	,mKerning: null
	,mLetterSpacing: null
	,mBorder: null
	,mWidth: null
	,mHeight: null
	,disposeMaterial: null
	,_boundsRect: null
	,_textHeight: null
	,_textWidth: null
	,_subGeometry: null
	,colorTransformMethod: null
	,textureMaterial: null
	,HexToRGB: function(hex) {
		var rgb = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
		var r = hex >>> 16 & 255;
		var g = hex >>> 8 & 255;
		var b = hex & 255;
		rgb.push(r);
		rgb.push(g);
		rgb.push(b);
		return rgb;
	}
	,dispose: function() {
		if(this.disposeMaterial) {
			this.get_material().dispose();
		}
		away3d_entities_Mesh.prototype.dispose.call(this);
	}
	,updateText: function() {
		this.mBitmapFont.fillBatched(this.vertexData,this.indexData,this.mWidth,this.mHeight,this.mText,this.mFontSize,this.mHAlign,this.mVAlign,this.mAutoScale,this.mKerning,this.mLetterSpacing);
		this._subGeometry.updateData(this.vertexData);
		this._subGeometry.updateIndexData(this.indexData);
	}
	,get_bold: function() {
		return this.mBold;
	}
	,set_bold: function(value) {
		if(this.mBold != value) {
			this.mBold = value;
			this.updateText();
		}
		return value;
	}
	,get_italic: function() {
		return this.mItalic;
	}
	,set_italic: function(value) {
		if(this.mItalic != value) {
			this.mItalic = value;
			this.updateText();
		}
		return value;
	}
	,get_underline: function() {
		return this.mUnderline;
	}
	,set_underline: function(value) {
		if(this.mUnderline != value) {
			this.mUnderline = value;
			this.updateText();
		}
		return value;
	}
	,get_kerning: function() {
		return this.mKerning;
	}
	,set_kerning: function(value) {
		if(this.mKerning != value) {
			this.mKerning = value;
			this.updateText();
		}
		return value;
	}
	,get_letterSpacing: function() {
		return this.mLetterSpacing;
	}
	,set_letterSpacing: function(value) {
		if(this.mLetterSpacing != value) {
			this.mLetterSpacing = value;
			this.updateText();
		}
		return value;
	}
	,get_autoScale: function() {
		return this.mAutoScale;
	}
	,set_autoScale: function(value) {
		if(this.mAutoScale != value) {
			this.mAutoScale = value;
			this.updateText();
		}
		return value;
	}
	,get_autoSize: function() {
		return this.mAutoSize;
	}
	,set_autoSize: function(value) {
		if(this.mAutoSize != value) {
			this.mAutoSize = value;
			this.updateText();
		}
		return value;
	}
	,textHeight: null
	,get_textHeight: function() {
		this._textHeight = Math.abs(this.get_bounds().get_min().z - this.get_bounds().get_max().z);
		return this._textHeight;
	}
	,textWidth: null
	,get_textWidth: function() {
		this._textWidth = Math.abs(this.get_bounds().get_min().x - this.get_bounds().get_max().x);
		return this._textWidth;
	}
	,boundsRect: null
	,get_boundsRect: function() {
		var minX = this.get_bounds().get_min().x;
		var maxX = this.get_bounds().get_max().x;
		var minY = this.get_bounds().get_min().y;
		var maxY = this.get_bounds().get_max().y;
		var minZ = this.get_bounds().get_min().z;
		var maxZ = this.get_bounds().get_max().z;
		this._boundsRect.setTo(minX,minZ,maxX - minX,maxZ - minZ);
		return this._boundsRect;
	}
	,get_alpha: function() {
		return this.textureMaterial.get_colorTransform().alphaMultiplier;
	}
	,set_alpha: function(value) {
		return this.textureMaterial.get_colorTransform().alphaMultiplier = value;
	}
	,__class__: away3d_textfield_TextField
	,__properties__: $extend(away3d_entities_Mesh.prototype.__properties__,{set_alpha:"set_alpha",get_alpha:"get_alpha",get_boundsRect:"get_boundsRect",get_textWidth:"get_textWidth",get_textHeight:"get_textHeight",set_autoSize:"set_autoSize",get_autoSize:"get_autoSize",set_autoScale:"set_autoScale",get_autoScale:"get_autoScale",set_letterSpacing:"set_letterSpacing",get_letterSpacing:"get_letterSpacing",set_kerning:"set_kerning",get_kerning:"get_kerning",set_underline:"set_underline",get_underline:"get_underline",set_italic:"set_italic",get_italic:"get_italic",set_bold:"set_bold",get_bold:"get_bold"})
});
var away3d_textfield_VAlign = function() {
	throw new js__$Boot_HaxeError(new openfl_errors_Error());
};
$hxClasses["away3d.textfield.VAlign"] = away3d_textfield_VAlign;
away3d_textfield_VAlign.__name__ = "away3d.textfield.VAlign";
away3d_textfield_VAlign.isValid = function(vAlign) {
	if(!(vAlign == away3d_textfield_VAlign.TOP || vAlign == away3d_textfield_VAlign.CENTER)) {
		return vAlign == away3d_textfield_VAlign.BOTTOM;
	} else {
		return true;
	}
};
away3d_textfield_VAlign.prototype = {
	__class__: away3d_textfield_VAlign
};
var away3d_textfield_utils_AwayFont = function() {
};
$hxClasses["away3d.textfield.utils.AwayFont"] = away3d_textfield_utils_AwayFont;
away3d_textfield_utils_AwayFont.__name__ = "away3d.textfield.utils.AwayFont";
away3d_textfield_utils_AwayFont.type = function(type,cacheMaterial,mipmap) {
	if(mipmap == null) {
		mipmap = true;
	}
	if(cacheMaterial == null) {
		cacheMaterial = false;
	}
	var family = Reflect.getProperty(type,"FAMILY");
	var size = Reflect.getProperty(type,"SIZE");
	var regName = family + "_" + size;
	var _this = away3d_textfield_utils_AwayFont.registeredBitmapFont;
	var cached = __map_reserved[regName] != null ? _this.getReserved(regName) : _this.h[regName];
	if(cacheMaterial == true && cached != null) {
		return cached;
	}
	if(cached == null) {
		var xmlLocation = Reflect.getProperty(type,"DATA");
		var xmlStr = openfl_utils_Assets.getText(xmlLocation);
		var data = Xml.parse(xmlStr);
		var bmdLocation = Reflect.getProperty(type,"TEXTURE");
		var texture = openfl_utils_Assets.getBitmapData(bmdLocation);
		return away3d_textfield_utils_AwayFont.generate(family,size,data,texture,cacheMaterial,mipmap);
	} else {
		var _this1 = away3d_textfield_utils_AwayFont.registeredTexture;
		var fontMaterial = new away3d_materials_TextureMaterial(__map_reserved[regName] != null ? _this1.getReserved(regName) : _this1.h[regName],true,false,mipmap);
		fontMaterial.set_smooth(true);
		fontMaterial.set_alphaBlending(true);
		fontMaterial.set_bothSides(true);
		var _this2 = away3d_textfield_utils_AwayFont.registeredData;
		return new away3d_textfield_BitmapFont(fontMaterial,__map_reserved[regName] != null ? _this2.getReserved(regName) : _this2.h[regName]);
	}
};
away3d_textfield_utils_AwayFont.gen = function(fontSize,cacheMaterial,mipmap) {
	if(mipmap == null) {
		mipmap = true;
	}
	if(cacheMaterial == null) {
		cacheMaterial = false;
	}
	return away3d_textfield_utils_AwayFont.generate(fontSize.family,fontSize.size,fontSize.data,fontSize.texture,cacheMaterial,mipmap);
};
away3d_textfield_utils_AwayFont.generate = function(family,size,data,texture,cacheMaterial,mipmap) {
	if(cacheMaterial == null) {
		cacheMaterial = false;
	}
	var regName = family + "_" + size;
	var bmTexture;
	var fontMaterial;
	if(cacheMaterial) {
		var _this = away3d_textfield_utils_AwayFont.registeredBitmapFont;
		var bitmapFont = __map_reserved[regName] != null ? _this.getReserved(regName) : _this.h[regName];
		if(bitmapFont == null) {
			bmTexture = new away3d_textures_BitmapTexture(texture,mipmap);
			fontMaterial = new away3d_materials_TextureMaterial(bmTexture,true,false,mipmap);
			fontMaterial.set_smooth(true);
			fontMaterial.set_alphaBlending(true);
			fontMaterial.set_bothSides(true);
			bitmapFont = new away3d_textfield_BitmapFont(fontMaterial,data);
			var _this1 = away3d_textfield_utils_AwayFont.registeredBitmapFont;
			if(__map_reserved[regName] != null) {
				_this1.setReserved(regName,bitmapFont);
			} else {
				_this1.h[regName] = bitmapFont;
			}
		}
		return bitmapFont;
	} else {
		var _this2 = away3d_textfield_utils_AwayFont.registeredTexture;
		bmTexture = __map_reserved[regName] != null ? _this2.getReserved(regName) : _this2.h[regName];
		if(bmTexture == null) {
			bmTexture = new away3d_textures_BitmapTexture(texture);
			var _this3 = away3d_textfield_utils_AwayFont.registeredTexture;
			if(__map_reserved[regName] != null) {
				_this3.setReserved(regName,bmTexture);
			} else {
				_this3.h[regName] = bmTexture;
			}
			var _this4 = away3d_textfield_utils_AwayFont.registeredData;
			if(__map_reserved[regName] != null) {
				_this4.setReserved(regName,data);
			} else {
				_this4.h[regName] = data;
			}
		}
		fontMaterial = new away3d_materials_TextureMaterial(bmTexture,true,false,true);
		fontMaterial.set_smooth(true);
		fontMaterial.set_alphaBlending(true);
		fontMaterial.set_bothSides(true);
		var _this5 = away3d_textfield_utils_AwayFont.registeredData;
		return new away3d_textfield_BitmapFont(fontMaterial,__map_reserved[regName] != null ? _this5.getReserved(regName) : _this5.h[regName]);
	}
};
away3d_textfield_utils_AwayFont.prototype = {
	__class__: away3d_textfield_utils_AwayFont
};
var away3d_textfield_utils_FontSize = function() { };
$hxClasses["away3d.textfield.utils.FontSize"] = away3d_textfield_utils_FontSize;
away3d_textfield_utils_FontSize.__name__ = "away3d.textfield.utils.FontSize";
away3d_textfield_utils_FontSize.prototype = {
	family: null
	,size: null
	,data: null
	,texture: null
	,FontSize: function(searchClass) {
		if(searchClass == null) {
			searchClass = true;
		}
		if(searchClass) {
			var type = js_Boot.getClass(this);
			try {
				this.family = Reflect.getProperty(type,"FAMILY");
				this.size = Reflect.getProperty(type,"SIZE");
				var dataType = Reflect.getProperty(type,"DATA");
				var textureType = Reflect.getProperty(type,"TEXTURE");
				this.data = js_Boot.__cast(Type.createInstance(dataType,null) , Xml);
				this.texture = openfl_display_BitmapData.fromBytes(openfl_utils__$ByteArray_ByteArray_$Impl_$.fromBytes(js_Boot.__cast(Type.createInstance(textureType,[]) , haxe_io_Bytes)));
			} catch( e ) {
				haxe_CallStack.lastException = e;
				var e1 = ((e) instanceof js__$Boot_HaxeError) ? e.val : e;
				if(((e1) instanceof openfl_errors_Error)) {
					var e2 = e1;
					throw new js__$Boot_HaxeError(new openfl_errors_Error("Class inheriting from FontSize (" + Std.string(type) + ") should have PUBLIC static members FAMILY, SIZE, DATA and TEXTURE."));
				} else {
					throw e;
				}
			}
		}
	}
	,__class__: away3d_textfield_utils_FontSize
};
var away3d_textures__$Anisotropy_Anisotropy_$Impl_$ = {};
$hxClasses["away3d.textures._Anisotropy.Anisotropy_Impl_"] = away3d_textures__$Anisotropy_Anisotropy_$Impl_$;
away3d_textures__$Anisotropy_Anisotropy_$Impl_$.__name__ = "away3d.textures._Anisotropy.Anisotropy_Impl_";
away3d_textures__$Anisotropy_Anisotropy_$Impl_$.fromString = function(value) {
	switch(value) {
	case "anisotropic16x":
		return 4;
	case "anisotropic2x":
		return 1;
	case "anisotropic4x":
		return 2;
	case "anisotropic8x":
		return 3;
	case "none":
		return 0;
	default:
		return null;
	}
};
away3d_textures__$Anisotropy_Anisotropy_$Impl_$.toString = function(this1) {
	switch(this1) {
	case 0:
		return "bool";
	case 1:
		return "anisotropic2x";
	case 2:
		return "anisotropic4x";
	case 3:
		return "anisotropic8x";
	case 4:
		return "anisotropic16x";
	default:
		return null;
	}
};
var away3d_textures_TextureProxyBase = function() {
	this._hasMipmaps = true;
	this._format = 1;
	this._textures = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	this._dirty = openfl__$Vector_Vector_$Impl_$.toObjectVector(null,8);
	away3d_library_assets_NamedAssetBase.call(this);
};
$hxClasses["away3d.textures.TextureProxyBase"] = away3d_textures_TextureProxyBase;
away3d_textures_TextureProxyBase.__name__ = "away3d.textures.TextureProxyBase";
away3d_textures_TextureProxyBase.__interfaces__ = [away3d_library_assets_IAsset];
away3d_textures_TextureProxyBase.__super__ = away3d_library_assets_NamedAssetBase;
away3d_textures_TextureProxyBase.prototype = $extend(away3d_library_assets_NamedAssetBase.prototype,{
	_format: null
	,_hasMipmaps: null
	,_textures: null
	,_dirty: null
	,_width: null
	,_height: null
	,get_hasMipMaps: function() {
		return this._hasMipmaps;
	}
	,get_format: function() {
		return this._format;
	}
	,get_assetType: function() {
		return "texture";
	}
	,get_width: function() {
		return this._width;
	}
	,set_width: function(value) {
		return value;
	}
	,get_height: function() {
		return this._height;
	}
	,set_height: function(value) {
		return value;
	}
	,getTextureForStage3D: function(stage3DProxy) {
		var contextIndex = stage3DProxy._stage3DIndex;
		var tex = this._textures.get(contextIndex);
		var context = stage3DProxy._context3D;
		if(context == null) {
			return null;
		}
		if(tex == null || this._dirty.get(contextIndex) != context) {
			var this1 = this._textures;
			tex = this.createTexture(context);
			this1.set(contextIndex,tex);
			this._dirty.set(contextIndex,context);
			this.uploadContent(tex);
		}
		return tex;
	}
	,uploadContent: function(texture) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,setSize: function(width,height) {
		if(this._width != width || this._height != height) {
			this.invalidateSize();
		}
		this._width = width;
		this._height = height;
	}
	,invalidateContent: function() {
		this._dirty.set(0,null);
		this._dirty.set(1,null);
		this._dirty.set(2,null);
		this._dirty.set(3,null);
		this._dirty.set(4,null);
		this._dirty.set(5,null);
		this._dirty.set(6,null);
		this._dirty.set(7,null);
	}
	,invalidateSize: function() {
		var tex;
		tex = this._textures.get(0);
		if(tex != null) {
			tex.dispose();
			this._textures.set(0,null);
			this._dirty.set(0,null);
		}
		tex = this._textures.get(1);
		if(tex != null) {
			tex.dispose();
			this._textures.set(1,null);
			this._dirty.set(1,null);
		}
		tex = this._textures.get(2);
		if(tex != null) {
			tex.dispose();
			this._textures.set(2,null);
			this._dirty.set(2,null);
		}
		tex = this._textures.get(3);
		if(tex != null) {
			tex.dispose();
			this._textures.set(3,null);
			this._dirty.set(3,null);
		}
		tex = this._textures.get(4);
		if(tex != null) {
			tex.dispose();
			this._textures.set(4,null);
			this._dirty.set(4,null);
		}
		tex = this._textures.get(5);
		if(tex != null) {
			tex.dispose();
			this._textures.set(5,null);
			this._dirty.set(5,null);
		}
		tex = this._textures.get(6);
		if(tex != null) {
			tex.dispose();
			this._textures.set(6,null);
			this._dirty.set(6,null);
		}
		tex = this._textures.get(7);
		if(tex != null) {
			tex.dispose();
			this._textures.set(7,null);
			this._dirty.set(7,null);
		}
	}
	,createTexture: function(context) {
		throw new js__$Boot_HaxeError(new away3d_errors_AbstractMethodError());
	}
	,dispose: function() {
		if(this._textures.get(0) != null) {
			this._textures.get(0).dispose();
		}
		if(this._textures.get(1) != null) {
			this._textures.get(1).dispose();
		}
		if(this._textures.get(2) != null) {
			this._textures.get(2).dispose();
		}
		if(this._textures.get(3) != null) {
			this._textures.get(3).dispose();
		}
		if(this._textures.get(4) != null) {
			this._textures.get(4).dispose();
		}
		if(this._textures.get(5) != null) {
			this._textures.get(5).dispose();
		}
		if(this._textures.get(6) != null) {
			this._textures.get(6).dispose();
		}
		if(this._textures.get(7) != null) {
			this._textures.get(7).dispose();
		}
	}
	,__class__: away3d_textures_TextureProxyBase
	,__properties__: $extend(away3d_library_assets_NamedAssetBase.prototype.__properties__,{set_height:"set_height",get_height:"get_height",set_width:"set_width",get_width:"get_width",get_assetType:"get_assetType",get_format:"get_format",get_hasMipMaps:"get_hasMipMaps"})
});
var away3d_textures_Texture2DBase = function() {
	away3d_textures_TextureProxyBase.call(this);
};
$hxClasses["away3d.textures.Texture2DBase"] = away3d_textures_Texture2DBase;
away3d_textures_Texture2DBase.__name__ = "away3d.textures.Texture2DBase";
away3d_textures_Texture2DBase.__super__ = away3d_textures_TextureProxyBase;
away3d_textures_Texture2DBase.prototype = $extend(away3d_textures_TextureProxyBase.prototype,{
	createTexture: function(context) {
		return context.createTexture(this._width,this._height,1,false);
	}
	,__class__: away3d_textures_Texture2DBase
});
var away3d_textures_BitmapTexture = function(bitmapData,generateMipmaps) {
	if(generateMipmaps == null) {
		generateMipmaps = true;
	}
	away3d_textures_Texture2DBase.call(this);
	this.set_bitmapData(bitmapData);
	this._generateMipmaps = this._hasMipmaps = generateMipmaps;
};
$hxClasses["away3d.textures.BitmapTexture"] = away3d_textures_BitmapTexture;
away3d_textures_BitmapTexture.__name__ = "away3d.textures.BitmapTexture";
away3d_textures_BitmapTexture.__super__ = away3d_textures_Texture2DBase;
away3d_textures_BitmapTexture.prototype = $extend(away3d_textures_Texture2DBase.prototype,{
	_bitmapData: null
	,_mipMapHolder: null
	,_generateMipmaps: null
	,get_bitmapData: function() {
		return this._bitmapData;
	}
	,set_bitmapData: function(value) {
		if(value == this._bitmapData) {
			return null;
		}
		if(!away3d_tools_utils_TextureUtils.isBitmapDataValid(value)) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Invalid bitmapData: Width and height must be power of 2 and cannot exceed 2048"));
		}
		this.invalidateContent();
		this.setSize(value.width,value.height);
		this._bitmapData = value;
		if(this._generateMipmaps) {
			this.getMipMapHolder();
		}
		return value;
	}
	,uploadContent: function(texture) {
		if(this._generateMipmaps) {
			away3d_materials_utils_MipmapGenerator.generateMipMaps(this._bitmapData,texture,this._mipMapHolder,true);
		} else {
			(js_Boot.__cast(texture , openfl_display3D_textures_Texture)).uploadFromBitmapData(this._bitmapData,0);
		}
	}
	,getMipMapHolder: function() {
		var newW = this._bitmapData.width;
		var newH = this._bitmapData.height;
		if(this._mipMapHolder != null) {
			if(this._mipMapHolder.width == newW && this._bitmapData.height == newH) {
				return;
			}
			this.freeMipMapHolder();
		}
		if(away3d_textures_BitmapTexture._mipMaps[newW] == null) {
			away3d_textures_BitmapTexture._mipMaps[newW] = [];
			away3d_textures_BitmapTexture._mipMapUses[newW] = [];
		}
		if(away3d_textures_BitmapTexture._mipMaps[newW][newH] == null) {
			this._mipMapHolder = away3d_textures_BitmapTexture._mipMaps[newW][newH] = new openfl_display_BitmapData(newW,newH,true);
			away3d_textures_BitmapTexture._mipMapUses[newW][newH] = 1;
		} else {
			away3d_textures_BitmapTexture._mipMapUses[newW][newH] += 1;
			this._mipMapHolder = away3d_textures_BitmapTexture._mipMaps[newW][newH];
		}
	}
	,freeMipMapHolder: function() {
		var holderWidth = this._mipMapHolder.width;
		var holderHeight = this._mipMapHolder.height;
		var tmp = away3d_textures_BitmapTexture._mipMapUses[holderWidth];
		if(--tmp[holderHeight] == 0) {
			away3d_textures_BitmapTexture._mipMaps[holderWidth][holderHeight].dispose();
			away3d_textures_BitmapTexture._mipMaps[holderWidth][holderHeight] = null;
		}
	}
	,dispose: function() {
		away3d_textures_Texture2DBase.prototype.dispose.call(this);
		if(this._mipMapHolder != null) {
			this.freeMipMapHolder();
		}
	}
	,__class__: away3d_textures_BitmapTexture
	,__properties__: $extend(away3d_textures_Texture2DBase.prototype.__properties__,{set_bitmapData:"set_bitmapData",get_bitmapData:"get_bitmapData"})
});
var away3d_textures_CubeTextureBase = function() {
	away3d_textures_TextureProxyBase.call(this);
};
$hxClasses["away3d.textures.CubeTextureBase"] = away3d_textures_CubeTextureBase;
away3d_textures_CubeTextureBase.__name__ = "away3d.textures.CubeTextureBase";
away3d_textures_CubeTextureBase.__super__ = away3d_textures_TextureProxyBase;
away3d_textures_CubeTextureBase.prototype = $extend(away3d_textures_TextureProxyBase.prototype,{
	get_size: function() {
		return this._width;
	}
	,createTexture: function(context) {
		return context.createCubeTexture(this.get_width(),1,false);
	}
	,__class__: away3d_textures_CubeTextureBase
	,__properties__: $extend(away3d_textures_TextureProxyBase.prototype.__properties__,{get_size:"get_size"})
});
var away3d_textures_RenderCubeTexture = function(size) {
	away3d_textures_CubeTextureBase.call(this);
	this.setSize(size,size);
};
$hxClasses["away3d.textures.RenderCubeTexture"] = away3d_textures_RenderCubeTexture;
away3d_textures_RenderCubeTexture.__name__ = "away3d.textures.RenderCubeTexture";
away3d_textures_RenderCubeTexture.__super__ = away3d_textures_CubeTextureBase;
away3d_textures_RenderCubeTexture.prototype = $extend(away3d_textures_CubeTextureBase.prototype,{
	set_size: function(value) {
		if(value == this._width) {
			return value;
		}
		if(!away3d_tools_utils_TextureUtils.isDimensionValid(value)) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Invalid size: Width and height must be power of 2 and cannot exceed 2048"));
		}
		this.invalidateContent();
		this.setSize(value,value);
		return value;
	}
	,uploadContent: function(texture) {
		var bmd = new openfl_display_BitmapData(this._width,this._height,false,0);
		away3d_materials_utils_MipmapGenerator.generateMipMaps(bmd,texture,null,false,0);
		away3d_materials_utils_MipmapGenerator.generateMipMaps(bmd,texture,null,false,1);
		away3d_materials_utils_MipmapGenerator.generateMipMaps(bmd,texture,null,false,2);
		away3d_materials_utils_MipmapGenerator.generateMipMaps(bmd,texture,null,false,3);
		away3d_materials_utils_MipmapGenerator.generateMipMaps(bmd,texture,null,false,4);
		away3d_materials_utils_MipmapGenerator.generateMipMaps(bmd,texture,null,false,5);
		bmd.dispose();
	}
	,createTexture: function(context) {
		return context.createCubeTexture(this._width,1,true);
	}
	,__class__: away3d_textures_RenderCubeTexture
});
var away3d_textures_RenderTexture = function(width,height) {
	away3d_textures_Texture2DBase.call(this);
	this.setSize(width,height);
};
$hxClasses["away3d.textures.RenderTexture"] = away3d_textures_RenderTexture;
away3d_textures_RenderTexture.__name__ = "away3d.textures.RenderTexture";
away3d_textures_RenderTexture.__super__ = away3d_textures_Texture2DBase;
away3d_textures_RenderTexture.prototype = $extend(away3d_textures_Texture2DBase.prototype,{
	set_width: function(value) {
		if(value == this._width) {
			return value;
		}
		if(!away3d_tools_utils_TextureUtils.isDimensionValid(value)) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Invalid size: Width and height must be power of 2 and cannot exceed 2048"));
		}
		this.invalidateContent();
		this.setSize(value,this._height);
		return value;
	}
	,set_height: function(value) {
		if(value == this._height) {
			return value;
		}
		if(!away3d_tools_utils_TextureUtils.isDimensionValid(value)) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("Invalid size: Width and height must be power of 2 and cannot exceed 2048"));
		}
		this.invalidateContent();
		this.setSize(this._width,value);
		return value;
	}
	,uploadContent: function(texture) {
	}
	,createTexture: function(context) {
		return context.createTexture(this.get_width(),this.get_height(),1,true);
	}
	,__class__: away3d_textures_RenderTexture
});
var away3d_tools_utils_GeomUtil = function() { };
$hxClasses["away3d.tools.utils.GeomUtil"] = away3d_tools_utils_GeomUtil;
away3d_tools_utils_GeomUtil.__name__ = "away3d.tools.utils.GeomUtil";
away3d_tools_utils_GeomUtil.fromVectors = function(verts,indices,uvs,normals,tangents,weights,jointIndices,triangleOffset) {
	if(triangleOffset == null) {
		triangleOffset = 0;
	}
	var subs = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
	if(uvs != null && uvs.get_length() == 0) {
		uvs = null;
	}
	if(normals != null && normals.get_length() == 0) {
		normals = null;
	}
	if(tangents != null && tangents.get_length() == 0) {
		tangents = null;
	}
	if(weights != null && weights.get_length() == 0) {
		weights = null;
	}
	if(jointIndices != null && jointIndices.get_length() == 0) {
		jointIndices = null;
	}
	if(indices.get_length() >= 983025 || verts.get_length() >= 196605) {
		var i = 0;
		var j;
		var splitVerts = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
		var splitIndices = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
		var splitUvs = uvs != null ? openfl__$Vector_Vector_$Impl_$.toFloatVector(null) : null;
		var splitNormals = normals != null ? openfl__$Vector_Vector_$Impl_$.toFloatVector(null) : null;
		var splitTangents = tangents != null ? openfl__$Vector_Vector_$Impl_$.toFloatVector(null) : null;
		var splitWeights = weights != null ? openfl__$Vector_Vector_$Impl_$.toFloatVector(null) : null;
		var splitJointIndices = jointIndices != null ? openfl__$Vector_Vector_$Impl_$.toFloatVector(null) : null;
		var mappings = openfl__$Vector_Vector_$Impl_$.toIntVector(null,verts.get_length() / 3 | 0,true);
		i = mappings.get_length();
		while(i-- > 0) mappings.set(i,-1);
		var originalIndex;
		var splitIndex;
		var o0;
		var o1;
		var o2;
		var s0;
		var s1;
		var s2;
		var su;
		var ou;
		var sv;
		var ov;
		var outIndex = 0;
		var len = indices.get_length();
		i = 0;
		while(i < len) {
			splitIndex = splitVerts.get_length() + 6;
			if(outIndex + 2 >= 983025 || splitIndex >= 196605) {
				subs.push(away3d_tools_utils_GeomUtil.constructSubGeometry(splitVerts,splitIndices,splitUvs,splitNormals,splitTangents,splitWeights,splitJointIndices,triangleOffset));
				splitVerts = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
				splitIndices = openfl__$Vector_Vector_$Impl_$.toIntVector(null);
				splitUvs = uvs != null ? openfl__$Vector_Vector_$Impl_$.toFloatVector(null) : null;
				splitNormals = normals != null ? openfl__$Vector_Vector_$Impl_$.toFloatVector(null) : null;
				splitTangents = tangents != null ? openfl__$Vector_Vector_$Impl_$.toFloatVector(null) : null;
				splitWeights = weights != null ? openfl__$Vector_Vector_$Impl_$.toFloatVector(null) : null;
				splitJointIndices = jointIndices != null ? openfl__$Vector_Vector_$Impl_$.toFloatVector(null) : null;
				splitIndex = 0;
				j = mappings.get_length();
				while(j-- > 0) mappings.set(j,-1);
				outIndex = 0;
			}
			var _g = 0;
			while(_g < 3) {
				var j1 = _g++;
				originalIndex = indices.get(i + j1);
				if(mappings.get(originalIndex) >= 0) {
					splitIndex = mappings.get(originalIndex);
				} else {
					o0 = originalIndex * 3;
					o1 = originalIndex * 3 + 1;
					o2 = originalIndex * 3 + 2;
					splitIndex = splitVerts.get_length() / 3 | 0;
					s0 = splitIndex * 3;
					s1 = splitIndex * 3 + 1;
					s2 = splitIndex * 3 + 2;
					splitVerts.set(s0,verts.get(o0));
					splitVerts.set(s1,verts.get(o1));
					splitVerts.set(s2,verts.get(o2));
					if(uvs != null) {
						su = splitIndex * 2;
						sv = splitIndex * 2 + 1;
						ou = originalIndex * 2;
						ov = originalIndex * 2 + 1;
						splitUvs.set(su,uvs.get(ou));
						splitUvs.set(sv,uvs.get(ov));
					}
					if(normals != null) {
						splitNormals.set(s0,normals.get(o0));
						splitNormals.set(s1,normals.get(o1));
						splitNormals.set(s2,normals.get(o2));
					}
					if(tangents != null) {
						splitTangents.set(s0,tangents.get(o0));
						splitTangents.set(s1,tangents.get(o1));
						splitTangents.set(s2,tangents.get(o2));
					}
					if(weights != null) {
						splitWeights.set(s0,weights.get(o0));
						splitWeights.set(s1,weights.get(o1));
						splitWeights.set(s2,weights.get(o2));
					}
					if(jointIndices != null) {
						splitJointIndices.set(s0,jointIndices.get(o0));
						splitJointIndices.set(s1,jointIndices.get(o1));
						splitJointIndices.set(s2,jointIndices.get(o2));
					}
					mappings.set(originalIndex,splitIndex);
				}
				splitIndices.set(outIndex + j1,splitIndex);
			}
			outIndex += 3;
			i += 3;
		}
		if(splitVerts.get_length() > 0) {
			subs.push(away3d_tools_utils_GeomUtil.constructSubGeometry(splitVerts,splitIndices,splitUvs,splitNormals,splitTangents,splitWeights,splitJointIndices,triangleOffset));
		}
	} else {
		subs.push(away3d_tools_utils_GeomUtil.constructSubGeometry(verts,indices,uvs,normals,tangents,weights,jointIndices,triangleOffset));
	}
	return subs;
};
away3d_tools_utils_GeomUtil.constructSubGeometry = function(verts,indices,uvs,normals,tangents,weights,jointIndices,triangleOffset) {
	var sub;
	if(weights != null && jointIndices != null) {
		sub = new away3d_core_base_SkinnedSubGeometry(weights.get_length() / (verts.get_length() / 3) | 0);
		(js_Boot.__cast(sub , away3d_core_base_SkinnedSubGeometry)).updateJointWeightsData(weights);
		(js_Boot.__cast(sub , away3d_core_base_SkinnedSubGeometry)).updateJointIndexData(jointIndices);
	} else {
		sub = new away3d_core_base_CompactSubGeometry();
	}
	sub.updateIndexData(indices);
	sub.fromVectors(verts,uvs,normals,tangents);
	return sub;
};
away3d_tools_utils_GeomUtil.interleaveBuffers = function(numVertices,vertices,normals,tangents,uvs,suvs) {
	var i = 0;
	var compIndex;
	var uvCompIndex;
	var interleavedCompIndex;
	var interleavedBuffer = openfl__$Vector_Vector_$Impl_$.toFloatVector(null);
	var _g = 0;
	var _g1 = numVertices;
	while(_g < _g1) {
		var i1 = _g++;
		uvCompIndex = i1 * 2;
		compIndex = i1 * 3;
		interleavedCompIndex = i1 * 13;
		interleavedBuffer.set(interleavedCompIndex,vertices != null ? vertices.get(compIndex) : 0);
		interleavedBuffer.set(interleavedCompIndex + 1,vertices != null ? vertices.get(compIndex + 1) : 0);
		interleavedBuffer.set(interleavedCompIndex + 2,vertices != null ? vertices.get(compIndex + 2) : 0);
		interleavedBuffer.set(interleavedCompIndex + 3,normals != null ? normals.get(compIndex) : 0);
		interleavedBuffer.set(interleavedCompIndex + 4,normals != null ? normals.get(compIndex + 1) : 0);
		interleavedBuffer.set(interleavedCompIndex + 5,normals != null ? normals.get(compIndex + 2) : 0);
		interleavedBuffer.set(interleavedCompIndex + 6,tangents != null ? tangents.get(compIndex) : 0);
		interleavedBuffer.set(interleavedCompIndex + 7,tangents != null ? tangents.get(compIndex + 1) : 0);
		interleavedBuffer.set(interleavedCompIndex + 8,tangents != null ? tangents.get(compIndex + 2) : 0);
		interleavedBuffer.set(interleavedCompIndex + 9,uvs != null ? uvs.get(uvCompIndex) : 0);
		interleavedBuffer.set(interleavedCompIndex + 10,uvs != null ? uvs.get(uvCompIndex + 1) : 0);
		interleavedBuffer.set(interleavedCompIndex + 11,suvs != null ? suvs.get(uvCompIndex) : 0);
		interleavedBuffer.set(interleavedCompIndex + 12,suvs != null ? suvs.get(uvCompIndex + 1) : 0);
	}
	return interleavedBuffer;
};
away3d_tools_utils_GeomUtil.getMeshSubgeometryIndex = function(subGeometry) {
	var index = 0;
	var subGeometries = subGeometry.get_parentGeometry().get_subGeometries();
	var _g = 0;
	var _g1 = subGeometries.get_length();
	while(_g < _g1) {
		var i = _g++;
		if(subGeometries.get(i) == subGeometry) {
			index = i;
			break;
		}
	}
	return index;
};
away3d_tools_utils_GeomUtil.getMeshSubMeshIndex = function(subMesh) {
	var index = 0;
	var subMeshes = subMesh.get_parentMesh().get_subMeshes();
	var _g = 0;
	var _g1 = subMeshes.get_length();
	while(_g < _g1) {
		var i = _g++;
		if(subMeshes.get(i) == subMesh) {
			index = i;
			break;
		}
	}
	return index;
};
var away3d_tools_utils_TextureUtils = function() { };
$hxClasses["away3d.tools.utils.TextureUtils"] = away3d_tools_utils_TextureUtils;
away3d_tools_utils_TextureUtils.__name__ = "away3d.tools.utils.TextureUtils";
away3d_tools_utils_TextureUtils.isBitmapDataValid = function(bitmapData) {
	if(bitmapData == null) {
		return true;
	}
	if(away3d_tools_utils_TextureUtils.isDimensionValid(bitmapData.width)) {
		return away3d_tools_utils_TextureUtils.isDimensionValid(bitmapData.height);
	} else {
		return false;
	}
};
away3d_tools_utils_TextureUtils.isDimensionValid = function(d) {
	if(d >= 1 && d <= 4096) {
		return away3d_tools_utils_TextureUtils.isPowerOfTwo(d);
	} else {
		return false;
	}
};
away3d_tools_utils_TextureUtils.isPowerOfTwo = function(value) {
	if(value > 0) {
		return (value & -value) == value;
	} else {
		return false;
	}
};
away3d_tools_utils_TextureUtils.getBestPowerOf2 = function(value) {
	var p = 1;
	while(p < value) p <<= 1;
	if(p > 4096) {
		p = 4096;
	}
	return p;
};
var away3d_utils_Cast = function() { };
$hxClasses["away3d.utils.Cast"] = away3d_utils_Cast;
away3d_utils_Cast.__name__ = "away3d.utils.Cast";
away3d_utils_Cast.string = function(data) {
	if(js_Boot.__instanceof(data,Class)) {
		data = Type.createInstance(data,[]);
	}
	if(typeof(data) == "string") {
		return data;
	}
	return Std.string(data);
};
away3d_utils_Cast.byteArray = function(data) {
	if(js_Boot.__instanceof(data,Class)) {
		data = Type.createInstance(data,[]);
	}
	if(((data) instanceof openfl_utils_ByteArrayData)) {
		return data;
	}
	if(((data) instanceof haxe_io_Bytes)) {
		return js_Boot.__cast(data , openfl_utils_ByteArrayData);
	}
	return null;
};
away3d_utils_Cast.isHex = function(string) {
	var length = string.length;
	var _g = 0;
	var _g1 = length;
	while(_g < _g1) {
		var i = _g++;
		if(away3d_utils_Cast._hexChars.indexOf(string.charAt(i)) == -1) {
			return false;
		}
	}
	return true;
};
away3d_utils_Cast.tryColor = function(data) {
	if(typeof(data) == "number" && ((data | 0) === data)) {
		return data;
	}
	if(typeof(data) == "string") {
		if(data == "random") {
			return Math.random() * 16777216 | 0;
		}
		if(away3d_utils_Cast._colorNames == null) {
			away3d_utils_Cast._colorNames = new haxe_ds_StringMap();
			var _this = away3d_utils_Cast._colorNames;
			if(__map_reserved["steelblue"] != null) {
				_this.setReserved("steelblue",4620980);
			} else {
				_this.h["steelblue"] = 4620980;
			}
			var _this1 = away3d_utils_Cast._colorNames;
			if(__map_reserved["royalblue"] != null) {
				_this1.setReserved("royalblue",267920);
			} else {
				_this1.h["royalblue"] = 267920;
			}
			var _this2 = away3d_utils_Cast._colorNames;
			if(__map_reserved["cornflowerblue"] != null) {
				_this2.setReserved("cornflowerblue",6591981);
			} else {
				_this2.h["cornflowerblue"] = 6591981;
			}
			var _this3 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightsteelblue"] != null) {
				_this3.setReserved("lightsteelblue",11584734);
			} else {
				_this3.h["lightsteelblue"] = 11584734;
			}
			var _this4 = away3d_utils_Cast._colorNames;
			if(__map_reserved["mediumslateblue"] != null) {
				_this4.setReserved("mediumslateblue",8087790);
			} else {
				_this4.h["mediumslateblue"] = 8087790;
			}
			var _this5 = away3d_utils_Cast._colorNames;
			if(__map_reserved["slateblue"] != null) {
				_this5.setReserved("slateblue",6970061);
			} else {
				_this5.h["slateblue"] = 6970061;
			}
			var _this6 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkslateblue"] != null) {
				_this6.setReserved("darkslateblue",4734347);
			} else {
				_this6.h["darkslateblue"] = 4734347;
			}
			var _this7 = away3d_utils_Cast._colorNames;
			if(__map_reserved["midnightblue"] != null) {
				_this7.setReserved("midnightblue",1644912);
			} else {
				_this7.h["midnightblue"] = 1644912;
			}
			var _this8 = away3d_utils_Cast._colorNames;
			if(__map_reserved["navy"] != null) {
				_this8.setReserved("navy",128);
			} else {
				_this8.h["navy"] = 128;
			}
			var _this9 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkblue"] != null) {
				_this9.setReserved("darkblue",139);
			} else {
				_this9.h["darkblue"] = 139;
			}
			var _this10 = away3d_utils_Cast._colorNames;
			if(__map_reserved["mediumblue"] != null) {
				_this10.setReserved("mediumblue",205);
			} else {
				_this10.h["mediumblue"] = 205;
			}
			var _this11 = away3d_utils_Cast._colorNames;
			if(__map_reserved["blue"] != null) {
				_this11.setReserved("blue",255);
			} else {
				_this11.h["blue"] = 255;
			}
			var _this12 = away3d_utils_Cast._colorNames;
			if(__map_reserved["dodgerblue"] != null) {
				_this12.setReserved("dodgerblue",2003199);
			} else {
				_this12.h["dodgerblue"] = 2003199;
			}
			var _this13 = away3d_utils_Cast._colorNames;
			if(__map_reserved["deepskyblue"] != null) {
				_this13.setReserved("deepskyblue",49151);
			} else {
				_this13.h["deepskyblue"] = 49151;
			}
			var _this14 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightskyblue"] != null) {
				_this14.setReserved("lightskyblue",8900346);
			} else {
				_this14.h["lightskyblue"] = 8900346;
			}
			var _this15 = away3d_utils_Cast._colorNames;
			if(__map_reserved["skyblue"] != null) {
				_this15.setReserved("skyblue",8900331);
			} else {
				_this15.h["skyblue"] = 8900331;
			}
			var _this16 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightblue"] != null) {
				_this16.setReserved("lightblue",11393254);
			} else {
				_this16.h["lightblue"] = 11393254;
			}
			var _this17 = away3d_utils_Cast._colorNames;
			if(__map_reserved["powderblue"] != null) {
				_this17.setReserved("powderblue",11591910);
			} else {
				_this17.h["powderblue"] = 11591910;
			}
			var _this18 = away3d_utils_Cast._colorNames;
			if(__map_reserved["azure"] != null) {
				_this18.setReserved("azure",15794175);
			} else {
				_this18.h["azure"] = 15794175;
			}
			var _this19 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightcyan"] != null) {
				_this19.setReserved("lightcyan",14745599);
			} else {
				_this19.h["lightcyan"] = 14745599;
			}
			var _this20 = away3d_utils_Cast._colorNames;
			if(__map_reserved["paleturquoise"] != null) {
				_this20.setReserved("paleturquoise",11529966);
			} else {
				_this20.h["paleturquoise"] = 11529966;
			}
			var _this21 = away3d_utils_Cast._colorNames;
			if(__map_reserved["mediumturquoise"] != null) {
				_this21.setReserved("mediumturquoise",4772300);
			} else {
				_this21.h["mediumturquoise"] = 4772300;
			}
			var _this22 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightseagreen"] != null) {
				_this22.setReserved("lightseagreen",2142890);
			} else {
				_this22.h["lightseagreen"] = 2142890;
			}
			var _this23 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkcyan"] != null) {
				_this23.setReserved("darkcyan",35723);
			} else {
				_this23.h["darkcyan"] = 35723;
			}
			var _this24 = away3d_utils_Cast._colorNames;
			if(__map_reserved["teal"] != null) {
				_this24.setReserved("teal",32896);
			} else {
				_this24.h["teal"] = 32896;
			}
			var _this25 = away3d_utils_Cast._colorNames;
			if(__map_reserved["cadetblue"] != null) {
				_this25.setReserved("cadetblue",6266528);
			} else {
				_this25.h["cadetblue"] = 6266528;
			}
			var _this26 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkturquoise"] != null) {
				_this26.setReserved("darkturquoise",52945);
			} else {
				_this26.h["darkturquoise"] = 52945;
			}
			var _this27 = away3d_utils_Cast._colorNames;
			if(__map_reserved["aqua"] != null) {
				_this27.setReserved("aqua",65535);
			} else {
				_this27.h["aqua"] = 65535;
			}
			var _this28 = away3d_utils_Cast._colorNames;
			if(__map_reserved["cyan"] != null) {
				_this28.setReserved("cyan",65535);
			} else {
				_this28.h["cyan"] = 65535;
			}
			var _this29 = away3d_utils_Cast._colorNames;
			if(__map_reserved["turquoise"] != null) {
				_this29.setReserved("turquoise",4251856);
			} else {
				_this29.h["turquoise"] = 4251856;
			}
			var _this30 = away3d_utils_Cast._colorNames;
			if(__map_reserved["aquamarine"] != null) {
				_this30.setReserved("aquamarine",8388564);
			} else {
				_this30.h["aquamarine"] = 8388564;
			}
			var _this31 = away3d_utils_Cast._colorNames;
			if(__map_reserved["mediumaquamarine"] != null) {
				_this31.setReserved("mediumaquamarine",6737322);
			} else {
				_this31.h["mediumaquamarine"] = 6737322;
			}
			var _this32 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkseagreen"] != null) {
				_this32.setReserved("darkseagreen",9419919);
			} else {
				_this32.h["darkseagreen"] = 9419919;
			}
			var _this33 = away3d_utils_Cast._colorNames;
			if(__map_reserved["mediumseagreen"] != null) {
				_this33.setReserved("mediumseagreen",3978097);
			} else {
				_this33.h["mediumseagreen"] = 3978097;
			}
			var _this34 = away3d_utils_Cast._colorNames;
			if(__map_reserved["seagreen"] != null) {
				_this34.setReserved("seagreen",3050327);
			} else {
				_this34.h["seagreen"] = 3050327;
			}
			var _this35 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkgreen"] != null) {
				_this35.setReserved("darkgreen",25600);
			} else {
				_this35.h["darkgreen"] = 25600;
			}
			var _this36 = away3d_utils_Cast._colorNames;
			if(__map_reserved["green"] != null) {
				_this36.setReserved("green",32768);
			} else {
				_this36.h["green"] = 32768;
			}
			var _this37 = away3d_utils_Cast._colorNames;
			if(__map_reserved["forestgreen"] != null) {
				_this37.setReserved("forestgreen",2263842);
			} else {
				_this37.h["forestgreen"] = 2263842;
			}
			var _this38 = away3d_utils_Cast._colorNames;
			if(__map_reserved["limegreen"] != null) {
				_this38.setReserved("limegreen",3329330);
			} else {
				_this38.h["limegreen"] = 3329330;
			}
			var _this39 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lime"] != null) {
				_this39.setReserved("lime",65280);
			} else {
				_this39.h["lime"] = 65280;
			}
			var _this40 = away3d_utils_Cast._colorNames;
			if(__map_reserved["chartreuse"] != null) {
				_this40.setReserved("chartreuse",8388352);
			} else {
				_this40.h["chartreuse"] = 8388352;
			}
			var _this41 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lawngreen"] != null) {
				_this41.setReserved("lawngreen",8190976);
			} else {
				_this41.h["lawngreen"] = 8190976;
			}
			var _this42 = away3d_utils_Cast._colorNames;
			if(__map_reserved["greenyellow"] != null) {
				_this42.setReserved("greenyellow",11403055);
			} else {
				_this42.h["greenyellow"] = 11403055;
			}
			var _this43 = away3d_utils_Cast._colorNames;
			if(__map_reserved["yellowgreen"] != null) {
				_this43.setReserved("yellowgreen",10145074);
			} else {
				_this43.h["yellowgreen"] = 10145074;
			}
			var _this44 = away3d_utils_Cast._colorNames;
			if(__map_reserved["palegreen"] != null) {
				_this44.setReserved("palegreen",10025880);
			} else {
				_this44.h["palegreen"] = 10025880;
			}
			var _this45 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightgreen"] != null) {
				_this45.setReserved("lightgreen",9498256);
			} else {
				_this45.h["lightgreen"] = 9498256;
			}
			var _this46 = away3d_utils_Cast._colorNames;
			if(__map_reserved["springgreen"] != null) {
				_this46.setReserved("springgreen",65407);
			} else {
				_this46.h["springgreen"] = 65407;
			}
			var _this47 = away3d_utils_Cast._colorNames;
			if(__map_reserved["mediumspringgreen"] != null) {
				_this47.setReserved("mediumspringgreen",64154);
			} else {
				_this47.h["mediumspringgreen"] = 64154;
			}
			var _this48 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkolivegreen"] != null) {
				_this48.setReserved("darkolivegreen",5597999);
			} else {
				_this48.h["darkolivegreen"] = 5597999;
			}
			var _this49 = away3d_utils_Cast._colorNames;
			if(__map_reserved["olivedrab"] != null) {
				_this49.setReserved("olivedrab",7048739);
			} else {
				_this49.h["olivedrab"] = 7048739;
			}
			var _this50 = away3d_utils_Cast._colorNames;
			if(__map_reserved["olive"] != null) {
				_this50.setReserved("olive",8421376);
			} else {
				_this50.h["olive"] = 8421376;
			}
			var _this51 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkkhaki"] != null) {
				_this51.setReserved("darkkhaki",12433259);
			} else {
				_this51.h["darkkhaki"] = 12433259;
			}
			var _this52 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkgoldenrod"] != null) {
				_this52.setReserved("darkgoldenrod",12092939);
			} else {
				_this52.h["darkgoldenrod"] = 12092939;
			}
			var _this53 = away3d_utils_Cast._colorNames;
			if(__map_reserved["goldenrod"] != null) {
				_this53.setReserved("goldenrod",14329120);
			} else {
				_this53.h["goldenrod"] = 14329120;
			}
			var _this54 = away3d_utils_Cast._colorNames;
			if(__map_reserved["gold"] != null) {
				_this54.setReserved("gold",16766720);
			} else {
				_this54.h["gold"] = 16766720;
			}
			var _this55 = away3d_utils_Cast._colorNames;
			if(__map_reserved["yellow"] != null) {
				_this55.setReserved("yellow",16776960);
			} else {
				_this55.h["yellow"] = 16776960;
			}
			var _this56 = away3d_utils_Cast._colorNames;
			if(__map_reserved["khaki"] != null) {
				_this56.setReserved("khaki",15787660);
			} else {
				_this56.h["khaki"] = 15787660;
			}
			var _this57 = away3d_utils_Cast._colorNames;
			if(__map_reserved["palegoldenrod"] != null) {
				_this57.setReserved("palegoldenrod",15657130);
			} else {
				_this57.h["palegoldenrod"] = 15657130;
			}
			var _this58 = away3d_utils_Cast._colorNames;
			if(__map_reserved["blanchedalmond"] != null) {
				_this58.setReserved("blanchedalmond",16772045);
			} else {
				_this58.h["blanchedalmond"] = 16772045;
			}
			var _this59 = away3d_utils_Cast._colorNames;
			if(__map_reserved["moccasin"] != null) {
				_this59.setReserved("moccasin",16770229);
			} else {
				_this59.h["moccasin"] = 16770229;
			}
			var _this60 = away3d_utils_Cast._colorNames;
			if(__map_reserved["wheat"] != null) {
				_this60.setReserved("wheat",16113331);
			} else {
				_this60.h["wheat"] = 16113331;
			}
			var _this61 = away3d_utils_Cast._colorNames;
			if(__map_reserved["navajowhite"] != null) {
				_this61.setReserved("navajowhite",16768685);
			} else {
				_this61.h["navajowhite"] = 16768685;
			}
			var _this62 = away3d_utils_Cast._colorNames;
			if(__map_reserved["burlywood"] != null) {
				_this62.setReserved("burlywood",14596231);
			} else {
				_this62.h["burlywood"] = 14596231;
			}
			var _this63 = away3d_utils_Cast._colorNames;
			if(__map_reserved["tan"] != null) {
				_this63.setReserved("tan",13808780);
			} else {
				_this63.h["tan"] = 13808780;
			}
			var _this64 = away3d_utils_Cast._colorNames;
			if(__map_reserved["rosybrown"] != null) {
				_this64.setReserved("rosybrown",12357519);
			} else {
				_this64.h["rosybrown"] = 12357519;
			}
			var _this65 = away3d_utils_Cast._colorNames;
			if(__map_reserved["sienna"] != null) {
				_this65.setReserved("sienna",10506797);
			} else {
				_this65.h["sienna"] = 10506797;
			}
			var _this66 = away3d_utils_Cast._colorNames;
			if(__map_reserved["saddlebrown"] != null) {
				_this66.setReserved("saddlebrown",9127187);
			} else {
				_this66.h["saddlebrown"] = 9127187;
			}
			var _this67 = away3d_utils_Cast._colorNames;
			if(__map_reserved["chocolate"] != null) {
				_this67.setReserved("chocolate",13789470);
			} else {
				_this67.h["chocolate"] = 13789470;
			}
			var _this68 = away3d_utils_Cast._colorNames;
			if(__map_reserved["peru"] != null) {
				_this68.setReserved("peru",13468991);
			} else {
				_this68.h["peru"] = 13468991;
			}
			var _this69 = away3d_utils_Cast._colorNames;
			if(__map_reserved["sandybrown"] != null) {
				_this69.setReserved("sandybrown",16032864);
			} else {
				_this69.h["sandybrown"] = 16032864;
			}
			var _this70 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkred"] != null) {
				_this70.setReserved("darkred",9109504);
			} else {
				_this70.h["darkred"] = 9109504;
			}
			var _this71 = away3d_utils_Cast._colorNames;
			if(__map_reserved["maroon"] != null) {
				_this71.setReserved("maroon",8388608);
			} else {
				_this71.h["maroon"] = 8388608;
			}
			var _this72 = away3d_utils_Cast._colorNames;
			if(__map_reserved["brown"] != null) {
				_this72.setReserved("brown",10824234);
			} else {
				_this72.h["brown"] = 10824234;
			}
			var _this73 = away3d_utils_Cast._colorNames;
			if(__map_reserved["firebrick"] != null) {
				_this73.setReserved("firebrick",11674146);
			} else {
				_this73.h["firebrick"] = 11674146;
			}
			var _this74 = away3d_utils_Cast._colorNames;
			if(__map_reserved["indianred"] != null) {
				_this74.setReserved("indianred",13458524);
			} else {
				_this74.h["indianred"] = 13458524;
			}
			var _this75 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightcoral"] != null) {
				_this75.setReserved("lightcoral",15761536);
			} else {
				_this75.h["lightcoral"] = 15761536;
			}
			var _this76 = away3d_utils_Cast._colorNames;
			if(__map_reserved["salmon"] != null) {
				_this76.setReserved("salmon",16416882);
			} else {
				_this76.h["salmon"] = 16416882;
			}
			var _this77 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darksalmon"] != null) {
				_this77.setReserved("darksalmon",15308410);
			} else {
				_this77.h["darksalmon"] = 15308410;
			}
			var _this78 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightsalmon"] != null) {
				_this78.setReserved("lightsalmon",16752762);
			} else {
				_this78.h["lightsalmon"] = 16752762;
			}
			var _this79 = away3d_utils_Cast._colorNames;
			if(__map_reserved["coral"] != null) {
				_this79.setReserved("coral",16744272);
			} else {
				_this79.h["coral"] = 16744272;
			}
			var _this80 = away3d_utils_Cast._colorNames;
			if(__map_reserved["tomato"] != null) {
				_this80.setReserved("tomato",16737095);
			} else {
				_this80.h["tomato"] = 16737095;
			}
			var _this81 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkorange"] != null) {
				_this81.setReserved("darkorange",16747520);
			} else {
				_this81.h["darkorange"] = 16747520;
			}
			var _this82 = away3d_utils_Cast._colorNames;
			if(__map_reserved["orange"] != null) {
				_this82.setReserved("orange",16753920);
			} else {
				_this82.h["orange"] = 16753920;
			}
			var _this83 = away3d_utils_Cast._colorNames;
			if(__map_reserved["orangered"] != null) {
				_this83.setReserved("orangered",16729344);
			} else {
				_this83.h["orangered"] = 16729344;
			}
			var _this84 = away3d_utils_Cast._colorNames;
			if(__map_reserved["crimson"] != null) {
				_this84.setReserved("crimson",14423100);
			} else {
				_this84.h["crimson"] = 14423100;
			}
			var _this85 = away3d_utils_Cast._colorNames;
			if(__map_reserved["red"] != null) {
				_this85.setReserved("red",16711680);
			} else {
				_this85.h["red"] = 16711680;
			}
			var _this86 = away3d_utils_Cast._colorNames;
			if(__map_reserved["deeppink"] != null) {
				_this86.setReserved("deeppink",16716947);
			} else {
				_this86.h["deeppink"] = 16716947;
			}
			var _this87 = away3d_utils_Cast._colorNames;
			if(__map_reserved["fuchsia"] != null) {
				_this87.setReserved("fuchsia",16711935);
			} else {
				_this87.h["fuchsia"] = 16711935;
			}
			var _this88 = away3d_utils_Cast._colorNames;
			if(__map_reserved["magenta"] != null) {
				_this88.setReserved("magenta",16711935);
			} else {
				_this88.h["magenta"] = 16711935;
			}
			var _this89 = away3d_utils_Cast._colorNames;
			if(__map_reserved["hotpink"] != null) {
				_this89.setReserved("hotpink",16738740);
			} else {
				_this89.h["hotpink"] = 16738740;
			}
			var _this90 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightpink"] != null) {
				_this90.setReserved("lightpink",16758465);
			} else {
				_this90.h["lightpink"] = 16758465;
			}
			var _this91 = away3d_utils_Cast._colorNames;
			if(__map_reserved["pink"] != null) {
				_this91.setReserved("pink",16761035);
			} else {
				_this91.h["pink"] = 16761035;
			}
			var _this92 = away3d_utils_Cast._colorNames;
			if(__map_reserved["palevioletred"] != null) {
				_this92.setReserved("palevioletred",14381203);
			} else {
				_this92.h["palevioletred"] = 14381203;
			}
			var _this93 = away3d_utils_Cast._colorNames;
			if(__map_reserved["mediumvioletred"] != null) {
				_this93.setReserved("mediumvioletred",13047173);
			} else {
				_this93.h["mediumvioletred"] = 13047173;
			}
			var _this94 = away3d_utils_Cast._colorNames;
			if(__map_reserved["purple"] != null) {
				_this94.setReserved("purple",8388736);
			} else {
				_this94.h["purple"] = 8388736;
			}
			var _this95 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkmagenta"] != null) {
				_this95.setReserved("darkmagenta",9109643);
			} else {
				_this95.h["darkmagenta"] = 9109643;
			}
			var _this96 = away3d_utils_Cast._colorNames;
			if(__map_reserved["mediumpurple"] != null) {
				_this96.setReserved("mediumpurple",9662683);
			} else {
				_this96.h["mediumpurple"] = 9662683;
			}
			var _this97 = away3d_utils_Cast._colorNames;
			if(__map_reserved["blueviolet"] != null) {
				_this97.setReserved("blueviolet",9055202);
			} else {
				_this97.h["blueviolet"] = 9055202;
			}
			var _this98 = away3d_utils_Cast._colorNames;
			if(__map_reserved["indigo"] != null) {
				_this98.setReserved("indigo",4915330);
			} else {
				_this98.h["indigo"] = 4915330;
			}
			var _this99 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkviolet"] != null) {
				_this99.setReserved("darkviolet",9699539);
			} else {
				_this99.h["darkviolet"] = 9699539;
			}
			var _this100 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkorchid"] != null) {
				_this100.setReserved("darkorchid",10040012);
			} else {
				_this100.h["darkorchid"] = 10040012;
			}
			var _this101 = away3d_utils_Cast._colorNames;
			if(__map_reserved["mediumorchid"] != null) {
				_this101.setReserved("mediumorchid",12211667);
			} else {
				_this101.h["mediumorchid"] = 12211667;
			}
			var _this102 = away3d_utils_Cast._colorNames;
			if(__map_reserved["orchid"] != null) {
				_this102.setReserved("orchid",14315734);
			} else {
				_this102.h["orchid"] = 14315734;
			}
			var _this103 = away3d_utils_Cast._colorNames;
			if(__map_reserved["violet"] != null) {
				_this103.setReserved("violet",15631086);
			} else {
				_this103.h["violet"] = 15631086;
			}
			var _this104 = away3d_utils_Cast._colorNames;
			if(__map_reserved["plum"] != null) {
				_this104.setReserved("plum",14524637);
			} else {
				_this104.h["plum"] = 14524637;
			}
			var _this105 = away3d_utils_Cast._colorNames;
			if(__map_reserved["thistle"] != null) {
				_this105.setReserved("thistle",14204888);
			} else {
				_this105.h["thistle"] = 14204888;
			}
			var _this106 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lavender"] != null) {
				_this106.setReserved("lavender",15132410);
			} else {
				_this106.h["lavender"] = 15132410;
			}
			var _this107 = away3d_utils_Cast._colorNames;
			if(__map_reserved["ghostwhite"] != null) {
				_this107.setReserved("ghostwhite",16316671);
			} else {
				_this107.h["ghostwhite"] = 16316671;
			}
			var _this108 = away3d_utils_Cast._colorNames;
			if(__map_reserved["aliceblue"] != null) {
				_this108.setReserved("aliceblue",15792383);
			} else {
				_this108.h["aliceblue"] = 15792383;
			}
			var _this109 = away3d_utils_Cast._colorNames;
			if(__map_reserved["mintcream"] != null) {
				_this109.setReserved("mintcream",16121850);
			} else {
				_this109.h["mintcream"] = 16121850;
			}
			var _this110 = away3d_utils_Cast._colorNames;
			if(__map_reserved["honeydew"] != null) {
				_this110.setReserved("honeydew",15794160);
			} else {
				_this110.h["honeydew"] = 15794160;
			}
			var _this111 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightgoldenrodyellow"] != null) {
				_this111.setReserved("lightgoldenrodyellow",16448210);
			} else {
				_this111.h["lightgoldenrodyellow"] = 16448210;
			}
			var _this112 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lemonchiffon"] != null) {
				_this112.setReserved("lemonchiffon",16775885);
			} else {
				_this112.h["lemonchiffon"] = 16775885;
			}
			var _this113 = away3d_utils_Cast._colorNames;
			if(__map_reserved["cornsilk"] != null) {
				_this113.setReserved("cornsilk",16775388);
			} else {
				_this113.h["cornsilk"] = 16775388;
			}
			var _this114 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightyellow"] != null) {
				_this114.setReserved("lightyellow",16777184);
			} else {
				_this114.h["lightyellow"] = 16777184;
			}
			var _this115 = away3d_utils_Cast._colorNames;
			if(__map_reserved["ivory"] != null) {
				_this115.setReserved("ivory",16777200);
			} else {
				_this115.h["ivory"] = 16777200;
			}
			var _this116 = away3d_utils_Cast._colorNames;
			if(__map_reserved["floralwhite"] != null) {
				_this116.setReserved("floralwhite",16775920);
			} else {
				_this116.h["floralwhite"] = 16775920;
			}
			var _this117 = away3d_utils_Cast._colorNames;
			if(__map_reserved["linen"] != null) {
				_this117.setReserved("linen",16445670);
			} else {
				_this117.h["linen"] = 16445670;
			}
			var _this118 = away3d_utils_Cast._colorNames;
			if(__map_reserved["oldlace"] != null) {
				_this118.setReserved("oldlace",16643558);
			} else {
				_this118.h["oldlace"] = 16643558;
			}
			var _this119 = away3d_utils_Cast._colorNames;
			if(__map_reserved["antiquewhite"] != null) {
				_this119.setReserved("antiquewhite",16444375);
			} else {
				_this119.h["antiquewhite"] = 16444375;
			}
			var _this120 = away3d_utils_Cast._colorNames;
			if(__map_reserved["bisque"] != null) {
				_this120.setReserved("bisque",16770244);
			} else {
				_this120.h["bisque"] = 16770244;
			}
			var _this121 = away3d_utils_Cast._colorNames;
			if(__map_reserved["peachpuff"] != null) {
				_this121.setReserved("peachpuff",16767673);
			} else {
				_this121.h["peachpuff"] = 16767673;
			}
			var _this122 = away3d_utils_Cast._colorNames;
			if(__map_reserved["papayawhip"] != null) {
				_this122.setReserved("papayawhip",16773077);
			} else {
				_this122.h["papayawhip"] = 16773077;
			}
			var _this123 = away3d_utils_Cast._colorNames;
			if(__map_reserved["beige"] != null) {
				_this123.setReserved("beige",16119260);
			} else {
				_this123.h["beige"] = 16119260;
			}
			var _this124 = away3d_utils_Cast._colorNames;
			if(__map_reserved["seashell"] != null) {
				_this124.setReserved("seashell",16774638);
			} else {
				_this124.h["seashell"] = 16774638;
			}
			var _this125 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lavenderblush"] != null) {
				_this125.setReserved("lavenderblush",16773365);
			} else {
				_this125.h["lavenderblush"] = 16773365;
			}
			var _this126 = away3d_utils_Cast._colorNames;
			if(__map_reserved["mistyrose"] != null) {
				_this126.setReserved("mistyrose",16770273);
			} else {
				_this126.h["mistyrose"] = 16770273;
			}
			var _this127 = away3d_utils_Cast._colorNames;
			if(__map_reserved["snow"] != null) {
				_this127.setReserved("snow",16775930);
			} else {
				_this127.h["snow"] = 16775930;
			}
			var _this128 = away3d_utils_Cast._colorNames;
			if(__map_reserved["white"] != null) {
				_this128.setReserved("white",16777215);
			} else {
				_this128.h["white"] = 16777215;
			}
			var _this129 = away3d_utils_Cast._colorNames;
			if(__map_reserved["whitesmoke"] != null) {
				_this129.setReserved("whitesmoke",16119285);
			} else {
				_this129.h["whitesmoke"] = 16119285;
			}
			var _this130 = away3d_utils_Cast._colorNames;
			if(__map_reserved["gainsboro"] != null) {
				_this130.setReserved("gainsboro",14474460);
			} else {
				_this130.h["gainsboro"] = 14474460;
			}
			var _this131 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightgrey"] != null) {
				_this131.setReserved("lightgrey",13882323);
			} else {
				_this131.h["lightgrey"] = 13882323;
			}
			var _this132 = away3d_utils_Cast._colorNames;
			if(__map_reserved["silver"] != null) {
				_this132.setReserved("silver",12632256);
			} else {
				_this132.h["silver"] = 12632256;
			}
			var _this133 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkgrey"] != null) {
				_this133.setReserved("darkgrey",11119017);
			} else {
				_this133.h["darkgrey"] = 11119017;
			}
			var _this134 = away3d_utils_Cast._colorNames;
			if(__map_reserved["grey"] != null) {
				_this134.setReserved("grey",8421504);
			} else {
				_this134.h["grey"] = 8421504;
			}
			var _this135 = away3d_utils_Cast._colorNames;
			if(__map_reserved["lightslategrey"] != null) {
				_this135.setReserved("lightslategrey",7833753);
			} else {
				_this135.h["lightslategrey"] = 7833753;
			}
			var _this136 = away3d_utils_Cast._colorNames;
			if(__map_reserved["slategrey"] != null) {
				_this136.setReserved("slategrey",7372944);
			} else {
				_this136.h["slategrey"] = 7372944;
			}
			var _this137 = away3d_utils_Cast._colorNames;
			if(__map_reserved["dimgrey"] != null) {
				_this137.setReserved("dimgrey",6908265);
			} else {
				_this137.h["dimgrey"] = 6908265;
			}
			var _this138 = away3d_utils_Cast._colorNames;
			if(__map_reserved["darkslategrey"] != null) {
				_this138.setReserved("darkslategrey",3100495);
			} else {
				_this138.h["darkslategrey"] = 3100495;
			}
			var _this139 = away3d_utils_Cast._colorNames;
			if(__map_reserved["black"] != null) {
				_this139.setReserved("black",0);
			} else {
				_this139.h["black"] = 0;
			}
			var _this140 = away3d_utils_Cast._colorNames;
			if(__map_reserved["transparent"] != null) {
				_this140.setReserved("transparent",-16777216);
			} else {
				_this140.h["transparent"] = -16777216;
			}
		}
		var dataString = data;
		var _this141 = away3d_utils_Cast._colorNames;
		var key = data;
		if(__map_reserved[key] != null ? _this141.existsReserved(key) : _this141.h.hasOwnProperty(key)) {
			var _this142 = away3d_utils_Cast._colorNames;
			var key1 = data;
			if(__map_reserved[key1] != null) {
				return _this142.getReserved(key1);
			} else {
				return _this142.h[key1];
			}
		}
		if(dataString.length == 6 && away3d_utils_Cast.isHex(data)) {
			return Std.parseInt("0x" + dataString);
		}
	}
	return 16777215;
};
away3d_utils_Cast.color = function(data) {
	var result = away3d_utils_Cast.tryColor(data);
	if(result == -1) {
		throw new js__$Boot_HaxeError(new away3d_errors_CastError("Can't cast to color: " + Std.string(data)));
	}
	return result;
};
away3d_utils_Cast.tryClass = function(name) {
	var _this = away3d_utils_Cast._notClasses;
	if(__map_reserved[name] != null ? _this.existsReserved(name) : _this.h.hasOwnProperty(name)) {
		return name;
	}
	var _this1 = away3d_utils_Cast._classes;
	var result = __map_reserved[name] != null ? _this1.getReserved(name) : _this1.h[name];
	if(result != null) {
		return result;
	}
	try {
		result = $hxClasses[name];
		var v = result;
		var _this2 = away3d_utils_Cast._classes;
		var value = v;
		if(__map_reserved[name] != null) {
			_this2.setReserved(name,value);
		} else {
			_this2.h[name] = value;
		}
		return result;
	} catch( error ) {
		haxe_CallStack.lastException = error;
		var error1 = ((error) instanceof js__$Boot_HaxeError) ? error.val : error;
	}
	var _this3 = away3d_utils_Cast._notClasses;
	if(__map_reserved[name] != null) {
	