package;


import haxe.io.Bytes;
import lime.utils.AssetBundle;
import lime.utils.AssetLibrary;
import lime.utils.AssetManifest;
import lime.utils.Assets;

#if sys
import sys.FileSystem;
#end

@:access(lime.utils.Assets)


@:keep @:dox(hide) class ManifestResources {


	public static var preloadLibraries:Array<AssetLibrary>;
	public static var preloadLibraryNames:Array<String>;
	public static var rootPath:String;


	public static function init (config:Dynamic):Void {

		preloadLibraries = new Array ();
		preloadLibraryNames = new Array ();

		rootPath = null;

		if (config != null && Reflect.hasField (config, "rootPath")) {

			rootPath = Reflect.field (config, "rootPath");

		}

		if (rootPath == null) {

			#if (ios || tvos || emscripten)
			rootPath = "assets/";
			#elseif android
			rootPath = "";
			#elseif console
			rootPath = lime.system.System.applicationDirectory;
			#else
			rootPath = "./";
			#end

		}

		#if (openfl && !flash && !display)
		
		#end

		var data, manifest, library, bundle;

		#if kha

		null
		library = AssetLibrary.fromManifest (manifest);
		Assets.registerLibrary ("null", library);

		if (library != null) preloadLibraries.push (library);
		else preloadLibraryNames.push ("null");

		#else

		data = '{"name":null,"assets":"aoy4:pathy36:assets%2Ffonts%2FBerberRevKC_260.pngy4:sizei51223y4:typey5:IMAGEy2:idR1y7:preloadtgoR0y36:assets%2Ffonts%2FBerberRevKC_260.fntR2i8673R3y4:TEXTR5R7R6tgoR0y26:assets%2Fkasajizougray.jpgR2i5243R3R4R5R9R6tgoR0y22:assets%2Fkasajizou.jpgR2i158146R3R4R5R10R6tgoR0y15:assets%2Fob.pngR2i1577R3R4R5R11R6tgoR0y23:assets%2Fkasajizou2.jpgR2i1172499R3R4R5R12R6tgoR0y26:assets%2Ffloor_diffuse.jpgR2i139264R3R4R5R13R6tgoR0y17:assets%2Fkasa.jpgR2i3815R3R4R5R14R6tgoR0y20:assets%2Fmarines.pngR2i1596R3R4R5R15R6tgoR0y17:assets%2Fkasa.pngR2i1416R3R4R5R16R6tgoR0y21:assets%2Fmarines2.pngR2i2784R3R4R5R17R6tgoR0y28:assets%2Ftrinket_diffuse.jpgR2i262144R3R4R5R18R6tgh","rootPath":null,"version":2,"libraryArgs":[],"libraryType":null}';
		manifest = AssetManifest.parse (data, rootPath);
		library = AssetLibrary.fromManifest (manifest);
		Assets.registerLibrary ("default", library);
		

		library = Assets.getLibrary ("default");
		if (library != null) preloadLibraries.push (library);
		else preloadLibraryNames.push ("default");
		

		#end

	}


}


#if kha

null

#else

#if !display
#if flash

@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_fonts_berberrevkc_260_png extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_fonts_berberrevkc_260_fnt extends null { }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_kasajizougray_jpg extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_kasajizou_jpg extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_ob_png extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_kasajizou2_jpg extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_floor_diffuse_jpg extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_kasa_jpg extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_marines_png extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_kasa_png extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_marines2_png extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_trinket_diffuse_jpg extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__manifest_default_json extends null { }


#elseif (desktop || cpp)

@:keep @:image("Assets/fonts/BerberRevKC_260.png") @:noCompletion #if display private #end class __ASSET__assets_fonts_berberrevkc_260_png extends lime.graphics.Image {}
@:keep @:file("Assets/fonts/BerberRevKC_260.fnt") @:noCompletion #if display private #end class __ASSET__assets_fonts_berberrevkc_260_fnt extends haxe.io.Bytes {}
@:keep @:image("Assets/kasajizougray.jpg") @:noCompletion #if display private #end class __ASSET__assets_kasajizougray_jpg extends lime.graphics.Image {}
@:keep @:image("Assets/kasajizou.jpg") @:noCompletion #if display private #end class __ASSET__assets_kasajizou_jpg extends lime.graphics.Image {}
@:keep @:image("Assets/ob.png") @:noCompletion #if display private #end class __ASSET__assets_ob_png extends lime.graphics.Image {}
@:keep @:image("Assets/kasajizou2.jpg") @:noCompletion #if display private #end class __ASSET__assets_kasajizou2_jpg extends lime.graphics.Image {}
@:keep @:image("Assets/floor_diffuse.jpg") @:noCompletion #if display private #end class __ASSET__assets_floor_diffuse_jpg extends lime.graphics.Image {}
@:keep @:image("Assets/kasa.jpg") @:noCompletion #if display private #end class __ASSET__assets_kasa_jpg extends lime.graphics.Image {}
@:keep @:image("Assets/marines.png") @:noCompletion #if display private #end class __ASSET__assets_marines_png extends lime.graphics.Image {}
@:keep @:image("Assets/kasa.png") @:noCompletion #if display private #end class __ASSET__assets_kasa_png extends lime.graphics.Image {}
@:keep @:image("Assets/marines2.png") @:noCompletion #if display private #end class __ASSET__assets_marines2_png extends lime.graphics.Image {}
@:keep @:image("Assets/trinket_diffuse.jpg") @:noCompletion #if display private #end class __ASSET__assets_trinket_diffuse_jpg extends lime.graphics.Image {}
@:keep @:file("") @:noCompletion #if display private #end class __ASSET__manifest_default_json extends haxe.io.Bytes {}



#else



#end

#if (openfl && !flash)

#if html5

#else

#end

#end
#end

#end
