/*

3D Tweening example in Away3d

Demonstrates:

How to use Tweener within a 3D coordinate system.
How to create a 3D mouse event listener on a scene object.
How to return the scene coordinates of a mouse click on the surface of a scene object.

Code by Rob Bateman
rob@infiniteturtles.co.uk
http://www.infiniteturtles.co.uk

This code is distributed under the MIT License

Copyright (c) The Away Foundation http://www.theawayfoundation.org

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the “Software”), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/

package;

import away3d.containers.*;
import away3d.core.pick.*;
import away3d.entities.*;
import away3d.events.*;
import away3d.materials.*;
import away3d.primitives.*;
import away3d.utils.*;
import away3d.textfield.BitmapFont;
import away3d.textfield.HAlign;
import away3d.textfield.TextField;
import away3d.textfield.utils.AwayFont;
import definitions.berberRevKC.BerberRevKC_260;

import motion.Actuate;
import motion.MotionPath;

import openfl.display.*;
import openfl.events.*;
import openfl.events.KeyboardEvent;
import openfl.ui.Keyboard;
import openfl.ui.Mouse;
import openfl.geom.Vector3D;
/*import openfl.text.Font;
import openfl.text.TextField;
import openfl.text.TextFieldAutoSize;
import openfl.text.TextFormat;
import openfl.text.TextFormatAlign;
*/
class Main extends Sprite
{
	//engine variables
	private var _view:View3D;
	
	//scene objects
	private var score:Int;
	private var _text:TextField;
	private var _cube:Mesh;
	private var _cube2:Mesh;
	private var _sphere_head1:Mesh;
	private var _sphere_body1:Mesh;
	private var movingDown:Bool;
	private var movingLeft:Bool;
	private var movingRight:Bool;
	private var movingUp:Bool;
	private var _botamoti_ohagi1:Mesh;
	private var _botamoti_ohagi2:Mesh;
	private var _botamoti_ohagi3:Mesh;
	private var _plane:Mesh;

	/**
	 * Constructor
	 */
	public function new()
	{
		super();
		
		var container = new ObjectContainer3D();
		var textContainer = new ObjectContainer3D();
		var colour:UInt=Std.int(0xFFFFFF*Math.random());
		var bitmapFont:BitmapFont = AwayFont.type(BerberRevKC_260,false);
		var textField:TextField = new TextField(800,400,"SCORE",bitmapFont,100,colour,false,HAlign.CENTER);
		//var textField:TextField = new TextField(800, 600, "THIS IS A TEST", bitmapFont, 100, colour, false, HAlign.CENTER);
		textField.rotationX=90;
		textField.y=400;
		textField.x=-800;
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		
		//setup the view
		_view = new View3D();
		addChild(_view);
	//setup the camera
		//_view.camera.z = -600;
		//_view.camera.y = 500;
		//_view.camera.lookAt(new Vector3D());
		_view.camera.z = -600;
		//_view.camera.x = 500;
		_view.camera.y = 500;
		_view.camera.lookAt(new Vector3D());
		
		//setup the scene
		_plane = new Mesh(new PlaneGeometry(2700, 2700));
		_view.scene.addChild(_plane);
		_cube = new Mesh(new CubeGeometry(200, 100, 100, 1, 1, 1, false), new TextureMaterial(Cast.bitmapTexture("assets/trinket_diffuse.jpg")));
		_cube2 = new Mesh(new CubeGeometry(200, 100, 100, 1, 1, 1, false), new TextureMaterial(Cast.bitmapTexture("assets/trinket_diffuse.jpg")));
		_sphere_head1 = new Mesh(new SphereGeometry(50, 100 ),new TextureMaterial(Cast.bitmapTexture("assets/kasajizou.jpg")));
		_sphere_body1 = new Mesh(new SphereGeometry(50, 100 ),new TextureMaterial(Cast.bitmapTexture("assets/kasajizou.jpg")));
		_botamoti_ohagi1 = new Mesh(new SphereGeometry(50, 100 ),new TextureMaterial(Cast.bitmapTexture("assets/ob.png")));
		_botamoti_ohagi2 = new Mesh(new SphereGeometry(50, 100 ),new TextureMaterial(Cast.bitmapTexture("assets/ob.png")));
		_botamoti_ohagi3 = new Mesh(new SphereGeometry(50, 100 ),new TextureMaterial(Cast.bitmapTexture("assets/ob.png")));
		_cube.y = 50;
		_cube.x = -450;
		_cube2.z = 555;
		_botamoti_ohagi1.z=1300;
		_botamoti_ohagi2.z=1500;
		_botamoti_ohagi3.z=1500;
		_botamoti_ohagi1.x=-500;
		_botamoti_ohagi1.x=500-(1000* Math.random());
		_botamoti_ohagi2.x=500-(1000* Math.random());
		_botamoti_ohagi3.x=500-(1000* Math.random());
		_sphere_head1.x = -500;
		_sphere_body1.x = 0;
		_sphere_head1.y = 70;
		_view.scene.addChild(_botamoti_ohagi1);
		_view.scene.addChild(_botamoti_ohagi2);
		_view.scene.addChild(_botamoti_ohagi3);
		_view.scene.addChild(_sphere_head1);

		_view.scene.addChild(_sphere_body1);
		_view.scene.addChild(textField);
		//_view.scene.addChild(_cylinder6);
		
		
		_plane.y = -100;
		_plane.z = 1000;
		//add mouse listener
		
		//setup the render loop
		addEventListener(Event.ENTER_FRAME, _onEnterFrame);
		stage.addEventListener(Event.RESIZE, onResize);
		stage.addEventListener(KeyboardEvent.KEY_DOWN,stage_onKeyDown);
		stage.addEventListener(KeyboardEvent.KEY_UP,stage_onKeyUp);
		onResize();
	}
	
	/**
	 * render loop
	 */
	private function stage_onKeyDown(event:KeyboardEvent):Void{
					switch (event.keyCode){
									case Keyboard.DOWN: movingDown=true;
									case Keyboard.LEFT: movingLeft=true;
									case Keyboard.RIGHT: movingRight=true;
									case Keyboard.UP: movingUp=true;
					}
	}
	private function stage_onKeyUp(event:KeyboardEvent):Void{
					switch (event.keyCode){
									case Keyboard.DOWN: movingDown=false;
									case Keyboard.LEFT: movingLeft=false;
									case Keyboard.RIGHT: movingRight=false;
									case Keyboard.UP: movingUp=false;
					}
	}
	private function _onEnterFrame(event:Event):Void {
		_sphere_head1.x=mouseX-600;
		_sphere_body1.x=mouseX-600;
		//_sphere_head1.x=screenX;
		//_sphere_body1.x=screenX;
		_botamoti_ohagi1.z -= 5;
		_botamoti_ohagi2.z -= 5;
		_botamoti_ohagi3.z -= 5;
		//if (_sphere_body1.y <  (_botamoti_ohagi1.x + 55) && _sphere_body1.x (_botamoti_ohagi1.y + 55) && _sphere_body1.x > _botamoti_ohagi1.x && _sphere_body1.y > _botamoti_ohagi1.y){
		//if (_sphere_body1.y <  (_botamoti_ohagi1.x + 55) && _sphere_body1.x (_botamoti_ohagi1.y + 55) && _sphere_body1.x > _botamoti_ohagi1.x && _sphere_body1.y > _botamoti_ohagi1.y){
					//	_view.scene.removeChild(_botamoti_ohagi1);
//if (_sphere_body1.x <  (_botamoti_ohagi1.x + 55) && _sphere_body1.y <(_botamoti_ohagi1.y + 55)&& _sphere_body1.x > _botamoti_ohagi1.x && _sphere_body1.y>_botamoti_ohagi1.y){
//trace(_sphere_body1.y <  (_botamoti_ohagi1.x + 55) && _sphere_body1.x (_botamoti_ohagi1.y + 55) && _sphere_body1.x > _botamoti_ohagi1.x && _sphere_body1.y > _botamoti_ohagi1.y);
	//if (_botamoti_ohagi1.z== -300 && _sphere_body1.y){
		if (_sphere_body1.x <  (_botamoti_ohagi1.x + 155) &&  _sphere_body1.x > _botamoti_ohagi1.x && _sphere_body1.z > _botamoti_ohagi1.z&& (_botamoti_ohagi1.z+50 > _sphere_body1.z) ){
					_view.scene.removeChild(_botamoti_ohagi1);
					_botamoti_ohagi1.z = 1500; 
		_botamoti_ohagi1.x=1000* Math.random();
					_view.scene.addChild(_botamoti_ohagi1);
					
		}
		if (_sphere_body1.x <  (_botamoti_ohagi2.x + 55) &&  _sphere_body1.x > _botamoti_ohagi2.x && _sphere_body1.z > _botamoti_ohagi2.z){
					_view.scene.removeChild(_botamoti_ohagi2);
					_botamoti_ohagi2.z = 1500;
		_botamoti_ohagi2.x=1000* Math.random();
					_view.scene.addChild(_botamoti_ohagi2);
					
		}
		if (_sphere_body1.x <  (_botamoti_ohagi3.x + 55) &&  _sphere_body1.x > _botamoti_ohagi3.x && _sphere_body1.z > _botamoti_ohagi3.z){
					_view.scene.removeChild(_botamoti_ohagi3);
					_botamoti_ohagi3.z = 1500;
		_botamoti_ohagi3.x=1000* Math.random();
					_view.scene.addChild(_botamoti_ohagi3);
					
		}

		if (_botamoti_ohagi1.z== -300){
						_view.scene.removeChild(_botamoti_ohagi1);
						_botamoti_ohagi1.z=1500;
		_botamoti_ohagi1.x=500-(1000* Math.random());
						_view.scene.addChild(_botamoti_ohagi1);
		}
		if (_botamoti_ohagi2.z== -300){
						_view.scene.removeChild(_botamoti_ohagi2);
						_botamoti_ohagi2.z=1500;
		_botamoti_ohagi2.x=500-(1000* Math.random());
						_view.scene.addChild(_botamoti_ohagi2);
		}
		if (_botamoti_ohagi3.z== -300){
						_view.scene.removeChild(_botamoti_ohagi3);
						_botamoti_ohagi3.z=1500;
		_botamoti_ohagi3.x=500-(1000* Math.random());
						_view.scene.addChild(_botamoti_ohagi3);
						
		}
		/*
		if (movingLeft){
						_sphere_head1.x -=5;
						_sphere_body1.x -=5;
		}
		if (movingRight){
						_sphere_head1.x +=5;
						_sphere_body1.x +=5;
		}
		*/
/*		if (movingUp){
						_sphere_head1.y +=5;
						_sphere_body1.y +=5;
		}
		if (movingDown){
						_sphere_head1.y -=5;
						_sphere_body1.y -=5;
		}
		*/
		//_cylinder.x+=1;

		_view.render();
	}

	/**
	 * mesh listener for mouse up interaction
	 */
	private function _onMouseUp(ev:MouseEvent3D) : Void
	{
		var path = new MotionPath ().bezier (ev.scenePosition.x, ev.scenePosition.z, _cube.x, ev.scenePosition.z);
		Actuate.motionPath(_cube, 0.5, { x: path.x, z: path.y });
	}
	
	/**
	 * stage listener for resize events
	 */
	private function onResize(event:Event = null):Void
	{
		_view.width = stage.stageWidth;
		_view.height = stage.stageHeight;
	}
	
}
