(function ($hx_exports, $global) { "use strict"; var $hx_script = (function (exports, global) { // Generated by Haxe 3.4.7
(function ($hx_exports, $global) { "use strict";
$hx_exports["lime"] = $hx_exports["lime"] || {};
var $hxClasses = {},$estr = function() { return js_Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function Inherit() {} Inherit.prototype = from; var proto = new Inherit();
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var lime_app_IModule = function() { };
$hxClasses["lime.app.IModule"] = lime_app_IModule;
lime_app_IModule.__name__ = ["lime","app","IModule"];
lime_app_IModule.prototype = {
	__class__: lime_app_IModule
};
var lime_app_Module = function() {
	this.onExit = new lime_app__$Event_$Int_$Void();
};
$hxClasses["lime.app.Module"] = lime_app_Module;
lime_app_Module.__name__ = ["lime","app","Module"];
lime_app_Module.__interfaces__ = [lime_app_IModule];
lime_app_Module.prototype = {
	__registerLimeModule: function(application) {
	}
	,__unregisterLimeModule: function(application) {
	}
	,__class__: lime_app_Module
};
var lime__$internal_backend_html5_HTML5Application = function(parent) {
	this.gameDeviceCache = new haxe_ds_IntMap();
	this.parent = parent;
	this.currentUpdate = 0;
	this.lastUpdate = 0;
	this.nextUpdate = 0;
	this.framePeriod = -1;
	lime_media_AudioManager.init();
	this.accelerometer = lime_system_Sensor.registerSensor(lime_system_SensorType.ACCELEROMETER,0);
};
$hxClasses["lime._internal.backend.html5.HTML5Application"] = lime__$internal_backend_html5_HTML5Application;
lime__$internal_backend_html5_HTML5Application.__name__ = ["lime","_internal","backend","html5","HTML5Application"];
lime__$internal_backend_html5_HTML5Application.prototype = {
	convertKeyCode: function(keyCode) {
		if(keyCode >= 65 && keyCode <= 90) {
			return keyCode + 32;
		}
		switch(keyCode) {
		case 12:
			return 1073741980;
		case 16:
			return 1073742049;
		case 17:
			return 1073742048;
		case 18:
			return 1073742050;
		case 19:
			return 1073741896;
		case 20:
			return 1073741881;
		case 33:
			return 1073741899;
		case 34:
			return 1073741902;
		case 35:
			return 1073741901;
		case 36:
			return 1073741898;
		case 37:
			return 1073741904;
		case 38:
			return 1073741906;
		case 39:
			return 1073741903;
		case 40:
			return 1073741905;
		case 41:
			return 1073741943;
		case 43:
			return 1073741940;
		case 44:
			return 1073741894;
		case 45:
			return 1073741897;
		case 46:
			return 127;
		case 91:
			return 1073742051;
		case 92:
			return 1073742055;
		case 93:
			return 1073742055;
		case 95:
			return 1073742106;
		case 96:
			return 1073741922;
		case 97:
			return 1073741913;
		case 98:
			return 1073741914;
		case 99:
			return 1073741915;
		case 100:
			return 1073741916;
		case 101:
			return 1073741917;
		case 102:
			return 1073741918;
		case 103:
			return 1073741919;
		case 104:
			return 1073741920;
		case 105:
			return 1073741921;
		case 106:
			return 1073741909;
		case 107:
			return 1073741911;
		case 108:
			return 1073741923;
		case 109:
			return 1073741910;
		case 110:
			return 1073741923;
		case 111:
			return 1073741908;
		case 112:
			return 1073741882;
		case 113:
			return 1073741883;
		case 114:
			return 1073741884;
		case 115:
			return 1073741885;
		case 116:
			return 1073741886;
		case 117:
			return 1073741887;
		case 118:
			return 1073741888;
		case 119:
			return 1073741889;
		case 120:
			return 1073741890;
		case 121:
			return 1073741891;
		case 122:
			return 1073741892;
		case 123:
			return 1073741893;
		case 124:
			return 1073741928;
		case 125:
			return 1073741929;
		case 126:
			return 1073741930;
		case 127:
			return 1073741931;
		case 128:
			return 1073741932;
		case 129:
			return 1073741933;
		case 130:
			return 1073741934;
		case 131:
			return 1073741935;
		case 132:
			return 1073741936;
		case 133:
			return 1073741937;
		case 134:
			return 1073741938;
		case 135:
			return 1073741939;
		case 144:
			return 1073741907;
		case 145:
			return 1073741895;
		case 160:
			return 94;
		case 161:
			return 33;
		case 163:
			return 35;
		case 164:
			return 36;
		case 166:
			return 1073742094;
		case 167:
			return 1073742095;
		case 168:
			return 1073742097;
		case 169:
			return 41;
		case 170:
			return 42;
		case 171:
			return 96;
		case 172:
			return 1073741898;
		case 173:
			return 45;
		case 174:
			return 1073741953;
		case 175:
			return 1073741952;
		case 176:
			return 1073742082;
		case 177:
			return 1073742083;
		case 178:
			return 1073742084;
		case 179:
			return 1073742085;
		case 180:
			return 1073742089;
		case 181:
			return 1073742086;
		case 182:
			return 1073741953;
		case 183:
			return 1073741952;
		case 186:
			return 59;
		case 187:
			return 61;
		case 188:
			return 44;
		case 189:
			return 45;
		case 190:
			return 46;
		case 191:
			return 47;
		case 192:
			return 96;
		case 193:
			return 63;
		case 194:
			return 1073741923;
		case 219:
			return 91;
		case 220:
			return 92;
		case 221:
			return 93;
		case 222:
			return 39;
		case 223:
			return 96;
		case 224:
			return 1073742051;
		case 226:
			return 92;
		}
		return keyCode;
	}
	,exec: function() {
		window.addEventListener("keydown",$bind(this,this.handleKeyEvent),false);
		window.addEventListener("keyup",$bind(this,this.handleKeyEvent),false);
		window.addEventListener("focus",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("blur",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("resize",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("beforeunload",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("devicemotion",$bind(this,this.handleSensorEvent),false);
		
			if (!CanvasRenderingContext2D.prototype.isPointInStroke) {
				CanvasRenderingContext2D.prototype.isPointInStroke = function (path, x, y) {
					return false;
				};
			}
			if (!CanvasRenderingContext2D.prototype.isPointInPath) {
				CanvasRenderingContext2D.prototype.isPointInPath = function (path, x, y) {
					return false;
				};
			}

			if ('performance' in window == false) {
				window.performance = {};
			}

			if ('now' in window.performance == false) {
				var offset = Date.now();
				if (performance.timing && performance.timing.navigationStart) {
					offset = performance.timing.navigationStart
				}
				window.performance.now = function now() {
					return Date.now() - offset;
				}
			}

			var lastTime = 0;
			var vendors = ['ms', 'moz', 'webkit', 'o'];
			for (var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
				window.requestAnimationFrame = window[vendors[x]+'RequestAnimationFrame'];
				window.cancelAnimationFrame = window[vendors[x]+'CancelAnimationFrame'] || window[vendors[x]+'CancelRequestAnimationFrame'];
			}

			if (!window.requestAnimationFrame)
				window.requestAnimationFrame = function(callback, element) {
					var currTime = new Date().getTime();
					var timeToCall = Math.max(0, 16 - (currTime - lastTime));
					var id = window.setTimeout(function() { callback(currTime + timeToCall); },
					  timeToCall);
					lastTime = currTime + timeToCall;
					return id;
				};

			if (!window.cancelAnimationFrame)
				window.cancelAnimationFrame = function(id) {
					clearTimeout(id);
				};

			window.requestAnimFrame = window.requestAnimationFrame;
		;
		this.lastUpdate = new Date().getTime();
		this.handleApplicationEvent();
		return 0;
	}
	,exit: function() {
	}
	,handleApplicationEvent: function(__) {
		var _g = 0;
		var _g1 = this.parent.__windows;
		while(_g < _g1.length) {
			var $window = _g1[_g];
			++_g;
			$window.__backend.updateSize();
		}
		this.updateGameDevices();
		this.currentUpdate = new Date().getTime();
		if(this.currentUpdate >= this.nextUpdate) {
			this.deltaTime = this.currentUpdate - this.lastUpdate;
			var _g2 = 0;
			var _g11 = this.parent.__windows;
			while(_g2 < _g11.length) {
				var window1 = _g11[_g2];
				++_g2;
				this.parent.onUpdate.dispatch(this.deltaTime | 0);
				if(window1.context != null) {
					window1.onRender.dispatch(window1.context);
				}
			}
			if(this.framePeriod < 0) {
				this.nextUpdate = this.currentUpdate;
			} else {
				this.nextUpdate = this.currentUpdate - this.currentUpdate % this.framePeriod + this.framePeriod;
			}
			this.lastUpdate = this.currentUpdate;
		}
		window.requestAnimationFrame($bind(this,this.handleApplicationEvent));
	}
	,handleKeyEvent: function(event) {
		if(this.parent.__window != null) {
			var keyCode = this.convertKeyCode(event.keyCode != null ? event.keyCode : event.which);
			var modifier = (event.shiftKey ? 3 : 0) | (event.ctrlKey ? 192 : 0) | (event.altKey ? 768 : 0) | (event.metaKey ? 3072 : 0);
			if(event.type == "keydown") {
				this.parent.__window.onKeyDown.dispatch(keyCode,modifier);
				if(this.parent.__window.onKeyDown.canceled && event.cancelable) {
					event.preventDefault();
				}
			} else {
				this.parent.__window.onKeyUp.dispatch(keyCode,modifier);
				if(this.parent.__window.onKeyUp.canceled && event.cancelable) {
					event.preventDefault();
				}
			}
		}
	}
	,handleSensorEvent: function(event) {
		this.accelerometer.onUpdate.dispatch(event.accelerationIncludingGravity.x,event.accelerationIncludingGravity.y,event.accelerationIncludingGravity.z);
	}
	,handleWindowEvent: function(event) {
		if(this.parent.__window != null) {
			var _g = event.type;
			switch(_g) {
			case "beforeunload":
				break;
			case "blur":
				if(!this.hidden) {
					this.parent.__window.onFocusOut.dispatch();
					this.parent.__window.onDeactivate.dispatch();
					this.hidden = true;
				}
				break;
			case "focus":
				if(this.hidden) {
					this.parent.__window.onFocusIn.dispatch();
					this.parent.__window.onActivate.dispatch();
					this.hidden = false;
				}
				break;
			case "resize":
				this.parent.__window.__backend.handleResizeEvent(event);
				break;
			case "visibilitychange":
				if(window.document.hidden) {
					if(!this.hidden) {
						this.parent.__window.onFocusOut.dispatch();
						this.parent.__window.onDeactivate.dispatch();
						this.hidden = true;
					}
				} else if(this.hidden) {
					this.parent.__window.onFocusIn.dispatch();
					this.parent.__window.onActivate.dispatch();
					this.hidden = false;
				}
				break;
			}
		}
	}
	,updateGameDevices: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		if(devices == null) {
			return;
		}
		var id;
		var gamepad;
		var joystick;
		var data;
		var cache;
		var _g1 = 0;
		var _g = devices.length;
		while(_g1 < _g) {
			var i = _g1++;
			id = i;
			data = devices[id];
			if(data == null) {
				continue;
			}
			if(!this.gameDeviceCache.h.hasOwnProperty(id)) {
				cache = new lime__$internal_backend_html5_GameDeviceData();
				cache.id = id;
				cache.connected = data.connected;
				var _g3 = 0;
				var _g2 = data.buttons.length;
				while(_g3 < _g2) {
					var i1 = _g3++;
					cache.buttons.push(data.buttons[i1].value);
				}
				var _g31 = 0;
				var _g21 = data.axes.length;
				while(_g31 < _g21) {
					var i2 = _g31++;
					cache.axes.push(data.axes[i2]);
				}
				if(data.mapping == "standard") {
					cache.isGamepad = true;
				}
				this.gameDeviceCache.h[id] = cache;
				if(data.connected) {
					lime_ui_Joystick.__connect(id);
					if(cache.isGamepad) {
						lime_ui_Gamepad.__connect(id);
					}
				}
			}
			cache = this.gameDeviceCache.h[id];
			joystick = lime_ui_Joystick.devices.h[id];
			gamepad = lime_ui_Gamepad.devices.h[id];
			if(data.connected) {
				var button;
				var value;
				var _g32 = 0;
				var _g22 = data.buttons.length;
				while(_g32 < _g22) {
					var i3 = _g32++;
					value = data.buttons[i3].value;
					if(value != cache.buttons[i3]) {
						if(i3 == 6) {
							joystick.onAxisMove.dispatch(data.axes.length,value);
							if(gamepad != null) {
								gamepad.onAxisMove.dispatch(4,value);
							}
						} else if(i3 == 7) {
							joystick.onAxisMove.dispatch(data.axes.length + 1,value);
							if(gamepad != null) {
								gamepad.onAxisMove.dispatch(5,value);
							}
						} else {
							if(value > 0) {
								joystick.onButtonDown.dispatch(i3);
							} else {
								joystick.onButtonUp.dispatch(i3);
							}
							if(gamepad != null) {
								switch(i3) {
								case 0:
									button = 0;
									break;
								case 1:
									button = 1;
									break;
								case 2:
									button = 2;
									break;
								case 3:
									button = 3;
									break;
								case 4:
									button = 9;
									break;
								case 5:
									button = 10;
									break;
								case 8:
									button = 4;
									break;
								case 9:
									button = 6;
									break;
								case 10:
									button = 7;
									break;
								case 11:
									button = 8;
									break;
								case 12:
									button = 11;
									break;
								case 13:
									button = 12;
									break;
								case 14:
									button = 13;
									break;
								case 15:
									button = 14;
									break;
								case 16:
									button = 5;
									break;
								default:
									continue;
								}
								if(value > 0) {
									gamepad.onButtonDown.dispatch(button);
								} else {
									gamepad.onButtonUp.dispatch(button);
								}
							}
						}
						cache.buttons[i3] = value;
					}
				}
				var _g33 = 0;
				var _g23 = data.axes.length;
				while(_g33 < _g23) {
					var i4 = _g33++;
					if(data.axes[i4] != cache.axes[i4]) {
						joystick.onAxisMove.dispatch(i4,data.axes[i4]);
						if(gamepad != null) {
							gamepad.onAxisMove.dispatch(i4,data.axes[i4]);
						}
						cache.axes[i4] = data.axes[i4];
					}
				}
			} else if(cache.connected) {
				cache.connected = false;
				lime_ui_Joystick.__disconnect(id);
				lime_ui_Gamepad.__disconnect(id);
			}
		}
	}
	,__class__: lime__$internal_backend_html5_HTML5Application
};
var lime_app_Application = function() {
	this.onCreateWindow = new lime_app__$Event_$lime_$ui_$Window_$Void();
	this.onUpdate = new lime_app__$Event_$Int_$Void();
	lime_app_Module.call(this);
	if(lime_app_Application.current == null) {
		lime_app_Application.current = this;
	}
	this.meta = new haxe_ds_StringMap();
	this.modules = [];
	this.__windowByID = new haxe_ds_IntMap();
	this.__windows = [];
	this.__backend = new lime__$internal_backend_html5_HTML5Application(this);
	this.__registerLimeModule(this);
	this.__preloader = new lime_utils_Preloader();
	this.__preloader.onProgress.add($bind(this,this.onPreloadProgress));
	this.__preloader.onComplete.add($bind(this,this.onPreloadComplete));
};
$hxClasses["lime.app.Application"] = lime_app_Application;
lime_app_Application.__name__ = ["lime","app","Application"];
lime_app_Application.__super__ = lime_app_Module;
lime_app_Application.prototype = $extend(lime_app_Module.prototype,{
	addModule: function(module) {
		module.__registerLimeModule(this);
		this.modules.push(module);
	}
	,createWindow: function(attributes) {
		var $window = this.__createWindow(attributes);
		this.__addWindow($window);
		return $window;
	}
	,exec: function() {
		lime_app_Application.current = this;
		return this.__backend.exec();
	}
	,onGamepadAxisMove: function(gamepad,axis,value) {
	}
	,onGamepadButtonDown: function(gamepad,button) {
	}
	,onGamepadButtonUp: function(gamepad,button) {
	}
	,onGamepadConnect: function(gamepad) {
	}
	,onGamepadDisconnect: function(gamepad) {
	}
	,onJoystickAxisMove: function(joystick,axis,value) {
	}
	,onJoystickButtonDown: function(joystick,button) {
	}
	,onJoystickButtonUp: function(joystick,button) {
	}
	,onJoystickConnect: function(joystick) {
	}
	,onJoystickDisconnect: function(joystick) {
	}
	,onJoystickHatMove: function(joystick,hat,position) {
	}
	,onJoystickTrackballMove: function(joystick,trackball,x,y) {
	}
	,onKeyDown: function(keyCode,modifier) {
	}
	,onKeyUp: function(keyCode,modifier) {
	}
	,onModuleExit: function(code) {
	}
	,onMouseDown: function(x,y,button) {
	}
	,onMouseMove: function(x,y) {
	}
	,onMouseMoveRelative: function(x,y) {
	}
	,onMouseUp: function(x,y,button) {
	}
	,onMouseWheel: function(deltaX,deltaY,deltaMode) {
	}
	,onPreloadComplete: function() {
	}
	,onPreloadProgress: function(loaded,total) {
	}
	,onRenderContextLost: function() {
	}
	,onRenderContextRestored: function(context) {
	}
	,onTextEdit: function(text,start,length) {
	}
	,onTextInput: function(text) {
	}
	,onTouchCancel: function(touch) {
	}
	,onTouchEnd: function(touch) {
	}
	,onTouchMove: function(touch) {
	}
	,onTouchStart: function(touch) {
	}
	,onWindowActivate: function() {
	}
	,onWindowClose: function() {
	}
	,onWindowCreate: function() {
	}
	,onWindowDeactivate: function() {
	}
	,onWindowDropFile: function(file) {
	}
	,onWindowEnter: function() {
	}
	,onWindowExpose: function() {
	}
	,onWindowFocusIn: function() {
	}
	,onWindowFocusOut: function() {
	}
	,onWindowFullscreen: function() {
	}
	,onWindowLeave: function() {
	}
	,onWindowMove: function(x,y) {
	}
	,onWindowMinimize: function() {
	}
	,onWindowResize: function(width,height) {
	}
	,onWindowRestore: function() {
	}
	,removeModule: function(module) {
		if(module != null) {
			module.__unregisterLimeModule(this);
			HxOverrides.remove(this.modules,module);
		}
	}
	,render: function(context) {
	}
	,update: function(deltaTime) {
	}
	,__addWindow: function(window) {
		if(window != null) {
			this.__windows.push(window);
			this.__windowByID.h[window.id] = window;
			var f = $bind(this,this.__onWindowClose);
			var a1 = window;
			var tmp = function() {
				f(a1);
			};
			window.onClose.add(tmp,false,-10000);
			if(this.__window == null) {
				this.__window = window;
				window.onActivate.add($bind(this,this.onWindowActivate));
				window.onRenderContextLost.add($bind(this,this.onRenderContextLost));
				window.onRenderContextRestored.add($bind(this,this.onRenderContextRestored));
				window.onDeactivate.add($bind(this,this.onWindowDeactivate));
				window.onDropFile.add($bind(this,this.onWindowDropFile));
				window.onEnter.add($bind(this,this.onWindowEnter));
				window.onExpose.add($bind(this,this.onWindowExpose));
				window.onFocusIn.add($bind(this,this.onWindowFocusIn));
				window.onFocusOut.add($bind(this,this.onWindowFocusOut));
				window.onFullscreen.add($bind(this,this.onWindowFullscreen));
				window.onKeyDown.add($bind(this,this.onKeyDown));
				window.onKeyUp.add($bind(this,this.onKeyUp));
				window.onLeave.add($bind(this,this.onWindowLeave));
				window.onMinimize.add($bind(this,this.onWindowMinimize));
				window.onMouseDown.add($bind(this,this.onMouseDown));
				window.onMouseMove.add($bind(this,this.onMouseMove));
				window.onMouseMoveRelative.add($bind(this,this.onMouseMoveRelative));
				window.onMouseUp.add($bind(this,this.onMouseUp));
				window.onMouseWheel.add($bind(this,this.onMouseWheel));
				window.onMove.add($bind(this,this.onWindowMove));
				window.onRender.add($bind(this,this.render));
				window.onResize.add($bind(this,this.onWindowResize));
				window.onRestore.add($bind(this,this.onWindowRestore));
				window.onTextEdit.add($bind(this,this.onTextEdit));
				window.onTextInput.add($bind(this,this.onTextInput));
				this.onWindowCreate();
			}
			this.onCreateWindow.dispatch(window);
		}
	}
	,__createWindow: function(attributes) {
		var $window = new lime_ui_Window(this,attributes);
		if($window.id == -1) {
			return null;
		}
		return $window;
	}
	,__registerLimeModule: function(application) {
		application.onUpdate.add($bind(this,this.update));
		application.onExit.add($bind(this,this.onModuleExit),false,0);
		application.onExit.add($bind(this,this.__onModuleExit),false,0);
		var gamepad = lime_ui_Gamepad.devices.iterator();
		while(gamepad.hasNext()) {
			var gamepad1 = gamepad.next();
			this.__onGamepadConnect(gamepad1);
		}
		lime_ui_Gamepad.onConnect.add($bind(this,this.__onGamepadConnect));
		var joystick = lime_ui_Joystick.devices.iterator();
		while(joystick.hasNext()) {
			var joystick1 = joystick.next();
			this.__onJoystickConnect(joystick1);
		}
		lime_ui_Joystick.onConnect.add($bind(this,this.__onJoystickConnect));
		lime_ui_Touch.onCancel.add($bind(this,this.onTouchCancel));
		lime_ui_Touch.onStart.add($bind(this,this.onTouchStart));
		lime_ui_Touch.onMove.add($bind(this,this.onTouchMove));
		lime_ui_Touch.onEnd.add($bind(this,this.onTouchEnd));
	}
	,__removeWindow: function(window) {
		if(window != null && this.__windowByID.h.hasOwnProperty(window.id)) {
			if(this.__window == window) {
				this.__window = null;
			}
			HxOverrides.remove(this.__windows,window);
			this.__windowByID.remove(window.id);
			window.close();
			if(this.__windows.length == 0) {
				lime_system_System.exit(0);
			}
		}
	}
	,__onGamepadConnect: function(gamepad) {
		this.onGamepadConnect(gamepad);
		var f = $bind(this,this.onGamepadAxisMove);
		var a1 = gamepad;
		var tmp = function(a2,a3) {
			f(a1,a2,a3);
		};
		gamepad.onAxisMove.add(tmp);
		var f1 = $bind(this,this.onGamepadButtonDown);
		var a11 = gamepad;
		var tmp1 = function(a21) {
			f1(a11,a21);
		};
		gamepad.onButtonDown.add(tmp1);
		var f2 = $bind(this,this.onGamepadButtonUp);
		var a12 = gamepad;
		var tmp2 = function(a22) {
			f2(a12,a22);
		};
		gamepad.onButtonUp.add(tmp2);
		var f3 = $bind(this,this.onGamepadDisconnect);
		var a13 = gamepad;
		var tmp3 = function() {
			f3(a13);
		};
		gamepad.onDisconnect.add(tmp3);
	}
	,__onJoystickConnect: function(joystick) {
		this.onJoystickConnect(joystick);
		var f = $bind(this,this.onJoystickAxisMove);
		var a1 = joystick;
		var tmp = function(a2,a3) {
			f(a1,a2,a3);
		};
		joystick.onAxisMove.add(tmp);
		var f1 = $bind(this,this.onJoystickButtonDown);
		var a11 = joystick;
		var tmp1 = function(a21) {
			f1(a11,a21);
		};
		joystick.onButtonDown.add(tmp1);
		var f2 = $bind(this,this.onJoystickButtonUp);
		var a12 = joystick;
		var tmp2 = function(a22) {
			f2(a12,a22);
		};
		joystick.onButtonUp.add(tmp2);
		var f3 = $bind(this,this.onJoystickDisconnect);
		var a13 = joystick;
		var tmp3 = function() {
			f3(a13);
		};
		joystick.onDisconnect.add(tmp3);
		var f4 = $bind(this,this.onJoystickHatMove);
		var a14 = joystick;
		var tmp4 = function(a23,a31) {
			f4(a14,a23,a31);
		};
		joystick.onHatMove.add(tmp4);
		var f5 = $bind(this,this.onJoystickTrackballMove);
		var a15 = joystick;
		var tmp5 = function(a24,x,y) {
			f5(a15,a24,x,y);
		};
		joystick.onTrackballMove.add(tmp5);
	}
	,__onModuleExit: function(code) {
		this.__backend.exit();
	}
	,__onWindowClose: function(window) {
		if(this.__window == window) {
			this.onWindowClose();
		}
		this.__removeWindow(window);
	}
	,__unregisterLimeModule: function(application) {
		application.onUpdate.remove($bind(this,this.update));
		application.onExit.remove($bind(this,this.__onModuleExit));
		application.onExit.remove($bind(this,this.onModuleExit));
		lime_ui_Gamepad.onConnect.remove($bind(this,this.__onGamepadConnect));
		lime_ui_Joystick.onConnect.remove($bind(this,this.__onJoystickConnect));
		lime_ui_Touch.onCancel.remove($bind(this,this.onTouchCancel));
		lime_ui_Touch.onStart.remove($bind(this,this.onTouchStart));
		lime_ui_Touch.onMove.remove($bind(this,this.onTouchMove));
		lime_ui_Touch.onEnd.remove($bind(this,this.onTouchEnd));
		this.onModuleExit(0);
	}
	,get_preloader: function() {
		return this.__preloader;
	}
	,get_window: function() {
		return this.__window;
	}
	,get_windows: function() {
		return this.__windows;
	}
	,__class__: lime_app_Application
	,__properties__: {get_windows:"get_windows",get_window:"get_window",get_preloader:"get_preloader"}
});
var ApplicationMain = function() { };
$hxClasses["ApplicationMain"] = ApplicationMain;
ApplicationMain.__name__ = ["ApplicationMain"];
ApplicationMain.main = function() {
	lime_system_System.__registerEntryPoint("Obgame05",ApplicationMain.create);
};
ApplicationMain.create = function(config) {
	var app = new openfl_display_Application();
	ManifestResources.init(config);
	var _this = app.meta;
	if(__map_reserved["build"] != null) {
		_this.setReserved("build","170");
	} else {
		_this.h["build"] = "170";
	}
	var _this1 = app.meta;
	if(__map_reserved["company"] != null) {
		_this1.setReserved("company","Company Name");
	} else {
		_this1.h["company"] = "Company Name";
	}
	var _this2 = app.meta;
	if(__map_reserved["file"] != null) {
		_this2.setReserved("file","Obgame05");
	} else {
		_this2.h["file"] = "Obgame05";
	}
	var _this3 = app.meta;
	if(__map_reserved["name"] != null) {
		_this3.setReserved("name","Obgame05");
	} else {
		_this3.h["name"] = "Obgame05";
	}
	var _this4 = app.meta;
	if(__map_reserved["packageName"] != null) {
		_this4.setReserved("packageName","com.sample.obgame05");
	} else {
		_this4.h["packageName"] = "com.sample.obgame05";
	}
	var _this5 = app.meta;
	if(__map_reserved["version"] != null) {
		_this5.setReserved("version","1.0.0");
	} else {
		_this5.h["version"] = "1.0.0";
	}
	var attributes = { allowHighDPI : false, alwaysOnTop : false, borderless : false, element : null, frameRate : 60, height : 0, hidden : false, maximized : false, minimized : false, parameters : { }, resizable : true, title : "Obgame05", width : 0, x : null, y : null};
	attributes.context = { antialiasing : 0, background : 16777215, colorDepth : 32, depth : true, hardware : true, stencil : true, type : null, vsync : false};
	if(app.__window == null) {
		if(config != null) {
			var _g = 0;
			var _g1 = Reflect.fields(config);
			while(_g < _g1.length) {
				var field = _g1[_g];
				++_g;
				if(Object.prototype.hasOwnProperty.call(attributes,field)) {
					attributes[field] = Reflect.field(config,field);
				} else if(Object.prototype.hasOwnProperty.call(attributes.context,field)) {
					attributes.context[field] = Reflect.field(config,field);
				}
			}
		}
	}
	app.createWindow(attributes);
	var preloader = new openfl_display_Preloader(new openfl_display_DefaultPreloader());
	app.__preloader.onProgress.add(function(loaded,total) {
		preloader.update(loaded,total);
	});
	app.__preloader.onComplete.add(function() {
		preloader.start();
	});
	var a1 = app.__window.stage;
	var tmp = function() {
		ApplicationMain.start(a1);
	};
	preloader.onComplete.add(tmp);
	var _g2 = 0;
	var _g11 = ManifestResources.preloadLibraries;
	while(_g2 < _g11.length) {
		var library = _g11[_g2];
		++_g2;
		app.__preloader.addLibrary(library);
	}
	var _g3 = 0;
	var _g12 = ManifestResources.preloadLibraryNames;
	while(_g3 < _g12.length) {
		var name = _g12[_g3];
		++_g3;
		app.__preloader.addLibraryName(name);
	}
	app.__preloader.load();
	var result = app.exec();
};
ApplicationMain.start = function(stage) {
	try {
		var current = stage.getChildAt(0);
		if(current == null || !js_Boot.__instanceof(current,openfl_display_DisplayObjectContainer)) {
			current = new openfl_display_MovieClip();
			stage.addChild(current);
		}
		new DocumentClass(current);
		stage.dispatchEvent(new openfl_events_Event("resize",false,false));
		if(stage.window.__fullscreen) {
			stage.dispatchEvent(new openfl_events_FullScreenEvent("fullScreen",false,false,true,true));
		}
	} catch( e ) {
		haxe_CallStack.lastException = e;
		if (e instanceof js__$Boot_HaxeError) e = e.val;
		stage.__handleError(e);
	}
};
var openfl_events_IEventDispatcher = function() { };
$hxClasses["openfl.events.IEventDispatcher"] = openfl_events_IEventDispatcher;
openfl_events_IEventDispatcher.__name__ = ["openfl","events","IEventDispatcher"];
openfl_events_IEventDispatcher.prototype = {
	__class__: openfl_events_IEventDispatcher
};
var openfl_events_EventDispatcher = function(target) {
	if(target != null) {
		this.__targetDispatcher = target;
	}
};
$hxClasses["openfl.events.EventDispatcher"] = openfl_events_EventDispatcher;
openfl_events_EventDispatcher.__name__ = ["openfl","events","EventDispatcher"];
openfl_events_EventDispatcher.__interfaces__ = [openfl_events_IEventDispatcher];
openfl_events_EventDispatcher.prototype = {
	addEventListener: function(type,listener,useCapture,priority,useWeakReference) {
		if(useWeakReference == null) {
			useWeakReference = false;
		}
		if(priority == null) {
			priority = 0;
		}
		if(useCapture == null) {
			useCapture = false;
		}
		if(listener == null) {
			return;
		}
		if(this.__eventMap == null) {
			this.__eventMap = new haxe_ds_StringMap();
			this.__iterators = new haxe_ds_StringMap();
		}
		var _this = this.__eventMap;
		if(!(__map_reserved[type] != null ? _this.existsReserved(type) : _this.h.hasOwnProperty(type))) {
			var list = [];
			list.push(new openfl_events__$EventDispatcher_Listener(listener,useCapture,priority));
			var iterator = new openfl_events__$EventDispatcher_DispatchIterator(list);
			var _this1 = this.__eventMap;
			if(__map_reserved[type] != null) {
				_this1.setReserved(type,list);
			} else {
				_this1.h[type] = list;
			}
			var _this2 = this.__iterators;
			var value = [iterator];
			if(__map_reserved[type] != null) {
				_this2.setReserved(type,value);
			} else {
				_this2.h[type] = value;
			}
		} else {
			var _this3 = this.__eventMap;
			var list1 = __map_reserved[type] != null ? _this3.getReserved(type) : _this3.h[type];
			var _g1 = 0;
			var _g = list1.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(list1[i].match(listener,useCapture)) {
					return;
				}
			}
			var _this4 = this.__iterators;
			var iterators = __map_reserved[type] != null ? _this4.getReserved(type) : _this4.h[type];
			var _g2 = 0;
			while(_g2 < iterators.length) {
				var iterator1 = iterators[_g2];
				++_g2;
				if(iterator1.active) {
					iterator1.copy();
				}
			}
			this.__addListenerByPriority(list1,new openfl_events__$EventDispatcher_Listener(listener,useCapture,priority));
		}
	}
	,dispatchEvent: function(event) {
		if(this.__targetDispatcher != null) {
			event.target = this.__targetDispatcher;
		} else {
			event.target = this;
		}
		return this.__dispatchEvent(event);
	}
	,hasEventListener: function(type) {
		if(this.__eventMap == null) {
			return false;
		}
		var _this = this.__eventMap;
		if(__map_reserved[type] != null) {
			return _this.existsReserved(type);
		} else {
			return _this.h.hasOwnProperty(type);
		}
	}
	,removeEventListener: function(type,listener,useCapture) {
		if(useCapture == null) {
			useCapture = false;
		}
		if(this.__eventMap == null || listener == null) {
			return;
		}
		var _this = this.__eventMap;
		var list = __map_reserved[type] != null ? _this.getReserved(type) : _this.h[type];
		if(list == null) {
			return;
		}
		var _this1 = this.__iterators;
		var iterators = __map_reserved[type] != null ? _this1.getReserved(type) : _this1.h[type];
		var _g1 = 0;
		var _g = list.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(list[i].match(listener,useCapture)) {
				var _g2 = 0;
				while(_g2 < iterators.length) {
					var iterator = iterators[_g2];
					++_g2;
					iterator.remove(list[i],i);
				}
				list.splice(i,1);
				break;
			}
		}
		if(list.length == 0) {
			this.__eventMap.remove(type);
			this.__iterators.remove(type);
		}
		var _this2 = this.__eventMap;
		if(!new haxe_ds__$StringMap_StringMapIterator(_this2,_this2.arrayKeys()).hasNext()) {
			this.__eventMap = null;
			this.__iterators = null;
		}
	}
	,toString: function() {
		var full = Type.getClassName(js_Boot.getClass(this));
		var $short = full.split(".").pop();
		return "[object " + $short + "]";
	}
	,willTrigger: function(type) {
		return this.hasEventListener(type);
	}
	,__dispatchEvent: function(event) {
		if(this.__eventMap == null || event == null) {
			return true;
		}
		var type = event.type;
		var _this = this.__eventMap;
		var list = __map_reserved[type] != null ? _this.getReserved(type) : _this.h[type];
		if(list == null) {
			return true;
		}
		if(event.target == null) {
			if(this.__targetDispatcher != null) {
				event.target = this.__targetDispatcher;
			} else {
				event.target = this;
			}
		}
		event.currentTarget = this;
		var capture = event.eventPhase == 1;
		var _this1 = this.__iterators;
		var iterators = __map_reserved[type] != null ? _this1.getReserved(type) : _this1.h[type];
		var iterator = iterators[0];
		if(iterator.active) {
			iterator = new openfl_events__$EventDispatcher_DispatchIterator(list);
			iterators.push(iterator);
		}
		iterator.start();
		var listener = iterator;
		while(listener.hasNext()) {
			var listener1 = listener.next();
			if(listener1 == null) {
				continue;
			}
			if(listener1.useCapture == capture) {
				listener1.callback(event);
				if(event.__isCanceledNow) {
					break;
				}
			}
		}
		iterator.stop();
		if(iterator != iterators[0]) {
			HxOverrides.remove(iterators,iterator);
		} else {
			iterator.reset(list);
		}
		return !event.isDefaultPrevented();
	}
	,__removeAllListeners: function() {
		this.__eventMap = null;
		this.__iterators = null;
	}
	,__addListenerByPriority: function(list,listener) {
		var numElements = list.length;
		var addAtPosition = numElements;
		var _g1 = 0;
		var _g = numElements;
		while(_g1 < _g) {
			var i = _g1++;
			if(list[i].priority < listener.priority) {
				addAtPosition = i;
				break;
			}
		}
		list.splice(addAtPosition,0,listener);
	}
	,__class__: openfl_events_EventDispatcher
};
var openfl_display_IBitmapDrawable = function() { };
$hxClasses["openfl.display.IBitmapDrawable"] = openfl_display_IBitmapDrawable;
openfl_display_IBitmapDrawable.__name__ = ["openfl","display","IBitmapDrawable"];
openfl_display_IBitmapDrawable.prototype = {
	__class__: openfl_display_IBitmapDrawable
};
var openfl__$Vector_Vector_$Impl_$ = {};
$hxClasses["openfl._Vector.Vector_Impl_"] = openfl__$Vector_Vector_$Impl_$;
openfl__$Vector_Vector_$Impl_$.__name__ = ["openfl","_Vector","Vector_Impl_"];
openfl__$Vector_Vector_$Impl_$.__properties__ = {set_length:"set_length",get_length:"get_length",set_fixed:"set_fixed",get_fixed:"get_fixed"};
openfl__$Vector_Vector_$Impl_$.concat = function(this1,vec) {
	return this1.concat(vec);
};
openfl__$Vector_Vector_$Impl_$.copy = function(this1) {
	return this1.copy();
};
openfl__$Vector_Vector_$Impl_$.filter = function(this1,callback) {
	return this1.filter(callback);
};
openfl__$Vector_Vector_$Impl_$.get = function(this1,index) {
	return this1.get(index);
};
openfl__$Vector_Vector_$Impl_$.indexOf = function(this1,searchElement,fromIndex) {
	if(fromIndex == null) {
		fromIndex = 0;
	}
	return this1.indexOf(searchElement,fromIndex);
};
openfl__$Vector_Vector_$Impl_$.insertAt = function(this1,index,element) {
	this1.insertAt(index,element);
};
openfl__$Vector_Vector_$Impl_$.iterator = function(this1) {
	return this1.iterator();
};
openfl__$Vector_Vector_$Impl_$.join = function(this1,sep) {
	if(sep == null) {
		sep = ",";
	}
	return this1.join(sep);
};
openfl__$Vector_Vector_$Impl_$.lastIndexOf = function(this1,searchElement,fromIndex) {
	return this1.lastIndexOf(searchElement,fromIndex);
};
openfl__$Vector_Vector_$Impl_$.pop = function(this1) {
	return this1.pop();
};
openfl__$Vector_Vector_$Impl_$.push = function(this1,value) {
	return this1.push(value);
};
openfl__$Vector_Vector_$Impl_$.removeAt = function(this1,index) {
	return this1.removeAt(index);
};
openfl__$Vector_Vector_$Impl_$.reverse = function(this1) {
	return this1.reverse();
};
openfl__$Vector_Vector_$Impl_$.set = function(this1,index,value) {
	return this1.set(index,value);
};
openfl__$Vector_Vector_$Impl_$.shift = function(this1) {
	return this1.shift();
};
openfl__$Vector_Vector_$Impl_$.slice = function(this1,startIndex,endIndex) {
	if(startIndex == null) {
		startIndex = 0;
	}
	return this1.slice(startIndex,endIndex);
};
openfl__$Vector_Vector_$Impl_$.sort = function(this1,sortBehavior) {
	this1.sort(sortBehavior);
};
openfl__$Vector_Vector_$Impl_$.splice = function(this1,startIndex,deleteCount) {
	return this1.splice(startIndex,deleteCount);
};
openfl__$Vector_Vector_$Impl_$.toString = function(this1) {
	if(this1 != null) {
		return this1.toString();
	} else {
		return null;
	}
};
openfl__$Vector_Vector_$Impl_$.unshift = function(this1,value) {
	this1.unshift(value);
};
openfl__$Vector_Vector_$Impl_$.convert = function(vec) {
	return vec;
};
openfl__$Vector_Vector_$Impl_$.toBoolVector = function(t,length,fixed,array) {
	return new openfl__$Vector_BoolVector(length,fixed,array);
};
openfl__$Vector_Vector_$Impl_$.toIntVector = function(t,length,fixed,array) {
	return new openfl__$Vector_IntVector(length,fixed,array);
};
openfl__$Vector_Vector_$Impl_$.toFloatVector = function(t,length,fixed,array) {
	return new openfl__$Vector_FloatVector(length,fixed,array,true);
};
openfl__$Vector_Vector_$Impl_$.toFunctionVector = function(t,length,fixed,array) {
	return new openfl__$Vector_FunctionVector(length,fixed,array);
};
openfl__$Vector_Vector_$Impl_$.toObjectVector = function(t,length,fixed,array) {
	return new openfl__$Vector_ObjectVector(length,fixed,array,true);
};
openfl__$Vector_Vector_$Impl_$.toNullVector = function(t,length,fixed,array) {
	return new openfl__$Vector_ObjectVector(length,fixed,array,true);
};
openfl__$Vector_Vector_$Impl_$.fromBoolVector = function(vector) {
	return vector;
};
openfl__$Vector_Vector_$Impl_$.fromIntVector = function(vector) {
	return vector;
};
openfl__$Vector_Vector_$Impl_$.fromFloatVector = function(vector) {
	return vector;
};
openfl__$Vector_Vector_$Impl_$.fromFunctionVector = function(vector) {
	return vector;
};
openfl__$Vector_Vector_$Impl_$.fromObjectVector = function(vector) {
	return vector;
};
openfl__$Vector_Vector_$Impl_$.get_fixed = function(this1) {
	return this1.fixed;
};
openfl__$Vector_Vector_$Impl_$.set_fixed = function(this1,value) {
	return this1.fixed = value;
};
openfl__$Vector_Vector_$Impl_$.get_length = function(this1) {
	return this1.get_length();
};
openfl__$Vector_Vector_$Impl_$.set_length = function(this1,value) {
	return this1.set_length(value);
};
var lime_utils_ObjectPool = function(create,clean,size) {
	this.__pool = new haxe_ds_ObjectMap();
	this.activeObjects = 0;
	this.inactiveObjects = 0;
	this.__inactiveObject0 = null;
	this.__inactiveObject1 = null;
	this.__inactiveObjectList = new List();
	if(create != null) {
		this.create = create;
	}
	if(clean != null) {
		this.clean = clean;
	}
	if(size != null) {
		this.set_size(size);
	}
};
$hxClasses["lime.utils.ObjectPool"] = lime_utils_ObjectPool;
lime_utils_ObjectPool.__name__ = ["lime","utils","ObjectPool"];
lime_utils_ObjectPool.prototype = {
	add: function(object) {
		if(!this.__pool.exists(object)) {
			this.__pool.set(object,false);
			this.clean(object);
			if(this.__inactiveObject0 == null) {
				this.__inactiveObject0 = object;
			} else if(this.__inactiveObject1 == null) {
				this.__inactiveObject1 = object;
			} else {
				this.__inactiveObjectList.add(object);
			}
			this.inactiveObjects++;
		}
	}
	,clean: function(object) {
	}
	,clear: function() {
		this.__pool = new haxe_ds_ObjectMap();
		this.activeObjects = 0;
		this.inactiveObjects = 0;
		this.__inactiveObject0 = null;
		this.__inactiveObject1 = null;
		this.__inactiveObjectList.clear();
	}
	,create: function() {
		return null;
	}
	,get: function() {
		var object = null;
		if(this.inactiveObjects > 0) {
			var object1 = null;
			if(this.__inactiveObject0 != null) {
				object1 = this.__inactiveObject0;
				this.__inactiveObject0 = null;
			} else if(this.__inactiveObject1 != null) {
				object1 = this.__inactiveObject1;
				this.__inactiveObject1 = null;
			} else {
				object1 = this.__inactiveObjectList.pop();
				if(this.__inactiveObjectList.length > 0) {
					this.__inactiveObject0 = this.__inactiveObjectList.pop();
				}
				if(this.__inactiveObjectList.length > 0) {
					this.__inactiveObject1 = this.__inactiveObjectList.pop();
				}
			}
			this.inactiveObjects--;
			this.activeObjects++;
			object = object1;
		} else if(this.__size == null || this.activeObjects < this.__size) {
			object = this.create();
			if(object != null) {
				this.__pool.set(object,true);
				this.activeObjects++;
			}
		}
		return object;
	}
	,release: function(object) {
		this.activeObjects--;
		if(this.__size == null || this.activeObjects + this.inactiveObjects < this.__size) {
			this.clean(object);
			if(this.__inactiveObject0 == null) {
				this.__inactiveObject0 = object;
			} else if(this.__inactiveObject1 == null) {
				this.__inactiveObject1 = object;
			} else {
				this.__inactiveObjectList.add(object);
			}
			this.inactiveObjects++;
		} else {
			this.__pool.remove(object);
		}
	}
	,remove: function(object) {
		if(this.__pool.exists(object)) {
			this.__pool.remove(object);
			if(this.__inactiveObject0 == object) {
				this.__inactiveObject0 = null;
				this.inactiveObjects--;
			} else if(this.__inactiveObject1 == object) {
				this.__inactiveObject1 = null;
				this.inactiveObjects--;
			} else if(this.__inactiveObjectList.remove(object)) {
				this.inactiveObjects--;
			} else {
				this.activeObjects--;
			}
		}
	}
	,__addInactive: function(object) {
		if(this.__inactiveObject0 == null) {
			this.__inactiveObject0 = object;
		} else if(this.__inactiveObject1 == null) {
			this.__inactiveObject1 = object;
		} else {
			this.__inactiveObjectList.add(object);
		}
		this.inactiveObjects++;
	}
	,__getInactive: function() {
		var object = null;
		if(this.__inactiveObject0 != null) {
			object = this.__inactiveObject0;
			this.__inactiveObject0 = null;
		} else if(this.__inactiveObject1 != null) {
			object = this.__inactiveObject1;
			this.__inactiveObject1 = null;
		} else {
			object = this.__inactiveObjectList.pop();
			if(this.__inactiveObjectList.length > 0) {
				this.__inactiveObject0 = this.__inactiveObjectList.pop();
			}
			if(this.__inactiveObjectList.length > 0) {
				this.__inactiveObject1 = this.__inactiveObjectList.pop();
			}
		}
		this.inactiveObjects--;
		this.activeObjects++;
		return object;
	}
	,__removeInactive: function(count) {
		if(count <= 0 || this.inactiveObjects == 0) {
			return;
		}
		if(this.__inactiveObject0 != null) {
			this.__pool.remove(this.__inactiveObject0);
			this.__inactiveObject0 = null;
			this.inactiveObjects--;
			--count;
		}
		if(count == 0 || this.inactiveObjects == 0) {
			return;
		}
		if(this.__inactiveObject1 != null) {
			this.__pool.remove(this.__inactiveObject1);
			this.__inactiveObject1 = null;
			this.inactiveObjects--;
			--count;
		}
		if(count == 0 || this.inactiveObjects == 0) {
			return;
		}
		var _g_head = this.__inactiveObjectList.h;
		while(_g_head != null) {
			var val = _g_head.item;
			_g_head = _g_head.next;
			var object = val;
			this.__pool.remove(object);
			this.__inactiveObjectList.remove(object);
			this.inactiveObjects--;
			--count;
			if(count == 0 || this.inactiveObjects == 0) {
				return;
			}
		}
	}
	,get_size: function() {
		return this.__size;
	}
	,set_size: function(value) {
		if(value == null) {
			this.__size = null;
		} else {
			var current = this.inactiveObjects + this.activeObjects;
			this.__size = value;
			if(current > value) {
				this.__removeInactive(current - value);
			} else if(value > current) {
				var object;
				var _g1 = 0;
				var _g = value - current;
				while(_g1 < _g) {
					var i = _g1++;
					object = this.create();
					if(object != null) {
						this.__pool.set(object,false);
						this.__inactiveObjectList.add(object);
						this.inactiveObjects++;
					} else {
						break;
					}
				}
			}
		}
		return value;
	}
	,__class__: lime_utils_ObjectPool
	,__properties__: {set_size:"set_size",get_size:"get_size"}
};
var haxe_IMap = function() { };
$hxClasses["haxe.IMap"] = haxe_IMap;
haxe_IMap.__name__ = ["haxe","IMap"];
haxe_IMap.prototype = {
	__class__: haxe_IMap
};
var haxe_ds_ObjectMap = function() {
	this.h = { __keys__ : { }};
};
$hxClasses["haxe.ds.ObjectMap"] = haxe_ds_ObjectMap;
haxe_ds_ObjectMap.__name__ = ["haxe","ds","ObjectMap"];
haxe_ds_ObjectMap.__interfaces__ = [haxe_IMap];
haxe_ds_ObjectMap.assignId = function(obj) {
	return obj.__id__ = ++haxe_ds_ObjectMap.count;
};
haxe_ds_ObjectMap.getId = function(obj) {
	return obj.__id__;
};
haxe_ds_ObjectMap.prototype = {
	set: function(key,value) {
		var id = key.__id__ || (key.__id__ = ++haxe_ds_ObjectMap.count);
		this.h[id] = value;
		this.h.__keys__[id] = key;
	}
	,get: function(key) {
		return this.h[key.__id__];
	}
	,exists: function(key) {
		return this.h.__keys__[key.__id__] != null;
	}
	,remove: function(key) {
		var id = key.__id__;
		if(this.h.__keys__[id] == null) {
			return false;
		}
		delete(this.h[id]);
		delete(this.h.__keys__[id]);
		return true;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h.__keys__ ) {
		if(this.h.hasOwnProperty(key)) {
			a.push(this.h.__keys__[key]);
		}
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i.__id__];
		}};
	}
	,toString: function() {
		var s_b = "";
		s_b += "{";
		var it = this.keys();
		var i = it;
		while(i.hasNext()) {
			var i1 = i.next();
			s_b += Std.string(Std.string(i1));
			s_b += " => ";
			s_b += Std.string(Std.string(this.h[i1.__id__]));
			if(it.hasNext()) {
				s_b += ", ";
			}
		}
		s_b += "}";
		return s_b;
	}
	,__class__: haxe_ds_ObjectMap
};
var List = function() {
	this.length = 0;
};
$hxClasses["List"] = List;
List.__name__ = ["List"];
List.prototype = {
	add: function(item) {
		var x = new _$List_ListNode(item,null);
		if(this.h == null) {
			this.h = x;
		} else {
			this.q.next = x;
		}
		this.q = x;
		this.length++;
	}
	,push: function(item) {
		var x = new _$List_ListNode(item,this.h);
		this.h = x;
		if(this.q == null) {
			this.q = x;
		}
		this.length++;
	}
	,pop: function() {
		if(this.h == null) {
			return null;
		}
		var x = this.h.item;
		this.h = this.h.next;
		if(this.h == null) {
			this.q = null;
		}
		this.length--;
		return x;
	}
	,clear: function() {
		this.h = null;
		this.q = null;
		this.length = 0;
	}
	,remove: function(v) {
		var prev = null;
		var l = this.h;
		while(l != null) {
			if(l.item == v) {
				if(prev == null) {
					this.h = l.next;
				} else {
					prev.next = l.next;
				}
				if(this.q == l) {
					this.q = prev;
				}
				this.length--;
				return true;
			}
			prev = l;
			l = l.next;
		}
		return false;
	}
	,iterator: function() {
		return new _$List_ListIterator(this.h);
	}
	,join: function(sep) {
		var s_b = "";
		var first = true;
		var l = this.h;
		while(l != null) {
			if(first) {
				first = false;
			} else {
				s_b += sep == null ? "null" : "" + sep;
			}
			s_b += Std.string(l.item);
			l = l.next;
		}
		return s_b;
	}
	,__class__: List
};
var openfl_display_DisplayObject = function() {
	openfl_events_EventDispatcher.call(this);
	this.__drawableType = 1;
	this.__alpha = 1;
	this.__blendMode = 10;
	this.__cacheAsBitmap = false;
	this.__transform = new openfl_geom_Matrix();
	this.__visible = true;
	this.__rotation = 0;
	this.__rotationSine = 0;
	this.__rotationCosine = 1;
	this.__scaleX = 1;
	this.__scaleY = 1;
	this.__worldAlpha = 1;
	this.__worldBlendMode = 10;
	this.__worldTransform = new openfl_geom_Matrix();
	this.__worldColorTransform = new openfl_geom_ColorTransform();
	this.__renderTransform = new openfl_geom_Matrix();
	this.__worldVisible = true;
	this.set_name("instance" + ++openfl_display_DisplayObject.__instanceCount);
	if(openfl_display_DisplayObject.__initStage != null) {
		this.stage = openfl_display_DisplayObject.__initStage;
		openfl_display_DisplayObject.__initStage = null;
		this.stage.addChild(this);
	}
};
$hxClasses["openfl.display.DisplayObject"] = openfl_display_DisplayObject;
openfl_display_DisplayObject.__name__ = ["openfl","display","DisplayObject"];
openfl_display_DisplayObject.__interfaces__ = [openfl_display_IBitmapDrawable];
openfl_display_DisplayObject.__calculateAbsoluteTransform = function(local,parentTransform,target) {
	target.a = local.a * parentTransform.a + local.b * parentTransform.c;
	target.b = local.a * parentTransform.b + local.b * parentTransform.d;
	target.c = local.c * parentTransform.a + local.d * parentTransform.c;
	target.d = local.c * parentTransform.b + local.d * parentTransform.d;
	target.tx = local.tx * parentTransform.a + local.ty * parentTransform.c + parentTransform.tx;
	target.ty = local.tx * parentTransform.b + local.ty * parentTransform.d + parentTransform.ty;
};
openfl_display_DisplayObject.__super__ = openfl_events_EventDispatcher;
openfl_display_DisplayObject.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	addEventListener: function(type,listener,useCapture,priority,useWeakReference) {
		if(useWeakReference == null) {
			useWeakReference = false;
		}
		if(priority == null) {
			priority = 0;
		}
		if(useCapture == null) {
			useCapture = false;
		}
		switch(type) {
		case "activate":case "deactivate":case "enterFrame":case "exitFrame":case "frameConstructed":case "render":
			if(!openfl_display_DisplayObject.__broadcastEvents.exists(type)) {
				openfl_display_DisplayObject.__broadcastEvents.set(type,[]);
			}
			var dispatchers = openfl_display_DisplayObject.__broadcastEvents.get(type);
			if(dispatchers.indexOf(this) == -1) {
				dispatchers.push(this);
			}
			break;
		case "clearDOM":case "renderCairo":case "renderCanvas":case "renderDOM":case "renderOpenGL":
			if(this.__customRenderEvent == null) {
				this.__customRenderEvent = new openfl_events_RenderEvent(null);
				this.__customRenderEvent.objectColorTransform = new openfl_geom_ColorTransform();
				this.__customRenderEvent.objectMatrix = new openfl_geom_Matrix();
				this.__customRenderClear = true;
			}
			break;
		default:
		}
		openfl_events_EventDispatcher.prototype.addEventListener.call(this,type,listener,useCapture,priority,useWeakReference);
	}
	,dispatchEvent: function(event) {
		if(js_Boot.__instanceof(event,openfl_events_MouseEvent)) {
			var mouseEvent = event;
			var _this = this.__getRenderTransform();
			mouseEvent.stageX = mouseEvent.localX * _this.a + mouseEvent.localY * _this.c + _this.tx;
			var _this1 = this.__getRenderTransform();
			mouseEvent.stageY = mouseEvent.localX * _this1.b + mouseEvent.localY * _this1.d + _this1.ty;
		} else if(js_Boot.__instanceof(event,openfl_events_TouchEvent)) {
			var touchEvent = event;
			var _this2 = this.__getRenderTransform();
			touchEvent.stageX = touchEvent.localX * _this2.a + touchEvent.localY * _this2.c + _this2.tx;
			var _this3 = this.__getRenderTransform();
			touchEvent.stageY = touchEvent.localX * _this3.b + touchEvent.localY * _this3.d + _this3.ty;
		}
		event.target = this;
		return this.__dispatchWithCapture(event);
	}
	,getBounds: function(targetCoordinateSpace) {
		var matrix = openfl_geom_Matrix.__pool.get();
		if(targetCoordinateSpace != null && targetCoordinateSpace != this) {
			matrix.copyFrom(this.__getWorldTransform());
			var targetMatrix = openfl_geom_Matrix.__pool.get();
			targetMatrix.copyFrom(targetCoordinateSpace.__getWorldTransform());
			targetMatrix.invert();
			matrix.concat(targetMatrix);
			openfl_geom_Matrix.__pool.release(targetMatrix);
		} else {
			matrix.identity();
		}
		var bounds = new openfl_geom_Rectangle();
		this.__getBounds(bounds,matrix);
		openfl_geom_Matrix.__pool.release(matrix);
		return bounds;
	}
	,getRect: function(targetCoordinateSpace) {
		return this.getBounds(targetCoordinateSpace);
	}
	,globalToLocal: function(pos) {
		return this.__globalToLocal(pos,new openfl_geom_Point());
	}
	,hitTestObject: function(obj) {
		if(obj != null && obj.parent != null && this.parent != null) {
			var currentBounds = this.getBounds(this);
			var targetBounds = obj.getBounds(this);
			return currentBounds.intersects(targetBounds);
		}
		return false;
	}
	,hitTestPoint: function(x,y,shapeFlag) {
		if(shapeFlag == null) {
			shapeFlag = false;
		}
		if(this.stage != null) {
			return this.__hitTest(x,y,shapeFlag,null,false,this);
		} else {
			return false;
		}
	}
	,invalidate: function() {
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
	}
	,localToGlobal: function(point) {
		return this.__getRenderTransform().transformPoint(point);
	}
	,removeEventListener: function(type,listener,useCapture) {
		if(useCapture == null) {
			useCapture = false;
		}
		openfl_events_EventDispatcher.prototype.removeEventListener.call(this,type,listener,useCapture);
		switch(type) {
		case "activate":case "deactivate":case "enterFrame":case "exitFrame":case "frameConstructed":case "render":
			if(!this.hasEventListener(type)) {
				if(openfl_display_DisplayObject.__broadcastEvents.exists(type)) {
					HxOverrides.remove(openfl_display_DisplayObject.__broadcastEvents.get(type),this);
				}
			}
			break;
		case "clearDOM":case "renderCairo":case "renderCanvas":case "renderDOM":case "renderOpenGL":
			if(!this.hasEventListener("clearDOM") && !this.hasEventListener("renderCairo") && !this.hasEventListener("renderCanvas") && !this.hasEventListener("renderDOM") && !this.hasEventListener("renderOpenGL")) {
				this.__customRenderEvent = null;
			}
			break;
		default:
		}
	}
	,__cleanup: function() {
		this.__cairo = null;
		this.__canvas = null;
		this.__context = null;
		if(this.__graphics != null) {
			this.__graphics.__cleanup();
		}
		if(this.__cacheBitmap != null) {
			this.__cacheBitmap.__cleanup();
			this.__cacheBitmap = null;
		}
		if(this.__cacheBitmapData != null) {
			this.__cacheBitmapData.dispose();
			this.__cacheBitmapData = null;
		}
	}
	,__dispatch: function(event) {
		if(this.__eventMap != null && this.hasEventListener(event.type)) {
			var result = openfl_events_EventDispatcher.prototype.__dispatchEvent.call(this,event);
			if(event.__isCanceled) {
				return true;
			}
			return result;
		}
		return true;
	}
	,__dispatchChildren: function(event) {
	}
	,__dispatchEvent: function(event) {
		var parent = event.bubbles ? this.parent : null;
		var result = openfl_events_EventDispatcher.prototype.__dispatchEvent.call(this,event);
		if(event.__isCanceled) {
			return true;
		}
		if(parent != null && parent != this) {
			event.eventPhase = 3;
			if(event.target == null) {
				event.target = this;
			}
			parent.__dispatchEvent(event);
		}
		return result;
	}
	,__dispatchWithCapture: function(event) {
		if(event.target == null) {
			event.target = this;
		}
		if(this.parent != null) {
			event.eventPhase = 1;
			if(this.parent == this.stage) {
				this.parent.__dispatch(event);
			} else {
				var stack = openfl_display_DisplayObject.__tempStack.get();
				var parent = this.parent;
				var i = 0;
				while(parent != null) {
					stack.set(i,parent);
					parent = parent.parent;
					++i;
				}
				var _g1 = 0;
				var _g = i;
				while(_g1 < _g) {
					var j = _g1++;
					stack.get(i - j - 1).__dispatch(event);
				}
				openfl_display_DisplayObject.__tempStack.release(stack);
			}
		}
		event.eventPhase = 2;
		return this.__dispatchEvent(event);
	}
	,__enterFrame: function(deltaTime) {
	}
	,__getBounds: function(rect,matrix) {
		if(this.__graphics != null) {
			this.__graphics.__getBounds(rect,matrix);
		}
	}
	,__getCursor: function() {
		return null;
	}
	,__getFilterBounds: function(rect,matrix) {
		this.__getRenderBounds(rect,matrix);
		if(this.__filters != null) {
			var extension = openfl_geom_Rectangle.__pool.get();
			var _g = 0;
			var _g1 = this.__filters;
			while(_g < _g1.length) {
				var filter = _g1[_g];
				++_g;
				extension.__expand(-filter.__leftExtension,-filter.__topExtension,filter.__leftExtension + filter.__rightExtension,filter.__topExtension + filter.__bottomExtension);
			}
			rect.width += extension.width;
			rect.height += extension.height;
			rect.x += extension.x;
			rect.y += extension.y;
			openfl_geom_Rectangle.__pool.release(extension);
		}
	}
	,__getInteractive: function(stack) {
		return false;
	}
	,__getLocalBounds: function(rect) {
		this.__getBounds(rect,this.__transform);
		rect.x -= this.__transform.tx;
		rect.y -= this.__transform.ty;
	}
	,__getRenderBounds: function(rect,matrix) {
		if(this.__scrollRect == null) {
			this.__getBounds(rect,matrix);
		} else {
			var r = openfl_geom_Rectangle.__pool.get();
			r.copyFrom(this.__scrollRect);
			r.__transform(r,matrix);
			rect.__expand(r.x,r.y,r.width,r.height);
			openfl_geom_Rectangle.__pool.release(r);
		}
	}
	,__getRenderTransform: function() {
		this.__getWorldTransform();
		return this.__renderTransform;
	}
	,__getWorldTransform: function() {
		var transformDirty = this.__transformDirty || this.__worldTransformInvalid;
		if(transformDirty) {
			var list = [];
			var current = this;
			if(this.parent == null) {
				this.__update(true,false);
			} else {
				while(current != this.stage) {
					list.push(current);
					current = current.parent;
					if(current == null) {
						break;
					}
				}
			}
			var i = list.length;
			while(--i >= 0) {
				current = list[i];
				current.__update(true,false);
			}
		}
		return this.__worldTransform;
	}
	,__globalToLocal: function(global,local) {
		this.__getRenderTransform();
		if(global == local) {
			var _this = this.__renderTransform;
			var norm = _this.a * _this.d - _this.b * _this.c;
			if(norm == 0) {
				global.x = -_this.tx;
				global.y = -_this.ty;
			} else {
				var px = 1.0 / norm * (_this.c * (_this.ty - global.y) + _this.d * (global.x - _this.tx));
				global.y = 1.0 / norm * (_this.a * (global.y - _this.ty) + _this.b * (_this.tx - global.x));
				global.x = px;
			}
		} else {
			var _this1 = this.__renderTransform;
			var norm1 = _this1.a * _this1.d - _this1.b * _this1.c;
			local.x = norm1 == 0 ? -_this1.tx : 1.0 / norm1 * (_this1.c * (_this1.ty - global.y) + _this1.d * (global.x - _this1.tx));
			var _this2 = this.__renderTransform;
			var norm2 = _this2.a * _this2.d - _this2.b * _this2.c;
			local.y = norm2 == 0 ? -_this2.ty : 1.0 / norm2 * (_this2.a * (global.y - _this2.ty) + _this2.b * (_this2.tx - global.x));
		}
		return local;
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(this.__graphics != null) {
			if(!hitObject.__visible || this.__isMask) {
				return false;
			}
			if(this.get_mask() != null && !this.get_mask().__hitTestMask(x,y)) {
				return false;
			}
			if(this.__graphics.__hitTest(x,y,shapeFlag,this.__getRenderTransform())) {
				if(stack != null && !interactiveOnly) {
					stack.push(hitObject);
				}
				return true;
			}
		}
		return false;
	}
	,__hitTestMask: function(x,y) {
		if(this.__graphics != null) {
			if(this.__graphics.__hitTest(x,y,true,this.__getRenderTransform())) {
				return true;
			}
		}
		return false;
	}
	,__readGraphicsData: function(graphicsData,recurse) {
		if(this.__graphics != null) {
			this.__graphics.__readGraphicsData(graphicsData);
		}
	}
	,__setParentRenderDirty: function() {
		var renderParent = this.__renderParent != null ? this.__renderParent : this.parent;
		if(renderParent != null && !renderParent.__renderDirty) {
			renderParent.__renderDirty = true;
			renderParent.__setParentRenderDirty();
		}
	}
	,__setRenderDirty: function() {
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
	}
	,__setStageReference: function(stage) {
		this.stage = stage;
	}
	,__setTransformDirty: function() {
		if(!this.__transformDirty) {
			this.__transformDirty = true;
			this.__setWorldTransformInvalid();
			this.__setParentRenderDirty();
		}
	}
	,__setWorldTransformInvalid: function() {
		this.__worldTransformInvalid = true;
	}
	,__stopAllMovieClips: function() {
	}
	,__update: function(transformOnly,updateChildren) {
		var renderParent = this.__renderParent != null ? this.__renderParent : this.parent;
		if(this.__isMask && renderParent == null) {
			renderParent = this.__maskTarget;
		}
		this.__renderable = this.__visible && this.__scaleX != 0 && this.__scaleY != 0 && !this.__isMask && (renderParent == null || !renderParent.__isMask);
		this.__updateTransforms();
		this.__transformDirty = false;
		this.__worldTransformInvalid = false;
		if(!transformOnly) {
			if(openfl_display_DisplayObject.__supportDOM) {
				this.__renderTransformChanged = !this.__renderTransform.equals(this.__renderTransformCache);
				if(this.__renderTransformCache == null) {
					this.__renderTransformCache = this.__renderTransform.clone();
				} else {
					this.__renderTransformCache.copyFrom(this.__renderTransform);
				}
			}
			if(renderParent != null) {
				if(openfl_display_DisplayObject.__supportDOM) {
					var worldVisible = renderParent.__worldVisible && this.__visible;
					this.__worldVisibleChanged = this.__worldVisible != worldVisible;
					this.__worldVisible = worldVisible;
					var worldAlpha = this.get_alpha() * renderParent.__worldAlpha;
					this.__worldAlphaChanged = this.__worldAlpha != worldAlpha;
					this.__worldAlpha = worldAlpha;
				} else {
					this.__worldAlpha = this.get_alpha() * renderParent.__worldAlpha;
				}
				if(this.__objectTransform != null) {
					this.__worldColorTransform.__copyFrom(this.__objectTransform.__colorTransform);
					this.__worldColorTransform.__combine(renderParent.__worldColorTransform);
				} else {
					this.__worldColorTransform.__copyFrom(renderParent.__worldColorTransform);
				}
				if(this.__blendMode == null || this.__blendMode == 10) {
					this.__worldBlendMode = renderParent.__worldBlendMode;
				} else {
					this.__worldBlendMode = this.__blendMode;
				}
				if(this.__shader == null) {
					this.__worldShader = renderParent.__shader;
				} else {
					this.__worldShader = this.__shader;
				}
				if(this.__scale9Grid == null) {
					this.__worldScale9Grid = renderParent.__scale9Grid;
				} else {
					this.__worldScale9Grid = this.__scale9Grid;
				}
			} else {
				this.__worldAlpha = this.get_alpha();
				if(openfl_display_DisplayObject.__supportDOM) {
					this.__worldVisibleChanged = this.__worldVisible != this.__visible;
					this.__worldVisible = this.__visible;
					this.__worldAlphaChanged = this.__worldAlpha != this.get_alpha();
				}
				if(this.__objectTransform != null) {
					this.__worldColorTransform.__copyFrom(this.__objectTransform.__colorTransform);
				} else {
					this.__worldColorTransform.__identity();
				}
				this.__worldBlendMode = this.__blendMode;
				this.__worldShader = this.__shader;
				this.__worldScale9Grid = this.__scale9Grid;
			}
		}
		if(updateChildren && this.get_mask() != null) {
			this.get_mask().__update(transformOnly,true);
		}
	}
	,__updateTransforms: function(overrideTransform) {
		var overrided = overrideTransform != null;
		var local = overrided ? overrideTransform : this.__transform;
		if(this.__worldTransform == null) {
			this.__worldTransform = new openfl_geom_Matrix();
		}
		if(this.__renderTransform == null) {
			this.__renderTransform = new openfl_geom_Matrix();
		}
		var renderParent = this.__renderParent != null ? this.__renderParent : this.parent;
		if(!overrided && this.parent != null) {
			var parentTransform = this.parent.__worldTransform;
			var target = this.__worldTransform;
			target.a = local.a * parentTransform.a + local.b * parentTransform.c;
			target.b = local.a * parentTransform.b + local.b * parentTransform.d;
			target.c = local.c * parentTransform.a + local.d * parentTransform.c;
			target.d = local.c * parentTransform.b + local.d * parentTransform.d;
			target.tx = local.tx * parentTransform.a + local.ty * parentTransform.c + parentTransform.tx;
			target.ty = local.tx * parentTransform.b + local.ty * parentTransform.d + parentTransform.ty;
		} else {
			this.__worldTransform.copyFrom(local);
		}
		if(!overrided && renderParent != null) {
			var parentTransform1 = renderParent.__renderTransform;
			var target1 = this.__renderTransform;
			target1.a = local.a * parentTransform1.a + local.b * parentTransform1.c;
			target1.b = local.a * parentTransform1.b + local.b * parentTransform1.d;
			target1.c = local.c * parentTransform1.a + local.d * parentTransform1.c;
			target1.d = local.c * parentTransform1.b + local.d * parentTransform1.d;
			target1.tx = local.tx * parentTransform1.a + local.ty * parentTransform1.c + parentTransform1.tx;
			target1.ty = local.tx * parentTransform1.b + local.ty * parentTransform1.d + parentTransform1.ty;
		} else {
			this.__renderTransform.copyFrom(local);
		}
		if(this.__scrollRect != null) {
			var _this = this.__renderTransform;
			var px = -this.__scrollRect.x;
			var py = -this.__scrollRect.y;
			_this.tx = px * _this.a + py * _this.c + _this.tx;
			_this.ty = px * _this.b + py * _this.d + _this.ty;
		}
	}
	,get_alpha: function() {
		return this.__alpha;
	}
	,set_alpha: function(value) {
		if(value > 1.0) {
			value = 1.0;
		}
		if(value < 0.0) {
			value = 0.0;
		}
		if(value != this.__alpha && !this.get_cacheAsBitmap()) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__alpha = value;
	}
	,get_blendMode: function() {
		return this.__blendMode;
	}
	,set_blendMode: function(value) {
		if(value == null) {
			value = 10;
		}
		if(value != this.__blendMode) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__blendMode = value;
	}
	,get_cacheAsBitmap: function() {
		if(this.__filters == null) {
			return this.__cacheAsBitmap;
		} else {
			return true;
		}
	}
	,set_cacheAsBitmap: function(value) {
		if(value != this.__cacheAsBitmap) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__cacheAsBitmap = value;
	}
	,get_cacheAsBitmapMatrix: function() {
		return this.__cacheAsBitmapMatrix;
	}
	,set_cacheAsBitmapMatrix: function(value) {
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
		return this.__cacheAsBitmapMatrix = value != null ? value.clone() : value;
	}
	,get_filters: function() {
		if(this.__filters == null) {
			return [];
		} else {
			return this.__filters.slice();
		}
	}
	,set_filters: function(value) {
		if(value != null && value.length > 0) {
			this.__filters = value;
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		} else if(this.__filters != null) {
			this.__filters = null;
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return value;
	}
	,get_height: function() {
		var rect = openfl_geom_Rectangle.__pool.get();
		this.__getLocalBounds(rect);
		var height = rect.height;
		openfl_geom_Rectangle.__pool.release(rect);
		return height;
	}
	,set_height: function(value) {
		var rect = openfl_geom_Rectangle.__pool.get();
		var matrix = openfl_geom_Matrix.__pool.get();
		matrix.identity();
		this.__getBounds(rect,matrix);
		if(value != rect.height) {
			this.set_scaleY(value / rect.height);
		} else {
			this.set_scaleY(1);
		}
		openfl_geom_Rectangle.__pool.release(rect);
		openfl_geom_Matrix.__pool.release(matrix);
		return value;
	}
	,get_loaderInfo: function() {
		if(this.stage != null) {
			return openfl_utils__$internal_Lib.current.__loaderInfo;
		}
		return null;
	}
	,get_mask: function() {
		return this.__mask;
	}
	,set_mask: function(value) {
		if(value == this.__mask) {
			return value;
		}
		if(value != this.__mask) {
			this.__setTransformDirty();
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		if(this.__mask != null) {
			this.__mask.__isMask = false;
			this.__mask.__maskTarget = null;
			this.__mask.__setTransformDirty();
			var _this = this.__mask;
			if(!_this.__renderDirty) {
				_this.__renderDirty = true;
				_this.__setParentRenderDirty();
			}
		}
		if(value != null) {
			value.__isMask = true;
			value.__maskTarget = this;
			value.__setWorldTransformInvalid();
		}
		if(this.__cacheBitmap != null && this.__cacheBitmap.get_mask() != value) {
			this.__cacheBitmap.set_mask(value);
		}
		return this.__mask = value;
	}
	,get_mouseX: function() {
		var mouseX = this.stage != null ? this.stage.__mouseX : openfl_utils__$internal_Lib.current.stage.__mouseX;
		var mouseY = this.stage != null ? this.stage.__mouseY : openfl_utils__$internal_Lib.current.stage.__mouseY;
		var _this = this.__getRenderTransform();
		var norm = _this.a * _this.d - _this.b * _this.c;
		if(norm == 0) {
			return -_this.tx;
		} else {
			return 1.0 / norm * (_this.c * (_this.ty - mouseY) + _this.d * (mouseX - _this.tx));
		}
	}
	,get_mouseY: function() {
		var mouseX = this.stage != null ? this.stage.__mouseX : openfl_utils__$internal_Lib.current.stage.__mouseX;
		var mouseY = this.stage != null ? this.stage.__mouseY : openfl_utils__$internal_Lib.current.stage.__mouseY;
		var _this = this.__getRenderTransform();
		var norm = _this.a * _this.d - _this.b * _this.c;
		if(norm == 0) {
			return -_this.ty;
		} else {
			return 1.0 / norm * (_this.a * (mouseY - _this.ty) + _this.b * (_this.tx - mouseX));
		}
	}
	,get_name: function() {
		return this.__name;
	}
	,set_name: function(value) {
		return this.__name = value;
	}
	,get_root: function() {
		if(this.stage != null) {
			return openfl_utils__$internal_Lib.current;
		}
		return null;
	}
	,get_rotation: function() {
		return this.__rotation;
	}
	,set_rotation: function(value) {
		if(value != this.__rotation) {
			this.__rotation = value;
			var radians = this.__rotation * (Math.PI / 180);
			this.__rotationSine = Math.sin(radians);
			this.__rotationCosine = Math.cos(radians);
			this.__transform.a = this.__rotationCosine * this.__scaleX;
			this.__transform.b = this.__rotationSine * this.__scaleX;
			this.__transform.c = -this.__rotationSine * this.__scaleY;
			this.__transform.d = this.__rotationCosine * this.__scaleY;
			this.__setTransformDirty();
		}
		return value;
	}
	,get_scale9Grid: function() {
		if(this.__scale9Grid == null) {
			return null;
		}
		return this.__scale9Grid.clone();
	}
	,set_scale9Grid: function(value) {
		if(value == null && this.__scale9Grid == null) {
			return value;
		}
		if(value != null && this.__scale9Grid != null && this.__scale9Grid.equals(value)) {
			return value;
		}
		if(value != null) {
			if(this.__scale9Grid == null) {
				this.__scale9Grid = new openfl_geom_Rectangle();
			}
			this.__scale9Grid.copyFrom(value);
		} else {
			this.__scale9Grid = null;
		}
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
		return value;
	}
	,get_scaleX: function() {
		return this.__scaleX;
	}
	,set_scaleX: function(value) {
		if(value != this.__scaleX) {
			this.__scaleX = value;
			if(this.__transform.b == 0) {
				if(value != this.__transform.a) {
					this.__setTransformDirty();
				}
				this.__transform.a = value;
			} else {
				var a = this.__rotationCosine * value;
				var b = this.__rotationSine * value;
				if(this.__transform.a != a || this.__transform.b != b) {
					this.__setTransformDirty();
				}
				this.__transform.a = a;
				this.__transform.b = b;
			}
		}
		return value;
	}
	,get_scaleY: function() {
		return this.__scaleY;
	}
	,set_scaleY: function(value) {
		if(value != this.__scaleY) {
			this.__scaleY = value;
			if(this.__transform.c == 0) {
				if(value != this.__transform.d) {
					this.__setTransformDirty();
				}
				this.__transform.d = value;
			} else {
				var c = -this.__rotationSine * value;
				var d = this.__rotationCosine * value;
				if(this.__transform.d != d || this.__transform.c != c) {
					this.__setTransformDirty();
				}
				this.__transform.c = c;
				this.__transform.d = d;
			}
		}
		return value;
	}
	,get_scrollRect: function() {
		if(this.__scrollRect == null) {
			return null;
		}
		return this.__scrollRect.clone();
	}
	,set_scrollRect: function(value) {
		if(value == null && this.__scrollRect == null) {
			return value;
		}
		if(value != null && this.__scrollRect != null && this.__scrollRect.equals(value)) {
			return value;
		}
		if(value != null) {
			if(this.__scrollRect == null) {
				this.__scrollRect = new openfl_geom_Rectangle();
			}
			this.__scrollRect.copyFrom(value);
		} else {
			this.__scrollRect = null;
		}
		this.__setTransformDirty();
		if(openfl_display_DisplayObject.__supportDOM) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return value;
	}
	,get_shader: function() {
		return this.__shader;
	}
	,set_shader: function(value) {
		this.__shader = value;
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
		return value;
	}
	,get_transform: function() {
		if(this.__objectTransform == null) {
			this.__objectTransform = new openfl_geom_Transform(this);
		}
		return this.__objectTransform;
	}
	,set_transform: function(value) {
		if(value == null) {
			throw new js__$Boot_HaxeError(new openfl_errors_TypeError("Parameter transform must be non-null."));
		}
		if(this.__objectTransform == null) {
			this.__objectTransform = new openfl_geom_Transform(this);
		}
		this.__setTransformDirty();
		this.__objectTransform.set_matrix(value.get_matrix());
		if(!this.__objectTransform.__colorTransform.__equals(value.__colorTransform,true) || !this.get_cacheAsBitmap() && this.__objectTransform.__colorTransform.alphaMultiplier != value.__colorTransform.alphaMultiplier) {
			this.__objectTransform.__colorTransform.__copyFrom(value.get_colorTransform());
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__objectTransform;
	}
	,get_visible: function() {
		return this.__visible;
	}
	,set_visible: function(value) {
		if(value != this.__visible) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__visible = value;
	}
	,get_width: function() {
		var rect = openfl_geom_Rectangle.__pool.get();
		this.__getLocalBounds(rect);
		var width = rect.width;
		openfl_geom_Rectangle.__pool.release(rect);
		return width;
	}
	,set_width: function(value) {
		var rect = openfl_geom_Rectangle.__pool.get();
		var matrix = openfl_geom_Matrix.__pool.get();
		matrix.identity();
		this.__getBounds(rect,matrix);
		if(value != rect.width) {
			this.set_scaleX(value / rect.width);
		} else {
			this.set_scaleX(1);
		}
		openfl_geom_Rectangle.__pool.release(rect);
		openfl_geom_Matrix.__pool.release(matrix);
		return value;
	}
	,get_x: function() {
		return this.__transform.tx;
	}
	,set_x: function(value) {
		if(value != this.__transform.tx) {
			this.__setTransformDirty();
		}
		return this.__transform.tx = value;
	}
	,get_y: function() {
		return this.__transform.ty;
	}
	,set_y: function(value) {
		if(value != this.__transform.ty) {
			this.__setTransformDirty();
		}
		return this.__transform.ty = value;
	}
	,__class__: openfl_display_DisplayObject
	,__properties__: {set_y:"set_y",get_y:"get_y",set_x:"set_x",get_x:"get_x",set_width:"set_width",get_width:"get_width",set_visible:"set_visible",get_visible:"get_visible",set_transform:"set_transform",get_transform:"get_transform",set_shader:"set_shader",get_shader:"get_shader",set_scrollRect:"set_scrollRect",get_scrollRect:"get_scrollRect",set_scaleY:"set_scaleY",get_scaleY:"get_scaleY",set_scaleX:"set_scaleX",get_scaleX:"get_scaleX",set_scale9Grid:"set_scale9Grid",get_scale9Grid:"get_scale9Grid",set_rotation:"set_rotation",get_rotation:"get_rotation",get_root:"get_root",set_name:"set_name",get_name:"get_name",get_mouseY:"get_mouseY",get_mouseX:"get_mouseX",set_mask:"set_mask",get_mask:"get_mask",get_loaderInfo:"get_loaderInfo",set_height:"set_height",get_height:"get_height",set_filters:"set_filters",get_filters:"get_filters",set_cacheAsBitmapMatrix:"set_cacheAsBitmapMatrix",get_cacheAsBitmapMatrix:"get_cacheAsBitmapMatrix",set_cacheAsBitmap:"set_cacheAsBitmap",get_cacheAsBitmap:"get_cacheAsBitmap",set_blendMode:"set_blendMode",get_blendMode:"get_blendMode",set_alpha:"set_alpha",get_alpha:"get_alpha"}
});
var openfl_display_InteractiveObject = function() {
	openfl_display_DisplayObject.call(this);
	this.doubleClickEnabled = false;
	this.mouseEnabled = true;
	this.needsSoftKeyboard = false;
	this.__tabEnabled = null;
	this.__tabIndex = -1;
};
$hxClasses["openfl.display.InteractiveObject"] = openfl_display_InteractiveObject;
openfl_display_InteractiveObject.__name__ = ["openfl","display","InteractiveObject"];
openfl_display_InteractiveObject.__super__ = openfl_display_DisplayObject;
openfl_display_InteractiveObject.prototype = $extend(openfl_display_DisplayObject.prototype,{
	requestSoftKeyboard: function() {
		openfl_utils__$internal_Lib.notImplemented({ fileName : "InteractiveObject.hx", lineNumber : 1251, className : "openfl.display.InteractiveObject", methodName : "requestSoftKeyboard"});
		return false;
	}
	,__allowMouseFocus: function() {
		return this.get_tabEnabled();
	}
	,__getInteractive: function(stack) {
		if(stack != null) {
			stack.push(this);
			if(this.parent != null) {
				this.parent.__getInteractive(stack);
			}
		}
		return true;
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(!hitObject.get_visible() || this.__isMask || interactiveOnly && !this.mouseEnabled) {
			return false;
		}
		return openfl_display_DisplayObject.prototype.__hitTest.call(this,x,y,shapeFlag,stack,interactiveOnly,hitObject);
	}
	,__tabTest: function(stack) {
		if(this.get_tabEnabled()) {
			stack.push(this);
		}
	}
	,get_tabEnabled: function() {
		if(this.__tabEnabled == true) {
			return true;
		} else {
			return false;
		}
	}
	,set_tabEnabled: function(value) {
		if(this.__tabEnabled != value) {
			this.__tabEnabled = value;
			this.dispatchEvent(new openfl_events_Event("tabEnabledChange",true,false));
		}
		return this.__tabEnabled;
	}
	,get_tabIndex: function() {
		return this.__tabIndex;
	}
	,set_tabIndex: function(value) {
		if(this.__tabIndex != value) {
			if(value < -1) {
				throw new js__$Boot_HaxeError(new openfl_errors_RangeError("Parameter tabIndex must be a non-negative number; got " + value));
			}
			this.__tabIndex = value;
			this.dispatchEvent(new openfl_events_Event("tabIndexChange",true,false));
		}
		return this.__tabIndex;
	}
	,__class__: openfl_display_InteractiveObject
	,__properties__: $extend(openfl_display_DisplayObject.prototype.__properties__,{set_tabIndex:"set_tabIndex",get_tabIndex:"get_tabIndex",set_tabEnabled:"set_tabEnabled",get_tabEnabled:"get_tabEnabled"})
});
var openfl_display_DisplayObjectContainer = function() {
	openfl_display_InteractiveObject.call(this);
	this.mouseChildren = true;
	this.__tabChildren = true;
	this.__children = [];
	this.__removedChildren = openfl__$Vector_Vector_$Impl_$.toObjectVector(null);
};
$hxClasses["openfl.display.DisplayObjectContainer"] = openfl_display_DisplayObjectContainer;
openfl_display_DisplayObjectContainer.__name__ = ["openfl","display","DisplayObjectContainer"];
openfl_display_DisplayObjectContainer.__super__ = openfl_display_InteractiveObject;
openfl_display_DisplayObjectContainer.prototype = $extend(openfl_display_InteractiveObject.prototype,{
	addChild: function(child) {
		return this.addChildAt(child,this.get_numChildren());
	}
	,addChildAt: function(child,index) {
		if(child == null) {
			var error = new openfl_errors_TypeError("Error #2007: Parameter child must be non-null.");
			error.errorID = 2007;
			throw new js__$Boot_HaxeError(error);
		} else if(child.stage == child) {
			var error1 = new openfl_errors_ArgumentError("Error #3783: A Stage object cannot be added as the child of another object.");
			error1.errorID = 3783;
			throw new js__$Boot_HaxeError(error1);
		}
		if(index > this.__children.length || index < 0) {
			throw new js__$Boot_HaxeError("Invalid index position " + index);
		}
		if(child.parent == this) {
			if(this.__children[index] != child) {
				HxOverrides.remove(this.__children,child);
				this.__children.splice(index,0,child);
				if(!this.__renderDirty) {
					this.__renderDirty = true;
					this.__setParentRenderDirty();
				}
			}
		} else {
			if(child.parent != null) {
				child.parent.removeChild(child);
			}
			this.__children.splice(index,0,child);
			child.parent = this;
			var addedToStage = this.stage != null && child.stage == null;
			if(addedToStage) {
				child.__setStageReference(this.stage);
			}
			child.__setTransformDirty();
			if(!child.__renderDirty) {
				child.__renderDirty = true;
				child.__setParentRenderDirty();
			}
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
			var event = new openfl_events_Event("added");
			event.bubbles = true;
			event.target = child;
			child.__dispatchWithCapture(event);
			if(addedToStage) {
				event = new openfl_events_Event("addedToStage",false,false);
				child.__dispatchWithCapture(event);
				child.__dispatchChildren(event);
			}
		}
		return child;
	}
	,areInaccessibleObjectsUnderPoint: function(point) {
		return false;
	}
	,contains: function(child) {
		while(child != this && child != null) child = child.parent;
		return child == this;
	}
	,getChildAt: function(index) {
		if(index >= 0 && index < this.__children.length) {
			return this.__children[index];
		}
		return null;
	}
	,getChildByName: function(name) {
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.get_name() == name) {
				return child;
			}
		}
		return null;
	}
	,getChildIndex: function(child) {
		var _g1 = 0;
		var _g = this.__children.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(this.__children[i] == child) {
				return i;
			}
		}
		return -1;
	}
	,getObjectsUnderPoint: function(point) {
		var stack = [];
		this.__hitTest(point.x,point.y,false,stack,false,this);
		stack.reverse();
		return stack;
	}
	,removeChild: function(child) {
		if(child != null && child.parent == this) {
			child.__setTransformDirty();
			if(!child.__renderDirty) {
				child.__renderDirty = true;
				child.__setParentRenderDirty();
			}
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
			var event = new openfl_events_Event("removed",true);
			child.__dispatchWithCapture(event);
			if(this.stage != null) {
				if(child.stage != null && this.stage.get_focus() == child) {
					this.stage.set_focus(null);
				}
				var event1 = new openfl_events_Event("removedFromStage",false,false);
				child.__dispatchWithCapture(event1);
				child.__dispatchChildren(event1);
				child.__setStageReference(null);
			}
			child.parent = null;
			HxOverrides.remove(this.__children,child);
			this.__removedChildren.push(child);
			child.__setTransformDirty();
		}
		return child;
	}
	,removeChildAt: function(index) {
		if(index >= 0 && index < this.__children.length) {
			return this.removeChild(this.__children[index]);
		}
		return null;
	}
	,removeChildren: function(beginIndex,endIndex) {
		if(endIndex == null) {
			endIndex = 2147483647;
		}
		if(beginIndex == null) {
			beginIndex = 0;
		}
		if(endIndex == 2147483647) {
			endIndex = this.__children.length - 1;
			if(endIndex < 0) {
				return;
			}
		}
		if(beginIndex > this.__children.length - 1) {
			return;
		} else if(endIndex < beginIndex || beginIndex < 0 || endIndex > this.__children.length) {
			throw new js__$Boot_HaxeError(new openfl_errors_RangeError("The supplied index is out of bounds."));
		}
		var numRemovals = endIndex - beginIndex;
		while(numRemovals >= 0) {
			this.removeChildAt(beginIndex);
			--numRemovals;
		}
	}
	,resolve: function(fieldName) {
		if(this.__children == null) {
			return null;
		}
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.get_name() == fieldName) {
				return child;
			}
		}
		return null;
	}
	,setChildIndex: function(child,index) {
		if(index >= 0 && index <= this.__children.length && child.parent == this) {
			HxOverrides.remove(this.__children,child);
			this.__children.splice(index,0,child);
		}
	}
	,stopAllMovieClips: function() {
		this.__stopAllMovieClips();
	}
	,swapChildren: function(child1,child2) {
		if(child1.parent == this && child2.parent == this) {
			var index1 = this.__children.indexOf(child1);
			var index2 = this.__children.indexOf(child2);
			this.__children[index1] = child2;
			this.__children[index2] = child1;
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
	}
	,swapChildrenAt: function(index1,index2) {
		var swap = this.__children[index1];
		this.__children[index1] = this.__children[index2];
		this.__children[index2] = swap;
		swap = null;
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
	}
	,__cleanup: function() {
		openfl_display_InteractiveObject.prototype.__cleanup.call(this);
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__cleanup();
		}
		var _g2 = 0;
		var _g11 = this.__removedChildren;
		while(_g2 < _g11.get_length()) {
			var orphan = _g11.get(_g2);
			++_g2;
			if(orphan.stage == null) {
				orphan.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
	}
	,__cleanupRemovedChildren: function() {
		var _g = 0;
		var _g1 = this.__removedChildren;
		while(_g < _g1.get_length()) {
			var orphan = _g1.get(_g);
			++_g;
			if(orphan.stage == null) {
				orphan.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
	}
	,__dispatchChildren: function(event) {
		if(this.__children != null) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				event.target = child;
				if(!child.__dispatchWithCapture(event)) {
					break;
				}
				child.__dispatchChildren(event);
			}
		}
	}
	,__enterFrame: function(deltaTime) {
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__enterFrame(deltaTime);
		}
	}
	,__getBounds: function(rect,matrix) {
		openfl_display_InteractiveObject.prototype.__getBounds.call(this,rect,matrix);
		if(this.__children.length == 0) {
			return;
		}
		var childWorldTransform = openfl_geom_Matrix.__pool.get();
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.__scaleX == 0 || child.__scaleY == 0) {
				continue;
			}
			var local = child.__transform;
			childWorldTransform.a = local.a * matrix.a + local.b * matrix.c;
			childWorldTransform.b = local.a * matrix.b + local.b * matrix.d;
			childWorldTransform.c = local.c * matrix.a + local.d * matrix.c;
			childWorldTransform.d = local.c * matrix.b + local.d * matrix.d;
			childWorldTransform.tx = local.tx * matrix.a + local.ty * matrix.c + matrix.tx;
			childWorldTransform.ty = local.tx * matrix.b + local.ty * matrix.d + matrix.ty;
			child.__getBounds(rect,childWorldTransform);
		}
		openfl_geom_Matrix.__pool.release(childWorldTransform);
	}
	,__getFilterBounds: function(rect,matrix) {
		openfl_display_InteractiveObject.prototype.__getFilterBounds.call(this,rect,matrix);
		if(this.__scrollRect != null) {
			return;
		}
		if(this.__children.length == 0) {
			return;
		}
		var childWorldTransform = openfl_geom_Matrix.__pool.get();
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.__scaleX == 0 || child.__scaleY == 0 || child.__isMask) {
				continue;
			}
			var local = child.__transform;
			childWorldTransform.a = local.a * matrix.a + local.b * matrix.c;
			childWorldTransform.b = local.a * matrix.b + local.b * matrix.d;
			childWorldTransform.c = local.c * matrix.a + local.d * matrix.c;
			childWorldTransform.d = local.c * matrix.b + local.d * matrix.d;
			childWorldTransform.tx = local.tx * matrix.a + local.ty * matrix.c + matrix.tx;
			childWorldTransform.ty = local.tx * matrix.b + local.ty * matrix.d + matrix.ty;
			var childRect = openfl_geom_Rectangle.__pool.get();
			child.__getFilterBounds(childRect,childWorldTransform);
			rect.__expand(childRect.x,childRect.y,childRect.width,childRect.height);
			openfl_geom_Rectangle.__pool.release(childRect);
		}
		openfl_geom_Matrix.__pool.release(childWorldTransform);
	}
	,__getRenderBounds: function(rect,matrix) {
		if(this.__scrollRect != null) {
			openfl_display_InteractiveObject.prototype.__getRenderBounds.call(this,rect,matrix);
			return;
		} else {
			openfl_display_InteractiveObject.prototype.__getBounds.call(this,rect,matrix);
		}
		if(this.__children.length == 0) {
			return;
		}
		var childWorldTransform = openfl_geom_Matrix.__pool.get();
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.__scaleX == 0 || child.__scaleY == 0 || child.__isMask) {
				continue;
			}
			var local = child.__transform;
			childWorldTransform.a = local.a * matrix.a + local.b * matrix.c;
			childWorldTransform.b = local.a * matrix.b + local.b * matrix.d;
			childWorldTransform.c = local.c * matrix.a + local.d * matrix.c;
			childWorldTransform.d = local.c * matrix.b + local.d * matrix.d;
			childWorldTransform.tx = local.tx * matrix.a + local.ty * matrix.c + matrix.tx;
			childWorldTransform.ty = local.tx * matrix.b + local.ty * matrix.d + matrix.ty;
			child.__getRenderBounds(rect,childWorldTransform);
		}
		openfl_geom_Matrix.__pool.release(childWorldTransform);
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(!hitObject.get_visible() || this.__isMask || interactiveOnly && !this.mouseEnabled && !this.mouseChildren) {
			return false;
		}
		if(this.get_mask() != null && !this.get_mask().__hitTestMask(x,y)) {
			return false;
		}
		if(this.__scrollRect != null) {
			var point = openfl_geom_Point.__pool.get();
			point.setTo(x,y);
			var _this = this.__getRenderTransform();
			var norm = _this.a * _this.d - _this.b * _this.c;
			if(norm == 0) {
				point.x = -_this.tx;
				point.y = -_this.ty;
			} else {
				var px = 1.0 / norm * (_this.c * (_this.ty - point.y) + _this.d * (point.x - _this.tx));
				point.y = 1.0 / norm * (_this.a * (point.y - _this.ty) + _this.b * (_this.tx - point.x));
				point.x = px;
			}
			if(!this.__scrollRect.containsPoint(point)) {
				openfl_geom_Point.__pool.release(point);
				return false;
			}
			openfl_geom_Point.__pool.release(point);
		}
		var i = this.__children.length;
		if(interactiveOnly) {
			if(stack == null || !this.mouseChildren) {
				while(--i >= 0) if(this.__children[i].__hitTest(x,y,shapeFlag,null,true,this.__children[i])) {
					if(stack != null) {
						stack.push(hitObject);
					}
					return true;
				}
			} else if(stack != null) {
				var length = stack.length;
				var interactive = false;
				var hitTest = false;
				while(--i >= 0) {
					interactive = this.__children[i].__getInteractive(null);
					if(interactive || this.mouseEnabled && !hitTest) {
						if(this.__children[i].__hitTest(x,y,shapeFlag,stack,true,this.__children[i])) {
							hitTest = true;
							if(interactive && stack.length > length) {
								break;
							}
						}
					}
				}
				if(hitTest) {
					stack.splice(length,0,hitObject);
					return true;
				}
			}
		} else {
			var hitTest1 = false;
			while(--i >= 0) if(this.__children[i].__hitTest(x,y,shapeFlag,stack,false,this.__children[i])) {
				hitTest1 = true;
				if(stack == null) {
					break;
				}
			}
			return hitTest1;
		}
		return false;
	}
	,__hitTestMask: function(x,y) {
		var i = this.__children.length;
		while(--i >= 0) if(this.__children[i].__hitTestMask(x,y)) {
			return true;
		}
		return false;
	}
	,__readGraphicsData: function(graphicsData,recurse) {
		openfl_display_InteractiveObject.prototype.__readGraphicsData.call(this,graphicsData,recurse);
		if(recurse) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__readGraphicsData(graphicsData,recurse);
			}
		}
	}
	,__setStageReference: function(stage) {
		openfl_display_InteractiveObject.prototype.__setStageReference.call(this,stage);
		if(this.__children != null) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__setStageReference(stage);
			}
		}
	}
	,__setWorldTransformInvalid: function() {
		if(!this.__worldTransformInvalid) {
			this.__worldTransformInvalid = true;
			if(this.__children != null) {
				var _g = 0;
				var _g1 = this.__children;
				while(_g < _g1.length) {
					var child = _g1[_g];
					++_g;
					child.__setWorldTransformInvalid();
				}
			}
		}
	}
	,__stopAllMovieClips: function() {
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__stopAllMovieClips();
		}
	}
	,__tabTest: function(stack) {
		openfl_display_InteractiveObject.prototype.__tabTest.call(this,stack);
		if(!this.get_tabChildren()) {
			return;
		}
		var interactive = false;
		var interactiveObject = null;
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			interactive = child.__getInteractive(null);
			if(interactive) {
				interactiveObject = child;
				interactiveObject.__tabTest(stack);
			}
		}
	}
	,__update: function(transformOnly,updateChildren) {
		openfl_display_InteractiveObject.prototype.__update.call(this,transformOnly,updateChildren);
		if(updateChildren) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__update(transformOnly,true);
			}
		}
	}
	,get_numChildren: function() {
		return this.__children.length;
	}
	,get_tabChildren: function() {
		return this.__tabChildren;
	}
	,set_tabChildren: function(value) {
		if(this.__tabChildren != value) {
			this.__tabChildren = value;
			this.dispatchEvent(new openfl_events_Event("tabChildrenChange",true,false));
		}
		return this.__tabChildren;
	}
	,__class__: openfl_display_DisplayObjectContainer
	,__properties__: $extend(openfl_display_InteractiveObject.prototype.__properties__,{set_tabChildren:"set_tabChildren",get_tabChildren:"get_tabChildren",get_numChildren:"get_numChildren"})
});
var openfl_display_Sprite = function() {
	openfl_display_DisplayObjectContainer.call(this);
	this.__drawableType = 4;
	this.__buttonMode = false;
	this.useHandCursor = true;
};
$hxClasses["openfl.display.Sprite"] = openfl_display_Sprite;
openfl_display_Sprite.__name__ = ["openfl","display","Sprite"];
openfl_display_Sprite.__super__ = openfl_display_DisplayObjectContainer;
openfl_display_Sprite.prototype = $extend(openfl_display_DisplayObjectContainer.prototype,{
	startDrag: function(lockCenter,bounds) {
		if(lockCenter == null) {
			lockCenter = false;
		}
		if(this.stage != null) {
			this.stage.__startDrag(this,lockCenter,bounds);
		}
	}
	,stopDrag: function() {
		if(this.stage != null) {
			this.stage.__stopDrag(this);
		}
	}
	,__getCursor: function() {
		if(this.__buttonMode && this.useHandCursor) {
			return "button";
		} else {
			return null;
		}
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(interactiveOnly && !this.mouseEnabled && !this.mouseChildren) {
			return false;
		}
		if(!hitObject.get_visible() || this.__isMask) {
			return this.__hitTestHitArea(x,y,shapeFlag,stack,interactiveOnly,hitObject);
		}
		if(this.get_mask() != null && !this.get_mask().__hitTestMask(x,y)) {
			return this.__hitTestHitArea(x,y,shapeFlag,stack,interactiveOnly,hitObject);
		}
		if(this.__scrollRect != null) {
			var point = openfl_geom_Point.__pool.get();
			point.setTo(x,y);
			var _this = this.__getRenderTransform();
			var norm = _this.a * _this.d - _this.b * _this.c;
			if(norm == 0) {
				point.x = -_this.tx;
				point.y = -_this.ty;
			} else {
				var px = 1.0 / norm * (_this.c * (_this.ty - point.y) + _this.d * (point.x - _this.tx));
				point.y = 1.0 / norm * (_this.a * (point.y - _this.ty) + _this.b * (_this.tx - point.x));
				point.x = px;
			}
			if(!this.__scrollRect.containsPoint(point)) {
				openfl_geom_Point.__pool.release(point);
				return this.__hitTestHitArea(x,y,shapeFlag,stack,true,hitObject);
			}
			openfl_geom_Point.__pool.release(point);
		}
		if(openfl_display_DisplayObjectContainer.prototype.__hitTest.call(this,x,y,shapeFlag,stack,interactiveOnly,hitObject)) {
			if(stack != null) {
				return interactiveOnly;
			} else {
				return true;
			}
		} else if(this.hitArea == null && this.__graphics != null && this.__graphics.__hitTest(x,y,shapeFlag,this.__getRenderTransform())) {
			if(stack != null && (!interactiveOnly || this.mouseEnabled)) {
				stack.push(hitObject);
			}
			return true;
		}
		return this.__hitTestHitArea(x,y,shapeFlag,stack,interactiveOnly,hitObject);
	}
	,__hitTestHitArea: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(this.hitArea != null) {
			if(!this.hitArea.mouseEnabled) {
				this.hitArea.mouseEnabled = true;
				var hitTest = this.hitArea.__hitTest(x,y,shapeFlag,null,true,hitObject);
				this.hitArea.mouseEnabled = false;
				if(stack != null && hitTest) {
					stack[stack.length] = hitObject;
				}
				return hitTest;
			}
		}
		return false;
	}
	,__hitTestMask: function(x,y) {
		if(openfl_display_DisplayObjectContainer.prototype.__hitTestMask.call(this,x,y)) {
			return true;
		} else if(this.__graphics != null && this.__graphics.__hitTest(x,y,true,this.__getRenderTransform())) {
			return true;
		}
		return false;
	}
	,get_graphics: function() {
		if(this.__graphics == null) {
			this.__graphics = new openfl_display_Graphics(this);
		}
		return this.__graphics;
	}
	,get_tabEnabled: function() {
		if(this.__tabEnabled == null) {
			return this.__buttonMode;
		} else {
			return this.__tabEnabled;
		}
	}
	,get_buttonMode: function() {
		return this.__buttonMode;
	}
	,set_buttonMode: function(value) {
		return this.__buttonMode = value;
	}
	,__class__: openfl_display_Sprite
	,__properties__: $extend(openfl_display_DisplayObjectContainer.prototype.__properties__,{get_graphics:"get_graphics",set_buttonMode:"set_buttonMode",get_buttonMode:"get_buttonMode"})
});
var Main = function() {
	this.chara2 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/jizou.png"));
	this.chara = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/jizou.png"));
	this.bitmap6 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.lll = new haxe_ds_StringMap();
	this.bitmap5 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.bitmap4 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.bitmap3 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.bitmap2 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.bitmap1 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.isibitmap8 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap7 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap6 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap5 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap4 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap3 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap2 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.date = new Date();
	this.isibitmap1 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.heartbitmap = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/heart.png"));
	this.scoreall = [0,0,0,0];
	this.BG = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/BG.jpg"));
	this.timer = new openfl_utils_Timer(100);
	this.bkg = new openfl_display_Sprite();
	openfl_display_Sprite.call(this);
	haxe_Log.trace("aaaaa",{ fileName : "Main.hx", lineNumber : 69, className : "Main", methodName : "new"});
	this.life = 3;
	this.score = 0;
	this.timer2 = 100;
	this._text = new openfl_text_TextField();
	this.lifetext = new openfl_text_TextField();
	this.timertext = new openfl_text_TextField();
	this.gameovertext = new openfl_text_TextField();
	this.datatext = new openfl_text_TextField();
	this.datatext2 = new openfl_text_TextField();
	this.datatext3 = new openfl_text_TextField();
	this.datatext4 = new openfl_text_TextField();
	this._text.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.lifetext.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.timertext.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.gameovertext.set_defaultTextFormat(new openfl_text_TextFormat("Times",60,2105376));
	this.datatext.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.datatext2.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.datatext3.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.datatext4.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.isiSound = openfl_utils_Assets.getSound("assets/isi.ogg");
	this.heartSound = openfl_utils_Assets.getSound("assets/heart.ogg");
	this.obSound = openfl_utils_Assets.getSound("assets/ob.ogg");
	this.bkg.get_graphics().beginFill(16777215,1);
	this.bkg.get_graphics().drawRect(0,0,768,1280);
	this.bkg.get_graphics().endFill();
	this._text.set_x(50);
	this._text.set_y(50);
	this._text.set_width(350);
	this._text.set_textColor(65535);
	this.lifetext.set_x(50);
	this.lifetext.set_y(100);
	this.lifetext.set_width(350);
	this.lifetext.set_textColor(16711680);
	this.timertext.set_x(50);
	this.timertext.set_y(150);
	this.timertext.set_width(350);
	this.timertext.set_textColor(0);
	this.gameovertext.set_x(150);
	this.gameovertext.set_y(150);
	this.gameovertext.set_width(350);
	this.datatext.set_x(250);
	this.datatext.set_y(250);
	this.datatext.set_width(250);
	this.chara2.set_x(100);
	this.chara2.set_y(100);
	this.addChild(this.bkg);
	this.addChild(this.BG);
	this.addChild(this.heartbitmap);
	this.addChild(this.isibitmap1);
	this.addChild(this.isibitmap2);
	this.addChild(this.isibitmap3);
	this.addChild(this.isibitmap4);
	this.addChild(this.isibitmap5);
	this.addChild(this.isibitmap6);
	this.addChild(this.isibitmap7);
	this.addChild(this.isibitmap8);
	this.addChild(this.bitmap1);
	this.addChild(this.bitmap2);
	this.addChild(this.bitmap3);
	this.addChild(this.bitmap4);
	this.addChild(this.bitmap5);
	this.addChild(this.bitmap6);
	this.addChild(this.chara);
	this.addChild(this._text);
	this.addChild(this.lifetext);
	this.addChild(this.timertext);
	this.isibitmap1.set_y(200);
	this.isibitmap1.set_x(200);
	this.isibitmap2.set_y(150);
	this.isibitmap2.set_x(150);
	this.isibitmap3.set_y(300);
	this.isibitmap3.set_x(300);
	this.isibitmap4.set_y(250);
	this.isibitmap4.set_x(250);
	this.isibitmap5.set_y(300);
	this.isibitmap5.set_x(300);
	this.isibitmap6.set_y(450);
	this.isibitmap6.set_x(450);
	this.isibitmap7.set_y(500);
	this.isibitmap7.set_x(500);
	this.isibitmap8.set_y(550);
	this.isibitmap8.set_x(550);
	this.heartbitmap.set_y(50);
	this.heartbitmap.set_x(50);
	this.bitmap1.set_y(100);
	this.bitmap2.set_y(200);
	this.bitmap3.set_y(200);
	this.bitmap4.set_y(100);
	this.bitmap5.set_y(200);
	this.bitmap6.set_y(200);
	this.bitmap1.set_x(100);
	this.bitmap2.set_x(200);
	this.bitmap3.set_x(300);
	this.bitmap4.set_x(400);
	this.bitmap5.set_x(500);
	this.bitmap6.set_x(600);
	this.addEventListener("enterFrame",$bind(this,this.loop));
};
$hxClasses["Main"] = Main;
Main.__name__ = ["Main"];
Main.__super__ = openfl_display_Sprite;
Main.prototype = $extend(openfl_display_Sprite.prototype,{
	loop: function(e) {
		this.chara.set_y(this.get_mouseY());
		this._text.set_text("Score スコア " + this.score);
		this.lifetext.set_text("Life " + this.life);
		this.time3 = this.timer2 / 100;
		this.timertext.set_text("Time " + this.time3);
		this.gameovertext.set_text("GAME OVER");
		this.timer2 += 1;
		this.chara.set_x(this.get_mouseX());
		var _g = this.isibitmap1;
		_g.set_y(_g.get_y() + 10);
		var _g1 = this.isibitmap2;
		_g1.set_y(_g1.get_y() + 5);
		var _g2 = this.isibitmap3;
		_g2.set_y(_g2.get_y() + 10);
		var _g3 = this.isibitmap4;
		_g3.set_y(_g3.get_y() + 5);
		var _g4 = this.isibitmap5;
		_g4.set_y(_g4.get_y() + 10);
		var _g5 = this.isibitmap6;
		_g5.set_y(_g5.get_y() + 5);
		var _g6 = this.isibitmap7;
		_g6.set_y(_g6.get_y() + 10);
		var _g7 = this.isibitmap8;
		_g7.set_y(_g7.get_y() + 5);
		var _g8 = this.heartbitmap;
		_g8.set_y(_g8.get_y() + 15);
		var _g9 = this.bitmap1;
		_g9.set_y(_g9.get_y() + 10);
		var _g10 = this.bitmap2;
		_g10.set_y(_g10.get_y() + 10);
		var _g11 = this.bitmap3;
		_g11.set_y(_g11.get_y() + 10);
		var _g12 = this.bitmap4;
		_g12.set_y(_g12.get_y() + 10);
		var _g13 = this.bitmap5;
		_g13.set_y(_g13.get_y() + 10);
		var _g14 = this.bitmap6;
		_g14.set_y(_g14.get_y() + 10);
		if(this.isibitmap1.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap1.set_y(0);
			this.isibitmap1.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap2.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap2.set_y(0);
			this.isibitmap2.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap3.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap3.set_y(0);
			this.isibitmap3.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap4.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap4.set_y(0);
			this.isibitmap4.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap5.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap5.set_y(0);
			this.isibitmap5.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap6.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap6.set_y(0);
			this.isibitmap6.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap7.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap7.set_y(0);
			this.isibitmap7.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap8.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap8.set_y(0);
			this.isibitmap8.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.heartbitmap.hitTestPoint(this.chara.get_x(),this.chara.get_y(),false)) {
			this.heartbitmap.set_y(0);
			this.heartbitmap.set_x(Math.random() * 768);
			this.life += 1;
			this.heartSound.play(0);
		}
		if(this.bitmap1.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap1.set_y(0);
			this.bitmap1.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.bitmap2.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap2.set_y(0);
			this.bitmap2.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.bitmap3.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap3.set_y(0);
			this.bitmap3.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.bitmap4.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap4.set_y(0);
			this.bitmap4.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.bitmap5.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap5.set_y(0);
			this.bitmap5.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.bitmap6.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap6.set_y(0);
			this.bitmap6.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.isibitmap1.get_y() >= 1280) {
			this.isibitmap1.set_y(0);
			this.isibitmap1.set_x(Math.random() * 768);
		}
		if(this.isibitmap2.get_y() >= 1280) {
			this.isibitmap2.set_y(0);
			this.isibitmap2.set_x(Math.random() * 768);
		}
		if(this.isibitmap3.get_y() >= 1280) {
			this.isibitmap3.set_y(0);
			this.isibitmap3.set_x(Math.random() * 768);
		}
		if(this.isibitmap4.get_y() >= 1280) {
			this.isibitmap4.set_y(0);
			this.isibitmap4.set_x(Math.random() * 768);
		}
		if(this.isibitmap5.get_y() >= 1280) {
			this.isibitmap5.set_y(0);
			this.isibitmap5.set_x(Math.random() * 768);
		}
		if(this.isibitmap6.get_y() >= 1280) {
			this.isibitmap6.set_y(0);
			this.isibitmap6.set_x(Math.random() * 768);
		}
		if(this.isibitmap7.get_y() >= 1280) {
			this.isibitmap7.set_y(0);
			this.isibitmap7.set_x(Math.random() * 768);
		}
		if(this.isibitmap8.get_y() >= 1280) {
			this.isibitmap8.set_y(0);
			this.isibitmap8.set_x(Math.random() * 768);
		}
		if(this.heartbitmap.get_y() >= 1280) {
			this.heartbitmap.set_y(0);
			this.heartbitmap.set_x(Math.random() * 768);
		}
		if(this.bitmap1.get_y() >= 1280) {
			this.bitmap1.set_y(0);
			this.bitmap1.set_x(Math.random() * 768);
		}
		if(this.bitmap2.get_y() >= 1280) {
			this.bitmap2.set_y(0);
			this.bitmap2.set_x(Math.random() * 768);
		}
		if(this.bitmap3.get_y() >= 1280) {
			this.bitmap3.set_y(0);
			this.bitmap3.set_x(Math.random() * 768);
		}
		if(this.bitmap4.get_y() >= 1280) {
			this.bitmap4.set_y(0);
			this.bitmap4.set_x(Math.random() * 768);
		}
		if(this.bitmap5.get_y() >= 1280) {
			this.bitmap5.set_y(0);
			this.bitmap5.set_x(Math.random() * 768);
		}
		if(this.bitmap6.get_y() >= 1280) {
			this.bitmap6.set_y(0);
			this.bitmap6.set_x(Math.random() * 768);
		}
		if(this.life == 0) {
			this.removeChild(this.heartbitmap);
			this.removeChild(this.isibitmap1);
			this.removeChild(this.isibitmap2);
			this.removeChild(this.isibitmap3);
			this.removeChild(this.isibitmap4);
			this.removeChild(this.isibitmap5);
			this.removeChild(this.isibitmap6);
			this.removeChild(this.isibitmap7);
			this.removeChild(this.isibitmap8);
			this.removeChild(this.bitmap1);
			this.removeChild(this.bitmap2);
			this.removeChild(this.bitmap3);
			this.removeChild(this.bitmap4);
			this.removeChild(this.bitmap5);
			this.removeChild(this.bitmap6);
			this.chara2.set_scaleY(this.score);
			this.chara2.set_scaleX(this.score);
			this.removeChild(this.chara);
			this.removeChild(this.BG);
			this.removeChild(this.timertext);
			this.addChild(this.gameovertext);
			e.preventDefault();
		}
		if(this.time3 == 10.00) {
			haxe_Log.trace(this.scoreall,{ fileName : "Main.hx", lineNumber : 394, className : "Main", methodName : "loop"});
			haxe_Log.trace(js_Cookie.all(),{ fileName : "Main.hx", lineNumber : 395, className : "Main", methodName : "loop"});
			this.removeChild(this.heartbitmap);
			this.removeChild(this.isibitmap1);
			this.removeChild(this.isibitmap2);
			this.removeChild(this.isibitmap3);
			this.removeChild(this.isibitmap4);
			this.removeChild(this.isibitmap5);
			this.removeChild(this.isibitmap6);
			this.removeChild(this.isibitmap7);
			this.removeChild(this.isibitmap8);
			this.removeChild(this.bitmap1);
			this.removeChild(this.bitmap2);
			this.removeChild(this.bitmap3);
			this.removeChild(this.bitmap4);
			this.removeChild(this.bitmap5);
			this.removeChild(this.bitmap6);
			this.removeChild(this.BG);
			this.chara2.set_scaleY(this.score);
			this.chara2.set_scaleX(this.score);
			this.removeChild(this.chara);
			this.addChild(this.chara2);
			this.removeChild(this.timertext);
			this.addChild(this.gameovertext);
			this.scoreall[0] = Std.parseInt(js_Cookie.get("1"));
			this.scoreall[1] = Std.parseInt(js_Cookie.get("2"));
			this.scoreall[2] = Std.parseInt(js_Cookie.get("3"));
			this.scoreall[3] = Std.parseInt(js_Cookie.get("4"));
			this.datatext.set_text(js_Cookie.get("1"));
			haxe_Log.trace(this.scoreall,{ fileName : "Main.hx", lineNumber : 430, className : "Main", methodName : "loop"});
			this.scoreall.push(this.score);
			haxe_Log.trace(js_Cookie.all(),{ fileName : "Main.hx", lineNumber : 432, className : "Main", methodName : "loop"});
			this.scoreall.sort(function(a,b) {
				return b - a;
			});
			haxe_Log.trace(this.score,{ fileName : "Main.hx", lineNumber : 436, className : "Main", methodName : "loop"});
			haxe_Log.trace(js_Cookie.all(),{ fileName : "Main.hx", lineNumber : 437, className : "Main", methodName : "loop"});
			js_Cookie.set("1",Std.string(this.scoreall[0]));
			js_Cookie.set("2",Std.string(this.scoreall[1]));
			js_Cookie.set("3",Std.string(this.scoreall[2]));
			js_Cookie.set("4",Std.string(this.scoreall[3]));
			haxe_Log.trace(js_Cookie.all(),{ fileName : "Main.hx", lineNumber : 442, className : "Main", methodName : "loop"});
			haxe_Log.trace(this.scoreall,{ fileName : "Main.hx", lineNumber : 443, className : "Main", methodName : "loop"});
			this.datatext.set_text(js_Cookie.get("1"));
			this.datatext2.set_text(js_Cookie.get("2"));
			this.datatext3.set_text(js_Cookie.get("3"));
			this.datatext4.set_text(js_Cookie.get("4"));
			this.datatext.set_width(500);
			this.datatext.set_x(100);
			this.datatext.set_y(50);
			this.addChild(this.datatext);
			this.datatext2.set_width(500);
			this.datatext2.set_x(200);
			this.datatext2.set_y(50);
			this.addChild(this.datatext2);
			this.datatext3.set_width(500);
			this.datatext3.set_x(300);
			this.datatext3.set_y(50);
			this.addChild(this.datatext3);
			this.datatext4.set_width(500);
			this.datatext4.set_x(400);
			this.datatext4.set_y(50);
			this.addChild(this.datatext4);
			haxe_Log.trace(Std.string(this.scoreall),{ fileName : "Main.hx", lineNumber : 484, className : "Main", methodName : "loop"});
			e.stopImmediatePropagation();
			var value = "hoge";
			var domain = "renge-lotus.net";
			var path = "/";
			var expiresDelay = 1000;
		}
	}
	,__class__: Main
});
var DocumentClass = function(current) {
	current.addChild(this);
	Main.call(this);
	this.dispatchEvent(new openfl_events_Event("addedToStage",false,false));
};
$hxClasses["DocumentClass"] = DocumentClass;
DocumentClass.__name__ = ["DocumentClass"];
DocumentClass.__super__ = Main;
DocumentClass.prototype = $extend(Main.prototype,{
	__class__: DocumentClass
});
var EReg = function(r,opt) {
	this.r = new RegExp(r,opt.split("u").join(""));
};
$hxClasses["EReg"] = EReg;
EReg.__name__ = ["EReg"];
EReg.prototype = {
	match: function(s) {
		if(this.r.global) {
			this.r.lastIndex = 0;
		}
		this.r.m = this.r.exec(s);
		this.r.s = s;
		return this.r.m != null;
	}
	,matched: function(n) {
		if(this.r.m != null && n >= 0 && n < this.r.m.length) {
			return this.r.m[n];
		} else {
			throw new js__$Boot_HaxeError("EReg::matched");
		}
	}
	,matchedRight: function() {
		if(this.r.m == null) {
			throw new js__$Boot_HaxeError("No string matched");
		}
		var sz = this.r.m.index + this.r.m[0].length;
		return HxOverrides.substr(this.r.s,sz,this.r.s.length - sz);
	}
	,matchedPos: function() {
		if(this.r.m == null) {
			throw new js__$Boot_HaxeError("No string matched");
		}
		return { pos : this.r.m.index, len : this.r.m[0].length};
	}
	,matchSub: function(s,pos,len) {
		if(len == null) {
			len = -1;
		}
		if(this.r.global) {
			this.r.lastIndex = pos;
			var tmp = this.r;
			var tmp1 = len < 0 ? s : HxOverrides.substr(s,0,pos + len);
			this.r.m = tmp.exec(tmp1);
			var b = this.r.m != null;
			if(b) {
				this.r.s = s;
			}
			return b;
		} else {
			var b1 = this.match(len < 0 ? HxOverrides.substr(s,pos,null) : HxOverrides.substr(s,pos,len));
			if(b1) {
				this.r.s = s;
				this.r.m.index += pos;
			}
			return b1;
		}
	}
	,split: function(s) {
		var d = "#__delim__#";
		return s.replace(this.r,d).split(d);
	}
	,map: function(s,f) {
		var offset = 0;
		var buf_b = "";
		while(true) {
			if(offset >= s.length) {
				break;
			} else if(!this.matchSub(s,offset)) {
				buf_b += Std.string(HxOverrides.substr(s,offset,null));
				break;
			}
			var p = this.matchedPos();
			buf_b += Std.string(HxOverrides.substr(s,offset,p.pos - offset));
			buf_b += Std.string(f(this));
			if(p.len == 0) {
				buf_b += Std.string(HxOverrides.substr(s,p.pos,1));
				offset = p.pos + 1;
			} else {
				offset = p.pos + p.len;
			}
			if(!this.r.global) {
				break;
			}
		}
		if(!this.r.global && offset > 0 && offset < s.length) {
			buf_b += Std.string(HxOverrides.substr(s,offset,null));
		}
		return buf_b;
	}
	,__class__: EReg
};
var HxOverrides = function() { };
$hxClasses["HxOverrides"] = HxOverrides;
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.strDate = function(s) {
	var _g = s.length;
	switch(_g) {
	case 8:
		var k = s.split(":");
		var d = new Date();
		d["setTime"](0);
		d["setUTCHours"](k[0]);
		d["setUTCMinutes"](k[1]);
		d["setUTCSeconds"](k[2]);
		return d;
	case 10:
		var k1 = s.split("-");
		return new Date(k1[0],k1[1] - 1,k1[2],0,0,0);
	case 19:
		var k2 = s.split(" ");
		var y = k2[0].split("-");
		var t = k2[1].split(":");
		return new Date(y[0],y[1] - 1,y[2],t[0],t[1],t[2]);
	default:
		throw new js__$Boot_HaxeError("Invalid date format : " + s);
	}
};
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
};
var Lambda = function() { };
$hxClasses["Lambda"] = Lambda;
Lambda.__name__ = ["Lambda"];
Lambda.array = function(it) {
	var a = [];
	var i = $iterator(it)();
	while(i.hasNext()) {
		var i1 = i.next();
		a.push(i1);
	}
	return a;
};
Lambda.map = function(it,f) {
	var l = new List();
	var x = $iterator(it)();
	while(x.hasNext()) {
		var x1 = x.next();
		l.add(f(x1));
	}
	return l;
};
var _$List_ListNode = function(item,next) {
	this.item = item;
	this.next = next;
};
$hxClasses["_List.ListNode"] = _$List_ListNode;
_$List_ListNode.__name__ = ["_List","ListNode"];
_$List_ListNode.prototype = {
	__class__: _$List_ListNode
};
var _$List_ListIterator = function(head) {
	this.head = head;
};
$hxClasses["_List.ListIterator"] = _$List_ListIterator;
_$List_ListIterator.__name__ = ["_List","ListIterator"];
_$List_ListIterator.prototype = {
	hasNext: function() {
		return this.head != null;
	}
	,next: function() {
		var val = this.head.item;
		this.head = this.head.next;
		return val;
	}
	,__class__: _$List_ListIterator
};
var ManifestResources = function() { };
$hxClasses["ManifestResources"] = ManifestResources;
ManifestResources.__name__ = ["ManifestResources"];
ManifestResources.init = function(config) {
	ManifestResources.preloadLibraries = [];
	ManifestResources.preloadLibraryNames = [];
	ManifestResources.rootPath = null;
	if(config != null && Object.prototype.hasOwnProperty.call(config,"rootPath")) {
		ManifestResources.rootPath = Reflect.field(config,"rootPath");
	}
	if(ManifestResources.rootPath == null) {
		ManifestResources.rootPath = "./";
	}
	var data;
	var manifest;
	var library;
	var bundle;
	data = "{\"name\":null,\"assets\":\"aoy4:sizei37813y4:typey5:SOUNDy2:idy18:assets%2Fheart.oggy9:pathGroupaR4hy7:preloadtgoy4:pathy18:assets%2Fjizou.pngR0i1588R1y5:IMAGER3R8R6tgoR0i26933R1R2R3y15:assets%2Fob.oggR5aR10hR6tgoR0i15880R1R2R3y19:assets%2Fdamage.wavR5aR11hR6tgoR0i18287R1R2R3y16:assets%2Fisi.oggR5aR12hR6tgoR7y15:assets%2Fob.pngR0i931R1R9R3R13R6tgoR7y16:assets%2Fisi.pngR0i827R1R9R3R14R6tgoR7y18:assets%2Fheart.pngR0i1156R1R9R3R15R6tgoR7y23:assets%2Fheart.png.backR0i570R1y6:BINARYR3R16R6tgoR7y19:assets%2Fheart2.pngR0i472R1R9R3R18R6tgoR7y15:assets%2FBG.jpgR0i8727R1R9R3R19R6tgh\",\"rootPath\":null,\"version\":2,\"libraryArgs\":[],\"libraryType\":null}";
	manifest = lime_utils_AssetManifest.parse(data,ManifestResources.rootPath);
	library = lime_utils_AssetLibrary.fromManifest(manifest);
	lime_utils_Assets.registerLibrary("default",library);
	library = lime_utils_Assets.getLibrary("default");
	if(library != null) {
		ManifestResources.preloadLibraries.push(library);
	} else {
		ManifestResources.preloadLibraryNames.push("default");
	}
};
Math.__name__ = ["Math"];
var Reflect = function() { };
$hxClasses["Reflect"] = Reflect;
Reflect.__name__ = ["Reflect"];
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( e ) {
		haxe_CallStack.lastException = e;
		return null;
	}
};
Reflect.getProperty = function(o,field) {
	var tmp;
	if(o == null) {
		return null;
	} else {
		var tmp1;
		if(o.__properties__) {
			tmp = o.__properties__["get_" + field];
			tmp1 = tmp;
		} else {
			tmp1 = false;
		}
		if(tmp1) {
			return o[tmp]();
		} else {
			return o[field];
		}
	}
};
Reflect.setProperty = function(o,field,value) {
	var tmp;
	var tmp1;
	if(o.__properties__) {
		tmp = o.__properties__["set_" + field];
		tmp1 = tmp;
	} else {
		tmp1 = false;
	}
	if(tmp1) {
		o[tmp](value);
	} else {
		o[field] = value;
	}
};
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(f != "__id__" && f != "hx__closures__" && hasOwnProperty.call(o,f)) {
			a.push(f);
		}
		}
	}
	return a;
};
Reflect.isFunction = function(f) {
	if(typeof(f) == "function") {
		return !(f.__name__ || f.__ename__);
	} else {
		return false;
	}
};
Reflect.compare = function(a,b) {
	if(a == b) {
		return 0;
	} else if(a > b) {
		return 1;
	} else {
		return -1;
	}
};
Reflect.compareMethods = function(f1,f2) {
	if(f1 == f2) {
		return true;
	}
	if(!Reflect.isFunction(f1) || !Reflect.isFunction(f2)) {
		return false;
	}
	if(f1.scope == f2.scope && f1.method == f2.method) {
		return f1.method != null;
	} else {
		return false;
	}
};
Reflect.isEnumValue = function(v) {
	if(v != null) {
		return v.__enum__ != null;
	} else {
		return false;
	}
};
Reflect.deleteField = function(o,field) {
	if(!Object.prototype.hasOwnProperty.call(o,field)) {
		return false;
	}
	delete(o[field]);
	return true;
};
Reflect.makeVarArgs = function(f) {
	return function() {
		var a = Array.prototype.slice.call(arguments);
		return f(a);
	};
};
var Std = function() { };
$hxClasses["Std"] = Std;
Std.__name__ = ["Std"];
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
Std.parseInt = function(x) {
	var v = parseInt(x,10);
	if(v == 0 && (HxOverrides.cca(x,1) == 120 || HxOverrides.cca(x,1) == 88)) {
		v = parseInt(x);
	}
	if(isNaN(v)) {
		return null;
	}
	return v;
};
var StringBuf = function() {
	this.b = "";
};
$hxClasses["StringBuf"] = StringBuf;
StringBuf.__name__ = ["StringBuf"];
StringBuf.prototype = {
	__class__: StringBuf
};
var StringTools = function() { };
$hxClasses["StringTools"] = StringTools;
StringTools.__name__ = ["StringTools"];
StringTools.htmlEscape = function(s,quotes) {
	s = s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
	if(quotes) {
		return s.split("\"").join("&quot;").split("'").join("&#039;");
	} else {
		return s;
	}
};
StringTools.htmlUnescape = function(s) {
	return s.split("&gt;").join(">").split("&lt;").join("<").split("&quot;").join("\"").split("&#039;").join("'").split("&amp;").join("&");
};
StringTools.startsWith = function(s,start) {
	if(s.length >= start.length) {
		return HxOverrides.substr(s,0,start.length) == start;
	} else {
		return false;
	}
};
StringTools.endsWith = function(s,end) {
	var elen = end.length;
	var slen = s.length;
	if(slen >= elen) {
		return HxOverrides.substr(s,slen - elen,elen) == end;
	} else {
		return false;
	}
};
StringTools.isSpace = function(s,pos) {
	var c = HxOverrides.cca(s,pos);
	if(!(c > 8 && c < 14)) {
		return c == 32;
	} else {
		return true;
	}
};
StringTools.ltrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,r)) ++r;
	if(r > 0) {
		return HxOverrides.substr(s,r,l - r);
	} else {
		return s;
	}
};
StringTools.rtrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,l - r - 1)) ++r;
	if(r > 0) {
		return HxOverrides.substr(s,0,l - r);
	} else {
		return s;
	}
};
StringTools.trim = function(s) {
	return StringTools.ltrim(StringTools.rtrim(s));
};
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
StringTools.hex = function(n,digits) {
	var s = "";
	var hexChars = "0123456789ABCDEF";
	while(true) {
		s = hexChars.charAt(n & 15) + s;
		n >>>= 4;
		if(!(n > 0)) {
			break;
		}
	}
	if(digits != null) {
		while(s.length < digits) s = "0" + s;
	}
	return s;
};
var ValueType = $hxClasses["ValueType"] = { __ename__ : ["ValueType"], __constructs__ : ["TNull","TInt","TFloat","TBool","TObject","TFunction","TClass","TEnum","TUnknown"] };
ValueType.TNull = ["TNull",0];
ValueType.TNull.toString = $estr;
ValueType.TNull.__enum__ = ValueType;
ValueType.TInt = ["TInt",1];
ValueType.TInt.toString = $estr;
ValueType.TInt.__enum__ = ValueType;
ValueType.TFloat = ["TFloat",2];
ValueType.TFloat.toString = $estr;
ValueType.TFloat.__enum__ = ValueType;
ValueType.TBool = ["TBool",3];
ValueType.TBool.toString = $estr;
ValueType.TBool.__enum__ = ValueType;
ValueType.TObject = ["TObject",4];
ValueType.TObject.toString = $estr;
ValueType.TObject.__enum__ = ValueType;
ValueType.TFunction = ["TFunction",5];
ValueType.TFunction.toString = $estr;
ValueType.TFunction.__enum__ = ValueType;
ValueType.TClass = function(c) { var $x = ["TClass",6,c]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; };
ValueType.TEnum = function(e) { var $x = ["TEnum",7,e]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; };
ValueType.TUnknown = ["TUnknown",8];
ValueType.TUnknown.toString = $estr;
ValueType.TUnknown.__enum__ = ValueType;
var Type = function() { };
$hxClasses["Type"] = Type;
Type.__name__ = ["Type"];
Type.getSuperClass = function(c) {
	return c.__super__;
};
Type.getClassName = function(c) {
	var a = c.__name__;
	if(a == null) {
		return null;
	}
	return a.join(".");
};
Type.getEnumName = function(e) {
	var a = e.__ename__;
	return a.join(".");
};
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) {
		return null;
	}
	return cl;
};
Type.resolveEnum = function(name) {
	var e = $hxClasses[name];
	if(e == null || !e.__ename__) {
		return null;
	}
	return e;
};
Type.createInstance = function(cl,args) {
	var _g = args.length;
	switch(_g) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	case 9:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8]);
	case 10:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9]);
	case 11:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10]);
	case 12:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11]);
	case 13:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12]);
	case 14:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12],args[13]);
	default:
		throw new js__$Boot_HaxeError("Too many arguments");
	}
};
Type.createEmptyInstance = function(cl) {
	function empty() {}; empty.prototype = cl.prototype;
	return new empty();
};
Type.createEnum = function(e,constr,params) {
	var f = Reflect.field(e,constr);
	if(f == null) {
		throw new js__$Boot_HaxeError("No such constructor " + constr);
	}
	if(Reflect.isFunction(f)) {
		if(params == null) {
			throw new js__$Boot_HaxeError("Constructor " + constr + " need parameters");
		}
		return f.apply(e,params);
	}
	if(params != null && params.length != 0) {
		throw new js__$Boot_HaxeError("Constructor " + constr + " does not need parameters");
	}
	return f;
};
Type["typeof"] = function(v) {
	var _g = typeof(v);
	switch(_g) {
	case "boolean":
		return ValueType.TBool;
	case "function":
		if(v.__name__ || v.__ename__) {
			return ValueType.TObject;
		}
		return ValueType.TFunction;
	case "number":
		if(Math.ceil(v) == v % 2147483648.0) {
			return ValueType.TInt;
		}
		return ValueType.TFloat;
	case "object":
		if(v == null) {
			return ValueType.TNull;
		}
		var e = v.__enum__;
		if(e != null) {
			return ValueType.TEnum(e);
		}
		var c = js_Boot.getClass(v);
		if(c != null) {
			return ValueType.TClass(c);
		}
		return ValueType.TObject;
	case "string":
		return ValueType.TClass(String);
	case "undefined":
		return ValueType.TNull;
	default:
		return ValueType.TUnknown;
	}
};
var _$UInt_UInt_$Impl_$ = {};
$hxClasses["_UInt.UInt_Impl_"] = _$UInt_UInt_$Impl_$;
_$UInt_UInt_$Impl_$.__name__ = ["_UInt","UInt_Impl_"];
_$UInt_UInt_$Impl_$.gt = function(a,b) {
	var aNeg = a < 0;
	var bNeg = b < 0;
	if(aNeg != bNeg) {
		return aNeg;
	} else {
		return a > b;
	}
};
_$UInt_UInt_$Impl_$.toFloat = function(this1) {
	var $int = this1;
	if($int < 0) {
		return 4294967296.0 + $int;
	} else {
		return $int + 0.0;
	}
};
var haxe_StackItem = $hxClasses["haxe.StackItem"] = { __ename__ : ["haxe","StackItem"], __constructs__ : ["CFunction","Module","FilePos","Method","LocalFunction"] };
haxe_StackItem.CFunction = ["CFunction",0];
haxe_StackItem.CFunction.toString = $estr;
haxe_StackItem.CFunction.__enum__ = haxe_StackItem;
haxe_StackItem.Module = function(m) { var $x = ["Module",1,m]; $x.__enum__ = haxe_StackItem; $x.toString = $estr; return $x; };
haxe_StackItem.FilePos = function(s,file,line) { var $x = ["FilePos",2,s,file,line]; $x.__enum__ = haxe_StackItem; $x.toString = $estr; return $x; };
haxe_StackItem.Method = function(classname,method) { var $x = ["Method",3,classname,method]; $x.__enum__ = haxe_StackItem; $x.toString = $estr; return $x; };
haxe_StackItem.LocalFunction = function(v) { var $x = ["LocalFunction",4,v]; $x.__enum__ = haxe_StackItem; $x.toString = $estr; return $x; };
var haxe_CallStack = function() { };
$hxClasses["haxe.CallStack"] = haxe_CallStack;
haxe_CallStack.__name__ = ["haxe","CallStack"];
haxe_CallStack.getStack = function(e) {
	if(e == null) {
		return [];
	}
	var oldValue = Error.prepareStackTrace;
	Error.prepareStackTrace = function(error,callsites) {
		var stack = [];
		var _g = 0;
		while(_g < callsites.length) {
			var site = callsites[_g];
			++_g;
			if(haxe_CallStack.wrapCallSite != null) {
				site = haxe_CallStack.wrapCallSite(site);
			}
			var method = null;
			var fullName = site.getFunctionName();
			if(fullName != null) {
				var idx = fullName.lastIndexOf(".");
				if(idx >= 0) {
					var className = HxOverrides.substr(fullName,0,idx);
					var methodName = HxOverrides.substr(fullName,idx + 1,null);
					method = haxe_StackItem.Method(className,methodName);
				}
			}
			stack.push(haxe_StackItem.FilePos(method,site.getFileName(),site.getLineNumber()));
		}
		return stack;
	};
	var a = haxe_CallStack.makeStack(e.stack);
	Error.prepareStackTrace = oldValue;
	return a;
};
haxe_CallStack.callStack = function() {
	try {
		throw new Error();
	} catch( e ) {
		haxe_CallStack.lastException = e;
		if (e instanceof js__$Boot_HaxeError) e = e.val;
		var a = haxe_CallStack.getStack(e);
		a.shift();
		return a;
	}
};
haxe_CallStack.exceptionStack = function() {
	return haxe_CallStack.getStack(haxe_CallStack.lastException);
};
haxe_CallStack.toString = function(stack) {
	var b = new StringBuf();
	var _g = 0;
	while(_g < stack.length) {
		var s = stack[_g];
		++_g;
		b.b += "\nCalled from ";
		haxe_CallStack.itemToString(b,s);
	}
	return b.b;
};
haxe_CallStack.itemToString = function(b,s) {
	switch(s[1]) {
	case 0:
		b.b += "a C function";
		break;
	case 1:
		var m = s[2];
		b.b += "module ";
		b.b += m == null ? "null" : "" + m;
		break;
	case 2:
		var line = s[4];
		var file = s[3];
		var s1 = s[2];
		if(s1 != null) {
			haxe_CallStack.itemToString(b,s1);
			b.b += " (";
		}
		b.b += file == null ? "null" : "" + file;
		b.b += " line ";
		b.b += line == null ? "null" : "" + line;
		if(s1 != null) {
			b.b += ")";
		}
		break;
	case 3:
		var meth = s[3];
		var cname = s[2];
		b.b += cname == null ? "null" : "" + cname;
		b.b += ".";
		b.b += meth == null ? "null" : "" + meth;
		break;
	case 4:
		var n = s[2];
		b.b += "local function #";
		b.b += n == null ? "null" : "" + n;
		break;
	}
};
haxe_CallStack.makeStack = function(s) {
	if(s == null) {
		return [];
	} else if(typeof(s) == "string") {
		var stack = s.split("\n");
		if(stack[0] == "Error") {
			stack.shift();
		}
		var m = [];
		var rie10 = new EReg("^   at ([A-Za-z0-9_. ]+) \\(([^)]+):([0-9]+):([0-9]+)\\)$","");
		var _g = 0;
		while(_g < stack.length) {
			var line = stack[_g];
			++_g;
			if(rie10.match(line)) {
				var path = rie10.matched(1).split(".");
				var meth = path.pop();
				var file = rie10.matched(2);
				var line1 = Std.parseInt(rie10.matched(3));
				m.push(haxe_StackItem.FilePos(meth == "Anonymous function" ? haxe_StackItem.LocalFunction() : meth == "Global code" ? null : haxe_StackItem.Method(path.join("."),meth),file,line1));
			} else {
				m.push(haxe_StackItem.Module(StringTools.trim(line)));
			}
		}
		return m;
	} else {
		return s;
	}
};
var haxe__$Int64__$_$_$Int64 = function(high,low) {
	this.high = high;
	this.low = low;
};
$hxClasses["haxe._Int64.___Int64"] = haxe__$Int64__$_$_$Int64;
haxe__$Int64__$_$_$Int64.__name__ = ["haxe","_Int64","___Int64"];
haxe__$Int64__$_$_$Int64.prototype = {
	__class__: haxe__$Int64__$_$_$Int64
};
var haxe_Log = function() { };
$hxClasses["haxe.Log"] = haxe_Log;
haxe_Log.__name__ = ["haxe","Log"];
haxe_Log.trace = function(v,infos) {
	js_Boot.__trace(v,infos);
};
var haxe_Serializer = function() {
	this.buf = new StringBuf();
	this.cache = [];
	this.useCache = haxe_Serializer.USE_CACHE;
	this.useEnumIndex = haxe_Serializer.USE_ENUM_INDEX;
	this.shash = new haxe_ds_StringMap();
	this.scount = 0;
};
$hxClasses["haxe.Serializer"] = haxe_Serializer;
haxe_Serializer.__name__ = ["haxe","Serializer"];
haxe_Serializer.run = function(v) {
	var s = new haxe_Serializer();
	s.serialize(v);
	return s.toString();
};
haxe_Serializer.prototype = {
	toString: function() {
		return this.buf.b;
	}
	,serializeString: function(s) {
		var _this = this.shash;
		var x = __map_reserved[s] != null ? _this.getReserved(s) : _this.h[s];
		if(x != null) {
			this.buf.b += "R";
			this.buf.b += x == null ? "null" : "" + x;
			return;
		}
		var _this1 = this.shash;
		var value = this.scount++;
		if(__map_reserved[s] != null) {
			_this1.setReserved(s,value);
		} else {
			_this1.h[s] = value;
		}
		this.buf.b += "y";
		s = encodeURIComponent(s);
		this.buf.b += Std.string(s.length);
		this.buf.b += ":";
		this.buf.b += s == null ? "null" : "" + s;
	}
	,serializeRef: function(v) {
		var vt = typeof(v);
		var _g1 = 0;
		var _g = this.cache.length;
		while(_g1 < _g) {
			var i = _g1++;
			var ci = this.cache[i];
			if(typeof(ci) == vt && ci == v) {
				this.buf.b += "r";
				this.buf.b += i == null ? "null" : "" + i;
				return true;
			}
		}
		this.cache.push(v);
		return false;
	}
	,serializeFields: function(v) {
		var _g = 0;
		var _g1 = Reflect.fields(v);
		while(_g < _g1.length) {
			var f = _g1[_g];
			++_g;
			this.serializeString(f);
			this.serialize(Reflect.field(v,f));
		}
		this.buf.b += "g";
	}
	,serialize: function(v) {
		var _g = Type["typeof"](v);
		switch(_g[1]) {
		case 0:
			this.buf.b += "n";
			break;
		case 1:
			var v1 = v;
			if(v1 == 0) {
				this.buf.b += "z";
				return;
			}
			this.buf.b += "i";
			this.buf.b += v1 == null ? "null" : "" + v1;
			break;
		case 2:
			var v2 = v;
			if(isNaN(v2)) {
				this.buf.b += "k";
			} else if(!isFinite(v2)) {
				this.buf.b += v2 < 0 ? "m" : "p";
			} else {
				this.buf.b += "d";
				this.buf.b += v2 == null ? "null" : "" + v2;
			}
			break;
		case 3:
			this.buf.b += v ? "t" : "f";
			break;
		case 4:
			if(js_Boot.__instanceof(v,Class)) {
				var className = Type.getClassName(v);
				this.buf.b += "A";
				this.serializeString(className);
			} else if(js_Boot.__instanceof(v,Enum)) {
				this.buf.b += "B";
				this.serializeString(Type.getEnumName(v));
			} else {
				if(this.useCache && this.serializeRef(v)) {
					return;
				}
				this.buf.b += "o";
				this.serializeFields(v);
			}
			break;
		case 5:
			throw new js__$Boot_HaxeError("Cannot serialize function");
			break;
		case 6:
			var c = _g[2];
			if(c == String) {
				this.serializeString(v);
				return;
			}
			if(this.useCache && this.serializeRef(v)) {
				return;
			}
			switch(c) {
			case Array:
				var ucount = 0;
				this.buf.b += "a";
				var l = v["length"];
				var _g1 = 0;
				var _g2 = l;
				while(_g1 < _g2) {
					var i = _g1++;
					if(v[i] == null) {
						++ucount;
					} else {
						if(ucount > 0) {
							if(ucount == 1) {
								this.buf.b += "n";
							} else {
								this.buf.b += "u";
								this.buf.b += ucount == null ? "null" : "" + ucount;
							}
							ucount = 0;
						}
						this.serialize(v[i]);
					}
				}
				if(ucount > 0) {
					if(ucount == 1) {
						this.buf.b += "n";
					} else {
						this.buf.b += "u";
						this.buf.b += ucount == null ? "null" : "" + ucount;
					}
				}
				this.buf.b += "h";
				break;
			case Date:
				var d = v;
				this.buf.b += "v";
				this.buf.b += Std.string(d.getTime());
				break;
			case List:
				this.buf.b += "l";
				var v3 = v;
				var _g_head = v3.h;
				while(_g_head != null) {
					var val = _g_head.item;
					_g_head = _g_head.next;
					var i1 = val;
					this.serialize(i1);
				}
				this.buf.b += "h";
				break;
			case haxe_ds_IntMap:
				this.buf.b += "q";
				var v4 = v;
				var k = v4.keys();
				while(k.hasNext()) {
					var k1 = k.next();
					this.buf.b += ":";
					this.buf.b += k1 == null ? "null" : "" + k1;
					this.serialize(v4.h[k1]);
				}
				this.buf.b += "h";
				break;
			case haxe_ds_ObjectMap:
				this.buf.b += "M";
				var v5 = v;
				var k2 = v5.keys();
				while(k2.hasNext()) {
					var k3 = k2.next();
					var id = Reflect.field(k3,"__id__");
					Reflect.deleteField(k3,"__id__");
					this.serialize(k3);
					k3["__id__"] = id;
					this.serialize(v5.h[k3.__id__]);
				}
				this.buf.b += "h";
				break;
			case haxe_ds_StringMap:
				this.buf.b += "b";
				var v6 = v;
				var k4 = v6.keys();
				while(k4.hasNext()) {
					var k5 = k4.next();
					this.serializeString(k5);
					this.serialize(__map_reserved[k5] != null ? v6.getReserved(k5) : v6.h[k5]);
				}
				this.buf.b += "h";
				break;
			case haxe_io_Bytes:
				var v7 = v;
				this.buf.b += "s";
				this.buf.b += Std.string(Math.ceil(v7.length * 8 / 6));
				this.buf.b += ":";
				var i2 = 0;
				var max = v7.length - 2;
				var b64 = haxe_Serializer.BASE64_CODES;
				if(b64 == null) {
					var length = haxe_Serializer.BASE64.length;
					var this1 = new Array(length);
					b64 = this1;
					var _g11 = 0;
					var _g3 = haxe_Serializer.BASE64.length;
					while(_g11 < _g3) {
						var i3 = _g11++;
						b64[i3] = HxOverrides.cca(haxe_Serializer.BASE64,i3);
					}
					haxe_Serializer.BASE64_CODES = b64;
				}
				while(i2 < max) {
					var b1 = v7.b[i2++];
					var b2 = v7.b[i2++];
					var b3 = v7.b[i2++];
					this.buf.b += String.fromCharCode(b64[b1 >> 2]);
					this.buf.b += String.fromCharCode(b64[(b1 << 4 | b2 >> 4) & 63]);
					this.buf.b += String.fromCharCode(b64[(b2 << 2 | b3 >> 6) & 63]);
					this.buf.b += String.fromCharCode(b64[b3 & 63]);
				}
				if(i2 == max) {
					var b11 = v7.b[i2++];
					var b21 = v7.b[i2++];
					this.buf.b += String.fromCharCode(b64[b11 >> 2]);
					this.buf.b += String.fromCharCode(b64[(b11 << 4 | b21 >> 4) & 63]);
					this.buf.b += String.fromCharCode(b64[b21 << 2 & 63]);
				} else if(i2 == max + 1) {
					var b12 = v7.b[i2++];
					this.buf.b += String.fromCharCode(b64[b12 >> 2]);
					this.buf.b += String.fromCharCode(b64[b12 << 4 & 63]);
				}
				break;
			default:
				if(this.useCache) {
					this.cache.pop();
				}
				if(v.hxSerialize != null) {
					this.buf.b += "C";
					this.serializeString(Type.getClassName(c));
					if(this.useCache) {
						this.cache.push(v);
					}
					v.hxSerialize(this);
					this.buf.b += "g";
				} else {
					this.buf.b += "c";
					this.serializeString(Type.getClassName(c));
					if(this.useCache) {
						this.cache.push(v);
					}
					this.serializeFields(v);
				}
			}
			break;
		case 7:
			var e = _g[2];
			if(this.useCache) {
				if(this.serializeRef(v)) {
					return;
				}
				this.cache.pop();
			}
			this.buf.b += Std.string(this.useEnumIndex ? "j" : "w");
			this.serializeString(Type.getEnumName(e));
			if(this.useEnumIndex) {
				this.buf.b += ":";
				this.buf.b += Std.string(v[1]);
			} else {
				this.serializeString(v[0]);
			}
			this.buf.b += ":";
			var l1 = v["length"];
			this.buf.b += Std.string(l1 - 2);
			var _g12 = 2;
			var _g4 = l1;
			while(_g12 < _g4) {
				var i4 = _g12++;
				this.serialize(v[i4]);
			}
			if(this.useCache) {
				this.cache.push(v);
			}
			break;
		default:
			throw new js__$Boot_HaxeError("Cannot serialize " + Std.string(v));
		}
	}
	,__class__: haxe_Serializer
};
var haxe_Timer = function(time_ms) {
	var me = this;
	this.id = setInterval(function() {
		me.run();
	},time_ms);
};
$hxClasses["haxe.Timer"] = haxe_Timer;
haxe_Timer.__name__ = ["haxe","Timer"];
haxe_Timer.delay = function(f,time_ms) {
	var t = new haxe_Timer(time_ms);
	t.run = function() {
		t.stop();
		f();
	};
	return t;
};
haxe_Timer.measure = function(f,pos) {
	var t0 = new Date().getTime() / 1000;
	var r = f();
	haxe_Log.trace(new Date().getTime() / 1000 - t0 + "s",pos);
	return r;
};
haxe_Timer.stamp = function() {
	return new Date().getTime() / 1000;
};
haxe_Timer.prototype = {
	stop: function() {
		if(this.id == null) {
			return;
		}
		clearInterval(this.id);
		this.id = null;
	}
	,run: function() {
	}
	,__class__: haxe_Timer
};
var haxe__$Unserializer_DefaultResolver = function() {
};
$hxClasses["haxe._Unserializer.DefaultResolver"] = haxe__$Unserializer_DefaultResolver;
haxe__$Unserializer_DefaultResolver.__name__ = ["haxe","_Unserializer","DefaultResolver"];
haxe__$Unserializer_DefaultResolver.prototype = {
	resolveClass: function(name) {
		return Type.resolveClass(name);
	}
	,resolveEnum: function(name) {
		return Type.resolveEnum(name);
	}
	,__class__: haxe__$Unserializer_DefaultResolver
};
var haxe_Unserializer = function(buf) {
	this.buf = buf;
	this.length = buf.length;
	this.pos = 0;
	this.scache = [];
	this.cache = [];
	var r = haxe_Unserializer.DEFAULT_RESOLVER;
	if(r == null) {
		r = new haxe__$Unserializer_DefaultResolver();
		haxe_Unserializer.DEFAULT_RESOLVER = r;
	}
	this.resolver = r;
};
$hxClasses["haxe.Unserializer"] = haxe_Unserializer;
haxe_Unserializer.__name__ = ["haxe","Unserializer"];
haxe_Unserializer.initCodes = function() {
	var codes = [];
	var _g1 = 0;
	var _g = haxe_Unserializer.BASE64.length;
	while(_g1 < _g) {
		var i = _g1++;
		codes[haxe_Unserializer.BASE64.charCodeAt(i)] = i;
	}
	return codes;
};
haxe_Unserializer.run = function(v) {
	return new haxe_Unserializer(v).unserialize();
};
haxe_Unserializer.prototype = {
	setResolver: function(r) {
		if(r == null) {
			if(haxe__$Unserializer_NullResolver.instance == null) {
				haxe__$Unserializer_NullResolver.instance = new haxe__$Unserializer_NullResolver();
			}
			this.resolver = haxe__$Unserializer_NullResolver.instance;
		} else {
			this.resolver = r;
		}
	}
	,readDigits: function() {
		var k = 0;
		var s = false;
		var fpos = this.pos;
		while(true) {
			var c = this.buf.charCodeAt(this.pos);
			if(c != c) {
				break;
			}
			if(c == 45) {
				if(this.pos != fpos) {
					break;
				}
				s = true;
				this.pos++;
				continue;
			}
			if(c < 48 || c > 57) {
				break;
			}
			k = k * 10 + (c - 48);
			this.pos++;
		}
		if(s) {
			k *= -1;
		}
		return k;
	}
	,readFloat: function() {
		var p1 = this.pos;
		while(true) {
			var c = this.buf.charCodeAt(this.pos);
			if(c != c) {
				break;
			}
			if(c >= 43 && c < 58 || c == 101 || c == 69) {
				this.pos++;
			} else {
				break;
			}
		}
		return parseFloat(HxOverrides.substr(this.buf,p1,this.pos - p1));
	}
	,unserializeObject: function(o) {
		while(true) {
			if(this.pos >= this.length) {
				throw new js__$Boot_HaxeError("Invalid object");
			}
			if(this.buf.charCodeAt(this.pos) == 103) {
				break;
			}
			var k = this.unserialize();
			if(typeof(k) != "string") {
				throw new js__$Boot_HaxeError("Invalid object key");
			}
			var v = this.unserialize();
			o[k] = v;
		}
		this.pos++;
	}
	,unserializeEnum: function(edecl,tag) {
		if(this.buf.charCodeAt(this.pos++) != 58) {
			throw new js__$Boot_HaxeError("Invalid enum format");
		}
		var nargs = this.readDigits();
		if(nargs == 0) {
			return Type.createEnum(edecl,tag);
		}
		var args = [];
		while(nargs-- > 0) args.push(this.unserialize());
		return Type.createEnum(edecl,tag,args);
	}
	,unserialize: function() {
		var _g = this.buf.charCodeAt(this.pos++);
		switch(_g) {
		case 65:
			var name = this.unserialize();
			var cl = this.resolver.resolveClass(name);
			if(cl == null) {
				throw new js__$Boot_HaxeError("Class not found " + name);
			}
			return cl;
		case 66:
			var name1 = this.unserialize();
			var e = this.resolver.resolveEnum(name1);
			if(e == null) {
				throw new js__$Boot_HaxeError("Enum not found " + name1);
			}
			return e;
		case 67:
			var name2 = this.unserialize();
			var cl1 = this.resolver.resolveClass(name2);
			if(cl1 == null) {
				throw new js__$Boot_HaxeError("Class not found " + name2);
			}
			var o = Type.createEmptyInstance(cl1);
			this.cache.push(o);
			o.hxUnserialize(this);
			if(this.buf.charCodeAt(this.pos++) != 103) {
				throw new js__$Boot_HaxeError("Invalid custom data");
			}
			return o;
		case 77:
			var h = new haxe_ds_ObjectMap();
			this.cache.push(h);
			var buf = this.buf;
			while(this.buf.charCodeAt(this.pos) != 104) {
				var s = this.unserialize();
				h.set(s,this.unserialize());
			}
			this.pos++;
			return h;
		case 82:
			var n = this.readDigits();
			if(n < 0 || n >= this.scache.length) {
				throw new js__$Boot_HaxeError("Invalid string reference");
			}
			return this.scache[n];
		case 97:
			var buf1 = this.buf;
			var a = [];
			this.cache.push(a);
			while(true) {
				var c = this.buf.charCodeAt(this.pos);
				if(c == 104) {
					this.pos++;
					break;
				}
				if(c == 117) {
					this.pos++;
					var n1 = this.readDigits();
					a[a.length + n1 - 1] = null;
				} else {
					a.push(this.unserialize());
				}
			}
			return a;
		case 98:
			var h1 = new haxe_ds_StringMap();
			this.cache.push(h1);
			var buf2 = this.buf;
			while(this.buf.charCodeAt(this.pos) != 104) {
				var s1 = this.unserialize();
				var value = this.unserialize();
				if(__map_reserved[s1] != null) {
					h1.setReserved(s1,value);
				} else {
					h1.h[s1] = value;
				}
			}
			this.pos++;
			return h1;
		case 99:
			var name3 = this.unserialize();
			var cl2 = this.resolver.resolveClass(name3);
			if(cl2 == null) {
				throw new js__$Boot_HaxeError("Class not found " + name3);
			}
			var o1 = Type.createEmptyInstance(cl2);
			this.cache.push(o1);
			this.unserializeObject(o1);
			return o1;
		case 100:
			return this.readFloat();
		case 102:
			return false;
		case 105:
			return this.readDigits();
		case 106:
			var name4 = this.unserialize();
			var edecl = this.resolver.resolveEnum(name4);
			if(edecl == null) {
				throw new js__$Boot_HaxeError("Enum not found " + name4);
			}
			this.pos++;
			var index = this.readDigits();
			var tag = edecl.__constructs__.slice()[index];
			if(tag == null) {
				throw new js__$Boot_HaxeError("Unknown enum index " + name4 + "@" + index);
			}
			var e1 = this.unserializeEnum(edecl,tag);
			this.cache.push(e1);
			return e1;
		case 107:
			return NaN;
		case 108:
			var l = new List();
			this.cache.push(l);
			var buf3 = this.buf;
			while(this.buf.charCodeAt(this.pos) != 104) l.add(this.unserialize());
			this.pos++;
			return l;
		case 109:
			return -Infinity;
		case 110:
			return null;
		case 111:
			var o2 = { };
			this.cache.push(o2);
			this.unserializeObject(o2);
			return o2;
		case 112:
			return Infinity;
		case 113:
			var h2 = new haxe_ds_IntMap();
			this.cache.push(h2);
			var buf4 = this.buf;
			var c1 = this.buf.charCodeAt(this.pos++);
			while(c1 == 58) {
				var i = this.readDigits();
				var value1 = this.unserialize();
				h2.h[i] = value1;
				c1 = this.buf.charCodeAt(this.pos++);
			}
			if(c1 != 104) {
				throw new js__$Boot_HaxeError("Invalid IntMap format");
			}
			return h2;
		case 114:
			var n2 = this.readDigits();
			if(n2 < 0 || n2 >= this.cache.length) {
				throw new js__$Boot_HaxeError("Invalid reference");
			}
			return this.cache[n2];
		case 115:
			var len = this.readDigits();
			var buf5 = this.buf;
			if(this.buf.charCodeAt(this.pos++) != 58 || this.length - this.pos < len) {
				throw new js__$Boot_HaxeError("Invalid bytes length");
			}
			var codes = haxe_Unserializer.CODES;
			if(codes == null) {
				codes = haxe_Unserializer.initCodes();
				haxe_Unserializer.CODES = codes;
			}
			var i1 = this.pos;
			var rest = len & 3;
			var size = (len >> 2) * 3 + (rest >= 2 ? rest - 1 : 0);
			var max = i1 + (len - rest);
			var bytes = new haxe_io_Bytes(new ArrayBuffer(size));
			var bpos = 0;
			while(i1 < max) {
				var c11 = codes[buf5.charCodeAt(i1++)];
				var c2 = codes[buf5.charCodeAt(i1++)];
				bytes.b[bpos++] = (c11 << 2 | c2 >> 4) & 255;
				var c3 = codes[buf5.charCodeAt(i1++)];
				bytes.b[bpos++] = (c2 << 4 | c3 >> 2) & 255;
				var c4 = codes[buf5.charCodeAt(i1++)];
				bytes.b[bpos++] = (c3 << 6 | c4) & 255;
			}
			if(rest >= 2) {
				var c12 = codes[buf5.charCodeAt(i1++)];
				var c21 = codes[buf5.charCodeAt(i1++)];
				bytes.b[bpos++] = (c12 << 2 | c21 >> 4) & 255;
				if(rest == 3) {
					var c31 = codes[buf5.charCodeAt(i1++)];
					bytes.b[bpos++] = (c21 << 4 | c31 >> 2) & 255;
				}
			}
			this.pos += len;
			this.cache.push(bytes);
			return bytes;
		case 116:
			return true;
		case 118:
			var d;
			if(this.buf.charCodeAt(this.pos) >= 48 && this.buf.charCodeAt(this.pos) <= 57 && this.buf.charCodeAt(this.pos + 1) >= 48 && this.buf.charCodeAt(this.pos + 1) <= 57 && this.buf.charCodeAt(this.pos + 2) >= 48 && this.buf.charCodeAt(this.pos + 2) <= 57 && this.buf.charCodeAt(this.pos + 3) >= 48 && this.buf.charCodeAt(this.pos + 3) <= 57 && this.buf.charCodeAt(this.pos + 4) == 45) {
				d = HxOverrides.strDate(HxOverrides.substr(this.buf,this.pos,19));
				this.pos += 19;
			} else {
				var t = this.readFloat();
				d = new Date(t);
			}
			this.cache.push(d);
			return d;
		case 119:
			var name5 = this.unserialize();
			var edecl1 = this.resolver.resolveEnum(name5);
			if(edecl1 == null) {
				throw new js__$Boot_HaxeError("Enum not found " + name5);
			}
			var e2 = this.unserializeEnum(edecl1,this.unserialize());
			this.cache.push(e2);
			return e2;
		case 120:
			throw js__$Boot_HaxeError.wrap(this.unserialize());
			break;
		case 121:
			var len1 = this.readDigits();
			if(this.buf.charCodeAt(this.pos++) != 58 || this.length - this.pos < len1) {
				throw new js__$Boot_HaxeError("Invalid string length");
			}
			var s2 = HxOverrides.substr(this.buf,this.pos,len1);
			this.pos += len1;
			s2 = decodeURIComponent(s2.split("+").join(" "));
			this.scache.push(s2);
			return s2;
		case 122:
			return 0;
		default:
		}
		this.pos--;
		throw new js__$Boot_HaxeError("Invalid char " + this.buf.charAt(this.pos) + " at position " + this.pos);
	}
	,__class__: haxe_Unserializer
};
var haxe__$Unserializer_NullResolver = function() {
};
$hxClasses["haxe._Unserializer.NullResolver"] = haxe__$Unserializer_NullResolver;
haxe__$Unserializer_NullResolver.__name__ = ["haxe","_Unserializer","NullResolver"];
haxe__$Unserializer_NullResolver.prototype = {
	resolveClass: function(name) {
		return null;
	}
	,resolveEnum: function(name) {
		return null;
	}
	,__class__: haxe__$Unserializer_NullResolver
};
var haxe_crypto_Adler32 = function() {
	this.a1 = 1;
	this.a2 = 0;
};
$hxClasses["haxe.crypto.Adler32"] = haxe_crypto_Adler32;
haxe_crypto_Adler32.__name__ = ["haxe","crypto","Adler32"];
haxe_crypto_Adler32.read = function(i) {
	var a = new haxe_crypto_Adler32();
	var a2a = i.readByte();
	var a2b = i.readByte();
	var a1a = i.readByte();
	var a1b = i.readByte();
	a.a1 = a1a << 8 | a1b;
	a.a2 = a2a << 8 | a2b;
	return a;
};
haxe_crypto_Adler32.prototype = {
	update: function(b,pos,len) {
		var a1 = this.a1;
		var a2 = this.a2;
		var _g1 = pos;
		var _g = pos + len;
		while(_g1 < _g) {
			var p = _g1++;
			var c = b.b[p];
			a1 = (a1 + c) % 65521;
			a2 = (a2 + a1) % 65521;
		}
		this.a1 = a1;
		this.a2 = a2;
	}
	,equals: function(a) {
		if(a.a1 == this.a1) {
			return a.a2 == this.a2;
		} else {
			return false;
		}
	}
	,__class__: haxe_crypto_Adler32
};
var haxe_io_Bytes = function(data) {
	this.length = data.byteLength;
	this.b = new Uint8Array(data);
	this.b.bufferValue = data;
	data.hxBytes = this;
	data.bytes = this.b;
};
$hxClasses["haxe.io.Bytes"] = haxe_io_Bytes;
haxe_io_Bytes.__name__ = ["haxe","io","Bytes"];
haxe_io_Bytes.alloc = function(length) {
	return new haxe_io_Bytes(new ArrayBuffer(length));
};
haxe_io_Bytes.ofString = function(s,encoding) {
	var a = [];
	var i = 0;
	while(i < s.length) {
		var c = s.charCodeAt(i++);
		if(55296 <= c && c <= 56319) {
			c = c - 55232 << 10 | s.charCodeAt(i++) & 1023;
		}
		if(c <= 127) {
			a.push(c);
		} else if(c <= 2047) {
			a.push(192 | c >> 6);
			a.push(128 | c & 63);
		} else if(c <= 65535) {
			a.push(224 | c >> 12);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		} else {
			a.push(240 | c >> 18);
			a.push(128 | c >> 12 & 63);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		}
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.ofData = function(b) {
	var hb = b.hxBytes;
	if(hb != null) {
		return hb;
	}
	return new haxe_io_Bytes(b);
};
haxe_io_Bytes.ofHex = function(s) {
	if((s.length & 1) != 0) {
		throw new js__$Boot_HaxeError("Not a hex string (odd number of digits)");
	}
	var a = [];
	var i = 0;
	var len = s.length >> 1;
	while(i < len) {
		var high = s.charCodeAt(i * 2);
		var low = s.charCodeAt(i * 2 + 1);
		high = (high & 15) + ((high & 64) >> 6) * 9;
		low = (low & 15) + ((low & 64) >> 6) * 9;
		a.push((high << 4 | low) & 255);
		++i;
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.fastGet = function(b,pos) {
	return b.bytes[pos];
};
haxe_io_Bytes.prototype = {
	get: function(pos) {
		return this.b[pos];
	}
	,set: function(pos,v) {
		this.b[pos] = v & 255;
	}
	,blit: function(pos,src,srcpos,len) {
		if(pos < 0 || srcpos < 0 || len < 0 || pos + len > this.length || srcpos + len > src.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		if(srcpos == 0 && len == src.b.byteLength) {
			this.b.set(src.b,pos);
		} else {
			this.b.set(src.b.subarray(srcpos,srcpos + len),pos);
		}
	}
	,fill: function(pos,len,value) {
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) {
			var i = _g1++;
			this.b[pos++] = value & 255;
		}
	}
	,sub: function(pos,len) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		return new haxe_io_Bytes(this.b.buffer.slice(pos + this.b.byteOffset,pos + this.b.byteOffset + len));
	}
	,compare: function(other) {
		var b1 = this.b;
		var b2 = other.b;
		var len = this.length < other.length ? this.length : other.length;
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) {
			var i = _g1++;
			if(b1[i] != b2[i]) {
				return b1[i] - b2[i];
			}
		}
		return this.length - other.length;
	}
	,initData: function() {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
	}
	,getDouble: function(pos) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		return this.data.getFloat64(pos,true);
	}
	,getFloat: function(pos) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		return this.data.getFloat32(pos,true);
	}
	,setDouble: function(pos,v) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		this.data.setFloat64(pos,v,true);
	}
	,setFloat: function(pos,v) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		this.data.setFloat32(pos,v,true);
	}
	,getUInt16: function(pos) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		return this.data.getUint16(pos,true);
	}
	,setUInt16: function(pos,v) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		this.data.setUint16(pos,v,true);
	}
	,getInt32: function(pos) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		return this.data.getInt32(pos,true);
	}
	,setInt32: function(pos,v) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		this.data.setInt32(pos,v,true);
	}
	,getInt64: function(pos) {
		var this1 = new haxe__$Int64__$_$_$Int64(this.getInt32(pos + 4),this.getInt32(pos));
		return this1;
	}
	,setInt64: function(pos,v) {
		this.setInt32(pos,v.low);
		this.setInt32(pos + 4,v.high);
	}
	,getString: function(pos,len,encoding) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		var s = "";
		var b = this.b;
		var fcc = String.fromCharCode;
		var i = pos;
		var max = pos + len;
		while(i < max) {
			var c = b[i++];
			if(c < 128) {
				if(c == 0) {
					break;
				}
				s += fcc(c);
			} else if(c < 224) {
				s += fcc((c & 63) << 6 | b[i++] & 127);
			} else if(c < 240) {
				var c2 = b[i++];
				s += fcc((c & 31) << 12 | (c2 & 127) << 6 | b[i++] & 127);
			} else {
				var c21 = b[i++];
				var c3 = b[i++];
				var u = (c & 15) << 18 | (c21 & 127) << 12 | (c3 & 127) << 6 | b[i++] & 127;
				s += fcc((u >> 10) + 55232);
				s += fcc(u & 1023 | 56320);
			}
		}
		return s;
	}
	,readString: function(pos,len) {
		return this.getString(pos,len);
	}
	,toString: function() {
		return this.getString(0,this.length);
	}
	,toHex: function() {
		var s_b = "";
		var chars = [];
		var str = "0123456789abcdef";
		var _g1 = 0;
		var _g = str.length;
		while(_g1 < _g) {
			var i = _g1++;
			chars.push(HxOverrides.cca(str,i));
		}
		var _g11 = 0;
		var _g2 = this.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			var c = this.b[i1];
			s_b += String.fromCharCode(chars[c >> 4]);
			s_b += String.fromCharCode(chars[c & 15]);
		}
		return s_b;
	}
	,getData: function() {
		return this.b.bufferValue;
	}
	,__class__: haxe_io_Bytes
};
var haxe_crypto_Base64 = function() { };
$hxClasses["haxe.crypto.Base64"] = haxe_crypto_Base64;
haxe_crypto_Base64.__name__ = ["haxe","crypto","Base64"];
haxe_crypto_Base64.decode = function(str,complement) {
	if(complement == null) {
		complement = true;
	}
	if(complement) {
		while(HxOverrides.cca(str,str.length - 1) == 61) str = HxOverrides.substr(str,0,-1);
	}
	return new haxe_crypto_BaseCode(haxe_crypto_Base64.BYTES).decodeBytes(haxe_io_Bytes.ofString(str));
};
var haxe_crypto_BaseCode = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) ++nbits;
	if(nbits > 8 || len != 1 << nbits) {
		throw new js__$Boot_HaxeError("BaseCode : base length must be a power of two.");
	}
	this.base = base;
	this.nbits = nbits;
};
$hxClasses["haxe.crypto.BaseCode"] = haxe_crypto_BaseCode;
haxe_crypto_BaseCode.__name__ = ["haxe","crypto","BaseCode"];
haxe_crypto_BaseCode.prototype = {
	initTable: function() {
		var tbl = [];
		var _g = 0;
		while(_g < 256) {
			var i = _g++;
			tbl[i] = -1;
		}
		var _g1 = 0;
		var _g2 = this.base.length;
		while(_g1 < _g2) {
			var i1 = _g1++;
			tbl[this.base.b[i1]] = i1;
		}
		this.tbl = tbl;
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		var base = this.base;
		if(this.tbl == null) {
			this.initTable();
		}
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = new haxe_io_Bytes(new ArrayBuffer(size));
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.b[pin++]];
				if(i == -1) {
					throw new js__$Boot_HaxeError("BaseCode : invalid encoded char");
				}
				buf |= i;
			}
			curbits -= 8;
			out.b[pout++] = buf >> curbits & 255 & 255;
		}
		return out;
	}
	,__class__: haxe_crypto_BaseCode
};
var haxe_ds_ArraySort = function() { };
$hxClasses["haxe.ds.ArraySort"] = haxe_ds_ArraySort;
haxe_ds_ArraySort.__name__ = ["haxe","ds","ArraySort"];
haxe_ds_ArraySort.sort = function(a,cmp) {
	haxe_ds_ArraySort.rec(a,cmp,0,a.length);
};
haxe_ds_ArraySort.rec = function(a,cmp,from,to) {
	var middle = from + to >> 1;
	if(to - from < 12) {
		if(to <= from) {
			return;
		}
		var _g1 = from + 1;
		var _g = to;
		while(_g1 < _g) {
			var i = _g1++;
			var j = i;
			while(j > from) {
				if(cmp(a[j],a[j - 1]) < 0) {
					haxe_ds_ArraySort.swap(a,j - 1,j);
				} else {
					break;
				}
				--j;
			}
		}
		return;
	}
	haxe_ds_ArraySort.rec(a,cmp,from,middle);
	haxe_ds_ArraySort.rec(a,cmp,middle,to);
	haxe_ds_ArraySort.doMerge(a,cmp,from,middle,to,middle - from,to - middle);
};
haxe_ds_ArraySort.doMerge = function(a,cmp,from,pivot,to,len1,len2) {
	var first_cut;
	var second_cut;
	var len11;
	var len22;
	var new_mid;
	if(len1 == 0 || len2 == 0) {
		return;
	}
	if(len1 + len2 == 2) {
		if(cmp(a[pivot],a[from]) < 0) {
			haxe_ds_ArraySort.swap(a,pivot,from);
		}
		return;
	}
	if(len1 > len2) {
		len11 = len1 >> 1;
		first_cut = from + len11;
		second_cut = haxe_ds_ArraySort.lower(a,cmp,pivot,to,first_cut);
		len22 = second_cut - pivot;
	} else {
		len22 = len2 >> 1;
		second_cut = pivot + len22;
		first_cut = haxe_ds_ArraySort.upper(a,cmp,from,pivot,second_cut);
		len11 = first_cut - from;
	}
	haxe_ds_ArraySort.rotate(a,cmp,first_cut,pivot,second_cut);
	new_mid = first_cut + len22;
	haxe_ds_ArraySort.doMerge(a,cmp,from,first_cut,new_mid,len11,len22);
	haxe_ds_ArraySort.doMerge(a,cmp,new_mid,second_cut,to,len1 - len11,len2 - len22);
};
haxe_ds_ArraySort.rotate = function(a,cmp,from,mid,to) {
	var n;
	if(from == mid || mid == to) {
		return;
	}
	n = haxe_ds_ArraySort.gcd(to - from,mid - from);
	while(n-- != 0) {
		var val = a[from + n];
		var shift = mid - from;
		var p1 = from + n;
		var p2 = from + n + shift;
		while(p2 != from + n) {
			a[p1] = a[p2];
			p1 = p2;
			if(to - p2 > shift) {
				p2 += shift;
			} else {
				p2 = from + (shift - (to - p2));
			}
		}
		a[p1] = val;
	}
};
haxe_ds_ArraySort.gcd = function(m,n) {
	while(n != 0) {
		var t = m % n;
		m = n;
		n = t;
	}
	return m;
};
haxe_ds_ArraySort.upper = function(a,cmp,from,to,val) {
	var len = to - from;
	var half;
	var mid;
	while(len > 0) {
		half = len >> 1;
		mid = from + half;
		if(cmp(a[val],a[mid]) < 0) {
			len = half;
		} else {
			from = mid + 1;
			len = len - half - 1;
		}
	}
	return from;
};
haxe_ds_ArraySort.lower = function(a,cmp,from,to,val) {
	var len = to - from;
	var half;
	var mid;
	while(len > 0) {
		half = len >> 1;
		mid = from + half;
		if(cmp(a[mid],a[val]) < 0) {
			from = mid + 1;
			len = len - half - 1;
		} else {
			len = half;
		}
	}
	return from;
};
haxe_ds_ArraySort.swap = function(a,i,j) {
	var tmp = a[i];
	a[i] = a[j];
	a[j] = tmp;
};
var haxe_ds_BalancedTree = function() {
};
$hxClasses["haxe.ds.BalancedTree"] = haxe_ds_BalancedTree;
haxe_ds_BalancedTree.__name__ = ["haxe","ds","BalancedTree"];
haxe_ds_BalancedTree.prototype = {
	set: function(key,value) {
		this.root = this.setLoop(key,value,this.root);
	}
	,get: function(key) {
		var node = this.root;
		while(node != null) {
			var c = this.compare(key,node.key);
			if(c == 0) {
				return node.value;
			}
			if(c < 0) {
				node = node.left;
			} else {
				node = node.right;
			}
		}
		return null;
	}
	,remove: function(key) {
		try {
			this.root = this.removeLoop(key,this.root);
			return true;
		} catch( e ) {
			haxe_CallStack.lastException = e;
			if (e instanceof js__$Boot_HaxeError) e = e.val;
			if( js_Boot.__instanceof(e,String) ) {
				return false;
			} else throw(e);
		}
	}
	,exists: function(key) {
		var node = this.root;
		while(node != null) {
			var c = this.compare(key,node.key);
			if(c == 0) {
				return true;
			} else if(c < 0) {
				node = node.left;
			} else {
				node = node.right;
			}
		}
		return false;
	}
	,iterator: function() {
		var ret = [];
		this.iteratorLoop(this.root,ret);
		return HxOverrides.iter(ret);
	}
	,keys: function() {
		var ret = [];
		this.keysLoop(this.root,ret);
		return HxOverrides.iter(ret);
	}
	,setLoop: function(k,v,node) {
		if(node == null) {
			return new haxe_ds_TreeNode(null,k,v,null);
		}
		var c = this.compare(k,node.key);
		if(c == 0) {
			return new haxe_ds_TreeNode(node.left,k,v,node.right,node == null ? 0 : node._height);
		} else if(c < 0) {
			var nl = this.setLoop(k,v,node.left);
			return this.balance(nl,node.key,node.value,node.right);
		} else {
			var nr = this.setLoop(k,v,node.right);
			return this.balance(node.left,node.key,node.value,nr);
		}
	}
	,removeLoop: function(k,node) {
		if(node == null) {
			throw new js__$Boot_HaxeError("Not_found");
		}
		var c = this.compare(k,node.key);
		if(c == 0) {
			return this.merge(node.left,node.right);
		} else if(c < 0) {
			return this.balance(this.removeLoop(k,node.left),node.key,node.value,node.right);
		} else {
			return this.balance(node.left,node.key,node.value,this.removeLoop(k,node.right));
		}
	}
	,iteratorLoop: function(node,acc) {
		if(node != null) {
			this.iteratorLoop(node.left,acc);
			acc.push(node.value);
			this.iteratorLoop(node.right,acc);
		}
	}
	,keysLoop: function(node,acc) {
		if(node != null) {
			this.keysLoop(node.left,acc);
			acc.push(node.key);
			this.keysLoop(node.right,acc);
		}
	}
	,merge: function(t1,t2) {
		if(t1 == null) {
			return t2;
		}
		if(t2 == null) {
			return t1;
		}
		var t = this.minBinding(t2);
		return this.balance(t1,t.key,t.value,this.removeMinBinding(t2));
	}
	,minBinding: function(t) {
		if(t == null) {
			throw new js__$Boot_HaxeError("Not_found");
		} else if(t.left == null) {
			return t;
		} else {
			return this.minBinding(t.left);
		}
	}
	,removeMinBinding: function(t) {
		if(t.left == null) {
			return t.right;
		} else {
			return this.balance(this.removeMinBinding(t.left),t.key,t.value,t.right);
		}
	}
	,balance: function(l,k,v,r) {
		var hl = l == null ? 0 : l._height;
		var hr = r == null ? 0 : r._height;
		if(hl > hr + 2) {
			var _this = l.left;
			var _this1 = l.right;
			if((_this == null ? 0 : _this._height) >= (_this1 == null ? 0 : _this1._height)) {
				return new haxe_ds_TreeNode(l.left,l.key,l.value,new haxe_ds_TreeNode(l.right,k,v,r));
			} else {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l.left,l.key,l.value,l.right.left),l.right.key,l.right.value,new haxe_ds_TreeNode(l.right.right,k,v,r));
			}
		} else if(hr > hl + 2) {
			var _this2 = r.right;
			var _this3 = r.left;
			if((_this2 == null ? 0 : _this2._height) > (_this3 == null ? 0 : _this3._height)) {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l,k,v,r.left),r.key,r.value,r.right);
			} else {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l,k,v,r.left.left),r.left.key,r.left.value,new haxe_ds_TreeNode(r.left.right,r.key,r.value,r.right));
			}
		} else {
			return new haxe_ds_TreeNode(l,k,v,r,(hl > hr ? hl : hr) + 1);
		}
	}
	,compare: function(k1,k2) {
		return Reflect.compare(k1,k2);
	}
	,__class__: haxe_ds_BalancedTree
};
var haxe_ds_TreeNode = function(l,k,v,r,h) {
	if(h == null) {
		h = -1;
	}
	this.left = l;
	this.key = k;
	this.value = v;
	this.right = r;
	if(h == -1) {
		var tmp;
		var _this = this.left;
		var _this1 = this.right;
		if((_this == null ? 0 : _this._height) > (_this1 == null ? 0 : _this1._height)) {
			var _this2 = this.left;
			if(_this2 == null) {
				tmp = 0;
			} else {
				tmp = _this2._height;
			}
		} else {
			var _this3 = this.right;
			if(_this3 == null) {
				tmp = 0;
			} else {
				tmp = _this3._height;
			}
		}
		this._height = tmp + 1;
	} else {
		this._height = h;
	}
};
$hxClasses["haxe.ds.TreeNode"] = haxe_ds_TreeNode;
haxe_ds_TreeNode.__name__ = ["haxe","ds","TreeNode"];
haxe_ds_TreeNode.prototype = {
	__class__: haxe_ds_TreeNode
};
var haxe_ds_EnumValueMap = function() {
	haxe_ds_BalancedTree.call(this);
};
$hxClasses["haxe.ds.EnumValueMap"] = haxe_ds_EnumValueMap;
haxe_ds_EnumValueMap.__name__ = ["haxe","ds","EnumValueMap"];
haxe_ds_EnumValueMap.__interfaces__ = [haxe_IMap];
haxe_ds_EnumValueMap.__super__ = haxe_ds_BalancedTree;
haxe_ds_EnumValueMap.prototype = $extend(haxe_ds_BalancedTree.prototype,{
	compare: function(k1,k2) {
		var d = k1[1] - k2[1];
		if(d != 0) {
			return d;
		}
		var p1 = k1.slice(2);
		var p2 = k2.slice(2);
		if(p1.length == 0 && p2.length == 0) {
			return 0;
		}
		return this.compareArgs(p1,p2);
	}
	,compareArgs: function(a1,a2) {
		var ld = a1.length - a2.length;
		if(ld != 0) {
			return ld;
		}
		var _g1 = 0;
		var _g = a1.length;
		while(_g1 < _g) {
			var i = _g1++;
			var d = this.compareArg(a1[i],a2[i]);
			if(d != 0) {
				return d;
			}
		}
		return 0;
	}
	,compareArg: function(v1,v2) {
		if(Reflect.isEnumValue(v1) && Reflect.isEnumValue(v2)) {
			return this.compare(v1,v2);
		} else if((v1 instanceof Array) && v1.__enum__ == null && ((v2 instanceof Array) && v2.__enum__ == null)) {
			return this.compareArgs(v1,v2);
		} else {
			return Reflect.compare(v1,v2);
		}
	}
	,__class__: haxe_ds_EnumValueMap
});
var haxe_ds_IntMap = function() {
	this.h = { };
};
$hxClasses["haxe.ds.IntMap"] = haxe_ds_IntMap;
haxe_ds_IntMap.__name__ = ["haxe","ds","IntMap"];
haxe_ds_IntMap.__interfaces__ = [haxe_IMap];
haxe_ds_IntMap.prototype = {
	set: function(key,value) {
		this.h[key] = value;
	}
	,get: function(key) {
		return this.h[key];
	}
	,exists: function(key) {
		return this.h.hasOwnProperty(key);
	}
	,remove: function(key) {
		if(!this.h.hasOwnProperty(key)) {
			return false;
		}
		delete(this.h[key]);
		return true;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h ) if(this.h.hasOwnProperty(key)) {
			a.push(key | 0);
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i];
		}};
	}
	,__class__: haxe_ds_IntMap
};
var haxe_ds__$StringMap_StringMapIterator = function(map,keys) {
	this.map = map;
	this.keys = keys;
	this.index = 0;
	this.count = keys.length;
};
$hxClasses["haxe.ds._StringMap.StringMapIterator"] = haxe_ds__$StringMap_StringMapIterator;
haxe_ds__$StringMap_StringMapIterator.__name__ = ["haxe","ds","_StringMap","StringMapIterator"];
haxe_ds__$StringMap_StringMapIterator.prototype = {
	hasNext: function() {
		return this.index < this.count;
	}
	,next: function() {
		var _this = this.map;
		var key = this.keys[this.index++];
		if(__map_reserved[key] != null) {
			return _this.getReserved(key);
		} else {
			return _this.h[key];
		}
	}
	,__class__: haxe_ds__$StringMap_StringMapIterator
};
var haxe_ds_StringMap = function() {
	this.h = { };
};
$hxClasses["haxe.ds.StringMap"] = haxe_ds_StringMap;
haxe_ds_StringMap.__name__ = ["haxe","ds","StringMap"];
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.prototype = {
	set: function(key,value) {
		if(__map_reserved[key] != null) {
			this.setReserved(key,value);
		} else {
			this.h[key] = value;
		}
	}
	,get: function(key) {
		if(__map_reserved[key] != null) {
			return this.getReserved(key);
		}
		return this.h[key];
	}
	,exists: function(key) {
		if(__map_reserved[key] != null) {
			return this.existsReserved(key);
		}
		return this.h.hasOwnProperty(key);
	}
	,setReserved: function(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	,getReserved: function(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	,existsReserved: function(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	,remove: function(key) {
		if(__map_reserved[key] != null) {
			key = "$" + key;
			if(this.rh == null || !this.rh.hasOwnProperty(key)) {
				return false;
			}
			delete(this.rh[key]);
			return true;
		} else {
			if(!this.h.hasOwnProperty(key)) {
				return false;
			}
			delete(this.h[key]);
			return true;
		}
	}
	,keys: function() {
		return HxOverrides.iter(this.arrayKeys());
	}
	,arrayKeys: function() {
		var out = [];
		for( var key in this.h ) {
		if(this.h.hasOwnProperty(key)) {
			out.push(key);
		}
		}
		if(this.rh != null) {
			for( var key in this.rh ) {
			if(key.charCodeAt(0) == 36) {
				out.push(key.substr(1));
			}
			}
		}
		return out;
	}
	,iterator: function() {
		return new haxe_ds__$StringMap_StringMapIterator(this,this.arrayKeys());
	}
	,toString: function() {
		var s_b = "";
		s_b += "{";
		var keys = this.arrayKeys();
		var _g1 = 0;
		var _g = keys.length;
		while(_g1 < _g) {
			var i = _g1++;
			var k = keys[i];
			s_b += k == null ? "null" : "" + k;
			s_b += " => ";
			s_b += Std.string(Std.string(__map_reserved[k] != null ? this.getReserved(k) : this.h[k]));
			if(i < keys.length - 1) {
				s_b += ", ";
			}
		}
		s_b += "}";
		return s_b;
	}
	,__class__: haxe_ds_StringMap
};
var haxe_io_BytesBuffer = function() {
	this.b = [];
};
$hxClasses["haxe.io.BytesBuffer"] = haxe_io_BytesBuffer;
haxe_io_BytesBuffer.__name__ = ["haxe","io","BytesBuffer"];
haxe_io_BytesBuffer.prototype = {
	getBytes: function() {
		var bytes = new haxe_io_Bytes(new Uint8Array(this.b).buffer);
		this.b = null;
		return bytes;
	}
	,__class__: haxe_io_BytesBuffer
};
var haxe_io_Input = function() { };
$hxClasses["haxe.io.Input"] = haxe_io_Input;
haxe_io_Input.__name__ = ["haxe","io","Input"];
haxe_io_Input.prototype = {
	readByte: function() {
		throw new js__$Boot_HaxeError("Not implemented");
	}
	,readBytes: function(s,pos,len) {
		var k = len;
		var b = s.b;
		if(pos < 0 || len < 0 || pos + len > s.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		try {
			while(k > 0) {
				b[pos] = this.readByte();
				++pos;
				--k;
			}
		} catch( eof ) {
			haxe_CallStack.lastException = eof;
			if (eof instanceof js__$Boot_HaxeError) eof = eof.val;
			if( js_Boot.__instanceof(eof,haxe_io_Eof) ) {
			} else throw(eof);
		}
		return len - k;
	}
	,readFullBytes: function(s,pos,len) {
		while(len > 0) {
			var k = this.readBytes(s,pos,len);
			if(k == 0) {
				throw new js__$Boot_HaxeError(haxe_io_Error.Blocked);
			}
			pos += k;
			len -= k;
		}
	}
	,read: function(nbytes) {
		var s = new haxe_io_Bytes(new ArrayBuffer(nbytes));
		var p = 0;
		while(nbytes > 0) {
			var k = this.readBytes(s,p,nbytes);
			if(k == 0) {
				throw new js__$Boot_HaxeError(haxe_io_Error.Blocked);
			}
			p += k;
			nbytes -= k;
		}
		return s;
	}
	,readInt16: function() {
		var ch1 = this.readByte();
		var ch2 = this.readByte();
		var n = this.bigEndian ? ch2 | ch1 << 8 : ch1 | ch2 << 8;
		if((n & 32768) != 0) {
			return n - 65536;
		}
		return n;
	}
	,readUInt16: function() {
		var ch1 = this.readByte();
		var ch2 = this.readByte();
		if(this.bigEndian) {
			return ch2 | ch1 << 8;
		} else {
			return ch1 | ch2 << 8;
		}
	}
	,readInt32: function() {
		var ch1 = this.readByte();
		var ch2 = this.readByte();
		var ch3 = this.readByte();
		var ch4 = this.readByte();
		if(this.bigEndian) {
			return ch4 | ch3 << 8 | ch2 << 16 | ch1 << 24;
		} else {
			return ch1 | ch2 << 8 | ch3 << 16 | ch4 << 24;
		}
	}
	,readString: function(len) {
		var b = new haxe_io_Bytes(new ArrayBuffer(len));
		this.readFullBytes(b,0,len);
		return b.toString();
	}
	,__class__: haxe_io_Input
};
var haxe_io_BytesInput = function(b,pos,len) {
	if(pos == null) {
		pos = 0;
	}
	if(len == null) {
		len = b.length - pos;
	}
	if(pos < 0 || len < 0 || pos + len > b.length) {
		throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
	}
	this.b = b.b;
	this.pos = pos;
	this.len = len;
	this.totlen = len;
};
$hxClasses["haxe.io.BytesInput"] = haxe_io_BytesInput;
haxe_io_BytesInput.__name__ = ["haxe","io","BytesInput"];
haxe_io_BytesInput.__super__ = haxe_io_Input;
haxe_io_BytesInput.prototype = $extend(haxe_io_Input.prototype,{
	readByte: function() {
		if(this.len == 0) {
			throw new js__$Boot_HaxeError(new haxe_io_Eof());
		}
		this.len--;
		return this.b[this.pos++];
	}
	,readBytes: function(buf,pos,len) {
		if(pos < 0 || len < 0 || pos + len > buf.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		if(this.len == 0 && len > 0) {
			throw new js__$Boot_HaxeError(new haxe_io_Eof());
		}
		if(this.len < len) {
			len = this.len;
		}
		var b1 = this.b;
		var b2 = buf.b;
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) {
			var i = _g1++;
			b2[pos + i] = b1[this.pos + i];
		}
		this.pos += len;
		this.len -= len;
		return len;
	}
	,__class__: haxe_io_BytesInput
});
var haxe_io_Eof = function() {
};
$hxClasses["haxe.io.Eof"] = haxe_io_Eof;
haxe_io_Eof.__name__ = ["haxe","io","Eof"];
haxe_io_Eof.prototype = {
	toString: function() {
		return "Eof";
	}
	,__class__: haxe_io_Eof
};
var haxe_io_Error = $hxClasses["haxe.io.Error"] = { __ename__ : ["haxe","io","Error"], __constructs__ : ["Blocked","Overflow","OutsideBounds","Custom"] };
haxe_io_Error.Blocked = ["Blocked",0];
haxe_io_Error.Blocked.toString = $estr;
haxe_io_Error.Blocked.__enum__ = haxe_io_Error;
haxe_io_Error.Overflow = ["Overflow",1];
haxe_io_Error.Overflow.toString = $estr;
haxe_io_Error.Overflow.__enum__ = haxe_io_Error;
haxe_io_Error.OutsideBounds = ["OutsideBounds",2];
haxe_io_Error.OutsideBounds.toString = $estr;
haxe_io_Error.OutsideBounds.__enum__ = haxe_io_Error;
haxe_io_Error.Custom = function(e) { var $x = ["Custom",3,e]; $x.__enum__ = haxe_io_Error; $x.toString = $estr; return $x; };
var haxe_io_FPHelper = function() { };
$hxClasses["haxe.io.FPHelper"] = haxe_io_FPHelper;
haxe_io_FPHelper.__name__ = ["haxe","io","FPHelper"];
haxe_io_FPHelper.i32ToFloat = function(i) {
	var sign = 1 - (i >>> 31 << 1);
	var exp = i >>> 23 & 255;
	var sig = i & 8388607;
	if(sig == 0 && exp == 0) {
		return 0.0;
	}
	return sign * (1 + Math.pow(2,-23) * sig) * Math.pow(2,exp - 127);
};
haxe_io_FPHelper.floatToI32 = function(f) {
	if(f == 0) {
		return 0;
	}
	var af = f < 0 ? -f : f;
	var exp = Math.floor(Math.log(af) / 0.6931471805599453);
	if(exp < -127) {
		exp = -127;
	} else if(exp > 128) {
		exp = 128;
	}
	var sig = Math.round((af / Math.pow(2,exp) - 1) * 8388608);
	if(sig == 8388608 && exp < 128) {
		sig = 0;
		++exp;
	}
	return (f < 0 ? -2147483648 : 0) | exp + 127 << 23 | sig;
};
haxe_io_FPHelper.i64ToDouble = function(low,high) {
	var sign = 1 - (high >>> 31 << 1);
	var exp = (high >> 20 & 2047) - 1023;
	var sig = (high & 1048575) * 4294967296. + (low >>> 31) * 2147483648. + (low & 2147483647);
	if(sig == 0 && exp == -1023) {
		return 0.0;
	}
	return sign * (1.0 + Math.pow(2,-52) * sig) * Math.pow(2,exp);
};
haxe_io_FPHelper.doubleToI64 = function(v) {
	var i64 = haxe_io_FPHelper.i64tmp;
	if(v == 0) {
		i64.low = 0;
		i64.high = 0;
	} else if(!isFinite(v)) {
		if(v > 0) {
			i64.low = 0;
			i64.high = 2146435072;
		} else {
			i64.low = 0;
			i64.high = -1048576;
		}
	} else {
		var av = v < 0 ? -v : v;
		var exp = Math.floor(Math.log(av) / 0.6931471805599453);
		var sig = Math.round((av / Math.pow(2,exp) - 1) * 4503599627370496.);
		var sig_l = sig | 0;
		var sig_h = sig / 4294967296.0 | 0;
		i64.low = sig_l;
		i64.high = (v < 0 ? -2147483648 : 0) | exp + 1023 << 20 | sig_h;
	}
	return i64;
};
var haxe_io_Path = function(path) {
	switch(path) {
	case ".":case "..":
		this.dir = path;
		this.file = "";
		return;
	}
	var c1 = path.lastIndexOf("/");
	var c2 = path.lastIndexOf("\\");
	if(c1 < c2) {
		this.dir = HxOverrides.substr(path,0,c2);
		path = HxOverrides.substr(path,c2 + 1,null);
		this.backslash = true;
	} else if(c2 < c1) {
		this.dir = HxOverrides.substr(path,0,c1);
		path = HxOverrides.substr(path,c1 + 1,null);
	} else {
		this.dir = null;
	}
	var cp = path.lastIndexOf(".");
	if(cp != -1) {
		this.ext = HxOverrides.substr(path,cp + 1,null);
		this.file = HxOverrides.substr(path,0,cp);
	} else {
		this.ext = null;
		this.file = path;
	}
};
$hxClasses["haxe.io.Path"] = haxe_io_Path;
haxe_io_Path.__name__ = ["haxe","io","Path"];
haxe_io_Path.directory = function(path) {
	var s = new haxe_io_Path(path);
	if(s.dir == null) {
		return "";
	}
	return s.dir;
};
haxe_io_Path.prototype = {
	__class__: haxe_io_Path
};
var haxe_zip_ExtraField = $hxClasses["haxe.zip.ExtraField"] = { __ename__ : ["haxe","zip","ExtraField"], __constructs__ : ["FUnknown","FInfoZipUnicodePath","FUtf8"] };
haxe_zip_ExtraField.FUnknown = function(tag,bytes) { var $x = ["FUnknown",0,tag,bytes]; $x.__enum__ = haxe_zip_ExtraField; $x.toString = $estr; return $x; };
haxe_zip_ExtraField.FInfoZipUnicodePath = function(name,crc) { var $x = ["FInfoZipUnicodePath",1,name,crc]; $x.__enum__ = haxe_zip_ExtraField; $x.toString = $estr; return $x; };
haxe_zip_ExtraField.FUtf8 = ["FUtf8",2];
haxe_zip_ExtraField.FUtf8.toString = $estr;
haxe_zip_ExtraField.FUtf8.__enum__ = haxe_zip_ExtraField;
var haxe_zip_Huffman = $hxClasses["haxe.zip.Huffman"] = { __ename__ : ["haxe","zip","Huffman"], __constructs__ : ["Found","NeedBit","NeedBits"] };
haxe_zip_Huffman.Found = function(i) { var $x = ["Found",0,i]; $x.__enum__ = haxe_zip_Huffman; $x.toString = $estr; return $x; };
haxe_zip_Huffman.NeedBit = function(left,right) { var $x = ["NeedBit",1,left,right]; $x.__enum__ = haxe_zip_Huffman; $x.toString = $estr; return $x; };
haxe_zip_Huffman.NeedBits = function(n,table) { var $x = ["NeedBits",2,n,table]; $x.__enum__ = haxe_zip_Huffman; $x.toString = $estr; return $x; };
var haxe_zip_HuffTools = function() {
};
$hxClasses["haxe.zip.HuffTools"] = haxe_zip_HuffTools;
haxe_zip_HuffTools.__name__ = ["haxe","zip","HuffTools"];
haxe_zip_HuffTools.prototype = {
	treeDepth: function(t) {
		switch(t[1]) {
		case 0:
			return 0;
		case 1:
			var b = t[3];
			var a = t[2];
			var da = this.treeDepth(a);
			var db = this.treeDepth(b);
			return 1 + (da < db ? da : db);
		case 2:
			throw new js__$Boot_HaxeError("assert");
			break;
		}
	}
	,treeCompress: function(t) {
		var d = this.treeDepth(t);
		if(d == 0) {
			return t;
		}
		if(d == 1) {
			if(t[1] == 1) {
				var b = t[3];
				var a = t[2];
				return haxe_zip_Huffman.NeedBit(this.treeCompress(a),this.treeCompress(b));
			} else {
				throw new js__$Boot_HaxeError("assert");
			}
		}
		var size = 1 << d;
		var table = [];
		var _g1 = 0;
		var _g = size;
		while(_g1 < _g) {
			var i = _g1++;
			table.push(haxe_zip_Huffman.Found(-1));
		}
		this.treeWalk(table,0,0,d,t);
		return haxe_zip_Huffman.NeedBits(d,table);
	}
	,treeWalk: function(table,p,cd,d,t) {
		if(t[1] == 1) {
			var b = t[3];
			var a = t[2];
			if(d > 0) {
				this.treeWalk(table,p,cd + 1,d - 1,a);
				this.treeWalk(table,p | 1 << cd,cd + 1,d - 1,b);
			} else {
				table[p] = this.treeCompress(t);
			}
		} else {
			table[p] = this.treeCompress(t);
		}
	}
	,treeMake: function(bits,maxbits,v,len) {
		if(len > maxbits) {
			throw new js__$Boot_HaxeError("Invalid huffman");
		}
		var idx = v << 5 | len;
		if(bits.h.hasOwnProperty(idx)) {
			return haxe_zip_Huffman.Found(bits.h[idx]);
		}
		v <<= 1;
		++len;
		return haxe_zip_Huffman.NeedBit(this.treeMake(bits,maxbits,v,len),this.treeMake(bits,maxbits,v | 1,len));
	}
	,make: function(lengths,pos,nlengths,maxbits) {
		var counts = [];
		var tmp = [];
		if(maxbits > 32) {
			throw new js__$Boot_HaxeError("Invalid huffman");
		}
		var _g1 = 0;
		var _g = maxbits;
		while(_g1 < _g) {
			var i = _g1++;
			counts.push(0);
			tmp.push(0);
		}
		var _g11 = 0;
		var _g2 = nlengths;
		while(_g11 < _g2) {
			var i1 = _g11++;
			var p = lengths[i1 + pos];
			if(p >= maxbits) {
				throw new js__$Boot_HaxeError("Invalid huffman");
			}
			counts[p]++;
		}
		var code = 0;
		var _g12 = 1;
		var _g3 = maxbits - 1;
		while(_g12 < _g3) {
			var i2 = _g12++;
			code = code + counts[i2] << 1;
			tmp[i2] = code;
		}
		var bits = new haxe_ds_IntMap();
		var _g13 = 0;
		var _g4 = nlengths;
		while(_g13 < _g4) {
			var i3 = _g13++;
			var l = lengths[i3 + pos];
			if(l != 0) {
				var n = tmp[l - 1];
				tmp[l - 1] = n + 1;
				bits.h[n << 5 | l] = i3;
			}
		}
		return this.treeCompress(haxe_zip_Huffman.NeedBit(this.treeMake(bits,maxbits,0,1),this.treeMake(bits,maxbits,1,1)));
	}
	,__class__: haxe_zip_HuffTools
};
var haxe_zip__$InflateImpl_Window = function(hasCrc) {
	this.buffer = new haxe_io_Bytes(new ArrayBuffer(65536));
	this.pos = 0;
	if(hasCrc) {
		this.crc = new haxe_crypto_Adler32();
	}
};
$hxClasses["haxe.zip._InflateImpl.Window"] = haxe_zip__$InflateImpl_Window;
haxe_zip__$InflateImpl_Window.__name__ = ["haxe","zip","_InflateImpl","Window"];
haxe_zip__$InflateImpl_Window.prototype = {
	slide: function() {
		if(this.crc != null) {
			this.crc.update(this.buffer,0,32768);
		}
		var b = new haxe_io_Bytes(new ArrayBuffer(65536));
		this.pos -= 32768;
		b.blit(0,this.buffer,32768,this.pos);
		this.buffer = b;
	}
	,addBytes: function(b,p,len) {
		if(this.pos + len > 65536) {
			this.slide();
		}
		this.buffer.blit(this.pos,b,p,len);
		this.pos += len;
	}
	,addByte: function(c) {
		if(this.pos == 65536) {
			this.slide();
		}
		this.buffer.b[this.pos] = c & 255;
		this.pos++;
	}
	,getLastChar: function() {
		return this.buffer.b[this.pos - 1];
	}
	,available: function() {
		return this.pos;
	}
	,checksum: function() {
		if(this.crc != null) {
			this.crc.update(this.buffer,0,this.pos);
		}
		return this.crc;
	}
	,__class__: haxe_zip__$InflateImpl_Window
};
var haxe_zip__$InflateImpl_State = $hxClasses["haxe.zip._InflateImpl.State"] = { __ename__ : ["haxe","zip","_InflateImpl","State"], __constructs__ : ["Head","Block","CData","Flat","Crc","Dist","DistOne","Done"] };
haxe_zip__$InflateImpl_State.Head = ["Head",0];
haxe_zip__$InflateImpl_State.Head.toString = $estr;
haxe_zip__$InflateImpl_State.Head.__enum__ = haxe_zip__$InflateImpl_State;
haxe_zip__$InflateImpl_State.Block = ["Block",1];
haxe_zip__$InflateImpl_State.Block.toString = $estr;
haxe_zip__$InflateImpl_State.Block.__enum__ = haxe_zip__$InflateImpl_State;
haxe_zip__$InflateImpl_State.CData = ["CData",2];
haxe_zip__$InflateImpl_State.CData.toString = $estr;
haxe_zip__$InflateImpl_State.CData.__enum__ = haxe_zip__$InflateImpl_State;
haxe_zip__$InflateImpl_State.Flat = ["Flat",3];
haxe_zip__$InflateImpl_State.Flat.toString = $estr;
haxe_zip__$InflateImpl_State.Flat.__enum__ = haxe_zip__$InflateImpl_State;
haxe_zip__$InflateImpl_State.Crc = ["Crc",4];
haxe_zip__$InflateImpl_State.Crc.toString = $estr;
haxe_zip__$InflateImpl_State.Crc.__enum__ = haxe_zip__$InflateImpl_State;
haxe_zip__$InflateImpl_State.Dist = ["Dist",5];
haxe_zip__$InflateImpl_State.Dist.toString = $estr;
haxe_zip__$InflateImpl_State.Dist.__enum__ = haxe_zip__$InflateImpl_State;
haxe_zip__$InflateImpl_State.DistOne = ["DistOne",6];
haxe_zip__$InflateImpl_State.DistOne.toString = $estr;
haxe_zip__$InflateImpl_State.DistOne.__enum__ = haxe_zip__$InflateImpl_State;
haxe_zip__$InflateImpl_State.Done = ["Done",7];
haxe_zip__$InflateImpl_State.Done.toString = $estr;
haxe_zip__$InflateImpl_State.Done.__enum__ = haxe_zip__$InflateImpl_State;
var haxe_zip_InflateImpl = function(i,header,crc) {
	if(crc == null) {
		crc = true;
	}
	if(header == null) {
		header = true;
	}
	this["final"] = false;
	this.htools = new haxe_zip_HuffTools();
	this.huffman = this.buildFixedHuffman();
	this.huffdist = null;
	this.len = 0;
	this.dist = 0;
	this.state = header ? haxe_zip__$InflateImpl_State.Head : haxe_zip__$InflateImpl_State.Block;
	this.input = i;
	this.bits = 0;
	this.nbits = 0;
	this.needed = 0;
	this.output = null;
	this.outpos = 0;
	this.lengths = [];
	var _g = 0;
	while(_g < 19) {
		var i1 = _g++;
		this.lengths.push(-1);
	}
	this.window = new haxe_zip__$InflateImpl_Window(crc);
};
$hxClasses["haxe.zip.InflateImpl"] = haxe_zip_InflateImpl;
haxe_zip_InflateImpl.__name__ = ["haxe","zip","InflateImpl"];
haxe_zip_InflateImpl.prototype = {
	buildFixedHuffman: function() {
		if(haxe_zip_InflateImpl.FIXED_HUFFMAN != null) {
			return haxe_zip_InflateImpl.FIXED_HUFFMAN;
		}
		var a = [];
		var _g = 0;
		while(_g < 288) {
			var n = _g++;
			a.push(n <= 143 ? 8 : n <= 255 ? 9 : n <= 279 ? 7 : 8);
		}
		haxe_zip_InflateImpl.FIXED_HUFFMAN = this.htools.make(a,0,288,10);
		return haxe_zip_InflateImpl.FIXED_HUFFMAN;
	}
	,readBytes: function(b,pos,len) {
		this.needed = len;
		this.outpos = pos;
		this.output = b;
		if(len > 0) {
			while(this.inflateLoop()) {
			}
		}
		return len - this.needed;
	}
	,getBits: function(n) {
		while(this.nbits < n) {
			this.bits |= this.input.readByte() << this.nbits;
			this.nbits += 8;
		}
		var b = this.bits & (1 << n) - 1;
		this.nbits -= n;
		this.bits >>= n;
		return b;
	}
	,getBit: function() {
		if(this.nbits == 0) {
			this.nbits = 8;
			this.bits = this.input.readByte();
		}
		var b = (this.bits & 1) == 1;
		this.nbits--;
		this.bits >>= 1;
		return b;
	}
	,getRevBits: function(n) {
		if(n == 0) {
			return 0;
		} else if(this.getBit()) {
			return 1 << n - 1 | this.getRevBits(n - 1);
		} else {
			return this.getRevBits(n - 1);
		}
	}
	,resetBits: function() {
		this.bits = 0;
		this.nbits = 0;
	}
	,addBytes: function(b,p,len) {
		this.window.addBytes(b,p,len);
		this.output.blit(this.outpos,b,p,len);
		this.needed -= len;
		this.outpos += len;
	}
	,addByte: function(b) {
		this.window.addByte(b);
		this.output.b[this.outpos] = b & 255;
		this.needed--;
		this.outpos++;
	}
	,addDistOne: function(n) {
		var c = this.window.getLastChar();
		var _g1 = 0;
		var _g = n;
		while(_g1 < _g) {
			var i = _g1++;
			this.addByte(c);
		}
	}
	,addDist: function(d,len) {
		this.addBytes(this.window.buffer,this.window.pos - d,len);
	}
	,applyHuffman: function(h) {
		switch(h[1]) {
		case 0:
			var n = h[2];
			return n;
		case 1:
			var b = h[3];
			var a = h[2];
			return this.applyHuffman(this.getBit() ? b : a);
		case 2:
			var tbl = h[3];
			var n1 = h[2];
			return this.applyHuffman(tbl[this.getBits(n1)]);
		}
	}
	,inflateLengths: function(a,max) {
		var i = 0;
		var prev = 0;
		while(i < max) {
			var n = this.applyHuffman(this.huffman);
			switch(n) {
			case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:case 9:case 10:case 11:case 12:case 13:case 14:case 15:
				prev = n;
				a[i] = n;
				++i;
				break;
			case 16:
				var end = i + 3 + this.getBits(2);
				if(end > max) {
					throw new js__$Boot_HaxeError("Invalid data");
				}
				while(i < end) {
					a[i] = prev;
					++i;
				}
				break;
			case 17:
				i += 3 + this.getBits(3);
				if(i > max) {
					throw new js__$Boot_HaxeError("Invalid data");
				}
				break;
			case 18:
				i += 11 + this.getBits(7);
				if(i > max) {
					throw new js__$Boot_HaxeError("Invalid data");
				}
				break;
			default:
				throw new js__$Boot_HaxeError("Invalid data");
			}
		}
	}
	,inflateLoop: function() {
		var _g = this.state;
		switch(_g[1]) {
		case 0:
			var cmf = this.input.readByte();
			var cm = cmf & 15;
			var cinfo = cmf >> 4;
			if(cm != 8) {
				throw new js__$Boot_HaxeError("Invalid data");
			}
			var flg = this.input.readByte();
			var fdict = (flg & 32) != 0;
			if(((cmf << 8) + flg) % 31 != 0) {
				throw new js__$Boot_HaxeError("Invalid data");
			}
			if(fdict) {
				throw new js__$Boot_HaxeError("Unsupported dictionary");
			}
			this.state = haxe_zip__$InflateImpl_State.Block;
			return true;
		case 1:
			this["final"] = this.getBit();
			var _g1 = this.getBits(2);
			switch(_g1) {
			case 0:
				this.len = this.input.readUInt16();
				var nlen = this.input.readUInt16();
				if(nlen != 65535 - this.len) {
					throw new js__$Boot_HaxeError("Invalid data");
				}
				this.state = haxe_zip__$InflateImpl_State.Flat;
				var r = this.inflateLoop();
				this.resetBits();
				return r;
			case 1:
				this.huffman = this.buildFixedHuffman();
				this.huffdist = null;
				this.state = haxe_zip__$InflateImpl_State.CData;
				return true;
			case 2:
				var hlit = this.getBits(5) + 257;
				var hdist = this.getBits(5) + 1;
				var hclen = this.getBits(4) + 4;
				var _g11 = 0;
				var _g2 = hclen;
				while(_g11 < _g2) {
					var i = _g11++;
					this.lengths[haxe_zip_InflateImpl.CODE_LENGTHS_POS[i]] = this.getBits(3);
				}
				var _g3 = hclen;
				while(_g3 < 19) {
					var i1 = _g3++;
					this.lengths[haxe_zip_InflateImpl.CODE_LENGTHS_POS[i1]] = 0;
				}
				this.huffman = this.htools.make(this.lengths,0,19,8);
				var lengths = [];
				var _g12 = 0;
				var _g4 = hlit + hdist;
				while(_g12 < _g4) {
					var i2 = _g12++;
					lengths.push(0);
				}
				this.inflateLengths(lengths,hlit + hdist);
				this.huffdist = this.htools.make(lengths,hlit,hdist,16);
				this.huffman = this.htools.make(lengths,0,hlit,16);
				this.state = haxe_zip__$InflateImpl_State.CData;
				return true;
			default:
				throw new js__$Boot_HaxeError("Invalid data");
			}
			break;
		case 2:
			var n = this.applyHuffman(this.huffman);
			if(n < 256) {
				this.addByte(n);
				return this.needed > 0;
			} else if(n == 256) {
				this.state = this["final"] ? haxe_zip__$InflateImpl_State.Crc : haxe_zip__$InflateImpl_State.Block;
				return true;
			} else {
				n -= 257;
				var extra_bits = haxe_zip_InflateImpl.LEN_EXTRA_BITS_TBL[n];
				if(extra_bits == -1) {
					throw new js__$Boot_HaxeError("Invalid data");
				}
				this.len = haxe_zip_InflateImpl.LEN_BASE_VAL_TBL[n] + this.getBits(extra_bits);
				var dist_code = this.huffdist == null ? this.getRevBits(5) : this.applyHuffman(this.huffdist);
				extra_bits = haxe_zip_InflateImpl.DIST_EXTRA_BITS_TBL[dist_code];
				if(extra_bits == -1) {
					throw new js__$Boot_HaxeError("Invalid data");
				}
				this.dist = haxe_zip_InflateImpl.DIST_BASE_VAL_TBL[dist_code] + this.getBits(extra_bits);
				if(this.dist > this.window.available()) {
					throw new js__$Boot_HaxeError("Invalid data");
				}
				this.state = this.dist == 1 ? haxe_zip__$InflateImpl_State.DistOne : haxe_zip__$InflateImpl_State.Dist;
				return true;
			}
			break;
		case 3:
			var rlen = this.len < this.needed ? this.len : this.needed;
			var bytes = this.input.read(rlen);
			this.len -= rlen;
			this.addBytes(bytes,0,rlen);
			if(this.len == 0) {
				this.state = this["final"] ? haxe_zip__$InflateImpl_State.Crc : haxe_zip__$InflateImpl_State.Block;
			}
			return this.needed > 0;
		case 4:
			var calc = this.window.checksum();
			if(calc == null) {
				this.state = haxe_zip__$InflateImpl_State.Done;
				return true;
			}
			var crc = haxe_crypto_Adler32.read(this.input);
			if(!calc.equals(crc)) {
				throw new js__$Boot_HaxeError("Invalid CRC");
			}
			this.state = haxe_zip__$InflateImpl_State.Done;
			return true;
		case 5:
			while(this.len > 0 && this.needed > 0) {
				var rdist = this.len < this.dist ? this.len : this.dist;
				var rlen1 = this.needed < rdist ? this.needed : rdist;
				this.addDist(this.dist,rlen1);
				this.len -= rlen1;
			}
			if(this.len == 0) {
				this.state = haxe_zip__$InflateImpl_State.CData;
			}
			return this.needed > 0;
		case 6:
			var rlen2 = this.len < this.needed ? this.len : this.needed;
			this.addDistOne(rlen2);
			this.len -= rlen2;
			if(this.len == 0) {
				this.state = haxe_zip__$InflateImpl_State.CData;
			}
			return this.needed > 0;
		case 7:
			return false;
		}
	}
	,__class__: haxe_zip_InflateImpl
};
var haxe_zip_Reader = function(i) {
	this.i = i;
};
$hxClasses["haxe.zip.Reader"] = haxe_zip_Reader;
haxe_zip_Reader.__name__ = ["haxe","zip","Reader"];
haxe_zip_Reader.readZip = function(i) {
	var r = new haxe_zip_Reader(i);
	return r.read();
};
haxe_zip_Reader.unzip = function(f) {
	if(!f.compressed) {
		return f.data;
	}
	throw new js__$Boot_HaxeError("No uncompress support");
};
haxe_zip_Reader.prototype = {
	readZipDate: function() {
		var t = this.i.readUInt16();
		var hour = t >> 11 & 31;
		var min = t >> 5 & 63;
		var sec = t & 31;
		var d = this.i.readUInt16();
		var year = d >> 9;
		var month = d >> 5 & 15;
		var day = d & 31;
		return new Date(year + 1980,month - 1,day,hour,min,sec << 1);
	}
	,readExtraFields: function(length) {
		var fields = new List();
		while(length > 0) {
			if(length < 4) {
				throw new js__$Boot_HaxeError("Invalid extra fields data");
			}
			var tag = this.i.readUInt16();
			var len = this.i.readUInt16();
			if(length < len) {
				throw new js__$Boot_HaxeError("Invalid extra fields data");
			}
			if(tag == 28789) {
				var version = this.i.readByte();
				if(version != 1) {
					var data = new haxe_io_BytesBuffer();
					data.b.push(version);
					var src = this.i.read(len - 1);
					var b1 = data.b;
					var b2 = src.b;
					var _g1 = 0;
					var _g = src.length;
					while(_g1 < _g) {
						var i = _g1++;
						data.b.push(b2[i]);
					}
					fields.add(haxe_zip_ExtraField.FUnknown(tag,data.getBytes()));
				} else {
					var crc = this.i.readInt32();
					var name = this.i.read(len - 5).toString();
					fields.add(haxe_zip_ExtraField.FInfoZipUnicodePath(name,crc));
				}
			} else {
				fields.add(haxe_zip_ExtraField.FUnknown(tag,this.i.read(len)));
			}
			length -= 4 + len;
		}
		return fields;
	}
	,readEntryHeader: function() {
		var i = this.i;
		var h = i.readInt32();
		if(h == 33639248 || h == 101010256) {
			return null;
		}
		if(h != 67324752) {
			throw new js__$Boot_HaxeError("Invalid Zip Data");
		}
		var version = i.readUInt16();
		var flags = i.readUInt16();
		var utf8 = (flags & 2048) != 0;
		var compression = i.readUInt16();
		var compressed = compression != 0;
		if(compressed && compression != 8) {
			throw new js__$Boot_HaxeError("Unsupported compression " + compression);
		}
		var mtime = this.readZipDate();
		var crc32 = i.readInt32();
		var csize = i.readInt32();
		var usize = i.readInt32();
		var fnamelen = i.readInt16();
		var elen = i.readInt16();
		var fname = i.readString(fnamelen);
		var fields = this.readExtraFields(elen);
		if(utf8) {
			fields.push(haxe_zip_ExtraField.FUtf8);
		}
		var data = null;
		if((flags & 8) != 0) {
			csize = -1;
		}
		return { fileName : fname, fileSize : usize, fileTime : mtime, compressed : compressed, dataSize : csize, data : data, crc32 : crc32, extraFields : fields};
	}
	,read: function() {
		var l = new List();
		var buf = null;
		var tmp = null;
		while(true) {
			var e = this.readEntryHeader();
			if(e == null) {
				break;
			}
			if(e.dataSize < 0) {
				var bufSize = 65536;
				if(tmp == null) {
					tmp = new haxe_io_Bytes(new ArrayBuffer(bufSize));
				}
				var out = new haxe_io_BytesBuffer();
				var z = new haxe_zip_InflateImpl(this.i,false,false);
				while(true) {
					var n = z.readBytes(tmp,0,bufSize);
					if(n < 0 || n > tmp.length) {
						throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
					}
					var b1 = out.b;
					var b2 = tmp.b;
					var _g1 = 0;
					var _g = n;
					while(_g1 < _g) {
						var i = _g1++;
						out.b.push(b2[i]);
					}
					if(n < bufSize) {
						break;
					}
				}
				e.data = out.getBytes();
				e.crc32 = this.i.readInt32();
				if(e.crc32 == 134695760) {
					e.crc32 = this.i.readInt32();
				}
				e.dataSize = this.i.readInt32();
				e.fileSize = this.i.readInt32();
				e.dataSize = e.fileSize;
				e.compressed = false;
			} else {
				e.data = this.i.read(e.dataSize);
			}
			l.add(e);
		}
		return l;
	}
	,__class__: haxe_zip_Reader
};
var js__$Boot_HaxeError = function(val) {
	Error.call(this);
	this.val = val;
	this.message = String(val);
	if(Error.captureStackTrace) {
		Error.captureStackTrace(this,js__$Boot_HaxeError);
	}
};
$hxClasses["js._Boot.HaxeError"] = js__$Boot_HaxeError;
js__$Boot_HaxeError.__name__ = ["js","_Boot","HaxeError"];
js__$Boot_HaxeError.wrap = function(val) {
	if((val instanceof Error)) {
		return val;
	} else {
		return new js__$Boot_HaxeError(val);
	}
};
js__$Boot_HaxeError.__super__ = Error;
js__$Boot_HaxeError.prototype = $extend(Error.prototype,{
	__class__: js__$Boot_HaxeError
});
var js_Boot = function() { };
$hxClasses["js.Boot"] = js_Boot;
js_Boot.__name__ = ["js","Boot"];
js_Boot.__unhtml = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
};
js_Boot.__trace = function(v,i) {
	var msg = i != null ? i.fileName + ":" + i.lineNumber + ": " : "";
	msg += js_Boot.__string_rec(v,"");
	if(i != null && i.customParams != null) {
		var _g = 0;
		var _g1 = i.customParams;
		while(_g < _g1.length) {
			var v1 = _g1[_g];
			++_g;
			msg += "," + js_Boot.__string_rec(v1,"");
		}
	}
	var d;
	var tmp;
	if(typeof(document) != "undefined") {
		d = document.getElementById("haxe:trace");
		tmp = d != null;
	} else {
		tmp = false;
	}
	if(tmp) {
		d.innerHTML += js_Boot.__unhtml(msg) + "<br/>";
	} else if(typeof console != "undefined" && console.log != null) {
		console.log(msg);
	}
};
js_Boot.getClass = function(o) {
	if((o instanceof Array) && o.__enum__ == null) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) {
					return o[0];
				}
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2;
				var _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) {
						str += "," + js_Boot.__string_rec(o[i],s);
					} else {
						str += js_Boot.__string_rec(o[i],s);
					}
				}
				return str + ")";
			}
			var l = o.length;
			var i1;
			var str1 = "[";
			s += "\t";
			var _g11 = 0;
			var _g2 = l;
			while(_g11 < _g2) {
				var i2 = _g11++;
				str1 += (i2 > 0 ? "," : "") + js_Boot.__string_rec(o[i2],s);
			}
			str1 += "]";
			return str1;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			haxe_CallStack.lastException = e;
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var k = null;
		var str2 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str2.length != 2) {
			str2 += ", \n";
		}
		str2 += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str2 += "\n" + s + "}";
		return str2;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0;
		var _g = intf.length;
		while(_g1 < _g) {
			var i = _g1++;
			var i1 = intf[i];
			if(i1 == cl || js_Boot.__interfLoop(i1,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		if((o instanceof Array)) {
			return o.__enum__ == null;
		} else {
			return false;
		}
		break;
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return true;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return (o|0) === o;
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(o instanceof cl) {
					return true;
				}
				if(js_Boot.__interfLoop(js_Boot.getClass(o),cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(o instanceof cl) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class ? o.__name__ != null : false) {
			return true;
		}
		if(cl == Enum ? o.__ename__ != null : false) {
			return true;
		}
		return o.__enum__ == cl;
	}
};
js_Boot.__cast = function(o,t) {
	if(js_Boot.__instanceof(o,t)) {
		return o;
	} else {
		throw new js__$Boot_HaxeError("Cannot cast " + Std.string(o) + " to " + Std.string(t));
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var js_Browser = function() { };
$hxClasses["js.Browser"] = js_Browser;
js_Browser.__name__ = ["js","Browser"];
js_Browser.getLocalStorage = function() {
	try {
		var s = window.localStorage;
		s.getItem("");
		return s;
	} catch( e ) {
		haxe_CallStack.lastException = e;
		return null;
	}
};
js_Browser.alert = function(v) {
	window.alert(js_Boot.__string_rec(v,""));
};
var js_Cookie = function() { };
$hxClasses["js.Cookie"] = js_Cookie;
js_Cookie.__name__ = ["js","Cookie"];
js_Cookie.set = function(name,value,expireDelay,path,domain) {
	var s = name + "=" + encodeURIComponent(value);
	if(expireDelay != null) {
		var t = new Date().getTime() + expireDelay * 1000;
		var d = new Date(t);
		s += ";expires=" + d.toGMTString();
	}
	if(path != null) {
		s += ";path=" + path;
	}
	if(domain != null) {
		s += ";domain=" + domain;
	}
	window.document.cookie = s;
};
js_Cookie.all = function() {
	var h = new haxe_ds_StringMap();
	var a = window.document.cookie.split(";");
	var _g = 0;
	while(_g < a.length) {
		var e = a[_g];
		++_g;
		e = StringTools.ltrim(e);
		var t = e.split("=");
		if(t.length < 2) {
			continue;
		}
		var key = t[0];
		var value = decodeURIComponent(t[1].split("+").join(" "));
		if(__map_reserved[key] != null) {
			h.setReserved(key,value);
		} else {
			h.h[key] = value;
		}
	}
	return h;
};
js_Cookie.get = function(name) {
	var _this = js_Cookie.all();
	if(__map_reserved[name] != null) {
		return _this.getReserved(name);
	} else {
		return _this.h[name];
	}
};
var js_html__$CanvasElement_CanvasUtil = function() { };
$hxClasses["js.html._CanvasElement.CanvasUtil"] = js_html__$CanvasElement_CanvasUtil;
js_html__$CanvasElement_CanvasUtil.__name__ = ["js","html","_CanvasElement","CanvasUtil"];
js_html__$CanvasElement_CanvasUtil.getContextWebGL = function(canvas,attribs) {
	var _g = 0;
	var _g1 = ["webgl","experimental-webgl"];
	while(_g < _g1.length) {
		var name = _g1[_g];
		++_g;
		var ctx = canvas.getContext(name,attribs);
		if(ctx != null) {
			return ctx;
		}
	}
	return null;
};
var js_html_compat_ArrayBuffer = function(a) {
	if((a instanceof Array) && a.__enum__ == null) {
		this.a = a;
		this.byteLength = a.length;
	} else {
		var len = a;
		this.a = [];
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) {
			var i = _g1++;
			this.a[i] = 0;
		}
		this.byteLength = len;
	}
};
$hxClasses["js.html.compat.ArrayBuffer"] = js_html_compat_ArrayBuffer;
js_html_compat_ArrayBuffer.__name__ = ["js","html","compat","ArrayBuffer"];
js_html_compat_ArrayBuffer.sliceImpl = function(begin,end) {
	var u = new Uint8Array(this,begin,end == null ? null : end - begin);
	var result = new ArrayBuffer(u.byteLength);
	var resultArray = new Uint8Array(result);
	resultArray.set(u);
	return result;
};
js_html_compat_ArrayBuffer.prototype = {
	slice: function(begin,end) {
		return new js_html_compat_ArrayBuffer(this.a.slice(begin,end));
	}
	,__class__: js_html_compat_ArrayBuffer
};
var js_html_compat_DataView = function(buffer,byteOffset,byteLength) {
	this.buf = buffer;
	this.offset = byteOffset == null ? 0 : byteOffset;
	this.length = byteLength == null ? buffer.byteLength - this.offset : byteLength;
	if(this.offset < 0 || this.length < 0 || this.offset + this.length > buffer.byteLength) {
		throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
	}
	this.byteLength = this.length;
	this.byteOffset = this.offset;
	this.buffer = this.buf;
};
$hxClasses["js.html.compat.DataView"] = js_html_compat_DataView;
js_html_compat_DataView.__name__ = ["js","html","compat","DataView"];
js_html_compat_DataView.prototype = {
	getInt8: function(byteOffset) {
		var v = this.buf.a[this.offset + byteOffset];
		if(v >= 128) {
			return v - 256;
		} else {
			return v;
		}
	}
	,getUint8: function(byteOffset) {
		return this.buf.a[this.offset + byteOffset];
	}
	,getInt16: function(byteOffset,littleEndian) {
		var v = this.getUint16(byteOffset,littleEndian);
		if(v >= 32768) {
			return v - 65536;
		} else {
			return v;
		}
	}
	,getUint16: function(byteOffset,littleEndian) {
		if(littleEndian) {
			return this.buf.a[this.offset + byteOffset] | this.buf.a[this.offset + byteOffset + 1] << 8;
		} else {
			return this.buf.a[this.offset + byteOffset] << 8 | this.buf.a[this.offset + byteOffset + 1];
		}
	}
	,getInt32: function(byteOffset,littleEndian) {
		var p = this.offset + byteOffset;
		var a = this.buf.a[p++];
		var b = this.buf.a[p++];
		var c = this.buf.a[p++];
		var d = this.buf.a[p++];
		if(littleEndian) {
			return a | b << 8 | c << 16 | d << 24;
		} else {
			return d | c << 8 | b << 16 | a << 24;
		}
	}
	,getUint32: function(byteOffset,littleEndian) {
		var v = this.getInt32(byteOffset,littleEndian);
		if(v < 0) {
			return v + 4294967296.;
		} else {
			return v;
		}
	}
	,getFloat32: function(byteOffset,littleEndian) {
		return haxe_io_FPHelper.i32ToFloat(this.getInt32(byteOffset,littleEndian));
	}
	,getFloat64: function(byteOffset,littleEndian) {
		var a = this.getInt32(byteOffset,littleEndian);
		var b = this.getInt32(byteOffset + 4,littleEndian);
		return haxe_io_FPHelper.i64ToDouble(littleEndian ? a : b,littleEndian ? b : a);
	}
	,setInt8: function(byteOffset,value) {
		this.buf.a[byteOffset + this.offset] = value < 0 ? value + 128 & 255 : value & 255;
	}
	,setUint8: function(byteOffset,value) {
		this.buf.a[byteOffset + this.offset] = value & 255;
	}
	,setInt16: function(byteOffset,value,littleEndian) {
		this.setUint16(byteOffset,value < 0 ? value + 65536 : value,littleEndian);
	}
	,setUint16: function(byteOffset,value,littleEndian) {
		var p = byteOffset + this.offset;
		if(littleEndian) {
			this.buf.a[p] = value & 255;
			this.buf.a[p++] = value >> 8 & 255;
		} else {
			this.buf.a[p++] = value >> 8 & 255;
			this.buf.a[p] = value & 255;
		}
	}
	,setInt32: function(byteOffset,value,littleEndian) {
		this.setUint32(byteOffset,value,littleEndian);
	}
	,setUint32: function(byteOffset,value,littleEndian) {
		var p = byteOffset + this.offset;
		if(littleEndian) {
			this.buf.a[p++] = value & 255;
			this.buf.a[p++] = value >> 8 & 255;
			this.buf.a[p++] = value >> 16 & 255;
			this.buf.a[p++] = value >>> 24;
		} else {
			this.buf.a[p++] = value >>> 24;
			this.buf.a[p++] = value >> 16 & 255;
			this.buf.a[p++] = value >> 8 & 255;
			this.buf.a[p++] = value & 255;
		}
	}
	,setFloat32: function(byteOffset,value,littleEndian) {
		this.setUint32(byteOffset,haxe_io_FPHelper.floatToI32(value),littleEndian);
	}
	,setFloat64: function(byteOffset,value,littleEndian) {
		var i64 = haxe_io_FPHelper.doubleToI64(value);
		if(littleEndian) {
			this.setUint32(byteOffset,i64.low);
			this.setUint32(byteOffset,i64.high);
		} else {
			this.setUint32(byteOffset,i64.high);
			this.setUint32(byteOffset,i64.low);
		}
	}
	,__class__: js_html_compat_DataView
};
var js_html_compat_Float32Array = function() { };
$hxClasses["js.html.compat.Float32Array"] = js_html_compat_Float32Array;
js_html_compat_Float32Array.__name__ = ["js","html","compat","Float32Array"];
js_html_compat_Float32Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		var _g2 = [];
		var _g21 = 0;
		var _g11 = arr.length << 2;
		while(_g21 < _g11) {
			var i1 = _g21++;
			_g2.push(0);
		}
		arr.buffer = new js_html_compat_ArrayBuffer(_g2);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset >> 2;
		}
		arr = [];
		var _g12 = 0;
		var _g3 = length;
		while(_g12 < _g3) {
			var i2 = _g12++;
			var val = buffer.a[offset++] | buffer.a[offset++] << 8 | buffer.a[offset++] << 16 | buffer.a[offset++] << 24;
			arr.push(haxe_io_FPHelper.i32ToFloat(val));
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		var buffer1 = [];
		var _g4 = 0;
		while(_g4 < arr.length) {
			var f = arr[_g4];
			++_g4;
			var i3 = haxe_io_FPHelper.floatToI32(f);
			buffer1.push(i3 & 255);
			buffer1.push(i3 >> 8 & 255);
			buffer1.push(i3 >> 16 & 255);
			buffer1.push(i3 >>> 24);
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(buffer1);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Float32Array._subarray;
	arr.set = js_html_compat_Float32Array._set;
	return arr;
};
js_html_compat_Float32Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Float32Array._subarray = function(start,end) {
	var a = js_html_compat_Float32Array._new(this.slice(start,end));
	a.byteOffset = start * 4;
	return a;
};
var js_html_compat_Float64Array = function() { };
$hxClasses["js.html.compat.Float64Array"] = js_html_compat_Float64Array;
js_html_compat_Float64Array.__name__ = ["js","html","compat","Float64Array"];
js_html_compat_Float64Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length << 3;
		arr.byteOffset = 0;
		var _g2 = [];
		var _g21 = 0;
		var _g11 = arr.length << 3;
		while(_g21 < _g11) {
			var i1 = _g21++;
			_g2.push(0);
		}
		arr.buffer = new js_html_compat_ArrayBuffer(_g2);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset >> 3;
		}
		arr = [];
		var _g12 = 0;
		var _g3 = length;
		while(_g12 < _g3) {
			var i2 = _g12++;
			var val1 = buffer.a[offset++] | buffer.a[offset++] << 8 | buffer.a[offset++] << 16 | buffer.a[offset++] << 24;
			var val2 = buffer.a[offset++] | buffer.a[offset++] << 8 | buffer.a[offset++] << 16 | buffer.a[offset++] << 24;
			arr.push(haxe_io_FPHelper.i64ToDouble(val1,val2));
		}
		arr.byteLength = arr.length << 3;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		var buffer1 = [];
		var _g4 = 0;
		while(_g4 < arr.length) {
			var f = arr[_g4];
			++_g4;
			var v = haxe_io_FPHelper.doubleToI64(f);
			var i3 = v.low;
			buffer1.push(i3 & 255);
			buffer1.push(i3 >> 8 & 255);
			buffer1.push(i3 >> 16 & 255);
			buffer1.push(i3 >>> 24);
			var i4 = v.high;
			buffer1.push(i4 & 255);
			buffer1.push(i4 >> 8 & 255);
			buffer1.push(i4 >> 16 & 255);
			buffer1.push(i4 >>> 24);
		}
		arr.byteLength = arr.length << 3;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(buffer1);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Float64Array._subarray;
	arr.set = js_html_compat_Float64Array._set;
	return arr;
};
js_html_compat_Float64Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Float64Array._subarray = function(start,end) {
	var a = js_html_compat_Float64Array._new(this.slice(start,end));
	a.byteOffset = start * 8;
	return a;
};
var js_html_compat_Uint8Array = function() { };
$hxClasses["js.html.compat.Uint8Array"] = js_html_compat_Uint8Array;
js_html_compat_Uint8Array.__name__ = ["js","html","compat","Uint8Array"];
js_html_compat_Uint8Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset;
		}
		if(offset == 0) {
			arr = buffer.a;
		} else {
			arr = buffer.a.slice(offset,offset + length);
		}
		arr.byteLength = arr.length;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Uint8Array._subarray;
	arr.set = js_html_compat_Uint8Array._set;
	return arr;
};
js_html_compat_Uint8Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Uint8Array._subarray = function(start,end) {
	var a = js_html_compat_Uint8Array._new(this.slice(start,end));
	a.byteOffset = start;
	return a;
};
var lime__$internal_backend_html5_GameDeviceData = function() {
	this.connected = true;
	this.buttons = [];
	this.axes = [];
};
$hxClasses["lime._internal.backend.html5.GameDeviceData"] = lime__$internal_backend_html5_GameDeviceData;
lime__$internal_backend_html5_GameDeviceData.__name__ = ["lime","_internal","backend","html5","GameDeviceData"];
lime__$internal_backend_html5_GameDeviceData.prototype = {
	__class__: lime__$internal_backend_html5_GameDeviceData
};
var lime__$internal_backend_html5_HTML5AudioSource = function(parent) {
	this.parent = parent;
	this.id = -1;
	this.gain = 1;
	this.position = new lime_math_Vector4();
};
$hxClasses["lime._internal.backend.html5.HTML5AudioSource"] = lime__$internal_backend_html5_HTML5AudioSource;
lime__$internal_backend_html5_HTML5AudioSource.__name__ = ["lime","_internal","backend","html5","HTML5AudioSource"];
lime__$internal_backend_html5_HTML5AudioSource.prototype = {
	dispose: function() {
	}
	,init: function() {
	}
	,play: function() {
		if(this.playing || this.parent.buffer == null || this.parent.buffer.__srcHowl == null) {
			return;
		}
		this.playing = true;
		var time = this.getCurrentTime();
		this.completed = false;
		var cacheVolume = this.parent.buffer.__srcHowl._volume;
		this.parent.buffer.__srcHowl._volume = this.parent.get_gain();
		this.id = this.parent.buffer.__srcHowl.play();
		this.parent.buffer.__srcHowl._volume = cacheVolume;
		this.setPosition(this.parent.get_position());
		this.parent.buffer.__srcHowl.on("end",$bind(this,this.howl_onEnd),this.id);
		this.setCurrentTime(time);
	}
	,pause: function() {
		this.playing = false;
		if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			this.parent.buffer.__srcHowl.pause(this.id);
		}
	}
	,stop: function() {
		this.playing = false;
		if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			this.parent.buffer.__srcHowl.stop(this.id);
			this.parent.buffer.__srcHowl.off("end",$bind(this,this.howl_onEnd),this.id);
		}
	}
	,howl_onEnd: function() {
		this.playing = false;
		if(this.loops > 0) {
			this.loops--;
			this.stop();
			this.play();
			return;
		} else if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			this.parent.buffer.__srcHowl.stop(this.id);
			this.parent.buffer.__srcHowl.off("end",$bind(this,this.howl_onEnd),this.id);
		}
		this.completed = true;
		this.parent.onComplete.dispatch();
	}
	,getCurrentTime: function() {
		if(this.id == -1) {
			return 0;
		}
		if(this.completed) {
			return this.getLength();
		} else if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			var time = (this.parent.buffer.__srcHowl.seek(this.id) * 1000 | 0) - this.parent.offset;
			if(time < 0) {
				return 0;
			}
			return time;
		}
		return 0;
	}
	,setCurrentTime: function(value) {
		if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			var pos = (value + this.parent.offset) / 1000;
			if(pos < 0) {
				pos = 0;
			}
			this.parent.buffer.__srcHowl.seek(pos,this.id);
		}
		return value;
	}
	,getGain: function() {
		return this.gain;
	}
	,setGain: function(value) {
		if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null && this.id != -1) {
			this.parent.buffer.__srcHowl.volume(value,this.id);
		}
		return this.gain = value;
	}
	,getLength: function() {
		if(this.length != 0) {
			return this.length;
		}
		if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			return this.parent.buffer.__srcHowl.duration() * 1000 | 0;
		}
		return 0;
	}
	,setLength: function(value) {
		return this.length = value;
	}
	,getLoops: function() {
		return this.loops;
	}
	,setLoops: function(value) {
		return this.loops = value;
	}
	,getPosition: function() {
		return this.position;
	}
	,setPosition: function(value) {
		this.position.x = value.x;
		this.position.y = value.y;
		this.position.z = value.z;
		this.position.w = value.w;
		if(this.parent.buffer.__srcHowl != null && ($_=this.parent.buffer.__srcHowl,$bind($_,$_.pos)) != null) {
			this.parent.buffer.__srcHowl.pos(this.position.x,this.position.y,this.position.z,this.id);
		}
		return this.position;
	}
	,__class__: lime__$internal_backend_html5_HTML5AudioSource
};
var lime__$internal_backend_html5_HTML5HTTPRequest = function() {
	this.validStatus0 = new EReg("Tizen","gi").match(window.navigator.userAgent);
};
$hxClasses["lime._internal.backend.html5.HTML5HTTPRequest"] = lime__$internal_backend_html5_HTML5HTTPRequest;
lime__$internal_backend_html5_HTML5HTTPRequest.__name__ = ["lime","_internal","backend","html5","HTML5HTTPRequest"];
lime__$internal_backend_html5_HTML5HTTPRequest.loadImage = function(uri) {
	var promise = new lime_app_Promise();
	if(lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests < lime__$internal_backend_html5_HTML5HTTPRequest.requestLimit) {
		lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests++;
		lime__$internal_backend_html5_HTML5HTTPRequest.__loadImage(uri,promise,0);
	} else {
		lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.add({ instance : null, uri : uri, promise : promise, type : "IMAGE", options : 0});
	}
	return promise.future;
};
lime__$internal_backend_html5_HTML5HTTPRequest.loadImageFromBytes = function(bytes,type) {
	var uri = URL.createObjectURL(new Blob([bytes.b.bufferValue],{ type : type}));
	if(uri != null) {
		var promise = new lime_app_Promise();
		if(lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests < lime__$internal_backend_html5_HTML5HTTPRequest.requestLimit) {
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests++;
			lime__$internal_backend_html5_HTML5HTTPRequest.__loadImage(uri,promise,1);
		} else {
			lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.add({ instance : null, uri : uri, promise : promise, type : "IMAGE", options : 1});
		}
		return promise.future;
	} else {
		return lime__$internal_backend_html5_HTML5HTTPRequest.loadImage("data:" + type + ";base64," + lime__$internal_format_Base64.encode(bytes));
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.processQueue = function() {
	if(lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests < lime__$internal_backend_html5_HTML5HTTPRequest.requestLimit && lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.length > 0) {
		lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests++;
		var queueItem = lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.pop();
		var _g = queueItem.type;
		switch(_g) {
		case "BINARY":
			queueItem.instance.__loadData(queueItem.uri,queueItem.promise);
			break;
		case "IMAGE":
			lime__$internal_backend_html5_HTML5HTTPRequest.__loadImage(queueItem.uri,queueItem.promise,queueItem.options);
			break;
		case "TEXT":
			queueItem.instance.__loadText(queueItem.uri,queueItem.promise);
			break;
		default:
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
		}
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__createBlobURIFromBytes = function(bytes,type) {
	return URL.createObjectURL(new Blob([bytes.b.bufferValue],{ type : type}));
};
lime__$internal_backend_html5_HTML5HTTPRequest.__fixHostname = function(hostname) {
	if(hostname == null) {
		return "";
	} else {
		return hostname;
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__fixPort = function(port,protocol) {
	if(port == null || port == "") {
		switch(protocol) {
		case "ftp:":
			return "21";
		case "gopher:":
			return "70";
		case "http:":
			return "80";
		case "https:":
			return "443";
		case "ws:":
			return "80";
		case "wss:":
			return "443";
		default:
			return "";
		}
	}
	return port;
};
lime__$internal_backend_html5_HTML5HTTPRequest.__fixProtocol = function(protocol) {
	if(protocol == null || protocol == "") {
		return "http:";
	} else {
		return protocol;
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__isInMemoryURI = function(uri) {
	if(!StringTools.startsWith(uri,"data:")) {
		return StringTools.startsWith(uri,"blob:");
	} else {
		return true;
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__isSameOrigin = function(path) {
	if(path == null || path == "") {
		return true;
	}
	if(lime__$internal_backend_html5_HTML5HTTPRequest.__isInMemoryURI(path)) {
		return true;
	}
	if(lime__$internal_backend_html5_HTML5HTTPRequest.originElement == null) {
		lime__$internal_backend_html5_HTML5HTTPRequest.originElement = window.document.createElement("a");
		lime__$internal_backend_html5_HTML5HTTPRequest.originHostname = lime__$internal_backend_html5_HTML5HTTPRequest.__fixHostname(window.location.hostname);
		lime__$internal_backend_html5_HTML5HTTPRequest.originProtocol = lime__$internal_backend_html5_HTML5HTTPRequest.__fixProtocol(window.location.protocol);
		lime__$internal_backend_html5_HTML5HTTPRequest.originPort = lime__$internal_backend_html5_HTML5HTTPRequest.__fixPort(window.location.port,lime__$internal_backend_html5_HTML5HTTPRequest.originProtocol);
	}
	var a = lime__$internal_backend_html5_HTML5HTTPRequest.originElement;
	a.href = path;
	if(a.hostname == "") {
		a.href = a.href;
	}
	var hostname = lime__$internal_backend_html5_HTML5HTTPRequest.__fixHostname(a.hostname);
	var protocol = lime__$internal_backend_html5_HTML5HTTPRequest.__fixProtocol(a.protocol);
	var port = lime__$internal_backend_html5_HTML5HTTPRequest.__fixPort(a.port,protocol);
	var sameHost = hostname == "" || hostname == lime__$internal_backend_html5_HTML5HTTPRequest.originHostname;
	var samePort = port == "" || port == lime__$internal_backend_html5_HTML5HTTPRequest.originPort;
	if(protocol != "file:" && sameHost) {
		return samePort;
	} else {
		return false;
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__loadImage = function(uri,promise,options) {
	var image = new Image();
	if(!lime__$internal_backend_html5_HTML5HTTPRequest.__isSameOrigin(uri)) {
		image.crossOrigin = "Anonymous";
	}
	if(lime__$internal_backend_html5_HTML5HTTPRequest.supportsImageProgress == null) {
		lime__$internal_backend_html5_HTML5HTTPRequest.supportsImageProgress = 'onprogress' in image;
	}
	if(lime__$internal_backend_html5_HTML5HTTPRequest.supportsImageProgress || lime__$internal_backend_html5_HTML5HTTPRequest.__isInMemoryURI(uri)) {
		image.addEventListener("load",function(event) {
			lime__$internal_backend_html5_HTML5HTTPRequest.__revokeBlobURI(uri,options);
			var buffer = new lime_graphics_ImageBuffer(null,image.width,image.height);
			buffer.__srcImage = image;
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
			lime__$internal_backend_html5_HTML5HTTPRequest.processQueue();
			promise.complete(new lime_graphics_Image(buffer));
		},false);
		image.addEventListener("progress",function(event1) {
			promise.progress(event1.loaded,event1.total);
		},false);
		image.addEventListener("error",function(event2) {
			lime__$internal_backend_html5_HTML5HTTPRequest.__revokeBlobURI(uri,options);
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
			lime__$internal_backend_html5_HTML5HTTPRequest.processQueue();
			promise.error(event2.detail);
		},false);
		image.src = uri;
	} else {
		var request = new XMLHttpRequest();
		request.onload = function(_) {
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
			lime__$internal_backend_html5_HTML5HTTPRequest.processQueue();
			var img = new lime_graphics_Image();
			img.__fromBytes(haxe_io_Bytes.ofData(request.response),function(img1) {
				promise.complete(img1);
			});
		};
		request.onerror = function(event3) {
			promise.error(event3.message);
		};
		request.onprogress = function(event4) {
			if(event4.lengthComputable) {
				promise.progress(event4.loaded,event4.total);
			}
		};
		request.open("GET",uri,true);
		request.responseType = "arraybuffer";
		request.overrideMimeType("text/plain; charset=x-user-defined");
		request.send(null);
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__revokeBlobURI = function(uri,options) {
	if((options & 1) != 0) {
		URL.revokeObjectURL(uri);
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.prototype = {
	cancel: function() {
		if(this.request != null) {
			this.request.abort();
		}
	}
	,init: function(parent) {
		this.parent = parent;
	}
	,load: function(uri,progress,readyStateChange) {
		this.request = new XMLHttpRequest();
		if(this.parent.method == "POST") {
			this.request.upload.addEventListener("progress",progress,false);
		} else {
			this.request.addEventListener("progress",progress,false);
		}
		this.request.onreadystatechange = readyStateChange;
		var query = "";
		if(this.parent.data == null) {
			var key = this.parent.formData.keys();
			while(key.hasNext()) {
				var key1 = key.next();
				if(query.length > 0) {
					query += "&";
				}
				var _this = this.parent.formData;
				var value = __map_reserved[key1] != null ? _this.getReserved(key1) : _this.h[key1];
				if(key1.indexOf("[]") > -1 && ((value instanceof Array) && value.__enum__ == null)) {
					var arrayValue = Lambda.map(value,function(v) {
						return encodeURIComponent(v);
					}).join("&amp;" + key1 + "=");
					query += encodeURIComponent(key1) + "=" + arrayValue;
				} else {
					var query1 = encodeURIComponent(key1) + "=";
					var s = Std.string(value);
					query += query1 + encodeURIComponent(s);
				}
			}
			if(this.parent.method == "GET" && query != "") {
				if(uri.indexOf("?") > -1) {
					uri += "&" + query;
				} else {
					uri += "?" + query;
				}
				query = "";
			}
		}
		this.request.open(Std.string(this.parent.method),uri,true);
		if(this.parent.timeout > 0) {
			this.request.timeout = this.parent.timeout;
		}
		if(this.binary) {
			this.request.responseType = "arraybuffer";
		}
		var contentType = null;
		var _g = 0;
		var _g1 = this.parent.headers;
		while(_g < _g1.length) {
			var header = _g1[_g];
			++_g;
			if(header.name == "Content-Type") {
				contentType = header.value;
			} else {
				this.request.setRequestHeader(header.name,header.value);
			}
		}
		if(this.parent.contentType != null) {
			contentType = this.parent.contentType;
		}
		if(contentType == null) {
			if(this.parent.data != null) {
				contentType = "application/octet-stream";
			} else if(query != "") {
				contentType = "application/x-www-form-urlencoded";
			}
		}
		if(contentType != null) {
			this.request.setRequestHeader("Content-Type",contentType);
		}
		if(this.parent.withCredentials) {
			this.request.withCredentials = true;
		}
		if(this.parent.data != null) {
			this.request.send(this.parent.data.b.bufferValue);
		} else {
			this.request.send(query);
		}
	}
	,loadData: function(uri) {
		var promise = new lime_app_Promise();
		if(lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests < lime__$internal_backend_html5_HTML5HTTPRequest.requestLimit) {
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests++;
			this.__loadData(uri,promise);
		} else {
			lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.add({ instance : this, uri : uri, promise : promise, type : "BINARY", options : 0});
		}
		return promise.future;
	}
	,loadText: function(uri) {
		var promise = new lime_app_Promise();
		if(lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests < lime__$internal_backend_html5_HTML5HTTPRequest.requestLimit) {
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests++;
			this.__loadText(uri,promise);
		} else {
			lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.add({ instance : this, uri : uri, promise : promise, type : "TEXT", options : 0});
		}
		return promise.future;
	}
	,processResponse: function() {
		if(this.parent.enableResponseHeaders) {
			this.parent.responseHeaders = [];
			var name;
			var value;
			var _g = 0;
			var _g1 = this.request.getAllResponseHeaders().split("\n");
			while(_g < _g1.length) {
				var line = _g1[_g];
				++_g;
				name = StringTools.trim(HxOverrides.substr(line,0,line.indexOf(":")));
				value = StringTools.trim(HxOverrides.substr(line,line.indexOf(":") + 1,null));
				if(name != "") {
					this.parent.responseHeaders.push(new lime_net_HTTPRequestHeader(name,value));
				}
			}
		}
		this.parent.responseStatus = this.request.status;
	}
	,__loadData: function(uri,promise) {
		var _gthis = this;
		var progress = function(event) {
			promise.progress(event.loaded,event.total);
		};
		var readyStateChange = function(event1) {
			if(_gthis.request.readyState != 4) {
				return;
			}
			if(_gthis.request.status != null && (_gthis.request.status >= 200 && _gthis.request.status < 400 || _gthis.validStatus0 && _gthis.request.status == 0)) {
				var bytes = null;
				if(_gthis.request.responseType == "") {
					if(_gthis.request.responseText != null) {
						bytes = haxe_io_Bytes.ofString(_gthis.request.responseText);
					}
				} else if(_gthis.request.response != null) {
					bytes = haxe_io_Bytes.ofData(_gthis.request.response);
				}
				_gthis.processResponse();
				promise.complete(bytes);
			} else {
				_gthis.processResponse();
				promise.error(_gthis.request.status);
			}
			_gthis.request = null;
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
			lime__$internal_backend_html5_HTML5HTTPRequest.processQueue();
		};
		this.binary = true;
		this.load(uri,progress,readyStateChange);
	}
	,__loadText: function(uri,promise) {
		var _gthis = this;
		var progress = function(event) {
			promise.progress(event.loaded,event.total);
		};
		var readyStateChange = function(event1) {
			if(_gthis.request.readyState != 4) {
				return;
			}
			if(_gthis.request.status != null && (_gthis.request.status >= 200 && _gthis.request.status <= 400 || _gthis.validStatus0 && _gthis.request.status == 0)) {
				_gthis.processResponse();
				promise.complete(_gthis.request.responseText);
			} else {
				_gthis.processResponse();
				promise.error(_gthis.request.status);
			}
			_gthis.request = null;
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
			lime__$internal_backend_html5_HTML5HTTPRequest.processQueue();
		};
		this.binary = false;
		this.load(uri,progress,readyStateChange);
	}
	,__class__: lime__$internal_backend_html5_HTML5HTTPRequest
};
var lime__$internal_backend_html5_HTML5Window = function(parent) {
	this.inputing = false;
	this.unusedTouchesPool = new List();
	this.scale = 1.0;
	this.currentTouches = new haxe_ds_IntMap();
	this.parent = parent;
	this.cursor = lime_ui_MouseCursor.DEFAULT;
	this.cacheMouseX = 0;
	this.cacheMouseY = 0;
	var attributes = parent.__attributes;
	if(!Object.prototype.hasOwnProperty.call(attributes,"context")) {
		attributes.context = { };
	}
	this.renderType = attributes.context.type;
	if(Object.prototype.hasOwnProperty.call(attributes,"element")) {
		parent.element = attributes.element;
	}
	var element = parent.element;
	if(Object.prototype.hasOwnProperty.call(attributes,"allowHighDPI") && attributes.allowHighDPI && this.renderType != "dom") {
		this.scale = window.devicePixelRatio;
	}
	parent.__scale = this.scale;
	this.setWidth = Object.prototype.hasOwnProperty.call(attributes,"width") ? attributes.width : 0;
	this.setHeight = Object.prototype.hasOwnProperty.call(attributes,"height") ? attributes.height : 0;
	parent.__width = this.setWidth;
	parent.__height = this.setHeight;
	parent.id = lime__$internal_backend_html5_HTML5Window.windowID++;
	if(js_Boot.__instanceof(element,HTMLCanvasElement)) {
		this.canvas = element;
	} else if(this.renderType == "dom") {
		this.div = window.document.createElement("div");
	} else {
		this.canvas = window.document.createElement("canvas");
	}
	if(this.canvas != null) {
		var style = this.canvas.style;
		style.setProperty("-webkit-transform","translateZ(0)",null);
		style.setProperty("transform","translateZ(0)",null);
	} else if(this.div != null) {
		var style1 = this.div.style;
		style1.setProperty("-webkit-transform","translate3D(0,0,0)",null);
		style1.setProperty("transform","translate3D(0,0,0)",null);
		style1.position = "relative";
		style1.overflow = "hidden";
		style1.setProperty("-webkit-user-select","none",null);
		style1.setProperty("-moz-user-select","none",null);
		style1.setProperty("-ms-user-select","none",null);
		style1.setProperty("-o-user-select","none",null);
	}
	if(parent.__width == 0 && parent.__height == 0) {
		if(element != null) {
			parent.__width = element.clientWidth;
			parent.__height = element.clientHeight;
		} else {
			parent.__width = window.innerWidth;
			parent.__height = window.innerHeight;
		}
		this.cacheElementWidth = parent.__width;
		this.cacheElementHeight = parent.__height;
		this.resizeElement = true;
	}
	if(this.canvas != null) {
		this.canvas.width = Math.round(parent.__width * this.scale);
		this.canvas.height = Math.round(parent.__height * this.scale);
		this.canvas.style.width = parent.__width + "px";
		this.canvas.style.height = parent.__height + "px";
	} else {
		this.div.style.width = parent.__width + "px";
		this.div.style.height = parent.__height + "px";
	}
	if(Object.prototype.hasOwnProperty.call(attributes,"resizable") && attributes.resizable || !Object.prototype.hasOwnProperty.call(attributes,"width") && this.setWidth == 0 && this.setHeight == 0) {
		parent.__resizable = true;
	}
	this.updateSize();
	if(element != null) {
		if(this.canvas != null) {
			if(element != this.canvas) {
				element.appendChild(this.canvas);
			}
		} else {
			element.appendChild(this.div);
		}
		var events = ["mousedown","mouseenter","mouseleave","mousemove","mouseup","wheel"];
		var _g = 0;
		while(_g < events.length) {
			var event = events[_g];
			++_g;
			element.addEventListener(event,$bind(this,this.handleMouseEvent),true);
		}
		element.addEventListener("contextmenu",$bind(this,this.handleContextMenuEvent),true);
		element.addEventListener("dragstart",$bind(this,this.handleDragEvent),true);
		element.addEventListener("dragover",$bind(this,this.handleDragEvent),true);
		element.addEventListener("drop",$bind(this,this.handleDragEvent),true);
		element.addEventListener("touchstart",$bind(this,this.handleTouchEvent),true);
		element.addEventListener("touchmove",$bind(this,this.handleTouchEvent),true);
		element.addEventListener("touchend",$bind(this,this.handleTouchEvent),true);
		element.addEventListener("touchcancel",$bind(this,this.handleTouchEvent),true);
		element.addEventListener("gamepadconnected",$bind(this,this.handleGamepadEvent),true);
		element.addEventListener("gamepaddisconnected",$bind(this,this.handleGamepadEvent),true);
	}
	this.createContext();
	if(parent.context.type == "webgl") {
		this.canvas.addEventListener("webglcontextlost",$bind(this,this.handleContextEvent),false);
		this.canvas.addEventListener("webglcontextrestored",$bind(this,this.handleContextEvent),false);
	}
};
$hxClasses["lime._internal.backend.html5.HTML5Window"] = lime__$internal_backend_html5_HTML5Window;
lime__$internal_backend_html5_HTML5Window.__name__ = ["lime","_internal","backend","html5","HTML5Window"];
lime__$internal_backend_html5_HTML5Window.prototype = {
	alert: function(message,title) {
		if(message != null) {
			js_Browser.alert(message);
		}
	}
	,close: function() {
		this.parent.application.__removeWindow(this.parent);
	}
	,createContext: function() {
		var context = new lime_graphics_RenderContext();
		var contextAttributes = this.parent.__attributes.context;
		context.window = this.parent;
		context.attributes = contextAttributes;
		if(this.div != null) {
			context.dom = this.div;
			context.type = "dom";
			context.version = "";
		} else if(this.canvas != null) {
			var webgl = null;
			var forceCanvas = this.renderType == "canvas";
			var forceWebGL = this.renderType == "opengl" || this.renderType == "opengles" || this.renderType == "webgl";
			var allowWebGL2 = !Object.prototype.hasOwnProperty.call(contextAttributes,"version") || contextAttributes.version != "1";
			var isWebGL2 = false;
			if(forceWebGL || !forceCanvas && (!Object.prototype.hasOwnProperty.call(contextAttributes,"hardware") || contextAttributes.hardware)) {
				var transparentBackground = Object.prototype.hasOwnProperty.call(contextAttributes,"background") && contextAttributes.background == null;
				var colorDepth = Object.prototype.hasOwnProperty.call(contextAttributes,"colorDepth") ? contextAttributes.colorDepth : 16;
				var options = Object.prototype.hasOwnProperty.call(contextAttributes,"antialiasing") && contextAttributes.antialiasing > 0;
				var options1 = { alpha : transparentBackground || colorDepth > 16, antialias : options, depth : Object.prototype.hasOwnProperty.call(contextAttributes,"depth") ? contextAttributes.depth : true, premultipliedAlpha : true, stencil : Object.prototype.hasOwnProperty.call(contextAttributes,"stencil") && contextAttributes.stencil, preserveDrawingBuffer : false, failIfMajorPerformanceCaveat : false};
				var glContextType = ["webgl","experimental-webgl"];
				if(allowWebGL2) {
					glContextType.unshift("webgl2");
				}
				var _g = 0;
				while(_g < glContextType.length) {
					var name = glContextType[_g];
					++_g;
					webgl = this.canvas.getContext(name,options1);
					if(webgl != null && name == "webgl2") {
						isWebGL2 = true;
					}
					if(webgl != null) {
						break;
					}
				}
			}
			if(webgl == null) {
				context.canvas2D = this.canvas.getContext("2d");
				context.type = "canvas";
				context.version = "";
			} else {
				context.webgl = lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.fromWebGL2RenderContext(webgl);
				if(isWebGL2) {
					context.webgl2 = webgl;
				}
				if(lime_graphics_opengl_GL.context == null) {
					lime_graphics_opengl_GL.context = webgl;
					lime_graphics_opengl_GL.type = "webgl";
					lime_graphics_opengl_GL.version = isWebGL2 ? 2 : 1;
				}
				context.type = "webgl";
				context.version = isWebGL2 ? "2" : "1";
			}
		}
		this.parent.context = context;
	}
	,focus: function() {
	}
	,getCursor: function() {
		return this.cursor;
	}
	,getDisplay: function() {
		return lime_system_System.getDisplay(0);
	}
	,getDisplayMode: function() {
		return lime_system_System.getDisplay(0).currentMode;
	}
	,getFrameRate: function() {
		if(this.parent.application == null) {
			return 0;
		}
		if(this.parent.application.__backend.framePeriod < 0) {
			return 60;
		} else if(this.parent.application.__backend.framePeriod == 1000) {
			return 0;
		} else {
			return 1000 / this.parent.application.__backend.framePeriod;
		}
	}
	,getMouseLock: function() {
		return false;
	}
	,getTextInputEnabled: function() {
		return this.textInputEnabled;
	}
	,handleContextEvent: function(event) {
		var _g = event.type;
		switch(_g) {
		case "webglcontextlost":
			if(event.cancelable) {
				event.preventDefault();
			}
			var tmp = lime_graphics_opengl_GL.context != null;
			this.parent.context = null;
			this.parent.onRenderContextLost.dispatch();
			break;
		case "webglcontextrestored":
			this.createContext();
			this.parent.onRenderContextRestored.dispatch(this.parent.context);
			break;
		default:
		}
	}
	,handleContextMenuEvent: function(event) {
		if((this.parent.onMouseUp.canceled || this.parent.onMouseDown.canceled) && event.cancelable) {
			event.preventDefault();
		}
	}
	,handleCutOrCopyEvent: function(event) {
		event.clipboardData.setData("text/plain",lime_system_Clipboard.get_text());
		if(event.cancelable) {
			event.preventDefault();
		}
	}
	,handleDragEvent: function(event) {
		var _g = event.type;
		switch(_g) {
		case "dragover":
			event.preventDefault();
			return false;
		case "dragstart":
			if((js_Boot.__cast(event.target , HTMLElement)).nodeName.toLowerCase() == "img" && event.cancelable) {
				event.preventDefault();
				return false;
			}
			break;
		case "drop":
			if(event.dataTransfer != null && event.dataTransfer.files.length > 0) {
				this.parent.onDropFile.dispatch(event.dataTransfer.files);
				event.preventDefault();
				return false;
			}
			break;
		}
		return true;
	}
	,handleFocusEvent: function(event) {
		var _gthis = this;
		if(this.textInputEnabled) {
			if(event.relatedTarget == null || this.isDescendent(event.relatedTarget)) {
				haxe_Timer.delay(function() {
					if(_gthis.textInputEnabled) {
						lime__$internal_backend_html5_HTML5Window.textInput.focus();
					}
				},20);
			}
		}
	}
	,handleFullscreenEvent: function(event) {
		var fullscreenElement = document.fullscreenElement || document.mozFullScreenElement || document.webkitFullscreenElement || document.msFullscreenElement;
		if(fullscreenElement != null) {
			this.isFullscreen = true;
			this.parent.__fullscreen = true;
			if(this.requestedFullscreen) {
				this.requestedFullscreen = false;
				this.parent.onFullscreen.dispatch();
			}
		} else {
			this.isFullscreen = false;
			this.parent.__fullscreen = false;
			this.parent.onRestore.dispatch();
			var changeEvents = ["fullscreenchange","mozfullscreenchange","webkitfullscreenchange","MSFullscreenChange"];
			var errorEvents = ["fullscreenerror","mozfullscreenerror","webkitfullscreenerror","MSFullscreenError"];
			var _g1 = 0;
			var _g = changeEvents.length;
			while(_g1 < _g) {
				var i = _g1++;
				window.document.removeEventListener(changeEvents[i],$bind(this,this.handleFullscreenEvent),false);
				window.document.removeEventListener(errorEvents[i],$bind(this,this.handleFullscreenEvent),false);
			}
		}
	}
	,handleGamepadEvent: function(event) {
		var _g = event.type;
		switch(_g) {
		case "gamepadconnected":
			lime_ui_Joystick.__connect(event.gamepad.index);
			if(event.gamepad.mapping == "standard") {
				lime_ui_Gamepad.__connect(event.gamepad.index);
			}
			break;
		case "gamepaddisconnected":
			lime_ui_Joystick.__disconnect(event.gamepad.index);
			lime_ui_Gamepad.__disconnect(event.gamepad.index);
			break;
		default:
		}
	}
	,handleInputEvent: function(event) {
		if(this.inputing) {
			return;
		}
		if(lime__$internal_backend_html5_HTML5Window.textInput.value != lime__$internal_backend_html5_HTML5Window.dummyCharacter) {
			var value = StringTools.replace(lime__$internal_backend_html5_HTML5Window.textInput.value,lime__$internal_backend_html5_HTML5Window.dummyCharacter,"");
			if(value.length > 0) {
				this.parent.onTextInput.dispatch(value);
			}
			lime__$internal_backend_html5_HTML5Window.textInput.value = lime__$internal_backend_html5_HTML5Window.dummyCharacter;
		}
	}
	,handleMouseEvent: function(event) {
		var x = 0.0;
		var y = 0.0;
		if(event.type != "wheel") {
			if(this.parent.element != null) {
				if(this.canvas != null) {
					var rect = this.canvas.getBoundingClientRect();
					x = (event.clientX - rect.left) * (this.parent.__width / rect.width);
					y = (event.clientY - rect.top) * (this.parent.__height / rect.height);
				} else if(this.div != null) {
					var rect1 = this.div.getBoundingClientRect();
					x = event.clientX - rect1.left;
					y = event.clientY - rect1.top;
				} else {
					var rect2 = this.parent.element.getBoundingClientRect();
					x = (event.clientX - rect2.left) * (this.parent.__width / rect2.width);
					y = (event.clientY - rect2.top) * (this.parent.__height / rect2.height);
				}
			} else {
				x = event.clientX;
				y = event.clientY;
			}
			var _g = event.type;
			switch(_g) {
			case "mousedown":
				if(event.currentTarget == this.parent.element) {
					window.addEventListener("mouseup",$bind(this,this.handleMouseEvent));
				}
				this.parent.onMouseDown.dispatch(x,y,event.button);
				if(this.parent.onMouseDown.canceled && event.cancelable) {
					event.preventDefault();
				}
				break;
			case "mouseenter":
				if(event.target == this.parent.element) {
					this.parent.onEnter.dispatch();
					if(this.parent.onEnter.canceled && event.cancelable) {
						event.preventDefault();
					}
				}
				break;
			case "mouseleave":
				if(event.target == this.parent.element) {
					this.parent.onLeave.dispatch();
					if(this.parent.onLeave.canceled && event.cancelable) {
						event.preventDefault();
					}
				}
				break;
			case "mousemove":
				if(x != this.cacheMouseX || y != this.cacheMouseY) {
					this.parent.onMouseMove.dispatch(x,y);
					this.parent.onMouseMoveRelative.dispatch(x - this.cacheMouseX,y - this.cacheMouseY);
					if((this.parent.onMouseMove.canceled || this.parent.onMouseMoveRelative.canceled) && event.cancelable) {
						event.preventDefault();
					}
				}
				break;
			case "mouseup":
				window.removeEventListener("mouseup",$bind(this,this.handleMouseEvent));
				if(event.currentTarget == this.parent.element) {
					event.stopPropagation();
				}
				this.parent.onMouseUp.dispatch(x,y,event.button);
				if(this.parent.onMouseUp.canceled && event.cancelable) {
					event.preventDefault();
				}
				break;
			default:
			}
			this.cacheMouseX = x;
			this.cacheMouseY = y;
		} else {
			var deltaMode;
			var _g1 = event.deltaMode;
			switch(_g1) {
			case 0:
				deltaMode = lime_ui_MouseWheelMode.PIXELS;
				break;
			case 1:
				deltaMode = lime_ui_MouseWheelMode.LINES;
				break;
			case 2:
				deltaMode = lime_ui_MouseWheelMode.PAGES;
				break;
			default:
				deltaMode = lime_ui_MouseWheelMode.UNKNOWN;
			}
			this.parent.onMouseWheel.dispatch(event.deltaX,-event.deltaY,deltaMode);
			if(this.parent.onMouseWheel.canceled && event.cancelable) {
				event.preventDefault();
			}
		}
	}
	,handlePasteEvent: function(event) {
		if(event.clipboardData.types.indexOf("text/plain") > -1) {
			var text = event.clipboardData.getData("text/plain");
			lime_system_Clipboard.set_text(text);
			if(this.textInputEnabled) {
				this.parent.onTextInput.dispatch(text);
			}
			if(event.cancelable) {
				event.preventDefault();
			}
		}
	}
	,handleResizeEvent: function(event) {
		this.primaryTouch = null;
		this.updateSize();
	}
	,handleTouchEvent: function(event) {
		if(event.cancelable) {
			event.preventDefault();
		}
		var rect = null;
		if(this.parent.element != null) {
			if(this.canvas != null) {
				rect = this.canvas.getBoundingClientRect();
			} else if(this.div != null) {
				rect = this.div.getBoundingClientRect();
			} else {
				rect = this.parent.element.getBoundingClientRect();
			}
		}
		var windowWidth = this.setWidth;
		var windowHeight = this.setHeight;
		if(windowWidth == 0 || windowHeight == 0) {
			if(rect != null) {
				windowWidth = rect.width;
				windowHeight = rect.height;
			} else {
				windowWidth = 1;
				windowHeight = 1;
			}
		}
		var touch;
		var x;
		var y;
		var cacheX;
		var cacheY;
		var _g = 0;
		var _g1 = event.changedTouches;
		while(_g < _g1.length) {
			var data = _g1[_g];
			++_g;
			x = 0.0;
			y = 0.0;
			if(rect != null) {
				x = (data.clientX - rect.left) * (windowWidth / rect.width);
				y = (data.clientY - rect.top) * (windowHeight / rect.height);
			} else {
				x = data.clientX;
				y = data.clientY;
			}
			if(event.type == "touchstart") {
				touch = this.unusedTouchesPool.pop();
				if(touch == null) {
					touch = new lime_ui_Touch(x / windowWidth,y / windowHeight,data.identifier,0,0,data.force,this.parent.id);
				} else {
					touch.x = x / windowWidth;
					touch.y = y / windowHeight;
					touch.id = data.identifier;
					touch.dx = 0;
					touch.dy = 0;
					touch.pressure = data.force;
					touch.device = this.parent.id;
				}
				this.currentTouches.h[data.identifier] = touch;
				lime_ui_Touch.onStart.dispatch(touch);
				if(this.primaryTouch == null) {
					this.primaryTouch = touch;
				}
				if(touch == this.primaryTouch) {
					this.parent.onMouseDown.dispatch(x,y,0);
				}
			} else {
				touch = this.currentTouches.h[data.identifier];
				if(touch != null) {
					cacheX = touch.x;
					cacheY = touch.y;
					touch.x = x / windowWidth;
					touch.y = y / windowHeight;
					touch.dx = touch.x - cacheX;
					touch.dy = touch.y - cacheY;
					touch.pressure = data.force;
					var _g2 = event.type;
					switch(_g2) {
					case "touchcancel":
						lime_ui_Touch.onCancel.dispatch(touch);
						this.currentTouches.remove(data.identifier);
						this.unusedTouchesPool.add(touch);
						if(touch == this.primaryTouch) {
							this.primaryTouch = null;
						}
						break;
					case "touchend":
						lime_ui_Touch.onEnd.dispatch(touch);
						this.currentTouches.remove(data.identifier);
						this.unusedTouchesPool.add(touch);
						if(touch == this.primaryTouch) {
							this.parent.onMouseUp.dispatch(x,y,0);
							this.primaryTouch = null;
						}
						break;
					case "touchmove":
						lime_ui_Touch.onMove.dispatch(touch);
						if(touch == this.primaryTouch) {
							this.parent.onMouseMove.dispatch(x,y);
						}
						break;
					default:
					}
				}
			}
		}
	}
	,isDescendent: function(node) {
		if(node == this.parent.element) {
			return true;
		}
		while(node != null) {
			if(node.parentNode == this.parent.element) {
				return true;
			}
			node = node.parentNode;
		}
		return false;
	}
	,move: function(x,y) {
	}
	,readPixels: function(rect) {
		if(this.canvas != null) {
			var stageRect = new lime_math_Rectangle(0,0,this.canvas.width,this.canvas.height);
			if(rect == null) {
				rect = stageRect;
			} else {
				rect.intersection(stageRect,rect);
			}
			if(rect.width > 0 && rect.height > 0) {
				var canvas2 = window.document.createElement("canvas");
				canvas2.width = rect.width | 0;
				canvas2.height = rect.height | 0;
				var context = canvas2.getContext("2d");
				context.drawImage(this.canvas,-rect.x,-rect.y);
				return lime_graphics_Image.fromCanvas(canvas2);
			}
		}
		return null;
	}
	,resize: function(width,height) {
	}
	,setBorderless: function(value) {
		return value;
	}
	,setClipboard: function(value) {
		if(lime__$internal_backend_html5_HTML5Window.textArea == null) {
			lime__$internal_backend_html5_HTML5Window.textArea = window.document.createElement("textarea");
			lime__$internal_backend_html5_HTML5Window.textArea.style.height = "0px";
			lime__$internal_backend_html5_HTML5Window.textArea.style.left = "-100px";
			lime__$internal_backend_html5_HTML5Window.textArea.style.opacity = "0";
			lime__$internal_backend_html5_HTML5Window.textArea.style.position = "fixed";
			lime__$internal_backend_html5_HTML5Window.textArea.style.top = "-100px";
			lime__$internal_backend_html5_HTML5Window.textArea.style.width = "0px";
			window.document.body.appendChild(lime__$internal_backend_html5_HTML5Window.textArea);
		}
		lime__$internal_backend_html5_HTML5Window.textArea.value = value;
		lime__$internal_backend_html5_HTML5Window.textArea.focus();
		lime__$internal_backend_html5_HTML5Window.textArea.select();
		if(window.document.queryCommandEnabled("copy")) {
			window.document.execCommand("copy");
		}
	}
	,setCursor: function(value) {
		if(this.cursor != value) {
			if(value == null) {
				this.parent.element.style.cursor = "none";
			} else {
				var tmp;
				switch(value[1]) {
				case 0:
					tmp = "default";
					break;
				case 1:
					tmp = "crosshair";
					break;
				case 3:
					tmp = "move";
					break;
				case 4:
					tmp = "pointer";
					break;
				case 5:
					tmp = "nesw-resize";
					break;
				case 6:
					tmp = "ns-resize";
					break;
				case 7:
					tmp = "nwse-resize";
					break;
				case 8:
					tmp = "ew-resize";
					break;
				case 9:
					tmp = "text";
					break;
				case 10:
					tmp = "wait";
					break;
				case 11:
					tmp = "wait";
					break;
				default:
					tmp = "auto";
				}
				this.parent.element.style.cursor = tmp;
			}
			this.cursor = value;
		}
		return this.cursor;
	}
	,setDisplayMode: function(value) {
		return value;
	}
	,setFrameRate: function(value) {
		if(this.parent.application != null) {
			if(value >= 60) {
				if(this.parent == this.parent.application.__window) {
					this.parent.application.__backend.framePeriod = -1;
				}
			} else if(value > 0) {
				if(this.parent == this.parent.application.__window) {
					this.parent.application.__backend.framePeriod = 1000 / value;
				}
			} else if(this.parent == this.parent.application.__window) {
				this.parent.application.__backend.framePeriod = 1000;
			}
		}
		return value;
	}
	,setFullscreen: function(value) {
		if(value) {
			if(!this.requestedFullscreen && !this.isFullscreen) {
				this.requestedFullscreen = true;
				if(($_=this.parent.element,$bind($_,$_.requestFullscreen))) {
					document.addEventListener("fullscreenchange",$bind(this,this.handleFullscreenEvent),false);
					document.addEventListener("fullscreenerror",$bind(this,this.handleFullscreenEvent),false);
					this.parent.element.requestFullscreen();
				} else if(this.parent.element.mozRequestFullScreen) {
					document.addEventListener("mozfullscreenchange",$bind(this,this.handleFullscreenEvent),false);
					document.addEventListener("mozfullscreenerror",$bind(this,this.handleFullscreenEvent),false);
					this.parent.element.mozRequestFullScreen();
				} else if(this.parent.element.webkitRequestFullscreen) {
					document.addEventListener("webkitfullscreenchange",$bind(this,this.handleFullscreenEvent),false);
					document.addEventListener("webkitfullscreenerror",$bind(this,this.handleFullscreenEvent),false);
					this.parent.element.webkitRequestFullscreen();
				} else if(this.parent.element.msRequestFullscreen) {
					document.addEventListener("MSFullscreenChange",$bind(this,this.handleFullscreenEvent),false);
					document.addEventListener("MSFullscreenError",$bind(this,this.handleFullscreenEvent),false);
					this.parent.element.msRequestFullscreen();
				}
			}
		} else if(this.isFullscreen) {
			this.requestedFullscreen = false;
			if(document.exitFullscreen) {
				document.exitFullscreen();
			} else if(document.mozCancelFullScreen) {
				document.mozCancelFullScreen();
			} else if(document.webkitExitFullscreen) {
				document.webkitExitFullscreen();
			} else if(document.msExitFullscreen) {
				document.msExitFullscreen();
			}
		}
		return value;
	}
	,setIcon: function(image) {
		lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image);
		var link = window.document.querySelector("link[rel*='icon']");
		if(link == null) {
			link = window.document.createElement("link");
		}
		link.type = "image/x-icon";
		link.rel = "shortcut icon";
		link.href = image.buffer.get_src().toDataURL("image/x-icon");
		window.document.getElementsByTagName("head")[0].appendChild(link);
	}
	,setMaximized: function(value) {
		return false;
	}
	,setMinimized: function(value) {
		return false;
	}
	,setMouseLock: function(value) {
	}
	,setResizable: function(value) {
		return value;
	}
	,setTextInputEnabled: function(value) {
		if(value) {
			if(lime__$internal_backend_html5_HTML5Window.textInput == null) {
				lime__$internal_backend_html5_HTML5Window.textInput = window.document.createElement("input");
				lime__$internal_backend_html5_HTML5Window.textInput.type = "text";
				lime__$internal_backend_html5_HTML5Window.textInput.style.position = "absolute";
				lime__$internal_backend_html5_HTML5Window.textInput.style.opacity = "0";
				lime__$internal_backend_html5_HTML5Window.textInput.style.color = "transparent";
				lime__$internal_backend_html5_HTML5Window.textInput.value = lime__$internal_backend_html5_HTML5Window.dummyCharacter;
				lime__$internal_backend_html5_HTML5Window.textInput.autocapitalize = "off";
				lime__$internal_backend_html5_HTML5Window.textInput.autocorrect = "off";
				lime__$internal_backend_html5_HTML5Window.textInput.autocomplete = "off";
				lime__$internal_backend_html5_HTML5Window.textInput.style.left = "0px";
				lime__$internal_backend_html5_HTML5Window.textInput.style.top = "50%";
				if(new EReg("(iPad|iPhone|iPod).*OS 8_","gi").match(window.navigator.userAgent)) {
					lime__$internal_backend_html5_HTML5Window.textInput.style.fontSize = "0px";
					lime__$internal_backend_html5_HTML5Window.textInput.style.width = "0px";
					lime__$internal_backend_html5_HTML5Window.textInput.style.height = "0px";
				} else {
					lime__$internal_backend_html5_HTML5Window.textInput.style.width = "1px";
					lime__$internal_backend_html5_HTML5Window.textInput.style.height = "1px";
				}
				lime__$internal_backend_html5_HTML5Window.textInput.style.pointerEvents = "none";
				lime__$internal_backend_html5_HTML5Window.textInput.style.zIndex = "-10000000";
			}
			if(lime__$internal_backend_html5_HTML5Window.textInput.parentNode == null) {
				this.parent.element.appendChild(lime__$internal_backend_html5_HTML5Window.textInput);
			}
			if(!this.textInputEnabled) {
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("input",$bind(this,this.handleInputEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("blur",$bind(this,this.handleFocusEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("cut",$bind(this,this.handleCutOrCopyEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("copy",$bind(this,this.handleCutOrCopyEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("paste",$bind(this,this.handlePasteEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("compositionstart",$bind(this,this.handleCompositionstartEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("compositionend",$bind(this,this.handleCompositionendEvent),true);
			}
			lime__$internal_backend_html5_HTML5Window.textInput.focus();
			lime__$internal_backend_html5_HTML5Window.textInput.select();
		} else if(lime__$internal_backend_html5_HTML5Window.textInput != null) {
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("input",$bind(this,this.handleInputEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("blur",$bind(this,this.handleFocusEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("cut",$bind(this,this.handleCutOrCopyEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("copy",$bind(this,this.handleCutOrCopyEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("paste",$bind(this,this.handlePasteEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("compositionstart",$bind(this,this.handleCompositionstartEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("compositionend",$bind(this,this.handleCompositionendEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.blur();
		}
		return this.textInputEnabled = value;
	}
	,handleCompositionstartEvent: function(e) {
		this.inputing = true;
	}
	,handleCompositionendEvent: function(e) {
		this.inputing = false;
		this.handleInputEvent(e);
	}
	,setTitle: function(value) {
		if(value != null) {
			window.document.title = value;
		}
		return value;
	}
	,updateSize: function() {
		if(!this.parent.__resizable) {
			return;
		}
		var elementWidth;
		var elementHeight;
		if(this.parent.element != null) {
			elementWidth = this.parent.element.clientWidth;
			elementHeight = this.parent.element.clientHeight;
		} else {
			elementWidth = window.innerWidth;
			elementHeight = window.innerHeight;
		}
		if(elementWidth != this.cacheElementWidth || elementHeight != this.cacheElementHeight) {
			this.cacheElementWidth = elementWidth;
			this.cacheElementHeight = elementHeight;
			var stretch = this.resizeElement || this.setWidth == 0 && this.setHeight == 0;
			if(this.parent.element != null && (this.div == null || this.div != null && stretch)) {
				if(stretch) {
					if(this.parent.__width != elementWidth || this.parent.__height != elementHeight) {
						this.parent.__width = elementWidth;
						this.parent.__height = elementHeight;
						if(this.canvas != null) {
							if(this.parent.element != this.canvas) {
								this.canvas.width = Math.round(elementWidth * this.scale);
								this.canvas.height = Math.round(elementHeight * this.scale);
								this.canvas.style.width = elementWidth + "px";
								this.canvas.style.height = elementHeight + "px";
							}
						} else {
							this.div.style.width = elementWidth + "px";
							this.div.style.height = elementHeight + "px";
						}
						this.parent.onResize.dispatch(elementWidth,elementHeight);
					}
				} else {
					var scaleX = this.setWidth != 0 ? elementWidth / this.setWidth : 1;
					var scaleY = this.setHeight != 0 ? elementHeight / this.setHeight : 1;
					var targetWidth = elementWidth;
					var targetHeight = elementHeight;
					var marginLeft = 0;
					var marginTop = 0;
					if(scaleX < scaleY) {
						targetHeight = Math.floor(this.setHeight * scaleX);
						marginTop = Math.floor((elementHeight - targetHeight) / 2);
					} else {
						targetWidth = Math.floor(this.setWidth * scaleY);
						marginLeft = Math.floor((elementWidth - targetWidth) / 2);
					}
					if(this.canvas != null) {
						if(this.parent.element != this.canvas) {
							this.canvas.style.width = targetWidth + "px";
							this.canvas.style.height = targetHeight + "px";
							this.canvas.style.marginLeft = marginLeft + "px";
							this.canvas.style.marginTop = marginTop + "px";
						}
					} else {
						this.div.style.width = targetWidth + "px";
						this.div.style.height = targetHeight + "px";
						this.div.style.marginLeft = marginLeft + "px";
						this.div.style.marginTop = marginTop + "px";
					}
				}
			}
		}
	}
	,warpMouse: function(x,y) {
	}
	,__class__: lime__$internal_backend_html5_HTML5Window
};
var lime__$internal_backend_native_NativeCFFI = function() { };
$hxClasses["lime._internal.backend.native.NativeCFFI"] = lime__$internal_backend_native_NativeCFFI;
lime__$internal_backend_native_NativeCFFI.__name__ = ["lime","_internal","backend","native","NativeCFFI"];
var lime__$internal_format_BMP = function() { };
$hxClasses["lime._internal.format.BMP"] = lime__$internal_format_BMP;
lime__$internal_format_BMP.__name__ = ["lime","_internal","format","BMP"];
lime__$internal_format_BMP.encode = function(image,type) {
	if(image.get_premultiplied() || image.get_format() != 0) {
		image = image.clone();
		image.set_premultiplied(false);
		image.set_format(0);
	}
	if(type == null) {
		type = lime__$internal_format_BMPType.RGB;
	}
	var fileHeaderLength = 14;
	var infoHeaderLength = 40;
	var pixelValuesLength = image.width * image.height * 4;
	if(type != null) {
		switch(type[1]) {
		case 0:
			pixelValuesLength = (image.width * 3 + image.width * 3 % 4) * image.height;
			break;
		case 1:
			infoHeaderLength = 108;
			break;
		case 2:
			fileHeaderLength = 0;
			pixelValuesLength += image.width * image.height;
			break;
		}
	}
	var data = new haxe_io_Bytes(new ArrayBuffer(fileHeaderLength + infoHeaderLength + pixelValuesLength));
	var position = 0;
	if(fileHeaderLength > 0) {
		data.b[position++] = 66;
		data.b[position++] = 77;
		data.setInt32(position,data.length);
		position += 4;
		data.setUInt16(position,0);
		position += 2;
		data.setUInt16(position,0);
		position += 2;
		data.setInt32(position,fileHeaderLength + infoHeaderLength);
		position += 4;
	}
	data.setInt32(position,infoHeaderLength);
	position += 4;
	data.setInt32(position,image.width);
	position += 4;
	data.setInt32(position,type == lime__$internal_format_BMPType.ICO ? image.height * 2 : image.height);
	position += 4;
	data.setUInt16(position,1);
	position += 2;
	data.setUInt16(position,type == lime__$internal_format_BMPType.RGB ? 24 : 32);
	position += 2;
	data.setInt32(position,type == lime__$internal_format_BMPType.BITFIELD ? 3 : 0);
	position += 4;
	data.setInt32(position,pixelValuesLength);
	position += 4;
	data.setInt32(position,11824);
	position += 4;
	data.setInt32(position,11824);
	position += 4;
	data.setInt32(position,0);
	position += 4;
	data.setInt32(position,0);
	position += 4;
	if(type == lime__$internal_format_BMPType.BITFIELD) {
		data.setInt32(position,16711680);
		position += 4;
		data.setInt32(position,65280);
		position += 4;
		data.setInt32(position,255);
		position += 4;
		data.setInt32(position,-16777216);
		position += 4;
		data.b[position++] = 32;
		data.b[position++] = 110;
		data.b[position++] = 105;
		data.b[position++] = 87;
		var _g = 0;
		while(_g < 48) {
			var i = _g++;
			data.b[position++] = 0;
		}
	}
	var pixels = image.getPixels(new lime_math_Rectangle(0,0,image.width,image.height),1);
	var readPosition = 0;
	var a;
	var r;
	var g;
	var b;
	if(type != null) {
		switch(type[1]) {
		case 0:
			var _g1 = 0;
			var _g2 = image.height;
			while(_g1 < _g2) {
				var y = _g1++;
				readPosition = (image.height - 1 - y) * 4 * image.width;
				var _g3 = 0;
				var _g21 = image.width;
				while(_g3 < _g21) {
					var x = _g3++;
					a = pixels.b[readPosition++];
					r = pixels.b[readPosition++];
					g = pixels.b[readPosition++];
					b = pixels.b[readPosition++];
					data.b[position++] = b & 255;
					data.b[position++] = g & 255;
					data.b[position++] = r & 255;
				}
				var _g31 = 0;
				var _g22 = image.width * 3 % 4;
				while(_g31 < _g22) {
					var i1 = _g31++;
					data.b[position++] = 0;
				}
			}
			break;
		case 1:
			var _g11 = 0;
			var _g4 = image.height;
			while(_g11 < _g4) {
				var y1 = _g11++;
				readPosition = (image.height - 1 - y1) * 4 * image.width;
				var _g32 = 0;
				var _g23 = image.width;
				while(_g32 < _g23) {
					var x1 = _g32++;
					a = pixels.b[readPosition++];
					r = pixels.b[readPosition++];
					g = pixels.b[readPosition++];
					b = pixels.b[readPosition++];
					data.b[position++] = b & 255;
					data.b[position++] = g & 255;
					data.b[position++] = r & 255;
					data.b[position++] = a & 255;
				}
			}
			break;
		case 2:
			var andMask = new haxe_io_Bytes(new ArrayBuffer(image.width * image.height));
			var maskPosition = 0;
			var _g12 = 0;
			var _g5 = image.height;
			while(_g12 < _g5) {
				var y2 = _g12++;
				readPosition = (image.height - 1 - y2) * 4 * image.width;
				var _g33 = 0;
				var _g24 = image.width;
				while(_g33 < _g24) {
					var x2 = _g33++;
					a = pixels.b[readPosition++];
					r = pixels.b[readPosition++];
					g = pixels.b[readPosition++];
					b = pixels.b[readPosition++];
					data.b[position++] = b & 255;
					data.b[position++] = g & 255;
					data.b[position++] = r & 255;
					data.b[position++] = a & 255;
					andMask.b[maskPosition++] = 0;
				}
			}
			data.blit(position,andMask,0,image.width * image.height);
			break;
		}
	}
	return data;
};
var lime__$internal_format_BMPType = $hxClasses["lime._internal.format.BMPType"] = { __ename__ : ["lime","_internal","format","BMPType"], __constructs__ : ["RGB","BITFIELD","ICO"] };
lime__$internal_format_BMPType.RGB = ["RGB",0];
lime__$internal_format_BMPType.RGB.toString = $estr;
lime__$internal_format_BMPType.RGB.__enum__ = lime__$internal_format_BMPType;
lime__$internal_format_BMPType.BITFIELD = ["BITFIELD",1];
lime__$internal_format_BMPType.BITFIELD.toString = $estr;
lime__$internal_format_BMPType.BITFIELD.__enum__ = lime__$internal_format_BMPType;
lime__$internal_format_BMPType.ICO = ["ICO",2];
lime__$internal_format_BMPType.ICO.toString = $estr;
lime__$internal_format_BMPType.ICO.__enum__ = lime__$internal_format_BMPType;
var lime__$internal_format_Base64 = function() { };
$hxClasses["lime._internal.format.Base64"] = lime__$internal_format_Base64;
lime__$internal_format_Base64.__name__ = ["lime","_internal","format","Base64"];
lime__$internal_format_Base64.decode = function(source) {
	return haxe_crypto_Base64.decode(source);
};
lime__$internal_format_Base64.encode = function(source) {
	var result = [];
	var dictionary = lime__$internal_format_Base64.DICTIONARY;
	var extendedDictionary = lime__$internal_format_Base64.EXTENDED_DICTIONARY;
	var numBytes = source.length;
	var numInputTriplets = Math.floor(numBytes / 3);
	var numChunksToWrite = numInputTriplets * 2;
	result.length = Math.ceil(numBytes / 3) * 2;
	var numBytesRead = 0;
	var numChunksWritten = 0;
	var inputTriplet;
	while(numChunksWritten < numChunksToWrite) {
		inputTriplet = source.b[numBytesRead] << 16 | source.b[numBytesRead + 1] << 8 | source.b[numBytesRead + 2];
		result[numChunksWritten] = extendedDictionary[inputTriplet >> 12 & 4095];
		result[numChunksWritten + 1] = extendedDictionary[inputTriplet & 4095];
		numBytesRead += 3;
		numChunksWritten += 2;
	}
	var _g = numBytes - numInputTriplets * 3;
	switch(_g) {
	case 1:
		inputTriplet = source.b[numBytesRead] << 16;
		result[numChunksWritten] = extendedDictionary[inputTriplet >> 12 & 4095];
		result[numChunksWritten + 1] = "==";
		break;
	case 2:
		inputTriplet = source.b[numBytesRead] << 16 | source.b[numBytesRead + 1] << 8;
		result[numChunksWritten] = extendedDictionary[inputTriplet >> 12 & 4095];
		result[numChunksWritten + 1] = dictionary[inputTriplet >> 6 & 63] + "=";
		break;
	default:
	}
	return result.join("");
};
var lime__$internal_format_Deflate = function() { };
$hxClasses["lime._internal.format.Deflate"] = lime__$internal_format_Deflate;
lime__$internal_format_Deflate.__name__ = ["lime","_internal","format","Deflate"];
lime__$internal_format_Deflate.compress = function(bytes) {
	var data = pako.deflateRaw(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
lime__$internal_format_Deflate.decompress = function(bytes) {
	var data = pako.inflateRaw(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
var lime__$internal_format_GZip = function() { };
$hxClasses["lime._internal.format.GZip"] = lime__$internal_format_GZip;
lime__$internal_format_GZip.__name__ = ["lime","_internal","format","GZip"];
lime__$internal_format_GZip.compress = function(bytes) {
	var data = pako.gzip(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
lime__$internal_format_GZip.decompress = function(bytes) {
	var data = pako.ungzip(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
var lime__$internal_format_JPEG = function() { };
$hxClasses["lime._internal.format.JPEG"] = lime__$internal_format_JPEG;
lime__$internal_format_JPEG.__name__ = ["lime","_internal","format","JPEG"];
lime__$internal_format_JPEG.decodeBytes = function(bytes,decodeData) {
	if(decodeData == null) {
		decodeData = true;
	}
	return null;
};
lime__$internal_format_JPEG.decodeFile = function(path,decodeData) {
	if(decodeData == null) {
		decodeData = true;
	}
	return null;
};
lime__$internal_format_JPEG.encode = function(image,quality) {
	if(image.get_premultiplied() || image.get_format() != 0) {
		image = image.clone();
		image.set_premultiplied(false);
		image.set_format(0);
	}
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,false);
	if(image.buffer.__srcCanvas != null) {
		var data = image.buffer.__srcCanvas.toDataURL("image/jpeg",quality / 100);
		var buffer = window.atob(data.split(";base64,")[1]);
		var bytes = new haxe_io_Bytes(new ArrayBuffer(buffer.length));
		var _g1 = 0;
		var _g = buffer.length;
		while(_g1 < _g) {
			var i = _g1++;
			var v = HxOverrides.cca(buffer,i);
			bytes.b[i] = v & 255;
		}
		return bytes;
	}
	return null;
};
var lime__$internal_format_LZMA = function() { };
$hxClasses["lime._internal.format.LZMA"] = lime__$internal_format_LZMA;
lime__$internal_format_LZMA.__name__ = ["lime","_internal","format","LZMA"];
lime__$internal_format_LZMA.compress = function(bytes) {
	return null;
};
lime__$internal_format_LZMA.decompress = function(bytes) {
	return null;
};
var lime__$internal_format_PNG = function() { };
$hxClasses["lime._internal.format.PNG"] = lime__$internal_format_PNG;
lime__$internal_format_PNG.__name__ = ["lime","_internal","format","PNG"];
lime__$internal_format_PNG.decodeBytes = function(bytes,decodeData) {
	if(decodeData == null) {
		decodeData = true;
	}
	return null;
};
lime__$internal_format_PNG.decodeFile = function(path,decodeData) {
	if(decodeData == null) {
		decodeData = true;
	}
	return null;
};
lime__$internal_format_PNG.encode = function(image) {
	if(image.get_premultiplied() || image.get_format() != 0) {
		image = image.clone();
		image.set_premultiplied(false);
		image.set_format(0);
	}
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,false);
	if(image.buffer.__srcCanvas != null) {
		var data = image.buffer.__srcCanvas.toDataURL("image/png");
		var buffer = window.atob(data.split(";base64,")[1]);
		var bytes = new haxe_io_Bytes(new ArrayBuffer(buffer.length));
		var _g1 = 0;
		var _g = buffer.length;
		while(_g1 < _g) {
			var i = _g1++;
			var v = HxOverrides.cca(buffer,i);
			bytes.b[i] = v & 255;
		}
		return bytes;
	}
	return null;
};
var lime__$internal_format_Zlib = function() { };
$hxClasses["lime._internal.format.Zlib"] = lime__$internal_format_Zlib;
lime__$internal_format_Zlib.__name__ = ["lime","_internal","format","Zlib"];
lime__$internal_format_Zlib.compress = function(bytes) {
	var data = pako.deflate(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
lime__$internal_format_Zlib.decompress = function(bytes) {
	var data = pako.inflate(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
var lime__$internal_graphics_ImageCanvasUtil = function() { };
$hxClasses["lime._internal.graphics.ImageCanvasUtil"] = lime__$internal_graphics_ImageCanvasUtil;
lime__$internal_graphics_ImageCanvasUtil.__name__ = ["lime","_internal","graphics","ImageCanvasUtil"];
lime__$internal_graphics_ImageCanvasUtil.colorTransform = function(image,rect,colorMatrix) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.colorTransform(image,rect,colorMatrix);
};
lime__$internal_graphics_ImageCanvasUtil.convertToCanvas = function(image,clear) {
	if(clear == null) {
		clear = false;
	}
	var buffer = image.buffer;
	if(buffer.__srcImage != null) {
		if(buffer.__srcCanvas == null) {
			lime__$internal_graphics_ImageCanvasUtil.createCanvas(image,buffer.__srcImage.width,buffer.__srcImage.height);
			buffer.__srcContext.drawImage(buffer.__srcImage,0,0);
		}
		buffer.__srcImage = null;
	} else if(buffer.__srcCanvas == null && buffer.data != null) {
		image.set_transparent(true);
		lime__$internal_graphics_ImageCanvasUtil.createCanvas(image,buffer.width,buffer.height);
		lime__$internal_graphics_ImageCanvasUtil.createImageData(image);
		buffer.__srcContext.putImageData(buffer.__srcImageData,0,0);
	} else if(image.type == lime_graphics_ImageType.DATA && buffer.__srcImageData != null && image.dirty) {
		buffer.__srcContext.putImageData(buffer.__srcImageData,0,0);
		image.dirty = false;
	}
	if(clear) {
		buffer.data = null;
		buffer.__srcImageData = null;
	} else if(buffer.data == null && buffer.__srcImageData != null) {
		buffer.data = buffer.__srcImageData.data;
	}
	image.type = lime_graphics_ImageType.CANVAS;
};
lime__$internal_graphics_ImageCanvasUtil.convertToData = function(image,clear) {
	if(clear == null) {
		clear = false;
	}
	var buffer = image.buffer;
	if(buffer.__srcImage != null) {
		lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image);
	}
	if(buffer.__srcCanvas != null && buffer.data == null) {
		lime__$internal_graphics_ImageCanvasUtil.createImageData(image);
		if(image.type == lime_graphics_ImageType.CANVAS) {
			image.dirty = false;
		}
	} else if(image.type == lime_graphics_ImageType.CANVAS && buffer.__srcCanvas != null && image.dirty) {
		if(buffer.__srcImageData == null) {
			lime__$internal_graphics_ImageCanvasUtil.createImageData(image);
		} else {
			buffer.__srcImageData = buffer.__srcContext.getImageData(0,0,buffer.width,buffer.height);
			var elements = buffer.__srcImageData.data.buffer;
			var this1;
			if(elements != null) {
				this1 = new Uint8Array(elements);
			} else {
				this1 = null;
			}
			buffer.data = this1;
		}
		image.dirty = false;
	}
	if(clear) {
		image.buffer.__srcCanvas = null;
		image.buffer.__srcContext = null;
	}
	image.type = lime_graphics_ImageType.DATA;
};
lime__$internal_graphics_ImageCanvasUtil.copyChannel = function(image,sourceImage,sourceRect,destPoint,sourceChannel,destChannel) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.copyChannel(image,sourceImage,sourceRect,destPoint,sourceChannel,destChannel);
};
lime__$internal_graphics_ImageCanvasUtil.copyPixels = function(image,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha) {
	if(mergeAlpha == null) {
		mergeAlpha = false;
	}
	if(destPoint == null || destPoint.x >= image.width || destPoint.y >= image.height || sourceRect == null || sourceRect.width < 1 || sourceRect.height < 1) {
		return;
	}
	if(alphaImage != null && alphaImage.get_transparent()) {
		if(alphaPoint == null) {
			alphaPoint = new lime_math_Vector2();
		}
		var tempData = sourceImage.clone();
		tempData.copyChannel(alphaImage,new lime_math_Rectangle(sourceRect.x + alphaPoint.x,sourceRect.y + alphaPoint.y,sourceRect.width,sourceRect.height),new lime_math_Vector2(sourceRect.x,sourceRect.y),lime_graphics_ImageChannel.ALPHA,lime_graphics_ImageChannel.ALPHA);
		sourceImage = tempData;
	}
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,true);
	if(!mergeAlpha) {
		if(image.get_transparent() && sourceImage.get_transparent()) {
			image.buffer.__srcContext.clearRect(destPoint.x + image.offsetX,destPoint.y + image.offsetY,sourceRect.width + image.offsetX,sourceRect.height + image.offsetY);
		}
	}
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(sourceImage);
	if(sourceImage.buffer.get_src() != null) {
		image.buffer.__srcContext.globalCompositeOperation = "source-over";
		image.buffer.__srcContext.drawImage(sourceImage.buffer.get_src(),sourceRect.x + sourceImage.offsetX | 0,sourceRect.y + sourceImage.offsetY | 0,sourceRect.width | 0,sourceRect.height | 0,destPoint.x + image.offsetX | 0,destPoint.y + image.offsetY | 0,sourceRect.width | 0,sourceRect.height | 0);
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageCanvasUtil.createCanvas = function(image,width,height) {
	var buffer = image.buffer;
	if(buffer.__srcCanvas == null) {
		buffer.__srcCanvas = window.document.createElement("canvas");
		buffer.__srcCanvas.width = width;
		buffer.__srcCanvas.height = height;
		if(!image.get_transparent()) {
			if(!image.get_transparent()) {
				buffer.__srcCanvas.setAttribute("moz-opaque","true");
			}
			buffer.__srcContext = buffer.__srcCanvas.getContext ("2d", { alpha: false });
		} else {
			buffer.__srcContext = buffer.__srcCanvas.getContext("2d");
		}
	}
};
lime__$internal_graphics_ImageCanvasUtil.createImageData = function(image) {
	var buffer = image.buffer;
	if(buffer.__srcImageData == null) {
		if(buffer.data == null) {
			buffer.__srcImageData = buffer.__srcContext.getImageData(0,0,buffer.width,buffer.height);
		} else {
			buffer.__srcImageData = buffer.__srcContext.createImageData(buffer.width,buffer.height);
			buffer.__srcImageData.data.set(buffer.data);
		}
		var elements = buffer.__srcImageData.data.buffer;
		var this1;
		if(elements != null) {
			this1 = new Uint8Array(elements);
		} else {
			this1 = null;
		}
		buffer.data = this1;
	}
};
lime__$internal_graphics_ImageCanvasUtil.fillRect = function(image,rect,color,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image);
	var r;
	var g;
	var b;
	var a;
	if(format == 1) {
		r = color >> 16 & 255;
		g = color >> 8 & 255;
		b = color & 255;
		if(image.get_transparent()) {
			a = color >> 24 & 255;
		} else {
			a = 255;
		}
	} else {
		r = color >> 24 & 255;
		g = color >> 16 & 255;
		b = color >> 8 & 255;
		if(image.get_transparent()) {
			a = color & 255;
		} else {
			a = 255;
		}
	}
	if(rect.x == 0 && rect.y == 0 && rect.width == image.width && rect.height == image.height) {
		if(image.get_transparent() && a == 0) {
			image.buffer.__srcCanvas.width = image.buffer.width;
			return;
		}
	}
	if(a < 255) {
		image.buffer.__srcContext.clearRect(rect.x + image.offsetX,rect.y + image.offsetY,rect.width + image.offsetX,rect.height + image.offsetY);
	}
	if(a > 0) {
		image.buffer.__srcContext.fillStyle = "rgba(" + r + ", " + g + ", " + b + ", " + a / 255 + ")";
		image.buffer.__srcContext.fillRect(rect.x + image.offsetX,rect.y + image.offsetY,rect.width + image.offsetX,rect.height + image.offsetY);
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageCanvasUtil.floodFill = function(image,x,y,color,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.floodFill(image,x,y,color,format);
};
lime__$internal_graphics_ImageCanvasUtil.getPixel = function(image,x,y,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	return lime__$internal_graphics_ImageDataUtil.getPixel(image,x,y,format);
};
lime__$internal_graphics_ImageCanvasUtil.getPixel32 = function(image,x,y,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	return lime__$internal_graphics_ImageDataUtil.getPixel32(image,x,y,format);
};
lime__$internal_graphics_ImageCanvasUtil.getPixels = function(image,rect,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	return lime__$internal_graphics_ImageDataUtil.getPixels(image,rect,format);
};
lime__$internal_graphics_ImageCanvasUtil.merge = function(image,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.merge(image,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
};
lime__$internal_graphics_ImageCanvasUtil.resize = function(image,newWidth,newHeight) {
	var buffer = image.buffer;
	if(buffer.__srcCanvas == null) {
		lime__$internal_graphics_ImageCanvasUtil.createCanvas(image,newWidth,newHeight);
		buffer.__srcContext.drawImage(buffer.get_src(),0,0,newWidth,newHeight);
	} else {
		lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,true);
		var sourceCanvas = buffer.__srcCanvas;
		buffer.__srcCanvas = null;
		lime__$internal_graphics_ImageCanvasUtil.createCanvas(image,newWidth,newHeight);
		buffer.__srcContext.drawImage(sourceCanvas,0,0,newWidth,newHeight);
	}
	buffer.__srcImageData = null;
	buffer.data = null;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageCanvasUtil.scroll = function(image,x,y) {
	if(x % image.width == 0 && y % image.height == 0) {
		return;
	}
	var copy = image.clone();
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,true);
	image.buffer.__srcContext.clearRect(x,y,image.width,image.height);
	image.buffer.__srcContext.drawImage(copy.get_src(),x,y);
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageCanvasUtil.setPixel = function(image,x,y,color,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.setPixel(image,x,y,color,format);
};
lime__$internal_graphics_ImageCanvasUtil.setPixel32 = function(image,x,y,color,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.setPixel32(image,x,y,color,format);
};
lime__$internal_graphics_ImageCanvasUtil.setPixels = function(image,rect,bytePointer,format,endian) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.setPixels(image,rect,bytePointer,format,endian);
};
lime__$internal_graphics_ImageCanvasUtil.sync = function(image,clear) {
	if(image == null) {
		return;
	}
	if(image.type == lime_graphics_ImageType.CANVAS && (image.buffer.__srcCanvas != null || image.buffer.data != null)) {
		lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,clear);
	} else if(image.type == lime_graphics_ImageType.DATA) {
		lime__$internal_graphics_ImageCanvasUtil.convertToData(image,clear);
	}
};
var lime__$internal_graphics_ImageDataUtil = function() { };
$hxClasses["lime._internal.graphics.ImageDataUtil"] = lime__$internal_graphics_ImageDataUtil;
lime__$internal_graphics_ImageDataUtil.__name__ = ["lime","_internal","graphics","ImageDataUtil"];
lime__$internal_graphics_ImageDataUtil.displaceMap = function(target,source,map,mapPoint,componentX,componentY,smooth) {
	var targetData = target.buffer.data;
	var sourceData = source.buffer.data;
	var mapData = map.buffer.data;
	var targetFormat = target.buffer.format;
	var sourceFormat = source.buffer.format;
	var mapFormat = map.buffer.format;
	var targetPremultiplied = target.get_premultiplied();
	var sourcePremultiplied = source.get_premultiplied();
	var mapPremultiplied = map.get_premultiplied();
	var sourceView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(source);
	var mapView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(map);
	var row;
	var sourceOffset;
	var sourcePixel = 0;
	var mapPixel = 0;
	var targetPixel = 0;
	var mapPixelX;
	var mapPixelY;
	var mapPixelA;
	var s1 = 0;
	var s2 = 0;
	var s3 = 0;
	var s4 = 0;
	var mPointXFloor;
	var mPointYFloor;
	var disOffsetXFloor;
	var disOffsetYFloor;
	var disX;
	var disY;
	var _g1 = 0;
	var _g = sourceView.height;
	while(_g1 < _g) {
		var y = _g1++;
		row = sourceView.byteOffset + sourceView.stride * y;
		var _g3 = 0;
		var _g2 = sourceView.width;
		while(_g3 < _g2) {
			var x = _g3++;
			sourceOffset = row + x * 4;
			mPointXFloor = mapPoint.x | 0;
			mPointYFloor = mapPoint.y | 0;
			if(smooth) {
				var offset = sourceView.byteOffset + sourceView.stride * (y - mPointYFloor + 1) + (x - mPointXFloor) * 4;
				switch(mapFormat) {
				case 0:
					s1 = (mapData[offset] & 255) << 24 | (mapData[offset + 1] & 255) << 16 | (mapData[offset + 2] & 255) << 8 | mapData[offset + 3] & 255;
					break;
				case 1:
					s1 = (mapData[offset + 1] & 255) << 24 | (mapData[offset + 2] & 255) << 16 | (mapData[offset + 3] & 255) << 8 | mapData[offset] & 255;
					break;
				case 2:
					s1 = (mapData[offset + 2] & 255) << 24 | (mapData[offset + 1] & 255) << 16 | (mapData[offset] & 255) << 8 | mapData[offset + 3] & 255;
					break;
				}
				if(mapPremultiplied) {
					if((s1 & 255) != 0 && (s1 & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (s1 & 255);
						s1 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s1 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s1 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s1 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | s1 & 255 & 255;
					}
				}
				var offset1 = sourceView.byteOffset + sourceView.stride * (y - mPointYFloor) + (x - mPointXFloor + 1) * 4;
				switch(mapFormat) {
				case 0:
					s2 = (mapData[offset1] & 255) << 24 | (mapData[offset1 + 1] & 255) << 16 | (mapData[offset1 + 2] & 255) << 8 | mapData[offset1 + 3] & 255;
					break;
				case 1:
					s2 = (mapData[offset1 + 1] & 255) << 24 | (mapData[offset1 + 2] & 255) << 16 | (mapData[offset1 + 3] & 255) << 8 | mapData[offset1] & 255;
					break;
				case 2:
					s2 = (mapData[offset1 + 2] & 255) << 24 | (mapData[offset1 + 1] & 255) << 16 | (mapData[offset1] & 255) << 8 | mapData[offset1 + 3] & 255;
					break;
				}
				if(mapPremultiplied) {
					if((s2 & 255) != 0 && (s2 & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (s2 & 255);
						s2 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s2 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s2 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s2 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | s2 & 255 & 255;
					}
				}
				var offset2 = sourceView.byteOffset + sourceView.stride * (y - mPointYFloor + 1) + (x - mPointXFloor + 1) * 4;
				switch(mapFormat) {
				case 0:
					s3 = (mapData[offset2] & 255) << 24 | (mapData[offset2 + 1] & 255) << 16 | (mapData[offset2 + 2] & 255) << 8 | mapData[offset2 + 3] & 255;
					break;
				case 1:
					s3 = (mapData[offset2 + 1] & 255) << 24 | (mapData[offset2 + 2] & 255) << 16 | (mapData[offset2 + 3] & 255) << 8 | mapData[offset2] & 255;
					break;
				case 2:
					s3 = (mapData[offset2 + 2] & 255) << 24 | (mapData[offset2 + 1] & 255) << 16 | (mapData[offset2] & 255) << 8 | mapData[offset2 + 3] & 255;
					break;
				}
				if(mapPremultiplied) {
					if((s3 & 255) != 0 && (s3 & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (s3 & 255);
						s3 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s3 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s3 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s3 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | s3 & 255 & 255;
					}
				}
				var offset3 = sourceView.byteOffset + sourceView.stride * (y - mPointYFloor) + (x - mPointXFloor) * 4;
				switch(mapFormat) {
				case 0:
					s4 = (mapData[offset3] & 255) << 24 | (mapData[offset3 + 1] & 255) << 16 | (mapData[offset3 + 2] & 255) << 8 | mapData[offset3 + 3] & 255;
					break;
				case 1:
					s4 = (mapData[offset3 + 1] & 255) << 24 | (mapData[offset3 + 2] & 255) << 16 | (mapData[offset3 + 3] & 255) << 8 | mapData[offset3] & 255;
					break;
				case 2:
					s4 = (mapData[offset3 + 2] & 255) << 24 | (mapData[offset3 + 1] & 255) << 16 | (mapData[offset3] & 255) << 8 | mapData[offset3 + 3] & 255;
					break;
				}
				if(mapPremultiplied) {
					if((s4 & 255) != 0 && (s4 & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (s4 & 255);
						s4 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s4 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s4 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s4 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | s4 & 255 & 255;
					}
				}
				mapPixel = lime__$internal_graphics_ImageDataUtil.bilinear(s1,s2,s3,s4,mapPoint.x - mPointXFloor,mapPoint.y - mPointYFloor);
			} else {
				var offset4 = mapView.byteOffset + mapView.stride * (y - mPointYFloor) + (x - mPointXFloor) * 4;
				switch(mapFormat) {
				case 0:
					mapPixel = (mapData[offset4] & 255) << 24 | (mapData[offset4 + 1] & 255) << 16 | (mapData[offset4 + 2] & 255) << 8 | mapData[offset4 + 3] & 255;
					break;
				case 1:
					mapPixel = (mapData[offset4 + 1] & 255) << 24 | (mapData[offset4 + 2] & 255) << 16 | (mapData[offset4 + 3] & 255) << 8 | mapData[offset4] & 255;
					break;
				case 2:
					mapPixel = (mapData[offset4 + 2] & 255) << 24 | (mapData[offset4 + 1] & 255) << 16 | (mapData[offset4] & 255) << 8 | mapData[offset4 + 3] & 255;
					break;
				}
				if(mapPremultiplied) {
					if((mapPixel & 255) != 0 && (mapPixel & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (mapPixel & 255);
						mapPixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((mapPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((mapPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((mapPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | mapPixel & 255 & 255;
					}
				}
			}
			mapPixelA = (mapPixel & 255) / 255.0;
			mapPixelX = ((mapPixel >>> 24 & 255) - 128) / 255.0 * mapPixelA;
			mapPixelY = ((mapPixel >>> 16 & 255) - 128) / 255.0 * mapPixelA;
			disX = mapPixelX * componentX.x + mapPixelY * componentY.x;
			disY = mapPixelX * componentX.y + mapPixelY * componentY.y;
			disOffsetXFloor = Math.floor(disX * sourceView.width);
			disOffsetYFloor = Math.floor(disY * sourceView.height);
			if(smooth) {
				var offset5 = sourceView.byteOffset + sourceView.stride * (y + disOffsetYFloor + 1) + (x + disOffsetXFloor) * 4;
				switch(sourceFormat) {
				case 0:
					s1 = (sourceData[offset5] & 255) << 24 | (sourceData[offset5 + 1] & 255) << 16 | (sourceData[offset5 + 2] & 255) << 8 | sourceData[offset5 + 3] & 255;
					break;
				case 1:
					s1 = (sourceData[offset5 + 1] & 255) << 24 | (sourceData[offset5 + 2] & 255) << 16 | (sourceData[offset5 + 3] & 255) << 8 | sourceData[offset5] & 255;
					break;
				case 2:
					s1 = (sourceData[offset5 + 2] & 255) << 24 | (sourceData[offset5 + 1] & 255) << 16 | (sourceData[offset5] & 255) << 8 | sourceData[offset5 + 3] & 255;
					break;
				}
				if(sourcePremultiplied) {
					if((s1 & 255) != 0 && (s1 & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (s1 & 255);
						s1 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s1 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s1 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s1 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | s1 & 255 & 255;
					}
				}
				var offset6 = sourceView.byteOffset + sourceView.stride * (y + disOffsetYFloor) + (x + disOffsetXFloor + 1) * 4;
				switch(sourceFormat) {
				case 0:
					s2 = (sourceData[offset6] & 255) << 24 | (sourceData[offset6 + 1] & 255) << 16 | (sourceData[offset6 + 2] & 255) << 8 | sourceData[offset6 + 3] & 255;
					break;
				case 1:
					s2 = (sourceData[offset6 + 1] & 255) << 24 | (sourceData[offset6 + 2] & 255) << 16 | (sourceData[offset6 + 3] & 255) << 8 | sourceData[offset6] & 255;
					break;
				case 2:
					s2 = (sourceData[offset6 + 2] & 255) << 24 | (sourceData[offset6 + 1] & 255) << 16 | (sourceData[offset6] & 255) << 8 | sourceData[offset6 + 3] & 255;
					break;
				}
				if(sourcePremultiplied) {
					if((s2 & 255) != 0 && (s2 & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (s2 & 255);
						s2 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s2 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s2 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s2 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | s2 & 255 & 255;
					}
				}
				var offset7 = sourceView.byteOffset + sourceView.stride * (y + disOffsetYFloor + 1) + (x + disOffsetXFloor + 1) * 4;
				switch(sourceFormat) {
				case 0:
					s3 = (sourceData[offset7] & 255) << 24 | (sourceData[offset7 + 1] & 255) << 16 | (sourceData[offset7 + 2] & 255) << 8 | sourceData[offset7 + 3] & 255;
					break;
				case 1:
					s3 = (sourceData[offset7 + 1] & 255) << 24 | (sourceData[offset7 + 2] & 255) << 16 | (sourceData[offset7 + 3] & 255) << 8 | sourceData[offset7] & 255;
					break;
				case 2:
					s3 = (sourceData[offset7 + 2] & 255) << 24 | (sourceData[offset7 + 1] & 255) << 16 | (sourceData[offset7] & 255) << 8 | sourceData[offset7 + 3] & 255;
					break;
				}
				if(sourcePremultiplied) {
					if((s3 & 255) != 0 && (s3 & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (s3 & 255);
						s3 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s3 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s3 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s3 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | s3 & 255 & 255;
					}
				}
				var offset8 = sourceView.byteOffset + sourceView.stride * (y + disOffsetYFloor) + (x + disOffsetXFloor) * 4;
				switch(sourceFormat) {
				case 0:
					s4 = (sourceData[offset8] & 255) << 24 | (sourceData[offset8 + 1] & 255) << 16 | (sourceData[offset8 + 2] & 255) << 8 | sourceData[offset8 + 3] & 255;
					break;
				case 1:
					s4 = (sourceData[offset8 + 1] & 255) << 24 | (sourceData[offset8 + 2] & 255) << 16 | (sourceData[offset8 + 3] & 255) << 8 | sourceData[offset8] & 255;
					break;
				case 2:
					s4 = (sourceData[offset8 + 2] & 255) << 24 | (sourceData[offset8 + 1] & 255) << 16 | (sourceData[offset8] & 255) << 8 | sourceData[offset8 + 3] & 255;
					break;
				}
				if(sourcePremultiplied) {
					if((s4 & 255) != 0 && (s4 & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (s4 & 255);
						s4 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s4 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s4 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((s4 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | s4 & 255 & 255;
					}
				}
				sourcePixel = lime__$internal_graphics_ImageDataUtil.bilinear(s1,s2,s3,s4,disX * sourceView.width - disOffsetXFloor,disY * sourceView.height - disOffsetYFloor);
			} else {
				var offset9 = sourceView.byteOffset + sourceView.stride * (y + disOffsetYFloor) + (x + disOffsetXFloor) * 4;
				switch(sourceFormat) {
				case 0:
					sourcePixel = (sourceData[offset9] & 255) << 24 | (sourceData[offset9 + 1] & 255) << 16 | (sourceData[offset9 + 2] & 255) << 8 | sourceData[offset9 + 3] & 255;
					break;
				case 1:
					sourcePixel = (sourceData[offset9 + 1] & 255) << 24 | (sourceData[offset9 + 2] & 255) << 16 | (sourceData[offset9 + 3] & 255) << 8 | sourceData[offset9] & 255;
					break;
				case 2:
					sourcePixel = (sourceData[offset9 + 2] & 255) << 24 | (sourceData[offset9 + 1] & 255) << 16 | (sourceData[offset9] & 255) << 8 | sourceData[offset9 + 3] & 255;
					break;
				}
				if(sourcePremultiplied) {
					if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (sourcePixel & 255);
						sourcePixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
					}
				}
			}
			if(targetPremultiplied) {
				if((sourcePixel & 255) == 0) {
					if(sourcePixel != 0) {
						sourcePixel = 0;
					}
				} else if((sourcePixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[sourcePixel & 255];
					sourcePixel = ((sourcePixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((sourcePixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((sourcePixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | sourcePixel & 255 & 255;
				}
			}
			switch(targetFormat) {
			case 0:
				targetData[sourceOffset] = sourcePixel >>> 24 & 255;
				targetData[sourceOffset + 1] = sourcePixel >>> 16 & 255;
				targetData[sourceOffset + 2] = sourcePixel >>> 8 & 255;
				targetData[sourceOffset + 3] = sourcePixel & 255;
				break;
			case 1:
				targetData[sourceOffset] = sourcePixel & 255;
				targetData[sourceOffset + 1] = sourcePixel >>> 24 & 255;
				targetData[sourceOffset + 2] = sourcePixel >>> 16 & 255;
				targetData[sourceOffset + 3] = sourcePixel >>> 8 & 255;
				break;
			case 2:
				targetData[sourceOffset] = sourcePixel >>> 8 & 255;
				targetData[sourceOffset + 1] = sourcePixel >>> 16 & 255;
				targetData[sourceOffset + 2] = sourcePixel >>> 24 & 255;
				targetData[sourceOffset + 3] = sourcePixel & 255;
				break;
			}
		}
	}
	target.dirty = true;
	target.version++;
};
lime__$internal_graphics_ImageDataUtil.bilinear = function(s1,s2,s3,s4,su,sv) {
	return lime__$internal_graphics_ImageDataUtil.lerpRGBA(lime__$internal_graphics_ImageDataUtil.lerpRGBA(s4,s2,su),lime__$internal_graphics_ImageDataUtil.lerpRGBA(s1,s3,su),sv);
};
lime__$internal_graphics_ImageDataUtil.lerpRGBA = function(v0,v1,x) {
	var result = 0;
	var value = Math.floor(lime__$internal_graphics_ImageDataUtil.lerp(v0 >>> 24 & 255,v1 >>> 24 & 255,x));
	result = (value & 255) << 24 | (result >>> 16 & 255 & 255) << 16 | (result >>> 8 & 255 & 255) << 8 | result & 255 & 255;
	var value1 = Math.floor(lime__$internal_graphics_ImageDataUtil.lerp(v0 >>> 16 & 255,v1 >>> 16 & 255,x));
	result = (result >>> 24 & 255 & 255) << 24 | (value1 & 255) << 16 | (result >>> 8 & 255 & 255) << 8 | result & 255 & 255;
	var value2 = Math.floor(lime__$internal_graphics_ImageDataUtil.lerp(v0 >>> 8 & 255,v1 >>> 8 & 255,x));
	result = (result >>> 24 & 255 & 255) << 24 | (result >>> 16 & 255 & 255) << 16 | (value2 & 255) << 8 | result & 255 & 255;
	var value3 = Math.floor(lime__$internal_graphics_ImageDataUtil.lerp(v0 & 255,v1 & 255,x));
	result = (result >>> 24 & 255 & 255) << 24 | (result >>> 16 & 255 & 255) << 16 | (result >>> 8 & 255 & 255) << 8 | value3 & 255;
	return result;
};
lime__$internal_graphics_ImageDataUtil.lerp4f = function(v0,v1,x) {
	return new lime_math_Vector4(lime__$internal_graphics_ImageDataUtil.lerp(v0.x,v1.x,x),lime__$internal_graphics_ImageDataUtil.lerp(v0.y,v1.y,x),lime__$internal_graphics_ImageDataUtil.lerp(v0.z,v1.z,x),lime__$internal_graphics_ImageDataUtil.lerp(v0.w,v1.w,x));
};
lime__$internal_graphics_ImageDataUtil.lerp = function(v0,v1,x) {
	return (1.0 - x) * v0 + x * v1;
};
lime__$internal_graphics_ImageDataUtil.colorTransform = function(image,rect,colorMatrix) {
	var data = image.buffer.data;
	if(data == null) {
		return;
	}
	var format = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	var dataView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,rect);
	var alphaTable = lime_math__$ColorMatrix_ColorMatrix_$Impl_$.getAlphaTable(colorMatrix);
	var redTable = lime_math__$ColorMatrix_ColorMatrix_$Impl_$.getRedTable(colorMatrix);
	var greenTable = lime_math__$ColorMatrix_ColorMatrix_$Impl_$.getGreenTable(colorMatrix);
	var blueTable = lime_math__$ColorMatrix_ColorMatrix_$Impl_$.getBlueTable(colorMatrix);
	var row;
	var offset;
	var pixel = 0;
	var _g1 = 0;
	var _g = dataView.height;
	while(_g1 < _g) {
		var y = _g1++;
		row = dataView.byteOffset + dataView.stride * y;
		var _g3 = 0;
		var _g2 = dataView.width;
		while(_g3 < _g2) {
			var x = _g3++;
			offset = row + x * 4;
			switch(format) {
			case 0:
				pixel = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
				break;
			case 1:
				pixel = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
				break;
			case 2:
				pixel = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
				break;
			}
			if(premultiplied) {
				if((pixel & 255) != 0 && (pixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (pixel & 255);
					pixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | pixel & 255 & 255;
				}
			}
			pixel = (redTable[pixel >>> 24 & 255] & 255) << 24 | (greenTable[pixel >>> 16 & 255] & 255) << 16 | (blueTable[pixel >>> 8 & 255] & 255) << 8 | alphaTable[pixel & 255] & 255;
			if(premultiplied) {
				if((pixel & 255) == 0) {
					if(pixel != 0) {
						pixel = 0;
					}
				} else if((pixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[pixel & 255];
					pixel = ((pixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((pixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((pixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | pixel & 255 & 255;
				}
			}
			switch(format) {
			case 0:
				data[offset] = pixel >>> 24 & 255;
				data[offset + 1] = pixel >>> 16 & 255;
				data[offset + 2] = pixel >>> 8 & 255;
				data[offset + 3] = pixel & 255;
				break;
			case 1:
				data[offset] = pixel & 255;
				data[offset + 1] = pixel >>> 24 & 255;
				data[offset + 2] = pixel >>> 16 & 255;
				data[offset + 3] = pixel >>> 8 & 255;
				break;
			case 2:
				data[offset] = pixel >>> 8 & 255;
				data[offset + 1] = pixel >>> 16 & 255;
				data[offset + 2] = pixel >>> 24 & 255;
				data[offset + 3] = pixel & 255;
				break;
			}
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.copyChannel = function(image,sourceImage,sourceRect,destPoint,sourceChannel,destChannel) {
	var destIdx;
	switch(destChannel[1]) {
	case 0:
		destIdx = 0;
		break;
	case 1:
		destIdx = 1;
		break;
	case 2:
		destIdx = 2;
		break;
	case 3:
		destIdx = 3;
		break;
	}
	var srcIdx;
	switch(sourceChannel[1]) {
	case 0:
		srcIdx = 0;
		break;
	case 1:
		srcIdx = 1;
		break;
	case 2:
		srcIdx = 2;
		break;
	case 3:
		srcIdx = 3;
		break;
	}
	var srcData = sourceImage.buffer.data;
	var destData = image.buffer.data;
	if(srcData == null || destData == null) {
		return;
	}
	var srcView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(sourceImage,sourceRect);
	var destView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,new lime_math_Rectangle(destPoint.x,destPoint.y,srcView.width,srcView.height));
	var srcFormat = sourceImage.buffer.format;
	var destFormat = image.buffer.format;
	var srcPremultiplied = sourceImage.buffer.premultiplied;
	var destPremultiplied = image.buffer.premultiplied;
	var srcPosition;
	var destPosition;
	var srcPixel = 0;
	var destPixel = 0;
	var value = 0;
	var _g1 = 0;
	var _g = destView.height;
	while(_g1 < _g) {
		var y = _g1++;
		srcPosition = srcView.byteOffset + srcView.stride * y;
		destPosition = destView.byteOffset + destView.stride * y;
		var _g3 = 0;
		var _g2 = destView.width;
		while(_g3 < _g2) {
			var x = _g3++;
			switch(srcFormat) {
			case 0:
				srcPixel = (srcData[srcPosition] & 255) << 24 | (srcData[srcPosition + 1] & 255) << 16 | (srcData[srcPosition + 2] & 255) << 8 | srcData[srcPosition + 3] & 255;
				break;
			case 1:
				srcPixel = (srcData[srcPosition + 1] & 255) << 24 | (srcData[srcPosition + 2] & 255) << 16 | (srcData[srcPosition + 3] & 255) << 8 | srcData[srcPosition] & 255;
				break;
			case 2:
				srcPixel = (srcData[srcPosition + 2] & 255) << 24 | (srcData[srcPosition + 1] & 255) << 16 | (srcData[srcPosition] & 255) << 8 | srcData[srcPosition + 3] & 255;
				break;
			}
			if(srcPremultiplied) {
				if((srcPixel & 255) != 0 && (srcPixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (srcPixel & 255);
					srcPixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((srcPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((srcPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((srcPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | srcPixel & 255 & 255;
				}
			}
			switch(destFormat) {
			case 0:
				destPixel = (destData[destPosition] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition + 2] & 255) << 8 | destData[destPosition + 3] & 255;
				break;
			case 1:
				destPixel = (destData[destPosition + 1] & 255) << 24 | (destData[destPosition + 2] & 255) << 16 | (destData[destPosition + 3] & 255) << 8 | destData[destPosition] & 255;
				break;
			case 2:
				destPixel = (destData[destPosition + 2] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition] & 255) << 8 | destData[destPosition + 3] & 255;
				break;
			}
			if(destPremultiplied) {
				if((destPixel & 255) != 0 && (destPixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (destPixel & 255);
					destPixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | destPixel & 255 & 255;
				}
			}
			switch(srcIdx) {
			case 0:
				value = srcPixel >>> 24 & 255;
				break;
			case 1:
				value = srcPixel >>> 16 & 255;
				break;
			case 2:
				value = srcPixel >>> 8 & 255;
				break;
			case 3:
				value = srcPixel & 255;
				break;
			}
			switch(destIdx) {
			case 0:
				destPixel = (value & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
				break;
			case 1:
				destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (value & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
				break;
			case 2:
				destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (value & 255) << 8 | destPixel & 255 & 255;
				break;
			case 3:
				destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | value & 255;
				break;
			}
			if(destPremultiplied) {
				if((destPixel & 255) == 0) {
					if(destPixel != 0) {
						destPixel = 0;
					}
				} else if((destPixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[destPixel & 255];
					destPixel = ((destPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((destPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((destPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | destPixel & 255 & 255;
				}
			}
			switch(destFormat) {
			case 0:
				destData[destPosition] = destPixel >>> 24 & 255;
				destData[destPosition + 1] = destPixel >>> 16 & 255;
				destData[destPosition + 2] = destPixel >>> 8 & 255;
				destData[destPosition + 3] = destPixel & 255;
				break;
			case 1:
				destData[destPosition] = destPixel & 255;
				destData[destPosition + 1] = destPixel >>> 24 & 255;
				destData[destPosition + 2] = destPixel >>> 16 & 255;
				destData[destPosition + 3] = destPixel >>> 8 & 255;
				break;
			case 2:
				destData[destPosition] = destPixel >>> 8 & 255;
				destData[destPosition + 1] = destPixel >>> 16 & 255;
				destData[destPosition + 2] = destPixel >>> 24 & 255;
				destData[destPosition + 3] = destPixel & 255;
				break;
			}
			srcPosition += 4;
			destPosition += 4;
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.copyPixels = function(image,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha) {
	if(mergeAlpha == null) {
		mergeAlpha = false;
	}
	if(image.width == sourceImage.width && image.height == sourceImage.height && sourceRect.width == sourceImage.width && sourceRect.height == sourceImage.height && sourceRect.x == 0 && sourceRect.y == 0 && destPoint.x == 0 && destPoint.y == 0 && alphaImage == null && alphaPoint == null && mergeAlpha == false && image.get_format() == sourceImage.get_format()) {
		image.buffer.data.set(sourceImage.buffer.data);
	} else {
		var sourceData = sourceImage.buffer.data;
		var destData = image.buffer.data;
		if(sourceData == null || destData == null) {
			return;
		}
		var sourceView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(sourceImage,sourceRect);
		var destRect = new lime_math_Rectangle(destPoint.x,destPoint.y,sourceView.width,sourceView.height);
		var destView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,destRect);
		var sourceFormat = sourceImage.buffer.format;
		var destFormat = image.buffer.format;
		var sourcePosition;
		var destPosition;
		var sourceAlpha;
		var destAlpha;
		var oneMinusSourceAlpha;
		var blendAlpha;
		var sourcePixel = 0;
		var destPixel = 0;
		var sourcePremultiplied = sourceImage.buffer.premultiplied;
		var destPremultiplied = image.buffer.premultiplied;
		var sourceBytesPerPixel = sourceImage.buffer.bitsPerPixel / 8 | 0;
		var destBytesPerPixel = image.buffer.bitsPerPixel / 8 | 0;
		var useAlphaImage = alphaImage != null && alphaImage.get_transparent();
		var blend = mergeAlpha || useAlphaImage && !image.get_transparent() || !mergeAlpha && !image.get_transparent() && sourceImage.get_transparent();
		if(!useAlphaImage) {
			if(blend) {
				var _g1 = 0;
				var _g = destView.height;
				while(_g1 < _g) {
					var y = _g1++;
					sourcePosition = sourceView.byteOffset + sourceView.stride * y;
					destPosition = destView.byteOffset + destView.stride * y;
					var _g3 = 0;
					var _g2 = destView.width;
					while(_g3 < _g2) {
						var x = _g3++;
						switch(sourceFormat) {
						case 0:
							sourcePixel = (sourceData[sourcePosition] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition + 2] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						case 1:
							sourcePixel = (sourceData[sourcePosition + 1] & 255) << 24 | (sourceData[sourcePosition + 2] & 255) << 16 | (sourceData[sourcePosition + 3] & 255) << 8 | sourceData[sourcePosition] & 255;
							break;
						case 2:
							sourcePixel = (sourceData[sourcePosition + 2] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						}
						if(sourcePremultiplied) {
							if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
								lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (sourcePixel & 255);
								sourcePixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						switch(destFormat) {
						case 0:
							destPixel = (destData[destPosition] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition + 2] & 255) << 8 | destData[destPosition + 3] & 255;
							break;
						case 1:
							destPixel = (destData[destPosition + 1] & 255) << 24 | (destData[destPosition + 2] & 255) << 16 | (destData[destPosition + 3] & 255) << 8 | destData[destPosition] & 255;
							break;
						case 2:
							destPixel = (destData[destPosition + 2] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition] & 255) << 8 | destData[destPosition + 3] & 255;
							break;
						}
						if(destPremultiplied) {
							if((destPixel & 255) != 0 && (destPixel & 255) != 255) {
								lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (destPixel & 255);
								destPixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | destPixel & 255 & 255;
							}
						}
						sourceAlpha = (sourcePixel & 255) / 255.0;
						destAlpha = (destPixel & 255) / 255.0;
						oneMinusSourceAlpha = 1 - sourceAlpha;
						blendAlpha = sourceAlpha + destAlpha * oneMinusSourceAlpha;
						if(blendAlpha == 0) {
							destPixel = 0;
						} else {
							var value = lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round(((sourcePixel >>> 24 & 255) * sourceAlpha + (destPixel >>> 24 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (value & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
							var value1 = lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round(((sourcePixel >>> 16 & 255) * sourceAlpha + (destPixel >>> 16 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (value1 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
							var value2 = lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round(((sourcePixel >>> 8 & 255) * sourceAlpha + (destPixel >>> 8 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (value2 & 255) << 8 | destPixel & 255 & 255;
							var value3 = lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round(blendAlpha * 255.0)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | value3 & 255;
						}
						if(destPremultiplied) {
							if((destPixel & 255) == 0) {
								if(destPixel != 0) {
									destPixel = 0;
								}
							} else if((destPixel & 255) != 255) {
								lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[destPixel & 255];
								destPixel = ((destPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((destPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((destPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | destPixel & 255 & 255;
							}
						}
						switch(destFormat) {
						case 0:
							destData[destPosition] = destPixel >>> 24 & 255;
							destData[destPosition + 1] = destPixel >>> 16 & 255;
							destData[destPosition + 2] = destPixel >>> 8 & 255;
							destData[destPosition + 3] = destPixel & 255;
							break;
						case 1:
							destData[destPosition] = destPixel & 255;
							destData[destPosition + 1] = destPixel >>> 24 & 255;
							destData[destPosition + 2] = destPixel >>> 16 & 255;
							destData[destPosition + 3] = destPixel >>> 8 & 255;
							break;
						case 2:
							destData[destPosition] = destPixel >>> 8 & 255;
							destData[destPosition + 1] = destPixel >>> 16 & 255;
							destData[destPosition + 2] = destPixel >>> 24 & 255;
							destData[destPosition + 3] = destPixel & 255;
							break;
						}
						sourcePosition += 4;
						destPosition += 4;
					}
				}
			} else if(sourceFormat == destFormat && sourcePremultiplied == destPremultiplied && sourceBytesPerPixel == destBytesPerPixel) {
				var _g11 = 0;
				var _g4 = destView.height;
				while(_g11 < _g4) {
					var y1 = _g11++;
					sourcePosition = sourceView.byteOffset + sourceView.stride * y1;
					destPosition = destView.byteOffset + destView.stride * y1;
					destData.set(sourceData.subarray(sourcePosition,sourcePosition + destView.width * destBytesPerPixel),destPosition);
				}
			} else {
				var _g12 = 0;
				var _g5 = destView.height;
				while(_g12 < _g5) {
					var y2 = _g12++;
					sourcePosition = sourceView.byteOffset + sourceView.stride * y2;
					destPosition = destView.byteOffset + destView.stride * y2;
					var _g31 = 0;
					var _g21 = destView.width;
					while(_g31 < _g21) {
						var x1 = _g31++;
						switch(sourceFormat) {
						case 0:
							sourcePixel = (sourceData[sourcePosition] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition + 2] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						case 1:
							sourcePixel = (sourceData[sourcePosition + 1] & 255) << 24 | (sourceData[sourcePosition + 2] & 255) << 16 | (sourceData[sourcePosition + 3] & 255) << 8 | sourceData[sourcePosition] & 255;
							break;
						case 2:
							sourcePixel = (sourceData[sourcePosition + 2] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						}
						if(sourcePremultiplied) {
							if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
								lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (sourcePixel & 255);
								sourcePixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						if(destPremultiplied) {
							if((sourcePixel & 255) == 0) {
								if(sourcePixel != 0) {
									sourcePixel = 0;
								}
							} else if((sourcePixel & 255) != 255) {
								lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[sourcePixel & 255];
								sourcePixel = ((sourcePixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((sourcePixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((sourcePixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						switch(destFormat) {
						case 0:
							destData[destPosition] = sourcePixel >>> 24 & 255;
							destData[destPosition + 1] = sourcePixel >>> 16 & 255;
							destData[destPosition + 2] = sourcePixel >>> 8 & 255;
							destData[destPosition + 3] = sourcePixel & 255;
							break;
						case 1:
							destData[destPosition] = sourcePixel & 255;
							destData[destPosition + 1] = sourcePixel >>> 24 & 255;
							destData[destPosition + 2] = sourcePixel >>> 16 & 255;
							destData[destPosition + 3] = sourcePixel >>> 8 & 255;
							break;
						case 2:
							destData[destPosition] = sourcePixel >>> 8 & 255;
							destData[destPosition + 1] = sourcePixel >>> 16 & 255;
							destData[destPosition + 2] = sourcePixel >>> 24 & 255;
							destData[destPosition + 3] = sourcePixel & 255;
							break;
						}
						sourcePosition += 4;
						destPosition += 4;
					}
				}
			}
		} else {
			var alphaData = alphaImage.buffer.data;
			var alphaFormat = alphaImage.buffer.format;
			var alphaPosition;
			var alphaPixel = 0;
			var alphaView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(alphaImage,new lime_math_Rectangle(sourceView.x + (alphaPoint == null ? 0 : alphaPoint.x),sourceView.y + (alphaPoint == null ? 0 : alphaPoint.y),sourceView.width,sourceView.height));
			destView.clip(destPoint.x | 0,destPoint.y | 0,alphaView.width,alphaView.height);
			if(blend) {
				var _g13 = 0;
				var _g6 = destView.height;
				while(_g13 < _g6) {
					var y3 = _g13++;
					sourcePosition = sourceView.byteOffset + sourceView.stride * y3;
					destPosition = destView.byteOffset + destView.stride * y3;
					alphaPosition = alphaView.byteOffset + alphaView.stride * y3;
					var _g32 = 0;
					var _g22 = destView.width;
					while(_g32 < _g22) {
						var x2 = _g32++;
						switch(sourceFormat) {
						case 0:
							sourcePixel = (sourceData[sourcePosition] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition + 2] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						case 1:
							sourcePixel = (sourceData[sourcePosition + 1] & 255) << 24 | (sourceData[sourcePosition + 2] & 255) << 16 | (sourceData[sourcePosition + 3] & 255) << 8 | sourceData[sourcePosition] & 255;
							break;
						case 2:
							sourcePixel = (sourceData[sourcePosition + 2] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						}
						if(sourcePremultiplied) {
							if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
								lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (sourcePixel & 255);
								sourcePixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						switch(destFormat) {
						case 0:
							destPixel = (destData[destPosition] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition + 2] & 255) << 8 | destData[destPosition + 3] & 255;
							break;
						case 1:
							destPixel = (destData[destPosition + 1] & 255) << 24 | (destData[destPosition + 2] & 255) << 16 | (destData[destPosition + 3] & 255) << 8 | destData[destPosition] & 255;
							break;
						case 2:
							destPixel = (destData[destPosition + 2] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition] & 255) << 8 | destData[destPosition + 3] & 255;
							break;
						}
						if(destPremultiplied) {
							if((destPixel & 255) != 0 && (destPixel & 255) != 255) {
								lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (destPixel & 255);
								destPixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | destPixel & 255 & 255;
							}
						}
						switch(alphaFormat) {
						case 0:
							alphaPixel = (alphaData[alphaPosition] & 255) << 24 | (alphaData[alphaPosition + 1] & 255) << 16 | (alphaData[alphaPosition + 2] & 255) << 8 | alphaData[alphaPosition + 3] & 255;
							break;
						case 1:
							alphaPixel = (alphaData[alphaPosition + 1] & 255) << 24 | (alphaData[alphaPosition + 2] & 255) << 16 | (alphaData[alphaPosition + 3] & 255) << 8 | alphaData[alphaPosition] & 255;
							break;
						case 2:
							alphaPixel = (alphaData[alphaPosition + 2] & 255) << 24 | (alphaData[alphaPosition + 1] & 255) << 16 | (alphaData[alphaPosition] & 255) << 8 | alphaData[alphaPosition + 3] & 255;
							break;
						}
						sourceAlpha = (alphaPixel & 255) / 255.0 * ((sourcePixel & 255) / 255.0);
						if(sourceAlpha > 0) {
							destAlpha = (destPixel & 255) / 255.0;
							oneMinusSourceAlpha = 1 - sourceAlpha;
							blendAlpha = sourceAlpha + destAlpha * oneMinusSourceAlpha;
							var value4 = lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round(((sourcePixel >>> 24 & 255) * sourceAlpha + (destPixel >>> 24 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (value4 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
							var value5 = lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round(((sourcePixel >>> 16 & 255) * sourceAlpha + (destPixel >>> 16 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (value5 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
							var value6 = lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round(((sourcePixel >>> 8 & 255) * sourceAlpha + (destPixel >>> 8 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (value6 & 255) << 8 | destPixel & 255 & 255;
							var value7 = lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round(blendAlpha * 255.0)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | value7 & 255;
							if(destPremultiplied) {
								if((destPixel & 255) == 0) {
									if(destPixel != 0) {
										destPixel = 0;
									}
								} else if((destPixel & 255) != 255) {
									lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[destPixel & 255];
									destPixel = ((destPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((destPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((destPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | destPixel & 255 & 255;
								}
							}
							switch(destFormat) {
							case 0:
								destData[destPosition] = destPixel >>> 24 & 255;
								destData[destPosition + 1] = destPixel >>> 16 & 255;
								destData[destPosition + 2] = destPixel >>> 8 & 255;
								destData[destPosition + 3] = destPixel & 255;
								break;
							case 1:
								destData[destPosition] = destPixel & 255;
								destData[destPosition + 1] = destPixel >>> 24 & 255;
								destData[destPosition + 2] = destPixel >>> 16 & 255;
								destData[destPosition + 3] = destPixel >>> 8 & 255;
								break;
							case 2:
								destData[destPosition] = destPixel >>> 8 & 255;
								destData[destPosition + 1] = destPixel >>> 16 & 255;
								destData[destPosition + 2] = destPixel >>> 24 & 255;
								destData[destPosition + 3] = destPixel & 255;
								break;
							}
						}
						sourcePosition += 4;
						destPosition += 4;
						alphaPosition += 4;
					}
				}
			} else {
				var _g14 = 0;
				var _g7 = destView.height;
				while(_g14 < _g7) {
					var y4 = _g14++;
					sourcePosition = sourceView.byteOffset + sourceView.stride * y4;
					destPosition = destView.byteOffset + destView.stride * y4;
					alphaPosition = alphaView.byteOffset + alphaView.stride * y4;
					var _g33 = 0;
					var _g23 = destView.width;
					while(_g33 < _g23) {
						var x3 = _g33++;
						switch(sourceFormat) {
						case 0:
							sourcePixel = (sourceData[sourcePosition] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition + 2] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						case 1:
							sourcePixel = (sourceData[sourcePosition + 1] & 255) << 24 | (sourceData[sourcePosition + 2] & 255) << 16 | (sourceData[sourcePosition + 3] & 255) << 8 | sourceData[sourcePosition] & 255;
							break;
						case 2:
							sourcePixel = (sourceData[sourcePosition + 2] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						}
						if(sourcePremultiplied) {
							if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
								lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (sourcePixel & 255);
								sourcePixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						switch(alphaFormat) {
						case 0:
							alphaPixel = (alphaData[alphaPosition] & 255) << 24 | (alphaData[alphaPosition + 1] & 255) << 16 | (alphaData[alphaPosition + 2] & 255) << 8 | alphaData[alphaPosition + 3] & 255;
							break;
						case 1:
							alphaPixel = (alphaData[alphaPosition + 1] & 255) << 24 | (alphaData[alphaPosition + 2] & 255) << 16 | (alphaData[alphaPosition + 3] & 255) << 8 | alphaData[alphaPosition] & 255;
							break;
						case 2:
							alphaPixel = (alphaData[alphaPosition + 2] & 255) << 24 | (alphaData[alphaPosition + 1] & 255) << 16 | (alphaData[alphaPosition] & 255) << 8 | alphaData[alphaPosition + 3] & 255;
							break;
						}
						var value8 = Math.round((sourcePixel & 255) * ((alphaPixel & 255) / 255));
						sourcePixel = (sourcePixel >>> 24 & 255 & 255) << 24 | (sourcePixel >>> 16 & 255 & 255) << 16 | (sourcePixel >>> 8 & 255 & 255) << 8 | value8 & 255;
						if(destPremultiplied) {
							if((sourcePixel & 255) == 0) {
								if(sourcePixel != 0) {
									sourcePixel = 0;
								}
							} else if((sourcePixel & 255) != 255) {
								lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[sourcePixel & 255];
								sourcePixel = ((sourcePixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((sourcePixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((sourcePixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						switch(destFormat) {
						case 0:
							destData[destPosition] = sourcePixel >>> 24 & 255;
							destData[destPosition + 1] = sourcePixel >>> 16 & 255;
							destData[destPosition + 2] = sourcePixel >>> 8 & 255;
							destData[destPosition + 3] = sourcePixel & 255;
							break;
						case 1:
							destData[destPosition] = sourcePixel & 255;
							destData[destPosition + 1] = sourcePixel >>> 24 & 255;
							destData[destPosition + 2] = sourcePixel >>> 16 & 255;
							destData[destPosition + 3] = sourcePixel >>> 8 & 255;
							break;
						case 2:
							destData[destPosition] = sourcePixel >>> 8 & 255;
							destData[destPosition + 1] = sourcePixel >>> 16 & 255;
							destData[destPosition + 2] = sourcePixel >>> 24 & 255;
							destData[destPosition + 3] = sourcePixel & 255;
							break;
						}
						sourcePosition += 4;
						destPosition += 4;
						alphaPosition += 4;
					}
				}
			}
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.fillRect = function(image,rect,color,format) {
	var fillColor;
	switch(format) {
	case 1:
		var argb = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		fillColor = rgba;
		break;
	case 2:
		var bgra = color;
		var this2 = 0;
		var rgba1 = this2;
		rgba1 = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		fillColor = rgba1;
		break;
	default:
		fillColor = color;
	}
	if(!image.get_transparent()) {
		fillColor = (fillColor >>> 24 & 255 & 255) << 24 | (fillColor >>> 16 & 255 & 255) << 16 | (fillColor >>> 8 & 255 & 255) << 8 | 255;
	}
	var data = image.buffer.data;
	if(data == null) {
		return;
	}
	var format1 = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	if(premultiplied) {
		if((fillColor & 255) == 0) {
			if(fillColor != 0) {
				fillColor = 0;
			}
		} else if((fillColor & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[fillColor & 255];
			fillColor = ((fillColor >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((fillColor >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((fillColor >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | fillColor & 255 & 255;
		}
	}
	var dataView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,rect);
	var row;
	var _g1 = 0;
	var _g = dataView.height;
	while(_g1 < _g) {
		var y = _g1++;
		row = dataView.byteOffset + dataView.stride * y;
		var _g3 = 0;
		var _g2 = dataView.width;
		while(_g3 < _g2) {
			var x = _g3++;
			var offset = row + x * 4;
			switch(format1) {
			case 0:
				data[offset] = fillColor >>> 24 & 255;
				data[offset + 1] = fillColor >>> 16 & 255;
				data[offset + 2] = fillColor >>> 8 & 255;
				data[offset + 3] = fillColor & 255;
				break;
			case 1:
				data[offset] = fillColor & 255;
				data[offset + 1] = fillColor >>> 24 & 255;
				data[offset + 2] = fillColor >>> 16 & 255;
				data[offset + 3] = fillColor >>> 8 & 255;
				break;
			case 2:
				data[offset] = fillColor >>> 8 & 255;
				data[offset + 1] = fillColor >>> 16 & 255;
				data[offset + 2] = fillColor >>> 24 & 255;
				data[offset + 3] = fillColor & 255;
				break;
			}
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.floodFill = function(image,x,y,color,format) {
	var data = image.buffer.data;
	if(data == null) {
		return;
	}
	if(format == 1) {
		color = (color & 16777215) << 8 | color >> 24 & 255;
	}
	var format1 = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	var fillColor = color;
	var hitColor = 0;
	var offset = (y + image.offsetY) * (image.buffer.width * 4) + (x + image.offsetX) * 4;
	switch(format1) {
	case 0:
		hitColor = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		hitColor = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		hitColor = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied) {
		if((hitColor & 255) != 0 && (hitColor & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (hitColor & 255);
			hitColor = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((hitColor >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((hitColor >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((hitColor >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | hitColor & 255 & 255;
		}
	}
	if(!image.get_transparent()) {
		fillColor = (fillColor >>> 24 & 255 & 255) << 24 | (fillColor >>> 16 & 255 & 255) << 16 | (fillColor >>> 8 & 255 & 255) << 8 | 255;
		hitColor = (hitColor >>> 24 & 255 & 255) << 24 | (hitColor >>> 16 & 255 & 255) << 16 | (hitColor >>> 8 & 255 & 255) << 8 | 255;
	}
	if(fillColor == hitColor) {
		return;
	}
	if(premultiplied) {
		if((fillColor & 255) == 0) {
			if(fillColor != 0) {
				fillColor = 0;
			}
		} else if((fillColor & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[fillColor & 255];
			fillColor = ((fillColor >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((fillColor >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((fillColor >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | fillColor & 255 & 255;
		}
	}
	var dx = [0,-1,1,0];
	var dy = [-1,0,0,1];
	var minX = -image.offsetX;
	var minY = -image.offsetY;
	var maxX = minX + image.width;
	var maxY = minY + image.height;
	var queue = [];
	queue.push(x);
	queue.push(y);
	var curPointX;
	var curPointY;
	var nextPointX;
	var nextPointY;
	var nextPointOffset;
	var readColor = 0;
	while(queue.length > 0) {
		curPointY = queue.pop();
		curPointX = queue.pop();
		var _g = 0;
		while(_g < 4) {
			var i = _g++;
			nextPointX = curPointX + dx[i];
			nextPointY = curPointY + dy[i];
			if(nextPointX < minX || nextPointY < minY || nextPointX >= maxX || nextPointY >= maxY) {
				continue;
			}
			nextPointOffset = (nextPointY * image.width + nextPointX) * 4;
			switch(format1) {
			case 0:
				readColor = (data[nextPointOffset] & 255) << 24 | (data[nextPointOffset + 1] & 255) << 16 | (data[nextPointOffset + 2] & 255) << 8 | data[nextPointOffset + 3] & 255;
				break;
			case 1:
				readColor = (data[nextPointOffset + 1] & 255) << 24 | (data[nextPointOffset + 2] & 255) << 16 | (data[nextPointOffset + 3] & 255) << 8 | data[nextPointOffset] & 255;
				break;
			case 2:
				readColor = (data[nextPointOffset + 2] & 255) << 24 | (data[nextPointOffset + 1] & 255) << 16 | (data[nextPointOffset] & 255) << 8 | data[nextPointOffset + 3] & 255;
				break;
			}
			if(premultiplied) {
				if((readColor & 255) != 0 && (readColor & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (readColor & 255);
					readColor = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((readColor >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((readColor >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((readColor >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | readColor & 255 & 255;
				}
			}
			if(readColor == hitColor) {
				switch(format1) {
				case 0:
					data[nextPointOffset] = fillColor >>> 24 & 255;
					data[nextPointOffset + 1] = fillColor >>> 16 & 255;
					data[nextPointOffset + 2] = fillColor >>> 8 & 255;
					data[nextPointOffset + 3] = fillColor & 255;
					break;
				case 1:
					data[nextPointOffset] = fillColor & 255;
					data[nextPointOffset + 1] = fillColor >>> 24 & 255;
					data[nextPointOffset + 2] = fillColor >>> 16 & 255;
					data[nextPointOffset + 3] = fillColor >>> 8 & 255;
					break;
				case 2:
					data[nextPointOffset] = fillColor >>> 8 & 255;
					data[nextPointOffset + 1] = fillColor >>> 16 & 255;
					data[nextPointOffset + 2] = fillColor >>> 24 & 255;
					data[nextPointOffset + 3] = fillColor & 255;
					break;
				}
				queue.push(nextPointX);
				queue.push(nextPointY);
			}
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.gaussianBlur = function(image,sourceImage,sourceRect,destPoint,blurX,blurY,quality,strength,color) {
	if(strength == null) {
		strength = 1;
	}
	if(quality == null) {
		quality = 1;
	}
	if(blurY == null) {
		blurY = 4;
	}
	if(blurX == null) {
		blurX = 4;
	}
	var imagePremultiplied = image.get_premultiplied();
	if(imagePremultiplied) {
		image.set_premultiplied(false);
	}
	lime__$internal_graphics_StackBlur.blur(image,sourceImage,sourceRect,destPoint,blurX,blurY,quality);
	image.dirty = true;
	image.version++;
	if(imagePremultiplied) {
		image.set_premultiplied(true);
	}
	return image;
};
lime__$internal_graphics_ImageDataUtil.getColorBoundsRect = function(image,mask,color,findColor,format) {
	var left = image.width + 1;
	var right = 0;
	var top = image.height + 1;
	var bottom = 0;
	var _color;
	var _mask;
	switch(format) {
	case 1:
		var argb = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		_color = rgba;
		var argb1 = mask;
		var this2 = 0;
		var rgba1 = this2;
		rgba1 = (argb1 >>> 16 & 255 & 255) << 24 | (argb1 >>> 8 & 255 & 255) << 16 | (argb1 & 255 & 255) << 8 | argb1 >>> 24 & 255 & 255;
		_mask = rgba1;
		break;
	case 2:
		var bgra = color;
		var this3 = 0;
		var rgba2 = this3;
		rgba2 = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		_color = rgba2;
		var bgra1 = mask;
		var this4 = 0;
		var rgba3 = this4;
		rgba3 = (bgra1 >>> 8 & 255 & 255) << 24 | (bgra1 >>> 16 & 255 & 255) << 16 | (bgra1 >>> 24 & 255 & 255) << 8 | bgra1 & 255 & 255;
		_mask = rgba3;
		break;
	default:
		_color = color;
		_mask = mask;
	}
	if(!image.get_transparent()) {
		_color = (_color >>> 24 & 255 & 255) << 24 | (_color >>> 16 & 255 & 255) << 16 | (_color >>> 8 & 255 & 255) << 8 | 255;
		_mask = (_mask >>> 24 & 255 & 255) << 24 | (_mask >>> 16 & 255 & 255) << 16 | (_mask >>> 8 & 255 & 255) << 8 | 255;
	}
	var pixel;
	var hit;
	var _g1 = 0;
	var _g = image.width;
	while(_g1 < _g) {
		var x = _g1++;
		hit = false;
		var _g3 = 0;
		var _g2 = image.height;
		while(_g3 < _g2) {
			var y = _g3++;
			pixel = image.getPixel32(x,y,0);
			if(findColor) {
				hit = (pixel & _mask) == _color;
			} else {
				hit = (pixel & _mask) != _color;
			}
			if(hit) {
				if(x < left) {
					left = x;
				}
				break;
			}
		}
		if(hit) {
			break;
		}
	}
	var ix;
	var _g11 = 0;
	var _g4 = image.width;
	while(_g11 < _g4) {
		var x1 = _g11++;
		ix = image.width - 1 - x1;
		hit = false;
		var _g31 = 0;
		var _g21 = image.height;
		while(_g31 < _g21) {
			var y1 = _g31++;
			pixel = image.getPixel32(ix,y1,0);
			if(findColor) {
				hit = (pixel & _mask) == _color;
			} else {
				hit = (pixel & _mask) != _color;
			}
			if(hit) {
				if(ix > right) {
					right = ix;
				}
				break;
			}
		}
		if(hit) {
			break;
		}
	}
	var _g12 = 0;
	var _g5 = image.height;
	while(_g12 < _g5) {
		var y2 = _g12++;
		hit = false;
		var _g32 = 0;
		var _g22 = image.width;
		while(_g32 < _g22) {
			var x2 = _g32++;
			pixel = image.getPixel32(x2,y2,0);
			if(findColor) {
				hit = (pixel & _mask) == _color;
			} else {
				hit = (pixel & _mask) != _color;
			}
			if(hit) {
				if(y2 < top) {
					top = y2;
				}
				break;
			}
		}
		if(hit) {
			break;
		}
	}
	var iy;
	var _g13 = 0;
	var _g6 = image.height;
	while(_g13 < _g6) {
		var y3 = _g13++;
		iy = image.height - 1 - y3;
		hit = false;
		var _g33 = 0;
		var _g23 = image.width;
		while(_g33 < _g23) {
			var x3 = _g33++;
			pixel = image.getPixel32(x3,iy,0);
			if(findColor) {
				hit = (pixel & _mask) == _color;
			} else {
				hit = (pixel & _mask) != _color;
			}
			if(hit) {
				if(iy > bottom) {
					bottom = iy;
				}
				break;
			}
		}
		if(hit) {
			break;
		}
	}
	var w = right - left;
	var h = bottom - top;
	if(w > 0) {
		++w;
	}
	if(h > 0) {
		++h;
	}
	if(w < 0) {
		w = 0;
	}
	if(h < 0) {
		h = 0;
	}
	if(left == right) {
		w = 1;
	}
	if(top == bottom) {
		h = 1;
	}
	if(left > image.width) {
		left = 0;
	}
	if(top > image.height) {
		top = 0;
	}
	return new lime_math_Rectangle(left,top,w,h);
};
lime__$internal_graphics_ImageDataUtil.getPixel = function(image,x,y,format) {
	var pixel = 0;
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	var premultiplied = image.buffer.premultiplied;
	switch(image.buffer.format) {
	case 0:
		pixel = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		pixel = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		pixel = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied) {
		if((pixel & 255) != 0 && (pixel & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (pixel & 255);
			pixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | pixel & 255 & 255;
		}
	}
	pixel = (pixel >>> 24 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 8 & 255 & 255) << 8 | 0;
	switch(format) {
	case 1:
		var this1 = 0;
		var argb = this1;
		argb = (pixel & 255 & 255) << 24 | (pixel >>> 24 & 255 & 255) << 16 | (pixel >>> 16 & 255 & 255) << 8 | pixel >>> 8 & 255 & 255;
		return argb;
	case 2:
		var this2 = 0;
		var bgra = this2;
		bgra = (pixel >>> 8 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 24 & 255 & 255) << 8 | pixel & 255 & 255;
		return bgra;
	default:
		return pixel;
	}
};
lime__$internal_graphics_ImageDataUtil.getPixel32 = function(image,x,y,format) {
	var pixel = 0;
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	var premultiplied = image.buffer.premultiplied;
	switch(image.buffer.format) {
	case 0:
		pixel = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		pixel = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		pixel = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied) {
		if((pixel & 255) != 0 && (pixel & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (pixel & 255);
			pixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | pixel & 255 & 255;
		}
	}
	switch(format) {
	case 1:
		var this1 = 0;
		var argb = this1;
		argb = (pixel & 255 & 255) << 24 | (pixel >>> 24 & 255 & 255) << 16 | (pixel >>> 16 & 255 & 255) << 8 | pixel >>> 8 & 255 & 255;
		return argb;
	case 2:
		var this2 = 0;
		var bgra = this2;
		bgra = (pixel >>> 8 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 24 & 255 & 255) << 8 | pixel & 255 & 255;
		return bgra;
	default:
		return pixel;
	}
};
lime__$internal_graphics_ImageDataUtil.getPixels = function(image,rect,format) {
	if(image.buffer.data == null) {
		return null;
	}
	var length = rect.width * rect.height | 0;
	var bytes = new haxe_io_Bytes(new ArrayBuffer(length * 4));
	var data = image.buffer.data;
	var sourceFormat = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	var dataView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,rect);
	var position;
	var argb = 0;
	var bgra = 0;
	var pixel = 0;
	var destPosition = 0;
	var _g1 = 0;
	var _g = dataView.height;
	while(_g1 < _g) {
		var y = _g1++;
		position = dataView.byteOffset + dataView.stride * y;
		var _g3 = 0;
		var _g2 = dataView.width;
		while(_g3 < _g2) {
			var x = _g3++;
			switch(sourceFormat) {
			case 0:
				pixel = (data[position] & 255) << 24 | (data[position + 1] & 255) << 16 | (data[position + 2] & 255) << 8 | data[position + 3] & 255;
				break;
			case 1:
				pixel = (data[position + 1] & 255) << 24 | (data[position + 2] & 255) << 16 | (data[position + 3] & 255) << 8 | data[position] & 255;
				break;
			case 2:
				pixel = (data[position + 2] & 255) << 24 | (data[position + 1] & 255) << 16 | (data[position] & 255) << 8 | data[position + 3] & 255;
				break;
			}
			if(premultiplied) {
				if((pixel & 255) != 0 && (pixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (pixel & 255);
					pixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | pixel & 255 & 255;
				}
			}
			switch(format) {
			case 1:
				var this1 = 0;
				var argb1 = this1;
				argb1 = (pixel & 255 & 255) << 24 | (pixel >>> 24 & 255 & 255) << 16 | (pixel >>> 16 & 255 & 255) << 8 | pixel >>> 8 & 255 & 255;
				argb = argb1;
				pixel = argb;
				break;
			case 2:
				var this2 = 0;
				var bgra1 = this2;
				bgra1 = (pixel >>> 8 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 24 & 255 & 255) << 8 | pixel & 255 & 255;
				bgra = bgra1;
				pixel = bgra;
				break;
			default:
			}
			bytes.b[destPosition++] = pixel >>> 24 & 255 & 255;
			bytes.b[destPosition++] = pixel >>> 16 & 255 & 255;
			bytes.b[destPosition++] = pixel >>> 8 & 255 & 255;
			bytes.b[destPosition++] = pixel & 255 & 255;
			position += 4;
		}
	}
	return bytes;
};
lime__$internal_graphics_ImageDataUtil.merge = function(image,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
	if(image.buffer.data == null || sourceImage.buffer.data == null) {
		return;
	}
	var sourceView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(sourceImage,sourceRect);
	var destView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,new lime_math_Rectangle(destPoint.x,destPoint.y,sourceView.width,sourceView.height));
	var sourceData = sourceImage.buffer.data;
	var destData = image.buffer.data;
	var sourceFormat = sourceImage.buffer.format;
	var destFormat = image.buffer.format;
	var sourcePremultiplied = sourceImage.buffer.premultiplied;
	var destPremultiplied = image.buffer.premultiplied;
	var sourcePosition;
	var destPosition;
	var sourcePixel = 0;
	var destPixel = 0;
	var _g1 = 0;
	var _g = destView.height;
	while(_g1 < _g) {
		var y = _g1++;
		sourcePosition = sourceView.byteOffset + sourceView.stride * y;
		destPosition = destView.byteOffset + destView.stride * y;
		var _g3 = 0;
		var _g2 = destView.width;
		while(_g3 < _g2) {
			var x = _g3++;
			switch(sourceFormat) {
			case 0:
				sourcePixel = (sourceData[sourcePosition] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition + 2] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
				break;
			case 1:
				sourcePixel = (sourceData[sourcePosition + 1] & 255) << 24 | (sourceData[sourcePosition + 2] & 255) << 16 | (sourceData[sourcePosition + 3] & 255) << 8 | sourceData[sourcePosition] & 255;
				break;
			case 2:
				sourcePixel = (sourceData[sourcePosition + 2] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
				break;
			}
			if(sourcePremultiplied) {
				if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (sourcePixel & 255);
					sourcePixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
				}
			}
			switch(destFormat) {
			case 0:
				destPixel = (destData[destPosition] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition + 2] & 255) << 8 | destData[destPosition + 3] & 255;
				break;
			case 1:
				destPixel = (destData[destPosition + 1] & 255) << 24 | (destData[destPosition + 2] & 255) << 16 | (destData[destPosition + 3] & 255) << 8 | destData[destPosition] & 255;
				break;
			case 2:
				destPixel = (destData[destPosition + 2] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition] & 255) << 8 | destData[destPosition + 3] & 255;
				break;
			}
			if(destPremultiplied) {
				if((destPixel & 255) != 0 && (destPixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (destPixel & 255);
					destPixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((destPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | destPixel & 255 & 255;
				}
			}
			var value = ((sourcePixel >>> 24 & 255) * redMultiplier + (destPixel >>> 24 & 255) * (256 - redMultiplier)) / 256 | 0;
			destPixel = (value & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
			var value1 = ((sourcePixel >>> 16 & 255) * greenMultiplier + (destPixel >>> 16 & 255) * (256 - greenMultiplier)) / 256 | 0;
			destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (value1 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
			var value2 = ((sourcePixel >>> 8 & 255) * blueMultiplier + (destPixel >>> 8 & 255) * (256 - blueMultiplier)) / 256 | 0;
			destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (value2 & 255) << 8 | destPixel & 255 & 255;
			var value3 = ((sourcePixel & 255) * alphaMultiplier + (destPixel & 255) * (256 - alphaMultiplier)) / 256 | 0;
			destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | value3 & 255;
			if(destPremultiplied) {
				if((destPixel & 255) == 0) {
					if(destPixel != 0) {
						destPixel = 0;
					}
				} else if((destPixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[destPixel & 255];
					destPixel = ((destPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((destPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((destPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | destPixel & 255 & 255;
				}
			}
			switch(destFormat) {
			case 0:
				destData[destPosition] = destPixel >>> 24 & 255;
				destData[destPosition + 1] = destPixel >>> 16 & 255;
				destData[destPosition + 2] = destPixel >>> 8 & 255;
				destData[destPosition + 3] = destPixel & 255;
				break;
			case 1:
				destData[destPosition] = destPixel & 255;
				destData[destPosition + 1] = destPixel >>> 24 & 255;
				destData[destPosition + 2] = destPixel >>> 16 & 255;
				destData[destPosition + 3] = destPixel >>> 8 & 255;
				break;
			case 2:
				destData[destPosition] = destPixel >>> 8 & 255;
				destData[destPosition + 1] = destPixel >>> 16 & 255;
				destData[destPosition + 2] = destPixel >>> 24 & 255;
				destData[destPosition + 3] = destPixel & 255;
				break;
			}
			sourcePosition += 4;
			destPosition += 4;
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.multiplyAlpha = function(image) {
	var data = image.buffer.data;
	if(data == null || !image.buffer.transparent) {
		return;
	}
	var format = image.buffer.format;
	var length = data.length / 4 | 0;
	var pixel = 0;
	var _g1 = 0;
	var _g = length;
	while(_g1 < _g) {
		var i = _g1++;
		var offset = i * 4;
		switch(format) {
		case 0:
			pixel = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
			break;
		case 1:
			pixel = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
			break;
		case 2:
			pixel = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
			break;
		}
		var offset1 = i * 4;
		if((pixel & 255) == 0) {
			if(pixel != 0) {
				pixel = 0;
			}
		} else if((pixel & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[pixel & 255];
			pixel = ((pixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((pixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((pixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | pixel & 255 & 255;
		}
		switch(format) {
		case 0:
			data[offset1] = pixel >>> 24 & 255;
			data[offset1 + 1] = pixel >>> 16 & 255;
			data[offset1 + 2] = pixel >>> 8 & 255;
			data[offset1 + 3] = pixel & 255;
			break;
		case 1:
			data[offset1] = pixel & 255;
			data[offset1 + 1] = pixel >>> 24 & 255;
			data[offset1 + 2] = pixel >>> 16 & 255;
			data[offset1 + 3] = pixel >>> 8 & 255;
			break;
		case 2:
			data[offset1] = pixel >>> 8 & 255;
			data[offset1 + 1] = pixel >>> 16 & 255;
			data[offset1 + 2] = pixel >>> 24 & 255;
			data[offset1 + 3] = pixel & 255;
			break;
		}
	}
	image.buffer.premultiplied = true;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.resize = function(image,newWidth,newHeight) {
	var buffer = image.buffer;
	if(buffer.width == newWidth && buffer.height == newHeight) {
		return;
	}
	var elements = newWidth * newHeight * 4;
	var this1;
	if(elements != null) {
		this1 = new Uint8Array(elements);
	} else {
		this1 = null;
	}
	var newBuffer = new lime_graphics_ImageBuffer(this1,newWidth,newHeight);
	var imageWidth = image.width;
	var imageHeight = image.height;
	var data = image.get_data();
	var newData = newBuffer.data;
	var sourceIndex;
	var sourceIndexX;
	var sourceIndexY;
	var sourceIndexXY;
	var index;
	var sourceX;
	var sourceY;
	var u;
	var v;
	var uRatio;
	var vRatio;
	var uOpposite;
	var vOpposite;
	var _g1 = 0;
	var _g = newHeight;
	while(_g1 < _g) {
		var y = _g1++;
		var _g3 = 0;
		var _g2 = newWidth;
		while(_g3 < _g2) {
			var x = _g3++;
			u = (x + 0.5) / newWidth * imageWidth - 0.5;
			v = (y + 0.5) / newHeight * imageHeight - 0.5;
			sourceX = u | 0;
			sourceY = v | 0;
			sourceIndex = (sourceY * imageWidth + sourceX) * 4;
			if(sourceX < imageWidth - 1) {
				sourceIndexX = sourceIndex + 4;
			} else {
				sourceIndexX = sourceIndex;
			}
			if(sourceY < imageHeight - 1) {
				sourceIndexY = sourceIndex + imageWidth * 4;
			} else {
				sourceIndexY = sourceIndex;
			}
			if(sourceIndexX != sourceIndex) {
				sourceIndexXY = sourceIndexY + 4;
			} else {
				sourceIndexXY = sourceIndexY;
			}
			index = (y * newWidth + x) * 4;
			uRatio = u - sourceX;
			vRatio = v - sourceY;
			uOpposite = 1 - uRatio;
			vOpposite = 1 - vRatio;
			newData[index] = (_$UInt_UInt_$Impl_$.toFloat(data[sourceIndex]) * uOpposite + _$UInt_UInt_$Impl_$.toFloat(data[sourceIndexX]) * uRatio) * vOpposite + (_$UInt_UInt_$Impl_$.toFloat(data[sourceIndexY]) * uOpposite + _$UInt_UInt_$Impl_$.toFloat(data[sourceIndexXY]) * uRatio) * vRatio | 0;
			newData[index + 1] = (_$UInt_UInt_$Impl_$.toFloat(data[sourceIndex + 1]) * uOpposite + _$UInt_UInt_$Impl_$.toFloat(data[sourceIndexX + 1]) * uRatio) * vOpposite + (_$UInt_UInt_$Impl_$.toFloat(data[sourceIndexY + 1]) * uOpposite + _$UInt_UInt_$Impl_$.toFloat(data[sourceIndexXY + 1]) * uRatio) * vRatio | 0;
			newData[index + 2] = (_$UInt_UInt_$Impl_$.toFloat(data[sourceIndex + 2]) * uOpposite + _$UInt_UInt_$Impl_$.toFloat(data[sourceIndexX + 2]) * uRatio) * vOpposite + (_$UInt_UInt_$Impl_$.toFloat(data[sourceIndexY + 2]) * uOpposite + _$UInt_UInt_$Impl_$.toFloat(data[sourceIndexXY + 2]) * uRatio) * vRatio | 0;
			if(data[sourceIndexX + 3] == 0 || data[sourceIndexY + 3] == 0 || data[sourceIndexXY + 3] == 0) {
				newData[index + 3] = 0;
			} else {
				newData[index + 3] = data[sourceIndex + 3];
			}
		}
	}
	buffer.data = newBuffer.data;
	buffer.width = newWidth;
	buffer.height = newHeight;
	buffer.__srcImage = null;
	buffer.__srcImageData = null;
	buffer.__srcCanvas = null;
	buffer.__srcContext = null;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.resizeBuffer = function(image,newWidth,newHeight) {
	var buffer = image.buffer;
	var data = image.get_data();
	var elements = newWidth * newHeight * 4;
	var this1;
	if(elements != null) {
		this1 = new Uint8Array(elements);
	} else {
		this1 = null;
	}
	var newData = this1;
	var sourceIndex;
	var index;
	var _g1 = 0;
	var _g = buffer.height;
	while(_g1 < _g) {
		var y = _g1++;
		var _g3 = 0;
		var _g2 = buffer.width;
		while(_g3 < _g2) {
			var x = _g3++;
			sourceIndex = (y * buffer.width + x) * 4;
			index = (y * newWidth + x) * 4;
			newData[index] = data[sourceIndex];
			newData[index + 1] = data[sourceIndex + 1];
			newData[index + 2] = data[sourceIndex + 2];
			newData[index + 3] = data[sourceIndex + 3];
		}
	}
	buffer.data = newData;
	buffer.width = newWidth;
	buffer.height = newHeight;
	buffer.__srcImage = null;
	buffer.__srcImageData = null;
	buffer.__srcCanvas = null;
	buffer.__srcContext = null;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.setFormat = function(image,format) {
	var data = image.buffer.data;
	if(data == null) {
		return;
	}
	var index;
	var a16;
	var length = data.length / 4 | 0;
	var r1;
	var g1;
	var b1;
	var a1;
	var r2;
	var g2;
	var b2;
	var a2;
	var r;
	var g;
	var b;
	var a;
	var _g = image.get_format();
	switch(_g) {
	case 0:
		r1 = 0;
		g1 = 1;
		b1 = 2;
		a1 = 3;
		break;
	case 1:
		r1 = 1;
		g1 = 2;
		b1 = 3;
		a1 = 0;
		break;
	case 2:
		r1 = 2;
		g1 = 1;
		b1 = 0;
		a1 = 3;
		break;
	}
	switch(format) {
	case 0:
		r2 = 0;
		g2 = 1;
		b2 = 2;
		a2 = 3;
		break;
	case 1:
		r2 = 1;
		g2 = 2;
		b2 = 3;
		a2 = 0;
		break;
	case 2:
		r2 = 2;
		g2 = 1;
		b2 = 0;
		a2 = 3;
		break;
	}
	var _g2 = 0;
	var _g1 = length;
	while(_g2 < _g1) {
		var i = _g2++;
		index = i * 4;
		r = data[index + r1];
		g = data[index + g1];
		b = data[index + b1];
		a = data[index + a1];
		data[index + r2] = r;
		data[index + g2] = g;
		data[index + b2] = b;
		data[index + a2] = a;
	}
	image.buffer.format = format;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.setPixel = function(image,x,y,color,format) {
	var pixel;
	switch(format) {
	case 1:
		var argb = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		pixel = rgba;
		break;
	case 2:
		var bgra = color;
		var this2 = 0;
		var rgba1 = this2;
		rgba1 = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		pixel = rgba1;
		break;
	default:
		pixel = color;
	}
	var this3 = 0;
	var source = this3;
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	var premultiplied = image.buffer.premultiplied;
	switch(image.buffer.format) {
	case 0:
		source = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		source = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		source = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied) {
		if((source & 255) != 0 && (source & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (source & 255);
			source = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((source >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((source >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((source >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | source & 255 & 255;
		}
	}
	var value = source & 255;
	pixel = (pixel >>> 24 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 8 & 255 & 255) << 8 | value & 255;
	var data1 = image.buffer.data;
	var offset1 = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	if(image.buffer.premultiplied) {
		if((pixel & 255) == 0) {
			if(pixel != 0) {
				pixel = 0;
			}
		} else if((pixel & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[pixel & 255];
			pixel = ((pixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((pixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((pixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | pixel & 255 & 255;
		}
	}
	switch(image.buffer.format) {
	case 0:
		data1[offset1] = pixel >>> 24 & 255;
		data1[offset1 + 1] = pixel >>> 16 & 255;
		data1[offset1 + 2] = pixel >>> 8 & 255;
		data1[offset1 + 3] = pixel & 255;
		break;
	case 1:
		data1[offset1] = pixel & 255;
		data1[offset1 + 1] = pixel >>> 24 & 255;
		data1[offset1 + 2] = pixel >>> 16 & 255;
		data1[offset1 + 3] = pixel >>> 8 & 255;
		break;
	case 2:
		data1[offset1] = pixel >>> 8 & 255;
		data1[offset1 + 1] = pixel >>> 16 & 255;
		data1[offset1 + 2] = pixel >>> 24 & 255;
		data1[offset1 + 3] = pixel & 255;
		break;
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.setPixel32 = function(image,x,y,color,format) {
	var pixel;
	switch(format) {
	case 1:
		var argb = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		pixel = rgba;
		break;
	case 2:
		var bgra = color;
		var this2 = 0;
		var rgba1 = this2;
		rgba1 = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		pixel = rgba1;
		break;
	default:
		pixel = color;
	}
	if(!image.get_transparent()) {
		pixel = (pixel >>> 24 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 8 & 255 & 255) << 8 | 255;
	}
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	if(image.buffer.premultiplied) {
		if((pixel & 255) == 0) {
			if(pixel != 0) {
				pixel = 0;
			}
		} else if((pixel & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[pixel & 255];
			pixel = ((pixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((pixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((pixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | pixel & 255 & 255;
		}
	}
	switch(image.buffer.format) {
	case 0:
		data[offset] = pixel >>> 24 & 255;
		data[offset + 1] = pixel >>> 16 & 255;
		data[offset + 2] = pixel >>> 8 & 255;
		data[offset + 3] = pixel & 255;
		break;
	case 1:
		data[offset] = pixel & 255;
		data[offset + 1] = pixel >>> 24 & 255;
		data[offset + 2] = pixel >>> 16 & 255;
		data[offset + 3] = pixel >>> 8 & 255;
		break;
	case 2:
		data[offset] = pixel >>> 8 & 255;
		data[offset + 1] = pixel >>> 16 & 255;
		data[offset + 2] = pixel >>> 24 & 255;
		data[offset + 3] = pixel & 255;
		break;
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.setPixels = function(image,rect,bytePointer,format,endian) {
	if(image.buffer.data == null) {
		return;
	}
	var data = image.buffer.data;
	var sourceFormat = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	var dataView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,rect);
	var row;
	var color;
	var pixel;
	var transparent = image.get_transparent();
	var bytes = bytePointer.bytes;
	var dataPosition = bytePointer.offset;
	var littleEndian = endian != lime_system_Endian.BIG_ENDIAN;
	var _g1 = 0;
	var _g = dataView.height;
	while(_g1 < _g) {
		var y = _g1++;
		row = dataView.byteOffset + dataView.stride * y;
		var _g3 = 0;
		var _g2 = dataView.width;
		while(_g3 < _g2) {
			var x = _g3++;
			if(littleEndian) {
				color = bytes.getInt32(dataPosition);
			} else {
				color = bytes.b[dataPosition + 3] | bytes.b[dataPosition + 2] << 8 | bytes.b[dataPosition + 1] << 16 | bytes.b[dataPosition] << 24;
			}
			dataPosition += 4;
			switch(format) {
			case 1:
				var argb = color;
				var this1 = 0;
				var rgba = this1;
				rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
				pixel = rgba;
				break;
			case 2:
				var bgra = color;
				var this2 = 0;
				var rgba1 = this2;
				rgba1 = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
				pixel = rgba1;
				break;
			default:
				pixel = color;
			}
			if(!transparent) {
				pixel = (pixel >>> 24 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 8 & 255 & 255) << 8 | 255;
			}
			var offset = row + x * 4;
			if(premultiplied) {
				if((pixel & 255) == 0) {
					if(pixel != 0) {
						pixel = 0;
					}
				} else if((pixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[pixel & 255];
					pixel = ((pixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((pixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((pixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | pixel & 255 & 255;
				}
			}
			switch(sourceFormat) {
			case 0:
				data[offset] = pixel >>> 24 & 255;
				data[offset + 1] = pixel >>> 16 & 255;
				data[offset + 2] = pixel >>> 8 & 255;
				data[offset + 3] = pixel & 255;
				break;
			case 1:
				data[offset] = pixel & 255;
				data[offset + 1] = pixel >>> 24 & 255;
				data[offset + 2] = pixel >>> 16 & 255;
				data[offset + 3] = pixel >>> 8 & 255;
				break;
			case 2:
				data[offset] = pixel >>> 8 & 255;
				data[offset + 1] = pixel >>> 16 & 255;
				data[offset + 2] = pixel >>> 24 & 255;
				data[offset + 3] = pixel & 255;
				break;
			}
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.threshold = function(image,sourceImage,sourceRect,destPoint,operation,threshold,color,mask,copySource,format) {
	var _color;
	var _mask;
	var _threshold;
	switch(format) {
	case 1:
		var argb = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		_color = rgba;
		var argb1 = mask;
		var this2 = 0;
		var rgba1 = this2;
		rgba1 = (argb1 >>> 16 & 255 & 255) << 24 | (argb1 >>> 8 & 255 & 255) << 16 | (argb1 & 255 & 255) << 8 | argb1 >>> 24 & 255 & 255;
		_mask = rgba1;
		var argb2 = threshold;
		var this3 = 0;
		var rgba2 = this3;
		rgba2 = (argb2 >>> 16 & 255 & 255) << 24 | (argb2 >>> 8 & 255 & 255) << 16 | (argb2 & 255 & 255) << 8 | argb2 >>> 24 & 255 & 255;
		_threshold = rgba2;
		break;
	case 2:
		var bgra = color;
		var this4 = 0;
		var rgba3 = this4;
		rgba3 = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		_color = rgba3;
		var bgra1 = mask;
		var this5 = 0;
		var rgba4 = this5;
		rgba4 = (bgra1 >>> 8 & 255 & 255) << 24 | (bgra1 >>> 16 & 255 & 255) << 16 | (bgra1 >>> 24 & 255 & 255) << 8 | bgra1 & 255 & 255;
		_mask = rgba4;
		var bgra2 = threshold;
		var this6 = 0;
		var rgba5 = this6;
		rgba5 = (bgra2 >>> 8 & 255 & 255) << 24 | (bgra2 >>> 16 & 255 & 255) << 16 | (bgra2 >>> 24 & 255 & 255) << 8 | bgra2 & 255 & 255;
		_threshold = rgba5;
		break;
	default:
		_color = color;
		_mask = mask;
		_threshold = threshold;
	}
	var _operation;
	switch(operation) {
	case "!=":
		_operation = 0;
		break;
	case "<":
		_operation = 2;
		break;
	case "<=":
		_operation = 3;
		break;
	case "==":
		_operation = 1;
		break;
	case ">":
		_operation = 4;
		break;
	case ">=":
		_operation = 5;
		break;
	default:
		_operation = -1;
	}
	if(_operation == -1) {
		return 0;
	}
	var srcData = sourceImage.buffer.data;
	var destData = image.buffer.data;
	if(srcData == null || destData == null) {
		return 0;
	}
	var hits = 0;
	var srcView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(sourceImage,sourceRect);
	var destView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,new lime_math_Rectangle(destPoint.x,destPoint.y,srcView.width,srcView.height));
	var srcFormat = sourceImage.buffer.format;
	var destFormat = image.buffer.format;
	var srcPremultiplied = sourceImage.buffer.premultiplied;
	var destPremultiplied = image.buffer.premultiplied;
	var srcPosition;
	var destPosition;
	var srcPixel = 0;
	var destPixel = 0;
	var pixelMask;
	var test;
	var value;
	var _g1 = 0;
	var _g = destView.height;
	while(_g1 < _g) {
		var y = _g1++;
		srcPosition = srcView.byteOffset + srcView.stride * y;
		destPosition = destView.byteOffset + destView.stride * y;
		var _g3 = 0;
		var _g2 = destView.width;
		while(_g3 < _g2) {
			var x = _g3++;
			switch(srcFormat) {
			case 0:
				srcPixel = (srcData[srcPosition] & 255) << 24 | (srcData[srcPosition + 1] & 255) << 16 | (srcData[srcPosition + 2] & 255) << 8 | srcData[srcPosition + 3] & 255;
				break;
			case 1:
				srcPixel = (srcData[srcPosition + 1] & 255) << 24 | (srcData[srcPosition + 2] & 255) << 16 | (srcData[srcPosition + 3] & 255) << 8 | srcData[srcPosition] & 255;
				break;
			case 2:
				srcPixel = (srcData[srcPosition + 2] & 255) << 24 | (srcData[srcPosition + 1] & 255) << 16 | (srcData[srcPosition] & 255) << 8 | srcData[srcPosition + 3] & 255;
				break;
			}
			if(srcPremultiplied) {
				if((srcPixel & 255) != 0 && (srcPixel & 255) != 255) {
					lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (srcPixel & 255);
					srcPixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((srcPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((srcPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((srcPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | srcPixel & 255 & 255;
				}
			}
			pixelMask = srcPixel & _mask;
			var tmp1;
			var tmp2;
			tmp1 = pixelMask >>> 24 & 255;
			tmp2 = _threshold >>> 24 & 255;
			if(tmp1 != tmp2) {
				if(_$UInt_UInt_$Impl_$.gt(tmp1,tmp2)) {
					value = 1;
				} else {
					value = -1;
				}
			} else {
				tmp1 = pixelMask >>> 16 & 255;
				tmp2 = _threshold >>> 16 & 255;
				if(tmp1 != tmp2) {
					if(_$UInt_UInt_$Impl_$.gt(tmp1,tmp2)) {
						value = 1;
					} else {
						value = -1;
					}
				} else {
					tmp1 = pixelMask >>> 8 & 255;
					tmp2 = _threshold >>> 8 & 255;
					if(tmp1 != tmp2) {
						if(_$UInt_UInt_$Impl_$.gt(tmp1,tmp2)) {
							value = 1;
						} else {
							value = -1;
						}
					} else {
						tmp1 = pixelMask & 255;
						tmp2 = _threshold & 255;
						if(tmp1 != tmp2) {
							if(_$UInt_UInt_$Impl_$.gt(tmp1,tmp2)) {
								value = 1;
							} else {
								value = -1;
							}
						} else {
							value = 0;
						}
					}
				}
			}
			switch(_operation) {
			case 0:
				test = value != 0;
				break;
			case 1:
				test = value == 0;
				break;
			case 2:
				test = value == -1;
				break;
			case 3:
				if(value != 0) {
					test = value == -1;
				} else {
					test = true;
				}
				break;
			case 4:
				test = value == 1;
				break;
			case 5:
				if(value != 0) {
					test = value == 1;
				} else {
					test = true;
				}
				break;
			default:
				test = false;
			}
			if(test) {
				if(destPremultiplied) {
					if((_color & 255) == 0) {
						if(_color != 0) {
							_color = 0;
						}
					} else if((_color & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[_color & 255];
						_color = ((_color >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((_color >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((_color >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | _color & 255 & 255;
					}
				}
				switch(destFormat) {
				case 0:
					destData[destPosition] = _color >>> 24 & 255;
					destData[destPosition + 1] = _color >>> 16 & 255;
					destData[destPosition + 2] = _color >>> 8 & 255;
					destData[destPosition + 3] = _color & 255;
					break;
				case 1:
					destData[destPosition] = _color & 255;
					destData[destPosition + 1] = _color >>> 24 & 255;
					destData[destPosition + 2] = _color >>> 16 & 255;
					destData[destPosition + 3] = _color >>> 8 & 255;
					break;
				case 2:
					destData[destPosition] = _color >>> 8 & 255;
					destData[destPosition + 1] = _color >>> 16 & 255;
					destData[destPosition + 2] = _color >>> 24 & 255;
					destData[destPosition + 3] = _color & 255;
					break;
				}
				++hits;
			} else if(copySource) {
				if(destPremultiplied) {
					if((srcPixel & 255) == 0) {
						if(srcPixel != 0) {
							srcPixel = 0;
						}
					} else if((srcPixel & 255) != 255) {
						lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[srcPixel & 255];
						srcPixel = ((srcPixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((srcPixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((srcPixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | srcPixel & 255 & 255;
					}
				}
				switch(destFormat) {
				case 0:
					destData[destPosition] = srcPixel >>> 24 & 255;
					destData[destPosition + 1] = srcPixel >>> 16 & 255;
					destData[destPosition + 2] = srcPixel >>> 8 & 255;
					destData[destPosition + 3] = srcPixel & 255;
					break;
				case 1:
					destData[destPosition] = srcPixel & 255;
					destData[destPosition + 1] = srcPixel >>> 24 & 255;
					destData[destPosition + 2] = srcPixel >>> 16 & 255;
					destData[destPosition + 3] = srcPixel >>> 8 & 255;
					break;
				case 2:
					destData[destPosition] = srcPixel >>> 8 & 255;
					destData[destPosition + 1] = srcPixel >>> 16 & 255;
					destData[destPosition + 2] = srcPixel >>> 24 & 255;
					destData[destPosition + 3] = srcPixel & 255;
					break;
				}
			}
			srcPosition += 4;
			destPosition += 4;
		}
	}
	if(hits > 0) {
		image.dirty = true;
		image.version++;
	}
	return hits;
};
lime__$internal_graphics_ImageDataUtil.unmultiplyAlpha = function(image) {
	var data = image.buffer.data;
	if(data == null) {
		return;
	}
	var format = image.buffer.format;
	var length = data.length / 4 | 0;
	var pixel = 0;
	var _g1 = 0;
	var _g = length;
	while(_g1 < _g) {
		var i = _g1++;
		var offset = i * 4;
		switch(format) {
		case 0:
			pixel = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
			break;
		case 1:
			pixel = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
			break;
		case 2:
			pixel = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
			break;
		}
		if((pixel & 255) != 0 && (pixel & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (pixel & 255);
			pixel = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((pixel >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | pixel & 255 & 255;
		}
		var offset1 = i * 4;
		switch(format) {
		case 0:
			data[offset1] = pixel >>> 24 & 255;
			data[offset1 + 1] = pixel >>> 16 & 255;
			data[offset1 + 2] = pixel >>> 8 & 255;
			data[offset1 + 3] = pixel & 255;
			break;
		case 1:
			data[offset1] = pixel & 255;
			data[offset1 + 1] = pixel >>> 24 & 255;
			data[offset1 + 2] = pixel >>> 16 & 255;
			data[offset1 + 3] = pixel >>> 8 & 255;
			break;
		case 2:
			data[offset1] = pixel >>> 8 & 255;
			data[offset1 + 1] = pixel >>> 16 & 255;
			data[offset1 + 2] = pixel >>> 24 & 255;
			data[offset1 + 3] = pixel & 255;
			break;
		}
	}
	image.buffer.premultiplied = false;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.__boxBlur = function(imgA,imgB,w,h,bx,by) {
	imgB.set(imgA);
	var bx1 = bx | 0;
	var by1 = by | 0;
	lime__$internal_graphics_ImageDataUtil.__boxBlurH(imgB,imgA,w,h,bx1,0);
	lime__$internal_graphics_ImageDataUtil.__boxBlurH(imgB,imgA,w,h,bx1,1);
	lime__$internal_graphics_ImageDataUtil.__boxBlurH(imgB,imgA,w,h,bx1,2);
	lime__$internal_graphics_ImageDataUtil.__boxBlurH(imgB,imgA,w,h,bx1,3);
	var iarr = 1 / (by1 + by1 + 1);
	var ws = w * 4;
	var ti;
	var li;
	var ri;
	var fv;
	var lv;
	var val;
	var _g1 = 0;
	var _g = w;
	while(_g1 < _g) {
		var i = _g1++;
		ti = i * 4;
		li = ti;
		ri = ti + by1 * ws;
		fv = imgA[ti];
		lv = imgA[ti + ws * (h - 1)];
		val = (by1 + 1) * fv;
		var _g3 = 0;
		var _g2 = by1;
		while(_g3 < _g2) {
			var j = _g3++;
			val = val + imgA[ti + j * ws];
		}
		var _g31 = 0;
		var _g21 = by1 + 1;
		while(_g31 < _g21) {
			var j1 = _g31++;
			val = val + (imgA[ri] - fv);
			imgB[ti] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val) * iarr);
			ri += ws;
			ti += ws;
		}
		var _g32 = by1 + 1;
		var _g22 = h - by1;
		while(_g32 < _g22) {
			var j2 = _g32++;
			val = val + (imgA[ri] - imgA[li]);
			imgB[ti] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val) * iarr);
			li += ws;
			ri += ws;
			ti += ws;
		}
		var _g33 = h - by1;
		var _g23 = h;
		while(_g33 < _g23) {
			var j3 = _g33++;
			val = val + (lv - imgA[li]);
			imgB[ti] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val) * iarr);
			li += ws;
			ti += ws;
		}
	}
	var iarr1 = 1 / (by1 + by1 + 1);
	var ws1 = w * 4;
	var ti1;
	var li1;
	var ri1;
	var fv1;
	var lv1;
	var val1;
	var _g11 = 0;
	var _g4 = w;
	while(_g11 < _g4) {
		var i1 = _g11++;
		ti1 = i1 * 4 + 1;
		li1 = ti1;
		ri1 = ti1 + by1 * ws1;
		fv1 = imgA[ti1];
		lv1 = imgA[ti1 + ws1 * (h - 1)];
		val1 = (by1 + 1) * fv1;
		var _g34 = 0;
		var _g24 = by1;
		while(_g34 < _g24) {
			var j4 = _g34++;
			val1 = val1 + imgA[ti1 + j4 * ws1];
		}
		var _g35 = 0;
		var _g25 = by1 + 1;
		while(_g35 < _g25) {
			var j5 = _g35++;
			val1 = val1 + (imgA[ri1] - fv1);
			imgB[ti1] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val1) * iarr1);
			ri1 += ws1;
			ti1 += ws1;
		}
		var _g36 = by1 + 1;
		var _g26 = h - by1;
		while(_g36 < _g26) {
			var j6 = _g36++;
			val1 = val1 + (imgA[ri1] - imgA[li1]);
			imgB[ti1] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val1) * iarr1);
			li1 += ws1;
			ri1 += ws1;
			ti1 += ws1;
		}
		var _g37 = h - by1;
		var _g27 = h;
		while(_g37 < _g27) {
			var j7 = _g37++;
			val1 = val1 + (lv1 - imgA[li1]);
			imgB[ti1] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val1) * iarr1);
			li1 += ws1;
			ti1 += ws1;
		}
	}
	var iarr2 = 1 / (by1 + by1 + 1);
	var ws2 = w * 4;
	var ti2;
	var li2;
	var ri2;
	var fv2;
	var lv2;
	var val2;
	var _g12 = 0;
	var _g5 = w;
	while(_g12 < _g5) {
		var i2 = _g12++;
		ti2 = i2 * 4 + 2;
		li2 = ti2;
		ri2 = ti2 + by1 * ws2;
		fv2 = imgA[ti2];
		lv2 = imgA[ti2 + ws2 * (h - 1)];
		val2 = (by1 + 1) * fv2;
		var _g38 = 0;
		var _g28 = by1;
		while(_g38 < _g28) {
			var j8 = _g38++;
			val2 = val2 + imgA[ti2 + j8 * ws2];
		}
		var _g39 = 0;
		var _g29 = by1 + 1;
		while(_g39 < _g29) {
			var j9 = _g39++;
			val2 = val2 + (imgA[ri2] - fv2);
			imgB[ti2] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val2) * iarr2);
			ri2 += ws2;
			ti2 += ws2;
		}
		var _g310 = by1 + 1;
		var _g210 = h - by1;
		while(_g310 < _g210) {
			var j10 = _g310++;
			val2 = val2 + (imgA[ri2] - imgA[li2]);
			imgB[ti2] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val2) * iarr2);
			li2 += ws2;
			ri2 += ws2;
			ti2 += ws2;
		}
		var _g311 = h - by1;
		var _g211 = h;
		while(_g311 < _g211) {
			var j11 = _g311++;
			val2 = val2 + (lv2 - imgA[li2]);
			imgB[ti2] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val2) * iarr2);
			li2 += ws2;
			ti2 += ws2;
		}
	}
	var iarr3 = 1 / (by1 + by1 + 1);
	var ws3 = w * 4;
	var ti3;
	var li3;
	var ri3;
	var fv3;
	var lv3;
	var val3;
	var _g13 = 0;
	var _g6 = w;
	while(_g13 < _g6) {
		var i3 = _g13++;
		ti3 = i3 * 4 + 3;
		li3 = ti3;
		ri3 = ti3 + by1 * ws3;
		fv3 = imgA[ti3];
		lv3 = imgA[ti3 + ws3 * (h - 1)];
		val3 = (by1 + 1) * fv3;
		var _g312 = 0;
		var _g212 = by1;
		while(_g312 < _g212) {
			var j12 = _g312++;
			val3 = val3 + imgA[ti3 + j12 * ws3];
		}
		var _g313 = 0;
		var _g213 = by1 + 1;
		while(_g313 < _g213) {
			var j13 = _g313++;
			val3 = val3 + (imgA[ri3] - fv3);
			imgB[ti3] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val3) * iarr3);
			ri3 += ws3;
			ti3 += ws3;
		}
		var _g314 = by1 + 1;
		var _g214 = h - by1;
		while(_g314 < _g214) {
			var j14 = _g314++;
			val3 = val3 + (imgA[ri3] - imgA[li3]);
			imgB[ti3] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val3) * iarr3);
			li3 += ws3;
			ri3 += ws3;
			ti3 += ws3;
		}
		var _g315 = h - by1;
		var _g215 = h;
		while(_g315 < _g215) {
			var j15 = _g315++;
			val3 = val3 + (lv3 - imgA[li3]);
			imgB[ti3] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val3) * iarr3);
			li3 += ws3;
			ti3 += ws3;
		}
	}
};
lime__$internal_graphics_ImageDataUtil.__boxBlurH = function(imgA,imgB,w,h,r,off) {
	var iarr = 1 / (r + r + 1);
	var ti;
	var li;
	var ri;
	var fv;
	var lv;
	var val;
	var _g1 = 0;
	var _g = h;
	while(_g1 < _g) {
		var i = _g1++;
		ti = i * w;
		li = ti;
		ri = ti + r;
		fv = imgA[ti * 4 + off];
		lv = imgA[(ti + w - 1) * 4 + off];
		val = (r + 1) * fv;
		var _g3 = 0;
		var _g2 = r;
		while(_g3 < _g2) {
			var j = _g3++;
			val = val + imgA[(ti + j) * 4 + off];
		}
		var _g31 = 0;
		var _g21 = r + 1;
		while(_g31 < _g21) {
			var j1 = _g31++;
			val = val + (imgA[ri * 4 + off] - fv);
			imgB[ti * 4 + off] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val) * iarr);
			++ri;
			++ti;
		}
		var _g32 = r + 1;
		var _g22 = w - r;
		while(_g32 < _g22) {
			var j2 = _g32++;
			val = val + (imgA[ri * 4 + off] - imgA[li * 4 + off]);
			imgB[ti * 4 + off] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val) * iarr);
			++ri;
			++li;
			++ti;
		}
		var _g33 = w - r;
		var _g23 = w;
		while(_g33 < _g23) {
			var j3 = _g33++;
			val = val + (lv - imgA[li * 4 + off]);
			imgB[ti * 4 + off] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val) * iarr);
			++li;
			++ti;
		}
	}
};
lime__$internal_graphics_ImageDataUtil.__boxBlurT = function(imgA,imgB,w,h,r,off) {
	var iarr = 1 / (r + r + 1);
	var ws = w * 4;
	var ti;
	var li;
	var ri;
	var fv;
	var lv;
	var val;
	var _g1 = 0;
	var _g = w;
	while(_g1 < _g) {
		var i = _g1++;
		ti = i * 4 + off;
		li = ti;
		ri = ti + r * ws;
		fv = imgA[ti];
		lv = imgA[ti + ws * (h - 1)];
		val = (r + 1) * fv;
		var _g3 = 0;
		var _g2 = r;
		while(_g3 < _g2) {
			var j = _g3++;
			val = val + imgA[ti + j * ws];
		}
		var _g31 = 0;
		var _g21 = r + 1;
		while(_g31 < _g21) {
			var j1 = _g31++;
			val = val + (imgA[ri] - fv);
			imgB[ti] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val) * iarr);
			ri += ws;
			ti += ws;
		}
		var _g32 = r + 1;
		var _g22 = h - r;
		while(_g32 < _g22) {
			var j2 = _g32++;
			val = val + (imgA[ri] - imgA[li]);
			imgB[ti] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val) * iarr);
			li += ws;
			ri += ws;
			ti += ws;
		}
		var _g33 = h - r;
		var _g23 = h;
		while(_g33 < _g23) {
			var j3 = _g33++;
			val = val + (lv - imgA[li]);
			imgB[ti] = Math.round(_$UInt_UInt_$Impl_$.toFloat(val) * iarr);
			li += ws;
			ti += ws;
		}
	}
};
lime__$internal_graphics_ImageDataUtil.__calculateSourceOffset = function(sourceRect,destPoint,destX,destY) {
	var sourceX = destX - (destPoint.x | 0);
	var sourceY = destY - (destPoint.y | 0);
	var offset = 0;
	if(sourceX < 0 || sourceY < 0 || sourceX >= sourceRect.width || sourceY >= sourceRect.height) {
		offset = -1;
	} else {
		offset = 4 * (sourceY * (sourceRect.width | 0) + sourceX);
	}
	return offset;
};
lime__$internal_graphics_ImageDataUtil.__getBoxesForGaussianBlur = function(sigma,n) {
	var wIdeal = Math.sqrt(12 * sigma * sigma / n + 1);
	var wl = Math.floor(wIdeal);
	if(wl % 2 == 0) {
		--wl;
	}
	var wu = wl + 2;
	var mIdeal = (12 * sigma * sigma - n * wl * wl - 4 * n * wl - 3 * n) / (-4 * wl - 4);
	var m = Math.round(mIdeal);
	var sizes = [];
	var _g1 = 0;
	var _g = n;
	while(_g1 < _g) {
		var i = _g1++;
		sizes.push(i < m ? wl : wu);
	}
	return sizes;
};
lime__$internal_graphics_ImageDataUtil.__pixelCompare = function(n1,n2) {
	var tmp1;
	var tmp2;
	tmp1 = n1 >>> 24 & 255;
	tmp2 = n2 >>> 24 & 255;
	if(tmp1 != tmp2) {
		if(_$UInt_UInt_$Impl_$.gt(tmp1,tmp2)) {
			return 1;
		} else {
			return -1;
		}
	} else {
		tmp1 = n1 >>> 16 & 255;
		tmp2 = n2 >>> 16 & 255;
		if(tmp1 != tmp2) {
			if(_$UInt_UInt_$Impl_$.gt(tmp1,tmp2)) {
				return 1;
			} else {
				return -1;
			}
		} else {
			tmp1 = n1 >>> 8 & 255;
			tmp2 = n2 >>> 8 & 255;
			if(tmp1 != tmp2) {
				if(_$UInt_UInt_$Impl_$.gt(tmp1,tmp2)) {
					return 1;
				} else {
					return -1;
				}
			} else {
				tmp1 = n1 & 255;
				tmp2 = n2 & 255;
				if(tmp1 != tmp2) {
					if(_$UInt_UInt_$Impl_$.gt(tmp1,tmp2)) {
						return 1;
					} else {
						return -1;
					}
				} else {
					return 0;
				}
			}
		}
	}
};
lime__$internal_graphics_ImageDataUtil.__translatePixel = function(imgB,sourceRect,destRect,destPoint,destX,destY,strength) {
	var d = 4 * (destY * (destRect.width | 0) + destX);
	var s = lime__$internal_graphics_ImageDataUtil.__calculateSourceOffset(sourceRect,destPoint,destX,destY);
	if(s < 0) {
		imgB[d] = imgB[d + 1] = imgB[d + 2] = imgB[d + 3] = 0;
	} else {
		imgB[d] = imgB[s];
		imgB[d + 1] = imgB[s + 1];
		imgB[d + 2] = imgB[s + 2];
		var a = _$UInt_UInt_$Impl_$.toFloat(imgB[s + 3]) * strength | 0;
		imgB[d + 3] = a < 0 ? 0 : a > 255 ? 255 : a;
	}
};
var lime__$internal_graphics__$ImageDataUtil_ImageDataView = function(image,rect) {
	this.image = image;
	if(rect == null) {
		this.rect = image.get_rect();
	} else {
		if(rect.x < 0) {
			rect.x = 0;
		}
		if(rect.y < 0) {
			rect.y = 0;
		}
		if(rect.x + rect.width > image.width) {
			rect.width = image.width - rect.x;
		}
		if(rect.y + rect.height > image.height) {
			rect.height = image.height - rect.y;
		}
		if(rect.width < 0) {
			rect.width = 0;
		}
		if(rect.height < 0) {
			rect.height = 0;
		}
		this.rect = rect;
	}
	this.stride = image.buffer.get_stride();
	this.__update();
};
$hxClasses["lime._internal.graphics._ImageDataUtil.ImageDataView"] = lime__$internal_graphics__$ImageDataUtil_ImageDataView;
lime__$internal_graphics__$ImageDataUtil_ImageDataView.__name__ = ["lime","_internal","graphics","_ImageDataUtil","ImageDataView"];
lime__$internal_graphics__$ImageDataUtil_ImageDataView.prototype = {
	clip: function(x,y,width,height) {
		if(this.tempRect == null) {
			this.tempRect = new lime_math_Rectangle();
		}
		this.tempRect.setTo(x,y,width,height);
		this.rect.intersection(this.tempRect,this.rect);
		this.__update();
	}
	,hasRow: function(y) {
		if(y >= 0) {
			return y < this.height;
		} else {
			return false;
		}
	}
	,offset: function(x,y) {
		if(x < 0) {
			this.rect.x += x;
			if(this.rect.x < 0) {
				this.rect.x = 0;
			}
		} else {
			this.rect.x += x;
			this.rect.width -= x;
		}
		if(y < 0) {
			this.rect.y += y;
			if(this.rect.y < 0) {
				this.rect.y = 0;
			}
		} else {
			this.rect.y += y;
			this.rect.height -= y;
		}
		this.__update();
	}
	,row: function(y) {
		return this.byteOffset + this.stride * y;
	}
	,__update: function() {
		this.x = Math.ceil(this.rect.x);
		this.y = Math.ceil(this.rect.y);
		this.width = Math.floor(this.rect.width);
		this.height = Math.floor(this.rect.height);
		this.byteOffset = this.stride * (this.y + this.image.offsetY) + (this.x + this.image.offsetX) * 4;
	}
	,__class__: lime__$internal_graphics__$ImageDataUtil_ImageDataView
};
var lime__$internal_graphics_StackBlur = function() { };
$hxClasses["lime._internal.graphics.StackBlur"] = lime__$internal_graphics_StackBlur;
lime__$internal_graphics_StackBlur.__name__ = ["lime","_internal","graphics","StackBlur"];
lime__$internal_graphics_StackBlur.blur = function(dest,source,sourceRect,destPoint,blurX,blurY,quality) {
	dest.copyPixels(source,sourceRect,destPoint);
	lime__$internal_graphics_StackBlur.__stackBlurCanvasRGBA(dest,sourceRect.width | 0,sourceRect.height | 0,blurX,blurY,quality);
};
lime__$internal_graphics_StackBlur.__stackBlurCanvasRGBA = function(image,width,height,blurX,blurY,quality) {
	var radiusX = Math.round(blurX) >> 1;
	var radiusY = Math.round(blurY) >> 1;
	if(lime__$internal_graphics_StackBlur.MUL_TABLE == null) {
		return;
	}
	if(radiusX >= lime__$internal_graphics_StackBlur.MUL_TABLE.length) {
		radiusX = lime__$internal_graphics_StackBlur.MUL_TABLE.length - 1;
	}
	if(radiusY >= lime__$internal_graphics_StackBlur.MUL_TABLE.length) {
		radiusY = lime__$internal_graphics_StackBlur.MUL_TABLE.length - 1;
	}
	if(radiusX < 0 || radiusY < 0) {
		return;
	}
	var iterations = quality;
	if(iterations < 1) {
		iterations = 1;
	}
	if(iterations > 3) {
		iterations = 3;
	}
	var px = image.get_data();
	var x;
	var y;
	var i;
	var p;
	var yp;
	var yi;
	var yw;
	var r;
	var g;
	var b;
	var a;
	var pr;
	var pg;
	var pb;
	var pa;
	var f;
	var divx = radiusX + radiusX + 1;
	var divy = radiusY + radiusY + 1;
	var w = width;
	var h = height;
	var w1 = w - 1;
	var h1 = h - 1;
	var rxp1 = radiusX + 1;
	var ryp1 = radiusY + 1;
	var ssx = new lime__$internal_graphics_BlurStack();
	var sx = ssx;
	var _g1 = 1;
	var _g = divx;
	while(_g1 < _g) {
		var i1 = _g1++;
		sx = sx.n = new lime__$internal_graphics_BlurStack();
	}
	sx.n = ssx;
	var ssy = new lime__$internal_graphics_BlurStack();
	var sy = ssy;
	var _g11 = 1;
	var _g2 = divy;
	while(_g11 < _g2) {
		var i2 = _g11++;
		sy = sy.n = new lime__$internal_graphics_BlurStack();
	}
	sy.n = ssy;
	var si = null;
	var mtx = lime__$internal_graphics_StackBlur.MUL_TABLE[radiusX];
	var stx = lime__$internal_graphics_StackBlur.SHG_TABLE[radiusX];
	var mty = lime__$internal_graphics_StackBlur.MUL_TABLE[radiusY];
	var sty = lime__$internal_graphics_StackBlur.SHG_TABLE[radiusY];
	while(iterations > 0) {
		--iterations;
		yi = 0;
		yw = yi;
		var ms = mtx;
		var ss = stx;
		y = h;
		while(true) {
			pr = px[yi];
			r = rxp1 * pr;
			pg = px[yi + 1];
			g = rxp1 * pg;
			pb = px[yi + 2];
			b = rxp1 * pb;
			pa = px[yi + 3];
			a = rxp1 * pa;
			sx = ssx;
			i = rxp1;
			while(true) {
				sx.r = pr;
				sx.g = pg;
				sx.b = pb;
				sx.a = pa;
				sx = sx.n;
				if(!(--i > -1)) {
					break;
				}
			}
			var _g12 = 1;
			var _g3 = rxp1;
			while(_g12 < _g3) {
				var i3 = _g12++;
				p = yi + ((w1 < i3 ? w1 : i3) << 2);
				r += sx.r = px[p];
				g += sx.g = px[p + 1];
				b += sx.b = px[p + 2];
				a += sx.a = px[p + 3];
				sx = sx.n;
			}
			si = ssx;
			var _g13 = 0;
			var _g4 = w;
			while(_g13 < _g4) {
				var x1 = _g13++;
				px[yi++] = r * ms >>> ss;
				px[yi++] = g * ms >>> ss;
				px[yi++] = b * ms >>> ss;
				px[yi++] = a * ms >>> ss;
				var p1;
				p = x1 + radiusX + 1;
				if(p < w1) {
					p1 = p;
				} else {
					p1 = w1;
				}
				p = yw + p1 << 2;
				r -= si.r - (si.r = px[p]);
				g -= si.g - (si.g = px[p + 1]);
				b -= si.b - (si.b = px[p + 2]);
				a -= si.a - (si.a = px[p + 3]);
				si = si.n;
			}
			yw += w;
			if(!(--y > 0)) {
				break;
			}
		}
		ms = mty;
		ss = sty;
		var _g14 = 0;
		var _g5 = w;
		while(_g14 < _g5) {
			var x2 = _g14++;
			yi = x2 << 2;
			pr = px[yi];
			r = ryp1 * pr;
			pg = px[yi + 1];
			g = ryp1 * pg;
			pb = px[yi + 2];
			b = ryp1 * pb;
			pa = px[yi + 3];
			a = ryp1 * pa;
			sy = ssy;
			var _g31 = 0;
			var _g21 = ryp1;
			while(_g31 < _g21) {
				var i4 = _g31++;
				sy.r = pr;
				sy.g = pg;
				sy.b = pb;
				sy.a = pa;
				sy = sy.n;
			}
			yp = w;
			var _g32 = 1;
			var _g22 = radiusY + 1;
			while(_g32 < _g22) {
				var i5 = _g32++;
				yi = yp + x2 << 2;
				r += sy.r = px[yi];
				g += sy.g = px[yi + 1];
				b += sy.b = px[yi + 2];
				a += sy.a = px[yi + 3];
				sy = sy.n;
				if(i5 < h1) {
					yp += w;
				}
			}
			yi = x2;
			si = ssy;
			if(iterations > 0) {
				var _g33 = 0;
				var _g23 = h;
				while(_g33 < _g23) {
					var y1 = _g33++;
					p = yi << 2;
					pa = a * ms >>> ss;
					px[p + 3] = pa;
					if(pa > 0) {
						px[p] = r * ms >>> ss;
						px[p + 1] = g * ms >>> ss;
						px[p + 2] = b * ms >>> ss;
					} else {
						px[p] = px[p + 1] = px[p + 2] = 0;
					}
					var p2;
					p = y1 + ryp1;
					if(p < h1) {
						p2 = p;
					} else {
						p2 = h1;
					}
					p = x2 + p2 * w << 2;
					r -= si.r - (si.r = px[p]);
					g -= si.g - (si.g = px[p + 1]);
					b -= si.b - (si.b = px[p + 2]);
					a -= si.a - (si.a = px[p + 3]);
					si = si.n;
					yi += w;
				}
			} else {
				var _g34 = 0;
				var _g24 = h;
				while(_g34 < _g24) {
					var y2 = _g34++;
					p = yi << 2;
					pa = a * ms >>> ss;
					px[p + 3] = pa;
					if(pa > 0) {
						f = 255 / pa;
						pr = (r * ms >>> ss) * f | 0;
						pg = (g * ms >>> ss) * f | 0;
						pb = (b * ms >>> ss) * f | 0;
						px[p] = pr > 255 ? 255 : pr;
						px[p + 1] = pg > 255 ? 255 : pg;
						px[p + 2] = pb > 255 ? 255 : pb;
					} else {
						px[p] = px[p + 1] = px[p + 2] = 0;
					}
					var p3;
					p = y2 + ryp1;
					if(p < h1) {
						p3 = p;
					} else {
						p3 = h1;
					}
					p = x2 + p3 * w << 2;
					r -= si.r - (si.r = px[p]);
					g -= si.g - (si.g = px[p + 1]);
					b -= si.b - (si.b = px[p + 2]);
					a -= si.a - (si.a = px[p + 3]);
					si = si.n;
					yi += w;
				}
			}
		}
	}
};
var lime__$internal_graphics_BlurStack = function() {
	this.r = 0;
	this.g = 0;
	this.b = 0;
	this.a = 0;
	this.n = null;
};
$hxClasses["lime._internal.graphics.BlurStack"] = lime__$internal_graphics_BlurStack;
lime__$internal_graphics_BlurStack.__name__ = ["lime","_internal","graphics","BlurStack"];
lime__$internal_graphics_BlurStack.prototype = {
	__class__: lime__$internal_graphics_BlurStack
};
var lime__$internal_macros_AssetsMacro = function() { };
$hxClasses["lime._internal.macros.AssetsMacro"] = lime__$internal_macros_AssetsMacro;
lime__$internal_macros_AssetsMacro.__name__ = ["lime","_internal","macros","AssetsMacro"];
var lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$ = {};
$hxClasses["lime._internal.unifill._CodePoint.CodePoint_Impl_"] = lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$;
lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$.__name__ = ["lime","_internal","unifill","_CodePoint","CodePoint_Impl_"];
lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$.fromInt = function(code) {
	if(!(0 <= code && code <= 1114111 && !(55296 <= code && code <= 56319) && !(56320 <= code && code <= 57343))) {
		throw new js__$Boot_HaxeError(new lime__$internal_unifill_InvalidCodePoint(code));
	}
	var this1 = code;
	return this1;
};
lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$.cons = function(a,b) {
	var this1;
	if(a <= 65535) {
		var this2 = String.fromCharCode(a);
		var this3 = this2;
		this1 = this3;
	} else {
		var this4 = String.fromCharCode((a >> 10) + 55232) + String.fromCharCode(a & 1023 | 56320);
		var this5 = this4;
		this1 = this5;
	}
	return this1 + b;
};
lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$.snoc = function(a,b) {
	var this1;
	if(b <= 65535) {
		var this2 = String.fromCharCode(b);
		var this3 = this2;
		this1 = this3;
	} else {
		var this4 = String.fromCharCode((b >> 10) + 55232) + String.fromCharCode(b & 1023 | 56320);
		var this5 = this4;
		this1 = this5;
	}
	return a + this1;
};
lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$.addInt = function(a,b) {
	var code = a + b;
	if(!(0 <= code && code <= 1114111 && !(55296 <= code && code <= 56319) && !(56320 <= code && code <= 57343))) {
		throw new js__$Boot_HaxeError(new lime__$internal_unifill_InvalidCodePoint(code));
	}
	var this1 = code;
	return this1;
};
lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$.sub = function(a,b) {
	return a - b;
};
lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$.subInt = function(a,b) {
	var code = a - b;
	if(!(0 <= code && code <= 1114111 && !(55296 <= code && code <= 56319) && !(56320 <= code && code <= 57343))) {
		throw new js__$Boot_HaxeError(new lime__$internal_unifill_InvalidCodePoint(code));
	}
	var this1 = code;
	return this1;
};
lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$._new = function(code) {
	var this1 = code;
	return this1;
};
lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$.toString = function(this1) {
	var this2;
	if(this1 <= 65535) {
		var this3 = String.fromCharCode(this1);
		var this4 = this3;
		this2 = this4;
	} else {
		var this5 = String.fromCharCode((this1 >> 10) + 55232) + String.fromCharCode(this1 & 1023 | 56320);
		var this6 = this5;
		this2 = this6;
	}
	return this2;
};
lime__$internal_unifill__$CodePoint_CodePoint_$Impl_$.toInt = function(this1) {
	return this1;
};
var lime__$internal_unifill_CodePointIter = function(s) {
	this.i = 0;
	this.string = s;
	this.index = 0;
	this.endIndex = s.length;
};
$hxClasses["lime._internal.unifill.CodePointIter"] = lime__$internal_unifill_CodePointIter;
lime__$internal_unifill_CodePointIter.__name__ = ["lime","_internal","unifill","CodePointIter"];
lime__$internal_unifill_CodePointIter.prototype = {
	hasNext: function() {
		return this.index < this.endIndex;
	}
	,next: function() {
		this.i = this.index;
		var tmp = this;
		var tmp1 = tmp.index;
		var this1 = this.string;
		var this2 = this1;
		var c = this2.charCodeAt(this.index);
		tmp.index = tmp1 + (!(55296 <= c && c <= 56319) ? 1 : 2);
		var this3 = this.string;
		var this4 = this3;
		return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointAt(this4,this.i);
	}
	,__class__: lime__$internal_unifill_CodePointIter
};
var lime__$internal_unifill_Exception = function() {
};
$hxClasses["lime._internal.unifill.Exception"] = lime__$internal_unifill_Exception;
lime__$internal_unifill_Exception.__name__ = ["lime","_internal","unifill","Exception"];
lime__$internal_unifill_Exception.prototype = {
	toString: function() {
		throw new js__$Boot_HaxeError(null);
	}
	,__class__: lime__$internal_unifill_Exception
};
var lime__$internal_unifill_InvalidCodePoint = function(code) {
	lime__$internal_unifill_Exception.call(this);
	this.code = code;
};
$hxClasses["lime._internal.unifill.InvalidCodePoint"] = lime__$internal_unifill_InvalidCodePoint;
lime__$internal_unifill_InvalidCodePoint.__name__ = ["lime","_internal","unifill","InvalidCodePoint"];
lime__$internal_unifill_InvalidCodePoint.__super__ = lime__$internal_unifill_Exception;
lime__$internal_unifill_InvalidCodePoint.prototype = $extend(lime__$internal_unifill_Exception.prototype,{
	toString: function() {
		return "InvalidCodePoint(code: " + this.code + ")";
	}
	,__class__: lime__$internal_unifill_InvalidCodePoint
});
var lime__$internal_unifill_InvalidCodeUnitSequence = function(index) {
	lime__$internal_unifill_Exception.call(this);
	this.index = index;
};
$hxClasses["lime._internal.unifill.InvalidCodeUnitSequence"] = lime__$internal_unifill_InvalidCodeUnitSequence;
lime__$internal_unifill_InvalidCodeUnitSequence.__name__ = ["lime","_internal","unifill","InvalidCodeUnitSequence"];
lime__$internal_unifill_InvalidCodeUnitSequence.__super__ = lime__$internal_unifill_Exception;
lime__$internal_unifill_InvalidCodeUnitSequence.prototype = $extend(lime__$internal_unifill_Exception.prototype,{
	toString: function() {
		return "InvalidCodeUnitSequence(index: " + this.index + ")";
	}
	,__class__: lime__$internal_unifill_InvalidCodeUnitSequence
});
var lime__$internal_unifill_InternalEncoding = function() { };
$hxClasses["lime._internal.unifill.InternalEncoding"] = lime__$internal_unifill_InternalEncoding;
lime__$internal_unifill_InternalEncoding.__name__ = ["lime","_internal","unifill","InternalEncoding"];
lime__$internal_unifill_InternalEncoding.__properties__ = {get_internalEncoding:"get_internalEncoding"};
lime__$internal_unifill_InternalEncoding.get_internalEncoding = function() {
	return "UTF-16";
};
lime__$internal_unifill_InternalEncoding.codeUnitAt = function(s,index) {
	var this1 = s;
	var this2 = this1;
	return this2.charCodeAt(index);
};
lime__$internal_unifill_InternalEncoding.codePointAt = function(s,index) {
	var this1 = s;
	var this2 = this1;
	return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointAt(this2,index);
};
lime__$internal_unifill_InternalEncoding.charAt = function(s,index) {
	var this1 = s;
	var this2 = this1;
	var this3 = this2;
	var c = this3.charCodeAt(index);
	var this4 = HxOverrides.substr(this3,index,!(55296 <= c && c <= 56319) ? 1 : 2);
	var this5 = this4;
	return this5;
};
lime__$internal_unifill_InternalEncoding.codePointCount = function(s,beginIndex,endIndex) {
	var this1 = s;
	var this2 = this1;
	return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointCount(this2,beginIndex,endIndex);
};
lime__$internal_unifill_InternalEncoding.codePointWidthAt = function(s,index) {
	var this1 = s;
	var this2 = this1;
	var c = this2.charCodeAt(index);
	if(!(55296 <= c && c <= 56319)) {
		return 1;
	} else {
		return 2;
	}
};
lime__$internal_unifill_InternalEncoding.codePointWidthBefore = function(s,index) {
	var this1 = s;
	var this2 = this1;
	var c = this2.charCodeAt(index - 1);
	if(!(56320 <= c && c <= 57343)) {
		return 1;
	} else {
		return 2;
	}
};
lime__$internal_unifill_InternalEncoding.offsetByCodePoints = function(s,index,codePointOffset) {
	var this1 = s;
	var this2 = this1;
	var this3 = this2;
	if(codePointOffset >= 0) {
		var index1 = index;
		var len = this3.length;
		var i = 0;
		while(i < codePointOffset && index1 < len) {
			var c = this3.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i;
		}
		return index1;
	} else {
		var index2 = index;
		var count = 0;
		while(count < -codePointOffset && 0 < index2) {
			var c1 = this3.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		return index2;
	}
};
lime__$internal_unifill_InternalEncoding.backwardOffsetByCodePoints = function(s,index,codePointOffset) {
	var this1 = s;
	var this2 = this1;
	var this3 = this2;
	var codePointOffset1 = -codePointOffset;
	if(codePointOffset1 >= 0) {
		var index1 = index;
		var len = this3.length;
		var i = 0;
		while(i < codePointOffset1 && index1 < len) {
			var c = this3.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i;
		}
		return index1;
	} else {
		var index2 = index;
		var count = 0;
		while(count < -codePointOffset1 && 0 < index2) {
			var c1 = this3.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		return index2;
	}
};
lime__$internal_unifill_InternalEncoding.fromCodePoint = function(codePoint) {
	var this1;
	if(codePoint <= 65535) {
		var this2 = String.fromCharCode(codePoint);
		var this3 = this2;
		this1 = this3;
	} else {
		var this4 = String.fromCharCode((codePoint >> 10) + 55232) + String.fromCharCode(codePoint & 1023 | 56320);
		var this5 = this4;
		this1 = this5;
	}
	return this1;
};
lime__$internal_unifill_InternalEncoding.fromCodePoints = function(codePoints) {
	var this1 = new StringBuf();
	var buf = this1;
	var c = $iterator(codePoints)();
	while(c.hasNext()) {
		var c1 = c.next();
		if(c1 <= 65535) {
			buf.b += String.fromCharCode(c1);
		} else {
			buf.b += String.fromCharCode((c1 >> 10) + 55232);
			buf.b += String.fromCharCode(c1 & 1023 | 56320);
		}
	}
	var this2 = buf.b;
	var this3 = this2;
	return this3;
};
lime__$internal_unifill_InternalEncoding.validate = function(s) {
	var this1 = s;
	var this2 = this1;
	lime__$internal_unifill__$Utf16_Utf16_$Impl_$.validate(this2);
};
lime__$internal_unifill_InternalEncoding.isValidString = function(s) {
	try {
		var this1 = s;
		var this2 = this1;
		lime__$internal_unifill__$Utf16_Utf16_$Impl_$.validate(this2);
		return true;
	} catch( e ) {
		haxe_CallStack.lastException = e;
		if (e instanceof js__$Boot_HaxeError) e = e.val;
		if( js_Boot.__instanceof(e,lime__$internal_unifill_InvalidCodeUnitSequence) ) {
			return false;
		} else throw(e);
	}
};
lime__$internal_unifill_InternalEncoding.encodeWith = function(f,c) {
	if(c <= 65535) {
		f(c);
	} else {
		f((c >> 10) + 55232);
		f(c & 1023 | 56320);
	}
};
var lime__$internal_unifill_InternalEncodingIter = function(s,beginIndex,endIndex) {
	this.i = 0;
	this.string = s;
	this.index = beginIndex;
	this.endIndex = endIndex;
};
$hxClasses["lime._internal.unifill.InternalEncodingIter"] = lime__$internal_unifill_InternalEncodingIter;
lime__$internal_unifill_InternalEncodingIter.__name__ = ["lime","_internal","unifill","InternalEncodingIter"];
lime__$internal_unifill_InternalEncodingIter.prototype = {
	hasNext: function() {
		return this.index < this.endIndex;
	}
	,next: function() {
		this.i = this.index;
		var tmp = this;
		var tmp1 = tmp.index;
		var this1 = this.string;
		var this2 = this1;
		var c = this2.charCodeAt(this.index);
		tmp.index = tmp1 + (!(55296 <= c && c <= 56319) ? 1 : 2);
		return this.i;
	}
	,__class__: lime__$internal_unifill_InternalEncodingIter
};
var lime__$internal_unifill_Unicode = function() { };
$hxClasses["lime._internal.unifill.Unicode"] = lime__$internal_unifill_Unicode;
lime__$internal_unifill_Unicode.__name__ = ["lime","_internal","unifill","Unicode"];
lime__$internal_unifill_Unicode.decodeSurrogate = function(hi,lo) {
	return hi - 55232 << 10 | lo & 1023;
};
lime__$internal_unifill_Unicode.encodeHighSurrogate = function(c) {
	return (c >> 10) + 55232;
};
lime__$internal_unifill_Unicode.encodeLowSurrogate = function(c) {
	return c & 1023 | 56320;
};
lime__$internal_unifill_Unicode.isScalar = function(code) {
	if(0 <= code && code <= 1114111 && !(55296 <= code && code <= 56319)) {
		return !(56320 <= code && code <= 57343);
	} else {
		return false;
	}
};
lime__$internal_unifill_Unicode.isHighSurrogate = function(code) {
	if(55296 <= code) {
		return code <= 56319;
	} else {
		return false;
	}
};
lime__$internal_unifill_Unicode.isLowSurrogate = function(code) {
	if(56320 <= code) {
		return code <= 57343;
	} else {
		return false;
	}
};
var lime__$internal_unifill_Unifill = function() { };
$hxClasses["lime._internal.unifill.Unifill"] = lime__$internal_unifill_Unifill;
lime__$internal_unifill_Unifill.__name__ = ["lime","_internal","unifill","Unifill"];
lime__$internal_unifill_Unifill.uLength = function(s) {
	var this1 = s;
	var this2 = this1;
	return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointCount(this2,0,s.length);
};
lime__$internal_unifill_Unifill.uCharAt = function(s,index) {
	var this1 = s;
	var this2 = this1;
	var this3 = this2;
	var i;
	if(index >= 0) {
		var index1 = 0;
		var len = this3.length;
		var i1 = 0;
		while(i1 < index && index1 < len) {
			var c = this3.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i1;
		}
		i = index1;
	} else {
		var index2 = 0;
		var count = 0;
		while(count < -index && 0 < index2) {
			var c1 = this3.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		i = index2;
	}
	var this4 = s;
	var this5 = this4;
	var this6 = this5;
	var c2 = this6.charCodeAt(i);
	var this7 = HxOverrides.substr(this6,i,!(55296 <= c2 && c2 <= 56319) ? 1 : 2);
	var this8 = this7;
	return this8;
};
lime__$internal_unifill_Unifill.uCharCodeAt = function(s,index) {
	var this1 = s;
	var this2 = this1;
	var this3 = this2;
	var i;
	if(index >= 0) {
		var index1 = 0;
		var len = this3.length;
		var i1 = 0;
		while(i1 < index && index1 < len) {
			var c = this3.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i1;
		}
		i = index1;
	} else {
		var index2 = 0;
		var count = 0;
		while(count < -index && 0 < index2) {
			var c1 = this3.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		i = index2;
	}
	var this4 = s;
	var this5 = this4;
	return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointAt(this5,i);
};
lime__$internal_unifill_Unifill.uCodePointAt = function(s,index) {
	var this1 = s;
	var this2 = this1;
	var this3 = this2;
	var i;
	if(index >= 0) {
		var index1 = 0;
		var len = this3.length;
		var i1 = 0;
		while(i1 < index && index1 < len) {
			var c = this3.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i1;
		}
		i = index1;
	} else {
		var index2 = 0;
		var count = 0;
		while(count < -index && 0 < index2) {
			var c1 = this3.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		i = index2;
	}
	var this4 = s;
	var this5 = this4;
	return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointAt(this5,i);
};
lime__$internal_unifill_Unifill.uIndexOf = function(s,value,startIndex) {
	if(startIndex == null) {
		startIndex = 0;
	}
	var this1 = s;
	var this2 = this1;
	var this3 = this2;
	var index;
	if(startIndex >= 0) {
		var index1 = 0;
		var len = this3.length;
		var i = 0;
		while(i < startIndex && index1 < len) {
			var c = this3.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i;
		}
		index = index1;
	} else {
		var index2 = 0;
		var count = 0;
		while(count < -startIndex && 0 < index2) {
			var c1 = this3.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		index = index2;
	}
	var index3 = s.indexOf(value,index);
	if(index3 >= 0) {
		var this4 = s;
		var this5 = this4;
		return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointCount(this5,0,index3);
	} else {
		return -1;
	}
};
lime__$internal_unifill_Unifill.uLastIndexOf = function(s,value,startIndex) {
	if(startIndex == null) {
		startIndex = s.length - 1;
	}
	var this1 = s;
	var this2 = this1;
	var this3 = this2;
	var index;
	if(startIndex >= 0) {
		var index1 = 0;
		var len = this3.length;
		var i = 0;
		while(i < startIndex && index1 < len) {
			var c = this3.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i;
		}
		index = index1;
	} else {
		var index2 = 0;
		var count = 0;
		while(count < -startIndex && 0 < index2) {
			var c1 = this3.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		index = index2;
	}
	var index3 = s.lastIndexOf(value,index);
	if(index3 >= 0) {
		var this4 = s;
		var this5 = this4;
		return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointCount(this5,0,index3);
	} else {
		return -1;
	}
};
lime__$internal_unifill_Unifill.uSplit = function(s,delimiter) {
	if(delimiter.length == 0) {
		var _g = [];
		var _g1_string;
		var _g1_index;
		var _g1_i;
		var _g1_endIndex;
		_g1_i = 0;
		_g1_string = s;
		_g1_index = 0;
		_g1_endIndex = s.length;
		while(_g1_index < _g1_endIndex) {
			_g1_i = _g1_index;
			var this1 = _g1_string;
			var this2 = this1;
			var c = this2.charCodeAt(_g1_index);
			_g1_index += !(55296 <= c && c <= 56319) ? 1 : 2;
			var i = _g1_i;
			var this3 = s;
			var this4 = this3;
			var this5 = this4;
			var c1 = this5.charCodeAt(i);
			var this6 = HxOverrides.substr(this5,i,!(55296 <= c1 && c1 <= 56319) ? 1 : 2);
			var this7 = this6;
			_g.push(this7);
		}
		return _g;
	} else {
		return s.split(delimiter);
	}
};
lime__$internal_unifill_Unifill.uSubstr = function(s,startIndex,length) {
	var index = startIndex >= 0 ? 0 : s.length;
	var this1 = s;
	var this2 = this1;
	var this3 = this2;
	var si;
	if(startIndex >= 0) {
		var index1 = index;
		var len = this3.length;
		var i = 0;
		while(i < startIndex && index1 < len) {
			var c = this3.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i;
		}
		si = index1;
	} else {
		var index2 = index;
		var count = 0;
		while(count < -startIndex && 0 < index2) {
			var c1 = this3.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		si = index2;
	}
	var ei;
	if(length == null) {
		ei = s.length;
	} else if(length < 0) {
		ei = si;
	} else {
		var this4 = s;
		var this5 = this4;
		var this6 = this5;
		if(length >= 0) {
			var index3 = si;
			var len1 = this6.length;
			var i1 = 0;
			while(i1 < length && index3 < len1) {
				var c2 = this6.charCodeAt(index3);
				index3 += !(55296 <= c2 && c2 <= 56319) ? 1 : 2;
				++i1;
			}
			ei = index3;
		} else {
			var index4 = si;
			var count1 = 0;
			while(count1 < -length && 0 < index4) {
				var c3 = this6.charCodeAt(index4 - 1);
				index4 -= !(56320 <= c3 && c3 <= 57343) ? 1 : 2;
				++count1;
			}
			ei = index4;
		}
	}
	return s.substring(si,ei);
};
lime__$internal_unifill_Unifill.uSubstring = function(s,startIndex,endIndex) {
	var si;
	if(startIndex < 0) {
		si = 0;
	} else {
		var this1 = s;
		var this2 = this1;
		var this3 = this2;
		if(startIndex >= 0) {
			var index = 0;
			var len = this3.length;
			var i = 0;
			while(i < startIndex && index < len) {
				var c = this3.charCodeAt(index);
				index += !(55296 <= c && c <= 56319) ? 1 : 2;
				++i;
			}
			si = index;
		} else {
			var index1 = 0;
			var count = 0;
			while(count < -startIndex && 0 < index1) {
				var c1 = this3.charCodeAt(index1 - 1);
				index1 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
				++count;
			}
			si = index1;
		}
	}
	var ei;
	if(endIndex == null) {
		ei = s.length;
	} else if(endIndex < 0) {
		ei = 0;
	} else {
		var this4 = s;
		var this5 = this4;
		var this6 = this5;
		if(endIndex >= 0) {
			var index2 = 0;
			var len1 = this6.length;
			var i1 = 0;
			while(i1 < endIndex && index2 < len1) {
				var c2 = this6.charCodeAt(index2);
				index2 += !(55296 <= c2 && c2 <= 56319) ? 1 : 2;
				++i1;
			}
			ei = index2;
		} else {
			var index3 = 0;
			var count1 = 0;
			while(count1 < -endIndex && 0 < index3) {
				var c3 = this6.charCodeAt(index3 - 1);
				index3 -= !(56320 <= c3 && c3 <= 57343) ? 1 : 2;
				++count1;
			}
			ei = index3;
		}
	}
	return s.substring(si,ei);
};
lime__$internal_unifill_Unifill.uIterator = function(s) {
	return new lime__$internal_unifill_CodePointIter(s);
};
lime__$internal_unifill_Unifill.uCompare = function(a,b) {
	var aiter_string;
	var aiter_index;
	var aiter_i;
	var aiter_endIndex;
	aiter_i = 0;
	aiter_string = a;
	aiter_index = 0;
	aiter_endIndex = a.length;
	var biter_string;
	var biter_index;
	var biter_i;
	var biter_endIndex;
	biter_i = 0;
	biter_string = b;
	biter_index = 0;
	biter_endIndex = b.length;
	while(aiter_index < aiter_endIndex && biter_index < biter_endIndex) {
		aiter_i = aiter_index;
		var this1 = aiter_string;
		var this2 = this1;
		var c = this2.charCodeAt(aiter_index);
		aiter_index += !(55296 <= c && c <= 56319) ? 1 : 2;
		var this3 = a;
		var this4 = this3;
		var acode = lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointAt(this4,aiter_i);
		biter_i = biter_index;
		var this5 = biter_string;
		var this6 = this5;
		var c1 = this6.charCodeAt(biter_index);
		biter_index += !(55296 <= c1 && c1 <= 56319) ? 1 : 2;
		var this7 = b;
		var this8 = this7;
		var bcode = lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointAt(this8,biter_i);
		if(acode < bcode) {
			return -1;
		}
		if(acode > bcode) {
			return 1;
		}
	}
	if(biter_index < biter_endIndex) {
		return -1;
	}
	if(aiter_index < aiter_endIndex) {
		return 1;
	}
	return 0;
};
lime__$internal_unifill_Unifill.uToString = function(codePoints) {
	var this1 = new StringBuf();
	var buf = this1;
	var c = $iterator(codePoints)();
	while(c.hasNext()) {
		var c1 = c.next();
		if(c1 <= 65535) {
			buf.b += String.fromCharCode(c1);
		} else {
			buf.b += String.fromCharCode((c1 >> 10) + 55232);
			buf.b += String.fromCharCode(c1 & 1023 | 56320);
		}
	}
	var this2 = buf.b;
	var this3 = this2;
	return this3;
};
lime__$internal_unifill_Unifill.uAddChar = function(sb,c) {
	var c1 = c;
	if(c1 <= 65535) {
		sb.b += String.fromCharCode(c1);
	} else {
		sb.b += String.fromCharCode((c1 >> 10) + 55232);
		sb.b += String.fromCharCode(c1 & 1023 | 56320);
	}
};
var lime__$internal_unifill__$Utf16_Utf16_$Impl_$ = {};
$hxClasses["lime._internal.unifill._Utf16.Utf16_Impl_"] = lime__$internal_unifill__$Utf16_Utf16_$Impl_$;
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.__name__ = ["lime","_internal","unifill","_Utf16","Utf16_Impl_"];
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.__properties__ = {get_length:"get_length"};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.fromCodePoint = function(codePoint) {
	if(codePoint <= 65535) {
		var this1 = String.fromCharCode(codePoint);
		var this2 = this1;
		return this2;
	} else {
		var this3 = String.fromCharCode((codePoint >> 10) + 55232) + String.fromCharCode(codePoint & 1023 | 56320);
		var this4 = this3;
		return this4;
	}
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.fromCodePoints = function(codePoints) {
	var this1 = new StringBuf();
	var buf = this1;
	var c = $iterator(codePoints)();
	while(c.hasNext()) {
		var c1 = c.next();
		if(c1 <= 65535) {
			buf.b += String.fromCharCode(c1);
		} else {
			buf.b += String.fromCharCode((c1 >> 10) + 55232);
			buf.b += String.fromCharCode(c1 & 1023 | 56320);
		}
	}
	var this2 = buf.b;
	var this3 = this2;
	return this3;
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.fromString = function(s) {
	var this1 = s;
	var this2 = this1;
	return this2;
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.fromArray = function(a) {
	var buf_b = "";
	var _g = 0;
	while(_g < a.length) {
		var x = a[_g];
		++_g;
		buf_b += String.fromCharCode(x);
	}
	var this1 = buf_b;
	var this2 = this1;
	return this2;
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.encodeWith = function(f,c) {
	if(c <= 65535) {
		f(c);
	} else {
		f((c >> 10) + 55232);
		f(c & 1023 | 56320);
	}
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codeUnitAt = function(this1,index) {
	return this1.charCodeAt(index);
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointAt = function(this1,index) {
	return lime__$internal_unifill__$Utf16_Utf16Impl.decode_code_point(this1.length,function(i) {
		return this1.charCodeAt(i);
	},index);
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.charAt = function(this1,index) {
	var c = this1.charCodeAt(index);
	var this2 = HxOverrides.substr(this1,index,!(55296 <= c && c <= 56319) ? 1 : 2);
	var this3 = this2;
	return this3;
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointCount = function(this1,beginIndex,endIndex) {
	var index = beginIndex;
	var i = 0;
	while(index < endIndex) {
		var c = this1.charCodeAt(index);
		index += !(55296 <= c && c <= 56319) ? 1 : 2;
		++i;
	}
	return i;
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointWidthAt = function(this1,index) {
	var c = this1.charCodeAt(index);
	if(!(55296 <= c && c <= 56319)) {
		return 1;
	} else {
		return 2;
	}
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointWidthBefore = function(this1,index) {
	var c = this1.charCodeAt(index - 1);
	if(!(56320 <= c && c <= 57343)) {
		return 1;
	} else {
		return 2;
	}
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.offsetByCodePoints = function(this1,index,codePointOffset) {
	if(codePointOffset >= 0) {
		var index1 = index;
		var len = this1.length;
		var i = 0;
		while(i < codePointOffset && index1 < len) {
			var c = this1.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i;
		}
		return index1;
	} else {
		var index2 = index;
		var count = 0;
		while(count < -codePointOffset && 0 < index2) {
			var c1 = this1.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		return index2;
	}
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.substr = function(this1,index,len) {
	var this2 = HxOverrides.substr(this1,index,len);
	var this3 = this2;
	return this3;
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.validate = function(this1) {
	var len = this1.length;
	var accessor = function(i) {
		return this1.charCodeAt(i);
	};
	var i1 = 0;
	while(i1 < len) {
		lime__$internal_unifill__$Utf16_Utf16Impl.decode_code_point(len,accessor,i1);
		var c = this1.charCodeAt(i1);
		i1 += !(55296 <= c && c <= 56319) ? 1 : 2;
	}
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.toString = function(this1) {
	return this1;
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.toArray = function(this1) {
	var i = 0;
	var len = this1.length;
	var _g = [];
	while(i < len) _g.push(this1.charCodeAt(i++));
	return _g;
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$._new = function(s) {
	var this1 = s;
	return this1;
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.get_length = function(this1) {
	return this1.length;
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.forward_offset_by_code_points = function(this1,index,codePointOffset) {
	var len = this1.length;
	var i = 0;
	while(i < codePointOffset && index < len) {
		var c = this1.charCodeAt(index);
		index += !(55296 <= c && c <= 56319) ? 1 : 2;
		++i;
	}
	return index;
};
lime__$internal_unifill__$Utf16_Utf16_$Impl_$.backward_offset_by_code_points = function(this1,index,codePointOffset) {
	var count = 0;
	while(count < codePointOffset && 0 < index) {
		var c = this1.charCodeAt(index - 1);
		index -= !(56320 <= c && c <= 57343) ? 1 : 2;
		++count;
	}
	return index;
};
var lime__$internal_unifill__$Utf16_Utf16Impl = function() { };
$hxClasses["lime._internal.unifill._Utf16.Utf16Impl"] = lime__$internal_unifill__$Utf16_Utf16Impl;
lime__$internal_unifill__$Utf16_Utf16Impl.__name__ = ["lime","_internal","unifill","_Utf16","Utf16Impl"];
lime__$internal_unifill__$Utf16_Utf16Impl.code_point_width = function(c) {
	if(!(55296 <= c && c <= 56319)) {
		return 1;
	} else {
		return 2;
	}
};
lime__$internal_unifill__$Utf16_Utf16Impl.find_prev_code_point = function(accessor,index) {
	var c = accessor(index - 1);
	if(!(56320 <= c && c <= 57343)) {
		return 1;
	} else {
		return 2;
	}
};
lime__$internal_unifill__$Utf16_Utf16Impl.encode_code_point = function(addUnit,codePoint) {
	if(codePoint <= 65535) {
		addUnit(codePoint);
	} else {
		addUnit((codePoint >> 10) + 55232);
		addUnit(codePoint & 1023 | 56320);
	}
};
lime__$internal_unifill__$Utf16_Utf16Impl.decode_code_point = function(len,accessor,index) {
	if(index < 0 || len <= index) {
		throw new js__$Boot_HaxeError(new lime__$internal_unifill_InvalidCodeUnitSequence(index));
	}
	var hi = accessor(index);
	if(55296 <= hi && hi <= 56319) {
		if(index + 1 < 0 || len <= index + 1) {
			throw new js__$Boot_HaxeError(new lime__$internal_unifill_InvalidCodeUnitSequence(index));
		}
		var lo = accessor(index + 1);
		if(56320 <= lo && lo <= 57343) {
			return hi - 55232 << 10 | lo & 1023;
		} else {
			throw new js__$Boot_HaxeError(new lime__$internal_unifill_InvalidCodeUnitSequence(index));
		}
	} else if(56320 <= hi && hi <= 57343) {
		throw new js__$Boot_HaxeError(new lime__$internal_unifill_InvalidCodeUnitSequence(index));
	} else {
		return hi;
	}
};
var lime__$internal_unifill__$Utf16_StringU16Buffer_$Impl_$ = {};
$hxClasses["lime._internal.unifill._Utf16.StringU16Buffer_Impl_"] = lime__$internal_unifill__$Utf16_StringU16Buffer_$Impl_$;
lime__$internal_unifill__$Utf16_StringU16Buffer_$Impl_$.__name__ = ["lime","_internal","unifill","_Utf16","StringU16Buffer_Impl_"];
lime__$internal_unifill__$Utf16_StringU16Buffer_$Impl_$._new = function() {
	var this1 = new StringBuf();
	return this1;
};
lime__$internal_unifill__$Utf16_StringU16Buffer_$Impl_$.addUnit = function(this1,unit) {
	this1.b += String.fromCharCode(unit);
};
lime__$internal_unifill__$Utf16_StringU16Buffer_$Impl_$.getStringU16 = function(this1) {
	var this2 = this1.b;
	return this2;
};
var lime__$internal_unifill__$Utf16_StringU16_$Impl_$ = {};
$hxClasses["lime._internal.unifill._Utf16.StringU16_Impl_"] = lime__$internal_unifill__$Utf16_StringU16_$Impl_$;
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.__name__ = ["lime","_internal","unifill","_Utf16","StringU16_Impl_"];
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.__properties__ = {get_length:"get_length"};
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.fromString = function(s) {
	var this1 = s;
	return this1;
};
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.fromCodeUnit = function(u) {
	var this1 = String.fromCharCode(u);
	return this1;
};
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.fromTwoCodeUnits = function(u0,u1) {
	var this1 = String.fromCharCode(u0) + String.fromCharCode(u1);
	return this1;
};
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.ofArray = function(a) {
	var buf_b = "";
	var _g = 0;
	while(_g < a.length) {
		var x = a[_g];
		++_g;
		buf_b += String.fromCharCode(x);
	}
	var this1 = buf_b;
	return this1;
};
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.fromArray = function(a) {
	var buf_b = "";
	var _g = 0;
	while(_g < a.length) {
		var x = a[_g];
		++_g;
		buf_b += String.fromCharCode(x);
	}
	var this1 = buf_b;
	return this1;
};
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.codeUnitAt = function(this1,index) {
	return this1.charCodeAt(index);
};
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.substr = function(this1,index,len) {
	var this2 = HxOverrides.substr(this1,index,len);
	return this2;
};
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.toString = function(this1) {
	return this1;
};
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.toArray = function(this1) {
	var i = 0;
	var len = this1.length;
	var _g = [];
	while(i < len) _g.push(this1.charCodeAt(i++));
	return _g;
};
lime__$internal_unifill__$Utf16_StringU16_$Impl_$._new = function(s) {
	var this1 = s;
	return this1;
};
lime__$internal_unifill__$Utf16_StringU16_$Impl_$.get_length = function(this1) {
	return this1.length;
};
var lime_app_Event = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app.Event"] = lime_app_Event;
lime_app_Event.__name__ = ["lime","app","Event"];
lime_app_Event.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,__class__: lime_app_Event
};
var lime_app_Future = function(work,async) {
	if(async == null) {
		async = false;
	}
	if(work != null) {
		if(async) {
			var promise = new lime_app_Promise();
			promise.future = this;
			lime_app__$Future_FutureWork.queue({ promise : promise, work : work});
		} else {
			try {
				this.value = work();
				this.isComplete = true;
			} catch( e ) {
				haxe_CallStack.lastException = e;
				if (e instanceof js__$Boot_HaxeError) e = e.val;
				this.error = e;
				this.isError = true;
			}
		}
	}
};
$hxClasses["lime.app.Future"] = lime_app_Future;
lime_app_Future.__name__ = ["lime","app","Future"];
lime_app_Future.ofEvents = function(onComplete,onError,onProgress) {
	var promise = new lime_app_Promise();
	onComplete.add(function(data) {
		promise.complete(data);
	},true);
	if(onError != null) {
		onError.add(function(error) {
			promise.error(error);
		},true);
	}
	if(onProgress != null) {
		onProgress.add(function(progress,total) {
			promise.progress(progress,total);
		},true);
	}
	return promise.future;
};
lime_app_Future.withError = function(error) {
	var future = new lime_app_Future();
	future.isError = true;
	future.error = error;
	return future;
};
lime_app_Future.withValue = function(value) {
	var future = new lime_app_Future();
	future.isComplete = true;
	future.value = value;
	return future;
};
lime_app_Future.prototype = {
	onComplete: function(listener) {
		if(listener != null) {
			if(this.isComplete) {
				listener(this.value);
			} else if(!this.isError) {
				if(this.__completeListeners == null) {
					this.__completeListeners = [];
				}
				this.__completeListeners.push(listener);
			}
		}
		return this;
	}
	,onError: function(listener) {
		if(listener != null) {
			if(this.isError) {
				listener(this.error);
			} else if(!this.isComplete) {
				if(this.__errorListeners == null) {
					this.__errorListeners = [];
				}
				this.__errorListeners.push(listener);
			}
		}
		return this;
	}
	,onProgress: function(listener) {
		if(listener != null) {
			if(this.__progressListeners == null) {
				this.__progressListeners = [];
			}
			this.__progressListeners.push(listener);
		}
		return this;
	}
	,ready: function(waitTime) {
		if(waitTime == null) {
			waitTime = -1;
		}
		if(this.isComplete || this.isError) {
			return this;
		} else {
			lime_utils_Log.warn("Cannot block thread in JavaScript",{ fileName : "Future.hx", lineNumber : 208, className : "lime.app.Future", methodName : "ready"});
			return this;
		}
	}
	,result: function(waitTime) {
		if(waitTime == null) {
			waitTime = -1;
		}
		this.ready(waitTime);
		if(this.isComplete) {
			return this.value;
		} else {
			return null;
		}
	}
	,then: function(next) {
		if(this.isComplete) {
			return next(this.value);
		} else if(this.isError) {
			var future = new lime_app_Future();
			future.isError = true;
			future.error = this.error;
			return future;
		} else {
			var promise = new lime_app_Promise();
			this.onError($bind(promise,promise.error));
			this.onProgress($bind(promise,promise.progress));
			this.onComplete(function(val) {
				var future1 = next(val);
				future1.onError($bind(promise,promise.error));
				future1.onComplete($bind(promise,promise.complete));
			});
			return promise.future;
		}
	}
	,__class__: lime_app_Future
};
var lime_app__$Future_FutureWork = function() { };
$hxClasses["lime.app._Future.FutureWork"] = lime_app__$Future_FutureWork;
lime_app__$Future_FutureWork.__name__ = ["lime","app","_Future","FutureWork"];
lime_app__$Future_FutureWork.queue = function(state) {
	if(lime_app__$Future_FutureWork.threadPool == null) {
		lime_app__$Future_FutureWork.threadPool = new lime_system_ThreadPool();
		lime_app__$Future_FutureWork.threadPool.doWork.add(lime_app__$Future_FutureWork.threadPool_doWork);
		lime_app__$Future_FutureWork.threadPool.onComplete.add(lime_app__$Future_FutureWork.threadPool_onComplete);
		lime_app__$Future_FutureWork.threadPool.onError.add(lime_app__$Future_FutureWork.threadPool_onError);
	}
	lime_app__$Future_FutureWork.threadPool.queue(state);
};
lime_app__$Future_FutureWork.threadPool_doWork = function(state) {
	try {
		var result = state.work();
		lime_app__$Future_FutureWork.threadPool.sendComplete({ promise : state.promise, result : result});
	} catch( e ) {
		haxe_CallStack.lastException = e;
		if (e instanceof js__$Boot_HaxeError) e = e.val;
		lime_app__$Future_FutureWork.threadPool.sendError({ promise : state.promise, error : e});
	}
};
lime_app__$Future_FutureWork.threadPool_onComplete = function(state) {
	state.promise.complete(state.result);
};
lime_app__$Future_FutureWork.threadPool_onError = function(state) {
	state.promise.error(state.error);
};
var lime_app_Promise = function() {
	this.future = new lime_app_Future();
};
$hxClasses["lime.app.Promise"] = lime_app_Promise;
lime_app_Promise.__name__ = ["lime","app","Promise"];
lime_app_Promise.prototype = {
	complete: function(data) {
		if(!this.future.isError) {
			this.future.isComplete = true;
			this.future.value = data;
			if(this.future.__completeListeners != null) {
				var _g = 0;
				var _g1 = this.future.__completeListeners;
				while(_g < _g1.length) {
					var listener = _g1[_g];
					++_g;
					listener(data);
				}
				this.future.__completeListeners = null;
			}
		}
		return this;
	}
	,completeWith: function(future) {
		future.onComplete($bind(this,this.complete));
		future.onError($bind(this,this.error));
		future.onProgress($bind(this,this.progress));
		return this;
	}
	,error: function(msg) {
		if(!this.future.isComplete) {
			this.future.isError = true;
			this.future.error = msg;
			if(this.future.__errorListeners != null) {
				var _g = 0;
				var _g1 = this.future.__errorListeners;
				while(_g < _g1.length) {
					var listener = _g1[_g];
					++_g;
					listener(msg);
				}
				this.future.__errorListeners = null;
			}
		}
		return this;
	}
	,progress: function(progress,total) {
		if(!this.future.isError && !this.future.isComplete) {
			if(this.future.__progressListeners != null) {
				var _g = 0;
				var _g1 = this.future.__progressListeners;
				while(_g < _g1.length) {
					var listener = _g1[_g];
					++_g;
					listener(progress,total);
				}
			}
		}
		return this;
	}
	,get_isComplete: function() {
		return this.future.isComplete;
	}
	,get_isError: function() {
		return this.future.isError;
	}
	,__class__: lime_app_Promise
	,__properties__: {get_isError:"get_isError",get_isComplete:"get_isComplete"}
};
var lime_app__$Event_$Dynamic_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Dynamic_Void"] = lime_app__$Event_$Dynamic_$Void;
lime_app__$Event_$Dynamic_$Void.__name__ = ["lime","app","_Event_Dynamic_Void"];
lime_app__$Event_$Dynamic_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Dynamic_$Void
};
var lime_app__$Event_$Float_$Float_$Float_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Float_Float_Float_Void"] = lime_app__$Event_$Float_$Float_$Float_$Void;
lime_app__$Event_$Float_$Float_$Float_$Void.__name__ = ["lime","app","_Event_Float_Float_Float_Void"];
lime_app__$Event_$Float_$Float_$Float_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Float_$Float_$Float_$Void
};
var lime_app__$Event_$Float_$Float_$Int_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Float_Float_Int_Void"] = lime_app__$Event_$Float_$Float_$Int_$Void;
lime_app__$Event_$Float_$Float_$Int_$Void.__name__ = ["lime","app","_Event_Float_Float_Int_Void"];
lime_app__$Event_$Float_$Float_$Int_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Float_$Float_$Int_$Void
};
var lime_app__$Event_$Float_$Float_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Float_Float_Void"] = lime_app__$Event_$Float_$Float_$Void;
lime_app__$Event_$Float_$Float_$Void.__name__ = ["lime","app","_Event_Float_Float_Void"];
lime_app__$Event_$Float_$Float_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Float_$Float_$Void
};
var lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Float_Float_lime_ui_MouseButton_Void"] = lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void;
lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void.__name__ = ["lime","app","_Event_Float_Float_lime_ui_MouseButton_Void"];
lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void
};
var lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Float_Float_lime_ui_MouseWheelMode_Void"] = lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void;
lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void.__name__ = ["lime","app","_Event_Float_Float_lime_ui_MouseWheelMode_Void"];
lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void
};
var lime_app__$Event_$Int_$Float_$Float_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Int_Float_Float_Void"] = lime_app__$Event_$Int_$Float_$Float_$Void;
lime_app__$Event_$Int_$Float_$Float_$Void.__name__ = ["lime","app","_Event_Int_Float_Float_Void"];
lime_app__$Event_$Int_$Float_$Float_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Int_$Float_$Float_$Void
};
var lime_app__$Event_$Int_$Float_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Int_Float_Void"] = lime_app__$Event_$Int_$Float_$Void;
lime_app__$Event_$Int_$Float_$Void.__name__ = ["lime","app","_Event_Int_Float_Void"];
lime_app__$Event_$Int_$Float_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Int_$Float_$Void
};
var lime_app__$Event_$Int_$Int_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Int_Int_Void"] = lime_app__$Event_$Int_$Int_$Void;
lime_app__$Event_$Int_$Int_$Void.__name__ = ["lime","app","_Event_Int_Int_Void"];
lime_app__$Event_$Int_$Int_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Int_$Int_$Void
};
var lime_app__$Event_$Int_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Int_Void"] = lime_app__$Event_$Int_$Void;
lime_app__$Event_$Int_$Void.__name__ = ["lime","app","_Event_Int_Void"];
lime_app__$Event_$Int_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Int_$Void
};
var lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Int_lime_ui_JoystickHatPosition_Void"] = lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void;
lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void.__name__ = ["lime","app","_Event_Int_lime_ui_JoystickHatPosition_Void"];
lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void
};
var lime_app__$Event_$String_$Int_$Int_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_String_Int_Int_Void"] = lime_app__$Event_$String_$Int_$Int_$Void;
lime_app__$Event_$String_$Int_$Int_$Void.__name__ = ["lime","app","_Event_String_Int_Int_Void"];
lime_app__$Event_$String_$Int_$Int_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$String_$Int_$Int_$Void
};
var lime_app__$Event_$String_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_String_Void"] = lime_app__$Event_$String_$Void;
lime_app__$Event_$String_$Void.__name__ = ["lime","app","_Event_String_Void"];
lime_app__$Event_$String_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$String_$Void
};
var lime_app__$Event_$Void_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Void_Void"] = lime_app__$Event_$Void_$Void;
lime_app__$Event_$Void_$Void.__name__ = ["lime","app","_Event_Void_Void"];
lime_app__$Event_$Void_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function() {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i]();
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Void_$Void
};
var lime_app__$Event_$lime_$graphics_$RenderContext_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_graphics_RenderContext_Void"] = lime_app__$Event_$lime_$graphics_$RenderContext_$Void;
lime_app__$Event_$lime_$graphics_$RenderContext_$Void.__name__ = ["lime","app","_Event_lime_graphics_RenderContext_Void"];
lime_app__$Event_$lime_$graphics_$RenderContext_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$graphics_$RenderContext_$Void
};
var lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_GamepadAxis_Float_Void"] = lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void;
lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void.__name__ = ["lime","app","_Event_lime_ui_GamepadAxis_Float_Void"];
lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void
};
var lime_app__$Event_$lime_$ui_$GamepadButton_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_GamepadButton_Void"] = lime_app__$Event_$lime_$ui_$GamepadButton_$Void;
lime_app__$Event_$lime_$ui_$GamepadButton_$Void.__name__ = ["lime","app","_Event_lime_ui_GamepadButton_Void"];
lime_app__$Event_$lime_$ui_$GamepadButton_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$GamepadButton_$Void
};
var lime_app__$Event_$lime_$ui_$Gamepad_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_Gamepad_Void"] = lime_app__$Event_$lime_$ui_$Gamepad_$Void;
lime_app__$Event_$lime_$ui_$Gamepad_$Void.__name__ = ["lime","app","_Event_lime_ui_Gamepad_Void"];
lime_app__$Event_$lime_$ui_$Gamepad_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$Gamepad_$Void
};
var lime_app__$Event_$lime_$ui_$Joystick_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_Joystick_Void"] = lime_app__$Event_$lime_$ui_$Joystick_$Void;
lime_app__$Event_$lime_$ui_$Joystick_$Void.__name__ = ["lime","app","_Event_lime_ui_Joystick_Void"];
lime_app__$Event_$lime_$ui_$Joystick_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$Joystick_$Void
};
var lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_KeyCode_lime_ui_KeyModifier_Void"] = lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void;
lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void.__name__ = ["lime","app","_Event_lime_ui_KeyCode_lime_ui_KeyModifier_Void"];
lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void
};
var lime_app__$Event_$lime_$ui_$Touch_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_Touch_Void"] = lime_app__$Event_$lime_$ui_$Touch_$Void;
lime_app__$Event_$lime_$ui_$Touch_$Void.__name__ = ["lime","app","_Event_lime_ui_Touch_Void"];
lime_app__$Event_$lime_$ui_$Touch_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$Touch_$Void
};
var lime_app__$Event_$lime_$ui_$Window_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_Window_Void"] = lime_app__$Event_$lime_$ui_$Window_$Void;
lime_app__$Event_$lime_$ui_$Window_$Void.__name__ = ["lime","app","_Event_lime_ui_Window_Void"];
lime_app__$Event_$lime_$ui_$Window_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$Window_$Void
};
var lime_app__$Event_$ofEvents_$T_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_ofEvents_T_Void"] = lime_app__$Event_$ofEvents_$T_$Void;
lime_app__$Event_$ofEvents_$T_$Void.__name__ = ["lime","app","_Event_ofEvents_T_Void"];
lime_app__$Event_$ofEvents_$T_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g1 = 0;
		var _g = this.__priorities.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$ofEvents_$T_$Void
};
var lime_graphics__$CairoRenderContext_CairoRenderContext_$Impl_$ = {};
$hxClasses["lime.graphics._CairoRenderContext.CairoRenderContext_Impl_"] = lime_graphics__$CairoRenderContext_CairoRenderContext_$Impl_$;
lime_graphics__$CairoRenderContext_CairoRenderContext_$Impl_$.__name__ = ["lime","graphics","_CairoRenderContext","CairoRenderContext_Impl_"];
lime_graphics__$CairoRenderContext_CairoRenderContext_$Impl_$.fromRenderContext = function(context) {
	return context.cairo;
};
var lime_graphics__$Canvas2DRenderContext_Canvas2DRenderContext_$Impl_$ = {};
$hxClasses["lime.graphics._Canvas2DRenderContext.Canvas2DRenderContext_Impl_"] = lime_graphics__$Canvas2DRenderContext_Canvas2DRenderContext_$Impl_$;
lime_graphics__$Canvas2DRenderContext_Canvas2DRenderContext_$Impl_$.__name__ = ["lime","graphics","_Canvas2DRenderContext","Canvas2DRenderContext_Impl_"];
lime_graphics__$Canvas2DRenderContext_Canvas2DRenderContext_$Impl_$.fromRenderContext = function(context) {
	return context.canvas2D;
};
var lime_graphics__$DOMRenderContext_DOMRenderContext_$Impl_$ = {};
$hxClasses["lime.graphics._DOMRenderContext.DOMRenderContext_Impl_"] = lime_graphics__$DOMRenderContext_DOMRenderContext_$Impl_$;
lime_graphics__$DOMRenderContext_DOMRenderContext_$Impl_$.__name__ = ["lime","graphics","_DOMRenderContext","DOMRenderContext_Impl_"];
lime_graphics__$DOMRenderContext_DOMRenderContext_$Impl_$.fromRenderContext = function(context) {
	return context.dom;
};
var lime_graphics__$FlashRenderContext_FlashRenderContext_$Impl_$ = {};
$hxClasses["lime.graphics._FlashRenderContext.FlashRenderContext_Impl_"] = lime_graphics__$FlashRenderContext_FlashRenderContext_$Impl_$;
lime_graphics__$FlashRenderContext_FlashRenderContext_$Impl_$.__name__ = ["lime","graphics","_FlashRenderContext","FlashRenderContext_Impl_"];
lime_graphics__$FlashRenderContext_FlashRenderContext_$Impl_$.fromRenderContext = function(context) {
	return null;
};
var lime_graphics_Image = function(buffer,offsetX,offsetY,width,height,color,type) {
	if(height == null) {
		height = -1;
	}
	if(width == null) {
		width = -1;
	}
	if(offsetY == null) {
		offsetY = 0;
	}
	if(offsetX == null) {
		offsetX = 0;
	}
	this.offsetX = offsetX;
	this.offsetY = offsetY;
	this.width = width;
	this.height = height;
	this.version = 0;
	if(type == null) {
		type = lime_graphics_ImageType.CANVAS;
	}
	this.type = type;
	if(buffer == null) {
		if(width > 0 && height > 0) {
			var _g = this.type;
			switch(_g[1]) {
			case 0:
				this.buffer = new lime_graphics_ImageBuffer(null,width,height);
				lime__$internal_graphics_ImageCanvasUtil.createCanvas(this,width,height);
				if(color != null && color != 0) {
					this.fillRect(new lime_math_Rectangle(0,0,width,height),color);
				}
				break;
			case 1:
				var elements = width * height * 4;
				var this1;
				if(elements != null) {
					this1 = new Uint8Array(elements);
				} else {
					this1 = null;
				}
				this.buffer = new lime_graphics_ImageBuffer(this1,width,height);
				if(color != null && color != 0) {
					this.fillRect(new lime_math_Rectangle(0,0,width,height),color);
				}
				break;
			case 2:
				break;
			default:
			}
		}
	} else {
		this.__fromImageBuffer(buffer);
	}
};
$hxClasses["lime.graphics.Image"] = lime_graphics_Image;
lime_graphics_Image.__name__ = ["lime","graphics","Image"];
lime_graphics_Image.fromBase64 = function(base64,type) {
	if(base64 == null) {
		return null;
	}
	var image = new lime_graphics_Image();
	image.__fromBase64(base64,type);
	return image;
};
lime_graphics_Image.fromBitmapData = function(bitmapData) {
	if(bitmapData == null) {
		return null;
	}
	return bitmapData.image;
};
lime_graphics_Image.fromBytes = function(bytes) {
	if(bytes == null) {
		return null;
	}
	var image = new lime_graphics_Image();
	if(image.__fromBytes(bytes)) {
		return image;
	} else {
		return null;
	}
};
lime_graphics_Image.fromCanvas = function(canvas) {
	if(canvas == null) {
		return null;
	}
	var buffer = new lime_graphics_ImageBuffer(null,canvas.width,canvas.height);
	buffer.set_src(canvas);
	var image = new lime_graphics_Image(buffer);
	image.type = lime_graphics_ImageType.CANVAS;
	return image;
};
lime_graphics_Image.fromFile = function(path) {
	if(path == null) {
		return null;
	}
	var image = new lime_graphics_Image();
	if(image.__fromFile(path)) {
		return image;
	} else {
		return null;
	}
};
lime_graphics_Image.fromImageElement = function(image) {
	if(image == null) {
		return null;
	}
	var buffer = new lime_graphics_ImageBuffer(null,image.width,image.height);
	buffer.set_src(image);
	var _image = new lime_graphics_Image(buffer);
	_image.type = lime_graphics_ImageType.CANVAS;
	return _image;
};
lime_graphics_Image.loadFromBase64 = function(base64,type) {
	if(base64 == null || type == null) {
		return lime_app_Future.withValue(null);
	}
	return lime__$internal_backend_html5_HTML5HTTPRequest.loadImage("data:" + type + ";base64," + base64);
};
lime_graphics_Image.loadFromBytes = function(bytes) {
	if(bytes == null) {
		return lime_app_Future.withValue(null);
	}
	var type = "";
	if(lime_graphics_Image.__isPNG(bytes)) {
		type = "image/png";
	} else if(lime_graphics_Image.__isJPG(bytes)) {
		type = "image/jpeg";
	} else if(lime_graphics_Image.__isGIF(bytes)) {
		type = "image/gif";
	} else if(lime_graphics_Image.__isWebP(bytes)) {
		type = "image/webp";
	} else {
		return lime_app_Future.withValue(null);
	}
	return lime__$internal_backend_html5_HTML5HTTPRequest.loadImageFromBytes(bytes,type);
};
lime_graphics_Image.loadFromFile = function(path) {
	if(path == null) {
		return lime_app_Future.withValue(null);
	}
	return lime__$internal_backend_html5_HTML5HTTPRequest.loadImage(path);
};
lime_graphics_Image.__isGIF = function(bytes) {
	if(bytes == null || bytes.length < 6) {
		return false;
	}
	var header = bytes.getString(0,6);
	if(header != "GIF87a") {
		return header == "GIF89a";
	} else {
		return true;
	}
};
lime_graphics_Image.__isJPG = function(bytes) {
	if(bytes == null || bytes.length < 4) {
		return false;
	}
	if(bytes.b[0] == 255 && bytes.b[1] == 216 && bytes.b[bytes.length - 2] == 255) {
		return bytes.b[bytes.length - 1] == 217;
	} else {
		return false;
	}
};
lime_graphics_Image.__isPNG = function(bytes) {
	if(bytes == null || bytes.length < 8) {
		return false;
	}
	if(bytes.b[0] == 137 && bytes.b[1] == 80 && bytes.b[2] == 78 && bytes.b[3] == 71 && bytes.b[4] == 13 && bytes.b[5] == 10 && bytes.b[6] == 26) {
		return bytes.b[7] == 10;
	} else {
		return false;
	}
};
lime_graphics_Image.__isWebP = function(bytes) {
	if(bytes == null || bytes.length < 16) {
		return false;
	}
	if(bytes.getString(0,4) == "RIFF") {
		return bytes.getString(8,4) == "WEBP";
	} else {
		return false;
	}
};
lime_graphics_Image.prototype = {
	clone: function() {
		if(this.buffer != null) {
			if(this.type == lime_graphics_ImageType.CANVAS) {
				lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this);
			} else {
				lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			}
			var image = new lime_graphics_Image(this.buffer.clone(),this.offsetX,this.offsetY,this.width,this.height,null,this.type);
			image.version = this.version;
			return image;
		} else {
			return new lime_graphics_Image(null,this.offsetX,this.offsetY,this.width,this.height,null,this.type);
		}
	}
	,colorTransform: function(rect,colorMatrix) {
		rect = this.__clipRect(rect);
		if(this.buffer == null || rect == null) {
			return;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.colorTransform(this,rect,colorMatrix);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageDataUtil.colorTransform(this,rect,colorMatrix);
			break;
		case 2:
			rect.offset(this.offsetX,this.offsetY);
			this.buffer.__srcBitmapData.colorTransform(rect.__toFlashRectangle(),lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__toFlashColorTransform(colorMatrix));
			break;
		default:
		}
	}
	,copyChannel: function(sourceImage,sourceRect,destPoint,sourceChannel,destChannel) {
		sourceRect = this.__clipRect(sourceRect);
		if(this.buffer == null || sourceRect == null) {
			return;
		}
		if(destChannel == lime_graphics_ImageChannel.ALPHA && !this.get_transparent()) {
			return;
		}
		if(sourceRect.width <= 0 || sourceRect.height <= 0) {
			return;
		}
		if(sourceRect.x + sourceRect.width > sourceImage.width) {
			sourceRect.width = sourceImage.width - sourceRect.x;
		}
		if(sourceRect.y + sourceRect.height > sourceImage.height) {
			sourceRect.height = sourceImage.height - sourceRect.y;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.copyChannel(this,sourceImage,sourceRect,destPoint,sourceChannel,destChannel);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
			lime__$internal_graphics_ImageDataUtil.copyChannel(this,sourceImage,sourceRect,destPoint,sourceChannel,destChannel);
			break;
		case 2:
			var srcChannel;
			switch(sourceChannel[1]) {
			case 0:
				srcChannel = 1;
				break;
			case 1:
				srcChannel = 2;
				break;
			case 2:
				srcChannel = 4;
				break;
			case 3:
				srcChannel = 8;
				break;
			}
			var dstChannel;
			switch(destChannel[1]) {
			case 0:
				dstChannel = 1;
				break;
			case 1:
				dstChannel = 2;
				break;
			case 2:
				dstChannel = 4;
				break;
			case 3:
				dstChannel = 8;
				break;
			}
			sourceRect.offset(sourceImage.offsetX,sourceImage.offsetY);
			destPoint.offset(this.offsetX,this.offsetY);
			this.buffer.__srcBitmapData.copyChannel(sourceImage.buffer.get_src(),sourceRect.__toFlashRectangle(),destPoint.__toFlashPoint(),srcChannel,dstChannel);
			break;
		default:
		}
	}
	,copyPixels: function(sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha) {
		if(mergeAlpha == null) {
			mergeAlpha = false;
		}
		if(this.buffer == null || sourceImage == null) {
			return;
		}
		if(sourceRect.width <= 0 || sourceRect.height <= 0) {
			return;
		}
		if(this.width <= 0 || this.height <= 0) {
			return;
		}
		if(sourceRect.x + sourceRect.width > sourceImage.width) {
			sourceRect.width = sourceImage.width - sourceRect.x;
		}
		if(sourceRect.y + sourceRect.height > sourceImage.height) {
			sourceRect.height = sourceImage.height - sourceRect.y;
		}
		if(sourceRect.x < 0) {
			sourceRect.width += sourceRect.x;
			sourceRect.x = 0;
		}
		if(sourceRect.y < 0) {
			sourceRect.height += sourceRect.y;
			sourceRect.y = 0;
		}
		if(destPoint.x + sourceRect.width > this.width) {
			sourceRect.width = this.width - destPoint.x;
		}
		if(destPoint.y + sourceRect.height > this.height) {
			sourceRect.height = this.height - destPoint.y;
		}
		if(destPoint.x < 0) {
			sourceRect.width += destPoint.x;
			sourceRect.x -= destPoint.x;
			destPoint.x = 0;
		}
		if(destPoint.y < 0) {
			sourceRect.height += destPoint.y;
			sourceRect.y -= destPoint.y;
			destPoint.y = 0;
		}
		if(sourceImage == this && destPoint.x < sourceRect.get_right() && destPoint.y < sourceRect.get_bottom()) {
			sourceImage = this.clone();
		}
		if(alphaImage == sourceImage && (alphaPoint == null || alphaPoint.x == 0 && alphaPoint.y == 0)) {
			alphaImage = null;
			alphaPoint = null;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			if(alphaImage != null) {
				lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
				lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
				if(alphaImage != null) {
					lime__$internal_graphics_ImageCanvasUtil.convertToData(alphaImage);
				}
				lime__$internal_graphics_ImageDataUtil.copyPixels(this,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha);
			} else {
				lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this);
				lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(sourceImage);
				lime__$internal_graphics_ImageCanvasUtil.copyPixels(this,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha);
			}
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
			if(alphaImage != null) {
				lime__$internal_graphics_ImageCanvasUtil.convertToData(alphaImage);
			}
			lime__$internal_graphics_ImageDataUtil.copyPixels(this,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha);
			break;
		case 2:
			sourceRect.offset(sourceImage.offsetX,sourceImage.offsetY);
			destPoint.offset(this.offsetX,this.offsetY);
			if(alphaImage != null && alphaPoint != null) {
				alphaPoint.offset(alphaImage.offsetX,alphaImage.offsetY);
			}
			this.buffer.__srcBitmapData.copyPixels(sourceImage.buffer.__srcBitmapData,sourceRect.__toFlashRectangle(),destPoint.__toFlashPoint(),alphaImage != null ? alphaImage.buffer.get_src() : null,alphaPoint != null ? alphaPoint.__toFlashPoint() : null,mergeAlpha);
			break;
		default:
		}
	}
	,encode: function(format,quality) {
		if(quality == null) {
			quality = 90;
		}
		if(format == null) {
			return lime__$internal_format_PNG.encode(this);
		} else {
			switch(format[1]) {
			case 0:
				return lime__$internal_format_BMP.encode(this);
			case 1:
				return lime__$internal_format_JPEG.encode(this,quality);
			case 2:
				return lime__$internal_format_PNG.encode(this);
			}
		}
	}
	,fillRect: function(rect,color,format) {
		rect = this.__clipRect(rect);
		if(this.buffer == null || rect == null) {
			return;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.fillRect(this,rect,color,format);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			if(this.buffer.data.length == 0) {
				return;
			}
			lime__$internal_graphics_ImageDataUtil.fillRect(this,rect,color,format);
			break;
		case 2:
			rect.offset(this.offsetX,this.offsetY);
			var argb;
			if(format == null) {
				var rgba = color;
				var this1 = 0;
				var argb1 = this1;
				argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
				argb = argb1;
			} else {
				switch(format) {
				case 1:
					argb = color;
					break;
				case 2:
					var bgra = color;
					var this2 = 0;
					var argb2 = this2;
					argb2 = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
					argb = argb2;
					break;
				default:
					var rgba1 = color;
					var this3 = 0;
					var argb3 = this3;
					argb3 = (rgba1 & 255 & 255) << 24 | (rgba1 >>> 24 & 255 & 255) << 16 | (rgba1 >>> 16 & 255 & 255) << 8 | rgba1 >>> 8 & 255 & 255;
					argb = argb3;
				}
			}
			this.buffer.__srcBitmapData.fillRect(rect.__toFlashRectangle(),argb);
			break;
		default:
		}
	}
	,floodFill: function(x,y,color,format) {
		if(this.buffer == null) {
			return;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.floodFill(this,x,y,color,format);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageDataUtil.floodFill(this,x,y,color,format);
			break;
		case 2:
			var argb;
			if(format == null) {
				var rgba = color;
				var this1 = 0;
				var argb1 = this1;
				argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
				argb = argb1;
			} else {
				switch(format) {
				case 1:
					argb = color;
					break;
				case 2:
					var bgra = color;
					var this2 = 0;
					var argb2 = this2;
					argb2 = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
					argb = argb2;
					break;
				default:
					var rgba1 = color;
					var this3 = 0;
					var argb3 = this3;
					argb3 = (rgba1 & 255 & 255) << 24 | (rgba1 >>> 24 & 255 & 255) << 16 | (rgba1 >>> 16 & 255 & 255) << 8 | rgba1 >>> 8 & 255 & 255;
					argb = argb3;
				}
			}
			this.buffer.__srcBitmapData.floodFill(x + this.offsetX,y + this.offsetY,argb);
			break;
		default:
		}
	}
	,getColorBoundsRect: function(mask,color,findColor,format) {
		if(findColor == null) {
			findColor = true;
		}
		if(this.buffer == null) {
			return null;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			return lime__$internal_graphics_ImageDataUtil.getColorBoundsRect(this,mask,color,findColor,format);
		case 1:
			return lime__$internal_graphics_ImageDataUtil.getColorBoundsRect(this,mask,color,findColor,format);
		case 2:
			var rect = this.buffer.__srcBitmapData.getColorBoundsRect(mask,color,findColor);
			return new lime_math_Rectangle(rect.x,rect.y,rect.width,rect.height);
		default:
			return null;
		}
	}
	,getPixel: function(x,y,format) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) {
			return 0;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			return lime__$internal_graphics_ImageCanvasUtil.getPixel(this,x,y,format);
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			return lime__$internal_graphics_ImageDataUtil.getPixel(this,x,y,format);
		case 2:
			var color = this.buffer.__srcBitmapData.getPixel(x + this.offsetX,y + this.offsetY);
			if(format == null) {
				var this1 = 0;
				var rgba = this1;
				rgba = (color >>> 16 & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color & 255 & 255) << 8 | color >>> 24 & 255 & 255;
				var rgba1 = rgba;
				return rgba1;
			} else {
				switch(format) {
				case 1:
					return color;
				case 2:
					var this2 = 0;
					var bgra = this2;
					bgra = (color & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color >>> 16 & 255 & 255) << 8 | color >>> 24 & 255 & 255;
					var bgra1 = bgra;
					return bgra1;
				default:
					var this3 = 0;
					var rgba2 = this3;
					rgba2 = (color >>> 16 & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color & 255 & 255) << 8 | color >>> 24 & 255 & 255;
					var rgba3 = rgba2;
					return rgba3;
				}
			}
			break;
		default:
			return 0;
		}
	}
	,getPixel32: function(x,y,format) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) {
			return 0;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			return lime__$internal_graphics_ImageCanvasUtil.getPixel32(this,x,y,format);
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			return lime__$internal_graphics_ImageDataUtil.getPixel32(this,x,y,format);
		case 2:
			var color = this.buffer.__srcBitmapData.getPixel32(x + this.offsetX,y + this.offsetY);
			if(format == null) {
				var this1 = 0;
				var rgba = this1;
				rgba = (color >>> 16 & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color & 255 & 255) << 8 | color >>> 24 & 255 & 255;
				var rgba1 = rgba;
				return rgba1;
			} else {
				switch(format) {
				case 1:
					return color;
				case 2:
					var this2 = 0;
					var bgra = this2;
					bgra = (color & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color >>> 16 & 255 & 255) << 8 | color >>> 24 & 255 & 255;
					var bgra1 = bgra;
					return bgra1;
				default:
					var this3 = 0;
					var rgba2 = this3;
					rgba2 = (color >>> 16 & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color & 255 & 255) << 8 | color >>> 24 & 255 & 255;
					var rgba3 = rgba2;
					return rgba3;
				}
			}
			break;
		default:
			return 0;
		}
	}
	,getPixels: function(rect,format) {
		if(this.buffer == null) {
			return null;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			return lime__$internal_graphics_ImageCanvasUtil.getPixels(this,rect,format);
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			return lime__$internal_graphics_ImageDataUtil.getPixels(this,rect,format);
		case 2:
			return null;
		default:
			return null;
		}
	}
	,merge: function(sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
		if(this.buffer == null || sourceImage == null) {
			return;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this);
			lime__$internal_graphics_ImageCanvasUtil.merge(this,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
			lime__$internal_graphics_ImageDataUtil.merge(this,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
			break;
		case 2:
			sourceRect.offset(this.offsetX,this.offsetY);
			this.buffer.__srcBitmapData.merge(sourceImage.buffer.__srcBitmapData,sourceRect.__toFlashRectangle(),destPoint.__toFlashPoint(),redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
			break;
		default:
			return;
		}
	}
	,resize: function(newWidth,newHeight) {
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.resize(this,newWidth,newHeight);
			break;
		case 1:
			lime__$internal_graphics_ImageDataUtil.resize(this,newWidth,newHeight);
			break;
		case 2:
			break;
		default:
		}
		this.buffer.width = newWidth;
		this.buffer.height = newHeight;
		this.offsetX = 0;
		this.offsetY = 0;
		this.width = newWidth;
		this.height = newHeight;
	}
	,scroll: function(x,y) {
		if(this.buffer == null) {
			return;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.scroll(this,x,y);
			break;
		case 1:
			this.copyPixels(this,this.get_rect(),new lime_math_Vector2(x,y));
			break;
		case 2:
			this.buffer.__srcBitmapData.scroll(x + this.offsetX,y + this.offsetX);
			break;
		default:
		}
	}
	,setPixel: function(x,y,color,format) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) {
			return;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.setPixel(this,x,y,color,format);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageDataUtil.setPixel(this,x,y,color,format);
			break;
		case 2:
			var argb;
			if(format == null) {
				var rgba = color;
				var this1 = 0;
				var argb1 = this1;
				argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
				argb = argb1;
			} else {
				switch(format) {
				case 1:
					argb = color;
					break;
				case 2:
					var bgra = color;
					var this2 = 0;
					var argb2 = this2;
					argb2 = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
					argb = argb2;
					break;
				default:
					var rgba1 = color;
					var this3 = 0;
					var argb3 = this3;
					argb3 = (rgba1 & 255 & 255) << 24 | (rgba1 >>> 24 & 255 & 255) << 16 | (rgba1 >>> 16 & 255 & 255) << 8 | rgba1 >>> 8 & 255 & 255;
					argb = argb3;
				}
			}
			this.buffer.__srcBitmapData.setPixel(x + this.offsetX,y + this.offsetX,argb);
			break;
		default:
		}
	}
	,setPixel32: function(x,y,color,format) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) {
			return;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.setPixel32(this,x,y,color,format);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageDataUtil.setPixel32(this,x,y,color,format);
			break;
		case 2:
			var argb;
			if(format == null) {
				var rgba = color;
				var this1 = 0;
				var argb1 = this1;
				argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
				argb = argb1;
			} else {
				switch(format) {
				case 1:
					argb = color;
					break;
				case 2:
					var bgra = color;
					var this2 = 0;
					var argb2 = this2;
					argb2 = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
					argb = argb2;
					break;
				default:
					var rgba1 = color;
					var this3 = 0;
					var argb3 = this3;
					argb3 = (rgba1 & 255 & 255) << 24 | (rgba1 >>> 24 & 255 & 255) << 16 | (rgba1 >>> 16 & 255 & 255) << 8 | rgba1 >>> 8 & 255 & 255;
					argb = argb3;
				}
			}
			this.buffer.__srcBitmapData.setPixel32(x + this.offsetX,y + this.offsetY,argb);
			break;
		default:
		}
	}
	,setPixels: function(rect,bytePointer,format,endian) {
		rect = this.__clipRect(rect);
		if(this.buffer == null || rect == null) {
			return;
		}
		if(endian == null) {
			endian = lime_system_Endian.BIG_ENDIAN;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.setPixels(this,rect,bytePointer,format,endian);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageDataUtil.setPixels(this,rect,bytePointer,format,endian);
			break;
		case 2:
			break;
		default:
		}
	}
	,threshold: function(sourceImage,sourceRect,destPoint,operation,threshold,color,mask,copySource,format) {
		if(copySource == null) {
			copySource = false;
		}
		if(mask == null) {
			mask = -1;
		}
		if(color == null) {
			color = 0;
		}
		if(this.buffer == null || sourceImage == null || sourceRect == null) {
			return 0;
		}
		var _g = this.type;
		switch(_g[1]) {
		case 0:case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
			return lime__$internal_graphics_ImageDataUtil.threshold(this,sourceImage,sourceRect,destPoint,operation,threshold,color,mask,copySource,format);
		case 2:
			var _color;
			if(format == null) {
				var rgba = color;
				var this1 = 0;
				var argb = this1;
				argb = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
				_color = argb;
			} else {
				switch(format) {
				case 1:
					_color = color;
					break;
				case 2:
					var bgra = color;
					var this2 = 0;
					var argb1 = this2;
					argb1 = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
					_color = argb1;
					break;
				default:
					var rgba1 = color;
					var this3 = 0;
					var argb2 = this3;
					argb2 = (rgba1 & 255 & 255) << 24 | (rgba1 >>> 24 & 255 & 255) << 16 | (rgba1 >>> 16 & 255 & 255) << 8 | rgba1 >>> 8 & 255 & 255;
					_color = argb2;
				}
			}
			var _mask;
			if(format == null) {
				var rgba2 = mask;
				var this4 = 0;
				var argb3 = this4;
				argb3 = (rgba2 & 255 & 255) << 24 | (rgba2 >>> 24 & 255 & 255) << 16 | (rgba2 >>> 16 & 255 & 255) << 8 | rgba2 >>> 8 & 255 & 255;
				_mask = argb3;
			} else {
				switch(format) {
				case 1:
					_mask = mask;
					break;
				case 2:
					var bgra1 = mask;
					var this5 = 0;
					var argb4 = this5;
					argb4 = (bgra1 & 255 & 255) << 24 | (bgra1 >>> 8 & 255 & 255) << 16 | (bgra1 >>> 16 & 255 & 255) << 8 | bgra1 >>> 24 & 255 & 255;
					_mask = argb4;
					break;
				default:
					var rgba3 = mask;
					var this6 = 0;
					var argb5 = this6;
					argb5 = (rgba3 & 255 & 255) << 24 | (rgba3 >>> 24 & 255 & 255) << 16 | (rgba3 >>> 16 & 255 & 255) << 8 | rgba3 >>> 8 & 255 & 255;
					_mask = argb5;
				}
			}
			sourceRect.offset(sourceImage.offsetX,sourceImage.offsetY);
			destPoint.offset(this.offsetX,this.offsetY);
			return this.buffer.__srcBitmapData.threshold(sourceImage.buffer.get_src(),sourceRect.__toFlashRectangle(),destPoint.__toFlashPoint(),operation,threshold,_color,_mask,copySource);
		default:
		}
		return 0;
	}
	,__clipRect: function(r) {
		if(r == null) {
			return null;
		}
		if(r.x < 0) {
			r.width -= -r.x;
			r.x = 0;
			if(r.x + r.width <= 0) {
				return null;
			}
		}
		if(r.y < 0) {
			r.height -= -r.y;
			r.y = 0;
			if(r.y + r.height <= 0) {
				return null;
			}
		}
		if(r.x + r.width >= this.width) {
			r.width -= r.x + r.width - this.width;
			if(r.width <= 0) {
				return null;
			}
		}
		if(r.y + r.height >= this.height) {
			r.height -= r.y + r.height - this.height;
			if(r.height <= 0) {
				return null;
			}
		}
		return r;
	}
	,__fromBase64: function(base64,type,onload) {
		var _gthis = this;
		var image = new Image();
		var image_onLoaded = function(event) {
			_gthis.buffer = new lime_graphics_ImageBuffer(null,image.width,image.height);
			_gthis.buffer.__srcImage = image;
			_gthis.offsetX = 0;
			_gthis.offsetY = 0;
			_gthis.width = _gthis.buffer.width;
			_gthis.height = _gthis.buffer.height;
			if(onload != null) {
				onload(_gthis);
			}
		};
		image.addEventListener("load",image_onLoaded,false);
		image.src = "data:" + type + ";base64," + base64;
	}
	,__fromBytes: function(bytes,onload) {
		var type = "";
		if(lime_graphics_Image.__isPNG(bytes)) {
			type = "image/png";
		} else if(lime_graphics_Image.__isJPG(bytes)) {
			type = "image/jpeg";
		} else if(lime_graphics_Image.__isGIF(bytes)) {
			type = "image/gif";
		} else {
			return false;
		}
		this.__fromBase64(lime__$internal_format_Base64.encode(bytes),type,onload);
		return true;
	}
	,__fromFile: function(path,onload,onerror) {
		var _gthis = this;
		var image = new Image();
		if(!lime__$internal_backend_html5_HTML5HTTPRequest.__isSameOrigin(path)) {
			image.crossOrigin = "Anonymous";
		}
		image.onload = function(_) {
			_gthis.buffer = new lime_graphics_ImageBuffer(null,image.width,image.height);
			_gthis.buffer.__srcImage = image;
			_gthis.width = image.width;
			_gthis.height = image.height;
			if(onload != null) {
				onload(_gthis);
			}
		};
		image.onerror = function(_1) {
			if(onerror != null) {
				onerror();
			}
		};
		image.src = path;
		var image1 = image.complete;
		return true;
	}
	,__fromImageBuffer: function(buffer) {
		this.buffer = buffer;
		if(buffer != null) {
			if(this.width == -1) {
				this.width = buffer.width;
			}
			if(this.height == -1) {
				this.height = buffer.height;
			}
		}
	}
	,get_data: function() {
		if(this.buffer.data == null && this.buffer.width > 0 && this.buffer.height > 0) {
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
		}
		return this.buffer.data;
	}
	,set_data: function(value) {
		return this.buffer.data = value;
	}
	,get_format: function() {
		return this.buffer.format;
	}
	,set_format: function(value) {
		if(this.buffer.format != value) {
			var _g = this.type;
			if(_g[1] == 1) {
				lime__$internal_graphics_ImageDataUtil.setFormat(this,value);
			}
		}
		return this.buffer.format = value;
	}
	,get_powerOfTwo: function() {
		if(this.buffer.width != 0 && (this.buffer.width & ~this.buffer.width + 1) == this.buffer.width) {
			if(this.buffer.height != 0) {
				return (this.buffer.height & ~this.buffer.height + 1) == this.buffer.height;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	,set_powerOfTwo: function(value) {
		if(value != this.get_powerOfTwo()) {
			var newWidth = 1;
			var newHeight = 1;
			while(newWidth < this.buffer.width) newWidth <<= 1;
			while(newHeight < this.buffer.height) newHeight <<= 1;
			if(newWidth == this.buffer.width && newHeight == this.buffer.height) {
				return value;
			}
			var _g = this.type;
			switch(_g[1]) {
			case 0:
				lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
				lime__$internal_graphics_ImageDataUtil.resizeBuffer(this,newWidth,newHeight);
				break;
			case 1:
				lime__$internal_graphics_ImageDataUtil.resizeBuffer(this,newWidth,newHeight);
				break;
			case 2:
				break;
			default:
			}
		}
		return value;
	}
	,get_premultiplied: function() {
		return this.buffer.premultiplied;
	}
	,set_premultiplied: function(value) {
		if(value && !this.buffer.premultiplied) {
			var _g = this.type;
			switch(_g[1]) {
			case 0:case 1:
				lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
				lime__$internal_graphics_ImageDataUtil.multiplyAlpha(this);
				break;
			default:
			}
		} else if(!value && this.buffer.premultiplied) {
			var _g1 = this.type;
			if(_g1[1] == 1) {
				lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
				lime__$internal_graphics_ImageDataUtil.unmultiplyAlpha(this);
			}
		}
		return value;
	}
	,get_rect: function() {
		return new lime_math_Rectangle(0,0,this.width,this.height);
	}
	,get_src: function() {
		if(this.buffer.__srcCanvas == null && (this.buffer.data != null || this.type == lime_graphics_ImageType.DATA)) {
			lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this);
		}
		return this.buffer.get_src();
	}
	,set_src: function(value) {
		return this.buffer.set_src(value);
	}
	,get_transparent: function() {
		if(this.buffer == null) {
			return false;
		}
		return this.buffer.transparent;
	}
	,set_transparent: function(value) {
		if(this.buffer == null) {
			return false;
		}
		return this.buffer.transparent = value;
	}
	,__class__: lime_graphics_Image
	,__properties__: {set_transparent:"set_transparent",get_transparent:"get_transparent",set_src:"set_src",get_src:"get_src",get_rect:"get_rect",set_premultiplied:"set_premultiplied",get_premultiplied:"get_premultiplied",set_powerOfTwo:"set_powerOfTwo",get_powerOfTwo:"get_powerOfTwo",set_format:"set_format",get_format:"get_format",set_data:"set_data",get_data:"get_data"}
};
var lime_graphics_ImageBuffer = function(data,width,height,bitsPerPixel,format) {
	if(bitsPerPixel == null) {
		bitsPerPixel = 32;
	}
	if(height == null) {
		height = 0;
	}
	if(width == null) {
		width = 0;
	}
	this.data = data;
	this.width = width;
	this.height = height;
	this.bitsPerPixel = bitsPerPixel;
	this.format = format == null ? 0 : format;
	this.premultiplied = false;
	this.transparent = true;
};
$hxClasses["lime.graphics.ImageBuffer"] = lime_graphics_ImageBuffer;
lime_graphics_ImageBuffer.__name__ = ["lime","graphics","ImageBuffer"];
lime_graphics_ImageBuffer.prototype = {
	clone: function() {
		var buffer = new lime_graphics_ImageBuffer(this.data,this.width,this.height,this.bitsPerPixel);
		if(this.data != null) {
			var elements = this.data.byteLength;
			var this1;
			if(elements != null) {
				this1 = new Uint8Array(elements);
			} else {
				this1 = null;
			}
			buffer.data = this1;
			var view = this.data;
			var this2;
			if(view != null) {
				this2 = new Uint8Array(view);
			} else {
				this2 = null;
			}
			var copy = this2;
			buffer.data.set(copy);
		} else if(this.__srcImageData != null) {
			buffer.__srcCanvas = window.document.createElement("canvas");
			buffer.__srcContext = buffer.__srcCanvas.getContext("2d");
			buffer.__srcCanvas.width = this.__srcImageData.width;
			buffer.__srcCanvas.height = this.__srcImageData.height;
			buffer.__srcImageData = buffer.__srcContext.createImageData(this.__srcImageData.width,this.__srcImageData.height);
			var copy1 = new Uint8ClampedArray(this.__srcImageData.data);
			buffer.__srcImageData.data.set(copy1);
		} else if(this.__srcCanvas != null) {
			buffer.__srcCanvas = window.document.createElement("canvas");
			buffer.__srcContext = buffer.__srcCanvas.getContext("2d");
			buffer.__srcCanvas.width = this.__srcCanvas.width;
			buffer.__srcCanvas.height = this.__srcCanvas.height;
			buffer.__srcContext.drawImage(this.__srcCanvas,0,0);
		} else {
			buffer.__srcImage = this.__srcImage;
		}
		buffer.bitsPerPixel = this.bitsPerPixel;
		buffer.format = this.format;
		buffer.premultiplied = this.premultiplied;
		buffer.transparent = this.transparent;
		return buffer;
	}
	,get_src: function() {
		if(this.__srcImage != null) {
			return this.__srcImage;
		}
		return this.__srcCanvas;
	}
	,set_src: function(value) {
		if(js_Boot.__instanceof(value,Image)) {
			this.__srcImage = value;
		} else if(js_Boot.__instanceof(value,HTMLCanvasElement)) {
			this.__srcCanvas = value;
			this.__srcContext = this.__srcCanvas.getContext("2d");
		}
		return value;
	}
	,get_stride: function() {
		return this.width * (this.bitsPerPixel / 8 | 0);
	}
	,__class__: lime_graphics_ImageBuffer
	,__properties__: {get_stride:"get_stride",set_src:"set_src",get_src:"get_src"}
};
var lime_graphics_ImageChannel = $hxClasses["lime.graphics.ImageChannel"] = { __ename__ : ["lime","graphics","ImageChannel"], __constructs__ : ["RED","GREEN","BLUE","ALPHA"] };
lime_graphics_ImageChannel.RED = ["RED",0];
lime_graphics_ImageChannel.RED.toString = $estr;
lime_graphics_ImageChannel.RED.__enum__ = lime_graphics_ImageChannel;
lime_graphics_ImageChannel.GREEN = ["GREEN",1];
lime_graphics_ImageChannel.GREEN.toString = $estr;
lime_graphics_ImageChannel.GREEN.__enum__ = lime_graphics_ImageChannel;
lime_graphics_ImageChannel.BLUE = ["BLUE",2];
lime_graphics_ImageChannel.BLUE.toString = $estr;
lime_graphics_ImageChannel.BLUE.__enum__ = lime_graphics_ImageChannel;
lime_graphics_ImageChannel.ALPHA = ["ALPHA",3];
lime_graphics_ImageChannel.ALPHA.toString = $estr;
lime_graphics_ImageChannel.ALPHA.__enum__ = lime_graphics_ImageChannel;
var lime_graphics_ImageFileFormat = $hxClasses["lime.graphics.ImageFileFormat"] = { __ename__ : ["lime","graphics","ImageFileFormat"], __constructs__ : ["BMP","JPEG","PNG"] };
lime_graphics_ImageFileFormat.BMP = ["BMP",0];
lime_graphics_ImageFileFormat.BMP.toString = $estr;
lime_graphics_ImageFileFormat.BMP.__enum__ = lime_graphics_ImageFileFormat;
lime_graphics_ImageFileFormat.JPEG = ["JPEG",1];
lime_graphics_ImageFileFormat.JPEG.toString = $estr;
lime_graphics_ImageFileFormat.JPEG.__enum__ = lime_graphics_ImageFileFormat;
lime_graphics_ImageFileFormat.PNG = ["PNG",2];
lime_graphics_ImageFileFormat.PNG.toString = $estr;
lime_graphics_ImageFileFormat.PNG.__enum__ = lime_graphics_ImageFileFormat;
var lime_graphics_ImageType = $hxClasses["lime.graphics.ImageType"] = { __ename__ : ["lime","graphics","ImageType"], __constructs__ : ["CANVAS","DATA","FLASH","CUSTOM"] };
lime_graphics_ImageType.CANVAS = ["CANVAS",0];
lime_graphics_ImageType.CANVAS.toString = $estr;
lime_graphics_ImageType.CANVAS.__enum__ = lime_graphics_ImageType;
lime_graphics_ImageType.DATA = ["DATA",1];
lime_graphics_ImageType.DATA.toString = $estr;
lime_graphics_ImageType.DATA.__enum__ = lime_graphics_ImageType;
lime_graphics_ImageType.FLASH = ["FLASH",2];
lime_graphics_ImageType.FLASH.toString = $estr;
lime_graphics_ImageType.FLASH.__enum__ = lime_graphics_ImageType;
lime_graphics_ImageType.CUSTOM = ["CUSTOM",3];
lime_graphics_ImageType.CUSTOM.toString = $estr;
lime_graphics_ImageType.CUSTOM.__enum__ = lime_graphics_ImageType;
var lime_graphics__$OpenGLES2RenderContext_OpenGLES2RenderContext_$Impl_$ = {};
$hxClasses["lime.graphics._OpenGLES2RenderContext.OpenGLES2RenderContext_Impl_"] = lime_graphics__$OpenGLES2RenderContext_OpenGLES2RenderContext_$Impl_$;
lime_graphics__$OpenGLES2RenderContext_OpenGLES2RenderContext_$Impl_$.__name__ = ["lime","graphics","_OpenGLES2RenderContext","OpenGLES2RenderContext_Impl_"];
lime_graphics__$OpenGLES2RenderContext_OpenGLES2RenderContext_$Impl_$.fromGL = function(gl) {
	return null;
};
lime_graphics__$OpenGLES2RenderContext_OpenGLES2RenderContext_$Impl_$.fromOpenGLES3RenderContext = function(gl) {
	return null;
};
lime_graphics__$OpenGLES2RenderContext_OpenGLES2RenderContext_$Impl_$.fromRenderContext = function(context) {
	return null;
};
lime_graphics__$OpenGLES2RenderContext_OpenGLES2RenderContext_$Impl_$.fromWebGLRenderContext = function(gl) {
	return null;
};
var lime_graphics__$OpenGLES3RenderContext_OpenGLES3RenderContext_$Impl_$ = {};
$hxClasses["lime.graphics._OpenGLES3RenderContext.OpenGLES3RenderContext_Impl_"] = lime_graphics__$OpenGLES3RenderContext_OpenGLES3RenderContext_$Impl_$;
lime_graphics__$OpenGLES3RenderContext_OpenGLES3RenderContext_$Impl_$.__name__ = ["lime","graphics","_OpenGLES3RenderContext","OpenGLES3RenderContext_Impl_"];
lime_graphics__$OpenGLES3RenderContext_OpenGLES3RenderContext_$Impl_$.fromRenderContext = function(context) {
	return null;
};
lime_graphics__$OpenGLES3RenderContext_OpenGLES3RenderContext_$Impl_$.fromGL = function(gl) {
	return null;
};
lime_graphics__$OpenGLES3RenderContext_OpenGLES3RenderContext_$Impl_$.fromOpenGLES2RenderContext = function(context) {
	return null;
};
lime_graphics__$OpenGLES3RenderContext_OpenGLES3RenderContext_$Impl_$.fromWebGLRenderContext = function(context) {
	return null;
};
lime_graphics__$OpenGLES3RenderContext_OpenGLES3RenderContext_$Impl_$.fromWebGL2RenderContext = function(context) {
	return null;
};
var lime_graphics__$OpenGLRenderContext_OpenGLRenderContext_$Impl_$ = {};
$hxClasses["lime.graphics._OpenGLRenderContext.OpenGLRenderContext_Impl_"] = lime_graphics__$OpenGLRenderContext_OpenGLRenderContext_$Impl_$;
lime_graphics__$OpenGLRenderContext_OpenGLRenderContext_$Impl_$.__name__ = ["lime","graphics","_OpenGLRenderContext","OpenGLRenderContext_Impl_"];
lime_graphics__$OpenGLRenderContext_OpenGLRenderContext_$Impl_$.fromRenderContext = function(context) {
	return null;
};
var lime_graphics_RenderContext = function() {
};
$hxClasses["lime.graphics.RenderContext"] = lime_graphics_RenderContext;
lime_graphics_RenderContext.__name__ = ["lime","graphics","RenderContext"];
lime_graphics_RenderContext.prototype = {
	__class__: lime_graphics_RenderContext
};
var lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$ = {};
$hxClasses["lime.graphics._WebGL2RenderContext.WebGL2RenderContext_Impl_"] = lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$;
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.__name__ = ["lime","graphics","_WebGL2RenderContext","WebGL2RenderContext_Impl_"];
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.bufferData = function(this1,target,srcData,usage,srcOffset,length) {
	if(srcOffset != null) {
		this1.bufferData(target,srcData,usage,srcOffset,length);
	} else {
		this1.bufferData(target,srcData,usage);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.bufferSubData = function(this1,target,dstByteOffset,srcData,srcOffset,length) {
	if(srcOffset != null) {
		this1.bufferSubData(target,dstByteOffset,srcData,srcOffset,length);
	} else {
		this1.bufferSubData(target,dstByteOffset,srcData);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.compressedTexImage2D = function(this1,target,level,internalformat,width,height,border,srcData,srcOffset,srcLengthOverride) {
	if(srcOffset != null) {
		this1.compressedTexImage2D(target,level,internalformat,width,height,border,srcData,srcOffset,srcLengthOverride);
	} else {
		this1.compressedTexImage2D(target,level,internalformat,width,height,border,srcData);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.compressedTexSubImage2D = function(this1,target,level,xoffset,yoffset,width,height,format,srcData,srcOffset,srcLengthOverride) {
	if(srcOffset != null) {
		this1.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,srcData,srcOffset,srcLengthOverride);
	} else {
		this1.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,srcData);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.getBufferSubData = function(this1,target,srcByteOffset,dstData,srcOffset,length) {
	if(srcOffset != null) {
		this1.getBufferSubData(target,srcByteOffset,dstData,srcOffset,length);
	} else {
		this1.getBufferSubData(target,srcByteOffset,dstData);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.readPixels = function(this1,x,y,width,height,format,type,pixels,dstOffset) {
	if(dstOffset != null) {
		this1.readPixels(x,y,width,height,format,type,pixels,dstOffset);
	} else {
		this1.readPixels(x,y,width,height,format,type,pixels);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.texImage2D = function(this1,target,level,internalformat,width,height,border,format,type,srcData,srcOffset) {
	if(srcOffset != null) {
		this1.texImage2D(target,level,internalformat,width,height,border,format,type,srcData,srcOffset);
	} else if(format != null) {
		this1.texImage2D(target,level,internalformat,width,height,border,format,type,srcData);
	} else {
		this1.texImage2D(target,level,internalformat,width,height,border);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.texSubImage2D = function(this1,target,level,xoffset,yoffset,width,height,format,type,srcData,srcOffset) {
	if(srcOffset != null) {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,srcData,srcOffset);
	} else if(type != null) {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,srcData);
	} else {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniform1fv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform1fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform1fv(location,data);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniform1iv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform1iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform1iv(location,data);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniform2fv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform2fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform2fv(location,data);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniform2iv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform2iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform2iv(location,data);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniform3fv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform3fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform3fv(location,data);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniform3iv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform3iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform3iv(location,data);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniform4fv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform4fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform4fv(location,data);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniform4iv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform4iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform4iv(location,data);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniformMatrix2fv = function(this1,location,transpose,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniformMatrix2fv(location,transpose,data,srcOffset,srcLength);
	} else {
		this1.uniformMatrix2fv(location,transpose,data);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniformMatrix3fv = function(this1,location,transpose,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniformMatrix3fv(location,transpose,data,srcOffset,srcLength);
	} else {
		this1.uniformMatrix3fv(location,transpose,data);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniformMatrix4fv = function(this1,location,transpose,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniformMatrix4fv(location,transpose,data,srcOffset,srcLength);
	} else {
		this1.uniformMatrix4fv(location,transpose,data);
	}
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.fromGL = function(gl) {
	return null;
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.fromRenderContext = function(context) {
	return context.webgl2;
};
lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.toWebGLRenderContext = function(gl) {
	return gl;
};
var lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$ = {};
$hxClasses["lime.graphics._WebGLRenderContext.WebGLRenderContext_Impl_"] = lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$;
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.__name__ = ["lime","graphics","_WebGLRenderContext","WebGLRenderContext_Impl_"];
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.bufferData = function(this1,target,srcData,usage) {
	this1.bufferData(target,srcData,usage);
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.bufferSubData = function(this1,target,offset,srcData) {
	this1.bufferSubData(target,offset,srcData);
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.compressedTexImage2D = function(this1,target,level,internalformat,width,height,border,srcData) {
	this1.compressedTexImage2D(target,level,internalformat,width,height,border,srcData);
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.compressedTexSubImage2D = function(this1,target,level,xoffset,yoffset,width,height,format,srcData) {
	this1.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,srcData);
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.readPixels = function(this1,x,y,width,height,format,type,pixels) {
	this1.readPixels(x,y,width,height,format,type,pixels);
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.texImage2D = function(this1,target,level,internalformat,width,height,border,format,type,srcData) {
	if(format != null) {
		this1.texImage2D(target,level,internalformat,width,height,border,format,type,srcData);
	} else {
		this1.texImage2D(target,level,internalformat,width,height,border);
	}
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.texSubImage2D = function(this1,target,level,xoffset,yoffset,width,height,format,type,srcData) {
	if(type != null) {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,srcData);
	} else {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format);
	}
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.uniformMatrix2fv = function(this1,location,transpose,v) {
	this1.uniformMatrix2fv(location,transpose,v);
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.uniformMatrix3fv = function(this1,location,transpose,v) {
	this1.uniformMatrix3fv(location,transpose,v);
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.uniformMatrix4fv = function(this1,location,transpose,v) {
	this1.uniformMatrix4fv(location,transpose,v);
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.fromWebGL2RenderContext = function(gl) {
	return gl;
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.fromRenderContext = function(context) {
	return context.webgl;
};
lime_graphics__$WebGLRenderContext_WebGLRenderContext_$Impl_$.fromGL = function(gl) {
	return lime_graphics_opengl_GL.context;
};
var lime_graphics_cairo_Cairo = function(surface) {
	var tmp = surface != null;
};
$hxClasses["lime.graphics.cairo.Cairo"] = lime_graphics_cairo_Cairo;
lime_graphics_cairo_Cairo.__name__ = ["lime","graphics","cairo","Cairo"];
lime_graphics_cairo_Cairo.__properties__ = {get_versionString:"get_versionString",get_version:"get_version"};
lime_graphics_cairo_Cairo.get_version = function() {
	return 0;
};
lime_graphics_cairo_Cairo.get_versionString = function() {
	return "";
};
lime_graphics_cairo_Cairo.prototype = {
	arc: function(xc,yc,radius,angle1,angle2) {
	}
	,arcNegative: function(xc,yc,radius,angle1,angle2) {
	}
	,clip: function() {
	}
	,clipExtents: function(x1,y1,x2,y2) {
	}
	,clipPreserve: function() {
	}
	,closePath: function() {
	}
	,copyPage: function() {
	}
	,curveTo: function(x1,y1,x2,y2,x3,y3) {
	}
	,fill: function() {
	}
	,fillExtents: function(x1,y1,x2,y2) {
	}
	,fillPreserve: function() {
	}
	,getOperator: function() {
		return 0;
	}
	,identityMatrix: function() {
	}
	,inClip: function(x,y) {
		return false;
	}
	,inFill: function(x,y) {
		return false;
	}
	,inStroke: function(x,y) {
		return false;
	}
	,lineTo: function(x,y) {
	}
	,mask: function(pattern) {
	}
	,maskSurface: function(surface,x,y) {
	}
	,moveTo: function(x,y) {
	}
	,newPath: function() {
	}
	,paint: function() {
	}
	,paintWithAlpha: function(alpha) {
	}
	,popGroup: function() {
		return null;
	}
	,popGroupToSource: function() {
	}
	,pushGroup: function() {
	}
	,pushGroupWithContent: function(content) {
	}
	,recreate: function(surface) {
	}
	,rectangle: function(x,y,width,height) {
	}
	,relCurveTo: function(dx1,dy1,dx2,dy2,dx3,dy3) {
	}
	,relLineTo: function(dx,dy) {
	}
	,relMoveTo: function(dx,dy) {
	}
	,resetClip: function() {
	}
	,restore: function() {
	}
	,rotate: function(amount) {
	}
	,save: function() {
	}
	,scale: function(x,y) {
	}
	,setFontSize: function(size) {
	}
	,setOperator: function(value) {
		return value;
	}
	,setSourceRGB: function(r,g,b) {
	}
	,setSourceRGBA: function(r,g,b,a) {
	}
	,setSourceSurface: function(surface,x,y) {
	}
	,showGlyphs: function(glyphs) {
	}
	,showPage: function() {
	}
	,showText: function(utf8) {
	}
	,status: function() {
		return 0;
	}
	,stroke: function() {
	}
	,strokeExtents: function(x1,y1,x2,y2) {
	}
	,strokePreserve: function() {
	}
	,textPath: function(utf8) {
	}
	,transform: function(matrix) {
	}
	,translate: function(x,y) {
	}
	,get_antialias: function() {
		return 0;
	}
	,set_antialias: function(value) {
		return value;
	}
	,get_currentPoint: function() {
		return null;
	}
	,get_dash: function() {
		return [];
	}
	,set_dash: function(value) {
		return value;
	}
	,get_dashCount: function() {
		return 0;
	}
	,get_fillRule: function() {
		return 0;
	}
	,set_fillRule: function(value) {
		return value;
	}
	,get_fontFace: function() {
		return 0;
	}
	,set_fontFace: function(value) {
		return value;
	}
	,get_fontOptions: function() {
		return null;
	}
	,set_fontOptions: function(value) {
		return value;
	}
	,get_groupTarget: function() {
		return 0;
	}
	,get_hasCurrentPoint: function() {
		return false;
	}
	,get_lineCap: function() {
		return 0;
	}
	,set_lineCap: function(value) {
		return value;
	}
	,get_lineJoin: function() {
		return 0;
	}
	,set_lineJoin: function(value) {
		return value;
	}
	,get_lineWidth: function() {
		return 0;
	}
	,set_lineWidth: function(value) {
		return value;
	}
	,get_matrix: function() {
		return null;
	}
	,set_matrix: function(value) {
		return value;
	}
	,get_miterLimit: function() {
		return 0;
	}
	,set_miterLimit: function(value) {
		return value;
	}
	,get_operator: function() {
		return 0;
	}
	,set_operator: function(value) {
		return value;
	}
	,get_source: function() {
		return 0;
	}
	,set_source: function(value) {
		return value;
	}
	,get_target: function() {
		return 0;
	}
	,get_tolerance: function() {
		return 0;
	}
	,set_tolerance: function(value) {
		return value;
	}
	,__class__: lime_graphics_cairo_Cairo
	,__properties__: {set_tolerance:"set_tolerance",get_tolerance:"get_tolerance",get_target:"get_target",set_source:"set_source",get_source:"get_source",set_operator:"set_operator",get_operator:"get_operator",set_miterLimit:"set_miterLimit",get_miterLimit:"get_miterLimit",set_matrix:"set_matrix",get_matrix:"get_matrix",set_lineWidth:"set_lineWidth",get_lineWidth:"get_lineWidth",set_lineJoin:"set_lineJoin",get_lineJoin:"get_lineJoin",set_lineCap:"set_lineCap",get_lineCap:"get_lineCap",get_hasCurrentPoint:"get_hasCurrentPoint",get_groupTarget:"get_groupTarget",set_fontOptions:"set_fontOptions",get_fontOptions:"get_fontOptions",set_fontFace:"set_fontFace",get_fontFace:"get_fontFace",set_fillRule:"set_fillRule",get_fillRule:"get_fillRule",get_dashCount:"get_dashCount",set_dash:"set_dash",get_dash:"get_dash",get_currentPoint:"get_currentPoint",set_antialias:"set_antialias",get_antialias:"get_antialias"}
};
var lime_graphics_cairo__$CairoFTFontFace_CairoFTFontFace_$Impl_$ = {};
$hxClasses["lime.graphics.cairo._CairoFTFontFace.CairoFTFontFace_Impl_"] = lime_graphics_cairo__$CairoFTFontFace_CairoFTFontFace_$Impl_$;
lime_graphics_cairo__$CairoFTFontFace_CairoFTFontFace_$Impl_$.__name__ = ["lime","graphics","cairo","_CairoFTFontFace","CairoFTFontFace_Impl_"];
lime_graphics_cairo__$CairoFTFontFace_CairoFTFontFace_$Impl_$._new = function() {
	var this1 = 0;
	return this1;
};
lime_graphics_cairo__$CairoFTFontFace_CairoFTFontFace_$Impl_$.create = function(face,loadFlags) {
	return 0;
};
var lime_graphics_cairo__$CairoFontFace_CairoFontFace_$Impl_$ = {};
$hxClasses["lime.graphics.cairo._CairoFontFace.CairoFontFace_Impl_"] = lime_graphics_cairo__$CairoFontFace_CairoFontFace_$Impl_$;
lime_graphics_cairo__$CairoFontFace_CairoFontFace_$Impl_$.__name__ = ["lime","graphics","cairo","_CairoFontFace","CairoFontFace_Impl_"];
lime_graphics_cairo__$CairoFontFace_CairoFontFace_$Impl_$._new = function() {
	var this1 = null;
	return this1;
};
lime_graphics_cairo__$CairoFontFace_CairoFontFace_$Impl_$.status = function(this1) {
	return 0;
};
var lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$ = {};
$hxClasses["lime.graphics.cairo._CairoFontOptions.CairoFontOptions_Impl_"] = lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$;
lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$.__name__ = ["lime","graphics","cairo","_CairoFontOptions","CairoFontOptions_Impl_"];
lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$.__properties__ = {set_subpixelOrder:"set_subpixelOrder",get_subpixelOrder:"get_subpixelOrder",set_hintStyle:"set_hintStyle",get_hintStyle:"get_hintStyle",set_hintMetrics:"set_hintMetrics",get_hintMetrics:"get_hintMetrics",set_antialias:"set_antialias",get_antialias:"get_antialias"};
lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$._new = function() {
	var this1 = null;
	return this1;
};
lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$.get_antialias = function(this1) {
	return 0;
};
lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$.set_antialias = function(this1,value) {
	return value;
};
lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$.get_hintMetrics = function(this1) {
	return 0;
};
lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$.set_hintMetrics = function(this1,value) {
	return value;
};
lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$.get_hintStyle = function(this1) {
	return 0;
};
lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$.set_hintStyle = function(this1,value) {
	return value;
};
lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$.get_subpixelOrder = function(this1) {
	return 0;
};
lime_graphics_cairo__$CairoFontOptions_CairoFontOptions_$Impl_$.set_subpixelOrder = function(this1,value) {
	return value;
};
var lime_graphics_cairo_CairoGlyph = function(index,x,y) {
	if(y == null) {
		y = 0;
	}
	if(x == null) {
		x = 0;
	}
	this.index = index;
	this.x = x;
	this.y = y;
};
$hxClasses["lime.graphics.cairo.CairoGlyph"] = lime_graphics_cairo_CairoGlyph;
lime_graphics_cairo_CairoGlyph.__name__ = ["lime","graphics","cairo","CairoGlyph"];
lime_graphics_cairo_CairoGlyph.prototype = {
	__class__: lime_graphics_cairo_CairoGlyph
};
var lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$ = {};
$hxClasses["lime.graphics.cairo._CairoImageSurface.CairoImageSurface_Impl_"] = lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$;
lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$.__name__ = ["lime","graphics","cairo","_CairoImageSurface","CairoImageSurface_Impl_"];
lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$.__properties__ = {get_width:"get_width",get_stride:"get_stride",get_height:"get_height",get_format:"get_format",get_data:"get_data"};
lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$._new = function(format,width,height) {
	var this1 = 0;
	return this1;
};
lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$.create = function(data,format,width,height,stride) {
	return 0;
};
lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$.fromImage = function(image) {
	return null;
};
lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$.get_data = function(this1) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat(0);
};
lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$.get_format = function(this1) {
	return 0;
};
lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$.get_height = function(this1) {
	return 0;
};
lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$.get_stride = function(this1) {
	return 0;
};
lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$.get_width = function(this1) {
	return 0;
};
var lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$ = {};
$hxClasses["lime.graphics.cairo._CairoPattern.CairoPattern_Impl_"] = lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$;
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.__name__ = ["lime","graphics","cairo","_CairoPattern","CairoPattern_Impl_"];
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.__properties__ = {set_matrix:"set_matrix",get_matrix:"get_matrix",set_filter:"set_filter",get_filter:"get_filter",set_extend:"set_extend",get_extend:"get_extend",get_colorStopCount:"get_colorStopCount"};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$._new = function(handle) {
	var this1 = handle;
	return this1;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.addColorStopRGB = function(this1,offset,r,g,b) {
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.addColorStopRGBA = function(this1,offset,r,g,b,a) {
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.createForSurface = function(surface) {
	return 0;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.createLinear = function(x0,y0,x1,y1) {
	return 0;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.createRadial = function(cx0,cy0,radius0,cx1,cy1,radius1) {
	return 0;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.createRGB = function(r,g,b) {
	return 0;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.createRGBA = function(r,g,b,a) {
	return 0;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.get_colorStopCount = function(this1) {
	return 0;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.get_extend = function(this1) {
	return 0;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.set_extend = function(this1,value) {
	return value;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.get_filter = function(this1) {
	return 0;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.set_filter = function(this1,value) {
	return value;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.get_matrix = function(this1) {
	return null;
};
lime_graphics_cairo__$CairoPattern_CairoPattern_$Impl_$.set_matrix = function(this1,value) {
	return value;
};
var lime_graphics_cairo__$CairoSurface_CairoSurface_$Impl_$ = {};
$hxClasses["lime.graphics.cairo._CairoSurface.CairoSurface_Impl_"] = lime_graphics_cairo__$CairoSurface_CairoSurface_$Impl_$;
lime_graphics_cairo__$CairoSurface_CairoSurface_$Impl_$.__name__ = ["lime","graphics","cairo","_CairoSurface","CairoSurface_Impl_"];
lime_graphics_cairo__$CairoSurface_CairoSurface_$Impl_$.flush = function(this1) {
};
var lime_graphics_opengl_GL = function() { };
$hxClasses["lime.graphics.opengl.GL"] = lime_graphics_opengl_GL;
lime_graphics_opengl_GL.__name__ = ["lime","graphics","opengl","GL"];
lime_graphics_opengl_GL.activeTexture = function(texture) {
	lime_graphics_opengl_GL.context.activeTexture(texture);
};
lime_graphics_opengl_GL.attachShader = function(program,shader) {
	lime_graphics_opengl_GL.context.attachShader(program,shader);
};
lime_graphics_opengl_GL.beginQuery = function(target,query) {
	lime_graphics_opengl_GL.context.beginQuery(target,query);
};
lime_graphics_opengl_GL.beginTransformFeedback = function(primitiveNode) {
	lime_graphics_opengl_GL.context.beginTransformFeedback(primitiveNode);
};
lime_graphics_opengl_GL.bindAttribLocation = function(program,index,name) {
	lime_graphics_opengl_GL.context.bindAttribLocation(program,index,name);
};
lime_graphics_opengl_GL.bindBuffer = function(target,buffer) {
	lime_graphics_opengl_GL.context.bindBuffer(target,buffer);
};
lime_graphics_opengl_GL.bindBufferBase = function(target,index,buffer) {
	lime_graphics_opengl_GL.context.bindBufferBase(target,index,buffer);
};
lime_graphics_opengl_GL.bindBufferRange = function(target,index,buffer,offset,size) {
	lime_graphics_opengl_GL.context.bindBufferRange(target,index,buffer,offset,lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat(size));
};
lime_graphics_opengl_GL.bindFramebuffer = function(target,framebuffer) {
	lime_graphics_opengl_GL.context.bindFramebuffer(target,framebuffer);
};
lime_graphics_opengl_GL.bindRenderbuffer = function(target,renderbuffer) {
	lime_graphics_opengl_GL.context.bindRenderbuffer(target,renderbuffer);
};
lime_graphics_opengl_GL.bindSampler = function(unit,sampler) {
	lime_graphics_opengl_GL.context.bindSampler(unit,sampler);
};
lime_graphics_opengl_GL.bindTexture = function(target,texture) {
	lime_graphics_opengl_GL.context.bindTexture(target,texture);
};
lime_graphics_opengl_GL.bindTransformFeedback = function(target,transformFeedback) {
	lime_graphics_opengl_GL.context.bindTransformFeedback(target,transformFeedback);
};
lime_graphics_opengl_GL.bindVertexArray = function(vertexArray) {
	lime_graphics_opengl_GL.context.bindVertexArray(vertexArray);
};
lime_graphics_opengl_GL.blitFramebuffer = function(srcX0,srcY0,srcX1,srcY1,dstX0,dstY0,dstX1,dstY1,mask,filter) {
	lime_graphics_opengl_GL.context.blitFramebuffer(srcX0,srcY0,srcX1,srcY1,dstX0,dstY0,dstX1,dstY1,mask,filter);
};
lime_graphics_opengl_GL.blendColor = function(red,green,blue,alpha) {
	lime_graphics_opengl_GL.context.blendColor(red,green,blue,alpha);
};
lime_graphics_opengl_GL.blendEquation = function(mode) {
	lime_graphics_opengl_GL.context.blendEquation(mode);
};
lime_graphics_opengl_GL.blendEquationSeparate = function(modeRGB,modeAlpha) {
	lime_graphics_opengl_GL.context.blendEquationSeparate(modeRGB,modeAlpha);
};
lime_graphics_opengl_GL.blendFunc = function(sfactor,dfactor) {
	lime_graphics_opengl_GL.context.blendFunc(sfactor,dfactor);
};
lime_graphics_opengl_GL.blendFuncSeparate = function(srcRGB,dstRGB,srcAlpha,dstAlpha) {
	lime_graphics_opengl_GL.context.blendFuncSeparate(srcRGB,dstRGB,srcAlpha,dstAlpha);
};
lime_graphics_opengl_GL.bufferDataWEBGL = function(target,srcData,usage,srcOffset,length) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.bufferData(target,srcData,usage,srcOffset,length);
	} else {
		this1.bufferData(target,srcData,usage);
	}
};
lime_graphics_opengl_GL.bufferSubDataWEBGL = function(target,dstByteOffset,srcData,srcOffset,length) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.bufferSubData(target,dstByteOffset,srcData,srcOffset,length);
	} else {
		this1.bufferSubData(target,dstByteOffset,srcData);
	}
};
lime_graphics_opengl_GL.checkFramebufferStatus = function(target) {
	return lime_graphics_opengl_GL.context.checkFramebufferStatus(target);
};
lime_graphics_opengl_GL.clear = function(mask) {
	lime_graphics_opengl_GL.context.clear(mask);
};
lime_graphics_opengl_GL.clearBufferfi = function(buffer,drawbuffer,depth,stencil) {
	lime_graphics_opengl_GL.context.clearBufferfi(buffer,drawbuffer,depth,stencil);
};
lime_graphics_opengl_GL.clearBufferfvWEBGL = function(buffer,drawbuffer,values,srcOffset) {
	lime_graphics_opengl_GL.context.clearBufferfv(buffer,drawbuffer,values,srcOffset);
};
lime_graphics_opengl_GL.clearBufferivWEBGL = function(buffer,drawbuffer,values,srcOffset) {
	lime_graphics_opengl_GL.context.clearBufferiv(buffer,drawbuffer,values,srcOffset);
};
lime_graphics_opengl_GL.clearBufferuivWEBGL = function(buffer,drawbuffer,values,srcOffset) {
	lime_graphics_opengl_GL.context.clearBufferuiv(buffer,drawbuffer,values,srcOffset);
};
lime_graphics_opengl_GL.clearColor = function(red,green,blue,alpha) {
	lime_graphics_opengl_GL.context.clearColor(red,green,blue,alpha);
};
lime_graphics_opengl_GL.clearDepth = function(depth) {
	lime_graphics_opengl_GL.context.clearDepth(depth);
};
lime_graphics_opengl_GL.clearStencil = function(s) {
	lime_graphics_opengl_GL.context.clearStencil(s);
};
lime_graphics_opengl_GL.clientWaitSync = function(sync,flags,timeout) {
	return lime_graphics_opengl_GL.context.clientWaitSync(sync,flags,timeout);
};
lime_graphics_opengl_GL.colorMask = function(red,green,blue,alpha) {
	lime_graphics_opengl_GL.context.colorMask(red,green,blue,alpha);
};
lime_graphics_opengl_GL.compileShader = function(shader) {
	lime_graphics_opengl_GL.context.compileShader(shader);
};
lime_graphics_opengl_GL.compressedTexImage2DWEBGL = function(target,level,internalformat,width,height,border,srcData,srcOffset,srcLengthOverride) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.compressedTexImage2D(target,level,internalformat,width,height,border,srcData,srcOffset,srcLengthOverride);
	} else {
		this1.compressedTexImage2D(target,level,internalformat,width,height,border,srcData);
	}
};
lime_graphics_opengl_GL.compressedTexImage3DWEBGL = function(target,level,internalformat,width,height,depth,border,srcData,srcOffset,srcLengthOverride) {
	lime_graphics_opengl_GL.context.compressedTexImage3D(target,level,internalformat,width,height,depth,border,srcData,srcOffset,srcLengthOverride);
};
lime_graphics_opengl_GL.compressedTexSubImage2DWEBGL = function(target,level,xoffset,yoffset,width,height,format,srcData,srcOffset,srcLengthOverride) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,srcData,srcOffset,srcLengthOverride);
	} else {
		this1.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,srcData);
	}
};
lime_graphics_opengl_GL.compressedTexSubImage3DWEBGL = function(target,level,xoffset,yoffset,zoffset,width,height,depth,format,srcData,srcOffset,srcLengthOverride) {
	lime_graphics_opengl_GL.context.compressedTexSubImage3D(target,level,xoffset,yoffset,zoffset,width,height,depth,format,srcData,srcOffset,srcLengthOverride);
};
lime_graphics_opengl_GL.copyTexImage2D = function(target,level,internalformat,x,y,width,height,border) {
	lime_graphics_opengl_GL.context.copyTexImage2D(target,level,internalformat,x,y,width,height,border);
};
lime_graphics_opengl_GL.copyTexSubImage2D = function(target,level,xoffset,yoffset,x,y,width,height) {
	lime_graphics_opengl_GL.context.copyTexSubImage2D(target,level,xoffset,yoffset,x,y,width,height);
};
lime_graphics_opengl_GL.copyTexSubImage3D = function(target,level,xoffset,yoffset,zoffset,x,y,width,height) {
	lime_graphics_opengl_GL.context.copyTexSubImage3D(target,level,xoffset,yoffset,zoffset,x,y,width,height);
};
lime_graphics_opengl_GL.createBuffer = function() {
	return lime_graphics_opengl_GL.context.createBuffer();
};
lime_graphics_opengl_GL.createFramebuffer = function() {
	return lime_graphics_opengl_GL.context.createFramebuffer();
};
lime_graphics_opengl_GL.createProgram = function() {
	return lime_graphics_opengl_GL.context.createProgram();
};
lime_graphics_opengl_GL.createQuery = function() {
	return lime_graphics_opengl_GL.context.createQuery();
};
lime_graphics_opengl_GL.createRenderbuffer = function() {
	return lime_graphics_opengl_GL.context.createRenderbuffer();
};
lime_graphics_opengl_GL.createSampler = function() {
	return lime_graphics_opengl_GL.context.createSampler();
};
lime_graphics_opengl_GL.createShader = function(type) {
	return lime_graphics_opengl_GL.context.createShader(type);
};
lime_graphics_opengl_GL.createTexture = function() {
	return lime_graphics_opengl_GL.context.createTexture();
};
lime_graphics_opengl_GL.createTransformFeedback = function() {
	return lime_graphics_opengl_GL.context.createTransformFeedback();
};
lime_graphics_opengl_GL.createVertexArray = function() {
	return lime_graphics_opengl_GL.context.createVertexArray();
};
lime_graphics_opengl_GL.cullFace = function(mode) {
	lime_graphics_opengl_GL.context.cullFace(mode);
};
lime_graphics_opengl_GL.deleteBuffer = function(buffer) {
	lime_graphics_opengl_GL.context.deleteBuffer(buffer);
};
lime_graphics_opengl_GL.deleteFramebuffer = function(framebuffer) {
	lime_graphics_opengl_GL.context.deleteFramebuffer(framebuffer);
};
lime_graphics_opengl_GL.deleteProgram = function(program) {
	lime_graphics_opengl_GL.context.deleteProgram(program);
};
lime_graphics_opengl_GL.deleteQuery = function(query) {
	lime_graphics_opengl_GL.context.deleteQuery(query);
};
lime_graphics_opengl_GL.deleteRenderbuffer = function(renderbuffer) {
	lime_graphics_opengl_GL.context.deleteRenderbuffer(renderbuffer);
};
lime_graphics_opengl_GL.deleteSampler = function(sampler) {
	lime_graphics_opengl_GL.context.deleteSampler(sampler);
};
lime_graphics_opengl_GL.deleteShader = function(shader) {
	lime_graphics_opengl_GL.context.deleteShader(shader);
};
lime_graphics_opengl_GL.deleteSync = function(sync) {
	lime_graphics_opengl_GL.context.deleteSync(sync);
};
lime_graphics_opengl_GL.deleteTexture = function(texture) {
	lime_graphics_opengl_GL.context.deleteTexture(texture);
};
lime_graphics_opengl_GL.deleteTransformFeedback = function(transformFeedback) {
	lime_graphics_opengl_GL.context.deleteTransformFeedback(transformFeedback);
};
lime_graphics_opengl_GL.deleteVertexArray = function(vertexArray) {
	lime_graphics_opengl_GL.context.deleteVertexArray(vertexArray);
};
lime_graphics_opengl_GL.depthFunc = function(func) {
	lime_graphics_opengl_GL.context.depthFunc(func);
};
lime_graphics_opengl_GL.depthMask = function(flag) {
	lime_graphics_opengl_GL.context.depthMask(flag);
};
lime_graphics_opengl_GL.depthRange = function(zNear,zFar) {
	lime_graphics_opengl_GL.context.depthRange(zNear,zFar);
};
lime_graphics_opengl_GL.detachShader = function(program,shader) {
	lime_graphics_opengl_GL.context.detachShader(program,shader);
};
lime_graphics_opengl_GL.disable = function(cap) {
	lime_graphics_opengl_GL.context.disable(cap);
};
lime_graphics_opengl_GL.disableVertexAttribArray = function(index) {
	lime_graphics_opengl_GL.context.disableVertexAttribArray(index);
};
lime_graphics_opengl_GL.drawArrays = function(mode,first,count) {
	lime_graphics_opengl_GL.context.drawArrays(mode,first,count);
};
lime_graphics_opengl_GL.drawArraysInstanced = function(mode,first,count,instanceCount) {
	lime_graphics_opengl_GL.context.drawArraysInstanced(mode,first,count,instanceCount);
};
lime_graphics_opengl_GL.drawBuffers = function(buffers) {
	lime_graphics_opengl_GL.context.drawBuffers(buffers);
};
lime_graphics_opengl_GL.drawElements = function(mode,count,type,offset) {
	lime_graphics_opengl_GL.context.drawElements(mode,count,type,offset);
};
lime_graphics_opengl_GL.drawElementsInstanced = function(mode,count,type,offset,instanceCount) {
	lime_graphics_opengl_GL.context.drawElementsInstanced(mode,count,type,offset,instanceCount);
};
lime_graphics_opengl_GL.drawRangeElements = function(mode,start,end,count,type,offset) {
	lime_graphics_opengl_GL.context.drawRangeElements(mode,start,end,count,type,offset);
};
lime_graphics_opengl_GL.enable = function(cap) {
	lime_graphics_opengl_GL.context.enable(cap);
};
lime_graphics_opengl_GL.enableVertexAttribArray = function(index) {
	lime_graphics_opengl_GL.context.enableVertexAttribArray(index);
};
lime_graphics_opengl_GL.endQuery = function(target) {
	lime_graphics_opengl_GL.context.endQuery(target);
};
lime_graphics_opengl_GL.endTransformFeedback = function() {
	lime_graphics_opengl_GL.context.endTransformFeedback();
};
lime_graphics_opengl_GL.fenceSync = function(condition,flags) {
	return lime_graphics_opengl_GL.context.fenceSync(condition,flags);
};
lime_graphics_opengl_GL.finish = function() {
	lime_graphics_opengl_GL.context.finish();
};
lime_graphics_opengl_GL.flush = function() {
	lime_graphics_opengl_GL.context.flush();
};
lime_graphics_opengl_GL.framebufferRenderbuffer = function(target,attachment,renderbuffertarget,renderbuffer) {
	lime_graphics_opengl_GL.context.framebufferRenderbuffer(target,attachment,renderbuffertarget,renderbuffer);
};
lime_graphics_opengl_GL.framebufferTexture2D = function(target,attachment,textarget,texture,level) {
	lime_graphics_opengl_GL.context.framebufferTexture2D(target,attachment,textarget,texture,level);
};
lime_graphics_opengl_GL.framebufferTextureLayer = function(target,attachment,texture,level,layer) {
	lime_graphics_opengl_GL.context.framebufferTextureLayer(target,attachment,texture,level,layer);
};
lime_graphics_opengl_GL.frontFace = function(mode) {
	lime_graphics_opengl_GL.context.frontFace(mode);
};
lime_graphics_opengl_GL.generateMipmap = function(target) {
	lime_graphics_opengl_GL.context.generateMipmap(target);
};
lime_graphics_opengl_GL.getActiveAttrib = function(program,index) {
	return lime_graphics_opengl_GL.context.getActiveAttrib(program,index);
};
lime_graphics_opengl_GL.getActiveUniform = function(program,index) {
	return lime_graphics_opengl_GL.context.getActiveUniform(program,index);
};
lime_graphics_opengl_GL.getActiveUniformBlockName = function(program,uniformBlockIndex) {
	return lime_graphics_opengl_GL.context.getActiveUniformBlockName(program,uniformBlockIndex);
};
lime_graphics_opengl_GL.getActiveUniformBlockParameter = function(program,uniformBlockIndex,pname) {
	return lime_graphics_opengl_GL.context.getActiveUniformBlockParameter(program,uniformBlockIndex,pname);
};
lime_graphics_opengl_GL.getActiveUniforms = function(program,uniformIndices,pname) {
	return lime_graphics_opengl_GL.context.getActiveUniforms(program,uniformIndices,pname);
};
lime_graphics_opengl_GL.getAttachedShaders = function(program) {
	return lime_graphics_opengl_GL.context.getAttachedShaders(program);
};
lime_graphics_opengl_GL.getAttribLocation = function(program,name) {
	return lime_graphics_opengl_GL.context.getAttribLocation(program,name);
};
lime_graphics_opengl_GL.getBufferParameter = function(target,pname) {
	return lime_graphics_opengl_GL.context.getBufferParameter(target,pname);
};
lime_graphics_opengl_GL.getBufferSubDataWEBGL = function(target,srcByteOffset,dstData,srcOffset,length) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.getBufferSubData(target,srcByteOffset,dstData,srcOffset,length);
	} else {
		this1.getBufferSubData(target,srcByteOffset,dstData);
	}
};
lime_graphics_opengl_GL.getContextAttributes = function() {
	return lime_graphics_opengl_GL.context.getContextAttributes();
};
lime_graphics_opengl_GL.getError = function() {
	return lime_graphics_opengl_GL.context.getError();
};
lime_graphics_opengl_GL.getExtension = function(name) {
	return lime_graphics_opengl_GL.context.getExtension(name);
};
lime_graphics_opengl_GL.getFragDataLocation = function(program,name) {
	return lime_graphics_opengl_GL.context.getFragDataLocation(program,name);
};
lime_graphics_opengl_GL.getFramebufferAttachmentParameter = function(target,attachment,pname) {
	return lime_graphics_opengl_GL.context.getFramebufferAttachmentParameter(target,attachment,pname);
};
lime_graphics_opengl_GL.getIndexedParameter = function(target,index) {
	return lime_graphics_opengl_GL.context.getIndexedParameter(target,index);
};
lime_graphics_opengl_GL.getInternalformatParameter = function(target,internalformat,pname) {
	return lime_graphics_opengl_GL.context.getInternalformatParameter(target,internalformat,pname);
};
lime_graphics_opengl_GL.getParameter = function(pname) {
	return lime_graphics_opengl_GL.context.getParameter(pname);
};
lime_graphics_opengl_GL.getProgramInfoLog = function(program) {
	return lime_graphics_opengl_GL.context.getProgramInfoLog(program);
};
lime_graphics_opengl_GL.getProgramParameter = function(program,pname) {
	return lime_graphics_opengl_GL.context.getProgramParameter(program,pname);
};
lime_graphics_opengl_GL.getQuery = function(target,pname) {
	return lime_graphics_opengl_GL.context.getQuery(target,pname);
};
lime_graphics_opengl_GL.getQueryParameter = function(query,pname) {
	return lime_graphics_opengl_GL.context.getQueryParameter(query,pname);
};
lime_graphics_opengl_GL.getRenderbufferParameter = function(target,pname) {
	return lime_graphics_opengl_GL.context.getRenderbufferParameter(target,pname);
};
lime_graphics_opengl_GL.getSamplerParameter = function(sampler,pname) {
	return lime_graphics_opengl_GL.context.getSamplerParameter(sampler,pname);
};
lime_graphics_opengl_GL.getShaderInfoLog = function(shader) {
	return lime_graphics_opengl_GL.context.getShaderInfoLog(shader);
};
lime_graphics_opengl_GL.getShaderParameter = function(shader,pname) {
	return lime_graphics_opengl_GL.context.getShaderParameter(shader,pname);
};
lime_graphics_opengl_GL.getShaderPrecisionFormat = function(shadertype,precisiontype) {
	return lime_graphics_opengl_GL.context.getShaderPrecisionFormat(shadertype,precisiontype);
};
lime_graphics_opengl_GL.getShaderSource = function(shader) {
	return lime_graphics_opengl_GL.context.getShaderSource(shader);
};
lime_graphics_opengl_GL.getSupportedExtensions = function() {
	return lime_graphics_opengl_GL.context.getSupportedExtensions();
};
lime_graphics_opengl_GL.getSyncParameter = function(sync,pname) {
	return lime_graphics_opengl_GL.context.getSyncParameter(sync,pname);
};
lime_graphics_opengl_GL.getTexParameter = function(target,pname) {
	return lime_graphics_opengl_GL.context.getTexParameter(target,pname);
};
lime_graphics_opengl_GL.getTransformFeedbackVarying = function(program,index) {
	return lime_graphics_opengl_GL.context.getTransformFeedbackVarying(program,index);
};
lime_graphics_opengl_GL.getUniform = function(program,location) {
	return lime_graphics_opengl_GL.context.getUniform(program,location);
};
lime_graphics_opengl_GL.getUniformBlockIndex = function(program,uniformBlockName) {
	return lime_graphics_opengl_GL.context.getUniformBlockIndex(program,uniformBlockName);
};
lime_graphics_opengl_GL.getUniformIndices = function(program,uniformNames) {
	return lime_graphics_opengl_GL.context.getUniformIndices(program,uniformNames);
};
lime_graphics_opengl_GL.getUniformLocation = function(program,name) {
	return lime_graphics_opengl_GL.context.getUniformLocation(program,name);
};
lime_graphics_opengl_GL.getVertexAttrib = function(index,pname) {
	return lime_graphics_opengl_GL.context.getVertexAttrib(index,pname);
};
lime_graphics_opengl_GL.getVertexAttribOffset = function(index,pname) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat(lime_graphics_opengl_GL.context.getVertexAttribOffset(index,pname));
};
lime_graphics_opengl_GL.hint = function(target,mode) {
	lime_graphics_opengl_GL.context.hint(target,mode);
};
lime_graphics_opengl_GL.invalidateFramebuffer = function(target,attachments) {
	lime_graphics_opengl_GL.context.invalidateFramebuffer(target,attachments);
};
lime_graphics_opengl_GL.invalidateSubFramebuffer = function(target,attachments,x,y,width,height) {
	lime_graphics_opengl_GL.context.invalidateSubFramebuffer(target,attachments,x,y,width,height);
};
lime_graphics_opengl_GL.isBuffer = function(buffer) {
	return lime_graphics_opengl_GL.context.isBuffer(buffer);
};
lime_graphics_opengl_GL.isContextLost = function() {
	return lime_graphics_opengl_GL.context.isContextLost();
};
lime_graphics_opengl_GL.isEnabled = function(cap) {
	return lime_graphics_opengl_GL.context.isEnabled(cap);
};
lime_graphics_opengl_GL.isFramebuffer = function(framebuffer) {
	return lime_graphics_opengl_GL.context.isFramebuffer(framebuffer);
};
lime_graphics_opengl_GL.isProgram = function(program) {
	return lime_graphics_opengl_GL.context.isProgram(program);
};
lime_graphics_opengl_GL.isQuery = function(query) {
	return lime_graphics_opengl_GL.context.isQuery(query);
};
lime_graphics_opengl_GL.isRenderbuffer = function(renderbuffer) {
	return lime_graphics_opengl_GL.context.isRenderbuffer(renderbuffer);
};
lime_graphics_opengl_GL.isSampler = function(sampler) {
	return lime_graphics_opengl_GL.context.isSampler(sampler);
};
lime_graphics_opengl_GL.isShader = function(shader) {
	return lime_graphics_opengl_GL.context.isShader(shader);
};
lime_graphics_opengl_GL.isSync = function(sync) {
	return lime_graphics_opengl_GL.context.isSync(sync);
};
lime_graphics_opengl_GL.isTexture = function(texture) {
	return lime_graphics_opengl_GL.context.isTexture(texture);
};
lime_graphics_opengl_GL.isTransformFeedback = function(transformFeedback) {
	return lime_graphics_opengl_GL.context.isTransformFeedback(transformFeedback);
};
lime_graphics_opengl_GL.isVertexArray = function(vertexArray) {
	return lime_graphics_opengl_GL.context.isVertexArray(vertexArray);
};
lime_graphics_opengl_GL.lineWidth = function(width) {
	lime_graphics_opengl_GL.context.lineWidth(width);
};
lime_graphics_opengl_GL.linkProgram = function(program) {
	lime_graphics_opengl_GL.context.linkProgram(program);
};
lime_graphics_opengl_GL.pauseTransformFeedback = function() {
	lime_graphics_opengl_GL.context.pauseTransformFeedback();
};
lime_graphics_opengl_GL.pixelStorei = function(pname,param) {
	lime_graphics_opengl_GL.context.pixelStorei(pname,param);
};
lime_graphics_opengl_GL.polygonOffset = function(factor,units) {
	lime_graphics_opengl_GL.context.polygonOffset(factor,units);
};
lime_graphics_opengl_GL.readBuffer = function(src) {
	lime_graphics_opengl_GL.context.readBuffer(src);
};
lime_graphics_opengl_GL.readPixelsWEBGL = function(x,y,width,height,format,type,pixels,dstOffset) {
	var this1 = lime_graphics_opengl_GL.context;
	if(dstOffset != null) {
		this1.readPixels(x,y,width,height,format,type,pixels,dstOffset);
	} else {
		this1.readPixels(x,y,width,height,format,type,pixels);
	}
};
lime_graphics_opengl_GL.renderbufferStorage = function(target,internalformat,width,height) {
	lime_graphics_opengl_GL.context.renderbufferStorage(target,internalformat,width,height);
};
lime_graphics_opengl_GL.renderbufferStorageMultisample = function(target,samples,internalformat,width,height) {
	lime_graphics_opengl_GL.context.renderbufferStorageMultisample(target,samples,internalformat,width,height);
};
lime_graphics_opengl_GL.resumeTransformFeedback = function() {
	lime_graphics_opengl_GL.context.resumeTransformFeedback();
};
lime_graphics_opengl_GL.sampleCoverage = function(value,invert) {
	lime_graphics_opengl_GL.context.sampleCoverage(value,invert);
};
lime_graphics_opengl_GL.samplerParameterf = function(sampler,pname,param) {
	lime_graphics_opengl_GL.context.samplerParameterf(sampler,pname,param);
};
lime_graphics_opengl_GL.samplerParameteri = function(sampler,pname,param) {
	lime_graphics_opengl_GL.context.samplerParameteri(sampler,pname,param);
};
lime_graphics_opengl_GL.scissor = function(x,y,width,height) {
	lime_graphics_opengl_GL.context.scissor(x,y,width,height);
};
lime_graphics_opengl_GL.shaderSource = function(shader,source) {
	lime_graphics_opengl_GL.context.shaderSource(shader,source);
};
lime_graphics_opengl_GL.stencilFunc = function(func,ref,mask) {
	lime_graphics_opengl_GL.context.stencilFunc(func,ref,mask);
};
lime_graphics_opengl_GL.stencilFuncSeparate = function(face,func,ref,mask) {
	lime_graphics_opengl_GL.context.stencilFuncSeparate(face,func,ref,mask);
};
lime_graphics_opengl_GL.stencilMask = function(mask) {
	lime_graphics_opengl_GL.context.stencilMask(mask);
};
lime_graphics_opengl_GL.stencilMaskSeparate = function(face,mask) {
	lime_graphics_opengl_GL.context.stencilMaskSeparate(face,mask);
};
lime_graphics_opengl_GL.stencilOp = function(fail,zfail,zpass) {
	lime_graphics_opengl_GL.context.stencilOp(fail,zfail,zpass);
};
lime_graphics_opengl_GL.stencilOpSeparate = function(face,fail,zfail,zpass) {
	lime_graphics_opengl_GL.context.stencilOpSeparate(face,fail,zfail,zpass);
};
lime_graphics_opengl_GL.texImage2DWEBGL = function(target,level,internalformat,width,height,border,format,type,srcData,srcOffset) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.texImage2D(target,level,internalformat,width,height,border,format,type,srcData,srcOffset);
	} else if(format != null) {
		this1.texImage2D(target,level,internalformat,width,height,border,format,type,srcData);
	} else {
		this1.texImage2D(target,level,internalformat,width,height,border);
	}
};
lime_graphics_opengl_GL.texImage3DWEBGL = function(target,level,internalformat,width,height,depth,border,format,type,srcData,srcOffset) {
	lime_graphics_opengl_GL.context.texImage3D(target,level,internalformat,width,height,depth,border,format,type,srcData,srcOffset);
};
lime_graphics_opengl_GL.texStorage2D = function(target,level,internalformat,width,height) {
	lime_graphics_opengl_GL.context.texStorage2D(target,level,internalformat,width,height);
};
lime_graphics_opengl_GL.texStorage3D = function(target,level,internalformat,width,height,depth) {
	lime_graphics_opengl_GL.context.texStorage3D(target,level,internalformat,width,height,depth);
};
lime_graphics_opengl_GL.texParameterf = function(target,pname,param) {
	lime_graphics_opengl_GL.context.texParameterf(target,pname,param);
};
lime_graphics_opengl_GL.texParameteri = function(target,pname,param) {
	lime_graphics_opengl_GL.context.texParameteri(target,pname,param);
};
lime_graphics_opengl_GL.texSubImage2DWEBGL = function(target,level,xoffset,yoffset,width,height,format,type,srcData,srcOffset) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,srcData,srcOffset);
	} else if(type != null) {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,srcData);
	} else {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format);
	}
};
lime_graphics_opengl_GL.texSubImage3DWEBGL = function(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,source,srcOffset) {
	lime_graphics_opengl_GL.context.texSubImage3D(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,source,srcOffset);
};
lime_graphics_opengl_GL.transformFeedbackVaryings = function(program,varyings,bufferMode) {
	lime_graphics_opengl_GL.context.transformFeedbackVaryings(program,varyings,bufferMode);
};
lime_graphics_opengl_GL.uniform1f = function(location,v0) {
	lime_graphics_opengl_GL.context.uniform1f(location,v0);
};
lime_graphics_opengl_GL.uniform1fvWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform1fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform1fv(location,data);
	}
};
lime_graphics_opengl_GL.uniform1i = function(location,v0) {
	lime_graphics_opengl_GL.context.uniform1i(location,v0);
};
lime_graphics_opengl_GL.uniform1ivWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform1iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform1iv(location,data);
	}
};
lime_graphics_opengl_GL.uniform1ui = function(location,v0) {
	lime_graphics_opengl_GL.context.uniform1ui(location,v0);
};
lime_graphics_opengl_GL.uniform1uivWEBGL = function(location,data,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniform1uiv(location,data,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniform2f = function(location,v0,v1) {
	lime_graphics_opengl_GL.context.uniform2f(location,v0,v1);
};
lime_graphics_opengl_GL.uniform2fvWEBGL = function(location,data,srcOffset,srcLength) {
	lime_graphics__$WebGL2RenderContext_WebGL2RenderContext_$Impl_$.uniform2fv(lime_graphics_opengl_GL.context,location,data,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniform2i = function(location,x,y) {
	lime_graphics_opengl_GL.context.uniform2i(location,x,y);
};
lime_graphics_opengl_GL.uniform2ivWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform2iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform2iv(location,data);
	}
};
lime_graphics_opengl_GL.uniform2ui = function(location,x,y) {
	lime_graphics_opengl_GL.context.uniform2ui(location,x,y);
};
lime_graphics_opengl_GL.uniform2uivWEBGL = function(location,data,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniform2uiv(location,data,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniform3f = function(location,v0,v1,v2) {
	lime_graphics_opengl_GL.context.uniform3f(location,v0,v1,v2);
};
lime_graphics_opengl_GL.uniform3fvWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform3fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform3fv(location,data);
	}
};
lime_graphics_opengl_GL.uniform3i = function(location,v0,v1,v2) {
	lime_graphics_opengl_GL.context.uniform3i(location,v0,v1,v2);
};
lime_graphics_opengl_GL.uniform3ivWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform3iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform3iv(location,data);
	}
};
lime_graphics_opengl_GL.uniform3ui = function(location,v0,v1,v2) {
	lime_graphics_opengl_GL.context.uniform3ui(location,v0,v1,v2);
};
lime_graphics_opengl_GL.uniform3uivWEBGL = function(location,data,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniform3uiv(location,data,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniform4f = function(location,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.uniform4f(location,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.uniform4fvWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform4fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform4fv(location,data);
	}
};
lime_graphics_opengl_GL.uniform4i = function(location,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.uniform4i(location,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.uniform4ivWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform4iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform4iv(location,data);
	}
};
lime_graphics_opengl_GL.uniform4ui = function(location,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.uniform4ui(location,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.uniform4uivWEBGL = function(location,data,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniform4uiv(location,data,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformBlockBinding = function(program,uniformBlockIndex,uniformBlockBinding) {
	lime_graphics_opengl_GL.context.uniformBlockBinding(program,uniformBlockIndex,uniformBlockBinding);
};
lime_graphics_opengl_GL.uniformMatrix2fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniformMatrix2fv(location,transpose,v,srcOffset,srcLength);
	} else {
		this1.uniformMatrix2fv(location,transpose,v);
	}
};
lime_graphics_opengl_GL.uniformMatrix2x3fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix2x3fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformMatrix2x4fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix2x4fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformMatrix3fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniformMatrix3fv(location,transpose,v,srcOffset,srcLength);
	} else {
		this1.uniformMatrix3fv(location,transpose,v);
	}
};
lime_graphics_opengl_GL.uniformMatrix3x2fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix3x2fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformMatrix3x4fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix3x4fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformMatrix4fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniformMatrix4fv(location,transpose,v,srcOffset,srcLength);
	} else {
		this1.uniformMatrix4fv(location,transpose,v);
	}
};
lime_graphics_opengl_GL.uniformMatrix4x2fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix4x2fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformMatrix4x3fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix4x3fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.useProgram = function(program) {
	lime_graphics_opengl_GL.context.useProgram(program);
};
lime_graphics_opengl_GL.validateProgram = function(program) {
	lime_graphics_opengl_GL.context.validateProgram(program);
};
lime_graphics_opengl_GL.vertexAttrib1f = function(index,v0) {
	lime_graphics_opengl_GL.context.vertexAttrib1f(index,v0);
};
lime_graphics_opengl_GL.vertexAttrib1fv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib1fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib1fvWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib1fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib2f = function(index,v0,v1) {
	lime_graphics_opengl_GL.context.vertexAttrib2f(index,v0,v1);
};
lime_graphics_opengl_GL.vertexAttrib2fv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib2fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib2fvWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib2fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib3f = function(index,v0,v1,v2) {
	lime_graphics_opengl_GL.context.vertexAttrib3f(index,v0,v1,v2);
};
lime_graphics_opengl_GL.vertexAttrib3fv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib3fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib3fvWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib3fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib4f = function(index,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.vertexAttrib4f(index,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.vertexAttrib4fv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib4fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib4fvWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib4fv(index,v);
};
lime_graphics_opengl_GL.vertexAttribDivisor = function(index,divisor) {
	lime_graphics_opengl_GL.context.vertexAttribDivisor(index,divisor);
};
lime_graphics_opengl_GL.vertexAttribI4i = function(index,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.vertexAttribI4i(index,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.vertexAttribI4iv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttribI4iv(index,v);
};
lime_graphics_opengl_GL.vertexAttribI4ivWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttribI4iv(index,v);
};
lime_graphics_opengl_GL.vertexAttribI4ui = function(index,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.vertexAttribI4ui(index,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.vertexAttribI4uiv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttribI4uiv(index,v);
};
lime_graphics_opengl_GL.vertexAttribI4uivWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttribI4uiv(index,v);
};
lime_graphics_opengl_GL.vertexAttribIPointer = function(index,size,type,stride,offset) {
	lime_graphics_opengl_GL.context.vertexAttribIPointer(index,size,type,stride,offset);
};
lime_graphics_opengl_GL.vertexAttribPointer = function(index,size,type,normalized,stride,offset) {
	lime_graphics_opengl_GL.context.vertexAttribPointer(index,size,type,normalized,stride,offset);
};
lime_graphics_opengl_GL.viewport = function(x,y,width,height) {
	lime_graphics_opengl_GL.context.viewport(x,y,width,height);
};
lime_graphics_opengl_GL.waitSync = function(sync,flags,timeout) {
	lime_graphics_opengl_GL.context.waitSync(sync,flags,timeout);
};
lime_graphics_opengl_GL.__getObjectID = function(object) {
	if(object == null) {
		return 0;
	} else {
		return object.id;
	}
};
var lime_graphics_opengl__$GLProgram_GLProgram_$Impl_$ = {};
$hxClasses["lime.graphics.opengl._GLProgram.GLProgram_Impl_"] = lime_graphics_opengl__$GLProgram_GLProgram_$Impl_$;
lime_graphics_opengl__$GLProgram_GLProgram_$Impl_$.__name__ = ["lime","graphics","opengl","_GLProgram","GLProgram_Impl_"];
lime_graphics_opengl__$GLProgram_GLProgram_$Impl_$.fromSources = function(gl,vertexSource,fragmentSource) {
	var vertexShader = lime_graphics_opengl__$GLShader_GLShader_$Impl_$.fromSource(gl,vertexSource,gl.VERTEX_SHADER);
	var fragmentShader = lime_graphics_opengl__$GLShader_GLShader_$Impl_$.fromSource(gl,fragmentSource,gl.FRAGMENT_SHADER);
	var program = gl.createProgram();
	gl.attachShader(program,vertexShader);
	gl.attachShader(program,fragmentShader);
	gl.linkProgram(program);
	if(gl.getProgramParameter(program,35714) == 0) {
		var message = "Unable to initialize the shader program";
		message += "\n" + lime_graphics_opengl_GL.context.getProgramInfoLog(program);
		lime_utils_Log.error(message,{ fileName : "GLProgram.hx", lineNumber : 39, className : "lime.graphics.opengl._GLProgram.GLProgram_Impl_", methodName : "fromSources"});
	}
	return program;
};
var lime_graphics_opengl__$GLShader_GLShader_$Impl_$ = {};
$hxClasses["lime.graphics.opengl._GLShader.GLShader_Impl_"] = lime_graphics_opengl__$GLShader_GLShader_$Impl_$;
lime_graphics_opengl__$GLShader_GLShader_$Impl_$.__name__ = ["lime","graphics","opengl","_GLShader","GLShader_Impl_"];
lime_graphics_opengl__$GLShader_GLShader_$Impl_$.fromSource = function(gl,source,type) {
	var shader = gl.createShader(type);
	gl.shaderSource(shader,source);
	gl.compileShader(shader);
	if(gl.getShaderParameter(shader,gl.COMPILE_STATUS) == 0) {
		var message;
		if(type == gl.VERTEX_SHADER) {
			message = "Error compiling vertex shader";
		} else if(type == gl.FRAGMENT_SHADER) {
			message = "Error compiling fragment shader";
		} else {
			message = "Error compiling unknown shader type";
		}
		message += "\n" + gl.getShaderInfoLog(shader);
		lime_utils_Log.error(message,{ fileName : "GLShader.hx", lineNumber : 40, className : "lime.graphics.opengl._GLShader.GLShader_Impl_", methodName : "fromSource"});
	}
	return shader;
};
var lime_graphics_opengl_ext_KHR_$debug = function() {
	this.STACK_UNDERFLOW = 1284;
	this.STACK_OVERFLOW = 1283;
	this.CONTEXT_FLAG_DEBUG_BIT = 2;
	this.DEBUG_OUTPUT = 37600;
	this.DEBUG_SEVERITY_LOW = 37192;
	this.DEBUG_SEVERITY_MEDIUM = 37191;
	this.DEBUG_SEVERITY_HIGH = 37190;
	this.DEBUG_LOGGED_MESSAGES = 37189;
	this.MAX_DEBUG_LOGGED_MESSAGES = 37188;
	this.MAX_DEBUG_MESSAGE_LENGTH = 37187;
	this.MAX_LABEL_LENGTH = 33512;
	this.SAMPLER = 33510;
	this.QUERY = 33507;
	this.PROGRAM = 33506;
	this.SHADER = 33505;
	this.BUFFER = 33504;
	this.DEBUG_GROUP_STACK_DEPTH = 33389;
	this.MAX_DEBUG_GROUP_STACK_DEPTH = 33388;
	this.DEBUG_SEVERITY_NOTIFICATION = 33387;
	this.DEBUG_TYPE_POP_GROUP = 33386;
	this.DEBUG_TYPE_PUSH_GROUP = 33385;
	this.DEBUG_TYPE_MARKER = 33384;
	this.DEBUG_TYPE_OTHER = 33361;
	this.DEBUG_TYPE_PERFORMANCE = 33360;
	this.DEBUG_TYPE_PORTABILITY = 33359;
	this.DEBUG_TYPE_UNDEFINED_BEHAVIOR = 33358;
	this.DEBUG_TYPE_DEPRECATED_BEHAVIOR = 33357;
	this.DEBUG_TYPE_ERROR = 33356;
	this.DEBUG_SOURCE_OTHER = 33355;
	this.DEBUG_SOURCE_APPLICATION = 33354;
	this.DEBUG_SOURCE_THIRD_PARTY = 33353;
	this.DEBUG_SOURCE_SHADER_COMPILER = 33352;
	this.DEBUG_SOURCE_WINDOW_SYSTEM = 33351;
	this.DEBUG_SOURCE_API = 33350;
	this.DEBUG_CALLBACK_USER_PARAM = 33349;
	this.DEBUG_CALLBACK_FUNCTION = 33348;
	this.DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 33347;
	this.DEBUG_OUTPUT_SYNCHRONOUS = 33346;
};
$hxClasses["lime.graphics.opengl.ext.KHR_debug"] = lime_graphics_opengl_ext_KHR_$debug;
lime_graphics_opengl_ext_KHR_$debug.__name__ = ["lime","graphics","opengl","ext","KHR_debug"];
lime_graphics_opengl_ext_KHR_$debug.prototype = {
	__class__: lime_graphics_opengl_ext_KHR_$debug
};
var lime_math__$ARGB_ARGB_$Impl_$ = {};
$hxClasses["lime.math._ARGB.ARGB_Impl_"] = lime_math__$ARGB_ARGB_$Impl_$;
lime_math__$ARGB_ARGB_$Impl_$.__name__ = ["lime","math","_ARGB","ARGB_Impl_"];
lime_math__$ARGB_ARGB_$Impl_$.__properties__ = {set_r:"set_r",get_r:"get_r",set_g:"set_g",get_g:"get_g",set_b:"set_b",get_b:"get_b",set_a:"set_a",get_a:"get_a"};
lime_math__$ARGB_ARGB_$Impl_$._new = function(argb) {
	if(argb == null) {
		argb = 0;
	}
	var this1 = argb;
	return this1;
};
lime_math__$ARGB_ARGB_$Impl_$.create = function(a,r,g,b) {
	var this1 = 0;
	var argb = this1;
	argb = (a & 255) << 24 | (r & 255) << 16 | (g & 255) << 8 | b & 255;
	return argb;
};
lime_math__$ARGB_ARGB_$Impl_$.multiplyAlpha = function(this1) {
	if((this1 >>> 24 & 255) == 0) {
		this1 = 0;
	} else if((this1 >>> 24 & 255) != 255) {
		lime_math__$ARGB_ARGB_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[this1 >>> 24 & 255];
		this1 = (this1 >>> 24 & 255 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math__$ARGB_ARGB_$Impl_$.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math__$ARGB_ARGB_$Impl_$.a16 >> 16 & 255) << 8 | (this1 & 255) * lime_math__$ARGB_ARGB_$Impl_$.a16 >> 16 & 255;
	}
};
lime_math__$ARGB_ARGB_$Impl_$.readUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	switch(format) {
	case 0:
		this1 = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 1:
		this1 = (data[offset + 2] & 255) << 24 | (data[offset + 3] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 1] & 255;
		break;
	case 2:
		this1 = (data[offset + 1] & 255) << 24 | (data[offset] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset + 2] & 255;
		break;
	}
	if(premultiplied) {
		if((this1 >>> 24 & 255) != 0 && (this1 >>> 24 & 255) != 255) {
			lime_math__$ARGB_ARGB_$Impl_$.unmult = 255.0 / (this1 >>> 24 & 255);
			this1 = (this1 >>> 24 & 255 & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 >>> 16 & 255) * lime_math__$ARGB_ARGB_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 >>> 8 & 255) * lime_math__$ARGB_ARGB_$Impl_$.unmult)] & 255) << 8 | lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 & 255) * lime_math__$ARGB_ARGB_$Impl_$.unmult)] & 255;
		}
	}
};
lime_math__$ARGB_ARGB_$Impl_$.set = function(this1,a,r,g,b) {
	this1 = (a & 255) << 24 | (r & 255) << 16 | (g & 255) << 8 | b & 255;
};
lime_math__$ARGB_ARGB_$Impl_$.unmultiplyAlpha = function(this1) {
	if((this1 >>> 24 & 255) != 0 && (this1 >>> 24 & 255) != 255) {
		lime_math__$ARGB_ARGB_$Impl_$.unmult = 255.0 / (this1 >>> 24 & 255);
		this1 = (this1 >>> 24 & 255 & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 >>> 16 & 255) * lime_math__$ARGB_ARGB_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 >>> 8 & 255) * lime_math__$ARGB_ARGB_$Impl_$.unmult)] & 255) << 8 | lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 & 255) * lime_math__$ARGB_ARGB_$Impl_$.unmult)] & 255;
	}
};
lime_math__$ARGB_ARGB_$Impl_$.writeUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	if(premultiplied) {
		if((this1 >>> 24 & 255) == 0) {
			this1 = 0;
		} else if((this1 >>> 24 & 255) != 255) {
			lime_math__$ARGB_ARGB_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[this1 >>> 24 & 255];
			this1 = (this1 >>> 24 & 255 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math__$ARGB_ARGB_$Impl_$.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math__$ARGB_ARGB_$Impl_$.a16 >> 16 & 255) << 8 | (this1 & 255) * lime_math__$ARGB_ARGB_$Impl_$.a16 >> 16 & 255;
		}
	}
	switch(format) {
	case 0:
		data[offset] = this1 >>> 16 & 255;
		data[offset + 1] = this1 >>> 8 & 255;
		data[offset + 2] = this1 & 255;
		data[offset + 3] = this1 >>> 24 & 255;
		break;
	case 1:
		data[offset] = this1 >>> 24 & 255;
		data[offset + 1] = this1 >>> 16 & 255;
		data[offset + 2] = this1 >>> 8 & 255;
		data[offset + 3] = this1 & 255;
		break;
	case 2:
		data[offset] = this1 & 255;
		data[offset + 1] = this1 >>> 8 & 255;
		data[offset + 2] = this1 >>> 16 & 255;
		data[offset + 3] = this1 >>> 24 & 255;
		break;
	}
};
lime_math__$ARGB_ARGB_$Impl_$.__fromBGRA = function(bgra) {
	var this1 = 0;
	var argb = this1;
	argb = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
	return argb;
};
lime_math__$ARGB_ARGB_$Impl_$.__fromRGBA = function(rgba) {
	var this1 = 0;
	var argb = this1;
	argb = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
	return argb;
};
lime_math__$ARGB_ARGB_$Impl_$.get_a = function(this1) {
	return this1 >>> 24 & 255;
};
lime_math__$ARGB_ARGB_$Impl_$.set_a = function(this1,value) {
	this1 = (value & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math__$ARGB_ARGB_$Impl_$.get_b = function(this1) {
	return this1 & 255;
};
lime_math__$ARGB_ARGB_$Impl_$.set_b = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | value & 255;
	return value;
};
lime_math__$ARGB_ARGB_$Impl_$.get_g = function(this1) {
	return this1 >>> 8 & 255;
};
lime_math__$ARGB_ARGB_$Impl_$.set_g = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (value & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math__$ARGB_ARGB_$Impl_$.get_r = function(this1) {
	return this1 >>> 16 & 255;
};
lime_math__$ARGB_ARGB_$Impl_$.set_r = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (value & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
var lime_math__$BGRA_BGRA_$Impl_$ = {};
$hxClasses["lime.math._BGRA.BGRA_Impl_"] = lime_math__$BGRA_BGRA_$Impl_$;
lime_math__$BGRA_BGRA_$Impl_$.__name__ = ["lime","math","_BGRA","BGRA_Impl_"];
lime_math__$BGRA_BGRA_$Impl_$.__properties__ = {set_r:"set_r",get_r:"get_r",set_g:"set_g",get_g:"get_g",set_b:"set_b",get_b:"get_b",set_a:"set_a",get_a:"get_a"};
lime_math__$BGRA_BGRA_$Impl_$._new = function(bgra) {
	if(bgra == null) {
		bgra = 0;
	}
	var this1 = bgra;
	return this1;
};
lime_math__$BGRA_BGRA_$Impl_$.create = function(b,g,r,a) {
	var this1 = 0;
	var bgra = this1;
	bgra = (b & 255) << 24 | (g & 255) << 16 | (r & 255) << 8 | a & 255;
	return bgra;
};
lime_math__$BGRA_BGRA_$Impl_$.multiplyAlpha = function(this1) {
	if((this1 & 255) == 0) {
		this1 = 0;
	} else if((this1 & 255) != 255) {
		lime_math__$BGRA_BGRA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[this1 & 255];
		this1 = ((this1 >>> 24 & 255) * lime_math__$BGRA_BGRA_$Impl_$.a16 >> 16 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math__$BGRA_BGRA_$Impl_$.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math__$BGRA_BGRA_$Impl_$.a16 >> 16 & 255) << 8 | this1 & 255 & 255;
	}
};
lime_math__$BGRA_BGRA_$Impl_$.readUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	switch(format) {
	case 0:
		this1 = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		this1 = (data[offset + 3] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 1] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		this1 = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied) {
		if((this1 & 255) != 0 && (this1 & 255) != 255) {
			lime_math__$BGRA_BGRA_$Impl_$.unmult = 255.0 / (this1 & 255);
			this1 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 >>> 24 & 255) * lime_math__$BGRA_BGRA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 >>> 16 & 255) * lime_math__$BGRA_BGRA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 >>> 8 & 255) * lime_math__$BGRA_BGRA_$Impl_$.unmult)] & 255) << 8 | this1 & 255 & 255;
		}
	}
};
lime_math__$BGRA_BGRA_$Impl_$.set = function(this1,b,g,r,a) {
	this1 = (b & 255) << 24 | (g & 255) << 16 | (r & 255) << 8 | a & 255;
};
lime_math__$BGRA_BGRA_$Impl_$.unmultiplyAlpha = function(this1) {
	if((this1 & 255) != 0 && (this1 & 255) != 255) {
		lime_math__$BGRA_BGRA_$Impl_$.unmult = 255.0 / (this1 & 255);
		this1 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 >>> 24 & 255) * lime_math__$BGRA_BGRA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 >>> 16 & 255) * lime_math__$BGRA_BGRA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.floor((this1 >>> 8 & 255) * lime_math__$BGRA_BGRA_$Impl_$.unmult)] & 255) << 8 | this1 & 255 & 255;
	}
};
lime_math__$BGRA_BGRA_$Impl_$.writeUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	if(premultiplied) {
		if((this1 & 255) == 0) {
			this1 = 0;
		} else if((this1 & 255) != 255) {
			lime_math__$BGRA_BGRA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[this1 & 255];
			this1 = ((this1 >>> 24 & 255) * lime_math__$BGRA_BGRA_$Impl_$.a16 >> 16 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math__$BGRA_BGRA_$Impl_$.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math__$BGRA_BGRA_$Impl_$.a16 >> 16 & 255) << 8 | this1 & 255 & 255;
		}
	}
	switch(format) {
	case 0:
		data[offset] = this1 >>> 8 & 255;
		data[offset + 1] = this1 >>> 16 & 255;
		data[offset + 2] = this1 >>> 24 & 255;
		data[offset + 3] = this1 & 255;
		break;
	case 1:
		data[offset] = this1 & 255;
		data[offset + 1] = this1 >>> 8 & 255;
		data[offset + 2] = this1 >>> 16 & 255;
		data[offset + 3] = this1 >>> 24 & 255;
		break;
	case 2:
		data[offset] = this1 >>> 24 & 255;
		data[offset + 1] = this1 >>> 16 & 255;
		data[offset + 2] = this1 >>> 8 & 255;
		data[offset + 3] = this1 & 255;
		break;
	}
};
lime_math__$BGRA_BGRA_$Impl_$.__fromARGB = function(argb) {
	var this1 = 0;
	var bgra = this1;
	bgra = (argb & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb >>> 16 & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
	return bgra;
};
lime_math__$BGRA_BGRA_$Impl_$.__fromRGBA = function(rgba) {
	var this1 = 0;
	var bgra = this1;
	bgra = (rgba >>> 8 & 255 & 255) << 24 | (rgba >>> 16 & 255 & 255) << 16 | (rgba >>> 24 & 255 & 255) << 8 | rgba & 255 & 255;
	return bgra;
};
lime_math__$BGRA_BGRA_$Impl_$.get_a = function(this1) {
	return this1 & 255;
};
lime_math__$BGRA_BGRA_$Impl_$.set_a = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | value & 255;
	return value;
};
lime_math__$BGRA_BGRA_$Impl_$.get_b = function(this1) {
	return this1 >>> 24 & 255;
};
lime_math__$BGRA_BGRA_$Impl_$.set_b = function(this1,value) {
	this1 = (value & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math__$BGRA_BGRA_$Impl_$.get_g = function(this1) {
	return this1 >>> 16 & 255;
};
lime_math__$BGRA_BGRA_$Impl_$.set_g = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (value & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math__$BGRA_BGRA_$Impl_$.get_r = function(this1) {
	return this1 >>> 8 & 255;
};
lime_math__$BGRA_BGRA_$Impl_$.set_r = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (value & 255) << 8 | this1 & 255 & 255;
	return value;
};
var lime_math__$ColorMatrix_ColorMatrix_$Impl_$ = {};
$hxClasses["lime.math._ColorMatrix.ColorMatrix_Impl_"] = lime_math__$ColorMatrix_ColorMatrix_$Impl_$;
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__name__ = ["lime","math","_ColorMatrix","ColorMatrix_Impl_"];
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__properties__ = {set_redOffset:"set_redOffset",get_redOffset:"get_redOffset",set_redMultiplier:"set_redMultiplier",get_redMultiplier:"get_redMultiplier",set_greenOffset:"set_greenOffset",get_greenOffset:"get_greenOffset",set_greenMultiplier:"set_greenMultiplier",get_greenMultiplier:"get_greenMultiplier",set_color:"set_color",get_color:"get_color",set_blueOffset:"set_blueOffset",get_blueOffset:"get_blueOffset",set_blueMultiplier:"set_blueMultiplier",get_blueMultiplier:"get_blueMultiplier",set_alphaOffset:"set_alphaOffset",get_alphaOffset:"get_alphaOffset",set_alphaMultiplier:"set_alphaMultiplier",get_alphaMultiplier:"get_alphaMultiplier"};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$._new = function(data) {
	var this1;
	if(data != null && data.length == 20) {
		this1 = data;
	} else {
		var array = lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__identity;
		var this2;
		if(array != null) {
			this2 = new Float32Array(array);
		} else {
			this2 = null;
		}
		this1 = this2;
	}
	return this1;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.clone = function(this1) {
	var view = lime_utils__$Float32Array_Float32Array_$Impl_$.toArrayBufferView(this1);
	var this2;
	if(view != null) {
		this2 = new Float32Array(view);
	} else {
		this2 = null;
	}
	return lime_math__$ColorMatrix_ColorMatrix_$Impl_$._new(this2);
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.concat = function(this1,second) {
	var _g = this1;
	_g[0] += second[0];
	var _g1 = this1;
	_g1[6] += second[6];
	var _g2 = this1;
	_g2[12] += second[12];
	var _g3 = this1;
	_g3[18] += second[18];
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.copyFrom = function(this1,other) {
	this1.set(other);
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.identity = function(this1) {
	this1[0] = 1;
	this1[1] = 0;
	this1[2] = 0;
	this1[3] = 0;
	this1[4] = 0;
	this1[5] = 0;
	this1[6] = 1;
	this1[7] = 0;
	this1[8] = 0;
	this1[9] = 0;
	this1[10] = 0;
	this1[11] = 0;
	this1[12] = 1;
	this1[13] = 0;
	this1[14] = 0;
	this1[15] = 0;
	this1[16] = 0;
	this1[17] = 0;
	this1[18] = 1;
	this1[19] = 0;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.getAlphaTable = function(this1) {
	if(lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__alphaTable == null) {
		var this2 = new Uint8Array(256);
		lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__alphaTable = this2;
	}
	var value;
	lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__alphaTable[0] = 0;
	var _g = 1;
	while(_g < 256) {
		var i = _g++;
		value = Math.floor(i * this1[18] + this1[19] * 255);
		if(value > 255) {
			value = 255;
		}
		if(value < 0) {
			value = 0;
		}
		lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__alphaTable[i] = value;
	}
	return lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__alphaTable;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.getBlueTable = function(this1) {
	if(lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__blueTable == null) {
		var this2 = new Uint8Array(256);
		lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__blueTable = this2;
	}
	var value;
	var _g = 0;
	while(_g < 256) {
		var i = _g++;
		value = Math.floor(i * this1[12] + this1[14] * 255);
		if(value > 255) {
			value = 255;
		}
		if(value < 0) {
			value = 0;
		}
		lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__blueTable[i] = value;
	}
	return lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__blueTable;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.getGreenTable = function(this1) {
	if(lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__greenTable == null) {
		var this2 = new Uint8Array(256);
		lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__greenTable = this2;
	}
	var value;
	var _g = 0;
	while(_g < 256) {
		var i = _g++;
		value = Math.floor(i * this1[6] + this1[9] * 255);
		if(value > 255) {
			value = 255;
		}
		if(value < 0) {
			value = 0;
		}
		lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__greenTable[i] = value;
	}
	return lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__greenTable;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.getRedTable = function(this1) {
	if(lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__redTable == null) {
		var this2 = new Uint8Array(256);
		lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__redTable = this2;
	}
	var value;
	var _g = 0;
	while(_g < 256) {
		var i = _g++;
		value = Math.floor(i * this1[0] + this1[4] * 255);
		if(value > 255) {
			value = 255;
		}
		if(value < 0) {
			value = 0;
		}
		lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__redTable[i] = value;
	}
	return lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__redTable;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.__toFlashColorTransform = function(this1) {
	return null;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.get_alphaMultiplier = function(this1) {
	return this1[18];
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.set_alphaMultiplier = function(this1,value) {
	return this1[18] = value;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.get_alphaOffset = function(this1) {
	return this1[19] * 255;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.set_alphaOffset = function(this1,value) {
	return this1[19] = value / 255;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.get_blueMultiplier = function(this1) {
	return this1[12];
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.set_blueMultiplier = function(this1,value) {
	return this1[12] = value;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.get_blueOffset = function(this1) {
	return this1[14] * 255;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.set_blueOffset = function(this1,value) {
	return this1[14] = value / 255;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.get_color = function(this1) {
	return (this1[4] * 255 | 0) << 16 | (this1[9] * 255 | 0) << 8 | (this1[14] * 255 | 0);
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.set_color = function(this1,value) {
	this1[4] = (value >> 16 & 255) / 255;
	this1[9] = (value >> 8 & 255) / 255;
	this1[14] = (value & 255) / 255;
	this1[0] = 0;
	this1[6] = 0;
	this1[12] = 0;
	return lime_math__$ColorMatrix_ColorMatrix_$Impl_$.get_color(this1);
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.get_greenMultiplier = function(this1) {
	return this1[6];
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.set_greenMultiplier = function(this1,value) {
	return this1[6] = value;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.get_greenOffset = function(this1) {
	return this1[9] * 255;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.set_greenOffset = function(this1,value) {
	return this1[9] = value / 255;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.get_redMultiplier = function(this1) {
	return this1[0];
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.set_redMultiplier = function(this1,value) {
	return this1[0] = value;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.get_redOffset = function(this1) {
	return this1[4] * 255;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.set_redOffset = function(this1,value) {
	return this1[4] = value / 255;
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.get = function(this1,index) {
	return this1[index];
};
lime_math__$ColorMatrix_ColorMatrix_$Impl_$.set = function(this1,index,value) {
	return this1[index] = value;
};
var lime_math_Matrix3 = function(a,b,c,d,tx,ty) {
	if(ty == null) {
		ty = 0;
	}
	if(tx == null) {
		tx = 0;
	}
	if(d == null) {
		d = 1;
	}
	if(c == null) {
		c = 0;
	}
	if(b == null) {
		b = 0;
	}
	if(a == null) {
		a = 1;
	}
	this.a = a;
	this.b = b;
	this.c = c;
	this.d = d;
	this.tx = tx;
	this.ty = ty;
};
$hxClasses["lime.math.Matrix3"] = lime_math_Matrix3;
lime_math_Matrix3.__name__ = ["lime","math","Matrix3"];
lime_math_Matrix3.prototype = {
	clone: function() {
		return new lime_math_Matrix3(this.a,this.b,this.c,this.d,this.tx,this.ty);
	}
	,concat: function(m) {
		var a1 = this.a * m.a + this.b * m.c;
		this.b = this.a * m.b + this.b * m.d;
		this.a = a1;
		var c1 = this.c * m.a + this.d * m.c;
		this.d = this.c * m.b + this.d * m.d;
		this.c = c1;
		var tx1 = this.tx * m.a + this.ty * m.c + m.tx;
		this.ty = this.tx * m.b + this.ty * m.d + m.ty;
		this.tx = tx1;
	}
	,copyColumnFrom: function(column,vector4) {
		if(column > 2) {
			throw new js__$Boot_HaxeError("Column " + column + " out of bounds (2)");
		} else if(column == 0) {
			this.a = vector4.x;
			this.b = vector4.y;
		} else if(column == 1) {
			this.c = vector4.x;
			this.d = vector4.y;
		} else {
			this.tx = vector4.x;
			this.ty = vector4.y;
		}
	}
	,copyColumnTo: function(column,vector4) {
		if(column > 2) {
			throw new js__$Boot_HaxeError("Column " + column + " out of bounds (2)");
		} else if(column == 0) {
			vector4.x = this.a;
			vector4.y = this.b;
			vector4.z = 0;
		} else if(column == 1) {
			vector4.x = this.c;
			vector4.y = this.d;
			vector4.z = 0;
		} else {
			vector4.x = this.tx;
			vector4.y = this.ty;
			vector4.z = 1;
		}
	}
	,copyFrom: function(sourceMatrix3) {
		this.a = sourceMatrix3.a;
		this.b = sourceMatrix3.b;
		this.c = sourceMatrix3.c;
		this.d = sourceMatrix3.d;
		this.tx = sourceMatrix3.tx;
		this.ty = sourceMatrix3.ty;
	}
	,copyRowFrom: function(row,vector4) {
		if(row > 2) {
			throw new js__$Boot_HaxeError("Row " + row + " out of bounds (2)");
		} else if(row == 0) {
			this.a = vector4.x;
			this.c = vector4.y;
			this.tx = vector4.z;
		} else if(row == 1) {
			this.b = vector4.x;
			this.d = vector4.y;
			this.ty = vector4.z;
		}
	}
	,copyRowTo: function(row,vector4) {
		if(row > 2) {
			throw new js__$Boot_HaxeError("Row " + row + " out of bounds (2)");
		} else if(row == 0) {
			vector4.x = this.a;
			vector4.y = this.c;
			vector4.z = this.tx;
		} else if(row == 1) {
			vector4.x = this.b;
			vector4.y = this.d;
			vector4.z = this.ty;
		} else {
			vector4.x = 0;
			vector4.y = 0;
			vector4.z = 1;
		}
	}
	,createBox: function(scaleX,scaleY,rotation,tx,ty) {
		if(ty == null) {
			ty = 0;
		}
		if(tx == null) {
			tx = 0;
		}
		if(rotation == null) {
			rotation = 0;
		}
		if(rotation != 0) {
			var cos = Math.cos(rotation);
			var sin = Math.sin(rotation);
			this.a = cos * scaleX;
			this.b = sin * scaleY;
			this.c = -sin * scaleX;
			this.d = cos * scaleY;
		} else {
			this.a = scaleX;
			this.b = 0;
			this.c = 0;
			this.d = scaleY;
		}
		this.tx = tx;
		this.ty = ty;
	}
	,createGradientBox: function(width,height,rotation,tx,ty) {
		if(ty == null) {
			ty = 0;
		}
		if(tx == null) {
			tx = 0;
		}
		if(rotation == null) {
			rotation = 0;
		}
		this.a = width / 1638.4;
		this.d = height / 1638.4;
		if(rotation != 0) {
			var cos = Math.cos(rotation);
			var sin = Math.sin(rotation);
			this.b = sin * this.d;
			this.c = -sin * this.a;
			this.a *= cos;
			this.d *= cos;
		} else {
			this.b = 0;
			this.c = 0;
		}
		this.tx = tx + width / 2;
		this.ty = ty + height / 2;
	}
	,equals: function(matrix3) {
		if(matrix3 != null && this.tx == matrix3.tx && this.ty == matrix3.ty && this.a == matrix3.a && this.b == matrix3.b && this.c == matrix3.c) {
			return this.d == matrix3.d;
		} else {
			return false;
		}
	}
	,deltaTransformVector: function(Vector2,result) {
		if(result == null) {
			result = new lime_math_Vector2();
		}
		result.x = Vector2.x * this.a + Vector2.y * this.c;
		result.y = Vector2.x * this.b + Vector2.y * this.d;
		return result;
	}
	,identity: function() {
		this.a = 1;
		this.b = 0;
		this.c = 0;
		this.d = 1;
		this.tx = 0;
		this.ty = 0;
	}
	,invert: function() {
		var norm = this.a * this.d - this.b * this.c;
		if(norm == 0) {
			this.a = this.b = this.c = this.d = 0;
			this.tx = -this.tx;
			this.ty = -this.ty;
		} else {
			norm = 1.0 / norm;
			var a1 = this.d * norm;
			this.d = this.a * norm;
			this.a = a1;
			this.b *= -norm;
			this.c *= -norm;
			var tx1 = -this.a * this.tx - this.c * this.ty;
			this.ty = -this.b * this.tx - this.d * this.ty;
			this.tx = tx1;
		}
		return this;
	}
	,rotate: function(theta) {
		var cos = Math.cos(theta);
		var sin = Math.sin(theta);
		var a1 = this.a * cos - this.b * sin;
		this.b = this.a * sin + this.b * cos;
		this.a = a1;
		var c1 = this.c * cos - this.d * sin;
		this.d = this.c * sin + this.d * cos;
		this.c = c1;
		var tx1 = this.tx * cos - this.ty * sin;
		this.ty = this.tx * sin + this.ty * cos;
		this.tx = tx1;
	}
	,scale: function(sx,sy) {
		this.a *= sx;
		this.b *= sy;
		this.c *= sx;
		this.d *= sy;
		this.tx *= sx;
		this.ty *= sy;
	}
	,setRotation: function(theta,scale) {
		if(scale == null) {
			scale = 1;
		}
		this.a = Math.cos(theta) * scale;
		this.c = Math.sin(theta) * scale;
		this.b = -this.c;
		this.d = this.a;
	}
	,setTo: function(a,b,c,d,tx,ty) {
		this.a = a;
		this.b = b;
		this.c = c;
		this.d = d;
		this.tx = tx;
		this.ty = ty;
	}
	,to3DString: function(roundPixels) {
		if(roundPixels == null) {
			roundPixels = false;
		}
		if(roundPixels) {
			return "matrix3d(" + this.a + ", " + this.b + ", " + "0, 0, " + this.c + ", " + this.d + ", " + "0, 0, 0, 0, 1, 0, " + (this.tx | 0) + ", " + (this.ty | 0) + ", 0, 1)";
		} else {
			return "matrix3d(" + this.a + ", " + this.b + ", " + "0, 0, " + this.c + ", " + this.d + ", " + "0, 0, 0, 0, 1, 0, " + this.tx + ", " + this.ty + ", 0, 1)";
		}
	}
	,toString: function() {
		return "matrix(" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ", " + this.tx + ", " + this.ty + ")";
	}
	,transformRect: function(rect,result) {
		if(result == null) {
			result = new lime_math_Rectangle();
		}
		var tx0 = this.a * rect.x + this.c * rect.y;
		var tx1 = tx0;
		var ty0 = this.b * rect.x + this.d * rect.y;
		var ty1 = ty0;
		var tx = this.a * (rect.x + rect.width) + this.c * rect.y;
		var ty = this.b * (rect.x + rect.width) + this.d * rect.y;
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		tx = this.a * (rect.x + rect.width) + this.c * (rect.y + rect.height);
		ty = this.b * (rect.x + rect.width) + this.d * (rect.y + rect.height);
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		tx = this.a * rect.x + this.c * (rect.y + rect.height);
		ty = this.b * rect.x + this.d * (rect.y + rect.height);
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		result.setTo(tx0 + tx,ty0 + ty,tx1 - tx0,ty1 - ty0);
		return result;
	}
	,transformVector: function(pos,result) {
		if(result == null) {
			result = new lime_math_Vector2();
		}
		result.x = pos.x * this.a + pos.y * this.c + this.tx;
		result.y = pos.x * this.b + pos.y * this.d + this.ty;
		return result;
	}
	,translate: function(dx,dy) {
		this.tx += dx;
		this.ty += dy;
	}
	,__class__: lime_math_Matrix3
};
var lime_math__$Matrix4_Matrix4_$Impl_$ = {};
$hxClasses["lime.math._Matrix4.Matrix4_Impl_"] = lime_math__$Matrix4_Matrix4_$Impl_$;
lime_math__$Matrix4_Matrix4_$Impl_$.__name__ = ["lime","math","_Matrix4","Matrix4_Impl_"];
lime_math__$Matrix4_Matrix4_$Impl_$.__properties__ = {set_position:"set_position",get_position:"get_position",get_determinant:"get_determinant"};
lime_math__$Matrix4_Matrix4_$Impl_$._new = function(data) {
	var this1;
	if(data != null && data.length == 16) {
		this1 = data;
	} else {
		var array = lime_math__$Matrix4_Matrix4_$Impl_$.__identity;
		var this2;
		if(array != null) {
			this2 = new Float32Array(array);
		} else {
			this2 = null;
		}
		this1 = this2;
	}
	return this1;
};
lime_math__$Matrix4_Matrix4_$Impl_$.append = function(this1,lhs) {
	var m111 = this1[0];
	var m121 = this1[4];
	var m131 = this1[8];
	var m141 = this1[12];
	var m112 = this1[1];
	var m122 = this1[5];
	var m132 = this1[9];
	var m142 = this1[13];
	var m113 = this1[2];
	var m123 = this1[6];
	var m133 = this1[10];
	var m143 = this1[14];
	var m114 = this1[3];
	var m124 = this1[7];
	var m134 = this1[11];
	var m144 = this1[15];
	var m211 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,0);
	var m221 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,4);
	var m231 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,8);
	var m241 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,12);
	var m212 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,1);
	var m222 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,5);
	var m232 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,9);
	var m242 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,13);
	var m213 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,2);
	var m223 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,6);
	var m233 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,10);
	var m243 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,14);
	var m214 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,3);
	var m224 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,7);
	var m234 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,11);
	var m244 = lime_math__$Matrix4_Matrix4_$Impl_$.get(lhs,15);
	this1[0] = m111 * m211 + m112 * m221 + m113 * m231 + m114 * m241;
	this1[1] = m111 * m212 + m112 * m222 + m113 * m232 + m114 * m242;
	this1[2] = m111 * m213 + m112 * m223 + m113 * m233 + m114 * m243;
	this1[3] = m111 * m214 + m112 * m224 + m113 * m234 + m114 * m244;
	this1[4] = m121 * m211 + m122 * m221 + m123 * m231 + m124 * m241;
	this1[5] = m121 * m212 + m122 * m222 + m123 * m232 + m124 * m242;
	this1[6] = m121 * m213 + m122 * m223 + m123 * m233 + m124 * m243;
	this1[7] = m121 * m214 + m122 * m224 + m123 * m234 + m124 * m244;
	this1[8] = m131 * m211 + m132 * m221 + m133 * m231 + m134 * m241;
	this1[9] = m131 * m212 + m132 * m222 + m133 * m232 + m134 * m242;
	this1[10] = m131 * m213 + m132 * m223 + m133 * m233 + m134 * m243;
	this1[11] = m131 * m214 + m132 * m224 + m133 * m234 + m134 * m244;
	this1[12] = m141 * m211 + m142 * m221 + m143 * m231 + m144 * m241;
	this1[13] = m141 * m212 + m142 * m222 + m143 * m232 + m144 * m242;
	this1[14] = m141 * m213 + m142 * m223 + m143 * m233 + m144 * m243;
	this1[15] = m141 * m214 + m142 * m224 + m143 * m234 + m144 * m244;
};
lime_math__$Matrix4_Matrix4_$Impl_$.appendRotation = function(this1,degrees,axis,pivotPoint) {
	var m = lime_math__$Matrix4_Matrix4_$Impl_$.__getAxisRotation(this1,axis.x,axis.y,axis.z,degrees);
	if(pivotPoint != null) {
		var p = pivotPoint;
		lime_math__$Matrix4_Matrix4_$Impl_$.appendTranslation(m,p.x,p.y,p.z);
	}
	lime_math__$Matrix4_Matrix4_$Impl_$.append(this1,m);
};
lime_math__$Matrix4_Matrix4_$Impl_$.appendScale = function(this1,xScale,yScale,zScale) {
	var array = [xScale,0.0,0.0,0.0,0.0,yScale,0.0,0.0,0.0,0.0,zScale,0.0,0.0,0.0,0.0,1.0];
	var this2;
	if(array != null) {
		this2 = new Float32Array(array);
	} else {
		this2 = null;
	}
	lime_math__$Matrix4_Matrix4_$Impl_$.append(this1,lime_math__$Matrix4_Matrix4_$Impl_$._new(this2));
};
lime_math__$Matrix4_Matrix4_$Impl_$.appendTranslation = function(this1,x,y,z) {
	this1[12] += x;
	this1[13] += y;
	this1[14] += z;
};
lime_math__$Matrix4_Matrix4_$Impl_$.clone = function(this1) {
	var view = lime_utils__$Float32Array_Float32Array_$Impl_$.toArrayBufferView(this1);
	var this2;
	if(view != null) {
		this2 = new Float32Array(view);
	} else {
		this2 = null;
	}
	return lime_math__$Matrix4_Matrix4_$Impl_$._new(this2);
};
lime_math__$Matrix4_Matrix4_$Impl_$.copyColumnFrom = function(this1,column,vector) {
	switch(column) {
	case 0:
		this1[0] = vector.x;
		this1[1] = vector.y;
		this1[2] = vector.z;
		this1[3] = vector.w;
		break;
	case 1:
		this1[4] = vector.x;
		this1[5] = vector.y;
		this1[6] = vector.z;
		this1[7] = vector.w;
		break;
	case 2:
		this1[8] = vector.x;
		this1[9] = vector.y;
		this1[10] = vector.z;
		this1[11] = vector.w;
		break;
	case 3:
		this1[12] = vector.x;
		this1[13] = vector.y;
		this1[14] = vector.z;
		this1[15] = vector.w;
		break;
	default:
		lime_utils_Log.error("Column " + column + " out of bounds [0, ..., 3]",{ fileName : "Matrix4.hx", lineNumber : 187, className : "lime.math._Matrix4.Matrix4_Impl_", methodName : "copyColumnFrom"});
	}
};
lime_math__$Matrix4_Matrix4_$Impl_$.copyColumnTo = function(this1,column,vector) {
	switch(column) {
	case 0:
		vector.x = this1[0];
		vector.y = this1[1];
		vector.z = this1[2];
		vector.w = this1[3];
		break;
	case 1:
		vector.x = this1[4];
		vector.y = this1[5];
		vector.z = this1[6];
		vector.w = this1[7];
		break;
	case 2:
		vector.x = this1[8];
		vector.y = this1[9];
		vector.z = this1[10];
		vector.w = this1[11];
		break;
	case 3:
		vector.x = this1[12];
		vector.y = this1[13];
		vector.z = this1[14];
		vector.w = this1[15];
		break;
	default:
		lime_utils_Log.error("Column " + column + " out of bounds [0, ..., 3]",{ fileName : "Matrix4.hx", lineNumber : 225, className : "lime.math._Matrix4.Matrix4_Impl_", methodName : "copyColumnTo"});
	}
};
lime_math__$Matrix4_Matrix4_$Impl_$.copyFrom = function(this1,other) {
	this1.set(other);
};
lime_math__$Matrix4_Matrix4_$Impl_$.copyRowFrom = function(this1,row,vector) {
	switch(row) {
	case 0:
		this1[0] = vector.x;
		this1[4] = vector.y;
		this1[8] = vector.z;
		this1[12] = vector.w;
		break;
	case 1:
		this1[1] = vector.x;
		this1[5] = vector.y;
		this1[9] = vector.z;
		this1[13] = vector.w;
		break;
	case 2:
		this1[2] = vector.x;
		this1[6] = vector.y;
		this1[10] = vector.z;
		this1[14] = vector.w;
		break;
	case 3:
		this1[3] = vector.x;
		this1[7] = vector.y;
		this1[11] = vector.z;
		this1[15] = vector.w;
		break;
	default:
		lime_utils_Log.error("Row " + row + " out of bounds [0, ..., 3]",{ fileName : "Matrix4.hx", lineNumber : 272, className : "lime.math._Matrix4.Matrix4_Impl_", methodName : "copyRowFrom"});
	}
};
lime_math__$Matrix4_Matrix4_$Impl_$.copyRowTo = function(this1,row,vector) {
	switch(row) {
	case 0:
		vector.x = this1[0];
		vector.y = this1[4];
		vector.z = this1[8];
		vector.w = this1[12];
		break;
	case 1:
		vector.x = this1[1];
		vector.y = this1[5];
		vector.z = this1[9];
		vector.w = this1[13];
		break;
	case 2:
		vector.x = this1[2];
		vector.y = this1[6];
		vector.z = this1[10];
		vector.w = this1[14];
		break;
	case 3:
		vector.x = this1[3];
		vector.y = this1[7];
		vector.z = this1[11];
		vector.w = this1[15];
		break;
	default:
		lime_utils_Log.error("Row " + row + " out of bounds [0, ..., 3]",{ fileName : "Matrix4.hx", lineNumber : 310, className : "lime.math._Matrix4.Matrix4_Impl_", methodName : "copyRowTo"});
	}
};
lime_math__$Matrix4_Matrix4_$Impl_$.create2D = function(this1,a,b,c,d,tx,ty) {
	if(ty == null) {
		ty = 0;
	}
	if(tx == null) {
		tx = 0;
	}
	this1[0] = a;
	this1[1] = b;
	this1[2] = 0;
	this1[3] = 0;
	this1[4] = c;
	this1[5] = d;
	this1[6] = 0;
	this1[7] = 0;
	this1[8] = 0;
	this1[9] = 0;
	this1[10] = 1;
	this1[11] = 0;
	this1[12] = tx;
	this1[13] = ty;
	this1[14] = 0;
	this1[15] = 1;
};
lime_math__$Matrix4_Matrix4_$Impl_$.createOrtho = function(this1,left,right,bottom,top,zNear,zFar) {
	var sx = 1.0 / (right - left);
	var sy = 1.0 / (top - bottom);
	var sz = 1.0 / (zFar - zNear);
	this1[0] = 2 * sx;
	this1[1] = 0;
	this1[2] = 0;
	this1[3] = 0;
	this1[4] = 0;
	this1[5] = 2 * sy;
	this1[6] = 0;
	this1[7] = 0;
	this1[8] = 0;
	this1[9] = 0;
	this1[10] = -2 * sz;
	this1[11] = 0;
	this1[12] = -(left + right) * sx;
	this1[13] = -(bottom + top) * sy;
	this1[14] = -(zNear + zFar) * sz;
	this1[15] = 1;
};
lime_math__$Matrix4_Matrix4_$Impl_$.deltaTransformVector = function(this1,v,result) {
	if(result == null) {
		result = new lime_math_Vector4();
	}
	var x = v.x;
	var y = v.y;
	var z = v.z;
	result.x = x * this1[0] + y * this1[4] + z * this1[8] + this1[3];
	result.y = x * this1[1] + y * this1[5] + z * this1[9] + this1[7];
	result.z = x * this1[2] + y * this1[6] + z * this1[10] + this1[11];
	return result;
};
lime_math__$Matrix4_Matrix4_$Impl_$.fromMatrix3 = function(matrix3) {
	var mat = lime_math__$Matrix4_Matrix4_$Impl_$._new();
	lime_math__$Matrix4_Matrix4_$Impl_$.create2D(mat,matrix3.a,matrix3.b,matrix3.c,matrix3.d,matrix3.tx,matrix3.ty);
	return mat;
};
lime_math__$Matrix4_Matrix4_$Impl_$.identity = function(this1) {
	this1[0] = 1;
	this1[1] = 0;
	this1[2] = 0;
	this1[3] = 0;
	this1[4] = 0;
	this1[5] = 1;
	this1[6] = 0;
	this1[7] = 0;
	this1[8] = 0;
	this1[9] = 0;
	this1[10] = 1;
	this1[11] = 0;
	this1[12] = 0;
	this1[13] = 0;
	this1[14] = 0;
	this1[15] = 1;
};
lime_math__$Matrix4_Matrix4_$Impl_$.interpolate = function(thisMat,toMat,percent,result) {
	if(result == null) {
		result = lime_math__$Matrix4_Matrix4_$Impl_$._new();
	}
	var _g = 0;
	while(_g < 16) {
		var i = _g++;
		lime_math__$Matrix4_Matrix4_$Impl_$.set(result,i,lime_math__$Matrix4_Matrix4_$Impl_$.get(thisMat,i) + (lime_math__$Matrix4_Matrix4_$Impl_$.get(toMat,i) - lime_math__$Matrix4_Matrix4_$Impl_$.get(thisMat,i)) * percent);
	}
	return result;
};
lime_math__$Matrix4_Matrix4_$Impl_$.interpolateTo = function(this1,toMat,percent) {
	var _g = 0;
	while(_g < 16) {
		var i = _g++;
		this1[i] += (lime_math__$Matrix4_Matrix4_$Impl_$.get(toMat,i) - this1[i]) * percent;
	}
};
lime_math__$Matrix4_Matrix4_$Impl_$.invert = function(this1) {
	var d = lime_math__$Matrix4_Matrix4_$Impl_$.get_determinant(this1);
	var invertable = Math.abs(d) > 0.00000000001;
	if(invertable) {
		d = 1 / d;
		var m11 = this1[0];
		var m21 = this1[4];
		var m31 = this1[8];
		var m41 = this1[12];
		var m12 = this1[1];
		var m22 = this1[5];
		var m32 = this1[9];
		var m42 = this1[13];
		var m13 = this1[2];
		var m23 = this1[6];
		var m33 = this1[10];
		var m43 = this1[14];
		var m14 = this1[3];
		var m24 = this1[7];
		var m34 = this1[11];
		var m44 = this1[15];
		this1[0] = d * (m22 * (m33 * m44 - m43 * m34) - m32 * (m23 * m44 - m43 * m24) + m42 * (m23 * m34 - m33 * m24));
		this1[1] = -d * (m12 * (m33 * m44 - m43 * m34) - m32 * (m13 * m44 - m43 * m14) + m42 * (m13 * m34 - m33 * m14));
		this1[2] = d * (m12 * (m23 * m44 - m43 * m24) - m22 * (m13 * m44 - m43 * m14) + m42 * (m13 * m24 - m23 * m14));
		this1[3] = -d * (m12 * (m23 * m34 - m33 * m24) - m22 * (m13 * m34 - m33 * m14) + m32 * (m13 * m24 - m23 * m14));
		this1[4] = -d * (m21 * (m33 * m44 - m43 * m34) - m31 * (m23 * m44 - m43 * m24) + m41 * (m23 * m34 - m33 * m24));
		this1[5] = d * (m11 * (m33 * m44 - m43 * m34) - m31 * (m13 * m44 - m43 * m14) + m41 * (m13 * m34 - m33 * m14));
		this1[6] = -d * (m11 * (m23 * m44 - m43 * m24) - m21 * (m13 * m44 - m43 * m14) + m41 * (m13 * m24 - m23 * m14));
		this1[7] = d * (m11 * (m23 * m34 - m33 * m24) - m21 * (m13 * m34 - m33 * m14) + m31 * (m13 * m24 - m23 * m14));
		this1[8] = d * (m21 * (m32 * m44 - m42 * m34) - m31 * (m22 * m44 - m42 * m24) + m41 * (m22 * m34 - m32 * m24));
		this1[9] = -d * (m11 * (m32 * m44 - m42 * m34) - m31 * (m12 * m44 - m42 * m14) + m41 * (m12 * m34 - m32 * m14));
		this1[10] = d * (m11 * (m22 * m44 - m42 * m24) - m21 * (m12 * m44 - m42 * m14) + m41 * (m12 * m24 - m22 * m14));
		this1[11] = -d * (m11 * (m22 * m34 - m32 * m24) - m21 * (m12 * m34 - m32 * m14) + m31 * (m12 * m24 - m22 * m14));
		this1[12] = -d * (m21 * (m32 * m43 - m42 * m33) - m31 * (m22 * m43 - m42 * m23) + m41 * (m22 * m33 - m32 * m23));
		this1[13] = d * (m11 * (m32 * m43 - m42 * m33) - m31 * (m12 * m43 - m42 * m13) + m41 * (m12 * m33 - m32 * m13));
		this1[14] = -d * (m11 * (m22 * m43 - m42 * m23) - m21 * (m12 * m43 - m42 * m13) + m41 * (m12 * m23 - m22 * m13));
		this1[15] = d * (m11 * (m22 * m33 - m32 * m23) - m21 * (m12 * m33 - m32 * m13) + m31 * (m12 * m23 - m22 * m13));
	}
	return invertable;
};
lime_math__$Matrix4_Matrix4_$Impl_$.pointAt = function(this1,pos,at,up) {
	if(at == null) {
		at = new lime_math_Vector4(0,0,1);
	}
	if(up == null) {
		up = new lime_math_Vector4(0,1,0);
	}
	var result = null;
	if(result == null) {
		result = new lime_math_Vector4();
	}
	result.x = pos.x - at.x;
	result.y = pos.y - at.y;
	result.z = pos.z - at.z;
	var dir = result;
	var vup = new lime_math_Vector4(up.x,up.y,up.z,up.w);
	var right;
	var l = Math.sqrt(dir.x * dir.x + dir.y * dir.y + dir.z * dir.z);
	if(l != 0) {
		dir.x /= l;
		dir.y /= l;
		dir.z /= l;
	}
	var l1 = Math.sqrt(vup.x * vup.x + vup.y * vup.y + vup.z * vup.z);
	if(l1 != 0) {
		vup.x /= l1;
		vup.y /= l1;
		vup.z /= l1;
	}
	var dir2 = new lime_math_Vector4(dir.x,dir.y,dir.z,dir.w);
	var s = vup.x * dir.x + vup.y * dir.y + vup.z * dir.z;
	dir2.x *= s;
	dir2.y *= s;
	dir2.z *= s;
	var result1 = null;
	if(result1 == null) {
		result1 = new lime_math_Vector4();
	}
	result1.x = vup.x - dir2.x;
	result1.y = vup.y - dir2.y;
	result1.z = vup.z - dir2.z;
	vup = result1;
	if(Math.sqrt(vup.x * vup.x + vup.y * vup.y + vup.z * vup.z) > 0) {
		var l2 = Math.sqrt(vup.x * vup.x + vup.y * vup.y + vup.z * vup.z);
		if(l2 != 0) {
			vup.x /= l2;
			vup.y /= l2;
			vup.z /= l2;
		}
	} else if(dir.x != 0) {
		vup = new lime_math_Vector4(-dir.y,dir.x,0);
	} else {
		vup = new lime_math_Vector4(1,0,0);
	}
	var result2 = null;
	if(result2 == null) {
		result2 = new lime_math_Vector4();
	}
	var ya = vup.z * dir.x - vup.x * dir.z;
	var za = vup.x * dir.y - vup.y * dir.x;
	result2.x = vup.y * dir.z - vup.z * dir.y;
	result2.y = ya;
	result2.z = za;
	result2.w = 1;
	right = result2;
	var l3 = Math.sqrt(right.x * right.x + right.y * right.y + right.z * right.z);
	if(l3 != 0) {
		right.x /= l3;
		right.y /= l3;
		right.z /= l3;
	}
	this1[0] = right.x;
	this1[4] = right.y;
	this1[8] = right.z;
	this1[12] = 0.0;
	this1[1] = vup.x;
	this1[5] = vup.y;
	this1[9] = vup.z;
	this1[13] = 0.0;
	this1[2] = dir.x;
	this1[6] = dir.y;
	this1[10] = dir.z;
	this1[14] = 0.0;
	this1[3] = pos.x;
	this1[7] = pos.y;
	this1[11] = pos.z;
	this1[15] = 1.0;
};
lime_math__$Matrix4_Matrix4_$Impl_$.prepend = function(this1,rhs) {
	var m111 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,0);
	var m121 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,4);
	var m131 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,8);
	var m141 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,12);
	var m112 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,1);
	var m122 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,5);
	var m132 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,9);
	var m142 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,13);
	var m113 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,2);
	var m123 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,6);
	var m133 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,10);
	var m143 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,14);
	var m114 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,3);
	var m124 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,7);
	var m134 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,11);
	var m144 = lime_math__$Matrix4_Matrix4_$Impl_$.get(rhs,15);
	var m211 = this1[0];
	var m221 = this1[4];
	var m231 = this1[8];
	var m241 = this1[12];
	var m212 = this1[1];
	var m222 = this1[5];
	var m232 = this1[9];
	var m242 = this1[13];
	var m213 = this1[2];
	var m223 = this1[6];
	var m233 = this1[10];
	var m243 = this1[14];
	var m214 = this1[3];
	var m224 = this1[7];
	var m234 = this1[11];
	var m244 = this1[15];
	this1[0] = m111 * m211 + m112 * m221 + m113 * m231 + m114 * m241;
	this1[1] = m111 * m212 + m112 * m222 + m113 * m232 + m114 * m242;
	this1[2] = m111 * m213 + m112 * m223 + m113 * m233 + m114 * m243;
	this1[3] = m111 * m214 + m112 * m224 + m113 * m234 + m114 * m244;
	this1[4] = m121 * m211 + m122 * m221 + m123 * m231 + m124 * m241;
	this1[5] = m121 * m212 + m122 * m222 + m123 * m232 + m124 * m242;
	this1[6] = m121 * m213 + m122 * m223 + m123 * m233 + m124 * m243;
	this1[7] = m121 * m214 + m122 * m224 + m123 * m234 + m124 * m244;
	this1[8] = m131 * m211 + m132 * m221 + m133 * m231 + m134 * m241;
	this1[9] = m131 * m212 + m132 * m222 + m133 * m232 + m134 * m242;
	this1[10] = m131 * m213 + m132 * m223 + m133 * m233 + m134 * m243;
	this1[11] = m131 * m214 + m132 * m224 + m133 * m234 + m134 * m244;
	this1[12] = m141 * m211 + m142 * m221 + m143 * m231 + m144 * m241;
	this1[13] = m141 * m212 + m142 * m222 + m143 * m232 + m144 * m242;
	this1[14] = m141 * m213 + m142 * m223 + m143 * m233 + m144 * m243;
	this1[15] = m141 * m214 + m142 * m224 + m143 * m234 + m144 * m244;
};
lime_math__$Matrix4_Matrix4_$Impl_$.prependRotation = function(this1,degrees,axis,pivotPoint) {
	var m = lime_math__$Matrix4_Matrix4_$Impl_$.__getAxisRotation(this1,axis.x,axis.y,axis.z,degrees);
	if(pivotPoint != null) {
		var p = pivotPoint;
		lime_math__$Matrix4_Matrix4_$Impl_$.appendTranslation(m,p.x,p.y,p.z);
	}
	lime_math__$Matrix4_Matrix4_$Impl_$.prepend(this1,m);
};
lime_math__$Matrix4_Matrix4_$Impl_$.prependScale = function(this1,xScale,yScale,zScale) {
	var array = [xScale,0.0,0.0,0.0,0.0,yScale,0.0,0.0,0.0,0.0,zScale,0.0,0.0,0.0,0.0,1.0];
	var this2;
	if(array != null) {
		this2 = new Float32Array(array);
	} else {
		this2 = null;
	}
	lime_math__$Matrix4_Matrix4_$Impl_$.prepend(this1,lime_math__$Matrix4_Matrix4_$Impl_$._new(this2));
};
lime_math__$Matrix4_Matrix4_$Impl_$.prependTranslation = function(this1,x,y,z) {
	var m = lime_math__$Matrix4_Matrix4_$Impl_$._new();
	lime_math__$Matrix4_Matrix4_$Impl_$.set_position(m,new lime_math_Vector4(x,y,z));
	lime_math__$Matrix4_Matrix4_$Impl_$.prepend(this1,m);
};
lime_math__$Matrix4_Matrix4_$Impl_$.transformVector = function(this1,v,result) {
	if(result == null) {
		result = new lime_math_Vector4();
	}
	var x = v.x;
	var y = v.y;
	var z = v.z;
	result.x = x * this1[0] + y * this1[4] + z * this1[8] + this1[12];
	result.y = x * this1[1] + y * this1[5] + z * this1[9] + this1[13];
	result.z = x * this1[2] + y * this1[6] + z * this1[10] + this1[14];
	result.w = x * this1[3] + y * this1[7] + z * this1[11] + this1[15];
	return result;
};
lime_math__$Matrix4_Matrix4_$Impl_$.transformVectors = function(this1,ain,aout) {
	var i = 0;
	var x;
	var y;
	var z;
	while(i + 3 <= ain.length) {
		x = ain[i];
		y = ain[i + 1];
		z = ain[i + 2];
		aout[i] = x * this1[0] + y * this1[4] + z * this1[8] + this1[12];
		aout[i + 1] = x * this1[1] + y * this1[5] + z * this1[9] + this1[13];
		aout[i + 2] = x * this1[2] + y * this1[6] + z * this1[10] + this1[14];
		i += 3;
	}
};
lime_math__$Matrix4_Matrix4_$Impl_$.transpose = function(this1) {
	var temp = this1[1];
	this1[1] = this1[4];
	this1[4] = temp;
	var temp1 = this1[2];
	this1[2] = this1[8];
	this1[8] = temp1;
	var temp2 = this1[3];
	this1[3] = this1[12];
	this1[12] = temp2;
	var temp3 = this1[6];
	this1[6] = this1[9];
	this1[9] = temp3;
	var temp4 = this1[7];
	this1[7] = this1[13];
	this1[13] = temp4;
	var temp5 = this1[11];
	this1[11] = this1[14];
	this1[14] = temp5;
};
lime_math__$Matrix4_Matrix4_$Impl_$.__getAxisRotation = function(this1,x,y,z,degrees) {
	var m = lime_math__$Matrix4_Matrix4_$Impl_$._new();
	var a1 = new lime_math_Vector4(x,y,z);
	var rad = -degrees * (Math.PI / 180);
	var c = Math.cos(rad);
	var s = Math.sin(rad);
	var t = 1.0 - c;
	lime_math__$Matrix4_Matrix4_$Impl_$.set(m,0,c + a1.x * a1.x * t);
	lime_math__$Matrix4_Matrix4_$Impl_$.set(m,5,c + a1.y * a1.y * t);
	lime_math__$Matrix4_Matrix4_$Impl_$.set(m,10,c + a1.z * a1.z * t);
	var tmp1 = a1.x * a1.y * t;
	var tmp2 = a1.z * s;
	lime_math__$Matrix4_Matrix4_$Impl_$.set(m,4,tmp1 + tmp2);
	lime_math__$Matrix4_Matrix4_$Impl_$.set(m,1,tmp1 - tmp2);
	tmp1 = a1.x * a1.z * t;
	tmp2 = a1.y * s;
	lime_math__$Matrix4_Matrix4_$Impl_$.set(m,8,tmp1 - tmp2);
	lime_math__$Matrix4_Matrix4_$Impl_$.set(m,2,tmp1 + tmp2);
	tmp1 = a1.y * a1.z * t;
	tmp2 = a1.x * s;
	lime_math__$Matrix4_Matrix4_$Impl_$.set(m,9,tmp1 + tmp2);
	lime_math__$Matrix4_Matrix4_$Impl_$.set(m,6,tmp1 - tmp2);
	return m;
};
lime_math__$Matrix4_Matrix4_$Impl_$.__swap = function(this1,a,b) {
	var temp = this1[a];
	this1[a] = this1[b];
	this1[b] = temp;
};
lime_math__$Matrix4_Matrix4_$Impl_$.get_determinant = function(this1) {
	return (this1[0] * this1[5] - this1[4] * this1[1]) * (this1[10] * this1[15] - this1[14] * this1[11]) - (this1[0] * this1[9] - this1[8] * this1[1]) * (this1[6] * this1[15] - this1[14] * this1[7]) + (this1[0] * this1[13] - this1[12] * this1[1]) * (this1[6] * this1[11] - this1[10] * this1[7]) + (this1[4] * this1[9] - this1[8] * this1[5]) * (this1[2] * this1[15] - this1[14] * this1[3]) - (this1[4] * this1[13] - this1[12] * this1[5]) * (this1[2] * this1[11] - this1[10] * this1[3]) + (this1[8] * this1[13] - this1[12] * this1[9]) * (this1[2] * this1[7] - this1[6] * this1[3]);
};
lime_math__$Matrix4_Matrix4_$Impl_$.get_position = function(this1) {
	return new lime_math_Vector4(this1[12],this1[13],this1[14]);
};
lime_math__$Matrix4_Matrix4_$Impl_$.set_position = function(this1,val) {
	this1[12] = val.x;
	this1[13] = val.y;
	this1[14] = val.z;
	return val;
};
lime_math__$Matrix4_Matrix4_$Impl_$.get = function(this1,index) {
	return this1[index];
};
lime_math__$Matrix4_Matrix4_$Impl_$.set = function(this1,index,value) {
	this1[index] = value;
	return value;
};
var lime_math__$RGBA_RGBA_$Impl_$ = {};
$hxClasses["lime.math._RGBA.RGBA_Impl_"] = lime_math__$RGBA_RGBA_$Impl_$;
lime_math__$RGBA_RGBA_$Impl_$.__name__ = ["lime","math","_RGBA","RGBA_Impl_"];
lime_math__$RGBA_RGBA_$Impl_$.__properties__ = {set_r:"set_r",get_r:"get_r",set_g:"set_g",get_g:"get_g",set_b:"set_b",get_b:"get_b",set_a:"set_a",get_a:"get_a"};
lime_math__$RGBA_RGBA_$Impl_$._new = function(rgba) {
	if(rgba == null) {
		rgba = 0;
	}
	var this1 = rgba;
	return this1;
};
lime_math__$RGBA_RGBA_$Impl_$.create = function(r,g,b,a) {
	var this1 = 0;
	var rgba = this1;
	rgba = (r & 255) << 24 | (g & 255) << 16 | (b & 255) << 8 | a & 255;
	return rgba;
};
lime_math__$RGBA_RGBA_$Impl_$.multiplyAlpha = function(this1) {
	if((this1 & 255) == 0) {
		if(this1 != 0) {
			this1 = 0;
		}
	} else if((this1 & 255) != 255) {
		lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[this1 & 255];
		this1 = ((this1 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | this1 & 255 & 255;
	}
};
lime_math__$RGBA_RGBA_$Impl_$.readUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	switch(format) {
	case 0:
		this1 = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		this1 = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		this1 = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied) {
		if((this1 & 255) != 0 && (this1 & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (this1 & 255);
			this1 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((this1 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((this1 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((this1 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | this1 & 255 & 255;
		}
	}
};
lime_math__$RGBA_RGBA_$Impl_$.set = function(this1,r,g,b,a) {
	this1 = (r & 255) << 24 | (g & 255) << 16 | (b & 255) << 8 | a & 255;
};
lime_math__$RGBA_RGBA_$Impl_$.unmultiplyAlpha = function(this1) {
	if((this1 & 255) != 0 && (this1 & 255) != 255) {
		lime_math__$RGBA_RGBA_$Impl_$.unmult = 255.0 / (this1 & 255);
		this1 = (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((this1 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 24 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((this1 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 16 | (lime_math__$RGBA_RGBA_$Impl_$.__clamp[Math.round((this1 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.unmult)] & 255) << 8 | this1 & 255 & 255;
	}
};
lime_math__$RGBA_RGBA_$Impl_$.writeUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	if(premultiplied) {
		if((this1 & 255) == 0) {
			if(this1 != 0) {
				this1 = 0;
			}
		} else if((this1 & 255) != 255) {
			lime_math__$RGBA_RGBA_$Impl_$.a16 = lime_math__$RGBA_RGBA_$Impl_$.__alpha16[this1 & 255];
			this1 = ((this1 >>> 24 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math__$RGBA_RGBA_$Impl_$.a16 >> 16 & 255) << 8 | this1 & 255 & 255;
		}
	}
	switch(format) {
	case 0:
		data[offset] = this1 >>> 24 & 255;
		data[offset + 1] = this1 >>> 16 & 255;
		data[offset + 2] = this1 >>> 8 & 255;
		data[offset + 3] = this1 & 255;
		break;
	case 1:
		data[offset] = this1 & 255;
		data[offset + 1] = this1 >>> 24 & 255;
		data[offset + 2] = this1 >>> 16 & 255;
		data[offset + 3] = this1 >>> 8 & 255;
		break;
	case 2:
		data[offset] = this1 >>> 8 & 255;
		data[offset + 1] = this1 >>> 16 & 255;
		data[offset + 2] = this1 >>> 24 & 255;
		data[offset + 3] = this1 & 255;
		break;
	}
};
lime_math__$RGBA_RGBA_$Impl_$.__fromARGB = function(argb) {
	var this1 = 0;
	var rgba = this1;
	rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
	return rgba;
};
lime_math__$RGBA_RGBA_$Impl_$.__fromBGRA = function(bgra) {
	var this1 = 0;
	var rgba = this1;
	rgba = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
	return rgba;
};
lime_math__$RGBA_RGBA_$Impl_$.get_a = function(this1) {
	return this1 & 255;
};
lime_math__$RGBA_RGBA_$Impl_$.set_a = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | value & 255;
	return value;
};
lime_math__$RGBA_RGBA_$Impl_$.get_b = function(this1) {
	return this1 >>> 8 & 255;
};
lime_math__$RGBA_RGBA_$Impl_$.set_b = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (value & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math__$RGBA_RGBA_$Impl_$.get_g = function(this1) {
	return this1 >>> 16 & 255;
};
lime_math__$RGBA_RGBA_$Impl_$.set_g = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (value & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math__$RGBA_RGBA_$Impl_$.get_r = function(this1) {
	return this1 >>> 24 & 255;
};
lime_math__$RGBA_RGBA_$Impl_$.set_r = function(this1,value) {
	this1 = (value & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
var lime_math_Rectangle = function(x,y,width,height) {
	if(height == null) {
		height = 0;
	}
	if(width == null) {
		width = 0;
	}
	if(y == null) {
		y = 0;
	}
	if(x == null) {
		x = 0;
	}
	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;
};
$hxClasses["lime.math.Rectangle"] = lime_math_Rectangle;
lime_math_Rectangle.__name__ = ["lime","math","Rectangle"];
lime_math_Rectangle.prototype = {
	clone: function() {
		return new lime_math_Rectangle(this.x,this.y,this.width,this.height);
	}
	,contains: function(x,y) {
		if(x >= this.x && y >= this.y && x < this.get_right()) {
			return y < this.get_bottom();
		} else {
			return false;
		}
	}
	,containsPoint: function(point) {
		return this.containsVector(point);
	}
	,containsRect: function(rect) {
		if(rect.width <= 0 || rect.height <= 0) {
			if(rect.x > this.x && rect.y > this.y && rect.get_right() < this.get_right()) {
				return rect.get_bottom() < this.get_bottom();
			} else {
				return false;
			}
		} else if(rect.x >= this.x && rect.y >= this.y && rect.get_right() <= this.get_right()) {
			return rect.get_bottom() <= this.get_bottom();
		} else {
			return false;
		}
	}
	,containsVector: function(vector) {
		return this.contains(vector.x,vector.y);
	}
	,copyFrom: function(sourceRect) {
		this.x = sourceRect.x;
		this.y = sourceRect.y;
		this.width = sourceRect.width;
		this.height = sourceRect.height;
	}
	,equals: function(toCompare) {
		if(toCompare != null && this.x == toCompare.x && this.y == toCompare.y && this.width == toCompare.width) {
			return this.height == toCompare.height;
		} else {
			return false;
		}
	}
	,inflate: function(dx,dy) {
		this.x -= dx;
		this.width += dx * 2;
		this.y -= dy;
		this.height += dy * 2;
	}
	,inflateVector: function(vector) {
		this.inflate(vector.x,vector.y);
	}
	,intersection: function(toIntersect,result) {
		if(result == null) {
			result = new lime_math_Rectangle();
		}
		var x0 = this.x < toIntersect.x ? toIntersect.x : this.x;
		var x1 = this.get_right() > toIntersect.get_right() ? toIntersect.get_right() : this.get_right();
		if(x1 <= x0) {
			result.setEmpty();
			return result;
		}
		var y0 = this.y < toIntersect.y ? toIntersect.y : this.y;
		var y1 = this.get_bottom() > toIntersect.get_bottom() ? toIntersect.get_bottom() : this.get_bottom();
		if(y1 <= y0) {
			result.setEmpty();
			return result;
		}
		result.x = x0;
		result.y = y0;
		result.width = x1 - x0;
		result.height = y1 - y0;
		return result;
	}
	,intersects: function(toIntersect) {
		var x0 = this.x < toIntersect.x ? toIntersect.x : this.x;
		var x1 = this.get_right() > toIntersect.get_right() ? toIntersect.get_right() : this.get_right();
		if(x1 <= x0) {
			return false;
		}
		var y0 = this.y < toIntersect.y ? toIntersect.y : this.y;
		var y1 = this.get_bottom() > toIntersect.get_bottom() ? toIntersect.get_bottom() : this.get_bottom();
		return y1 > y0;
	}
	,isEmpty: function() {
		if(!(this.width <= 0)) {
			return this.height <= 0;
		} else {
			return true;
		}
	}
	,offset: function(dx,dy) {
		this.x += dx;
		this.y += dy;
	}
	,offsetVector: function(vector) {
		this.x += vector.x;
		this.y += vector.y;
	}
	,setEmpty: function() {
		this.x = this.y = this.width = this.height = 0;
	}
	,setTo: function(xa,ya,widtha,heighta) {
		this.x = xa;
		this.y = ya;
		this.width = widtha;
		this.height = heighta;
	}
	,union: function(toUnion,result) {
		if(result == null) {
			result = new lime_math_Rectangle();
		}
		if(this.width == 0 || this.height == 0) {
			result.copyFrom(toUnion);
		} else if(toUnion.width == 0 || toUnion.height == 0) {
			result.copyFrom(this);
		} else {
			var x0 = this.x > toUnion.x ? toUnion.x : this.x;
			var x1 = this.get_right() < toUnion.get_right() ? toUnion.get_right() : this.get_right();
			var y0 = this.y > toUnion.y ? toUnion.y : this.y;
			var y1 = this.get_bottom() < toUnion.get_bottom() ? toUnion.get_bottom() : this.get_bottom();
			result.setTo(x0,y0,x1 - x0,y1 - y0);
		}
		return result;
	}
	,__toFlashRectangle: function() {
		return null;
	}
	,get_bottom: function() {
		return this.y + this.height;
	}
	,set_bottom: function(b) {
		this.height = b - this.y;
		return b;
	}
	,get_bottomRight: function() {
		return new lime_math_Vector2(this.x + this.width,this.y + this.height);
	}
	,set_bottomRight: function(p) {
		this.width = p.x - this.x;
		this.height = p.y - this.y;
		return p.clone();
	}
	,get_left: function() {
		return this.x;
	}
	,set_left: function(l) {
		this.width -= l - this.x;
		this.x = l;
		return l;
	}
	,get_right: function() {
		return this.x + this.width;
	}
	,set_right: function(r) {
		this.width = r - this.x;
		return r;
	}
	,get_size: function() {
		return new lime_math_Vector2(this.width,this.height);
	}
	,set_size: function(p) {
		this.width = p.x;
		this.height = p.y;
		return p.clone();
	}
	,get_top: function() {
		return this.y;
	}
	,set_top: function(t) {
		this.height -= t - this.y;
		this.y = t;
		return t;
	}
	,get_topLeft: function() {
		return new lime_math_Vector2(this.x,this.y);
	}
	,set_topLeft: function(p) {
		this.x = p.x;
		this.y = p.y;
		return p.clone();
	}
	,__class__: lime_math_Rectangle
	,__properties__: {set_topLeft:"set_topLeft",get_topLeft:"get_topLeft",set_top:"set_top",get_top:"get_top",set_size:"set_size",get_size:"get_size",set_right:"set_right",get_right:"get_right",set_left:"set_left",get_left:"get_left",set_bottomRight:"set_bottomRight",get_bottomRight:"get_bottomRight",set_bottom:"set_bottom",get_bottom:"get_bottom"}
};
var lime_math_Vector2 = function(x,y) {
	if(y == null) {
		y = 0;
	}
	if(x == null) {
		x = 0;
	}
	this.x = x;
	this.y = y;
};
$hxClasses["lime.math.Vector2"] = lime_math_Vector2;
lime_math_Vector2.__name__ = ["lime","math","Vector2"];
lime_math_Vector2.distance = function(pt1,pt2) {
	var dx = pt1.x - pt2.x;
	var dy = pt1.y - pt2.y;
	return Math.sqrt(dx * dx + dy * dy);
};
lime_math_Vector2.interpolate = function(pt1,pt2,f,result) {
	if(result == null) {
		result = new lime_math_Vector2();
	}
	result.x = pt2.x + f * (pt1.x - pt2.x);
	result.y = pt2.y + f * (pt1.y - pt2.y);
	return result;
};
lime_math_Vector2.polar = function(len,angle,result) {
	if(result == null) {
		result = new lime_math_Vector2();
	}
	var ya = len * Math.sin(angle);
	result.x = len * Math.cos(angle);
	result.y = ya;
	return result;
};
lime_math_Vector2.prototype = {
	add: function(v,result) {
		if(result == null) {
			result = new lime_math_Vector2();
		}
		result.x = v.x + this.x;
		result.y = v.y + this.y;
		return result;
	}
	,clone: function() {
		return new lime_math_Vector2(this.x,this.y);
	}
	,equals: function(toCompare) {
		if(toCompare != null && toCompare.x == this.x) {
			return toCompare.y == this.y;
		} else {
			return false;
		}
	}
	,normalize: function(thickness) {
		if(this.x == 0 && this.y == 0) {
			return;
		} else {
			var norm = thickness / Math.sqrt(this.x * this.x + this.y * this.y);
			this.x *= norm;
			this.y *= norm;
		}
	}
	,offset: function(dx,dy) {
		this.x += dx;
		this.y += dy;
	}
	,setTo: function(xa,ya) {
		this.x = xa;
		this.y = ya;
	}
	,subtract: function(v,result) {
		if(result == null) {
			result = new lime_math_Vector2();
		}
		result.x = this.x - v.x;
		result.y = this.y - v.y;
		return result;
	}
	,__toFlashPoint: function() {
		return null;
	}
	,get_length: function() {
		return Math.sqrt(this.x * this.x + this.y * this.y);
	}
	,get_lengthSquared: function() {
		return this.x * this.x + this.y * this.y;
	}
	,__class__: lime_math_Vector2
	,__properties__: {get_lengthSquared:"get_lengthSquared",get_length:"get_length"}
};
var lime_math_Vector4 = function(x,y,z,w) {
	if(w == null) {
		w = 0.;
	}
	if(z == null) {
		z = 0.;
	}
	if(y == null) {
		y = 0.;
	}
	if(x == null) {
		x = 0.;
	}
	this.w = w;
	this.x = x;
	this.y = y;
	this.z = z;
};
$hxClasses["lime.math.Vector4"] = lime_math_Vector4;
lime_math_Vector4.__name__ = ["lime","math","Vector4"];
lime_math_Vector4.__properties__ = {get_Z_AXIS:"get_Z_AXIS",get_Y_AXIS:"get_Y_AXIS",get_X_AXIS:"get_X_AXIS"};
lime_math_Vector4.angleBetween = function(a,b) {
	var a0 = new lime_math_Vector4(a.x,a.y,a.z,a.w);
	var l = Math.sqrt(a0.x * a0.x + a0.y * a0.y + a0.z * a0.z);
	if(l != 0) {
		a0.x /= l;
		a0.y /= l;
		a0.z /= l;
	}
	var b0 = new lime_math_Vector4(b.x,b.y,b.z,b.w);
	var l1 = Math.sqrt(b0.x * b0.x + b0.y * b0.y + b0.z * b0.z);
	if(l1 != 0) {
		b0.x /= l1;
		b0.y /= l1;
		b0.z /= l1;
	}
	return Math.acos(a0.x * b0.x + a0.y * b0.y + a0.z * b0.z);
};
lime_math_Vector4.distance = function(pt1,pt2) {
	var x = pt2.x - pt1.x;
	var y = pt2.y - pt1.y;
	var z = pt2.z - pt1.z;
	return Math.sqrt(x * x + y * y + z * z);
};
lime_math_Vector4.distanceSquared = function(pt1,pt2) {
	var x = pt2.x - pt1.x;
	var y = pt2.y - pt1.y;
	var z = pt2.z - pt1.z;
	return x * x + y * y + z * z;
};
lime_math_Vector4.get_X_AXIS = function() {
	return new lime_math_Vector4(1,0,0);
};
lime_math_Vector4.get_Y_AXIS = function() {
	return new lime_math_Vector4(0,1,0);
};
lime_math_Vector4.get_Z_AXIS = function() {
	return new lime_math_Vector4(0,0,1);
};
lime_math_Vector4.prototype = {
	add: function(a,result) {
		if(result == null) {
			result = new lime_math_Vector4();
		}
		result.x = this.x + a.x;
		result.y = this.y + a.y;
		result.z = this.z + a.z;
		return result;
	}
	,clone: function() {
		return new lime_math_Vector4(this.x,this.y,this.z,this.w);
	}
	,copyFrom: function(sourceVector4) {
		this.x = sourceVector4.x;
		this.y = sourceVector4.y;
		this.z = sourceVector4.z;
	}
	,crossProduct: function(a,result) {
		if(result == null) {
			result = new lime_math_Vector4();
		}
		var ya = this.z * a.x - this.x * a.z;
		var za = this.x * a.y - this.y * a.x;
		result.x = this.y * a.z - this.z * a.y;
		result.y = ya;
		result.z = za;
		result.w = 1;
		return result;
	}
	,decrementBy: function(a) {
		this.x -= a.x;
		this.y -= a.y;
		this.z -= a.z;
	}
	,dotProduct: function(a) {
		return this.x * a.x + this.y * a.y + this.z * a.z;
	}
	,equals: function(toCompare,allFour) {
		if(allFour == null) {
			allFour = false;
		}
		if(this.x == toCompare.x && this.y == toCompare.y && this.z == toCompare.z) {
			if(!(!allFour)) {
				return this.w == toCompare.w;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	,incrementBy: function(a) {
		this.x += a.x;
		this.y += a.y;
		this.z += a.z;
	}
	,nearEquals: function(toCompare,tolerance,allFour) {
		if(allFour == null) {
			allFour = false;
		}
		if(Math.abs(this.x - toCompare.x) < tolerance && Math.abs(this.y - toCompare.y) < tolerance && Math.abs(this.z - toCompare.z) < tolerance) {
			if(!(!allFour)) {
				return Math.abs(this.w - toCompare.w) < tolerance;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	,negate: function() {
		this.x *= -1;
		this.y *= -1;
		this.z *= -1;
	}
	,normalize: function() {
		var l = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
		if(l != 0) {
			this.x /= l;
			this.y /= l;
			this.z /= l;
		}
		return l;
	}
	,project: function() {
		this.x /= this.w;
		this.y /= this.w;
		this.z /= this.w;
	}
	,scaleBy: function(s) {
		this.x *= s;
		this.y *= s;
		this.z *= s;
	}
	,setTo: function(xa,ya,za) {
		this.x = xa;
		this.y = ya;
		this.z = za;
	}
	,subtract: function(a,result) {
		if(result == null) {
			result = new lime_math_Vector4();
		}
		result.x = this.x - a.x;
		result.y = this.y - a.y;
		result.z = this.z - a.z;
		return result;
	}
	,toString: function() {
		return "Vector4(" + this.x + ", " + this.y + ", " + this.z + ")";
	}
	,get_length: function() {
		return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
	}
	,get_lengthSquared: function() {
		return this.x * this.x + this.y * this.y + this.z * this.z;
	}
	,__class__: lime_math_Vector4
	,__properties__: {get_lengthSquared:"get_lengthSquared",get_length:"get_length"}
};
var lime_media_AudioBuffer = function() {
};
$hxClasses["lime.media.AudioBuffer"] = lime_media_AudioBuffer;
lime_media_AudioBuffer.__name__ = ["lime","media","AudioBuffer"];
lime_media_AudioBuffer.fromBase64 = function(base64String) {
	if(base64String == null) {
		return null;
	}
	if(base64String.indexOf(",") == -1) {
		base64String = "data:" + lime_media_AudioBuffer.__getCodec(lime__$internal_format_Base64.decode(base64String)) + ";base64," + base64String;
	}
	var audioBuffer = new lime_media_AudioBuffer();
	audioBuffer.set_src(new Howl({ src : [base64String], html5 : true, preload : false}));
	return audioBuffer;
};
lime_media_AudioBuffer.fromBytes = function(bytes) {
	if(bytes == null) {
		return null;
	}
	var audioBuffer = new lime_media_AudioBuffer();
	audioBuffer.set_src(new Howl({ src : ["data:" + lime_media_AudioBuffer.__getCodec(bytes) + ";base64," + lime__$internal_format_Base64.encode(bytes)], html5 : true, preload : false}));
	return audioBuffer;
};
lime_media_AudioBuffer.fromFile = function(path) {
	if(path == null) {
		return null;
	}
	var audioBuffer = new lime_media_AudioBuffer();
	audioBuffer.__srcHowl = new Howl({ src : [path], preload : false});
	return audioBuffer;
};
lime_media_AudioBuffer.fromFiles = function(paths) {
	var audioBuffer = new lime_media_AudioBuffer();
	audioBuffer.__srcHowl = new Howl({ src : paths, preload : false});
	return audioBuffer;
};
lime_media_AudioBuffer.fromVorbisFile = function(vorbisFile) {
	return null;
};
lime_media_AudioBuffer.loadFromFile = function(path) {
	var promise = new lime_app_Promise();
	var audioBuffer = lime_media_AudioBuffer.fromFile(path);
	if(audioBuffer != null) {
		if(audioBuffer != null) {
			audioBuffer.__srcHowl.on("load",function() {
				promise.complete(audioBuffer);
			});
			audioBuffer.__srcHowl.on("loaderror",function(id,msg) {
				promise.error(msg);
			});
			audioBuffer.__srcHowl.load();
		}
	} else {
		promise.error(null);
	}
	return promise.future;
};
lime_media_AudioBuffer.loadFromFiles = function(paths) {
	var promise = new lime_app_Promise();
	var audioBuffer = lime_media_AudioBuffer.fromFiles(paths);
	if(audioBuffer != null) {
		audioBuffer.__srcHowl.on("load",function() {
			promise.complete(audioBuffer);
		});
		audioBuffer.__srcHowl.on("loaderror",function() {
			promise.error(null);
		});
		audioBuffer.__srcHowl.load();
	} else {
		promise.error(null);
	}
	return promise.future;
};
lime_media_AudioBuffer.__getCodec = function(bytes) {
	var signature = bytes.getString(0,4);
	switch(signature) {
	case "OggS":
		return "audio/ogg";
	case "RIFF":
		if(bytes.getString(8,4) == "WAVE") {
			return "audio/wav";
		} else {
			var _g = bytes.b[2];
			var _g1 = bytes.b[1];
			var _g2 = bytes.b[0];
			switch(_g2) {
			case 73:
				if(_g1 == 68) {
					if(_g == 51) {
						return "audio/mp3";
					}
				}
				break;
			case 255:
				switch(_g1) {
				case 243:case 250:case 251:
					return "audio/mp3";
				default:
				}
				break;
			default:
			}
		}
		break;
	case "fLaC":
		return "audio/flac";
	default:
		var _g3 = bytes.b[2];
		var _g11 = bytes.b[1];
		var _g21 = bytes.b[0];
		switch(_g21) {
		case 73:
			if(_g11 == 68) {
				if(_g3 == 51) {
					return "audio/mp3";
				}
			}
			break;
		case 255:
			switch(_g11) {
			case 243:case 250:case 251:
				return "audio/mp3";
			default:
			}
			break;
		default:
		}
	}
	lime_utils_Log.error("Unsupported sound format",{ fileName : "AudioBuffer.hx", lineNumber : 362, className : "lime.media.AudioBuffer", methodName : "__getCodec"});
	return null;
};
lime_media_AudioBuffer.prototype = {
	dispose: function() {
		this.__srcHowl.unload();
	}
	,get_src: function() {
		return this.__srcHowl;
	}
	,set_src: function(value) {
		return this.__srcHowl = value;
	}
	,__class__: lime_media_AudioBuffer
	,__properties__: {set_src:"set_src",get_src:"get_src"}
};
var lime_media_AudioContext = function(type) {
	if(type != "custom") {
		if(type == null || type == "web") {
			try {
				window.AudioContext = window.AudioContext || window.webkitAudioContext;
				this.web = new window.AudioContext ();
				this.type = "web";
			} catch( e ) {
				haxe_CallStack.lastException = e;
			}
		}
		if(this.web == null && type != "web") {
			this.html5 = new lime_media_HTML5AudioContext();
			this.type = "html5";
		}
	} else {
		this.type = "custom";
	}
};
$hxClasses["lime.media.AudioContext"] = lime_media_AudioContext;
lime_media_AudioContext.__name__ = ["lime","media","AudioContext"];
lime_media_AudioContext.prototype = {
	__class__: lime_media_AudioContext
};
var lime_media_AudioManager = function() { };
$hxClasses["lime.media.AudioManager"] = lime_media_AudioManager;
lime_media_AudioManager.__name__ = ["lime","media","AudioManager"];
lime_media_AudioManager.init = function(context) {
	if(lime_media_AudioManager.context == null) {
		if(context == null) {
			lime_media_AudioManager.context = new lime_media_AudioContext();
			context = lime_media_AudioManager.context;
			if(context.type == "openal") {
				var alc = context.openal;
				var device = alc.openDevice();
				var ctx = alc.createContext(device);
				alc.makeContextCurrent(ctx);
				alc.processContext(ctx);
			}
		}
		lime_media_AudioManager.context = context;
	}
};
lime_media_AudioManager.resume = function() {
	if(lime_media_AudioManager.context != null && lime_media_AudioManager.context.type == "openal") {
		var alc = lime_media_AudioManager.context.openal;
		var currentContext = alc.getCurrentContext();
		if(currentContext != null) {
			var device = alc.getContextsDevice(currentContext);
			alc.resumeDevice(device);
			alc.processContext(currentContext);
		}
	}
};
lime_media_AudioManager.shutdown = function() {
	if(lime_media_AudioManager.context != null && lime_media_AudioManager.context.type == "openal") {
		var alc = lime_media_AudioManager.context.openal;
		var currentContext = alc.getCurrentContext();
		if(currentContext != null) {
			var device = alc.getContextsDevice(currentContext);
			alc.makeContextCurrent(null);
			alc.destroyContext(currentContext);
			if(device != null) {
				alc.closeDevice(device);
			}
		}
	}
	lime_media_AudioManager.context = null;
};
lime_media_AudioManager.suspend = function() {
	if(lime_media_AudioManager.context != null && lime_media_AudioManager.context.type == "openal") {
		var alc = lime_media_AudioManager.context.openal;
		var currentContext = alc.getCurrentContext();
		if(currentContext != null) {
			alc.suspendContext(currentContext);
			var device = alc.getContextsDevice(currentContext);
			if(device != null) {
				alc.pauseDevice(device);
			}
		}
	}
};
var lime_media_AudioSource = function(buffer,offset,length,loops) {
	if(loops == null) {
		loops = 0;
	}
	if(offset == null) {
		offset = 0;
	}
	this.onComplete = new lime_app__$Event_$Void_$Void();
	this.buffer = buffer;
	this.offset = offset;
	this.__backend = new lime__$internal_backend_html5_HTML5AudioSource(this);
	if(length != null && length != 0) {
		this.set_length(length);
	}
	this.set_loops(loops);
	if(buffer != null) {
		this.init();
	}
};
$hxClasses["lime.media.AudioSource"] = lime_media_AudioSource;
lime_media_AudioSource.__name__ = ["lime","media","AudioSource"];
lime_media_AudioSource.prototype = {
	dispose: function() {
		this.__backend.dispose();
	}
	,init: function() {
		this.__backend.init();
	}
	,play: function() {
		this.__backend.play();
	}
	,pause: function() {
		this.__backend.pause();
	}
	,stop: function() {
		this.__backend.stop();
	}
	,get_currentTime: function() {
		return this.__backend.getCurrentTime();
	}
	,set_currentTime: function(value) {
		return this.__backend.setCurrentTime(value);
	}
	,get_gain: function() {
		return this.__backend.getGain();
	}
	,set_gain: function(value) {
		return this.__backend.setGain(value);
	}
	,get_length: function() {
		return this.__backend.getLength();
	}
	,set_length: function(value) {
		return this.__backend.setLength(value);
	}
	,get_loops: function() {
		return this.__backend.getLoops();
	}
	,set_loops: function(value) {
		return this.__backend.setLoops(value);
	}
	,get_position: function() {
		return this.__backend.getPosition();
	}
	,set_position: function(value) {
		return this.__backend.setPosition(value);
	}
	,__class__: lime_media_AudioSource
	,__properties__: {set_position:"set_position",get_position:"get_position",set_loops:"set_loops",get_loops:"get_loops",set_length:"set_length",get_length:"get_length",set_gain:"set_gain",get_gain:"get_gain",set_currentTime:"set_currentTime",get_currentTime:"get_currentTime"}
};
var lime_media_FlashAudioContext = function() {
};
$hxClasses["lime.media.FlashAudioContext"] = lime_media_FlashAudioContext;
lime_media_FlashAudioContext.__name__ = ["lime","media","FlashAudioContext"];
lime_media_FlashAudioContext.prototype = {
	createBuffer: function(stream,context) {
		return null;
	}
	,getBytesLoaded: function(buffer) {
		return 0;
	}
	,getBytesTotal: function(buffer) {
		return 0;
	}
	,getID3: function(buffer) {
		return null;
	}
	,getIsBuffering: function(buffer) {
		return false;
	}
	,getIsURLInaccessible: function(buffer) {
		return false;
	}
	,getLength: function(buffer) {
		return 0;
	}
	,getURL: function(buffer) {
		return null;
	}
	,close: function(buffer) {
	}
	,extract: function(buffer,target,length,startPosition) {
		if(startPosition == null) {
			startPosition = -1;
		}
		return 0;
	}
	,load: function(buffer,stream,context) {
	}
	,loadCompressedDataFromByteArray: function(buffer,bytes,bytesLength) {
	}
	,loadPCMFromByteArray: function(buffer,bytes,samples,format,stereo,sampleRate) {
		if(sampleRate == null) {
			sampleRate = 44100;
		}
		if(stereo == null) {
			stereo = true;
		}
	}
	,play: function(buffer,startTime,loops,sndTransform) {
		if(loops == null) {
			loops = 0;
		}
		if(startTime == null) {
			startTime = 0;
		}
		return null;
	}
	,__class__: lime_media_FlashAudioContext
};
var lime_media_HTML5AudioContext = function() {
	this.NETWORK_NO_SOURCE = 3;
	this.NETWORK_LOADING = 2;
	this.NETWORK_IDLE = 1;
	this.NETWORK_EMPTY = 0;
	this.HAVE_NOTHING = 0;
	this.HAVE_METADATA = 1;
	this.HAVE_FUTURE_DATA = 3;
	this.HAVE_ENOUGH_DATA = 4;
	this.HAVE_CURRENT_DATA = 2;
};
$hxClasses["lime.media.HTML5AudioContext"] = lime_media_HTML5AudioContext;
lime_media_HTML5AudioContext.__name__ = ["lime","media","HTML5AudioContext"];
lime_media_HTML5AudioContext.prototype = {
	canPlayType: function(buffer,type) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.canPlayType(type);
		}
		return null;
	}
	,createBuffer: function(urlString) {
		var buffer = new lime_media_AudioBuffer();
		buffer.__srcAudio = new Audio();
		buffer.__srcAudio.src = urlString;
		return buffer;
	}
	,getAutoplay: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.autoplay;
		}
		return false;
	}
	,getBuffered: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.buffered;
		}
		return null;
	}
	,getCurrentSrc: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.currentSrc;
		}
		return null;
	}
	,getCurrentTime: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.currentTime;
		}
		return 0;
	}
	,getDefaultPlaybackRate: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.defaultPlaybackRate;
		}
		return 1;
	}
	,getDuration: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.duration;
		}
		return 0;
	}
	,getEnded: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.ended;
		}
		return false;
	}
	,getError: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.error;
		}
		return null;
	}
	,getLoop: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.loop;
		}
		return false;
	}
	,getMuted: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.muted;
		}
		return false;
	}
	,getNetworkState: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.networkState;
		}
		return 0;
	}
	,getPaused: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.paused;
		}
		return false;
	}
	,getPlaybackRate: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.playbackRate;
		}
		return 1;
	}
	,getPlayed: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.played;
		}
		return null;
	}
	,getPreload: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.preload;
		}
		return null;
	}
	,getReadyState: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.readyState;
		}
		return 0;
	}
	,getSeekable: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.seekable;
		}
		return null;
	}
	,getSeeking: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.seeking;
		}
		return false;
	}
	,getSrc: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.src;
		}
		return null;
	}
	,getStartTime: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.playbackRate;
		}
		return 0;
	}
	,getVolume: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.volume;
		}
		return 1;
	}
	,load: function(buffer) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.load();
		}
	}
	,pause: function(buffer) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.pause();
		}
	}
	,play: function(buffer) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.play();
		}
	}
	,setAutoplay: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.autoplay = value;
		}
	}
	,setCurrentTime: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.currentTime = value;
		}
	}
	,setDefaultPlaybackRate: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.defaultPlaybackRate = value;
		}
	}
	,setLoop: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.loop = value;
		}
	}
	,setMuted: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.muted = value;
		}
	}
	,setPlaybackRate: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.playbackRate = value;
		}
	}
	,setPreload: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.preload = value;
		}
	}
	,setSrc: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.src = value;
		}
	}
	,setVolume: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.volume = value;
		}
	}
	,__class__: lime_media_HTML5AudioContext
};
var lime_media_OpenALAudioContext = function() {
	this.ALL_DEVICES_SPECIFIER = 4115;
	this.DEFAULT_ALL_DEVICES_SPECIFIER = 4114;
	this.ENUMERATE_ALL_EXT = 1;
	this.DEVICE_SPECIFIER = 4101;
	this.DEFAULT_DEVICE_SPECIFIER = 4100;
	this.ALL_ATTRIBUTES = 4099;
	this.ATTRIBUTES_SIZE = 4098;
	this.INVALID_CONTEXT = 40962;
	this.INVALID_DEVICE = 40961;
	this.STEREO_SOURCES = 4113;
	this.MONO_SOURCES = 4112;
	this.SYNC = 4105;
	this.REFRESH = 4104;
	this.EXPONENT_DISTANCE_CLAMPED = 53254;
	this.EXPONENT_DISTANCE = 53253;
	this.LINEAR_DISTANCE_CLAMPED = 53252;
	this.LINEAR_DISTANCE = 53251;
	this.INVERSE_DISTANCE_CLAMPED = 53250;
	this.INVERSE_DISTANCE = 53249;
	this.DISTANCE_MODEL = 53248;
	this.DOPPLER_VELOCITY = 49153;
	this.SPEED_OF_SOUND = 49155;
	this.DOPPLER_FACTOR = 49152;
	this.EXTENSIONS = 45060;
	this.RENDERER = 45059;
	this.VERSION = 45058;
	this.VENDOR = 45057;
	this.OUT_OF_MEMORY = 40965;
	this.INVALID_OPERATION = 40964;
	this.INVALID_VALUE = 40963;
	this.INVALID_ENUM = 40962;
	this.INVALID_NAME = 40961;
	this.NO_ERROR = 0;
	this.SIZE = 8196;
	this.CHANNELS = 8195;
	this.BITS = 8194;
	this.FREQUENCY = 8193;
	this.FORMAT_STEREO16 = 4355;
	this.FORMAT_STEREO8 = 4354;
	this.FORMAT_MONO16 = 4353;
	this.FORMAT_MONO8 = 4352;
	this.UNDETERMINED = 4144;
	this.STREAMING = 4137;
	this.STATIC = 4136;
	this.SOURCE_TYPE = 4135;
	this.BYTE_OFFSET = 4134;
	this.SAMPLE_OFFSET = 4133;
	this.SEC_OFFSET = 4132;
	this.MAX_DISTANCE = 4131;
	this.CONE_OUTER_GAIN = 4130;
	this.ROLLOFF_FACTOR = 4129;
	this.REFERENCE_DISTANCE = 4128;
	this.BUFFERS_PROCESSED = 4118;
	this.BUFFERS_QUEUED = 4117;
	this.STOPPED = 4116;
	this.PAUSED = 4115;
	this.PLAYING = 4114;
	this.INITIAL = 4113;
	this.SOURCE_STATE = 4112;
	this.ORIENTATION = 4111;
	this.MAX_GAIN = 4110;
	this.MIN_GAIN = 4109;
	this.GAIN = 4106;
	this.BUFFER = 4105;
	this.LOOPING = 4103;
	this.VELOCITY = 4102;
	this.DIRECTION = 4101;
	this.POSITION = 4100;
	this.PITCH = 4099;
	this.CONE_OUTER_ANGLE = 4098;
	this.CONE_INNER_ANGLE = 4097;
	this.SOURCE_RELATIVE = 514;
	this.TRUE = 1;
	this.FALSE = 0;
	this.NONE = 0;
};
$hxClasses["lime.media.OpenALAudioContext"] = lime_media_OpenALAudioContext;
lime_media_OpenALAudioContext.__name__ = ["lime","media","OpenALAudioContext"];
lime_media_OpenALAudioContext.prototype = {
	bufferData: function(buffer,format,data,size,freq) {
		lime_media_openal_AL.bufferData(buffer,format,data,size,freq);
	}
	,buffer3f: function(buffer,param,value1,value2,value3) {
		lime_media_openal_AL.buffer3f(buffer,param,value1,value2,value3);
	}
	,buffer3i: function(buffer,param,value1,value2,value3) {
		lime_media_openal_AL.buffer3i(buffer,param,value1,value2,value3);
	}
	,bufferf: function(buffer,param,value) {
		lime_media_openal_AL.bufferf(buffer,param,value);
	}
	,bufferfv: function(buffer,param,values) {
		lime_media_openal_AL.bufferfv(buffer,param,values);
	}
	,bufferi: function(buffer,param,value) {
		lime_media_openal_AL.bufferi(buffer,param,value);
	}
	,bufferiv: function(buffer,param,values) {
		lime_media_openal_AL.bufferiv(buffer,param,values);
	}
	,closeDevice: function(device) {
		return lime_media_openal_ALC.closeDevice(device);
	}
	,createContext: function(device,attrlist) {
		return lime_media_openal_ALC.createContext(device,attrlist);
	}
	,createBuffer: function() {
		return lime_media_openal_AL.createBuffer();
	}
	,createSource: function() {
		return lime_media_openal_AL.createSource();
	}
	,deleteBuffer: function(buffer) {
		lime_media_openal_AL.deleteBuffer(buffer);
	}
	,deleteBuffers: function(buffers) {
		lime_media_openal_AL.deleteBuffers(buffers);
	}
	,deleteSource: function(source) {
		lime_media_openal_AL.deleteSource(source);
	}
	,deleteSources: function(sources) {
		lime_media_openal_AL.deleteSources(sources);
	}
	,destroyContext: function(context) {
		if(context == null) {
			return;
		}
		lime_media_openal_ALC.destroyContext(context);
	}
	,disable: function(capability) {
		lime_media_openal_AL.disable(capability);
	}
	,distanceModel: function(distanceModel) {
		lime_media_openal_AL.distanceModel(distanceModel);
	}
	,dopplerFactor: function(value) {
		lime_media_openal_AL.dopplerFactor(value);
	}
	,dopplerVelocity: function(value) {
		lime_media_openal_AL.dopplerVelocity(value);
	}
	,enable: function(capability) {
		lime_media_openal_AL.enable(capability);
	}
	,genSource: function() {
		return this.createSource();
	}
	,genSources: function(n) {
		return lime_media_openal_AL.genSources(n);
	}
	,genBuffer: function() {
		return this.createBuffer();
	}
	,genBuffers: function(n) {
		return lime_media_openal_AL.genBuffers(n);
	}
	,getBoolean: function(param) {
		return lime_media_openal_AL.getBoolean(param);
	}
	,getBooleanv: function(param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getBooleanv(param,count);
	}
	,getBuffer3f: function(buffer,param) {
		return lime_media_openal_AL.getBuffer3f(buffer,param);
	}
	,getBuffer3i: function(buffer,param) {
		return lime_media_openal_AL.getBuffer3i(buffer,param);
	}
	,getBufferf: function(buffer,param) {
		return lime_media_openal_AL.getBufferf(buffer,param);
	}
	,getBufferfv: function(buffer,param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getBufferfv(buffer,param,count);
	}
	,getBufferi: function(buffer,param) {
		return lime_media_openal_AL.getBufferi(buffer,param);
	}
	,getBufferiv: function(buffer,param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getBufferiv(buffer,param,count);
	}
	,getContextsDevice: function(context) {
		if(context == null) {
			return null;
		}
		return lime_media_openal_ALC.getContextsDevice(context);
	}
	,getCurrentContext: function() {
		return lime_media_openal_ALC.getCurrentContext();
	}
	,getDouble: function(param) {
		return lime_media_openal_AL.getDouble(param);
	}
	,getDoublev: function(param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getDoublev(param,count);
	}
	,getEnumValue: function(ename) {
		return lime_media_openal_AL.getEnumValue(ename);
	}
	,getError: function(device) {
		if(device == null) {
			return lime_media_openal_AL.getError();
		} else {
			return lime_media_openal_ALC.getError(device);
		}
	}
	,getErrorString: function(device) {
		if(device == null) {
			return lime_media_openal_AL.getErrorString();
		} else {
			return lime_media_openal_ALC.getErrorString(device);
		}
	}
	,getFloat: function(param) {
		return lime_media_openal_AL.getFloat(param);
	}
	,getFloatv: function(param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getFloatv(param,count);
	}
	,getInteger: function(param) {
		return lime_media_openal_AL.getInteger(param);
	}
	,getIntegerv: function(param,count,device) {
		if(count == null) {
			count = 1;
		}
		if(device == null) {
			return lime_media_openal_AL.getIntegerv(param,count);
		} else {
			return lime_media_openal_ALC.getIntegerv(device,param,count);
		}
	}
	,getListener3f: function(param) {
		return lime_media_openal_AL.getListener3f(param);
	}
	,getListener3i: function(param) {
		return lime_media_openal_AL.getListener3i(param);
	}
	,getListenerf: function(param) {
		return lime_media_openal_AL.getListenerf(param);
	}
	,getListenerfv: function(param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getListenerfv(param,count);
	}
	,getListeneri: function(param) {
		return lime_media_openal_AL.getListeneri(param);
	}
	,getListeneriv: function(param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getListeneriv(param,count);
	}
	,getProcAddress: function(fname) {
		return lime_media_openal_AL.getProcAddress(fname);
	}
	,getSource3f: function(source,param) {
		return lime_media_openal_AL.getSource3f(source,param);
	}
	,getSourcef: function(source,param) {
		return lime_media_openal_AL.getSourcef(source,param);
	}
	,getSource3i: function(source,param) {
		return lime_media_openal_AL.getSource3i(source,param);
	}
	,getSourcefv: function(source,param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getSourcefv(source,param);
	}
	,getSourcei: function(source,param) {
		return lime_media_openal_AL.getSourcei(source,param);
	}
	,getSourceiv: function(source,param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getSourceiv(source,param,count);
	}
	,getString: function(param,device) {
		if(device == null) {
			return lime_media_openal_AL.getString(param);
		} else {
			return lime_media_openal_ALC.getString(device,param);
		}
	}
	,isBuffer: function(buffer) {
		return lime_media_openal_AL.isBuffer(buffer);
	}
	,isEnabled: function(capability) {
		return lime_media_openal_AL.isEnabled(capability);
	}
	,isExtensionPresent: function(extname) {
		return lime_media_openal_AL.isExtensionPresent(extname);
	}
	,isSource: function(source) {
		return lime_media_openal_AL.isSource(source);
	}
	,listener3f: function(param,value1,value2,value3) {
		lime_media_openal_AL.listener3f(param,value1,value2,value3);
	}
	,listener3i: function(param,value1,value2,value3) {
		lime_media_openal_AL.listener3i(param,value1,value2,value3);
	}
	,listenerf: function(param,value) {
		lime_media_openal_AL.listenerf(param,value);
	}
	,listenerfv: function(param,values) {
		lime_media_openal_AL.listenerfv(param,values);
	}
	,listeneri: function(param,value) {
		lime_media_openal_AL.listeneri(param,value);
	}
	,listeneriv: function(param,values) {
		lime_media_openal_AL.listeneriv(param,values);
	}
	,makeContextCurrent: function(context) {
		return lime_media_openal_ALC.makeContextCurrent(context);
	}
	,openDevice: function(deviceName) {
		return lime_media_openal_ALC.openDevice(deviceName);
	}
	,pauseDevice: function(device) {
		lime_media_openal_ALC.pauseDevice(device);
	}
	,processContext: function(context) {
		lime_media_openal_ALC.processContext(context);
	}
	,resumeDevice: function(device) {
		lime_media_openal_ALC.resumeDevice(device);
	}
	,source3f: function(source,param,value1,value2,value3) {
		lime_media_openal_AL.source3f(source,param,value1,value2,value3);
	}
	,source3i: function(source,param,value1,value2,value3) {
		lime_media_openal_AL.source3i(source,param,value1,value2,value3);
	}
	,sourcef: function(source,param,value) {
		lime_media_openal_AL.sourcef(source,param,value);
	}
	,sourcefv: function(source,param,values) {
		lime_media_openal_AL.sourcefv(source,param,values);
	}
	,sourcei: function(source,param,value) {
		lime_media_openal_AL.sourcei(source,param,value);
	}
	,sourceiv: function(source,param,values) {
		lime_media_openal_AL.sourceiv(source,param,values);
	}
	,sourcePlay: function(source) {
		lime_media_openal_AL.sourcePlay(source);
	}
	,sourcePlayv: function(sources) {
		lime_media_openal_AL.sourcePlayv(sources);
	}
	,sourceStop: function(source) {
		lime_media_openal_AL.sourceStop(source);
	}
	,sourceStopv: function(sources) {
		lime_media_openal_AL.sourceStopv(sources);
	}
	,sourceRewind: function(source) {
		lime_media_openal_AL.sourceRewind(source);
	}
	,sourceRewindv: function(sources) {
		lime_media_openal_AL.sourceRewindv(sources);
	}
	,sourcePause: function(source) {
		lime_media_openal_AL.sourcePause(source);
	}
	,sourcePausev: function(sources) {
		lime_media_openal_AL.sourcePausev(sources);
	}
	,sourceQueueBuffer: function(source,buffer) {
		lime_media_openal_AL.sourceQueueBuffer(source,buffer);
	}
	,sourceQueueBuffers: function(source,nb,buffers) {
		lime_media_openal_AL.sourceQueueBuffers(source,nb,buffers);
	}
	,sourceUnqueueBuffer: function(source) {
		return lime_media_openal_AL.sourceUnqueueBuffer(source);
	}
	,sourceUnqueueBuffers: function(source,nb) {
		return lime_media_openal_AL.sourceUnqueueBuffers(source,nb);
	}
	,speedOfSound: function(value) {
		lime_media_openal_AL.speedOfSound(value);
	}
	,suspendContext: function(context) {
		lime_media_openal_ALC.suspendContext(context);
	}
	,__class__: lime_media_OpenALAudioContext
};
var lime_media_openal_AL = function() { };
$hxClasses["lime.media.openal.AL"] = lime_media_openal_AL;
lime_media_openal_AL.__name__ = ["lime","media","openal","AL"];
lime_media_openal_AL.removeDirectFilter = function(source) {
};
lime_media_openal_AL.removeSend = function(source,index) {
};
lime_media_openal_AL.auxf = function(aux,param,value) {
};
lime_media_openal_AL.auxfv = function(aux,param,values) {
};
lime_media_openal_AL.auxi = function(aux,param,value) {
};
lime_media_openal_AL.auxiv = function(aux,param,values) {
};
lime_media_openal_AL.bufferData = function(buffer,format,data,size,freq) {
};
lime_media_openal_AL.buffer3f = function(buffer,param,value1,value2,value3) {
};
lime_media_openal_AL.buffer3i = function(buffer,param,value1,value2,value3) {
};
lime_media_openal_AL.bufferf = function(buffer,param,value) {
};
lime_media_openal_AL.bufferfv = function(buffer,param,values) {
};
lime_media_openal_AL.bufferi = function(buffer,param,value) {
};
lime_media_openal_AL.bufferiv = function(buffer,param,values) {
};
lime_media_openal_AL.createAux = function() {
	return null;
};
lime_media_openal_AL.createBuffer = function() {
	return null;
};
lime_media_openal_AL.createEffect = function() {
	return null;
};
lime_media_openal_AL.createFilter = function() {
	return null;
};
lime_media_openal_AL.createSource = function() {
	return null;
};
lime_media_openal_AL.deleteBuffer = function(buffer) {
};
lime_media_openal_AL.deleteBuffers = function(buffers) {
};
lime_media_openal_AL.deleteSource = function(source) {
};
lime_media_openal_AL.deleteSources = function(sources) {
};
lime_media_openal_AL.disable = function(capability) {
};
lime_media_openal_AL.distanceModel = function(distanceModel) {
};
lime_media_openal_AL.dopplerFactor = function(value) {
};
lime_media_openal_AL.dopplerVelocity = function(value) {
};
lime_media_openal_AL.effectf = function(effect,param,value) {
};
lime_media_openal_AL.effectfv = function(effect,param,values) {
};
lime_media_openal_AL.effecti = function(effect,param,value) {
};
lime_media_openal_AL.effectiv = function(effect,param,values) {
};
lime_media_openal_AL.enable = function(capability) {
};
lime_media_openal_AL.genSource = function() {
	return null;
};
lime_media_openal_AL.genSources = function(n) {
	return null;
};
lime_media_openal_AL.genBuffer = function() {
	return null;
};
lime_media_openal_AL.genBuffers = function(n) {
	return null;
};
lime_media_openal_AL.getBoolean = function(param) {
	return false;
};
lime_media_openal_AL.getBooleanv = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getBuffer3f = function(buffer,param) {
	return null;
};
lime_media_openal_AL.getBuffer3i = function(buffer,param) {
	return null;
};
lime_media_openal_AL.getBufferf = function(buffer,param) {
	return 0;
};
lime_media_openal_AL.getBufferfv = function(buffer,param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getBufferi = function(buffer,param) {
	return 0;
};
lime_media_openal_AL.getBufferiv = function(buffer,param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getDouble = function(param) {
	return 0;
};
lime_media_openal_AL.getDoublev = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getEnumValue = function(ename) {
	return 0;
};
lime_media_openal_AL.getError = function() {
	return 0;
};
lime_media_openal_AL.getErrorString = function() {
	var _g = lime_media_openal_AL.getError();
	switch(_g) {
	case 40961:
		return "INVALID_NAME: Invalid parameter name";
	case 40962:
		return "INVALID_ENUM: Invalid enum value";
	case 40963:
		return "INVALID_VALUE: Invalid parameter value";
	case 40964:
		return "INVALID_OPERATION: Illegal operation or call";
	case 40965:
		return "OUT_OF_MEMORY: OpenAL has run out of memory";
	default:
		return "";
	}
};
lime_media_openal_AL.getFilteri = function(filter,param) {
	return 0;
};
lime_media_openal_AL.getFloat = function(param) {
	return 0;
};
lime_media_openal_AL.getFloatv = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getInteger = function(param) {
	return 0;
};
lime_media_openal_AL.getIntegerv = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getListener3f = function(param) {
	return null;
};
lime_media_openal_AL.getListener3i = function(param) {
	return null;
};
lime_media_openal_AL.getListenerf = function(param) {
	return 0;
};
lime_media_openal_AL.getListenerfv = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getListeneri = function(param) {
	return 0;
};
lime_media_openal_AL.getListeneriv = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getParameter = function(param) {
	return null;
};
lime_media_openal_AL.getProcAddress = function(fname) {
	return null;
};
lime_media_openal_AL.getSource3f = function(source,param) {
	return null;
};
lime_media_openal_AL.getSourcef = function(source,param) {
	return 0;
};
lime_media_openal_AL.getSource3i = function(source,param) {
	return null;
};
lime_media_openal_AL.getSourcefv = function(source,param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getSourcei = function(source,param) {
	return 0;
};
lime_media_openal_AL.getSourceiv = function(source,param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getString = function(param) {
	return null;
};
lime_media_openal_AL.isBuffer = function(buffer) {
	return false;
};
lime_media_openal_AL.isEnabled = function(capability) {
	return false;
};
lime_media_openal_AL.isExtensionPresent = function(extname) {
	return false;
};
lime_media_openal_AL.isAux = function(aux) {
	return false;
};
lime_media_openal_AL.isEffect = function(effect) {
	return false;
};
lime_media_openal_AL.isFilter = function(filter) {
	return false;
};
lime_media_openal_AL.isSource = function(source) {
	return false;
};
lime_media_openal_AL.listener3f = function(param,value1,value2,value3) {
};
lime_media_openal_AL.listener3i = function(param,value1,value2,value3) {
};
lime_media_openal_AL.listenerf = function(param,value) {
};
lime_media_openal_AL.listenerfv = function(param,values) {
};
lime_media_openal_AL.listeneri = function(param,value) {
};
lime_media_openal_AL.listeneriv = function(param,values) {
};
lime_media_openal_AL.source3f = function(source,param,value1,value2,value3) {
};
lime_media_openal_AL.source3i = function(source,param,value1,value2,value3) {
};
lime_media_openal_AL.sourcef = function(source,param,value) {
};
lime_media_openal_AL.sourcefv = function(source,param,values) {
};
lime_media_openal_AL.sourcei = function(source,param,value) {
};
lime_media_openal_AL.filteri = function(filter,param,value) {
};
lime_media_openal_AL.filterf = function(filter,param,value) {
};
lime_media_openal_AL.sourceiv = function(source,param,values) {
};
lime_media_openal_AL.sourcePlay = function(source) {
};
lime_media_openal_AL.sourcePlayv = function(sources) {
};
lime_media_openal_AL.sourceStop = function(source) {
};
lime_media_openal_AL.sourceStopv = function(sources) {
};
lime_media_openal_AL.sourceRewind = function(source) {
};
lime_media_openal_AL.sourceRewindv = function(sources) {
};
lime_media_openal_AL.sourcePause = function(source) {
};
lime_media_openal_AL.sourcePausev = function(sources) {
};
lime_media_openal_AL.sourceQueueBuffer = function(source,buffer) {
};
lime_media_openal_AL.sourceQueueBuffers = function(source,nb,buffers) {
};
lime_media_openal_AL.sourceUnqueueBuffer = function(source) {
	return 0;
};
lime_media_openal_AL.sourceUnqueueBuffers = function(source,nb) {
	return null;
};
lime_media_openal_AL.speedOfSound = function(value) {
};
var lime_media_openal__$ALAuxiliaryEffectSlot_ALAuxiliaryEffectSlot_$Impl_$ = {};
$hxClasses["lime.media.openal._ALAuxiliaryEffectSlot.ALAuxiliaryEffectSlot_Impl_"] = lime_media_openal__$ALAuxiliaryEffectSlot_ALAuxiliaryEffectSlot_$Impl_$;
lime_media_openal__$ALAuxiliaryEffectSlot_ALAuxiliaryEffectSlot_$Impl_$.__name__ = ["lime","media","openal","_ALAuxiliaryEffectSlot","ALAuxiliaryEffectSlot_Impl_"];
lime_media_openal__$ALAuxiliaryEffectSlot_ALAuxiliaryEffectSlot_$Impl_$._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal__$ALBuffer_ALBuffer_$Impl_$ = {};
$hxClasses["lime.media.openal._ALBuffer.ALBuffer_Impl_"] = lime_media_openal__$ALBuffer_ALBuffer_$Impl_$;
lime_media_openal__$ALBuffer_ALBuffer_$Impl_$.__name__ = ["lime","media","openal","_ALBuffer","ALBuffer_Impl_"];
lime_media_openal__$ALBuffer_ALBuffer_$Impl_$._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal_ALC = function() { };
$hxClasses["lime.media.openal.ALC"] = lime_media_openal_ALC;
lime_media_openal_ALC.__name__ = ["lime","media","openal","ALC"];
lime_media_openal_ALC.closeDevice = function(device) {
	return false;
};
lime_media_openal_ALC.createContext = function(device,attrlist) {
	return null;
};
lime_media_openal_ALC.destroyContext = function(context) {
};
lime_media_openal_ALC.getContextsDevice = function(context) {
	return null;
};
lime_media_openal_ALC.getCurrentContext = function() {
	return null;
};
lime_media_openal_ALC.getError = function(device) {
	return 0;
};
lime_media_openal_ALC.getErrorString = function(device) {
	var _g = lime_media_openal_ALC.getError(device);
	switch(_g) {
	case 40961:
		return "INVALID_DEVICE: Invalid device (or no device?)";
	case 40962:
		return "INVALID_CONTEXT: Invalid context (or no context?)";
	case 40963:
		return "INVALID_ENUM: Invalid enum value";
	case 40964:
		return "INVALID_VALUE: Invalid param value";
	case 40965:
		return "OUT_OF_MEMORY: OpenAL has run out of memory";
	default:
		return "";
	}
};
lime_media_openal_ALC.getIntegerv = function(device,param,size) {
	return null;
};
lime_media_openal_ALC.getString = function(device,param) {
	return null;
};
lime_media_openal_ALC.makeContextCurrent = function(context) {
	return false;
};
lime_media_openal_ALC.openDevice = function(deviceName) {
	return null;
};
lime_media_openal_ALC.pauseDevice = function(device) {
};
lime_media_openal_ALC.processContext = function(context) {
};
lime_media_openal_ALC.resumeDevice = function(device) {
};
lime_media_openal_ALC.suspendContext = function(context) {
};
var lime_media_openal__$ALContext_ALContext_$Impl_$ = {};
$hxClasses["lime.media.openal._ALContext.ALContext_Impl_"] = lime_media_openal__$ALContext_ALContext_$Impl_$;
lime_media_openal__$ALContext_ALContext_$Impl_$.__name__ = ["lime","media","openal","_ALContext","ALContext_Impl_"];
lime_media_openal__$ALContext_ALContext_$Impl_$._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal__$ALDevice_ALDevice_$Impl_$ = {};
$hxClasses["lime.media.openal._ALDevice.ALDevice_Impl_"] = lime_media_openal__$ALDevice_ALDevice_$Impl_$;
lime_media_openal__$ALDevice_ALDevice_$Impl_$.__name__ = ["lime","media","openal","_ALDevice","ALDevice_Impl_"];
lime_media_openal__$ALDevice_ALDevice_$Impl_$._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal__$ALEffect_ALEffect_$Impl_$ = {};
$hxClasses["lime.media.openal._ALEffect.ALEffect_Impl_"] = lime_media_openal__$ALEffect_ALEffect_$Impl_$;
lime_media_openal__$ALEffect_ALEffect_$Impl_$.__name__ = ["lime","media","openal","_ALEffect","ALEffect_Impl_"];
lime_media_openal__$ALEffect_ALEffect_$Impl_$._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal__$ALFilter_ALFilter_$Impl_$ = {};
$hxClasses["lime.media.openal._ALFilter.ALFilter_Impl_"] = lime_media_openal__$ALFilter_ALFilter_$Impl_$;
lime_media_openal__$ALFilter_ALFilter_$Impl_$.__name__ = ["lime","media","openal","_ALFilter","ALFilter_Impl_"];
lime_media_openal__$ALFilter_ALFilter_$Impl_$._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal__$ALSource_ALSource_$Impl_$ = {};
$hxClasses["lime.media.openal._ALSource.ALSource_Impl_"] = lime_media_openal__$ALSource_ALSource_$Impl_$;
lime_media_openal__$ALSource_ALSource_$Impl_$.__name__ = ["lime","media","openal","_ALSource","ALSource_Impl_"];
lime_media_openal__$ALSource_ALSource_$Impl_$._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_vorbis_VorbisComment = function() {
};
$hxClasses["lime.media.vorbis.VorbisComment"] = lime_media_vorbis_VorbisComment;
lime_media_vorbis_VorbisComment.__name__ = ["lime","media","vorbis","VorbisComment"];
lime_media_vorbis_VorbisComment.prototype = {
	__class__: lime_media_vorbis_VorbisComment
};
var lime_media_vorbis_VorbisFile = function(handle) {
	this.handle = handle;
};
$hxClasses["lime.media.vorbis.VorbisFile"] = lime_media_vorbis_VorbisFile;
lime_media_vorbis_VorbisFile.__name__ = ["lime","media","vorbis","VorbisFile"];
lime_media_vorbis_VorbisFile.fromBytes = function(bytes) {
	return null;
};
lime_media_vorbis_VorbisFile.fromFile = function(path) {
	return null;
};
lime_media_vorbis_VorbisFile.prototype = {
	bitrate: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		return 0;
	}
	,bitrateInstant: function() {
		return 0;
	}
	,clear: function() {
	}
	,comment: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		return null;
	}
	,crosslap: function(other) {
		return 0;
	}
	,info: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		return null;
	}
	,pcmSeek: function(pos) {
		return 0;
	}
	,pcmSeekLap: function(pos) {
		return 0;
	}
	,pcmSeekPage: function(pos) {
		return 0;
	}
	,pcmSeekPageLap: function(pos) {
		return 0;
	}
	,pcmTell: function() {
		var this1 = new haxe__$Int64__$_$_$Int64(0,0);
		return this1;
	}
	,pcmTotal: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		var this1 = new haxe__$Int64__$_$_$Int64(0,0);
		return this1;
	}
	,rawSeek: function(pos) {
		return 0;
	}
	,rawSeekLap: function(pos) {
		return 0;
	}
	,rawTell: function() {
		var this1 = new haxe__$Int64__$_$_$Int64(0,0);
		return this1;
	}
	,rawTotal: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		var this1 = new haxe__$Int64__$_$_$Int64(0,0);
		return this1;
	}
	,read: function(buffer,position,length,bigEndianPacking,wordSize,signed) {
		if(signed == null) {
			signed = true;
		}
		if(wordSize == null) {
			wordSize = 2;
		}
		if(bigEndianPacking == null) {
			bigEndianPacking = false;
		}
		if(length == null) {
			length = 4096;
		}
		return 0;
	}
	,readFloat: function(pcmChannels,samples) {
		return 0;
	}
	,seekable: function() {
		return false;
	}
	,serialNumber: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		return 0;
	}
	,streams: function() {
		return 0;
	}
	,timeSeek: function(s) {
		return 0;
	}
	,timeSeekLap: function(s) {
		return 0;
	}
	,timeSeekPage: function(s) {
		return 0;
	}
	,timeSeekPageLap: function(s) {
		return 0;
	}
	,timeTell: function() {
		return 0;
	}
	,timeTotal: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		return 0;
	}
	,__class__: lime_media_vorbis_VorbisFile
};
var lime_media_vorbis_VorbisInfo = function() {
};
$hxClasses["lime.media.vorbis.VorbisInfo"] = lime_media_vorbis_VorbisInfo;
lime_media_vorbis_VorbisInfo.__name__ = ["lime","media","vorbis","VorbisInfo"];
lime_media_vorbis_VorbisInfo.prototype = {
	__class__: lime_media_vorbis_VorbisInfo
};
var lime_net__$IHTTPRequest = function() { };
$hxClasses["lime.net._IHTTPRequest"] = lime_net__$IHTTPRequest;
lime_net__$IHTTPRequest.__name__ = ["lime","net","_IHTTPRequest"];
lime_net__$IHTTPRequest.prototype = {
	__class__: lime_net__$IHTTPRequest
};
var lime_net__$HTTPRequest_AbstractHTTPRequest = function(uri) {
	this.uri = uri;
	this.contentType = "application/x-www-form-urlencoded";
	this.followRedirects = true;
	this.enableResponseHeaders = false;
	this.formData = new haxe_ds_StringMap();
	this.headers = [];
	this.method = "GET";
	this.timeout = 30000;
	this.withCredentials = false;
	this.__backend = new lime__$internal_backend_html5_HTML5HTTPRequest();
	this.__backend.init(this);
};
$hxClasses["lime.net._HTTPRequest.AbstractHTTPRequest"] = lime_net__$HTTPRequest_AbstractHTTPRequest;
lime_net__$HTTPRequest_AbstractHTTPRequest.__name__ = ["lime","net","_HTTPRequest","AbstractHTTPRequest"];
lime_net__$HTTPRequest_AbstractHTTPRequest.__interfaces__ = [lime_net__$IHTTPRequest];
lime_net__$HTTPRequest_AbstractHTTPRequest.prototype = {
	cancel: function() {
		this.__backend.cancel();
	}
	,load: function(uri) {
		return null;
	}
	,__class__: lime_net__$HTTPRequest_AbstractHTTPRequest
};
var lime_net_HTTPRequest = function(uri) {
	lime_net__$HTTPRequest_AbstractHTTPRequest.call(this,uri);
};
$hxClasses["lime.net.HTTPRequest"] = lime_net_HTTPRequest;
lime_net_HTTPRequest.__name__ = ["lime","net","HTTPRequest"];
lime_net_HTTPRequest.__super__ = lime_net__$HTTPRequest_AbstractHTTPRequest;
lime_net_HTTPRequest.prototype = $extend(lime_net__$HTTPRequest_AbstractHTTPRequest.prototype,{
	__class__: lime_net_HTTPRequest
});
var lime_net__$HTTPRequest_$Bytes = function(uri) {
	lime_net__$HTTPRequest_AbstractHTTPRequest.call(this,uri);
};
$hxClasses["lime.net._HTTPRequest_Bytes"] = lime_net__$HTTPRequest_$Bytes;
lime_net__$HTTPRequest_$Bytes.__name__ = ["lime","net","_HTTPRequest_Bytes"];
lime_net__$HTTPRequest_$Bytes.__super__ = lime_net__$HTTPRequest_AbstractHTTPRequest;
lime_net__$HTTPRequest_$Bytes.prototype = $extend(lime_net__$HTTPRequest_AbstractHTTPRequest.prototype,{
	fromBytes: function(bytes) {
		return bytes;
	}
	,load: function(uri) {
		var _gthis = this;
		if(uri != null) {
			this.uri = uri;
		}
		var promise = new lime_app_Promise();
		var future = this.__backend.loadData(this.uri);
		future.onProgress($bind(promise,promise.progress));
		future.onError($bind(promise,promise.error));
		future.onComplete(function(bytes) {
			_gthis.responseData = _gthis.fromBytes(bytes);
			promise.complete(_gthis.responseData);
		});
		return promise.future;
	}
	,__class__: lime_net__$HTTPRequest_$Bytes
});
var lime_net__$HTTPRequest_$String = function(uri) {
	lime_net__$HTTPRequest_AbstractHTTPRequest.call(this,uri);
};
$hxClasses["lime.net._HTTPRequest_String"] = lime_net__$HTTPRequest_$String;
lime_net__$HTTPRequest_$String.__name__ = ["lime","net","_HTTPRequest_String"];
lime_net__$HTTPRequest_$String.__super__ = lime_net__$HTTPRequest_AbstractHTTPRequest;
lime_net__$HTTPRequest_$String.prototype = $extend(lime_net__$HTTPRequest_AbstractHTTPRequest.prototype,{
	load: function(uri) {
		var _gthis = this;
		if(uri != null) {
			this.uri = uri;
		}
		var promise = new lime_app_Promise();
		var future = this.__backend.loadText(this.uri);
		future.onProgress($bind(promise,promise.progress));
		future.onError($bind(promise,promise.error));
		future.onComplete(function(text) {
			_gthis.responseData = text;
			promise.complete(_gthis.responseData);
		});
		return promise.future;
	}
	,__class__: lime_net__$HTTPRequest_$String
});
var lime_net_HTTPRequestHeader = function(name,value) {
	if(value == null) {
		value = "";
	}
	this.name = name;
	this.value = value;
};
$hxClasses["lime.net.HTTPRequestHeader"] = lime_net_HTTPRequestHeader;
lime_net_HTTPRequestHeader.__name__ = ["lime","net","HTTPRequestHeader"];
lime_net_HTTPRequestHeader.prototype = {
	__class__: lime_net_HTTPRequestHeader
};
var lime_net__$HTTPRequest_$lime_$text_$Font = function(uri) {
	lime_net__$HTTPRequest_$Bytes.call(this,uri);
};
$hxClasses["lime.net._HTTPRequest_lime_text_Font"] = lime_net__$HTTPRequest_$lime_$text_$Font;
lime_net__$HTTPRequest_$lime_$text_$Font.__name__ = ["lime","net","_HTTPRequest_lime_text_Font"];
lime_net__$HTTPRequest_$lime_$text_$Font.__super__ = lime_net__$HTTPRequest_$Bytes;
lime_net__$HTTPRequest_$lime_$text_$Font.prototype = $extend(lime_net__$HTTPRequest_$Bytes.prototype,{
	fromBytes: function(bytes) {
		return lime_text_Font.fromBytes(bytes);
	}
	,__class__: lime_net__$HTTPRequest_$lime_$text_$Font
});
var lime_net__$HTTPRequest_$lime_$utils_$Bytes = function(uri) {
	lime_net__$HTTPRequest_$Bytes.call(this,uri);
};
$hxClasses["lime.net._HTTPRequest_lime_utils_Bytes"] = lime_net__$HTTPRequest_$lime_$utils_$Bytes;
lime_net__$HTTPRequest_$lime_$utils_$Bytes.__name__ = ["lime","net","_HTTPRequest_lime_utils_Bytes"];
lime_net__$HTTPRequest_$lime_$utils_$Bytes.__super__ = lime_net__$HTTPRequest_$Bytes;
lime_net__$HTTPRequest_$lime_$utils_$Bytes.prototype = $extend(lime_net__$HTTPRequest_$Bytes.prototype,{
	fromBytes: function(bytes) {
		return lime_utils__$Bytes_Bytes_$Impl_$.fromBytes(bytes);
	}
	,__class__: lime_net__$HTTPRequest_$lime_$utils_$Bytes
});
var lime_net__$HTTPRequest_$openfl_$utils_$ByteArray = function(uri) {
	lime_net__$HTTPRequest_$Bytes.call(this,uri);
};
$hxClasses["lime.net._HTTPRequest_openfl_utils_ByteArray"] = lime_net__$HTTPRequest_$openfl_$utils_$ByteArray;
lime_net__$HTTPRequest_$openfl_$utils_$ByteArray.__name__ = ["lime","net","_HTTPRequest_openfl_utils_ByteArray"];
lime_net__$HTTPRequest_$openfl_$utils_$ByteArray.__super__ = lime_net__$HTTPRequest_$Bytes;
lime_net__$HTTPRequest_$openfl_$utils_$ByteArray.prototype = $extend(lime_net__$HTTPRequest_$Bytes.prototype,{
	fromBytes: function(bytes) {
		return openfl_utils__$ByteArray_ByteArray_$Impl_$.fromBytes(bytes);
	}
	,__class__: lime_net__$HTTPRequest_$openfl_$utils_$ByteArray
});
var lime_system_CFFI = function() { };
$hxClasses["lime.system.CFFI"] = lime_system_CFFI;
lime_system_CFFI.__name__ = ["lime","system","CFFI"];
lime_system_CFFI.load = function(library,method,args,lazy) {
	if(lazy == null) {
		lazy = false;
	}
	if(args == null) {
		args = 0;
	}
	if(!lime_system_CFFI.enabled) {
		return Reflect.makeVarArgs(function(__) {
			return { };
		});
	}
	var result = null;
	return result;
};
lime_system_CFFI.__findHaxelib = function(library) {
	return "";
};
lime_system_CFFI.__loaderTrace = function(message) {
};
lime_system_CFFI.__sysName = function() {
	return null;
};
lime_system_CFFI.__tryLoad = function(name,library,func,args) {
	return null;
};
var lime_system__$CFFIPointer_CFFIPointer_$Impl_$ = {};
$hxClasses["lime.system._CFFIPointer.CFFIPointer_Impl_"] = lime_system__$CFFIPointer_CFFIPointer_$Impl_$;
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.__name__ = ["lime","system","_CFFIPointer","CFFIPointer_Impl_"];
lime_system__$CFFIPointer_CFFIPointer_$Impl_$._new = function(handle) {
	var this1 = handle;
	return this1;
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get = function(this1) {
	var tmp = this1 != null;
	return 0;
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.equals = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) == b;
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.equalsPointer = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) == lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(b);
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.greaterThan = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) > b;
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.greaterThanPointer = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) > lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(b);
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.greaterThanOrEqual = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) >= b;
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.greaterThanOrEqualPointer = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) >= lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(b);
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.lessThan = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) < b;
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.lessThanPointer = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) < lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(b);
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.lessThanOrEqual = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) <= b;
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.lessThanOrEqualPointer = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) <= lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(b);
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.notEquals = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) != b;
};
lime_system__$CFFIPointer_CFFIPointer_$Impl_$.notEqualsPointer = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) != lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(b);
};
var lime_system_Clipboard = function() { };
$hxClasses["lime.system.Clipboard"] = lime_system_Clipboard;
lime_system_Clipboard.__name__ = ["lime","system","Clipboard"];
lime_system_Clipboard.__properties__ = {set_text:"set_text",get_text:"get_text"};
lime_system_Clipboard.__update = function() {
	var cacheText = lime_system_Clipboard._text;
	lime_system_Clipboard._text = null;
	if(lime_system_Clipboard._text != cacheText) {
		lime_system_Clipboard.onUpdate.dispatch();
	}
};
lime_system_Clipboard.get_text = function() {
	lime_system_Clipboard.__update();
	return lime_system_Clipboard._text;
};
lime_system_Clipboard.set_text = function(value) {
	var cacheText = lime_system_Clipboard._text;
	lime_system_Clipboard._text = value;
	var $window = lime_app_Application.current.__window;
	if($window != null) {
		$window.__backend.setClipboard(value);
	}
	if(lime_system_Clipboard._text != cacheText) {
		lime_system_Clipboard.onUpdate.dispatch();
	}
	return value;
};
var lime_system_Display = function() {
};
$hxClasses["lime.system.Display"] = lime_system_Display;
lime_system_Display.__name__ = ["lime","system","Display"];
lime_system_Display.prototype = {
	__class__: lime_system_Display
};
var lime_system_DisplayMode = function(width,height,refreshRate,pixelFormat) {
	this.width = width;
	this.height = height;
	this.refreshRate = refreshRate;
	this.pixelFormat = pixelFormat;
};
$hxClasses["lime.system.DisplayMode"] = lime_system_DisplayMode;
lime_system_DisplayMode.__name__ = ["lime","system","DisplayMode"];
lime_system_DisplayMode.prototype = {
	__class__: lime_system_DisplayMode
};
var lime_system_Endian = $hxClasses["lime.system.Endian"] = { __ename__ : ["lime","system","Endian"], __constructs__ : ["LITTLE_ENDIAN","BIG_ENDIAN"] };
lime_system_Endian.LITTLE_ENDIAN = ["LITTLE_ENDIAN",0];
lime_system_Endian.LITTLE_ENDIAN.toString = $estr;
lime_system_Endian.LITTLE_ENDIAN.__enum__ = lime_system_Endian;
lime_system_Endian.BIG_ENDIAN = ["BIG_ENDIAN",1];
lime_system_Endian.BIG_ENDIAN.toString = $estr;
lime_system_Endian.BIG_ENDIAN.__enum__ = lime_system_Endian;
var lime_system_JNI = function() { };
$hxClasses["lime.system.JNI"] = lime_system_JNI;
lime_system_JNI.__name__ = ["lime","system","JNI"];
lime_system_JNI.callMember = function(method,jobject,a) {
	var _g = a.length;
	switch(_g) {
	case 0:
		return method(jobject);
	case 1:
		return method(jobject,a[0]);
	case 2:
		return method(jobject,a[0],a[1]);
	case 3:
		return method(jobject,a[0],a[1],a[2]);
	case 4:
		return method(jobject,a[0],a[1],a[2],a[3]);
	case 5:
		return method(jobject,a[0],a[1],a[2],a[3],a[4]);
	case 6:
		return method(jobject,a[0],a[1],a[2],a[3],a[4],a[5]);
	case 7:
		return method(jobject,a[0],a[1],a[2],a[3],a[4],a[5],a[6]);
	default:
		return null;
	}
};
lime_system_JNI.callStatic = function(method,a) {
	var _g = a.length;
	switch(_g) {
	case 0:
		return method();
	case 1:
		return method(a[0]);
	case 2:
		return method(a[0],a[1]);
	case 3:
		return method(a[0],a[1],a[2]);
	case 4:
		return method(a[0],a[1],a[2],a[3]);
	case 5:
		return method(a[0],a[1],a[2],a[3],a[4]);
	case 6:
		return method(a[0],a[1],a[2],a[3],a[4],a[5]);
	case 7:
		return method(a[0],a[1],a[2],a[3],a[4],a[5],a[6]);
	default:
		return null;
	}
};
lime_system_JNI.createMemberField = function(className,memberName,signature) {
	lime_system_JNI.init();
	return null;
};
lime_system_JNI.createMemberMethod = function(className,memberName,signature,useArray,quietFail) {
	if(quietFail == null) {
		quietFail = false;
	}
	if(useArray == null) {
		useArray = false;
	}
	lime_system_JNI.init();
	return null;
};
lime_system_JNI.createStaticField = function(className,memberName,signature) {
	lime_system_JNI.init();
	return null;
};
lime_system_JNI.createStaticMethod = function(className,memberName,signature,useArray,quietFail) {
	if(quietFail == null) {
		quietFail = false;
	}
	if(useArray == null) {
		useArray = false;
	}
	lime_system_JNI.init();
	return null;
};
lime_system_JNI.getEnv = function() {
	lime_system_JNI.init();
	return null;
};
lime_system_JNI.init = function() {
	if(!lime_system_JNI.initialized) {
		lime_system_JNI.initialized = true;
	}
};
lime_system_JNI.onCallback = function(object,method,args) {
	var field = Reflect.field(object,method);
	if(field != null) {
		if(args == null) {
			args = [];
		}
		return field.apply(object,args);
	}
	haxe_Log.trace("onCallback - unknown field " + method,{ fileName : "JNI.hx", lineNumber : 173, className : "lime.system.JNI", methodName : "onCallback"});
	return null;
};
lime_system_JNI.postUICallback = function(callback) {
	callback();
};
var lime_system_JNIMemberField = function(field) {
	this.field = field;
};
$hxClasses["lime.system.JNIMemberField"] = lime_system_JNIMemberField;
lime_system_JNIMemberField.__name__ = ["lime","system","JNIMemberField"];
lime_system_JNIMemberField.prototype = {
	get: function(jobject) {
		return null;
	}
	,set: function(jobject,value) {
		return value;
	}
	,__class__: lime_system_JNIMemberField
};
var lime_system_JNIStaticField = function(field) {
	this.field = field;
};
$hxClasses["lime.system.JNIStaticField"] = lime_system_JNIStaticField;
lime_system_JNIStaticField.__name__ = ["lime","system","JNIStaticField"];
lime_system_JNIStaticField.prototype = {
	get: function() {
		return null;
	}
	,set: function(value) {
		return value;
	}
	,__class__: lime_system_JNIStaticField
};
var lime_system_JNIMethod = function(method) {
	this.method = method;
};
$hxClasses["lime.system.JNIMethod"] = lime_system_JNIMethod;
lime_system_JNIMethod.__name__ = ["lime","system","JNIMethod"];
lime_system_JNIMethod.prototype = {
	callMember: function(args) {
		return null;
	}
	,callStatic: function(args) {
		return null;
	}
	,getMemberMethod: function(useArray) {
		if(useArray) {
			return $bind(this,this.callMember);
		} else {
			return Reflect.makeVarArgs($bind(this,this.callMember));
		}
	}
	,getStaticMethod: function(useArray) {
		if(useArray) {
			return $bind(this,this.callStatic);
		} else {
			return Reflect.makeVarArgs($bind(this,this.callStatic));
		}
	}
	,__class__: lime_system_JNIMethod
};
var lime_system__$Locale_Locale_$Impl_$ = {};
$hxClasses["lime.system._Locale.Locale_Impl_"] = lime_system__$Locale_Locale_$Impl_$;
lime_system__$Locale_Locale_$Impl_$.__name__ = ["lime","system","_Locale","Locale_Impl_"];
lime_system__$Locale_Locale_$Impl_$.__properties__ = {get_region:"get_region",get_language:"get_language",get_systemLocale:"get_systemLocale",set_currentLocale:"set_currentLocale",get_currentLocale:"get_currentLocale"};
lime_system__$Locale_Locale_$Impl_$._new = function(value) {
	var this1 = value;
	return this1;
};
lime_system__$Locale_Locale_$Impl_$.equals = function(a,b) {
	var language = lime_system__$Locale_Locale_$Impl_$.get_language(a);
	var region = lime_system__$Locale_Locale_$Impl_$.get_region(a);
	var language2 = lime_system__$Locale_Locale_$Impl_$.get_language(b);
	var region2 = lime_system__$Locale_Locale_$Impl_$.get_region(b);
	var languageMatch = language == language2;
	var regionMatch = region == region2;
	if(!languageMatch && language != null && language2 != null) {
		languageMatch = language.toLowerCase() == language2.toLowerCase();
	}
	if(!regionMatch && region != null && region2 != null) {
		regionMatch = region.toLowerCase() == region2.toLowerCase();
	}
	if(languageMatch) {
		return regionMatch;
	} else {
		return false;
	}
};
lime_system__$Locale_Locale_$Impl_$.__init = function() {
	if(lime_system__$Locale_Locale_$Impl_$.__systemLocale == null) {
		var locale = null;
		locale = navigator.language;
		if(locale != null) {
			lime_system__$Locale_Locale_$Impl_$.__systemLocale = locale;
		} else {
			lime_system__$Locale_Locale_$Impl_$.__systemLocale = "en-US";
		}
		lime_system__$Locale_Locale_$Impl_$.set_currentLocale(lime_system__$Locale_Locale_$Impl_$.__systemLocale);
	}
};
lime_system__$Locale_Locale_$Impl_$.get_language = function(this1) {
	if(this1 != null) {
		var index = this1.indexOf("_");
		if(index > -1) {
			var dashIndex = this1.indexOf("-");
			if(dashIndex > -1 && dashIndex < index) {
				index = dashIndex;
			}
			return this1.substring(0,index);
		}
		index = this1.indexOf("-");
		if(index > -1) {
			return this1.substring(0,index);
		}
	}
	return this1;
};
lime_system__$Locale_Locale_$Impl_$.get_region = function(this1) {
	if(this1 != null) {
		var underscoreIndex = this1.indexOf("_");
		var dotIndex = this1.indexOf(".");
		var dashIndex = this1.indexOf("-");
		if(underscoreIndex > -1) {
			if(dotIndex > -1) {
				return this1.substring(underscoreIndex + 1,dotIndex);
			} else {
				return this1.substring(underscoreIndex + 1);
			}
		} else if(dashIndex > -1) {
			if(dotIndex > -1) {
				return this1.substring(dashIndex + 1,dotIndex);
			} else {
				return this1.substring(dashIndex + 1);
			}
		}
	}
	return null;
};
lime_system__$Locale_Locale_$Impl_$.get_currentLocale = function() {
	lime_system__$Locale_Locale_$Impl_$.__init();
	return lime_system__$Locale_Locale_$Impl_$.currentLocale;
};
lime_system__$Locale_Locale_$Impl_$.set_currentLocale = function(value) {
	lime_system__$Locale_Locale_$Impl_$.__init();
	return lime_system__$Locale_Locale_$Impl_$.currentLocale = value;
};
lime_system__$Locale_Locale_$Impl_$.get_systemLocale = function() {
	lime_system__$Locale_Locale_$Impl_$.__init();
	return lime_system__$Locale_Locale_$Impl_$.__systemLocale;
};
var lime_system_Sensor = function(type,id) {
	this.onUpdate = new lime_app__$Event_$Float_$Float_$Float_$Void();
	this.type = type;
	this.id = id;
};
$hxClasses["lime.system.Sensor"] = lime_system_Sensor;
lime_system_Sensor.__name__ = ["lime","system","Sensor"];
lime_system_Sensor.getSensors = function(type) {
	if(type == null) {
		return lime_system_Sensor.sensors.slice();
	} else {
		var result = [];
		var _g = 0;
		var _g1 = lime_system_Sensor.sensors;
		while(_g < _g1.length) {
			var sensor = _g1[_g];
			++_g;
			if(sensor.type == type) {
				result.push(sensor);
			}
		}
		return result;
	}
};
lime_system_Sensor.registerSensor = function(type,id) {
	var sensor = new lime_system_Sensor(type,id);
	lime_system_Sensor.sensors.push(sensor);
	lime_system_Sensor.sensorByID.h[id] = sensor;
	return sensor;
};
lime_system_Sensor.prototype = {
	__class__: lime_system_Sensor
};
var lime_system_SensorType = $hxClasses["lime.system.SensorType"] = { __ename__ : ["lime","system","SensorType"], __constructs__ : ["ACCELEROMETER"] };
lime_system_SensorType.ACCELEROMETER = ["ACCELEROMETER",0];
lime_system_SensorType.ACCELEROMETER.toString = $estr;
lime_system_SensorType.ACCELEROMETER.__enum__ = lime_system_SensorType;
var lime_system_System = function() { };
$hxClasses["lime.system.System"] = lime_system_System;
lime_system_System.__name__ = ["lime","system","System"];
lime_system_System.__properties__ = {get_userDirectory:"get_userDirectory",get_platformVersion:"get_platformVersion",get_platformName:"get_platformName",get_platformLabel:"get_platformLabel",get_numDisplays:"get_numDisplays",get_fontsDirectory:"get_fontsDirectory",get_endianness:"get_endianness",get_documentsDirectory:"get_documentsDirectory",get_deviceVendor:"get_deviceVendor",get_deviceModel:"get_deviceModel",get_desktopDirectory:"get_desktopDirectory",get_applicationStorageDirectory:"get_applicationStorageDirectory",get_applicationDirectory:"get_applicationDirectory",set_allowScreenTimeout:"set_allowScreenTimeout",get_allowScreenTimeout:"get_allowScreenTimeout"};
lime_system_System.embed = $hx_exports["lime"]["embed"] = function(projectName,element,width,height,config) {
	if(lime_system_System.__applicationEntryPoint == null) {
		return;
	}
	var _this = lime_system_System.__applicationEntryPoint;
	if(__map_reserved[projectName] != null ? _this.existsReserved(projectName) : _this.h.hasOwnProperty(projectName)) {
		var htmlElement = null;
		if(typeof(element) == "string") {
			htmlElement = window.document.getElementById(element);
		} else if(element == null) {
			htmlElement = window.document.createElement("div");
		} else {
			htmlElement = element;
		}
		if(htmlElement == null) {
			window.console.log("[lime.embed] ERROR: Cannot find target element: " + Std.string(element));
			return;
		}
		if(width == null) {
			width = 0;
		}
		if(height == null) {
			height = 0;
		}
		if(config == null) {
			config = { };
		}
		if(Object.prototype.hasOwnProperty.call(config,"background") && typeof(config.background) == "string") {
			var background = StringTools.replace(Std.string(config.background),"#","");
			if(background.indexOf("0x") > -1) {
				config.background = Std.parseInt(background);
			} else {
				config.background = Std.parseInt("0x" + background);
			}
		}
		config.element = htmlElement;
		config.width = width;
		config.height = height;
		var _this1 = lime_system_System.__applicationEntryPoint;
		(__map_reserved[projectName] != null ? _this1.getReserved(projectName) : _this1.h[projectName])(config);
	}
};
lime_system_System.exit = function(code) {
};
lime_system_System.getDisplay = function(id) {
	if(id == 0) {
		var display = new lime_system_Display();
		display.id = 0;
		display.name = "Generic Display";
		display.dpi = 96 * window.devicePixelRatio;
		display.currentMode = new lime_system_DisplayMode(window.screen.width,window.screen.height,60,1);
		display.supportedModes = [display.currentMode];
		display.bounds = new lime_math_Rectangle(0,0,display.currentMode.width,display.currentMode.height);
		return display;
	}
	return null;
};
lime_system_System.getTimer = function() {
	return window.performance.now() | 0;
};
lime_system_System.load = function(library,method,args,lazy) {
	if(lazy == null) {
		lazy = false;
	}
	if(args == null) {
		args = 0;
	}
	return lime_system_CFFI.load(library,method,args,lazy);
};
lime_system_System.openFile = function(path) {
	if(path != null) {
		window.open(path,"_blank");
	}
};
lime_system_System.openURL = function(url,target) {
	if(target == null) {
		target = "_blank";
	}
	if(url != null) {
		window.open(url,target);
	}
};
lime_system_System.__copyMissingFields = function(target,source) {
	if(source == null || target == null) {
		return;
	}
	var _g = 0;
	var _g1 = Reflect.fields(source);
	while(_g < _g1.length) {
		var field = _g1[_g];
		++_g;
		if(!Object.prototype.hasOwnProperty.call(target,field)) {
			target[field] = Reflect.field(source,field);
		}
	}
};
lime_system_System.__getDirectory = function(type) {
	return null;
};
lime_system_System.__parseBool = function(value) {
	return value == "true";
};
lime_system_System.__registerEntryPoint = function(projectName,entryPoint) {
	if(lime_system_System.__applicationEntryPoint == null) {
		lime_system_System.__applicationEntryPoint = new haxe_ds_StringMap();
	}
	var _this = lime_system_System.__applicationEntryPoint;
	if(__map_reserved[projectName] != null) {
		_this.setReserved(projectName,entryPoint);
	} else {
		_this.h[projectName] = entryPoint;
	}
};
lime_system_System.__runProcess = function(command,args) {
	return null;
};
lime_system_System.get_allowScreenTimeout = function() {
	return true;
};
lime_system_System.set_allowScreenTimeout = function(value) {
	return true;
};
lime_system_System.get_applicationDirectory = function() {
	if(lime_system_System.__applicationDirectory == null) {
		lime_system_System.__applicationDirectory = lime_system_System.__getDirectory(0);
	}
	return lime_system_System.__applicationDirectory;
};
lime_system_System.get_applicationStorageDirectory = function() {
	if(lime_system_System.__applicationStorageDirectory == null) {
		lime_system_System.__applicationStorageDirectory = lime_system_System.__getDirectory(1);
	}
	return lime_system_System.__applicationStorageDirectory;
};
lime_system_System.get_deviceModel = function() {
	var tmp = lime_system_System.__deviceModel == null;
	return lime_system_System.__deviceModel;
};
lime_system_System.get_deviceVendor = function() {
	var tmp = lime_system_System.__deviceVendor == null;
	return lime_system_System.__deviceVendor;
};
lime_system_System.get_desktopDirectory = function() {
	if(lime_system_System.__desktopDirectory == null) {
		lime_system_System.__desktopDirectory = lime_system_System.__getDirectory(2);
	}
	return lime_system_System.__desktopDirectory;
};
lime_system_System.get_documentsDirectory = function() {
	if(lime_system_System.__documentsDirectory == null) {
		lime_system_System.__documentsDirectory = lime_system_System.__getDirectory(3);
	}
	return lime_system_System.__documentsDirectory;
};
lime_system_System.get_endianness = function() {
	if(lime_system_System.__endianness == null) {
		var arrayBuffer = new ArrayBuffer(2);
		var this1;
		if(arrayBuffer != null) {
			this1 = new Uint8Array(arrayBuffer,0);
		} else {
			this1 = null;
		}
		var uint8Array = this1;
		var this2;
		if(arrayBuffer != null) {
			this2 = new Uint16Array(arrayBuffer,0);
		} else {
			this2 = null;
		}
		var uint16array = this2;
		uint8Array[0] = 170;
		uint8Array[1] = 187;
		if(uint16array[0] == 43707) {
			lime_system_System.__endianness = lime_system_Endian.BIG_ENDIAN;
		} else {
			lime_system_System.__endianness = lime_system_Endian.LITTLE_ENDIAN;
		}
	}
	return lime_system_System.__endianness;
};
lime_system_System.get_fontsDirectory = function() {
	if(lime_system_System.__fontsDirectory == null) {
		lime_system_System.__fontsDirectory = lime_system_System.__getDirectory(4);
	}
	return lime_system_System.__fontsDirectory;
};
lime_system_System.get_numDisplays = function() {
	return 1;
};
lime_system_System.get_platformLabel = function() {
	if(lime_system_System.__platformLabel == null) {
		var name = lime_system_System.get_platformName();
		var version = lime_system_System.get_platformVersion();
		if(name != null && version != null) {
			lime_system_System.__platformLabel = name + " " + version;
		} else if(name != null) {
			lime_system_System.__platformLabel = name;
		}
	}
	return lime_system_System.__platformLabel;
};
lime_system_System.get_platformName = function() {
	if(lime_system_System.__platformName == null) {
		lime_system_System.__platformName = "HTML5";
	}
	return lime_system_System.__platformName;
};
lime_system_System.get_platformVersion = function() {
	var tmp = lime_system_System.__platformVersion == null;
	return lime_system_System.__platformVersion;
};
lime_system_System.get_userDirectory = function() {
	if(lime_system_System.__userDirectory == null) {
		lime_system_System.__userDirectory = lime_system_System.__getDirectory(5);
	}
	return lime_system_System.__userDirectory;
};
var lime_system_ThreadPool = function(minThreads,maxThreads) {
	if(maxThreads == null) {
		maxThreads = 1;
	}
	if(minThreads == null) {
		minThreads = 0;
	}
	this.onRun = new lime_app__$Event_$Dynamic_$Void();
	this.onProgress = new lime_app__$Event_$Dynamic_$Void();
	this.onError = new lime_app__$Event_$Dynamic_$Void();
	this.onComplete = new lime_app__$Event_$Dynamic_$Void();
	this.doWork = new lime_app__$Event_$Dynamic_$Void();
	this.minThreads = minThreads;
	this.maxThreads = maxThreads;
	this.currentThreads = 0;
};
$hxClasses["lime.system.ThreadPool"] = lime_system_ThreadPool;
lime_system_ThreadPool.__name__ = ["lime","system","ThreadPool"];
lime_system_ThreadPool.prototype = {
	queue: function(state) {
		this.runWork(state);
	}
	,sendComplete: function(state) {
		this.onComplete.dispatch(state);
	}
	,sendError: function(state) {
		this.onError.dispatch(state);
	}
	,sendProgress: function(state) {
		this.onProgress.dispatch(state);
	}
	,runWork: function(state) {
		this.onRun.dispatch(state);
		this.doWork.dispatch(state);
	}
	,__class__: lime_system_ThreadPool
};
var lime_system__$ThreadPool_ThreadPoolMessageType = $hxClasses["lime.system._ThreadPool.ThreadPoolMessageType"] = { __ename__ : ["lime","system","_ThreadPool","ThreadPoolMessageType"], __constructs__ : ["COMPLETE","ERROR","EXIT","PROGRESS","WORK"] };
lime_system__$ThreadPool_ThreadPoolMessageType.COMPLETE = ["COMPLETE",0];
lime_system__$ThreadPool_ThreadPoolMessageType.COMPLETE.toString = $estr;
lime_system__$ThreadPool_ThreadPoolMessageType.COMPLETE.__enum__ = lime_system__$ThreadPool_ThreadPoolMessageType;
lime_system__$ThreadPool_ThreadPoolMessageType.ERROR = ["ERROR",1];
lime_system__$ThreadPool_ThreadPoolMessageType.ERROR.toString = $estr;
lime_system__$ThreadPool_ThreadPoolMessageType.ERROR.__enum__ = lime_system__$ThreadPool_ThreadPoolMessageType;
lime_system__$ThreadPool_ThreadPoolMessageType.EXIT = ["EXIT",2];
lime_system__$ThreadPool_ThreadPoolMessageType.EXIT.toString = $estr;
lime_system__$ThreadPool_ThreadPoolMessageType.EXIT.__enum__ = lime_system__$ThreadPool_ThreadPoolMessageType;
lime_system__$ThreadPool_ThreadPoolMessageType.PROGRESS = ["PROGRESS",3];
lime_system__$ThreadPool_ThreadPoolMessageType.PROGRESS.toString = $estr;
lime_system__$ThreadPool_ThreadPoolMessageType.PROGRESS.__enum__ = lime_system__$ThreadPool_ThreadPoolMessageType;
lime_system__$ThreadPool_ThreadPoolMessageType.WORK = ["WORK",4];
lime_system__$ThreadPool_ThreadPoolMessageType.WORK.toString = $estr;
lime_system__$ThreadPool_ThreadPoolMessageType.WORK.__enum__ = lime_system__$ThreadPool_ThreadPoolMessageType;
var lime_system__$ThreadPool_ThreadPoolMessage = function(type,state) {
	this.type = type;
	this.state = state;
};
$hxClasses["lime.system._ThreadPool.ThreadPoolMessage"] = lime_system__$ThreadPool_ThreadPoolMessage;
lime_system__$ThreadPool_ThreadPoolMessage.__name__ = ["lime","system","_ThreadPool","ThreadPoolMessage"];
lime_system__$ThreadPool_ThreadPoolMessage.prototype = {
	__class__: lime_system__$ThreadPool_ThreadPoolMessage
};
var lime_text_Font = function(name) {
	if(name != null) {
		this.name = name;
	}
	if(!this.__init) {
		if(this.ascender == undefined) {
			this.ascender = 0;
		}
		if(this.descender == undefined) {
			this.descender = 0;
		}
		if(this.height == undefined) {
			this.height = 0;
		}
		if(this.numGlyphs == undefined) {
			this.numGlyphs = 0;
		}
		if(this.underlinePosition == undefined) {
			this.underlinePosition = 0;
		}
		if(this.underlineThickness == undefined) {
			this.underlineThickness = 0;
		}
		if(this.unitsPerEM == undefined) {
			this.unitsPerEM = 0;
		}
		if(this.__fontID != null) {
			if(lime_utils_Assets.isLocal(this.__fontID)) {
				this.__fromBytes(lime_utils_Assets.getBytes(this.__fontID));
			}
		} else if(this.__fontPath != null) {
			this.__fromFile(this.__fontPath);
		}
	}
};
$hxClasses["lime.text.Font"] = lime_text_Font;
lime_text_Font.__name__ = ["lime","text","Font"];
lime_text_Font.fromBytes = function(bytes) {
	if(bytes == null) {
		return null;
	}
	var font = new lime_text_Font();
	font.__fromBytes(bytes);
	return font;
};
lime_text_Font.fromFile = function(path) {
	if(path == null) {
		return null;
	}
	var font = new lime_text_Font();
	font.__fromFile(path);
	return font;
};
lime_text_Font.loadFromBytes = function(bytes) {
	return lime_app_Future.withValue(lime_text_Font.fromBytes(bytes));
};
lime_text_Font.loadFromFile = function(path) {
	var request = new lime_net__$HTTPRequest_$lime_$text_$Font();
	return request.load(path).then(function(font) {
		if(font != null) {
			return lime_app_Future.withValue(font);
		} else {
			return lime_app_Future.withError("");
		}
	});
};
lime_text_Font.loadFromName = function(path) {
	var font = new lime_text_Font();
	return font.__loadFromName(path);
};
lime_text_Font.__measureFontNode = function(fontFamily) {
	var node = window.document.createElement("span");
	node.setAttribute("aria-hidden","true");
	var text = window.document.createTextNode("BESbswy");
	node.appendChild(text);
	var style = node.style;
	style.display = "block";
	style.position = "absolute";
	style.top = "-9999px";
	style.left = "-9999px";
	style.fontSize = "300px";
	style.width = "auto";
	style.height = "auto";
	style.lineHeight = "normal";
	style.margin = "0";
	style.padding = "0";
	style.fontVariant = "normal";
	style.whiteSpace = "nowrap";
	style.fontFamily = fontFamily;
	window.document.body.appendChild(node);
	return node;
};
lime_text_Font.prototype = {
	decompose: function() {
		return null;
	}
	,getGlyph: function(character) {
		return -1;
	}
	,getGlyphs: function(characters) {
		if(characters == null) {
			characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^`'\"/\\&*()[]{}<>|:;_-+=?,. ";
		}
		return null;
	}
	,getGlyphMetrics: function(glyph) {
		return null;
	}
	,renderGlyph: function(glyph,fontSize) {
		return null;
	}
	,renderGlyphs: function(glyphs,fontSize) {
		return null;
	}
	,__copyFrom: function(other) {
		if(other != null) {
			this.ascender = other.ascender;
			this.descender = other.descender;
			this.height = other.height;
			this.name = other.name;
			this.numGlyphs = other.numGlyphs;
			this.src = other.src;
			this.underlinePosition = other.underlinePosition;
			this.underlineThickness = other.underlineThickness;
			this.unitsPerEM = other.unitsPerEM;
			this.__fontID = other.__fontID;
			this.__fontPath = other.__fontPath;
			this.__init = true;
		}
	}
	,__fromBytes: function(bytes) {
		this.__fontPath = null;
	}
	,__fromFile: function(path) {
		this.__fontPath = path;
	}
	,__initializeSource: function() {
		this.__init = true;
	}
	,__loadFromName: function(name) {
		var _gthis = this;
		var promise = new lime_app_Promise();
		this.name = name;
		var userAgent = window.navigator.userAgent.toLowerCase();
		var isSafari = userAgent.indexOf(" safari/") >= 0 && userAgent.indexOf(" chrome/") < 0;
		var isUIWebView = new EReg("(iPhone|iPod|iPad).*AppleWebKit(?!.*Version)","i").match(userAgent);
		if(!isSafari && !isUIWebView && (window.document.fonts && ($_=window.document.fonts,$bind($_,$_.load)))) {
			window.document.fonts.load("1em '" + name + "'").then(function(_) {
				promise.complete(_gthis);
			},function(_1) {
				lime_utils_Log.warn("Could not load web font \"" + name + "\"",{ fileName : "Font.hx", lineNumber : 513, className : "lime.text.Font", methodName : "__loadFromName"});
				promise.complete(_gthis);
			});
		} else {
			var node1 = lime_text_Font.__measureFontNode("'" + name + "', sans-serif");
			var node2 = lime_text_Font.__measureFontNode("'" + name + "', serif");
			var width1 = node1.offsetWidth;
			var width2 = node2.offsetWidth;
			var interval = -1;
			var timeout = 3000;
			var intervalLength = 50;
			var intervalCount = 0;
			var loaded;
			var timeExpired;
			var checkFont = function() {
				intervalCount += 1;
				if(node1.offsetWidth == width1) {
					loaded = node2.offsetWidth != width2;
				} else {
					loaded = true;
				}
				timeExpired = intervalCount * intervalLength >= timeout;
				if(loaded || timeExpired) {
					window.clearInterval(interval);
					node1.parentNode.removeChild(node1);
					node2.parentNode.removeChild(node2);
					node1 = null;
					node2 = null;
					if(timeExpired) {
						lime_utils_Log.warn("Could not load web font \"" + name + "\"",{ fileName : "Font.hx", lineNumber : 548, className : "lime.text.Font", methodName : "__loadFromName"});
					}
					promise.complete(_gthis);
				}
			};
			interval = window.setInterval(checkFont,intervalLength);
		}
		return promise.future;
	}
	,__setSize: function(size) {
	}
	,__class__: lime_text_Font
};
var lime_text__$Glyph_Glyph_$Impl_$ = {};
$hxClasses["lime.text._Glyph.Glyph_Impl_"] = lime_text__$Glyph_Glyph_$Impl_$;
lime_text__$Glyph_Glyph_$Impl_$.__name__ = ["lime","text","_Glyph","Glyph_Impl_"];
lime_text__$Glyph_Glyph_$Impl_$._new = function(i) {
	var this1 = i;
	return this1;
};
var lime_text_GlyphMetrics = function() {
};
$hxClasses["lime.text.GlyphMetrics"] = lime_text_GlyphMetrics;
lime_text_GlyphMetrics.__name__ = ["lime","text","GlyphMetrics"];
lime_text_GlyphMetrics.prototype = {
	__class__: lime_text_GlyphMetrics
};
var lime_text__$UTF8String_UTF8String_$Impl_$ = {};
$hxClasses["lime.text._UTF8String.UTF8String_Impl_"] = lime_text__$UTF8String_UTF8String_$Impl_$;
lime_text__$UTF8String_UTF8String_$Impl_$.__name__ = ["lime","text","_UTF8String","UTF8String_Impl_"];
lime_text__$UTF8String_UTF8String_$Impl_$.__properties__ = {get_length:"get_length"};
lime_text__$UTF8String_UTF8String_$Impl_$._new = function(str) {
	var this1 = new String(str);
	return this1;
};
lime_text__$UTF8String_UTF8String_$Impl_$.charAt = function(this1,index) {
	var this2 = this1;
	var this3 = this2;
	var this4 = this3;
	var i;
	if(index >= 0) {
		var index1 = 0;
		var len = this4.length;
		var i1 = 0;
		while(i1 < index && index1 < len) {
			var c = this4.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i1;
		}
		i = index1;
	} else {
		var index2 = 0;
		var count = 0;
		while(count < -index && 0 < index2) {
			var c1 = this4.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		i = index2;
	}
	var this5 = this1;
	var this6 = this5;
	var this7 = this6;
	var c2 = this7.charCodeAt(i);
	var this8 = HxOverrides.substr(this7,i,!(55296 <= c2 && c2 <= 56319) ? 1 : 2);
	var this9 = this8;
	return this9;
};
lime_text__$UTF8String_UTF8String_$Impl_$.charCodeAt = function(this1,index) {
	var tmp;
	if(index >= 0) {
		var this2 = this1;
		var this3 = this2;
		tmp = index >= lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointCount(this3,0,this1.length);
	} else {
		tmp = true;
	}
	if(tmp) {
		return null;
	}
	var this4 = this1;
	var this5 = this4;
	var this6 = this5;
	var i;
	if(index >= 0) {
		var index1 = 0;
		var len = this6.length;
		var i1 = 0;
		while(i1 < index && index1 < len) {
			var c = this6.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i1;
		}
		i = index1;
	} else {
		var index2 = 0;
		var count = 0;
		while(count < -index && 0 < index2) {
			var c1 = this6.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		i = index2;
	}
	var this7 = this1;
	var this8 = this7;
	return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointAt(this8,i);
};
lime_text__$UTF8String_UTF8String_$Impl_$.fromCharCode = function(code) {
	if(!(0 <= code && code <= 1114111 && !(55296 <= code && code <= 56319) && !(56320 <= code && code <= 57343))) {
		throw new js__$Boot_HaxeError(new lime__$internal_unifill_InvalidCodePoint(code));
	}
	var this1 = code;
	var this2 = this1;
	var this3;
	if(this2 <= 65535) {
		var this4 = String.fromCharCode(this2);
		var this5 = this4;
		this3 = this5;
	} else {
		var this6 = String.fromCharCode((this2 >> 10) + 55232) + String.fromCharCode(this2 & 1023 | 56320);
		var this7 = this6;
		this3 = this7;
	}
	return this3;
};
lime_text__$UTF8String_UTF8String_$Impl_$.fromCharCodes = function(codes) {
	var s = "";
	var _g = 0;
	while(_g < codes.length) {
		var code = codes[_g];
		++_g;
		if(!(0 <= code && code <= 1114111 && !(55296 <= code && code <= 56319) && !(56320 <= code && code <= 57343))) {
			throw new js__$Boot_HaxeError(new lime__$internal_unifill_InvalidCodePoint(code));
		}
		var this1 = code;
		var b = this1;
		var this2;
		if(b <= 65535) {
			var this3 = String.fromCharCode(b);
			var this4 = this3;
			this2 = this4;
		} else {
			var this5 = String.fromCharCode((b >> 10) + 55232) + String.fromCharCode(b & 1023 | 56320);
			var this6 = this5;
			this2 = this6;
		}
		s += this2;
	}
	return s;
};
lime_text__$UTF8String_UTF8String_$Impl_$.indexOf = function(this1,str,startIndex) {
	if(startIndex == null) {
		startIndex = 0;
	}
	var this2 = this1;
	var this3 = this2;
	var this4 = this3;
	var index;
	if(startIndex >= 0) {
		var index1 = 0;
		var len = this4.length;
		var i = 0;
		while(i < startIndex && index1 < len) {
			var c = this4.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i;
		}
		index = index1;
	} else {
		var index2 = 0;
		var count = 0;
		while(count < -startIndex && 0 < index2) {
			var c1 = this4.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		index = index2;
	}
	var index3 = this1.indexOf(str,index);
	if(index3 >= 0) {
		var this5 = this1;
		var this6 = this5;
		return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointCount(this6,0,index3);
	} else {
		return -1;
	}
};
lime_text__$UTF8String_UTF8String_$Impl_$.lastIndexOf = function(this1,str,startIndex) {
	var startIndex1 = startIndex;
	if(startIndex1 == null) {
		startIndex1 = this1.length - 1;
	}
	var this2 = this1;
	var this3 = this2;
	var this4 = this3;
	var index;
	if(startIndex1 >= 0) {
		var index1 = 0;
		var len = this4.length;
		var i = 0;
		while(i < startIndex1 && index1 < len) {
			var c = this4.charCodeAt(index1);
			index1 += !(55296 <= c && c <= 56319) ? 1 : 2;
			++i;
		}
		index = index1;
	} else {
		var index2 = 0;
		var count = 0;
		while(count < -startIndex1 && 0 < index2) {
			var c1 = this4.charCodeAt(index2 - 1);
			index2 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
			++count;
		}
		index = index2;
	}
	var index3 = this1.lastIndexOf(str,index);
	if(index3 >= 0) {
		var this5 = this1;
		var this6 = this5;
		return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointCount(this6,0,index3);
	} else {
		return -1;
	}
};
lime_text__$UTF8String_UTF8String_$Impl_$.split = function(this1,delimiter) {
	if(delimiter.length == 0) {
		var _g = [];
		var _g1_string;
		var _g1_index;
		var _g1_i;
		var _g1_endIndex;
		_g1_i = 0;
		_g1_string = this1;
		_g1_index = 0;
		_g1_endIndex = this1.length;
		while(_g1_index < _g1_endIndex) {
			_g1_i = _g1_index;
			var this2 = _g1_string;
			var this3 = this2;
			var c = this3.charCodeAt(_g1_index);
			_g1_index += !(55296 <= c && c <= 56319) ? 1 : 2;
			var i = _g1_i;
			var this4 = this1;
			var this5 = this4;
			var this6 = this5;
			var c1 = this6.charCodeAt(i);
			var this7 = HxOverrides.substr(this6,i,!(55296 <= c1 && c1 <= 56319) ? 1 : 2);
			var this8 = this7;
			_g.push(this8);
		}
		return _g;
	} else {
		return this1.split(delimiter);
	}
};
lime_text__$UTF8String_UTF8String_$Impl_$.substr = function(this1,pos,len) {
	if(len == null) {
		len = lime_text__$UTF8String_UTF8String_$Impl_$.get_length(this1) - pos;
	}
	return HxOverrides.substr(this1,pos,len);
};
lime_text__$UTF8String_UTF8String_$Impl_$.substring = function(this1,startIndex,endIndex) {
	var si;
	if(startIndex < 0) {
		si = 0;
	} else {
		var this2 = this1;
		var this3 = this2;
		var this4 = this3;
		if(startIndex >= 0) {
			var index = 0;
			var len = this4.length;
			var i = 0;
			while(i < startIndex && index < len) {
				var c = this4.charCodeAt(index);
				index += !(55296 <= c && c <= 56319) ? 1 : 2;
				++i;
			}
			si = index;
		} else {
			var index1 = 0;
			var count = 0;
			while(count < -startIndex && 0 < index1) {
				var c1 = this4.charCodeAt(index1 - 1);
				index1 -= !(56320 <= c1 && c1 <= 57343) ? 1 : 2;
				++count;
			}
			si = index1;
		}
	}
	var ei;
	if(endIndex == null) {
		ei = this1.length;
	} else if(endIndex < 0) {
		ei = 0;
	} else {
		var this5 = this1;
		var this6 = this5;
		var this7 = this6;
		if(endIndex >= 0) {
			var index2 = 0;
			var len1 = this7.length;
			var i1 = 0;
			while(i1 < endIndex && index2 < len1) {
				var c2 = this7.charCodeAt(index2);
				index2 += !(55296 <= c2 && c2 <= 56319) ? 1 : 2;
				++i1;
			}
			ei = index2;
		} else {
			var index3 = 0;
			var count1 = 0;
			while(count1 < -endIndex && 0 < index3) {
				var c3 = this7.charCodeAt(index3 - 1);
				index3 -= !(56320 <= c3 && c3 <= 57343) ? 1 : 2;
				++count1;
			}
			ei = index3;
		}
	}
	return this1.substring(si,ei);
};
lime_text__$UTF8String_UTF8String_$Impl_$.toLowerCase = function(this1,locale) {
	return this1.toLowerCase();
};
lime_text__$UTF8String_UTF8String_$Impl_$.toLowerCaseLocaleFixes = function(v,locale) {
	var _g = lime_system__$Locale_Locale_$Impl_$.get_language(locale);
	if(_g == "tr") {
		if(v == 50352) {
			return 105;
		} else {
			return v;
		}
	} else {
		return v;
	}
};
lime_text__$UTF8String_UTF8String_$Impl_$.toString = function(this1) {
	return this1;
};
lime_text__$UTF8String_UTF8String_$Impl_$.toUpperCase = function(this1,locale) {
	return this1.toUpperCase();
};
lime_text__$UTF8String_UTF8String_$Impl_$.toUpperCaseLocaleFixes = function(v,locale) {
	var _g = lime_system__$Locale_Locale_$Impl_$.get_language(locale);
	if(_g == "tr") {
		if(v == 105) {
			return 50352;
		} else {
			return v;
		}
	} else {
		return v;
	}
};
lime_text__$UTF8String_UTF8String_$Impl_$.equals = function(a,b) {
	if(a == null || b == null) {
		return a == b;
	}
	return lime__$internal_unifill_Unifill.uCompare(a,b) == 0;
};
lime_text__$UTF8String_UTF8String_$Impl_$.lt = function(a,b) {
	if(b == null) {
		return false;
	}
	if(a == null) {
		return true;
	}
	return lime__$internal_unifill_Unifill.uCompare(a,b) == -1;
};
lime_text__$UTF8String_UTF8String_$Impl_$.gt = function(a,b) {
	if(a == null) {
		return false;
	}
	if(b == null) {
		return true;
	}
	return lime__$internal_unifill_Unifill.uCompare(a,b) == 1;
};
lime_text__$UTF8String_UTF8String_$Impl_$.lteq = function(a,b) {
	if(b == null) {
		return a == null;
	}
	if(a == null) {
		return true;
	}
	return lime__$internal_unifill_Unifill.uCompare(a,b) != 1;
};
lime_text__$UTF8String_UTF8String_$Impl_$.gteq = function(a,b) {
	if(a == null) {
		return b == null;
	}
	if(b == null) {
		return true;
	}
	return lime__$internal_unifill_Unifill.uCompare(a,b) != -1;
};
lime_text__$UTF8String_UTF8String_$Impl_$.plus = function(a,b) {
	if(a == null && b == null) {
		return null;
	}
	if(a == null) {
		return b;
	}
	if(b == null) {
		return a;
	}
	var sb_b = "";
	sb_b += Std.string(lime_text__$UTF8String_UTF8String_$Impl_$.toString(a));
	sb_b += Std.string(lime_text__$UTF8String_UTF8String_$Impl_$.toString(b));
	return sb_b;
};
lime_text__$UTF8String_UTF8String_$Impl_$.fromDynamic = function(value) {
	return Std.string(value);
};
lime_text__$UTF8String_UTF8String_$Impl_$.get_length = function(this1) {
	if(this1 == null) {
		return 0;
	} else {
		var this2 = this1;
		var this3 = this2;
		return lime__$internal_unifill__$Utf16_Utf16_$Impl_$.codePointCount(this3,0,this1.length);
	}
};
var lime_text__$UTF8String_Utf8Ext = function() { };
$hxClasses["lime.text._UTF8String.Utf8Ext"] = lime_text__$UTF8String_Utf8Ext;
lime_text__$UTF8String_Utf8Ext.__name__ = ["lime","text","_UTF8String","Utf8Ext"];
lime_text__$UTF8String_Utf8Ext.fillUpperToLowerMap = function(map) {
	var i = 0;
	var _g = 0;
	while(_g < 26) {
		var i1 = _g++;
		var v = 97 + i1;
		map.h[65 + i1] = v;
	}
	var _g1 = 0;
	while(_g1 < 23) {
		var i2 = _g1++;
		var v1 = 224 + i2;
		map.h[192 + i2] = v1;
	}
	var _g2 = 0;
	while(_g2 < 7) {
		var i3 = _g2++;
		var v2 = 248 + i3;
		map.h[216 + i3] = v2;
	}
	while(i < 48) {
		var v3 = 257 + i;
		map.h[256 + i] = v3;
		i += 2;
	}
	i = 0;
	map.h[304] = 105;
	while(i < 6) {
		var v4 = 307 + i;
		map.h[306 + i] = v4;
		i += 2;
	}
	i = 0;
	while(i < 16) {
		var v5 = 314 + i;
		map.h[313 + i] = v5;
		i += 2;
	}
	i = 0;
	while(i < 46) {
		var v6 = 331 + i;
		map.h[330 + i] = v6;
		i += 2;
	}
	i = 0;
	map.h[376] = 255;
	while(i < 6) {
		var v7 = 378 + i;
		map.h[377 + i] = v7;
		i += 2;
	}
	i = 0;
	map.h[385] = 595;
	while(i < 4) {
		var v8 = 387 + i;
		map.h[386 + i] = v8;
		i += 2;
	}
	i = 0;
	map.h[390] = 596;
	map.h[391] = 392;
	var _g3 = 0;
	while(_g3 < 2) {
		var i4 = _g3++;
		var v9 = 598 + i4;
		map.h[393 + i4] = v9;
	}
	map.h[395] = 396;
	map.h[398] = 477;
	map.h[399] = 601;
	map.h[400] = 603;
	map.h[401] = 402;
	map.h[403] = 608;
	map.h[404] = 611;
	map.h[406] = 617;
	map.h[407] = 616;
	map.h[408] = 409;
	map.h[412] = 623;
	map.h[413] = 626;
	map.h[415] = 629;
	while(i < 6) {
		var v10 = 417 + i;
		map.h[416 + i] = v10;
		i += 2;
	}
	i = 0;
	map.h[422] = 640;
	map.h[423] = 424;
	map.h[425] = 643;
	map.h[428] = 429;
	map.h[430] = 648;
	map.h[431] = 432;
	var _g4 = 0;
	while(_g4 < 2) {
		var i5 = _g4++;
		var v11 = 650 + i5;
		map.h[433 + i5] = v11;
	}
	while(i < 4) {
		var v12 = 436 + i;
		map.h[435 + i] = v12;
		i += 2;
	}
	i = 0;
	map.h[439] = 658;
	map.h[440] = 441;
	map.h[444] = 445;
	map.h[452] = 454;
	map.h[455] = 457;
	map.h[458] = 460;
	while(i < 16) {
		var v13 = 462 + i;
		map.h[461 + i] = v13;
		i += 2;
	}
	i = 0;
	while(i < 18) {
		var v14 = 479 + i;
		map.h[478 + i] = v14;
		i += 2;
	}
	i = 0;
	map.h[497] = 499;
	map.h[500] = 501;
	map.h[502] = 405;
	map.h[503] = 447;
	while(i < 40) {
		var v15 = 505 + i;
		map.h[504 + i] = v15;
		i += 2;
	}
	i = 0;
	map.h[544] = 414;
	while(i < 18) {
		var v16 = 547 + i;
		map.h[546 + i] = v16;
		i += 2;
	}
	i = 0;
	map.h[570] = 11365;
	map.h[571] = 572;
	map.h[573] = 410;
	map.h[574] = 11366;
	map.h[577] = 578;
	map.h[579] = 384;
	map.h[580] = 649;
	map.h[581] = 652;
	while(i < 10) {
		var v17 = 583 + i;
		map.h[582 + i] = v17;
		i += 2;
	}
	i = 0;
	while(i < 4) {
		var v18 = 881 + i;
		map.h[880 + i] = v18;
		i += 2;
	}
	i = 0;
	map.h[886] = 887;
	map.h[895] = 1011;
	map.h[902] = 940;
	var _g5 = 0;
	while(_g5 < 3) {
		var i6 = _g5++;
		var v19 = 941 + i6;
		map.h[904 + i6] = v19;
	}
	map.h[908] = 972;
	var _g6 = 0;
	while(_g6 < 2) {
		var i7 = _g6++;
		var v20 = 973 + i7;
		map.h[910 + i7] = v20;
	}
	var _g7 = 0;
	while(_g7 < 17) {
		var i8 = _g7++;
		var v21 = 945 + i8;
		map.h[913 + i8] = v21;
	}
	var _g8 = 0;
	while(_g8 < 9) {
		var i9 = _g8++;
		var v22 = 963 + i9;
		map.h[931 + i9] = v22;
	}
	map.h[975] = 983;
	while(i < 24) {
		var v23 = 985 + i;
		map.h[984 + i] = v23;
		i += 2;
	}
	i = 0;
	map.h[1012] = 952;
	map.h[1015] = 1016;
	map.h[1017] = 1010;
	map.h[1018] = 1019;
	var _g9 = 0;
	while(_g9 < 3) {
		var i10 = _g9++;
		var v24 = 891 + i10;
		map.h[1021 + i10] = v24;
	}
	var _g10 = 0;
	while(_g10 < 16) {
		var i11 = _g10++;
		var v25 = 1104 + i11;
		map.h[1024 + i11] = v25;
	}
	var _g11 = 0;
	while(_g11 < 32) {
		var i12 = _g11++;
		var v26 = 1072 + i12;
		map.h[1040 + i12] = v26;
	}
	while(i < 34) {
		var v27 = 1121 + i;
		map.h[1120 + i] = v27;
		i += 2;
	}
	i = 0;
	while(i < 54) {
		var v28 = 1163 + i;
		map.h[1162 + i] = v28;
		i += 2;
	}
	i = 0;
	map.h[1216] = 1231;
	while(i < 14) {
		var v29 = 1218 + i;
		map.h[1217 + i] = v29;
		i += 2;
	}
	i = 0;
	while(i < 96) {
		var v30 = 1233 + i;
		map.h[1232 + i] = v30;
		i += 2;
	}
	i = 0;
	var _g12 = 0;
	while(_g12 < 38) {
		var i13 = _g12++;
		var v31 = 1377 + i13;
		map.h[1329 + i13] = v31;
	}
	var _g13 = 0;
	while(_g13 < 38) {
		var i14 = _g13++;
		var v32 = 11520 + i14;
		map.h[4256 + i14] = v32;
	}
	map.h[4295] = 11559;
	map.h[4301] = 11565;
	var _g14 = 0;
	while(_g14 < 80) {
		var i15 = _g14++;
		var v33 = 43888 + i15;
		map.h[5024 + i15] = v33;
	}
	var _g15 = 0;
	while(_g15 < 6) {
		var i16 = _g15++;
		var v34 = 5112 + i16;
		map.h[5104 + i16] = v34;
	}
	while(i < 150) {
		var v35 = 7681 + i;
		map.h[7680 + i] = v35;
		i += 2;
	}
	i = 0;
	map.h[7838] = 223;
	while(i < 96) {
		var v36 = 7841 + i;
		map.h[7840 + i] = v36;
		i += 2;
	}
	i = 0;
	var _g16 = 0;
	while(_g16 < 8) {
		var i17 = _g16++;
		var v37 = 7936 + i17;
		map.h[7944 + i17] = v37;
	}
	var _g17 = 0;
	while(_g17 < 6) {
		var i18 = _g17++;
		var v38 = 7952 + i18;
		map.h[7960 + i18] = v38;
	}
	var _g18 = 0;
	while(_g18 < 8) {
		var i19 = _g18++;
		var v39 = 7968 + i19;
		map.h[7976 + i19] = v39;
	}
	var _g19 = 0;
	while(_g19 < 8) {
		var i20 = _g19++;
		var v40 = 7984 + i20;
		map.h[7992 + i20] = v40;
	}
	var _g20 = 0;
	while(_g20 < 6) {
		var i21 = _g20++;
		var v41 = 8000 + i21;
		map.h[8008 + i21] = v41;
	}
	while(i < 8) {
		var v42 = 8017 + i;
		map.h[8025 + i] = v42;
		i += 2;
	}
	i = 0;
	var _g21 = 0;
	while(_g21 < 8) {
		var i22 = _g21++;
		var v43 = 8032 + i22;
		map.h[8040 + i22] = v43;
	}
	var _g22 = 0;
	while(_g22 < 2) {
		var i23 = _g22++;
		var v44 = 8112 + i23;
		map.h[8120 + i23] = v44;
	}
	var _g23 = 0;
	while(_g23 < 2) {
		var i24 = _g23++;
		var v45 = 8048 + i24;
		map.h[8122 + i24] = v45;
	}
	var _g24 = 0;
	while(_g24 < 4) {
		var i25 = _g24++;
		var v46 = 8050 + i25;
		map.h[8136 + i25] = v46;
	}
	var _g25 = 0;
	while(_g25 < 2) {
		var i26 = _g25++;
		var v47 = 8144 + i26;
		map.h[8152 + i26] = v47;
	}
	var _g26 = 0;
	while(_g26 < 2) {
		var i27 = _g26++;
		var v48 = 8054 + i27;
		map.h[8154 + i27] = v48;
	}
	var _g27 = 0;
	while(_g27 < 2) {
		var i28 = _g27++;
		var v49 = 8160 + i28;
		map.h[8168 + i28] = v49;
	}
	var _g28 = 0;
	while(_g28 < 2) {
		var i29 = _g28++;
		var v50 = 8058 + i29;
		map.h[8170 + i29] = v50;
	}
	map.h[8172] = 8165;
	var _g29 = 0;
	while(_g29 < 2) {
		var i30 = _g29++;
		var v51 = 8056 + i30;
		map.h[8184 + i30] = v51;
	}
	var _g30 = 0;
	while(_g30 < 2) {
		var i31 = _g30++;
		var v52 = 8060 + i31;
		map.h[8186 + i31] = v52;
	}
	map.h[8486] = 969;
	map.h[8490] = 107;
	map.h[8491] = 229;
	map.h[8498] = 8526;
	map.h[8579] = 8580;
	var _g31 = 0;
	while(_g31 < 47) {
		var i32 = _g31++;
		var v53 = 11312 + i32;
		map.h[11264 + i32] = v53;
	}
	map.h[11360] = 11361;
	map.h[11362] = 619;
	map.h[11363] = 7549;
	map.h[11364] = 637;
	while(i < 6) {
		var v54 = 11368 + i;
		map.h[11367 + i] = v54;
		i += 2;
	}
	i = 0;
	map.h[11373] = 593;
	map.h[11374] = 625;
	map.h[11375] = 592;
	map.h[11376] = 594;
	map.h[11378] = 11379;
	map.h[11381] = 11382;
	var _g32 = 0;
	while(_g32 < 2) {
		var i33 = _g32++;
		var v55 = 575 + i33;
		map.h[11390 + i33] = v55;
	}
	while(i < 100) {
		var v56 = 11393 + i;
		map.h[11392 + i] = v56;
		i += 2;
	}
	i = 0;
	while(i < 4) {
		var v57 = 11500 + i;
		map.h[11499 + i] = v57;
		i += 2;
	}
	i = 0;
	map.h[11506] = 11507;
	while(i < 46) {
		var v58 = 42561 + i;
		map.h[42560 + i] = v58;
		i += 2;
	}
	i = 0;
	while(i < 28) {
		var v59 = 42625 + i;
		map.h[42624 + i] = v59;
		i += 2;
	}
	i = 0;
	while(i < 14) {
		var v60 = 42787 + i;
		map.h[42786 + i] = v60;
		i += 2;
	}
	i = 0;
	while(i < 62) {
		var v61 = 42803 + i;
		map.h[42802 + i] = v61;
		i += 2;
	}
	i = 0;
	while(i < 4) {
		var v62 = 42874 + i;
		map.h[42873 + i] = v62;
		i += 2;
	}
	i = 0;
	map.h[42877] = 7545;
	while(i < 10) {
		var v63 = 42879 + i;
		map.h[42878 + i] = v63;
		i += 2;
	}
	i = 0;
	map.h[42891] = 42892;
	map.h[42893] = 613;
	while(i < 4) {
		var v64 = 42897 + i;
		map.h[42896 + i] = v64;
		i += 2;
	}
	i = 0;
	while(i < 20) {
		var v65 = 42903 + i;
		map.h[42902 + i] = v65;
		i += 2;
	}
	i = 0;
	map.h[42922] = 614;
	map.h[42923] = 604;
	map.h[42924] = 609;
	map.h[42925] = 620;
	map.h[42926] = 618;
	map.h[42928] = 670;
	map.h[42929] = 647;
	map.h[42930] = 669;
	map.h[42931] = 43859;
	while(i < 4) {
		var v66 = 42933 + i;
		map.h[42932 + i] = v66;
		i += 2;
	}
	i = 0;
	var _g33 = 0;
	while(_g33 < 26) {
		var i34 = _g33++;
		var v67 = 65345 + i34;
		map.h[65313 + i34] = v67;
	}
	var _g34 = 0;
	while(_g34 < 40) {
		var i35 = _g34++;
		var v68 = 66600 + i35;
		map.h[66560 + i35] = v68;
	}
	var _g35 = 0;
	while(_g35 < 36) {
		var i36 = _g35++;
		var v69 = 66776 + i36;
		map.h[66736 + i36] = v69;
	}
	var _g36 = 0;
	while(_g36 < 51) {
		var i37 = _g36++;
		var v70 = 68800 + i37;
		map.h[68736 + i37] = v70;
	}
	var _g37 = 0;
	while(_g37 < 32) {
		var i38 = _g37++;
		var v71 = 71872 + i38;
		map.h[71840 + i38] = v71;
	}
	var _g38 = 0;
	while(_g38 < 34) {
		var i39 = _g38++;
		var v72 = 125218 + i39;
		map.h[125184 + i39] = v72;
	}
};
lime_text__$UTF8String_Utf8Ext.fillLowerToUpperMap = function(map) {
	var i = 0;
	var _g = 0;
	while(_g < 26) {
		var i1 = _g++;
		var v = 65 + i1;
		map.h[97 + i1] = v;
	}
	map.h[181] = 924;
	var _g1 = 0;
	while(_g1 < 23) {
		var i2 = _g1++;
		var v1 = 192 + i2;
		map.h[224 + i2] = v1;
	}
	var _g2 = 0;
	while(_g2 < 7) {
		var i3 = _g2++;
		var v2 = 216 + i3;
		map.h[248 + i3] = v2;
	}
	map.h[255] = 376;
	while(i < 48) {
		var v3 = 256 + i;
		map.h[257 + i] = v3;
		i += 2;
	}
	i = 0;
	map.h[305] = 73;
	while(i < 6) {
		var v4 = 306 + i;
		map.h[307 + i] = v4;
		i += 2;
	}
	i = 0;
	while(i < 16) {
		var v5 = 313 + i;
		map.h[314 + i] = v5;
		i += 2;
	}
	i = 0;
	while(i < 46) {
		var v6 = 330 + i;
		map.h[331 + i] = v6;
		i += 2;
	}
	i = 0;
	while(i < 6) {
		var v7 = 377 + i;
		map.h[378 + i] = v7;
		i += 2;
	}
	i = 0;
	map.h[383] = 83;
	map.h[384] = 579;
	while(i < 4) {
		var v8 = 386 + i;
		map.h[387 + i] = v8;
		i += 2;
	}
	i = 0;
	map.h[392] = 391;
	map.h[396] = 395;
	map.h[402] = 401;
	map.h[405] = 502;
	map.h[409] = 408;
	map.h[410] = 573;
	map.h[414] = 544;
	while(i < 6) {
		var v9 = 416 + i;
		map.h[417 + i] = v9;
		i += 2;
	}
	i = 0;
	map.h[424] = 423;
	map.h[429] = 428;
	map.h[432] = 431;
	while(i < 4) {
		var v10 = 435 + i;
		map.h[436 + i] = v10;
		i += 2;
	}
	i = 0;
	map.h[441] = 440;
	map.h[445] = 444;
	map.h[447] = 503;
	map.h[454] = 452;
	map.h[457] = 455;
	map.h[460] = 458;
	while(i < 16) {
		var v11 = 461 + i;
		map.h[462 + i] = v11;
		i += 2;
	}
	i = 0;
	map.h[477] = 398;
	while(i < 18) {
		var v12 = 478 + i;
		map.h[479 + i] = v12;
		i += 2;
	}
	i = 0;
	map.h[496] = 74;
	map.h[499] = 497;
	map.h[501] = 500;
	while(i < 40) {
		var v13 = 504 + i;
		map.h[505 + i] = v13;
		i += 2;
	}
	i = 0;
	while(i < 18) {
		var v14 = 546 + i;
		map.h[547 + i] = v14;
		i += 2;
	}
	i = 0;
	map.h[572] = 571;
	var _g3 = 0;
	while(_g3 < 2) {
		var i4 = _g3++;
		var v15 = 11390 + i4;
		map.h[575 + i4] = v15;
	}
	map.h[578] = 577;
	while(i < 10) {
		var v16 = 582 + i;
		map.h[583 + i] = v16;
		i += 2;
	}
	i = 0;
	map.h[592] = 11375;
	map.h[593] = 11373;
	map.h[594] = 11376;
	map.h[595] = 385;
	map.h[596] = 390;
	var _g4 = 0;
	while(_g4 < 2) {
		var i5 = _g4++;
		var v17 = 393 + i5;
		map.h[598 + i5] = v17;
	}
	map.h[601] = 399;
	map.h[603] = 400;
	map.h[604] = 42923;
	map.h[608] = 403;
	map.h[609] = 42924;
	map.h[611] = 404;
	map.h[613] = 42893;
	map.h[614] = 42922;
	map.h[616] = 407;
	map.h[617] = 406;
	map.h[618] = 42926;
	map.h[619] = 11362;
	map.h[620] = 42925;
	map.h[623] = 412;
	map.h[625] = 11374;
	map.h[626] = 413;
	map.h[629] = 415;
	map.h[637] = 11364;
	map.h[640] = 422;
	map.h[643] = 425;
	map.h[647] = 42929;
	map.h[648] = 430;
	map.h[649] = 580;
	var _g5 = 0;
	while(_g5 < 2) {
		var i6 = _g5++;
		var v18 = 433 + i6;
		map.h[650 + i6] = v18;
	}
	map.h[652] = 581;
	map.h[658] = 439;
	map.h[669] = 42930;
	map.h[670] = 42928;
	while(i < 4) {
		var v19 = 880 + i;
		map.h[881 + i] = v19;
		i += 2;
	}
	i = 0;
	map.h[887] = 886;
	var _g6 = 0;
	while(_g6 < 3) {
		var i7 = _g6++;
		var v20 = 1021 + i7;
		map.h[891 + i7] = v20;
	}
	map.h[912] = 938;
	map.h[940] = 902;
	var _g7 = 0;
	while(_g7 < 3) {
		var i8 = _g7++;
		var v21 = 904 + i8;
		map.h[941 + i8] = v21;
	}
	map.h[944] = 939;
	var _g8 = 0;
	while(_g8 < 17) {
		var i9 = _g8++;
		var v22 = 913 + i9;
		map.h[945 + i9] = v22;
	}
	map.h[962] = 931;
	var _g9 = 0;
	while(_g9 < 9) {
		var i10 = _g9++;
		var v23 = 931 + i10;
		map.h[963 + i10] = v23;
	}
	map.h[972] = 908;
	var _g10 = 0;
	while(_g10 < 2) {
		var i11 = _g10++;
		var v24 = 910 + i11;
		map.h[973 + i11] = v24;
	}
	map.h[976] = 914;
	map.h[977] = 920;
	map.h[981] = 934;
	map.h[982] = 928;
	map.h[983] = 975;
	while(i < 24) {
		var v25 = 984 + i;
		map.h[985 + i] = v25;
		i += 2;
	}
	i = 0;
	map.h[1008] = 922;
	map.h[1009] = 929;
	map.h[1010] = 1017;
	map.h[1011] = 895;
	map.h[1013] = 917;
	map.h[1016] = 1015;
	map.h[1019] = 1018;
	var _g11 = 0;
	while(_g11 < 32) {
		var i12 = _g11++;
		var v26 = 1040 + i12;
		map.h[1072 + i12] = v26;
	}
	var _g12 = 0;
	while(_g12 < 16) {
		var i13 = _g12++;
		var v27 = 1024 + i13;
		map.h[1104 + i13] = v27;
	}
	while(i < 34) {
		var v28 = 1120 + i;
		map.h[1121 + i] = v28;
		i += 2;
	}
	i = 0;
	while(i < 54) {
		var v29 = 1162 + i;
		map.h[1163 + i] = v29;
		i += 2;
	}
	i = 0;
	while(i < 14) {
		var v30 = 1217 + i;
		map.h[1218 + i] = v30;
		i += 2;
	}
	i = 0;
	map.h[1231] = 1216;
	while(i < 96) {
		var v31 = 1232 + i;
		map.h[1233 + i] = v31;
		i += 2;
	}
	i = 0;
	var _g13 = 0;
	while(_g13 < 38) {
		var i14 = _g13++;
		var v32 = 1329 + i14;
		map.h[1377 + i14] = v32;
	}
	var _g14 = 0;
	while(_g14 < 6) {
		var i15 = _g14++;
		var v33 = 5104 + i15;
		map.h[5112 + i15] = v33;
	}
	map.h[7296] = 1042;
	map.h[7297] = 1044;
	map.h[7298] = 1054;
	var _g15 = 0;
	while(_g15 < 2) {
		var i16 = _g15++;
		var v34 = 1057 + i16;
		map.h[7299 + i16] = v34;
	}
	map.h[7301] = 1058;
	map.h[7302] = 1066;
	map.h[7303] = 1122;
	map.h[7304] = 42570;
	map.h[7545] = 42877;
	map.h[7549] = 11363;
	while(i < 150) {
		var v35 = 7680 + i;
		map.h[7681 + i] = v35;
		i += 2;
	}
	i = 0;
	map.h[7830] = 72;
	map.h[7831] = 84;
	map.h[7832] = 87;
	map.h[7833] = 89;
	map.h[7835] = 7776;
	while(i < 96) {
		var v36 = 7840 + i;
		map.h[7841 + i] = v36;
		i += 2;
	}
	i = 0;
	var _g16 = 0;
	while(_g16 < 8) {
		var i17 = _g16++;
		var v37 = 7944 + i17;
		map.h[7936 + i17] = v37;
	}
	var _g17 = 0;
	while(_g17 < 6) {
		var i18 = _g17++;
		var v38 = 7960 + i18;
		map.h[7952 + i18] = v38;
	}
	var _g18 = 0;
	while(_g18 < 8) {
		var i19 = _g18++;
		var v39 = 7976 + i19;
		map.h[7968 + i19] = v39;
	}
	var _g19 = 0;
	while(_g19 < 8) {
		var i20 = _g19++;
		var v40 = 7992 + i20;
		map.h[7984 + i20] = v40;
	}
	var _g20 = 0;
	while(_g20 < 6) {
		var i21 = _g20++;
		var v41 = 8008 + i21;
		map.h[8000 + i21] = v41;
	}
	map.h[8016] = 933;
	map.h[8017] = 8025;
	map.h[8018] = 933;
	map.h[8019] = 8027;
	map.h[8020] = 933;
	map.h[8021] = 8029;
	map.h[8022] = 933;
	map.h[8023] = 8031;
	var _g21 = 0;
	while(_g21 < 8) {
		var i22 = _g21++;
		var v42 = 8040 + i22;
		map.h[8032 + i22] = v42;
	}
	var _g22 = 0;
	while(_g22 < 2) {
		var i23 = _g22++;
		var v43 = 8122 + i23;
		map.h[8048 + i23] = v43;
	}
	var _g23 = 0;
	while(_g23 < 4) {
		var i24 = _g23++;
		var v44 = 8136 + i24;
		map.h[8050 + i24] = v44;
	}
	var _g24 = 0;
	while(_g24 < 2) {
		var i25 = _g24++;
		var v45 = 8154 + i25;
		map.h[8054 + i25] = v45;
	}
	var _g25 = 0;
	while(_g25 < 2) {
		var i26 = _g25++;
		var v46 = 8184 + i26;
		map.h[8056 + i26] = v46;
	}
	var _g26 = 0;
	while(_g26 < 2) {
		var i27 = _g26++;
		var v47 = 8170 + i27;
		map.h[8058 + i27] = v47;
	}
	var _g27 = 0;
	while(_g27 < 2) {
		var i28 = _g27++;
		var v48 = 8186 + i28;
		map.h[8060 + i28] = v48;
	}
	var _g28 = 0;
	while(_g28 < 8) {
		var i29 = _g28++;
		var v49 = 8072 + i29;
		map.h[8064 + i29] = v49;
	}
	var _g29 = 0;
	while(_g29 < 8) {
		var i30 = _g29++;
		var v50 = 8088 + i30;
		map.h[8080 + i30] = v50;
	}
	var _g30 = 0;
	while(_g30 < 8) {
		var i31 = _g30++;
		var v51 = 8104 + i31;
		map.h[8096 + i31] = v51;
	}
	var _g31 = 0;
	while(_g31 < 3) {
		var i32 = _g31++;
		var v52 = 8120 + i32;
		map.h[8112 + i32] = v52;
	}
	map.h[8115] = 8124;
	map.h[8116] = 902;
	map.h[8118] = 913;
	map.h[8119] = 913;
	map.h[8126] = 921;
	map.h[8130] = 8138;
	map.h[8131] = 8140;
	map.h[8132] = 905;
	map.h[8134] = 919;
	map.h[8135] = 919;
	var _g32 = 0;
	while(_g32 < 2) {
		var i33 = _g32++;
		var v53 = 8152 + i33;
		map.h[8144 + i33] = v53;
	}
	map.h[8146] = 938;
	map.h[8147] = 938;
	map.h[8150] = 921;
	map.h[8151] = 938;
	var _g33 = 0;
	while(_g33 < 2) {
		var i34 = _g33++;
		var v54 = 8168 + i34;
		map.h[8160 + i34] = v54;
	}
	map.h[8162] = 939;
	map.h[8163] = 939;
	map.h[8164] = 929;
	map.h[8165] = 8172;
	map.h[8166] = 933;
	map.h[8167] = 939;
	map.h[8178] = 8186;
	map.h[8179] = 8188;
	map.h[8180] = 911;
	map.h[8182] = 937;
	map.h[8183] = 937;
	map.h[8526] = 8498;
	map.h[8580] = 8579;
	var _g34 = 0;
	while(_g34 < 47) {
		var i35 = _g34++;
		var v55 = 11264 + i35;
		map.h[11312 + i35] = v55;
	}
	map.h[11361] = 11360;
	map.h[11365] = 570;
	map.h[11366] = 574;
	while(i < 6) {
		var v56 = 11367 + i;
		map.h[11368 + i] = v56;
		i += 2;
	}
	i = 0;
	map.h[11379] = 11378;
	map.h[11382] = 11381;
	while(i < 100) {
		var v57 = 11392 + i;
		map.h[11393 + i] = v57;
		i += 2;
	}
	i = 0;
	while(i < 4) {
		var v58 = 11499 + i;
		map.h[11500 + i] = v58;
		i += 2;
	}
	i = 0;
	map.h[11507] = 11506;
	var _g35 = 0;
	while(_g35 < 38) {
		var i36 = _g35++;
		var v59 = 4256 + i36;
		map.h[11520 + i36] = v59;
	}
	map.h[11559] = 4295;
	map.h[11565] = 4301;
	while(i < 46) {
		var v60 = 42560 + i;
		map.h[42561 + i] = v60;
		i += 2;
	}
	i = 0;
	while(i < 28) {
		var v61 = 42624 + i;
		map.h[42625 + i] = v61;
		i += 2;
	}
	i = 0;
	while(i < 14) {
		var v62 = 42786 + i;
		map.h[42787 + i] = v62;
		i += 2;
	}
	i = 0;
	while(i < 62) {
		var v63 = 42802 + i;
		map.h[42803 + i] = v63;
		i += 2;
	}
	i = 0;
	while(i < 4) {
		var v64 = 42873 + i;
		map.h[42874 + i] = v64;
		i += 2;
	}
	i = 0;
	while(i < 10) {
		var v65 = 42878 + i;
		map.h[42879 + i] = v65;
		i += 2;
	}
	i = 0;
	map.h[42892] = 42891;
	while(i < 4) {
		var v66 = 42896 + i;
		map.h[42897 + i] = v66;
		i += 2;
	}
	i = 0;
	while(i < 20) {
		var v67 = 42902 + i;
		map.h[42903 + i] = v67;
		i += 2;
	}
	i = 0;
	while(i < 4) {
		var v68 = 42932 + i;
		map.h[42933 + i] = v68;
		i += 2;
	}
	i = 0;
	map.h[43859] = 42931;
	var _g36 = 0;
	while(_g36 < 80) {
		var i37 = _g36++;
		var v69 = 5024 + i37;
		map.h[43888 + i37] = v69;
	}
	var _g37 = 0;
	while(_g37 < 26) {
		var i38 = _g37++;
		var v70 = 65313 + i38;
		map.h[65345 + i38] = v70;
	}
	var _g38 = 0;
	while(_g38 < 40) {
		var i39 = _g38++;
		var v71 = 66560 + i39;
		map.h[66600 + i39] = v71;
	}
	var _g39 = 0;
	while(_g39 < 36) {
		var i40 = _g39++;
		var v72 = 66736 + i40;
		map.h[66776 + i40] = v72;
	}
	var _g40 = 0;
	while(_g40 < 51) {
		var i41 = _g40++;
		var v73 = 68736 + i41;
		map.h[68800 + i41] = v73;
	}
	var _g41 = 0;
	while(_g41 < 32) {
		var i42 = _g41++;
		var v74 = 71840 + i42;
		map.h[71872 + i42] = v74;
	}
	var _g42 = 0;
	while(_g42 < 34) {
		var i43 = _g42++;
		var v75 = 125184 + i43;
		map.h[125218 + i43] = v75;
	}
};
var lime_text_harfbuzz_HB = function() { };
$hxClasses["lime.text.harfbuzz.HB"] = lime_text_harfbuzz_HB;
lime_text_harfbuzz_HB.__name__ = ["lime","text","harfbuzz","HB"];
lime_text_harfbuzz_HB.shape = function(font,buffer,features) {
};
var lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$ = {};
$hxClasses["lime.text.harfbuzz._HBBlob.HBBlob_Impl_"] = lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$;
lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$.__name__ = ["lime","text","harfbuzz","_HBBlob","HBBlob_Impl_"];
lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$.__properties__ = {get_length:"get_length",get_immutable:"get_immutable",get_dataWritable:"get_dataWritable",get_data:"get_data",get_empty:"get_empty"};
lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$._new = function(data,length,memoryMode) {
	var this1 = null;
	return this1;
};
lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$.createSubBlob = function(this1,offset,length) {
	return null;
};
lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$.makeImmutable = function(this1) {
};
lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$.get_data = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$.get_dataWritable = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$.get_empty = function() {
	return null;
};
lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$.get_immutable = function(this1) {
	return false;
};
lime_text_harfbuzz__$HBBlob_HBBlob_$Impl_$.get_length = function(this1) {
	return 0;
};
var lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$ = {};
$hxClasses["lime.text.harfbuzz._HBBuffer.HBBuffer_Impl_"] = lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$;
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.__name__ = ["lime","text","harfbuzz","_HBBuffer","HBBuffer_Impl_"];
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.__properties__ = {set_segmentProperties:"set_segmentProperties",get_segmentProperties:"get_segmentProperties",set_script:"set_script",get_script:"get_script",set_replacementCodepoint:"set_replacementCodepoint",get_replacementCodepoint:"get_replacementCodepoint",set_length:"set_length",get_length:"get_length",set_language:"set_language",get_language:"get_language",set_flags:"set_flags",get_flags:"get_flags",set_direction:"set_direction",get_direction:"get_direction",set_contentType:"set_contentType",get_contentType:"get_contentType",set_clusterLevel:"set_clusterLevel",get_clusterLevel:"get_clusterLevel",get_allocationSuccessful:"get_allocationSuccessful"};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$._new = function() {
	var this1 = null;
	return this1;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.add = function(this1,codepoint,cluster) {
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.addCodepoints = function(this1,text,textLength,itemOffset,itemLength) {
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.addUTF8 = function(this1,text,itemOffset,itemLength) {
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.addUTF16 = function(this1,text,textLength,itemOffset,itemLength) {
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.addUTF32 = function(this1,text,textLength,itemOffset,itemLength) {
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.clearContents = function(this1) {
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.getGlyphInfo = function(this1) {
	return null;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.getGlyphPositions = function(this1) {
	return null;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.guessSegmentProperties = function(this1) {
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.normalizeGlyphs = function(this1) {
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.preallocate = function(this1,size) {
	return false;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.reset = function(this1) {
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.reverse = function(this1) {
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.reverseClusters = function(this1) {
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.get_allocationSuccessful = function(this1) {
	return false;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.get_clusterLevel = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.set_clusterLevel = function(this1,value) {
	return value;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.get_contentType = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.set_contentType = function(this1,value) {
	return value;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.get_direction = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.set_direction = function(this1,value) {
	return value;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.get_empty = function() {
	return null;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.get_flags = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.set_flags = function(this1,value) {
	return value;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.get_language = function(this1) {
	return null;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.set_language = function(this1,value) {
	return value;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.get_length = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.set_length = function(this1,value) {
	return value;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.get_replacementCodepoint = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.set_replacementCodepoint = function(this1,value) {
	return value;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.get_script = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.set_script = function(this1,value) {
	return value;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.get_segmentProperties = function(this1) {
	return null;
};
lime_text_harfbuzz__$HBBuffer_HBBuffer_$Impl_$.set_segmentProperties = function(this1,value) {
	return value;
};
var lime_text_harfbuzz__$HBFTFont_HBFTFont_$Impl_$ = {};
$hxClasses["lime.text.harfbuzz._HBFTFont.HBFTFont_Impl_"] = lime_text_harfbuzz__$HBFTFont_HBFTFont_$Impl_$;
lime_text_harfbuzz__$HBFTFont_HBFTFont_$Impl_$.__name__ = ["lime","text","harfbuzz","_HBFTFont","HBFTFont_Impl_"];
lime_text_harfbuzz__$HBFTFont_HBFTFont_$Impl_$.__properties__ = {set_loadFlags:"set_loadFlags",get_loadFlags:"get_loadFlags"};
lime_text_harfbuzz__$HBFTFont_HBFTFont_$Impl_$._new = function(font) {
	var this1;
	if(font.src != null) {
		this1 = null;
	} else {
		this1 = null;
	}
	return this1;
};
lime_text_harfbuzz__$HBFTFont_HBFTFont_$Impl_$.get_loadFlags = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBFTFont_HBFTFont_$Impl_$.set_loadFlags = function(this1,value) {
	return value;
};
var lime_text_harfbuzz__$HBFace_HBFace_$Impl_$ = {};
$hxClasses["lime.text.harfbuzz._HBFace.HBFace_Impl_"] = lime_text_harfbuzz__$HBFace_HBFace_$Impl_$;
lime_text_harfbuzz__$HBFace_HBFace_$Impl_$.__name__ = ["lime","text","harfbuzz","_HBFace","HBFace_Impl_"];
lime_text_harfbuzz__$HBFace_HBFace_$Impl_$.__properties__ = {set_upem:"set_upem",get_upem:"get_upem",set_index:"set_index",get_index:"get_index",get_immutable:"get_immutable",set_glyphCount:"set_glyphCount",get_glyphCount:"get_glyphCount",get_empty:"get_empty"};
lime_text_harfbuzz__$HBFace_HBFace_$Impl_$._new = function(blob,index) {
	var this1 = null;
	return this1;
};
lime_text_harfbuzz__$HBFace_HBFace_$Impl_$.get_empty = function() {
	return null;
};
lime_text_harfbuzz__$HBFace_HBFace_$Impl_$.get_glyphCount = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBFace_HBFace_$Impl_$.set_glyphCount = function(this1,value) {
	return value;
};
lime_text_harfbuzz__$HBFace_HBFace_$Impl_$.get_immutable = function(this1) {
	return false;
};
lime_text_harfbuzz__$HBFace_HBFace_$Impl_$.get_index = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBFace_HBFace_$Impl_$.set_index = function(this1,value) {
	return value;
};
lime_text_harfbuzz__$HBFace_HBFace_$Impl_$.get_upem = function(this1) {
	return 0;
};
lime_text_harfbuzz__$HBFace_HBFace_$Impl_$.set_upem = function(this1,value) {
	return value;
};
var lime_text_harfbuzz_HBFeature = function() {
};
$hxClasses["lime.text.harfbuzz.HBFeature"] = lime_text_harfbuzz_HBFeature;
lime_text_harfbuzz_HBFeature.__name__ = ["lime","text","harfbuzz","HBFeature"];
lime_text_harfbuzz_HBFeature.prototype = {
	__class__: lime_text_harfbuzz_HBFeature
};
var lime_text_harfbuzz__$HBFont_HBFont_$Impl_$ = {};
$hxClasses["lime.text.harfbuzz._HBFont.HBFont_Impl_"] = lime_text_harfbuzz__$HBFont_HBFont_$Impl_$;
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.__name__ = ["lime","text","harfbuzz","_HBFont","HBFont_Impl_"];
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.__properties__ = {set_scale:"set_scale",get_scale:"get_scale",set_ppem:"set_ppem",get_ppem:"get_ppem",get_parent:"get_parent",get_immutable:"get_immutable",get_face:"get_face",get_empty:"get_empty"};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$._new = function(face) {
	var this1 = null;
	return this1;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.addGlyphOriginForDirection = function(this1,glyph,direction,x,y) {
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.createSubFont = function(this1) {
	return null;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.getGlyphAdvanceForDirection = function(this1,glyph,direction) {
	return null;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.getGlyphKerningForDirection = function(this1,glyph,firstGlyph,secondGlyph,direction) {
	return null;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.getGlyphOriginForDirection = function(this1,glyph,direction) {
	return null;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.glyphFromString = function(this1,s) {
	return 0;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.glyphToString = function(this1,codepoint) {
	return null;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.makeImmutable = function(this1) {
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.subtractGlyphOriginForDirection = function(this1,glyph,direction,x,y) {
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.get_empty = function() {
	return null;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.get_face = function(this1) {
	return null;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.get_immutable = function(this1) {
	return false;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.get_parent = function(this1) {
	return null;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.get_ppem = function(this1) {
	return null;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.set_ppem = function(this1,value) {
	return value;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.get_scale = function(this1) {
	return null;
};
lime_text_harfbuzz__$HBFont_HBFont_$Impl_$.set_scale = function(this1,value) {
	return value;
};
var lime_text_harfbuzz_HBGlyphInfo = function() {
};
$hxClasses["lime.text.harfbuzz.HBGlyphInfo"] = lime_text_harfbuzz_HBGlyphInfo;
lime_text_harfbuzz_HBGlyphInfo.__name__ = ["lime","text","harfbuzz","HBGlyphInfo"];
lime_text_harfbuzz_HBGlyphInfo.prototype = {
	__class__: lime_text_harfbuzz_HBGlyphInfo
};
var lime_text_harfbuzz_HBGlyphPosition = function() {
};
$hxClasses["lime.text.harfbuzz.HBGlyphPosition"] = lime_text_harfbuzz_HBGlyphPosition;
lime_text_harfbuzz_HBGlyphPosition.__name__ = ["lime","text","harfbuzz","HBGlyphPosition"];
lime_text_harfbuzz_HBGlyphPosition.prototype = {
	__class__: lime_text_harfbuzz_HBGlyphPosition
};
var lime_text_harfbuzz__$HBLanguage_HBLanguage_$Impl_$ = {};
$hxClasses["lime.text.harfbuzz._HBLanguage.HBLanguage_Impl_"] = lime_text_harfbuzz__$HBLanguage_HBLanguage_$Impl_$;
lime_text_harfbuzz__$HBLanguage_HBLanguage_$Impl_$.__name__ = ["lime","text","harfbuzz","_HBLanguage","HBLanguage_Impl_"];
lime_text_harfbuzz__$HBLanguage_HBLanguage_$Impl_$._new = function(language) {
	var this1 = null;
	return this1;
};
lime_text_harfbuzz__$HBLanguage_HBLanguage_$Impl_$.toString = function(this1) {
	return null;
};
lime_text_harfbuzz__$HBLanguage_HBLanguage_$Impl_$.fromString = function(value) {
	return lime_text_harfbuzz__$HBLanguage_HBLanguage_$Impl_$._new(value);
};
var lime_text_harfbuzz_HBSegmentProperties = function() {
};
$hxClasses["lime.text.harfbuzz.HBSegmentProperties"] = lime_text_harfbuzz_HBSegmentProperties;
lime_text_harfbuzz_HBSegmentProperties.__name__ = ["lime","text","harfbuzz","HBSegmentProperties"];
lime_text_harfbuzz_HBSegmentProperties.prototype = {
	__class__: lime_text_harfbuzz_HBSegmentProperties
};
var lime_ui_Gamepad = function(id) {
	this.onDisconnect = new lime_app__$Event_$Void_$Void();
	this.onButtonUp = new lime_app__$Event_$lime_$ui_$GamepadButton_$Void();
	this.onButtonDown = new lime_app__$Event_$lime_$ui_$GamepadButton_$Void();
	this.onAxisMove = new lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void();
	this.id = id;
	this.connected = true;
};
$hxClasses["lime.ui.Gamepad"] = lime_ui_Gamepad;
lime_ui_Gamepad.__name__ = ["lime","ui","Gamepad"];
lime_ui_Gamepad.addMappings = function(mappings) {
};
lime_ui_Gamepad.__connect = function(id) {
	if(!lime_ui_Gamepad.devices.h.hasOwnProperty(id)) {
		var gamepad = new lime_ui_Gamepad(id);
		lime_ui_Gamepad.devices.h[id] = gamepad;
		lime_ui_Gamepad.onConnect.dispatch(gamepad);
	}
};
lime_ui_Gamepad.__disconnect = function(id) {
	var gamepad = lime_ui_Gamepad.devices.h[id];
	if(gamepad != null) {
		gamepad.connected = false;
	}
	lime_ui_Gamepad.devices.remove(id);
	if(gamepad != null) {
		gamepad.onDisconnect.dispatch();
	}
};
lime_ui_Gamepad.prototype = {
	get_guid: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].id;
	}
	,get_name: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].id;
	}
	,__class__: lime_ui_Gamepad
	,__properties__: {get_name:"get_name",get_guid:"get_guid"}
};
var lime_ui__$GamepadAxis_GamepadAxis_$Impl_$ = {};
$hxClasses["lime.ui._GamepadAxis.GamepadAxis_Impl_"] = lime_ui__$GamepadAxis_GamepadAxis_$Impl_$;
lime_ui__$GamepadAxis_GamepadAxis_$Impl_$.__name__ = ["lime","ui","_GamepadAxis","GamepadAxis_Impl_"];
lime_ui__$GamepadAxis_GamepadAxis_$Impl_$.toString = function(this1) {
	switch(this1) {
	case 0:
		return "LEFT_X";
	case 1:
		return "LEFT_Y";
	case 2:
		return "RIGHT_X";
	case 3:
		return "RIGHT_Y";
	case 4:
		return "TRIGGER_LEFT";
	case 5:
		return "TRIGGER_RIGHT";
	default:
		return "UNKNOWN (" + this1 + ")";
	}
};
var lime_ui__$GamepadButton_GamepadButton_$Impl_$ = {};
$hxClasses["lime.ui._GamepadButton.GamepadButton_Impl_"] = lime_ui__$GamepadButton_GamepadButton_$Impl_$;
lime_ui__$GamepadButton_GamepadButton_$Impl_$.__name__ = ["lime","ui","_GamepadButton","GamepadButton_Impl_"];
lime_ui__$GamepadButton_GamepadButton_$Impl_$.toString = function(this1) {
	switch(this1) {
	case 0:
		return "A";
	case 1:
		return "B";
	case 2:
		return "X";
	case 3:
		return "Y";
	case 4:
		return "BACK";
	case 5:
		return "GUIDE";
	case 6:
		return "START";
	case 7:
		return "LEFT_STICK";
	case 8:
		return "RIGHT_STICK";
	case 9:
		return "LEFT_SHOULDER";
	case 10:
		return "RIGHT_SHOULDER";
	case 11:
		return "DPAD_UP";
	case 12:
		return "DPAD_DOWN";
	case 13:
		return "DPAD_LEFT";
	case 14:
		return "DPAD_RIGHT";
	default:
		return "UNKNOWN (" + this1 + ")";
	}
};
var lime_ui_Joystick = function(id) {
	this.onTrackballMove = new lime_app__$Event_$Int_$Float_$Float_$Void();
	this.onHatMove = new lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void();
	this.onDisconnect = new lime_app__$Event_$Void_$Void();
	this.onButtonUp = new lime_app__$Event_$Int_$Void();
	this.onButtonDown = new lime_app__$Event_$Int_$Void();
	this.onAxisMove = new lime_app__$Event_$Int_$Float_$Void();
	this.id = id;
	this.connected = true;
};
$hxClasses["lime.ui.Joystick"] = lime_ui_Joystick;
lime_ui_Joystick.__name__ = ["lime","ui","Joystick"];
lime_ui_Joystick.__connect = function(id) {
	if(!lime_ui_Joystick.devices.h.hasOwnProperty(id)) {
		var joystick = new lime_ui_Joystick(id);
		lime_ui_Joystick.devices.h[id] = joystick;
		lime_ui_Joystick.onConnect.dispatch(joystick);
	}
};
lime_ui_Joystick.__disconnect = function(id) {
	var joystick = lime_ui_Joystick.devices.h[id];
	if(joystick != null) {
		joystick.connected = false;
	}
	lime_ui_Joystick.devices.remove(id);
	if(joystick != null) {
		joystick.onDisconnect.dispatch();
	}
};
lime_ui_Joystick.__getDeviceData = function() {
	if(navigator.getGamepads) {
		return navigator.getGamepads();
	} else if(navigator.webkitGetGamepads) {
		return navigator.webkitGetGamepads();
	} else {
		return null;
	}
};
lime_ui_Joystick.prototype = {
	get_guid: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].id;
	}
	,get_name: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].id;
	}
	,get_numAxes: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].axes.length;
	}
	,get_numButtons: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].buttons.length;
	}
	,get_numHats: function() {
		return 0;
	}
	,get_numTrackballs: function() {
		return 0;
	}
	,__class__: lime_ui_Joystick
	,__properties__: {get_numTrackballs:"get_numTrackballs",get_numHats:"get_numHats",get_numButtons:"get_numButtons",get_numAxes:"get_numAxes",get_name:"get_name",get_guid:"get_guid"}
};
var lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$ = {};
$hxClasses["lime.ui._JoystickHatPosition.JoystickHatPosition_Impl_"] = lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$;
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.__name__ = ["lime","ui","_JoystickHatPosition","JoystickHatPosition_Impl_"];
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.__properties__ = {set_up:"set_up",get_up:"get_up",set_right:"set_right",get_right:"get_right",set_left:"set_left",get_left:"get_left",set_down:"set_down",get_down:"get_down",set_center:"set_center",get_center:"get_center"};
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$._new = function(value) {
	var this1 = value;
	return this1;
};
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.get_center = function(this1) {
	return this1 == 0;
};
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.set_center = function(this1,value) {
	if(value) {
		this1 = 0;
	}
	return value;
};
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.get_down = function(this1) {
	return (this1 & 4) > 0;
};
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.set_down = function(this1,value) {
	if(value) {
		this1 |= 4;
	} else {
		this1 &= 268435455 - 4;
	}
	return value;
};
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.get_left = function(this1) {
	return (this1 & 8) > 0;
};
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.set_left = function(this1,value) {
	if(value) {
		this1 |= 8;
	} else {
		this1 &= 268435455 - 8;
	}
	return value;
};
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.get_right = function(this1) {
	return (this1 & 2) > 0;
};
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.set_right = function(this1,value) {
	if(value) {
		this1 |= 2;
	} else {
		this1 &= 268435455 - 2;
	}
	return value;
};
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.get_up = function(this1) {
	return (this1 & 1) > 0;
};
lime_ui__$JoystickHatPosition_JoystickHatPosition_$Impl_$.set_up = function(this1,value) {
	if(value) {
		this1 |= 1;
	} else {
		this1 &= 268435455 - 1;
	}
	return value;
};
var lime_ui__$KeyCode_KeyCode_$Impl_$ = {};
$hxClasses["lime.ui._KeyCode.KeyCode_Impl_"] = lime_ui__$KeyCode_KeyCode_$Impl_$;
lime_ui__$KeyCode_KeyCode_$Impl_$.__name__ = ["lime","ui","_KeyCode","KeyCode_Impl_"];
lime_ui__$KeyCode_KeyCode_$Impl_$.fromScanCode = function(scanCode) {
	return 0;
};
lime_ui__$KeyCode_KeyCode_$Impl_$.toScanCode = function(keyCode) {
	return 0;
};
lime_ui__$KeyCode_KeyCode_$Impl_$.gt = function(a,b) {
	return a > b;
};
lime_ui__$KeyCode_KeyCode_$Impl_$.gte = function(a,b) {
	return a >= b;
};
lime_ui__$KeyCode_KeyCode_$Impl_$.lt = function(a,b) {
	return a < b;
};
lime_ui__$KeyCode_KeyCode_$Impl_$.lte = function(a,b) {
	return a <= b;
};
lime_ui__$KeyCode_KeyCode_$Impl_$.plus = function(a,b) {
	return a + b;
};
var lime_ui__$KeyModifier_KeyModifier_$Impl_$ = {};
$hxClasses["lime.ui._KeyModifier.KeyModifier_Impl_"] = lime_ui__$KeyModifier_KeyModifier_$Impl_$;
lime_ui__$KeyModifier_KeyModifier_$Impl_$.__name__ = ["lime","ui","_KeyModifier","KeyModifier_Impl_"];
lime_ui__$KeyModifier_KeyModifier_$Impl_$.__properties__ = {set_shiftKey:"set_shiftKey",get_shiftKey:"get_shiftKey",set_numLock:"set_numLock",get_numLock:"get_numLock",set_metaKey:"set_metaKey",get_metaKey:"get_metaKey",set_ctrlKey:"set_ctrlKey",get_ctrlKey:"get_ctrlKey",set_capsLock:"set_capsLock",get_capsLock:"get_capsLock",set_altKey:"set_altKey",get_altKey:"get_altKey"};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.get_altKey = function(this1) {
	if((this1 & 256) <= 0) {
		return (this1 & 512) > 0;
	} else {
		return true;
	}
};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.set_altKey = function(this1,value) {
	if(value) {
		this1 |= 768;
	} else {
		this1 &= 268435455 - 768;
	}
	return value;
};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.get_capsLock = function(this1) {
	if((this1 & 8192) <= 0) {
		return (this1 & 8192) > 0;
	} else {
		return true;
	}
};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.set_capsLock = function(this1,value) {
	if(value) {
		this1 |= 8192;
	} else {
		this1 &= 268435455 - 8192;
	}
	return value;
};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.get_ctrlKey = function(this1) {
	if((this1 & 64) <= 0) {
		return (this1 & 128) > 0;
	} else {
		return true;
	}
};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.set_ctrlKey = function(this1,value) {
	if(value) {
		this1 |= 192;
	} else {
		this1 &= 268435455 - 192;
	}
	return value;
};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.get_metaKey = function(this1) {
	if((this1 & 1024) <= 0) {
		return (this1 & 2048) > 0;
	} else {
		return true;
	}
};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.set_metaKey = function(this1,value) {
	if(value) {
		this1 |= 3072;
	} else {
		this1 &= 268435455 - 3072;
	}
	return value;
};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.get_numLock = function(this1) {
	if((this1 & 4096) <= 0) {
		return (this1 & 4096) > 0;
	} else {
		return true;
	}
};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.set_numLock = function(this1,value) {
	if(value) {
		this1 |= 4096;
	} else {
		this1 &= 268435455 - 4096;
	}
	return value;
};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.get_shiftKey = function(this1) {
	if((this1 & 1) <= 0) {
		return (this1 & 2) > 0;
	} else {
		return true;
	}
};
lime_ui__$KeyModifier_KeyModifier_$Impl_$.set_shiftKey = function(this1,value) {
	if(value) {
		this1 |= 3;
	} else {
		this1 &= 268435455 - 3;
	}
	return value;
};
var lime_ui_MouseCursor = $hxClasses["lime.ui.MouseCursor"] = { __ename__ : ["lime","ui","MouseCursor"], __constructs__ : ["ARROW","CROSSHAIR","DEFAULT","MOVE","POINTER","RESIZE_NESW","RESIZE_NS","RESIZE_NWSE","RESIZE_WE","TEXT","WAIT","WAIT_ARROW","CUSTOM"] };
lime_ui_MouseCursor.ARROW = ["ARROW",0];
lime_ui_MouseCursor.ARROW.toString = $estr;
lime_ui_MouseCursor.ARROW.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.CROSSHAIR = ["CROSSHAIR",1];
lime_ui_MouseCursor.CROSSHAIR.toString = $estr;
lime_ui_MouseCursor.CROSSHAIR.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.DEFAULT = ["DEFAULT",2];
lime_ui_MouseCursor.DEFAULT.toString = $estr;
lime_ui_MouseCursor.DEFAULT.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.MOVE = ["MOVE",3];
lime_ui_MouseCursor.MOVE.toString = $estr;
lime_ui_MouseCursor.MOVE.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.POINTER = ["POINTER",4];
lime_ui_MouseCursor.POINTER.toString = $estr;
lime_ui_MouseCursor.POINTER.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.RESIZE_NESW = ["RESIZE_NESW",5];
lime_ui_MouseCursor.RESIZE_NESW.toString = $estr;
lime_ui_MouseCursor.RESIZE_NESW.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.RESIZE_NS = ["RESIZE_NS",6];
lime_ui_MouseCursor.RESIZE_NS.toString = $estr;
lime_ui_MouseCursor.RESIZE_NS.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.RESIZE_NWSE = ["RESIZE_NWSE",7];
lime_ui_MouseCursor.RESIZE_NWSE.toString = $estr;
lime_ui_MouseCursor.RESIZE_NWSE.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.RESIZE_WE = ["RESIZE_WE",8];
lime_ui_MouseCursor.RESIZE_WE.toString = $estr;
lime_ui_MouseCursor.RESIZE_WE.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.TEXT = ["TEXT",9];
lime_ui_MouseCursor.TEXT.toString = $estr;
lime_ui_MouseCursor.TEXT.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.WAIT = ["WAIT",10];
lime_ui_MouseCursor.WAIT.toString = $estr;
lime_ui_MouseCursor.WAIT.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.WAIT_ARROW = ["WAIT_ARROW",11];
lime_ui_MouseCursor.WAIT_ARROW.toString = $estr;
lime_ui_MouseCursor.WAIT_ARROW.__enum__ = lime_ui_MouseCursor;
lime_ui_MouseCursor.CUSTOM = ["CUSTOM",12];
lime_ui_MouseCursor.CUSTOM.toString = $estr;
lime_ui_MouseCursor.CUSTOM.__enum__ = lime_ui_MouseCursor;
var lime_ui_MouseWheelMode = $hxClasses["lime.ui.MouseWheelMode"] = { __ename__ : ["lime","ui","MouseWheelMode"], __constructs__ : ["PIXELS","LINES","PAGES","UNKNOWN"] };
lime_ui_MouseWheelMode.PIXELS = ["PIXELS",0];
lime_ui_MouseWheelMode.PIXELS.toString = $estr;
lime_ui_MouseWheelMode.PIXELS.__enum__ = lime_ui_MouseWheelMode;
lime_ui_MouseWheelMode.LINES = ["LINES",1];
lime_ui_MouseWheelMode.LINES.toString = $estr;
lime_ui_MouseWheelMode.LINES.__enum__ = lime_ui_MouseWheelMode;
lime_ui_MouseWheelMode.PAGES = ["PAGES",2];
lime_ui_MouseWheelMode.PAGES.toString = $estr;
lime_ui_MouseWheelMode.PAGES.__enum__ = lime_ui_MouseWheelMode;
lime_ui_MouseWheelMode.UNKNOWN = ["UNKNOWN",3];
lime_ui_MouseWheelMode.UNKNOWN.toString = $estr;
lime_ui_MouseWheelMode.UNKNOWN.__enum__ = lime_ui_MouseWheelMode;
var lime_ui__$ScanCode_ScanCode_$Impl_$ = {};
$hxClasses["lime.ui._ScanCode.ScanCode_Impl_"] = lime_ui__$ScanCode_ScanCode_$Impl_$;
lime_ui__$ScanCode_ScanCode_$Impl_$.__name__ = ["lime","ui","_ScanCode","ScanCode_Impl_"];
lime_ui__$ScanCode_ScanCode_$Impl_$.fromKeyCode = function(keyCode) {
	return lime_ui__$KeyCode_KeyCode_$Impl_$.toScanCode(keyCode);
};
lime_ui__$ScanCode_ScanCode_$Impl_$.toKeyCode = function(scanCode) {
	return lime_ui__$KeyCode_KeyCode_$Impl_$.fromScanCode(scanCode);
};
lime_ui__$ScanCode_ScanCode_$Impl_$.gt = function(a,b) {
	return a > b;
};
lime_ui__$ScanCode_ScanCode_$Impl_$.gte = function(a,b) {
	return a >= b;
};
lime_ui__$ScanCode_ScanCode_$Impl_$.lt = function(a,b) {
	return a < b;
};
lime_ui__$ScanCode_ScanCode_$Impl_$.lte = function(a,b) {
	return a <= b;
};
lime_ui__$ScanCode_ScanCode_$Impl_$.plus = function(a,b) {
	return a + b;
};
var lime_ui_Touch = function(x,y,id,dx,dy,pressure,device) {
	this.x = x;
	this.y = y;
	this.id = id;
	this.dx = dx;
	this.dy = dy;
	this.pressure = pressure;
	this.device = device;
};
$hxClasses["lime.ui.Touch"] = lime_ui_Touch;
lime_ui_Touch.__name__ = ["lime","ui","Touch"];
lime_ui_Touch.prototype = {
	__class__: lime_ui_Touch
};
var lime_ui_Window = function(application,attributes) {
	this.onTextInput = new lime_app__$Event_$String_$Void();
	this.onTextEdit = new lime_app__$Event_$String_$Int_$Int_$Void();
	this.onRestore = new lime_app__$Event_$Void_$Void();
	this.onResize = new lime_app__$Event_$Int_$Int_$Void();
	this.onRenderContextRestored = new lime_app__$Event_$lime_$graphics_$RenderContext_$Void();
	this.onRenderContextLost = new lime_app__$Event_$Void_$Void();
	this.onRender = new lime_app__$Event_$lime_$graphics_$RenderContext_$Void();
	this.onMove = new lime_app__$Event_$Float_$Float_$Void();
	this.onMouseWheel = new lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void();
	this.onMouseUp = new lime_app__$Event_$Float_$Float_$Int_$Void();
	this.onMouseMoveRelative = new lime_app__$Event_$Float_$Float_$Void();
	this.onMouseMove = new lime_app__$Event_$Float_$Float_$Void();
	this.onMouseDown = new lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void();
	this.onMinimize = new lime_app__$Event_$Void_$Void();
	this.onMaximize = new lime_app__$Event_$Void_$Void();
	this.onLeave = new lime_app__$Event_$Void_$Void();
	this.onKeyUp = new lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void();
	this.onKeyDown = new lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void();
	this.onFullscreen = new lime_app__$Event_$Void_$Void();
	this.onFocusOut = new lime_app__$Event_$Void_$Void();
	this.onFocusIn = new lime_app__$Event_$Void_$Void();
	this.onExpose = new lime_app__$Event_$Void_$Void();
	this.onEnter = new lime_app__$Event_$Void_$Void();
	this.onDropFile = new lime_app__$Event_$String_$Void();
	this.onDeactivate = new lime_app__$Event_$Void_$Void();
	this.onClose = new lime_app__$Event_$Void_$Void();
	this.onActivate = new lime_app__$Event_$Void_$Void();
	this.application = application;
	this.__attributes = attributes != null ? attributes : { };
	if(Object.prototype.hasOwnProperty.call(this.__attributes,"parameters")) {
		this.parameters = this.__attributes.parameters;
	}
	this.__width = 0;
	this.__height = 0;
	this.__fullscreen = false;
	this.__scale = 1;
	this.__x = 0;
	this.__y = 0;
	this.__title = "";
	this.id = -1;
	this.__backend = new lime__$internal_backend_html5_HTML5Window(this);
};
$hxClasses["lime.ui.Window"] = lime_ui_Window;
lime_ui_Window.__name__ = ["lime","ui","Window"];
lime_ui_Window.prototype = {
	alert: function(message,title) {
		this.__backend.alert(message,title);
	}
	,close: function() {
		this.__backend.close();
	}
	,focus: function() {
		this.__backend.focus();
	}
	,move: function(x,y) {
		this.__backend.move(x,y);
		this.__x = x;
		this.__y = y;
	}
	,readPixels: function(rect) {
		return this.__backend.readPixels(rect);
	}
	,resize: function(width,height) {
		this.__backend.resize(width,height);
		this.__width = width;
		this.__height = height;
	}
	,setIcon: function(image) {
		if(image == null) {
			return;
		}
		this.__backend.setIcon(image);
	}
	,toString: function() {
		return "[object Window]";
	}
	,warpMouse: function(x,y) {
		this.__backend.warpMouse(x,y);
	}
	,get_cursor: function() {
		return this.__backend.getCursor();
	}
	,set_cursor: function(value) {
		return this.__backend.setCursor(value);
	}
	,get_display: function() {
		return this.__backend.getDisplay();
	}
	,get_displayMode: function() {
		return this.__backend.getDisplayMode();
	}
	,set_displayMode: function(value) {
		return this.__backend.setDisplayMode(value);
	}
	,get_borderless: function() {
		return this.__borderless;
	}
	,set_borderless: function(value) {
		return this.__borderless = this.__backend.setBorderless(value);
	}
	,get_frameRate: function() {
		return this.__backend.getFrameRate();
	}
	,set_frameRate: function(value) {
		return this.__backend.setFrameRate(value);
	}
	,get_fullscreen: function() {
		return this.__fullscreen;
	}
	,set_fullscreen: function(value) {
		return this.__fullscreen = this.__backend.setFullscreen(value);
	}
	,get_height: function() {
		return this.__height;
	}
	,set_height: function(value) {
		this.resize(this.__width,value);
		return this.__height;
	}
	,get_hidden: function() {
		return this.__hidden;
	}
	,get_maximized: function() {
		return this.__maximized;
	}
	,set_maximized: function(value) {
		this.__minimized = false;
		return this.__maximized = this.__backend.setMaximized(value);
	}
	,get_minimized: function() {
		return this.__minimized;
	}
	,set_minimized: function(value) {
		this.__maximized = false;
		return this.__minimized = this.__backend.setMinimized(value);
	}
	,get_mouseLock: function() {
		return this.__backend.getMouseLock();
	}
	,set_mouseLock: function(value) {
		this.__backend.setMouseLock(value);
		return value;
	}
	,get_resizable: function() {
		return this.__resizable;
	}
	,set_resizable: function(value) {
		this.__resizable = this.__backend.setResizable(value);
		return this.__resizable;
	}
	,get_scale: function() {
		return this.__scale;
	}
	,get_textInputEnabled: function() {
		return this.__backend.getTextInputEnabled();
	}
	,set_textInputEnabled: function(value) {
		return this.__backend.setTextInputEnabled(value);
	}
	,get_title: function() {
		return this.__title;
	}
	,set_title: function(value) {
		return this.__title = this.__backend.setTitle(value);
	}
	,get_width: function() {
		return this.__width;
	}
	,set_width: function(value) {
		this.resize(value,this.__height);
		return this.__width;
	}
	,get_x: function() {
		return this.__x;
	}
	,set_x: function(value) {
		this.move(value,this.__y);
		return this.__x;
	}
	,get_y: function() {
		return this.__y;
	}
	,set_y: function(value) {
		this.move(this.__x,value);
		return this.__y;
	}
	,__class__: lime_ui_Window
	,__properties__: {set_y:"set_y",get_y:"get_y",set_x:"set_x",get_x:"get_x",set_width:"set_width",get_width:"get_width",set_title:"set_title",get_title:"get_title",set_textInputEnabled:"set_textInputEnabled",get_textInputEnabled:"get_textInputEnabled",get_scale:"get_scale",set_resizable:"set_resizable",get_resizable:"get_resizable",set_mouseLock:"set_mouseLock",get_mouseLock:"get_mouseLock",set_minimized:"set_minimized",get_minimized:"get_minimized",set_maximized:"set_maximized",get_maximized:"get_maximized",get_hidden:"get_hidden",set_height:"set_height",get_height:"get_height",set_fullscreen:"set_fullscreen",get_fullscreen:"get_fullscreen",set_frameRate:"set_frameRate",get_frameRate:"get_frameRate",set_displayMode:"set_displayMode",get_displayMode:"get_displayMode",get_display:"get_display",set_cursor:"set_cursor",get_cursor:"get_cursor",set_borderless:"set_borderless",get_borderless:"get_borderless"}
};
var lime_utils_TAError = $hxClasses["lime.utils.TAError"] = { __ename__ : ["lime","utils","TAError"], __constructs__ : ["RangeError"] };
lime_utils_TAError.RangeError = ["RangeError",0];
lime_utils_TAError.RangeError.toString = $estr;
lime_utils_TAError.RangeError.__enum__ = lime_utils_TAError;
var lime_utils_AssetBundle = function() {
	this.data = new haxe_ds_StringMap();
	this.paths = [];
};
$hxClasses["lime.utils.AssetBundle"] = lime_utils_AssetBundle;
lime_utils_AssetBundle.__name__ = ["lime","utils","AssetBundle"];
lime_utils_AssetBundle.fromBytes = function(bytes) {
	var input = new haxe_io_BytesInput(bytes);
	return lime_utils_AssetBundle.__extractBundle(input);
};
lime_utils_AssetBundle.fromFile = function(path) {
	return null;
};
lime_utils_AssetBundle.loadFromBytes = function(bytes) {
	return lime_app_Future.withValue(lime_utils_AssetBundle.fromBytes(bytes));
};
lime_utils_AssetBundle.loadFromFile = function(path) {
	return lime_utils__$Bytes_Bytes_$Impl_$.loadFromFile(path).then(lime_utils_AssetBundle.loadFromBytes);
};
lime_utils_AssetBundle.__extractBundle = function(input) {
	var entries = haxe_zip_Reader.readZip(input);
	var bundle = new lime_utils_AssetBundle();
	var _g_head = entries.h;
	while(_g_head != null) {
		var val = _g_head.item;
		_g_head = _g_head.next;
		var entry = val;
		if(entry.compressed) {
			var bytes = entry.data;
			var this1 = bundle.data;
			var key = entry.fileName;
			var value = lime_utils__$Bytes_Bytes_$Impl_$.decompress(bytes,lime_utils_CompressionAlgorithm.DEFLATE);
			var _this = this1;
			if(__map_reserved[key] != null) {
				_this.setReserved(key,value);
			} else {
				_this.h[key] = value;
			}
		} else {
			var key1 = entry.fileName;
			var value1 = entry.data;
			var _this1 = bundle.data;
			if(__map_reserved[key1] != null) {
				_this1.setReserved(key1,value1);
			} else {
				_this1.h[key1] = value1;
			}
		}
		bundle.paths.push(entry.fileName);
	}
	return bundle;
};
lime_utils_AssetBundle.prototype = {
	__class__: lime_utils_AssetBundle
};
var lime_utils_AssetCache = function() {
	this.enabled = true;
	this.audio = new haxe_ds_StringMap();
	this.font = new haxe_ds_StringMap();
	this.image = new haxe_ds_StringMap();
	this.version = 116406;
};
$hxClasses["lime.utils.AssetCache"] = lime_utils_AssetCache;
lime_utils_AssetCache.__name__ = ["lime","utils","AssetCache"];
lime_utils_AssetCache.prototype = {
	exists: function(id,type) {
		if(type == "IMAGE" || type == null) {
			var _this = this.image;
			if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
				return true;
			}
		}
		if(type == "FONT" || type == null) {
			var _this1 = this.font;
			if(__map_reserved[id] != null ? _this1.existsReserved(id) : _this1.h.hasOwnProperty(id)) {
				return true;
			}
		}
		if(type == "SOUND" || type == "MUSIC" || type == null) {
			var _this2 = this.audio;
			if(__map_reserved[id] != null ? _this2.existsReserved(id) : _this2.h.hasOwnProperty(id)) {
				return true;
			}
		}
		return false;
	}
	,set: function(id,type,asset) {
		switch(type) {
		case "FONT":
			this.font.set(id,asset);
			break;
		case "IMAGE":
			if(!js_Boot.__instanceof(asset,lime_graphics_Image)) {
				throw new js__$Boot_HaxeError("Cannot cache non-Image asset: " + Std.string(asset) + " as Image");
			}
			this.image.set(id,asset);
			break;
		case "MUSIC":case "SOUND":
			if(!js_Boot.__instanceof(asset,lime_media_AudioBuffer)) {
				throw new js__$Boot_HaxeError("Cannot cache non-AudioBuffer asset: " + Std.string(asset) + " as AudioBuffer");
			}
			this.audio.set(id,asset);
			break;
		default:
			throw new js__$Boot_HaxeError(type + " assets are not cachable");
		}
	}
	,clear: function(prefix) {
		if(prefix == null) {
			this.audio = new haxe_ds_StringMap();
			this.font = new haxe_ds_StringMap();
			this.image = new haxe_ds_StringMap();
		} else {
			var keys = this.audio.keys();
			var key = keys;
			while(key.hasNext()) {
				var key1 = key.next();
				if(StringTools.startsWith(key1,prefix)) {
					this.audio.remove(key1);
				}
			}
			var keys1 = this.font.keys();
			var key2 = keys1;
			while(key2.hasNext()) {
				var key3 = key2.next();
				if(StringTools.startsWith(key3,prefix)) {
					this.font.remove(key3);
				}
			}
			var keys2 = this.image.keys();
			var key4 = keys2;
			while(key4.hasNext()) {
				var key5 = key4.next();
				if(StringTools.startsWith(key5,prefix)) {
					this.image.remove(key5);
				}
			}
		}
	}
	,__class__: lime_utils_AssetCache
};
var lime_utils_AssetLibrary = function() {
	this.types = new haxe_ds_StringMap();
	this.sizes = new haxe_ds_StringMap();
	this.preload = new haxe_ds_StringMap();
	this.paths = new haxe_ds_StringMap();
	this.pathGroups = new haxe_ds_StringMap();
	this.classTypes = new haxe_ds_StringMap();
	this.cachedText = new haxe_ds_StringMap();
	this.cachedImages = new haxe_ds_StringMap();
	this.cachedFonts = new haxe_ds_StringMap();
	this.cachedBytes = new haxe_ds_StringMap();
	this.cachedAudioBuffers = new haxe_ds_StringMap();
	this.onChange = new lime_app__$Event_$Void_$Void();
	this.bytesLoaded = 0;
	this.bytesTotal = 0;
};
$hxClasses["lime.utils.AssetLibrary"] = lime_utils_AssetLibrary;
lime_utils_AssetLibrary.__name__ = ["lime","utils","AssetLibrary"];
lime_utils_AssetLibrary.fromBytes = function(bytes,rootPath) {
	return lime_utils_AssetLibrary.fromManifest(lime_utils_AssetManifest.fromBytes(bytes,rootPath));
};
lime_utils_AssetLibrary.fromFile = function(path,rootPath) {
	return lime_utils_AssetLibrary.fromManifest(lime_utils_AssetManifest.fromFile(path,rootPath));
};
lime_utils_AssetLibrary.fromBundle = function(bundle) {
	var _this = bundle.data;
	if(__map_reserved["library.json"] != null ? _this.existsReserved("library.json") : _this.h.hasOwnProperty("library.json")) {
		var _this1 = bundle.data;
		var manifest = lime_utils_AssetManifest.fromBytes(__map_reserved["library.json"] != null ? _this1.getReserved("library.json") : _this1.h["library.json"]);
		if(manifest != null) {
			var library = null;
			if(manifest.libraryType == null) {
				library = new lime_utils_AssetLibrary();
			} else {
				var libraryClass = Type.resolveClass(manifest.libraryType);
				if(libraryClass != null) {
					library = Type.createInstance(libraryClass,manifest.libraryArgs);
				} else {
					lime_utils_Log.warn("Could not find library type: " + manifest.libraryType,{ fileName : "AssetLibrary.hx", lineNumber : 122, className : "lime.utils.AssetLibrary", methodName : "fromBundle"});
					return null;
				}
			}
			library.__fromBundle(bundle,manifest);
			return library;
		}
	} else {
		var library1 = new lime_utils_AssetLibrary();
		library1.__fromBundle(bundle);
		return library1;
	}
	return null;
};
lime_utils_AssetLibrary.fromManifest = function(manifest) {
	if(manifest == null) {
		return null;
	}
	var library = null;
	if(manifest.libraryType == null) {
		library = new lime_utils_AssetLibrary();
	} else {
		var libraryClass = Type.resolveClass(manifest.libraryType);
		if(libraryClass != null) {
			library = Type.createInstance(libraryClass,manifest.libraryArgs);
		} else {
			lime_utils_Log.warn("Could not find library type: " + manifest.libraryType,{ fileName : "AssetLibrary.hx", lineNumber : 160, className : "lime.utils.AssetLibrary", methodName : "fromManifest"});
			return null;
		}
	}
	library.__fromManifest(manifest);
	return library;
};
lime_utils_AssetLibrary.loadFromBytes = function(bytes,rootPath) {
	return lime_utils_AssetManifest.loadFromBytes(bytes,rootPath).then(function(manifest) {
		return lime_utils_AssetLibrary.loadFromManifest(manifest);
	});
};
lime_utils_AssetLibrary.loadFromFile = function(path,rootPath) {
	return lime_utils_AssetManifest.loadFromFile(path,rootPath).then(function(manifest) {
		return lime_utils_AssetLibrary.loadFromManifest(manifest);
	});
};
lime_utils_AssetLibrary.loadFromManifest = function(manifest) {
	var library = lime_utils_AssetLibrary.fromManifest(manifest);
	if(library != null) {
		return library.load();
	} else {
		return lime_app_Future.withError("Could not load asset manifest");
	}
};
lime_utils_AssetLibrary.prototype = {
	exists: function(id,type) {
		var requestedType = type != null ? js_Boot.__cast(type , String) : null;
		var _this = this.types;
		var assetType = __map_reserved[id] != null ? _this.getReserved(id) : _this.h[id];
		if(assetType != null) {
			if(assetType == requestedType || (requestedType == "SOUND" || requestedType == "MUSIC") && (assetType == "MUSIC" || assetType == "SOUND")) {
				return true;
			}
			if(requestedType == "BINARY" || requestedType == null || assetType == "BINARY" && requestedType == "TEXT") {
				return true;
			}
		}
		return false;
	}
	,getAsset: function(id,type) {
		switch(type) {
		case "BINARY":
			return this.getBytes(id);
		case "FONT":
			return this.getFont(id);
		case "IMAGE":
			return this.getImage(id);
		case "MUSIC":case "SOUND":
			return this.getAudioBuffer(id);
		case "TEMPLATE":
			throw new js__$Boot_HaxeError("Not sure how to get template: " + id);
			break;
		case "TEXT":
			return this.getText(id);
		default:
			throw new js__$Boot_HaxeError("Unknown asset type: " + type);
		}
	}
	,getAudioBuffer: function(id) {
		var _this = this.cachedAudioBuffers;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.cachedAudioBuffers;
			if(__map_reserved[id] != null) {
				return _this1.getReserved(id);
			} else {
				return _this1.h[id];
			}
		} else {
			var _this2 = this.classTypes;
			if(__map_reserved[id] != null ? _this2.existsReserved(id) : _this2.h.hasOwnProperty(id)) {
				var _this3 = this.classTypes;
				return lime_media_AudioBuffer.fromBytes(js_Boot.__cast(Type.createInstance(__map_reserved[id] != null ? _this3.getReserved(id) : _this3.h[id],[]) , haxe_io_Bytes));
			} else {
				var _this4 = this.paths;
				return lime_media_AudioBuffer.fromFile(__map_reserved[id] != null ? _this4.getReserved(id) : _this4.h[id]);
			}
		}
	}
	,getBytes: function(id) {
		var _this = this.cachedBytes;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.cachedBytes;
			if(__map_reserved[id] != null) {
				return _this1.getReserved(id);
			} else {
				return _this1.h[id];
			}
		} else {
			var _this2 = this.cachedText;
			if(__map_reserved[id] != null ? _this2.existsReserved(id) : _this2.h.hasOwnProperty(id)) {
				var _this3 = this.cachedText;
				var bytes = lime_utils__$Bytes_Bytes_$Impl_$.ofString(__map_reserved[id] != null ? _this3.getReserved(id) : _this3.h[id]);
				var _this4 = this.cachedBytes;
				if(__map_reserved[id] != null) {
					_this4.setReserved(id,bytes);
				} else {
					_this4.h[id] = bytes;
				}
				return bytes;
			} else {
				var _this5 = this.classTypes;
				if(__map_reserved[id] != null ? _this5.existsReserved(id) : _this5.h.hasOwnProperty(id)) {
					var _this6 = this.classTypes;
					return js_Boot.__cast(Type.createInstance(__map_reserved[id] != null ? _this6.getReserved(id) : _this6.h[id],[]) , haxe_io_Bytes);
				} else {
					var _this7 = this.paths;
					return lime_utils__$Bytes_Bytes_$Impl_$.fromFile(__map_reserved[id] != null ? _this7.getReserved(id) : _this7.h[id]);
				}
			}
		}
	}
	,getFont: function(id) {
		var _this = this.cachedFonts;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.cachedFonts;
			if(__map_reserved[id] != null) {
				return _this1.getReserved(id);
			} else {
				return _this1.h[id];
			}
		} else {
			var _this2 = this.classTypes;
			if(__map_reserved[id] != null ? _this2.existsReserved(id) : _this2.h.hasOwnProperty(id)) {
				var _this3 = this.classTypes;
				return js_Boot.__cast(Type.createInstance(__map_reserved[id] != null ? _this3.getReserved(id) : _this3.h[id],[]) , lime_text_Font);
			} else {
				var _this4 = this.paths;
				return lime_text_Font.fromFile(__map_reserved[id] != null ? _this4.getReserved(id) : _this4.h[id]);
			}
		}
	}
	,getImage: function(id) {
		var _this = this.cachedImages;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.cachedImages;
			if(__map_reserved[id] != null) {
				return _this1.getReserved(id);
			} else {
				return _this1.h[id];
			}
		} else {
			var _this2 = this.classTypes;
			if(__map_reserved[id] != null ? _this2.existsReserved(id) : _this2.h.hasOwnProperty(id)) {
				var _this3 = this.classTypes;
				return js_Boot.__cast(Type.createInstance(__map_reserved[id] != null ? _this3.getReserved(id) : _this3.h[id],[]) , lime_graphics_Image);
			} else {
				var _this4 = this.paths;
				return lime_graphics_Image.fromFile(__map_reserved[id] != null ? _this4.getReserved(id) : _this4.h[id]);
			}
		}
	}
	,getPath: function(id) {
		var _this = this.paths;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.paths;
			if(__map_reserved[id] != null) {
				return _this1.getReserved(id);
			} else {
				return _this1.h[id];
			}
		} else {
			var _this2 = this.pathGroups;
			if(__map_reserved[id] != null ? _this2.existsReserved(id) : _this2.h.hasOwnProperty(id)) {
				var _this3 = this.pathGroups;
				return (__map_reserved[id] != null ? _this3.getReserved(id) : _this3.h[id])[0];
			} else {
				return null;
			}
		}
	}
	,getText: function(id) {
		var _this = this.cachedText;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.cachedText;
			if(__map_reserved[id] != null) {
				return _this1.getReserved(id);
			} else {
				return _this1.h[id];
			}
		} else {
			var bytes = this.getBytes(id);
			if(bytes == null) {
				return null;
			} else {
				return bytes.getString(0,bytes.length);
			}
		}
	}
	,isLocal: function(id,type) {
		var _this = this.classTypes;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			return true;
		}
		var requestedType = type != null ? js_Boot.__cast(type , String) : null;
		switch(requestedType) {
		case "FONT":
			return this.cachedFonts.exists(id);
		case "IMAGE":
			return this.cachedImages.exists(id);
		case "MUSIC":case "SOUND":
			return this.cachedAudioBuffers.exists(id);
		default:
			if(!this.cachedBytes.exists(id)) {
				return this.cachedText.exists(id);
			} else {
				return true;
			}
		}
	}
	,list: function(type) {
		var requestedType = type != null ? js_Boot.__cast(type , String) : null;
		var items = [];
		var id = this.types.keys();
		while(id.hasNext()) {
			var id1 = id.next();
			if(requestedType == null || this.exists(id1,type)) {
				items.push(id1);
			}
		}
		return items;
	}
	,loadAsset: function(id,type) {
		switch(type) {
		case "BINARY":
			return this.loadBytes(id);
		case "FONT":
			return this.loadFont(id);
		case "IMAGE":
			return this.loadImage(id);
		case "MUSIC":case "SOUND":
			return this.loadAudioBuffer(id);
		case "TEMPLATE":
			throw new js__$Boot_HaxeError("Not sure how to load template: " + id);
			break;
		case "TEXT":
			return this.loadText(id);
		default:
			throw new js__$Boot_HaxeError("Unknown asset type: " + type);
		}
	}
	,load: function() {
		if(this.loaded) {
			return lime_app_Future.withValue(this);
		}
		if(this.promise == null) {
			this.promise = new lime_app_Promise();
			this.bytesLoadedCache = new haxe_ds_StringMap();
			this.assetsLoaded = 0;
			this.assetsTotal = 1;
			var id = this.preload.keys();
			while(id.hasNext()) {
				var id1 = id.next();
				var _this = this.preload;
				if(!(__map_reserved[id1] != null ? _this.getReserved(id1) : _this.h[id1])) {
					continue;
				}
				var _this1 = this.types;
				lime_utils_Log.verbose("Preloading asset: " + id1 + " [" + (__map_reserved[id1] != null ? _this1.getReserved(id1) : _this1.h[id1]) + "]",{ fileName : "AssetLibrary.hx", lineNumber : 405, className : "lime.utils.AssetLibrary", methodName : "load"});
				var _g = this.types.get(id1);
				if(_g != null) {
					switch(_g) {
					case "BINARY":
						this.assetsTotal++;
						var future = this.loadBytes(id1);
						future.onProgress((function(id2,f) {
							return function(a1,a2) {
								f[0](id2[0],a1,a2);
							};
						})([id1],[$bind(this,this.load_onProgress)]));
						future.onError((function(id3,f1) {
							return function(a11) {
								f1[0](id3[0],a11);
							};
						})([id1],[$bind(this,this.load_onError)]));
						future.onComplete((function(id4,f2) {
							return function(a12) {
								f2[0](id4[0],a12);
							};
						})([id1],[$bind(this,this.loadBytes_onComplete)]));
						break;
					case "FONT":
						this.assetsTotal++;
						var future1 = this.loadFont(id1);
						future1.onProgress((function(id5,f3) {
							return function(a13,a21) {
								f3[0](id5[0],a13,a21);
							};
						})([id1],[$bind(this,this.load_onProgress)]));
						future1.onError((function(id6,f4) {
							return function(a14) {
								f4[0](id6[0],a14);
							};
						})([id1],[$bind(this,this.load_onError)]));
						future1.onComplete((function(id7,f5) {
							return function(a15) {
								f5[0](id7[0],a15);
							};
						})([id1],[$bind(this,this.loadFont_onComplete)]));
						break;
					case "IMAGE":
						this.assetsTotal++;
						var future2 = this.loadImage(id1);
						future2.onProgress((function(id8,f6) {
							return function(a16,a22) {
								f6[0](id8[0],a16,a22);
							};
						})([id1],[$bind(this,this.load_onProgress)]));
						future2.onError((function(id9,f7) {
							return function(a17) {
								f7[0](id9[0],a17);
							};
						})([id1],[$bind(this,this.load_onError)]));
						future2.onComplete((function(id10,f8) {
							return function(a18) {
								f8[0](id10[0],a18);
							};
						})([id1],[$bind(this,this.loadImage_onComplete)]));
						break;
					case "MUSIC":case "SOUND":
						this.assetsTotal++;
						var future3 = this.loadAudioBuffer(id1);
						future3.onProgress((function(id11,f9) {
							return function(a19,a23) {
								f9[0](id11[0],a19,a23);
							};
						})([id1],[$bind(this,this.load_onProgress)]));
						future3.onError((function(id12,f10) {
							return function(a110) {
								f10[0](id12[0],a110);
							};
						})([id1],[$bind(this,this.loadAudioBuffer_onError)]));
						future3.onComplete((function(id13,f11) {
							return function(a111) {
								f11[0](id13[0],a111);
							};
						})([id1],[$bind(this,this.loadAudioBuffer_onComplete)]));
						break;
					case "TEXT":
						this.assetsTotal++;
						var future4 = this.loadText(id1);
						future4.onProgress((function(id14,f12) {
							return function(a112,a24) {
								f12[0](id14[0],a112,a24);
							};
						})([id1],[$bind(this,this.load_onProgress)]));
						future4.onError((function(id15,f13) {
							return function(a113) {
								f13[0](id15[0],a113);
							};
						})([id1],[$bind(this,this.load_onError)]));
						future4.onComplete((function(id16,f14) {
							return function(a114) {
								f14[0](id16[0],a114);
							};
						})([id1],[$bind(this,this.loadText_onComplete)]));
						break;
					default:
					}
				}
			}
			this.__assetLoaded(null);
		}
		return this.promise.future;
	}
	,loadAudioBuffer: function(id) {
		var _this = this.cachedAudioBuffers;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.cachedAudioBuffers;
			return lime_app_Future.withValue(__map_reserved[id] != null ? _this1.getReserved(id) : _this1.h[id]);
		} else {
			var _this2 = this.classTypes;
			if(__map_reserved[id] != null ? _this2.existsReserved(id) : _this2.h.hasOwnProperty(id)) {
				var _this3 = this.classTypes;
				return lime_app_Future.withValue(Type.createInstance(__map_reserved[id] != null ? _this3.getReserved(id) : _this3.h[id],[]));
			} else {
				var _this4 = this.pathGroups;
				if(__map_reserved[id] != null ? _this4.existsReserved(id) : _this4.h.hasOwnProperty(id)) {
					var _this5 = this.pathGroups;
					return lime_media_AudioBuffer.loadFromFiles(__map_reserved[id] != null ? _this5.getReserved(id) : _this5.h[id]);
				} else {
					var _this6 = this.paths;
					return lime_media_AudioBuffer.loadFromFile(__map_reserved[id] != null ? _this6.getReserved(id) : _this6.h[id]);
				}
			}
		}
	}
	,loadBytes: function(id) {
		var _this = this.cachedBytes;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.cachedBytes;
			return lime_app_Future.withValue(__map_reserved[id] != null ? _this1.getReserved(id) : _this1.h[id]);
		} else {
			var _this2 = this.classTypes;
			if(__map_reserved[id] != null ? _this2.existsReserved(id) : _this2.h.hasOwnProperty(id)) {
				var _this3 = this.classTypes;
				return lime_app_Future.withValue(Type.createInstance(__map_reserved[id] != null ? _this3.getReserved(id) : _this3.h[id],[]));
			} else {
				var _this4 = this.paths;
				return lime_utils__$Bytes_Bytes_$Impl_$.loadFromFile(__map_reserved[id] != null ? _this4.getReserved(id) : _this4.h[id]);
			}
		}
	}
	,loadFont: function(id) {
		var _this = this.cachedFonts;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.cachedFonts;
			return lime_app_Future.withValue(__map_reserved[id] != null ? _this1.getReserved(id) : _this1.h[id]);
		} else {
			var _this2 = this.classTypes;
			if(__map_reserved[id] != null ? _this2.existsReserved(id) : _this2.h.hasOwnProperty(id)) {
				var _this3 = this.classTypes;
				var font = Type.createInstance(__map_reserved[id] != null ? _this3.getReserved(id) : _this3.h[id],[]);
				return font.__loadFromName(font.name);
			} else {
				var _this4 = this.paths;
				return lime_text_Font.loadFromName(__map_reserved[id] != null ? _this4.getReserved(id) : _this4.h[id]);
			}
		}
	}
	,loadImage: function(id) {
		var _gthis = this;
		var _this = this.cachedImages;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.cachedImages;
			return lime_app_Future.withValue(__map_reserved[id] != null ? _this1.getReserved(id) : _this1.h[id]);
		} else {
			var _this2 = this.classTypes;
			if(__map_reserved[id] != null ? _this2.existsReserved(id) : _this2.h.hasOwnProperty(id)) {
				var _this3 = this.classTypes;
				return lime_app_Future.withValue(Type.createInstance(__map_reserved[id] != null ? _this3.getReserved(id) : _this3.h[id],[]));
			} else {
				var _this4 = this.cachedBytes;
				if(__map_reserved[id] != null ? _this4.existsReserved(id) : _this4.h.hasOwnProperty(id)) {
					var _this5 = this.cachedBytes;
					return lime_graphics_Image.loadFromBytes(__map_reserved[id] != null ? _this5.getReserved(id) : _this5.h[id]).then(function(image) {
						_gthis.cachedBytes.remove(id);
						var _this6 = _gthis.cachedImages;
						if(__map_reserved[id] != null) {
							_this6.setReserved(id,image);
						} else {
							_this6.h[id] = image;
						}
						return lime_app_Future.withValue(image);
					});
				} else {
					var _this7 = this.paths;
					return lime_graphics_Image.loadFromFile(__map_reserved[id] != null ? _this7.getReserved(id) : _this7.h[id]);
				}
			}
		}
	}
	,loadText: function(id) {
		var _this = this.cachedText;
		if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
			var _this1 = this.cachedText;
			return lime_app_Future.withValue(__map_reserved[id] != null ? _this1.getReserved(id) : _this1.h[id]);
		} else {
			var tmp;
			var _this2 = this.cachedBytes;
			if(!(__map_reserved[id] != null ? _this2.existsReserved(id) : _this2.h.hasOwnProperty(id))) {
				var _this3 = this.classTypes;
				if(__map_reserved[id] != null) {
					tmp = _this3.existsReserved(id);
				} else {
					tmp = _this3.h.hasOwnProperty(id);
				}
			} else {
				tmp = true;
			}
			if(tmp) {
				var bytes = this.getBytes(id);
				if(bytes == null) {
					return lime_app_Future.withValue(null);
				} else {
					var text = bytes.getString(0,bytes.length);
					var _this4 = this.cachedText;
					if(__map_reserved[id] != null) {
						_this4.setReserved(id,text);
					} else {
						_this4.h[id] = text;
					}
					return lime_app_Future.withValue(text);
				}
			} else {
				var request = new lime_net__$HTTPRequest_$String();
				var _this5 = this.paths;
				return request.load(__map_reserved[id] != null ? _this5.getReserved(id) : _this5.h[id]);
			}
		}
	}
	,unload: function() {
	}
	,__assetLoaded: function(id) {
		this.assetsLoaded++;
		if(id != null) {
			var _this = this.types;
			lime_utils_Log.verbose("Loaded asset: " + id + " [" + (__map_reserved[id] != null ? _this.getReserved(id) : _this.h[id]) + "] (" + (this.assetsLoaded - 1) + "/" + (this.assetsTotal - 1) + ")",{ fileName : "AssetLibrary.hx", lineNumber : 619, className : "lime.utils.AssetLibrary", methodName : "__assetLoaded"});
		}
		if(id != null) {
			var size;
			var _this1 = this.sizes;
			if(__map_reserved[id] != null ? _this1.existsReserved(id) : _this1.h.hasOwnProperty(id)) {
				var _this2 = this.sizes;
				if(__map_reserved[id] != null) {
					size = _this2.getReserved(id);
				} else {
					size = _this2.h[id];
				}
			} else {
				size = 0;
			}
			var _this3 = this.bytesLoadedCache;
			if(!(__map_reserved[id] != null ? _this3.existsReserved(id) : _this3.h.hasOwnProperty(id))) {
				this.bytesLoaded += size;
			} else {
				var _this4 = this.bytesLoadedCache;
				var cache = __map_reserved[id] != null ? _this4.getReserved(id) : _this4.h[id];
				if(cache < size) {
					this.bytesLoaded += size - cache;
				}
			}
			var _this5 = this.bytesLoadedCache;
			if(__map_reserved[id] != null) {
				_this5.setReserved(id,size);
			} else {
				_this5.h[id] = size;
			}
		}
		if(this.assetsLoaded < this.assetsTotal) {
			this.promise.progress(this.bytesLoaded,this.bytesTotal);
		} else {
			this.loaded = true;
			this.promise.progress(this.bytesTotal,this.bytesTotal);
			this.promise.complete(this);
		}
	}
	,__cacheBreak: function(path) {
		return lime_utils_Assets.__cacheBreak(path);
	}
	,__fromBundle: function(bundle,manifest) {
		if(manifest != null) {
			var id;
			var data;
			var type;
			var _g = 0;
			var _g1 = manifest.assets;
			while(_g < _g1.length) {
				var asset = _g1[_g];
				++_g;
				if(Object.prototype.hasOwnProperty.call(asset,"id")) {
					id = asset.id;
				} else {
					id = asset.path;
				}
				var key = asset.path;
				var _this = bundle.data;
				if(__map_reserved[key] != null) {
					data = _this.getReserved(key);
				} else {
					data = _this.h[key];
				}
				if(Object.prototype.hasOwnProperty.call(asset,"type")) {
					type = asset.type;
					if(type == "TEXT") {
						this.cachedText.set(id,data != null ? Std.string(data) : null);
					} else {
						this.cachedBytes.set(id,data);
					}
					var value = asset.type;
					var _this1 = this.types;
					if(__map_reserved[id] != null) {
						_this1.setReserved(id,value);
					} else {
						_this1.h[id] = value;
					}
				} else {
					var _this2 = this.cachedBytes;
					if(__map_reserved[id] != null) {
						_this2.setReserved(id,data);
					} else {
						_this2.h[id] = data;
					}
					var _this3 = this.types;
					var value1 = "BINARY";
					if(__map_reserved[id] != null) {
						_this3.setReserved(id,value1);
					} else {
						_this3.h[id] = value1;
					}
				}
			}
		} else {
			var _g2 = 0;
			var _g11 = bundle.paths;
			while(_g2 < _g11.length) {
				var path = _g11[_g2];
				++_g2;
				var this1 = this.cachedBytes;
				var _this4 = bundle.data;
				var value2 = __map_reserved[path] != null ? _this4.getReserved(path) : _this4.h[path];
				var _this5 = this1;
				if(__map_reserved[path] != null) {
					_this5.setReserved(path,value2);
				} else {
					_this5.h[path] = value2;
				}
				var _this6 = this.types;
				var value3 = "BINARY";
				if(__map_reserved[path] != null) {
					_this6.setReserved(path,value3);
				} else {
					_this6.h[path] = value3;
				}
			}
		}
	}
	,__fromManifest: function(manifest) {
		var hasSize = manifest.version >= 2;
		var size;
		var id;
		var pathGroup;
		var classRef;
		var basePath = manifest.rootPath;
		if(basePath == null) {
			basePath = "";
		}
		if(basePath != "") {
			basePath += "/";
		}
		var _g = 0;
		var _g1 = manifest.assets;
		while(_g < _g1.length) {
			var asset = _g1[_g];
			++_g;
			if(hasSize && Object.prototype.hasOwnProperty.call(asset,"size")) {
				size = asset.size;
			} else {
				size = 100;
			}
			if(Object.prototype.hasOwnProperty.call(asset,"id")) {
				id = asset.id;
			} else {
				id = asset.path;
			}
			if(Object.prototype.hasOwnProperty.call(asset,"path")) {
				var this1 = this.paths;
				var value = this.__cacheBreak(this.__resolvePath(basePath + Std.string(Reflect.field(asset,"path"))));
				var _this = this1;
				if(__map_reserved[id] != null) {
					_this.setReserved(id,value);
				} else {
					_this.h[id] = value;
				}
			}
			if(Object.prototype.hasOwnProperty.call(asset,"pathGroup")) {
				pathGroup = Reflect.field(asset,"pathGroup");
				var _g3 = 0;
				var _g2 = pathGroup.length;
				while(_g3 < _g2) {
					var i = _g3++;
					pathGroup[i] = this.__cacheBreak(this.__resolvePath(basePath + pathGroup[i]));
				}
				var _this1 = this.pathGroups;
				if(__map_reserved[id] != null) {
					_this1.setReserved(id,pathGroup);
				} else {
					_this1.h[id] = pathGroup;
				}
			}
			var _this2 = this.sizes;
			if(__map_reserved[id] != null) {
				_this2.setReserved(id,size);
			} else {
				_this2.h[id] = size;
			}
			var value1 = asset.type;
			var _this3 = this.types;
			if(__map_reserved[id] != null) {
				_this3.setReserved(id,value1);
			} else {
				_this3.h[id] = value1;
			}
			if(Object.prototype.hasOwnProperty.call(asset,"preload")) {
				var this2 = this.preload;
				var value2 = Reflect.field(asset,"preload");
				var _this4 = this2;
				if(__map_reserved[id] != null) {
					_this4.setReserved(id,value2);
				} else {
					_this4.h[id] = value2;
				}
			}
			if(Object.prototype.hasOwnProperty.call(asset,"className")) {
				classRef = Type.resolveClass(Reflect.field(asset,"className"));
				var _this5 = this.classTypes;
				if(__map_reserved[id] != null) {
					_this5.setReserved(id,classRef);
				} else {
					_this5.h[id] = classRef;
				}
			}
		}
		this.bytesTotal = 0;
		var _g4 = 0;
		var _g11 = manifest.assets;
		while(_g4 < _g11.length) {
			var asset1 = _g11[_g4];
			++_g4;
			if(Object.prototype.hasOwnProperty.call(asset1,"id")) {
				id = asset1.id;
			} else {
				id = asset1.path;
			}
			var tmp;
			var tmp1;
			var _this6 = this.preload;
			if(__map_reserved[id] != null ? _this6.existsReserved(id) : _this6.h.hasOwnProperty(id)) {
				var _this7 = this.preload;
				if(__map_reserved[id] != null) {
					tmp1 = _this7.getReserved(id);
				} else {
					tmp1 = _this7.h[id];
				}
			} else {
				tmp1 = false;
			}
			if(tmp1) {
				var _this8 = this.sizes;
				if(__map_reserved[id] != null) {
					tmp = _this8.existsReserved(id);
				} else {
					tmp = _this8.h.hasOwnProperty(id);
				}
			} else {
				tmp = false;
			}
			if(tmp) {
				var _this9 = this.sizes;
				this.bytesTotal += __map_reserved[id] != null ? _this9.getReserved(id) : _this9.h[id];
			}
		}
	}
	,__resolvePath: function(path) {
		path = StringTools.replace(path,"\\","/");
		var colonIdx = path.indexOf(":");
		if(StringTools.startsWith(path,"http") && colonIdx > 0) {
			var lastSlashIdx = colonIdx + 3;
			var httpSection = HxOverrides.substr(path,0,lastSlashIdx);
			path = httpSection + StringTools.replace(HxOverrides.substr(path,lastSlashIdx,null),"//","/");
		} else {
			path = StringTools.replace(path,"//","/");
		}
		if(path.indexOf("./") > -1) {
			var split = path.split("/");
			var newPath = [];
			var _g1 = 0;
			var _g = split.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(split[i] == "..") {
					if(i == 0 || newPath[i - 1] == "..") {
						newPath.push("..");
					} else {
						newPath.pop();
					}
				} else if(split[i] == ".") {
					if(i == 0) {
						newPath.push(".");
					}
				} else {
					newPath.push(split[i]);
				}
			}
			path = newPath.join("/");
		}
		return path;
	}
	,loadAudioBuffer_onComplete: function(id,audioBuffer) {
		var _this = this.cachedAudioBuffers;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,audioBuffer);
		} else {
			_this.h[id] = audioBuffer;
		}
		var _this1 = this.pathGroups;
		if(__map_reserved[id] != null ? _this1.existsReserved(id) : _this1.h.hasOwnProperty(id)) {
			var _this2 = this.pathGroups;
			var pathGroup = __map_reserved[id] != null ? _this2.getReserved(id) : _this2.h[id];
			var otherID = this.pathGroups.keys();
			while(otherID.hasNext()) {
				var otherID1 = otherID.next();
				if(otherID1 == id) {
					continue;
				}
				var _g = 0;
				while(_g < pathGroup.length) {
					var path = pathGroup[_g];
					++_g;
					var _this3 = this.pathGroups;
					if((__map_reserved[otherID1] != null ? _this3.getReserved(otherID1) : _this3.h[otherID1]).indexOf(path) > -1) {
						var _this4 = this.cachedAudioBuffers;
						if(__map_reserved[otherID1] != null) {
							_this4.setReserved(otherID1,audioBuffer);
						} else {
							_this4.h[otherID1] = audioBuffer;
						}
						break;
					}
				}
			}
		}
		this.__assetLoaded(id);
	}
	,loadAudioBuffer_onError: function(id,message) {
		if(message != null && message != "") {
			lime_utils_Log.warn("Could not load \"" + id + "\": " + Std.string(message),{ fileName : "AssetLibrary.hx", lineNumber : 865, className : "lime.utils.AssetLibrary", methodName : "loadAudioBuffer_onError"});
		} else {
			lime_utils_Log.warn("Could not load \"" + id + "\"",{ fileName : "AssetLibrary.hx", lineNumber : 869, className : "lime.utils.AssetLibrary", methodName : "loadAudioBuffer_onError"});
		}
		this.loadAudioBuffer_onComplete(id,new lime_media_AudioBuffer());
	}
	,loadBytes_onComplete: function(id,bytes) {
		var _this = this.cachedBytes;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,bytes);
		} else {
			_this.h[id] = bytes;
		}
		this.__assetLoaded(id);
	}
	,loadFont_onComplete: function(id,font) {
		var _this = this.cachedFonts;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,font);
		} else {
			_this.h[id] = font;
		}
		this.__assetLoaded(id);
	}
	,loadImage_onComplete: function(id,image) {
		var _this = this.cachedImages;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,image);
		} else {
			_this.h[id] = image;
		}
		this.__assetLoaded(id);
	}
	,loadText_onComplete: function(id,text) {
		var _this = this.cachedText;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,text);
		} else {
			_this.h[id] = text;
		}
		this.__assetLoaded(id);
	}
	,load_onError: function(id,message) {
		if(message != null && message != "") {
			this.promise.error("Error loading asset \"" + id + "\": " + Std.string(message));
		} else {
			this.promise.error("Error loading asset \"" + id + "\"");
		}
	}
	,load_onProgress: function(id,bytesLoaded,bytesTotal) {
		if(bytesLoaded > 0) {
			var _this = this.sizes;
			var size = __map_reserved[id] != null ? _this.getReserved(id) : _this.h[id];
			var percent;
			if(bytesTotal > 0) {
				percent = bytesLoaded / bytesTotal;
				if(percent > 1) {
					percent = 1;
				}
				bytesLoaded = Math.floor(percent * size);
			} else if(bytesLoaded > size) {
				bytesLoaded = size;
			}
			var _this1 = this.bytesLoadedCache;
			if(__map_reserved[id] != null ? _this1.existsReserved(id) : _this1.h.hasOwnProperty(id)) {
				var _this2 = this.bytesLoadedCache;
				var cache = __map_reserved[id] != null ? _this2.getReserved(id) : _this2.h[id];
				if(bytesLoaded != cache) {
					this.bytesLoaded += bytesLoaded - cache;
				}
			} else {
				this.bytesLoaded += bytesLoaded;
			}
			var _this3 = this.bytesLoadedCache;
			if(__map_reserved[id] != null) {
				_this3.setReserved(id,bytesLoaded);
			} else {
				_this3.h[id] = bytesLoaded;
			}
			this.promise.progress(this.bytesLoaded,this.bytesTotal);
		}
	}
	,__class__: lime_utils_AssetLibrary
};
var lime_utils_AssetManifest = function() {
	this.assets = [];
	this.libraryArgs = [];
	this.version = 2;
};
$hxClasses["lime.utils.AssetManifest"] = lime_utils_AssetManifest;
lime_utils_AssetManifest.__name__ = ["lime","utils","AssetManifest"];
lime_utils_AssetManifest.fromBytes = function(bytes,rootPath) {
	if(bytes != null) {
		return lime_utils_AssetManifest.parse(bytes.getString(0,bytes.length),rootPath);
	} else {
		return null;
	}
};
lime_utils_AssetManifest.fromFile = function(path,rootPath) {
	path = lime_utils_AssetManifest.__resolvePath(path);
	rootPath = lime_utils_AssetManifest.__resolveRootPath(rootPath,path);
	if(path == null) {
		return null;
	}
	return lime_utils_AssetManifest.fromBytes(lime_utils__$Bytes_Bytes_$Impl_$.fromFile(path),rootPath);
};
lime_utils_AssetManifest.loadFromBytes = function(bytes,rootPath) {
	return lime_app_Future.withValue(lime_utils_AssetManifest.fromBytes(bytes,rootPath));
};
lime_utils_AssetManifest.loadFromFile = function(path,rootPath) {
	path = lime_utils_AssetManifest.__resolvePath(path);
	rootPath = lime_utils_AssetManifest.__resolveRootPath(rootPath,path);
	if(path == null) {
		return null;
	}
	return lime_utils__$Bytes_Bytes_$Impl_$.loadFromFile(path).then(function(bytes) {
		return lime_app_Future.withValue(lime_utils_AssetManifest.fromBytes(bytes,rootPath));
	});
};
lime_utils_AssetManifest.parse = function(data,rootPath) {
	if(data == null || data == "") {
		return null;
	}
	var manifestData = JSON.parse(data);
	var manifest = new lime_utils_AssetManifest();
	if(Object.prototype.hasOwnProperty.call(manifestData,"name")) {
		manifest.name = manifestData.name;
	}
	if(Object.prototype.hasOwnProperty.call(manifestData,"libraryType")) {
		manifest.libraryType = manifestData.libraryType;
	}
	if(Object.prototype.hasOwnProperty.call(manifestData,"libraryArgs")) {
		manifest.libraryArgs = manifestData.libraryArgs;
	}
	if(Object.prototype.hasOwnProperty.call(manifestData,"assets")) {
		var assets = manifestData.assets;
		if(Object.prototype.hasOwnProperty.call(manifestData,"version") && manifestData.version <= 2) {
			manifest.assets = haxe_Unserializer.run(assets);
		} else {
			manifest.assets = assets;
		}
	}
	if(Object.prototype.hasOwnProperty.call(manifestData,"rootPath")) {
		manifest.rootPath = manifestData.rootPath;
	}
	if(rootPath != null && rootPath != "") {
		if(manifest.rootPath == null || manifest.rootPath == "") {
			manifest.rootPath = rootPath;
		} else {
			manifest.rootPath = rootPath + "/" + manifest.rootPath;
		}
	}
	return manifest;
};
lime_utils_AssetManifest.__resolvePath = function(path) {
	if(path == null) {
		return null;
	}
	var queryIndex = path.indexOf("?");
	var basePath;
	if(queryIndex > -1) {
		basePath = HxOverrides.substr(path,0,queryIndex);
	} else {
		basePath = path;
	}
	basePath = StringTools.replace(basePath,"\\","/");
	while(StringTools.endsWith(basePath,"/")) basePath = HxOverrides.substr(basePath,0,basePath.length - 1);
	if(StringTools.endsWith(basePath,".bundle")) {
		if(queryIndex > -1) {
			return basePath + "/library.json" + HxOverrides.substr(path,queryIndex,null);
		} else {
			return basePath + "/library.json";
		}
	} else {
		return path;
	}
};
lime_utils_AssetManifest.__resolveRootPath = function(rootPath,path) {
	if(rootPath != null) {
		return rootPath;
	}
	var queryIndex = path.indexOf("?");
	if(queryIndex > -1) {
		rootPath = HxOverrides.substr(path,0,queryIndex);
	} else {
		rootPath = path;
	}
	rootPath = StringTools.replace(rootPath,"\\","/");
	while(StringTools.endsWith(rootPath,"/")) {
		if(rootPath == "/") {
			return rootPath;
		}
		rootPath = HxOverrides.substr(rootPath,0,rootPath.length - 1);
	}
	if(StringTools.endsWith(rootPath,".bundle")) {
		return rootPath;
	} else {
		return haxe_io_Path.directory(rootPath);
	}
};
lime_utils_AssetManifest.prototype = {
	serialize: function() {
		var manifestData = { };
		manifestData.version = this.version;
		manifestData.libraryType = this.libraryType;
		manifestData.libraryArgs = this.libraryArgs;
		manifestData.name = this.name;
		manifestData.assets = haxe_Serializer.run(this.assets);
		manifestData.rootPath = this.rootPath;
		return JSON.stringify(manifestData);
	}
	,__class__: lime_utils_AssetManifest
};
var lime_utils_Assets = function() { };
$hxClasses["lime.utils.Assets"] = lime_utils_Assets;
lime_utils_Assets.__name__ = ["lime","utils","Assets"];
lime_utils_Assets.exists = function(id,type) {
	if(type == null) {
		type = "BINARY";
	}
	var symbol_symbolName;
	var symbol_libraryName;
	var symbol_library;
	var colonIndex = id.indexOf(":");
	symbol_libraryName = id.substring(0,colonIndex);
	symbol_symbolName = id.substring(colonIndex + 1);
	symbol_library = lime_utils_Assets.getLibrary(symbol_libraryName);
	if(symbol_library != null) {
		return symbol_library.exists(symbol_symbolName,type);
	}
	return false;
};
lime_utils_Assets.getAsset = function(id,type,useCache) {
	if(useCache && lime_utils_Assets.cache.enabled) {
		switch(type) {
		case "BINARY":case "TEXT":
			useCache = false;
			break;
		case "FONT":
			var font = lime_utils_Assets.cache.font.get(id);
			if(font != null) {
				return font;
			}
			break;
		case "IMAGE":
			var image = lime_utils_Assets.cache.image.get(id);
			if(lime_utils_Assets.isValidImage(image)) {
				return image;
			}
			break;
		case "MUSIC":case "SOUND":
			var audio = lime_utils_Assets.cache.audio.get(id);
			if(lime_utils_Assets.isValidAudio(audio)) {
				return audio;
			}
			break;
		case "TEMPLATE":
			throw new js__$Boot_HaxeError("Not sure how to get template: " + id);
			break;
		default:
			return null;
		}
	}
	var symbol_symbolName;
	var symbol_libraryName;
	var symbol_library;
	var colonIndex = id.indexOf(":");
	symbol_libraryName = id.substring(0,colonIndex);
	symbol_symbolName = id.substring(colonIndex + 1);
	symbol_library = lime_utils_Assets.getLibrary(symbol_libraryName);
	if(symbol_library != null) {
		if(symbol_library.exists(symbol_symbolName,type)) {
			if(symbol_library.isLocal(symbol_symbolName,type)) {
				var asset = symbol_library.getAsset(symbol_symbolName,type);
				if(useCache && lime_utils_Assets.cache.enabled) {
					lime_utils_Assets.cache.set(id,type,asset);
				}
				return asset;
			} else {
				lime_utils_Log.error(type + " asset \"" + id + "\" exists, but only asynchronously",{ fileName : "Assets.hx", lineNumber : 133, className : "lime.utils.Assets", methodName : "getAsset"});
			}
		} else {
			lime_utils_Log.error("There is no " + type + " asset with an ID of \"" + id + "\"",{ fileName : "Assets.hx", lineNumber : 138, className : "lime.utils.Assets", methodName : "getAsset"});
		}
	} else {
		lime_utils_Log.error(lime_utils_Assets.__libraryNotFound(symbol_libraryName),{ fileName : "Assets.hx", lineNumber : 143, className : "lime.utils.Assets", methodName : "getAsset"});
	}
	return null;
};
lime_utils_Assets.getAudioBuffer = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.getAsset(id,"SOUND",useCache);
};
lime_utils_Assets.getBytes = function(id) {
	return lime_utils_Assets.getAsset(id,"BINARY",false);
};
lime_utils_Assets.getFont = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.getAsset(id,"FONT",useCache);
};
lime_utils_Assets.getImage = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.getAsset(id,"IMAGE",useCache);
};
lime_utils_Assets.getLibrary = function(name) {
	if(name == null || name == "") {
		name = "default";
	}
	var _this = lime_utils_Assets.libraries;
	if(__map_reserved[name] != null) {
		return _this.getReserved(name);
	} else {
		return _this.h[name];
	}
};
lime_utils_Assets.getPath = function(id) {
	var symbol_symbolName;
	var symbol_libraryName;
	var symbol_library;
	var colonIndex = id.indexOf(":");
	symbol_libraryName = id.substring(0,colonIndex);
	symbol_symbolName = id.substring(colonIndex + 1);
	symbol_library = lime_utils_Assets.getLibrary(symbol_libraryName);
	if(symbol_library != null) {
		if(symbol_library.exists(symbol_symbolName,null)) {
			return symbol_library.getPath(symbol_symbolName);
		} else {
			lime_utils_Log.error("There is no asset with an ID of \"" + id + "\"",{ fileName : "Assets.hx", lineNumber : 224, className : "lime.utils.Assets", methodName : "getPath"});
		}
	} else {
		lime_utils_Log.error(lime_utils_Assets.__libraryNotFound(symbol_libraryName),{ fileName : "Assets.hx", lineNumber : 229, className : "lime.utils.Assets", methodName : "getPath"});
	}
	return null;
};
lime_utils_Assets.getText = function(id) {
	return lime_utils_Assets.getAsset(id,"TEXT",false);
};
lime_utils_Assets.hasLibrary = function(name) {
	if(name == null || name == "") {
		name = "default";
	}
	var _this = lime_utils_Assets.libraries;
	if(__map_reserved[name] != null) {
		return _this.existsReserved(name);
	} else {
		return _this.h.hasOwnProperty(name);
	}
};
lime_utils_Assets.isLocal = function(id,type,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	if(useCache && lime_utils_Assets.cache.enabled) {
		if(lime_utils_Assets.cache.exists(id,type)) {
			return true;
		}
	}
	var symbol_symbolName;
	var symbol_libraryName;
	var symbol_library;
	var colonIndex = id.indexOf(":");
	symbol_libraryName = id.substring(0,colonIndex);
	symbol_symbolName = id.substring(colonIndex + 1);
	symbol_library = lime_utils_Assets.getLibrary(symbol_libraryName);
	if(symbol_library != null) {
		return symbol_library.isLocal(symbol_symbolName,type);
	} else {
		return false;
	}
};
lime_utils_Assets.isValidAudio = function(buffer) {
	return buffer != null;
};
lime_utils_Assets.isValidImage = function(image) {
	if(image != null) {
		return image.buffer != null;
	} else {
		return false;
	}
};
lime_utils_Assets.list = function(type) {
	var items = [];
	var _this = lime_utils_Assets.libraries;
	var library = new haxe_ds__$StringMap_StringMapIterator(_this,_this.arrayKeys());
	while(library.hasNext()) {
		var library1 = library.next();
		var libraryItems = library1.list(type);
		if(libraryItems != null) {
			items = items.concat(libraryItems);
		}
	}
	return items;
};
lime_utils_Assets.loadAsset = function(id,type,useCache) {
	if(useCache && lime_utils_Assets.cache.enabled) {
		switch(type) {
		case "BINARY":case "TEXT":
			useCache = false;
			break;
		case "FONT":
			var font = lime_utils_Assets.cache.font.get(id);
			if(font != null) {
				return lime_app_Future.withValue(font);
			}
			break;
		case "IMAGE":
			var image = lime_utils_Assets.cache.image.get(id);
			if(lime_utils_Assets.isValidImage(image)) {
				return lime_app_Future.withValue(image);
			}
			break;
		case "MUSIC":case "SOUND":
			var audio = lime_utils_Assets.cache.audio.get(id);
			if(lime_utils_Assets.isValidAudio(audio)) {
				return lime_app_Future.withValue(audio);
			}
			break;
		case "TEMPLATE":
			throw new js__$Boot_HaxeError("Not sure how to get template: " + id);
			break;
		default:
			return null;
		}
	}
	var symbol_symbolName;
	var symbol_libraryName;
	var symbol_library;
	var colonIndex = id.indexOf(":");
	symbol_libraryName = id.substring(0,colonIndex);
	symbol_symbolName = id.substring(colonIndex + 1);
	symbol_library = lime_utils_Assets.getLibrary(symbol_libraryName);
	if(symbol_library != null) {
		if(symbol_library.exists(symbol_symbolName,type)) {
			var future = symbol_library.loadAsset(symbol_symbolName,type);
			if(useCache && lime_utils_Assets.cache.enabled) {
				future.onComplete(function(asset) {
					lime_utils_Assets.cache.set(id,type,asset);
				});
			}
			return future;
		} else {
			return lime_app_Future.withError("There is no " + type + " asset with an ID of \"" + id + "\"");
		}
	} else {
		return lime_app_Future.withError(lime_utils_Assets.__libraryNotFound(symbol_libraryName));
	}
};
lime_utils_Assets.loadAudioBuffer = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.loadAsset(id,"SOUND",useCache);
};
lime_utils_Assets.loadBytes = function(id) {
	return lime_utils_Assets.loadAsset(id,"BINARY",false);
};
lime_utils_Assets.loadFont = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.loadAsset(id,"FONT",useCache);
};
lime_utils_Assets.loadImage = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.loadAsset(id,"IMAGE",useCache);
};
lime_utils_Assets.loadLibrary = function(id) {
	var promise = new lime_app_Promise();
	var library = lime_utils_Assets.getLibrary(id);
	if(library != null) {
		return library.load();
	}
	var path = id;
	var rootPath = null;
	var _this = lime_utils_Assets.bundlePaths;
	if(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id)) {
		var _this1 = lime_utils_Assets.bundlePaths;
		lime_utils_AssetBundle.loadFromFile(__map_reserved[id] != null ? _this1.getReserved(id) : _this1.h[id]).onComplete(function(bundle) {
			if(bundle == null) {
				promise.error("Cannot load bundle for library \"" + id + "\"");
				return;
			}
			var library1 = lime_utils_AssetLibrary.fromBundle(bundle);
			if(library1 == null) {
				promise.error("Cannot open library \"" + id + "\"");
			} else {
				var _this2 = lime_utils_Assets.libraries;
				if(__map_reserved[id] != null) {
					_this2.setReserved(id,library1);
				} else {
					_this2.h[id] = library1;
				}
				library1.onChange.add(($_=lime_utils_Assets.onChange,$bind($_,$_.dispatch)));
				var tmp = library1.load();
				promise.completeWith(tmp);
			}
		}).onError(function(_) {
			promise.error("There is no asset library with an ID of \"" + id + "\"");
		});
	} else {
		var _this3 = lime_utils_Assets.libraryPaths;
		if(__map_reserved[id] != null ? _this3.existsReserved(id) : _this3.h.hasOwnProperty(id)) {
			var _this4 = lime_utils_Assets.libraryPaths;
			if(__map_reserved[id] != null) {
				path = _this4.getReserved(id);
			} else {
				path = _this4.h[id];
			}
			rootPath = haxe_io_Path.directory(path);
		} else {
			if(StringTools.endsWith(path,".bundle")) {
				rootPath = path;
				path += "/library.json";
			} else {
				rootPath = haxe_io_Path.directory(path);
			}
			path = lime_utils_Assets.__cacheBreak(path);
		}
		lime_utils_AssetManifest.loadFromFile(path,rootPath).onComplete(function(manifest) {
			if(manifest == null) {
				promise.error("Cannot parse asset manifest for library \"" + id + "\"");
				return;
			}
			var library2 = lime_utils_AssetLibrary.fromManifest(manifest);
			if(library2 == null) {
				promise.error("Cannot open library \"" + id + "\"");
			} else {
				var _this5 = lime_utils_Assets.libraries;
				if(__map_reserved[id] != null) {
					_this5.setReserved(id,library2);
				} else {
					_this5.h[id] = library2;
				}
				library2.onChange.add(($_=lime_utils_Assets.onChange,$bind($_,$_.dispatch)));
				var tmp1 = library2.load();
				promise.completeWith(tmp1);
			}
		}).onError(function(_1) {
			promise.error("There is no asset library with an ID of \"" + id + "\"");
		});
	}
	return promise.future;
};
lime_utils_Assets.loadText = function(id) {
	return lime_utils_Assets.loadAsset(id,"TEXT",false);
};
lime_utils_Assets.registerLibrary = function(name,library) {
	var _this = lime_utils_Assets.libraries;
	if(__map_reserved[name] != null ? _this.existsReserved(name) : _this.h.hasOwnProperty(name)) {
		var _this1 = lime_utils_Assets.libraries;
		if((__map_reserved[name] != null ? _this1.getReserved(name) : _this1.h[name]) == library) {
			return;
		} else {
			lime_utils_Assets.unloadLibrary(name);
		}
	}
	if(library != null) {
		library.onChange.add(lime_utils_Assets.library_onChange);
	}
	var _this2 = lime_utils_Assets.libraries;
	if(__map_reserved[name] != null) {
		_this2.setReserved(name,library);
	} else {
		_this2.h[name] = library;
	}
};
lime_utils_Assets.unloadLibrary = function(name) {
	if(name == null || name == "") {
		name = "default";
	}
	var _this = lime_utils_Assets.libraries;
	var library = __map_reserved[name] != null ? _this.getReserved(name) : _this.h[name];
	if(library != null) {
		lime_utils_Assets.cache.clear(name + ":");
		library.onChange.remove(lime_utils_Assets.library_onChange);
		library.unload();
	}
	lime_utils_Assets.libraries.remove(name);
};
lime_utils_Assets.__cacheBreak = function(path) {
	if(lime_utils_Assets.cache.version > 0) {
		if(path.indexOf("?") > -1) {
			path += "&" + lime_utils_Assets.cache.version;
		} else {
			path += "?" + lime_utils_Assets.cache.version;
		}
	}
	return path;
};
lime_utils_Assets.__libraryNotFound = function(name) {
	if(name == null || name == "") {
		name = "default";
	}
	if(lime_app_Application.current != null && lime_app_Application.current.__preloader != null && !lime_app_Application.current.__preloader.complete) {
		return "There is no asset library named \"" + name + "\", or it is not yet preloaded";
	} else {
		return "There is no asset library named \"" + name + "\"";
	}
};
lime_utils_Assets.library_onChange = function() {
	lime_utils_Assets.cache.clear();
	lime_utils_Assets.onChange.dispatch();
};
var lime_utils__$Assets_LibrarySymbol = function(id) {
	var colonIndex = id.indexOf(":");
	this.libraryName = id.substring(0,colonIndex);
	this.symbolName = id.substring(colonIndex + 1);
	this.library = lime_utils_Assets.getLibrary(this.libraryName);
};
$hxClasses["lime.utils._Assets.LibrarySymbol"] = lime_utils__$Assets_LibrarySymbol;
lime_utils__$Assets_LibrarySymbol.__name__ = ["lime","utils","_Assets","LibrarySymbol"];
lime_utils__$Assets_LibrarySymbol.prototype = {
	isLocal: function(type) {
		return this.library.isLocal(this.symbolName,type);
	}
	,exists: function(type) {
		return this.library.exists(this.symbolName,type);
	}
	,__class__: lime_utils__$Assets_LibrarySymbol
};
var lime_utils__$BytePointer_BytePointer_$Impl_$ = {};
$hxClasses["lime.utils._BytePointer.BytePointer_Impl_"] = lime_utils__$BytePointer_BytePointer_$Impl_$;
lime_utils__$BytePointer_BytePointer_$Impl_$.__name__ = ["lime","utils","_BytePointer","BytePointer_Impl_"];
lime_utils__$BytePointer_BytePointer_$Impl_$._new = function(bytes,offset) {
	if(offset == null) {
		offset = 0;
	}
	var this1 = new lime_utils_BytePointerData(bytes,offset);
	return this1;
};
lime_utils__$BytePointer_BytePointer_$Impl_$.set = function(this1,bytes,bufferView,buffer,offset) {
	if(buffer != null) {
		bytes = haxe_io_Bytes.ofData(buffer);
	}
	if(bytes != null || bufferView == null) {
		this1.bytes = bytes;
		this1.offset = offset != null ? offset : 0;
	} else {
		this1.bytes = haxe_io_Bytes.ofData(bufferView.buffer);
		this1.offset = offset != null ? bufferView.byteOffset + offset : bufferView.byteOffset;
	}
};
lime_utils__$BytePointer_BytePointer_$Impl_$.__arrayGet = function(this1,index) {
	if(this1.bytes != null) {
		return this1.bytes.b[index + this1.offset];
	} else {
		return 0;
	}
};
lime_utils__$BytePointer_BytePointer_$Impl_$.__arraySet = function(this1,index,value) {
	if(this1.bytes == null) {
		this1.bytes.b[index + this1.offset] = value & 255;
	}
	return value;
};
lime_utils__$BytePointer_BytePointer_$Impl_$.fromArrayBufferView = function(arrayBufferView) {
	if(arrayBufferView == null) {
		return null;
	}
	return new lime_utils_BytePointerData(haxe_io_Bytes.ofData(arrayBufferView.buffer),arrayBufferView.byteOffset);
};
lime_utils__$BytePointer_BytePointer_$Impl_$.fromArrayBuffer = function(buffer) {
	if(buffer == null) {
		return null;
	}
	return new lime_utils_BytePointerData(haxe_io_Bytes.ofData(buffer),0);
};
lime_utils__$BytePointer_BytePointer_$Impl_$.fromBytes = function(bytes) {
	return new lime_utils_BytePointerData(bytes,0);
};
lime_utils__$BytePointer_BytePointer_$Impl_$.fromBytesData = function(bytesData) {
	if(bytesData == null) {
		return new lime_utils_BytePointerData(null,0);
	} else {
		return new lime_utils_BytePointerData(haxe_io_Bytes.ofData(bytesData),0);
	}
};
lime_utils__$BytePointer_BytePointer_$Impl_$.fromFile = function(path) {
	return new lime_utils_BytePointerData(lime_utils__$Bytes_Bytes_$Impl_$.fromFile(path),0);
};
lime_utils__$BytePointer_BytePointer_$Impl_$.fromLimeBytes = function(bytes) {
	return new lime_utils_BytePointerData(bytes,0);
};
lime_utils__$BytePointer_BytePointer_$Impl_$.toUInt8Array = function(bytePointer) {
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 8 | 0;
	var this1;
	if(buffer != null) {
		this1 = new Uint8Array(buffer,byteoffset);
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils__$BytePointer_BytePointer_$Impl_$.toUInt8ClampedArray = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 8 | 0;
	var this1;
	if(buffer != null) {
		this1 = new Uint8ClampedArray(buffer,byteoffset);
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils__$BytePointer_BytePointer_$Impl_$.toInt8Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 8 | 0;
	var this1;
	if(buffer != null) {
		this1 = new Int8Array(buffer,byteoffset);
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils__$BytePointer_BytePointer_$Impl_$.toUInt16Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 16 | 0;
	var this1;
	if(buffer != null) {
		this1 = new Uint16Array(buffer,byteoffset);
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils__$BytePointer_BytePointer_$Impl_$.toInt16Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 16 | 0;
	var this1;
	if(buffer != null) {
		this1 = new Int16Array(buffer,byteoffset);
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils__$BytePointer_BytePointer_$Impl_$.toUInt32Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 32 | 0;
	var this1;
	if(buffer != null) {
		this1 = new Uint32Array(buffer,byteoffset);
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils__$BytePointer_BytePointer_$Impl_$.toInt32Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 32 | 0;
	var this1;
	if(buffer != null) {
		this1 = new Int32Array(buffer,byteoffset);
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils__$BytePointer_BytePointer_$Impl_$.toFloat32Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 32 | 0;
	var this1;
	if(buffer != null) {
		this1 = new Float32Array(buffer,byteoffset);
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils__$BytePointer_BytePointer_$Impl_$.toFloat64Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 64 | 0;
	var this1;
	if(buffer != null) {
		this1 = new Float64Array(buffer,byteoffset);
	} else {
		this1 = null;
	}
	return this1;
};
var lime_utils_BytePointerData = function(bytes,offset) {
	this.bytes = bytes;
	this.offset = offset;
};
$hxClasses["lime.utils.BytePointerData"] = lime_utils_BytePointerData;
lime_utils_BytePointerData.__name__ = ["lime","utils","BytePointerData"];
lime_utils_BytePointerData.prototype = {
	__class__: lime_utils_BytePointerData
};
var lime_utils__$Bytes_Bytes_$Impl_$ = {};
$hxClasses["lime.utils._Bytes.Bytes_Impl_"] = lime_utils__$Bytes_Bytes_$Impl_$;
lime_utils__$Bytes_Bytes_$Impl_$.__name__ = ["lime","utils","_Bytes","Bytes_Impl_"];
lime_utils__$Bytes_Bytes_$Impl_$._new = function(length,bytesData) {
	var this1 = new haxe_io_Bytes(bytesData);
	return this1;
};
lime_utils__$Bytes_Bytes_$Impl_$.alloc = function(length) {
	return new haxe_io_Bytes(new ArrayBuffer(length));
};
lime_utils__$Bytes_Bytes_$Impl_$.compress = function(this1,algorithm) {
	switch(algorithm[1]) {
	case 0:
		return lime__$internal_format_Deflate.compress(this1);
	case 1:
		return lime__$internal_format_GZip.compress(this1);
	case 2:
		return lime__$internal_format_LZMA.compress(this1);
	case 3:
		return lime__$internal_format_Zlib.compress(this1);
	}
};
lime_utils__$Bytes_Bytes_$Impl_$.decompress = function(this1,algorithm) {
	switch(algorithm[1]) {
	case 0:
		return lime__$internal_format_Deflate.decompress(this1);
	case 1:
		return lime__$internal_format_GZip.decompress(this1);
	case 2:
		return lime__$internal_format_LZMA.decompress(this1);
	case 3:
		return lime__$internal_format_Zlib.decompress(this1);
	}
};
lime_utils__$Bytes_Bytes_$Impl_$.fastGet = function(b,pos) {
	return b.bytes[pos];
};
lime_utils__$Bytes_Bytes_$Impl_$.fromBytes = function(bytes) {
	if(bytes == null) {
		return null;
	}
	return lime_utils__$Bytes_Bytes_$Impl_$._new(bytes.length,bytes.b.bufferValue);
};
lime_utils__$Bytes_Bytes_$Impl_$.fromFile = function(path) {
	return null;
};
lime_utils__$Bytes_Bytes_$Impl_$.loadFromBytes = function(bytes) {
	return lime_app_Future.withValue(lime_utils__$Bytes_Bytes_$Impl_$.fromBytes(bytes));
};
lime_utils__$Bytes_Bytes_$Impl_$.loadFromFile = function(path) {
	var request = new lime_net__$HTTPRequest_$lime_$utils_$Bytes();
	return request.load(path);
};
lime_utils__$Bytes_Bytes_$Impl_$.ofData = function(b) {
	var bytes = haxe_io_Bytes.ofData(b);
	return lime_utils__$Bytes_Bytes_$Impl_$._new(bytes.length,bytes.b.bufferValue);
};
lime_utils__$Bytes_Bytes_$Impl_$.ofString = function(s) {
	var bytes = haxe_io_Bytes.ofString(s);
	return lime_utils__$Bytes_Bytes_$Impl_$._new(bytes.length,bytes.b.bufferValue);
};
var lime_utils_CompressionAlgorithm = $hxClasses["lime.utils.CompressionAlgorithm"] = { __ename__ : ["lime","utils","CompressionAlgorithm"], __constructs__ : ["DEFLATE","GZIP","LZMA","ZLIB"] };
lime_utils_CompressionAlgorithm.DEFLATE = ["DEFLATE",0];
lime_utils_CompressionAlgorithm.DEFLATE.toString = $estr;
lime_utils_CompressionAlgorithm.DEFLATE.__enum__ = lime_utils_CompressionAlgorithm;
lime_utils_CompressionAlgorithm.GZIP = ["GZIP",1];
lime_utils_CompressionAlgorithm.GZIP.toString = $estr;
lime_utils_CompressionAlgorithm.GZIP.__enum__ = lime_utils_CompressionAlgorithm;
lime_utils_CompressionAlgorithm.LZMA = ["LZMA",2];
lime_utils_CompressionAlgorithm.LZMA.toString = $estr;
lime_utils_CompressionAlgorithm.LZMA.__enum__ = lime_utils_CompressionAlgorithm;
lime_utils_CompressionAlgorithm.ZLIB = ["ZLIB",3];
lime_utils_CompressionAlgorithm.ZLIB.toString = $estr;
lime_utils_CompressionAlgorithm.ZLIB.__enum__ = lime_utils_CompressionAlgorithm;
var lime_utils__$DataPointer_DataPointer_$Impl_$ = {};
$hxClasses["lime.utils._DataPointer.DataPointer_Impl_"] = lime_utils__$DataPointer_DataPointer_$Impl_$;
lime_utils__$DataPointer_DataPointer_$Impl_$.__name__ = ["lime","utils","_DataPointer","DataPointer_Impl_"];
lime_utils__$DataPointer_DataPointer_$Impl_$._new = function(data) {
	var this1 = data;
	return this1;
};
lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat = function(value) {
	return value;
};
lime_utils__$DataPointer_DataPointer_$Impl_$.fromBytesPointer = function(pointer) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat(0);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.fromArrayBufferView = function(arrayBufferView) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat(0);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.fromArrayBuffer = function(buffer) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat(0);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.fromBytes = function(bytes) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat(0);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.fromBytesData = function(bytesData) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat(0);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.fromLimeBytes = function(bytes) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.fromBytes(bytes);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.fromCFFIPointer = function(pointer) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat(0);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.fromFile = function(path) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat(0);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.__withOffset = function(data,offset) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.fromFloat(0);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.equals = function(a,b) {
	return a == b;
};
lime_utils__$DataPointer_DataPointer_$Impl_$.equalsPointer = function(a,b) {
	return a == b;
};
lime_utils__$DataPointer_DataPointer_$Impl_$.greaterThan = function(a,b) {
	return a > b;
};
lime_utils__$DataPointer_DataPointer_$Impl_$.greaterThanPointer = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) > lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(b);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.greaterThanOrEqual = function(a,b) {
	return a >= b;
};
lime_utils__$DataPointer_DataPointer_$Impl_$.greaterThanOrEqualPointer = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) >= lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(b);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.lessThan = function(a,b) {
	return a < b;
};
lime_utils__$DataPointer_DataPointer_$Impl_$.lessThanPointer = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) < lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(b);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.lessThanOrEqual = function(a,b) {
	return a <= b;
};
lime_utils__$DataPointer_DataPointer_$Impl_$.lessThanOrEqualPointer = function(a,b) {
	return lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(a) <= lime_system__$CFFIPointer_CFFIPointer_$Impl_$.get(b);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.notEquals = function(a,b) {
	return a != b;
};
lime_utils__$DataPointer_DataPointer_$Impl_$.notEqualsPointer = function(a,b) {
	return a != b;
};
lime_utils__$DataPointer_DataPointer_$Impl_$.plus = function(a,b) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.__withOffset(a,b);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.plusPointer = function(a,b) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.__withOffset(a,b | 0);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.minus = function(a,b) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.__withOffset(a,-b);
};
lime_utils__$DataPointer_DataPointer_$Impl_$.minusPointer = function(a,b) {
	return lime_utils__$DataPointer_DataPointer_$Impl_$.__withOffset(a,-(b | 0));
};
var lime_utils__$Float32Array_Float32Array_$Impl_$ = {};
$hxClasses["lime.utils._Float32Array.Float32Array_Impl_"] = lime_utils__$Float32Array_Float32Array_$Impl_$;
lime_utils__$Float32Array_Float32Array_$Impl_$.__name__ = ["lime","utils","_Float32Array","Float32Array_Impl_"];
lime_utils__$Float32Array_Float32Array_$Impl_$.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils__$Float32Array_Float32Array_$Impl_$.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Float32Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Float32Array(bytes.b.bufferValue,byteOffset);
	}
	return new Float32Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils__$Float32Array_Float32Array_$Impl_$.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils__$Float32Array_Float32Array_$Impl_$.toString = function(this1) {
	if(this1 != null) {
		return "Float32Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils__$Float64Array_Float64Array_$Impl_$ = {};
$hxClasses["lime.utils._Float64Array.Float64Array_Impl_"] = lime_utils__$Float64Array_Float64Array_$Impl_$;
lime_utils__$Float64Array_Float64Array_$Impl_$.__name__ = ["lime","utils","_Float64Array","Float64Array_Impl_"];
lime_utils__$Float64Array_Float64Array_$Impl_$.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils__$Float64Array_Float64Array_$Impl_$.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Float64Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Float64Array(bytes.b.bufferValue,byteOffset);
	}
	return new Float64Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils__$Float64Array_Float64Array_$Impl_$.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils__$Float64Array_Float64Array_$Impl_$.toString = function(this1) {
	if(this1 != null) {
		return "Float64Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils__$Int16Array_Int16Array_$Impl_$ = {};
$hxClasses["lime.utils._Int16Array.Int16Array_Impl_"] = lime_utils__$Int16Array_Int16Array_$Impl_$;
lime_utils__$Int16Array_Int16Array_$Impl_$.__name__ = ["lime","utils","_Int16Array","Int16Array_Impl_"];
lime_utils__$Int16Array_Int16Array_$Impl_$.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils__$Int16Array_Int16Array_$Impl_$.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Int16Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Int16Array(bytes.b.bufferValue,byteOffset);
	}
	return new Int16Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils__$Int16Array_Int16Array_$Impl_$.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils__$Int16Array_Int16Array_$Impl_$.toString = function(this1) {
	if(this1 != null) {
		return "Int16Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils__$Int32Array_Int32Array_$Impl_$ = {};
$hxClasses["lime.utils._Int32Array.Int32Array_Impl_"] = lime_utils__$Int32Array_Int32Array_$Impl_$;
lime_utils__$Int32Array_Int32Array_$Impl_$.__name__ = ["lime","utils","_Int32Array","Int32Array_Impl_"];
lime_utils__$Int32Array_Int32Array_$Impl_$.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils__$Int32Array_Int32Array_$Impl_$.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Int32Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Int32Array(bytes.b.bufferValue,byteOffset);
	}
	return new Int32Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils__$Int32Array_Int32Array_$Impl_$.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils__$Int32Array_Int32Array_$Impl_$.toString = function(this1) {
	if(this1 != null) {
		return "Int32Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils__$Int8Array_Int8Array_$Impl_$ = {};
$hxClasses["lime.utils._Int8Array.Int8Array_Impl_"] = lime_utils__$Int8Array_Int8Array_$Impl_$;
lime_utils__$Int8Array_Int8Array_$Impl_$.__name__ = ["lime","utils","_Int8Array","Int8Array_Impl_"];
lime_utils__$Int8Array_Int8Array_$Impl_$.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils__$Int8Array_Int8Array_$Impl_$.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	return new Int8Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils__$Int8Array_Int8Array_$Impl_$.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils__$Int8Array_Int8Array_$Impl_$.toString = function(this1) {
	if(this1 != null) {
		return "Int8Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils_Log = function() { };
$hxClasses["lime.utils.Log"] = lime_utils_Log;
lime_utils_Log.__name__ = ["lime","utils","Log"];
lime_utils_Log.debug = function(message,info) {
	if(lime_utils_Log.level >= 4) {
		console.debug("[" + info.className + "] " + Std.string(message));
	}
};
lime_utils_Log.error = function(message,info) {
	if(lime_utils_Log.level >= 1) {
		var message1 = "[" + info.className + "] ERROR: " + Std.string(message);
		if(lime_utils_Log.throwErrors) {
			throw new js__$Boot_HaxeError(message1);
		} else {
			console.error(message1);
		}
	}
};
lime_utils_Log.info = function(message,info) {
	if(lime_utils_Log.level >= 3) {
		console.info("[" + info.className + "] " + Std.string(message));
	}
};
lime_utils_Log.print = function(message) {
	console.log(message);
};
lime_utils_Log.println = function(message) {
	console.log(message);
};
lime_utils_Log.verbose = function(message,info) {
	if(lime_utils_Log.level >= 5) {
		console.log("[" + info.className + "] " + Std.string(message));
	}
};
lime_utils_Log.warn = function(message,info) {
	if(lime_utils_Log.level >= 2) {
		console.warn("[" + info.className + "] WARNING: " + Std.string(message));
	}
};
var lime_utils__$LogLevel_LogLevel_$Impl_$ = {};
$hxClasses["lime.utils._LogLevel.LogLevel_Impl_"] = lime_utils__$LogLevel_LogLevel_$Impl_$;
lime_utils__$LogLevel_LogLevel_$Impl_$.__name__ = ["lime","utils","_LogLevel","LogLevel_Impl_"];
lime_utils__$LogLevel_LogLevel_$Impl_$.gt = function(a,b) {
	return a > b;
};
lime_utils__$LogLevel_LogLevel_$Impl_$.gte = function(a,b) {
	return a >= b;
};
lime_utils__$LogLevel_LogLevel_$Impl_$.lt = function(a,b) {
	return a < b;
};
lime_utils__$LogLevel_LogLevel_$Impl_$.lte = function(a,b) {
	return a <= b;
};
var lime_utils_Preloader = function() {
	this.bytesTotalCache = new haxe_ds_StringMap();
	this.bytesLoadedCache2 = new haxe_ds_StringMap();
	this.bytesLoadedCache = new haxe_ds_ObjectMap();
	this.onProgress = new lime_app__$Event_$Int_$Int_$Void();
	this.onComplete = new lime_app__$Event_$Void_$Void();
	this.bytesLoaded = 0;
	this.bytesTotal = 0;
	this.libraries = [];
	this.libraryNames = [];
	this.onProgress.add($bind(this,this.update));
};
$hxClasses["lime.utils.Preloader"] = lime_utils_Preloader;
lime_utils_Preloader.__name__ = ["lime","utils","Preloader"];
lime_utils_Preloader.prototype = {
	addLibrary: function(library) {
		this.libraries.push(library);
	}
	,addLibraryName: function(name) {
		if(this.libraryNames.indexOf(name) == -1) {
			this.libraryNames.push(name);
		}
	}
	,load: function() {
		var _gthis = this;
		var _g = 0;
		var _g1 = this.libraries;
		while(_g < _g1.length) {
			var library = _g1[_g];
			++_g;
			this.bytesTotal += library.bytesTotal;
		}
		this.loadedLibraries = -1;
		this.preloadStarted = false;
		var _g2 = 0;
		var _g11 = this.libraries;
		while(_g2 < _g11.length) {
			var library1 = [_g11[_g2]];
			++_g2;
			lime_utils_Log.verbose("Preloading asset library",{ fileName : "Preloader.hx", lineNumber : 132, className : "lime.utils.Preloader", methodName : "load"});
			library1[0].load().onProgress((function(library2) {
				return function(loaded,total) {
					if(_gthis.bytesLoadedCache.h.__keys__[library2[0].__id__] == null) {
						_gthis.bytesLoaded += loaded;
					} else {
						_gthis.bytesLoaded += loaded - _gthis.bytesLoadedCache.h[library2[0].__id__];
					}
					_gthis.bytesLoadedCache.set(library2[0],loaded);
					if(!_gthis.simulateProgress) {
						_gthis.onProgress.dispatch(_gthis.bytesLoaded,_gthis.bytesTotal);
					}
				};
			})(library1)).onComplete((function(library3) {
				return function(_) {
					if(_gthis.bytesLoadedCache.h.__keys__[library3[0].__id__] == null) {
						_gthis.bytesLoaded += library3[0].bytesTotal;
					} else {
						_gthis.bytesLoaded += library3[0].bytesTotal - _gthis.bytesLoadedCache.h[library3[0].__id__];
					}
					_gthis.loadedAssetLibrary();
				};
			})(library1)).onError((function() {
				return function(e) {
					lime_utils_Log.error(e,{ fileName : "Preloader.hx", lineNumber : 168, className : "lime.utils.Preloader", methodName : "load"});
				};
			})());
		}
		var _g3 = 0;
		var _g12 = this.libraryNames;
		while(_g3 < _g12.length) {
			var name = _g12[_g3];
			++_g3;
			this.bytesTotal += 200;
		}
		this.loadedLibraries++;
		this.preloadStarted = true;
		this.updateProgress();
	}
	,loadedAssetLibrary: function(name) {
		this.loadedLibraries++;
		var current = this.loadedLibraries;
		if(!this.preloadStarted) {
			++current;
		}
		var totalLibraries = this.libraries.length + this.libraryNames.length;
		if(name != null) {
			lime_utils_Log.verbose("Loaded asset library: " + name + " [" + current + "/" + totalLibraries + "]",{ fileName : "Preloader.hx", lineNumber : 195, className : "lime.utils.Preloader", methodName : "loadedAssetLibrary"});
		} else {
			lime_utils_Log.verbose("Loaded asset library [" + current + "/" + totalLibraries + "]",{ fileName : "Preloader.hx", lineNumber : 199, className : "lime.utils.Preloader", methodName : "loadedAssetLibrary"});
		}
		this.updateProgress();
	}
	,start: function() {
		if(this.complete || this.simulateProgress || !this.preloadComplete) {
			return;
		}
		this.complete = true;
		this.onComplete.dispatch();
	}
	,update: function(loaded,total) {
	}
	,updateProgress: function() {
		var _gthis = this;
		if(!this.simulateProgress) {
			this.onProgress.dispatch(this.bytesLoaded,this.bytesTotal);
		}
		if(this.loadedLibraries == this.libraries.length && !this.initLibraryNames) {
			this.initLibraryNames = true;
			var _g = 0;
			var _g1 = this.libraryNames;
			while(_g < _g1.length) {
				var name = [_g1[_g]];
				++_g;
				lime_utils_Log.verbose("Preloading asset library: " + name[0],{ fileName : "Preloader.hx", lineNumber : 236, className : "lime.utils.Preloader", methodName : "updateProgress"});
				lime_utils_Assets.loadLibrary(name[0]).onProgress((function(name1) {
					return function(loaded,total) {
						if(total > 0) {
							var _this = _gthis.bytesTotalCache;
							if(!(__map_reserved[name1[0]] != null ? _this.existsReserved(name1[0]) : _this.h.hasOwnProperty(name1[0]))) {
								var _this1 = _gthis.bytesTotalCache;
								if(__map_reserved[name1[0]] != null) {
									_this1.setReserved(name1[0],total);
								} else {
									_this1.h[name1[0]] = total;
								}
								_gthis.bytesTotal += total - 200;
							}
							if(loaded > total) {
								loaded = total;
							}
							var _this2 = _gthis.bytesLoadedCache2;
							if(!(__map_reserved[name1[0]] != null ? _this2.existsReserved(name1[0]) : _this2.h.hasOwnProperty(name1[0]))) {
								_gthis.bytesLoaded += loaded;
							} else {
								var _this3 = _gthis.bytesLoadedCache2;
								_gthis.bytesLoaded += loaded - (__map_reserved[name1[0]] != null ? _this3.getReserved(name1[0]) : _this3.h[name1[0]]);
							}
							var _this4 = _gthis.bytesLoadedCache2;
							if(__map_reserved[name1[0]] != null) {
								_this4.setReserved(name1[0],loaded);
							} else {
								_this4.h[name1[0]] = loaded;
							}
							if(!_gthis.simulateProgress) {
								_gthis.onProgress.dispatch(_gthis.bytesLoaded,_gthis.bytesTotal);
							}
						}
					};
				})(name)).onComplete((function(name2) {
					return function(library) {
						var total1 = 200;
						var _this5 = _gthis.bytesTotalCache;
						if(__map_reserved[name2[0]] != null ? _this5.existsReserved(name2[0]) : _this5.h.hasOwnProperty(name2[0])) {
							var _this6 = _gthis.bytesTotalCache;
							if(__map_reserved[name2[0]] != null) {
								total1 = _this6.getReserved(name2[0]);
							} else {
								total1 = _this6.h[name2[0]];
							}
						}
						var _this7 = _gthis.bytesLoadedCache2;
						if(!(__map_reserved[name2[0]] != null ? _this7.existsReserved(name2[0]) : _this7.h.hasOwnProperty(name2[0]))) {
							_gthis.bytesLoaded += total1;
						} else {
							var _this8 = _gthis.bytesLoadedCache2;
							_gthis.bytesLoaded += total1 - (__map_reserved[name2[0]] != null ? _this8.getReserved(name2[0]) : _this8.h[name2[0]]);
						}
						_gthis.loadedAssetLibrary(name2[0]);
					};
				})(name)).onError((function() {
					return function(e) {
						lime_utils_Log.error(e,{ fileName : "Preloader.hx", lineNumber : 290, className : "lime.utils.Preloader", methodName : "updateProgress"});
					};
				})());
			}
		}
		if(!this.simulateProgress && this.loadedLibraries == this.libraries.length + this.libraryNames.length) {
			if(!this.preloadComplete) {
				this.preloadComplete = true;
				lime_utils_Log.verbose("Preload complete",{ fileName : "Preloader.hx", lineNumber : 301, className : "lime.utils.Preloader", methodName : "updateProgress"});
			}
			this.start();
		}
	}
	,__class__: lime_utils_Preloader
};
var lime_utils__$UInt16Array_UInt16Array_$Impl_$ = {};
$hxClasses["lime.utils._UInt16Array.UInt16Array_Impl_"] = lime_utils__$UInt16Array_UInt16Array_$Impl_$;
lime_utils__$UInt16Array_UInt16Array_$Impl_$.__name__ = ["lime","utils","_UInt16Array","UInt16Array_Impl_"];
lime_utils__$UInt16Array_UInt16Array_$Impl_$.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils__$UInt16Array_UInt16Array_$Impl_$.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Uint16Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Uint16Array(bytes.b.bufferValue,byteOffset);
	}
	return new Uint16Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils__$UInt16Array_UInt16Array_$Impl_$.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils__$UInt16Array_UInt16Array_$Impl_$.toString = function(this1) {
	if(this1 != null) {
		return "UInt16Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils__$UInt32Array_UInt32Array_$Impl_$ = {};
$hxClasses["lime.utils._UInt32Array.UInt32Array_Impl_"] = lime_utils__$UInt32Array_UInt32Array_$Impl_$;
lime_utils__$UInt32Array_UInt32Array_$Impl_$.__name__ = ["lime","utils","_UInt32Array","UInt32Array_Impl_"];
lime_utils__$UInt32Array_UInt32Array_$Impl_$.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils__$UInt32Array_UInt32Array_$Impl_$.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Uint32Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Uint32Array(bytes.b.bufferValue,byteOffset);
	}
	return new Uint32Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils__$UInt32Array_UInt32Array_$Impl_$.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils__$UInt32Array_UInt32Array_$Impl_$.toString = function(this1) {
	if(this1 != null) {
		return "UInt32Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils__$UInt8Array_UInt8Array_$Impl_$ = {};
$hxClasses["lime.utils._UInt8Array.UInt8Array_Impl_"] = lime_utils__$UInt8Array_UInt8Array_$Impl_$;
lime_utils__$UInt8Array_UInt8Array_$Impl_$.__name__ = ["lime","utils","_UInt8Array","UInt8Array_Impl_"];
lime_utils__$UInt8Array_UInt8Array_$Impl_$.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils__$UInt8Array_UInt8Array_$Impl_$.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		return new Uint8Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Uint8Array(bytes.b.bufferValue,byteOffset);
	}
	return new Uint8Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils__$UInt8Array_UInt8Array_$Impl_$.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils__$UInt8Array_UInt8Array_$Impl_$.toString = function(this1) {
	if(this1 != null) {
		return "UInt8Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils__$UInt8ClampedArray_UInt8ClampedArray_$Impl_$ = {};
$hxClasses["lime.utils._UInt8ClampedArray.UInt8ClampedArray_Impl_"] = lime_utils__$UInt8ClampedArray_UInt8ClampedArray_$Impl_$;
lime_utils__$UInt8ClampedArray_UInt8ClampedArray_$Impl_$.__name__ = ["lime","utils","_UInt8ClampedArray","UInt8ClampedArray_Impl_"];
lime_utils__$UInt8ClampedArray_UInt8ClampedArray_$Impl_$.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils__$UInt8ClampedArray_UInt8ClampedArray_$Impl_$.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Uint8ClampedArray(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Uint8ClampedArray(bytes.b.bufferValue,byteOffset);
	}
	return new Uint8ClampedArray(bytes.b.bufferValue,byteOffset,len);
};
lime_utils__$UInt8ClampedArray_UInt8ClampedArray_$Impl_$.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils__$UInt8ClampedArray_UInt8ClampedArray_$Impl_$.toString = function(this1) {
	if(this1 != null) {
		return "UInt8ClampedArray [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
lime_utils__$UInt8ClampedArray_UInt8ClampedArray_$Impl_$._clamp = function(_in) {
	var _out = _in | 0;
	if(_out > 255) {
		_out = 255;
	} else {
		_out = _out;
	}
	if(_out < 0) {
		return 0;
	} else {
		return _out;
	}
};
var openfl_Lib = function() { };
$hxClasses["openfl.Lib"] = openfl_Lib;
openfl_Lib.__name__ = ["openfl","Lib"];
openfl_Lib.__properties__ = {get_current:"get_current",get_application:"get_application"};
openfl_Lib["as"] = function(v,c) {
	if(js_Boot.__instanceof(v,c)) {
		return v;
	} else {
		return null;
	}
};
openfl_Lib.attach = function(name) {
	return new openfl_display_MovieClip();
};
openfl_Lib.clearInterval = function(id) {
	if(openfl_Lib.__timers.h.hasOwnProperty(id)) {
		var timer = openfl_Lib.__timers.h[id];
		timer.stop();
		openfl_Lib.__timers.remove(id);
	}
};
openfl_Lib.clearTimeout = function(id) {
	if(openfl_Lib.__timers.h.hasOwnProperty(id)) {
		var timer = openfl_Lib.__timers.h[id];
		timer.stop();
		openfl_Lib.__timers.remove(id);
	}
};
openfl_Lib.getDefinitionByName = function(name) {
	if(name == null) {
		return null;
	}
	return Type.resolveClass(name);
};
openfl_Lib.getQualifiedClassName = function(value) {
	if(value == null) {
		return null;
	}
	var ref;
	if(js_Boot.__instanceof(value,Class)) {
		ref = value;
	} else {
		var o = value;
		if(o == null) {
			ref = null;
		} else {
			ref = js_Boot.getClass(o);
		}
	}
	if(ref == null) {
		if(typeof(value) == "boolean" || value == Bool) {
			return "Bool";
		} else if(typeof(value) == "number" && ((value | 0) === value) || value == Int) {
			return "Int";
		} else if(typeof(value) == "number" || value == Float) {
			return "Float";
		} else {
			return null;
		}
	}
	return Type.getClassName(ref);
};
openfl_Lib.getQualifiedSuperclassName = function(value) {
	if(value == null) {
		return null;
	}
	var ref;
	if(js_Boot.__instanceof(value,Class)) {
		ref = value;
	} else {
		var o = value;
		if(o == null) {
			ref = null;
		} else {
			ref = js_Boot.getClass(o);
		}
	}
	if(ref == null) {
		return null;
	}
	var parentRef = Type.getSuperClass(ref);
	if(parentRef == null) {
		return null;
	}
	return Type.getClassName(parentRef);
};
openfl_Lib.getTimer = function() {
	return lime_system_System.getTimer();
};
openfl_Lib.getURL = function(request,target) {
	openfl_Lib.navigateToURL(request,target);
};
openfl_Lib.navigateToURL = function(request,window) {
	if(window == null) {
		window = "_blank";
	}
	var uri = request.url;
	if(Type["typeof"](request.data) == ValueType.TObject) {
		var query = "";
		var fields = Reflect.fields(request.data);
		var _g = 0;
		while(_g < fields.length) {
			var field = fields[_g];
			++_g;
			if(query.length > 0) {
				query += "&";
			}
			var query1 = encodeURIComponent(field) + "=";
			var s = Std.string(Reflect.field(request.data,field));
			query += query1 + encodeURIComponent(s);
		}
		if(uri.indexOf("?") > -1) {
			uri += "&" + query;
		} else {
			uri += "?" + query;
		}
	}
	lime_system_System.openURL(uri,window);
};
openfl_Lib.notImplemented = function(posInfo) {
	var api = posInfo.className + "." + posInfo.methodName;
	var _this = openfl_Lib.__sentWarnings;
	if(!(__map_reserved[api] != null ? _this.existsReserved(api) : _this.h.hasOwnProperty(api))) {
		var _this1 = openfl_Lib.__sentWarnings;
		if(__map_reserved[api] != null) {
			_this1.setReserved(api,true);
		} else {
			_this1.h[api] = true;
		}
		lime_utils_Log.warn(posInfo.methodName + " is not implemented",posInfo);
	}
};
openfl_Lib.preventDefaultTouchMove = function() {
	window.document.addEventListener("touchmove",function(evt) {
		evt.preventDefault();
	},false);
};
openfl_Lib.sendToURL = function(request) {
	var urlLoader = new openfl_net_URLLoader();
	urlLoader.load(request);
};
openfl_Lib.setInterval = function(closure,delay,args) {
	var id = ++openfl_Lib.__lastTimerID;
	var timer = new haxe_Timer(delay);
	openfl_Lib.__timers.h[id] = timer;
	timer.run = function() {
		closure.apply(closure,args == null ? [] : args);
	};
	return id;
};
openfl_Lib.setTimeout = function(closure,delay,args) {
	var id = ++openfl_Lib.__lastTimerID;
	var this1 = openfl_Lib.__timers;
	var v = haxe_Timer.delay(function() {
		closure.apply(closure,args == null ? [] : args);
	},delay);
	this1.h[id] = v;
	return id;
};
openfl_Lib.trace = function(arg) {
	haxe_Log.trace(arg,{ fileName : "Lib.hx", lineNumber : 565, className : "openfl.Lib", methodName : "trace"});
};
openfl_Lib.get_application = function() {
	return openfl_utils__$internal_Lib.application;
};
openfl_Lib.get_current = function() {
	if(openfl_utils__$internal_Lib.current == null) {
		openfl_utils__$internal_Lib.current = new openfl_display_MovieClip();
	}
	return openfl_utils__$internal_Lib.current;
};
var openfl__$Vector_IVector = function() { };
$hxClasses["openfl._Vector.IVector"] = openfl__$Vector_IVector;
openfl__$Vector_IVector.__name__ = ["openfl","_Vector","IVector"];
openfl__$Vector_IVector.prototype = {
	__class__: openfl__$Vector_IVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl__$Vector_BoolVector = function(length,fixed,array) {
	if(fixed == null) {
		fixed = false;
	}
	if(length == null) {
		length = 0;
	}
	if(array == null) {
		array = [];
	}
	this.__array = array;
	if(length > 0) {
		this.set_length(length);
	}
	this.fixed = fixed;
};
$hxClasses["openfl._Vector.BoolVector"] = openfl__$Vector_BoolVector;
openfl__$Vector_BoolVector.__name__ = ["openfl","_Vector","BoolVector"];
openfl__$Vector_BoolVector.__interfaces__ = [openfl__$Vector_IVector];
openfl__$Vector_BoolVector.prototype = {
	concat: function(a) {
		if(a == null) {
			return new openfl__$Vector_BoolVector(0,false,this.__array.slice());
		} else {
			var other = a;
			if(other.__array.length > 0) {
				return new openfl__$Vector_BoolVector(0,false,this.__array.concat(other.__array));
			} else {
				return new openfl__$Vector_BoolVector(0,false,this.__array.slice());
			}
		}
	}
	,copy: function() {
		return new openfl__$Vector_BoolVector(0,this.fixed,this.__array.slice());
	}
	,filter: function(callback) {
		return new openfl__$Vector_BoolVector(0,this.fixed,this.__array.filter(callback));
	}
	,get: function(index) {
		if(index >= this.__array.length) {
			return false;
		} else {
			return this.__array[index];
		}
	}
	,indexOf: function(x,from) {
		if(from == null) {
			from = 0;
		}
		var _g1 = from;
		var _g = this.__array.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(this.__array[i] == x) {
				return i;
			}
		}
		return -1;
	}
	,insertAt: function(index,element) {
		if(!this.fixed || index < this.__array.length) {
			this.__array.splice(index,0,element);
		}
	}
	,iterator: function() {
		return HxOverrides.iter(this.__array);
	}
	,join: function(sep) {
		if(sep == null) {
			sep = ",";
		}
		return this.__array.join(sep);
	}
	,lastIndexOf: function(x,from) {
		var i = from == null || from >= this.__array.length ? this.__array.length - 1 : from;
		while(i >= 0) {
			if(this.__array[i] == x) {
				return i;
			}
			--i;
		}
		return -1;
	}
	,pop: function() {
		if(!this.fixed) {
			return this.__array.pop();
		} else {
			return null;
		}
	}
	,push: function(x) {
		if(!this.fixed) {
			return this.__array.push(x);
		} else {
			return this.__array.length;
		}
	}
	,removeAt: function(index) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array.splice(index,1)[0];
		}
		return false;
	}
	,reverse: function() {
		this.__array.reverse();
		return this;
	}
	,set: function(index,value) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array[index] = value;
		} else {
			return value;
		}
	}
	,shift: function() {
		if(!this.fixed) {
			return this.__array.shift();
		} else {
			return null;
		}
	}
	,slice: function(startIndex,endIndex) {
		if(startIndex == null) {
			startIndex = 0;
		}
		if(endIndex == null) {
			endIndex = 16777215;
		}
		return new openfl__$Vector_BoolVector(0,false,this.__array.slice(startIndex,endIndex));
	}
	,sort: function(f) {
		this.__array.sort(f);
	}
	,splice: function(pos,len) {
		return new openfl__$Vector_BoolVector(0,false,this.__array.splice(pos,len));
	}
	,toJSON: function() {
		return this.__array;
	}
	,toString: function() {
		if(this.__array != null) {
			return this.__array.toString();
		} else {
			return null;
		}
	}
	,unshift: function(x) {
		if(!this.fixed) {
			this.__array.unshift(x);
		}
	}
	,get_length: function() {
		return this.__array.length;
	}
	,set_length: function(value) {
		if(!this.fixed) {
			var currentLength = this.__array.length;
			if(value < 0) {
				value = 0;
			}
			if(value > currentLength) {
				var _g1 = currentLength;
				var _g = value;
				while(_g1 < _g) {
					var i = _g1++;
					this.__array[i] = false;
				}
			} else {
				while(this.__array.length > value) this.__array.pop();
			}
		}
		return this.__array.length;
	}
	,__class__: openfl__$Vector_BoolVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl__$Vector_FloatVector = function(length,fixed,array,forceCopy) {
	if(forceCopy == null) {
		forceCopy = false;
	}
	if(fixed == null) {
		fixed = false;
	}
	if(length == null) {
		length = 0;
	}
	if(forceCopy) {
		this.__array = [];
		if(array != null) {
			var _g1 = 0;
			var _g = array.length;
			while(_g1 < _g) {
				var i = _g1++;
				this.__array[i] = array[i];
			}
		}
	} else {
		if(array == null) {
			array = [];
		}
		this.__array = array;
	}
	if(length > 0) {
		this.set_length(length);
	}
	this.fixed = fixed;
};
$hxClasses["openfl._Vector.FloatVector"] = openfl__$Vector_FloatVector;
openfl__$Vector_FloatVector.__name__ = ["openfl","_Vector","FloatVector"];
openfl__$Vector_FloatVector.__interfaces__ = [openfl__$Vector_IVector];
openfl__$Vector_FloatVector.prototype = {
	concat: function(a) {
		if(a == null) {
			return new openfl__$Vector_FloatVector(0,false,this.__array.slice());
		} else {
			var other = a;
			if(other.__array.length > 0) {
				return new openfl__$Vector_FloatVector(0,false,this.__array.concat(other.__array));
			} else {
				return new openfl__$Vector_FloatVector(0,false,this.__array.slice());
			}
		}
	}
	,copy: function() {
		return new openfl__$Vector_FloatVector(0,this.fixed,this.__array.slice());
	}
	,filter: function(callback) {
		return new openfl__$Vector_FloatVector(0,this.fixed,this.__array.filter(callback));
	}
	,get: function(index) {
		return this.__array[index];
	}
	,indexOf: function(x,from) {
		if(from == null) {
			from = 0;
		}
		var _g1 = from;
		var _g = this.__array.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(this.__array[i] == x) {
				return i;
			}
		}
		return -1;
	}
	,insertAt: function(index,element) {
		if(!this.fixed || index < this.__array.length) {
			this.__array.splice(index,0,element);
		}
	}
	,iterator: function() {
		return HxOverrides.iter(this.__array);
	}
	,join: function(sep) {
		if(sep == null) {
			sep = ",";
		}
		return this.__array.join(sep);
	}
	,lastIndexOf: function(x,from) {
		var i = from == null || from >= this.__array.length ? this.__array.length - 1 : from;
		while(i >= 0) {
			if(this.__array[i] == x) {
				return i;
			}
			--i;
		}
		return -1;
	}
	,pop: function() {
		if(!this.fixed) {
			return this.__array.pop();
		} else {
			return null;
		}
	}
	,push: function(x) {
		if(!this.fixed) {
			return this.__array.push(x);
		} else {
			return this.__array.length;
		}
	}
	,removeAt: function(index) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array.splice(index,1)[0];
		}
		return 0;
	}
	,reverse: function() {
		this.__array.reverse();
		return this;
	}
	,set: function(index,value) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array[index] = value;
		} else {
			return value;
		}
	}
	,shift: function() {
		if(!this.fixed) {
			return this.__array.shift();
		} else {
			return null;
		}
	}
	,slice: function(startIndex,endIndex) {
		if(startIndex == null) {
			startIndex = 0;
		}
		if(endIndex == null) {
			endIndex = 16777215;
		}
		return new openfl__$Vector_FloatVector(0,false,this.__array.slice(startIndex,endIndex));
	}
	,sort: function(f) {
		this.__array.sort(f);
	}
	,splice: function(pos,len) {
		return new openfl__$Vector_FloatVector(0,false,this.__array.splice(pos,len));
	}
	,toJSON: function() {
		return this.__array;
	}
	,toString: function() {
		if(this.__array != null) {
			return this.__array.toString();
		} else {
			return null;
		}
	}
	,unshift: function(x) {
		if(!this.fixed) {
			this.__array.unshift(x);
		}
	}
	,get_length: function() {
		return this.__array.length;
	}
	,set_length: function(value) {
		if(value != this.__array.length && !this.fixed) {
			var currentLength = this.__array.length;
			if(value < 0) {
				value = 0;
			}
			if(value > currentLength) {
				var _g1 = currentLength;
				var _g = value;
				while(_g1 < _g) {
					var i = _g1++;
					this.__array[i] = 0;
				}
			} else {
				while(this.__array.length > value) this.__array.pop();
			}
		}
		return this.__array.length;
	}
	,__class__: openfl__$Vector_FloatVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl__$Vector_FunctionVector = function(length,fixed,array) {
	if(fixed == null) {
		fixed = false;
	}
	if(length == null) {
		length = 0;
	}
	if(array == null) {
		array = [];
	}
	this.__array = array;
	if(length > 0) {
		this.set_length(length);
	}
	this.fixed = fixed;
};
$hxClasses["openfl._Vector.FunctionVector"] = openfl__$Vector_FunctionVector;
openfl__$Vector_FunctionVector.__name__ = ["openfl","_Vector","FunctionVector"];
openfl__$Vector_FunctionVector.__interfaces__ = [openfl__$Vector_IVector];
openfl__$Vector_FunctionVector.prototype = {
	concat: function(a) {
		if(a == null) {
			return new openfl__$Vector_FunctionVector(0,false,this.__array.slice());
		} else {
			var other = a;
			if(other.__array.length > 0) {
				return new openfl__$Vector_FunctionVector(0,false,this.__array.concat(other.__array));
			} else {
				return new openfl__$Vector_FunctionVector(0,false,this.__array.slice());
			}
		}
	}
	,copy: function() {
		return new openfl__$Vector_FunctionVector(0,this.fixed,this.__array.slice());
	}
	,filter: function(callback) {
		return new openfl__$Vector_FunctionVector(0,this.fixed,this.__array.filter(callback));
	}
	,get: function(index) {
		if(index >= this.__array.length) {
			return null;
		} else {
			return this.__array[index];
		}
	}
	,indexOf: function(x,from) {
		if(from == null) {
			from = 0;
		}
		var _g1 = from;
		var _g = this.__array.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(Reflect.compareMethods(this.__array[i],x)) {
				return i;
			}
		}
		return -1;
	}
	,insertAt: function(index,element) {
		if(!this.fixed || index < this.__array.length) {
			this.__array.splice(index,0,element);
		}
	}
	,iterator: function() {
		return HxOverrides.iter(this.__array);
	}
	,join: function(sep) {
		if(sep == null) {
			sep = ",";
		}
		return this.__array.join(sep);
	}
	,lastIndexOf: function(x,from) {
		var i = from == null || from >= this.__array.length ? this.__array.length - 1 : from;
		while(i >= 0) {
			if(Reflect.compareMethods(this.__array[i],x)) {
				return i;
			}
			--i;
		}
		return -1;
	}
	,pop: function() {
		if(!this.fixed) {
			return this.__array.pop();
		} else {
			return null;
		}
	}
	,push: function(x) {
		if(!this.fixed) {
			return this.__array.push(x);
		} else {
			return this.__array.length;
		}
	}
	,removeAt: function(index) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array.splice(index,1)[0];
		}
		return null;
	}
	,reverse: function() {
		this.__array.reverse();
		return this;
	}
	,set: function(index,value) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array[index] = value;
		} else {
			return value;
		}
	}
	,shift: function() {
		if(!this.fixed) {
			return this.__array.shift();
		} else {
			return null;
		}
	}
	,slice: function(startIndex,endIndex) {
		if(startIndex == null) {
			startIndex = 0;
		}
		if(endIndex == null) {
			endIndex = 16777215;
		}
		return new openfl__$Vector_FunctionVector(0,false,this.__array.slice(startIndex,endIndex));
	}
	,sort: function(f) {
		this.__array.sort(f);
	}
	,splice: function(pos,len) {
		return new openfl__$Vector_FunctionVector(0,false,this.__array.splice(pos,len));
	}
	,toJSON: function() {
		return this.__array;
	}
	,toString: function() {
		if(this.__array != null) {
			return this.__array.toString();
		} else {
			return null;
		}
	}
	,unshift: function(x) {
		if(!this.fixed) {
			this.__array.unshift(x);
		}
	}
	,get_length: function() {
		return this.__array.length;
	}
	,set_length: function(value) {
		if(!this.fixed) {
			var currentLength = this.__array.length;
			if(value < 0) {
				value = 0;
			}
			if(value > currentLength) {
				var _g1 = currentLength;
				var _g = value;
				while(_g1 < _g) {
					var i = _g1++;
					this.__array[i] = null;
				}
			} else {
				while(this.__array.length > value) this.__array.pop();
			}
		}
		return this.__array.length;
	}
	,__class__: openfl__$Vector_FunctionVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl__$Vector_IntVector = function(length,fixed,array) {
	if(fixed == null) {
		fixed = false;
	}
	if(length == null) {
		length = 0;
	}
	if(array == null) {
		array = [];
	}
	this.__array = array;
	if(length > 0) {
		this.set_length(length);
	}
	this.fixed = fixed;
};
$hxClasses["openfl._Vector.IntVector"] = openfl__$Vector_IntVector;
openfl__$Vector_IntVector.__name__ = ["openfl","_Vector","IntVector"];
openfl__$Vector_IntVector.__interfaces__ = [openfl__$Vector_IVector];
openfl__$Vector_IntVector.prototype = {
	concat: function(a) {
		if(a == null) {
			return new openfl__$Vector_IntVector(0,false,this.__array.slice());
		} else {
			var other = a;
			if(other.__array.length > 0) {
				return new openfl__$Vector_IntVector(0,false,this.__array.concat(other.__array));
			} else {
				return new openfl__$Vector_IntVector(0,false,this.__array.slice());
			}
		}
	}
	,copy: function() {
		return new openfl__$Vector_IntVector(0,this.fixed,this.__array.slice());
	}
	,filter: function(callback) {
		return new openfl__$Vector_IntVector(0,this.fixed,this.__array.filter(callback));
	}
	,get: function(index) {
		return this.__array[index];
	}
	,indexOf: function(x,from) {
		if(from == null) {
			from = 0;
		}
		var _g1 = from;
		var _g = this.__array.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(this.__array[i] == x) {
				return i;
			}
		}
		return -1;
	}
	,insertAt: function(index,element) {
		if(!this.fixed || index < this.__array.length) {
			this.__array.splice(index,0,element);
		}
	}
	,iterator: function() {
		return HxOverrides.iter(this.__array);
	}
	,join: function(sep) {
		if(sep == null) {
			sep = ",";
		}
		return this.__array.join(sep);
	}
	,lastIndexOf: function(x,from) {
		var i = from == null || from >= this.__array.length ? this.__array.length - 1 : from;
		while(i >= 0) {
			if(this.__array[i] == x) {
				return i;
			}
			--i;
		}
		return -1;
	}
	,pop: function() {
		if(!this.fixed) {
			return this.__array.pop();
		} else {
			return null;
		}
	}
	,push: function(x) {
		if(!this.fixed) {
			return this.__array.push(x);
		} else {
			return this.__array.length;
		}
	}
	,removeAt: function(index) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array.splice(index,1)[0];
		}
		return 0;
	}
	,reverse: function() {
		this.__array.reverse();
		return this;
	}
	,set: function(index,value) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array[index] = value;
		} else {
			return value;
		}
	}
	,shift: function() {
		if(!this.fixed) {
			return this.__array.shift();
		} else {
			return null;
		}
	}
	,slice: function(startIndex,endIndex) {
		if(startIndex == null) {
			startIndex = 0;
		}
		if(endIndex == null) {
			endIndex = 16777215;
		}
		return new openfl__$Vector_IntVector(0,false,this.__array.slice(startIndex,endIndex));
	}
	,sort: function(f) {
		this.__array.sort(f);
	}
	,splice: function(pos,len) {
		return new openfl__$Vector_IntVector(0,false,this.__array.splice(pos,len));
	}
	,toJSON: function() {
		return this.__array;
	}
	,toString: function() {
		if(this.__array != null) {
			return this.__array.toString();
		} else {
			return null;
		}
	}
	,unshift: function(x) {
		if(!this.fixed) {
			this.__array.unshift(x);
		}
	}
	,get_length: function() {
		return this.__array.length;
	}
	,set_length: function(value) {
		if(!this.fixed) {
			var currentLength = this.__array.length;
			if(value < 0) {
				value = 0;
			}
			if(value > currentLength) {
				var _g1 = currentLength;
				var _g = value;
				while(_g1 < _g) {
					var i = _g1++;
					this.__array[i] = 0;
				}
			} else {
				while(this.__array.length > value) this.__array.pop();
			}
		}
		return this.__array.length;
	}
	,__class__: openfl__$Vector_IntVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl__$Vector_ObjectVector = function(length,fixed,array,forceCopy) {
	if(forceCopy == null) {
		forceCopy = false;
	}
	if(fixed == null) {
		fixed = false;
	}
	if(length == null) {
		length = 0;
	}
	if(forceCopy) {
		this.__array = [];
		if(array != null) {
			var _g1 = 0;
			var _g = array.length;
			while(_g1 < _g) {
				var i = _g1++;
				this.__array[i] = array[i];
			}
		}
	} else {
		if(array == null) {
			array = [];
		}
		this.__array = array;
	}
	if(length > 0) {
		this.set_length(length);
	}
	this.fixed = fixed;
};
$hxClasses["openfl._Vector.ObjectVector"] = openfl__$Vector_ObjectVector;
openfl__$Vector_ObjectVector.__name__ = ["openfl","_Vector","ObjectVector"];
openfl__$Vector_ObjectVector.__interfaces__ = [openfl__$Vector_IVector];
openfl__$Vector_ObjectVector.prototype = {
	concat: function(a) {
		if(a == null) {
			return new openfl__$Vector_ObjectVector(0,false,this.__array.slice());
		} else {
			var other = a;
			if(other.__array.length > 0) {
				return new openfl__$Vector_ObjectVector(0,false,this.__array.concat(other.__array));
			} else {
				return new openfl__$Vector_ObjectVector(0,false,this.__array.slice());
			}
		}
	}
	,copy: function() {
		return new openfl__$Vector_ObjectVector(0,this.fixed,this.__array.slice());
	}
	,filter: function(callback) {
		return new openfl__$Vector_ObjectVector(0,this.fixed,this.__array.filter(callback));
	}
	,get: function(index) {
		return this.__array[index];
	}
	,indexOf: function(x,from) {
		if(from == null) {
			from = 0;
		}
		var _g1 = from;
		var _g = this.__array.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(this.__array[i] == x) {
				return i;
			}
		}
		return -1;
	}
	,insertAt: function(index,element) {
		if(!this.fixed || index < this.__array.length) {
			this.__array.splice(index,0,element);
		}
	}
	,iterator: function() {
		return HxOverrides.iter(this.__array);
	}
	,join: function(sep) {
		if(sep == null) {
			sep = ",";
		}
		return this.__array.join(sep);
	}
	,lastIndexOf: function(x,from) {
		var i = from == null || from >= this.__array.length ? this.__array.length - 1 : from;
		while(i >= 0) {
			if(this.__array[i] == x) {
				return i;
			}
			--i;
		}
		return -1;
	}
	,pop: function() {
		if(!this.fixed) {
			return this.__array.pop();
		} else {
			return null;
		}
	}
	,push: function(x) {
		if(!this.fixed) {
			return this.__array.push(x);
		} else {
			return this.__array.length;
		}
	}
	,removeAt: function(index) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array.splice(index,1)[0];
		}
		return null;
	}
	,reverse: function() {
		this.__array.reverse();
		return this;
	}
	,set: function(index,value) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array[index] = value;
		} else {
			return value;
		}
	}
	,shift: function() {
		if(!this.fixed) {
			return this.__array.shift();
		} else {
			return null;
		}
	}
	,slice: function(startIndex,endIndex) {
		if(startIndex == null) {
			startIndex = 0;
		}
		if(endIndex == null) {
			endIndex = 16777215;
		}
		return new openfl__$Vector_ObjectVector(0,false,this.__array.slice(startIndex,endIndex));
	}
	,sort: function(f) {
		this.__array.sort(f);
	}
	,splice: function(pos,len) {
		return new openfl__$Vector_ObjectVector(0,false,this.__array.splice(pos,len));
	}
	,toJSON: function() {
		return this.__array;
	}
	,toString: function() {
		if(this.__array != null) {
			return this.__array.toString();
		} else {
			return null;
		}
	}
	,unshift: function(x) {
		if(!this.fixed) {
			this.__array.unshift(x);
		}
	}
	,get_length: function() {
		return this.__array.length;
	}
	,set_length: function(value) {
		if(!this.fixed) {
			var currentLength = this.__array.length;
			if(value < 0) {
				value = 0;
			}
			if(value > currentLength) {
				var _g1 = currentLength;
				var _g = value;
				while(_g1 < _g) {
					var i = _g1++;
					this.__array.push(null);
				}
			} else {
				while(this.__array.length > value) this.__array.pop();
			}
		}
		return this.__array.length;
	}
	,__class__: openfl__$Vector_ObjectVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl_display_Application = function() {
	lime_app_Application.call(this);
	if(openfl_utils__$internal_Lib.application == null) {
		openfl_utils__$internal_Lib.application = this;
	}
	if(openfl_utils__$internal_Lib.current == null) {
		openfl_utils__$internal_Lib.current = new openfl_display_MovieClip();
	}
	openfl_utils__$internal_Lib.current.__loaderInfo = openfl_display_LoaderInfo.create(null);
	openfl_utils__$internal_Lib.current.__loaderInfo.content = openfl_utils__$internal_Lib.current;
};
$hxClasses["openfl.display.Application"] = openfl_display_Application;
openfl_display_Application.__name__ = ["openfl","display","Application"];
openfl_display_Application.__super__ = lime_app_Application;
openfl_display_Application.prototype = $extend(lime_app_Application.prototype,{
	createWindow: function(attributes) {
		var $window = new openfl_display_Window(this,attributes);
		this.__windows.push($window);
		this.__windowByID.h[$window.id] = $window;
		var f = $bind(this,this.__onWindowClose);
		var a1 = $window;
		var tmp = function() {
			f(a1);
		};
		$window.onClose.add(tmp,false,-10000);
		if(this.__window == null) {
			this.__window = $window;
			$window.onActivate.add($bind(this,this.onWindowActivate));
			$window.onRenderContextLost.add($bind(this,this.onRenderContextLost));
			$window.onRenderContextRestored.add($bind(this,this.onRenderContextRestored));
			$window.onDeactivate.add($bind(this,this.onWindowDeactivate));
			$window.onDropFile.add($bind(this,this.onWindowDropFile));
			$window.onEnter.add($bind(this,this.onWindowEnter));
			$window.onExpose.add($bind(this,this.onWindowExpose));
			$window.onFocusIn.add($bind(this,this.onWindowFocusIn));
			$window.onFocusOut.add($bind(this,this.onWindowFocusOut));
			$window.onFullscreen.add($bind(this,this.onWindowFullscreen));
			$window.onKeyDown.add($bind(this,this.onKeyDown));
			$window.onKeyUp.add($bind(this,this.onKeyUp));
			$window.onLeave.add($bind(this,this.onWindowLeave));
			$window.onMinimize.add($bind(this,this.onWindowMinimize));
			$window.onMouseDown.add($bind(this,this.onMouseDown));
			$window.onMouseMove.add($bind(this,this.onMouseMove));
			$window.onMouseMoveRelative.add($bind(this,this.onMouseMoveRelative));
			$window.onMouseUp.add($bind(this,this.onMouseUp));
			$window.onMouseWheel.add($bind(this,this.onMouseWheel));
			$window.onMove.add($bind(this,this.onWindowMove));
			$window.onRender.add($bind(this,this.render));
			$window.onResize.add($bind(this,this.onWindowResize));
			$window.onRestore.add($bind(this,this.onWindowRestore));
			$window.onTextEdit.add($bind(this,this.onTextEdit));
			$window.onTextInput.add($bind(this,this.onTextInput));
			this.onWindowCreate();
		}
		this.onCreateWindow.dispatch($window);
		return $window;
	}
	,__class__: openfl_display_Application
});
var openfl_display_Bitmap = function(bitmapData,pixelSnapping,smoothing) {
	if(smoothing == null) {
		smoothing = false;
	}
	openfl_display_DisplayObject.call(this);
	this.__drawableType = 2;
	this.__bitmapData = bitmapData;
	this.pixelSnapping = pixelSnapping;
	this.smoothing = smoothing;
	if(pixelSnapping == null) {
		this.pixelSnapping = 1;
	}
};
$hxClasses["openfl.display.Bitmap"] = openfl_display_Bitmap;
openfl_display_Bitmap.__name__ = ["openfl","display","Bitmap"];
openfl_display_Bitmap.__super__ = openfl_display_DisplayObject;
openfl_display_Bitmap.prototype = $extend(openfl_display_DisplayObject.prototype,{
	__enterFrame: function(deltaTime) {
		if(this.__bitmapData != null && this.__bitmapData.image != null && this.__bitmapData.image.version != this.__imageVersion) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
	}
	,__getBounds: function(rect,matrix) {
		var bounds = openfl_geom_Rectangle.__pool.get();
		if(this.__bitmapData != null) {
			bounds.setTo(0,0,this.__bitmapData.width,this.__bitmapData.height);
		} else {
			bounds.setTo(0,0,0,0);
		}
		bounds.__transform(bounds,matrix);
		rect.__expand(bounds.x,bounds.y,bounds.width,bounds.height);
		openfl_geom_Rectangle.__pool.release(bounds);
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(!hitObject.get_visible() || this.__isMask || this.__bitmapData == null) {
			return false;
		}
		if(this.get_mask() != null && !this.get_mask().__hitTestMask(x,y)) {
			return false;
		}
		this.__getRenderTransform();
		var _this = this.__renderTransform;
		var norm = _this.a * _this.d - _this.b * _this.c;
		var px = norm == 0 ? -_this.tx : 1.0 / norm * (_this.c * (_this.ty - y) + _this.d * (x - _this.tx));
		var _this1 = this.__renderTransform;
		var norm1 = _this1.a * _this1.d - _this1.b * _this1.c;
		var py = norm1 == 0 ? -_this1.ty : 1.0 / norm1 * (_this1.a * (y - _this1.ty) + _this1.b * (_this1.tx - x));
		if(px > 0 && py > 0 && px <= this.__bitmapData.width && py <= this.__bitmapData.height) {
			if(this.__scrollRect != null && !this.__scrollRect.contains(px,py)) {
				return false;
			}
			if(stack != null && !interactiveOnly) {
				stack.push(hitObject);
			}
			return true;
		}
		return false;
	}
	,__hitTestMask: function(x,y) {
		if(this.__bitmapData == null) {
			return false;
		}
		this.__getRenderTransform();
		var _this = this.__renderTransform;
		var norm = _this.a * _this.d - _this.b * _this.c;
		var px = norm == 0 ? -_this.tx : 1.0 / norm * (_this.c * (_this.ty - y) + _this.d * (x - _this.tx));
		var _this1 = this.__renderTransform;
		var norm1 = _this1.a * _this1.d - _this1.b * _this1.c;
		var py = norm1 == 0 ? -_this1.ty : 1.0 / norm1 * (_this1.a * (y - _this1.ty) + _this1.b * (_this1.tx - x));
		if(px > 0 && py > 0 && px <= this.__bitmapData.width && py <= this.__bitmapData.height) {
			return true;
		}
		return false;
	}
	,get_bitmapData: function() {
		return this.__bitmapData;
	}
	,set_bitmapData: function(value) {
		this.__bitmapData = value;
		this.smoothing = false;
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
		var tmp = this.__filters != null;
		this.__imageVersion = -1;
		return this.__bitmapData;
	}
	,set_height: function(value) {
		if(this.__bitmapData != null) {
			this.set_scaleY(value / this.__bitmapData.height);
		} else {
			this.set_scaleY(0);
		}
		return value;
	}
	,set_width: function(value) {
		if(this.__bitmapData != null) {
			this.set_scaleX(value / this.__bitmapData.width);
		} else {
			this.set_scaleX(0);
		}
		return value;
	}
	,__class__: openfl_display_Bitmap
	,__properties__: $extend(openfl_display_DisplayObject.prototype.__properties__,{set_bitmapData:"set_bitmapData",get_bitmapData:"get_bitmapData"})
});
var openfl_display_BitmapData = function(width,height,transparent,fillColor) {
	if(fillColor == null) {
		fillColor = -1;
	}
	if(transparent == null) {
		transparent = true;
	}
	this.__drawableType = 0;
	this.transparent = transparent;
	if(width == null) {
		width = 0;
	} else {
		width = width;
	}
	if(height == null) {
		height = 0;
	} else {
		height = height;
	}
	if(width < 0) {
		width = 0;
	} else {
		width = width;
	}
	if(height < 0) {
		height = 0;
	} else {
		height = height;
	}
	this.width = width;
	this.height = height;
	this.rect = new openfl_geom_Rectangle(0,0,width,height);
	this.__textureWidth = width;
	this.__textureHeight = height;
	if(width > 0 && height > 0) {
		if(transparent) {
			if((fillColor & -16777216) == 0) {
				fillColor = 0;
			}
		} else {
			fillColor = -16777216 | fillColor & 16777215;
		}
		fillColor = fillColor << 8 | fillColor >>> 24 & 255;
		this.image = new lime_graphics_Image(null,0,0,width,height,fillColor);
		this.image.set_transparent(transparent);
		this.__isValid = true;
		this.readable = true;
	}
	this.__renderTransform = new openfl_geom_Matrix();
	this.__worldAlpha = 1;
	this.__worldTransform = new openfl_geom_Matrix();
	this.__worldColorTransform = new openfl_geom_ColorTransform();
	this.__renderable = true;
};
$hxClasses["openfl.display.BitmapData"] = openfl_display_BitmapData;
openfl_display_BitmapData.__name__ = ["openfl","display","BitmapData"];
openfl_display_BitmapData.__interfaces__ = [openfl_display_IBitmapDrawable];
openfl_display_BitmapData.fromBase64 = function(base64,type) {
	return null;
};
openfl_display_BitmapData.fromBytes = function(bytes,rawAlpha) {
	return null;
};
openfl_display_BitmapData.fromCanvas = function(canvas,transparent) {
	if(transparent == null) {
		transparent = true;
	}
	if(canvas == null) {
		return null;
	}
	var bitmapData = new openfl_display_BitmapData(0,0,transparent,0);
	bitmapData.__fromImage(lime_graphics_Image.fromCanvas(canvas));
	bitmapData.image.set_transparent(transparent);
	return bitmapData;
};
openfl_display_BitmapData.fromFile = function(path) {
	return null;
};
openfl_display_BitmapData.fromImage = function(image,transparent) {
	if(transparent == null) {
		transparent = true;
	}
	if(image == null || image.buffer == null) {
		return null;
	}
	var bitmapData = new openfl_display_BitmapData(0,0,transparent,0);
	bitmapData.__fromImage(image);
	bitmapData.image.set_transparent(transparent);
	if(bitmapData.image != null) {
		return bitmapData;
	} else {
		return null;
	}
};
openfl_display_BitmapData.fromTexture = function(texture) {
	if(texture == null) {
		return null;
	}
	var bitmapData = new openfl_display_BitmapData(texture.__width,texture.__height,true,0);
	bitmapData.readable = false;
	bitmapData.__texture = texture;
	bitmapData.__textureContext = texture.__textureContext;
	bitmapData.image = null;
	return bitmapData;
};
openfl_display_BitmapData.loadFromBase64 = function(base64,type) {
	return lime_graphics_Image.loadFromBase64(base64,type).then(function(image) {
		return lime_app_Future.withValue(openfl_display_BitmapData.fromImage(image));
	});
};
openfl_display_BitmapData.loadFromBytes = function(bytes,rawAlpha) {
	return lime_graphics_Image.loadFromBytes(openfl_utils__$ByteArray_ByteArray_$Impl_$.toBytes(bytes)).then(function(image) {
		var bitmapData = openfl_display_BitmapData.fromImage(image);
		if(rawAlpha != null) {
			bitmapData.__applyAlpha(rawAlpha);
		}
		return lime_app_Future.withValue(bitmapData);
	});
};
openfl_display_BitmapData.loadFromFile = function(path) {
	return lime_graphics_Image.loadFromFile(path).then(function(image) {
		return lime_app_Future.withValue(openfl_display_BitmapData.fromImage(image));
	});
};
openfl_display_BitmapData.prototype = {
	applyFilter: function(sourceBitmapData,sourceRect,destPoint,filter) {
		if(!this.readable || sourceBitmapData == null || !sourceBitmapData.readable) {
			return;
		}
		var needSecondBitmapData = filter.__needSecondBitmapData;
		var needCopyOfOriginal = filter.__preserveObject;
		var bitmapData2 = null;
		var bitmapData3 = null;
		if(needSecondBitmapData) {
			bitmapData2 = new openfl_display_BitmapData(this.width,this.height,true,0);
		} else {
			bitmapData2 = this;
		}
		if(needCopyOfOriginal) {
			bitmapData3 = new openfl_display_BitmapData(this.width,this.height,true,0);
		}
		if(filter.__preserveObject) {
			bitmapData3.copyPixels(this,this.rect,destPoint);
		}
		var lastBitmap = filter.__applyFilter(bitmapData2,this,sourceRect,destPoint);
		if(filter.__preserveObject) {
			lastBitmap.draw(bitmapData3,null,null);
		}
		if(needSecondBitmapData && lastBitmap == bitmapData2) {
			bitmapData2.image.version = this.image.version;
			this.image = bitmapData2.image;
		}
		this.image.dirty = true;
		this.image.version++;
	}
	,clone: function() {
		var bitmapData;
		if(!this.__isValid) {
			bitmapData = new openfl_display_BitmapData(this.width,this.height,this.transparent,0);
		} else if(!this.readable && this.image == null) {
			bitmapData = new openfl_display_BitmapData(0,0,this.transparent,0);
			bitmapData.width = this.width;
			bitmapData.height = this.height;
			bitmapData.__textureWidth = this.__textureWidth;
			bitmapData.__textureHeight = this.__textureHeight;
			bitmapData.rect.copyFrom(this.rect);
			bitmapData.__framebuffer = this.__framebuffer;
			bitmapData.__framebufferContext = this.__framebufferContext;
			bitmapData.__texture = this.__texture;
			bitmapData.__textureContext = this.__textureContext;
			bitmapData.__isValid = true;
		} else {
			bitmapData = openfl_display_BitmapData.fromImage(this.image.clone(),this.transparent);
		}
		bitmapData.__worldTransform.copyFrom(this.__worldTransform);
		bitmapData.__renderTransform.copyFrom(this.__renderTransform);
		return bitmapData;
	}
	,colorTransform: function(rect,colorTransform) {
		if(!this.readable) {
			return;
		}
		this.image.colorTransform(rect.__toLimeRectangle(),colorTransform.__toLimeColorMatrix());
	}
	,compare: function(otherBitmapData) {
		if(otherBitmapData == this) {
			return 0;
		} else if(otherBitmapData == null) {
			return -1;
		} else if(this.readable == false || otherBitmapData.readable == false) {
			return -2;
		} else if(this.width != otherBitmapData.width) {
			return -3;
		} else if(this.height != otherBitmapData.height) {
			return -4;
		}
		if(this.image != null && otherBitmapData.image != null && this.image.get_format() == otherBitmapData.image.get_format()) {
			var bytes = this.image.get_data();
			var otherBytes = otherBitmapData.image.get_data();
			var equal = true;
			var _g1 = 0;
			var _g = bytes.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(bytes[i] != otherBytes[i]) {
					equal = false;
					break;
				}
			}
			if(equal) {
				return 0;
			}
		}
		var bitmapData = null;
		var foundDifference;
		var pixel;
		var otherPixel;
		var comparePixel;
		var r;
		var g;
		var b;
		var a;
		var _g11 = 0;
		var _g2 = this.height;
		while(_g11 < _g2) {
			var y = _g11++;
			var _g3 = 0;
			var _g21 = this.width;
			while(_g3 < _g21) {
				var x = _g3++;
				foundDifference = false;
				pixel = this.getPixel32(x,y);
				otherPixel = otherBitmapData.getPixel32(x,y);
				comparePixel = 0;
				if(pixel != otherPixel) {
					r = (pixel >>> 16 & 255) - (otherPixel >>> 16 & 255);
					g = (pixel >>> 8 & 255) - (otherPixel >>> 8 & 255);
					b = (pixel & 255) - (otherPixel & 255);
					if(r < 0) {
						r *= -1;
					}
					if(g < 0) {
						g *= -1;
					}
					if(b < 0) {
						b *= -1;
					}
					if(r == 0 && g == 0 && b == 0) {
						a = (pixel >>> 24 & 255) - (otherPixel >>> 24 & 255);
						if(a != 0) {
							comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | 16711680 | (comparePixel >>> 8 & 255 & 255) << 8 | comparePixel & 255 & 255;
							comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | (comparePixel >>> 16 & 255 & 255) << 16 | 65280 | comparePixel & 255 & 255;
							comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | (comparePixel >>> 16 & 255 & 255) << 16 | (comparePixel >>> 8 & 255 & 255) << 8 | 255;
							comparePixel = (a & 255) << 24 | (comparePixel >>> 16 & 255 & 255) << 16 | (comparePixel >>> 8 & 255 & 255) << 8 | comparePixel & 255 & 255;
							foundDifference = true;
						}
					} else {
						comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | (r & 255) << 16 | (comparePixel >>> 8 & 255 & 255) << 8 | comparePixel & 255 & 255;
						comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | (comparePixel >>> 16 & 255 & 255) << 16 | (g & 255) << 8 | comparePixel & 255 & 255;
						comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | (comparePixel >>> 16 & 255 & 255) << 16 | (comparePixel >>> 8 & 255 & 255) << 8 | b & 255;
						comparePixel = -16777216 | (comparePixel >>> 16 & 255 & 255) << 16 | (comparePixel >>> 8 & 255 & 255) << 8 | comparePixel & 255 & 255;
						foundDifference = true;
					}
				}
				if(foundDifference) {
					if(bitmapData == null) {
						bitmapData = new openfl_display_BitmapData(this.width,this.height,this.transparent || otherBitmapData.transparent,0);
					}
					bitmapData.setPixel32(x,y,comparePixel);
				}
			}
		}
		if(bitmapData == null) {
			return 0;
		}
		return bitmapData;
	}
	,copyChannel: function(sourceBitmapData,sourceRect,destPoint,sourceChannel,destChannel) {
		if(!this.readable) {
			return;
		}
		var sourceChannel1;
		switch(sourceChannel) {
		case 1:
			sourceChannel1 = lime_graphics_ImageChannel.RED;
			break;
		case 2:
			sourceChannel1 = lime_graphics_ImageChannel.GREEN;
			break;
		case 4:
			sourceChannel1 = lime_graphics_ImageChannel.BLUE;
			break;
		case 8:
			sourceChannel1 = lime_graphics_ImageChannel.ALPHA;
			break;
		default:
			return;
		}
		var destChannel1;
		switch(destChannel) {
		case 1:
			destChannel1 = lime_graphics_ImageChannel.RED;
			break;
		case 2:
			destChannel1 = lime_graphics_ImageChannel.GREEN;
			break;
		case 4:
			destChannel1 = lime_graphics_ImageChannel.BLUE;
			break;
		case 8:
			destChannel1 = lime_graphics_ImageChannel.ALPHA;
			break;
		default:
			return;
		}
		this.image.copyChannel(sourceBitmapData.image,sourceRect.__toLimeRectangle(),destPoint.__toLimeVector2(),sourceChannel1,destChannel1);
	}
	,copyPixels: function(sourceBitmapData,sourceRect,destPoint,alphaBitmapData,alphaPoint,mergeAlpha) {
		if(mergeAlpha == null) {
			mergeAlpha = false;
		}
		if(!this.readable || sourceBitmapData == null) {
			return;
		}
		if(alphaPoint != null) {
			openfl_display_BitmapData.__tempVector.x = alphaPoint.x;
			openfl_display_BitmapData.__tempVector.y = alphaPoint.y;
		}
		this.image.copyPixels(sourceBitmapData.image,sourceRect.__toLimeRectangle(),destPoint.__toLimeVector2(),alphaBitmapData != null ? alphaBitmapData.image : null,alphaPoint != null ? openfl_display_BitmapData.__tempVector : null,mergeAlpha);
	}
	,dispose: function() {
		this.image = null;
		this.width = 0;
		this.height = 0;
		this.rect = null;
		this.__isValid = false;
		this.readable = false;
		this.__surface = null;
		this.__vertexBuffer = null;
		this.__framebuffer = null;
		this.__framebufferContext = null;
		this.__texture = null;
		this.__textureContext = null;
	}
	,disposeImage: function() {
		this.readable = false;
	}
	,draw: function(source,matrix,colorTransform,blendMode,clipRect,smoothing) {
		if(smoothing == null) {
			smoothing = false;
		}
		if(source == null) {
			return;
		}
		source.__update(false,true);
		var transform = openfl_geom_Matrix.__pool.get();
		transform.copyFrom(source.__renderTransform);
		transform.invert();
		if(matrix != null) {
			transform.concat(matrix);
		}
		var clipMatrix = null;
		if(clipRect != null) {
			clipMatrix = openfl_geom_Matrix.__pool.get();
			clipMatrix.copyFrom(transform);
			clipMatrix.invert();
		}
		var _colorTransform = new openfl_geom_ColorTransform();
		_colorTransform.__copyFrom(source.__worldColorTransform);
		_colorTransform.__invert();
		if(!this.readable && openfl_Lib.get_current().stage.context3D != null) {
			if(this.__textureContext == null) {
				this.__textureContext = lime_app_Application.current.__window.context;
			}
			if(colorTransform != null) {
				_colorTransform.__combine(colorTransform);
			}
			var renderer = new openfl_display_OpenGLRenderer(openfl_Lib.get_current().stage.context3D,this);
			renderer.__allowSmoothing = smoothing;
			renderer.__overrideBlendMode = blendMode;
			renderer.__worldTransform = transform;
			renderer.__worldAlpha = 1 / source.__worldAlpha;
			renderer.__worldColorTransform = _colorTransform;
			renderer.__resize(this.width,this.height);
			if(clipRect != null) {
				renderer.__pushMaskRect(clipRect,clipMatrix);
			}
			this.__drawGL(source,renderer);
			if(clipRect != null) {
				renderer.__popMaskRect();
				openfl_geom_Matrix.__pool.release(clipMatrix);
			}
		} else {
			if(colorTransform != null) {
				var bounds = openfl_geom_Rectangle.__pool.get();
				var boundsMatrix = openfl_geom_Matrix.__pool.get();
				source.__getBounds(bounds,boundsMatrix);
				var width = Math.ceil(bounds.width);
				var height = Math.ceil(bounds.height);
				boundsMatrix.tx = -bounds.x;
				boundsMatrix.ty = -bounds.y;
				var copy = new openfl_display_BitmapData(width,height,true,0);
				copy.draw(source,boundsMatrix);
				copy.colorTransform(copy.rect,colorTransform);
				copy.__renderTransform.identity();
				copy.__renderTransform.tx = bounds.x;
				copy.__renderTransform.ty = bounds.y;
				copy.__renderTransform.concat(source.__renderTransform);
				copy.__worldAlpha = source.__worldAlpha;
				copy.__worldColorTransform.__copyFrom(source.__worldColorTransform);
				source = copy;
				openfl_geom_Rectangle.__pool.release(bounds);
				openfl_geom_Matrix.__pool.release(boundsMatrix);
			}
			lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this.image);
			var renderer1 = new openfl_display_CanvasRenderer(this.image.buffer.__srcContext);
			renderer1.__allowSmoothing = smoothing;
			renderer1.__overrideBlendMode = blendMode;
			renderer1.__worldTransform = transform;
			renderer1.__worldAlpha = 1 / source.__worldAlpha;
			renderer1.__worldColorTransform = _colorTransform;
			if(clipRect != null) {
				renderer1.__pushMaskRect(clipRect,clipMatrix);
			}
			this.__drawCanvas(source,renderer1);
			if(clipRect != null) {
				renderer1.__popMaskRect();
				openfl_geom_Matrix.__pool.release(clipMatrix);
			}
		}
		openfl_geom_Matrix.__pool.release(transform);
	}
	,drawWithQuality: function(source,matrix,colorTransform,blendMode,clipRect,smoothing,quality) {
		if(smoothing == null) {
			smoothing = false;
		}
		this.draw(source,matrix,colorTransform,blendMode,clipRect,quality != 2 && smoothing);
	}
	,encode: function(rect,compressor,byteArray) {
		if(!this.readable || rect == null) {
			byteArray = null;
			return byteArray;
		}
		if(byteArray == null) {
			var this1 = new openfl_utils_ByteArrayData(0);
			byteArray = this1;
		}
		var image = this.image;
		if(!rect.equals(this.rect)) {
			var matrix = openfl_geom_Matrix.__pool.get();
			matrix.tx = Math.round(-rect.x);
			matrix.ty = Math.round(-rect.y);
			var bitmapData = new openfl_display_BitmapData(Math.ceil(rect.width),Math.ceil(rect.height),true,0);
			bitmapData.draw(this,matrix);
			image = bitmapData.image;
			openfl_geom_Matrix.__pool.release(matrix);
		}
		if(js_Boot.__instanceof(compressor,openfl_display_PNGEncoderOptions)) {
			byteArray.writeBytes(openfl_utils__$ByteArray_ByteArray_$Impl_$.fromBytes(image.encode(lime_graphics_ImageFileFormat.PNG)),0,0);
			return byteArray;
		} else if(js_Boot.__instanceof(compressor,openfl_display_JPEGEncoderOptions)) {
			byteArray.writeBytes(openfl_utils__$ByteArray_ByteArray_$Impl_$.fromBytes(image.encode(lime_graphics_ImageFileFormat.JPEG,(js_Boot.__cast(compressor , openfl_display_JPEGEncoderOptions)).quality)),0,0);
			return byteArray;
		}
		byteArray = null;
		return byteArray;
	}
	,fillRect: function(rect,color) {
		this.__fillRect(rect,color,true);
	}
	,floodFill: function(x,y,color) {
		if(!this.readable) {
			return;
		}
		this.image.floodFill(x,y,color,1);
	}
	,generateFilterRect: function(sourceRect,filter) {
		return sourceRect.clone();
	}
	,getIndexBuffer: function(context,scale9Grid) {
		var gl = context.gl;
		if(this.__indexBuffer == null || this.__indexBufferContext != context.__context || scale9Grid != null && this.__indexBufferGrid == null || this.__indexBufferGrid != null && !this.__indexBufferGrid.equals(scale9Grid)) {
			this.__indexBufferContext = context.__context;
			this.__indexBuffer = null;
			if(scale9Grid != null) {
				if(this.__indexBufferGrid == null) {
					this.__indexBufferGrid = new openfl_geom_Rectangle();
				}
				this.__indexBufferGrid.copyFrom(scale9Grid);
				var centerX = scale9Grid.width;
				var centerY = scale9Grid.height;
				if(centerX != 0 && centerY != 0) {
					var this1 = new Uint16Array(54);
					this.__indexBufferData = this1;
					this.__indexBufferData[0] = 0;
					this.__indexBufferData[1] = 1;
					this.__indexBufferData[2] = 2;
					this.__indexBufferData[3] = 2;
					this.__indexBufferData[4] = 1;
					this.__indexBufferData[5] = 3;
					this.__indexBufferData[6] = 4;
					this.__indexBufferData[7] = 0;
					this.__indexBufferData[8] = 5;
					this.__indexBufferData[9] = 5;
					this.__indexBufferData[10] = 0;
					this.__indexBufferData[11] = 2;
					this.__indexBufferData[12] = 6;
					this.__indexBufferData[13] = 4;
					this.__indexBufferData[14] = 7;
					this.__indexBufferData[15] = 7;
					this.__indexBufferData[16] = 4;
					this.__indexBufferData[17] = 5;
					this.__indexBufferData[18] = 8;
					this.__indexBufferData[19] = 9;
					this.__indexBufferData[20] = 0;
					this.__indexBufferData[21] = 0;
					this.__indexBufferData[22] = 9;
					this.__indexBufferData[23] = 1;
					this.__indexBufferData[24] = 10;
					this.__indexBufferData[25] = 8;
					this.__indexBufferData[26] = 4;
					this.__indexBufferData[27] = 4;
					this.__indexBufferData[28] = 8;
					this.__indexBufferData[29] = 0;
					this.__indexBufferData[30] = 11;
					this.__indexBufferData[31] = 10;
					this.__indexBufferData[32] = 6;
					this.__indexBufferData[33] = 6;
					this.__indexBufferData[34] = 10;
					this.__indexBufferData[35] = 4;
					this.__indexBufferData[36] = 12;
					this.__indexBufferData[37] = 13;
					this.__indexBufferData[38] = 8;
					this.__indexBufferData[39] = 8;
					this.__indexBufferData[40] = 13;
					this.__indexBufferData[41] = 9;
					this.__indexBufferData[42] = 14;
					this.__indexBufferData[43] = 12;
					this.__indexBufferData[44] = 10;
					this.__indexBufferData[45] = 10;
					this.__indexBufferData[46] = 12;
					this.__indexBufferData[47] = 8;
					this.__indexBufferData[48] = 15;
					this.__indexBufferData[49] = 14;
					this.__indexBufferData[50] = 11;
					this.__indexBufferData[51] = 11;
					this.__indexBufferData[52] = 14;
					this.__indexBufferData[53] = 10;
					this.__indexBuffer = context.createIndexBuffer(54);
				} else if(centerX == 0 && centerY != 0) {
					var this2 = new Uint16Array(18);
					this.__indexBufferData = this2;
					this.__indexBufferData[0] = 0;
					this.__indexBufferData[1] = 1;
					this.__indexBufferData[2] = 2;
					this.__indexBufferData[3] = 2;
					this.__indexBufferData[4] = 1;
					this.__indexBufferData[5] = 3;
					this.__indexBufferData[6] = 4;
					this.__indexBufferData[7] = 5;
					this.__indexBufferData[8] = 0;
					this.__indexBufferData[9] = 0;
					this.__indexBufferData[10] = 5;
					this.__indexBufferData[11] = 1;
					this.__indexBufferData[12] = 6;
					this.__indexBufferData[13] = 7;
					this.__indexBufferData[14] = 4;
					this.__indexBufferData[15] = 4;
					this.__indexBufferData[16] = 7;
					this.__indexBufferData[17] = 5;
					this.__indexBuffer = context.createIndexBuffer(18);
				} else if(centerX != 0 && centerY == 0) {
					var this3 = new Uint16Array(18);
					this.__indexBufferData = this3;
					this.__indexBufferData[0] = 0;
					this.__indexBufferData[1] = 1;
					this.__indexBufferData[2] = 2;
					this.__indexBufferData[3] = 2;
					this.__indexBufferData[4] = 1;
					this.__indexBufferData[5] = 3;
					this.__indexBufferData[6] = 4;
					this.__indexBufferData[7] = 0;
					this.__indexBufferData[8] = 5;
					this.__indexBufferData[9] = 5;
					this.__indexBufferData[10] = 0;
					this.__indexBufferData[11] = 2;
					this.__indexBufferData[12] = 6;
					this.__indexBufferData[13] = 4;
					this.__indexBufferData[14] = 7;
					this.__indexBufferData[15] = 7;
					this.__indexBufferData[16] = 4;
					this.__indexBufferData[17] = 5;
					this.__indexBuffer = context.createIndexBuffer(18);
				}
			} else {
				this.__indexBufferGrid = null;
			}
			if(this.__indexBuffer == null) {
				var this4 = new Uint16Array(6);
				this.__indexBufferData = this4;
				this.__indexBufferData[0] = 0;
				this.__indexBufferData[1] = 1;
				this.__indexBufferData[2] = 2;
				this.__indexBufferData[3] = 2;
				this.__indexBufferData[4] = 1;
				this.__indexBufferData[5] = 3;
				this.__indexBuffer = context.createIndexBuffer(6);
			}
			this.__indexBuffer.uploadFromTypedArray(this.__indexBufferData);
		}
		return this.__indexBuffer;
	}
	,getVertexBuffer: function(context,scale9Grid,targetObject) {
		var gl = context.gl;
		if(this.__vertexBuffer == null || this.__vertexBufferContext != context.__context || scale9Grid != null && this.__vertexBufferGrid == null || this.__vertexBufferGrid != null && !this.__vertexBufferGrid.equals(scale9Grid) || targetObject != null && (this.__vertexBufferWidth != targetObject.get_width() || this.__vertexBufferHeight != targetObject.get_height() || this.__vertexBufferScaleX != targetObject.get_scaleX() || this.__vertexBufferScaleY != targetObject.get_scaleY())) {
			this.__uvRect = new openfl_geom_Rectangle(0,0,this.width,this.height);
			var uvWidth = 1;
			var uvHeight = 1;
			this.__vertexBufferContext = context.__context;
			this.__vertexBuffer = null;
			if(targetObject != null) {
				this.__vertexBufferWidth = targetObject.get_width();
				this.__vertexBufferHeight = targetObject.get_height();
				this.__vertexBufferScaleX = targetObject.get_scaleX();
				this.__vertexBufferScaleY = targetObject.get_scaleY();
			}
			if(scale9Grid != null && targetObject != null) {
				if(this.__vertexBufferGrid == null) {
					this.__vertexBufferGrid = new openfl_geom_Rectangle();
				}
				this.__vertexBufferGrid.copyFrom(scale9Grid);
				this.__vertexBufferWidth = targetObject.get_width();
				this.__vertexBufferHeight = targetObject.get_height();
				this.__vertexBufferScaleX = targetObject.get_scaleX();
				this.__vertexBufferScaleY = targetObject.get_scaleY();
				var centerX = scale9Grid.width;
				var centerY = scale9Grid.height;
				if(centerX != 0 && centerY != 0) {
					var this1 = new Float32Array(224);
					this.__vertexBufferData = this1;
					var left = scale9Grid.x;
					var top = scale9Grid.y;
					var right = this.width - centerX - left;
					var bottom = this.height - centerY - top;
					var uvLeft = left / this.width;
					var uvTop = top / this.height;
					var uvCenterX = centerX / this.width;
					var uvCenterY = centerY / this.height;
					var uvRight = right / this.width;
					var uvBottom = bottom / this.height;
					var renderedLeft = left / targetObject.get_scaleX();
					var renderedTop = top / targetObject.get_scaleY();
					var renderedRight = right / targetObject.get_scaleX();
					var renderedBottom = bottom / targetObject.get_scaleY();
					var renderedCenterX = targetObject.get_width() / targetObject.get_scaleX() - renderedLeft - renderedRight;
					var renderedCenterY = targetObject.get_height() / targetObject.get_scaleY() - renderedTop - renderedBottom;
					this.__vertexBufferData[0] = renderedLeft;
					this.__vertexBufferData[1] = renderedTop;
					this.__vertexBufferData[3] = uvWidth * uvLeft;
					this.__vertexBufferData[4] = uvHeight * uvTop;
					this.__vertexBufferData[15] = renderedTop;
					this.__vertexBufferData[18] = uvHeight * uvTop;
					this.__vertexBufferData[28] = renderedLeft;
					this.__vertexBufferData[31] = uvWidth * uvLeft;
					this.__vertexBufferData[56] = renderedLeft + renderedCenterX;
					this.__vertexBufferData[57] = renderedTop;
					this.__vertexBufferData[59] = uvWidth * (uvLeft + uvCenterX);
					this.__vertexBufferData[60] = uvHeight * uvTop;
					this.__vertexBufferData[70] = renderedLeft + renderedCenterX;
					this.__vertexBufferData[73] = uvWidth * (uvLeft + uvCenterX);
					this.__vertexBufferData[84] = this.width;
					this.__vertexBufferData[85] = renderedTop;
					this.__vertexBufferData[87] = uvWidth;
					this.__vertexBufferData[88] = uvHeight * uvTop;
					this.__vertexBufferData[98] = this.width;
					this.__vertexBufferData[101] = uvWidth;
					this.__vertexBufferData[112] = renderedLeft;
					this.__vertexBufferData[113] = renderedTop + renderedCenterY;
					this.__vertexBufferData[115] = uvWidth * uvLeft;
					this.__vertexBufferData[116] = uvHeight * (uvTop + uvCenterY);
					this.__vertexBufferData[127] = renderedTop + renderedCenterY;
					this.__vertexBufferData[130] = uvHeight * (uvTop + uvCenterY);
					this.__vertexBufferData[140] = renderedLeft + renderedCenterX;
					this.__vertexBufferData[141] = renderedTop + renderedCenterY;
					this.__vertexBufferData[143] = uvWidth * (uvLeft + uvCenterX);
					this.__vertexBufferData[144] = uvHeight * (uvTop + uvCenterY);
					this.__vertexBufferData[154] = this.width;
					this.__vertexBufferData[155] = renderedTop + renderedCenterY;
					this.__vertexBufferData[157] = uvWidth;
					this.__vertexBufferData[158] = uvHeight * (uvTop + uvCenterY);
					this.__vertexBufferData[168] = renderedLeft;
					this.__vertexBufferData[169] = this.height;
					this.__vertexBufferData[171] = uvWidth * uvLeft;
					this.__vertexBufferData[172] = uvHeight;
					this.__vertexBufferData[183] = this.height;
					this.__vertexBufferData[186] = uvHeight;
					this.__vertexBufferData[196] = renderedLeft + renderedCenterX;
					this.__vertexBufferData[197] = this.height;
					this.__vertexBufferData[199] = uvWidth * (uvLeft + uvCenterX);
					this.__vertexBufferData[200] = uvHeight;
					this.__vertexBufferData[210] = this.width;
					this.__vertexBufferData[211] = this.height;
					this.__vertexBufferData[213] = uvWidth;
					this.__vertexBufferData[214] = uvHeight;
					this.__vertexBuffer = context.createVertexBuffer(16,14);
				} else if(centerX == 0 && centerY != 0) {
					var this2 = new Float32Array(112);
					this.__vertexBufferData = this2;
					var top1 = scale9Grid.y;
					var bottom1 = this.height - centerY - top1;
					var uvTop1 = top1 / this.height;
					var uvCenterY1 = centerY / this.height;
					var uvBottom1 = bottom1 / this.height;
					var renderedTop1 = top1 / targetObject.get_scaleY();
					var renderedBottom1 = bottom1 / targetObject.get_scaleY();
					var renderedCenterY1 = targetObject.get_height() / targetObject.get_scaleY() - renderedTop1 - renderedBottom1;
					var renderedWidth = targetObject.get_width() / targetObject.get_scaleX();
					this.__vertexBufferData[0] = renderedWidth;
					this.__vertexBufferData[1] = renderedTop1;
					this.__vertexBufferData[3] = uvWidth;
					this.__vertexBufferData[4] = uvHeight * uvTop1;
					this.__vertexBufferData[15] = renderedTop1;
					this.__vertexBufferData[18] = uvHeight * uvTop1;
					this.__vertexBufferData[28] = renderedWidth;
					this.__vertexBufferData[31] = uvWidth;
					this.__vertexBufferData[56] = renderedWidth;
					this.__vertexBufferData[57] = renderedTop1 + renderedCenterY1;
					this.__vertexBufferData[59] = uvWidth;
					this.__vertexBufferData[60] = uvHeight * (uvTop1 + uvCenterY1);
					this.__vertexBufferData[71] = renderedTop1 + renderedCenterY1;
					this.__vertexBufferData[74] = uvHeight * (uvTop1 + uvCenterY1);
					this.__vertexBufferData[84] = renderedWidth;
					this.__vertexBufferData[85] = this.height;
					this.__vertexBufferData[87] = uvWidth;
					this.__vertexBufferData[88] = uvHeight;
					this.__vertexBufferData[99] = this.height;
					this.__vertexBufferData[102] = uvHeight;
					this.__vertexBuffer = context.createVertexBuffer(8,14);
				} else if(centerY == 0 && centerX != 0) {
					var this3 = new Float32Array(112);
					this.__vertexBufferData = this3;
					var left1 = scale9Grid.x;
					var right1 = this.width - centerX - left1;
					var uvLeft1 = left1 / this.width;
					var uvCenterX1 = centerX / this.width;
					var uvRight1 = right1 / this.width;
					var renderedLeft1 = left1 / targetObject.get_scaleX();
					var renderedRight1 = right1 / targetObject.get_scaleX();
					var renderedCenterX1 = targetObject.get_width() / targetObject.get_scaleX() - renderedLeft1 - renderedRight1;
					var renderedHeight = targetObject.get_height() / targetObject.get_scaleY();
					this.__vertexBufferData[0] = renderedLeft1;
					this.__vertexBufferData[1] = renderedHeight;
					this.__vertexBufferData[3] = uvWidth * uvLeft1;
					this.__vertexBufferData[4] = uvHeight;
					this.__vertexBufferData[15] = renderedHeight;
					this.__vertexBufferData[18] = uvHeight;
					this.__vertexBufferData[28] = renderedLeft1;
					this.__vertexBufferData[31] = uvWidth * uvLeft1;
					this.__vertexBufferData[56] = renderedLeft1 + renderedCenterX1;
					this.__vertexBufferData[57] = renderedHeight;
					this.__vertexBufferData[59] = uvWidth * (uvLeft1 + uvCenterX1);
					this.__vertexBufferData[60] = uvHeight;
					this.__vertexBufferData[70] = renderedLeft1 + renderedCenterX1;
					this.__vertexBufferData[73] = uvWidth * (uvLeft1 + uvCenterX1);
					this.__vertexBufferData[84] = this.width;
					this.__vertexBufferData[85] = renderedHeight;
					this.__vertexBufferData[87] = uvWidth;
					this.__vertexBufferData[88] = uvHeight;
					this.__vertexBufferData[98] = this.width;
					this.__vertexBufferData[101] = uvWidth;
					this.__vertexBuffer = context.createVertexBuffer(8,14);
				}
			} else {
				this.__vertexBufferGrid = null;
			}
			if(this.__vertexBuffer == null) {
				var this4 = new Float32Array(56);
				this.__vertexBufferData = this4;
				this.__vertexBufferData[0] = this.width;
				this.__vertexBufferData[1] = this.height;
				this.__vertexBufferData[3] = uvWidth;
				this.__vertexBufferData[4] = uvHeight;
				this.__vertexBufferData[15] = this.height;
				this.__vertexBufferData[18] = uvHeight;
				this.__vertexBufferData[28] = this.width;
				this.__vertexBufferData[31] = uvWidth;
				this.__vertexBuffer = context.createVertexBuffer(3,14);
			}
			this.__vertexBuffer.uploadFromTypedArray(lime_utils__$Float32Array_Float32Array_$Impl_$.toArrayBufferView(this.__vertexBufferData));
		}
		return this.__vertexBuffer;
	}
	,getColorBoundsRect: function(mask,color,findColor) {
		if(findColor == null) {
			findColor = true;
		}
		if(!this.readable) {
			return new openfl_geom_Rectangle(0,0,this.width,this.height);
		}
		if(!this.transparent || (mask >> 24 & 255) > 0) {
			var color1 = color;
			if((color1 >>> 24 & 255) == 0) {
				color1 = 0;
			}
		}
		var rect = this.image.getColorBoundsRect(mask,color,findColor,1);
		return new openfl_geom_Rectangle(rect.x,rect.y,rect.width,rect.height);
	}
	,getPixel: function(x,y) {
		if(!this.readable) {
			return 0;
		}
		return this.image.getPixel(x,y,1);
	}
	,getPixel32: function(x,y) {
		if(!this.readable) {
			return 0;
		}
		return this.image.getPixel32(x,y,1);
	}
	,getPixels: function(rect) {
		if(!this.readable) {
			return null;
		}
		if(rect == null) {
			rect = this.rect;
		}
		var byteArray = openfl_utils__$ByteArray_ByteArray_$Impl_$.fromBytes(this.image.getPixels(rect.__toLimeRectangle(),1));
		byteArray.__endian = 0;
		return byteArray;
	}
	,getSurface: function() {
		if(!this.readable) {
			return null;
		}
		if(this.__surface == null) {
			this.__surface = lime_graphics_cairo__$CairoImageSurface_CairoImageSurface_$Impl_$.fromImage(this.image);
		}
		return this.__surface;
	}
	,getTexture: function(context) {
		if(!this.__isValid) {
			return null;
		}
		if(this.__texture == null || this.__textureContext != context.__context) {
			this.__textureContext = context.__context;
			this.__texture = context.createRectangleTexture(this.width,this.height,1,false);
			this.__textureVersion = -1;
		}
		lime__$internal_graphics_ImageCanvasUtil.sync(this.image,false);
		if(this.image != null && this.image.version > this.__textureVersion) {
			if(this.__surface != null) {
				lime_graphics_cairo__$CairoSurface_CairoSurface_$Impl_$.flush(this.__surface);
			}
			var textureImage = this.image;
			if(!openfl_display3D_textures_TextureBase.__supportsBGRA && textureImage.get_format() != 0) {
				textureImage = textureImage.clone();
				textureImage.set_format(0);
			}
			this.__texture.__uploadFromImage(textureImage);
			this.__textureVersion = this.image.version;
			this.__textureWidth = textureImage.buffer.width;
			this.__textureHeight = textureImage.buffer.height;
		}
		if(!this.readable && this.image != null) {
			this.__surface = null;
			this.image = null;
		}
		return this.__texture;
	}
	,getVector: function(rect) {
		var pixels = this.getPixels(rect);
		var length = _$UInt_UInt_$Impl_$.toFloat(openfl_utils__$ByteArray_ByteArray_$Impl_$.get_length(pixels)) / _$UInt_UInt_$Impl_$.toFloat(4) | 0;
		var result = openfl__$Vector_Vector_$Impl_$.toIntVector(null,length,true);
		var _g1 = 0;
		var _g = length;
		while(_g1 < _g) {
			var i = _g1++;
			result.set(i,pixels.readUnsignedInt());
		}
		return result;
	}
	,histogram: function(hRect) {
		var rect = hRect != null ? hRect : new openfl_geom_Rectangle(0,0,this.width,this.height);
		var pixels = this.getPixels(rect);
		var _g = [];
		var _g1 = 0;
		while(_g1 < 4) {
			var i = _g1++;
			var _g2 = [];
			var _g3 = 0;
			while(_g3 < 256) {
				var j = _g3++;
				_g2.push(0);
			}
			_g.push(_g2);
		}
		var result = _g;
		var _g21 = 0;
		var _g11 = openfl_utils__$ByteArray_ByteArray_$Impl_$.get_length(pixels);
		while(_g21 < _g11) {
			var i1 = _g21++;
			++result[i1 % 4][pixels.readUnsignedByte()];
		}
		return result;
	}
	,hitTest: function(firstPoint,firstAlphaThreshold,secondObject,secondBitmapDataPoint,secondAlphaThreshold) {
		if(secondAlphaThreshold == null) {
			secondAlphaThreshold = 1;
		}
		if(!this.readable) {
			return false;
		}
		if(js_Boot.__instanceof(secondObject,openfl_display_Bitmap)) {
			secondObject = (js_Boot.__cast(secondObject , openfl_display_Bitmap)).__bitmapData;
		}
		if(js_Boot.__instanceof(secondObject,openfl_geom_Point)) {
			var secondPoint = secondObject;
			var x = secondPoint.x - firstPoint.x | 0;
			var y = secondPoint.y - firstPoint.y | 0;
			if(this.rect.contains(x,y)) {
				var pixel = this.getPixel32(x,y);
				if((pixel >> 24 & 255) > firstAlphaThreshold) {
					return true;
				}
			}
		} else if(js_Boot.__instanceof(secondObject,openfl_display_BitmapData)) {
			var secondBitmapData = secondObject;
			var x1;
			var y1;
			if(secondBitmapDataPoint == null) {
				x1 = 0;
				y1 = 0;
			} else {
				x1 = Math.round(secondBitmapDataPoint.x - firstPoint.x);
				y1 = Math.round(secondBitmapDataPoint.y - firstPoint.y);
			}
			var hitRect = openfl_geom_Rectangle.__pool.get();
			hitRect.setTo(x1,y1,secondBitmapData.width,secondBitmapData.height);
			if(this.rect.intersects(hitRect)) {
				if(x1 < 0) {
					hitRect.x = 0;
					hitRect.width = Math.min(secondBitmapData.width + x1,this.width);
				} else {
					hitRect.width = Math.min(secondBitmapData.width,this.width - x1);
				}
				if(y1 < 0) {
					hitRect.y = 0;
					hitRect.height = Math.min(secondBitmapData.height + y1,this.height);
				} else {
					hitRect.height = Math.min(secondBitmapData.height,this.height - y1);
				}
				var pixels = this.getPixels(hitRect);
				hitRect.x = x1 < 0 ? -x1 : 0;
				hitRect.y = y1 < 0 ? -y1 : 0;
				var testPixels = secondBitmapData.getPixels(hitRect);
				var length = hitRect.width * hitRect.height | 0;
				var pixel1;
				var testPixel;
				var _g1 = 0;
				var _g = length;
				while(_g1 < _g) {
					var i = _g1++;
					pixel1 = pixels.readUnsignedInt();
					testPixel = testPixels.readUnsignedInt();
					if(_$UInt_UInt_$Impl_$.gt(pixel1 >>> 24 & 255,firstAlphaThreshold) && _$UInt_UInt_$Impl_$.gt(testPixel >>> 24 & 255,secondAlphaThreshold)) {
						openfl_geom_Rectangle.__pool.release(hitRect);
						return true;
					}
				}
			}
			openfl_geom_Rectangle.__pool.release(hitRect);
		} else if(js_Boot.__instanceof(secondObject,openfl_geom_Rectangle)) {
			var secondRectangle = openfl_geom_Rectangle.__pool.get();
			secondRectangle.copyFrom(secondObject);
			secondRectangle.offset(-firstPoint.x,-firstPoint.y);
			secondRectangle.__contract(0,0,this.width,this.height);
			if(secondRectangle.width > 0 && secondRectangle.height > 0) {
				var pixels1 = this.getPixels(secondRectangle);
				var length1 = _$UInt_UInt_$Impl_$.toFloat(openfl_utils__$ByteArray_ByteArray_$Impl_$.get_length(pixels1)) / _$UInt_UInt_$Impl_$.toFloat(4) | 0;
				var pixel2;
				var _g11 = 0;
				var _g2 = length1;
				while(_g11 < _g2) {
					var i1 = _g11++;
					pixel2 = pixels1.readUnsignedInt();
					if(_$UInt_UInt_$Impl_$.gt(pixel2 >>> 24 & 255,firstAlphaThreshold)) {
						openfl_geom_Rectangle.__pool.release(secondRectangle);
						return true;
					}
				}
			}
			openfl_geom_Rectangle.__pool.release(secondRectangle);
		}
		return false;
	}
	,lock: function() {
	}
	,merge: function(sourceBitmapData,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
		if(!this.readable || sourceBitmapData == null || !sourceBitmapData.readable || sourceRect == null || destPoint == null) {
			return;
		}
		this.image.merge(sourceBitmapData.image,sourceRect.__toLimeRectangle(),destPoint.__toLimeVector2(),redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
	}
	,noise: function(randomSeed,low,high,channelOptions,grayScale) {
		if(grayScale == null) {
			grayScale = false;
		}
		if(channelOptions == null) {
			channelOptions = 7;
		}
		if(high == null) {
			high = 255;
		}
		if(low == null) {
			low = 0;
		}
		if(!this.readable) {
			return;
		}
		var func = function() {
			randomSeed = randomSeed * 1103515245 + 12345;
			return (Math.abs(randomSeed / 65536) | 0) % 32768;
		};
		var rand = func;
		rand();
		var range = high - low;
		var redChannel = (channelOptions & 1) == 1;
		var greenChannel = (channelOptions & 2) >> 1 == 1;
		var blueChannel = (channelOptions & 4) >> 2 == 1;
		var alphaChannel = (channelOptions & 8) >> 3 == 1;
		var _g1 = 0;
		var _g = this.height;
		while(_g1 < _g) {
			var y = _g1++;
			var _g3 = 0;
			var _g2 = this.width;
			while(_g3 < _g2) {
				var x = _g3++;
				var red = 0;
				var blue = 0;
				var green = 0;
				var alpha = 255;
				if(grayScale) {
					blue = low + rand() % range;
					green = blue;
					red = green;
					alpha = 255;
				} else {
					if(redChannel) {
						red = low + rand() % range;
					}
					if(greenChannel) {
						green = low + rand() % range;
					}
					if(blueChannel) {
						blue = low + rand() % range;
					}
					if(alphaChannel) {
						alpha = low + rand() % range;
					}
				}
				var rgb = alpha;
				rgb = (rgb << 8) + red;
				rgb = (rgb << 8) + green;
				rgb = (rgb << 8) + blue;
				this.setPixel32(x,y,rgb);
			}
		}
	}
	,paletteMap: function(sourceBitmapData,sourceRect,destPoint,redArray,greenArray,blueArray,alphaArray) {
		var sw = sourceRect.width | 0;
		var sh = sourceRect.height | 0;
		var pixels = sourceBitmapData.getPixels(sourceRect);
		var pixelValue;
		var r;
		var g;
		var b;
		var a;
		var color;
		var _g1 = 0;
		var _g = sh * sw;
		while(_g1 < _g) {
			var i = _g1++;
			pixelValue = pixels.readUnsignedInt();
			if(alphaArray == null) {
				a = pixelValue & -16777216;
			} else {
				a = alphaArray[pixelValue >> 24 & 255];
			}
			if(redArray == null) {
				r = pixelValue & 16711680;
			} else {
				r = redArray[pixelValue >> 16 & 255];
			}
			if(greenArray == null) {
				g = pixelValue & 65280;
			} else {
				g = greenArray[pixelValue >> 8 & 255];
			}
			if(blueArray == null) {
				b = pixelValue & 255;
			} else {
				b = blueArray[pixelValue & 255];
			}
			color = a + r + g + b;
			pixels.position = i * 4;
			pixels.writeUnsignedInt(color);
		}
		pixels.position = 0;
		var destRect = openfl_geom_Rectangle.__pool.get();
		destRect.setTo(destPoint.x,destPoint.y,sw,sh);
		this.setPixels(destRect,pixels);
		openfl_geom_Rectangle.__pool.release(destRect);
	}
	,perlinNoise: function(baseX,baseY,numOctaves,randomSeed,stitch,fractalNoise,channelOptions,grayScale,offsets) {
		if(grayScale == null) {
			grayScale = false;
		}
		if(channelOptions == null) {
			channelOptions = 7;
		}
		if(!this.readable) {
			return;
		}
		var noise = new openfl_display__$internal_PerlinNoise(randomSeed,numOctaves,channelOptions,grayScale,0.5,stitch,0.15);
		noise.fill(this,baseX,baseY,0);
	}
	,scroll: function(x,y) {
		if(!this.readable) {
			return;
		}
		this.image.scroll(x,y);
	}
	,setPixel: function(x,y,color) {
		if(!this.readable) {
			return;
		}
		this.image.setPixel(x,y,color,1);
	}
	,setPixel32: function(x,y,color) {
		if(!this.readable) {
			return;
		}
		this.image.setPixel32(x,y,color,1);
	}
	,setPixels: function(rect,byteArray) {
		if(!this.readable || rect == null) {
			return;
		}
		var length = rect.width * rect.height * 4;
		if(_$UInt_UInt_$Impl_$.toFloat(byteArray.length - byteArray.position) < length) {
			throw new js__$Boot_HaxeError(new openfl_errors_Error("End of file was encountered.",2030));
		}
		this.image.setPixels(rect.__toLimeRectangle(),openfl_utils__$ByteArray_ByteArray_$Impl_$.toBytePointer(byteArray),1,openfl_utils__$Endian_Endian_$Impl_$.toLimeEndian(byteArray.__endian));
	}
	,setVector: function(rect,inputVector) {
		var this1 = new openfl_utils_ByteArrayData(0);
		var byteArray = this1;
		openfl_utils__$ByteArray_ByteArray_$Impl_$.set_length(byteArray,inputVector.get_length() * 4);
		var _g = 0;
		while(_g < inputVector.get_length()) {
			var color = inputVector.get(_g);
			++_g;
			byteArray.writeUnsignedInt(color);
		}
		byteArray.position = 0;
		this.setPixels(rect,byteArray);
	}
	,threshold: function(sourceBitmapData,sourceRect,destPoint,operation,threshold,color,mask,copySource) {
		if(copySource == null) {
			copySource = false;
		}
		if(mask == null) {
			mask = -1;
		}
		if(color == null) {
			color = 0;
		}
		if(sourceBitmapData == null || sourceRect == null || destPoint == null || sourceRect.x > sourceBitmapData.width || sourceRect.y > sourceBitmapData.height || destPoint.x > this.width || destPoint.y > this.height) {
			return 0;
		}
		return this.image.threshold(sourceBitmapData.image,sourceRect.__toLimeRectangle(),destPoint.__toLimeVector2(),operation,threshold,color,mask,copySource,1);
	}
	,unlock: function(changeRect) {
	}
	,__applyAlpha: function(alpha) {
		lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this.image);
		lime__$internal_graphics_ImageCanvasUtil.createImageData(this.image);
		var data = this.image.buffer.data;
		var _g1 = 0;
		var _g = openfl_utils__$ByteArray_ByteArray_$Impl_$.get_length(alpha);
		while(_g1 < _g) {
			var i = _g1++;
			data[i * 4 + 3] = alpha.readUnsignedByte();
		}
		this.image.version++;
	}
	,__drawCairo: function(source,renderer) {
	}
	,__drawCanvas: function(source,renderer) {
		var buffer = this.image.buffer;
		if(!renderer.__allowSmoothing) {
			renderer.applySmoothing(buffer.__srcContext,false);
		}
		renderer.__render(source);
		if(!renderer.__allowSmoothing) {
			renderer.applySmoothing(buffer.__srcContext,true);
		}
		buffer.__srcContext.setTransform(1,0,0,1,0,0);
		buffer.__srcImageData = null;
		buffer.data = null;
		this.image.dirty = true;
		this.image.version++;
	}
	,__drawGL: function(source,renderer) {
		var context = renderer.__context3D;
		var cacheRTT = context.__state.renderToTexture;
		var cacheRTTDepthStencil = context.__state.renderToTextureDepthStencil;
		var cacheRTTAntiAlias = context.__state.renderToTextureAntiAlias;
		var cacheRTTSurfaceSelector = context.__state.renderToTextureSurfaceSelector;
		context.setRenderToTexture(this.getTexture(context),true);
		renderer.__render(source);
		if(cacheRTT != null) {
			context.setRenderToTexture(cacheRTT,cacheRTTDepthStencil,cacheRTTAntiAlias,cacheRTTSurfaceSelector);
		} else {
			context.setRenderToBackBuffer();
		}
	}
	,__fillRect: function(rect,color,allowFramebuffer) {
		if(rect == null) {
			return;
		}
		if(this.transparent && (color & -16777216) == 0) {
			color = 0;
		}
		if(allowFramebuffer && this.__texture != null && this.__texture.__glFramebuffer != null && openfl_Lib.get_current().stage.__renderer.__type == "opengl") {
			var renderer = openfl_Lib.get_current().stage.__renderer;
			var context = renderer.__context3D;
			var color1 = color;
			var useScissor = !this.rect.equals(rect);
			var cacheRTT = context.__state.renderToTexture;
			var cacheRTTDepthStencil = context.__state.renderToTextureDepthStencil;
			var cacheRTTAntiAlias = context.__state.renderToTextureAntiAlias;
			var cacheRTTSurfaceSelector = context.__state.renderToTextureSurfaceSelector;
			context.setRenderToTexture(this.__texture);
			if(useScissor) {
				context.setScissorRectangle(rect);
			}
			context.clear((color1 >>> 16 & 255) / 255,(color1 >>> 8 & 255) / 255,(color1 & 255) / 255,this.transparent ? (color1 >>> 24 & 255) / 255 : 1,0,0,1);
			if(useScissor) {
				context.setScissorRectangle(null);
			}
			if(cacheRTT != null) {
				context.setRenderToTexture(cacheRTT,cacheRTTDepthStencil,cacheRTTAntiAlias,cacheRTTSurfaceSelector);
			} else {
				context.setRenderToBackBuffer();
			}
		} else if(this.readable) {
			this.image.fillRect(rect.__toLimeRectangle(),color,1);
		}
	}
	,__fromBase64: function(base64,type) {
		var image = lime_graphics_Image.fromBase64(base64,type);
		this.__fromImage(image);
	}
	,__fromBytes: function(bytes,rawAlpha) {
		var image = lime_graphics_Image.fromBytes(openfl_utils__$ByteArray_ByteArray_$Impl_$.toBytes(bytes));
		this.__fromImage(image);
		if(rawAlpha != null) {
			this.__applyAlpha(rawAlpha);
		}
	}
	,__fromFile: function(path) {
		var image = lime_graphics_Image.fromFile(path);
		this.__fromImage(image);
	}
	,__fromImage: function(image) {
		if(image != null && image.buffer != null) {
			this.image = image;
			this.width = image.width;
			this.height = image.height;
			this.rect = new openfl_geom_Rectangle(0,0,image.width,image.height);
			this.__textureWidth = this.width;
			this.__textureHeight = this.height;
			this.readable = true;
			this.__isValid = true;
		}
	}
	,__getBounds: function(rect,matrix) {
		var bounds = openfl_geom_Rectangle.__pool.get();
		this.rect.__transform(bounds,matrix);
		rect.__expand(bounds.x,bounds.y,bounds.width,bounds.height);
		openfl_geom_Rectangle.__pool.release(bounds);
	}
	,__loadFromBase64: function(base64,type) {
		var _gthis = this;
		return lime_graphics_Image.loadFromBase64(base64,type).then(function(image) {
			_gthis.__fromImage(image);
			return lime_app_Future.withValue(_gthis);
		});
	}
	,__loadFromBytes: function(bytes,rawAlpha) {
		var _gthis = this;
		return lime_graphics_Image.loadFromBytes(openfl_utils__$ByteArray_ByteArray_$Impl_$.toBytes(bytes)).then(function(image) {
			_gthis.__fromImage(image);
			if(rawAlpha != null) {
				_gthis.__applyAlpha(rawAlpha);
			}
			return lime_app_Future.withValue(_gthis);
		});
	}
	,__loadFromFile: function(path) {
		var _gthis = this;
		return lime_graphics_Image.loadFromFile(path).then(function(image) {
			_gthis.__fromImage(image);
			return lime_app_Future.withValue(_gthis);
		});
	}
	,__resize: function(width,height) {
		this.width = width;
		this.height = height;
		this.rect.width = width;
		this.rect.height = height;
		this.__textureWidth = width;
		this.__textureHeight = height;
	}
	,__setUVRect: function(context,x,y,width,height) {
		var buffer = this.getVertexBuffer(context);
		if(buffer != null && (width != this.__uvRect.width || height != this.__uvRect.height || x != this.__uvRect.x || y != this.__uvRect.y)) {
			var gl = context.gl;
			if(this.__uvRect == null) {
				this.__uvRect = new openfl_geom_Rectangle();
			}
			this.__uvRect.setTo(x,y,width,height);
			var uvX = this.__textureWidth > 0 ? x / this.__textureWidth : 0;
			var uvY = this.__textureHeight > 0 ? y / this.__textureHeight : 0;
			var uvWidth = this.__textureWidth > 0 ? width / this.__textureWidth : 0;
			var uvHeight = this.__textureHeight > 0 ? height / this.__textureHeight : 0;
			this.__vertexBufferData[0] = width;
			this.__vertexBufferData[1] = height;
			this.__vertexBufferData[3] = uvX + uvWidth;
			this.__vertexBufferData[4] = uvY + uvHeight;
			this.__vertexBufferData[15] = height;
			this.__vertexBufferData[17] = uvX;
			this.__vertexBufferData[18] = uvY + uvHeight;
			this.__vertexBufferData[28] = width;
			this.__vertexBufferData[31] = uvX + uvWidth;
			this.__vertexBufferData[32] = uvY;
			this.__vertexBufferData[45] = uvX;
			this.__vertexBufferData[46] = uvY;
			this.__vertexBuffer.uploadFromTypedArray(lime_utils__$Float32Array_Float32Array_$Impl_$.toArrayBufferView(this.__vertexBufferData));
		}
	}
	,__sync: function() {
		lime__$internal_graphics_ImageCanvasUtil.sync(this.image,false);
	}
	,__update: function(transformOnly,updateChildren) {
		this.__updateTransforms();
	}
	,__updateTransforms: function(overrideTransform) {
		if(overrideTransform == null) {
			this.__worldTransform.identity();
		} else {
			this.__worldTransform.copyFrom(overrideTransform);
		}
		this.__renderTransform.copyFrom(this.__worldTransform);
	}
	,__class__: openfl_display_BitmapData
};
var openfl_display__$BlendMode_BlendMode_$Impl_$ = {};
$hxClasses["openfl.display._BlendMode.BlendMode_Impl_"] = openfl_display__$BlendMode_BlendMode_$Impl_$;
openfl_display__$BlendMode_BlendMode_$Impl_$.__name__ = ["openfl","display","_BlendMode","BlendMode_Impl_"];
openfl_display__$BlendMode_BlendMode_$Impl_$.fromString = function(value) {
	switch(value) {
	case "add":
		return 0;
	case "alpha":
		return 1;
	case "darken":
		return 2;
	case "difference":
		return 3;
	case "erase":
		return 4;
	case "hardlight":
		return 5;
	case "invert":
		return 6;
	case "layer":
		return 7;
	case "lighten":
		return 8;
	case "multiply":
		return 9;
	case "normal":
		return 10;
	case "overlay":
		return 11;
	case "screen":
		return 12;
	case "shader":
		return 13;
	case "subtract":
		return 14;
	default:
		return null;
	}
};
openfl_display__$BlendMode_BlendMode_$Impl_$.toString = function(this1) {
	var _g = this1;
	switch(_g) {
	case 0:
		return "add";
	case 1:
		return "alpha";
	case 2:
		return "darken";
	case 3:
		return "difference";
	case 4:
		return "erase";
	case 5:
		return "hardlight";
	case 6:
		return "invert";
	case 7:
		return "layer";
	case 8:
		return "lighten";
	case 9:
		return "multiply";
	case 10:
		return "normal";
	case 11:
		return "overlay";
	case 12:
		return "screen";
	case 13:
		return "shader";
	case 14:
		return "subtract";
	default:
		return null;
	}
};
var openfl_display_DisplayObjectRenderer = function() {
	openfl_events_EventDispatcher.call(this);
	this.__allowSmoothing = true;
	this.__tempColorTransform = new openfl_geom_ColorTransform();
	this.__worldAlpha = 1;
};
$hxClasses["openfl.display.DisplayObjectRenderer"] = openfl_display_DisplayObjectRenderer;
openfl_display_DisplayObjectRenderer.__name__ = ["openfl","display","DisplayObjectRenderer"];
openfl_display_DisplayObjectRenderer.__super__ = openfl_events_EventDispatcher;
openfl_display_DisplayObjectRenderer.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	__clear: function() {
	}
	,__getAlpha: function(value) {
		return value * this.__worldAlpha;
	}
	,__getColorTransform: function(value) {
		if(this.__worldColorTransform != null) {
			this.__tempColorTransform.__copyFrom(this.__worldColorTransform);
			this.__tempColorTransform.__combine(value);
			return this.__tempColorTransform;
		} else {
			return value;
		}
	}
	,__popMask: function() {
	}
	,__popMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
	}
	,__popMaskRect: function() {
	}
	,__pushMask: function(mask) {
	}
	,__pushMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
	}
	,__pushMaskRect: function(rect,transform) {
	}
	,__render: function(object) {
	}
	,__renderEvent: function(displayObject) {
		var renderer = this;
		if(displayObject.__customRenderEvent != null && displayObject.__renderable) {
			displayObject.__customRenderEvent.allowSmoothing = renderer.__allowSmoothing;
			displayObject.__customRenderEvent.objectMatrix.copyFrom(displayObject.__renderTransform);
			displayObject.__customRenderEvent.objectColorTransform.__copyFrom(displayObject.__worldColorTransform);
			displayObject.__customRenderEvent.renderer = renderer;
			var _g = renderer.__type;
			switch(_g) {
			case "cairo":
				displayObject.__customRenderEvent.type = "renderCairo";
				break;
			case "canvas":
				displayObject.__customRenderEvent.type = "renderCanvas";
				break;
			case "dom":
				if(displayObject.stage != null && displayObject.__worldVisible) {
					displayObject.__customRenderEvent.type = "renderDOM";
				} else {
					displayObject.__customRenderEvent.type = "clearDOM";
				}
				break;
			case "opengl":
				if(!renderer.__cleared) {
					renderer.__clear();
				}
				var renderer1 = renderer;
				renderer1.setShader(displayObject.__worldShader);
				renderer1.__context3D.__flushGL();
				displayObject.__customRenderEvent.type = "renderOpenGL";
				break;
			default:
				return;
			}
			renderer.__setBlendMode(displayObject.__worldBlendMode);
			renderer.__pushMaskObject(displayObject);
			displayObject.dispatchEvent(displayObject.__customRenderEvent);
			renderer.__popMaskObject(displayObject);
			if(renderer.__type == "opengl") {
				var renderer2 = renderer;
				renderer2.setViewport();
			}
		}
	}
	,__resize: function(width,height) {
	}
	,__setBlendMode: function(value) {
	}
	,__shouldCacheHardware: function(displayObject,value) {
		if(displayObject == null) {
			return null;
		}
		var _g = displayObject.__drawableType;
		switch(_g) {
		case 4:case 5:
			if(value == true) {
				return true;
			}
			value = this.__shouldCacheHardware_DisplayObject(displayObject,value);
			if(value == true) {
				return true;
			}
			if(displayObject.__children != null) {
				var _g1 = 0;
				var _g11 = displayObject.__children;
				while(_g1 < _g11.length) {
					var child = _g11[_g1];
					++_g1;
					value = this.__shouldCacheHardware_DisplayObject(child,value);
					if(value == true) {
						return true;
					}
				}
			}
			return value;
		case 7:
			if(value == true) {
				return true;
			} else {
				return false;
			}
			break;
		case 9:
			return true;
		default:
			return this.__shouldCacheHardware_DisplayObject(displayObject,value);
		}
	}
	,__shouldCacheHardware_DisplayObject: function(displayObject,value) {
		if(value == true || displayObject.__filters != null) {
			return true;
		}
		if(value == false || displayObject.__graphics != null && !openfl_display__$internal_Context3DGraphics.isCompatible(displayObject.__graphics)) {
			return false;
		}
		return null;
	}
	,__updateCacheBitmap: function(displayObject,force) {
		if(displayObject == null) {
			return false;
		}
		var renderer = this;
		var _g = displayObject.__drawableType;
		switch(_g) {
		case 2:
			var bitmap = displayObject;
			if(bitmap.__bitmapData == null || bitmap.__filters == null && renderer.__type == "opengl" && bitmap.__cacheBitmap == null) {
				return false;
			}
			if(bitmap.__bitmapData.image != null) {
				force = bitmap.__bitmapData.image.version != bitmap.__imageVersion;
			} else {
				force = false;
			}
			break;
		case 7:
			var textField = displayObject;
			if(textField.__filters == null && renderer.__type == "opengl" && textField.__cacheBitmap == null && !textField.__domRender) {
				return false;
			}
			if(force) {
				textField.__renderDirty = true;
			}
			if(!force) {
				force = textField.__dirty;
			} else {
				force = true;
			}
			break;
		case 9:
			var tilemap = displayObject;
			if(tilemap.__filters == null && renderer.__type == "opengl" && tilemap.__cacheBitmap == null) {
				return false;
			}
			break;
		default:
		}
		if(displayObject.__isCacheBitmapRender) {
			return false;
		}
		var colorTransform = openfl_geom_ColorTransform.__pool.get();
		colorTransform.__copyFrom(displayObject.__worldColorTransform);
		if(renderer.__worldColorTransform != null) {
			colorTransform.__combine(renderer.__worldColorTransform);
		}
		var updated = false;
		if(displayObject.get_cacheAsBitmap() || renderer.__type != "opengl" && !colorTransform.__isDefault(true)) {
			var rect = null;
			var needRender = displayObject.__cacheBitmap == null || displayObject.__renderDirty && (force || displayObject.__children != null && displayObject.__children.length > 0) || displayObject.opaqueBackground != displayObject.__cacheBitmapBackground;
			var softwareDirty = needRender || displayObject.__graphics != null && displayObject.__graphics.__softwareDirty || !displayObject.__cacheBitmapColorTransform.__equals(colorTransform,true);
			var hardwareDirty = needRender || displayObject.__graphics != null && displayObject.__graphics.__hardwareDirty;
			var renderType = renderer.__type;
			if(softwareDirty || hardwareDirty) {
				if(renderType == "opengl") {
					if(this.__shouldCacheHardware(displayObject,null) == false) {
						renderType = "canvas";
					}
				}
				if(softwareDirty && (renderType == "canvas" || renderType == "cairo")) {
					needRender = true;
				}
				if(hardwareDirty && renderType == "opengl") {
					needRender = true;
				}
			}
			var updateTransform = needRender || !displayObject.__cacheBitmap.__worldTransform.equals(displayObject.__worldTransform);
			var hasFilters = displayObject.__filters != null;
			if(hasFilters && !needRender) {
				var _g1 = 0;
				var _g2 = displayObject.__filters;
				while(_g1 < _g2.length) {
					var filter = _g2[_g1];
					++_g1;
					if(filter.__renderDirty) {
						needRender = true;
						break;
					}
				}
			}
			if(displayObject.__cacheBitmapMatrix == null) {
				displayObject.__cacheBitmapMatrix = new openfl_geom_Matrix();
			}
			var bitmapMatrix = displayObject.__cacheAsBitmapMatrix != null ? displayObject.__cacheAsBitmapMatrix : displayObject.__renderTransform;
			if(!needRender && (bitmapMatrix.a != displayObject.__cacheBitmapMatrix.a || bitmapMatrix.b != displayObject.__cacheBitmapMatrix.b || bitmapMatrix.c != displayObject.__cacheBitmapMatrix.c || bitmapMatrix.d != displayObject.__cacheBitmapMatrix.d)) {
				needRender = true;
			}
			if(!needRender && renderer.__type != "opengl" && displayObject.__cacheBitmapData != null && displayObject.__cacheBitmapData.image != null && displayObject.__cacheBitmapData.image.version < displayObject.__cacheBitmapData.__textureVersion) {
				needRender = true;
			}
			displayObject.__cacheBitmapMatrix.copyFrom(bitmapMatrix);
			displayObject.__cacheBitmapMatrix.tx = 0;
			displayObject.__cacheBitmapMatrix.ty = 0;
			var bitmapWidth = 0;
			var bitmapHeight = 0;
			var filterWidth = 0;
			var filterHeight = 0;
			var offsetX = 0.;
			var offsetY = 0.;
			if(updateTransform || needRender) {
				rect = openfl_geom_Rectangle.__pool.get();
				displayObject.__getFilterBounds(rect,displayObject.__cacheBitmapMatrix);
				filterWidth = Math.ceil(rect.width);
				filterHeight = Math.ceil(rect.height);
				if(rect.x > 0) {
					offsetX = Math.ceil(rect.x);
				} else {
					offsetX = Math.floor(rect.x);
				}
				if(rect.y > 0) {
					offsetY = Math.ceil(rect.y);
				} else {
					offsetY = Math.floor(rect.y);
				}
				if(displayObject.__cacheBitmapData != null) {
					if(filterWidth > displayObject.__cacheBitmapData.width || filterHeight > displayObject.__cacheBitmapData.height) {
						bitmapWidth = Math.ceil(Math.max(filterWidth * 1.25,displayObject.__cacheBitmapData.width));
						bitmapHeight = Math.ceil(Math.max(filterHeight * 1.25,displayObject.__cacheBitmapData.height));
						needRender = true;
					} else {
						bitmapWidth = displayObject.__cacheBitmapData.width;
						bitmapHeight = displayObject.__cacheBitmapData.height;
					}
				} else {
					bitmapWidth = filterWidth;
					bitmapHeight = filterHeight;
				}
			}
			if(needRender) {
				updateTransform = true;
				displayObject.__cacheBitmapBackground = displayObject.opaqueBackground;
				if(filterWidth >= 0.5 && filterHeight >= 0.5) {
					var needsFill = displayObject.opaqueBackground != null && (bitmapWidth != filterWidth || bitmapHeight != filterHeight);
					var fillColor = displayObject.opaqueBackground != null ? -16777216 | displayObject.opaqueBackground : 0;
					var bitmapColor = needsFill ? 0 : fillColor;
					var allowFramebuffer = renderer.__type == "opengl";
					if(displayObject.__cacheBitmapData == null || bitmapWidth > displayObject.__cacheBitmapData.width || bitmapHeight > displayObject.__cacheBitmapData.height) {
						displayObject.__cacheBitmapData = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,bitmapColor);
						if(displayObject.__cacheBitmap == null) {
							displayObject.__cacheBitmap = new openfl_display_Bitmap();
						}
						displayObject.__cacheBitmap.__bitmapData = displayObject.__cacheBitmapData;
						displayObject.__cacheBitmapRenderer = null;
					} else {
						displayObject.__cacheBitmapData.__fillRect(displayObject.__cacheBitmapData.rect,bitmapColor,allowFramebuffer);
					}
					if(needsFill) {
						rect.setTo(0,0,filterWidth,filterHeight);
						displayObject.__cacheBitmapData.__fillRect(rect,fillColor,allowFramebuffer);
					}
				} else {
					openfl_geom_ColorTransform.__pool.release(colorTransform);
					displayObject.__cacheBitmap = null;
					displayObject.__cacheBitmapData = null;
					displayObject.__cacheBitmapData2 = null;
					displayObject.__cacheBitmapData3 = null;
					displayObject.__cacheBitmapRenderer = null;
					if(displayObject.__drawableType == 7) {
						var textField1 = displayObject;
						if(textField1.__cacheBitmap != null) {
							textField1.__cacheBitmap.__renderTransform.tx -= textField1.__offsetX;
							textField1.__cacheBitmap.__renderTransform.ty -= textField1.__offsetY;
						}
					}
					return true;
				}
			} else {
				displayObject.__cacheBitmapData = displayObject.__cacheBitmap.get_bitmapData();
				displayObject.__cacheBitmapData2 = null;
				displayObject.__cacheBitmapData3 = null;
			}
			if(updateTransform || needRender) {
				displayObject.__cacheBitmap.__worldTransform.copyFrom(displayObject.__worldTransform);
				if(bitmapMatrix == displayObject.__renderTransform) {
					displayObject.__cacheBitmap.__renderTransform.identity();
					displayObject.__cacheBitmap.__renderTransform.tx = displayObject.__renderTransform.tx + offsetX;
					displayObject.__cacheBitmap.__renderTransform.ty = displayObject.__renderTransform.ty + offsetY;
				} else {
					displayObject.__cacheBitmap.__renderTransform.copyFrom(displayObject.__cacheBitmapMatrix);
					displayObject.__cacheBitmap.__renderTransform.invert();
					displayObject.__cacheBitmap.__renderTransform.concat(displayObject.__renderTransform);
					displayObject.__cacheBitmap.__renderTransform.tx += offsetX;
					displayObject.__cacheBitmap.__renderTransform.ty += offsetY;
				}
			}
			displayObject.__cacheBitmap.smoothing = renderer.__allowSmoothing;
			displayObject.__cacheBitmap.__renderable = displayObject.__renderable;
			displayObject.__cacheBitmap.__worldAlpha = displayObject.__worldAlpha;
			displayObject.__cacheBitmap.__worldBlendMode = displayObject.__worldBlendMode;
			displayObject.__cacheBitmap.__worldShader = displayObject.__worldShader;
			displayObject.__cacheBitmap.set_mask(displayObject.__mask);
			if(needRender) {
				if(displayObject.__cacheBitmapRenderer == null || renderType != displayObject.__cacheBitmapRenderer.__type) {
					if(renderType == "opengl") {
						displayObject.__cacheBitmapRenderer = new openfl_display_OpenGLRenderer((js_Boot.__cast(renderer , openfl_display_OpenGLRenderer)).__context3D,displayObject.__cacheBitmapData);
					} else {
						if(displayObject.__cacheBitmapData.image == null) {
							var color = displayObject.opaqueBackground != null ? -16777216 | displayObject.opaqueBackground : 0;
							displayObject.__cacheBitmapData = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,color);
							displayObject.__cacheBitmap.__bitmapData = displayObject.__cacheBitmapData;
						}
						lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(displayObject.__cacheBitmapData.image);
						displayObject.__cacheBitmapRenderer = new openfl_display_CanvasRenderer(displayObject.__cacheBitmapData.image.buffer.__srcContext);
					}
					displayObject.__cacheBitmapRenderer.__worldTransform = new openfl_geom_Matrix();
					displayObject.__cacheBitmapRenderer.__worldColorTransform = new openfl_geom_ColorTransform();
				}
				if(displayObject.__cacheBitmapColorTransform == null) {
					displayObject.__cacheBitmapColorTransform = new openfl_geom_ColorTransform();
				}
				displayObject.__cacheBitmapRenderer.__stage = displayObject.stage;
				displayObject.__cacheBitmapRenderer.__allowSmoothing = renderer.__allowSmoothing;
				displayObject.__cacheBitmapRenderer.__setBlendMode(10);
				displayObject.__cacheBitmapRenderer.__worldAlpha = 1 / displayObject.__worldAlpha;
				displayObject.__cacheBitmapRenderer.__worldTransform.copyFrom(displayObject.__renderTransform);
				displayObject.__cacheBitmapRenderer.__worldTransform.invert();
				displayObject.__cacheBitmapRenderer.__worldTransform.concat(displayObject.__cacheBitmapMatrix);
				displayObject.__cacheBitmapRenderer.__worldTransform.tx -= offsetX;
				displayObject.__cacheBitmapRenderer.__worldTransform.ty -= offsetY;
				displayObject.__cacheBitmapRenderer.__worldColorTransform.__copyFrom(colorTransform);
				displayObject.__cacheBitmapRenderer.__worldColorTransform.__invert();
				displayObject.__isCacheBitmapRender = true;
				if(displayObject.__cacheBitmapRenderer.__type == "opengl") {
					var parentRenderer = renderer;
					var childRenderer = displayObject.__cacheBitmapRenderer;
					var context = childRenderer.__context3D;
					var cacheRTT = context.__state.renderToTexture;
					var cacheRTTDepthStencil = context.__state.renderToTextureDepthStencil;
					var cacheRTTAntiAlias = context.__state.renderToTextureAntiAlias;
					var cacheRTTSurfaceSelector = context.__state.renderToTextureSurfaceSelector;
					var cacheBlendMode = parentRenderer.__blendMode;
					parentRenderer.__suspendClipAndMask();
					childRenderer.__copyShader(parentRenderer);
					displayObject.__cacheBitmapData.__setUVRect(context,0,0,filterWidth,filterHeight);
					childRenderer.__setRenderTarget(displayObject.__cacheBitmapData);
					if(displayObject.__cacheBitmapData.image != null) {
						displayObject.__cacheBitmapData.__textureVersion = displayObject.__cacheBitmapData.image.version + 1;
					}
					displayObject.__cacheBitmapData.__drawGL(displayObject,childRenderer);
					if(hasFilters) {
						var needSecondBitmapData = true;
						var needCopyOfOriginal = false;
						var _g11 = 0;
						var _g21 = displayObject.__filters;
						while(_g11 < _g21.length) {
							var filter1 = _g21[_g11];
							++_g11;
							if(filter1.__preserveObject) {
								needCopyOfOriginal = true;
							}
						}
						var bitmap1 = displayObject.__cacheBitmapData;
						var bitmap2 = null;
						var bitmap3 = null;
						if(displayObject.__cacheBitmapData2 == null || bitmapWidth > displayObject.__cacheBitmapData2.width || bitmapHeight > displayObject.__cacheBitmapData2.height) {
							displayObject.__cacheBitmapData2 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
						} else {
							displayObject.__cacheBitmapData2.fillRect(displayObject.__cacheBitmapData2.rect,0);
							if(displayObject.__cacheBitmapData2.image != null) {
								displayObject.__cacheBitmapData2.__textureVersion = displayObject.__cacheBitmapData2.image.version + 1;
							}
						}
						displayObject.__cacheBitmapData2.__setUVRect(context,0,0,filterWidth,filterHeight);
						bitmap2 = displayObject.__cacheBitmapData2;
						if(needCopyOfOriginal) {
							if(displayObject.__cacheBitmapData3 == null || bitmapWidth > displayObject.__cacheBitmapData3.width || bitmapHeight > displayObject.__cacheBitmapData3.height) {
								displayObject.__cacheBitmapData3 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
							} else {
								displayObject.__cacheBitmapData3.fillRect(displayObject.__cacheBitmapData3.rect,0);
								if(displayObject.__cacheBitmapData3.image != null) {
									displayObject.__cacheBitmapData3.__textureVersion = displayObject.__cacheBitmapData3.image.version + 1;
								}
							}
							displayObject.__cacheBitmapData3.__setUVRect(context,0,0,filterWidth,filterHeight);
							bitmap3 = displayObject.__cacheBitmapData3;
						}
						childRenderer.__setBlendMode(10);
						childRenderer.__worldAlpha = 1;
						childRenderer.__worldTransform.identity();
						childRenderer.__worldColorTransform.__identity();
						var shader;
						var cacheBitmap;
						var _g12 = 0;
						var _g22 = displayObject.__filters;
						while(_g12 < _g22.length) {
							var filter2 = _g22[_g12];
							++_g12;
							if(filter2.__preserveObject) {
								childRenderer.__setRenderTarget(bitmap3);
								childRenderer.__renderFilterPass(bitmap1,childRenderer.__defaultDisplayShader,filter2.__smooth);
							}
							var _g4 = 0;
							var _g3 = filter2.__numShaderPasses;
							while(_g4 < _g3) {
								var i = _g4++;
								shader = filter2.__initShader(childRenderer,i,filter2.__preserveObject ? bitmap3 : null);
								childRenderer.__setBlendMode(filter2.__shaderBlendMode);
								childRenderer.__setRenderTarget(bitmap2);
								childRenderer.__renderFilterPass(bitmap1,shader,filter2.__smooth);
								cacheBitmap = bitmap1;
								bitmap1 = bitmap2;
								bitmap2 = cacheBitmap;
							}
							filter2.__renderDirty = false;
						}
						displayObject.__cacheBitmap.__bitmapData = bitmap1;
					}
					parentRenderer.__blendMode = 10;
					parentRenderer.__setBlendMode(cacheBlendMode);
					parentRenderer.__copyShader(childRenderer);
					if(cacheRTT != null) {
						context.setRenderToTexture(cacheRTT,cacheRTTDepthStencil,cacheRTTAntiAlias,cacheRTTSurfaceSelector);
					} else {
						context.setRenderToBackBuffer();
					}
					parentRenderer.__resumeClipAndMask(childRenderer);
					parentRenderer.setViewport();
					displayObject.__cacheBitmapColorTransform.__copyFrom(colorTransform);
				} else {
					displayObject.__cacheBitmapData.__drawCanvas(displayObject,displayObject.__cacheBitmapRenderer);
					if(hasFilters) {
						var needSecondBitmapData1 = false;
						var needCopyOfOriginal1 = false;
						var _g13 = 0;
						var _g23 = displayObject.__filters;
						while(_g13 < _g23.length) {
							var filter3 = _g23[_g13];
							++_g13;
							if(filter3.__needSecondBitmapData) {
								needSecondBitmapData1 = true;
							}
							if(filter3.__preserveObject) {
								needCopyOfOriginal1 = true;
							}
						}
						var bitmap4 = displayObject.__cacheBitmapData;
						var bitmap21 = null;
						var bitmap31 = null;
						if(needSecondBitmapData1) {
							if(displayObject.__cacheBitmapData2 == null || displayObject.__cacheBitmapData2.image == null || bitmapWidth > displayObject.__cacheBitmapData2.width || bitmapHeight > displayObject.__cacheBitmapData2.height) {
								displayObject.__cacheBitmapData2 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
							} else {
								displayObject.__cacheBitmapData2.fillRect(displayObject.__cacheBitmapData2.rect,0);
							}
							bitmap21 = displayObject.__cacheBitmapData2;
						} else {
							bitmap21 = bitmap4;
						}
						if(needCopyOfOriginal1) {
							if(displayObject.__cacheBitmapData3 == null || displayObject.__cacheBitmapData3.image == null || bitmapWidth > displayObject.__cacheBitmapData3.width || bitmapHeight > displayObject.__cacheBitmapData3.height) {
								displayObject.__cacheBitmapData3 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
							} else {
								displayObject.__cacheBitmapData3.fillRect(displayObject.__cacheBitmapData3.rect,0);
							}
							bitmap31 = displayObject.__cacheBitmapData3;
						}
						if(displayObject.__tempPoint == null) {
							displayObject.__tempPoint = new openfl_geom_Point();
						}
						var destPoint = displayObject.__tempPoint;
						var cacheBitmap1;
						var lastBitmap;
						var _g14 = 0;
						var _g24 = displayObject.__filters;
						while(_g14 < _g24.length) {
							var filter4 = _g24[_g14];
							++_g14;
							if(filter4.__preserveObject) {
								bitmap31.copyPixels(bitmap4,bitmap4.rect,destPoint);
							}
							lastBitmap = filter4.__applyFilter(bitmap21,bitmap4,bitmap4.rect,destPoint);
							if(filter4.__preserveObject) {
								lastBitmap.draw(bitmap31,null,displayObject.__objectTransform != null ? displayObject.__objectTransform.__colorTransform : null);
							}
							filter4.__renderDirty = false;
							if(needSecondBitmapData1 && lastBitmap == bitmap21) {
								cacheBitmap1 = bitmap4;
								bitmap4 = bitmap21;
								bitmap21 = cacheBitmap1;
							}
						}
						if(displayObject.__cacheBitmapData != bitmap4) {
							cacheBitmap1 = displayObject.__cacheBitmapData;
							displayObject.__cacheBitmapData = bitmap4;
							displayObject.__cacheBitmapData2 = cacheBitmap1;
							displayObject.__cacheBitmap.__bitmapData = displayObject.__cacheBitmapData;
							displayObject.__cacheBitmapRenderer = null;
						}
						displayObject.__cacheBitmap.__imageVersion = displayObject.__cacheBitmapData.__textureVersion;
					}
					displayObject.__cacheBitmapColorTransform.__copyFrom(colorTransform);
					if(!displayObject.__cacheBitmapColorTransform.__isDefault(true)) {
						displayObject.__cacheBitmapColorTransform.alphaMultiplier = 1;
						displayObject.__cacheBitmapData.colorTransform(displayObject.__cacheBitmapData.rect,displayObject.__cacheBitmapColorTransform);
					}
				}
				displayObject.__isCacheBitmapRender = false;
			}
			if(updateTransform || needRender) {
				openfl_geom_Rectangle.__pool.release(rect);
			}
			updated = updateTransform;
		} else if(displayObject.__cacheBitmap != null) {
			if(renderer.__type == "dom") {
				var domRenderer = renderer;
				domRenderer.__renderDrawableClear(displayObject.__cacheBitmap);
			}
			displayObject.__cacheBitmap = null;
			displayObject.__cacheBitmapData = null;
			displayObject.__cacheBitmapData2 = null;
			displayObject.__cacheBitmapData3 = null;
			displayObject.__cacheBitmapColorTransform = null;
			displayObject.__cacheBitmapRenderer = null;
			updated = true;
		}
		openfl_geom_ColorTransform.__pool.release(colorTransform);
		if(updated && displayObject.__drawableType == 7) {
			var textField2 = displayObject;
			if(textField2.__cacheBitmap != null) {
				textField2.__cacheBitmap.__renderTransform.tx -= textField2.__offsetX;
				textField2.__cacheBitmap.__renderTransform.ty -= textField2.__offsetY;
			}
		}
		return updated;
	}
	,__class__: openfl_display_DisplayObjectRenderer
});
var openfl_display_CairoRenderer = function(cairo) {
	openfl_display_DisplayObjectRenderer.call(this);
};
$hxClasses["openfl.display.CairoRenderer"] = openfl_display_CairoRenderer;
openfl_display_CairoRenderer.__name__ = ["openfl","display","CairoRenderer"];
openfl_display_CairoRenderer.__super__ = openfl_display_DisplayObjectRenderer;
openfl_display_CairoRenderer.prototype = $extend(openfl_display_DisplayObjectRenderer.prototype,{
	applyMatrix: function(transform,cairo) {
		if(cairo == null) {
			cairo = this.cairo;
		}
		this.__matrix.copyFrom(transform);
		if(this.cairo == cairo && this.__worldTransform != null) {
			this.__matrix.concat(this.__worldTransform);
		}
		this.__matrix3.a = this.__matrix.a;
		this.__matrix3.b = this.__matrix.b;
		this.__matrix3.c = this.__matrix.c;
		this.__matrix3.d = this.__matrix.d;
		if(this.__roundPixels) {
			this.__matrix3.tx = Math.round(this.__matrix.tx);
			this.__matrix3.ty = Math.round(this.__matrix.ty);
		} else {
			this.__matrix3.tx = this.__matrix.tx;
			this.__matrix3.ty = this.__matrix.ty;
		}
		cairo.set_matrix(this.__matrix3);
	}
	,__clear: function() {
		if(this.cairo == null) {
			return;
		}
		this.cairo.identityMatrix();
		if(this.__stage != null && this.__stage.__clearBeforeRender) {
			var cacheBlendMode = this.__blendMode;
			this.__setBlendMode(10);
			this.cairo.setSourceRGB(this.__stage.__colorSplit[0],this.__stage.__colorSplit[1],this.__stage.__colorSplit[2]);
			this.cairo.paint();
			this.__setBlendMode(cacheBlendMode);
		}
	}
	,__popMask: function() {
		this.cairo.restore();
	}
	,__popMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
		if(!object.__isCacheBitmapRender && object.__mask != null) {
			this.__popMask();
		}
		if(handleScrollRect && object.__scrollRect != null) {
			this.__popMaskRect();
		}
	}
	,__popMaskRect: function() {
		this.cairo.restore();
	}
	,__pushMask: function(mask) {
		this.cairo.save();
		this.applyMatrix(mask.__renderTransform,this.cairo);
		this.cairo.newPath();
		this.__renderDrawableMask(mask);
		this.cairo.clip();
	}
	,__pushMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
		if(handleScrollRect && object.__scrollRect != null) {
			this.__pushMaskRect(object.__scrollRect,object.__renderTransform)