package;


import haxe.io.Bytes;
import lime.utils.AssetBundle;
import lime.utils.AssetLibrary;
import lime.utils.AssetManifest;
import lime.utils.Assets;

#if sys
import sys.FileSystem;
#end

@:access(lime.utils.Assets)


@:keep @:dox(hide) class ManifestResources {


	public static var preloadLibraries:Array<AssetLibrary>;
	public static var preloadLibraryNames:Array<String>;
	public static var rootPath:String;


	public static function init (config:Dynamic):Void {

		preloadLibraries = new Array ();
		preloadLibraryNames = new Array ();

		rootPath = null;

		if (config != null && Reflect.hasField (config, "rootPath")) {

			rootPath = Reflect.field (config, "rootPath");

		}

		if (rootPath == null) {

			#if (ios || tvos || emscripten)
			rootPath = "assets/";
			#elseif android
			rootPath = "";
			#elseif console
			rootPath = lime.system.System.applicationDirectory;
			#else
			rootPath = "./";
			#end

		}

		#if (openfl && !flash && !display)
		
		#end

		var data, manifest, library, bundle;

		#if kha

		null
		library = AssetLibrary.fromManifest (manifest);
		Assets.registerLibrary ("null", library);

		if (library != null) preloadLibraries.push (library);
		else preloadLibraryNames.push ("null");

		#else

		data = '{"name":null,"assets":"aoy4:sizei37813y4:typey5:SOUNDy2:idy18:assets%2Fheart.oggy9:pathGroupaR4hy7:preloadtgoy4:pathy18:assets%2Fjizou.pngR0i1588R1y5:IMAGER3R8R6tgoR0i26933R1R2R3y15:assets%2Fob.oggR5aR10hR6tgoR0i15880R1R2R3y19:assets%2Fdamage.wavR5aR11hR6tgoR0i18287R1R2R3y16:assets%2Fisi.oggR5aR12hR6tgoR7y15:assets%2Fob.pngR0i931R1R9R3R13R6tgoR7y16:assets%2Fisi.pngR0i827R1R9R3R14R6tgoR7y18:assets%2Fheart.pngR0i1156R1R9R3R15R6tgoR7y23:assets%2Fheart.png.backR0i570R1y6:BINARYR3R16R6tgoR7y19:assets%2Fheart2.pngR0i472R1R9R3R18R6tgoR7y15:assets%2FBG.jpgR0i8727R1R9R3R19R6tgh","rootPath":null,"version":2,"libraryArgs":[],"libraryType":null}';
		manifest = AssetManifest.parse (data, rootPath);
		library = AssetLibrary.fromManifest (manifest);
		Assets.registerLibrary ("default", library);
		

		library = Assets.getLibrary ("default");
		if (library != null) preloadLibraries.push (library);
		else preloadLibraryNames.push ("default");
		

		#end

	}


}


#if kha

null

#else

#if !display
#if flash

@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_heart_ogg extends null { }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_jizou_png extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_ob_ogg extends null { }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_damage_wav extends null { }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_isi_ogg extends null { }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_ob_png extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_isi_png extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_heart_png extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_heart_png_back extends null { }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_heart2_png extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__assets_bg_jpg extends flash.display.BitmapData { public function new () { super (0, 0, true, 0); } }
@:keep @:bind @:noCompletion #if display private #end class __ASSET__manifest_default_json extends null { }


#elseif (desktop || cpp)

@:keep @:file("Assets/heart.ogg") @:noCompletion #if display private #end class __ASSET__assets_heart_ogg extends haxe.io.Bytes {}
@:keep @:image("Assets/jizou.png") @:noCompletion #if display private #end class __ASSET__assets_jizou_png extends lime.graphics.Image {}
@:keep @:file("Assets/ob.ogg") @:noCompletion #if display private #end class __ASSET__assets_ob_ogg extends haxe.io.Bytes {}
@:keep @:file("Assets/damage.wav") @:noCompletion #if display private #end class __ASSET__assets_damage_wav extends haxe.io.Bytes {}
@:keep @:file("Assets/isi.ogg") @:noCompletion #if display private #end class __ASSET__assets_isi_ogg extends haxe.io.Bytes {}
@:keep @:image("Assets/ob.png") @:noCompletion #if display private #end class __ASSET__assets_ob_png extends lime.graphics.Image {}
@:keep @:image("Assets/isi.png") @:noCompletion #if display private #end class __ASSET__assets_isi_png extends lime.graphics.Image {}
@:keep @:image("Assets/heart.png") @:noCompletion #if display private #end class __ASSET__assets_heart_png extends lime.graphics.Image {}
@:keep @:file("Assets/heart.png.back") @:noCompletion #if display private #end class __ASSET__assets_heart_png_back extends haxe.io.Bytes {}
@:keep @:image("Assets/heart2.png") @:noCompletion #if display private #end class __ASSET__assets_heart2_png extends lime.graphics.Image {}
@:keep @:image("Assets/BG.jpg") @:noCompletion #if display private #end class __ASSET__assets_bg_jpg extends lime.graphics.Image {}
@:keep @:file("") @:noCompletion #if display private #end class __ASSET__manifest_default_json extends haxe.io.Bytes {}



#else



#end

#if (openfl && !flash)

#if html5

#else

#end

#end
#end

#end
