(function ($hx_exports, $global) { "use strict"; var $hx_script = (function (exports, global) { // Generated by Haxe 4.1.5
(function ($hx_exports, $global) { "use strict";
$hx_exports["lime"] = $hx_exports["lime"] || {};
var $hxClasses = {},$estr = function() { return js_Boot.__string_rec(this,''); },$hxEnums = $hxEnums || {},$_;
function $extend(from, fields) {
	var proto = Object.create(from);
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var lime_app_IModule = function() { };
$hxClasses["lime.app.IModule"] = lime_app_IModule;
lime_app_IModule.__name__ = "lime.app.IModule";
lime_app_IModule.__isInterface__ = true;
lime_app_IModule.prototype = {
	__class__: lime_app_IModule
};
var lime_app_Module = function() {
	this.onExit = new lime_app__$Event_$Int_$Void();
};
$hxClasses["lime.app.Module"] = lime_app_Module;
lime_app_Module.__name__ = "lime.app.Module";
lime_app_Module.__interfaces__ = [lime_app_IModule];
lime_app_Module.prototype = {
	__registerLimeModule: function(application) {
	}
	,__unregisterLimeModule: function(application) {
	}
	,__class__: lime_app_Module
};
var lime__$internal_backend_html5_HTML5Application = function(parent) {
	this.gameDeviceCache = new haxe_ds_IntMap();
	this.parent = parent;
	this.currentUpdate = 0;
	this.lastUpdate = 0;
	this.nextUpdate = 0;
	this.framePeriod = -1;
	lime_media_AudioManager.init();
	this.accelerometer = lime_system_Sensor.registerSensor(lime_system_SensorType.ACCELEROMETER,0);
};
$hxClasses["lime._internal.backend.html5.HTML5Application"] = lime__$internal_backend_html5_HTML5Application;
lime__$internal_backend_html5_HTML5Application.__name__ = "lime._internal.backend.html5.HTML5Application";
lime__$internal_backend_html5_HTML5Application.prototype = {
	convertKeyCode: function(keyCode) {
		if(keyCode >= 65 && keyCode <= 90) {
			return keyCode + 32;
		}
		switch(keyCode) {
		case 12:
			return 1073741980;
		case 16:
			return 1073742049;
		case 17:
			return 1073742048;
		case 18:
			return 1073742050;
		case 19:
			return 1073741896;
		case 20:
			return 1073741881;
		case 33:
			return 1073741899;
		case 34:
			return 1073741902;
		case 35:
			return 1073741901;
		case 36:
			return 1073741898;
		case 37:
			return 1073741904;
		case 38:
			return 1073741906;
		case 39:
			return 1073741903;
		case 40:
			return 1073741905;
		case 41:
			return 1073741943;
		case 43:
			return 1073741940;
		case 44:
			return 1073741894;
		case 45:
			return 1073741897;
		case 46:
			return 127;
		case 91:
			return 1073742051;
		case 92:
			return 1073742055;
		case 93:
			return 1073742055;
		case 95:
			return 1073742106;
		case 96:
			return 1073741922;
		case 97:
			return 1073741913;
		case 98:
			return 1073741914;
		case 99:
			return 1073741915;
		case 100:
			return 1073741916;
		case 101:
			return 1073741917;
		case 102:
			return 1073741918;
		case 103:
			return 1073741919;
		case 104:
			return 1073741920;
		case 105:
			return 1073741921;
		case 106:
			return 1073741909;
		case 107:
			return 1073741911;
		case 108:
			return 1073741923;
		case 109:
			return 1073741910;
		case 110:
			return 1073741923;
		case 111:
			return 1073741908;
		case 112:
			return 1073741882;
		case 113:
			return 1073741883;
		case 114:
			return 1073741884;
		case 115:
			return 1073741885;
		case 116:
			return 1073741886;
		case 117:
			return 1073741887;
		case 118:
			return 1073741888;
		case 119:
			return 1073741889;
		case 120:
			return 1073741890;
		case 121:
			return 1073741891;
		case 122:
			return 1073741892;
		case 123:
			return 1073741893;
		case 124:
			return 1073741928;
		case 125:
			return 1073741929;
		case 126:
			return 1073741930;
		case 127:
			return 1073741931;
		case 128:
			return 1073741932;
		case 129:
			return 1073741933;
		case 130:
			return 1073741934;
		case 131:
			return 1073741935;
		case 132:
			return 1073741936;
		case 133:
			return 1073741937;
		case 134:
			return 1073741938;
		case 135:
			return 1073741939;
		case 144:
			return 1073741907;
		case 145:
			return 1073741895;
		case 160:
			return 94;
		case 161:
			return 33;
		case 163:
			return 35;
		case 164:
			return 36;
		case 166:
			return 1073742094;
		case 167:
			return 1073742095;
		case 168:
			return 1073742097;
		case 169:
			return 41;
		case 170:
			return 42;
		case 171:
			return 96;
		case 172:
			return 1073741898;
		case 173:
			return 45;
		case 174:
			return 1073741953;
		case 175:
			return 1073741952;
		case 176:
			return 1073742082;
		case 177:
			return 1073742083;
		case 178:
			return 1073742084;
		case 179:
			return 1073742085;
		case 180:
			return 1073742089;
		case 181:
			return 1073742086;
		case 182:
			return 1073741953;
		case 183:
			return 1073741952;
		case 186:
			return 59;
		case 187:
			return 61;
		case 188:
			return 44;
		case 189:
			return 45;
		case 190:
			return 46;
		case 191:
			return 47;
		case 192:
			return 96;
		case 193:
			return 63;
		case 194:
			return 1073741923;
		case 219:
			return 91;
		case 220:
			return 92;
		case 221:
			return 93;
		case 222:
			return 39;
		case 223:
			return 96;
		case 224:
			return 1073742051;
		case 226:
			return 92;
		}
		return keyCode;
	}
	,exec: function() {
		window.addEventListener("keydown",$bind(this,this.handleKeyEvent),false);
		window.addEventListener("keyup",$bind(this,this.handleKeyEvent),false);
		window.addEventListener("focus",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("blur",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("resize",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("beforeunload",$bind(this,this.handleWindowEvent),false);
		window.addEventListener("devicemotion",$bind(this,this.handleSensorEvent),false);
		
			if (!CanvasRenderingContext2D.prototype.isPointInStroke) {
				CanvasRenderingContext2D.prototype.isPointInStroke = function (path, x, y) {
					return false;
				};
			}
			if (!CanvasRenderingContext2D.prototype.isPointInPath) {
				CanvasRenderingContext2D.prototype.isPointInPath = function (path, x, y) {
					return false;
				};
			}

			if ('performance' in window == false) {
				window.performance = {};
			}

			if ('now' in window.performance == false) {
				var offset = Date.now();
				if (performance.timing && performance.timing.navigationStart) {
					offset = performance.timing.navigationStart
				}
				window.performance.now = function now() {
					return Date.now() - offset;
				}
			}

			var lastTime = 0;
			var vendors = ['ms', 'moz', 'webkit', 'o'];
			for (var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
				window.requestAnimationFrame = window[vendors[x]+'RequestAnimationFrame'];
				window.cancelAnimationFrame = window[vendors[x]+'CancelAnimationFrame'] || window[vendors[x]+'CancelRequestAnimationFrame'];
			}

			if (!window.requestAnimationFrame)
				window.requestAnimationFrame = function(callback, element) {
					var currTime = new Date().getTime();
					var timeToCall = Math.max(0, 16 - (currTime - lastTime));
					var id = window.setTimeout(function() { callback(currTime + timeToCall); },
					  timeToCall);
					lastTime = currTime + timeToCall;
					return id;
				};

			if (!window.cancelAnimationFrame)
				window.cancelAnimationFrame = function(id) {
					clearTimeout(id);
				};

			window.requestAnimFrame = window.requestAnimationFrame;
		;
		this.lastUpdate = new Date().getTime();
		this.handleApplicationEvent();
		return 0;
	}
	,exit: function() {
	}
	,handleApplicationEvent: function(__) {
		var _g = 0;
		var _g1 = this.parent.__windows;
		while(_g < _g1.length) {
			var $window = _g1[_g];
			++_g;
			$window.__backend.updateSize();
		}
		this.updateGameDevices();
		this.currentUpdate = new Date().getTime();
		if(this.currentUpdate >= this.nextUpdate) {
			this.deltaTime = this.currentUpdate - this.lastUpdate;
			var _g = 0;
			var _g1 = this.parent.__windows;
			while(_g < _g1.length) {
				var $window = _g1[_g];
				++_g;
				this.parent.onUpdate.dispatch(this.deltaTime | 0);
				if($window.context != null) {
					$window.onRender.dispatch($window.context);
				}
			}
			if(this.framePeriod < 0) {
				this.nextUpdate = this.currentUpdate;
			} else {
				this.nextUpdate = this.currentUpdate - this.currentUpdate % this.framePeriod + this.framePeriod;
			}
			this.lastUpdate = this.currentUpdate;
		}
		window.requestAnimationFrame($bind(this,this.handleApplicationEvent));
	}
	,handleKeyEvent: function(event) {
		if(this.parent.__window != null) {
			var keyCode = this.convertKeyCode(event.keyCode != null ? event.keyCode : event.which);
			var modifier = (event.shiftKey ? 3 : 0) | (event.ctrlKey ? 192 : 0) | (event.altKey ? 768 : 0) | (event.metaKey ? 3072 : 0);
			if(event.type == "keydown") {
				this.parent.__window.onKeyDown.dispatch(keyCode,modifier);
				if(this.parent.__window.onKeyDown.canceled && event.cancelable) {
					event.preventDefault();
				}
			} else {
				this.parent.__window.onKeyUp.dispatch(keyCode,modifier);
				if(this.parent.__window.onKeyUp.canceled && event.cancelable) {
					event.preventDefault();
				}
			}
		}
	}
	,handleSensorEvent: function(event) {
		this.accelerometer.onUpdate.dispatch(event.accelerationIncludingGravity.x,event.accelerationIncludingGravity.y,event.accelerationIncludingGravity.z);
	}
	,handleWindowEvent: function(event) {
		if(this.parent.__window != null) {
			switch(event.type) {
			case "beforeunload":
				break;
			case "blur":
				if(!this.hidden) {
					this.parent.__window.onFocusOut.dispatch();
					this.parent.__window.onDeactivate.dispatch();
					this.hidden = true;
				}
				break;
			case "focus":
				if(this.hidden) {
					this.parent.__window.onFocusIn.dispatch();
					this.parent.__window.onActivate.dispatch();
					this.hidden = false;
				}
				break;
			case "resize":
				this.parent.__window.__backend.handleResizeEvent(event);
				break;
			case "visibilitychange":
				if(window.document.hidden) {
					if(!this.hidden) {
						this.parent.__window.onFocusOut.dispatch();
						this.parent.__window.onDeactivate.dispatch();
						this.hidden = true;
					}
				} else if(this.hidden) {
					this.parent.__window.onFocusIn.dispatch();
					this.parent.__window.onActivate.dispatch();
					this.hidden = false;
				}
				break;
			}
		}
	}
	,updateGameDevices: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		if(devices == null) {
			return;
		}
		var id;
		var gamepad;
		var joystick;
		var data;
		var cache;
		var _g = 0;
		var _g1 = devices.length;
		while(_g < _g1) {
			var i = _g++;
			id = i;
			data = devices[id];
			if(data == null) {
				continue;
			}
			if(!this.gameDeviceCache.h.hasOwnProperty(id)) {
				cache = new lime__$internal_backend_html5_GameDeviceData();
				cache.id = id;
				cache.connected = data.connected;
				var _g2 = 0;
				var _g3 = data.buttons.length;
				while(_g2 < _g3) {
					var i1 = _g2++;
					cache.buttons.push(data.buttons[i1].value);
				}
				var _g4 = 0;
				var _g5 = data.axes.length;
				while(_g4 < _g5) {
					var i2 = _g4++;
					cache.axes.push(data.axes[i2]);
				}
				if(data.mapping == "standard") {
					cache.isGamepad = true;
				}
				this.gameDeviceCache.h[id] = cache;
				if(data.connected) {
					lime_ui_Joystick.__connect(id);
					if(cache.isGamepad) {
						lime_ui_Gamepad.__connect(id);
					}
				}
			}
			cache = this.gameDeviceCache.h[id];
			joystick = lime_ui_Joystick.devices.h[id];
			gamepad = lime_ui_Gamepad.devices.h[id];
			if(data.connected) {
				var button;
				var value;
				var _g6 = 0;
				var _g7 = data.buttons.length;
				while(_g6 < _g7) {
					var i3 = _g6++;
					value = data.buttons[i3].value;
					if(value != cache.buttons[i3]) {
						if(i3 == 6) {
							joystick.onAxisMove.dispatch(data.axes.length,value);
							if(gamepad != null) {
								gamepad.onAxisMove.dispatch(4,value);
							}
						} else if(i3 == 7) {
							joystick.onAxisMove.dispatch(data.axes.length + 1,value);
							if(gamepad != null) {
								gamepad.onAxisMove.dispatch(5,value);
							}
						} else {
							if(value > 0) {
								joystick.onButtonDown.dispatch(i3);
							} else {
								joystick.onButtonUp.dispatch(i3);
							}
							if(gamepad != null) {
								switch(i3) {
								case 0:
									button = 0;
									break;
								case 1:
									button = 1;
									break;
								case 2:
									button = 2;
									break;
								case 3:
									button = 3;
									break;
								case 4:
									button = 9;
									break;
								case 5:
									button = 10;
									break;
								case 8:
									button = 4;
									break;
								case 9:
									button = 6;
									break;
								case 10:
									button = 7;
									break;
								case 11:
									button = 8;
									break;
								case 12:
									button = 11;
									break;
								case 13:
									button = 12;
									break;
								case 14:
									button = 13;
									break;
								case 15:
									button = 14;
									break;
								case 16:
									button = 5;
									break;
								default:
									continue;
								}
								if(value > 0) {
									gamepad.onButtonDown.dispatch(button);
								} else {
									gamepad.onButtonUp.dispatch(button);
								}
							}
						}
						cache.buttons[i3] = value;
					}
				}
				var _g8 = 0;
				var _g9 = data.axes.length;
				while(_g8 < _g9) {
					var i4 = _g8++;
					if(data.axes[i4] != cache.axes[i4]) {
						joystick.onAxisMove.dispatch(i4,data.axes[i4]);
						if(gamepad != null) {
							gamepad.onAxisMove.dispatch(i4,data.axes[i4]);
						}
						cache.axes[i4] = data.axes[i4];
					}
				}
			} else if(cache.connected) {
				cache.connected = false;
				lime_ui_Joystick.__disconnect(id);
				lime_ui_Gamepad.__disconnect(id);
			}
		}
	}
	,__class__: lime__$internal_backend_html5_HTML5Application
};
var lime_app_Application = function() {
	this.onCreateWindow = new lime_app__$Event_$lime_$ui_$Window_$Void();
	this.onUpdate = new lime_app__$Event_$Int_$Void();
	lime_app_Module.call(this);
	if(lime_app_Application.current == null) {
		lime_app_Application.current = this;
	}
	this.meta = new haxe_ds_StringMap();
	this.modules = [];
	this.__windowByID = new haxe_ds_IntMap();
	this.__windows = [];
	this.__backend = new lime__$internal_backend_html5_HTML5Application(this);
	this.__registerLimeModule(this);
	this.__preloader = new lime_utils_Preloader();
	this.__preloader.onProgress.add($bind(this,this.onPreloadProgress));
	this.__preloader.onComplete.add($bind(this,this.onPreloadComplete));
};
$hxClasses["lime.app.Application"] = lime_app_Application;
lime_app_Application.__name__ = "lime.app.Application";
lime_app_Application.__super__ = lime_app_Module;
lime_app_Application.prototype = $extend(lime_app_Module.prototype,{
	addModule: function(module) {
		module.__registerLimeModule(this);
		this.modules.push(module);
	}
	,createWindow: function(attributes) {
		var $window = this.__createWindow(attributes);
		this.__addWindow($window);
		return $window;
	}
	,exec: function() {
		lime_app_Application.current = this;
		return this.__backend.exec();
	}
	,onGamepadAxisMove: function(gamepad,axis,value) {
	}
	,onGamepadButtonDown: function(gamepad,button) {
	}
	,onGamepadButtonUp: function(gamepad,button) {
	}
	,onGamepadConnect: function(gamepad) {
	}
	,onGamepadDisconnect: function(gamepad) {
	}
	,onJoystickAxisMove: function(joystick,axis,value) {
	}
	,onJoystickButtonDown: function(joystick,button) {
	}
	,onJoystickButtonUp: function(joystick,button) {
	}
	,onJoystickConnect: function(joystick) {
	}
	,onJoystickDisconnect: function(joystick) {
	}
	,onJoystickHatMove: function(joystick,hat,position) {
	}
	,onJoystickTrackballMove: function(joystick,trackball,x,y) {
	}
	,onKeyDown: function(keyCode,modifier) {
	}
	,onKeyUp: function(keyCode,modifier) {
	}
	,onModuleExit: function(code) {
	}
	,onMouseDown: function(x,y,button) {
	}
	,onMouseMove: function(x,y) {
	}
	,onMouseMoveRelative: function(x,y) {
	}
	,onMouseUp: function(x,y,button) {
	}
	,onMouseWheel: function(deltaX,deltaY,deltaMode) {
	}
	,onPreloadComplete: function() {
	}
	,onPreloadProgress: function(loaded,total) {
	}
	,onRenderContextLost: function() {
	}
	,onRenderContextRestored: function(context) {
	}
	,onTextEdit: function(text,start,length) {
	}
	,onTextInput: function(text) {
	}
	,onTouchCancel: function(touch) {
	}
	,onTouchEnd: function(touch) {
	}
	,onTouchMove: function(touch) {
	}
	,onTouchStart: function(touch) {
	}
	,onWindowActivate: function() {
	}
	,onWindowClose: function() {
	}
	,onWindowCreate: function() {
	}
	,onWindowDeactivate: function() {
	}
	,onWindowDropFile: function(file) {
	}
	,onWindowEnter: function() {
	}
	,onWindowExpose: function() {
	}
	,onWindowFocusIn: function() {
	}
	,onWindowFocusOut: function() {
	}
	,onWindowFullscreen: function() {
	}
	,onWindowLeave: function() {
	}
	,onWindowMove: function(x,y) {
	}
	,onWindowMinimize: function() {
	}
	,onWindowResize: function(width,height) {
	}
	,onWindowRestore: function() {
	}
	,removeModule: function(module) {
		if(module != null) {
			module.__unregisterLimeModule(this);
			HxOverrides.remove(this.modules,module);
		}
	}
	,render: function(context) {
	}
	,update: function(deltaTime) {
	}
	,__addWindow: function($window) {
		if($window != null) {
			this.__windows.push($window);
			this.__windowByID.h[$window.id] = $window;
			var _g = $bind(this,this.__onWindowClose);
			var window1 = $window;
			var tmp = function() {
				_g(window1);
			};
			$window.onClose.add(tmp,false,-10000);
			if(this.__window == null) {
				this.__window = $window;
				$window.onActivate.add($bind(this,this.onWindowActivate));
				$window.onRenderContextLost.add($bind(this,this.onRenderContextLost));
				$window.onRenderContextRestored.add($bind(this,this.onRenderContextRestored));
				$window.onDeactivate.add($bind(this,this.onWindowDeactivate));
				$window.onDropFile.add($bind(this,this.onWindowDropFile));
				$window.onEnter.add($bind(this,this.onWindowEnter));
				$window.onExpose.add($bind(this,this.onWindowExpose));
				$window.onFocusIn.add($bind(this,this.onWindowFocusIn));
				$window.onFocusOut.add($bind(this,this.onWindowFocusOut));
				$window.onFullscreen.add($bind(this,this.onWindowFullscreen));
				$window.onKeyDown.add($bind(this,this.onKeyDown));
				$window.onKeyUp.add($bind(this,this.onKeyUp));
				$window.onLeave.add($bind(this,this.onWindowLeave));
				$window.onMinimize.add($bind(this,this.onWindowMinimize));
				$window.onMouseDown.add($bind(this,this.onMouseDown));
				$window.onMouseMove.add($bind(this,this.onMouseMove));
				$window.onMouseMoveRelative.add($bind(this,this.onMouseMoveRelative));
				$window.onMouseUp.add($bind(this,this.onMouseUp));
				$window.onMouseWheel.add($bind(this,this.onMouseWheel));
				$window.onMove.add($bind(this,this.onWindowMove));
				$window.onRender.add($bind(this,this.render));
				$window.onResize.add($bind(this,this.onWindowResize));
				$window.onRestore.add($bind(this,this.onWindowRestore));
				$window.onTextEdit.add($bind(this,this.onTextEdit));
				$window.onTextInput.add($bind(this,this.onTextInput));
				this.onWindowCreate();
			}
			this.onCreateWindow.dispatch($window);
		}
	}
	,__createWindow: function(attributes) {
		var $window = new lime_ui_Window(this,attributes);
		if($window.id == -1) {
			return null;
		}
		return $window;
	}
	,__registerLimeModule: function(application) {
		application.onUpdate.add($bind(this,this.update));
		application.onExit.add($bind(this,this.onModuleExit),false,0);
		application.onExit.add($bind(this,this.__onModuleExit),false,0);
		var gamepad = lime_ui_Gamepad.devices.iterator();
		while(gamepad.hasNext()) {
			var gamepad1 = gamepad.next();
			this.__onGamepadConnect(gamepad1);
		}
		lime_ui_Gamepad.onConnect.add($bind(this,this.__onGamepadConnect));
		var joystick = lime_ui_Joystick.devices.iterator();
		while(joystick.hasNext()) {
			var joystick1 = joystick.next();
			this.__onJoystickConnect(joystick1);
		}
		lime_ui_Joystick.onConnect.add($bind(this,this.__onJoystickConnect));
		lime_ui_Touch.onCancel.add($bind(this,this.onTouchCancel));
		lime_ui_Touch.onStart.add($bind(this,this.onTouchStart));
		lime_ui_Touch.onMove.add($bind(this,this.onTouchMove));
		lime_ui_Touch.onEnd.add($bind(this,this.onTouchEnd));
	}
	,__removeWindow: function($window) {
		if($window != null && this.__windowByID.h.hasOwnProperty($window.id)) {
			if(this.__window == $window) {
				this.__window = null;
			}
			HxOverrides.remove(this.__windows,$window);
			this.__windowByID.remove($window.id);
			$window.close();
			if(this.__windows.length == 0) {
				lime_system_System.exit(0);
			}
		}
	}
	,__onGamepadConnect: function(gamepad) {
		this.onGamepadConnect(gamepad);
		var _g = $bind(this,this.onGamepadAxisMove);
		var gamepad1 = gamepad;
		var tmp = function(axis,value) {
			_g(gamepad1,axis,value);
		};
		gamepad.onAxisMove.add(tmp);
		var _g1 = $bind(this,this.onGamepadButtonDown);
		var gamepad2 = gamepad;
		var tmp = function(button) {
			_g1(gamepad2,button);
		};
		gamepad.onButtonDown.add(tmp);
		var _g2 = $bind(this,this.onGamepadButtonUp);
		var gamepad3 = gamepad;
		var tmp = function(button) {
			_g2(gamepad3,button);
		};
		gamepad.onButtonUp.add(tmp);
		var _g3 = $bind(this,this.onGamepadDisconnect);
		var gamepad4 = gamepad;
		var tmp = function() {
			_g3(gamepad4);
		};
		gamepad.onDisconnect.add(tmp);
	}
	,__onJoystickConnect: function(joystick) {
		this.onJoystickConnect(joystick);
		var _g = $bind(this,this.onJoystickAxisMove);
		var joystick1 = joystick;
		var tmp = function(axis,value) {
			_g(joystick1,axis,value);
		};
		joystick.onAxisMove.add(tmp);
		var _g1 = $bind(this,this.onJoystickButtonDown);
		var joystick2 = joystick;
		var tmp = function(button) {
			_g1(joystick2,button);
		};
		joystick.onButtonDown.add(tmp);
		var _g2 = $bind(this,this.onJoystickButtonUp);
		var joystick3 = joystick;
		var tmp = function(button) {
			_g2(joystick3,button);
		};
		joystick.onButtonUp.add(tmp);
		var _g3 = $bind(this,this.onJoystickDisconnect);
		var joystick4 = joystick;
		var tmp = function() {
			_g3(joystick4);
		};
		joystick.onDisconnect.add(tmp);
		var _g4 = $bind(this,this.onJoystickHatMove);
		var joystick5 = joystick;
		var tmp = function(hat,position) {
			_g4(joystick5,hat,position);
		};
		joystick.onHatMove.add(tmp);
		var _g5 = $bind(this,this.onJoystickTrackballMove);
		var joystick6 = joystick;
		var tmp = function(trackball,x,y) {
			_g5(joystick6,trackball,x,y);
		};
		joystick.onTrackballMove.add(tmp);
	}
	,__onModuleExit: function(code) {
		this.__backend.exit();
	}
	,__onWindowClose: function($window) {
		if(this.__window == $window) {
			this.onWindowClose();
		}
		this.__removeWindow($window);
	}
	,__unregisterLimeModule: function(application) {
		application.onUpdate.remove($bind(this,this.update));
		application.onExit.remove($bind(this,this.__onModuleExit));
		application.onExit.remove($bind(this,this.onModuleExit));
		lime_ui_Gamepad.onConnect.remove($bind(this,this.__onGamepadConnect));
		lime_ui_Joystick.onConnect.remove($bind(this,this.__onJoystickConnect));
		lime_ui_Touch.onCancel.remove($bind(this,this.onTouchCancel));
		lime_ui_Touch.onStart.remove($bind(this,this.onTouchStart));
		lime_ui_Touch.onMove.remove($bind(this,this.onTouchMove));
		lime_ui_Touch.onEnd.remove($bind(this,this.onTouchEnd));
		this.onModuleExit(0);
	}
	,get_preloader: function() {
		return this.__preloader;
	}
	,get_window: function() {
		return this.__window;
	}
	,get_windows: function() {
		return this.__windows;
	}
	,__class__: lime_app_Application
	,__properties__: {get_windows:"get_windows",get_window:"get_window",get_preloader:"get_preloader"}
});
var ApplicationMain = function() { };
$hxClasses["ApplicationMain"] = ApplicationMain;
ApplicationMain.__name__ = "ApplicationMain";
ApplicationMain.main = function() {
	lime_system_System.__registerEntryPoint("Obgame05",ApplicationMain.create);
};
ApplicationMain.create = function(config) {
	var app = new openfl_display_Application();
	ManifestResources.init(config);
	app.meta.h["build"] = "197";
	app.meta.h["company"] = "Company Name";
	app.meta.h["file"] = "Obgame05";
	app.meta.h["name"] = "Obgame05";
	app.meta.h["packageName"] = "com.sample.obgame05";
	app.meta.h["version"] = "1.0.0";
	var attributes = { allowHighDPI : false, alwaysOnTop : false, borderless : false, element : null, frameRate : 60, height : 0, hidden : false, maximized : false, minimized : false, parameters : { }, resizable : true, title : "Obgame05", width : 0, x : null, y : null};
	attributes.context = { antialiasing : 0, background : 16777215, colorDepth : 32, depth : true, hardware : true, stencil : true, type : null, vsync : false};
	if(app.__window == null) {
		if(config != null) {
			var _g = 0;
			var _g1 = Reflect.fields(config);
			while(_g < _g1.length) {
				var field = _g1[_g];
				++_g;
				if(Object.prototype.hasOwnProperty.call(attributes,field)) {
					attributes[field] = Reflect.field(config,field);
				} else if(Object.prototype.hasOwnProperty.call(attributes.context,field)) {
					attributes.context[field] = Reflect.field(config,field);
				}
			}
		}
	}
	app.createWindow(attributes);
	var preloader = new openfl_display_Preloader(new openfl_display_DefaultPreloader());
	app.__preloader.onProgress.add(function(loaded,total) {
		preloader.update(loaded,total);
	});
	app.__preloader.onComplete.add(function() {
		preloader.start();
	});
	var stage = app.__window.stage;
	var tmp = function() {
		ApplicationMain.start(stage);
	};
	preloader.onComplete.add(tmp);
	var _g = 0;
	var _g1 = ManifestResources.preloadLibraries;
	while(_g < _g1.length) {
		var library = _g1[_g];
		++_g;
		app.__preloader.addLibrary(library);
	}
	var _g = 0;
	var _g1 = ManifestResources.preloadLibraryNames;
	while(_g < _g1.length) {
		var name = _g1[_g];
		++_g;
		app.__preloader.addLibraryName(name);
	}
	app.__preloader.load();
	var result = app.exec();
};
ApplicationMain.start = function(stage) {
	try {
		var current = stage.getChildAt(0);
		if(current == null || !((current) instanceof openfl_display_DisplayObjectContainer)) {
			current = new openfl_display_MovieClip();
			stage.addChild(current);
		}
		new DocumentClass(current);
		stage.dispatchEvent(new openfl_events_Event("resize",false,false));
		if(stage.window.__fullscreen) {
			stage.dispatchEvent(new openfl_events_FullScreenEvent("fullScreen",false,false,true,true));
		}
	} catch( _g ) {
		haxe_NativeStackTrace.lastError = _g;
		var e = haxe_Exception.caught(_g).unwrap();
		stage.__handleError(e);
	}
};
var openfl_events_IEventDispatcher = function() { };
$hxClasses["openfl.events.IEventDispatcher"] = openfl_events_IEventDispatcher;
openfl_events_IEventDispatcher.__name__ = "openfl.events.IEventDispatcher";
openfl_events_IEventDispatcher.__isInterface__ = true;
openfl_events_IEventDispatcher.prototype = {
	__class__: openfl_events_IEventDispatcher
};
var openfl_events_EventDispatcher = function(target) {
	if(target != null) {
		this.__targetDispatcher = target;
	}
};
$hxClasses["openfl.events.EventDispatcher"] = openfl_events_EventDispatcher;
openfl_events_EventDispatcher.__name__ = "openfl.events.EventDispatcher";
openfl_events_EventDispatcher.__interfaces__ = [openfl_events_IEventDispatcher];
openfl_events_EventDispatcher.prototype = {
	addEventListener: function(type,listener,useCapture,priority,useWeakReference) {
		if(useWeakReference == null) {
			useWeakReference = false;
		}
		if(priority == null) {
			priority = 0;
		}
		if(useCapture == null) {
			useCapture = false;
		}
		if(listener == null) {
			return;
		}
		if(this.__eventMap == null) {
			this.__eventMap = new haxe_ds_StringMap();
			this.__iterators = new haxe_ds_StringMap();
		}
		if(!Object.prototype.hasOwnProperty.call(this.__eventMap.h,type)) {
			var list = [];
			list.push(new openfl_events__$EventDispatcher_Listener(listener,useCapture,priority));
			var iterator = new openfl_events__$EventDispatcher_DispatchIterator(list);
			this.__eventMap.h[type] = list;
			this.__iterators.h[type] = [iterator];
		} else {
			var list = this.__eventMap.h[type];
			var _g = 0;
			var _g1 = list.length;
			while(_g < _g1) {
				var i = _g++;
				if(list[i].match(listener,useCapture)) {
					return;
				}
			}
			var iterators = this.__iterators.h[type];
			var _g = 0;
			while(_g < iterators.length) {
				var iterator = iterators[_g];
				++_g;
				if(iterator.active) {
					iterator.copy();
				}
			}
			this.__addListenerByPriority(list,new openfl_events__$EventDispatcher_Listener(listener,useCapture,priority));
		}
	}
	,dispatchEvent: function(event) {
		if(this.__targetDispatcher != null) {
			event.target = this.__targetDispatcher;
		} else {
			event.target = this;
		}
		return this.__dispatchEvent(event);
	}
	,hasEventListener: function(type) {
		if(this.__eventMap == null) {
			return false;
		}
		return Object.prototype.hasOwnProperty.call(this.__eventMap.h,type);
	}
	,removeEventListener: function(type,listener,useCapture) {
		if(useCapture == null) {
			useCapture = false;
		}
		if(this.__eventMap == null || listener == null) {
			return;
		}
		var list = this.__eventMap.h[type];
		if(list == null) {
			return;
		}
		var iterators = this.__iterators.h[type];
		var _g = 0;
		var _g1 = list.length;
		while(_g < _g1) {
			var i = _g++;
			if(list[i].match(listener,useCapture)) {
				var _g2 = 0;
				while(_g2 < iterators.length) {
					var iterator = iterators[_g2];
					++_g2;
					iterator.remove(list[i],i);
				}
				list.splice(i,1);
				break;
			}
		}
		if(list.length == 0) {
			var _this = this.__eventMap;
			if(Object.prototype.hasOwnProperty.call(_this.h,type)) {
				delete(_this.h[type]);
			}
			var _this = this.__iterators;
			if(Object.prototype.hasOwnProperty.call(_this.h,type)) {
				delete(_this.h[type]);
			}
		}
		if(!haxe_ds_StringMap.valueIterator(this.__eventMap.h).hasNext()) {
			this.__eventMap = null;
			this.__iterators = null;
		}
	}
	,toString: function() {
		var c = js_Boot.getClass(this);
		var full = c.__name__;
		var short = full.split(".").pop();
		return "[object " + short + "]";
	}
	,willTrigger: function(type) {
		return this.hasEventListener(type);
	}
	,__dispatchEvent: function(event) {
		if(this.__eventMap == null || event == null) {
			return true;
		}
		var type = event.type;
		var list = this.__eventMap.h[type];
		if(list == null) {
			return true;
		}
		if(event.target == null) {
			if(this.__targetDispatcher != null) {
				event.target = this.__targetDispatcher;
			} else {
				event.target = this;
			}
		}
		event.currentTarget = this;
		var capture = event.eventPhase == 1;
		var iterators = this.__iterators.h[type];
		var iterator = iterators[0];
		if(iterator.active) {
			iterator = new openfl_events__$EventDispatcher_DispatchIterator(list);
			iterators.push(iterator);
		}
		iterator.start();
		var listener = iterator;
		while(listener.hasNext()) {
			var listener1 = listener.next();
			if(listener1 == null) {
				continue;
			}
			if(listener1.useCapture == capture) {
				listener1.callback(event);
				if(event.__isCanceledNow) {
					break;
				}
			}
		}
		iterator.stop();
		if(iterator != iterators[0]) {
			HxOverrides.remove(iterators,iterator);
		} else {
			iterator.reset(list);
		}
		return !event.isDefaultPrevented();
	}
	,__removeAllListeners: function() {
		this.__eventMap = null;
		this.__iterators = null;
	}
	,__addListenerByPriority: function(list,listener) {
		var numElements = list.length;
		var addAtPosition = numElements;
		var _g = 0;
		var _g1 = numElements;
		while(_g < _g1) {
			var i = _g++;
			if(list[i].priority < listener.priority) {
				addAtPosition = i;
				break;
			}
		}
		list.splice(addAtPosition,0,listener);
	}
	,__class__: openfl_events_EventDispatcher
};
var openfl_display_IBitmapDrawable = function() { };
$hxClasses["openfl.display.IBitmapDrawable"] = openfl_display_IBitmapDrawable;
openfl_display_IBitmapDrawable.__name__ = "openfl.display.IBitmapDrawable";
openfl_display_IBitmapDrawable.__isInterface__ = true;
openfl_display_IBitmapDrawable.prototype = {
	__class__: openfl_display_IBitmapDrawable
};
var openfl_Vector = {};
openfl_Vector.__properties__ = {set_length:"set_length",get_length:"get_length",set_fixed:"set_fixed",get_fixed:"get_fixed"};
openfl_Vector.concat = function(this1,vec) {
	return this1.concat(vec);
};
openfl_Vector.copy = function(this1) {
	return this1.copy();
};
openfl_Vector.filter = function(this1,callback) {
	return this1.filter(callback);
};
openfl_Vector.get = function(this1,index) {
	return this1.get(index);
};
openfl_Vector.indexOf = function(this1,searchElement,fromIndex) {
	if(fromIndex == null) {
		fromIndex = 0;
	}
	return this1.indexOf(searchElement,fromIndex);
};
openfl_Vector.insertAt = function(this1,index,element) {
	this1.insertAt(index,element);
};
openfl_Vector.iterator = function(this1) {
	return this1.iterator();
};
openfl_Vector.join = function(this1,sep) {
	if(sep == null) {
		sep = ",";
	}
	return this1.join(sep);
};
openfl_Vector.lastIndexOf = function(this1,searchElement,fromIndex) {
	return this1.lastIndexOf(searchElement,fromIndex);
};
openfl_Vector.pop = function(this1) {
	return this1.pop();
};
openfl_Vector.push = function(this1,value) {
	return this1.push(value);
};
openfl_Vector.removeAt = function(this1,index) {
	return this1.removeAt(index);
};
openfl_Vector.reverse = function(this1) {
	return this1.reverse();
};
openfl_Vector.set = function(this1,index,value) {
	return this1.set(index,value);
};
openfl_Vector.shift = function(this1) {
	return this1.shift();
};
openfl_Vector.slice = function(this1,startIndex,endIndex) {
	if(startIndex == null) {
		startIndex = 0;
	}
	return this1.slice(startIndex,endIndex);
};
openfl_Vector.sort = function(this1,sortBehavior) {
	this1.sort(sortBehavior);
};
openfl_Vector.splice = function(this1,startIndex,deleteCount) {
	return this1.splice(startIndex,deleteCount);
};
openfl_Vector.toString = function(this1) {
	if(this1 != null) {
		return this1.toString();
	} else {
		return null;
	}
};
openfl_Vector.unshift = function(this1,value) {
	this1.unshift(value);
};
openfl_Vector.convert = function(vec) {
	return vec;
};
openfl_Vector.toBoolVector = function(t,length,fixed,array) {
	return new openfl__$Vector_BoolVector(length,fixed,array);
};
openfl_Vector.toIntVector = function(t,length,fixed,array) {
	return new openfl__$Vector_IntVector(length,fixed,array);
};
openfl_Vector.toFloatVector = function(t,length,fixed,array) {
	return new openfl__$Vector_FloatVector(length,fixed,array,true);
};
openfl_Vector.toFunctionVector = function(t,length,fixed,array) {
	return new openfl__$Vector_FunctionVector(length,fixed,array);
};
openfl_Vector.toObjectVector = function(t,length,fixed,array) {
	return new openfl__$Vector_ObjectVector(length,fixed,array,true);
};
openfl_Vector.toNullVector = function(t,length,fixed,array) {
	return new openfl__$Vector_ObjectVector(length,fixed,array,true);
};
openfl_Vector.fromBoolVector = function(vector) {
	return vector;
};
openfl_Vector.fromIntVector = function(vector) {
	return vector;
};
openfl_Vector.fromFloatVector = function(vector) {
	return vector;
};
openfl_Vector.fromFunctionVector = function(vector) {
	return vector;
};
openfl_Vector.fromObjectVector = function(vector) {
	return vector;
};
openfl_Vector.get_fixed = function(this1) {
	return this1.fixed;
};
openfl_Vector.set_fixed = function(this1,value) {
	return this1.fixed = value;
};
openfl_Vector.get_length = function(this1) {
	return this1.get_length();
};
openfl_Vector.set_length = function(this1,value) {
	return this1.set_length(value);
};
var lime_utils_ObjectPool = function(create,clean,size) {
	this.__pool = new haxe_ds_ObjectMap();
	this.activeObjects = 0;
	this.inactiveObjects = 0;
	this.__inactiveObject0 = null;
	this.__inactiveObject1 = null;
	this.__inactiveObjectList = new haxe_ds_List();
	if(create != null) {
		this.create = create;
	}
	if(clean != null) {
		this.clean = clean;
	}
	if(size != null) {
		this.set_size(size);
	}
};
$hxClasses["lime.utils.ObjectPool"] = lime_utils_ObjectPool;
lime_utils_ObjectPool.__name__ = "lime.utils.ObjectPool";
lime_utils_ObjectPool.prototype = {
	add: function(object) {
		if(!this.__pool.exists(object)) {
			this.__pool.set(object,false);
			this.clean(object);
			if(this.__inactiveObject0 == null) {
				this.__inactiveObject0 = object;
			} else if(this.__inactiveObject1 == null) {
				this.__inactiveObject1 = object;
			} else {
				this.__inactiveObjectList.add(object);
			}
			this.inactiveObjects++;
		}
	}
	,clean: function(object) {
	}
	,clear: function() {
		this.__pool = new haxe_ds_ObjectMap();
		this.activeObjects = 0;
		this.inactiveObjects = 0;
		this.__inactiveObject0 = null;
		this.__inactiveObject1 = null;
		this.__inactiveObjectList.clear();
	}
	,create: function() {
		return null;
	}
	,get: function() {
		var object = null;
		if(this.inactiveObjects > 0) {
			var object1 = null;
			if(this.__inactiveObject0 != null) {
				object1 = this.__inactiveObject0;
				this.__inactiveObject0 = null;
			} else if(this.__inactiveObject1 != null) {
				object1 = this.__inactiveObject1;
				this.__inactiveObject1 = null;
			} else {
				object1 = this.__inactiveObjectList.pop();
				if(this.__inactiveObjectList.length > 0) {
					this.__inactiveObject0 = this.__inactiveObjectList.pop();
				}
				if(this.__inactiveObjectList.length > 0) {
					this.__inactiveObject1 = this.__inactiveObjectList.pop();
				}
			}
			this.inactiveObjects--;
			this.activeObjects++;
			object = object1;
		} else if(this.__size == null || this.activeObjects < this.__size) {
			object = this.create();
			if(object != null) {
				this.__pool.set(object,true);
				this.activeObjects++;
			}
		}
		return object;
	}
	,release: function(object) {
		this.activeObjects--;
		if(this.__size == null || this.activeObjects + this.inactiveObjects < this.__size) {
			this.clean(object);
			if(this.__inactiveObject0 == null) {
				this.__inactiveObject0 = object;
			} else if(this.__inactiveObject1 == null) {
				this.__inactiveObject1 = object;
			} else {
				this.__inactiveObjectList.add(object);
			}
			this.inactiveObjects++;
		} else {
			this.__pool.remove(object);
		}
	}
	,remove: function(object) {
		if(this.__pool.exists(object)) {
			this.__pool.remove(object);
			if(this.__inactiveObject0 == object) {
				this.__inactiveObject0 = null;
				this.inactiveObjects--;
			} else if(this.__inactiveObject1 == object) {
				this.__inactiveObject1 = null;
				this.inactiveObjects--;
			} else if(this.__inactiveObjectList.remove(object)) {
				this.inactiveObjects--;
			} else {
				this.activeObjects--;
			}
		}
	}
	,__addInactive: function(object) {
		if(this.__inactiveObject0 == null) {
			this.__inactiveObject0 = object;
		} else if(this.__inactiveObject1 == null) {
			this.__inactiveObject1 = object;
		} else {
			this.__inactiveObjectList.add(object);
		}
		this.inactiveObjects++;
	}
	,__getInactive: function() {
		var object = null;
		if(this.__inactiveObject0 != null) {
			object = this.__inactiveObject0;
			this.__inactiveObject0 = null;
		} else if(this.__inactiveObject1 != null) {
			object = this.__inactiveObject1;
			this.__inactiveObject1 = null;
		} else {
			object = this.__inactiveObjectList.pop();
			if(this.__inactiveObjectList.length > 0) {
				this.__inactiveObject0 = this.__inactiveObjectList.pop();
			}
			if(this.__inactiveObjectList.length > 0) {
				this.__inactiveObject1 = this.__inactiveObjectList.pop();
			}
		}
		this.inactiveObjects--;
		this.activeObjects++;
		return object;
	}
	,__removeInactive: function(count) {
		if(count <= 0 || this.inactiveObjects == 0) {
			return;
		}
		if(this.__inactiveObject0 != null) {
			this.__pool.remove(this.__inactiveObject0);
			this.__inactiveObject0 = null;
			this.inactiveObjects--;
			--count;
		}
		if(count == 0 || this.inactiveObjects == 0) {
			return;
		}
		if(this.__inactiveObject1 != null) {
			this.__pool.remove(this.__inactiveObject1);
			this.__inactiveObject1 = null;
			this.inactiveObjects--;
			--count;
		}
		if(count == 0 || this.inactiveObjects == 0) {
			return;
		}
		var _g_head = this.__inactiveObjectList.h;
		while(_g_head != null) {
			var val = _g_head.item;
			_g_head = _g_head.next;
			var object = val;
			this.__pool.remove(object);
			this.__inactiveObjectList.remove(object);
			this.inactiveObjects--;
			--count;
			if(count == 0 || this.inactiveObjects == 0) {
				return;
			}
		}
	}
	,get_size: function() {
		return this.__size;
	}
	,set_size: function(value) {
		if(value == null) {
			this.__size = null;
		} else {
			var current = this.inactiveObjects + this.activeObjects;
			this.__size = value;
			if(current > value) {
				this.__removeInactive(current - value);
			} else if(value > current) {
				var object;
				var _g = 0;
				var _g1 = value - current;
				while(_g < _g1) {
					var i = _g++;
					object = this.create();
					if(object != null) {
						this.__pool.set(object,false);
						this.__inactiveObjectList.add(object);
						this.inactiveObjects++;
					} else {
						break;
					}
				}
			}
		}
		return value;
	}
	,__class__: lime_utils_ObjectPool
	,__properties__: {set_size:"set_size",get_size:"get_size"}
};
var haxe_IMap = function() { };
$hxClasses["haxe.IMap"] = haxe_IMap;
haxe_IMap.__name__ = "haxe.IMap";
haxe_IMap.__isInterface__ = true;
haxe_IMap.prototype = {
	__class__: haxe_IMap
};
var haxe_ds_ObjectMap = function() {
	this.h = { __keys__ : { }};
};
$hxClasses["haxe.ds.ObjectMap"] = haxe_ds_ObjectMap;
haxe_ds_ObjectMap.__name__ = "haxe.ds.ObjectMap";
haxe_ds_ObjectMap.__interfaces__ = [haxe_IMap];
haxe_ds_ObjectMap.prototype = {
	set: function(key,value) {
		var id = key.__id__;
		if(id == null) {
			id = (key.__id__ = $global.$haxeUID++);
		}
		this.h[id] = value;
		this.h.__keys__[id] = key;
	}
	,get: function(key) {
		return this.h[key.__id__];
	}
	,exists: function(key) {
		return this.h.__keys__[key.__id__] != null;
	}
	,remove: function(key) {
		var id = key.__id__;
		if(this.h.__keys__[id] == null) {
			return false;
		}
		delete(this.h[id]);
		delete(this.h.__keys__[id]);
		return true;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h.__keys__ ) {
		if(this.h.hasOwnProperty(key)) {
			a.push(this.h.__keys__[key]);
		}
		}
		return new haxe_iterators_ArrayIterator(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i.__id__];
		}};
	}
	,keyValueIterator: function() {
		return new haxe_iterators_MapKeyValueIterator(this);
	}
	,toString: function() {
		var s_b = "";
		s_b += "{";
		var it = this.keys();
		var i = it;
		while(i.hasNext()) {
			var i1 = i.next();
			s_b += Std.string(Std.string(i1));
			s_b += " => ";
			s_b += Std.string(Std.string(this.h[i1.__id__]));
			if(it.hasNext()) {
				s_b += ", ";
			}
		}
		s_b += "}";
		return s_b;
	}
	,__class__: haxe_ds_ObjectMap
};
var haxe_ds_List = function() {
	this.length = 0;
};
$hxClasses["haxe.ds.List"] = haxe_ds_List;
haxe_ds_List.__name__ = "haxe.ds.List";
haxe_ds_List.prototype = {
	add: function(item) {
		var x = new haxe_ds__$List_ListNode(item,null);
		if(this.h == null) {
			this.h = x;
		} else {
			this.q.next = x;
		}
		this.q = x;
		this.length++;
	}
	,push: function(item) {
		var x = new haxe_ds__$List_ListNode(item,this.h);
		this.h = x;
		if(this.q == null) {
			this.q = x;
		}
		this.length++;
	}
	,pop: function() {
		if(this.h == null) {
			return null;
		}
		var x = this.h.item;
		this.h = this.h.next;
		if(this.h == null) {
			this.q = null;
		}
		this.length--;
		return x;
	}
	,clear: function() {
		this.h = null;
		this.q = null;
		this.length = 0;
	}
	,remove: function(v) {
		var prev = null;
		var l = this.h;
		while(l != null) {
			if(l.item == v) {
				if(prev == null) {
					this.h = l.next;
				} else {
					prev.next = l.next;
				}
				if(this.q == l) {
					this.q = prev;
				}
				this.length--;
				return true;
			}
			prev = l;
			l = l.next;
		}
		return false;
	}
	,iterator: function() {
		return new haxe_ds__$List_ListIterator(this.h);
	}
	,__class__: haxe_ds_List
};
var openfl_display_DisplayObject = function() {
	openfl_events_EventDispatcher.call(this);
	this.__drawableType = 1;
	this.__alpha = 1;
	this.__blendMode = 10;
	this.__cacheAsBitmap = false;
	this.__transform = new openfl_geom_Matrix();
	this.__visible = true;
	this.__rotation = 0;
	this.__rotationSine = 0;
	this.__rotationCosine = 1;
	this.__scaleX = 1;
	this.__scaleY = 1;
	this.__worldAlpha = 1;
	this.__worldBlendMode = 10;
	this.__worldTransform = new openfl_geom_Matrix();
	this.__worldColorTransform = new openfl_geom_ColorTransform();
	this.__renderTransform = new openfl_geom_Matrix();
	this.__worldVisible = true;
	this.set_name("instance" + ++openfl_display_DisplayObject.__instanceCount);
	if(openfl_display_DisplayObject.__initStage != null) {
		this.stage = openfl_display_DisplayObject.__initStage;
		openfl_display_DisplayObject.__initStage = null;
		this.stage.addChild(this);
	}
};
$hxClasses["openfl.display.DisplayObject"] = openfl_display_DisplayObject;
openfl_display_DisplayObject.__name__ = "openfl.display.DisplayObject";
openfl_display_DisplayObject.__interfaces__ = [openfl_display_IBitmapDrawable];
openfl_display_DisplayObject.__calculateAbsoluteTransform = function(local,parentTransform,target) {
	target.a = local.a * parentTransform.a + local.b * parentTransform.c;
	target.b = local.a * parentTransform.b + local.b * parentTransform.d;
	target.c = local.c * parentTransform.a + local.d * parentTransform.c;
	target.d = local.c * parentTransform.b + local.d * parentTransform.d;
	target.tx = local.tx * parentTransform.a + local.ty * parentTransform.c + parentTransform.tx;
	target.ty = local.tx * parentTransform.b + local.ty * parentTransform.d + parentTransform.ty;
};
openfl_display_DisplayObject.__super__ = openfl_events_EventDispatcher;
openfl_display_DisplayObject.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	addEventListener: function(type,listener,useCapture,priority,useWeakReference) {
		if(useWeakReference == null) {
			useWeakReference = false;
		}
		if(priority == null) {
			priority = 0;
		}
		if(useCapture == null) {
			useCapture = false;
		}
		switch(type) {
		case "activate":case "deactivate":case "enterFrame":case "exitFrame":case "frameConstructed":case "render":
			if(!Object.prototype.hasOwnProperty.call(openfl_display_DisplayObject.__broadcastEvents.h,type)) {
				openfl_display_DisplayObject.__broadcastEvents.h[type] = [];
			}
			var dispatchers = openfl_display_DisplayObject.__broadcastEvents.h[type];
			if(dispatchers.indexOf(this) == -1) {
				dispatchers.push(this);
			}
			break;
		case "clearDOM":case "renderCairo":case "renderCanvas":case "renderDOM":case "renderOpenGL":
			if(this.__customRenderEvent == null) {
				this.__customRenderEvent = new openfl_events_RenderEvent(null);
				this.__customRenderEvent.objectColorTransform = new openfl_geom_ColorTransform();
				this.__customRenderEvent.objectMatrix = new openfl_geom_Matrix();
				this.__customRenderClear = true;
			}
			break;
		default:
		}
		openfl_events_EventDispatcher.prototype.addEventListener.call(this,type,listener,useCapture,priority,useWeakReference);
	}
	,dispatchEvent: function(event) {
		if(((event) instanceof openfl_events_MouseEvent)) {
			var mouseEvent = event;
			var _this = this.__getRenderTransform();
			mouseEvent.stageX = mouseEvent.localX * _this.a + mouseEvent.localY * _this.c + _this.tx;
			var _this = this.__getRenderTransform();
			mouseEvent.stageY = mouseEvent.localX * _this.b + mouseEvent.localY * _this.d + _this.ty;
		} else if(((event) instanceof openfl_events_TouchEvent)) {
			var touchEvent = event;
			var _this = this.__getRenderTransform();
			touchEvent.stageX = touchEvent.localX * _this.a + touchEvent.localY * _this.c + _this.tx;
			var _this = this.__getRenderTransform();
			touchEvent.stageY = touchEvent.localX * _this.b + touchEvent.localY * _this.d + _this.ty;
		}
		event.target = this;
		return this.__dispatchWithCapture(event);
	}
	,getBounds: function(targetCoordinateSpace) {
		var matrix = openfl_geom_Matrix.__pool.get();
		if(targetCoordinateSpace != null && targetCoordinateSpace != this) {
			matrix.copyFrom(this.__getWorldTransform());
			var targetMatrix = openfl_geom_Matrix.__pool.get();
			targetMatrix.copyFrom(targetCoordinateSpace.__getWorldTransform());
			targetMatrix.invert();
			matrix.concat(targetMatrix);
			openfl_geom_Matrix.__pool.release(targetMatrix);
		} else {
			matrix.identity();
		}
		var bounds = new openfl_geom_Rectangle();
		this.__getBounds(bounds,matrix);
		openfl_geom_Matrix.__pool.release(matrix);
		return bounds;
	}
	,getRect: function(targetCoordinateSpace) {
		return this.getBounds(targetCoordinateSpace);
	}
	,globalToLocal: function(pos) {
		return this.__globalToLocal(pos,new openfl_geom_Point());
	}
	,hitTestObject: function(obj) {
		if(obj != null && obj.parent != null && this.parent != null) {
			var currentBounds = this.getBounds(this);
			var targetBounds = obj.getBounds(this);
			return currentBounds.intersects(targetBounds);
		}
		return false;
	}
	,hitTestPoint: function(x,y,shapeFlag) {
		if(shapeFlag == null) {
			shapeFlag = false;
		}
		if(this.stage != null) {
			return this.__hitTest(x,y,shapeFlag,null,false,this);
		} else {
			return false;
		}
	}
	,invalidate: function() {
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
	}
	,localToGlobal: function(point) {
		return this.__getRenderTransform().transformPoint(point);
	}
	,removeEventListener: function(type,listener,useCapture) {
		if(useCapture == null) {
			useCapture = false;
		}
		openfl_events_EventDispatcher.prototype.removeEventListener.call(this,type,listener,useCapture);
		switch(type) {
		case "activate":case "deactivate":case "enterFrame":case "exitFrame":case "frameConstructed":case "render":
			if(!this.hasEventListener(type)) {
				if(Object.prototype.hasOwnProperty.call(openfl_display_DisplayObject.__broadcastEvents.h,type)) {
					HxOverrides.remove(openfl_display_DisplayObject.__broadcastEvents.h[type],this);
				}
			}
			break;
		case "clearDOM":case "renderCairo":case "renderCanvas":case "renderDOM":case "renderOpenGL":
			if(!this.hasEventListener("clearDOM") && !this.hasEventListener("renderCairo") && !this.hasEventListener("renderCanvas") && !this.hasEventListener("renderDOM") && !this.hasEventListener("renderOpenGL")) {
				this.__customRenderEvent = null;
			}
			break;
		default:
		}
	}
	,__cleanup: function() {
		this.__cairo = null;
		this.__canvas = null;
		this.__context = null;
		if(this.__graphics != null) {
			this.__graphics.__cleanup();
		}
		if(this.__cacheBitmap != null) {
			this.__cacheBitmap.__cleanup();
			this.__cacheBitmap = null;
		}
		if(this.__cacheBitmapData != null) {
			this.__cacheBitmapData.dispose();
			this.__cacheBitmapData = null;
		}
	}
	,__dispatch: function(event) {
		if(this.__eventMap != null && this.hasEventListener(event.type)) {
			var result = openfl_events_EventDispatcher.prototype.__dispatchEvent.call(this,event);
			if(event.__isCanceled) {
				return true;
			}
			return result;
		}
		return true;
	}
	,__dispatchChildren: function(event) {
	}
	,__dispatchEvent: function(event) {
		var parent = event.bubbles ? this.parent : null;
		var result = openfl_events_EventDispatcher.prototype.__dispatchEvent.call(this,event);
		if(event.__isCanceled) {
			return true;
		}
		if(parent != null && parent != this) {
			event.eventPhase = 3;
			if(event.target == null) {
				event.target = this;
			}
			parent.__dispatchEvent(event);
		}
		return result;
	}
	,__dispatchWithCapture: function(event) {
		if(event.target == null) {
			event.target = this;
		}
		if(this.parent != null) {
			event.eventPhase = 1;
			if(this.parent == this.stage) {
				this.parent.__dispatch(event);
			} else {
				var stack = openfl_display_DisplayObject.__tempStack.get();
				var parent = this.parent;
				var i = 0;
				while(parent != null) {
					stack.set(i,parent);
					parent = parent.parent;
					++i;
				}
				var _g = 0;
				var _g1 = i;
				while(_g < _g1) {
					var j = _g++;
					stack.get(i - j - 1).__dispatch(event);
				}
				openfl_display_DisplayObject.__tempStack.release(stack);
			}
		}
		event.eventPhase = 2;
		return this.__dispatchEvent(event);
	}
	,__enterFrame: function(deltaTime) {
	}
	,__getBounds: function(rect,matrix) {
		if(this.__graphics != null) {
			this.__graphics.__getBounds(rect,matrix);
		}
	}
	,__getCursor: function() {
		return null;
	}
	,__getFilterBounds: function(rect,matrix) {
		this.__getRenderBounds(rect,matrix);
		if(this.__filters != null) {
			var extension = openfl_geom_Rectangle.__pool.get();
			var _g = 0;
			var _g1 = this.__filters;
			while(_g < _g1.length) {
				var filter = _g1[_g];
				++_g;
				extension.__expand(-filter.__leftExtension,-filter.__topExtension,filter.__leftExtension + filter.__rightExtension,filter.__topExtension + filter.__bottomExtension);
			}
			rect.width += extension.width;
			rect.height += extension.height;
			rect.x += extension.x;
			rect.y += extension.y;
			openfl_geom_Rectangle.__pool.release(extension);
		}
	}
	,__getInteractive: function(stack) {
		return false;
	}
	,__getLocalBounds: function(rect) {
		this.__getBounds(rect,this.__transform);
		rect.x -= this.__transform.tx;
		rect.y -= this.__transform.ty;
	}
	,__getRenderBounds: function(rect,matrix) {
		if(this.__scrollRect == null) {
			this.__getBounds(rect,matrix);
		} else {
			var r = openfl_geom_Rectangle.__pool.get();
			r.copyFrom(this.__scrollRect);
			r.__transform(r,matrix);
			rect.__expand(r.x,r.y,r.width,r.height);
			openfl_geom_Rectangle.__pool.release(r);
		}
	}
	,__getRenderTransform: function() {
		this.__getWorldTransform();
		return this.__renderTransform;
	}
	,__getWorldTransform: function() {
		var transformDirty = this.__transformDirty || this.__worldTransformInvalid;
		if(transformDirty) {
			var list = [];
			var current = this;
			if(this.parent == null) {
				this.__update(true,false);
			} else {
				while(current != this.stage) {
					list.push(current);
					current = current.parent;
					if(current == null) {
						break;
					}
				}
			}
			var i = list.length;
			while(--i >= 0) {
				current = list[i];
				current.__update(true,false);
			}
		}
		return this.__worldTransform;
	}
	,__globalToLocal: function(global,local) {
		this.__getRenderTransform();
		if(global == local) {
			var _this = this.__renderTransform;
			var norm = _this.a * _this.d - _this.b * _this.c;
			if(norm == 0) {
				global.x = -_this.tx;
				global.y = -_this.ty;
			} else {
				var px = 1.0 / norm * (_this.c * (_this.ty - global.y) + _this.d * (global.x - _this.tx));
				global.y = 1.0 / norm * (_this.a * (global.y - _this.ty) + _this.b * (_this.tx - global.x));
				global.x = px;
			}
		} else {
			var _this = this.__renderTransform;
			var norm = _this.a * _this.d - _this.b * _this.c;
			local.x = norm == 0 ? -_this.tx : 1.0 / norm * (_this.c * (_this.ty - global.y) + _this.d * (global.x - _this.tx));
			var _this = this.__renderTransform;
			var norm = _this.a * _this.d - _this.b * _this.c;
			local.y = norm == 0 ? -_this.ty : 1.0 / norm * (_this.a * (global.y - _this.ty) + _this.b * (_this.tx - global.x));
		}
		return local;
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(this.__graphics != null) {
			if(!hitObject.__visible || this.__isMask) {
				return false;
			}
			if(this.get_mask() != null && !this.get_mask().__hitTestMask(x,y)) {
				return false;
			}
			if(this.__graphics.__hitTest(x,y,shapeFlag,this.__getRenderTransform())) {
				if(stack != null && !interactiveOnly) {
					stack.push(hitObject);
				}
				return true;
			}
		}
		return false;
	}
	,__hitTestMask: function(x,y) {
		if(this.__graphics != null) {
			if(this.__graphics.__hitTest(x,y,true,this.__getRenderTransform())) {
				return true;
			}
		}
		return false;
	}
	,__readGraphicsData: function(graphicsData,recurse) {
		if(this.__graphics != null) {
			this.__graphics.__readGraphicsData(graphicsData);
		}
	}
	,__setParentRenderDirty: function() {
		var renderParent = this.__renderParent != null ? this.__renderParent : this.parent;
		if(renderParent != null && !renderParent.__renderDirty) {
			renderParent.__renderDirty = true;
			renderParent.__setParentRenderDirty();
		}
	}
	,__setRenderDirty: function() {
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
	}
	,__setStageReference: function(stage) {
		this.stage = stage;
	}
	,__setTransformDirty: function() {
		if(!this.__transformDirty) {
			this.__transformDirty = true;
			this.__setWorldTransformInvalid();
			this.__setParentRenderDirty();
		}
	}
	,__setWorldTransformInvalid: function() {
		this.__worldTransformInvalid = true;
	}
	,__stopAllMovieClips: function() {
	}
	,__update: function(transformOnly,updateChildren) {
		var renderParent = this.__renderParent != null ? this.__renderParent : this.parent;
		if(this.__isMask && renderParent == null) {
			renderParent = this.__maskTarget;
		}
		this.__renderable = this.__visible && this.__scaleX != 0 && this.__scaleY != 0 && !this.__isMask && (renderParent == null || !renderParent.__isMask);
		this.__updateTransforms();
		this.__transformDirty = false;
		this.__worldTransformInvalid = false;
		if(!transformOnly) {
			if(openfl_display_DisplayObject.__supportDOM) {
				this.__renderTransformChanged = !this.__renderTransform.equals(this.__renderTransformCache);
				if(this.__renderTransformCache == null) {
					this.__renderTransformCache = this.__renderTransform.clone();
				} else {
					this.__renderTransformCache.copyFrom(this.__renderTransform);
				}
			}
			if(renderParent != null) {
				if(openfl_display_DisplayObject.__supportDOM) {
					var worldVisible = renderParent.__worldVisible && this.__visible;
					this.__worldVisibleChanged = this.__worldVisible != worldVisible;
					this.__worldVisible = worldVisible;
					var worldAlpha = this.get_alpha() * renderParent.__worldAlpha;
					this.__worldAlphaChanged = this.__worldAlpha != worldAlpha;
					this.__worldAlpha = worldAlpha;
				} else {
					this.__worldAlpha = this.get_alpha() * renderParent.__worldAlpha;
				}
				if(this.__objectTransform != null) {
					this.__worldColorTransform.__copyFrom(this.__objectTransform.__colorTransform);
					this.__worldColorTransform.__combine(renderParent.__worldColorTransform);
				} else {
					this.__worldColorTransform.__copyFrom(renderParent.__worldColorTransform);
				}
				if(this.__blendMode == null || this.__blendMode == 10) {
					this.__worldBlendMode = renderParent.__worldBlendMode;
				} else {
					this.__worldBlendMode = this.__blendMode;
				}
				if(this.__shader == null) {
					this.__worldShader = renderParent.__shader;
				} else {
					this.__worldShader = this.__shader;
				}
				if(this.__scale9Grid == null) {
					this.__worldScale9Grid = renderParent.__scale9Grid;
				} else {
					this.__worldScale9Grid = this.__scale9Grid;
				}
			} else {
				this.__worldAlpha = this.get_alpha();
				if(openfl_display_DisplayObject.__supportDOM) {
					this.__worldVisibleChanged = this.__worldVisible != this.__visible;
					this.__worldVisible = this.__visible;
					this.__worldAlphaChanged = this.__worldAlpha != this.get_alpha();
				}
				if(this.__objectTransform != null) {
					this.__worldColorTransform.__copyFrom(this.__objectTransform.__colorTransform);
				} else {
					this.__worldColorTransform.__identity();
				}
				this.__worldBlendMode = this.__blendMode;
				this.__worldShader = this.__shader;
				this.__worldScale9Grid = this.__scale9Grid;
			}
		}
		if(updateChildren && this.get_mask() != null) {
			this.get_mask().__update(transformOnly,true);
		}
	}
	,__updateTransforms: function(overrideTransform) {
		var overrided = overrideTransform != null;
		var local = overrided ? overrideTransform : this.__transform;
		if(this.__worldTransform == null) {
			this.__worldTransform = new openfl_geom_Matrix();
		}
		if(this.__renderTransform == null) {
			this.__renderTransform = new openfl_geom_Matrix();
		}
		var renderParent = this.__renderParent != null ? this.__renderParent : this.parent;
		if(!overrided && this.parent != null) {
			var parentTransform = this.parent.__worldTransform;
			var target = this.__worldTransform;
			target.a = local.a * parentTransform.a + local.b * parentTransform.c;
			target.b = local.a * parentTransform.b + local.b * parentTransform.d;
			target.c = local.c * parentTransform.a + local.d * parentTransform.c;
			target.d = local.c * parentTransform.b + local.d * parentTransform.d;
			target.tx = local.tx * parentTransform.a + local.ty * parentTransform.c + parentTransform.tx;
			target.ty = local.tx * parentTransform.b + local.ty * parentTransform.d + parentTransform.ty;
		} else {
			this.__worldTransform.copyFrom(local);
		}
		if(!overrided && renderParent != null) {
			var parentTransform = renderParent.__renderTransform;
			var target = this.__renderTransform;
			target.a = local.a * parentTransform.a + local.b * parentTransform.c;
			target.b = local.a * parentTransform.b + local.b * parentTransform.d;
			target.c = local.c * parentTransform.a + local.d * parentTransform.c;
			target.d = local.c * parentTransform.b + local.d * parentTransform.d;
			target.tx = local.tx * parentTransform.a + local.ty * parentTransform.c + parentTransform.tx;
			target.ty = local.tx * parentTransform.b + local.ty * parentTransform.d + parentTransform.ty;
		} else {
			this.__renderTransform.copyFrom(local);
		}
		if(this.__scrollRect != null) {
			var _this = this.__renderTransform;
			var px = -this.__scrollRect.x;
			var py = -this.__scrollRect.y;
			_this.tx = px * _this.a + py * _this.c + _this.tx;
			_this.ty = px * _this.b + py * _this.d + _this.ty;
		}
	}
	,get_alpha: function() {
		return this.__alpha;
	}
	,set_alpha: function(value) {
		if(value > 1.0) {
			value = 1.0;
		}
		if(value < 0.0) {
			value = 0.0;
		}
		if(value != this.__alpha && !this.get_cacheAsBitmap()) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__alpha = value;
	}
	,get_blendMode: function() {
		return this.__blendMode;
	}
	,set_blendMode: function(value) {
		if(value == null) {
			value = 10;
		}
		if(value != this.__blendMode) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__blendMode = value;
	}
	,get_cacheAsBitmap: function() {
		if(this.__filters == null) {
			return this.__cacheAsBitmap;
		} else {
			return true;
		}
	}
	,set_cacheAsBitmap: function(value) {
		if(value != this.__cacheAsBitmap) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__cacheAsBitmap = value;
	}
	,get_cacheAsBitmapMatrix: function() {
		return this.__cacheAsBitmapMatrix;
	}
	,set_cacheAsBitmapMatrix: function(value) {
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
		return this.__cacheAsBitmapMatrix = value != null ? value.clone() : value;
	}
	,get_filters: function() {
		if(this.__filters == null) {
			return [];
		} else {
			return this.__filters.slice();
		}
	}
	,set_filters: function(value) {
		if(value != null && value.length > 0) {
			this.__filters = value;
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		} else if(this.__filters != null) {
			this.__filters = null;
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return value;
	}
	,get_height: function() {
		var rect = openfl_geom_Rectangle.__pool.get();
		this.__getLocalBounds(rect);
		var height = rect.height;
		openfl_geom_Rectangle.__pool.release(rect);
		return height;
	}
	,set_height: function(value) {
		var rect = openfl_geom_Rectangle.__pool.get();
		var matrix = openfl_geom_Matrix.__pool.get();
		matrix.identity();
		this.__getBounds(rect,matrix);
		if(value != rect.height) {
			this.set_scaleY(value / rect.height);
		} else {
			this.set_scaleY(1);
		}
		openfl_geom_Rectangle.__pool.release(rect);
		openfl_geom_Matrix.__pool.release(matrix);
		return value;
	}
	,get_loaderInfo: function() {
		if(this.stage != null) {
			return openfl_utils__$internal_Lib.current.__loaderInfo;
		}
		return null;
	}
	,get_mask: function() {
		return this.__mask;
	}
	,set_mask: function(value) {
		if(value == this.__mask) {
			return value;
		}
		if(value != this.__mask) {
			this.__setTransformDirty();
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		if(this.__mask != null) {
			this.__mask.__isMask = false;
			this.__mask.__maskTarget = null;
			this.__mask.__setTransformDirty();
			var _this = this.__mask;
			if(!_this.__renderDirty) {
				_this.__renderDirty = true;
				_this.__setParentRenderDirty();
			}
		}
		if(value != null) {
			value.__isMask = true;
			value.__maskTarget = this;
			value.__setWorldTransformInvalid();
		}
		if(this.__cacheBitmap != null && this.__cacheBitmap.get_mask() != value) {
			this.__cacheBitmap.set_mask(value);
		}
		return this.__mask = value;
	}
	,get_mouseX: function() {
		var mouseX = this.stage != null ? this.stage.__mouseX : openfl_utils__$internal_Lib.current.stage.__mouseX;
		var mouseY = this.stage != null ? this.stage.__mouseY : openfl_utils__$internal_Lib.current.stage.__mouseY;
		var _this = this.__getRenderTransform();
		var norm = _this.a * _this.d - _this.b * _this.c;
		if(norm == 0) {
			return -_this.tx;
		} else {
			return 1.0 / norm * (_this.c * (_this.ty - mouseY) + _this.d * (mouseX - _this.tx));
		}
	}
	,get_mouseY: function() {
		var mouseX = this.stage != null ? this.stage.__mouseX : openfl_utils__$internal_Lib.current.stage.__mouseX;
		var mouseY = this.stage != null ? this.stage.__mouseY : openfl_utils__$internal_Lib.current.stage.__mouseY;
		var _this = this.__getRenderTransform();
		var norm = _this.a * _this.d - _this.b * _this.c;
		if(norm == 0) {
			return -_this.ty;
		} else {
			return 1.0 / norm * (_this.a * (mouseY - _this.ty) + _this.b * (_this.tx - mouseX));
		}
	}
	,get_name: function() {
		return this.__name;
	}
	,set_name: function(value) {
		return this.__name = value;
	}
	,get_root: function() {
		if(this.stage != null) {
			return openfl_utils__$internal_Lib.current;
		}
		return null;
	}
	,get_rotation: function() {
		return this.__rotation;
	}
	,set_rotation: function(value) {
		if(value != this.__rotation) {
			this.__rotation = value;
			var radians = this.__rotation * (Math.PI / 180);
			this.__rotationSine = Math.sin(radians);
			this.__rotationCosine = Math.cos(radians);
			this.__transform.a = this.__rotationCosine * this.__scaleX;
			this.__transform.b = this.__rotationSine * this.__scaleX;
			this.__transform.c = -this.__rotationSine * this.__scaleY;
			this.__transform.d = this.__rotationCosine * this.__scaleY;
			this.__setTransformDirty();
		}
		return value;
	}
	,get_scale9Grid: function() {
		if(this.__scale9Grid == null) {
			return null;
		}
		return this.__scale9Grid.clone();
	}
	,set_scale9Grid: function(value) {
		if(value == null && this.__scale9Grid == null) {
			return value;
		}
		if(value != null && this.__scale9Grid != null && this.__scale9Grid.equals(value)) {
			return value;
		}
		if(value != null) {
			if(this.__scale9Grid == null) {
				this.__scale9Grid = new openfl_geom_Rectangle();
			}
			this.__scale9Grid.copyFrom(value);
		} else {
			this.__scale9Grid = null;
		}
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
		return value;
	}
	,get_scaleX: function() {
		return this.__scaleX;
	}
	,set_scaleX: function(value) {
		if(value != this.__scaleX) {
			this.__scaleX = value;
			if(this.__transform.b == 0) {
				if(value != this.__transform.a) {
					this.__setTransformDirty();
				}
				this.__transform.a = value;
			} else {
				var a = this.__rotationCosine * value;
				var b = this.__rotationSine * value;
				if(this.__transform.a != a || this.__transform.b != b) {
					this.__setTransformDirty();
				}
				this.__transform.a = a;
				this.__transform.b = b;
			}
		}
		return value;
	}
	,get_scaleY: function() {
		return this.__scaleY;
	}
	,set_scaleY: function(value) {
		if(value != this.__scaleY) {
			this.__scaleY = value;
			if(this.__transform.c == 0) {
				if(value != this.__transform.d) {
					this.__setTransformDirty();
				}
				this.__transform.d = value;
			} else {
				var c = -this.__rotationSine * value;
				var d = this.__rotationCosine * value;
				if(this.__transform.d != d || this.__transform.c != c) {
					this.__setTransformDirty();
				}
				this.__transform.c = c;
				this.__transform.d = d;
			}
		}
		return value;
	}
	,get_scrollRect: function() {
		if(this.__scrollRect == null) {
			return null;
		}
		return this.__scrollRect.clone();
	}
	,set_scrollRect: function(value) {
		if(value == null && this.__scrollRect == null) {
			return value;
		}
		if(value != null && this.__scrollRect != null && this.__scrollRect.equals(value)) {
			return value;
		}
		if(value != null) {
			if(this.__scrollRect == null) {
				this.__scrollRect = new openfl_geom_Rectangle();
			}
			this.__scrollRect.copyFrom(value);
		} else {
			this.__scrollRect = null;
		}
		this.__setTransformDirty();
		if(openfl_display_DisplayObject.__supportDOM) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return value;
	}
	,get_shader: function() {
		return this.__shader;
	}
	,set_shader: function(value) {
		this.__shader = value;
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
		return value;
	}
	,get_transform: function() {
		if(this.__objectTransform == null) {
			this.__objectTransform = new openfl_geom_Transform(this);
		}
		return this.__objectTransform;
	}
	,set_transform: function(value) {
		if(value == null) {
			throw haxe_Exception.thrown(new openfl_errors_TypeError("Parameter transform must be non-null."));
		}
		if(this.__objectTransform == null) {
			this.__objectTransform = new openfl_geom_Transform(this);
		}
		this.__setTransformDirty();
		this.__objectTransform.set_matrix(value.get_matrix());
		if(!this.__objectTransform.__colorTransform.__equals(value.__colorTransform,true) || !this.get_cacheAsBitmap() && this.__objectTransform.__colorTransform.alphaMultiplier != value.__colorTransform.alphaMultiplier) {
			this.__objectTransform.__colorTransform.__copyFrom(value.get_colorTransform());
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__objectTransform;
	}
	,get_visible: function() {
		return this.__visible;
	}
	,set_visible: function(value) {
		if(value != this.__visible) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
		return this.__visible = value;
	}
	,get_width: function() {
		var rect = openfl_geom_Rectangle.__pool.get();
		this.__getLocalBounds(rect);
		var width = rect.width;
		openfl_geom_Rectangle.__pool.release(rect);
		return width;
	}
	,set_width: function(value) {
		var rect = openfl_geom_Rectangle.__pool.get();
		var matrix = openfl_geom_Matrix.__pool.get();
		matrix.identity();
		this.__getBounds(rect,matrix);
		if(value != rect.width) {
			this.set_scaleX(value / rect.width);
		} else {
			this.set_scaleX(1);
		}
		openfl_geom_Rectangle.__pool.release(rect);
		openfl_geom_Matrix.__pool.release(matrix);
		return value;
	}
	,get_x: function() {
		return this.__transform.tx;
	}
	,set_x: function(value) {
		if(value != this.__transform.tx) {
			this.__setTransformDirty();
		}
		return this.__transform.tx = value;
	}
	,get_y: function() {
		return this.__transform.ty;
	}
	,set_y: function(value) {
		if(value != this.__transform.ty) {
			this.__setTransformDirty();
		}
		return this.__transform.ty = value;
	}
	,__class__: openfl_display_DisplayObject
	,__properties__: {set_y:"set_y",get_y:"get_y",set_x:"set_x",get_x:"get_x",set_width:"set_width",get_width:"get_width",set_visible:"set_visible",get_visible:"get_visible",set_transform:"set_transform",get_transform:"get_transform",set_shader:"set_shader",get_shader:"get_shader",set_scrollRect:"set_scrollRect",get_scrollRect:"get_scrollRect",set_scaleY:"set_scaleY",get_scaleY:"get_scaleY",set_scaleX:"set_scaleX",get_scaleX:"get_scaleX",set_scale9Grid:"set_scale9Grid",get_scale9Grid:"get_scale9Grid",set_rotation:"set_rotation",get_rotation:"get_rotation",get_root:"get_root",set_name:"set_name",get_name:"get_name",get_mouseY:"get_mouseY",get_mouseX:"get_mouseX",set_mask:"set_mask",get_mask:"get_mask",get_loaderInfo:"get_loaderInfo",set_height:"set_height",get_height:"get_height",set_filters:"set_filters",get_filters:"get_filters",set_cacheAsBitmapMatrix:"set_cacheAsBitmapMatrix",get_cacheAsBitmapMatrix:"get_cacheAsBitmapMatrix",set_cacheAsBitmap:"set_cacheAsBitmap",get_cacheAsBitmap:"get_cacheAsBitmap",set_blendMode:"set_blendMode",get_blendMode:"get_blendMode",set_alpha:"set_alpha",get_alpha:"get_alpha"}
});
var openfl_display_InteractiveObject = function() {
	openfl_display_DisplayObject.call(this);
	this.doubleClickEnabled = false;
	this.mouseEnabled = true;
	this.needsSoftKeyboard = false;
	this.__tabEnabled = null;
	this.__tabIndex = -1;
};
$hxClasses["openfl.display.InteractiveObject"] = openfl_display_InteractiveObject;
openfl_display_InteractiveObject.__name__ = "openfl.display.InteractiveObject";
openfl_display_InteractiveObject.__super__ = openfl_display_DisplayObject;
openfl_display_InteractiveObject.prototype = $extend(openfl_display_DisplayObject.prototype,{
	requestSoftKeyboard: function() {
		openfl_utils__$internal_Lib.notImplemented({ fileName : "openfl/display/InteractiveObject.hx", lineNumber : 1251, className : "openfl.display.InteractiveObject", methodName : "requestSoftKeyboard"});
		return false;
	}
	,__allowMouseFocus: function() {
		return this.get_tabEnabled();
	}
	,__getInteractive: function(stack) {
		if(stack != null) {
			stack.push(this);
			if(this.parent != null) {
				this.parent.__getInteractive(stack);
			}
		}
		return true;
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(!hitObject.get_visible() || this.__isMask || interactiveOnly && !this.mouseEnabled) {
			return false;
		}
		return openfl_display_DisplayObject.prototype.__hitTest.call(this,x,y,shapeFlag,stack,interactiveOnly,hitObject);
	}
	,__tabTest: function(stack) {
		if(this.get_tabEnabled()) {
			stack.push(this);
		}
	}
	,get_tabEnabled: function() {
		if(this.__tabEnabled == true) {
			return true;
		} else {
			return false;
		}
	}
	,set_tabEnabled: function(value) {
		if(this.__tabEnabled != value) {
			this.__tabEnabled = value;
			this.dispatchEvent(new openfl_events_Event("tabEnabledChange",true,false));
		}
		return this.__tabEnabled;
	}
	,get_tabIndex: function() {
		return this.__tabIndex;
	}
	,set_tabIndex: function(value) {
		if(this.__tabIndex != value) {
			if(value < -1) {
				throw haxe_Exception.thrown(new openfl_errors_RangeError("Parameter tabIndex must be a non-negative number; got " + value));
			}
			this.__tabIndex = value;
			this.dispatchEvent(new openfl_events_Event("tabIndexChange",true,false));
		}
		return this.__tabIndex;
	}
	,__class__: openfl_display_InteractiveObject
	,__properties__: $extend(openfl_display_DisplayObject.prototype.__properties__,{set_tabIndex:"set_tabIndex",get_tabIndex:"get_tabIndex",set_tabEnabled:"set_tabEnabled",get_tabEnabled:"get_tabEnabled"})
});
var openfl_display_DisplayObjectContainer = function() {
	openfl_display_InteractiveObject.call(this);
	this.mouseChildren = true;
	this.__tabChildren = true;
	this.__children = [];
	this.__removedChildren = openfl_Vector.toObjectVector(null);
};
$hxClasses["openfl.display.DisplayObjectContainer"] = openfl_display_DisplayObjectContainer;
openfl_display_DisplayObjectContainer.__name__ = "openfl.display.DisplayObjectContainer";
openfl_display_DisplayObjectContainer.__super__ = openfl_display_InteractiveObject;
openfl_display_DisplayObjectContainer.prototype = $extend(openfl_display_InteractiveObject.prototype,{
	addChild: function(child) {
		return this.addChildAt(child,this.get_numChildren());
	}
	,addChildAt: function(child,index) {
		if(child == null) {
			var error = new openfl_errors_TypeError("Error #2007: Parameter child must be non-null.");
			error.errorID = 2007;
			throw haxe_Exception.thrown(error);
		} else if(child.stage == child) {
			var error = new openfl_errors_ArgumentError("Error #3783: A Stage object cannot be added as the child of another object.");
			error.errorID = 3783;
			throw haxe_Exception.thrown(error);
		}
		if(index > this.__children.length || index < 0) {
			throw haxe_Exception.thrown("Invalid index position " + index);
		}
		if(child.parent == this) {
			if(this.__children[index] != child) {
				HxOverrides.remove(this.__children,child);
				this.__children.splice(index,0,child);
				if(!this.__renderDirty) {
					this.__renderDirty = true;
					this.__setParentRenderDirty();
				}
			}
		} else {
			if(child.parent != null) {
				child.parent.removeChild(child);
			}
			this.__children.splice(index,0,child);
			child.parent = this;
			var addedToStage = this.stage != null && child.stage == null;
			if(addedToStage) {
				child.__setStageReference(this.stage);
			}
			child.__setTransformDirty();
			if(!child.__renderDirty) {
				child.__renderDirty = true;
				child.__setParentRenderDirty();
			}
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
			var event = new openfl_events_Event("added");
			event.bubbles = true;
			event.target = child;
			child.__dispatchWithCapture(event);
			if(addedToStage) {
				event = new openfl_events_Event("addedToStage",false,false);
				child.__dispatchWithCapture(event);
				child.__dispatchChildren(event);
			}
		}
		return child;
	}
	,areInaccessibleObjectsUnderPoint: function(point) {
		return false;
	}
	,contains: function(child) {
		while(child != this && child != null) child = child.parent;
		return child == this;
	}
	,getChildAt: function(index) {
		if(index >= 0 && index < this.__children.length) {
			return this.__children[index];
		}
		return null;
	}
	,getChildByName: function(name) {
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.get_name() == name) {
				return child;
			}
		}
		return null;
	}
	,getChildIndex: function(child) {
		var _g = 0;
		var _g1 = this.__children.length;
		while(_g < _g1) {
			var i = _g++;
			if(this.__children[i] == child) {
				return i;
			}
		}
		return -1;
	}
	,getObjectsUnderPoint: function(point) {
		var stack = [];
		this.__hitTest(point.x,point.y,false,stack,false,this);
		stack.reverse();
		return stack;
	}
	,removeChild: function(child) {
		if(child != null && child.parent == this) {
			child.__setTransformDirty();
			if(!child.__renderDirty) {
				child.__renderDirty = true;
				child.__setParentRenderDirty();
			}
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
			var event = new openfl_events_Event("removed",true);
			child.__dispatchWithCapture(event);
			if(this.stage != null) {
				if(child.stage != null && this.stage.get_focus() == child) {
					this.stage.set_focus(null);
				}
				var event = new openfl_events_Event("removedFromStage",false,false);
				child.__dispatchWithCapture(event);
				child.__dispatchChildren(event);
				child.__setStageReference(null);
			}
			child.parent = null;
			HxOverrides.remove(this.__children,child);
			this.__removedChildren.push(child);
			child.__setTransformDirty();
		}
		return child;
	}
	,removeChildAt: function(index) {
		if(index >= 0 && index < this.__children.length) {
			return this.removeChild(this.__children[index]);
		}
		return null;
	}
	,removeChildren: function(beginIndex,endIndex) {
		if(endIndex == null) {
			endIndex = 2147483647;
		}
		if(beginIndex == null) {
			beginIndex = 0;
		}
		if(endIndex == 2147483647) {
			endIndex = this.__children.length - 1;
			if(endIndex < 0) {
				return;
			}
		}
		if(beginIndex > this.__children.length - 1) {
			return;
		} else if(endIndex < beginIndex || beginIndex < 0 || endIndex > this.__children.length) {
			throw haxe_Exception.thrown(new openfl_errors_RangeError("The supplied index is out of bounds."));
		}
		var numRemovals = endIndex - beginIndex;
		while(numRemovals >= 0) {
			this.removeChildAt(beginIndex);
			--numRemovals;
		}
	}
	,resolve: function(fieldName) {
		if(this.__children == null) {
			return null;
		}
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.get_name() == fieldName) {
				return child;
			}
		}
		return null;
	}
	,setChildIndex: function(child,index) {
		if(index >= 0 && index <= this.__children.length && child.parent == this) {
			HxOverrides.remove(this.__children,child);
			this.__children.splice(index,0,child);
		}
	}
	,stopAllMovieClips: function() {
		this.__stopAllMovieClips();
	}
	,swapChildren: function(child1,child2) {
		if(child1.parent == this && child2.parent == this) {
			var index1 = this.__children.indexOf(child1);
			var index2 = this.__children.indexOf(child2);
			this.__children[index1] = child2;
			this.__children[index2] = child1;
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
	}
	,swapChildrenAt: function(index1,index2) {
		var swap = this.__children[index1];
		this.__children[index1] = this.__children[index2];
		this.__children[index2] = swap;
		swap = null;
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
	}
	,__cleanup: function() {
		openfl_display_InteractiveObject.prototype.__cleanup.call(this);
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__cleanup();
		}
		var orphan = this.__removedChildren.iterator();
		while(orphan.hasNext()) {
			var orphan1 = orphan.next();
			if(orphan1.stage == null) {
				orphan1.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
	}
	,__cleanupRemovedChildren: function() {
		var orphan = this.__removedChildren.iterator();
		while(orphan.hasNext()) {
			var orphan1 = orphan.next();
			if(orphan1.stage == null) {
				orphan1.__cleanup();
			}
		}
		this.__removedChildren.set_length(0);
	}
	,__dispatchChildren: function(event) {
		if(this.__children != null) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				event.target = child;
				if(!child.__dispatchWithCapture(event)) {
					break;
				}
				child.__dispatchChildren(event);
			}
		}
	}
	,__enterFrame: function(deltaTime) {
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__enterFrame(deltaTime);
		}
	}
	,__getBounds: function(rect,matrix) {
		openfl_display_InteractiveObject.prototype.__getBounds.call(this,rect,matrix);
		if(this.__children.length == 0) {
			return;
		}
		var childWorldTransform = openfl_geom_Matrix.__pool.get();
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.__scaleX == 0 || child.__scaleY == 0) {
				continue;
			}
			var local = child.__transform;
			childWorldTransform.a = local.a * matrix.a + local.b * matrix.c;
			childWorldTransform.b = local.a * matrix.b + local.b * matrix.d;
			childWorldTransform.c = local.c * matrix.a + local.d * matrix.c;
			childWorldTransform.d = local.c * matrix.b + local.d * matrix.d;
			childWorldTransform.tx = local.tx * matrix.a + local.ty * matrix.c + matrix.tx;
			childWorldTransform.ty = local.tx * matrix.b + local.ty * matrix.d + matrix.ty;
			child.__getBounds(rect,childWorldTransform);
		}
		openfl_geom_Matrix.__pool.release(childWorldTransform);
	}
	,__getFilterBounds: function(rect,matrix) {
		openfl_display_InteractiveObject.prototype.__getFilterBounds.call(this,rect,matrix);
		if(this.__scrollRect != null) {
			return;
		}
		if(this.__children.length == 0) {
			return;
		}
		var childWorldTransform = openfl_geom_Matrix.__pool.get();
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.__scaleX == 0 || child.__scaleY == 0 || child.__isMask) {
				continue;
			}
			var local = child.__transform;
			childWorldTransform.a = local.a * matrix.a + local.b * matrix.c;
			childWorldTransform.b = local.a * matrix.b + local.b * matrix.d;
			childWorldTransform.c = local.c * matrix.a + local.d * matrix.c;
			childWorldTransform.d = local.c * matrix.b + local.d * matrix.d;
			childWorldTransform.tx = local.tx * matrix.a + local.ty * matrix.c + matrix.tx;
			childWorldTransform.ty = local.tx * matrix.b + local.ty * matrix.d + matrix.ty;
			var childRect = openfl_geom_Rectangle.__pool.get();
			child.__getFilterBounds(childRect,childWorldTransform);
			rect.__expand(childRect.x,childRect.y,childRect.width,childRect.height);
			openfl_geom_Rectangle.__pool.release(childRect);
		}
		openfl_geom_Matrix.__pool.release(childWorldTransform);
	}
	,__getRenderBounds: function(rect,matrix) {
		if(this.__scrollRect != null) {
			openfl_display_InteractiveObject.prototype.__getRenderBounds.call(this,rect,matrix);
			return;
		} else {
			openfl_display_InteractiveObject.prototype.__getBounds.call(this,rect,matrix);
		}
		if(this.__children.length == 0) {
			return;
		}
		var childWorldTransform = openfl_geom_Matrix.__pool.get();
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			if(child.__scaleX == 0 || child.__scaleY == 0 || child.__isMask) {
				continue;
			}
			var local = child.__transform;
			childWorldTransform.a = local.a * matrix.a + local.b * matrix.c;
			childWorldTransform.b = local.a * matrix.b + local.b * matrix.d;
			childWorldTransform.c = local.c * matrix.a + local.d * matrix.c;
			childWorldTransform.d = local.c * matrix.b + local.d * matrix.d;
			childWorldTransform.tx = local.tx * matrix.a + local.ty * matrix.c + matrix.tx;
			childWorldTransform.ty = local.tx * matrix.b + local.ty * matrix.d + matrix.ty;
			child.__getRenderBounds(rect,childWorldTransform);
		}
		openfl_geom_Matrix.__pool.release(childWorldTransform);
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(!hitObject.get_visible() || this.__isMask || interactiveOnly && !this.mouseEnabled && !this.mouseChildren) {
			return false;
		}
		if(this.get_mask() != null && !this.get_mask().__hitTestMask(x,y)) {
			return false;
		}
		if(this.__scrollRect != null) {
			var point = openfl_geom_Point.__pool.get();
			point.setTo(x,y);
			var _this = this.__getRenderTransform();
			var norm = _this.a * _this.d - _this.b * _this.c;
			if(norm == 0) {
				point.x = -_this.tx;
				point.y = -_this.ty;
			} else {
				var px = 1.0 / norm * (_this.c * (_this.ty - point.y) + _this.d * (point.x - _this.tx));
				point.y = 1.0 / norm * (_this.a * (point.y - _this.ty) + _this.b * (_this.tx - point.x));
				point.x = px;
			}
			if(!this.__scrollRect.containsPoint(point)) {
				openfl_geom_Point.__pool.release(point);
				return false;
			}
			openfl_geom_Point.__pool.release(point);
		}
		var i = this.__children.length;
		if(interactiveOnly) {
			if(stack == null || !this.mouseChildren) {
				while(--i >= 0) if(this.__children[i].__hitTest(x,y,shapeFlag,null,true,this.__children[i])) {
					if(stack != null) {
						stack.push(hitObject);
					}
					return true;
				}
			} else if(stack != null) {
				var length = stack.length;
				var interactive = false;
				var hitTest = false;
				while(--i >= 0) {
					interactive = this.__children[i].__getInteractive(null);
					if(interactive || this.mouseEnabled && !hitTest) {
						if(this.__children[i].__hitTest(x,y,shapeFlag,stack,true,this.__children[i])) {
							hitTest = true;
							if(interactive && stack.length > length) {
								break;
							}
						}
					}
				}
				if(hitTest) {
					stack.splice(length,0,hitObject);
					return true;
				}
			}
		} else {
			var hitTest = false;
			while(--i >= 0) if(this.__children[i].__hitTest(x,y,shapeFlag,stack,false,this.__children[i])) {
				hitTest = true;
				if(stack == null) {
					break;
				}
			}
			return hitTest;
		}
		return false;
	}
	,__hitTestMask: function(x,y) {
		var i = this.__children.length;
		while(--i >= 0) if(this.__children[i].__hitTestMask(x,y)) {
			return true;
		}
		return false;
	}
	,__readGraphicsData: function(graphicsData,recurse) {
		openfl_display_InteractiveObject.prototype.__readGraphicsData.call(this,graphicsData,recurse);
		if(recurse) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__readGraphicsData(graphicsData,recurse);
			}
		}
	}
	,__setStageReference: function(stage) {
		openfl_display_InteractiveObject.prototype.__setStageReference.call(this,stage);
		if(this.__children != null) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__setStageReference(stage);
			}
		}
	}
	,__setWorldTransformInvalid: function() {
		if(!this.__worldTransformInvalid) {
			this.__worldTransformInvalid = true;
			if(this.__children != null) {
				var _g = 0;
				var _g1 = this.__children;
				while(_g < _g1.length) {
					var child = _g1[_g];
					++_g;
					child.__setWorldTransformInvalid();
				}
			}
		}
	}
	,__stopAllMovieClips: function() {
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			child.__stopAllMovieClips();
		}
	}
	,__tabTest: function(stack) {
		openfl_display_InteractiveObject.prototype.__tabTest.call(this,stack);
		if(!this.get_tabChildren()) {
			return;
		}
		var interactive = false;
		var interactiveObject = null;
		var _g = 0;
		var _g1 = this.__children;
		while(_g < _g1.length) {
			var child = _g1[_g];
			++_g;
			interactive = child.__getInteractive(null);
			if(interactive) {
				interactiveObject = child;
				interactiveObject.__tabTest(stack);
			}
		}
	}
	,__update: function(transformOnly,updateChildren) {
		openfl_display_InteractiveObject.prototype.__update.call(this,transformOnly,updateChildren);
		if(updateChildren) {
			var _g = 0;
			var _g1 = this.__children;
			while(_g < _g1.length) {
				var child = _g1[_g];
				++_g;
				child.__update(transformOnly,true);
			}
		}
	}
	,get_numChildren: function() {
		return this.__children.length;
	}
	,get_tabChildren: function() {
		return this.__tabChildren;
	}
	,set_tabChildren: function(value) {
		if(this.__tabChildren != value) {
			this.__tabChildren = value;
			this.dispatchEvent(new openfl_events_Event("tabChildrenChange",true,false));
		}
		return this.__tabChildren;
	}
	,__class__: openfl_display_DisplayObjectContainer
	,__properties__: $extend(openfl_display_InteractiveObject.prototype.__properties__,{set_tabChildren:"set_tabChildren",get_tabChildren:"get_tabChildren",get_numChildren:"get_numChildren"})
});
var openfl_display_Sprite = function() {
	openfl_display_DisplayObjectContainer.call(this);
	this.__drawableType = 4;
	this.__buttonMode = false;
	this.useHandCursor = true;
};
$hxClasses["openfl.display.Sprite"] = openfl_display_Sprite;
openfl_display_Sprite.__name__ = "openfl.display.Sprite";
openfl_display_Sprite.__super__ = openfl_display_DisplayObjectContainer;
openfl_display_Sprite.prototype = $extend(openfl_display_DisplayObjectContainer.prototype,{
	startDrag: function(lockCenter,bounds) {
		if(lockCenter == null) {
			lockCenter = false;
		}
		if(this.stage != null) {
			this.stage.__startDrag(this,lockCenter,bounds);
		}
	}
	,stopDrag: function() {
		if(this.stage != null) {
			this.stage.__stopDrag(this);
		}
	}
	,__getCursor: function() {
		if(this.__buttonMode && this.useHandCursor) {
			return "button";
		} else {
			return null;
		}
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(interactiveOnly && !this.mouseEnabled && !this.mouseChildren) {
			return false;
		}
		if(!hitObject.get_visible() || this.__isMask) {
			return this.__hitTestHitArea(x,y,shapeFlag,stack,interactiveOnly,hitObject);
		}
		if(this.get_mask() != null && !this.get_mask().__hitTestMask(x,y)) {
			return this.__hitTestHitArea(x,y,shapeFlag,stack,interactiveOnly,hitObject);
		}
		if(this.__scrollRect != null) {
			var point = openfl_geom_Point.__pool.get();
			point.setTo(x,y);
			var _this = this.__getRenderTransform();
			var norm = _this.a * _this.d - _this.b * _this.c;
			if(norm == 0) {
				point.x = -_this.tx;
				point.y = -_this.ty;
			} else {
				var px = 1.0 / norm * (_this.c * (_this.ty - point.y) + _this.d * (point.x - _this.tx));
				point.y = 1.0 / norm * (_this.a * (point.y - _this.ty) + _this.b * (_this.tx - point.x));
				point.x = px;
			}
			if(!this.__scrollRect.containsPoint(point)) {
				openfl_geom_Point.__pool.release(point);
				return this.__hitTestHitArea(x,y,shapeFlag,stack,true,hitObject);
			}
			openfl_geom_Point.__pool.release(point);
		}
		if(openfl_display_DisplayObjectContainer.prototype.__hitTest.call(this,x,y,shapeFlag,stack,interactiveOnly,hitObject)) {
			if(stack != null) {
				return interactiveOnly;
			} else {
				return true;
			}
		} else if(this.hitArea == null && this.__graphics != null && this.__graphics.__hitTest(x,y,shapeFlag,this.__getRenderTransform())) {
			if(stack != null && (!interactiveOnly || this.mouseEnabled)) {
				stack.push(hitObject);
			}
			return true;
		}
		return this.__hitTestHitArea(x,y,shapeFlag,stack,interactiveOnly,hitObject);
	}
	,__hitTestHitArea: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(this.hitArea != null) {
			if(!this.hitArea.mouseEnabled) {
				this.hitArea.mouseEnabled = true;
				var hitTest = this.hitArea.__hitTest(x,y,shapeFlag,null,true,hitObject);
				this.hitArea.mouseEnabled = false;
				if(stack != null && hitTest) {
					stack[stack.length] = hitObject;
				}
				return hitTest;
			}
		}
		return false;
	}
	,__hitTestMask: function(x,y) {
		if(openfl_display_DisplayObjectContainer.prototype.__hitTestMask.call(this,x,y)) {
			return true;
		} else if(this.__graphics != null && this.__graphics.__hitTest(x,y,true,this.__getRenderTransform())) {
			return true;
		}
		return false;
	}
	,get_graphics: function() {
		if(this.__graphics == null) {
			this.__graphics = new openfl_display_Graphics(this);
		}
		return this.__graphics;
	}
	,get_tabEnabled: function() {
		if(this.__tabEnabled == null) {
			return this.__buttonMode;
		} else {
			return this.__tabEnabled;
		}
	}
	,get_buttonMode: function() {
		return this.__buttonMode;
	}
	,set_buttonMode: function(value) {
		return this.__buttonMode = value;
	}
	,__class__: openfl_display_Sprite
	,__properties__: $extend(openfl_display_DisplayObjectContainer.prototype.__properties__,{get_graphics:"get_graphics",set_buttonMode:"set_buttonMode",get_buttonMode:"get_buttonMode"})
});
var Main = function() {
	this.akudaikan = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/akudaikan.png"));
	this.tesita2 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/tesita.png"));
	this.tesita1 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/tesita.png"));
	this.chara2 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/jizou.png"));
	this.chara = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/jizou.png"));
	this.bitmap6 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.lll = new haxe_ds_StringMap();
	this.bitmap5 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.bitmap4 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.bitmap3 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.bitmap2 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.bitmap1 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/ob.png"));
	this.isibitmap8 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap7 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap6 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap5 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap4 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap3 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.isibitmap2 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.date = new Date();
	this.isibitmap1 = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/isi.png"));
	this.heartbitmap = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/heart.png"));
	this.scoreall = [0,0,0,0];
	this.BG = new openfl_display_Bitmap(openfl_utils_Assets.getBitmapData("assets/BG.jpg"));
	this.timer = new openfl_utils_Timer(100);
	this.bkg = new openfl_display_Sprite();
	openfl_display_Sprite.call(this);
	haxe_Log.trace("aaaaa",{ fileName : "Source/Main.hx", lineNumber : 73, className : "Main", methodName : "new"});
	this.life = 30;
	this.score = 0;
	this.timer2 = 100;
	this._text = new openfl_text_TextField();
	this.lifetext = new openfl_text_TextField();
	this.timertext = new openfl_text_TextField();
	this.gameovertext = new openfl_text_TextField();
	this.datatext = new openfl_text_TextField();
	this.datatext2 = new openfl_text_TextField();
	this.datatext3 = new openfl_text_TextField();
	this.datatext4 = new openfl_text_TextField();
	this._text.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.lifetext.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.timertext.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.gameovertext.set_defaultTextFormat(new openfl_text_TextFormat("Times",60,2105376));
	this.datatext.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.datatext2.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.datatext3.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.datatext4.set_defaultTextFormat(new openfl_text_TextFormat("Times",30,2105376));
	this.isiSound = openfl_utils_Assets.getSound("assets/isi.ogg");
	this.heartSound = openfl_utils_Assets.getSound("assets/heart.ogg");
	this.obSound = openfl_utils_Assets.getSound("assets/ob.ogg");
	this.bkg.get_graphics().beginFill(16777215,1);
	this.bkg.get_graphics().drawRect(0,0,768,1280);
	this.bkg.get_graphics().endFill();
	this._text.set_x(50);
	this._text.set_y(50);
	this._text.set_width(350);
	this._text.set_textColor(65535);
	this.lifetext.set_x(50);
	this.lifetext.set_y(100);
	this.lifetext.set_width(350);
	this.lifetext.set_textColor(16711680);
	this.timertext.set_x(50);
	this.timertext.set_y(150);
	this.timertext.set_width(350);
	this.timertext.set_textColor(0);
	this.gameovertext.set_x(150);
	this.gameovertext.set_y(150);
	this.gameovertext.set_width(350);
	this.datatext.set_x(250);
	this.datatext.set_y(250);
	this.datatext.set_width(250);
	this.chara2.set_x(100);
	this.chara2.set_y(100);
	this.addChild(this.bkg);
	this.addChild(this.BG);
	this.addChild(this.heartbitmap);
	this.addChild(this.isibitmap1);
	this.addChild(this.isibitmap2);
	this.addChild(this.isibitmap3);
	this.addChild(this.isibitmap4);
	this.addChild(this.isibitmap5);
	this.addChild(this.isibitmap6);
	this.addChild(this.isibitmap7);
	this.addChild(this.isibitmap8);
	this.addChild(this.bitmap1);
	this.addChild(this.bitmap2);
	this.addChild(this.bitmap3);
	this.addChild(this.bitmap4);
	this.addChild(this.bitmap5);
	this.addChild(this.bitmap6);
	this.addChild(this.tesita1);
	this.addChild(this.tesita2);
	this.addChild(this.akudaikan);
	this.addChild(this.chara);
	this.addChild(this._text);
	this.addChild(this.lifetext);
	this.addChild(this.timertext);
	this.isibitmap1.set_y(200);
	this.isibitmap1.set_x(200);
	this.isibitmap2.set_y(150);
	this.isibitmap2.set_x(150);
	this.isibitmap3.set_y(300);
	this.isibitmap3.set_x(300);
	this.isibitmap4.set_y(250);
	this.isibitmap4.set_x(250);
	this.isibitmap5.set_y(300);
	this.isibitmap5.set_x(300);
	this.isibitmap6.set_y(450);
	this.isibitmap6.set_x(450);
	this.isibitmap7.set_y(500);
	this.isibitmap7.set_x(500);
	this.isibitmap8.set_y(550);
	this.isibitmap8.set_x(550);
	this.tesita1.set_y(-3000);
	this.tesita1.set_x(400);
	this.tesita2.set_y(-3000);
	this.tesita2.set_x(200);
	this.akudaikan.set_y(-3500);
	this.akudaikan.set_x(0);
	this.heartbitmap.set_y(50);
	this.heartbitmap.set_x(50);
	this.bitmap1.set_y(100);
	this.bitmap2.set_y(200);
	this.bitmap3.set_y(200);
	this.bitmap4.set_y(100);
	this.bitmap5.set_y(200);
	this.bitmap6.set_y(200);
	this.bitmap1.set_x(100);
	this.bitmap2.set_x(200);
	this.bitmap3.set_x(300);
	this.bitmap4.set_x(400);
	this.bitmap5.set_x(500);
	this.bitmap6.set_x(600);
	this.addEventListener("enterFrame",$bind(this,this.loop));
};
$hxClasses["Main"] = Main;
Main.__name__ = "Main";
Main.__super__ = openfl_display_Sprite;
Main.prototype = $extend(openfl_display_Sprite.prototype,{
	loop: function(e) {
		this.chara.set_y(this.get_mouseY());
		this._text.set_text("Score スコア " + this.score);
		this.lifetext.set_text("Life " + this.life);
		this.time3 = this.timer2 / 100;
		this.timertext.set_text("Time " + this.time3);
		this.gameovertext.set_text("GAME OVER");
		this.timer2 += 1;
		this.chara.set_x(this.get_mouseX());
		var _g = this.isibitmap1;
		_g.set_y(_g.get_y() + 5);
		var _g = this.isibitmap2;
		_g.set_y(_g.get_y() + 5);
		var _g = this.isibitmap3;
		_g.set_y(_g.get_y() + 5);
		var _g = this.isibitmap4;
		_g.set_y(_g.get_y() + 5);
		var _g = this.isibitmap5;
		_g.set_y(_g.get_y() + 5);
		var _g = this.isibitmap6;
		_g.set_y(_g.get_y() + 5);
		var _g = this.isibitmap7;
		_g.set_y(_g.get_y() + 5);
		var _g = this.isibitmap8;
		_g.set_y(_g.get_y() + 5);
		var _g = this.heartbitmap;
		_g.set_y(_g.get_y() + 15);
		var _g = this.bitmap1;
		_g.set_y(_g.get_y() + 10);
		var _g = this.bitmap2;
		_g.set_y(_g.get_y() + 10);
		var _g = this.bitmap3;
		_g.set_y(_g.get_y() + 10);
		var _g = this.bitmap4;
		_g.set_y(_g.get_y() + 10);
		var _g = this.bitmap5;
		_g.set_y(_g.get_y() + 10);
		var _g = this.bitmap6;
		_g.set_y(_g.get_y() + 10);
		var _g = this.akudaikan;
		_g.set_y(_g.get_y() + 5);
		var _g = this.tesita1;
		_g.set_y(_g.get_y() + 5);
		var _g = this.tesita2;
		_g.set_y(_g.get_y() + 5);
		if(this.akudaikan.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.akudaikan.set_y(-1000);
			this.akudaikan.set_x(300);
			this.life -= 5;
			this.isiSound.play(0);
		}
		if(this.tesita1.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.tesita1.set_y(0);
			this.tesita1.set_x(Math.random() * 768);
			this.life -= 3;
			this.isiSound.play(0);
		}
		if(this.tesita2.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.tesita2.set_y(0);
			this.tesita2.set_x(Math.random() * 768);
			this.life -= 3;
			this.isiSound.play(0);
		}
		if(this.isibitmap1.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap1.set_y(0);
			this.isibitmap1.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap2.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap2.set_y(0);
			this.isibitmap2.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap3.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap3.set_y(0);
			this.isibitmap3.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap4.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap4.set_y(0);
			this.isibitmap4.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap5.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap5.set_y(0);
			this.isibitmap5.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap6.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap6.set_y(0);
			this.isibitmap6.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap7.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap7.set_y(0);
			this.isibitmap7.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.isibitmap8.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.isibitmap8.set_y(0);
			this.isibitmap8.set_x(Math.random() * 768);
			this.life -= 1;
			this.isiSound.play(0);
		}
		if(this.heartbitmap.hitTestPoint(this.chara.get_x(),this.chara.get_y(),false)) {
			this.heartbitmap.set_y(0);
			this.heartbitmap.set_x(Math.random() * 768);
			this.life += 1;
			this.heartSound.play(0);
		}
		if(this.bitmap1.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap1.set_y(0);
			this.bitmap1.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.bitmap2.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap2.set_y(0);
			this.bitmap2.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.bitmap3.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap3.set_y(0);
			this.bitmap3.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.bitmap4.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap4.set_y(0);
			this.bitmap4.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.bitmap5.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap5.set_y(0);
			this.bitmap5.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.bitmap6.hitTestPoint(this.chara.get_x(),this.chara.get_y(),true)) {
			this.bitmap6.set_y(0);
			this.bitmap6.set_x(Math.random() * 768);
			this.score += 1;
			this.obSound.play(0);
		}
		if(this.akudaikan.get_y() >= 1280) {
			this.akudaikan.set_y(-3000);
			this.akudaikan.set_x(400);
		}
		if(this.tesita1.get_y() >= 1280) {
			this.tesita1.set_y(-1000);
			this.tesita1.set_x(Math.random() * 768);
		}
		if(this.tesita2.get_y() >= 1280) {
			this.tesita2.set_y(-1000);
			this.tesita2.set_x(Math.random() * 768);
		}
		if(this.isibitmap1.get_y() >= 1280) {
			this.isibitmap1.set_y(0);
			this.isibitmap1.set_x(Math.random() * 768);
		}
		if(this.isibitmap2.get_y() >= 1280) {
			this.isibitmap2.set_y(0);
			this.isibitmap2.set_x(Math.random() * 768);
		}
		if(this.isibitmap3.get_y() >= 1280) {
			this.isibitmap3.set_y(0);
			this.isibitmap3.set_x(Math.random() * 768);
		}
		if(this.isibitmap4.get_y() >= 1280) {
			this.isibitmap4.set_y(0);
			this.isibitmap4.set_x(Math.random() * 768);
		}
		if(this.isibitmap5.get_y() >= 1280) {
			this.isibitmap5.set_y(0);
			this.isibitmap5.set_x(Math.random() * 768);
		}
		if(this.isibitmap6.get_y() >= 1280) {
			this.isibitmap6.set_y(0);
			this.isibitmap6.set_x(Math.random() * 768);
		}
		if(this.isibitmap7.get_y() >= 1280) {
			this.isibitmap7.set_y(0);
			this.isibitmap7.set_x(Math.random() * 768);
		}
		if(this.isibitmap8.get_y() >= 1280) {
			this.isibitmap8.set_y(0);
			this.isibitmap8.set_x(Math.random() * 768);
		}
		if(this.heartbitmap.get_y() >= 1280) {
			this.heartbitmap.set_y(0);
			this.heartbitmap.set_x(Math.random() * 768);
		}
		if(this.bitmap1.get_y() >= 1280) {
			this.bitmap1.set_y(0);
			this.bitmap1.set_x(Math.random() * 768);
		}
		if(this.bitmap2.get_y() >= 1280) {
			this.bitmap2.set_y(0);
			this.bitmap2.set_x(Math.random() * 768);
		}
		if(this.bitmap3.get_y() >= 1280) {
			this.bitmap3.set_y(0);
			this.bitmap3.set_x(Math.random() * 768);
		}
		if(this.bitmap4.get_y() >= 1280) {
			this.bitmap4.set_y(0);
			this.bitmap4.set_x(Math.random() * 768);
		}
		if(this.bitmap5.get_y() >= 1280) {
			this.bitmap5.set_y(0);
			this.bitmap5.set_x(Math.random() * 768);
		}
		if(this.bitmap6.get_y() >= 1280) {
			this.bitmap6.set_y(0);
			this.bitmap6.set_x(Math.random() * 768);
		}
		if(this.life == 0) {
			this.removeChild(this.heartbitmap);
			this.removeChild(this.isibitmap1);
			this.removeChild(this.isibitmap2);
			this.removeChild(this.isibitmap3);
			this.removeChild(this.isibitmap4);
			this.removeChild(this.isibitmap5);
			this.removeChild(this.isibitmap6);
			this.removeChild(this.isibitmap7);
			this.removeChild(this.isibitmap8);
			this.removeChild(this.bitmap1);
			this.removeChild(this.bitmap2);
			this.removeChild(this.bitmap3);
			this.removeChild(this.bitmap4);
			this.removeChild(this.bitmap5);
			this.removeChild(this.bitmap6);
			this.removeChild(this.akudaikan);
			this.removeChild(this.tesita1);
			this.removeChild(this.tesita2);
			this.chara2.set_scaleY(this.score);
			this.chara2.set_scaleX(this.score);
			this.removeChild(this.chara);
			this.removeChild(this.BG);
			this.removeChild(this.timertext);
			this.addChild(this.gameovertext);
			e.preventDefault();
		}
		if(this.time3 == 30.00) {
			haxe_Log.trace(this.scoreall,{ fileName : "Source/Main.hx", lineNumber : 447, className : "Main", methodName : "loop"});
			haxe_Log.trace(js_Cookie.all(),{ fileName : "Source/Main.hx", lineNumber : 448, className : "Main", methodName : "loop"});
			this.removeChild(this.heartbitmap);
			this.removeChild(this.isibitmap1);
			this.removeChild(this.isibitmap2);
			this.removeChild(this.isibitmap3);
			this.removeChild(this.isibitmap4);
			this.removeChild(this.isibitmap5);
			this.removeChild(this.isibitmap6);
			this.removeChild(this.isibitmap7);
			this.removeChild(this.isibitmap8);
			this.removeChild(this.bitmap1);
			this.removeChild(this.bitmap2);
			this.removeChild(this.bitmap3);
			this.removeChild(this.bitmap4);
			this.removeChild(this.bitmap5);
			this.removeChild(this.bitmap6);
			this.removeChild(this.akudaikan);
			this.removeChild(this.tesita1);
			this.removeChild(this.tesita2);
			this.removeChild(this.BG);
			this.chara2.set_scaleY(this.score);
			this.chara2.set_scaleX(this.score);
			this.removeChild(this.chara);
			this.addChild(this.chara2);
			this.removeChild(this.timertext);
			this.addChild(this.gameovertext);
			this.scoreall[0] = Std.parseInt(js_Cookie.get("1"));
			this.scoreall[1] = Std.parseInt(js_Cookie.get("2"));
			this.scoreall[2] = Std.parseInt(js_Cookie.get("3"));
			this.scoreall[3] = Std.parseInt(js_Cookie.get("4"));
			haxe_Log.trace(this.scoreall,{ fileName : "Source/Main.hx", lineNumber : 486, className : "Main", methodName : "loop"});
			this.scoreall.push(this.score);
			haxe_Log.trace(js_Cookie.all(),{ fileName : "Source/Main.hx", lineNumber : 488, className : "Main", methodName : "loop"});
			this.scoreall.sort(function(a,b) {
				return b - a;
			});
			haxe_Log.trace(this.score,{ fileName : "Source/Main.hx", lineNumber : 492, className : "Main", methodName : "loop"});
			haxe_Log.trace(js_Cookie.all(),{ fileName : "Source/Main.hx", lineNumber : 493, className : "Main", methodName : "loop"});
			js_Cookie.set("1",Std.string(this.scoreall[0]));
			js_Cookie.set("2",Std.string(this.scoreall[1]));
			js_Cookie.set("3",Std.string(this.scoreall[2]));
			js_Cookie.set("4",Std.string(this.scoreall[3]));
			haxe_Log.trace(js_Cookie.all(),{ fileName : "Source/Main.hx", lineNumber : 498, className : "Main", methodName : "loop"});
			haxe_Log.trace(this.scoreall,{ fileName : "Source/Main.hx", lineNumber : 499, className : "Main", methodName : "loop"});
			this.datatext.set_text(js_Cookie.get("1"));
			this.datatext2.set_text(js_Cookie.get("2"));
			this.datatext3.set_text(js_Cookie.get("3"));
			this.datatext4.set_text(js_Cookie.get("4"));
			this.datatext.set_width(500);
			this.datatext.set_x(100);
			this.datatext.set_y(50);
			this.addChild(this.datatext);
			this.datatext2.set_width(500);
			this.datatext2.set_x(200);
			this.datatext2.set_y(50);
			this.addChild(this.datatext2);
			this.datatext3.set_width(500);
			this.datatext3.set_x(300);
			this.datatext3.set_y(50);
			this.addChild(this.datatext3);
			this.datatext4.set_width(500);
			this.datatext4.set_x(400);
			this.datatext4.set_y(50);
			this.addChild(this.datatext4);
			haxe_Log.trace(Std.string(this.scoreall),{ fileName : "Source/Main.hx", lineNumber : 540, className : "Main", methodName : "loop"});
			e.stopImmediatePropagation();
			var value = "hoge";
			var domain = "renge-lotus.net";
			var path = "/";
			var expiresDelay = 1000;
		}
	}
	,__class__: Main
});
var DocumentClass = function(current) {
	current.addChild(this);
	Main.call(this);
	this.dispatchEvent(new openfl_events_Event("addedToStage",false,false));
};
$hxClasses["DocumentClass"] = DocumentClass;
DocumentClass.__name__ = "DocumentClass";
DocumentClass.__super__ = Main;
DocumentClass.prototype = $extend(Main.prototype,{
	__class__: DocumentClass
});
var EReg = function(r,opt) {
	this.r = new RegExp(r,opt.split("u").join(""));
};
$hxClasses["EReg"] = EReg;
EReg.__name__ = "EReg";
EReg.prototype = {
	match: function(s) {
		if(this.r.global) {
			this.r.lastIndex = 0;
		}
		this.r.m = this.r.exec(s);
		this.r.s = s;
		return this.r.m != null;
	}
	,matched: function(n) {
		if(this.r.m != null && n >= 0 && n < this.r.m.length) {
			return this.r.m[n];
		} else {
			throw haxe_Exception.thrown("EReg::matched");
		}
	}
	,matchedRight: function() {
		if(this.r.m == null) {
			throw haxe_Exception.thrown("No string matched");
		}
		var sz = this.r.m.index + this.r.m[0].length;
		return HxOverrides.substr(this.r.s,sz,this.r.s.length - sz);
	}
	,matchedPos: function() {
		if(this.r.m == null) {
			throw haxe_Exception.thrown("No string matched");
		}
		return { pos : this.r.m.index, len : this.r.m[0].length};
	}
	,matchSub: function(s,pos,len) {
		if(len == null) {
			len = -1;
		}
		if(this.r.global) {
			this.r.lastIndex = pos;
			this.r.m = this.r.exec(len < 0 ? s : HxOverrides.substr(s,0,pos + len));
			var b = this.r.m != null;
			if(b) {
				this.r.s = s;
			}
			return b;
		} else {
			var b = this.match(len < 0 ? HxOverrides.substr(s,pos,null) : HxOverrides.substr(s,pos,len));
			if(b) {
				this.r.s = s;
				this.r.m.index += pos;
			}
			return b;
		}
	}
	,split: function(s) {
		var d = "#__delim__#";
		return s.replace(this.r,d).split(d);
	}
	,map: function(s,f) {
		var offset = 0;
		var buf_b = "";
		while(true) {
			if(offset >= s.length) {
				break;
			} else if(!this.matchSub(s,offset)) {
				buf_b += Std.string(HxOverrides.substr(s,offset,null));
				break;
			}
			var p = this.matchedPos();
			buf_b += Std.string(HxOverrides.substr(s,offset,p.pos - offset));
			buf_b += Std.string(f(this));
			if(p.len == 0) {
				buf_b += Std.string(HxOverrides.substr(s,p.pos,1));
				offset = p.pos + 1;
			} else {
				offset = p.pos + p.len;
			}
			if(!this.r.global) {
				break;
			}
		}
		if(!this.r.global && offset > 0 && offset < s.length) {
			buf_b += Std.string(HxOverrides.substr(s,offset,null));
		}
		return buf_b;
	}
	,__class__: EReg
};
var HxOverrides = function() { };
$hxClasses["HxOverrides"] = HxOverrides;
HxOverrides.__name__ = "HxOverrides";
HxOverrides.strDate = function(s) {
	switch(s.length) {
	case 8:
		var k = s.split(":");
		var d = new Date();
		d["setTime"](0);
		d["setUTCHours"](k[0]);
		d["setUTCMinutes"](k[1]);
		d["setUTCSeconds"](k[2]);
		return d;
	case 10:
		var k = s.split("-");
		return new Date(k[0],k[1] - 1,k[2],0,0,0);
	case 19:
		var k = s.split(" ");
		var y = k[0].split("-");
		var t = k[1].split(":");
		return new Date(y[0],y[1] - 1,y[2],t[0],t[1],t[2]);
	default:
		throw haxe_Exception.thrown("Invalid date format : " + s);
	}
};
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
HxOverrides.now = function() {
	return Date.now();
};
var Lambda = function() { };
$hxClasses["Lambda"] = Lambda;
Lambda.__name__ = "Lambda";
Lambda.array = function(it) {
	var a = [];
	var i = $getIterator(it);
	while(i.hasNext()) {
		var i1 = i.next();
		a.push(i1);
	}
	return a;
};
var ManifestResources = function() { };
$hxClasses["ManifestResources"] = ManifestResources;
ManifestResources.__name__ = "ManifestResources";
ManifestResources.init = function(config) {
	ManifestResources.preloadLibraries = [];
	ManifestResources.preloadLibraryNames = [];
	ManifestResources.rootPath = null;
	if(config != null && Object.prototype.hasOwnProperty.call(config,"rootPath")) {
		ManifestResources.rootPath = Reflect.field(config,"rootPath");
	}
	if(ManifestResources.rootPath == null) {
		ManifestResources.rootPath = "./";
	}
	var bundle;
	var data = "{\"name\":null,\"assets\":\"aoy4:pathy19:assets%2Ftesita.pngy4:sizei4666y4:typey5:IMAGEy2:idR1y7:preloadtgoR0y16:assets%2Fisi.pngR2i827R3R4R5R7R6tgoR0y19:assets%2Fheart2.pngR2i472R3R4R5R8R6tgoR0y23:assets%2Fheart.png.backR2i570R3y6:BINARYR5R9R6tgoR0y22:assets%2Fakudaikan.pngR2i16302R3R4R5R11R6tgoR0y15:assets%2FBG.jpgR2i8727R3R4R5R12R6tgoR0y15:assets%2Fob.pngR2i931R3R4R5R13R6tgoR2i15880R3y5:SOUNDR5y19:assets%2Fdamage.wavy9:pathGroupaR15hR6tgoR0y18:assets%2Fheart.pngR2i1156R3R4R5R17R6tgoR2i37813R3R14R5y18:assets%2Fheart.oggR16aR18hR6tgoR0y18:assets%2Fjizou.pngR2i1588R3R4R5R19R6tgoR2i18287R3R14R5y16:assets%2Fisi.oggR16aR20hR6tgoR2i26933R3R14R5y15:assets%2Fob.oggR16aR21hR6tgh\",\"rootPath\":null,\"version\":2,\"libraryArgs\":[],\"libraryType\":null}";
	var manifest = lime_utils_AssetManifest.parse(data,ManifestResources.rootPath);
	var library = lime_utils_AssetLibrary.fromManifest(manifest);
	lime_utils_Assets.registerLibrary("default",library);
	library = lime_utils_Assets.getLibrary("default");
	if(library != null) {
		ManifestResources.preloadLibraries.push(library);
	} else {
		ManifestResources.preloadLibraryNames.push("default");
	}
};
Math.__name__ = "Math";
var Reflect = function() { };
$hxClasses["Reflect"] = Reflect;
Reflect.__name__ = "Reflect";
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( _g ) {
		haxe_NativeStackTrace.lastError = _g;
		return null;
	}
};
Reflect.getProperty = function(o,field) {
	var tmp;
	if(o == null) {
		return null;
	} else {
		var tmp1;
		if(o.__properties__) {
			tmp = o.__properties__["get_" + field];
			tmp1 = tmp;
		} else {
			tmp1 = false;
		}
		if(tmp1) {
			return o[tmp]();
		} else {
			return o[field];
		}
	}
};
Reflect.setProperty = function(o,field,value) {
	var tmp;
	var tmp1;
	if(o.__properties__) {
		tmp = o.__properties__["set_" + field];
		tmp1 = tmp;
	} else {
		tmp1 = false;
	}
	if(tmp1) {
		o[tmp](value);
	} else {
		o[field] = value;
	}
};
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(f != "__id__" && f != "hx__closures__" && hasOwnProperty.call(o,f)) {
			a.push(f);
		}
		}
	}
	return a;
};
Reflect.isFunction = function(f) {
	if(typeof(f) == "function") {
		return !(f.__name__ || f.__ename__);
	} else {
		return false;
	}
};
Reflect.compare = function(a,b) {
	if(a == b) {
		return 0;
	} else if(a > b) {
		return 1;
	} else {
		return -1;
	}
};
Reflect.compareMethods = function(f1,f2) {
	if(f1 == f2) {
		return true;
	}
	if(!Reflect.isFunction(f1) || !Reflect.isFunction(f2)) {
		return false;
	}
	if(f1.scope == f2.scope && f1.method == f2.method) {
		return f1.method != null;
	} else {
		return false;
	}
};
Reflect.isEnumValue = function(v) {
	if(v != null) {
		return v.__enum__ != null;
	} else {
		return false;
	}
};
Reflect.deleteField = function(o,field) {
	if(!Object.prototype.hasOwnProperty.call(o,field)) {
		return false;
	}
	delete(o[field]);
	return true;
};
Reflect.makeVarArgs = function(f) {
	return function() {
		var a = Array.prototype.slice;
		var a1 = arguments;
		var a2 = a.call(a1);
		return f(a2);
	};
};
var Std = function() { };
$hxClasses["Std"] = Std;
Std.__name__ = "Std";
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
Std.parseInt = function(x) {
	if(x != null) {
		var _g = 0;
		var _g1 = x.length;
		while(_g < _g1) {
			var i = _g++;
			var c = x.charCodeAt(i);
			if(c <= 8 || c >= 14 && c != 32 && c != 45) {
				var nc = x.charCodeAt(i + 1);
				var v = parseInt(x,nc == 120 || nc == 88 ? 16 : 10);
				if(isNaN(v)) {
					return null;
				} else {
					return v;
				}
			}
		}
	}
	return null;
};
var _$String_String_$Impl_$ = function() { };
$hxClasses["_String.String_Impl_"] = _$String_String_$Impl_$;
_$String_String_$Impl_$.__name__ = "_String.String_Impl_";
_$String_String_$Impl_$.fromCharCode = function(code) {
	return String.fromCodePoint(code);
};
var StringBuf = function() {
	this.b = "";
};
$hxClasses["StringBuf"] = StringBuf;
StringBuf.__name__ = "StringBuf";
StringBuf.prototype = {
	__class__: StringBuf
};
var StringTools = function() { };
$hxClasses["StringTools"] = StringTools;
StringTools.__name__ = "StringTools";
StringTools.htmlEscape = function(s,quotes) {
	var buf_b = "";
	var _g_offset = 0;
	var _g_s = s;
	while(_g_offset < _g_s.length) {
		var s = _g_s;
		var index = _g_offset++;
		var c = s.charCodeAt(index);
		if(c >= 55296 && c <= 56319) {
			c = c - 55232 << 10 | s.charCodeAt(index + 1) & 1023;
		}
		var c1 = c;
		if(c1 >= 65536) {
			++_g_offset;
		}
		var code = c1;
		switch(code) {
		case 34:
			if(quotes) {
				buf_b += "&quot;";
			} else {
				buf_b += String.fromCodePoint(code);
			}
			break;
		case 38:
			buf_b += "&amp;";
			break;
		case 39:
			if(quotes) {
				buf_b += "&#039;";
			} else {
				buf_b += String.fromCodePoint(code);
			}
			break;
		case 60:
			buf_b += "&lt;";
			break;
		case 62:
			buf_b += "&gt;";
			break;
		default:
			buf_b += String.fromCodePoint(code);
		}
	}
	return buf_b;
};
StringTools.htmlUnescape = function(s) {
	return s.split("&gt;").join(">").split("&lt;").join("<").split("&quot;").join("\"").split("&#039;").join("'").split("&amp;").join("&");
};
StringTools.startsWith = function(s,start) {
	if(s.length >= start.length) {
		return s.lastIndexOf(start,0) == 0;
	} else {
		return false;
	}
};
StringTools.endsWith = function(s,end) {
	var elen = end.length;
	var slen = s.length;
	if(slen >= elen) {
		return s.indexOf(end,slen - elen) == slen - elen;
	} else {
		return false;
	}
};
StringTools.isSpace = function(s,pos) {
	var c = HxOverrides.cca(s,pos);
	if(!(c > 8 && c < 14)) {
		return c == 32;
	} else {
		return true;
	}
};
StringTools.ltrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,r)) ++r;
	if(r > 0) {
		return HxOverrides.substr(s,r,l - r);
	} else {
		return s;
	}
};
StringTools.rtrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,l - r - 1)) ++r;
	if(r > 0) {
		return HxOverrides.substr(s,0,l - r);
	} else {
		return s;
	}
};
StringTools.trim = function(s) {
	return StringTools.ltrim(StringTools.rtrim(s));
};
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
StringTools.hex = function(n,digits) {
	var s = "";
	var hexChars = "0123456789ABCDEF";
	while(true) {
		s = hexChars.charAt(n & 15) + s;
		n >>>= 4;
		if(!(n > 0)) {
			break;
		}
	}
	if(digits != null) {
		while(s.length < digits) s = "0" + s;
	}
	return s;
};
var ValueType = $hxEnums["ValueType"] = { __ename__ : "ValueType", __constructs__ : ["TNull","TInt","TFloat","TBool","TObject","TFunction","TClass","TEnum","TUnknown"]
	,TNull: {_hx_index:0,__enum__:"ValueType",toString:$estr}
	,TInt: {_hx_index:1,__enum__:"ValueType",toString:$estr}
	,TFloat: {_hx_index:2,__enum__:"ValueType",toString:$estr}
	,TBool: {_hx_index:3,__enum__:"ValueType",toString:$estr}
	,TObject: {_hx_index:4,__enum__:"ValueType",toString:$estr}
	,TFunction: {_hx_index:5,__enum__:"ValueType",toString:$estr}
	,TClass: ($_=function(c) { return {_hx_index:6,c:c,__enum__:"ValueType",toString:$estr}; },$_.__params__ = ["c"],$_)
	,TEnum: ($_=function(e) { return {_hx_index:7,e:e,__enum__:"ValueType",toString:$estr}; },$_.__params__ = ["e"],$_)
	,TUnknown: {_hx_index:8,__enum__:"ValueType",toString:$estr}
};
var Type = function() { };
$hxClasses["Type"] = Type;
Type.__name__ = "Type";
Type.resolveEnum = function(name) {
	return $hxEnums[name];
};
Type.createInstance = function(cl,args) {
	var ctor = Function.prototype.bind.apply(cl,[null].concat(args));
	return new (ctor);
};
Type.createEnum = function(e,constr,params) {
	var f = Reflect.field(e,constr);
	if(f == null) {
		throw haxe_Exception.thrown("No such constructor " + constr);
	}
	if(Reflect.isFunction(f)) {
		if(params == null) {
			throw haxe_Exception.thrown("Constructor " + constr + " need parameters");
		}
		return f.apply(e,params);
	}
	if(params != null && params.length != 0) {
		throw haxe_Exception.thrown("Constructor " + constr + " does not need parameters");
	}
	return f;
};
Type.typeof = function(v) {
	switch(typeof(v)) {
	case "boolean":
		return ValueType.TBool;
	case "function":
		if(v.__name__ || v.__ename__) {
			return ValueType.TObject;
		}
		return ValueType.TFunction;
	case "number":
		if(Math.ceil(v) == v % 2147483648.0) {
			return ValueType.TInt;
		}
		return ValueType.TFloat;
	case "object":
		if(v == null) {
			return ValueType.TNull;
		}
		var e = v.__enum__;
		if(e != null) {
			return ValueType.TEnum($hxEnums[e]);
		}
		var c = js_Boot.getClass(v);
		if(c != null) {
			return ValueType.TClass(c);
		}
		return ValueType.TObject;
	case "string":
		return ValueType.TClass(String);
	case "undefined":
		return ValueType.TNull;
	default:
		return ValueType.TUnknown;
	}
};
Type.enumParameters = function(e) {
	var enm = $hxEnums[e.__enum__];
	var ctorName = enm.__constructs__[e._hx_index];
	var params = enm[ctorName].__params__;
	if(params != null) {
		var _g = [];
		var _g1 = 0;
		while(_g1 < params.length) {
			var p = params[_g1];
			++_g1;
			_g.push(e[p]);
		}
		return _g;
	} else {
		return [];
	}
};
var UInt = {};
UInt.gt = function(a,b) {
	var aNeg = a < 0;
	var bNeg = b < 0;
	if(aNeg != bNeg) {
		return aNeg;
	} else {
		return a > b;
	}
};
UInt.toFloat = function(this1) {
	var int = this1;
	if(int < 0) {
		return 4294967296.0 + int;
	} else {
		return int + 0.0;
	}
};
var haxe_StackItem = $hxEnums["haxe.StackItem"] = { __ename__ : "haxe.StackItem", __constructs__ : ["CFunction","Module","FilePos","Method","LocalFunction"]
	,CFunction: {_hx_index:0,__enum__:"haxe.StackItem",toString:$estr}
	,Module: ($_=function(m) { return {_hx_index:1,m:m,__enum__:"haxe.StackItem",toString:$estr}; },$_.__params__ = ["m"],$_)
	,FilePos: ($_=function(s,file,line,column) { return {_hx_index:2,s:s,file:file,line:line,column:column,__enum__:"haxe.StackItem",toString:$estr}; },$_.__params__ = ["s","file","line","column"],$_)
	,Method: ($_=function(classname,method) { return {_hx_index:3,classname:classname,method:method,__enum__:"haxe.StackItem",toString:$estr}; },$_.__params__ = ["classname","method"],$_)
	,LocalFunction: ($_=function(v) { return {_hx_index:4,v:v,__enum__:"haxe.StackItem",toString:$estr}; },$_.__params__ = ["v"],$_)
};
var haxe_CallStack = {};
haxe_CallStack.callStack = function() {
	return haxe_NativeStackTrace.toHaxe(haxe_NativeStackTrace.callStack());
};
haxe_CallStack.exceptionStack = function(fullStack) {
	if(fullStack == null) {
		fullStack = false;
	}
	var eStack = haxe_NativeStackTrace.toHaxe(haxe_NativeStackTrace.exceptionStack());
	return fullStack ? eStack : haxe_CallStack.subtract(eStack,haxe_CallStack.callStack());
};
haxe_CallStack.toString = function(stack) {
	var b = new StringBuf();
	var _g = 0;
	var _g1 = stack;
	while(_g < _g1.length) {
		var s = _g1[_g];
		++_g;
		b.b += "\nCalled from ";
		haxe_CallStack.itemToString(b,s);
	}
	return b.b;
};
haxe_CallStack.subtract = function(this1,stack) {
	var startIndex = -1;
	var i = -1;
	while(++i < this1.length) {
		var _g = 0;
		var _g1 = stack.length;
		while(_g < _g1) {
			var j = _g++;
			if(haxe_CallStack.equalItems(this1[i],stack[j])) {
				if(startIndex < 0) {
					startIndex = i;
				}
				++i;
				if(i >= this1.length) {
					break;
				}
			} else {
				startIndex = -1;
			}
		}
		if(startIndex >= 0) {
			break;
		}
	}
	if(startIndex >= 0) {
		return this1.slice(0,startIndex);
	} else {
		return this1;
	}
};
haxe_CallStack.equalItems = function(item1,item2) {
	if(item1 == null) {
		if(item2 == null) {
			return true;
		} else {
			return false;
		}
	} else {
		switch(item1._hx_index) {
		case 0:
			if(item2 == null) {
				return false;
			} else if(item2._hx_index == 0) {
				return true;
			} else {
				return false;
			}
			break;
		case 1:
			if(item2 == null) {
				return false;
			} else if(item2._hx_index == 1) {
				var m1 = item1.m;
				var m2 = item2.m;
				return m1 == m2;
			} else {
				return false;
			}
			break;
		case 2:
			if(item2 == null) {
				return false;
			} else if(item2._hx_index == 2) {
				var item11 = item1.s;
				var file1 = item1.file;
				var line1 = item1.line;
				var col1 = item1.column;
				var col2 = item2.column;
				var line2 = item2.line;
				var file2 = item2.file;
				var item21 = item2.s;
				if(file1 == file2 && line1 == line2 && col1 == col2) {
					return haxe_CallStack.equalItems(item11,item21);
				} else {
					return false;
				}
			} else {
				return false;
			}
			break;
		case 3:
			if(item2 == null) {
				return false;
			} else if(item2._hx_index == 3) {
				var class1 = item1.classname;
				var method1 = item1.method;
				var method2 = item2.method;
				var class2 = item2.classname;
				if(class1 == class2) {
					return method1 == method2;
				} else {
					return false;
				}
			} else {
				return false;
			}
			break;
		case 4:
			if(item2 == null) {
				return false;
			} else if(item2._hx_index == 4) {
				var v1 = item1.v;
				var v2 = item2.v;
				return v1 == v2;
			} else {
				return false;
			}
			break;
		}
	}
};
haxe_CallStack.itemToString = function(b,s) {
	switch(s._hx_index) {
	case 0:
		b.b += "a C function";
		break;
	case 1:
		var m = s.m;
		b.b += "module ";
		b.b += m == null ? "null" : "" + m;
		break;
	case 2:
		var col = s.column;
		var line = s.line;
		var file = s.file;
		var s1 = s.s;
		if(s1 != null) {
			haxe_CallStack.itemToString(b,s1);
			b.b += " (";
		}
		b.b += file == null ? "null" : "" + file;
		b.b += " line ";
		b.b += line == null ? "null" : "" + line;
		if(col != null) {
			b.b += " column ";
			b.b += col == null ? "null" : "" + col;
		}
		if(s1 != null) {
			b.b += ")";
		}
		break;
	case 3:
		var meth = s.method;
		var cname = s.classname;
		b.b += Std.string(cname == null ? "<unknown>" : cname);
		b.b += ".";
		b.b += meth == null ? "null" : "" + meth;
		break;
	case 4:
		var n = s.v;
		b.b += "local function #";
		b.b += n == null ? "null" : "" + n;
		break;
	}
};
var haxe_Exception = function(message,previous,native) {
	Error.call(this,message);
	this.message = message;
	this.__previousException = previous;
	this.__nativeException = native != null ? native : this;
	this.__skipStack = 0;
	var old = Error.prepareStackTrace;
	Error.prepareStackTrace = function(e) { return e.stack; }
	if(((native) instanceof Error)) {
		this.stack = native.stack;
	} else {
		var e = null;
		if(Error.captureStackTrace) {
			Error.captureStackTrace(this,haxe_Exception);
			e = this;
		} else {
			e = new Error();
			if(typeof(e.stack) == "undefined") {
				try { throw e; } catch(_) {}
				this.__skipStack++;
			}
		}
		this.stack = e.stack;
	}
	Error.prepareStackTrace = old;
};
$hxClasses["haxe.Exception"] = haxe_Exception;
haxe_Exception.__name__ = "haxe.Exception";
haxe_Exception.caught = function(value) {
	if(((value) instanceof haxe_Exception)) {
		return value;
	} else if(((value) instanceof Error)) {
		return new haxe_Exception(value.message,null,value);
	} else {
		return new haxe_ValueException(value,null,value);
	}
};
haxe_Exception.thrown = function(value) {
	if(((value) instanceof haxe_Exception)) {
		return value.get_native();
	} else if(((value) instanceof Error)) {
		return value;
	} else {
		var e = new haxe_ValueException(value);
		e.__skipStack++;
		return e;
	}
};
haxe_Exception.__super__ = Error;
haxe_Exception.prototype = $extend(Error.prototype,{
	unwrap: function() {
		return this.__nativeException;
	}
	,__shiftStack: function() {
		this.__skipStack++;
	}
	,get_native: function() {
		return this.__nativeException;
	}
	,get_stack: function() {
		var _g = this.__exceptionStack;
		if(_g == null) {
			var value = haxe_NativeStackTrace.toHaxe(haxe_NativeStackTrace.normalize(this.stack),this.__skipStack);
			this.setProperty("__exceptionStack",value);
			return value;
		} else {
			var s = _g;
			return s;
		}
	}
	,setProperty: function(name,value) {
		try {
			Object.defineProperty(this,name,{ value : value});
		} catch( _g ) {
			this[name] = value;
		}
	}
	,__class__: haxe_Exception
	,__properties__: {get_native:"get_native",get_stack:"get_stack"}
});
var haxe__$Int64__$_$_$Int64 = function(high,low) {
	this.high = high;
	this.low = low;
};
$hxClasses["haxe._Int64.___Int64"] = haxe__$Int64__$_$_$Int64;
haxe__$Int64__$_$_$Int64.__name__ = "haxe._Int64.___Int64";
haxe__$Int64__$_$_$Int64.prototype = {
	__class__: haxe__$Int64__$_$_$Int64
};
var haxe_Log = function() { };
$hxClasses["haxe.Log"] = haxe_Log;
haxe_Log.__name__ = "haxe.Log";
haxe_Log.formatOutput = function(v,infos) {
	var str = Std.string(v);
	if(infos == null) {
		return str;
	}
	var pstr = infos.fileName + ":" + infos.lineNumber;
	if(infos.customParams != null) {
		var _g = 0;
		var _g1 = infos.customParams;
		while(_g < _g1.length) {
			var v = _g1[_g];
			++_g;
			str += ", " + Std.string(v);
		}
	}
	return pstr + ": " + str;
};
haxe_Log.trace = function(v,infos) {
	var str = haxe_Log.formatOutput(v,infos);
	if(typeof(console) != "undefined" && console.log != null) {
		console.log(str);
	}
};
var haxe_NativeStackTrace = function() { };
$hxClasses["haxe.NativeStackTrace"] = haxe_NativeStackTrace;
haxe_NativeStackTrace.__name__ = "haxe.NativeStackTrace";
haxe_NativeStackTrace.saveStack = function(e) {
	haxe_NativeStackTrace.lastError = e;
};
haxe_NativeStackTrace.callStack = function() {
	var e = new Error("");
	var stack = haxe_NativeStackTrace.tryHaxeStack(e);
	if(typeof(stack) == "undefined") {
		try {
			throw e;
		} catch( _g ) {
		}
		stack = e.stack;
	}
	return haxe_NativeStackTrace.normalize(stack,2);
};
haxe_NativeStackTrace.exceptionStack = function() {
	return haxe_NativeStackTrace.normalize(haxe_NativeStackTrace.tryHaxeStack(haxe_NativeStackTrace.lastError));
};
haxe_NativeStackTrace.toHaxe = function(s,skip) {
	if(skip == null) {
		skip = 0;
	}
	if(s == null) {
		return [];
	} else if(typeof(s) == "string") {
		var stack = s.split("\n");
		if(stack[0] == "Error") {
			stack.shift();
		}
		var m = [];
		var _g = 0;
		var _g1 = stack.length;
		while(_g < _g1) {
			var i = _g++;
			if(skip > i) {
				continue;
			}
			var line = stack[i];
			var matched = line.match(/^    at ([A-Za-z0-9_. ]+) \(([^)]+):([0-9]+):([0-9]+)\)$/);
			if(matched != null) {
				var path = matched[1].split(".");
				if(path[0] == "$hxClasses") {
					path.shift();
				}
				var meth = path.pop();
				var file = matched[2];
				var line1 = Std.parseInt(matched[3]);
				var column = Std.parseInt(matched[4]);
				m.push(haxe_StackItem.FilePos(meth == "Anonymous function" ? haxe_StackItem.LocalFunction() : meth == "Global code" ? null : haxe_StackItem.Method(path.join("."),meth),file,line1,column));
			} else {
				m.push(haxe_StackItem.Module(StringTools.trim(line)));
			}
		}
		return m;
	} else if(skip > 0 && Array.isArray(s)) {
		return s.slice(skip);
	} else {
		return s;
	}
};
haxe_NativeStackTrace.tryHaxeStack = function(e) {
	if(e == null) {
		return [];
	}
	var oldValue = Error.prepareStackTrace;
	Error.prepareStackTrace = haxe_NativeStackTrace.prepareHxStackTrace;
	var stack = e.stack;
	Error.prepareStackTrace = oldValue;
	return stack;
};
haxe_NativeStackTrace.prepareHxStackTrace = function(e,callsites) {
	var stack = [];
	var _g = 0;
	while(_g < callsites.length) {
		var site = callsites[_g];
		++_g;
		if(haxe_NativeStackTrace.wrapCallSite != null) {
			site = haxe_NativeStackTrace.wrapCallSite(site);
		}
		var method = null;
		var fullName = site.getFunctionName();
		if(fullName != null) {
			var idx = fullName.lastIndexOf(".");
			if(idx >= 0) {
				var className = fullName.substring(0,idx);
				var methodName = fullName.substring(idx + 1);
				method = haxe_StackItem.Method(className,methodName);
			} else {
				method = haxe_StackItem.Method(null,fullName);
			}
		}
		var fileName = site.getFileName();
		var fileAddr = fileName == null ? -1 : fileName.indexOf("file:");
		if(haxe_NativeStackTrace.wrapCallSite != null && fileAddr > 0) {
			fileName = fileName.substring(fileAddr + 6);
		}
		stack.push(haxe_StackItem.FilePos(method,fileName,site.getLineNumber(),site.getColumnNumber()));
	}
	return stack;
};
haxe_NativeStackTrace.normalize = function(stack,skipItems) {
	if(skipItems == null) {
		skipItems = 0;
	}
	if(Array.isArray(stack) && skipItems > 0) {
		return stack.slice(skipItems);
	} else if(typeof(stack) == "string") {
		switch(stack.substring(0,6)) {
		case "Error\n":case "Error:":
			++skipItems;
			break;
		default:
		}
		return haxe_NativeStackTrace.skipLines(stack,skipItems);
	} else {
		return stack;
	}
};
haxe_NativeStackTrace.skipLines = function(stack,skip,pos) {
	if(pos == null) {
		pos = 0;
	}
	if(skip > 0) {
		pos = stack.indexOf("\n",pos);
		if(pos < 0) {
			return "";
		} else {
			return haxe_NativeStackTrace.skipLines(stack,--skip,pos + 1);
		}
	} else {
		return stack.substring(pos);
	}
};
var haxe_Serializer = function() {
	this.buf = new StringBuf();
	this.cache = [];
	this.useCache = haxe_Serializer.USE_CACHE;
	this.useEnumIndex = haxe_Serializer.USE_ENUM_INDEX;
	this.shash = new haxe_ds_StringMap();
	this.scount = 0;
};
$hxClasses["haxe.Serializer"] = haxe_Serializer;
haxe_Serializer.__name__ = "haxe.Serializer";
haxe_Serializer.run = function(v) {
	var s = new haxe_Serializer();
	s.serialize(v);
	return s.toString();
};
haxe_Serializer.prototype = {
	toString: function() {
		return this.buf.b;
	}
	,serializeString: function(s) {
		var x = this.shash.h[s];
		if(x != null) {
			this.buf.b += "R";
			this.buf.b += x == null ? "null" : "" + x;
			return;
		}
		this.shash.h[s] = this.scount++;
		this.buf.b += "y";
		s = encodeURIComponent(s);
		this.buf.b += Std.string(s.length);
		this.buf.b += ":";
		this.buf.b += s == null ? "null" : "" + s;
	}
	,serializeRef: function(v) {
		var vt = typeof(v);
		var _g = 0;
		var _g1 = this.cache.length;
		while(_g < _g1) {
			var i = _g++;
			var ci = this.cache[i];
			if(typeof(ci) == vt && ci == v) {
				this.buf.b += "r";
				this.buf.b += i == null ? "null" : "" + i;
				return true;
			}
		}
		this.cache.push(v);
		return false;
	}
	,serializeFields: function(v) {
		var _g = 0;
		var _g1 = Reflect.fields(v);
		while(_g < _g1.length) {
			var f = _g1[_g];
			++_g;
			this.serializeString(f);
			this.serialize(Reflect.field(v,f));
		}
		this.buf.b += "g";
	}
	,serialize: function(v) {
		var _g = Type.typeof(v);
		switch(_g._hx_index) {
		case 0:
			this.buf.b += "n";
			break;
		case 1:
			var v1 = v;
			if(v1 == 0) {
				this.buf.b += "z";
				return;
			}
			this.buf.b += "i";
			this.buf.b += v1 == null ? "null" : "" + v1;
			break;
		case 2:
			var v1 = v;
			if(isNaN(v1)) {
				this.buf.b += "k";
			} else if(!isFinite(v1)) {
				this.buf.b += v1 < 0 ? "m" : "p";
			} else {
				this.buf.b += "d";
				this.buf.b += v1 == null ? "null" : "" + v1;
			}
			break;
		case 3:
			this.buf.b += v ? "t" : "f";
			break;
		case 4:
			if(js_Boot.__instanceof(v,Class)) {
				var className = v.__name__;
				this.buf.b += "A";
				this.serializeString(className);
			} else if(js_Boot.__instanceof(v,Enum)) {
				this.buf.b += "B";
				this.serializeString(v.__ename__);
			} else {
				if(this.useCache && this.serializeRef(v)) {
					return;
				}
				this.buf.b += "o";
				this.serializeFields(v);
			}
			break;
		case 5:
			throw haxe_Exception.thrown("Cannot serialize function");
		case 6:
			var c = _g.c;
			if(c == String) {
				this.serializeString(v);
				return;
			}
			if(this.useCache && this.serializeRef(v)) {
				return;
			}
			switch(c) {
			case Array:
				var ucount = 0;
				this.buf.b += "a";
				var l = v["length"];
				var _g1 = 0;
				var _g2 = l;
				while(_g1 < _g2) {
					var i = _g1++;
					if(v[i] == null) {
						++ucount;
					} else {
						if(ucount > 0) {
							if(ucount == 1) {
								this.buf.b += "n";
							} else {
								this.buf.b += "u";
								this.buf.b += ucount == null ? "null" : "" + ucount;
							}
							ucount = 0;
						}
						this.serialize(v[i]);
					}
				}
				if(ucount > 0) {
					if(ucount == 1) {
						this.buf.b += "n";
					} else {
						this.buf.b += "u";
						this.buf.b += ucount == null ? "null" : "" + ucount;
					}
				}
				this.buf.b += "h";
				break;
			case Date:
				var d = v;
				this.buf.b += "v";
				this.buf.b += Std.string(d.getTime());
				break;
			case haxe_ds_IntMap:
				this.buf.b += "q";
				var v1 = v;
				var k = v1.keys();
				while(k.hasNext()) {
					var k1 = k.next();
					this.buf.b += ":";
					this.buf.b += k1 == null ? "null" : "" + k1;
					this.serialize(v1.h[k1]);
				}
				this.buf.b += "h";
				break;
			case haxe_ds_List:
				this.buf.b += "l";
				var v1 = v;
				var _g_head = v1.h;
				while(_g_head != null) {
					var val = _g_head.item;
					_g_head = _g_head.next;
					var i = val;
					this.serialize(i);
				}
				this.buf.b += "h";
				break;
			case haxe_ds_ObjectMap:
				this.buf.b += "M";
				var v1 = v;
				var k = v1.keys();
				while(k.hasNext()) {
					var k1 = k.next();
					var id = Reflect.field(k1,"__id__");
					Reflect.deleteField(k1,"__id__");
					this.serialize(k1);
					k1["__id__"] = id;
					this.serialize(v1.h[k1.__id__]);
				}
				this.buf.b += "h";
				break;
			case haxe_ds_StringMap:
				this.buf.b += "b";
				var v1 = v;
				var k = haxe_ds_StringMap.keysIterator(v1.h);
				while(k.hasNext()) {
					var k1 = k.next();
					this.serializeString(k1);
					this.serialize(v1.h[k1]);
				}
				this.buf.b += "h";
				break;
			case haxe_io_Bytes:
				var v1 = v;
				this.buf.b += "s";
				this.buf.b += Std.string(Math.ceil(v1.length * 8 / 6));
				this.buf.b += ":";
				var i = 0;
				var max = v1.length - 2;
				var b64 = haxe_Serializer.BASE64_CODES;
				if(b64 == null) {
					var this1 = new Array(haxe_Serializer.BASE64.length);
					b64 = this1;
					var _g1 = 0;
					var _g2 = haxe_Serializer.BASE64.length;
					while(_g1 < _g2) {
						var i1 = _g1++;
						b64[i1] = HxOverrides.cca(haxe_Serializer.BASE64,i1);
					}
					haxe_Serializer.BASE64_CODES = b64;
				}
				while(i < max) {
					var b1 = v1.b[i++];
					var b2 = v1.b[i++];
					var b3 = v1.b[i++];
					this.buf.b += String.fromCodePoint(b64[b1 >> 2]);
					this.buf.b += String.fromCodePoint(b64[(b1 << 4 | b2 >> 4) & 63]);
					this.buf.b += String.fromCodePoint(b64[(b2 << 2 | b3 >> 6) & 63]);
					this.buf.b += String.fromCodePoint(b64[b3 & 63]);
				}
				if(i == max) {
					var b1 = v1.b[i++];
					var b2 = v1.b[i++];
					this.buf.b += String.fromCodePoint(b64[b1 >> 2]);
					this.buf.b += String.fromCodePoint(b64[(b1 << 4 | b2 >> 4) & 63]);
					this.buf.b += String.fromCodePoint(b64[b2 << 2 & 63]);
				} else if(i == max + 1) {
					var b1 = v1.b[i++];
					this.buf.b += String.fromCodePoint(b64[b1 >> 2]);
					this.buf.b += String.fromCodePoint(b64[b1 << 4 & 63]);
				}
				break;
			default:
				if(this.useCache) {
					this.cache.pop();
				}
				if(v.hxSerialize != null) {
					this.buf.b += "C";
					this.serializeString(c.__name__);
					if(this.useCache) {
						this.cache.push(v);
					}
					v.hxSerialize(this);
					this.buf.b += "g";
				} else {
					this.buf.b += "c";
					this.serializeString(c.__name__);
					if(this.useCache) {
						this.cache.push(v);
					}
					this.serializeFields(v);
				}
			}
			break;
		case 7:
			var e = _g.e;
			if(this.useCache) {
				if(this.serializeRef(v)) {
					return;
				}
				this.cache.pop();
			}
			this.buf.b += Std.string(this.useEnumIndex ? "j" : "w");
			this.serializeString(e.__ename__);
			if(this.useEnumIndex) {
				this.buf.b += ":";
				this.buf.b += Std.string(v._hx_index);
			} else {
				var e = v;
				this.serializeString($hxEnums[e.__enum__].__constructs__[e._hx_index]);
			}
			this.buf.b += ":";
			var params = Type.enumParameters(v);
			this.buf.b += Std.string(params.length);
			var _g = 0;
			while(_g < params.length) {
				var p = params[_g];
				++_g;
				this.serialize(p);
			}
			if(this.useCache) {
				this.cache.push(v);
			}
			break;
		default:
			throw haxe_Exception.thrown("Cannot serialize " + Std.string(v));
		}
	}
	,__class__: haxe_Serializer
};
var haxe_Timer = function(time_ms) {
	var me = this;
	this.id = setInterval(function() {
		me.run();
	},time_ms);
};
$hxClasses["haxe.Timer"] = haxe_Timer;
haxe_Timer.__name__ = "haxe.Timer";
haxe_Timer.delay = function(f,time_ms) {
	var t = new haxe_Timer(time_ms);
	t.run = function() {
		t.stop();
		f();
	};
	return t;
};
haxe_Timer.measure = function(f,pos) {
	var t0 = new Date().getTime() / 1000;
	var r = f();
	haxe_Log.trace(new Date().getTime() / 1000 - t0 + "s",pos);
	return r;
};
haxe_Timer.stamp = function() {
	return new Date().getTime() / 1000;
};
haxe_Timer.prototype = {
	stop: function() {
		if(this.id == null) {
			return;
		}
		clearInterval(this.id);
		this.id = null;
	}
	,run: function() {
	}
	,__class__: haxe_Timer
};
var haxe__$Unserializer_DefaultResolver = function() {
};
$hxClasses["haxe._Unserializer.DefaultResolver"] = haxe__$Unserializer_DefaultResolver;
haxe__$Unserializer_DefaultResolver.__name__ = "haxe._Unserializer.DefaultResolver";
haxe__$Unserializer_DefaultResolver.prototype = {
	resolveClass: function(name) {
		return $hxClasses[name];
	}
	,resolveEnum: function(name) {
		return $hxEnums[name];
	}
	,__class__: haxe__$Unserializer_DefaultResolver
};
var haxe_Unserializer = function(buf) {
	this.buf = buf;
	this.length = buf.length;
	this.pos = 0;
	this.scache = [];
	this.cache = [];
	var r = haxe_Unserializer.DEFAULT_RESOLVER;
	if(r == null) {
		r = new haxe__$Unserializer_DefaultResolver();
		haxe_Unserializer.DEFAULT_RESOLVER = r;
	}
	this.resolver = r;
};
$hxClasses["haxe.Unserializer"] = haxe_Unserializer;
haxe_Unserializer.__name__ = "haxe.Unserializer";
haxe_Unserializer.initCodes = function() {
	var codes = [];
	var _g = 0;
	var _g1 = haxe_Unserializer.BASE64.length;
	while(_g < _g1) {
		var i = _g++;
		codes[haxe_Unserializer.BASE64.charCodeAt(i)] = i;
	}
	return codes;
};
haxe_Unserializer.run = function(v) {
	return new haxe_Unserializer(v).unserialize();
};
haxe_Unserializer.prototype = {
	setResolver: function(r) {
		if(r == null) {
			if(haxe__$Unserializer_NullResolver.instance == null) {
				haxe__$Unserializer_NullResolver.instance = new haxe__$Unserializer_NullResolver();
			}
			this.resolver = haxe__$Unserializer_NullResolver.instance;
		} else {
			this.resolver = r;
		}
	}
	,readDigits: function() {
		var k = 0;
		var s = false;
		var fpos = this.pos;
		while(true) {
			var c = this.buf.charCodeAt(this.pos);
			if(c != c) {
				break;
			}
			if(c == 45) {
				if(this.pos != fpos) {
					break;
				}
				s = true;
				this.pos++;
				continue;
			}
			if(c < 48 || c > 57) {
				break;
			}
			k = k * 10 + (c - 48);
			this.pos++;
		}
		if(s) {
			k *= -1;
		}
		return k;
	}
	,readFloat: function() {
		var p1 = this.pos;
		while(true) {
			var c = this.buf.charCodeAt(this.pos);
			if(c != c) {
				break;
			}
			if(c >= 43 && c < 58 || c == 101 || c == 69) {
				this.pos++;
			} else {
				break;
			}
		}
		return parseFloat(HxOverrides.substr(this.buf,p1,this.pos - p1));
	}
	,unserializeObject: function(o) {
		while(true) {
			if(this.pos >= this.length) {
				throw haxe_Exception.thrown("Invalid object");
			}
			if(this.buf.charCodeAt(this.pos) == 103) {
				break;
			}
			var k = this.unserialize();
			if(typeof(k) != "string") {
				throw haxe_Exception.thrown("Invalid object key");
			}
			var v = this.unserialize();
			o[k] = v;
		}
		this.pos++;
	}
	,unserializeEnum: function(edecl,tag) {
		if(this.buf.charCodeAt(this.pos++) != 58) {
			throw haxe_Exception.thrown("Invalid enum format");
		}
		var nargs = this.readDigits();
		if(nargs == 0) {
			return Type.createEnum(edecl,tag);
		}
		var args = [];
		while(nargs-- > 0) args.push(this.unserialize());
		return Type.createEnum(edecl,tag,args);
	}
	,unserialize: function() {
		switch(this.buf.charCodeAt(this.pos++)) {
		case 65:
			var name = this.unserialize();
			var cl = this.resolver.resolveClass(name);
			if(cl == null) {
				throw haxe_Exception.thrown("Class not found " + name);
			}
			return cl;
		case 66:
			var name = this.unserialize();
			var e = this.resolver.resolveEnum(name);
			if(e == null) {
				throw haxe_Exception.thrown("Enum not found " + name);
			}
			return e;
		case 67:
			var name = this.unserialize();
			var cl = this.resolver.resolveClass(name);
			if(cl == null) {
				throw haxe_Exception.thrown("Class not found " + name);
			}
			var o = Object.create(cl.prototype);
			this.cache.push(o);
			o.hxUnserialize(this);
			if(this.buf.charCodeAt(this.pos++) != 103) {
				throw haxe_Exception.thrown("Invalid custom data");
			}
			return o;
		case 77:
			var h = new haxe_ds_ObjectMap();
			this.cache.push(h);
			var buf = this.buf;
			while(this.buf.charCodeAt(this.pos) != 104) {
				var s = this.unserialize();
				h.set(s,this.unserialize());
			}
			this.pos++;
			return h;
		case 82:
			var n = this.readDigits();
			if(n < 0 || n >= this.scache.length) {
				throw haxe_Exception.thrown("Invalid string reference");
			}
			return this.scache[n];
		case 97:
			var buf = this.buf;
			var a = [];
			this.cache.push(a);
			while(true) {
				var c = this.buf.charCodeAt(this.pos);
				if(c == 104) {
					this.pos++;
					break;
				}
				if(c == 117) {
					this.pos++;
					var n = this.readDigits();
					a[a.length + n - 1] = null;
				} else {
					a.push(this.unserialize());
				}
			}
			return a;
		case 98:
			var h = new haxe_ds_StringMap();
			this.cache.push(h);
			var buf = this.buf;
			while(this.buf.charCodeAt(this.pos) != 104) {
				var s = this.unserialize();
				var value = this.unserialize();
				h.h[s] = value;
			}
			this.pos++;
			return h;
		case 99:
			var name = this.unserialize();
			var cl = this.resolver.resolveClass(name);
			if(cl == null) {
				throw haxe_Exception.thrown("Class not found " + name);
			}
			var o = Object.create(cl.prototype);
			this.cache.push(o);
			this.unserializeObject(o);
			return o;
		case 100:
			return this.readFloat();
		case 102:
			return false;
		case 105:
			return this.readDigits();
		case 106:
			var name = this.unserialize();
			var edecl = this.resolver.resolveEnum(name);
			if(edecl == null) {
				throw haxe_Exception.thrown("Enum not found " + name);
			}
			this.pos++;
			var index = this.readDigits();
			var tag = edecl.__constructs__.slice()[index];
			if(tag == null) {
				throw haxe_Exception.thrown("Unknown enum index " + name + "@" + index);
			}
			var e = this.unserializeEnum(edecl,tag);
			this.cache.push(e);
			return e;
		case 107:
			return NaN;
		case 108:
			var l = new haxe_ds_List();
			this.cache.push(l);
			var buf = this.buf;
			while(this.buf.charCodeAt(this.pos) != 104) l.add(this.unserialize());
			this.pos++;
			return l;
		case 109:
			return -Infinity;
		case 110:
			return null;
		case 111:
			var o = { };
			this.cache.push(o);
			this.unserializeObject(o);
			return o;
		case 112:
			return Infinity;
		case 113:
			var h = new haxe_ds_IntMap();
			this.cache.push(h);
			var buf = this.buf;
			var c = this.buf.charCodeAt(this.pos++);
			while(c == 58) {
				var i = this.readDigits();
				var value = this.unserialize();
				h.h[i] = value;
				c = this.buf.charCodeAt(this.pos++);
			}
			if(c != 104) {
				throw haxe_Exception.thrown("Invalid IntMap format");
			}
			return h;
		case 114:
			var n = this.readDigits();
			if(n < 0 || n >= this.cache.length) {
				throw haxe_Exception.thrown("Invalid reference");
			}
			return this.cache[n];
		case 115:
			var len = this.readDigits();
			var buf = this.buf;
			if(this.buf.charCodeAt(this.pos++) != 58 || this.length - this.pos < len) {
				throw haxe_Exception.thrown("Invalid bytes length");
			}
			var codes = haxe_Unserializer.CODES;
			if(codes == null) {
				codes = haxe_Unserializer.initCodes();
				haxe_Unserializer.CODES = codes;
			}
			var i = this.pos;
			var rest = len & 3;
			var size = (len >> 2) * 3 + (rest >= 2 ? rest - 1 : 0);
			var max = i + (len - rest);
			var bytes = new haxe_io_Bytes(new ArrayBuffer(size));
			var bpos = 0;
			while(i < max) {
				var c1 = codes[buf.charCodeAt(i++)];
				var c2 = codes[buf.charCodeAt(i++)];
				bytes.b[bpos++] = (c1 << 2 | c2 >> 4) & 255;
				var c3 = codes[buf.charCodeAt(i++)];
				bytes.b[bpos++] = (c2 << 4 | c3 >> 2) & 255;
				var c4 = codes[buf.charCodeAt(i++)];
				bytes.b[bpos++] = (c3 << 6 | c4) & 255;
			}
			if(rest >= 2) {
				var c1 = codes[buf.charCodeAt(i++)];
				var c2 = codes[buf.charCodeAt(i++)];
				bytes.b[bpos++] = (c1 << 2 | c2 >> 4) & 255;
				if(rest == 3) {
					var c3 = codes[buf.charCodeAt(i++)];
					bytes.b[bpos++] = (c2 << 4 | c3 >> 2) & 255;
				}
			}
			this.pos += len;
			this.cache.push(bytes);
			return bytes;
		case 116:
			return true;
		case 118:
			var d;
			if(this.buf.charCodeAt(this.pos) >= 48 && this.buf.charCodeAt(this.pos) <= 57 && this.buf.charCodeAt(this.pos + 1) >= 48 && this.buf.charCodeAt(this.pos + 1) <= 57 && this.buf.charCodeAt(this.pos + 2) >= 48 && this.buf.charCodeAt(this.pos + 2) <= 57 && this.buf.charCodeAt(this.pos + 3) >= 48 && this.buf.charCodeAt(this.pos + 3) <= 57 && this.buf.charCodeAt(this.pos + 4) == 45) {
				d = HxOverrides.strDate(HxOverrides.substr(this.buf,this.pos,19));
				this.pos += 19;
			} else {
				d = new Date(this.readFloat());
			}
			this.cache.push(d);
			return d;
		case 119:
			var name = this.unserialize();
			var edecl = this.resolver.resolveEnum(name);
			if(edecl == null) {
				throw haxe_Exception.thrown("Enum not found " + name);
			}
			var e = this.unserializeEnum(edecl,this.unserialize());
			this.cache.push(e);
			return e;
		case 120:
			throw haxe_Exception.thrown(this.unserialize());
		case 121:
			var len = this.readDigits();
			if(this.buf.charCodeAt(this.pos++) != 58 || this.length - this.pos < len) {
				throw haxe_Exception.thrown("Invalid string length");
			}
			var s = HxOverrides.substr(this.buf,this.pos,len);
			this.pos += len;
			s = decodeURIComponent(s.split("+").join(" "));
			this.scache.push(s);
			return s;
		case 122:
			return 0;
		default:
		}
		this.pos--;
		throw haxe_Exception.thrown("Invalid char " + this.buf.charAt(this.pos) + " at position " + this.pos);
	}
	,__class__: haxe_Unserializer
};
var haxe__$Unserializer_NullResolver = function() {
};
$hxClasses["haxe._Unserializer.NullResolver"] = haxe__$Unserializer_NullResolver;
haxe__$Unserializer_NullResolver.__name__ = "haxe._Unserializer.NullResolver";
haxe__$Unserializer_NullResolver.prototype = {
	resolveClass: function(name) {
		return null;
	}
	,resolveEnum: function(name) {
		return null;
	}
	,__class__: haxe__$Unserializer_NullResolver
};
var haxe_ValueException = function(value,previous,native) {
	haxe_Exception.call(this,String(value),previous,native);
	this.value = value;
	this.__skipStack++;
};
$hxClasses["haxe.ValueException"] = haxe_ValueException;
haxe_ValueException.__name__ = "haxe.ValueException";
haxe_ValueException.__super__ = haxe_Exception;
haxe_ValueException.prototype = $extend(haxe_Exception.prototype,{
	unwrap: function() {
		return this.value;
	}
	,__class__: haxe_ValueException
});
var haxe_crypto_Adler32 = function() {
	this.a1 = 1;
	this.a2 = 0;
};
$hxClasses["haxe.crypto.Adler32"] = haxe_crypto_Adler32;
haxe_crypto_Adler32.__name__ = "haxe.crypto.Adler32";
haxe_crypto_Adler32.read = function(i) {
	var a = new haxe_crypto_Adler32();
	var a2a = i.readByte();
	var a2b = i.readByte();
	var a1a = i.readByte();
	var a1b = i.readByte();
	a.a1 = a1a << 8 | a1b;
	a.a2 = a2a << 8 | a2b;
	return a;
};
haxe_crypto_Adler32.prototype = {
	update: function(b,pos,len) {
		var a1 = this.a1;
		var a2 = this.a2;
		var _g = pos;
		var _g1 = pos + len;
		while(_g < _g1) {
			var p = _g++;
			var c = b.b[p];
			a1 = (a1 + c) % 65521;
			a2 = (a2 + a1) % 65521;
		}
		this.a1 = a1;
		this.a2 = a2;
	}
	,equals: function(a) {
		if(a.a1 == this.a1) {
			return a.a2 == this.a2;
		} else {
			return false;
		}
	}
	,__class__: haxe_crypto_Adler32
};
var haxe_io_Bytes = function(data) {
	this.length = data.byteLength;
	this.b = new Uint8Array(data);
	this.b.bufferValue = data;
	data.hxBytes = this;
	data.bytes = this.b;
};
$hxClasses["haxe.io.Bytes"] = haxe_io_Bytes;
haxe_io_Bytes.__name__ = "haxe.io.Bytes";
haxe_io_Bytes.alloc = function(length) {
	return new haxe_io_Bytes(new ArrayBuffer(length));
};
haxe_io_Bytes.ofString = function(s,encoding) {
	var a = [];
	var i = 0;
	while(i < s.length) {
		var c = s.charCodeAt(i++);
		if(55296 <= c && c <= 56319) {
			c = c - 55232 << 10 | s.charCodeAt(i++) & 1023;
		}
		if(c <= 127) {
			a.push(c);
		} else if(c <= 2047) {
			a.push(192 | c >> 6);
			a.push(128 | c & 63);
		} else if(c <= 65535) {
			a.push(224 | c >> 12);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		} else {
			a.push(240 | c >> 18);
			a.push(128 | c >> 12 & 63);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		}
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.ofData = function(b) {
	var hb = b.hxBytes;
	if(hb != null) {
		return hb;
	}
	return new haxe_io_Bytes(b);
};
haxe_io_Bytes.ofHex = function(s) {
	if((s.length & 1) != 0) {
		throw haxe_Exception.thrown("Not a hex string (odd number of digits)");
	}
	var a = [];
	var i = 0;
	var len = s.length >> 1;
	while(i < len) {
		var high = s.charCodeAt(i * 2);
		var low = s.charCodeAt(i * 2 + 1);
		high = (high & 15) + ((high & 64) >> 6) * 9;
		low = (low & 15) + ((low & 64) >> 6) * 9;
		a.push((high << 4 | low) & 255);
		++i;
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.fastGet = function(b,pos) {
	return b.bytes[pos];
};
haxe_io_Bytes.prototype = {
	get: function(pos) {
		return this.b[pos];
	}
	,set: function(pos,v) {
		this.b[pos] = v & 255;
	}
	,blit: function(pos,src,srcpos,len) {
		if(pos < 0 || srcpos < 0 || len < 0 || pos + len > this.length || srcpos + len > src.length) {
			throw haxe_Exception.thrown(haxe_io_Error.OutsideBounds);
		}
		if(srcpos == 0 && len == src.b.byteLength) {
			this.b.set(src.b,pos);
		} else {
			this.b.set(src.b.subarray(srcpos,srcpos + len),pos);
		}
	}
	,fill: function(pos,len,value) {
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			this.b[pos++] = value & 255;
		}
	}
	,sub: function(pos,len) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw haxe_Exception.thrown(haxe_io_Error.OutsideBounds);
		}
		return new haxe_io_Bytes(this.b.buffer.slice(pos + this.b.byteOffset,pos + this.b.byteOffset + len));
	}
	,compare: function(other) {
		var b1 = this.b;
		var b2 = other.b;
		var len = this.length < other.length ? this.length : other.length;
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			if(b1[i] != b2[i]) {
				return b1[i] - b2[i];
			}
		}
		return this.length - other.length;
	}
	,initData: function() {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
	}
	,getDouble: function(pos) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		return this.data.getFloat64(pos,true);
	}
	,getFloat: function(pos) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		return this.data.getFloat32(pos,true);
	}
	,setDouble: function(pos,v) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		this.data.setFloat64(pos,v,true);
	}
	,setFloat: function(pos,v) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		this.data.setFloat32(pos,v,true);
	}
	,getUInt16: function(pos) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		return this.data.getUint16(pos,true);
	}
	,setUInt16: function(pos,v) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		this.data.setUint16(pos,v,true);
	}
	,getInt32: function(pos) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		return this.data.getInt32(pos,true);
	}
	,setInt32: function(pos,v) {
		if(this.data == null) {
			this.data = new DataView(this.b.buffer,this.b.byteOffset,this.b.byteLength);
		}
		this.data.setInt32(pos,v,true);
	}
	,getInt64: function(pos) {
		var this1 = new haxe__$Int64__$_$_$Int64(this.getInt32(pos + 4),this.getInt32(pos));
		return this1;
	}
	,setInt64: function(pos,v) {
		this.setInt32(pos,v.low);
		this.setInt32(pos + 4,v.high);
	}
	,getString: function(pos,len,encoding) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw haxe_Exception.thrown(haxe_io_Error.OutsideBounds);
		}
		var s = "";
		var b = this.b;
		var fcc = _$String_String_$Impl_$.fromCharCode;
		var i = pos;
		var max = pos + len;
		while(i < max) {
			var c = b[i++];
			if(c < 128) {
				if(c == 0) {
					break;
				}
				s += fcc(c);
			} else if(c < 224) {
				s += fcc((c & 63) << 6 | b[i++] & 127);
			} else if(c < 240) {
				var c2 = b[i++];
				s += fcc((c & 31) << 12 | (c2 & 127) << 6 | b[i++] & 127);
			} else {
				var c21 = b[i++];
				var c3 = b[i++];
				var u = (c & 15) << 18 | (c21 & 127) << 12 | (c3 & 127) << 6 | b[i++] & 127;
				s += fcc((u >> 10) + 55232);
				s += fcc(u & 1023 | 56320);
			}
		}
		return s;
	}
	,readString: function(pos,len) {
		return this.getString(pos,len);
	}
	,toString: function() {
		return this.getString(0,this.length);
	}
	,toHex: function() {
		var s_b = "";
		var chars = [];
		var str = "0123456789abcdef";
		var _g = 0;
		var _g1 = str.length;
		while(_g < _g1) {
			var i = _g++;
			chars.push(HxOverrides.cca(str,i));
		}
		var _g = 0;
		var _g1 = this.length;
		while(_g < _g1) {
			var i = _g++;
			var c = this.b[i];
			s_b += String.fromCodePoint(chars[c >> 4]);
			s_b += String.fromCodePoint(chars[c & 15]);
		}
		return s_b;
	}
	,getData: function() {
		return this.b.bufferValue;
	}
	,__class__: haxe_io_Bytes
};
var haxe_crypto_Base64 = function() { };
$hxClasses["haxe.crypto.Base64"] = haxe_crypto_Base64;
haxe_crypto_Base64.__name__ = "haxe.crypto.Base64";
haxe_crypto_Base64.decode = function(str,complement) {
	if(complement == null) {
		complement = true;
	}
	if(complement) {
		while(HxOverrides.cca(str,str.length - 1) == 61) str = HxOverrides.substr(str,0,-1);
	}
	return new haxe_crypto_BaseCode(haxe_crypto_Base64.BYTES).decodeBytes(haxe_io_Bytes.ofString(str));
};
var haxe_crypto_BaseCode = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) ++nbits;
	if(nbits > 8 || len != 1 << nbits) {
		throw haxe_Exception.thrown("BaseCode : base length must be a power of two.");
	}
	this.base = base;
	this.nbits = nbits;
};
$hxClasses["haxe.crypto.BaseCode"] = haxe_crypto_BaseCode;
haxe_crypto_BaseCode.__name__ = "haxe.crypto.BaseCode";
haxe_crypto_BaseCode.prototype = {
	initTable: function() {
		var tbl = [];
		var _g = 0;
		while(_g < 256) {
			var i = _g++;
			tbl[i] = -1;
		}
		var _g = 0;
		var _g1 = this.base.length;
		while(_g < _g1) {
			var i = _g++;
			tbl[this.base.b[i]] = i;
		}
		this.tbl = tbl;
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		var base = this.base;
		if(this.tbl == null) {
			this.initTable();
		}
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = new haxe_io_Bytes(new ArrayBuffer(size));
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.b[pin++]];
				if(i == -1) {
					throw haxe_Exception.thrown("BaseCode : invalid encoded char");
				}
				buf |= i;
			}
			curbits -= 8;
			out.b[pout++] = buf >> curbits & 255 & 255;
		}
		return out;
	}
	,__class__: haxe_crypto_BaseCode
};
var haxe_ds_ArraySort = function() { };
$hxClasses["haxe.ds.ArraySort"] = haxe_ds_ArraySort;
haxe_ds_ArraySort.__name__ = "haxe.ds.ArraySort";
haxe_ds_ArraySort.sort = function(a,cmp) {
	haxe_ds_ArraySort.rec(a,cmp,0,a.length);
};
haxe_ds_ArraySort.rec = function(a,cmp,from,to) {
	var middle = from + to >> 1;
	if(to - from < 12) {
		if(to <= from) {
			return;
		}
		var _g = from + 1;
		var _g1 = to;
		while(_g < _g1) {
			var i = _g++;
			var j = i;
			while(j > from) {
				if(cmp(a[j],a[j - 1]) < 0) {
					haxe_ds_ArraySort.swap(a,j - 1,j);
				} else {
					break;
				}
				--j;
			}
		}
		return;
	}
	haxe_ds_ArraySort.rec(a,cmp,from,middle);
	haxe_ds_ArraySort.rec(a,cmp,middle,to);
	haxe_ds_ArraySort.doMerge(a,cmp,from,middle,to,middle - from,to - middle);
};
haxe_ds_ArraySort.doMerge = function(a,cmp,from,pivot,to,len1,len2) {
	var first_cut;
	var second_cut;
	var len11;
	var len22;
	if(len1 == 0 || len2 == 0) {
		return;
	}
	if(len1 + len2 == 2) {
		if(cmp(a[pivot],a[from]) < 0) {
			haxe_ds_ArraySort.swap(a,pivot,from);
		}
		return;
	}
	if(len1 > len2) {
		len11 = len1 >> 1;
		first_cut = from + len11;
		second_cut = haxe_ds_ArraySort.lower(a,cmp,pivot,to,first_cut);
		len22 = second_cut - pivot;
	} else {
		len22 = len2 >> 1;
		second_cut = pivot + len22;
		first_cut = haxe_ds_ArraySort.upper(a,cmp,from,pivot,second_cut);
		len11 = first_cut - from;
	}
	haxe_ds_ArraySort.rotate(a,cmp,first_cut,pivot,second_cut);
	var new_mid = first_cut + len22;
	haxe_ds_ArraySort.doMerge(a,cmp,from,first_cut,new_mid,len11,len22);
	haxe_ds_ArraySort.doMerge(a,cmp,new_mid,second_cut,to,len1 - len11,len2 - len22);
};
haxe_ds_ArraySort.rotate = function(a,cmp,from,mid,to) {
	if(from == mid || mid == to) {
		return;
	}
	var n = haxe_ds_ArraySort.gcd(to - from,mid - from);
	while(n-- != 0) {
		var val = a[from + n];
		var shift = mid - from;
		var p1 = from + n;
		var p2 = from + n + shift;
		while(p2 != from + n) {
			a[p1] = a[p2];
			p1 = p2;
			if(to - p2 > shift) {
				p2 += shift;
			} else {
				p2 = from + (shift - (to - p2));
			}
		}
		a[p1] = val;
	}
};
haxe_ds_ArraySort.gcd = function(m,n) {
	while(n != 0) {
		var t = m % n;
		m = n;
		n = t;
	}
	return m;
};
haxe_ds_ArraySort.upper = function(a,cmp,from,to,val) {
	var len = to - from;
	var half;
	var mid;
	while(len > 0) {
		half = len >> 1;
		mid = from + half;
		if(cmp(a[val],a[mid]) < 0) {
			len = half;
		} else {
			from = mid + 1;
			len = len - half - 1;
		}
	}
	return from;
};
haxe_ds_ArraySort.lower = function(a,cmp,from,to,val) {
	var len = to - from;
	var half;
	var mid;
	while(len > 0) {
		half = len >> 1;
		mid = from + half;
		if(cmp(a[mid],a[val]) < 0) {
			from = mid + 1;
			len = len - half - 1;
		} else {
			len = half;
		}
	}
	return from;
};
haxe_ds_ArraySort.swap = function(a,i,j) {
	var tmp = a[i];
	a[i] = a[j];
	a[j] = tmp;
};
var haxe_ds_BalancedTree = function() {
};
$hxClasses["haxe.ds.BalancedTree"] = haxe_ds_BalancedTree;
haxe_ds_BalancedTree.__name__ = "haxe.ds.BalancedTree";
haxe_ds_BalancedTree.__interfaces__ = [haxe_IMap];
haxe_ds_BalancedTree.iteratorLoop = function(node,acc) {
	if(node != null) {
		haxe_ds_BalancedTree.iteratorLoop(node.left,acc);
		acc.push(node.value);
		haxe_ds_BalancedTree.iteratorLoop(node.right,acc);
	}
};
haxe_ds_BalancedTree.prototype = {
	set: function(key,value) {
		this.root = this.setLoop(key,value,this.root);
	}
	,get: function(key) {
		var node = this.root;
		while(node != null) {
			var c = this.compare(key,node.key);
			if(c == 0) {
				return node.value;
			}
			if(c < 0) {
				node = node.left;
			} else {
				node = node.right;
			}
		}
		return null;
	}
	,remove: function(key) {
		try {
			this.root = this.removeLoop(key,this.root);
			return true;
		} catch( _g ) {
			haxe_NativeStackTrace.lastError = _g;
			if(typeof(haxe_Exception.caught(_g).unwrap()) == "string") {
				return false;
			} else {
				throw _g;
			}
		}
	}
	,exists: function(key) {
		var node = this.root;
		while(node != null) {
			var c = this.compare(key,node.key);
			if(c == 0) {
				return true;
			} else if(c < 0) {
				node = node.left;
			} else {
				node = node.right;
			}
		}
		return false;
	}
	,iterator: function() {
		var ret = [];
		haxe_ds_BalancedTree.iteratorLoop(this.root,ret);
		return new haxe_iterators_ArrayIterator(ret);
	}
	,keyValueIterator: function() {
		return new haxe_iterators_MapKeyValueIterator(this);
	}
	,keys: function() {
		var ret = [];
		this.keysLoop(this.root,ret);
		return new haxe_iterators_ArrayIterator(ret);
	}
	,setLoop: function(k,v,node) {
		if(node == null) {
			return new haxe_ds_TreeNode(null,k,v,null);
		}
		var c = this.compare(k,node.key);
		if(c == 0) {
			return new haxe_ds_TreeNode(node.left,k,v,node.right,node == null ? 0 : node._height);
		} else if(c < 0) {
			var nl = this.setLoop(k,v,node.left);
			return this.balance(nl,node.key,node.value,node.right);
		} else {
			var nr = this.setLoop(k,v,node.right);
			return this.balance(node.left,node.key,node.value,nr);
		}
	}
	,removeLoop: function(k,node) {
		if(node == null) {
			throw haxe_Exception.thrown("Not_found");
		}
		var c = this.compare(k,node.key);
		if(c == 0) {
			return this.merge(node.left,node.right);
		} else if(c < 0) {
			return this.balance(this.removeLoop(k,node.left),node.key,node.value,node.right);
		} else {
			return this.balance(node.left,node.key,node.value,this.removeLoop(k,node.right));
		}
	}
	,keysLoop: function(node,acc) {
		if(node != null) {
			this.keysLoop(node.left,acc);
			acc.push(node.key);
			this.keysLoop(node.right,acc);
		}
	}
	,merge: function(t1,t2) {
		if(t1 == null) {
			return t2;
		}
		if(t2 == null) {
			return t1;
		}
		var t = this.minBinding(t2);
		return this.balance(t1,t.key,t.value,this.removeMinBinding(t2));
	}
	,minBinding: function(t) {
		if(t == null) {
			throw haxe_Exception.thrown("Not_found");
		} else if(t.left == null) {
			return t;
		} else {
			return this.minBinding(t.left);
		}
	}
	,removeMinBinding: function(t) {
		if(t.left == null) {
			return t.right;
		} else {
			return this.balance(this.removeMinBinding(t.left),t.key,t.value,t.right);
		}
	}
	,balance: function(l,k,v,r) {
		var hl = l == null ? 0 : l._height;
		var hr = r == null ? 0 : r._height;
		if(hl > hr + 2) {
			var _this = l.left;
			var _this1 = l.right;
			if((_this == null ? 0 : _this._height) >= (_this1 == null ? 0 : _this1._height)) {
				return new haxe_ds_TreeNode(l.left,l.key,l.value,new haxe_ds_TreeNode(l.right,k,v,r));
			} else {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l.left,l.key,l.value,l.right.left),l.right.key,l.right.value,new haxe_ds_TreeNode(l.right.right,k,v,r));
			}
		} else if(hr > hl + 2) {
			var _this = r.right;
			var _this1 = r.left;
			if((_this == null ? 0 : _this._height) > (_this1 == null ? 0 : _this1._height)) {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l,k,v,r.left),r.key,r.value,r.right);
			} else {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l,k,v,r.left.left),r.left.key,r.left.value,new haxe_ds_TreeNode(r.left.right,r.key,r.value,r.right));
			}
		} else {
			return new haxe_ds_TreeNode(l,k,v,r,(hl > hr ? hl : hr) + 1);
		}
	}
	,compare: function(k1,k2) {
		return Reflect.compare(k1,k2);
	}
	,__class__: haxe_ds_BalancedTree
};
var haxe_ds_TreeNode = function(l,k,v,r,h) {
	if(h == null) {
		h = -1;
	}
	this.left = l;
	this.key = k;
	this.value = v;
	this.right = r;
	if(h == -1) {
		var tmp;
		var _this = this.left;
		var _this1 = this.right;
		if((_this == null ? 0 : _this._height) > (_this1 == null ? 0 : _this1._height)) {
			var _this = this.left;
			tmp = _this == null ? 0 : _this._height;
		} else {
			var _this = this.right;
			tmp = _this == null ? 0 : _this._height;
		}
		this._height = tmp + 1;
	} else {
		this._height = h;
	}
};
$hxClasses["haxe.ds.TreeNode"] = haxe_ds_TreeNode;
haxe_ds_TreeNode.__name__ = "haxe.ds.TreeNode";
haxe_ds_TreeNode.prototype = {
	__class__: haxe_ds_TreeNode
};
var haxe_ds_EnumValueMap = function() {
	haxe_ds_BalancedTree.call(this);
};
$hxClasses["haxe.ds.EnumValueMap"] = haxe_ds_EnumValueMap;
haxe_ds_EnumValueMap.__name__ = "haxe.ds.EnumValueMap";
haxe_ds_EnumValueMap.__interfaces__ = [haxe_IMap];
haxe_ds_EnumValueMap.__super__ = haxe_ds_BalancedTree;
haxe_ds_EnumValueMap.prototype = $extend(haxe_ds_BalancedTree.prototype,{
	compare: function(k1,k2) {
		var d = k1._hx_index - k2._hx_index;
		if(d != 0) {
			return d;
		}
		var p1 = Type.enumParameters(k1);
		var p2 = Type.enumParameters(k2);
		if(p1.length == 0 && p2.length == 0) {
			return 0;
		}
		return this.compareArgs(p1,p2);
	}
	,compareArgs: function(a1,a2) {
		var ld = a1.length - a2.length;
		if(ld != 0) {
			return ld;
		}
		var _g = 0;
		var _g1 = a1.length;
		while(_g < _g1) {
			var i = _g++;
			var d = this.compareArg(a1[i],a2[i]);
			if(d != 0) {
				return d;
			}
		}
		return 0;
	}
	,compareArg: function(v1,v2) {
		if(Reflect.isEnumValue(v1) && Reflect.isEnumValue(v2)) {
			return this.compare(v1,v2);
		} else if(((v1) instanceof Array) && ((v2) instanceof Array)) {
			return this.compareArgs(v1,v2);
		} else {
			return Reflect.compare(v1,v2);
		}
	}
	,__class__: haxe_ds_EnumValueMap
});
var haxe_ds_IntMap = function() {
	this.h = { };
};
$hxClasses["haxe.ds.IntMap"] = haxe_ds_IntMap;
haxe_ds_IntMap.__name__ = "haxe.ds.IntMap";
haxe_ds_IntMap.__interfaces__ = [haxe_IMap];
haxe_ds_IntMap.prototype = {
	set: function(key,value) {
		this.h[key] = value;
	}
	,get: function(key) {
		return this.h[key];
	}
	,exists: function(key) {
		return this.h.hasOwnProperty(key);
	}
	,remove: function(key) {
		if(!this.h.hasOwnProperty(key)) {
			return false;
		}
		delete(this.h[key]);
		return true;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h ) if(this.h.hasOwnProperty(key)) a.push(key | 0);
		return new haxe_iterators_ArrayIterator(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i];
		}};
	}
	,keyValueIterator: function() {
		return new haxe_iterators_MapKeyValueIterator(this);
	}
	,__class__: haxe_ds_IntMap
};
var haxe_ds__$List_ListNode = function(item,next) {
	this.item = item;
	this.next = next;
};
$hxClasses["haxe.ds._List.ListNode"] = haxe_ds__$List_ListNode;
haxe_ds__$List_ListNode.__name__ = "haxe.ds._List.ListNode";
haxe_ds__$List_ListNode.prototype = {
	__class__: haxe_ds__$List_ListNode
};
var haxe_ds__$List_ListIterator = function(head) {
	this.head = head;
};
$hxClasses["haxe.ds._List.ListIterator"] = haxe_ds__$List_ListIterator;
haxe_ds__$List_ListIterator.__name__ = "haxe.ds._List.ListIterator";
haxe_ds__$List_ListIterator.prototype = {
	hasNext: function() {
		return this.head != null;
	}
	,next: function() {
		var val = this.head.item;
		this.head = this.head.next;
		return val;
	}
	,__class__: haxe_ds__$List_ListIterator
};
var haxe_ds_StringMap = function() {
	this.h = Object.create(null);
};
$hxClasses["haxe.ds.StringMap"] = haxe_ds_StringMap;
haxe_ds_StringMap.__name__ = "haxe.ds.StringMap";
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.keysIterator = function(h) {
	var keys = Object.keys(h);
	var len = keys.length;
	var idx = 0;
	return { hasNext : function() {
		return idx < len;
	}, next : function() {
		idx += 1;
		return keys[idx - 1];
	}};
};
haxe_ds_StringMap.valueIterator = function(h) {
	var keys = Object.keys(h);
	var len = keys.length;
	var idx = 0;
	return { hasNext : function() {
		return idx < len;
	}, next : function() {
		idx += 1;
		return h[keys[idx - 1]];
	}};
};
haxe_ds_StringMap.kvIterator = function(h) {
	var keys = Object.keys(h);
	var len = keys.length;
	var idx = 0;
	return { hasNext : function() {
		return idx < len;
	}, next : function() {
		idx += 1;
		var k = keys[idx - 1];
		return { key : k, value : h[k]};
	}};
};
haxe_ds_StringMap.stringify = function(h) {
	var s = "{";
	var first = true;
	for (var key in h) {
		if (first) first = false; else s += ',';
		s += key + ' => ' + Std.string(h[key]);
	}
	return s + "}";
};
haxe_ds_StringMap.prototype = {
	exists: function(key) {
		return Object.prototype.hasOwnProperty.call(this.h,key);
	}
	,get: function(key) {
		return this.h[key];
	}
	,set: function(key,value) {
		this.h[key] = value;
	}
	,remove: function(key) {
		if(Object.prototype.hasOwnProperty.call(this.h,key)) {
			delete(this.h[key]);
			return true;
		} else {
			return false;
		}
	}
	,keys: function() {
		return haxe_ds_StringMap.keysIterator(this.h);
	}
	,iterator: function() {
		return haxe_ds_StringMap.valueIterator(this.h);
	}
	,keyValueIterator: function() {
		return haxe_ds_StringMap.kvIterator(this.h);
	}
	,__class__: haxe_ds_StringMap
};
var haxe_io_BytesBuffer = function() {
	this.pos = 0;
	this.size = 0;
};
$hxClasses["haxe.io.BytesBuffer"] = haxe_io_BytesBuffer;
haxe_io_BytesBuffer.__name__ = "haxe.io.BytesBuffer";
haxe_io_BytesBuffer.prototype = {
	addByte: function(byte) {
		if(this.pos == this.size) {
			this.grow(1);
		}
		this.view.setUint8(this.pos++,byte);
	}
	,add: function(src) {
		if(this.pos + src.length > this.size) {
			this.grow(src.length);
		}
		if(this.size == 0) {
			return;
		}
		var sub = new Uint8Array(src.b.buffer,src.b.byteOffset,src.length);
		this.u8.set(sub,this.pos);
		this.pos += src.length;
	}
	,addBytes: function(src,pos,len) {
		if(pos < 0 || len < 0 || pos + len > src.length) {
			throw haxe_Exception.thrown(haxe_io_Error.OutsideBounds);
		}
		if(this.pos + len > this.size) {
			this.grow(len);
		}
		if(this.size == 0) {
			return;
		}
		var sub = new Uint8Array(src.b.buffer,src.b.byteOffset + pos,len);
		this.u8.set(sub,this.pos);
		this.pos += len;
	}
	,grow: function(delta) {
		var req = this.pos + delta;
		var nsize = this.size == 0 ? 16 : this.size;
		while(nsize < req) nsize = nsize * 3 >> 1;
		var nbuf = new ArrayBuffer(nsize);
		var nu8 = new Uint8Array(nbuf);
		if(this.size > 0) {
			nu8.set(this.u8);
		}
		this.size = nsize;
		this.buffer = nbuf;
		this.u8 = nu8;
		this.view = new DataView(this.buffer);
	}
	,getBytes: function() {
		if(this.size == 0) {
			return new haxe_io_Bytes(new ArrayBuffer(0));
		}
		var b = new haxe_io_Bytes(this.buffer);
		b.length = this.pos;
		return b;
	}
	,__class__: haxe_io_BytesBuffer
};
var haxe_io_Input = function() { };
$hxClasses["haxe.io.Input"] = haxe_io_Input;
haxe_io_Input.__name__ = "haxe.io.Input";
haxe_io_Input.prototype = {
	readByte: function() {
		throw haxe_Exception.thrown("Not implemented");
	}
	,readBytes: function(s,pos,len) {
		var k = len;
		var b = s.b;
		if(pos < 0 || len < 0 || pos + len > s.length) {
			throw haxe_Exception.thrown(haxe_io_Error.OutsideBounds);
		}
		try {
			while(k > 0) {
				b[pos] = this.readByte();
				++pos;
				--k;
			}
		} catch( _g ) {
			haxe_NativeStackTrace.lastError = _g;
			if(!((haxe_Exception.caught(_g).unwrap()) instanceof haxe_io_Eof)) {
				throw _g;
			}
		}
		return len - k;
	}
	,readFullBytes: function(s,pos,len) {
		while(len > 0) {
			var k = this.readBytes(s,pos,len);
			if(k == 0) {
				throw haxe_Exception.thrown(haxe_io_Error.Blocked);
			}
			pos += k;
			len -= k;
		}
	}
	,read: function(nbytes) {
		var s = new haxe_io_Bytes(new ArrayBuffer(nbytes));
		var p = 0;
		while(nbytes > 0) {
			var k = this.readBytes(s,p,nbytes);
			if(k == 0) {
				throw haxe_Exception.thrown(haxe_io_Error.Blocked);
			}
			p += k;
			nbytes -= k;
		}
		return s;
	}
	,readInt16: function() {
		var ch1 = this.readByte();
		var ch2 = this.readByte();
		var n = this.bigEndian ? ch2 | ch1 << 8 : ch1 | ch2 << 8;
		if((n & 32768) != 0) {
			return n - 65536;
		}
		return n;
	}
	,readUInt16: function() {
		var ch1 = this.readByte();
		var ch2 = this.readByte();
		if(this.bigEndian) {
			return ch2 | ch1 << 8;
		} else {
			return ch1 | ch2 << 8;
		}
	}
	,readInt32: function() {
		var ch1 = this.readByte();
		var ch2 = this.readByte();
		var ch3 = this.readByte();
		var ch4 = this.readByte();
		if(this.bigEndian) {
			return ch4 | ch3 << 8 | ch2 << 16 | ch1 << 24;
		} else {
			return ch1 | ch2 << 8 | ch3 << 16 | ch4 << 24;
		}
	}
	,readString: function(len,encoding) {
		var b = new haxe_io_Bytes(new ArrayBuffer(len));
		this.readFullBytes(b,0,len);
		return b.getString(0,len,encoding);
	}
	,__class__: haxe_io_Input
};
var haxe_io_BytesInput = function(b,pos,len) {
	if(pos == null) {
		pos = 0;
	}
	if(len == null) {
		len = b.length - pos;
	}
	if(pos < 0 || len < 0 || pos + len > b.length) {
		throw haxe_Exception.thrown(haxe_io_Error.OutsideBounds);
	}
	this.b = b.b;
	this.pos = pos;
	this.len = len;
	this.totlen = len;
};
$hxClasses["haxe.io.BytesInput"] = haxe_io_BytesInput;
haxe_io_BytesInput.__name__ = "haxe.io.BytesInput";
haxe_io_BytesInput.__super__ = haxe_io_Input;
haxe_io_BytesInput.prototype = $extend(haxe_io_Input.prototype,{
	readByte: function() {
		if(this.len == 0) {
			throw haxe_Exception.thrown(new haxe_io_Eof());
		}
		this.len--;
		return this.b[this.pos++];
	}
	,readBytes: function(buf,pos,len) {
		if(pos < 0 || len < 0 || pos + len > buf.length) {
			throw haxe_Exception.thrown(haxe_io_Error.OutsideBounds);
		}
		if(this.len == 0 && len > 0) {
			throw haxe_Exception.thrown(new haxe_io_Eof());
		}
		if(this.len < len) {
			len = this.len;
		}
		var b1 = this.b;
		var b2 = buf.b;
		var _g = 0;
		var _g1 = len;
		while(_g < _g1) {
			var i = _g++;
			b2[pos + i] = b1[this.pos + i];
		}
		this.pos += len;
		this.len -= len;
		return len;
	}
	,__class__: haxe_io_BytesInput
});
var haxe_io_Encoding = $hxEnums["haxe.io.Encoding"] = { __ename__ : "haxe.io.Encoding", __constructs__ : ["UTF8","RawNative"]
	,UTF8: {_hx_index:0,__enum__:"haxe.io.Encoding",toString:$estr}
	,RawNative: {_hx_index:1,__enum__:"haxe.io.Encoding",toString:$estr}
};
var haxe_io_Eof = function() {
};
$hxClasses["haxe.io.Eof"] = haxe_io_Eof;
haxe_io_Eof.__name__ = "haxe.io.Eof";
haxe_io_Eof.prototype = {
	toString: function() {
		return "Eof";
	}
	,__class__: haxe_io_Eof
};
var haxe_io_Error = $hxEnums["haxe.io.Error"] = { __ename__ : "haxe.io.Error", __constructs__ : ["Blocked","Overflow","OutsideBounds","Custom"]
	,Blocked: {_hx_index:0,__enum__:"haxe.io.Error",toString:$estr}
	,Overflow: {_hx_index:1,__enum__:"haxe.io.Error",toString:$estr}
	,OutsideBounds: {_hx_index:2,__enum__:"haxe.io.Error",toString:$estr}
	,Custom: ($_=function(e) { return {_hx_index:3,e:e,__enum__:"haxe.io.Error",toString:$estr}; },$_.__params__ = ["e"],$_)
};
var haxe_io_FPHelper = function() { };
$hxClasses["haxe.io.FPHelper"] = haxe_io_FPHelper;
haxe_io_FPHelper.__name__ = "haxe.io.FPHelper";
haxe_io_FPHelper.i32ToFloat = function(i) {
	haxe_io_FPHelper.helper.setInt32(0,i,true);
	return haxe_io_FPHelper.helper.getFloat32(0,true);
};
haxe_io_FPHelper.floatToI32 = function(f) {
	haxe_io_FPHelper.helper.setFloat32(0,f,true);
	return haxe_io_FPHelper.helper.getInt32(0,true);
};
haxe_io_FPHelper.i64ToDouble = function(low,high) {
	haxe_io_FPHelper.helper.setInt32(0,low,true);
	haxe_io_FPHelper.helper.setInt32(4,high,true);
	return haxe_io_FPHelper.helper.getFloat64(0,true);
};
haxe_io_FPHelper.doubleToI64 = function(v) {
	var i64 = haxe_io_FPHelper.i64tmp;
	haxe_io_FPHelper.helper.setFloat64(0,v,true);
	i64.low = haxe_io_FPHelper.helper.getInt32(0,true);
	i64.high = haxe_io_FPHelper.helper.getInt32(4,true);
	return i64;
};
var haxe_io_Path = function(path) {
	switch(path) {
	case ".":case "..":
		this.dir = path;
		this.file = "";
		return;
	}
	var c1 = path.lastIndexOf("/");
	var c2 = path.lastIndexOf("\\");
	if(c1 < c2) {
		this.dir = HxOverrides.substr(path,0,c2);
		path = HxOverrides.substr(path,c2 + 1,null);
		this.backslash = true;
	} else if(c2 < c1) {
		this.dir = HxOverrides.substr(path,0,c1);
		path = HxOverrides.substr(path,c1 + 1,null);
	} else {
		this.dir = null;
	}
	var cp = path.lastIndexOf(".");
	if(cp != -1) {
		this.ext = HxOverrides.substr(path,cp + 1,null);
		this.file = HxOverrides.substr(path,0,cp);
	} else {
		this.ext = null;
		this.file = path;
	}
};
$hxClasses["haxe.io.Path"] = haxe_io_Path;
haxe_io_Path.__name__ = "haxe.io.Path";
haxe_io_Path.directory = function(path) {
	var s = new haxe_io_Path(path);
	if(s.dir == null) {
		return "";
	}
	return s.dir;
};
haxe_io_Path.prototype = {
	__class__: haxe_io_Path
};
var haxe_iterators_ArrayIterator = function(array) {
	this.current = 0;
	this.array = array;
};
$hxClasses["haxe.iterators.ArrayIterator"] = haxe_iterators_ArrayIterator;
haxe_iterators_ArrayIterator.__name__ = "haxe.iterators.ArrayIterator";
haxe_iterators_ArrayIterator.prototype = {
	hasNext: function() {
		return this.current < this.array.length;
	}
	,next: function() {
		return this.array[this.current++];
	}
	,__class__: haxe_iterators_ArrayIterator
};
var haxe_iterators_MapKeyValueIterator = function(map) {
	this.map = map;
	this.keys = map.keys();
};
$hxClasses["haxe.iterators.MapKeyValueIterator"] = haxe_iterators_MapKeyValueIterator;
haxe_iterators_MapKeyValueIterator.__name__ = "haxe.iterators.MapKeyValueIterator";
haxe_iterators_MapKeyValueIterator.prototype = {
	hasNext: function() {
		return this.keys.hasNext();
	}
	,next: function() {
		var key = this.keys.next();
		return { value : this.map.get(key), key : key};
	}
	,__class__: haxe_iterators_MapKeyValueIterator
};
var haxe_zip_ExtraField = $hxEnums["haxe.zip.ExtraField"] = { __ename__ : "haxe.zip.ExtraField", __constructs__ : ["FUnknown","FInfoZipUnicodePath","FUtf8"]
	,FUnknown: ($_=function(tag,bytes) { return {_hx_index:0,tag:tag,bytes:bytes,__enum__:"haxe.zip.ExtraField",toString:$estr}; },$_.__params__ = ["tag","bytes"],$_)
	,FInfoZipUnicodePath: ($_=function(name,crc) { return {_hx_index:1,name:name,crc:crc,__enum__:"haxe.zip.ExtraField",toString:$estr}; },$_.__params__ = ["name","crc"],$_)
	,FUtf8: {_hx_index:2,__enum__:"haxe.zip.ExtraField",toString:$estr}
};
var haxe_zip_Huffman = $hxEnums["haxe.zip.Huffman"] = { __ename__ : "haxe.zip.Huffman", __constructs__ : ["Found","NeedBit","NeedBits"]
	,Found: ($_=function(i) { return {_hx_index:0,i:i,__enum__:"haxe.zip.Huffman",toString:$estr}; },$_.__params__ = ["i"],$_)
	,NeedBit: ($_=function(left,right) { return {_hx_index:1,left:left,right:right,__enum__:"haxe.zip.Huffman",toString:$estr}; },$_.__params__ = ["left","right"],$_)
	,NeedBits: ($_=function(n,table) { return {_hx_index:2,n:n,table:table,__enum__:"haxe.zip.Huffman",toString:$estr}; },$_.__params__ = ["n","table"],$_)
};
var haxe_zip_HuffTools = function() {
};
$hxClasses["haxe.zip.HuffTools"] = haxe_zip_HuffTools;
haxe_zip_HuffTools.__name__ = "haxe.zip.HuffTools";
haxe_zip_HuffTools.prototype = {
	treeDepth: function(t) {
		switch(t._hx_index) {
		case 0:
			var _g = t.i;
			return 0;
		case 1:
			var b = t.right;
			var a = t.left;
			var da = this.treeDepth(a);
			var db = this.treeDepth(b);
			return 1 + (da < db ? da : db);
		case 2:
			var _g = t.table;
			var _g = t.n;
			throw haxe_Exception.thrown("assert");
		}
	}
	,treeCompress: function(t) {
		var d = this.treeDepth(t);
		if(d == 0) {
			return t;
		}
		if(d == 1) {
			if(t._hx_index == 1) {
				var b = t.right;
				var a = t.left;
				return haxe_zip_Huffman.NeedBit(this.treeCompress(a),this.treeCompress(b));
			} else {
				throw haxe_Exception.thrown("assert");
			}
		}
		var size = 1 << d;
		var table = [];
		var _g = 0;
		var _g1 = size;
		while(_g < _g1) {
			var i = _g++;
			table.push(haxe_zip_Huffman.Found(-1));
		}
		this.treeWalk(table,0,0,d,t);
		return haxe_zip_Huffman.NeedBits(d,table);
	}
	,treeWalk: function(table,p,cd,d,t) {
		if(t._hx_index == 1) {
			var b = t.right;
			var a = t.left;
			if(d > 0) {
				this.treeWalk(table,p,cd + 1,d - 1,a);
				this.treeWalk(table,p | 1 << cd,cd + 1,d - 1,b);
			} else {
				table[p] = this.treeCompress(t);
			}
		} else {
			table[p] = this.treeCompress(t);
		}
	}
	,treeMake: function(bits,maxbits,v,len) {
		if(len > maxbits) {
			throw haxe_Exception.thrown("Invalid huffman");
		}
		var idx = v << 5 | len;
		if(bits.h.hasOwnProperty(idx)) {
			return haxe_zip_Huffman.Found(bits.h[idx]);
		}
		v <<= 1;
		++len;
		return haxe_zip_Huffman.NeedBit(this.treeMake(bits,maxbits,v,len),this.treeMake(bits,maxbits,v | 1,len));
	}
	,make: function(lengths,pos,nlengths,maxbits) {
		if(nlengths == 1) {
			return haxe_zip_Huffman.NeedBit(haxe_zip_Huffman.Found(0),haxe_zip_Huffman.Found(0));
		}
		var counts = [];
		var tmp = [];
		if(maxbits > 32) {
			throw haxe_Exception.thrown("Invalid huffman");
		}
		var _g = 0;
		var _g1 = maxbits;
		while(_g < _g1) {
			var i = _g++;
			counts.push(0);
			tmp.push(0);
		}
		var _g = 0;
		var _g1 = nlengths;
		while(_g < _g1) {
			var i = _g++;
			var p = lengths[i + pos];
			if(p >= maxbits) {
				throw haxe_Exception.thrown("Invalid huffman");
			}
			counts[p]++;
		}
		var code = 0;
		var _g = 1;
		var _g1 = maxbits - 1;
		while(_g < _g1) {
			var i = _g++;
			code = code + counts[i] << 1;
			tmp[i] = code;
		}
		var bits = new haxe_ds_IntMap();
		var _g = 0;
		var _g1 = nlengths;
		while(_g < _g1) {
			var i = _g++;
			var l = lengths[i + pos];
			if(l != 0) {
				var n = tmp[l - 1];
				tmp[l - 1] = n + 1;
				bits.h[n << 5 | l] = i;
			}
		}
		return this.treeCompress(haxe_zip_Huffman.NeedBit(this.treeMake(bits,maxbits,0,1),this.treeMake(bits,maxbits,1,1)));
	}
	,__class__: haxe_zip_HuffTools
};
var haxe_zip__$InflateImpl_Window = function(hasCrc) {
	this.buffer = new haxe_io_Bytes(new ArrayBuffer(65536));
	this.pos = 0;
	if(hasCrc) {
		this.crc = new haxe_crypto_Adler32();
	}
};
$hxClasses["haxe.zip._InflateImpl.Window"] = haxe_zip__$InflateImpl_Window;
haxe_zip__$InflateImpl_Window.__name__ = "haxe.zip._InflateImpl.Window";
haxe_zip__$InflateImpl_Window.prototype = {
	slide: function() {
		if(this.crc != null) {
			this.crc.update(this.buffer,0,32768);
		}
		var b = new haxe_io_Bytes(new ArrayBuffer(65536));
		this.pos -= 32768;
		b.blit(0,this.buffer,32768,this.pos);
		this.buffer = b;
	}
	,addBytes: function(b,p,len) {
		if(this.pos + len > 65536) {
			this.slide();
		}
		this.buffer.blit(this.pos,b,p,len);
		this.pos += len;
	}
	,addByte: function(c) {
		if(this.pos == 65536) {
			this.slide();
		}
		this.buffer.b[this.pos] = c & 255;
		this.pos++;
	}
	,getLastChar: function() {
		return this.buffer.b[this.pos - 1];
	}
	,available: function() {
		return this.pos;
	}
	,checksum: function() {
		if(this.crc != null) {
			this.crc.update(this.buffer,0,this.pos);
		}
		return this.crc;
	}
	,__class__: haxe_zip__$InflateImpl_Window
};
var haxe_zip__$InflateImpl_State = $hxEnums["haxe.zip._InflateImpl.State"] = { __ename__ : "haxe.zip._InflateImpl.State", __constructs__ : ["Head","Block","CData","Flat","Crc","Dist","DistOne","Done"]
	,Head: {_hx_index:0,__enum__:"haxe.zip._InflateImpl.State",toString:$estr}
	,Block: {_hx_index:1,__enum__:"haxe.zip._InflateImpl.State",toString:$estr}
	,CData: {_hx_index:2,__enum__:"haxe.zip._InflateImpl.State",toString:$estr}
	,Flat: {_hx_index:3,__enum__:"haxe.zip._InflateImpl.State",toString:$estr}
	,Crc: {_hx_index:4,__enum__:"haxe.zip._InflateImpl.State",toString:$estr}
	,Dist: {_hx_index:5,__enum__:"haxe.zip._InflateImpl.State",toString:$estr}
	,DistOne: {_hx_index:6,__enum__:"haxe.zip._InflateImpl.State",toString:$estr}
	,Done: {_hx_index:7,__enum__:"haxe.zip._InflateImpl.State",toString:$estr}
};
var haxe_zip_InflateImpl = function(i,header,crc) {
	if(crc == null) {
		crc = true;
	}
	if(header == null) {
		header = true;
	}
	this.isFinal = false;
	this.htools = new haxe_zip_HuffTools();
	this.huffman = this.buildFixedHuffman();
	this.huffdist = null;
	this.len = 0;
	this.dist = 0;
	this.state = header ? haxe_zip__$InflateImpl_State.Head : haxe_zip__$InflateImpl_State.Block;
	this.input = i;
	this.bits = 0;
	this.nbits = 0;
	this.needed = 0;
	this.output = null;
	this.outpos = 0;
	this.lengths = [];
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.lengths.push(-1);
	this.window = new haxe_zip__$InflateImpl_Window(crc);
};
$hxClasses["haxe.zip.InflateImpl"] = haxe_zip_InflateImpl;
haxe_zip_InflateImpl.__name__ = "haxe.zip.InflateImpl";
haxe_zip_InflateImpl.prototype = {
	buildFixedHuffman: function() {
		if(haxe_zip_InflateImpl.FIXED_HUFFMAN != null) {
			return haxe_zip_InflateImpl.FIXED_HUFFMAN;
		}
		var a = [];
		var _g = 0;
		while(_g < 288) {
			var n = _g++;
			a.push(n <= 143 ? 8 : n <= 255 ? 9 : n <= 279 ? 7 : 8);
		}
		haxe_zip_InflateImpl.FIXED_HUFFMAN = this.htools.make(a,0,288,10);
		return haxe_zip_InflateImpl.FIXED_HUFFMAN;
	}
	,readBytes: function(b,pos,len) {
		this.needed = len;
		this.outpos = pos;
		this.output = b;
		if(len > 0) {
			while(this.inflateLoop()) {
			}
		}
		return len - this.needed;
	}
	,getBits: function(n) {
		while(this.nbits < n) {
			this.bits |= this.input.readByte() << this.nbits;
			this.nbits += 8;
		}
		var b = this.bits & (1 << n) - 1;
		this.nbits -= n;
		this.bits >>= n;
		return b;
	}
	,getBit: function() {
		if(this.nbits == 0) {
			this.nbits = 8;
			this.bits = this.input.readByte();
		}
		var b = (this.bits & 1) == 1;
		this.nbits--;
		this.bits >>= 1;
		return b;
	}
	,getRevBits: function(n) {
		if(n == 0) {
			return 0;
		} else if(this.getBit()) {
			return 1 << n - 1 | this.getRevBits(n - 1);
		} else {
			return this.getRevBits(n - 1);
		}
	}
	,resetBits: function() {
		this.bits = 0;
		this.nbits = 0;
	}
	,addBytes: function(b,p,len) {
		this.window.addBytes(b,p,len);
		this.output.blit(this.outpos,b,p,len);
		this.needed -= len;
		this.outpos += len;
	}
	,addByte: function(b) {
		this.window.addByte(b);
		this.output.b[this.outpos] = b & 255;
		this.needed--;
		this.outpos++;
	}
	,addDistOne: function(n) {
		var c = this.window.getLastChar();
		var _g = 0;
		var _g1 = n;
		while(_g < _g1) {
			var i = _g++;
			this.addByte(c);
		}
	}
	,addDist: function(d,len) {
		this.addBytes(this.window.buffer,this.window.pos - d,len);
	}
	,applyHuffman: function(h) {
		switch(h._hx_index) {
		case 0:
			var n = h.i;
			return n;
		case 1:
			var b = h.right;
			var a = h.left;
			return this.applyHuffman(this.getBit() ? b : a);
		case 2:
			var tbl = h.table;
			var n = h.n;
			return this.applyHuffman(tbl[this.getBits(n)]);
		}
	}
	,inflateLengths: function(a,max) {
		var i = 0;
		var prev = 0;
		while(i < max) {
			var n = this.applyHuffman(this.huffman);
			switch(n) {
			case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:case 9:case 10:case 11:case 12:case 13:case 14:case 15:
				prev = n;
				a[i] = n;
				++i;
				break;
			case 16:
				var end = i + 3 + this.getBits(2);
				if(end > max) {
					throw haxe_Exception.thrown("Invalid data");
				}
				while(i < end) {
					a[i] = prev;
					++i;
				}
				break;
			case 17:
				i += 3 + this.getBits(3);
				if(i > max) {
					throw haxe_Exception.thrown("Invalid data");
				}
				break;
			case 18:
				i += 11 + this.getBits(7);
				if(i > max) {
					throw haxe_Exception.thrown("Invalid data");
				}
				break;
			default:
				throw haxe_Exception.thrown("Invalid data");
			}
		}
	}
	,inflateLoop: function() {
		switch(this.state._hx_index) {
		case 0:
			var cmf = this.input.readByte();
			var cm = cmf & 15;
			var cinfo = cmf >> 4;
			if(cm != 8) {
				throw haxe_Exception.thrown("Invalid data");
			}
			var flg = this.input.readByte();
			var fdict = (flg & 32) != 0;
			if(((cmf << 8) + flg) % 31 != 0) {
				throw haxe_Exception.thrown("Invalid data");
			}
			if(fdict) {
				throw haxe_Exception.thrown("Unsupported dictionary");
			}
			this.state = haxe_zip__$InflateImpl_State.Block;
			return true;
		case 1:
			this.isFinal = this.getBit();
			switch(this.getBits(2)) {
			case 0:
				this.len = this.input.readUInt16();
				var nlen = this.input.readUInt16();
				if(nlen != 65535 - this.len) {
					throw haxe_Exception.thrown("Invalid data");
				}
				this.state = haxe_zip__$InflateImpl_State.Flat;
				var r = this.inflateLoop();
				this.resetBits();
				return r;
			case 1:
				this.huffman = this.buildFixedHuffman();
				this.huffdist = null;
				this.state = haxe_zip__$InflateImpl_State.CData;
				return true;
			case 2:
				var hlit = this.getBits(5) + 257;
				var hdist = this.getBits(5) + 1;
				var hclen = this.getBits(4) + 4;
				var _g = 0;
				var _g1 = hclen;
				while(_g < _g1) {
					var i = _g++;
					this.lengths[haxe_zip_InflateImpl.CODE_LENGTHS_POS[i]] = this.getBits(3);
				}
				var _g = hclen;
				var _g1 = 19;
				while(_g < _g1) {
					var i = _g++;
					this.lengths[haxe_zip_InflateImpl.CODE_LENGTHS_POS[i]] = 0;
				}
				this.huffman = this.htools.make(this.lengths,0,19,8);
				var lengths = [];
				var _g = 0;
				var _g1 = hlit + hdist;
				while(_g < _g1) {
					var i = _g++;
					lengths.push(0);
				}
				this.inflateLengths(lengths,hlit + hdist);
				this.huffdist = this.htools.make(lengths,hlit,hdist,16);
				this.huffman = this.htools.make(lengths,0,hlit,16);
				this.state = haxe_zip__$InflateImpl_State.CData;
				return true;
			default:
				throw haxe_Exception.thrown("Invalid data");
			}
			break;
		case 2:
			var n = this.applyHuffman(this.huffman);
			if(n < 256) {
				this.addByte(n);
				return this.needed > 0;
			} else if(n == 256) {
				this.state = this.isFinal ? haxe_zip__$InflateImpl_State.Crc : haxe_zip__$InflateImpl_State.Block;
				return true;
			} else {
				n -= 257;
				var extra_bits = haxe_zip_InflateImpl.LEN_EXTRA_BITS_TBL[n];
				if(extra_bits == -1) {
					throw haxe_Exception.thrown("Invalid data");
				}
				this.len = haxe_zip_InflateImpl.LEN_BASE_VAL_TBL[n] + this.getBits(extra_bits);
				var dist_code = this.huffdist == null ? this.getRevBits(5) : this.applyHuffman(this.huffdist);
				extra_bits = haxe_zip_InflateImpl.DIST_EXTRA_BITS_TBL[dist_code];
				if(extra_bits == -1) {
					throw haxe_Exception.thrown("Invalid data");
				}
				this.dist = haxe_zip_InflateImpl.DIST_BASE_VAL_TBL[dist_code] + this.getBits(extra_bits);
				if(this.dist > this.window.available()) {
					throw haxe_Exception.thrown("Invalid data");
				}
				this.state = this.dist == 1 ? haxe_zip__$InflateImpl_State.DistOne : haxe_zip__$InflateImpl_State.Dist;
				return true;
			}
			break;
		case 3:
			var rlen = this.len < this.needed ? this.len : this.needed;
			var bytes = this.input.read(rlen);
			this.len -= rlen;
			this.addBytes(bytes,0,rlen);
			if(this.len == 0) {
				this.state = this.isFinal ? haxe_zip__$InflateImpl_State.Crc : haxe_zip__$InflateImpl_State.Block;
			}
			return this.needed > 0;
		case 4:
			var calc = this.window.checksum();
			if(calc == null) {
				this.state = haxe_zip__$InflateImpl_State.Done;
				return true;
			}
			var crc = haxe_crypto_Adler32.read(this.input);
			if(!calc.equals(crc)) {
				throw haxe_Exception.thrown("Invalid CRC");
			}
			this.state = haxe_zip__$InflateImpl_State.Done;
			return true;
		case 5:
			while(this.len > 0 && this.needed > 0) {
				var rdist = this.len < this.dist ? this.len : this.dist;
				var rlen = this.needed < rdist ? this.needed : rdist;
				this.addDist(this.dist,rlen);
				this.len -= rlen;
			}
			if(this.len == 0) {
				this.state = haxe_zip__$InflateImpl_State.CData;
			}
			return this.needed > 0;
		case 6:
			var rlen = this.len < this.needed ? this.len : this.needed;
			this.addDistOne(rlen);
			this.len -= rlen;
			if(this.len == 0) {
				this.state = haxe_zip__$InflateImpl_State.CData;
			}
			return this.needed > 0;
		case 7:
			return false;
		}
	}
	,__class__: haxe_zip_InflateImpl
};
var haxe_zip_Reader = function(i) {
	this.i = i;
};
$hxClasses["haxe.zip.Reader"] = haxe_zip_Reader;
haxe_zip_Reader.__name__ = "haxe.zip.Reader";
haxe_zip_Reader.readZip = function(i) {
	var r = new haxe_zip_Reader(i);
	return r.read();
};
haxe_zip_Reader.unzip = function(f) {
	if(!f.compressed) {
		return f.data;
	}
	throw haxe_Exception.thrown("No uncompress support");
};
haxe_zip_Reader.prototype = {
	readZipDate: function() {
		var t = this.i.readUInt16();
		var hour = t >> 11 & 31;
		var min = t >> 5 & 63;
		var sec = t & 31;
		var d = this.i.readUInt16();
		var year = d >> 9;
		var month = d >> 5 & 15;
		var day = d & 31;
		return new Date(year + 1980,month - 1,day,hour,min,sec << 1);
	}
	,readExtraFields: function(length) {
		var fields = new haxe_ds_List();
		while(length > 0) {
			if(length < 4) {
				throw haxe_Exception.thrown("Invalid extra fields data");
			}
			var tag = this.i.readUInt16();
			var len = this.i.readUInt16();
			if(length < len) {
				throw haxe_Exception.thrown("Invalid extra fields data");
			}
			if(tag == 28789) {
				var version = this.i.readByte();
				if(version != 1) {
					var data = new haxe_io_BytesBuffer();
					data.addByte(version);
					data.add(this.i.read(len - 1));
					fields.add(haxe_zip_ExtraField.FUnknown(tag,data.getBytes()));
				} else {
					var crc = this.i.readInt32();
					var name = this.i.read(len - 5).toString();
					fields.add(haxe_zip_ExtraField.FInfoZipUnicodePath(name,crc));
				}
			} else {
				fields.add(haxe_zip_ExtraField.FUnknown(tag,this.i.read(len)));
			}
			length -= 4 + len;
		}
		return fields;
	}
	,readEntryHeader: function() {
		var i = this.i;
		var h = i.readInt32();
		if(h == 33639248 || h == 101010256) {
			return null;
		}
		if(h != 67324752) {
			throw haxe_Exception.thrown("Invalid Zip Data");
		}
		var version = i.readUInt16();
		var flags = i.readUInt16();
		var utf8 = (flags & 2048) != 0;
		var compression = i.readUInt16();
		var compressed = compression != 0;
		if(compressed && compression != 8) {
			throw haxe_Exception.thrown("Unsupported compression " + compression);
		}
		var mtime = this.readZipDate();
		var crc32 = i.readInt32();
		var csize = i.readInt32();
		var usize = i.readInt32();
		var fnamelen = i.readInt16();
		var elen = i.readInt16();
		var fname = i.readString(fnamelen);
		var fields = this.readExtraFields(elen);
		if(utf8) {
			fields.push(haxe_zip_ExtraField.FUtf8);
		}
		var data = null;
		if((flags & 8) != 0) {
			csize = -1;
		}
		return { fileName : fname, fileSize : usize, fileTime : mtime, compressed : compressed, dataSize : csize, data : data, crc32 : crc32, extraFields : fields};
	}
	,read: function() {
		var l = new haxe_ds_List();
		var buf = null;
		var tmp = null;
		while(true) {
			var e = this.readEntryHeader();
			if(e == null) {
				break;
			}
			if(e.dataSize < 0) {
				var bufSize = 65536;
				if(tmp == null) {
					tmp = new haxe_io_Bytes(new ArrayBuffer(bufSize));
				}
				var out = new haxe_io_BytesBuffer();
				var z = new haxe_zip_InflateImpl(this.i,false,false);
				while(true) {
					var n = z.readBytes(tmp,0,bufSize);
					out.addBytes(tmp,0,n);
					if(n < bufSize) {
						break;
					}
				}
				e.data = out.getBytes();
				e.crc32 = this.i.readInt32();
				if(e.crc32 == 134695760) {
					e.crc32 = this.i.readInt32();
				}
				e.dataSize = this.i.readInt32();
				e.fileSize = this.i.readInt32();
				e.dataSize = e.fileSize;
				e.compressed = false;
			} else {
				e.data = this.i.read(e.dataSize);
			}
			l.add(e);
		}
		return l;
	}
	,__class__: haxe_zip_Reader
};
var js_Boot = function() { };
$hxClasses["js.Boot"] = js_Boot;
js_Boot.__name__ = "js.Boot";
js_Boot.getClass = function(o) {
	if(o == null) {
		return null;
	} else if(((o) instanceof Array)) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o.__enum__) {
			var e = $hxEnums[o.__enum__];
			var n = e.__constructs__[o._hx_index];
			var con = e[n];
			if(con.__params__) {
				s = s + "\t";
				return n + "(" + ((function($this) {
					var $r;
					var _g = [];
					{
						var _g1 = 0;
						var _g2 = con.__params__;
						while(true) {
							if(!(_g1 < _g2.length)) {
								break;
							}
							var p = _g2[_g1];
							_g1 = _g1 + 1;
							_g.push(js_Boot.__string_rec(o[p],s));
						}
					}
					$r = _g;
					return $r;
				}(this))).join(",") + ")";
			} else {
				return n;
			}
		}
		if(((o) instanceof Array)) {
			var str = "[";
			s += "\t";
			var _g = 0;
			var _g1 = o.length;
			while(_g < _g1) {
				var i = _g++;
				str += (i > 0 ? "," : "") + js_Boot.__string_rec(o[i],s);
			}
			str += "]";
			return str;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( _g ) {
			haxe_NativeStackTrace.lastError = _g;
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var str = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		var k = null;
		for( k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str.length != 2) {
			str += ", \n";
		}
		str += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str += "\n" + s + "}";
		return str;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g = 0;
		var _g1 = intf.length;
		while(_g < _g1) {
			var i = _g++;
			var i1 = intf[i];
			if(i1 == cl || js_Boot.__interfLoop(i1,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		return ((o) instanceof Array);
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return o != null;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return ((o | 0) === o);
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(js_Boot.__downcastCheck(o,cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(((o) instanceof cl)) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class ? o.__name__ != null : false) {
			return true;
		}
		if(cl == Enum ? o.__ename__ != null : false) {
			return true;
		}
		return o.__enum__ != null ? $hxEnums[o.__enum__] == cl : false;
	}
};
js_Boot.__downcastCheck = function(o,cl) {
	if(!((o) instanceof cl)) {
		if(cl.__isInterface__) {
			return js_Boot.__interfLoop(js_Boot.getClass(o),cl);
		} else {
			return false;
		}
	} else {
		return true;
	}
};
js_Boot.__implements = function(o,iface) {
	return js_Boot.__interfLoop(js_Boot.getClass(o),iface);
};
js_Boot.__cast = function(o,t) {
	if(o == null || js_Boot.__instanceof(o,t)) {
		return o;
	} else {
		throw haxe_Exception.thrown("Cannot cast " + Std.string(o) + " to " + Std.string(t));
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var js_Browser = function() { };
$hxClasses["js.Browser"] = js_Browser;
js_Browser.__name__ = "js.Browser";
js_Browser.getLocalStorage = function() {
	try {
		var s = window.localStorage;
		s.getItem("");
		if(s.length == 0) {
			var key = "_hx_" + Math.random();
			s.setItem(key,key);
			s.removeItem(key);
		}
		return s;
	} catch( _g ) {
		haxe_NativeStackTrace.lastError = _g;
		return null;
	}
};
var js_Cookie = function() { };
$hxClasses["js.Cookie"] = js_Cookie;
js_Cookie.__name__ = "js.Cookie";
js_Cookie.set = function(name,value,expireDelay,path,domain) {
	var s = name + "=" + encodeURIComponent(value);
	if(expireDelay != null) {
		var d = new Date(new Date().getTime() + expireDelay * 1000);
		s += ";expires=" + d.toGMTString();
	}
	if(path != null) {
		s += ";path=" + path;
	}
	if(domain != null) {
		s += ";domain=" + domain;
	}
	window.document.cookie = s;
};
js_Cookie.all = function() {
	var h = new haxe_ds_StringMap();
	var a = window.document.cookie.split(";");
	var _g = 0;
	while(_g < a.length) {
		var e = a[_g];
		++_g;
		e = StringTools.ltrim(e);
		var t = e.split("=");
		if(t.length < 2) {
			continue;
		}
		var value = decodeURIComponent(t[1].split("+").join(" "));
		h.h[t[0]] = value;
	}
	return h;
};
js_Cookie.get = function(name) {
	return js_Cookie.all().h[name];
};
var js_html__$CanvasElement_CanvasUtil = function() { };
$hxClasses["js.html._CanvasElement.CanvasUtil"] = js_html__$CanvasElement_CanvasUtil;
js_html__$CanvasElement_CanvasUtil.__name__ = "js.html._CanvasElement.CanvasUtil";
js_html__$CanvasElement_CanvasUtil.getContextWebGL = function(canvas,attribs) {
	var name = "webgl";
	var ctx = canvas.getContext(name,attribs);
	if(ctx != null) {
		return ctx;
	}
	var name = "experimental-webgl";
	var ctx = canvas.getContext(name,attribs);
	if(ctx != null) {
		return ctx;
	}
	return null;
};
var js_lib__$ArrayBuffer_ArrayBufferCompat = function() { };
$hxClasses["js.lib._ArrayBuffer.ArrayBufferCompat"] = js_lib__$ArrayBuffer_ArrayBufferCompat;
js_lib__$ArrayBuffer_ArrayBufferCompat.__name__ = "js.lib._ArrayBuffer.ArrayBufferCompat";
js_lib__$ArrayBuffer_ArrayBufferCompat.sliceImpl = function(begin,end) {
	var u = new Uint8Array(this,begin,end == null ? null : end - begin);
	var resultArray = new Uint8Array(u.byteLength);
	resultArray.set(u);
	return resultArray.buffer;
};
var lime__$internal_backend_html5_GameDeviceData = function() {
	this.connected = true;
	this.buttons = [];
	this.axes = [];
};
$hxClasses["lime._internal.backend.html5.GameDeviceData"] = lime__$internal_backend_html5_GameDeviceData;
lime__$internal_backend_html5_GameDeviceData.__name__ = "lime._internal.backend.html5.GameDeviceData";
lime__$internal_backend_html5_GameDeviceData.prototype = {
	__class__: lime__$internal_backend_html5_GameDeviceData
};
var lime__$internal_backend_html5_HTML5AudioSource = function(parent) {
	this.parent = parent;
	this.id = -1;
	this.gain = 1;
	this.position = new lime_math_Vector4();
};
$hxClasses["lime._internal.backend.html5.HTML5AudioSource"] = lime__$internal_backend_html5_HTML5AudioSource;
lime__$internal_backend_html5_HTML5AudioSource.__name__ = "lime._internal.backend.html5.HTML5AudioSource";
lime__$internal_backend_html5_HTML5AudioSource.prototype = {
	dispose: function() {
	}
	,init: function() {
	}
	,play: function() {
		if(this.playing || this.parent.buffer == null || this.parent.buffer.__srcHowl == null) {
			return;
		}
		this.playing = true;
		var time = this.getCurrentTime();
		this.completed = false;
		var cacheVolume = this.parent.buffer.__srcHowl._volume;
		this.parent.buffer.__srcHowl._volume = this.parent.get_gain();
		this.id = this.parent.buffer.__srcHowl.play();
		this.parent.buffer.__srcHowl._volume = cacheVolume;
		this.setPosition(this.parent.get_position());
		this.parent.buffer.__srcHowl.on("end",$bind(this,this.howl_onEnd),this.id);
		this.setCurrentTime(time);
	}
	,pause: function() {
		this.playing = false;
		if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			this.parent.buffer.__srcHowl.pause(this.id);
		}
	}
	,stop: function() {
		this.playing = false;
		if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			this.parent.buffer.__srcHowl.stop(this.id);
			this.parent.buffer.__srcHowl.off("end",$bind(this,this.howl_onEnd),this.id);
		}
	}
	,howl_onEnd: function() {
		this.playing = false;
		if(this.loops > 0) {
			this.loops--;
			this.stop();
			this.play();
			return;
		} else if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			this.parent.buffer.__srcHowl.stop(this.id);
			this.parent.buffer.__srcHowl.off("end",$bind(this,this.howl_onEnd),this.id);
		}
		this.completed = true;
		this.parent.onComplete.dispatch();
	}
	,getCurrentTime: function() {
		if(this.id == -1) {
			return 0;
		}
		if(this.completed) {
			return this.getLength();
		} else if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			var time = (this.parent.buffer.__srcHowl.seek(this.id) * 1000 | 0) - this.parent.offset;
			if(time < 0) {
				return 0;
			}
			return time;
		}
		return 0;
	}
	,setCurrentTime: function(value) {
		if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			var pos = (value + this.parent.offset) / 1000;
			if(pos < 0) {
				pos = 0;
			}
			this.parent.buffer.__srcHowl.seek(pos,this.id);
		}
		return value;
	}
	,getGain: function() {
		return this.gain;
	}
	,setGain: function(value) {
		if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null && this.id != -1) {
			this.parent.buffer.__srcHowl.volume(value,this.id);
		}
		return this.gain = value;
	}
	,getLength: function() {
		if(this.length != 0) {
			return this.length;
		}
		if(this.parent.buffer != null && this.parent.buffer.__srcHowl != null) {
			return this.parent.buffer.__srcHowl.duration() * 1000 | 0;
		}
		return 0;
	}
	,setLength: function(value) {
		return this.length = value;
	}
	,getLoops: function() {
		return this.loops;
	}
	,setLoops: function(value) {
		return this.loops = value;
	}
	,getPosition: function() {
		return this.position;
	}
	,setPosition: function(value) {
		this.position.x = value.x;
		this.position.y = value.y;
		this.position.z = value.z;
		this.position.w = value.w;
		if(this.parent.buffer.__srcHowl != null && this.parent.buffer.__srcHowl.pos != null) {
			this.parent.buffer.__srcHowl.pos(this.position.x,this.position.y,this.position.z,this.id);
		}
		return this.position;
	}
	,__class__: lime__$internal_backend_html5_HTML5AudioSource
};
var lime__$internal_backend_html5_HTML5HTTPRequest = function() {
	this.validStatus0 = new EReg("Tizen","gi").match(window.navigator.userAgent);
};
$hxClasses["lime._internal.backend.html5.HTML5HTTPRequest"] = lime__$internal_backend_html5_HTML5HTTPRequest;
lime__$internal_backend_html5_HTML5HTTPRequest.__name__ = "lime._internal.backend.html5.HTML5HTTPRequest";
lime__$internal_backend_html5_HTML5HTTPRequest.loadImage = function(uri) {
	var promise = new lime_app_Promise();
	if(lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests < lime__$internal_backend_html5_HTML5HTTPRequest.requestLimit) {
		lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests++;
		lime__$internal_backend_html5_HTML5HTTPRequest.__loadImage(uri,promise,0);
	} else {
		lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.add({ instance : null, uri : uri, promise : promise, type : "IMAGE", options : 0});
	}
	return promise.future;
};
lime__$internal_backend_html5_HTML5HTTPRequest.loadImageFromBytes = function(bytes,type) {
	var uri = URL.createObjectURL(new Blob([bytes.b.bufferValue],{ type : type}));
	if(uri != null) {
		var promise = new lime_app_Promise();
		if(lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests < lime__$internal_backend_html5_HTML5HTTPRequest.requestLimit) {
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests++;
			lime__$internal_backend_html5_HTML5HTTPRequest.__loadImage(uri,promise,1);
		} else {
			lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.add({ instance : null, uri : uri, promise : promise, type : "IMAGE", options : 1});
		}
		return promise.future;
	} else {
		return lime__$internal_backend_html5_HTML5HTTPRequest.loadImage("data:" + type + ";base64," + lime__$internal_format_Base64.encode(bytes));
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.processQueue = function() {
	if(lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests < lime__$internal_backend_html5_HTML5HTTPRequest.requestLimit && lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.length > 0) {
		lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests++;
		var queueItem = lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.pop();
		switch(queueItem.type) {
		case "BINARY":
			queueItem.instance.__loadData(queueItem.uri,queueItem.promise);
			break;
		case "IMAGE":
			lime__$internal_backend_html5_HTML5HTTPRequest.__loadImage(queueItem.uri,queueItem.promise,queueItem.options);
			break;
		case "TEXT":
			queueItem.instance.__loadText(queueItem.uri,queueItem.promise);
			break;
		default:
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
		}
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__createBlobURIFromBytes = function(bytes,type) {
	return URL.createObjectURL(new Blob([bytes.b.bufferValue],{ type : type}));
};
lime__$internal_backend_html5_HTML5HTTPRequest.__fixHostname = function(hostname) {
	if(hostname == null) {
		return "";
	} else {
		return hostname;
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__fixPort = function(port,protocol) {
	if(port == null || port == "") {
		switch(protocol) {
		case "ftp:":
			return "21";
		case "gopher:":
			return "70";
		case "http:":
			return "80";
		case "https:":
			return "443";
		case "ws:":
			return "80";
		case "wss:":
			return "443";
		default:
			return "";
		}
	}
	return port;
};
lime__$internal_backend_html5_HTML5HTTPRequest.__fixProtocol = function(protocol) {
	if(protocol == null || protocol == "") {
		return "http:";
	} else {
		return protocol;
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__isInMemoryURI = function(uri) {
	if(!StringTools.startsWith(uri,"data:")) {
		return StringTools.startsWith(uri,"blob:");
	} else {
		return true;
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__isSameOrigin = function(path) {
	if(path == null || path == "") {
		return true;
	}
	if(lime__$internal_backend_html5_HTML5HTTPRequest.__isInMemoryURI(path)) {
		return true;
	}
	if(lime__$internal_backend_html5_HTML5HTTPRequest.originElement == null) {
		lime__$internal_backend_html5_HTML5HTTPRequest.originElement = window.document.createElement("a");
		lime__$internal_backend_html5_HTML5HTTPRequest.originHostname = lime__$internal_backend_html5_HTML5HTTPRequest.__fixHostname($global.location.hostname);
		lime__$internal_backend_html5_HTML5HTTPRequest.originProtocol = lime__$internal_backend_html5_HTML5HTTPRequest.__fixProtocol($global.location.protocol);
		lime__$internal_backend_html5_HTML5HTTPRequest.originPort = lime__$internal_backend_html5_HTML5HTTPRequest.__fixPort($global.location.port,lime__$internal_backend_html5_HTML5HTTPRequest.originProtocol);
	}
	var a = lime__$internal_backend_html5_HTML5HTTPRequest.originElement;
	a.href = path;
	if(a.hostname == "") {
		a.href = a.href;
	}
	var hostname = lime__$internal_backend_html5_HTML5HTTPRequest.__fixHostname(a.hostname);
	var protocol = lime__$internal_backend_html5_HTML5HTTPRequest.__fixProtocol(a.protocol);
	var port = lime__$internal_backend_html5_HTML5HTTPRequest.__fixPort(a.port,protocol);
	var sameHost = hostname == "" || hostname == lime__$internal_backend_html5_HTML5HTTPRequest.originHostname;
	var samePort = port == "" || port == lime__$internal_backend_html5_HTML5HTTPRequest.originPort;
	if(protocol != "file:" && sameHost) {
		return samePort;
	} else {
		return false;
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__loadImage = function(uri,promise,options) {
	var image = new Image();
	if(!lime__$internal_backend_html5_HTML5HTTPRequest.__isSameOrigin(uri)) {
		image.crossOrigin = "Anonymous";
	}
	if(lime__$internal_backend_html5_HTML5HTTPRequest.supportsImageProgress == null) {
		lime__$internal_backend_html5_HTML5HTTPRequest.supportsImageProgress = 'onprogress' in image;
	}
	if(lime__$internal_backend_html5_HTML5HTTPRequest.supportsImageProgress || lime__$internal_backend_html5_HTML5HTTPRequest.__isInMemoryURI(uri)) {
		image.addEventListener("load",function(event) {
			lime__$internal_backend_html5_HTML5HTTPRequest.__revokeBlobURI(uri,options);
			var buffer = new lime_graphics_ImageBuffer(null,image.width,image.height);
			buffer.__srcImage = image;
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
			lime__$internal_backend_html5_HTML5HTTPRequest.processQueue();
			promise.complete(new lime_graphics_Image(buffer));
		},false);
		image.addEventListener("progress",function(event) {
			promise.progress(event.loaded,event.total);
		},false);
		image.addEventListener("error",function(event) {
			lime__$internal_backend_html5_HTML5HTTPRequest.__revokeBlobURI(uri,options);
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
			lime__$internal_backend_html5_HTML5HTTPRequest.processQueue();
			promise.error(event.detail);
		},false);
		image.src = uri;
	} else {
		var request = new XMLHttpRequest();
		request.onload = function(_) {
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
			lime__$internal_backend_html5_HTML5HTTPRequest.processQueue();
			var img = new lime_graphics_Image();
			img.__fromBytes(haxe_io_Bytes.ofData(request.response),function(img) {
				promise.complete(img);
			});
		};
		request.onerror = function(event) {
			promise.error(event.message);
		};
		request.onprogress = function(event) {
			if(event.lengthComputable) {
				promise.progress(event.loaded,event.total);
			}
		};
		request.open("GET",uri,true);
		request.responseType = "arraybuffer";
		request.overrideMimeType("text/plain; charset=x-user-defined");
		request.send(null);
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.__revokeBlobURI = function(uri,options) {
	if((options & 1) != 0) {
		URL.revokeObjectURL(uri);
	}
};
lime__$internal_backend_html5_HTML5HTTPRequest.prototype = {
	cancel: function() {
		if(this.request != null) {
			this.request.abort();
		}
	}
	,init: function(parent) {
		this.parent = parent;
	}
	,load: function(uri,progress,readyStateChange) {
		this.request = new XMLHttpRequest();
		if(this.parent.method == "POST") {
			this.request.upload.addEventListener("progress",progress,false);
		} else {
			this.request.addEventListener("progress",progress,false);
		}
		this.request.onreadystatechange = readyStateChange;
		var query = "";
		if(this.parent.data == null) {
			var key = haxe_ds_StringMap.keysIterator(this.parent.formData.h);
			while(key.hasNext()) {
				var key1 = key.next();
				if(query.length > 0) {
					query += "&";
				}
				var value = this.parent.formData.h[key1];
				if(key1.indexOf("[]") > -1 && ((value) instanceof Array)) {
					var _g = [];
					var x = $getIterator(value);
					while(x.hasNext()) {
						var x1 = x.next();
						_g.push(encodeURIComponent(x1));
					}
					var arrayValue = _g.join("&amp;" + key1 + "=");
					query += encodeURIComponent(key1) + "=" + arrayValue;
				} else {
					var query1 = encodeURIComponent(key1) + "=";
					var s = Std.string(value);
					query += query1 + encodeURIComponent(s);
				}
			}
			if(this.parent.method == "GET" && query != "") {
				if(uri.indexOf("?") > -1) {
					uri += "&" + query;
				} else {
					uri += "?" + query;
				}
				query = "";
			}
		}
		this.request.open(Std.string(this.parent.method),uri,true);
		if(this.parent.timeout > 0) {
			this.request.timeout = this.parent.timeout;
		}
		if(this.binary) {
			this.request.responseType = "arraybuffer";
		}
		var contentType = null;
		var _g = 0;
		var _g1 = this.parent.headers;
		while(_g < _g1.length) {
			var header = _g1[_g];
			++_g;
			if(header.name == "Content-Type") {
				contentType = header.value;
			} else {
				this.request.setRequestHeader(header.name,header.value);
			}
		}
		if(this.parent.contentType != null) {
			contentType = this.parent.contentType;
		}
		if(contentType == null) {
			if(this.parent.data != null) {
				contentType = "application/octet-stream";
			} else if(query != "") {
				contentType = "application/x-www-form-urlencoded";
			}
		}
		if(contentType != null) {
			this.request.setRequestHeader("Content-Type",contentType);
		}
		if(this.parent.withCredentials) {
			this.request.withCredentials = true;
		}
		if(this.parent.data != null) {
			this.request.send(this.parent.data.b.bufferValue);
		} else {
			this.request.send(query);
		}
	}
	,loadData: function(uri) {
		var promise = new lime_app_Promise();
		if(lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests < lime__$internal_backend_html5_HTML5HTTPRequest.requestLimit) {
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests++;
			this.__loadData(uri,promise);
		} else {
			lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.add({ instance : this, uri : uri, promise : promise, type : "BINARY", options : 0});
		}
		return promise.future;
	}
	,loadText: function(uri) {
		var promise = new lime_app_Promise();
		if(lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests < lime__$internal_backend_html5_HTML5HTTPRequest.requestLimit) {
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests++;
			this.__loadText(uri,promise);
		} else {
			lime__$internal_backend_html5_HTML5HTTPRequest.requestQueue.add({ instance : this, uri : uri, promise : promise, type : "TEXT", options : 0});
		}
		return promise.future;
	}
	,processResponse: function() {
		if(this.parent.enableResponseHeaders) {
			this.parent.responseHeaders = [];
			var name;
			var value;
			var _g = 0;
			var _g1 = this.request.getAllResponseHeaders().split("\n");
			while(_g < _g1.length) {
				var line = _g1[_g];
				++_g;
				name = StringTools.trim(HxOverrides.substr(line,0,line.indexOf(":")));
				value = StringTools.trim(HxOverrides.substr(line,line.indexOf(":") + 1,null));
				if(name != "") {
					this.parent.responseHeaders.push(new lime_net_HTTPRequestHeader(name,value));
				}
			}
		}
		this.parent.responseStatus = this.request.status;
	}
	,__loadData: function(uri,promise) {
		var _gthis = this;
		var progress = function(event) {
			promise.progress(event.loaded,event.total);
		};
		var readyStateChange = function(event) {
			if(_gthis.request.readyState != 4) {
				return;
			}
			if(_gthis.request.status != null && (_gthis.request.status >= 200 && _gthis.request.status < 400 || _gthis.validStatus0 && _gthis.request.status == 0)) {
				var bytes = null;
				if(_gthis.request.responseType == "") {
					if(_gthis.request.responseText != null) {
						bytes = haxe_io_Bytes.ofString(_gthis.request.responseText);
					}
				} else if(_gthis.request.response != null) {
					bytes = haxe_io_Bytes.ofData(_gthis.request.response);
				}
				_gthis.processResponse();
				promise.complete(bytes);
			} else {
				_gthis.processResponse();
				promise.error(_gthis.request.status);
			}
			_gthis.request = null;
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
			lime__$internal_backend_html5_HTML5HTTPRequest.processQueue();
		};
		this.binary = true;
		this.load(uri,progress,readyStateChange);
	}
	,__loadText: function(uri,promise) {
		var _gthis = this;
		var progress = function(event) {
			promise.progress(event.loaded,event.total);
		};
		var readyStateChange = function(event) {
			if(_gthis.request.readyState != 4) {
				return;
			}
			if(_gthis.request.status != null && (_gthis.request.status >= 200 && _gthis.request.status <= 400 || _gthis.validStatus0 && _gthis.request.status == 0)) {
				_gthis.processResponse();
				promise.complete(_gthis.request.responseText);
			} else {
				_gthis.processResponse();
				promise.error(_gthis.request.status);
			}
			_gthis.request = null;
			lime__$internal_backend_html5_HTML5HTTPRequest.activeRequests--;
			lime__$internal_backend_html5_HTML5HTTPRequest.processQueue();
		};
		this.binary = false;
		this.load(uri,progress,readyStateChange);
	}
	,__class__: lime__$internal_backend_html5_HTML5HTTPRequest
};
var lime__$internal_backend_html5_HTML5Window = function(parent) {
	this.inputing = false;
	this.unusedTouchesPool = new haxe_ds_List();
	this.scale = 1.0;
	this.currentTouches = new haxe_ds_IntMap();
	this.parent = parent;
	this.cursor = lime_ui_MouseCursor.DEFAULT;
	this.cacheMouseX = 0;
	this.cacheMouseY = 0;
	var attributes = parent.__attributes;
	if(!Object.prototype.hasOwnProperty.call(attributes,"context")) {
		attributes.context = { };
	}
	this.renderType = attributes.context.type;
	if(Object.prototype.hasOwnProperty.call(attributes,"element")) {
		parent.element = attributes.element;
	}
	var element = parent.element;
	if(Object.prototype.hasOwnProperty.call(attributes,"allowHighDPI") && attributes.allowHighDPI && this.renderType != "dom") {
		this.scale = window.devicePixelRatio;
	}
	parent.__scale = this.scale;
	this.setWidth = Object.prototype.hasOwnProperty.call(attributes,"width") ? attributes.width : 0;
	this.setHeight = Object.prototype.hasOwnProperty.call(attributes,"height") ? attributes.height : 0;
	parent.__width = this.setWidth;
	parent.__height = this.setHeight;
	parent.id = lime__$internal_backend_html5_HTML5Window.windowID++;
	if(((element) instanceof HTMLCanvasElement)) {
		this.canvas = element;
	} else if(this.renderType == "dom") {
		this.div = window.document.createElement("div");
	} else {
		this.canvas = window.document.createElement("canvas");
	}
	if(this.canvas != null) {
		var style = this.canvas.style;
		style.setProperty("-webkit-transform","translateZ(0)",null);
		style.setProperty("transform","translateZ(0)",null);
	} else if(this.div != null) {
		var style = this.div.style;
		style.setProperty("-webkit-transform","translate3D(0,0,0)",null);
		style.setProperty("transform","translate3D(0,0,0)",null);
		style.position = "relative";
		style.overflow = "hidden";
		style.setProperty("-webkit-user-select","none",null);
		style.setProperty("-moz-user-select","none",null);
		style.setProperty("-ms-user-select","none",null);
		style.setProperty("-o-user-select","none",null);
	}
	if(parent.__width == 0 && parent.__height == 0) {
		if(element != null) {
			parent.__width = element.clientWidth;
			parent.__height = element.clientHeight;
		} else {
			parent.__width = window.innerWidth;
			parent.__height = window.innerHeight;
		}
		this.cacheElementWidth = parent.__width;
		this.cacheElementHeight = parent.__height;
		this.resizeElement = true;
	}
	if(this.canvas != null) {
		this.canvas.width = Math.round(parent.__width * this.scale);
		this.canvas.height = Math.round(parent.__height * this.scale);
		this.canvas.style.width = parent.__width + "px";
		this.canvas.style.height = parent.__height + "px";
	} else {
		this.div.style.width = parent.__width + "px";
		this.div.style.height = parent.__height + "px";
	}
	if(Object.prototype.hasOwnProperty.call(attributes,"resizable") && attributes.resizable || !Object.prototype.hasOwnProperty.call(attributes,"width") && this.setWidth == 0 && this.setHeight == 0) {
		parent.__resizable = true;
	}
	this.updateSize();
	if(element != null) {
		if(this.canvas != null) {
			if(element != this.canvas) {
				element.appendChild(this.canvas);
			}
		} else {
			element.appendChild(this.div);
		}
		var events = ["mousedown","mouseenter","mouseleave","mousemove","mouseup","wheel"];
		var _g = 0;
		while(_g < events.length) {
			var event = events[_g];
			++_g;
			element.addEventListener(event,$bind(this,this.handleMouseEvent),true);
		}
		element.addEventListener("contextmenu",$bind(this,this.handleContextMenuEvent),true);
		element.addEventListener("dragstart",$bind(this,this.handleDragEvent),true);
		element.addEventListener("dragover",$bind(this,this.handleDragEvent),true);
		element.addEventListener("drop",$bind(this,this.handleDragEvent),true);
		element.addEventListener("touchstart",$bind(this,this.handleTouchEvent),true);
		element.addEventListener("touchmove",$bind(this,this.handleTouchEvent),true);
		element.addEventListener("touchend",$bind(this,this.handleTouchEvent),true);
		element.addEventListener("touchcancel",$bind(this,this.handleTouchEvent),true);
		element.addEventListener("gamepadconnected",$bind(this,this.handleGamepadEvent),true);
		element.addEventListener("gamepaddisconnected",$bind(this,this.handleGamepadEvent),true);
	}
	this.createContext();
	if(parent.context.type == "webgl") {
		this.canvas.addEventListener("webglcontextlost",$bind(this,this.handleContextEvent),false);
		this.canvas.addEventListener("webglcontextrestored",$bind(this,this.handleContextEvent),false);
	}
};
$hxClasses["lime._internal.backend.html5.HTML5Window"] = lime__$internal_backend_html5_HTML5Window;
lime__$internal_backend_html5_HTML5Window.__name__ = "lime._internal.backend.html5.HTML5Window";
lime__$internal_backend_html5_HTML5Window.prototype = {
	alert: function(message,title) {
		if(message != null) {
			window.alert(Std.string(message));
		}
	}
	,close: function() {
		this.parent.application.__removeWindow(this.parent);
	}
	,createContext: function() {
		var context = new lime_graphics_RenderContext();
		var contextAttributes = this.parent.__attributes.context;
		context.window = this.parent;
		context.attributes = contextAttributes;
		if(this.div != null) {
			context.dom = this.div;
			context.type = "dom";
			context.version = "";
		} else if(this.canvas != null) {
			var webgl = null;
			var forceCanvas = this.renderType == "canvas";
			var forceWebGL = this.renderType == "opengl" || this.renderType == "opengles" || this.renderType == "webgl";
			var allowWebGL2 = !Object.prototype.hasOwnProperty.call(contextAttributes,"version") || contextAttributes.version != "1";
			var isWebGL2 = false;
			if(forceWebGL || !forceCanvas && (!Object.prototype.hasOwnProperty.call(contextAttributes,"hardware") || contextAttributes.hardware)) {
				var transparentBackground = Object.prototype.hasOwnProperty.call(contextAttributes,"background") && contextAttributes.background == null;
				var colorDepth = Object.prototype.hasOwnProperty.call(contextAttributes,"colorDepth") ? contextAttributes.colorDepth : 16;
				var options = Object.prototype.hasOwnProperty.call(contextAttributes,"antialiasing") && contextAttributes.antialiasing > 0;
				var options1 = Object.prototype.hasOwnProperty.call(contextAttributes,"depth") ? contextAttributes.depth : true;
				var options2 = Object.prototype.hasOwnProperty.call(contextAttributes,"stencil") && contextAttributes.stencil;
				var options3 = { alpha : transparentBackground || colorDepth > 16, antialias : options, depth : options1, premultipliedAlpha : true, stencil : options2, preserveDrawingBuffer : false, failIfMajorPerformanceCaveat : false};
				var glContextType = ["webgl","experimental-webgl"];
				if(allowWebGL2) {
					glContextType.unshift("webgl2");
				}
				var _g = 0;
				while(_g < glContextType.length) {
					var name = glContextType[_g];
					++_g;
					webgl = this.canvas.getContext(name,options3);
					if(webgl != null && name == "webgl2") {
						isWebGL2 = true;
					}
					if(webgl != null) {
						break;
					}
				}
			}
			if(webgl == null) {
				context.canvas2D = this.canvas.getContext("2d");
				context.type = "canvas";
				context.version = "";
			} else {
				context.webgl = lime_graphics_WebGLRenderContext.fromWebGL2RenderContext(webgl);
				if(isWebGL2) {
					context.webgl2 = webgl;
				}
				if(lime_graphics_opengl_GL.context == null) {
					lime_graphics_opengl_GL.context = webgl;
					lime_graphics_opengl_GL.type = "webgl";
					lime_graphics_opengl_GL.version = isWebGL2 ? 2 : 1;
				}
				context.type = "webgl";
				context.version = isWebGL2 ? "2" : "1";
			}
		}
		this.parent.context = context;
	}
	,focus: function() {
	}
	,getCursor: function() {
		return this.cursor;
	}
	,getDisplay: function() {
		return lime_system_System.getDisplay(0);
	}
	,getDisplayMode: function() {
		return lime_system_System.getDisplay(0).currentMode;
	}
	,getFrameRate: function() {
		if(this.parent.application == null) {
			return 0;
		}
		if(this.parent.application.__backend.framePeriod < 0) {
			return 60;
		} else if(this.parent.application.__backend.framePeriod == 1000) {
			return 0;
		} else {
			return 1000 / this.parent.application.__backend.framePeriod;
		}
	}
	,getMouseLock: function() {
		return false;
	}
	,getTextInputEnabled: function() {
		return this.textInputEnabled;
	}
	,handleContextEvent: function(event) {
		switch(event.type) {
		case "webglcontextlost":
			if(event.cancelable) {
				event.preventDefault();
			}
			var tmp = lime_graphics_opengl_GL.context != null;
			this.parent.context = null;
			this.parent.onRenderContextLost.dispatch();
			break;
		case "webglcontextrestored":
			this.createContext();
			this.parent.onRenderContextRestored.dispatch(this.parent.context);
			break;
		default:
		}
	}
	,handleContextMenuEvent: function(event) {
		if((this.parent.onMouseUp.canceled || this.parent.onMouseDown.canceled) && event.cancelable) {
			event.preventDefault();
		}
	}
	,handleCutOrCopyEvent: function(event) {
		event.clipboardData.setData("text/plain",lime_system_Clipboard.get_text());
		if(event.cancelable) {
			event.preventDefault();
		}
	}
	,handleDragEvent: function(event) {
		switch(event.type) {
		case "dragover":
			event.preventDefault();
			return false;
		case "dragstart":
			if((js_Boot.__cast(event.target , HTMLElement)).nodeName.toLowerCase() == "img" && event.cancelable) {
				event.preventDefault();
				return false;
			}
			break;
		case "drop":
			if(event.dataTransfer != null && event.dataTransfer.files.length > 0) {
				this.parent.onDropFile.dispatch(event.dataTransfer.files);
				event.preventDefault();
				return false;
			}
			break;
		}
		return true;
	}
	,handleFocusEvent: function(event) {
		var _gthis = this;
		if(this.textInputEnabled) {
			if(event.relatedTarget == null || this.isDescendent(event.relatedTarget)) {
				haxe_Timer.delay(function() {
					if(_gthis.textInputEnabled) {
						lime__$internal_backend_html5_HTML5Window.textInput.focus();
					}
				},20);
			}
		}
	}
	,handleFullscreenEvent: function(event) {
		var fullscreenElement = document.fullscreenElement || document.mozFullScreenElement || document.webkitFullscreenElement || document.msFullscreenElement;
		if(fullscreenElement != null) {
			this.isFullscreen = true;
			this.parent.__fullscreen = true;
			if(this.requestedFullscreen) {
				this.requestedFullscreen = false;
				this.parent.onFullscreen.dispatch();
			}
		} else {
			this.isFullscreen = false;
			this.parent.__fullscreen = false;
			this.parent.onRestore.dispatch();
			var changeEvents = ["fullscreenchange","mozfullscreenchange","webkitfullscreenchange","MSFullscreenChange"];
			var errorEvents = ["fullscreenerror","mozfullscreenerror","webkitfullscreenerror","MSFullscreenError"];
			var _g = 0;
			var _g1 = changeEvents.length;
			while(_g < _g1) {
				var i = _g++;
				window.document.removeEventListener(changeEvents[i],$bind(this,this.handleFullscreenEvent),false);
				window.document.removeEventListener(errorEvents[i],$bind(this,this.handleFullscreenEvent),false);
			}
		}
	}
	,handleGamepadEvent: function(event) {
		switch(event.type) {
		case "gamepadconnected":
			lime_ui_Joystick.__connect(event.gamepad.index);
			if(event.gamepad.mapping == "standard") {
				lime_ui_Gamepad.__connect(event.gamepad.index);
			}
			break;
		case "gamepaddisconnected":
			lime_ui_Joystick.__disconnect(event.gamepad.index);
			lime_ui_Gamepad.__disconnect(event.gamepad.index);
			break;
		default:
		}
	}
	,handleInputEvent: function(event) {
		if(this.inputing) {
			return;
		}
		if(lime__$internal_backend_html5_HTML5Window.textInput.value != lime__$internal_backend_html5_HTML5Window.dummyCharacter) {
			var value = StringTools.replace(lime__$internal_backend_html5_HTML5Window.textInput.value,lime__$internal_backend_html5_HTML5Window.dummyCharacter,"");
			if(value.length > 0) {
				this.parent.onTextInput.dispatch(value);
			}
			lime__$internal_backend_html5_HTML5Window.textInput.value = lime__$internal_backend_html5_HTML5Window.dummyCharacter;
		}
	}
	,handleMouseEvent: function(event) {
		var x = 0.0;
		var y = 0.0;
		if(event.type != "wheel") {
			if(this.parent.element != null) {
				if(this.canvas != null) {
					var rect = this.canvas.getBoundingClientRect();
					x = (event.clientX - rect.left) * (this.parent.__width / rect.width);
					y = (event.clientY - rect.top) * (this.parent.__height / rect.height);
				} else if(this.div != null) {
					var rect = this.div.getBoundingClientRect();
					x = event.clientX - rect.left;
					y = event.clientY - rect.top;
				} else {
					var rect = this.parent.element.getBoundingClientRect();
					x = (event.clientX - rect.left) * (this.parent.__width / rect.width);
					y = (event.clientY - rect.top) * (this.parent.__height / rect.height);
				}
			} else {
				x = event.clientX;
				y = event.clientY;
			}
			switch(event.type) {
			case "mousedown":
				if(event.currentTarget == this.parent.element) {
					window.addEventListener("mouseup",$bind(this,this.handleMouseEvent));
				}
				this.parent.onMouseDown.dispatch(x,y,event.button);
				if(this.parent.onMouseDown.canceled && event.cancelable) {
					event.preventDefault();
				}
				break;
			case "mouseenter":
				if(event.target == this.parent.element) {
					this.parent.onEnter.dispatch();
					if(this.parent.onEnter.canceled && event.cancelable) {
						event.preventDefault();
					}
				}
				break;
			case "mouseleave":
				if(event.target == this.parent.element) {
					this.parent.onLeave.dispatch();
					if(this.parent.onLeave.canceled && event.cancelable) {
						event.preventDefault();
					}
				}
				break;
			case "mousemove":
				if(x != this.cacheMouseX || y != this.cacheMouseY) {
					this.parent.onMouseMove.dispatch(x,y);
					this.parent.onMouseMoveRelative.dispatch(x - this.cacheMouseX,y - this.cacheMouseY);
					if((this.parent.onMouseMove.canceled || this.parent.onMouseMoveRelative.canceled) && event.cancelable) {
						event.preventDefault();
					}
				}
				break;
			case "mouseup":
				window.removeEventListener("mouseup",$bind(this,this.handleMouseEvent));
				if(event.currentTarget == this.parent.element) {
					event.stopPropagation();
				}
				this.parent.onMouseUp.dispatch(x,y,event.button);
				if(this.parent.onMouseUp.canceled && event.cancelable) {
					event.preventDefault();
				}
				break;
			default:
			}
			this.cacheMouseX = x;
			this.cacheMouseY = y;
		} else {
			var deltaMode;
			switch(event.deltaMode) {
			case 0:
				deltaMode = lime_ui_MouseWheelMode.PIXELS;
				break;
			case 1:
				deltaMode = lime_ui_MouseWheelMode.LINES;
				break;
			case 2:
				deltaMode = lime_ui_MouseWheelMode.PAGES;
				break;
			default:
				deltaMode = lime_ui_MouseWheelMode.UNKNOWN;
			}
			this.parent.onMouseWheel.dispatch(event.deltaX,-event.deltaY,deltaMode);
			if(this.parent.onMouseWheel.canceled && event.cancelable) {
				event.preventDefault();
			}
		}
	}
	,handlePasteEvent: function(event) {
		if(event.clipboardData.types.indexOf("text/plain") > -1) {
			var text = event.clipboardData.getData("text/plain");
			lime_system_Clipboard.set_text(text);
			if(this.textInputEnabled) {
				this.parent.onTextInput.dispatch(text);
			}
			if(event.cancelable) {
				event.preventDefault();
			}
		}
	}
	,handleResizeEvent: function(event) {
		this.primaryTouch = null;
		this.updateSize();
	}
	,handleTouchEvent: function(event) {
		if(event.cancelable) {
			event.preventDefault();
		}
		var rect = null;
		if(this.parent.element != null) {
			if(this.canvas != null) {
				rect = this.canvas.getBoundingClientRect();
			} else if(this.div != null) {
				rect = this.div.getBoundingClientRect();
			} else {
				rect = this.parent.element.getBoundingClientRect();
			}
		}
		var windowWidth = this.setWidth;
		var windowHeight = this.setHeight;
		if(windowWidth == 0 || windowHeight == 0) {
			if(rect != null) {
				windowWidth = rect.width;
				windowHeight = rect.height;
			} else {
				windowWidth = 1;
				windowHeight = 1;
			}
		}
		var touch;
		var x;
		var y;
		var cacheX;
		var cacheY;
		var _g = 0;
		var _g1 = event.changedTouches;
		while(_g < _g1.length) {
			var data = _g1[_g];
			++_g;
			x = 0.0;
			y = 0.0;
			if(rect != null) {
				x = (data.clientX - rect.left) * (windowWidth / rect.width);
				y = (data.clientY - rect.top) * (windowHeight / rect.height);
			} else {
				x = data.clientX;
				y = data.clientY;
			}
			if(event.type == "touchstart") {
				touch = this.unusedTouchesPool.pop();
				if(touch == null) {
					touch = new lime_ui_Touch(x / windowWidth,y / windowHeight,data.identifier,0,0,data.force,this.parent.id);
				} else {
					touch.x = x / windowWidth;
					touch.y = y / windowHeight;
					touch.id = data.identifier;
					touch.dx = 0;
					touch.dy = 0;
					touch.pressure = data.force;
					touch.device = this.parent.id;
				}
				this.currentTouches.h[data.identifier] = touch;
				lime_ui_Touch.onStart.dispatch(touch);
				if(this.primaryTouch == null) {
					this.primaryTouch = touch;
				}
				if(touch == this.primaryTouch) {
					this.parent.onMouseDown.dispatch(x,y,0);
				}
			} else {
				touch = this.currentTouches.h[data.identifier];
				if(touch != null) {
					cacheX = touch.x;
					cacheY = touch.y;
					touch.x = x / windowWidth;
					touch.y = y / windowHeight;
					touch.dx = touch.x - cacheX;
					touch.dy = touch.y - cacheY;
					touch.pressure = data.force;
					switch(event.type) {
					case "touchcancel":
						lime_ui_Touch.onCancel.dispatch(touch);
						this.currentTouches.remove(data.identifier);
						this.unusedTouchesPool.add(touch);
						if(touch == this.primaryTouch) {
							this.primaryTouch = null;
						}
						break;
					case "touchend":
						lime_ui_Touch.onEnd.dispatch(touch);
						this.currentTouches.remove(data.identifier);
						this.unusedTouchesPool.add(touch);
						if(touch == this.primaryTouch) {
							this.parent.onMouseUp.dispatch(x,y,0);
							this.primaryTouch = null;
						}
						break;
					case "touchmove":
						lime_ui_Touch.onMove.dispatch(touch);
						if(touch == this.primaryTouch) {
							this.parent.onMouseMove.dispatch(x,y);
						}
						break;
					default:
					}
				}
			}
		}
	}
	,isDescendent: function(node) {
		if(node == this.parent.element) {
			return true;
		}
		while(node != null) {
			if(node.parentNode == this.parent.element) {
				return true;
			}
			node = node.parentNode;
		}
		return false;
	}
	,move: function(x,y) {
	}
	,readPixels: function(rect) {
		if(this.canvas != null) {
			var stageRect = new lime_math_Rectangle(0,0,this.canvas.width,this.canvas.height);
			if(rect == null) {
				rect = stageRect;
			} else {
				rect.intersection(stageRect,rect);
			}
			if(rect.width > 0 && rect.height > 0) {
				var canvas2 = window.document.createElement("canvas");
				canvas2.width = rect.width | 0;
				canvas2.height = rect.height | 0;
				var context = canvas2.getContext("2d");
				context.drawImage(this.canvas,-rect.x,-rect.y);
				return lime_graphics_Image.fromCanvas(canvas2);
			}
		}
		return null;
	}
	,resize: function(width,height) {
	}
	,setBorderless: function(value) {
		return value;
	}
	,setClipboard: function(value) {
		if(lime__$internal_backend_html5_HTML5Window.textArea == null) {
			lime__$internal_backend_html5_HTML5Window.textArea = window.document.createElement("textarea");
			lime__$internal_backend_html5_HTML5Window.textArea.style.height = "0px";
			lime__$internal_backend_html5_HTML5Window.textArea.style.left = "-100px";
			lime__$internal_backend_html5_HTML5Window.textArea.style.opacity = "0";
			lime__$internal_backend_html5_HTML5Window.textArea.style.position = "fixed";
			lime__$internal_backend_html5_HTML5Window.textArea.style.top = "-100px";
			lime__$internal_backend_html5_HTML5Window.textArea.style.width = "0px";
			window.document.body.appendChild(lime__$internal_backend_html5_HTML5Window.textArea);
		}
		lime__$internal_backend_html5_HTML5Window.textArea.value = value;
		lime__$internal_backend_html5_HTML5Window.textArea.focus();
		lime__$internal_backend_html5_HTML5Window.textArea.select();
		if(window.document.queryCommandEnabled("copy")) {
			window.document.execCommand("copy");
		}
	}
	,setCursor: function(value) {
		if(this.cursor != value) {
			if(value == null) {
				this.parent.element.style.cursor = "none";
			} else {
				var tmp;
				switch(value._hx_index) {
				case 0:
					tmp = "default";
					break;
				case 1:
					tmp = "crosshair";
					break;
				case 3:
					tmp = "move";
					break;
				case 4:
					tmp = "pointer";
					break;
				case 5:
					tmp = "nesw-resize";
					break;
				case 6:
					tmp = "ns-resize";
					break;
				case 7:
					tmp = "nwse-resize";
					break;
				case 8:
					tmp = "ew-resize";
					break;
				case 9:
					tmp = "text";
					break;
				case 10:
					tmp = "wait";
					break;
				case 11:
					tmp = "wait";
					break;
				default:
					tmp = "auto";
				}
				this.parent.element.style.cursor = tmp;
			}
			this.cursor = value;
		}
		return this.cursor;
	}
	,setDisplayMode: function(value) {
		return value;
	}
	,setFrameRate: function(value) {
		if(this.parent.application != null) {
			if(value >= 60) {
				if(this.parent == this.parent.application.__window) {
					this.parent.application.__backend.framePeriod = -1;
				}
			} else if(value > 0) {
				if(this.parent == this.parent.application.__window) {
					this.parent.application.__backend.framePeriod = 1000 / value;
				}
			} else if(this.parent == this.parent.application.__window) {
				this.parent.application.__backend.framePeriod = 1000;
			}
		}
		return value;
	}
	,setFullscreen: function(value) {
		if(value) {
			if(!this.requestedFullscreen && !this.isFullscreen) {
				this.requestedFullscreen = true;
				if(($_=this.parent.element,$bind($_,$_.requestFullscreen))) {
					document.addEventListener("fullscreenchange",$bind(this,this.handleFullscreenEvent),false);
					document.addEventListener("fullscreenerror",$bind(this,this.handleFullscreenEvent),false);
					this.parent.element.requestFullscreen();
				} else if(this.parent.element.mozRequestFullScreen) {
					document.addEventListener("mozfullscreenchange",$bind(this,this.handleFullscreenEvent),false);
					document.addEventListener("mozfullscreenerror",$bind(this,this.handleFullscreenEvent),false);
					this.parent.element.mozRequestFullScreen();
				} else if(this.parent.element.webkitRequestFullscreen) {
					document.addEventListener("webkitfullscreenchange",$bind(this,this.handleFullscreenEvent),false);
					document.addEventListener("webkitfullscreenerror",$bind(this,this.handleFullscreenEvent),false);
					this.parent.element.webkitRequestFullscreen();
				} else if(this.parent.element.msRequestFullscreen) {
					document.addEventListener("MSFullscreenChange",$bind(this,this.handleFullscreenEvent),false);
					document.addEventListener("MSFullscreenError",$bind(this,this.handleFullscreenEvent),false);
					this.parent.element.msRequestFullscreen();
				}
			}
		} else if(this.isFullscreen) {
			this.requestedFullscreen = false;
			if(document.exitFullscreen) {
				document.exitFullscreen();
			} else if(document.mozCancelFullScreen) {
				document.mozCancelFullScreen();
			} else if(document.webkitExitFullscreen) {
				document.webkitExitFullscreen();
			} else if(document.msExitFullscreen) {
				document.msExitFullscreen();
			}
		}
		return value;
	}
	,setIcon: function(image) {
		lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image);
		var link = window.document.querySelector("link[rel*='icon']");
		if(link == null) {
			link = window.document.createElement("link");
		}
		link.type = "image/x-icon";
		link.rel = "shortcut icon";
		link.href = image.buffer.get_src().toDataURL("image/x-icon");
		window.document.getElementsByTagName("head")[0].appendChild(link);
	}
	,setMaximized: function(value) {
		return false;
	}
	,setMinimized: function(value) {
		return false;
	}
	,setMouseLock: function(value) {
	}
	,setResizable: function(value) {
		return value;
	}
	,setTextInputEnabled: function(value) {
		if(value) {
			if(lime__$internal_backend_html5_HTML5Window.textInput == null) {
				lime__$internal_backend_html5_HTML5Window.textInput = window.document.createElement("input");
				lime__$internal_backend_html5_HTML5Window.textInput.type = "text";
				lime__$internal_backend_html5_HTML5Window.textInput.style.position = "absolute";
				lime__$internal_backend_html5_HTML5Window.textInput.style.opacity = "0";
				lime__$internal_backend_html5_HTML5Window.textInput.style.color = "transparent";
				lime__$internal_backend_html5_HTML5Window.textInput.value = lime__$internal_backend_html5_HTML5Window.dummyCharacter;
				lime__$internal_backend_html5_HTML5Window.textInput.autocapitalize = "off";
				lime__$internal_backend_html5_HTML5Window.textInput.autocorrect = "off";
				lime__$internal_backend_html5_HTML5Window.textInput.autocomplete = "off";
				lime__$internal_backend_html5_HTML5Window.textInput.style.left = "0px";
				lime__$internal_backend_html5_HTML5Window.textInput.style.top = "50%";
				if(new EReg("(iPad|iPhone|iPod).*OS 8_","gi").match(window.navigator.userAgent)) {
					lime__$internal_backend_html5_HTML5Window.textInput.style.fontSize = "0px";
					lime__$internal_backend_html5_HTML5Window.textInput.style.width = "0px";
					lime__$internal_backend_html5_HTML5Window.textInput.style.height = "0px";
				} else {
					lime__$internal_backend_html5_HTML5Window.textInput.style.width = "1px";
					lime__$internal_backend_html5_HTML5Window.textInput.style.height = "1px";
				}
				lime__$internal_backend_html5_HTML5Window.textInput.style.pointerEvents = "none";
				lime__$internal_backend_html5_HTML5Window.textInput.style.zIndex = "-10000000";
			}
			if(lime__$internal_backend_html5_HTML5Window.textInput.parentNode == null) {
				this.parent.element.appendChild(lime__$internal_backend_html5_HTML5Window.textInput);
			}
			if(!this.textInputEnabled) {
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("input",$bind(this,this.handleInputEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("blur",$bind(this,this.handleFocusEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("cut",$bind(this,this.handleCutOrCopyEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("copy",$bind(this,this.handleCutOrCopyEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("paste",$bind(this,this.handlePasteEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("compositionstart",$bind(this,this.handleCompositionstartEvent),true);
				lime__$internal_backend_html5_HTML5Window.textInput.addEventListener("compositionend",$bind(this,this.handleCompositionendEvent),true);
			}
			lime__$internal_backend_html5_HTML5Window.textInput.focus();
			lime__$internal_backend_html5_HTML5Window.textInput.select();
		} else if(lime__$internal_backend_html5_HTML5Window.textInput != null) {
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("input",$bind(this,this.handleInputEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("blur",$bind(this,this.handleFocusEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("cut",$bind(this,this.handleCutOrCopyEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("copy",$bind(this,this.handleCutOrCopyEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("paste",$bind(this,this.handlePasteEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("compositionstart",$bind(this,this.handleCompositionstartEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.removeEventListener("compositionend",$bind(this,this.handleCompositionendEvent),true);
			lime__$internal_backend_html5_HTML5Window.textInput.blur();
		}
		return this.textInputEnabled = value;
	}
	,handleCompositionstartEvent: function(e) {
		this.inputing = true;
	}
	,handleCompositionendEvent: function(e) {
		this.inputing = false;
		this.handleInputEvent(e);
	}
	,setTitle: function(value) {
		if(value != null) {
			window.document.title = value;
		}
		return value;
	}
	,updateSize: function() {
		if(!this.parent.__resizable) {
			return;
		}
		var elementWidth;
		var elementHeight;
		if(this.parent.element != null) {
			elementWidth = this.parent.element.clientWidth;
			elementHeight = this.parent.element.clientHeight;
		} else {
			elementWidth = window.innerWidth;
			elementHeight = window.innerHeight;
		}
		if(elementWidth != this.cacheElementWidth || elementHeight != this.cacheElementHeight) {
			this.cacheElementWidth = elementWidth;
			this.cacheElementHeight = elementHeight;
			var stretch = this.resizeElement || this.setWidth == 0 && this.setHeight == 0;
			if(this.parent.element != null && (this.div == null || this.div != null && stretch)) {
				if(stretch) {
					if(this.parent.__width != elementWidth || this.parent.__height != elementHeight) {
						this.parent.__width = elementWidth;
						this.parent.__height = elementHeight;
						if(this.canvas != null) {
							if(this.parent.element != this.canvas) {
								this.canvas.width = Math.round(elementWidth * this.scale);
								this.canvas.height = Math.round(elementHeight * this.scale);
								this.canvas.style.width = elementWidth + "px";
								this.canvas.style.height = elementHeight + "px";
							}
						} else {
							this.div.style.width = elementWidth + "px";
							this.div.style.height = elementHeight + "px";
						}
						this.parent.onResize.dispatch(elementWidth,elementHeight);
					}
				} else {
					var scaleX = this.setWidth != 0 ? elementWidth / this.setWidth : 1;
					var scaleY = this.setHeight != 0 ? elementHeight / this.setHeight : 1;
					var targetWidth = elementWidth;
					var targetHeight = elementHeight;
					var marginLeft = 0;
					var marginTop = 0;
					if(scaleX < scaleY) {
						targetHeight = Math.floor(this.setHeight * scaleX);
						marginTop = Math.floor((elementHeight - targetHeight) / 2);
					} else {
						targetWidth = Math.floor(this.setWidth * scaleY);
						marginLeft = Math.floor((elementWidth - targetWidth) / 2);
					}
					if(this.canvas != null) {
						if(this.parent.element != this.canvas) {
							this.canvas.style.width = targetWidth + "px";
							this.canvas.style.height = targetHeight + "px";
							this.canvas.style.marginLeft = marginLeft + "px";
							this.canvas.style.marginTop = marginTop + "px";
						}
					} else {
						this.div.style.width = targetWidth + "px";
						this.div.style.height = targetHeight + "px";
						this.div.style.marginLeft = marginLeft + "px";
						this.div.style.marginTop = marginTop + "px";
					}
				}
			}
		}
	}
	,warpMouse: function(x,y) {
	}
	,__class__: lime__$internal_backend_html5_HTML5Window
};
var lime__$internal_backend_native_NativeCFFI = function() { };
$hxClasses["lime._internal.backend.native.NativeCFFI"] = lime__$internal_backend_native_NativeCFFI;
lime__$internal_backend_native_NativeCFFI.__name__ = "lime._internal.backend.native.NativeCFFI";
var lime__$internal_format_BMP = function() { };
$hxClasses["lime._internal.format.BMP"] = lime__$internal_format_BMP;
lime__$internal_format_BMP.__name__ = "lime._internal.format.BMP";
lime__$internal_format_BMP.encode = function(image,type) {
	if(image.get_premultiplied() || image.get_format() != 0) {
		image = image.clone();
		image.set_premultiplied(false);
		image.set_format(0);
	}
	if(type == null) {
		type = lime__$internal_format_BMPType.RGB;
	}
	var fileHeaderLength = 14;
	var infoHeaderLength = 40;
	var pixelValuesLength = image.width * image.height * 4;
	if(type != null) {
		switch(type._hx_index) {
		case 0:
			pixelValuesLength = (image.width * 3 + image.width * 3 % 4) * image.height;
			break;
		case 1:
			infoHeaderLength = 108;
			break;
		case 2:
			fileHeaderLength = 0;
			pixelValuesLength += image.width * image.height;
			break;
		}
	}
	var data = new haxe_io_Bytes(new ArrayBuffer(fileHeaderLength + infoHeaderLength + pixelValuesLength));
	var position = 0;
	if(fileHeaderLength > 0) {
		data.b[position++] = 66;
		data.b[position++] = 77;
		data.setInt32(position,data.length);
		position += 4;
		data.setUInt16(position,0);
		position += 2;
		data.setUInt16(position,0);
		position += 2;
		data.setInt32(position,fileHeaderLength + infoHeaderLength);
		position += 4;
	}
	data.setInt32(position,infoHeaderLength);
	position += 4;
	data.setInt32(position,image.width);
	position += 4;
	data.setInt32(position,type == lime__$internal_format_BMPType.ICO ? image.height * 2 : image.height);
	position += 4;
	data.setUInt16(position,1);
	position += 2;
	data.setUInt16(position,type == lime__$internal_format_BMPType.RGB ? 24 : 32);
	position += 2;
	data.setInt32(position,type == lime__$internal_format_BMPType.BITFIELD ? 3 : 0);
	position += 4;
	data.setInt32(position,pixelValuesLength);
	position += 4;
	data.setInt32(position,11824);
	position += 4;
	data.setInt32(position,11824);
	position += 4;
	data.setInt32(position,0);
	position += 4;
	data.setInt32(position,0);
	position += 4;
	if(type == lime__$internal_format_BMPType.BITFIELD) {
		data.setInt32(position,16711680);
		position += 4;
		data.setInt32(position,65280);
		position += 4;
		data.setInt32(position,255);
		position += 4;
		data.setInt32(position,-16777216);
		position += 4;
		data.b[position++] = 32;
		data.b[position++] = 110;
		data.b[position++] = 105;
		data.b[position++] = 87;
		var _g = 0;
		while(_g < 48) {
			var i = _g++;
			data.b[position++] = 0;
		}
	}
	var pixels = image.getPixels(new lime_math_Rectangle(0,0,image.width,image.height),1);
	var readPosition = 0;
	var a;
	var r;
	var g;
	var b;
	if(type != null) {
		switch(type._hx_index) {
		case 0:
			var _g = 0;
			var _g1 = image.height;
			while(_g < _g1) {
				var y = _g++;
				readPosition = (image.height - 1 - y) * 4 * image.width;
				var _g2 = 0;
				var _g3 = image.width;
				while(_g2 < _g3) {
					var x = _g2++;
					a = pixels.b[readPosition++];
					r = pixels.b[readPosition++];
					g = pixels.b[readPosition++];
					b = pixels.b[readPosition++];
					data.b[position++] = b & 255;
					data.b[position++] = g & 255;
					data.b[position++] = r & 255;
				}
				var _g4 = 0;
				var _g5 = image.width * 3 % 4;
				while(_g4 < _g5) {
					var i = _g4++;
					data.b[position++] = 0;
				}
			}
			break;
		case 1:
			var _g = 0;
			var _g1 = image.height;
			while(_g < _g1) {
				var y = _g++;
				readPosition = (image.height - 1 - y) * 4 * image.width;
				var _g2 = 0;
				var _g3 = image.width;
				while(_g2 < _g3) {
					var x = _g2++;
					a = pixels.b[readPosition++];
					r = pixels.b[readPosition++];
					g = pixels.b[readPosition++];
					b = pixels.b[readPosition++];
					data.b[position++] = b & 255;
					data.b[position++] = g & 255;
					data.b[position++] = r & 255;
					data.b[position++] = a & 255;
				}
			}
			break;
		case 2:
			var andMask = new haxe_io_Bytes(new ArrayBuffer(image.width * image.height));
			var maskPosition = 0;
			var _g = 0;
			var _g1 = image.height;
			while(_g < _g1) {
				var y = _g++;
				readPosition = (image.height - 1 - y) * 4 * image.width;
				var _g2 = 0;
				var _g3 = image.width;
				while(_g2 < _g3) {
					var x = _g2++;
					a = pixels.b[readPosition++];
					r = pixels.b[readPosition++];
					g = pixels.b[readPosition++];
					b = pixels.b[readPosition++];
					data.b[position++] = b & 255;
					data.b[position++] = g & 255;
					data.b[position++] = r & 255;
					data.b[position++] = a & 255;
					andMask.b[maskPosition++] = 0;
				}
			}
			data.blit(position,andMask,0,image.width * image.height);
			break;
		}
	}
	return data;
};
var lime__$internal_format_BMPType = $hxEnums["lime._internal.format.BMPType"] = { __ename__ : "lime._internal.format.BMPType", __constructs__ : ["RGB","BITFIELD","ICO"]
	,RGB: {_hx_index:0,__enum__:"lime._internal.format.BMPType",toString:$estr}
	,BITFIELD: {_hx_index:1,__enum__:"lime._internal.format.BMPType",toString:$estr}
	,ICO: {_hx_index:2,__enum__:"lime._internal.format.BMPType",toString:$estr}
};
var lime__$internal_format_Base64 = function() { };
$hxClasses["lime._internal.format.Base64"] = lime__$internal_format_Base64;
lime__$internal_format_Base64.__name__ = "lime._internal.format.Base64";
lime__$internal_format_Base64.decode = function(source) {
	return haxe_crypto_Base64.decode(source);
};
lime__$internal_format_Base64.encode = function(source) {
	var result = [];
	var dictionary = lime__$internal_format_Base64.DICTIONARY;
	var extendedDictionary = lime__$internal_format_Base64.EXTENDED_DICTIONARY;
	var numBytes = source.length;
	var numInputTriplets = Math.floor(numBytes / 3);
	var numChunksToWrite = numInputTriplets * 2;
	result.length = Math.ceil(numBytes / 3) * 2;
	var numBytesRead = 0;
	var numChunksWritten = 0;
	var inputTriplet;
	while(numChunksWritten < numChunksToWrite) {
		inputTriplet = source.b[numBytesRead] << 16 | source.b[numBytesRead + 1] << 8 | source.b[numBytesRead + 2];
		result[numChunksWritten] = extendedDictionary[inputTriplet >> 12 & 4095];
		result[numChunksWritten + 1] = extendedDictionary[inputTriplet & 4095];
		numBytesRead += 3;
		numChunksWritten += 2;
	}
	switch(numBytes - numInputTriplets * 3) {
	case 1:
		inputTriplet = source.b[numBytesRead] << 16;
		result[numChunksWritten] = extendedDictionary[inputTriplet >> 12 & 4095];
		result[numChunksWritten + 1] = "==";
		break;
	case 2:
		inputTriplet = source.b[numBytesRead] << 16 | source.b[numBytesRead + 1] << 8;
		result[numChunksWritten] = extendedDictionary[inputTriplet >> 12 & 4095];
		result[numChunksWritten + 1] = dictionary[inputTriplet >> 6 & 63] + "=";
		break;
	default:
	}
	return result.join("");
};
var lime__$internal_format_Deflate = function() { };
$hxClasses["lime._internal.format.Deflate"] = lime__$internal_format_Deflate;
lime__$internal_format_Deflate.__name__ = "lime._internal.format.Deflate";
lime__$internal_format_Deflate.compress = function(bytes) {
	var data = pako.deflateRaw(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
lime__$internal_format_Deflate.decompress = function(bytes) {
	var data = pako.inflateRaw(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
var lime__$internal_format_GZip = function() { };
$hxClasses["lime._internal.format.GZip"] = lime__$internal_format_GZip;
lime__$internal_format_GZip.__name__ = "lime._internal.format.GZip";
lime__$internal_format_GZip.compress = function(bytes) {
	var data = pako.gzip(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
lime__$internal_format_GZip.decompress = function(bytes) {
	var data = pako.ungzip(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
var lime__$internal_format_JPEG = function() { };
$hxClasses["lime._internal.format.JPEG"] = lime__$internal_format_JPEG;
lime__$internal_format_JPEG.__name__ = "lime._internal.format.JPEG";
lime__$internal_format_JPEG.decodeBytes = function(bytes,decodeData) {
	if(decodeData == null) {
		decodeData = true;
	}
	return null;
};
lime__$internal_format_JPEG.decodeFile = function(path,decodeData) {
	if(decodeData == null) {
		decodeData = true;
	}
	return null;
};
lime__$internal_format_JPEG.encode = function(image,quality) {
	if(image.get_premultiplied() || image.get_format() != 0) {
		image = image.clone();
		image.set_premultiplied(false);
		image.set_format(0);
	}
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,false);
	if(image.buffer.__srcCanvas != null) {
		var data = image.buffer.__srcCanvas.toDataURL("image/jpeg",quality / 100);
		var buffer = window.atob(data.split(";base64,")[1]);
		var bytes = new haxe_io_Bytes(new ArrayBuffer(buffer.length));
		var _g = 0;
		var _g1 = buffer.length;
		while(_g < _g1) {
			var i = _g++;
			bytes.b[i] = HxOverrides.cca(buffer,i) & 255;
		}
		return bytes;
	}
	return null;
};
var lime__$internal_format_LZMA = function() { };
$hxClasses["lime._internal.format.LZMA"] = lime__$internal_format_LZMA;
lime__$internal_format_LZMA.__name__ = "lime._internal.format.LZMA";
lime__$internal_format_LZMA.compress = function(bytes) {
	return null;
};
lime__$internal_format_LZMA.decompress = function(bytes) {
	return null;
};
var lime__$internal_format_PNG = function() { };
$hxClasses["lime._internal.format.PNG"] = lime__$internal_format_PNG;
lime__$internal_format_PNG.__name__ = "lime._internal.format.PNG";
lime__$internal_format_PNG.decodeBytes = function(bytes,decodeData) {
	if(decodeData == null) {
		decodeData = true;
	}
	return null;
};
lime__$internal_format_PNG.decodeFile = function(path,decodeData) {
	if(decodeData == null) {
		decodeData = true;
	}
	return null;
};
lime__$internal_format_PNG.encode = function(image) {
	if(image.get_premultiplied() || image.get_format() != 0) {
		image = image.clone();
		image.set_premultiplied(false);
		image.set_format(0);
	}
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,false);
	if(image.buffer.__srcCanvas != null) {
		var data = image.buffer.__srcCanvas.toDataURL("image/png");
		var buffer = window.atob(data.split(";base64,")[1]);
		var bytes = new haxe_io_Bytes(new ArrayBuffer(buffer.length));
		var _g = 0;
		var _g1 = buffer.length;
		while(_g < _g1) {
			var i = _g++;
			bytes.b[i] = HxOverrides.cca(buffer,i) & 255;
		}
		return bytes;
	}
	return null;
};
var lime__$internal_format_Zlib = function() { };
$hxClasses["lime._internal.format.Zlib"] = lime__$internal_format_Zlib;
lime__$internal_format_Zlib.__name__ = "lime._internal.format.Zlib";
lime__$internal_format_Zlib.compress = function(bytes) {
	var data = pako.deflate(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
lime__$internal_format_Zlib.decompress = function(bytes) {
	var data = pako.inflate(bytes.b.bufferValue);
	return haxe_io_Bytes.ofData(data);
};
var lime__$internal_graphics_ImageCanvasUtil = function() { };
$hxClasses["lime._internal.graphics.ImageCanvasUtil"] = lime__$internal_graphics_ImageCanvasUtil;
lime__$internal_graphics_ImageCanvasUtil.__name__ = "lime._internal.graphics.ImageCanvasUtil";
lime__$internal_graphics_ImageCanvasUtil.colorTransform = function(image,rect,colorMatrix) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.colorTransform(image,rect,colorMatrix);
};
lime__$internal_graphics_ImageCanvasUtil.convertToCanvas = function(image,clear) {
	if(clear == null) {
		clear = false;
	}
	var buffer = image.buffer;
	if(buffer.__srcImage != null) {
		if(buffer.__srcCanvas == null) {
			lime__$internal_graphics_ImageCanvasUtil.createCanvas(image,buffer.__srcImage.width,buffer.__srcImage.height);
			buffer.__srcContext.drawImage(buffer.__srcImage,0,0);
		}
		buffer.__srcImage = null;
	} else if(buffer.__srcCanvas == null && buffer.data != null) {
		image.set_transparent(true);
		lime__$internal_graphics_ImageCanvasUtil.createCanvas(image,buffer.width,buffer.height);
		lime__$internal_graphics_ImageCanvasUtil.createImageData(image);
		buffer.__srcContext.putImageData(buffer.__srcImageData,0,0);
	} else if(image.type == lime_graphics_ImageType.DATA && buffer.__srcImageData != null && image.dirty) {
		buffer.__srcContext.putImageData(buffer.__srcImageData,0,0);
		image.dirty = false;
	}
	if(clear) {
		buffer.data = null;
		buffer.__srcImageData = null;
	} else if(buffer.data == null && buffer.__srcImageData != null) {
		buffer.data = buffer.__srcImageData.data;
	}
	image.type = lime_graphics_ImageType.CANVAS;
};
lime__$internal_graphics_ImageCanvasUtil.convertToData = function(image,clear) {
	if(clear == null) {
		clear = false;
	}
	var buffer = image.buffer;
	if(buffer.__srcImage != null) {
		lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image);
	}
	if(buffer.__srcCanvas != null && buffer.data == null) {
		lime__$internal_graphics_ImageCanvasUtil.createImageData(image);
		if(image.type == lime_graphics_ImageType.CANVAS) {
			image.dirty = false;
		}
	} else if(image.type == lime_graphics_ImageType.CANVAS && buffer.__srcCanvas != null && image.dirty) {
		if(buffer.__srcImageData == null) {
			lime__$internal_graphics_ImageCanvasUtil.createImageData(image);
		} else {
			buffer.__srcImageData = buffer.__srcContext.getImageData(0,0,buffer.width,buffer.height);
			var elements = buffer.__srcImageData.data.buffer;
			var array = null;
			var vector = null;
			var view = null;
			var buffer1 = null;
			var len = null;
			var this1;
			if(elements != null) {
				this1 = new Uint8Array(elements);
			} else if(array != null) {
				this1 = new Uint8Array(array);
			} else if(vector != null) {
				this1 = new Uint8Array(vector.__array);
			} else if(view != null) {
				this1 = new Uint8Array(view);
			} else if(buffer1 != null) {
				if(len == null) {
					this1 = new Uint8Array(buffer1,0);
				} else {
					this1 = new Uint8Array(buffer1,0,len);
				}
			} else {
				this1 = null;
			}
			buffer.data = this1;
		}
		image.dirty = false;
	}
	if(clear) {
		image.buffer.__srcCanvas = null;
		image.buffer.__srcContext = null;
	}
	image.type = lime_graphics_ImageType.DATA;
};
lime__$internal_graphics_ImageCanvasUtil.copyChannel = function(image,sourceImage,sourceRect,destPoint,sourceChannel,destChannel) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.copyChannel(image,sourceImage,sourceRect,destPoint,sourceChannel,destChannel);
};
lime__$internal_graphics_ImageCanvasUtil.copyPixels = function(image,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha) {
	if(mergeAlpha == null) {
		mergeAlpha = false;
	}
	if(destPoint == null || destPoint.x >= image.width || destPoint.y >= image.height || sourceRect == null || sourceRect.width < 1 || sourceRect.height < 1) {
		return;
	}
	if(alphaImage != null && alphaImage.get_transparent()) {
		if(alphaPoint == null) {
			alphaPoint = new lime_math_Vector2();
		}
		var tempData = sourceImage.clone();
		tempData.copyChannel(alphaImage,new lime_math_Rectangle(sourceRect.x + alphaPoint.x,sourceRect.y + alphaPoint.y,sourceRect.width,sourceRect.height),new lime_math_Vector2(sourceRect.x,sourceRect.y),lime_graphics_ImageChannel.ALPHA,lime_graphics_ImageChannel.ALPHA);
		sourceImage = tempData;
	}
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,true);
	if(!mergeAlpha) {
		if(image.get_transparent() && sourceImage.get_transparent()) {
			image.buffer.__srcContext.clearRect(destPoint.x + image.offsetX,destPoint.y + image.offsetY,sourceRect.width + image.offsetX,sourceRect.height + image.offsetY);
		}
	}
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(sourceImage);
	if(sourceImage.buffer.get_src() != null) {
		image.buffer.__srcContext.globalCompositeOperation = "source-over";
		image.buffer.__srcContext.drawImage(sourceImage.buffer.get_src(),sourceRect.x + sourceImage.offsetX | 0,sourceRect.y + sourceImage.offsetY | 0,sourceRect.width | 0,sourceRect.height | 0,destPoint.x + image.offsetX | 0,destPoint.y + image.offsetY | 0,sourceRect.width | 0,sourceRect.height | 0);
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageCanvasUtil.createCanvas = function(image,width,height) {
	var buffer = image.buffer;
	if(buffer.__srcCanvas == null) {
		buffer.__srcCanvas = window.document.createElement("canvas");
		buffer.__srcCanvas.width = width;
		buffer.__srcCanvas.height = height;
		if(!image.get_transparent()) {
			if(!image.get_transparent()) {
				buffer.__srcCanvas.setAttribute("moz-opaque","true");
			}
			buffer.__srcContext = buffer.__srcCanvas.getContext ("2d", { alpha: false });
		} else {
			buffer.__srcContext = buffer.__srcCanvas.getContext("2d");
		}
	}
};
lime__$internal_graphics_ImageCanvasUtil.createImageData = function(image) {
	var buffer = image.buffer;
	if(buffer.__srcImageData == null) {
		if(buffer.data == null) {
			buffer.__srcImageData = buffer.__srcContext.getImageData(0,0,buffer.width,buffer.height);
		} else {
			buffer.__srcImageData = buffer.__srcContext.createImageData(buffer.width,buffer.height);
			buffer.__srcImageData.data.set(buffer.data);
		}
		var elements = buffer.__srcImageData.data.buffer;
		var array = null;
		var vector = null;
		var view = null;
		var buffer1 = null;
		var len = null;
		var this1;
		if(elements != null) {
			this1 = new Uint8Array(elements);
		} else if(array != null) {
			this1 = new Uint8Array(array);
		} else if(vector != null) {
			this1 = new Uint8Array(vector.__array);
		} else if(view != null) {
			this1 = new Uint8Array(view);
		} else if(buffer1 != null) {
			if(len == null) {
				this1 = new Uint8Array(buffer1,0);
			} else {
				this1 = new Uint8Array(buffer1,0,len);
			}
		} else {
			this1 = null;
		}
		buffer.data = this1;
	}
};
lime__$internal_graphics_ImageCanvasUtil.fillRect = function(image,rect,color,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image);
	var r;
	var g;
	var b;
	var a;
	if(format == 1) {
		r = color >> 16 & 255;
		g = color >> 8 & 255;
		b = color & 255;
		a = image.get_transparent() ? color >> 24 & 255 : 255;
	} else {
		r = color >> 24 & 255;
		g = color >> 16 & 255;
		b = color >> 8 & 255;
		a = image.get_transparent() ? color & 255 : 255;
	}
	if(rect.x == 0 && rect.y == 0 && rect.width == image.width && rect.height == image.height) {
		if(image.get_transparent() && a == 0) {
			image.buffer.__srcCanvas.width = image.buffer.width;
			return;
		}
	}
	if(a < 255) {
		image.buffer.__srcContext.clearRect(rect.x + image.offsetX,rect.y + image.offsetY,rect.width + image.offsetX,rect.height + image.offsetY);
	}
	if(a > 0) {
		image.buffer.__srcContext.fillStyle = "rgba(" + r + ", " + g + ", " + b + ", " + a / 255 + ")";
		image.buffer.__srcContext.fillRect(rect.x + image.offsetX,rect.y + image.offsetY,rect.width + image.offsetX,rect.height + image.offsetY);
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageCanvasUtil.floodFill = function(image,x,y,color,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.floodFill(image,x,y,color,format);
};
lime__$internal_graphics_ImageCanvasUtil.getPixel = function(image,x,y,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	return lime__$internal_graphics_ImageDataUtil.getPixel(image,x,y,format);
};
lime__$internal_graphics_ImageCanvasUtil.getPixel32 = function(image,x,y,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	return lime__$internal_graphics_ImageDataUtil.getPixel32(image,x,y,format);
};
lime__$internal_graphics_ImageCanvasUtil.getPixels = function(image,rect,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	return lime__$internal_graphics_ImageDataUtil.getPixels(image,rect,format);
};
lime__$internal_graphics_ImageCanvasUtil.merge = function(image,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.merge(image,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
};
lime__$internal_graphics_ImageCanvasUtil.resize = function(image,newWidth,newHeight) {
	var buffer = image.buffer;
	if(buffer.__srcCanvas == null) {
		lime__$internal_graphics_ImageCanvasUtil.createCanvas(image,newWidth,newHeight);
		buffer.__srcContext.drawImage(buffer.get_src(),0,0,newWidth,newHeight);
	} else {
		lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,true);
		var sourceCanvas = buffer.__srcCanvas;
		buffer.__srcCanvas = null;
		lime__$internal_graphics_ImageCanvasUtil.createCanvas(image,newWidth,newHeight);
		buffer.__srcContext.drawImage(sourceCanvas,0,0,newWidth,newHeight);
	}
	buffer.__srcImageData = null;
	buffer.data = null;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageCanvasUtil.scroll = function(image,x,y) {
	if(x % image.width == 0 && y % image.height == 0) {
		return;
	}
	var copy = image.clone();
	lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,true);
	image.buffer.__srcContext.clearRect(x,y,image.width,image.height);
	image.buffer.__srcContext.drawImage(copy.get_src(),x,y);
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageCanvasUtil.setPixel = function(image,x,y,color,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.setPixel(image,x,y,color,format);
};
lime__$internal_graphics_ImageCanvasUtil.setPixel32 = function(image,x,y,color,format) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.setPixel32(image,x,y,color,format);
};
lime__$internal_graphics_ImageCanvasUtil.setPixels = function(image,rect,bytePointer,format,endian) {
	lime__$internal_graphics_ImageCanvasUtil.convertToData(image);
	lime__$internal_graphics_ImageDataUtil.setPixels(image,rect,bytePointer,format,endian);
};
lime__$internal_graphics_ImageCanvasUtil.sync = function(image,clear) {
	if(image == null) {
		return;
	}
	if(image.type == lime_graphics_ImageType.CANVAS && (image.buffer.__srcCanvas != null || image.buffer.data != null)) {
		lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(image,clear);
	} else if(image.type == lime_graphics_ImageType.DATA) {
		lime__$internal_graphics_ImageCanvasUtil.convertToData(image,clear);
	}
};
var lime__$internal_graphics_ImageDataUtil = function() { };
$hxClasses["lime._internal.graphics.ImageDataUtil"] = lime__$internal_graphics_ImageDataUtil;
lime__$internal_graphics_ImageDataUtil.__name__ = "lime._internal.graphics.ImageDataUtil";
lime__$internal_graphics_ImageDataUtil.displaceMap = function(target,source,map,mapPoint,componentX,componentY,smooth) {
	var targetData = target.buffer.data;
	var sourceData = source.buffer.data;
	var mapData = map.buffer.data;
	var targetFormat = target.buffer.format;
	var sourceFormat = source.buffer.format;
	var mapFormat = map.buffer.format;
	var targetPremultiplied = target.get_premultiplied();
	var sourcePremultiplied = source.get_premultiplied();
	var mapPremultiplied = map.get_premultiplied();
	var sourceView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(source);
	var mapView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(map);
	var row;
	var sourceOffset;
	var sourcePixel = 0;
	var mapPixel = 0;
	var targetPixel = 0;
	var mapPixelX;
	var mapPixelY;
	var mapPixelA;
	var s1 = 0;
	var s2 = 0;
	var s3 = 0;
	var s4 = 0;
	var mPointXFloor;
	var mPointYFloor;
	var disOffsetXFloor;
	var disOffsetYFloor;
	var disX;
	var disY;
	var _g = 0;
	var _g1 = sourceView.height;
	while(_g < _g1) {
		var y = _g++;
		row = sourceView.byteOffset + sourceView.stride * y;
		var _g2 = 0;
		var _g3 = sourceView.width;
		while(_g2 < _g3) {
			var x = _g2++;
			sourceOffset = row + x * 4;
			mPointXFloor = mapPoint.x | 0;
			mPointYFloor = mapPoint.y | 0;
			if(smooth) {
				var offset = sourceView.byteOffset + sourceView.stride * (y - mPointYFloor + 1) + (x - mPointXFloor) * 4;
				var format = mapFormat;
				var premultiplied = mapPremultiplied;
				if(premultiplied == null) {
					premultiplied = false;
				}
				if(format == null) {
					format = 0;
				}
				switch(format) {
				case 0:
					s1 = (mapData[offset] & 255) << 24 | (mapData[offset + 1] & 255) << 16 | (mapData[offset + 2] & 255) << 8 | mapData[offset + 3] & 255;
					break;
				case 1:
					s1 = (mapData[offset + 1] & 255) << 24 | (mapData[offset + 2] & 255) << 16 | (mapData[offset + 3] & 255) << 8 | mapData[offset] & 255;
					break;
				case 2:
					s1 = (mapData[offset + 2] & 255) << 24 | (mapData[offset + 1] & 255) << 16 | (mapData[offset] & 255) << 8 | mapData[offset + 3] & 255;
					break;
				}
				if(premultiplied) {
					if((s1 & 255) != 0 && (s1 & 255) != 255) {
						lime_math_RGBA.unmult = 255.0 / (s1 & 255);
						s1 = (lime_math_RGBA.__clamp[Math.round((s1 >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((s1 >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((s1 >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | s1 & 255 & 255;
					}
				}
				var offset1 = sourceView.byteOffset + sourceView.stride * (y - mPointYFloor) + (x - mPointXFloor + 1) * 4;
				var format1 = mapFormat;
				var premultiplied1 = mapPremultiplied;
				if(premultiplied1 == null) {
					premultiplied1 = false;
				}
				if(format1 == null) {
					format1 = 0;
				}
				switch(format1) {
				case 0:
					s2 = (mapData[offset1] & 255) << 24 | (mapData[offset1 + 1] & 255) << 16 | (mapData[offset1 + 2] & 255) << 8 | mapData[offset1 + 3] & 255;
					break;
				case 1:
					s2 = (mapData[offset1 + 1] & 255) << 24 | (mapData[offset1 + 2] & 255) << 16 | (mapData[offset1 + 3] & 255) << 8 | mapData[offset1] & 255;
					break;
				case 2:
					s2 = (mapData[offset1 + 2] & 255) << 24 | (mapData[offset1 + 1] & 255) << 16 | (mapData[offset1] & 255) << 8 | mapData[offset1 + 3] & 255;
					break;
				}
				if(premultiplied1) {
					if((s2 & 255) != 0 && (s2 & 255) != 255) {
						lime_math_RGBA.unmult = 255.0 / (s2 & 255);
						s2 = (lime_math_RGBA.__clamp[Math.round((s2 >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((s2 >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((s2 >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | s2 & 255 & 255;
					}
				}
				var offset2 = sourceView.byteOffset + sourceView.stride * (y - mPointYFloor + 1) + (x - mPointXFloor + 1) * 4;
				var format2 = mapFormat;
				var premultiplied2 = mapPremultiplied;
				if(premultiplied2 == null) {
					premultiplied2 = false;
				}
				if(format2 == null) {
					format2 = 0;
				}
				switch(format2) {
				case 0:
					s3 = (mapData[offset2] & 255) << 24 | (mapData[offset2 + 1] & 255) << 16 | (mapData[offset2 + 2] & 255) << 8 | mapData[offset2 + 3] & 255;
					break;
				case 1:
					s3 = (mapData[offset2 + 1] & 255) << 24 | (mapData[offset2 + 2] & 255) << 16 | (mapData[offset2 + 3] & 255) << 8 | mapData[offset2] & 255;
					break;
				case 2:
					s3 = (mapData[offset2 + 2] & 255) << 24 | (mapData[offset2 + 1] & 255) << 16 | (mapData[offset2] & 255) << 8 | mapData[offset2 + 3] & 255;
					break;
				}
				if(premultiplied2) {
					if((s3 & 255) != 0 && (s3 & 255) != 255) {
						lime_math_RGBA.unmult = 255.0 / (s3 & 255);
						s3 = (lime_math_RGBA.__clamp[Math.round((s3 >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((s3 >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((s3 >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | s3 & 255 & 255;
					}
				}
				var offset3 = sourceView.byteOffset + sourceView.stride * (y - mPointYFloor) + (x - mPointXFloor) * 4;
				var format3 = mapFormat;
				var premultiplied3 = mapPremultiplied;
				if(premultiplied3 == null) {
					premultiplied3 = false;
				}
				if(format3 == null) {
					format3 = 0;
				}
				switch(format3) {
				case 0:
					s4 = (mapData[offset3] & 255) << 24 | (mapData[offset3 + 1] & 255) << 16 | (mapData[offset3 + 2] & 255) << 8 | mapData[offset3 + 3] & 255;
					break;
				case 1:
					s4 = (mapData[offset3 + 1] & 255) << 24 | (mapData[offset3 + 2] & 255) << 16 | (mapData[offset3 + 3] & 255) << 8 | mapData[offset3] & 255;
					break;
				case 2:
					s4 = (mapData[offset3 + 2] & 255) << 24 | (mapData[offset3 + 1] & 255) << 16 | (mapData[offset3] & 255) << 8 | mapData[offset3 + 3] & 255;
					break;
				}
				if(premultiplied3) {
					if((s4 & 255) != 0 && (s4 & 255) != 255) {
						lime_math_RGBA.unmult = 255.0 / (s4 & 255);
						s4 = (lime_math_RGBA.__clamp[Math.round((s4 >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((s4 >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((s4 >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | s4 & 255 & 255;
					}
				}
				mapPixel = lime__$internal_graphics_ImageDataUtil.bilinear(s1,s2,s3,s4,mapPoint.x - mPointXFloor,mapPoint.y - mPointYFloor);
			} else {
				var offset4 = mapView.byteOffset + mapView.stride * (y - mPointYFloor) + (x - mPointXFloor) * 4;
				var format4 = mapFormat;
				var premultiplied4 = mapPremultiplied;
				if(premultiplied4 == null) {
					premultiplied4 = false;
				}
				if(format4 == null) {
					format4 = 0;
				}
				switch(format4) {
				case 0:
					mapPixel = (mapData[offset4] & 255) << 24 | (mapData[offset4 + 1] & 255) << 16 | (mapData[offset4 + 2] & 255) << 8 | mapData[offset4 + 3] & 255;
					break;
				case 1:
					mapPixel = (mapData[offset4 + 1] & 255) << 24 | (mapData[offset4 + 2] & 255) << 16 | (mapData[offset4 + 3] & 255) << 8 | mapData[offset4] & 255;
					break;
				case 2:
					mapPixel = (mapData[offset4 + 2] & 255) << 24 | (mapData[offset4 + 1] & 255) << 16 | (mapData[offset4] & 255) << 8 | mapData[offset4 + 3] & 255;
					break;
				}
				if(premultiplied4) {
					if((mapPixel & 255) != 0 && (mapPixel & 255) != 255) {
						lime_math_RGBA.unmult = 255.0 / (mapPixel & 255);
						mapPixel = (lime_math_RGBA.__clamp[Math.round((mapPixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((mapPixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((mapPixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | mapPixel & 255 & 255;
					}
				}
			}
			mapPixelA = (mapPixel & 255) / 255.0;
			mapPixelX = ((mapPixel >>> 24 & 255) - 128) / 255.0 * mapPixelA;
			mapPixelY = ((mapPixel >>> 16 & 255) - 128) / 255.0 * mapPixelA;
			disX = mapPixelX * componentX.x + mapPixelY * componentY.x;
			disY = mapPixelX * componentX.y + mapPixelY * componentY.y;
			disOffsetXFloor = Math.floor(disX * sourceView.width);
			disOffsetYFloor = Math.floor(disY * sourceView.height);
			if(smooth) {
				var offset5 = sourceView.byteOffset + sourceView.stride * (y + disOffsetYFloor + 1) + (x + disOffsetXFloor) * 4;
				var format5 = sourceFormat;
				var premultiplied5 = sourcePremultiplied;
				if(premultiplied5 == null) {
					premultiplied5 = false;
				}
				if(format5 == null) {
					format5 = 0;
				}
				switch(format5) {
				case 0:
					s1 = (sourceData[offset5] & 255) << 24 | (sourceData[offset5 + 1] & 255) << 16 | (sourceData[offset5 + 2] & 255) << 8 | sourceData[offset5 + 3] & 255;
					break;
				case 1:
					s1 = (sourceData[offset5 + 1] & 255) << 24 | (sourceData[offset5 + 2] & 255) << 16 | (sourceData[offset5 + 3] & 255) << 8 | sourceData[offset5] & 255;
					break;
				case 2:
					s1 = (sourceData[offset5 + 2] & 255) << 24 | (sourceData[offset5 + 1] & 255) << 16 | (sourceData[offset5] & 255) << 8 | sourceData[offset5 + 3] & 255;
					break;
				}
				if(premultiplied5) {
					if((s1 & 255) != 0 && (s1 & 255) != 255) {
						lime_math_RGBA.unmult = 255.0 / (s1 & 255);
						s1 = (lime_math_RGBA.__clamp[Math.round((s1 >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((s1 >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((s1 >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | s1 & 255 & 255;
					}
				}
				var offset6 = sourceView.byteOffset + sourceView.stride * (y + disOffsetYFloor) + (x + disOffsetXFloor + 1) * 4;
				var format6 = sourceFormat;
				var premultiplied6 = sourcePremultiplied;
				if(premultiplied6 == null) {
					premultiplied6 = false;
				}
				if(format6 == null) {
					format6 = 0;
				}
				switch(format6) {
				case 0:
					s2 = (sourceData[offset6] & 255) << 24 | (sourceData[offset6 + 1] & 255) << 16 | (sourceData[offset6 + 2] & 255) << 8 | sourceData[offset6 + 3] & 255;
					break;
				case 1:
					s2 = (sourceData[offset6 + 1] & 255) << 24 | (sourceData[offset6 + 2] & 255) << 16 | (sourceData[offset6 + 3] & 255) << 8 | sourceData[offset6] & 255;
					break;
				case 2:
					s2 = (sourceData[offset6 + 2] & 255) << 24 | (sourceData[offset6 + 1] & 255) << 16 | (sourceData[offset6] & 255) << 8 | sourceData[offset6 + 3] & 255;
					break;
				}
				if(premultiplied6) {
					if((s2 & 255) != 0 && (s2 & 255) != 255) {
						lime_math_RGBA.unmult = 255.0 / (s2 & 255);
						s2 = (lime_math_RGBA.__clamp[Math.round((s2 >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((s2 >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((s2 >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | s2 & 255 & 255;
					}
				}
				var offset7 = sourceView.byteOffset + sourceView.stride * (y + disOffsetYFloor + 1) + (x + disOffsetXFloor + 1) * 4;
				var format7 = sourceFormat;
				var premultiplied7 = sourcePremultiplied;
				if(premultiplied7 == null) {
					premultiplied7 = false;
				}
				if(format7 == null) {
					format7 = 0;
				}
				switch(format7) {
				case 0:
					s3 = (sourceData[offset7] & 255) << 24 | (sourceData[offset7 + 1] & 255) << 16 | (sourceData[offset7 + 2] & 255) << 8 | sourceData[offset7 + 3] & 255;
					break;
				case 1:
					s3 = (sourceData[offset7 + 1] & 255) << 24 | (sourceData[offset7 + 2] & 255) << 16 | (sourceData[offset7 + 3] & 255) << 8 | sourceData[offset7] & 255;
					break;
				case 2:
					s3 = (sourceData[offset7 + 2] & 255) << 24 | (sourceData[offset7 + 1] & 255) << 16 | (sourceData[offset7] & 255) << 8 | sourceData[offset7 + 3] & 255;
					break;
				}
				if(premultiplied7) {
					if((s3 & 255) != 0 && (s3 & 255) != 255) {
						lime_math_RGBA.unmult = 255.0 / (s3 & 255);
						s3 = (lime_math_RGBA.__clamp[Math.round((s3 >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((s3 >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((s3 >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | s3 & 255 & 255;
					}
				}
				var offset8 = sourceView.byteOffset + sourceView.stride * (y + disOffsetYFloor) + (x + disOffsetXFloor) * 4;
				var format8 = sourceFormat;
				var premultiplied8 = sourcePremultiplied;
				if(premultiplied8 == null) {
					premultiplied8 = false;
				}
				if(format8 == null) {
					format8 = 0;
				}
				switch(format8) {
				case 0:
					s4 = (sourceData[offset8] & 255) << 24 | (sourceData[offset8 + 1] & 255) << 16 | (sourceData[offset8 + 2] & 255) << 8 | sourceData[offset8 + 3] & 255;
					break;
				case 1:
					s4 = (sourceData[offset8 + 1] & 255) << 24 | (sourceData[offset8 + 2] & 255) << 16 | (sourceData[offset8 + 3] & 255) << 8 | sourceData[offset8] & 255;
					break;
				case 2:
					s4 = (sourceData[offset8 + 2] & 255) << 24 | (sourceData[offset8 + 1] & 255) << 16 | (sourceData[offset8] & 255) << 8 | sourceData[offset8 + 3] & 255;
					break;
				}
				if(premultiplied8) {
					if((s4 & 255) != 0 && (s4 & 255) != 255) {
						lime_math_RGBA.unmult = 255.0 / (s4 & 255);
						s4 = (lime_math_RGBA.__clamp[Math.round((s4 >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((s4 >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((s4 >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | s4 & 255 & 255;
					}
				}
				sourcePixel = lime__$internal_graphics_ImageDataUtil.bilinear(s1,s2,s3,s4,disX * sourceView.width - disOffsetXFloor,disY * sourceView.height - disOffsetYFloor);
			} else {
				var offset9 = sourceView.byteOffset + sourceView.stride * (y + disOffsetYFloor) + (x + disOffsetXFloor) * 4;
				var format9 = sourceFormat;
				var premultiplied9 = sourcePremultiplied;
				if(premultiplied9 == null) {
					premultiplied9 = false;
				}
				if(format9 == null) {
					format9 = 0;
				}
				switch(format9) {
				case 0:
					sourcePixel = (sourceData[offset9] & 255) << 24 | (sourceData[offset9 + 1] & 255) << 16 | (sourceData[offset9 + 2] & 255) << 8 | sourceData[offset9 + 3] & 255;
					break;
				case 1:
					sourcePixel = (sourceData[offset9 + 1] & 255) << 24 | (sourceData[offset9 + 2] & 255) << 16 | (sourceData[offset9 + 3] & 255) << 8 | sourceData[offset9] & 255;
					break;
				case 2:
					sourcePixel = (sourceData[offset9 + 2] & 255) << 24 | (sourceData[offset9 + 1] & 255) << 16 | (sourceData[offset9] & 255) << 8 | sourceData[offset9 + 3] & 255;
					break;
				}
				if(premultiplied9) {
					if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
						lime_math_RGBA.unmult = 255.0 / (sourcePixel & 255);
						sourcePixel = (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
					}
				}
			}
			var format10 = targetFormat;
			var premultiplied10 = targetPremultiplied;
			if(premultiplied10 == null) {
				premultiplied10 = false;
			}
			if(format10 == null) {
				format10 = 0;
			}
			if(premultiplied10) {
				if((sourcePixel & 255) == 0) {
					if(sourcePixel != 0) {
						sourcePixel = 0;
					}
				} else if((sourcePixel & 255) != 255) {
					lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[sourcePixel & 255];
					sourcePixel = ((sourcePixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((sourcePixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((sourcePixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | sourcePixel & 255 & 255;
				}
			}
			switch(format10) {
			case 0:
				targetData[sourceOffset] = sourcePixel >>> 24 & 255;
				targetData[sourceOffset + 1] = sourcePixel >>> 16 & 255;
				targetData[sourceOffset + 2] = sourcePixel >>> 8 & 255;
				targetData[sourceOffset + 3] = sourcePixel & 255;
				break;
			case 1:
				targetData[sourceOffset] = sourcePixel & 255;
				targetData[sourceOffset + 1] = sourcePixel >>> 24 & 255;
				targetData[sourceOffset + 2] = sourcePixel >>> 16 & 255;
				targetData[sourceOffset + 3] = sourcePixel >>> 8 & 255;
				break;
			case 2:
				targetData[sourceOffset] = sourcePixel >>> 8 & 255;
				targetData[sourceOffset + 1] = sourcePixel >>> 16 & 255;
				targetData[sourceOffset + 2] = sourcePixel >>> 24 & 255;
				targetData[sourceOffset + 3] = sourcePixel & 255;
				break;
			}
		}
	}
	target.dirty = true;
	target.version++;
};
lime__$internal_graphics_ImageDataUtil.bilinear = function(s1,s2,s3,s4,su,sv) {
	return lime__$internal_graphics_ImageDataUtil.lerpRGBA(lime__$internal_graphics_ImageDataUtil.lerpRGBA(s4,s2,su),lime__$internal_graphics_ImageDataUtil.lerpRGBA(s1,s3,su),sv);
};
lime__$internal_graphics_ImageDataUtil.lerpRGBA = function(v0,v1,x) {
	var result = 0;
	var value = Math.floor(lime__$internal_graphics_ImageDataUtil.lerp(v0 >>> 24 & 255,v1 >>> 24 & 255,x));
	result = (value & 255) << 24 | (result >>> 16 & 255 & 255) << 16 | (result >>> 8 & 255 & 255) << 8 | result & 255 & 255;
	var value = Math.floor(lime__$internal_graphics_ImageDataUtil.lerp(v0 >>> 16 & 255,v1 >>> 16 & 255,x));
	result = (result >>> 24 & 255 & 255) << 24 | (value & 255) << 16 | (result >>> 8 & 255 & 255) << 8 | result & 255 & 255;
	var value = Math.floor(lime__$internal_graphics_ImageDataUtil.lerp(v0 >>> 8 & 255,v1 >>> 8 & 255,x));
	result = (result >>> 24 & 255 & 255) << 24 | (result >>> 16 & 255 & 255) << 16 | (value & 255) << 8 | result & 255 & 255;
	var value = Math.floor(lime__$internal_graphics_ImageDataUtil.lerp(v0 & 255,v1 & 255,x));
	result = (result >>> 24 & 255 & 255) << 24 | (result >>> 16 & 255 & 255) << 16 | (result >>> 8 & 255 & 255) << 8 | value & 255;
	return result;
};
lime__$internal_graphics_ImageDataUtil.lerp4f = function(v0,v1,x) {
	return new lime_math_Vector4(lime__$internal_graphics_ImageDataUtil.lerp(v0.x,v1.x,x),lime__$internal_graphics_ImageDataUtil.lerp(v0.y,v1.y,x),lime__$internal_graphics_ImageDataUtil.lerp(v0.z,v1.z,x),lime__$internal_graphics_ImageDataUtil.lerp(v0.w,v1.w,x));
};
lime__$internal_graphics_ImageDataUtil.lerp = function(v0,v1,x) {
	return (1.0 - x) * v0 + x * v1;
};
lime__$internal_graphics_ImageDataUtil.colorTransform = function(image,rect,colorMatrix) {
	var data = image.buffer.data;
	if(data == null) {
		return;
	}
	var format = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	var dataView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,rect);
	var alphaTable = lime_math_ColorMatrix.getAlphaTable(colorMatrix);
	var redTable = lime_math_ColorMatrix.getRedTable(colorMatrix);
	var greenTable = lime_math_ColorMatrix.getGreenTable(colorMatrix);
	var blueTable = lime_math_ColorMatrix.getBlueTable(colorMatrix);
	var row;
	var offset;
	var pixel = 0;
	var _g = 0;
	var _g1 = dataView.height;
	while(_g < _g1) {
		var y = _g++;
		row = dataView.byteOffset + dataView.stride * y;
		var _g2 = 0;
		var _g3 = dataView.width;
		while(_g2 < _g3) {
			var x = _g2++;
			offset = row + x * 4;
			var format1 = format;
			var premultiplied1 = premultiplied;
			if(premultiplied1 == null) {
				premultiplied1 = false;
			}
			if(format1 == null) {
				format1 = 0;
			}
			switch(format1) {
			case 0:
				pixel = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
				break;
			case 1:
				pixel = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
				break;
			case 2:
				pixel = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
				break;
			}
			if(premultiplied1) {
				if((pixel & 255) != 0 && (pixel & 255) != 255) {
					lime_math_RGBA.unmult = 255.0 / (pixel & 255);
					pixel = (lime_math_RGBA.__clamp[Math.round((pixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | pixel & 255 & 255;
				}
			}
			pixel = (redTable[pixel >>> 24 & 255] & 255) << 24 | (greenTable[pixel >>> 16 & 255] & 255) << 16 | (blueTable[pixel >>> 8 & 255] & 255) << 8 | alphaTable[pixel & 255] & 255;
			var format2 = format;
			var premultiplied2 = premultiplied;
			if(premultiplied2 == null) {
				premultiplied2 = false;
			}
			if(format2 == null) {
				format2 = 0;
			}
			if(premultiplied2) {
				if((pixel & 255) == 0) {
					if(pixel != 0) {
						pixel = 0;
					}
				} else if((pixel & 255) != 255) {
					lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[pixel & 255];
					pixel = ((pixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((pixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((pixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | pixel & 255 & 255;
				}
			}
			switch(format2) {
			case 0:
				data[offset] = pixel >>> 24 & 255;
				data[offset + 1] = pixel >>> 16 & 255;
				data[offset + 2] = pixel >>> 8 & 255;
				data[offset + 3] = pixel & 255;
				break;
			case 1:
				data[offset] = pixel & 255;
				data[offset + 1] = pixel >>> 24 & 255;
				data[offset + 2] = pixel >>> 16 & 255;
				data[offset + 3] = pixel >>> 8 & 255;
				break;
			case 2:
				data[offset] = pixel >>> 8 & 255;
				data[offset + 1] = pixel >>> 16 & 255;
				data[offset + 2] = pixel >>> 24 & 255;
				data[offset + 3] = pixel & 255;
				break;
			}
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.copyChannel = function(image,sourceImage,sourceRect,destPoint,sourceChannel,destChannel) {
	var destIdx;
	switch(destChannel._hx_index) {
	case 0:
		destIdx = 0;
		break;
	case 1:
		destIdx = 1;
		break;
	case 2:
		destIdx = 2;
		break;
	case 3:
		destIdx = 3;
		break;
	}
	var srcIdx;
	switch(sourceChannel._hx_index) {
	case 0:
		srcIdx = 0;
		break;
	case 1:
		srcIdx = 1;
		break;
	case 2:
		srcIdx = 2;
		break;
	case 3:
		srcIdx = 3;
		break;
	}
	var srcData = sourceImage.buffer.data;
	var destData = image.buffer.data;
	if(srcData == null || destData == null) {
		return;
	}
	var srcView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(sourceImage,sourceRect);
	var destView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,new lime_math_Rectangle(destPoint.x,destPoint.y,srcView.width,srcView.height));
	var srcFormat = sourceImage.buffer.format;
	var destFormat = image.buffer.format;
	var srcPremultiplied = sourceImage.buffer.premultiplied;
	var destPremultiplied = image.buffer.premultiplied;
	var srcPosition;
	var destPosition;
	var srcPixel = 0;
	var destPixel = 0;
	var value = 0;
	var _g = 0;
	var _g1 = destView.height;
	while(_g < _g1) {
		var y = _g++;
		srcPosition = srcView.byteOffset + srcView.stride * y;
		destPosition = destView.byteOffset + destView.stride * y;
		var _g2 = 0;
		var _g3 = destView.width;
		while(_g2 < _g3) {
			var x = _g2++;
			var format = srcFormat;
			var premultiplied = srcPremultiplied;
			if(premultiplied == null) {
				premultiplied = false;
			}
			if(format == null) {
				format = 0;
			}
			switch(format) {
			case 0:
				srcPixel = (srcData[srcPosition] & 255) << 24 | (srcData[srcPosition + 1] & 255) << 16 | (srcData[srcPosition + 2] & 255) << 8 | srcData[srcPosition + 3] & 255;
				break;
			case 1:
				srcPixel = (srcData[srcPosition + 1] & 255) << 24 | (srcData[srcPosition + 2] & 255) << 16 | (srcData[srcPosition + 3] & 255) << 8 | srcData[srcPosition] & 255;
				break;
			case 2:
				srcPixel = (srcData[srcPosition + 2] & 255) << 24 | (srcData[srcPosition + 1] & 255) << 16 | (srcData[srcPosition] & 255) << 8 | srcData[srcPosition + 3] & 255;
				break;
			}
			if(premultiplied) {
				if((srcPixel & 255) != 0 && (srcPixel & 255) != 255) {
					lime_math_RGBA.unmult = 255.0 / (srcPixel & 255);
					srcPixel = (lime_math_RGBA.__clamp[Math.round((srcPixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((srcPixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((srcPixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | srcPixel & 255 & 255;
				}
			}
			var format1 = destFormat;
			var premultiplied1 = destPremultiplied;
			if(premultiplied1 == null) {
				premultiplied1 = false;
			}
			if(format1 == null) {
				format1 = 0;
			}
			switch(format1) {
			case 0:
				destPixel = (destData[destPosition] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition + 2] & 255) << 8 | destData[destPosition + 3] & 255;
				break;
			case 1:
				destPixel = (destData[destPosition + 1] & 255) << 24 | (destData[destPosition + 2] & 255) << 16 | (destData[destPosition + 3] & 255) << 8 | destData[destPosition] & 255;
				break;
			case 2:
				destPixel = (destData[destPosition + 2] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition] & 255) << 8 | destData[destPosition + 3] & 255;
				break;
			}
			if(premultiplied1) {
				if((destPixel & 255) != 0 && (destPixel & 255) != 255) {
					lime_math_RGBA.unmult = 255.0 / (destPixel & 255);
					destPixel = (lime_math_RGBA.__clamp[Math.round((destPixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((destPixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((destPixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | destPixel & 255 & 255;
				}
			}
			switch(srcIdx) {
			case 0:
				value = srcPixel >>> 24 & 255;
				break;
			case 1:
				value = srcPixel >>> 16 & 255;
				break;
			case 2:
				value = srcPixel >>> 8 & 255;
				break;
			case 3:
				value = srcPixel & 255;
				break;
			}
			switch(destIdx) {
			case 0:
				destPixel = (value & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
				break;
			case 1:
				destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (value & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
				break;
			case 2:
				destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (value & 255) << 8 | destPixel & 255 & 255;
				break;
			case 3:
				destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | value & 255;
				break;
			}
			var format2 = destFormat;
			var premultiplied2 = destPremultiplied;
			if(premultiplied2 == null) {
				premultiplied2 = false;
			}
			if(format2 == null) {
				format2 = 0;
			}
			if(premultiplied2) {
				if((destPixel & 255) == 0) {
					if(destPixel != 0) {
						destPixel = 0;
					}
				} else if((destPixel & 255) != 255) {
					lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[destPixel & 255];
					destPixel = ((destPixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((destPixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((destPixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | destPixel & 255 & 255;
				}
			}
			switch(format2) {
			case 0:
				destData[destPosition] = destPixel >>> 24 & 255;
				destData[destPosition + 1] = destPixel >>> 16 & 255;
				destData[destPosition + 2] = destPixel >>> 8 & 255;
				destData[destPosition + 3] = destPixel & 255;
				break;
			case 1:
				destData[destPosition] = destPixel & 255;
				destData[destPosition + 1] = destPixel >>> 24 & 255;
				destData[destPosition + 2] = destPixel >>> 16 & 255;
				destData[destPosition + 3] = destPixel >>> 8 & 255;
				break;
			case 2:
				destData[destPosition] = destPixel >>> 8 & 255;
				destData[destPosition + 1] = destPixel >>> 16 & 255;
				destData[destPosition + 2] = destPixel >>> 24 & 255;
				destData[destPosition + 3] = destPixel & 255;
				break;
			}
			srcPosition += 4;
			destPosition += 4;
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.copyPixels = function(image,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha) {
	if(mergeAlpha == null) {
		mergeAlpha = false;
	}
	if(image.width == sourceImage.width && image.height == sourceImage.height && sourceRect.width == sourceImage.width && sourceRect.height == sourceImage.height && sourceRect.x == 0 && sourceRect.y == 0 && destPoint.x == 0 && destPoint.y == 0 && alphaImage == null && alphaPoint == null && mergeAlpha == false && image.get_format() == sourceImage.get_format()) {
		image.buffer.data.set(sourceImage.buffer.data);
	} else {
		var sourceData = sourceImage.buffer.data;
		var destData = image.buffer.data;
		if(sourceData == null || destData == null) {
			return;
		}
		var sourceView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(sourceImage,sourceRect);
		var destRect = new lime_math_Rectangle(destPoint.x,destPoint.y,sourceView.width,sourceView.height);
		var destView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,destRect);
		var sourceFormat = sourceImage.buffer.format;
		var destFormat = image.buffer.format;
		var sourcePosition;
		var destPosition;
		var sourceAlpha;
		var destAlpha;
		var oneMinusSourceAlpha;
		var blendAlpha;
		var sourcePixel = 0;
		var destPixel = 0;
		var sourcePremultiplied = sourceImage.buffer.premultiplied;
		var destPremultiplied = image.buffer.premultiplied;
		var sourceBytesPerPixel = sourceImage.buffer.bitsPerPixel / 8 | 0;
		var destBytesPerPixel = image.buffer.bitsPerPixel / 8 | 0;
		var useAlphaImage = alphaImage != null && alphaImage.get_transparent();
		var blend = mergeAlpha || useAlphaImage && !image.get_transparent() || !mergeAlpha && !image.get_transparent() && sourceImage.get_transparent();
		if(!useAlphaImage) {
			if(blend) {
				var _g = 0;
				var _g1 = destView.height;
				while(_g < _g1) {
					var y = _g++;
					sourcePosition = sourceView.byteOffset + sourceView.stride * y;
					destPosition = destView.byteOffset + destView.stride * y;
					var _g2 = 0;
					var _g3 = destView.width;
					while(_g2 < _g3) {
						var x = _g2++;
						var format = sourceFormat;
						var premultiplied = sourcePremultiplied;
						if(premultiplied == null) {
							premultiplied = false;
						}
						if(format == null) {
							format = 0;
						}
						switch(format) {
						case 0:
							sourcePixel = (sourceData[sourcePosition] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition + 2] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						case 1:
							sourcePixel = (sourceData[sourcePosition + 1] & 255) << 24 | (sourceData[sourcePosition + 2] & 255) << 16 | (sourceData[sourcePosition + 3] & 255) << 8 | sourceData[sourcePosition] & 255;
							break;
						case 2:
							sourcePixel = (sourceData[sourcePosition + 2] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						}
						if(premultiplied) {
							if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
								lime_math_RGBA.unmult = 255.0 / (sourcePixel & 255);
								sourcePixel = (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						var format1 = destFormat;
						var premultiplied1 = destPremultiplied;
						if(premultiplied1 == null) {
							premultiplied1 = false;
						}
						if(format1 == null) {
							format1 = 0;
						}
						switch(format1) {
						case 0:
							destPixel = (destData[destPosition] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition + 2] & 255) << 8 | destData[destPosition + 3] & 255;
							break;
						case 1:
							destPixel = (destData[destPosition + 1] & 255) << 24 | (destData[destPosition + 2] & 255) << 16 | (destData[destPosition + 3] & 255) << 8 | destData[destPosition] & 255;
							break;
						case 2:
							destPixel = (destData[destPosition + 2] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition] & 255) << 8 | destData[destPosition + 3] & 255;
							break;
						}
						if(premultiplied1) {
							if((destPixel & 255) != 0 && (destPixel & 255) != 255) {
								lime_math_RGBA.unmult = 255.0 / (destPixel & 255);
								destPixel = (lime_math_RGBA.__clamp[Math.round((destPixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((destPixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((destPixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | destPixel & 255 & 255;
							}
						}
						sourceAlpha = (sourcePixel & 255) / 255.0;
						destAlpha = (destPixel & 255) / 255.0;
						oneMinusSourceAlpha = 1 - sourceAlpha;
						blendAlpha = sourceAlpha + destAlpha * oneMinusSourceAlpha;
						if(blendAlpha == 0) {
							destPixel = 0;
						} else {
							var value = lime_math_RGBA.__clamp[Math.round(((sourcePixel >>> 24 & 255) * sourceAlpha + (destPixel >>> 24 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (value & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
							var value1 = lime_math_RGBA.__clamp[Math.round(((sourcePixel >>> 16 & 255) * sourceAlpha + (destPixel >>> 16 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (value1 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
							var value2 = lime_math_RGBA.__clamp[Math.round(((sourcePixel >>> 8 & 255) * sourceAlpha + (destPixel >>> 8 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (value2 & 255) << 8 | destPixel & 255 & 255;
							var value3 = lime_math_RGBA.__clamp[Math.round(blendAlpha * 255.0)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | value3 & 255;
						}
						var format2 = destFormat;
						var premultiplied2 = destPremultiplied;
						if(premultiplied2 == null) {
							premultiplied2 = false;
						}
						if(format2 == null) {
							format2 = 0;
						}
						if(premultiplied2) {
							if((destPixel & 255) == 0) {
								if(destPixel != 0) {
									destPixel = 0;
								}
							} else if((destPixel & 255) != 255) {
								lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[destPixel & 255];
								destPixel = ((destPixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((destPixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((destPixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | destPixel & 255 & 255;
							}
						}
						switch(format2) {
						case 0:
							destData[destPosition] = destPixel >>> 24 & 255;
							destData[destPosition + 1] = destPixel >>> 16 & 255;
							destData[destPosition + 2] = destPixel >>> 8 & 255;
							destData[destPosition + 3] = destPixel & 255;
							break;
						case 1:
							destData[destPosition] = destPixel & 255;
							destData[destPosition + 1] = destPixel >>> 24 & 255;
							destData[destPosition + 2] = destPixel >>> 16 & 255;
							destData[destPosition + 3] = destPixel >>> 8 & 255;
							break;
						case 2:
							destData[destPosition] = destPixel >>> 8 & 255;
							destData[destPosition + 1] = destPixel >>> 16 & 255;
							destData[destPosition + 2] = destPixel >>> 24 & 255;
							destData[destPosition + 3] = destPixel & 255;
							break;
						}
						sourcePosition += 4;
						destPosition += 4;
					}
				}
			} else if(sourceFormat == destFormat && sourcePremultiplied == destPremultiplied && sourceBytesPerPixel == destBytesPerPixel) {
				var _g = 0;
				var _g1 = destView.height;
				while(_g < _g1) {
					var y = _g++;
					sourcePosition = sourceView.byteOffset + sourceView.stride * y;
					destPosition = destView.byteOffset + destView.stride * y;
					destData.set(sourceData.subarray(sourcePosition,sourcePosition + destView.width * destBytesPerPixel),destPosition);
				}
			} else {
				var _g = 0;
				var _g1 = destView.height;
				while(_g < _g1) {
					var y = _g++;
					sourcePosition = sourceView.byteOffset + sourceView.stride * y;
					destPosition = destView.byteOffset + destView.stride * y;
					var _g2 = 0;
					var _g3 = destView.width;
					while(_g2 < _g3) {
						var x = _g2++;
						var format = sourceFormat;
						var premultiplied = sourcePremultiplied;
						if(premultiplied == null) {
							premultiplied = false;
						}
						if(format == null) {
							format = 0;
						}
						switch(format) {
						case 0:
							sourcePixel = (sourceData[sourcePosition] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition + 2] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						case 1:
							sourcePixel = (sourceData[sourcePosition + 1] & 255) << 24 | (sourceData[sourcePosition + 2] & 255) << 16 | (sourceData[sourcePosition + 3] & 255) << 8 | sourceData[sourcePosition] & 255;
							break;
						case 2:
							sourcePixel = (sourceData[sourcePosition + 2] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						}
						if(premultiplied) {
							if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
								lime_math_RGBA.unmult = 255.0 / (sourcePixel & 255);
								sourcePixel = (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						var format1 = destFormat;
						var premultiplied1 = destPremultiplied;
						if(premultiplied1 == null) {
							premultiplied1 = false;
						}
						if(format1 == null) {
							format1 = 0;
						}
						if(premultiplied1) {
							if((sourcePixel & 255) == 0) {
								if(sourcePixel != 0) {
									sourcePixel = 0;
								}
							} else if((sourcePixel & 255) != 255) {
								lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[sourcePixel & 255];
								sourcePixel = ((sourcePixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((sourcePixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((sourcePixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						switch(format1) {
						case 0:
							destData[destPosition] = sourcePixel >>> 24 & 255;
							destData[destPosition + 1] = sourcePixel >>> 16 & 255;
							destData[destPosition + 2] = sourcePixel >>> 8 & 255;
							destData[destPosition + 3] = sourcePixel & 255;
							break;
						case 1:
							destData[destPosition] = sourcePixel & 255;
							destData[destPosition + 1] = sourcePixel >>> 24 & 255;
							destData[destPosition + 2] = sourcePixel >>> 16 & 255;
							destData[destPosition + 3] = sourcePixel >>> 8 & 255;
							break;
						case 2:
							destData[destPosition] = sourcePixel >>> 8 & 255;
							destData[destPosition + 1] = sourcePixel >>> 16 & 255;
							destData[destPosition + 2] = sourcePixel >>> 24 & 255;
							destData[destPosition + 3] = sourcePixel & 255;
							break;
						}
						sourcePosition += 4;
						destPosition += 4;
					}
				}
			}
		} else {
			var alphaData = alphaImage.buffer.data;
			var alphaFormat = alphaImage.buffer.format;
			var alphaPosition;
			var alphaPixel = 0;
			var alphaView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(alphaImage,new lime_math_Rectangle(sourceView.x + (alphaPoint == null ? 0 : alphaPoint.x),sourceView.y + (alphaPoint == null ? 0 : alphaPoint.y),sourceView.width,sourceView.height));
			destView.clip(destPoint.x | 0,destPoint.y | 0,alphaView.width,alphaView.height);
			if(blend) {
				var _g = 0;
				var _g1 = destView.height;
				while(_g < _g1) {
					var y = _g++;
					sourcePosition = sourceView.byteOffset + sourceView.stride * y;
					destPosition = destView.byteOffset + destView.stride * y;
					alphaPosition = alphaView.byteOffset + alphaView.stride * y;
					var _g2 = 0;
					var _g3 = destView.width;
					while(_g2 < _g3) {
						var x = _g2++;
						var format = sourceFormat;
						var premultiplied = sourcePremultiplied;
						if(premultiplied == null) {
							premultiplied = false;
						}
						if(format == null) {
							format = 0;
						}
						switch(format) {
						case 0:
							sourcePixel = (sourceData[sourcePosition] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition + 2] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						case 1:
							sourcePixel = (sourceData[sourcePosition + 1] & 255) << 24 | (sourceData[sourcePosition + 2] & 255) << 16 | (sourceData[sourcePosition + 3] & 255) << 8 | sourceData[sourcePosition] & 255;
							break;
						case 2:
							sourcePixel = (sourceData[sourcePosition + 2] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						}
						if(premultiplied) {
							if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
								lime_math_RGBA.unmult = 255.0 / (sourcePixel & 255);
								sourcePixel = (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						var format1 = destFormat;
						var premultiplied1 = destPremultiplied;
						if(premultiplied1 == null) {
							premultiplied1 = false;
						}
						if(format1 == null) {
							format1 = 0;
						}
						switch(format1) {
						case 0:
							destPixel = (destData[destPosition] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition + 2] & 255) << 8 | destData[destPosition + 3] & 255;
							break;
						case 1:
							destPixel = (destData[destPosition + 1] & 255) << 24 | (destData[destPosition + 2] & 255) << 16 | (destData[destPosition + 3] & 255) << 8 | destData[destPosition] & 255;
							break;
						case 2:
							destPixel = (destData[destPosition + 2] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition] & 255) << 8 | destData[destPosition + 3] & 255;
							break;
						}
						if(premultiplied1) {
							if((destPixel & 255) != 0 && (destPixel & 255) != 255) {
								lime_math_RGBA.unmult = 255.0 / (destPixel & 255);
								destPixel = (lime_math_RGBA.__clamp[Math.round((destPixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((destPixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((destPixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | destPixel & 255 & 255;
							}
						}
						var format2 = alphaFormat;
						var premultiplied2 = false;
						if(premultiplied2 == null) {
							premultiplied2 = false;
						}
						if(format2 == null) {
							format2 = 0;
						}
						switch(format2) {
						case 0:
							alphaPixel = (alphaData[alphaPosition] & 255) << 24 | (alphaData[alphaPosition + 1] & 255) << 16 | (alphaData[alphaPosition + 2] & 255) << 8 | alphaData[alphaPosition + 3] & 255;
							break;
						case 1:
							alphaPixel = (alphaData[alphaPosition + 1] & 255) << 24 | (alphaData[alphaPosition + 2] & 255) << 16 | (alphaData[alphaPosition + 3] & 255) << 8 | alphaData[alphaPosition] & 255;
							break;
						case 2:
							alphaPixel = (alphaData[alphaPosition + 2] & 255) << 24 | (alphaData[alphaPosition + 1] & 255) << 16 | (alphaData[alphaPosition] & 255) << 8 | alphaData[alphaPosition + 3] & 255;
							break;
						}
						if(premultiplied2) {
							if((alphaPixel & 255) != 0 && (alphaPixel & 255) != 255) {
								lime_math_RGBA.unmult = 255.0 / (alphaPixel & 255);
								alphaPixel = (lime_math_RGBA.__clamp[Math.round((alphaPixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((alphaPixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((alphaPixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | alphaPixel & 255 & 255;
							}
						}
						sourceAlpha = (alphaPixel & 255) / 255.0 * ((sourcePixel & 255) / 255.0);
						if(sourceAlpha > 0) {
							destAlpha = (destPixel & 255) / 255.0;
							oneMinusSourceAlpha = 1 - sourceAlpha;
							blendAlpha = sourceAlpha + destAlpha * oneMinusSourceAlpha;
							var value = lime_math_RGBA.__clamp[Math.round(((sourcePixel >>> 24 & 255) * sourceAlpha + (destPixel >>> 24 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (value & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
							var value1 = lime_math_RGBA.__clamp[Math.round(((sourcePixel >>> 16 & 255) * sourceAlpha + (destPixel >>> 16 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (value1 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
							var value2 = lime_math_RGBA.__clamp[Math.round(((sourcePixel >>> 8 & 255) * sourceAlpha + (destPixel >>> 8 & 255) * destAlpha * oneMinusSourceAlpha) / blendAlpha)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (value2 & 255) << 8 | destPixel & 255 & 255;
							var value3 = lime_math_RGBA.__clamp[Math.round(blendAlpha * 255.0)];
							destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | value3 & 255;
							var format3 = destFormat;
							var premultiplied3 = destPremultiplied;
							if(premultiplied3 == null) {
								premultiplied3 = false;
							}
							if(format3 == null) {
								format3 = 0;
							}
							if(premultiplied3) {
								if((destPixel & 255) == 0) {
									if(destPixel != 0) {
										destPixel = 0;
									}
								} else if((destPixel & 255) != 255) {
									lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[destPixel & 255];
									destPixel = ((destPixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((destPixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((destPixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | destPixel & 255 & 255;
								}
							}
							switch(format3) {
							case 0:
								destData[destPosition] = destPixel >>> 24 & 255;
								destData[destPosition + 1] = destPixel >>> 16 & 255;
								destData[destPosition + 2] = destPixel >>> 8 & 255;
								destData[destPosition + 3] = destPixel & 255;
								break;
							case 1:
								destData[destPosition] = destPixel & 255;
								destData[destPosition + 1] = destPixel >>> 24 & 255;
								destData[destPosition + 2] = destPixel >>> 16 & 255;
								destData[destPosition + 3] = destPixel >>> 8 & 255;
								break;
							case 2:
								destData[destPosition] = destPixel >>> 8 & 255;
								destData[destPosition + 1] = destPixel >>> 16 & 255;
								destData[destPosition + 2] = destPixel >>> 24 & 255;
								destData[destPosition + 3] = destPixel & 255;
								break;
							}
						}
						sourcePosition += 4;
						destPosition += 4;
						alphaPosition += 4;
					}
				}
			} else {
				var _g = 0;
				var _g1 = destView.height;
				while(_g < _g1) {
					var y = _g++;
					sourcePosition = sourceView.byteOffset + sourceView.stride * y;
					destPosition = destView.byteOffset + destView.stride * y;
					alphaPosition = alphaView.byteOffset + alphaView.stride * y;
					var _g2 = 0;
					var _g3 = destView.width;
					while(_g2 < _g3) {
						var x = _g2++;
						var format = sourceFormat;
						var premultiplied = sourcePremultiplied;
						if(premultiplied == null) {
							premultiplied = false;
						}
						if(format == null) {
							format = 0;
						}
						switch(format) {
						case 0:
							sourcePixel = (sourceData[sourcePosition] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition + 2] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						case 1:
							sourcePixel = (sourceData[sourcePosition + 1] & 255) << 24 | (sourceData[sourcePosition + 2] & 255) << 16 | (sourceData[sourcePosition + 3] & 255) << 8 | sourceData[sourcePosition] & 255;
							break;
						case 2:
							sourcePixel = (sourceData[sourcePosition + 2] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
							break;
						}
						if(premultiplied) {
							if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
								lime_math_RGBA.unmult = 255.0 / (sourcePixel & 255);
								sourcePixel = (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						var format1 = alphaFormat;
						var premultiplied1 = false;
						if(premultiplied1 == null) {
							premultiplied1 = false;
						}
						if(format1 == null) {
							format1 = 0;
						}
						switch(format1) {
						case 0:
							alphaPixel = (alphaData[alphaPosition] & 255) << 24 | (alphaData[alphaPosition + 1] & 255) << 16 | (alphaData[alphaPosition + 2] & 255) << 8 | alphaData[alphaPosition + 3] & 255;
							break;
						case 1:
							alphaPixel = (alphaData[alphaPosition + 1] & 255) << 24 | (alphaData[alphaPosition + 2] & 255) << 16 | (alphaData[alphaPosition + 3] & 255) << 8 | alphaData[alphaPosition] & 255;
							break;
						case 2:
							alphaPixel = (alphaData[alphaPosition + 2] & 255) << 24 | (alphaData[alphaPosition + 1] & 255) << 16 | (alphaData[alphaPosition] & 255) << 8 | alphaData[alphaPosition + 3] & 255;
							break;
						}
						if(premultiplied1) {
							if((alphaPixel & 255) != 0 && (alphaPixel & 255) != 255) {
								lime_math_RGBA.unmult = 255.0 / (alphaPixel & 255);
								alphaPixel = (lime_math_RGBA.__clamp[Math.round((alphaPixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((alphaPixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((alphaPixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | alphaPixel & 255 & 255;
							}
						}
						var value = Math.round((sourcePixel & 255) * ((alphaPixel & 255) / 255));
						sourcePixel = (sourcePixel >>> 24 & 255 & 255) << 24 | (sourcePixel >>> 16 & 255 & 255) << 16 | (sourcePixel >>> 8 & 255 & 255) << 8 | value & 255;
						var format2 = destFormat;
						var premultiplied2 = destPremultiplied;
						if(premultiplied2 == null) {
							premultiplied2 = false;
						}
						if(format2 == null) {
							format2 = 0;
						}
						if(premultiplied2) {
							if((sourcePixel & 255) == 0) {
								if(sourcePixel != 0) {
									sourcePixel = 0;
								}
							} else if((sourcePixel & 255) != 255) {
								lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[sourcePixel & 255];
								sourcePixel = ((sourcePixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((sourcePixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((sourcePixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | sourcePixel & 255 & 255;
							}
						}
						switch(format2) {
						case 0:
							destData[destPosition] = sourcePixel >>> 24 & 255;
							destData[destPosition + 1] = sourcePixel >>> 16 & 255;
							destData[destPosition + 2] = sourcePixel >>> 8 & 255;
							destData[destPosition + 3] = sourcePixel & 255;
							break;
						case 1:
							destData[destPosition] = sourcePixel & 255;
							destData[destPosition + 1] = sourcePixel >>> 24 & 255;
							destData[destPosition + 2] = sourcePixel >>> 16 & 255;
							destData[destPosition + 3] = sourcePixel >>> 8 & 255;
							break;
						case 2:
							destData[destPosition] = sourcePixel >>> 8 & 255;
							destData[destPosition + 1] = sourcePixel >>> 16 & 255;
							destData[destPosition + 2] = sourcePixel >>> 24 & 255;
							destData[destPosition + 3] = sourcePixel & 255;
							break;
						}
						sourcePosition += 4;
						destPosition += 4;
						alphaPosition += 4;
					}
				}
			}
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.fillRect = function(image,rect,color,format) {
	var fillColor;
	switch(format) {
	case 1:
		var argb = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		fillColor = rgba;
		break;
	case 2:
		var bgra = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		fillColor = rgba;
		break;
	default:
		fillColor = color;
	}
	if(!image.get_transparent()) {
		fillColor = (fillColor >>> 24 & 255 & 255) << 24 | (fillColor >>> 16 & 255 & 255) << 16 | (fillColor >>> 8 & 255 & 255) << 8 | 255;
	}
	var data = image.buffer.data;
	if(data == null) {
		return;
	}
	var format = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	if(premultiplied) {
		if((fillColor & 255) == 0) {
			if(fillColor != 0) {
				fillColor = 0;
			}
		} else if((fillColor & 255) != 255) {
			lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[fillColor & 255];
			fillColor = ((fillColor >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((fillColor >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((fillColor >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | fillColor & 255 & 255;
		}
	}
	var dataView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,rect);
	var row;
	var _g = 0;
	var _g1 = dataView.height;
	while(_g < _g1) {
		var y = _g++;
		row = dataView.byteOffset + dataView.stride * y;
		var _g2 = 0;
		var _g3 = dataView.width;
		while(_g2 < _g3) {
			var x = _g2++;
			var offset = row + x * 4;
			var format1 = format;
			var premultiplied = false;
			if(premultiplied == null) {
				premultiplied = false;
			}
			if(format1 == null) {
				format1 = 0;
			}
			if(premultiplied) {
				if((fillColor & 255) == 0) {
					if(fillColor != 0) {
						fillColor = 0;
					}
				} else if((fillColor & 255) != 255) {
					lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[fillColor & 255];
					fillColor = ((fillColor >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((fillColor >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((fillColor >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | fillColor & 255 & 255;
				}
			}
			switch(format1) {
			case 0:
				data[offset] = fillColor >>> 24 & 255;
				data[offset + 1] = fillColor >>> 16 & 255;
				data[offset + 2] = fillColor >>> 8 & 255;
				data[offset + 3] = fillColor & 255;
				break;
			case 1:
				data[offset] = fillColor & 255;
				data[offset + 1] = fillColor >>> 24 & 255;
				data[offset + 2] = fillColor >>> 16 & 255;
				data[offset + 3] = fillColor >>> 8 & 255;
				break;
			case 2:
				data[offset] = fillColor >>> 8 & 255;
				data[offset + 1] = fillColor >>> 16 & 255;
				data[offset + 2] = fillColor >>> 24 & 255;
				data[offset + 3] = fillColor & 255;
				break;
			}
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.floodFill = function(image,x,y,color,format) {
	var data = image.buffer.data;
	if(data == null) {
		return;
	}
	if(format == 1) {
		color = (color & 16777215) << 8 | color >> 24 & 255;
	}
	var format = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	var fillColor = color;
	var hitColor = 0;
	var offset = (y + image.offsetY) * (image.buffer.width * 4) + (x + image.offsetX) * 4;
	var format1 = format;
	var premultiplied1 = premultiplied;
	if(premultiplied1 == null) {
		premultiplied1 = false;
	}
	if(format1 == null) {
		format1 = 0;
	}
	switch(format1) {
	case 0:
		hitColor = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		hitColor = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		hitColor = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied1) {
		if((hitColor & 255) != 0 && (hitColor & 255) != 255) {
			lime_math_RGBA.unmult = 255.0 / (hitColor & 255);
			hitColor = (lime_math_RGBA.__clamp[Math.round((hitColor >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((hitColor >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((hitColor >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | hitColor & 255 & 255;
		}
	}
	if(!image.get_transparent()) {
		fillColor = (fillColor >>> 24 & 255 & 255) << 24 | (fillColor >>> 16 & 255 & 255) << 16 | (fillColor >>> 8 & 255 & 255) << 8 | 255;
		hitColor = (hitColor >>> 24 & 255 & 255) << 24 | (hitColor >>> 16 & 255 & 255) << 16 | (hitColor >>> 8 & 255 & 255) << 8 | 255;
	}
	if(fillColor == hitColor) {
		return;
	}
	if(premultiplied) {
		if((fillColor & 255) == 0) {
			if(fillColor != 0) {
				fillColor = 0;
			}
		} else if((fillColor & 255) != 255) {
			lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[fillColor & 255];
			fillColor = ((fillColor >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((fillColor >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((fillColor >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | fillColor & 255 & 255;
		}
	}
	var dx = [0,-1,1,0];
	var dy = [-1,0,0,1];
	var minX = -image.offsetX;
	var minY = -image.offsetY;
	var maxX = minX + image.width;
	var maxY = minY + image.height;
	var queue = [];
	queue.push(x);
	queue.push(y);
	var curPointX;
	var curPointY;
	var nextPointX;
	var nextPointY;
	var nextPointOffset;
	var readColor = 0;
	while(queue.length > 0) {
		curPointY = queue.pop();
		curPointX = queue.pop();
		var _g = 0;
		while(_g < 4) {
			var i = _g++;
			nextPointX = curPointX + dx[i];
			nextPointY = curPointY + dy[i];
			if(nextPointX < minX || nextPointY < minY || nextPointX >= maxX || nextPointY >= maxY) {
				continue;
			}
			nextPointOffset = (nextPointY * image.width + nextPointX) * 4;
			var format1 = format;
			var premultiplied1 = premultiplied;
			if(premultiplied1 == null) {
				premultiplied1 = false;
			}
			if(format1 == null) {
				format1 = 0;
			}
			switch(format1) {
			case 0:
				readColor = (data[nextPointOffset] & 255) << 24 | (data[nextPointOffset + 1] & 255) << 16 | (data[nextPointOffset + 2] & 255) << 8 | data[nextPointOffset + 3] & 255;
				break;
			case 1:
				readColor = (data[nextPointOffset + 1] & 255) << 24 | (data[nextPointOffset + 2] & 255) << 16 | (data[nextPointOffset + 3] & 255) << 8 | data[nextPointOffset] & 255;
				break;
			case 2:
				readColor = (data[nextPointOffset + 2] & 255) << 24 | (data[nextPointOffset + 1] & 255) << 16 | (data[nextPointOffset] & 255) << 8 | data[nextPointOffset + 3] & 255;
				break;
			}
			if(premultiplied1) {
				if((readColor & 255) != 0 && (readColor & 255) != 255) {
					lime_math_RGBA.unmult = 255.0 / (readColor & 255);
					readColor = (lime_math_RGBA.__clamp[Math.round((readColor >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((readColor >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((readColor >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | readColor & 255 & 255;
				}
			}
			if(readColor == hitColor) {
				var format2 = format;
				var premultiplied2 = false;
				if(premultiplied2 == null) {
					premultiplied2 = false;
				}
				if(format2 == null) {
					format2 = 0;
				}
				if(premultiplied2) {
					if((fillColor & 255) == 0) {
						if(fillColor != 0) {
							fillColor = 0;
						}
					} else if((fillColor & 255) != 255) {
						lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[fillColor & 255];
						fillColor = ((fillColor >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((fillColor >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((fillColor >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | fillColor & 255 & 255;
					}
				}
				switch(format2) {
				case 0:
					data[nextPointOffset] = fillColor >>> 24 & 255;
					data[nextPointOffset + 1] = fillColor >>> 16 & 255;
					data[nextPointOffset + 2] = fillColor >>> 8 & 255;
					data[nextPointOffset + 3] = fillColor & 255;
					break;
				case 1:
					data[nextPointOffset] = fillColor & 255;
					data[nextPointOffset + 1] = fillColor >>> 24 & 255;
					data[nextPointOffset + 2] = fillColor >>> 16 & 255;
					data[nextPointOffset + 3] = fillColor >>> 8 & 255;
					break;
				case 2:
					data[nextPointOffset] = fillColor >>> 8 & 255;
					data[nextPointOffset + 1] = fillColor >>> 16 & 255;
					data[nextPointOffset + 2] = fillColor >>> 24 & 255;
					data[nextPointOffset + 3] = fillColor & 255;
					break;
				}
				queue.push(nextPointX);
				queue.push(nextPointY);
			}
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.gaussianBlur = function(image,sourceImage,sourceRect,destPoint,blurX,blurY,quality,strength,color) {
	if(strength == null) {
		strength = 1;
	}
	if(quality == null) {
		quality = 1;
	}
	if(blurY == null) {
		blurY = 4;
	}
	if(blurX == null) {
		blurX = 4;
	}
	var imagePremultiplied = image.get_premultiplied();
	if(imagePremultiplied) {
		image.set_premultiplied(false);
	}
	lime__$internal_graphics_StackBlur.blur(image,sourceImage,sourceRect,destPoint,blurX,blurY,quality);
	image.dirty = true;
	image.version++;
	if(imagePremultiplied) {
		image.set_premultiplied(true);
	}
	return image;
};
lime__$internal_graphics_ImageDataUtil.getColorBoundsRect = function(image,mask,color,findColor,format) {
	var left = image.width + 1;
	var right = 0;
	var top = image.height + 1;
	var bottom = 0;
	var _color;
	var _mask;
	switch(format) {
	case 1:
		var argb = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		_color = rgba;
		var argb = mask;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		_mask = rgba;
		break;
	case 2:
		var bgra = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		_color = rgba;
		var bgra = mask;
		var this1 = 0;
		var rgba = this1;
		rgba = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		_mask = rgba;
		break;
	default:
		_color = color;
		_mask = mask;
	}
	if(!image.get_transparent()) {
		_color = (_color >>> 24 & 255 & 255) << 24 | (_color >>> 16 & 255 & 255) << 16 | (_color >>> 8 & 255 & 255) << 8 | 255;
		_mask = (_mask >>> 24 & 255 & 255) << 24 | (_mask >>> 16 & 255 & 255) << 16 | (_mask >>> 8 & 255 & 255) << 8 | 255;
	}
	var pixel;
	var hit;
	var _g = 0;
	var _g1 = image.width;
	while(_g < _g1) {
		var x = _g++;
		hit = false;
		var _g2 = 0;
		var _g3 = image.height;
		while(_g2 < _g3) {
			var y = _g2++;
			pixel = image.getPixel32(x,y,0);
			hit = findColor ? (pixel & _mask) == _color : (pixel & _mask) != _color;
			if(hit) {
				if(x < left) {
					left = x;
				}
				break;
			}
		}
		if(hit) {
			break;
		}
	}
	var ix;
	var _g = 0;
	var _g1 = image.width;
	while(_g < _g1) {
		var x = _g++;
		ix = image.width - 1 - x;
		hit = false;
		var _g2 = 0;
		var _g3 = image.height;
		while(_g2 < _g3) {
			var y = _g2++;
			pixel = image.getPixel32(ix,y,0);
			hit = findColor ? (pixel & _mask) == _color : (pixel & _mask) != _color;
			if(hit) {
				if(ix > right) {
					right = ix;
				}
				break;
			}
		}
		if(hit) {
			break;
		}
	}
	var _g = 0;
	var _g1 = image.height;
	while(_g < _g1) {
		var y = _g++;
		hit = false;
		var _g2 = 0;
		var _g3 = image.width;
		while(_g2 < _g3) {
			var x = _g2++;
			pixel = image.getPixel32(x,y,0);
			hit = findColor ? (pixel & _mask) == _color : (pixel & _mask) != _color;
			if(hit) {
				if(y < top) {
					top = y;
				}
				break;
			}
		}
		if(hit) {
			break;
		}
	}
	var iy;
	var _g = 0;
	var _g1 = image.height;
	while(_g < _g1) {
		var y = _g++;
		iy = image.height - 1 - y;
		hit = false;
		var _g2 = 0;
		var _g3 = image.width;
		while(_g2 < _g3) {
			var x = _g2++;
			pixel = image.getPixel32(x,iy,0);
			hit = findColor ? (pixel & _mask) == _color : (pixel & _mask) != _color;
			if(hit) {
				if(iy > bottom) {
					bottom = iy;
				}
				break;
			}
		}
		if(hit) {
			break;
		}
	}
	var w = right - left;
	var h = bottom - top;
	if(w > 0) {
		++w;
	}
	if(h > 0) {
		++h;
	}
	if(w < 0) {
		w = 0;
	}
	if(h < 0) {
		h = 0;
	}
	if(left == right) {
		w = 1;
	}
	if(top == bottom) {
		h = 1;
	}
	if(left > image.width) {
		left = 0;
	}
	if(top > image.height) {
		top = 0;
	}
	return new lime_math_Rectangle(left,top,w,h);
};
lime__$internal_graphics_ImageDataUtil.getPixel = function(image,x,y,format) {
	var pixel = 0;
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	var format1 = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format1 == null) {
		format1 = 0;
	}
	switch(format1) {
	case 0:
		pixel = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		pixel = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		pixel = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied) {
		if((pixel & 255) != 0 && (pixel & 255) != 255) {
			lime_math_RGBA.unmult = 255.0 / (pixel & 255);
			pixel = (lime_math_RGBA.__clamp[Math.round((pixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | pixel & 255 & 255;
		}
	}
	pixel = (pixel >>> 24 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 8 & 255 & 255) << 8 | 0;
	switch(format) {
	case 1:
		var this1 = 0;
		var argb = this1;
		argb = (pixel & 255 & 255) << 24 | (pixel >>> 24 & 255 & 255) << 16 | (pixel >>> 16 & 255 & 255) << 8 | pixel >>> 8 & 255 & 255;
		return argb;
	case 2:
		var this1 = 0;
		var bgra = this1;
		bgra = (pixel >>> 8 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 24 & 255 & 255) << 8 | pixel & 255 & 255;
		return bgra;
	default:
		return pixel;
	}
};
lime__$internal_graphics_ImageDataUtil.getPixel32 = function(image,x,y,format) {
	var pixel = 0;
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	var format1 = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format1 == null) {
		format1 = 0;
	}
	switch(format1) {
	case 0:
		pixel = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		pixel = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		pixel = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied) {
		if((pixel & 255) != 0 && (pixel & 255) != 255) {
			lime_math_RGBA.unmult = 255.0 / (pixel & 255);
			pixel = (lime_math_RGBA.__clamp[Math.round((pixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | pixel & 255 & 255;
		}
	}
	switch(format) {
	case 1:
		var this1 = 0;
		var argb = this1;
		argb = (pixel & 255 & 255) << 24 | (pixel >>> 24 & 255 & 255) << 16 | (pixel >>> 16 & 255 & 255) << 8 | pixel >>> 8 & 255 & 255;
		return argb;
	case 2:
		var this1 = 0;
		var bgra = this1;
		bgra = (pixel >>> 8 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 24 & 255 & 255) << 8 | pixel & 255 & 255;
		return bgra;
	default:
		return pixel;
	}
};
lime__$internal_graphics_ImageDataUtil.getPixels = function(image,rect,format) {
	if(image.buffer.data == null) {
		return null;
	}
	var length = rect.width * rect.height | 0;
	var bytes = new haxe_io_Bytes(new ArrayBuffer(length * 4));
	var data = image.buffer.data;
	var sourceFormat = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	var dataView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,rect);
	var position;
	var argb = 0;
	var bgra = 0;
	var pixel = 0;
	var destPosition = 0;
	var _g = 0;
	var _g1 = dataView.height;
	while(_g < _g1) {
		var y = _g++;
		position = dataView.byteOffset + dataView.stride * y;
		var _g2 = 0;
		var _g3 = dataView.width;
		while(_g2 < _g3) {
			var x = _g2++;
			var format1 = sourceFormat;
			var premultiplied1 = premultiplied;
			if(premultiplied1 == null) {
				premultiplied1 = false;
			}
			if(format1 == null) {
				format1 = 0;
			}
			switch(format1) {
			case 0:
				pixel = (data[position] & 255) << 24 | (data[position + 1] & 255) << 16 | (data[position + 2] & 255) << 8 | data[position + 3] & 255;
				break;
			case 1:
				pixel = (data[position + 1] & 255) << 24 | (data[position + 2] & 255) << 16 | (data[position + 3] & 255) << 8 | data[position] & 255;
				break;
			case 2:
				pixel = (data[position + 2] & 255) << 24 | (data[position + 1] & 255) << 16 | (data[position] & 255) << 8 | data[position + 3] & 255;
				break;
			}
			if(premultiplied1) {
				if((pixel & 255) != 0 && (pixel & 255) != 255) {
					lime_math_RGBA.unmult = 255.0 / (pixel & 255);
					pixel = (lime_math_RGBA.__clamp[Math.round((pixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | pixel & 255 & 255;
				}
			}
			switch(format) {
			case 1:
				var this1 = 0;
				var argb1 = this1;
				argb1 = (pixel & 255 & 255) << 24 | (pixel >>> 24 & 255 & 255) << 16 | (pixel >>> 16 & 255 & 255) << 8 | pixel >>> 8 & 255 & 255;
				argb = argb1;
				pixel = argb;
				break;
			case 2:
				var this2 = 0;
				var bgra1 = this2;
				bgra1 = (pixel >>> 8 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 24 & 255 & 255) << 8 | pixel & 255 & 255;
				bgra = bgra1;
				pixel = bgra;
				break;
			default:
			}
			bytes.b[destPosition++] = pixel >>> 24 & 255 & 255;
			bytes.b[destPosition++] = pixel >>> 16 & 255 & 255;
			bytes.b[destPosition++] = pixel >>> 8 & 255 & 255;
			bytes.b[destPosition++] = pixel & 255 & 255;
			position += 4;
		}
	}
	return bytes;
};
lime__$internal_graphics_ImageDataUtil.merge = function(image,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
	if(image.buffer.data == null || sourceImage.buffer.data == null) {
		return;
	}
	var sourceView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(sourceImage,sourceRect);
	var destView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,new lime_math_Rectangle(destPoint.x,destPoint.y,sourceView.width,sourceView.height));
	var sourceData = sourceImage.buffer.data;
	var destData = image.buffer.data;
	var sourceFormat = sourceImage.buffer.format;
	var destFormat = image.buffer.format;
	var sourcePremultiplied = sourceImage.buffer.premultiplied;
	var destPremultiplied = image.buffer.premultiplied;
	var sourcePosition;
	var destPosition;
	var sourcePixel = 0;
	var destPixel = 0;
	var _g = 0;
	var _g1 = destView.height;
	while(_g < _g1) {
		var y = _g++;
		sourcePosition = sourceView.byteOffset + sourceView.stride * y;
		destPosition = destView.byteOffset + destView.stride * y;
		var _g2 = 0;
		var _g3 = destView.width;
		while(_g2 < _g3) {
			var x = _g2++;
			var format = sourceFormat;
			var premultiplied = sourcePremultiplied;
			if(premultiplied == null) {
				premultiplied = false;
			}
			if(format == null) {
				format = 0;
			}
			switch(format) {
			case 0:
				sourcePixel = (sourceData[sourcePosition] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition + 2] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
				break;
			case 1:
				sourcePixel = (sourceData[sourcePosition + 1] & 255) << 24 | (sourceData[sourcePosition + 2] & 255) << 16 | (sourceData[sourcePosition + 3] & 255) << 8 | sourceData[sourcePosition] & 255;
				break;
			case 2:
				sourcePixel = (sourceData[sourcePosition + 2] & 255) << 24 | (sourceData[sourcePosition + 1] & 255) << 16 | (sourceData[sourcePosition] & 255) << 8 | sourceData[sourcePosition + 3] & 255;
				break;
			}
			if(premultiplied) {
				if((sourcePixel & 255) != 0 && (sourcePixel & 255) != 255) {
					lime_math_RGBA.unmult = 255.0 / (sourcePixel & 255);
					sourcePixel = (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((sourcePixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | sourcePixel & 255 & 255;
				}
			}
			var format1 = destFormat;
			var premultiplied1 = destPremultiplied;
			if(premultiplied1 == null) {
				premultiplied1 = false;
			}
			if(format1 == null) {
				format1 = 0;
			}
			switch(format1) {
			case 0:
				destPixel = (destData[destPosition] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition + 2] & 255) << 8 | destData[destPosition + 3] & 255;
				break;
			case 1:
				destPixel = (destData[destPosition + 1] & 255) << 24 | (destData[destPosition + 2] & 255) << 16 | (destData[destPosition + 3] & 255) << 8 | destData[destPosition] & 255;
				break;
			case 2:
				destPixel = (destData[destPosition + 2] & 255) << 24 | (destData[destPosition + 1] & 255) << 16 | (destData[destPosition] & 255) << 8 | destData[destPosition + 3] & 255;
				break;
			}
			if(premultiplied1) {
				if((destPixel & 255) != 0 && (destPixel & 255) != 255) {
					lime_math_RGBA.unmult = 255.0 / (destPixel & 255);
					destPixel = (lime_math_RGBA.__clamp[Math.round((destPixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((destPixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((destPixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | destPixel & 255 & 255;
				}
			}
			var value = ((sourcePixel >>> 24 & 255) * redMultiplier + (destPixel >>> 24 & 255) * (256 - redMultiplier)) / 256 | 0;
			destPixel = (value & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
			var value1 = ((sourcePixel >>> 16 & 255) * greenMultiplier + (destPixel >>> 16 & 255) * (256 - greenMultiplier)) / 256 | 0;
			destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (value1 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | destPixel & 255 & 255;
			var value2 = ((sourcePixel >>> 8 & 255) * blueMultiplier + (destPixel >>> 8 & 255) * (256 - blueMultiplier)) / 256 | 0;
			destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (value2 & 255) << 8 | destPixel & 255 & 255;
			var value3 = ((sourcePixel & 255) * alphaMultiplier + (destPixel & 255) * (256 - alphaMultiplier)) / 256 | 0;
			destPixel = (destPixel >>> 24 & 255 & 255) << 24 | (destPixel >>> 16 & 255 & 255) << 16 | (destPixel >>> 8 & 255 & 255) << 8 | value3 & 255;
			var format2 = destFormat;
			var premultiplied2 = destPremultiplied;
			if(premultiplied2 == null) {
				premultiplied2 = false;
			}
			if(format2 == null) {
				format2 = 0;
			}
			if(premultiplied2) {
				if((destPixel & 255) == 0) {
					if(destPixel != 0) {
						destPixel = 0;
					}
				} else if((destPixel & 255) != 255) {
					lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[destPixel & 255];
					destPixel = ((destPixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((destPixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((destPixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | destPixel & 255 & 255;
				}
			}
			switch(format2) {
			case 0:
				destData[destPosition] = destPixel >>> 24 & 255;
				destData[destPosition + 1] = destPixel >>> 16 & 255;
				destData[destPosition + 2] = destPixel >>> 8 & 255;
				destData[destPosition + 3] = destPixel & 255;
				break;
			case 1:
				destData[destPosition] = destPixel & 255;
				destData[destPosition + 1] = destPixel >>> 24 & 255;
				destData[destPosition + 2] = destPixel >>> 16 & 255;
				destData[destPosition + 3] = destPixel >>> 8 & 255;
				break;
			case 2:
				destData[destPosition] = destPixel >>> 8 & 255;
				destData[destPosition + 1] = destPixel >>> 16 & 255;
				destData[destPosition + 2] = destPixel >>> 24 & 255;
				destData[destPosition + 3] = destPixel & 255;
				break;
			}
			sourcePosition += 4;
			destPosition += 4;
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.multiplyAlpha = function(image) {
	var data = image.buffer.data;
	if(data == null || !image.buffer.transparent) {
		return;
	}
	var format = image.buffer.format;
	var length = data.length / 4 | 0;
	var pixel = 0;
	var _g = 0;
	var _g1 = length;
	while(_g < _g1) {
		var i = _g++;
		var offset = i * 4;
		var format1 = format;
		var premultiplied = false;
		if(premultiplied == null) {
			premultiplied = false;
		}
		if(format1 == null) {
			format1 = 0;
		}
		switch(format1) {
		case 0:
			pixel = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
			break;
		case 1:
			pixel = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
			break;
		case 2:
			pixel = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
			break;
		}
		if(premultiplied) {
			if((pixel & 255) != 0 && (pixel & 255) != 255) {
				lime_math_RGBA.unmult = 255.0 / (pixel & 255);
				pixel = (lime_math_RGBA.__clamp[Math.round((pixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | pixel & 255 & 255;
			}
		}
		var offset1 = i * 4;
		var format2 = format;
		var premultiplied1 = true;
		if(premultiplied1 == null) {
			premultiplied1 = false;
		}
		if(format2 == null) {
			format2 = 0;
		}
		if(premultiplied1) {
			if((pixel & 255) == 0) {
				if(pixel != 0) {
					pixel = 0;
				}
			} else if((pixel & 255) != 255) {
				lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[pixel & 255];
				pixel = ((pixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((pixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((pixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | pixel & 255 & 255;
			}
		}
		switch(format2) {
		case 0:
			data[offset1] = pixel >>> 24 & 255;
			data[offset1 + 1] = pixel >>> 16 & 255;
			data[offset1 + 2] = pixel >>> 8 & 255;
			data[offset1 + 3] = pixel & 255;
			break;
		case 1:
			data[offset1] = pixel & 255;
			data[offset1 + 1] = pixel >>> 24 & 255;
			data[offset1 + 2] = pixel >>> 16 & 255;
			data[offset1 + 3] = pixel >>> 8 & 255;
			break;
		case 2:
			data[offset1] = pixel >>> 8 & 255;
			data[offset1 + 1] = pixel >>> 16 & 255;
			data[offset1 + 2] = pixel >>> 24 & 255;
			data[offset1 + 3] = pixel & 255;
			break;
		}
	}
	image.buffer.premultiplied = true;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.resize = function(image,newWidth,newHeight) {
	var buffer = image.buffer;
	if(buffer.width == newWidth && buffer.height == newHeight) {
		return;
	}
	var elements = newWidth * newHeight * 4;
	var array = null;
	var vector = null;
	var view = null;
	var buffer1 = null;
	var len = null;
	var this1;
	if(elements != null) {
		this1 = new Uint8Array(elements);
	} else if(array != null) {
		this1 = new Uint8Array(array);
	} else if(vector != null) {
		this1 = new Uint8Array(vector.__array);
	} else if(view != null) {
		this1 = new Uint8Array(view);
	} else if(buffer1 != null) {
		if(len == null) {
			this1 = new Uint8Array(buffer1,0);
		} else {
			this1 = new Uint8Array(buffer1,0,len);
		}
	} else {
		this1 = null;
	}
	var newBuffer = new lime_graphics_ImageBuffer(this1,newWidth,newHeight);
	var imageWidth = image.width;
	var imageHeight = image.height;
	var data = image.get_data();
	var newData = newBuffer.data;
	var sourceIndex;
	var sourceIndexX;
	var sourceIndexY;
	var sourceIndexXY;
	var index;
	var sourceX;
	var sourceY;
	var u;
	var v;
	var uRatio;
	var vRatio;
	var uOpposite;
	var vOpposite;
	var _g = 0;
	var _g1 = newHeight;
	while(_g < _g1) {
		var y = _g++;
		var _g2 = 0;
		var _g3 = newWidth;
		while(_g2 < _g3) {
			var x = _g2++;
			u = (x + 0.5) / newWidth * imageWidth - 0.5;
			v = (y + 0.5) / newHeight * imageHeight - 0.5;
			sourceX = u | 0;
			sourceY = v | 0;
			sourceIndex = (sourceY * imageWidth + sourceX) * 4;
			sourceIndexX = sourceX < imageWidth - 1 ? sourceIndex + 4 : sourceIndex;
			sourceIndexY = sourceY < imageHeight - 1 ? sourceIndex + imageWidth * 4 : sourceIndex;
			sourceIndexXY = sourceIndexX != sourceIndex ? sourceIndexY + 4 : sourceIndexY;
			index = (y * newWidth + x) * 4;
			uRatio = u - sourceX;
			vRatio = v - sourceY;
			uOpposite = 1 - uRatio;
			vOpposite = 1 - vRatio;
			newData[index] = (UInt.toFloat(data[sourceIndex]) * uOpposite + UInt.toFloat(data[sourceIndexX]) * uRatio) * vOpposite + (UInt.toFloat(data[sourceIndexY]) * uOpposite + UInt.toFloat(data[sourceIndexXY]) * uRatio) * vRatio | 0;
			newData[index + 1] = (UInt.toFloat(data[sourceIndex + 1]) * uOpposite + UInt.toFloat(data[sourceIndexX + 1]) * uRatio) * vOpposite + (UInt.toFloat(data[sourceIndexY + 1]) * uOpposite + UInt.toFloat(data[sourceIndexXY + 1]) * uRatio) * vRatio | 0;
			newData[index + 2] = (UInt.toFloat(data[sourceIndex + 2]) * uOpposite + UInt.toFloat(data[sourceIndexX + 2]) * uRatio) * vOpposite + (UInt.toFloat(data[sourceIndexY + 2]) * uOpposite + UInt.toFloat(data[sourceIndexXY + 2]) * uRatio) * vRatio | 0;
			if(data[sourceIndexX + 3] == 0 || data[sourceIndexY + 3] == 0 || data[sourceIndexXY + 3] == 0) {
				newData[index + 3] = 0;
			} else {
				newData[index + 3] = data[sourceIndex + 3];
			}
		}
	}
	buffer.data = newBuffer.data;
	buffer.width = newWidth;
	buffer.height = newHeight;
	buffer.__srcImage = null;
	buffer.__srcImageData = null;
	buffer.__srcCanvas = null;
	buffer.__srcContext = null;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.resizeBuffer = function(image,newWidth,newHeight) {
	var buffer = image.buffer;
	var data = image.get_data();
	var elements = newWidth * newHeight * 4;
	var array = null;
	var vector = null;
	var view = null;
	var buffer1 = null;
	var len = null;
	var this1;
	if(elements != null) {
		this1 = new Uint8Array(elements);
	} else if(array != null) {
		this1 = new Uint8Array(array);
	} else if(vector != null) {
		this1 = new Uint8Array(vector.__array);
	} else if(view != null) {
		this1 = new Uint8Array(view);
	} else if(buffer1 != null) {
		if(len == null) {
			this1 = new Uint8Array(buffer1,0);
		} else {
			this1 = new Uint8Array(buffer1,0,len);
		}
	} else {
		this1 = null;
	}
	var newData = this1;
	var sourceIndex;
	var index;
	var _g = 0;
	var _g1 = buffer.height;
	while(_g < _g1) {
		var y = _g++;
		var _g2 = 0;
		var _g3 = buffer.width;
		while(_g2 < _g3) {
			var x = _g2++;
			sourceIndex = (y * buffer.width + x) * 4;
			index = (y * newWidth + x) * 4;
			newData[index] = data[sourceIndex];
			newData[index + 1] = data[sourceIndex + 1];
			newData[index + 2] = data[sourceIndex + 2];
			newData[index + 3] = data[sourceIndex + 3];
		}
	}
	buffer.data = newData;
	buffer.width = newWidth;
	buffer.height = newHeight;
	buffer.__srcImage = null;
	buffer.__srcImageData = null;
	buffer.__srcCanvas = null;
	buffer.__srcContext = null;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.setFormat = function(image,format) {
	var data = image.buffer.data;
	if(data == null) {
		return;
	}
	var index;
	var a16;
	var length = data.length / 4 | 0;
	var r1;
	var g1;
	var b1;
	var a1;
	var r2;
	var g2;
	var b2;
	var a2;
	var r;
	var g;
	var b;
	var a;
	switch(image.get_format()) {
	case 0:
		r1 = 0;
		g1 = 1;
		b1 = 2;
		a1 = 3;
		break;
	case 1:
		r1 = 1;
		g1 = 2;
		b1 = 3;
		a1 = 0;
		break;
	case 2:
		r1 = 2;
		g1 = 1;
		b1 = 0;
		a1 = 3;
		break;
	}
	switch(format) {
	case 0:
		r2 = 0;
		g2 = 1;
		b2 = 2;
		a2 = 3;
		break;
	case 1:
		r2 = 1;
		g2 = 2;
		b2 = 3;
		a2 = 0;
		break;
	case 2:
		r2 = 2;
		g2 = 1;
		b2 = 0;
		a2 = 3;
		break;
	}
	var _g = 0;
	var _g1 = length;
	while(_g < _g1) {
		var i = _g++;
		index = i * 4;
		r = data[index + r1];
		g = data[index + g1];
		b = data[index + b1];
		a = data[index + a1];
		data[index + r2] = r;
		data[index + g2] = g;
		data[index + b2] = b;
		data[index + a2] = a;
	}
	image.buffer.format = format;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.setPixel = function(image,x,y,color,format) {
	var pixel;
	switch(format) {
	case 1:
		var argb = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		pixel = rgba;
		break;
	case 2:
		var bgra = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		pixel = rgba;
		break;
	default:
		pixel = color;
	}
	var this1 = 0;
	var source = this1;
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	var format = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	switch(format) {
	case 0:
		source = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		source = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		source = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied) {
		if((source & 255) != 0 && (source & 255) != 255) {
			lime_math_RGBA.unmult = 255.0 / (source & 255);
			source = (lime_math_RGBA.__clamp[Math.round((source >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((source >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((source >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | source & 255 & 255;
		}
	}
	var value = source & 255;
	pixel = (pixel >>> 24 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 8 & 255 & 255) << 8 | value & 255;
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	var format = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	if(premultiplied) {
		if((pixel & 255) == 0) {
			if(pixel != 0) {
				pixel = 0;
			}
		} else if((pixel & 255) != 255) {
			lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[pixel & 255];
			pixel = ((pixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((pixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((pixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | pixel & 255 & 255;
		}
	}
	switch(format) {
	case 0:
		data[offset] = pixel >>> 24 & 255;
		data[offset + 1] = pixel >>> 16 & 255;
		data[offset + 2] = pixel >>> 8 & 255;
		data[offset + 3] = pixel & 255;
		break;
	case 1:
		data[offset] = pixel & 255;
		data[offset + 1] = pixel >>> 24 & 255;
		data[offset + 2] = pixel >>> 16 & 255;
		data[offset + 3] = pixel >>> 8 & 255;
		break;
	case 2:
		data[offset] = pixel >>> 8 & 255;
		data[offset + 1] = pixel >>> 16 & 255;
		data[offset + 2] = pixel >>> 24 & 255;
		data[offset + 3] = pixel & 255;
		break;
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.setPixel32 = function(image,x,y,color,format) {
	var pixel;
	switch(format) {
	case 1:
		var argb = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		pixel = rgba;
		break;
	case 2:
		var bgra = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		pixel = rgba;
		break;
	default:
		pixel = color;
	}
	if(!image.get_transparent()) {
		pixel = (pixel >>> 24 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 8 & 255 & 255) << 8 | 255;
	}
	var data = image.buffer.data;
	var offset = 4 * (y + image.offsetY) * image.buffer.width + (x + image.offsetX) * 4;
	var format = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	if(premultiplied) {
		if((pixel & 255) == 0) {
			if(pixel != 0) {
				pixel = 0;
			}
		} else if((pixel & 255) != 255) {
			lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[pixel & 255];
			pixel = ((pixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((pixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((pixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | pixel & 255 & 255;
		}
	}
	switch(format) {
	case 0:
		data[offset] = pixel >>> 24 & 255;
		data[offset + 1] = pixel >>> 16 & 255;
		data[offset + 2] = pixel >>> 8 & 255;
		data[offset + 3] = pixel & 255;
		break;
	case 1:
		data[offset] = pixel & 255;
		data[offset + 1] = pixel >>> 24 & 255;
		data[offset + 2] = pixel >>> 16 & 255;
		data[offset + 3] = pixel >>> 8 & 255;
		break;
	case 2:
		data[offset] = pixel >>> 8 & 255;
		data[offset + 1] = pixel >>> 16 & 255;
		data[offset + 2] = pixel >>> 24 & 255;
		data[offset + 3] = pixel & 255;
		break;
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.setPixels = function(image,rect,bytePointer,format,endian) {
	if(image.buffer.data == null) {
		return;
	}
	var data = image.buffer.data;
	var sourceFormat = image.buffer.format;
	var premultiplied = image.buffer.premultiplied;
	var dataView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,rect);
	var row;
	var color;
	var pixel;
	var transparent = image.get_transparent();
	var bytes = bytePointer.bytes;
	var dataPosition = bytePointer.offset;
	var littleEndian = endian != lime_system_Endian.BIG_ENDIAN;
	var _g = 0;
	var _g1 = dataView.height;
	while(_g < _g1) {
		var y = _g++;
		row = dataView.byteOffset + dataView.stride * y;
		var _g2 = 0;
		var _g3 = dataView.width;
		while(_g2 < _g3) {
			var x = _g2++;
			if(littleEndian) {
				color = bytes.getInt32(dataPosition);
			} else {
				color = bytes.b[dataPosition + 3] | bytes.b[dataPosition + 2] << 8 | bytes.b[dataPosition + 1] << 16 | bytes.b[dataPosition] << 24;
			}
			dataPosition += 4;
			switch(format) {
			case 1:
				var argb = color;
				var this1 = 0;
				var rgba = this1;
				rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
				pixel = rgba;
				break;
			case 2:
				var bgra = color;
				var this2 = 0;
				var rgba1 = this2;
				rgba1 = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
				pixel = rgba1;
				break;
			default:
				pixel = color;
			}
			if(!transparent) {
				pixel = (pixel >>> 24 & 255 & 255) << 24 | (pixel >>> 16 & 255 & 255) << 16 | (pixel >>> 8 & 255 & 255) << 8 | 255;
			}
			var offset = row + x * 4;
			var format1 = sourceFormat;
			var premultiplied1 = premultiplied;
			if(premultiplied1 == null) {
				premultiplied1 = false;
			}
			if(format1 == null) {
				format1 = 0;
			}
			if(premultiplied1) {
				if((pixel & 255) == 0) {
					if(pixel != 0) {
						pixel = 0;
					}
				} else if((pixel & 255) != 255) {
					lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[pixel & 255];
					pixel = ((pixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((pixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((pixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | pixel & 255 & 255;
				}
			}
			switch(format1) {
			case 0:
				data[offset] = pixel >>> 24 & 255;
				data[offset + 1] = pixel >>> 16 & 255;
				data[offset + 2] = pixel >>> 8 & 255;
				data[offset + 3] = pixel & 255;
				break;
			case 1:
				data[offset] = pixel & 255;
				data[offset + 1] = pixel >>> 24 & 255;
				data[offset + 2] = pixel >>> 16 & 255;
				data[offset + 3] = pixel >>> 8 & 255;
				break;
			case 2:
				data[offset] = pixel >>> 8 & 255;
				data[offset + 1] = pixel >>> 16 & 255;
				data[offset + 2] = pixel >>> 24 & 255;
				data[offset + 3] = pixel & 255;
				break;
			}
		}
	}
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.threshold = function(image,sourceImage,sourceRect,destPoint,operation,threshold,color,mask,copySource,format) {
	var _color;
	var _mask;
	var _threshold;
	switch(format) {
	case 1:
		var argb = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		_color = rgba;
		var argb = mask;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		_mask = rgba;
		var argb = threshold;
		var this1 = 0;
		var rgba = this1;
		rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
		_threshold = rgba;
		break;
	case 2:
		var bgra = color;
		var this1 = 0;
		var rgba = this1;
		rgba = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		_color = rgba;
		var bgra = mask;
		var this1 = 0;
		var rgba = this1;
		rgba = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		_mask = rgba;
		var bgra = threshold;
		var this1 = 0;
		var rgba = this1;
		rgba = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
		_threshold = rgba;
		break;
	default:
		_color = color;
		_mask = mask;
		_threshold = threshold;
	}
	var _operation;
	switch(operation) {
	case "!=":
		_operation = 0;
		break;
	case "<":
		_operation = 2;
		break;
	case "<=":
		_operation = 3;
		break;
	case "==":
		_operation = 1;
		break;
	case ">":
		_operation = 4;
		break;
	case ">=":
		_operation = 5;
		break;
	default:
		_operation = -1;
	}
	if(_operation == -1) {
		return 0;
	}
	var srcData = sourceImage.buffer.data;
	var destData = image.buffer.data;
	if(srcData == null || destData == null) {
		return 0;
	}
	var hits = 0;
	var srcView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(sourceImage,sourceRect);
	var destView = new lime__$internal_graphics__$ImageDataUtil_ImageDataView(image,new lime_math_Rectangle(destPoint.x,destPoint.y,srcView.width,srcView.height));
	var srcFormat = sourceImage.buffer.format;
	var destFormat = image.buffer.format;
	var srcPremultiplied = sourceImage.buffer.premultiplied;
	var destPremultiplied = image.buffer.premultiplied;
	var srcPosition;
	var destPosition;
	var srcPixel = 0;
	var destPixel = 0;
	var pixelMask;
	var test;
	var value;
	var _g = 0;
	var _g1 = destView.height;
	while(_g < _g1) {
		var y = _g++;
		srcPosition = srcView.byteOffset + srcView.stride * y;
		destPosition = destView.byteOffset + destView.stride * y;
		var _g2 = 0;
		var _g3 = destView.width;
		while(_g2 < _g3) {
			var x = _g2++;
			var format = srcFormat;
			var premultiplied = srcPremultiplied;
			if(premultiplied == null) {
				premultiplied = false;
			}
			if(format == null) {
				format = 0;
			}
			switch(format) {
			case 0:
				srcPixel = (srcData[srcPosition] & 255) << 24 | (srcData[srcPosition + 1] & 255) << 16 | (srcData[srcPosition + 2] & 255) << 8 | srcData[srcPosition + 3] & 255;
				break;
			case 1:
				srcPixel = (srcData[srcPosition + 1] & 255) << 24 | (srcData[srcPosition + 2] & 255) << 16 | (srcData[srcPosition + 3] & 255) << 8 | srcData[srcPosition] & 255;
				break;
			case 2:
				srcPixel = (srcData[srcPosition + 2] & 255) << 24 | (srcData[srcPosition + 1] & 255) << 16 | (srcData[srcPosition] & 255) << 8 | srcData[srcPosition + 3] & 255;
				break;
			}
			if(premultiplied) {
				if((srcPixel & 255) != 0 && (srcPixel & 255) != 255) {
					lime_math_RGBA.unmult = 255.0 / (srcPixel & 255);
					srcPixel = (lime_math_RGBA.__clamp[Math.round((srcPixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((srcPixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((srcPixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | srcPixel & 255 & 255;
				}
			}
			pixelMask = srcPixel & _mask;
			var tmp1 = pixelMask >>> 24 & 255;
			var tmp2 = _threshold >>> 24 & 255;
			if(tmp1 != tmp2) {
				value = UInt.gt(tmp1,tmp2) ? 1 : -1;
			} else {
				tmp1 = pixelMask >>> 16 & 255;
				tmp2 = _threshold >>> 16 & 255;
				if(tmp1 != tmp2) {
					value = UInt.gt(tmp1,tmp2) ? 1 : -1;
				} else {
					tmp1 = pixelMask >>> 8 & 255;
					tmp2 = _threshold >>> 8 & 255;
					if(tmp1 != tmp2) {
						value = UInt.gt(tmp1,tmp2) ? 1 : -1;
					} else {
						tmp1 = pixelMask & 255;
						tmp2 = _threshold & 255;
						value = tmp1 != tmp2 ? UInt.gt(tmp1,tmp2) ? 1 : -1 : 0;
					}
				}
			}
			switch(_operation) {
			case 0:
				test = value != 0;
				break;
			case 1:
				test = value == 0;
				break;
			case 2:
				test = value == -1;
				break;
			case 3:
				test = value == 0 || value == -1;
				break;
			case 4:
				test = value == 1;
				break;
			case 5:
				test = value == 0 || value == 1;
				break;
			default:
				test = false;
			}
			if(test) {
				var format1 = destFormat;
				var premultiplied1 = destPremultiplied;
				if(premultiplied1 == null) {
					premultiplied1 = false;
				}
				if(format1 == null) {
					format1 = 0;
				}
				if(premultiplied1) {
					if((_color & 255) == 0) {
						if(_color != 0) {
							_color = 0;
						}
					} else if((_color & 255) != 255) {
						lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[_color & 255];
						_color = ((_color >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((_color >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((_color >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | _color & 255 & 255;
					}
				}
				switch(format1) {
				case 0:
					destData[destPosition] = _color >>> 24 & 255;
					destData[destPosition + 1] = _color >>> 16 & 255;
					destData[destPosition + 2] = _color >>> 8 & 255;
					destData[destPosition + 3] = _color & 255;
					break;
				case 1:
					destData[destPosition] = _color & 255;
					destData[destPosition + 1] = _color >>> 24 & 255;
					destData[destPosition + 2] = _color >>> 16 & 255;
					destData[destPosition + 3] = _color >>> 8 & 255;
					break;
				case 2:
					destData[destPosition] = _color >>> 8 & 255;
					destData[destPosition + 1] = _color >>> 16 & 255;
					destData[destPosition + 2] = _color >>> 24 & 255;
					destData[destPosition + 3] = _color & 255;
					break;
				}
				++hits;
			} else if(copySource) {
				var format2 = destFormat;
				var premultiplied2 = destPremultiplied;
				if(premultiplied2 == null) {
					premultiplied2 = false;
				}
				if(format2 == null) {
					format2 = 0;
				}
				if(premultiplied2) {
					if((srcPixel & 255) == 0) {
						if(srcPixel != 0) {
							srcPixel = 0;
						}
					} else if((srcPixel & 255) != 255) {
						lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[srcPixel & 255];
						srcPixel = ((srcPixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((srcPixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((srcPixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | srcPixel & 255 & 255;
					}
				}
				switch(format2) {
				case 0:
					destData[destPosition] = srcPixel >>> 24 & 255;
					destData[destPosition + 1] = srcPixel >>> 16 & 255;
					destData[destPosition + 2] = srcPixel >>> 8 & 255;
					destData[destPosition + 3] = srcPixel & 255;
					break;
				case 1:
					destData[destPosition] = srcPixel & 255;
					destData[destPosition + 1] = srcPixel >>> 24 & 255;
					destData[destPosition + 2] = srcPixel >>> 16 & 255;
					destData[destPosition + 3] = srcPixel >>> 8 & 255;
					break;
				case 2:
					destData[destPosition] = srcPixel >>> 8 & 255;
					destData[destPosition + 1] = srcPixel >>> 16 & 255;
					destData[destPosition + 2] = srcPixel >>> 24 & 255;
					destData[destPosition + 3] = srcPixel & 255;
					break;
				}
			}
			srcPosition += 4;
			destPosition += 4;
		}
	}
	if(hits > 0) {
		image.dirty = true;
		image.version++;
	}
	return hits;
};
lime__$internal_graphics_ImageDataUtil.unmultiplyAlpha = function(image) {
	var data = image.buffer.data;
	if(data == null) {
		return;
	}
	var format = image.buffer.format;
	var length = data.length / 4 | 0;
	var pixel = 0;
	var _g = 0;
	var _g1 = length;
	while(_g < _g1) {
		var i = _g++;
		var offset = i * 4;
		var format1 = format;
		var premultiplied = true;
		if(premultiplied == null) {
			premultiplied = false;
		}
		if(format1 == null) {
			format1 = 0;
		}
		switch(format1) {
		case 0:
			pixel = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
			break;
		case 1:
			pixel = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
			break;
		case 2:
			pixel = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
			break;
		}
		if(premultiplied) {
			if((pixel & 255) != 0 && (pixel & 255) != 255) {
				lime_math_RGBA.unmult = 255.0 / (pixel & 255);
				pixel = (lime_math_RGBA.__clamp[Math.round((pixel >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((pixel >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | pixel & 255 & 255;
			}
		}
		var offset1 = i * 4;
		var format2 = format;
		var premultiplied1 = false;
		if(premultiplied1 == null) {
			premultiplied1 = false;
		}
		if(format2 == null) {
			format2 = 0;
		}
		if(premultiplied1) {
			if((pixel & 255) == 0) {
				if(pixel != 0) {
					pixel = 0;
				}
			} else if((pixel & 255) != 255) {
				lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[pixel & 255];
				pixel = ((pixel >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((pixel >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((pixel >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | pixel & 255 & 255;
			}
		}
		switch(format2) {
		case 0:
			data[offset1] = pixel >>> 24 & 255;
			data[offset1 + 1] = pixel >>> 16 & 255;
			data[offset1 + 2] = pixel >>> 8 & 255;
			data[offset1 + 3] = pixel & 255;
			break;
		case 1:
			data[offset1] = pixel & 255;
			data[offset1 + 1] = pixel >>> 24 & 255;
			data[offset1 + 2] = pixel >>> 16 & 255;
			data[offset1 + 3] = pixel >>> 8 & 255;
			break;
		case 2:
			data[offset1] = pixel >>> 8 & 255;
			data[offset1 + 1] = pixel >>> 16 & 255;
			data[offset1 + 2] = pixel >>> 24 & 255;
			data[offset1 + 3] = pixel & 255;
			break;
		}
	}
	image.buffer.premultiplied = false;
	image.dirty = true;
	image.version++;
};
lime__$internal_graphics_ImageDataUtil.__boxBlur = function(imgA,imgB,w,h,bx,by) {
	imgB.set(imgA);
	var bx1 = bx | 0;
	var by1 = by | 0;
	lime__$internal_graphics_ImageDataUtil.__boxBlurH(imgB,imgA,w,h,bx1,0);
	lime__$internal_graphics_ImageDataUtil.__boxBlurH(imgB,imgA,w,h,bx1,1);
	lime__$internal_graphics_ImageDataUtil.__boxBlurH(imgB,imgA,w,h,bx1,2);
	lime__$internal_graphics_ImageDataUtil.__boxBlurH(imgB,imgA,w,h,bx1,3);
	var iarr = 1 / (by1 + by1 + 1);
	var ws = w * 4;
	var ti;
	var li;
	var ri;
	var fv;
	var lv;
	var val;
	var _g = 0;
	var _g1 = w;
	while(_g < _g1) {
		var i = _g++;
		ti = i * 4;
		li = ti;
		ri = ti + by1 * ws;
		fv = imgA[ti];
		lv = imgA[ti + ws * (h - 1)];
		val = (by1 + 1) * fv;
		var _g2 = 0;
		var _g3 = by1;
		while(_g2 < _g3) {
			var j = _g2++;
			val = val + imgA[ti + j * ws];
		}
		var _g4 = 0;
		var _g5 = by1 + 1;
		while(_g4 < _g5) {
			var j1 = _g4++;
			val = val + (imgA[ri] - fv);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			ri += ws;
			ti += ws;
		}
		var _g6 = by1 + 1;
		var _g7 = h - by1;
		while(_g6 < _g7) {
			var j2 = _g6++;
			val = val + (imgA[ri] - imgA[li]);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			li += ws;
			ri += ws;
			ti += ws;
		}
		var _g8 = h - by1;
		var _g9 = h;
		while(_g8 < _g9) {
			var j3 = _g8++;
			val = val + (lv - imgA[li]);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			li += ws;
			ti += ws;
		}
	}
	var iarr = 1 / (by1 + by1 + 1);
	var ws = w * 4;
	var ti;
	var li;
	var ri;
	var fv;
	var lv;
	var val;
	var _g = 0;
	var _g1 = w;
	while(_g < _g1) {
		var i = _g++;
		ti = i * 4 + 1;
		li = ti;
		ri = ti + by1 * ws;
		fv = imgA[ti];
		lv = imgA[ti + ws * (h - 1)];
		val = (by1 + 1) * fv;
		var _g2 = 0;
		var _g3 = by1;
		while(_g2 < _g3) {
			var j = _g2++;
			val = val + imgA[ti + j * ws];
		}
		var _g4 = 0;
		var _g5 = by1 + 1;
		while(_g4 < _g5) {
			var j1 = _g4++;
			val = val + (imgA[ri] - fv);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			ri += ws;
			ti += ws;
		}
		var _g6 = by1 + 1;
		var _g7 = h - by1;
		while(_g6 < _g7) {
			var j2 = _g6++;
			val = val + (imgA[ri] - imgA[li]);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			li += ws;
			ri += ws;
			ti += ws;
		}
		var _g8 = h - by1;
		var _g9 = h;
		while(_g8 < _g9) {
			var j3 = _g8++;
			val = val + (lv - imgA[li]);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			li += ws;
			ti += ws;
		}
	}
	var iarr = 1 / (by1 + by1 + 1);
	var ws = w * 4;
	var ti;
	var li;
	var ri;
	var fv;
	var lv;
	var val;
	var _g = 0;
	var _g1 = w;
	while(_g < _g1) {
		var i = _g++;
		ti = i * 4 + 2;
		li = ti;
		ri = ti + by1 * ws;
		fv = imgA[ti];
		lv = imgA[ti + ws * (h - 1)];
		val = (by1 + 1) * fv;
		var _g2 = 0;
		var _g3 = by1;
		while(_g2 < _g3) {
			var j = _g2++;
			val = val + imgA[ti + j * ws];
		}
		var _g4 = 0;
		var _g5 = by1 + 1;
		while(_g4 < _g5) {
			var j1 = _g4++;
			val = val + (imgA[ri] - fv);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			ri += ws;
			ti += ws;
		}
		var _g6 = by1 + 1;
		var _g7 = h - by1;
		while(_g6 < _g7) {
			var j2 = _g6++;
			val = val + (imgA[ri] - imgA[li]);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			li += ws;
			ri += ws;
			ti += ws;
		}
		var _g8 = h - by1;
		var _g9 = h;
		while(_g8 < _g9) {
			var j3 = _g8++;
			val = val + (lv - imgA[li]);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			li += ws;
			ti += ws;
		}
	}
	var iarr = 1 / (by1 + by1 + 1);
	var ws = w * 4;
	var ti;
	var li;
	var ri;
	var fv;
	var lv;
	var val;
	var _g = 0;
	var _g1 = w;
	while(_g < _g1) {
		var i = _g++;
		ti = i * 4 + 3;
		li = ti;
		ri = ti + by1 * ws;
		fv = imgA[ti];
		lv = imgA[ti + ws * (h - 1)];
		val = (by1 + 1) * fv;
		var _g2 = 0;
		var _g3 = by1;
		while(_g2 < _g3) {
			var j = _g2++;
			val = val + imgA[ti + j * ws];
		}
		var _g4 = 0;
		var _g5 = by1 + 1;
		while(_g4 < _g5) {
			var j1 = _g4++;
			val = val + (imgA[ri] - fv);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			ri += ws;
			ti += ws;
		}
		var _g6 = by1 + 1;
		var _g7 = h - by1;
		while(_g6 < _g7) {
			var j2 = _g6++;
			val = val + (imgA[ri] - imgA[li]);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			li += ws;
			ri += ws;
			ti += ws;
		}
		var _g8 = h - by1;
		var _g9 = h;
		while(_g8 < _g9) {
			var j3 = _g8++;
			val = val + (lv - imgA[li]);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			li += ws;
			ti += ws;
		}
	}
};
lime__$internal_graphics_ImageDataUtil.__boxBlurH = function(imgA,imgB,w,h,r,off) {
	var iarr = 1 / (r + r + 1);
	var ti;
	var li;
	var ri;
	var fv;
	var lv;
	var val;
	var _g = 0;
	var _g1 = h;
	while(_g < _g1) {
		var i = _g++;
		ti = i * w;
		li = ti;
		ri = ti + r;
		fv = imgA[ti * 4 + off];
		lv = imgA[(ti + w - 1) * 4 + off];
		val = (r + 1) * fv;
		var _g2 = 0;
		var _g3 = r;
		while(_g2 < _g3) {
			var j = _g2++;
			val = val + imgA[(ti + j) * 4 + off];
		}
		var _g4 = 0;
		var _g5 = r + 1;
		while(_g4 < _g5) {
			var j1 = _g4++;
			val = val + (imgA[ri * 4 + off] - fv);
			imgB[ti * 4 + off] = Math.round(UInt.toFloat(val) * iarr);
			++ri;
			++ti;
		}
		var _g6 = r + 1;
		var _g7 = w - r;
		while(_g6 < _g7) {
			var j2 = _g6++;
			val = val + (imgA[ri * 4 + off] - imgA[li * 4 + off]);
			imgB[ti * 4 + off] = Math.round(UInt.toFloat(val) * iarr);
			++ri;
			++li;
			++ti;
		}
		var _g8 = w - r;
		var _g9 = w;
		while(_g8 < _g9) {
			var j3 = _g8++;
			val = val + (lv - imgA[li * 4 + off]);
			imgB[ti * 4 + off] = Math.round(UInt.toFloat(val) * iarr);
			++li;
			++ti;
		}
	}
};
lime__$internal_graphics_ImageDataUtil.__boxBlurT = function(imgA,imgB,w,h,r,off) {
	var iarr = 1 / (r + r + 1);
	var ws = w * 4;
	var ti;
	var li;
	var ri;
	var fv;
	var lv;
	var val;
	var _g = 0;
	var _g1 = w;
	while(_g < _g1) {
		var i = _g++;
		ti = i * 4 + off;
		li = ti;
		ri = ti + r * ws;
		fv = imgA[ti];
		lv = imgA[ti + ws * (h - 1)];
		val = (r + 1) * fv;
		var _g2 = 0;
		var _g3 = r;
		while(_g2 < _g3) {
			var j = _g2++;
			val = val + imgA[ti + j * ws];
		}
		var _g4 = 0;
		var _g5 = r + 1;
		while(_g4 < _g5) {
			var j1 = _g4++;
			val = val + (imgA[ri] - fv);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			ri += ws;
			ti += ws;
		}
		var _g6 = r + 1;
		var _g7 = h - r;
		while(_g6 < _g7) {
			var j2 = _g6++;
			val = val + (imgA[ri] - imgA[li]);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			li += ws;
			ri += ws;
			ti += ws;
		}
		var _g8 = h - r;
		var _g9 = h;
		while(_g8 < _g9) {
			var j3 = _g8++;
			val = val + (lv - imgA[li]);
			imgB[ti] = Math.round(UInt.toFloat(val) * iarr);
			li += ws;
			ti += ws;
		}
	}
};
lime__$internal_graphics_ImageDataUtil.__calculateSourceOffset = function(sourceRect,destPoint,destX,destY) {
	var sourceX = destX - (destPoint.x | 0);
	var sourceY = destY - (destPoint.y | 0);
	var offset = 0;
	if(sourceX < 0 || sourceY < 0 || sourceX >= sourceRect.width || sourceY >= sourceRect.height) {
		offset = -1;
	} else {
		offset = 4 * (sourceY * (sourceRect.width | 0) + sourceX);
	}
	return offset;
};
lime__$internal_graphics_ImageDataUtil.__getBoxesForGaussianBlur = function(sigma,n) {
	var wIdeal = Math.sqrt(12 * sigma * sigma / n + 1);
	var wl = Math.floor(wIdeal);
	if(wl % 2 == 0) {
		--wl;
	}
	var wu = wl + 2;
	var mIdeal = (12 * sigma * sigma - n * wl * wl - 4 * n * wl - 3 * n) / (-4 * wl - 4);
	var m = Math.round(mIdeal);
	var sizes = [];
	var _g = 0;
	var _g1 = n;
	while(_g < _g1) {
		var i = _g++;
		sizes.push(i < m ? wl : wu);
	}
	return sizes;
};
lime__$internal_graphics_ImageDataUtil.__pixelCompare = function(n1,n2) {
	var tmp1 = n1 >>> 24 & 255;
	var tmp2 = n2 >>> 24 & 255;
	if(tmp1 != tmp2) {
		if(UInt.gt(tmp1,tmp2)) {
			return 1;
		} else {
			return -1;
		}
	} else {
		tmp1 = n1 >>> 16 & 255;
		tmp2 = n2 >>> 16 & 255;
		if(tmp1 != tmp2) {
			if(UInt.gt(tmp1,tmp2)) {
				return 1;
			} else {
				return -1;
			}
		} else {
			tmp1 = n1 >>> 8 & 255;
			tmp2 = n2 >>> 8 & 255;
			if(tmp1 != tmp2) {
				if(UInt.gt(tmp1,tmp2)) {
					return 1;
				} else {
					return -1;
				}
			} else {
				tmp1 = n1 & 255;
				tmp2 = n2 & 255;
				if(tmp1 != tmp2) {
					if(UInt.gt(tmp1,tmp2)) {
						return 1;
					} else {
						return -1;
					}
				} else {
					return 0;
				}
			}
		}
	}
};
lime__$internal_graphics_ImageDataUtil.__translatePixel = function(imgB,sourceRect,destRect,destPoint,destX,destY,strength) {
	var d = 4 * (destY * (destRect.width | 0) + destX);
	var s = lime__$internal_graphics_ImageDataUtil.__calculateSourceOffset(sourceRect,destPoint,destX,destY);
	if(s < 0) {
		imgB[d] = imgB[d + 1] = imgB[d + 2] = imgB[d + 3] = 0;
	} else {
		imgB[d] = imgB[s];
		imgB[d + 1] = imgB[s + 1];
		imgB[d + 2] = imgB[s + 2];
		var a = UInt.toFloat(imgB[s + 3]) * strength | 0;
		imgB[d + 3] = a < 0 ? 0 : a > 255 ? 255 : a;
	}
};
var lime__$internal_graphics__$ImageDataUtil_ImageDataView = function(image,rect) {
	this.image = image;
	if(rect == null) {
		this.rect = image.get_rect();
	} else {
		if(rect.x < 0) {
			rect.x = 0;
		}
		if(rect.y < 0) {
			rect.y = 0;
		}
		if(rect.x + rect.width > image.width) {
			rect.width = image.width - rect.x;
		}
		if(rect.y + rect.height > image.height) {
			rect.height = image.height - rect.y;
		}
		if(rect.width < 0) {
			rect.width = 0;
		}
		if(rect.height < 0) {
			rect.height = 0;
		}
		this.rect = rect;
	}
	this.stride = image.buffer.get_stride();
	this.__update();
};
$hxClasses["lime._internal.graphics._ImageDataUtil.ImageDataView"] = lime__$internal_graphics__$ImageDataUtil_ImageDataView;
lime__$internal_graphics__$ImageDataUtil_ImageDataView.__name__ = "lime._internal.graphics._ImageDataUtil.ImageDataView";
lime__$internal_graphics__$ImageDataUtil_ImageDataView.prototype = {
	clip: function(x,y,width,height) {
		if(this.tempRect == null) {
			this.tempRect = new lime_math_Rectangle();
		}
		this.tempRect.setTo(x,y,width,height);
		this.rect.intersection(this.tempRect,this.rect);
		this.__update();
	}
	,hasRow: function(y) {
		if(y >= 0) {
			return y < this.height;
		} else {
			return false;
		}
	}
	,offset: function(x,y) {
		if(x < 0) {
			this.rect.x += x;
			if(this.rect.x < 0) {
				this.rect.x = 0;
			}
		} else {
			this.rect.x += x;
			this.rect.width -= x;
		}
		if(y < 0) {
			this.rect.y += y;
			if(this.rect.y < 0) {
				this.rect.y = 0;
			}
		} else {
			this.rect.y += y;
			this.rect.height -= y;
		}
		this.__update();
	}
	,row: function(y) {
		return this.byteOffset + this.stride * y;
	}
	,__update: function() {
		this.x = Math.ceil(this.rect.x);
		this.y = Math.ceil(this.rect.y);
		this.width = Math.floor(this.rect.width);
		this.height = Math.floor(this.rect.height);
		this.byteOffset = this.stride * (this.y + this.image.offsetY) + (this.x + this.image.offsetX) * 4;
	}
	,__class__: lime__$internal_graphics__$ImageDataUtil_ImageDataView
};
var lime__$internal_graphics_StackBlur = function() { };
$hxClasses["lime._internal.graphics.StackBlur"] = lime__$internal_graphics_StackBlur;
lime__$internal_graphics_StackBlur.__name__ = "lime._internal.graphics.StackBlur";
lime__$internal_graphics_StackBlur.blur = function(dest,source,sourceRect,destPoint,blurX,blurY,quality) {
	dest.copyPixels(source,sourceRect,destPoint);
	lime__$internal_graphics_StackBlur.__stackBlurCanvasRGBA(dest,sourceRect.width | 0,sourceRect.height | 0,blurX,blurY,quality);
};
lime__$internal_graphics_StackBlur.__stackBlurCanvasRGBA = function(image,width,height,blurX,blurY,quality) {
	var radiusX = Math.round(blurX) >> 1;
	var radiusY = Math.round(blurY) >> 1;
	if(lime__$internal_graphics_StackBlur.MUL_TABLE == null) {
		return;
	}
	if(radiusX >= lime__$internal_graphics_StackBlur.MUL_TABLE.length) {
		radiusX = lime__$internal_graphics_StackBlur.MUL_TABLE.length - 1;
	}
	if(radiusY >= lime__$internal_graphics_StackBlur.MUL_TABLE.length) {
		radiusY = lime__$internal_graphics_StackBlur.MUL_TABLE.length - 1;
	}
	if(radiusX < 0 || radiusY < 0) {
		return;
	}
	var iterations = quality;
	if(iterations < 1) {
		iterations = 1;
	}
	if(iterations > 3) {
		iterations = 3;
	}
	var px = image.get_data();
	var x;
	var y;
	var i;
	var p;
	var yp;
	var yi;
	var yw;
	var r;
	var g;
	var b;
	var a;
	var pr;
	var pg;
	var pb;
	var pa;
	var f;
	var divx = radiusX + radiusX + 1;
	var divy = radiusY + radiusY + 1;
	var w = width;
	var h = height;
	var w1 = w - 1;
	var h1 = h - 1;
	var rxp1 = radiusX + 1;
	var ryp1 = radiusY + 1;
	var ssx = new lime__$internal_graphics_BlurStack();
	var sx = ssx;
	var _g = 1;
	var _g1 = divx;
	while(_g < _g1) {
		var i1 = _g++;
		sx = sx.n = new lime__$internal_graphics_BlurStack();
	}
	sx.n = ssx;
	var ssy = new lime__$internal_graphics_BlurStack();
	var sy = ssy;
	var _g = 1;
	var _g1 = divy;
	while(_g < _g1) {
		var i1 = _g++;
		sy = sy.n = new lime__$internal_graphics_BlurStack();
	}
	sy.n = ssy;
	var si = null;
	var mtx = lime__$internal_graphics_StackBlur.MUL_TABLE[radiusX];
	var stx = lime__$internal_graphics_StackBlur.SHG_TABLE[radiusX];
	var mty = lime__$internal_graphics_StackBlur.MUL_TABLE[radiusY];
	var sty = lime__$internal_graphics_StackBlur.SHG_TABLE[radiusY];
	while(iterations > 0) {
		--iterations;
		yi = 0;
		yw = yi;
		var ms = mtx;
		var ss = stx;
		y = h;
		while(true) {
			pr = px[yi];
			r = rxp1 * pr;
			pg = px[yi + 1];
			g = rxp1 * pg;
			pb = px[yi + 2];
			b = rxp1 * pb;
			pa = px[yi + 3];
			a = rxp1 * pa;
			sx = ssx;
			i = rxp1;
			while(true) {
				sx.r = pr;
				sx.g = pg;
				sx.b = pb;
				sx.a = pa;
				sx = sx.n;
				if(!(--i > -1)) {
					break;
				}
			}
			var _g = 1;
			var _g1 = rxp1;
			while(_g < _g1) {
				var i1 = _g++;
				p = yi + ((w1 < i1 ? w1 : i1) << 2);
				r += sx.r = px[p];
				g += sx.g = px[p + 1];
				b += sx.b = px[p + 2];
				a += sx.a = px[p + 3];
				sx = sx.n;
			}
			si = ssx;
			var _g2 = 0;
			var _g3 = w;
			while(_g2 < _g3) {
				var x = _g2++;
				px[yi++] = r * ms >>> ss;
				px[yi++] = g * ms >>> ss;
				px[yi++] = b * ms >>> ss;
				px[yi++] = a * ms >>> ss;
				p = x + radiusX + 1;
				p = yw + (p < w1 ? p : w1) << 2;
				r -= si.r - (si.r = px[p]);
				g -= si.g - (si.g = px[p + 1]);
				b -= si.b - (si.b = px[p + 2]);
				a -= si.a - (si.a = px[p + 3]);
				si = si.n;
			}
			yw += w;
			if(!(--y > 0)) {
				break;
			}
		}
		ms = mty;
		ss = sty;
		var _g4 = 0;
		var _g5 = w;
		while(_g4 < _g5) {
			var x1 = _g4++;
			yi = x1 << 2;
			pr = px[yi];
			r = ryp1 * pr;
			pg = px[yi + 1];
			g = ryp1 * pg;
			pb = px[yi + 2];
			b = ryp1 * pb;
			pa = px[yi + 3];
			a = ryp1 * pa;
			sy = ssy;
			var _g6 = 0;
			var _g7 = ryp1;
			while(_g6 < _g7) {
				var i2 = _g6++;
				sy.r = pr;
				sy.g = pg;
				sy.b = pb;
				sy.a = pa;
				sy = sy.n;
			}
			yp = w;
			var _g8 = 1;
			var _g9 = radiusY + 1;
			while(_g8 < _g9) {
				var i3 = _g8++;
				yi = yp + x1 << 2;
				r += sy.r = px[yi];
				g += sy.g = px[yi + 1];
				b += sy.b = px[yi + 2];
				a += sy.a = px[yi + 3];
				sy = sy.n;
				if(i3 < h1) {
					yp += w;
				}
			}
			yi = x1;
			si = ssy;
			if(iterations > 0) {
				var _g10 = 0;
				var _g11 = h;
				while(_g10 < _g11) {
					var y1 = _g10++;
					p = yi << 2;
					pa = a * ms >>> ss;
					px[p + 3] = pa;
					if(pa > 0) {
						px[p] = r * ms >>> ss;
						px[p + 1] = g * ms >>> ss;
						px[p + 2] = b * ms >>> ss;
					} else {
						px[p] = px[p + 1] = px[p + 2] = 0;
					}
					p = y1 + ryp1;
					p = x1 + (p < h1 ? p : h1) * w << 2;
					r -= si.r - (si.r = px[p]);
					g -= si.g - (si.g = px[p + 1]);
					b -= si.b - (si.b = px[p + 2]);
					a -= si.a - (si.a = px[p + 3]);
					si = si.n;
					yi += w;
				}
			} else {
				var _g12 = 0;
				var _g13 = h;
				while(_g12 < _g13) {
					var y2 = _g12++;
					p = yi << 2;
					pa = a * ms >>> ss;
					px[p + 3] = pa;
					if(pa > 0) {
						f = 255 / pa;
						pr = (r * ms >>> ss) * f | 0;
						pg = (g * ms >>> ss) * f | 0;
						pb = (b * ms >>> ss) * f | 0;
						px[p] = pr > 255 ? 255 : pr;
						px[p + 1] = pg > 255 ? 255 : pg;
						px[p + 2] = pb > 255 ? 255 : pb;
					} else {
						px[p] = px[p + 1] = px[p + 2] = 0;
					}
					p = y2 + ryp1;
					p = x1 + (p < h1 ? p : h1) * w << 2;
					r -= si.r - (si.r = px[p]);
					g -= si.g - (si.g = px[p + 1]);
					b -= si.b - (si.b = px[p + 2]);
					a -= si.a - (si.a = px[p + 3]);
					si = si.n;
					yi += w;
				}
			}
		}
	}
};
var lime__$internal_graphics_BlurStack = function() {
	this.r = 0;
	this.g = 0;
	this.b = 0;
	this.a = 0;
	this.n = null;
};
$hxClasses["lime._internal.graphics.BlurStack"] = lime__$internal_graphics_BlurStack;
lime__$internal_graphics_BlurStack.__name__ = "lime._internal.graphics.BlurStack";
lime__$internal_graphics_BlurStack.prototype = {
	__class__: lime__$internal_graphics_BlurStack
};
var lime__$internal_macros_AssetsMacro = function() { };
$hxClasses["lime._internal.macros.AssetsMacro"] = lime__$internal_macros_AssetsMacro;
lime__$internal_macros_AssetsMacro.__name__ = "lime._internal.macros.AssetsMacro";
var lime_app_Event = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app.Event"] = lime_app_Event;
lime_app_Event.__name__ = "lime.app.Event";
lime_app_Event.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,__class__: lime_app_Event
};
var lime_app_Future = function(work,async) {
	if(async == null) {
		async = false;
	}
	if(work != null) {
		if(async) {
			var promise = new lime_app_Promise();
			promise.future = this;
			lime_app__$Future_FutureWork.queue({ promise : promise, work : work});
		} else {
			try {
				this.value = work();
				this.isComplete = true;
			} catch( _g ) {
				haxe_NativeStackTrace.lastError = _g;
				var e = haxe_Exception.caught(_g).unwrap();
				this.error = e;
				this.isError = true;
			}
		}
	}
};
$hxClasses["lime.app.Future"] = lime_app_Future;
lime_app_Future.__name__ = "lime.app.Future";
lime_app_Future.ofEvents = function(onComplete,onError,onProgress) {
	var promise = new lime_app_Promise();
	onComplete.add(function(data) {
		promise.complete(data);
	},true);
	if(onError != null) {
		onError.add(function(error) {
			promise.error(error);
		},true);
	}
	if(onProgress != null) {
		onProgress.add(function(progress,total) {
			promise.progress(progress,total);
		},true);
	}
	return promise.future;
};
lime_app_Future.withError = function(error) {
	var future = new lime_app_Future();
	future.isError = true;
	future.error = error;
	return future;
};
lime_app_Future.withValue = function(value) {
	var future = new lime_app_Future();
	future.isComplete = true;
	future.value = value;
	return future;
};
lime_app_Future.prototype = {
	onComplete: function(listener) {
		if(listener != null) {
			if(this.isComplete) {
				listener(this.value);
			} else if(!this.isError) {
				if(this.__completeListeners == null) {
					this.__completeListeners = [];
				}
				this.__completeListeners.push(listener);
			}
		}
		return this;
	}
	,onError: function(listener) {
		if(listener != null) {
			if(this.isError) {
				listener(this.error);
			} else if(!this.isComplete) {
				if(this.__errorListeners == null) {
					this.__errorListeners = [];
				}
				this.__errorListeners.push(listener);
			}
		}
		return this;
	}
	,onProgress: function(listener) {
		if(listener != null) {
			if(this.__progressListeners == null) {
				this.__progressListeners = [];
			}
			this.__progressListeners.push(listener);
		}
		return this;
	}
	,ready: function(waitTime) {
		if(waitTime == null) {
			waitTime = -1;
		}
		if(this.isComplete || this.isError) {
			return this;
		} else {
			lime_utils_Log.warn("Cannot block thread in JavaScript",{ fileName : "lime/app/Future.hx", lineNumber : 208, className : "lime.app.Future", methodName : "ready"});
			return this;
		}
	}
	,result: function(waitTime) {
		if(waitTime == null) {
			waitTime = -1;
		}
		this.ready(waitTime);
		if(this.isComplete) {
			return this.value;
		} else {
			return null;
		}
	}
	,then: function(next) {
		if(this.isComplete) {
			return next(this.value);
		} else if(this.isError) {
			var future = new lime_app_Future();
			future.isError = true;
			future.error = this.error;
			return future;
		} else {
			var promise = new lime_app_Promise();
			this.onError($bind(promise,promise.error));
			this.onProgress($bind(promise,promise.progress));
			this.onComplete(function(val) {
				var future = next(val);
				future.onError($bind(promise,promise.error));
				future.onComplete($bind(promise,promise.complete));
			});
			return promise.future;
		}
	}
	,__class__: lime_app_Future
};
var lime_app__$Future_FutureWork = function() { };
$hxClasses["lime.app._Future.FutureWork"] = lime_app__$Future_FutureWork;
lime_app__$Future_FutureWork.__name__ = "lime.app._Future.FutureWork";
lime_app__$Future_FutureWork.queue = function(state) {
	if(lime_app__$Future_FutureWork.threadPool == null) {
		lime_app__$Future_FutureWork.threadPool = new lime_system_ThreadPool();
		lime_app__$Future_FutureWork.threadPool.doWork.add(lime_app__$Future_FutureWork.threadPool_doWork);
		lime_app__$Future_FutureWork.threadPool.onComplete.add(lime_app__$Future_FutureWork.threadPool_onComplete);
		lime_app__$Future_FutureWork.threadPool.onError.add(lime_app__$Future_FutureWork.threadPool_onError);
	}
	lime_app__$Future_FutureWork.threadPool.queue(state);
};
lime_app__$Future_FutureWork.threadPool_doWork = function(state) {
	try {
		var result = state.work();
		lime_app__$Future_FutureWork.threadPool.sendComplete({ promise : state.promise, result : result});
	} catch( _g ) {
		haxe_NativeStackTrace.lastError = _g;
		var e = haxe_Exception.caught(_g).unwrap();
		lime_app__$Future_FutureWork.threadPool.sendError({ promise : state.promise, error : e});
	}
};
lime_app__$Future_FutureWork.threadPool_onComplete = function(state) {
	state.promise.complete(state.result);
};
lime_app__$Future_FutureWork.threadPool_onError = function(state) {
	state.promise.error(state.error);
};
var lime_app_Promise = function() {
	this.future = new lime_app_Future();
};
$hxClasses["lime.app.Promise"] = lime_app_Promise;
lime_app_Promise.__name__ = "lime.app.Promise";
lime_app_Promise.prototype = {
	complete: function(data) {
		if(!this.future.isError) {
			this.future.isComplete = true;
			this.future.value = data;
			if(this.future.__completeListeners != null) {
				var _g = 0;
				var _g1 = this.future.__completeListeners;
				while(_g < _g1.length) {
					var listener = _g1[_g];
					++_g;
					listener(data);
				}
				this.future.__completeListeners = null;
			}
		}
		return this;
	}
	,completeWith: function(future) {
		future.onComplete($bind(this,this.complete));
		future.onError($bind(this,this.error));
		future.onProgress($bind(this,this.progress));
		return this;
	}
	,error: function(msg) {
		if(!this.future.isComplete) {
			this.future.isError = true;
			this.future.error = msg;
			if(this.future.__errorListeners != null) {
				var _g = 0;
				var _g1 = this.future.__errorListeners;
				while(_g < _g1.length) {
					var listener = _g1[_g];
					++_g;
					listener(msg);
				}
				this.future.__errorListeners = null;
			}
		}
		return this;
	}
	,progress: function(progress,total) {
		if(!this.future.isError && !this.future.isComplete) {
			if(this.future.__progressListeners != null) {
				var _g = 0;
				var _g1 = this.future.__progressListeners;
				while(_g < _g1.length) {
					var listener = _g1[_g];
					++_g;
					listener(progress,total);
				}
			}
		}
		return this;
	}
	,get_isComplete: function() {
		return this.future.isComplete;
	}
	,get_isError: function() {
		return this.future.isError;
	}
	,__class__: lime_app_Promise
	,__properties__: {get_isError:"get_isError",get_isComplete:"get_isComplete"}
};
var lime_app__$Event_$Dynamic_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Dynamic_Void"] = lime_app__$Event_$Dynamic_$Void;
lime_app__$Event_$Dynamic_$Void.__name__ = "lime.app._Event_Dynamic_Void";
lime_app__$Event_$Dynamic_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Dynamic_$Void
};
var lime_app__$Event_$Float_$Float_$Float_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Float_Float_Float_Void"] = lime_app__$Event_$Float_$Float_$Float_$Void;
lime_app__$Event_$Float_$Float_$Float_$Void.__name__ = "lime.app._Event_Float_Float_Float_Void";
lime_app__$Event_$Float_$Float_$Float_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Float_$Float_$Float_$Void
};
var lime_app__$Event_$Float_$Float_$Int_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Float_Float_Int_Void"] = lime_app__$Event_$Float_$Float_$Int_$Void;
lime_app__$Event_$Float_$Float_$Int_$Void.__name__ = "lime.app._Event_Float_Float_Int_Void";
lime_app__$Event_$Float_$Float_$Int_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Float_$Float_$Int_$Void
};
var lime_app__$Event_$Float_$Float_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Float_Float_Void"] = lime_app__$Event_$Float_$Float_$Void;
lime_app__$Event_$Float_$Float_$Void.__name__ = "lime.app._Event_Float_Float_Void";
lime_app__$Event_$Float_$Float_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Float_$Float_$Void
};
var lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Float_Float_lime_ui_MouseButton_Void"] = lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void;
lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void.__name__ = "lime.app._Event_Float_Float_lime_ui_MouseButton_Void";
lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void
};
var lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Float_Float_lime_ui_MouseWheelMode_Void"] = lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void;
lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void.__name__ = "lime.app._Event_Float_Float_lime_ui_MouseWheelMode_Void";
lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void
};
var lime_app__$Event_$Int_$Float_$Float_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Int_Float_Float_Void"] = lime_app__$Event_$Int_$Float_$Float_$Void;
lime_app__$Event_$Int_$Float_$Float_$Void.__name__ = "lime.app._Event_Int_Float_Float_Void";
lime_app__$Event_$Int_$Float_$Float_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Int_$Float_$Float_$Void
};
var lime_app__$Event_$Int_$Float_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Int_Float_Void"] = lime_app__$Event_$Int_$Float_$Void;
lime_app__$Event_$Int_$Float_$Void.__name__ = "lime.app._Event_Int_Float_Void";
lime_app__$Event_$Int_$Float_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Int_$Float_$Void
};
var lime_app__$Event_$Int_$Int_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Int_Int_Void"] = lime_app__$Event_$Int_$Int_$Void;
lime_app__$Event_$Int_$Int_$Void.__name__ = "lime.app._Event_Int_Int_Void";
lime_app__$Event_$Int_$Int_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Int_$Int_$Void
};
var lime_app__$Event_$Int_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Int_Void"] = lime_app__$Event_$Int_$Void;
lime_app__$Event_$Int_$Void.__name__ = "lime.app._Event_Int_Void";
lime_app__$Event_$Int_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Int_$Void
};
var lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Int_lime_ui_JoystickHatPosition_Void"] = lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void;
lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void.__name__ = "lime.app._Event_Int_lime_ui_JoystickHatPosition_Void";
lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void
};
var lime_app__$Event_$String_$Int_$Int_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_String_Int_Int_Void"] = lime_app__$Event_$String_$Int_$Int_$Void;
lime_app__$Event_$String_$Int_$Int_$Void.__name__ = "lime.app._Event_String_Int_Int_Void";
lime_app__$Event_$String_$Int_$Int_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1,a2) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1,a2);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$String_$Int_$Int_$Void
};
var lime_app__$Event_$String_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_String_Void"] = lime_app__$Event_$String_$Void;
lime_app__$Event_$String_$Void.__name__ = "lime.app._Event_String_Void";
lime_app__$Event_$String_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$String_$Void
};
var lime_app__$Event_$Void_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_Void_Void"] = lime_app__$Event_$Void_$Void;
lime_app__$Event_$Void_$Void.__name__ = "lime.app._Event_Void_Void";
lime_app__$Event_$Void_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function() {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i]();
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$Void_$Void
};
var lime_app__$Event_$lime_$graphics_$RenderContext_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_graphics_RenderContext_Void"] = lime_app__$Event_$lime_$graphics_$RenderContext_$Void;
lime_app__$Event_$lime_$graphics_$RenderContext_$Void.__name__ = "lime.app._Event_lime_graphics_RenderContext_Void";
lime_app__$Event_$lime_$graphics_$RenderContext_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$graphics_$RenderContext_$Void
};
var lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_GamepadAxis_Float_Void"] = lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void;
lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void.__name__ = "lime.app._Event_lime_ui_GamepadAxis_Float_Void";
lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void
};
var lime_app__$Event_$lime_$ui_$GamepadButton_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_GamepadButton_Void"] = lime_app__$Event_$lime_$ui_$GamepadButton_$Void;
lime_app__$Event_$lime_$ui_$GamepadButton_$Void.__name__ = "lime.app._Event_lime_ui_GamepadButton_Void";
lime_app__$Event_$lime_$ui_$GamepadButton_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$GamepadButton_$Void
};
var lime_app__$Event_$lime_$ui_$Gamepad_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_Gamepad_Void"] = lime_app__$Event_$lime_$ui_$Gamepad_$Void;
lime_app__$Event_$lime_$ui_$Gamepad_$Void.__name__ = "lime.app._Event_lime_ui_Gamepad_Void";
lime_app__$Event_$lime_$ui_$Gamepad_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$Gamepad_$Void
};
var lime_app__$Event_$lime_$ui_$Joystick_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_Joystick_Void"] = lime_app__$Event_$lime_$ui_$Joystick_$Void;
lime_app__$Event_$lime_$ui_$Joystick_$Void.__name__ = "lime.app._Event_lime_ui_Joystick_Void";
lime_app__$Event_$lime_$ui_$Joystick_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$Joystick_$Void
};
var lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_KeyCode_lime_ui_KeyModifier_Void"] = lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void;
lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void.__name__ = "lime.app._Event_lime_ui_KeyCode_lime_ui_KeyModifier_Void";
lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a,a1) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a,a1);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void
};
var lime_app__$Event_$lime_$ui_$Touch_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_Touch_Void"] = lime_app__$Event_$lime_$ui_$Touch_$Void;
lime_app__$Event_$lime_$ui_$Touch_$Void.__name__ = "lime.app._Event_lime_ui_Touch_Void";
lime_app__$Event_$lime_$ui_$Touch_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$Touch_$Void
};
var lime_app__$Event_$lime_$ui_$Window_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_lime_ui_Window_Void"] = lime_app__$Event_$lime_$ui_$Window_$Void;
lime_app__$Event_$lime_$ui_$Window_$Void.__name__ = "lime.app._Event_lime_ui_Window_Void";
lime_app__$Event_$lime_$ui_$Window_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$lime_$ui_$Window_$Void
};
var lime_app__$Event_$ofEvents_$T_$Void = function() {
	this.canceled = false;
	this.__listeners = [];
	this.__priorities = [];
	this.__repeat = [];
};
$hxClasses["lime.app._Event_ofEvents_T_Void"] = lime_app__$Event_$ofEvents_$T_$Void;
lime_app__$Event_$ofEvents_$T_$Void.__name__ = "lime.app._Event_ofEvents_T_Void";
lime_app__$Event_$ofEvents_$T_$Void.prototype = {
	add: function(listener,once,priority) {
		if(priority == null) {
			priority = 0;
		}
		if(once == null) {
			once = false;
		}
		var _g = 0;
		var _g1 = this.__priorities.length;
		while(_g < _g1) {
			var i = _g++;
			if(priority > this.__priorities[i]) {
				this.__listeners.splice(i,0,listener);
				this.__priorities.splice(i,0,priority);
				this.__repeat.splice(i,0,!once);
				return;
			}
		}
		this.__listeners.push(listener);
		this.__priorities.push(priority);
		this.__repeat.push(!once);
	}
	,cancel: function() {
		this.canceled = true;
	}
	,has: function(listener) {
		var _g = 0;
		var _g1 = this.__listeners;
		while(_g < _g1.length) {
			var l = _g1[_g];
			++_g;
			if(Reflect.compareMethods(l,listener)) {
				return true;
			}
		}
		return false;
	}
	,remove: function(listener) {
		var i = this.__listeners.length;
		while(--i >= 0) if(Reflect.compareMethods(this.__listeners[i],listener)) {
			this.__listeners.splice(i,1);
			this.__priorities.splice(i,1);
			this.__repeat.splice(i,1);
		}
	}
	,removeAll: function() {
		var len = this.__listeners.length;
		this.__listeners.splice(0,len);
		this.__priorities.splice(0,len);
		this.__repeat.splice(0,len);
	}
	,dispatch: function(a) {
		this.canceled = false;
		var listeners = this.__listeners;
		var repeat = this.__repeat;
		var i = 0;
		while(i < listeners.length) {
			listeners[i](a);
			if(!repeat[i]) {
				this.remove(listeners[i]);
			} else {
				++i;
			}
			if(this.canceled) {
				break;
			}
		}
	}
	,__class__: lime_app__$Event_$ofEvents_$T_$Void
};
var lime_graphics_CairoRenderContext = {};
lime_graphics_CairoRenderContext.fromRenderContext = function(context) {
	return context.cairo;
};
var lime_graphics_Canvas2DRenderContext = {};
lime_graphics_Canvas2DRenderContext.fromRenderContext = function(context) {
	return context.canvas2D;
};
var lime_graphics_DOMRenderContext = {};
lime_graphics_DOMRenderContext.fromRenderContext = function(context) {
	return context.dom;
};
var lime_graphics_FlashRenderContext = {};
lime_graphics_FlashRenderContext.fromRenderContext = function(context) {
	return null;
};
var lime_graphics_Image = function(buffer,offsetX,offsetY,width,height,color,type) {
	if(height == null) {
		height = -1;
	}
	if(width == null) {
		width = -1;
	}
	if(offsetY == null) {
		offsetY = 0;
	}
	if(offsetX == null) {
		offsetX = 0;
	}
	this.offsetX = offsetX;
	this.offsetY = offsetY;
	this.width = width;
	this.height = height;
	this.version = 0;
	if(type == null) {
		type = lime_graphics_ImageType.CANVAS;
	}
	this.type = type;
	if(buffer == null) {
		if(width > 0 && height > 0) {
			switch(this.type._hx_index) {
			case 0:
				this.buffer = new lime_graphics_ImageBuffer(null,width,height);
				lime__$internal_graphics_ImageCanvasUtil.createCanvas(this,width,height);
				if(color != null && color != 0) {
					this.fillRect(new lime_math_Rectangle(0,0,width,height),color);
				}
				break;
			case 1:
				var elements = width * height * 4;
				var array = null;
				var vector = null;
				var view = null;
				var buffer1 = null;
				var len = null;
				var this1;
				if(elements != null) {
					this1 = new Uint8Array(elements);
				} else if(array != null) {
					this1 = new Uint8Array(array);
				} else if(vector != null) {
					this1 = new Uint8Array(vector.__array);
				} else if(view != null) {
					this1 = new Uint8Array(view);
				} else if(buffer1 != null) {
					if(len == null) {
						this1 = new Uint8Array(buffer1,0);
					} else {
						this1 = new Uint8Array(buffer1,0,len);
					}
				} else {
					this1 = null;
				}
				this.buffer = new lime_graphics_ImageBuffer(this1,width,height);
				if(color != null && color != 0) {
					this.fillRect(new lime_math_Rectangle(0,0,width,height),color);
				}
				break;
			case 2:
				break;
			default:
			}
		}
	} else {
		this.__fromImageBuffer(buffer);
	}
};
$hxClasses["lime.graphics.Image"] = lime_graphics_Image;
lime_graphics_Image.__name__ = "lime.graphics.Image";
lime_graphics_Image.fromBase64 = function(base64,type) {
	if(base64 == null) {
		return null;
	}
	var image = new lime_graphics_Image();
	image.__fromBase64(base64,type);
	return image;
};
lime_graphics_Image.fromBitmapData = function(bitmapData) {
	if(bitmapData == null) {
		return null;
	}
	return bitmapData.image;
};
lime_graphics_Image.fromBytes = function(bytes) {
	if(bytes == null) {
		return null;
	}
	var image = new lime_graphics_Image();
	if(image.__fromBytes(bytes)) {
		return image;
	} else {
		return null;
	}
};
lime_graphics_Image.fromCanvas = function(canvas) {
	if(canvas == null) {
		return null;
	}
	var buffer = new lime_graphics_ImageBuffer(null,canvas.width,canvas.height);
	buffer.set_src(canvas);
	var image = new lime_graphics_Image(buffer);
	image.type = lime_graphics_ImageType.CANVAS;
	return image;
};
lime_graphics_Image.fromFile = function(path) {
	if(path == null) {
		return null;
	}
	var image = new lime_graphics_Image();
	if(image.__fromFile(path)) {
		return image;
	} else {
		return null;
	}
};
lime_graphics_Image.fromImageElement = function(image) {
	if(image == null) {
		return null;
	}
	var buffer = new lime_graphics_ImageBuffer(null,image.width,image.height);
	buffer.set_src(image);
	var _image = new lime_graphics_Image(buffer);
	_image.type = lime_graphics_ImageType.CANVAS;
	return _image;
};
lime_graphics_Image.loadFromBase64 = function(base64,type) {
	if(base64 == null || type == null) {
		return lime_app_Future.withValue(null);
	}
	return lime__$internal_backend_html5_HTML5HTTPRequest.loadImage("data:" + type + ";base64," + base64);
};
lime_graphics_Image.loadFromBytes = function(bytes) {
	if(bytes == null) {
		return lime_app_Future.withValue(null);
	}
	var type = "";
	if(lime_graphics_Image.__isPNG(bytes)) {
		type = "image/png";
	} else if(lime_graphics_Image.__isJPG(bytes)) {
		type = "image/jpeg";
	} else if(lime_graphics_Image.__isGIF(bytes)) {
		type = "image/gif";
	} else if(lime_graphics_Image.__isWebP(bytes)) {
		type = "image/webp";
	} else {
		return lime_app_Future.withValue(null);
	}
	return lime__$internal_backend_html5_HTML5HTTPRequest.loadImageFromBytes(bytes,type);
};
lime_graphics_Image.loadFromFile = function(path) {
	if(path == null) {
		return lime_app_Future.withValue(null);
	}
	return lime__$internal_backend_html5_HTML5HTTPRequest.loadImage(path);
};
lime_graphics_Image.__isGIF = function(bytes) {
	if(bytes == null || bytes.length < 6) {
		return false;
	}
	var header = bytes.getString(0,6);
	if(header != "GIF87a") {
		return header == "GIF89a";
	} else {
		return true;
	}
};
lime_graphics_Image.__isJPG = function(bytes) {
	if(bytes == null || bytes.length < 4) {
		return false;
	}
	if(bytes.b[0] == 255 && bytes.b[1] == 216 && bytes.b[bytes.length - 2] == 255) {
		return bytes.b[bytes.length - 1] == 217;
	} else {
		return false;
	}
};
lime_graphics_Image.__isPNG = function(bytes) {
	if(bytes == null || bytes.length < 8) {
		return false;
	}
	if(bytes.b[0] == 137 && bytes.b[1] == 80 && bytes.b[2] == 78 && bytes.b[3] == 71 && bytes.b[4] == 13 && bytes.b[5] == 10 && bytes.b[6] == 26) {
		return bytes.b[7] == 10;
	} else {
		return false;
	}
};
lime_graphics_Image.__isWebP = function(bytes) {
	if(bytes == null || bytes.length < 16) {
		return false;
	}
	if(bytes.getString(0,4) == "RIFF") {
		return bytes.getString(8,4) == "WEBP";
	} else {
		return false;
	}
};
lime_graphics_Image.prototype = {
	clone: function() {
		if(this.buffer != null) {
			if(this.type == lime_graphics_ImageType.CANVAS) {
				lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this);
			} else {
				lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			}
			var image = new lime_graphics_Image(this.buffer.clone(),this.offsetX,this.offsetY,this.width,this.height,null,this.type);
			image.version = this.version;
			return image;
		} else {
			return new lime_graphics_Image(null,this.offsetX,this.offsetY,this.width,this.height,null,this.type);
		}
	}
	,colorTransform: function(rect,colorMatrix) {
		rect = this.__clipRect(rect);
		if(this.buffer == null || rect == null) {
			return;
		}
		switch(this.type._hx_index) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.colorTransform(this,rect,colorMatrix);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageDataUtil.colorTransform(this,rect,colorMatrix);
			break;
		case 2:
			rect.offset(this.offsetX,this.offsetY);
			this.buffer.__srcBitmapData.colorTransform(rect.__toFlashRectangle(),lime_math_ColorMatrix.__toFlashColorTransform(colorMatrix));
			break;
		default:
		}
	}
	,copyChannel: function(sourceImage,sourceRect,destPoint,sourceChannel,destChannel) {
		sourceRect = this.__clipRect(sourceRect);
		if(this.buffer == null || sourceRect == null) {
			return;
		}
		if(destChannel == lime_graphics_ImageChannel.ALPHA && !this.get_transparent()) {
			return;
		}
		if(sourceRect.width <= 0 || sourceRect.height <= 0) {
			return;
		}
		if(sourceRect.x + sourceRect.width > sourceImage.width) {
			sourceRect.width = sourceImage.width - sourceRect.x;
		}
		if(sourceRect.y + sourceRect.height > sourceImage.height) {
			sourceRect.height = sourceImage.height - sourceRect.y;
		}
		switch(this.type._hx_index) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.copyChannel(this,sourceImage,sourceRect,destPoint,sourceChannel,destChannel);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
			lime__$internal_graphics_ImageDataUtil.copyChannel(this,sourceImage,sourceRect,destPoint,sourceChannel,destChannel);
			break;
		case 2:
			var srcChannel;
			switch(sourceChannel._hx_index) {
			case 0:
				srcChannel = 1;
				break;
			case 1:
				srcChannel = 2;
				break;
			case 2:
				srcChannel = 4;
				break;
			case 3:
				srcChannel = 8;
				break;
			}
			var dstChannel;
			switch(destChannel._hx_index) {
			case 0:
				dstChannel = 1;
				break;
			case 1:
				dstChannel = 2;
				break;
			case 2:
				dstChannel = 4;
				break;
			case 3:
				dstChannel = 8;
				break;
			}
			sourceRect.offset(sourceImage.offsetX,sourceImage.offsetY);
			destPoint.offset(this.offsetX,this.offsetY);
			this.buffer.__srcBitmapData.copyChannel(sourceImage.buffer.get_src(),sourceRect.__toFlashRectangle(),destPoint.__toFlashPoint(),srcChannel,dstChannel);
			break;
		default:
		}
	}
	,copyPixels: function(sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha) {
		if(mergeAlpha == null) {
			mergeAlpha = false;
		}
		if(this.buffer == null || sourceImage == null) {
			return;
		}
		if(sourceRect.width <= 0 || sourceRect.height <= 0) {
			return;
		}
		if(this.width <= 0 || this.height <= 0) {
			return;
		}
		if(sourceRect.x + sourceRect.width > sourceImage.width) {
			sourceRect.width = sourceImage.width - sourceRect.x;
		}
		if(sourceRect.y + sourceRect.height > sourceImage.height) {
			sourceRect.height = sourceImage.height - sourceRect.y;
		}
		if(sourceRect.x < 0) {
			sourceRect.width += sourceRect.x;
			sourceRect.x = 0;
		}
		if(sourceRect.y < 0) {
			sourceRect.height += sourceRect.y;
			sourceRect.y = 0;
		}
		if(destPoint.x + sourceRect.width > this.width) {
			sourceRect.width = this.width - destPoint.x;
		}
		if(destPoint.y + sourceRect.height > this.height) {
			sourceRect.height = this.height - destPoint.y;
		}
		if(destPoint.x < 0) {
			sourceRect.width += destPoint.x;
			sourceRect.x -= destPoint.x;
			destPoint.x = 0;
		}
		if(destPoint.y < 0) {
			sourceRect.height += destPoint.y;
			sourceRect.y -= destPoint.y;
			destPoint.y = 0;
		}
		if(sourceImage == this && destPoint.x < sourceRect.get_right() && destPoint.y < sourceRect.get_bottom()) {
			sourceImage = this.clone();
		}
		if(alphaImage == sourceImage && (alphaPoint == null || alphaPoint.x == 0 && alphaPoint.y == 0)) {
			alphaImage = null;
			alphaPoint = null;
		}
		switch(this.type._hx_index) {
		case 0:
			if(alphaImage != null) {
				lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
				lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
				if(alphaImage != null) {
					lime__$internal_graphics_ImageCanvasUtil.convertToData(alphaImage);
				}
				lime__$internal_graphics_ImageDataUtil.copyPixels(this,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha);
			} else {
				lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this);
				lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(sourceImage);
				lime__$internal_graphics_ImageCanvasUtil.copyPixels(this,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha);
			}
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
			if(alphaImage != null) {
				lime__$internal_graphics_ImageCanvasUtil.convertToData(alphaImage);
			}
			lime__$internal_graphics_ImageDataUtil.copyPixels(this,sourceImage,sourceRect,destPoint,alphaImage,alphaPoint,mergeAlpha);
			break;
		case 2:
			sourceRect.offset(sourceImage.offsetX,sourceImage.offsetY);
			destPoint.offset(this.offsetX,this.offsetY);
			if(alphaImage != null && alphaPoint != null) {
				alphaPoint.offset(alphaImage.offsetX,alphaImage.offsetY);
			}
			this.buffer.__srcBitmapData.copyPixels(sourceImage.buffer.__srcBitmapData,sourceRect.__toFlashRectangle(),destPoint.__toFlashPoint(),alphaImage != null ? alphaImage.buffer.get_src() : null,alphaPoint != null ? alphaPoint.__toFlashPoint() : null,mergeAlpha);
			break;
		default:
		}
	}
	,encode: function(format,quality) {
		if(quality == null) {
			quality = 90;
		}
		if(format == null) {
			return lime__$internal_format_PNG.encode(this);
		} else {
			switch(format._hx_index) {
			case 0:
				return lime__$internal_format_BMP.encode(this);
			case 1:
				return lime__$internal_format_JPEG.encode(this,quality);
			case 2:
				return lime__$internal_format_PNG.encode(this);
			}
		}
	}
	,fillRect: function(rect,color,format) {
		rect = this.__clipRect(rect);
		if(this.buffer == null || rect == null) {
			return;
		}
		switch(this.type._hx_index) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.fillRect(this,rect,color,format);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			if(this.buffer.data.length == 0) {
				return;
			}
			lime__$internal_graphics_ImageDataUtil.fillRect(this,rect,color,format);
			break;
		case 2:
			rect.offset(this.offsetX,this.offsetY);
			var argb;
			if(format == null) {
				var rgba = color;
				var this1 = 0;
				var argb1 = this1;
				argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
				argb = argb1;
			} else {
				switch(format) {
				case 1:
					argb = color;
					break;
				case 2:
					var bgra = color;
					var this1 = 0;
					var argb1 = this1;
					argb1 = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
					argb = argb1;
					break;
				default:
					var rgba = color;
					var this1 = 0;
					var argb1 = this1;
					argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
					argb = argb1;
				}
			}
			this.buffer.__srcBitmapData.fillRect(rect.__toFlashRectangle(),argb);
			break;
		default:
		}
	}
	,floodFill: function(x,y,color,format) {
		if(this.buffer == null) {
			return;
		}
		switch(this.type._hx_index) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.floodFill(this,x,y,color,format);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageDataUtil.floodFill(this,x,y,color,format);
			break;
		case 2:
			var argb;
			if(format == null) {
				var rgba = color;
				var this1 = 0;
				var argb1 = this1;
				argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
				argb = argb1;
			} else {
				switch(format) {
				case 1:
					argb = color;
					break;
				case 2:
					var bgra = color;
					var this1 = 0;
					var argb1 = this1;
					argb1 = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
					argb = argb1;
					break;
				default:
					var rgba = color;
					var this1 = 0;
					var argb1 = this1;
					argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
					argb = argb1;
				}
			}
			this.buffer.__srcBitmapData.floodFill(x + this.offsetX,y + this.offsetY,argb);
			break;
		default:
		}
	}
	,getColorBoundsRect: function(mask,color,findColor,format) {
		if(findColor == null) {
			findColor = true;
		}
		if(this.buffer == null) {
			return null;
		}
		switch(this.type._hx_index) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			return lime__$internal_graphics_ImageDataUtil.getColorBoundsRect(this,mask,color,findColor,format);
		case 1:
			return lime__$internal_graphics_ImageDataUtil.getColorBoundsRect(this,mask,color,findColor,format);
		case 2:
			var rect = this.buffer.__srcBitmapData.getColorBoundsRect(mask,color,findColor);
			return new lime_math_Rectangle(rect.x,rect.y,rect.width,rect.height);
		default:
			return null;
		}
	}
	,getPixel: function(x,y,format) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) {
			return 0;
		}
		switch(this.type._hx_index) {
		case 0:
			return lime__$internal_graphics_ImageCanvasUtil.getPixel(this,x,y,format);
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			return lime__$internal_graphics_ImageDataUtil.getPixel(this,x,y,format);
		case 2:
			var color = this.buffer.__srcBitmapData.getPixel(x + this.offsetX,y + this.offsetY);
			if(format == null) {
				var this1 = 0;
				var rgba = this1;
				rgba = (color >>> 16 & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color & 255 & 255) << 8 | color >>> 24 & 255 & 255;
				var rgba1 = rgba;
				return rgba1;
			} else {
				switch(format) {
				case 1:
					return color;
				case 2:
					var this1 = 0;
					var bgra = this1;
					bgra = (color & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color >>> 16 & 255 & 255) << 8 | color >>> 24 & 255 & 255;
					var bgra1 = bgra;
					return bgra1;
				default:
					var this1 = 0;
					var rgba = this1;
					rgba = (color >>> 16 & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color & 255 & 255) << 8 | color >>> 24 & 255 & 255;
					var rgba1 = rgba;
					return rgba1;
				}
			}
			break;
		default:
			return 0;
		}
	}
	,getPixel32: function(x,y,format) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) {
			return 0;
		}
		switch(this.type._hx_index) {
		case 0:
			return lime__$internal_graphics_ImageCanvasUtil.getPixel32(this,x,y,format);
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			return lime__$internal_graphics_ImageDataUtil.getPixel32(this,x,y,format);
		case 2:
			var color = this.buffer.__srcBitmapData.getPixel32(x + this.offsetX,y + this.offsetY);
			if(format == null) {
				var this1 = 0;
				var rgba = this1;
				rgba = (color >>> 16 & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color & 255 & 255) << 8 | color >>> 24 & 255 & 255;
				var rgba1 = rgba;
				return rgba1;
			} else {
				switch(format) {
				case 1:
					return color;
				case 2:
					var this1 = 0;
					var bgra = this1;
					bgra = (color & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color >>> 16 & 255 & 255) << 8 | color >>> 24 & 255 & 255;
					var bgra1 = bgra;
					return bgra1;
				default:
					var this1 = 0;
					var rgba = this1;
					rgba = (color >>> 16 & 255 & 255) << 24 | (color >>> 8 & 255 & 255) << 16 | (color & 255 & 255) << 8 | color >>> 24 & 255 & 255;
					var rgba1 = rgba;
					return rgba1;
				}
			}
			break;
		default:
			return 0;
		}
	}
	,getPixels: function(rect,format) {
		if(this.buffer == null) {
			return null;
		}
		switch(this.type._hx_index) {
		case 0:
			return lime__$internal_graphics_ImageCanvasUtil.getPixels(this,rect,format);
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			return lime__$internal_graphics_ImageDataUtil.getPixels(this,rect,format);
		case 2:
			return null;
		default:
			return null;
		}
	}
	,merge: function(sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
		if(this.buffer == null || sourceImage == null) {
			return;
		}
		switch(this.type._hx_index) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this);
			lime__$internal_graphics_ImageCanvasUtil.merge(this,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
			lime__$internal_graphics_ImageDataUtil.merge(this,sourceImage,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
			break;
		case 2:
			sourceRect.offset(this.offsetX,this.offsetY);
			this.buffer.__srcBitmapData.merge(sourceImage.buffer.__srcBitmapData,sourceRect.__toFlashRectangle(),destPoint.__toFlashPoint(),redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
			break;
		default:
			return;
		}
	}
	,resize: function(newWidth,newHeight) {
		switch(this.type._hx_index) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.resize(this,newWidth,newHeight);
			break;
		case 1:
			lime__$internal_graphics_ImageDataUtil.resize(this,newWidth,newHeight);
			break;
		case 2:
			break;
		default:
		}
		this.buffer.width = newWidth;
		this.buffer.height = newHeight;
		this.offsetX = 0;
		this.offsetY = 0;
		this.width = newWidth;
		this.height = newHeight;
	}
	,scroll: function(x,y) {
		if(this.buffer == null) {
			return;
		}
		switch(this.type._hx_index) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.scroll(this,x,y);
			break;
		case 1:
			this.copyPixels(this,this.get_rect(),new lime_math_Vector2(x,y));
			break;
		case 2:
			this.buffer.__srcBitmapData.scroll(x + this.offsetX,y + this.offsetX);
			break;
		default:
		}
	}
	,setPixel: function(x,y,color,format) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) {
			return;
		}
		switch(this.type._hx_index) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.setPixel(this,x,y,color,format);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageDataUtil.setPixel(this,x,y,color,format);
			break;
		case 2:
			var argb;
			if(format == null) {
				var rgba = color;
				var this1 = 0;
				var argb1 = this1;
				argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
				argb = argb1;
			} else {
				switch(format) {
				case 1:
					argb = color;
					break;
				case 2:
					var bgra = color;
					var this1 = 0;
					var argb1 = this1;
					argb1 = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
					argb = argb1;
					break;
				default:
					var rgba = color;
					var this1 = 0;
					var argb1 = this1;
					argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
					argb = argb1;
				}
			}
			this.buffer.__srcBitmapData.setPixel(x + this.offsetX,y + this.offsetX,argb);
			break;
		default:
		}
	}
	,setPixel32: function(x,y,color,format) {
		if(this.buffer == null || x < 0 || y < 0 || x >= this.width || y >= this.height) {
			return;
		}
		switch(this.type._hx_index) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.setPixel32(this,x,y,color,format);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageDataUtil.setPixel32(this,x,y,color,format);
			break;
		case 2:
			var argb;
			if(format == null) {
				var rgba = color;
				var this1 = 0;
				var argb1 = this1;
				argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
				argb = argb1;
			} else {
				switch(format) {
				case 1:
					argb = color;
					break;
				case 2:
					var bgra = color;
					var this1 = 0;
					var argb1 = this1;
					argb1 = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
					argb = argb1;
					break;
				default:
					var rgba = color;
					var this1 = 0;
					var argb1 = this1;
					argb1 = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
					argb = argb1;
				}
			}
			this.buffer.__srcBitmapData.setPixel32(x + this.offsetX,y + this.offsetY,argb);
			break;
		default:
		}
	}
	,setPixels: function(rect,bytePointer,format,endian) {
		rect = this.__clipRect(rect);
		if(this.buffer == null || rect == null) {
			return;
		}
		if(endian == null) {
			endian = lime_system_Endian.BIG_ENDIAN;
		}
		switch(this.type._hx_index) {
		case 0:
			lime__$internal_graphics_ImageCanvasUtil.setPixels(this,rect,bytePointer,format,endian);
			break;
		case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageDataUtil.setPixels(this,rect,bytePointer,format,endian);
			break;
		case 2:
			break;
		default:
		}
	}
	,threshold: function(sourceImage,sourceRect,destPoint,operation,threshold,color,mask,copySource,format) {
		if(copySource == null) {
			copySource = false;
		}
		if(mask == null) {
			mask = -1;
		}
		if(color == null) {
			color = 0;
		}
		if(this.buffer == null || sourceImage == null || sourceRect == null) {
			return 0;
		}
		switch(this.type._hx_index) {
		case 0:case 1:
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
			lime__$internal_graphics_ImageCanvasUtil.convertToData(sourceImage);
			return lime__$internal_graphics_ImageDataUtil.threshold(this,sourceImage,sourceRect,destPoint,operation,threshold,color,mask,copySource,format);
		case 2:
			var _color;
			if(format == null) {
				var rgba = color;
				var this1 = 0;
				var argb = this1;
				argb = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
				_color = argb;
			} else {
				switch(format) {
				case 1:
					_color = color;
					break;
				case 2:
					var bgra = color;
					var this1 = 0;
					var argb = this1;
					argb = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
					_color = argb;
					break;
				default:
					var rgba = color;
					var this1 = 0;
					var argb = this1;
					argb = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
					_color = argb;
				}
			}
			var _mask;
			if(format == null) {
				var rgba = mask;
				var this1 = 0;
				var argb = this1;
				argb = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
				_mask = argb;
			} else {
				switch(format) {
				case 1:
					_mask = mask;
					break;
				case 2:
					var bgra = mask;
					var this1 = 0;
					var argb = this1;
					argb = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
					_mask = argb;
					break;
				default:
					var rgba = mask;
					var this1 = 0;
					var argb = this1;
					argb = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
					_mask = argb;
				}
			}
			sourceRect.offset(sourceImage.offsetX,sourceImage.offsetY);
			destPoint.offset(this.offsetX,this.offsetY);
			return this.buffer.__srcBitmapData.threshold(sourceImage.buffer.get_src(),sourceRect.__toFlashRectangle(),destPoint.__toFlashPoint(),operation,threshold,_color,_mask,copySource);
		default:
		}
		return 0;
	}
	,__clipRect: function(r) {
		if(r == null) {
			return null;
		}
		if(r.x < 0) {
			r.width -= -r.x;
			r.x = 0;
			if(r.x + r.width <= 0) {
				return null;
			}
		}
		if(r.y < 0) {
			r.height -= -r.y;
			r.y = 0;
			if(r.y + r.height <= 0) {
				return null;
			}
		}
		if(r.x + r.width >= this.width) {
			r.width -= r.x + r.width - this.width;
			if(r.width <= 0) {
				return null;
			}
		}
		if(r.y + r.height >= this.height) {
			r.height -= r.y + r.height - this.height;
			if(r.height <= 0) {
				return null;
			}
		}
		return r;
	}
	,__fromBase64: function(base64,type,onload) {
		var _gthis = this;
		var image = new Image();
		var image_onLoaded = function(event) {
			_gthis.buffer = new lime_graphics_ImageBuffer(null,image.width,image.height);
			_gthis.buffer.__srcImage = image;
			_gthis.offsetX = 0;
			_gthis.offsetY = 0;
			_gthis.width = _gthis.buffer.width;
			_gthis.height = _gthis.buffer.height;
			if(onload != null) {
				onload(_gthis);
			}
		};
		image.addEventListener("load",image_onLoaded,false);
		image.src = "data:" + type + ";base64," + base64;
	}
	,__fromBytes: function(bytes,onload) {
		var type = "";
		if(lime_graphics_Image.__isPNG(bytes)) {
			type = "image/png";
		} else if(lime_graphics_Image.__isJPG(bytes)) {
			type = "image/jpeg";
		} else if(lime_graphics_Image.__isGIF(bytes)) {
			type = "image/gif";
		} else {
			return false;
		}
		this.__fromBase64(lime__$internal_format_Base64.encode(bytes),type,onload);
		return true;
	}
	,__fromFile: function(path,onload,onerror) {
		var _gthis = this;
		var image = new Image();
		if(!lime__$internal_backend_html5_HTML5HTTPRequest.__isSameOrigin(path)) {
			image.crossOrigin = "Anonymous";
		}
		image.onload = function(_) {
			_gthis.buffer = new lime_graphics_ImageBuffer(null,image.width,image.height);
			_gthis.buffer.__srcImage = image;
			_gthis.width = image.width;
			_gthis.height = image.height;
			if(onload != null) {
				onload(_gthis);
			}
		};
		image.onerror = function(_) {
			if(onerror != null) {
				onerror();
			}
		};
		image.src = path;
		var image1 = image.complete;
		return true;
	}
	,__fromImageBuffer: function(buffer) {
		this.buffer = buffer;
		if(buffer != null) {
			if(this.width == -1) {
				this.width = buffer.width;
			}
			if(this.height == -1) {
				this.height = buffer.height;
			}
		}
	}
	,get_data: function() {
		if(this.buffer.data == null && this.buffer.width > 0 && this.buffer.height > 0) {
			lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
		}
		return this.buffer.data;
	}
	,set_data: function(value) {
		return this.buffer.data = value;
	}
	,get_format: function() {
		return this.buffer.format;
	}
	,set_format: function(value) {
		if(this.buffer.format != value) {
			if(this.type._hx_index == 1) {
				lime__$internal_graphics_ImageDataUtil.setFormat(this,value);
			}
		}
		return this.buffer.format = value;
	}
	,get_powerOfTwo: function() {
		if(this.buffer.width != 0 && (this.buffer.width & ~this.buffer.width + 1) == this.buffer.width) {
			if(this.buffer.height != 0) {
				return (this.buffer.height & ~this.buffer.height + 1) == this.buffer.height;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	,set_powerOfTwo: function(value) {
		if(value != this.get_powerOfTwo()) {
			var newWidth = 1;
			var newHeight = 1;
			while(newWidth < this.buffer.width) newWidth <<= 1;
			while(newHeight < this.buffer.height) newHeight <<= 1;
			if(newWidth == this.buffer.width && newHeight == this.buffer.height) {
				return value;
			}
			switch(this.type._hx_index) {
			case 0:
				lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
				lime__$internal_graphics_ImageDataUtil.resizeBuffer(this,newWidth,newHeight);
				break;
			case 1:
				lime__$internal_graphics_ImageDataUtil.resizeBuffer(this,newWidth,newHeight);
				break;
			case 2:
				break;
			default:
			}
		}
		return value;
	}
	,get_premultiplied: function() {
		return this.buffer.premultiplied;
	}
	,set_premultiplied: function(value) {
		if(value && !this.buffer.premultiplied) {
			switch(this.type._hx_index) {
			case 0:case 1:
				lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
				lime__$internal_graphics_ImageDataUtil.multiplyAlpha(this);
				break;
			default:
			}
		} else if(!value && this.buffer.premultiplied) {
			if(this.type._hx_index == 1) {
				lime__$internal_graphics_ImageCanvasUtil.convertToData(this);
				lime__$internal_graphics_ImageDataUtil.unmultiplyAlpha(this);
			}
		}
		return value;
	}
	,get_rect: function() {
		return new lime_math_Rectangle(0,0,this.width,this.height);
	}
	,get_src: function() {
		if(this.buffer.__srcCanvas == null && (this.buffer.data != null || this.type == lime_graphics_ImageType.DATA)) {
			lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this);
		}
		return this.buffer.get_src();
	}
	,set_src: function(value) {
		return this.buffer.set_src(value);
	}
	,get_transparent: function() {
		if(this.buffer == null) {
			return false;
		}
		return this.buffer.transparent;
	}
	,set_transparent: function(value) {
		if(this.buffer == null) {
			return false;
		}
		return this.buffer.transparent = value;
	}
	,__class__: lime_graphics_Image
	,__properties__: {set_transparent:"set_transparent",get_transparent:"get_transparent",set_src:"set_src",get_src:"get_src",get_rect:"get_rect",set_premultiplied:"set_premultiplied",get_premultiplied:"get_premultiplied",set_powerOfTwo:"set_powerOfTwo",get_powerOfTwo:"get_powerOfTwo",set_format:"set_format",get_format:"get_format",set_data:"set_data",get_data:"get_data"}
};
var lime_graphics_ImageBuffer = function(data,width,height,bitsPerPixel,format) {
	if(bitsPerPixel == null) {
		bitsPerPixel = 32;
	}
	if(height == null) {
		height = 0;
	}
	if(width == null) {
		width = 0;
	}
	this.data = data;
	this.width = width;
	this.height = height;
	this.bitsPerPixel = bitsPerPixel;
	this.format = format == null ? 0 : format;
	this.premultiplied = false;
	this.transparent = true;
};
$hxClasses["lime.graphics.ImageBuffer"] = lime_graphics_ImageBuffer;
lime_graphics_ImageBuffer.__name__ = "lime.graphics.ImageBuffer";
lime_graphics_ImageBuffer.prototype = {
	clone: function() {
		var buffer = new lime_graphics_ImageBuffer(this.data,this.width,this.height,this.bitsPerPixel);
		if(this.data != null) {
			var elements = this.data.byteLength;
			var array = null;
			var vector = null;
			var view = null;
			var buffer1 = null;
			var len = null;
			var this1;
			if(elements != null) {
				this1 = new Uint8Array(elements);
			} else if(array != null) {
				this1 = new Uint8Array(array);
			} else if(vector != null) {
				this1 = new Uint8Array(vector.__array);
			} else if(view != null) {
				this1 = new Uint8Array(view);
			} else if(buffer1 != null) {
				if(len == null) {
					this1 = new Uint8Array(buffer1,0);
				} else {
					this1 = new Uint8Array(buffer1,0,len);
				}
			} else {
				this1 = null;
			}
			buffer.data = this1;
			var elements = null;
			var array = null;
			var vector = null;
			var view = this.data;
			var buffer1 = null;
			var len = null;
			var this1;
			if(elements != null) {
				this1 = new Uint8Array(elements);
			} else if(array != null) {
				this1 = new Uint8Array(array);
			} else if(vector != null) {
				this1 = new Uint8Array(vector.__array);
			} else if(view != null) {
				this1 = new Uint8Array(view);
			} else if(buffer1 != null) {
				if(len == null) {
					this1 = new Uint8Array(buffer1,0);
				} else {
					this1 = new Uint8Array(buffer1,0,len);
				}
			} else {
				this1 = null;
			}
			var copy = this1;
			buffer.data.set(copy);
		} else if(this.__srcImageData != null) {
			buffer.__srcCanvas = window.document.createElement("canvas");
			buffer.__srcContext = buffer.__srcCanvas.getContext("2d");
			buffer.__srcCanvas.width = this.__srcImageData.width;
			buffer.__srcCanvas.height = this.__srcImageData.height;
			buffer.__srcImageData = buffer.__srcContext.createImageData(this.__srcImageData.width,this.__srcImageData.height);
			var copy = new Uint8ClampedArray(this.__srcImageData.data);
			buffer.__srcImageData.data.set(copy);
		} else if(this.__srcCanvas != null) {
			buffer.__srcCanvas = window.document.createElement("canvas");
			buffer.__srcContext = buffer.__srcCanvas.getContext("2d");
			buffer.__srcCanvas.width = this.__srcCanvas.width;
			buffer.__srcCanvas.height = this.__srcCanvas.height;
			buffer.__srcContext.drawImage(this.__srcCanvas,0,0);
		} else {
			buffer.__srcImage = this.__srcImage;
		}
		buffer.bitsPerPixel = this.bitsPerPixel;
		buffer.format = this.format;
		buffer.premultiplied = this.premultiplied;
		buffer.transparent = this.transparent;
		return buffer;
	}
	,get_src: function() {
		if(this.__srcImage != null) {
			return this.__srcImage;
		}
		return this.__srcCanvas;
	}
	,set_src: function(value) {
		if(((value) instanceof Image)) {
			this.__srcImage = value;
		} else if(((value) instanceof HTMLCanvasElement)) {
			this.__srcCanvas = value;
			this.__srcContext = this.__srcCanvas.getContext("2d");
		}
		return value;
	}
	,get_stride: function() {
		return this.width * (this.bitsPerPixel / 8 | 0);
	}
	,__class__: lime_graphics_ImageBuffer
	,__properties__: {get_stride:"get_stride",set_src:"set_src",get_src:"get_src"}
};
var lime_graphics_ImageChannel = $hxEnums["lime.graphics.ImageChannel"] = { __ename__ : "lime.graphics.ImageChannel", __constructs__ : ["RED","GREEN","BLUE","ALPHA"]
	,RED: {_hx_index:0,__enum__:"lime.graphics.ImageChannel",toString:$estr}
	,GREEN: {_hx_index:1,__enum__:"lime.graphics.ImageChannel",toString:$estr}
	,BLUE: {_hx_index:2,__enum__:"lime.graphics.ImageChannel",toString:$estr}
	,ALPHA: {_hx_index:3,__enum__:"lime.graphics.ImageChannel",toString:$estr}
};
var lime_graphics_ImageFileFormat = $hxEnums["lime.graphics.ImageFileFormat"] = { __ename__ : "lime.graphics.ImageFileFormat", __constructs__ : ["BMP","JPEG","PNG"]
	,BMP: {_hx_index:0,__enum__:"lime.graphics.ImageFileFormat",toString:$estr}
	,JPEG: {_hx_index:1,__enum__:"lime.graphics.ImageFileFormat",toString:$estr}
	,PNG: {_hx_index:2,__enum__:"lime.graphics.ImageFileFormat",toString:$estr}
};
var lime_graphics_ImageType = $hxEnums["lime.graphics.ImageType"] = { __ename__ : "lime.graphics.ImageType", __constructs__ : ["CANVAS","DATA","FLASH","CUSTOM"]
	,CANVAS: {_hx_index:0,__enum__:"lime.graphics.ImageType",toString:$estr}
	,DATA: {_hx_index:1,__enum__:"lime.graphics.ImageType",toString:$estr}
	,FLASH: {_hx_index:2,__enum__:"lime.graphics.ImageType",toString:$estr}
	,CUSTOM: {_hx_index:3,__enum__:"lime.graphics.ImageType",toString:$estr}
};
var lime_graphics_OpenGLES2RenderContext = {};
lime_graphics_OpenGLES2RenderContext.fromGL = function(gl) {
	return null;
};
lime_graphics_OpenGLES2RenderContext.fromOpenGLES3RenderContext = function(gl) {
	return null;
};
lime_graphics_OpenGLES2RenderContext.fromRenderContext = function(context) {
	return null;
};
lime_graphics_OpenGLES2RenderContext.fromWebGLRenderContext = function(gl) {
	return null;
};
var lime_graphics_OpenGLES3RenderContext = {};
lime_graphics_OpenGLES3RenderContext.fromRenderContext = function(context) {
	return null;
};
lime_graphics_OpenGLES3RenderContext.fromGL = function(gl) {
	return null;
};
lime_graphics_OpenGLES3RenderContext.fromOpenGLES2RenderContext = function(context) {
	return null;
};
lime_graphics_OpenGLES3RenderContext.fromWebGLRenderContext = function(context) {
	return null;
};
lime_graphics_OpenGLES3RenderContext.fromWebGL2RenderContext = function(context) {
	return null;
};
var lime_graphics_OpenGLRenderContext = {};
lime_graphics_OpenGLRenderContext.fromRenderContext = function(context) {
	return null;
};
var lime_graphics_RenderContext = function() {
};
$hxClasses["lime.graphics.RenderContext"] = lime_graphics_RenderContext;
lime_graphics_RenderContext.__name__ = "lime.graphics.RenderContext";
lime_graphics_RenderContext.prototype = {
	__class__: lime_graphics_RenderContext
};
var lime_graphics_WebGL2RenderContext = {};
lime_graphics_WebGL2RenderContext.bufferData = function(this1,target,srcData,usage,srcOffset,length) {
	if(srcOffset != null) {
		this1.bufferData(target,srcData,usage,srcOffset,length);
	} else {
		this1.bufferData(target,srcData,usage);
	}
};
lime_graphics_WebGL2RenderContext.bufferSubData = function(this1,target,dstByteOffset,srcData,srcOffset,length) {
	if(srcOffset != null) {
		this1.bufferSubData(target,dstByteOffset,srcData,srcOffset,length);
	} else {
		this1.bufferSubData(target,dstByteOffset,srcData);
	}
};
lime_graphics_WebGL2RenderContext.compressedTexImage2D = function(this1,target,level,internalformat,width,height,border,srcData,srcOffset,srcLengthOverride) {
	if(srcOffset != null) {
		this1.compressedTexImage2D(target,level,internalformat,width,height,border,srcData,srcOffset,srcLengthOverride);
	} else {
		this1.compressedTexImage2D(target,level,internalformat,width,height,border,srcData);
	}
};
lime_graphics_WebGL2RenderContext.compressedTexSubImage2D = function(this1,target,level,xoffset,yoffset,width,height,format,srcData,srcOffset,srcLengthOverride) {
	if(srcOffset != null) {
		this1.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,srcData,srcOffset,srcLengthOverride);
	} else {
		this1.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,srcData);
	}
};
lime_graphics_WebGL2RenderContext.getBufferSubData = function(this1,target,srcByteOffset,dstData,srcOffset,length) {
	if(srcOffset != null) {
		this1.getBufferSubData(target,srcByteOffset,dstData,srcOffset,length);
	} else {
		this1.getBufferSubData(target,srcByteOffset,dstData);
	}
};
lime_graphics_WebGL2RenderContext.readPixels = function(this1,x,y,width,height,format,type,pixels,dstOffset) {
	if(dstOffset != null) {
		this1.readPixels(x,y,width,height,format,type,pixels,dstOffset);
	} else {
		this1.readPixels(x,y,width,height,format,type,pixels);
	}
};
lime_graphics_WebGL2RenderContext.texImage2D = function(this1,target,level,internalformat,width,height,border,format,type,srcData,srcOffset) {
	if(srcOffset != null) {
		this1.texImage2D(target,level,internalformat,width,height,border,format,type,srcData,srcOffset);
	} else if(format != null) {
		this1.texImage2D(target,level,internalformat,width,height,border,format,type,srcData);
	} else {
		this1.texImage2D(target,level,internalformat,width,height,border);
	}
};
lime_graphics_WebGL2RenderContext.texSubImage2D = function(this1,target,level,xoffset,yoffset,width,height,format,type,srcData,srcOffset) {
	if(srcOffset != null) {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,srcData,srcOffset);
	} else if(type != null) {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,srcData);
	} else {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format);
	}
};
lime_graphics_WebGL2RenderContext.uniform1fv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform1fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform1fv(location,data);
	}
};
lime_graphics_WebGL2RenderContext.uniform1iv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform1iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform1iv(location,data);
	}
};
lime_graphics_WebGL2RenderContext.uniform2fv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform2fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform2fv(location,data);
	}
};
lime_graphics_WebGL2RenderContext.uniform2iv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform2iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform2iv(location,data);
	}
};
lime_graphics_WebGL2RenderContext.uniform3fv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform3fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform3fv(location,data);
	}
};
lime_graphics_WebGL2RenderContext.uniform3iv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform3iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform3iv(location,data);
	}
};
lime_graphics_WebGL2RenderContext.uniform4fv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform4fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform4fv(location,data);
	}
};
lime_graphics_WebGL2RenderContext.uniform4iv = function(this1,location,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniform4iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform4iv(location,data);
	}
};
lime_graphics_WebGL2RenderContext.uniformMatrix2fv = function(this1,location,transpose,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniformMatrix2fv(location,transpose,data,srcOffset,srcLength);
	} else {
		this1.uniformMatrix2fv(location,transpose,data);
	}
};
lime_graphics_WebGL2RenderContext.uniformMatrix3fv = function(this1,location,transpose,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniformMatrix3fv(location,transpose,data,srcOffset,srcLength);
	} else {
		this1.uniformMatrix3fv(location,transpose,data);
	}
};
lime_graphics_WebGL2RenderContext.uniformMatrix4fv = function(this1,location,transpose,data,srcOffset,srcLength) {
	if(srcOffset != null) {
		this1.uniformMatrix4fv(location,transpose,data,srcOffset,srcLength);
	} else {
		this1.uniformMatrix4fv(location,transpose,data);
	}
};
lime_graphics_WebGL2RenderContext.fromGL = function(gl) {
	return null;
};
lime_graphics_WebGL2RenderContext.fromRenderContext = function(context) {
	return context.webgl2;
};
lime_graphics_WebGL2RenderContext.toWebGLRenderContext = function(gl) {
	return gl;
};
var lime_graphics_WebGLRenderContext = {};
lime_graphics_WebGLRenderContext.bufferData = function(this1,target,srcData,usage) {
	var srcOffset = null;
	if(srcOffset != null) {
		this1.bufferData(target,srcData,usage,srcOffset,null);
	} else {
		this1.bufferData(target,srcData,usage);
	}
};
lime_graphics_WebGLRenderContext.bufferSubData = function(this1,target,offset,srcData) {
	var srcOffset = null;
	if(srcOffset != null) {
		this1.bufferSubData(target,offset,srcData,srcOffset,null);
	} else {
		this1.bufferSubData(target,offset,srcData);
	}
};
lime_graphics_WebGLRenderContext.compressedTexImage2D = function(this1,target,level,internalformat,width,height,border,srcData) {
	var srcOffset = null;
	if(srcOffset != null) {
		this1.compressedTexImage2D(target,level,internalformat,width,height,border,srcData,srcOffset,null);
	} else {
		this1.compressedTexImage2D(target,level,internalformat,width,height,border,srcData);
	}
};
lime_graphics_WebGLRenderContext.compressedTexSubImage2D = function(this1,target,level,xoffset,yoffset,width,height,format,srcData) {
	var srcOffset = null;
	if(srcOffset != null) {
		this1.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,srcData,srcOffset,null);
	} else {
		this1.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,srcData);
	}
};
lime_graphics_WebGLRenderContext.readPixels = function(this1,x,y,width,height,format,type,pixels) {
	var dstOffset = null;
	if(dstOffset != null) {
		this1.readPixels(x,y,width,height,format,type,pixels,dstOffset);
	} else {
		this1.readPixels(x,y,width,height,format,type,pixels);
	}
};
lime_graphics_WebGLRenderContext.texImage2D = function(this1,target,level,internalformat,width,height,border,format,type,srcData) {
	var srcOffset = null;
	if(srcOffset != null) {
		this1.texImage2D(target,level,internalformat,width,height,border,format,type,srcData,srcOffset);
	} else if(format != null) {
		this1.texImage2D(target,level,internalformat,width,height,border,format,type,srcData);
	} else {
		this1.texImage2D(target,level,internalformat,width,height,border);
	}
};
lime_graphics_WebGLRenderContext.texSubImage2D = function(this1,target,level,xoffset,yoffset,width,height,format,type,srcData) {
	var srcOffset = null;
	if(srcOffset != null) {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,srcData,srcOffset);
	} else if(type != null) {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,srcData);
	} else {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format);
	}
};
lime_graphics_WebGLRenderContext.uniformMatrix2fv = function(this1,location,transpose,v) {
	var data = v;
	var srcOffset = null;
	if(srcOffset != null) {
		this1.uniformMatrix2fv(location,transpose,data,srcOffset,null);
	} else {
		this1.uniformMatrix2fv(location,transpose,data);
	}
};
lime_graphics_WebGLRenderContext.uniformMatrix3fv = function(this1,location,transpose,v) {
	var data = v;
	var srcOffset = null;
	if(srcOffset != null) {
		this1.uniformMatrix3fv(location,transpose,data,srcOffset,null);
	} else {
		this1.uniformMatrix3fv(location,transpose,data);
	}
};
lime_graphics_WebGLRenderContext.uniformMatrix4fv = function(this1,location,transpose,v) {
	var data = v;
	var srcOffset = null;
	if(srcOffset != null) {
		this1.uniformMatrix4fv(location,transpose,data,srcOffset,null);
	} else {
		this1.uniformMatrix4fv(location,transpose,data);
	}
};
lime_graphics_WebGLRenderContext.fromWebGL2RenderContext = function(gl) {
	return gl;
};
lime_graphics_WebGLRenderContext.fromRenderContext = function(context) {
	return context.webgl;
};
lime_graphics_WebGLRenderContext.fromGL = function(gl) {
	return lime_graphics_opengl_GL.context;
};
var lime_graphics_cairo_Cairo = function(surface) {
	var tmp = surface != null;
};
$hxClasses["lime.graphics.cairo.Cairo"] = lime_graphics_cairo_Cairo;
lime_graphics_cairo_Cairo.__name__ = "lime.graphics.cairo.Cairo";
lime_graphics_cairo_Cairo.__properties__ = {get_versionString:"get_versionString",get_version:"get_version"};
lime_graphics_cairo_Cairo.get_version = function() {
	return 0;
};
lime_graphics_cairo_Cairo.get_versionString = function() {
	return "";
};
lime_graphics_cairo_Cairo.prototype = {
	arc: function(xc,yc,radius,angle1,angle2) {
	}
	,arcNegative: function(xc,yc,radius,angle1,angle2) {
	}
	,clip: function() {
	}
	,clipExtents: function(x1,y1,x2,y2) {
	}
	,clipPreserve: function() {
	}
	,closePath: function() {
	}
	,copyPage: function() {
	}
	,curveTo: function(x1,y1,x2,y2,x3,y3) {
	}
	,fill: function() {
	}
	,fillExtents: function(x1,y1,x2,y2) {
	}
	,fillPreserve: function() {
	}
	,getOperator: function() {
		return 0;
	}
	,identityMatrix: function() {
	}
	,inClip: function(x,y) {
		return false;
	}
	,inFill: function(x,y) {
		return false;
	}
	,inStroke: function(x,y) {
		return false;
	}
	,lineTo: function(x,y) {
	}
	,mask: function(pattern) {
	}
	,maskSurface: function(surface,x,y) {
	}
	,moveTo: function(x,y) {
	}
	,newPath: function() {
	}
	,paint: function() {
	}
	,paintWithAlpha: function(alpha) {
	}
	,popGroup: function() {
		return null;
	}
	,popGroupToSource: function() {
	}
	,pushGroup: function() {
	}
	,pushGroupWithContent: function(content) {
	}
	,recreate: function(surface) {
	}
	,rectangle: function(x,y,width,height) {
	}
	,relCurveTo: function(dx1,dy1,dx2,dy2,dx3,dy3) {
	}
	,relLineTo: function(dx,dy) {
	}
	,relMoveTo: function(dx,dy) {
	}
	,resetClip: function() {
	}
	,restore: function() {
	}
	,rotate: function(amount) {
	}
	,save: function() {
	}
	,scale: function(x,y) {
	}
	,setFontSize: function(size) {
	}
	,setOperator: function(value) {
		return value;
	}
	,setSourceRGB: function(r,g,b) {
	}
	,setSourceRGBA: function(r,g,b,a) {
	}
	,setSourceSurface: function(surface,x,y) {
	}
	,showGlyphs: function(glyphs) {
	}
	,showPage: function() {
	}
	,showText: function(utf8) {
	}
	,status: function() {
		return 0;
	}
	,stroke: function() {
	}
	,strokeExtents: function(x1,y1,x2,y2) {
	}
	,strokePreserve: function() {
	}
	,textPath: function(utf8) {
	}
	,transform: function(matrix) {
	}
	,translate: function(x,y) {
	}
	,get_antialias: function() {
		return 0;
	}
	,set_antialias: function(value) {
		return value;
	}
	,get_currentPoint: function() {
		return null;
	}
	,get_dash: function() {
		return [];
	}
	,set_dash: function(value) {
		return value;
	}
	,get_dashCount: function() {
		return 0;
	}
	,get_fillRule: function() {
		return 0;
	}
	,set_fillRule: function(value) {
		return value;
	}
	,get_fontFace: function() {
		return 0;
	}
	,set_fontFace: function(value) {
		return value;
	}
	,get_fontOptions: function() {
		return null;
	}
	,set_fontOptions: function(value) {
		return value;
	}
	,get_groupTarget: function() {
		return 0;
	}
	,get_hasCurrentPoint: function() {
		return false;
	}
	,get_lineCap: function() {
		return 0;
	}
	,set_lineCap: function(value) {
		return value;
	}
	,get_lineJoin: function() {
		return 0;
	}
	,set_lineJoin: function(value) {
		return value;
	}
	,get_lineWidth: function() {
		return 0;
	}
	,set_lineWidth: function(value) {
		return value;
	}
	,get_matrix: function() {
		return null;
	}
	,set_matrix: function(value) {
		return value;
	}
	,get_miterLimit: function() {
		return 0;
	}
	,set_miterLimit: function(value) {
		return value;
	}
	,get_source: function() {
		return 0;
	}
	,set_source: function(value) {
		return value;
	}
	,get_target: function() {
		return 0;
	}
	,get_tolerance: function() {
		return 0;
	}
	,set_tolerance: function(value) {
		return value;
	}
	,__class__: lime_graphics_cairo_Cairo
	,__properties__: {set_tolerance:"set_tolerance",get_tolerance:"get_tolerance",get_target:"get_target",set_source:"set_source",get_source:"get_source",set_miterLimit:"set_miterLimit",get_miterLimit:"get_miterLimit",set_matrix:"set_matrix",get_matrix:"get_matrix",set_lineWidth:"set_lineWidth",get_lineWidth:"get_lineWidth",set_lineJoin:"set_lineJoin",get_lineJoin:"get_lineJoin",set_lineCap:"set_lineCap",get_lineCap:"get_lineCap",get_hasCurrentPoint:"get_hasCurrentPoint",get_groupTarget:"get_groupTarget",set_fontOptions:"set_fontOptions",get_fontOptions:"get_fontOptions",set_fontFace:"set_fontFace",get_fontFace:"get_fontFace",set_fillRule:"set_fillRule",get_fillRule:"get_fillRule",get_dashCount:"get_dashCount",set_dash:"set_dash",get_dash:"get_dash",get_currentPoint:"get_currentPoint",set_antialias:"set_antialias",get_antialias:"get_antialias"}
};
var lime_graphics_cairo_CairoFTFontFace = {};
lime_graphics_cairo_CairoFTFontFace._new = function() {
	var this1 = 0;
	return this1;
};
lime_graphics_cairo_CairoFTFontFace.create = function(face,loadFlags) {
	return 0;
};
var lime_graphics_cairo_CairoFontFace = {};
lime_graphics_cairo_CairoFontFace._new = function() {
	var this1 = null;
	return this1;
};
lime_graphics_cairo_CairoFontFace.status = function(this1) {
	return 0;
};
var lime_graphics_cairo_CairoFontOptions = {};
lime_graphics_cairo_CairoFontOptions.__properties__ = {set_subpixelOrder:"set_subpixelOrder",get_subpixelOrder:"get_subpixelOrder",set_hintStyle:"set_hintStyle",get_hintStyle:"get_hintStyle",set_hintMetrics:"set_hintMetrics",get_hintMetrics:"get_hintMetrics",set_antialias:"set_antialias",get_antialias:"get_antialias"};
lime_graphics_cairo_CairoFontOptions._new = function() {
	var this1 = null;
	return this1;
};
lime_graphics_cairo_CairoFontOptions.get_antialias = function(this1) {
	return 0;
};
lime_graphics_cairo_CairoFontOptions.set_antialias = function(this1,value) {
	return value;
};
lime_graphics_cairo_CairoFontOptions.get_hintMetrics = function(this1) {
	return 0;
};
lime_graphics_cairo_CairoFontOptions.set_hintMetrics = function(this1,value) {
	return value;
};
lime_graphics_cairo_CairoFontOptions.get_hintStyle = function(this1) {
	return 0;
};
lime_graphics_cairo_CairoFontOptions.set_hintStyle = function(this1,value) {
	return value;
};
lime_graphics_cairo_CairoFontOptions.get_subpixelOrder = function(this1) {
	return 0;
};
lime_graphics_cairo_CairoFontOptions.set_subpixelOrder = function(this1,value) {
	return value;
};
var lime_graphics_cairo_CairoGlyph = function(index,x,y) {
	if(y == null) {
		y = 0;
	}
	if(x == null) {
		x = 0;
	}
	this.index = index;
	this.x = x;
	this.y = y;
};
$hxClasses["lime.graphics.cairo.CairoGlyph"] = lime_graphics_cairo_CairoGlyph;
lime_graphics_cairo_CairoGlyph.__name__ = "lime.graphics.cairo.CairoGlyph";
lime_graphics_cairo_CairoGlyph.prototype = {
	__class__: lime_graphics_cairo_CairoGlyph
};
var lime_graphics_cairo_CairoImageSurface = {};
lime_graphics_cairo_CairoImageSurface.__properties__ = {get_width:"get_width",get_stride:"get_stride",get_height:"get_height",get_format:"get_format",get_data:"get_data"};
lime_graphics_cairo_CairoImageSurface._new = function(format,width,height) {
	var this1 = 0;
	return this1;
};
lime_graphics_cairo_CairoImageSurface.create = function(data,format,width,height,stride) {
	return 0;
};
lime_graphics_cairo_CairoImageSurface.fromImage = function(image) {
	return null;
};
lime_graphics_cairo_CairoImageSurface.get_data = function(this1) {
	return lime_utils_DataPointer.fromFloat(0);
};
lime_graphics_cairo_CairoImageSurface.get_format = function(this1) {
	return 0;
};
lime_graphics_cairo_CairoImageSurface.get_height = function(this1) {
	return 0;
};
lime_graphics_cairo_CairoImageSurface.get_stride = function(this1) {
	return 0;
};
lime_graphics_cairo_CairoImageSurface.get_width = function(this1) {
	return 0;
};
var lime_graphics_cairo_CairoPattern = {};
lime_graphics_cairo_CairoPattern.__properties__ = {set_matrix:"set_matrix",get_matrix:"get_matrix",set_filter:"set_filter",get_filter:"get_filter",set_extend:"set_extend",get_extend:"get_extend",get_colorStopCount:"get_colorStopCount"};
lime_graphics_cairo_CairoPattern._new = function(handle) {
	var this1 = handle;
	return this1;
};
lime_graphics_cairo_CairoPattern.addColorStopRGB = function(this1,offset,r,g,b) {
};
lime_graphics_cairo_CairoPattern.addColorStopRGBA = function(this1,offset,r,g,b,a) {
};
lime_graphics_cairo_CairoPattern.createForSurface = function(surface) {
	return 0;
};
lime_graphics_cairo_CairoPattern.createLinear = function(x0,y0,x1,y1) {
	return 0;
};
lime_graphics_cairo_CairoPattern.createRadial = function(cx0,cy0,radius0,cx1,cy1,radius1) {
	return 0;
};
lime_graphics_cairo_CairoPattern.createRGB = function(r,g,b) {
	return 0;
};
lime_graphics_cairo_CairoPattern.createRGBA = function(r,g,b,a) {
	return 0;
};
lime_graphics_cairo_CairoPattern.get_colorStopCount = function(this1) {
	return 0;
};
lime_graphics_cairo_CairoPattern.get_extend = function(this1) {
	return 0;
};
lime_graphics_cairo_CairoPattern.set_extend = function(this1,value) {
	return value;
};
lime_graphics_cairo_CairoPattern.get_filter = function(this1) {
	return 0;
};
lime_graphics_cairo_CairoPattern.set_filter = function(this1,value) {
	return value;
};
lime_graphics_cairo_CairoPattern.get_matrix = function(this1) {
	return null;
};
lime_graphics_cairo_CairoPattern.set_matrix = function(this1,value) {
	return value;
};
var lime_graphics_cairo_CairoSurface = {};
lime_graphics_cairo_CairoSurface.flush = function(this1) {
};
var lime_graphics_opengl_GL = function() { };
$hxClasses["lime.graphics.opengl.GL"] = lime_graphics_opengl_GL;
lime_graphics_opengl_GL.__name__ = "lime.graphics.opengl.GL";
lime_graphics_opengl_GL.activeTexture = function(texture) {
	lime_graphics_opengl_GL.context.activeTexture(texture);
};
lime_graphics_opengl_GL.attachShader = function(program,shader) {
	lime_graphics_opengl_GL.context.attachShader(program,shader);
};
lime_graphics_opengl_GL.beginQuery = function(target,query) {
	lime_graphics_opengl_GL.context.beginQuery(target,query);
};
lime_graphics_opengl_GL.beginTransformFeedback = function(primitiveNode) {
	lime_graphics_opengl_GL.context.beginTransformFeedback(primitiveNode);
};
lime_graphics_opengl_GL.bindAttribLocation = function(program,index,name) {
	lime_graphics_opengl_GL.context.bindAttribLocation(program,index,name);
};
lime_graphics_opengl_GL.bindBuffer = function(target,buffer) {
	lime_graphics_opengl_GL.context.bindBuffer(target,buffer);
};
lime_graphics_opengl_GL.bindBufferBase = function(target,index,buffer) {
	lime_graphics_opengl_GL.context.bindBufferBase(target,index,buffer);
};
lime_graphics_opengl_GL.bindBufferRange = function(target,index,buffer,offset,size) {
	lime_graphics_opengl_GL.context.bindBufferRange(target,index,buffer,offset,lime_utils_DataPointer.fromFloat(size));
};
lime_graphics_opengl_GL.bindFramebuffer = function(target,framebuffer) {
	lime_graphics_opengl_GL.context.bindFramebuffer(target,framebuffer);
};
lime_graphics_opengl_GL.bindRenderbuffer = function(target,renderbuffer) {
	lime_graphics_opengl_GL.context.bindRenderbuffer(target,renderbuffer);
};
lime_graphics_opengl_GL.bindSampler = function(unit,sampler) {
	lime_graphics_opengl_GL.context.bindSampler(unit,sampler);
};
lime_graphics_opengl_GL.bindTexture = function(target,texture) {
	lime_graphics_opengl_GL.context.bindTexture(target,texture);
};
lime_graphics_opengl_GL.bindTransformFeedback = function(target,transformFeedback) {
	lime_graphics_opengl_GL.context.bindTransformFeedback(target,transformFeedback);
};
lime_graphics_opengl_GL.bindVertexArray = function(vertexArray) {
	lime_graphics_opengl_GL.context.bindVertexArray(vertexArray);
};
lime_graphics_opengl_GL.blitFramebuffer = function(srcX0,srcY0,srcX1,srcY1,dstX0,dstY0,dstX1,dstY1,mask,filter) {
	lime_graphics_opengl_GL.context.blitFramebuffer(srcX0,srcY0,srcX1,srcY1,dstX0,dstY0,dstX1,dstY1,mask,filter);
};
lime_graphics_opengl_GL.blendColor = function(red,green,blue,alpha) {
	lime_graphics_opengl_GL.context.blendColor(red,green,blue,alpha);
};
lime_graphics_opengl_GL.blendEquation = function(mode) {
	lime_graphics_opengl_GL.context.blendEquation(mode);
};
lime_graphics_opengl_GL.blendEquationSeparate = function(modeRGB,modeAlpha) {
	lime_graphics_opengl_GL.context.blendEquationSeparate(modeRGB,modeAlpha);
};
lime_graphics_opengl_GL.blendFunc = function(sfactor,dfactor) {
	lime_graphics_opengl_GL.context.blendFunc(sfactor,dfactor);
};
lime_graphics_opengl_GL.blendFuncSeparate = function(srcRGB,dstRGB,srcAlpha,dstAlpha) {
	lime_graphics_opengl_GL.context.blendFuncSeparate(srcRGB,dstRGB,srcAlpha,dstAlpha);
};
lime_graphics_opengl_GL.bufferDataWEBGL = function(target,srcData,usage,srcOffset,length) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.bufferData(target,srcData,usage,srcOffset,length);
	} else {
		this1.bufferData(target,srcData,usage);
	}
};
lime_graphics_opengl_GL.bufferSubDataWEBGL = function(target,dstByteOffset,srcData,srcOffset,length) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.bufferSubData(target,dstByteOffset,srcData,srcOffset,length);
	} else {
		this1.bufferSubData(target,dstByteOffset,srcData);
	}
};
lime_graphics_opengl_GL.checkFramebufferStatus = function(target) {
	return lime_graphics_opengl_GL.context.checkFramebufferStatus(target);
};
lime_graphics_opengl_GL.clear = function(mask) {
	lime_graphics_opengl_GL.context.clear(mask);
};
lime_graphics_opengl_GL.clearBufferfi = function(buffer,drawbuffer,depth,stencil) {
	lime_graphics_opengl_GL.context.clearBufferfi(buffer,drawbuffer,depth,stencil);
};
lime_graphics_opengl_GL.clearBufferfvWEBGL = function(buffer,drawbuffer,values,srcOffset) {
	lime_graphics_opengl_GL.context.clearBufferfv(buffer,drawbuffer,values,srcOffset);
};
lime_graphics_opengl_GL.clearBufferivWEBGL = function(buffer,drawbuffer,values,srcOffset) {
	lime_graphics_opengl_GL.context.clearBufferiv(buffer,drawbuffer,values,srcOffset);
};
lime_graphics_opengl_GL.clearBufferuivWEBGL = function(buffer,drawbuffer,values,srcOffset) {
	lime_graphics_opengl_GL.context.clearBufferuiv(buffer,drawbuffer,values,srcOffset);
};
lime_graphics_opengl_GL.clearColor = function(red,green,blue,alpha) {
	lime_graphics_opengl_GL.context.clearColor(red,green,blue,alpha);
};
lime_graphics_opengl_GL.clearDepth = function(depth) {
	lime_graphics_opengl_GL.context.clearDepth(depth);
};
lime_graphics_opengl_GL.clearStencil = function(s) {
	lime_graphics_opengl_GL.context.clearStencil(s);
};
lime_graphics_opengl_GL.clientWaitSync = function(sync,flags,timeout) {
	return lime_graphics_opengl_GL.context.clientWaitSync(sync,flags,timeout);
};
lime_graphics_opengl_GL.colorMask = function(red,green,blue,alpha) {
	lime_graphics_opengl_GL.context.colorMask(red,green,blue,alpha);
};
lime_graphics_opengl_GL.compileShader = function(shader) {
	lime_graphics_opengl_GL.context.compileShader(shader);
};
lime_graphics_opengl_GL.compressedTexImage2DWEBGL = function(target,level,internalformat,width,height,border,srcData,srcOffset,srcLengthOverride) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.compressedTexImage2D(target,level,internalformat,width,height,border,srcData,srcOffset,srcLengthOverride);
	} else {
		this1.compressedTexImage2D(target,level,internalformat,width,height,border,srcData);
	}
};
lime_graphics_opengl_GL.compressedTexImage3DWEBGL = function(target,level,internalformat,width,height,depth,border,srcData,srcOffset,srcLengthOverride) {
	lime_graphics_opengl_GL.context.compressedTexImage3D(target,level,internalformat,width,height,depth,border,srcData,srcOffset,srcLengthOverride);
};
lime_graphics_opengl_GL.compressedTexSubImage2DWEBGL = function(target,level,xoffset,yoffset,width,height,format,srcData,srcOffset,srcLengthOverride) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,srcData,srcOffset,srcLengthOverride);
	} else {
		this1.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,srcData);
	}
};
lime_graphics_opengl_GL.compressedTexSubImage3DWEBGL = function(target,level,xoffset,yoffset,zoffset,width,height,depth,format,srcData,srcOffset,srcLengthOverride) {
	lime_graphics_opengl_GL.context.compressedTexSubImage3D(target,level,xoffset,yoffset,zoffset,width,height,depth,format,srcData,srcOffset,srcLengthOverride);
};
lime_graphics_opengl_GL.copyTexImage2D = function(target,level,internalformat,x,y,width,height,border) {
	lime_graphics_opengl_GL.context.copyTexImage2D(target,level,internalformat,x,y,width,height,border);
};
lime_graphics_opengl_GL.copyTexSubImage2D = function(target,level,xoffset,yoffset,x,y,width,height) {
	lime_graphics_opengl_GL.context.copyTexSubImage2D(target,level,xoffset,yoffset,x,y,width,height);
};
lime_graphics_opengl_GL.copyTexSubImage3D = function(target,level,xoffset,yoffset,zoffset,x,y,width,height) {
	lime_graphics_opengl_GL.context.copyTexSubImage3D(target,level,xoffset,yoffset,zoffset,x,y,width,height);
};
lime_graphics_opengl_GL.createBuffer = function() {
	return lime_graphics_opengl_GL.context.createBuffer();
};
lime_graphics_opengl_GL.createFramebuffer = function() {
	return lime_graphics_opengl_GL.context.createFramebuffer();
};
lime_graphics_opengl_GL.createProgram = function() {
	return lime_graphics_opengl_GL.context.createProgram();
};
lime_graphics_opengl_GL.createQuery = function() {
	return lime_graphics_opengl_GL.context.createQuery();
};
lime_graphics_opengl_GL.createRenderbuffer = function() {
	return lime_graphics_opengl_GL.context.createRenderbuffer();
};
lime_graphics_opengl_GL.createSampler = function() {
	return lime_graphics_opengl_GL.context.createSampler();
};
lime_graphics_opengl_GL.createShader = function(type) {
	return lime_graphics_opengl_GL.context.createShader(type);
};
lime_graphics_opengl_GL.createTexture = function() {
	return lime_graphics_opengl_GL.context.createTexture();
};
lime_graphics_opengl_GL.createTransformFeedback = function() {
	return lime_graphics_opengl_GL.context.createTransformFeedback();
};
lime_graphics_opengl_GL.createVertexArray = function() {
	return lime_graphics_opengl_GL.context.createVertexArray();
};
lime_graphics_opengl_GL.cullFace = function(mode) {
	lime_graphics_opengl_GL.context.cullFace(mode);
};
lime_graphics_opengl_GL.deleteBuffer = function(buffer) {
	lime_graphics_opengl_GL.context.deleteBuffer(buffer);
};
lime_graphics_opengl_GL.deleteFramebuffer = function(framebuffer) {
	lime_graphics_opengl_GL.context.deleteFramebuffer(framebuffer);
};
lime_graphics_opengl_GL.deleteProgram = function(program) {
	lime_graphics_opengl_GL.context.deleteProgram(program);
};
lime_graphics_opengl_GL.deleteQuery = function(query) {
	lime_graphics_opengl_GL.context.deleteQuery(query);
};
lime_graphics_opengl_GL.deleteRenderbuffer = function(renderbuffer) {
	lime_graphics_opengl_GL.context.deleteRenderbuffer(renderbuffer);
};
lime_graphics_opengl_GL.deleteSampler = function(sampler) {
	lime_graphics_opengl_GL.context.deleteSampler(sampler);
};
lime_graphics_opengl_GL.deleteShader = function(shader) {
	lime_graphics_opengl_GL.context.deleteShader(shader);
};
lime_graphics_opengl_GL.deleteSync = function(sync) {
	lime_graphics_opengl_GL.context.deleteSync(sync);
};
lime_graphics_opengl_GL.deleteTexture = function(texture) {
	lime_graphics_opengl_GL.context.deleteTexture(texture);
};
lime_graphics_opengl_GL.deleteTransformFeedback = function(transformFeedback) {
	lime_graphics_opengl_GL.context.deleteTransformFeedback(transformFeedback);
};
lime_graphics_opengl_GL.deleteVertexArray = function(vertexArray) {
	lime_graphics_opengl_GL.context.deleteVertexArray(vertexArray);
};
lime_graphics_opengl_GL.depthFunc = function(func) {
	lime_graphics_opengl_GL.context.depthFunc(func);
};
lime_graphics_opengl_GL.depthMask = function(flag) {
	lime_graphics_opengl_GL.context.depthMask(flag);
};
lime_graphics_opengl_GL.depthRange = function(zNear,zFar) {
	lime_graphics_opengl_GL.context.depthRange(zNear,zFar);
};
lime_graphics_opengl_GL.detachShader = function(program,shader) {
	lime_graphics_opengl_GL.context.detachShader(program,shader);
};
lime_graphics_opengl_GL.disable = function(cap) {
	lime_graphics_opengl_GL.context.disable(cap);
};
lime_graphics_opengl_GL.disableVertexAttribArray = function(index) {
	lime_graphics_opengl_GL.context.disableVertexAttribArray(index);
};
lime_graphics_opengl_GL.drawArrays = function(mode,first,count) {
	lime_graphics_opengl_GL.context.drawArrays(mode,first,count);
};
lime_graphics_opengl_GL.drawArraysInstanced = function(mode,first,count,instanceCount) {
	lime_graphics_opengl_GL.context.drawArraysInstanced(mode,first,count,instanceCount);
};
lime_graphics_opengl_GL.drawBuffers = function(buffers) {
	lime_graphics_opengl_GL.context.drawBuffers(buffers);
};
lime_graphics_opengl_GL.drawElements = function(mode,count,type,offset) {
	lime_graphics_opengl_GL.context.drawElements(mode,count,type,offset);
};
lime_graphics_opengl_GL.drawElementsInstanced = function(mode,count,type,offset,instanceCount) {
	lime_graphics_opengl_GL.context.drawElementsInstanced(mode,count,type,offset,instanceCount);
};
lime_graphics_opengl_GL.drawRangeElements = function(mode,start,end,count,type,offset) {
	lime_graphics_opengl_GL.context.drawRangeElements(mode,start,end,count,type,offset);
};
lime_graphics_opengl_GL.enable = function(cap) {
	lime_graphics_opengl_GL.context.enable(cap);
};
lime_graphics_opengl_GL.enableVertexAttribArray = function(index) {
	lime_graphics_opengl_GL.context.enableVertexAttribArray(index);
};
lime_graphics_opengl_GL.endQuery = function(target) {
	lime_graphics_opengl_GL.context.endQuery(target);
};
lime_graphics_opengl_GL.endTransformFeedback = function() {
	lime_graphics_opengl_GL.context.endTransformFeedback();
};
lime_graphics_opengl_GL.fenceSync = function(condition,flags) {
	return lime_graphics_opengl_GL.context.fenceSync(condition,flags);
};
lime_graphics_opengl_GL.finish = function() {
	lime_graphics_opengl_GL.context.finish();
};
lime_graphics_opengl_GL.flush = function() {
	lime_graphics_opengl_GL.context.flush();
};
lime_graphics_opengl_GL.framebufferRenderbuffer = function(target,attachment,renderbuffertarget,renderbuffer) {
	lime_graphics_opengl_GL.context.framebufferRenderbuffer(target,attachment,renderbuffertarget,renderbuffer);
};
lime_graphics_opengl_GL.framebufferTexture2D = function(target,attachment,textarget,texture,level) {
	lime_graphics_opengl_GL.context.framebufferTexture2D(target,attachment,textarget,texture,level);
};
lime_graphics_opengl_GL.framebufferTextureLayer = function(target,attachment,texture,level,layer) {
	lime_graphics_opengl_GL.context.framebufferTextureLayer(target,attachment,texture,level,layer);
};
lime_graphics_opengl_GL.frontFace = function(mode) {
	lime_graphics_opengl_GL.context.frontFace(mode);
};
lime_graphics_opengl_GL.generateMipmap = function(target) {
	lime_graphics_opengl_GL.context.generateMipmap(target);
};
lime_graphics_opengl_GL.getActiveAttrib = function(program,index) {
	return lime_graphics_opengl_GL.context.getActiveAttrib(program,index);
};
lime_graphics_opengl_GL.getActiveUniform = function(program,index) {
	return lime_graphics_opengl_GL.context.getActiveUniform(program,index);
};
lime_graphics_opengl_GL.getActiveUniformBlockName = function(program,uniformBlockIndex) {
	return lime_graphics_opengl_GL.context.getActiveUniformBlockName(program,uniformBlockIndex);
};
lime_graphics_opengl_GL.getActiveUniformBlockParameter = function(program,uniformBlockIndex,pname) {
	return lime_graphics_opengl_GL.context.getActiveUniformBlockParameter(program,uniformBlockIndex,pname);
};
lime_graphics_opengl_GL.getActiveUniforms = function(program,uniformIndices,pname) {
	return lime_graphics_opengl_GL.context.getActiveUniforms(program,uniformIndices,pname);
};
lime_graphics_opengl_GL.getAttachedShaders = function(program) {
	return lime_graphics_opengl_GL.context.getAttachedShaders(program);
};
lime_graphics_opengl_GL.getAttribLocation = function(program,name) {
	return lime_graphics_opengl_GL.context.getAttribLocation(program,name);
};
lime_graphics_opengl_GL.getBufferParameter = function(target,pname) {
	return lime_graphics_opengl_GL.context.getBufferParameter(target,pname);
};
lime_graphics_opengl_GL.getBufferSubDataWEBGL = function(target,srcByteOffset,dstData,srcOffset,length) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.getBufferSubData(target,srcByteOffset,dstData,srcOffset,length);
	} else {
		this1.getBufferSubData(target,srcByteOffset,dstData);
	}
};
lime_graphics_opengl_GL.getContextAttributes = function() {
	return lime_graphics_opengl_GL.context.getContextAttributes();
};
lime_graphics_opengl_GL.getError = function() {
	return lime_graphics_opengl_GL.context.getError();
};
lime_graphics_opengl_GL.getExtension = function(name) {
	return lime_graphics_opengl_GL.context.getExtension(name);
};
lime_graphics_opengl_GL.getFragDataLocation = function(program,name) {
	return lime_graphics_opengl_GL.context.getFragDataLocation(program,name);
};
lime_graphics_opengl_GL.getFramebufferAttachmentParameter = function(target,attachment,pname) {
	return lime_graphics_opengl_GL.context.getFramebufferAttachmentParameter(target,attachment,pname);
};
lime_graphics_opengl_GL.getIndexedParameter = function(target,index) {
	return lime_graphics_opengl_GL.context.getIndexedParameter(target,index);
};
lime_graphics_opengl_GL.getInternalformatParameter = function(target,internalformat,pname) {
	return lime_graphics_opengl_GL.context.getInternalformatParameter(target,internalformat,pname);
};
lime_graphics_opengl_GL.getParameter = function(pname) {
	return lime_graphics_opengl_GL.context.getParameter(pname);
};
lime_graphics_opengl_GL.getProgramInfoLog = function(program) {
	return lime_graphics_opengl_GL.context.getProgramInfoLog(program);
};
lime_graphics_opengl_GL.getProgramParameter = function(program,pname) {
	return lime_graphics_opengl_GL.context.getProgramParameter(program,pname);
};
lime_graphics_opengl_GL.getQuery = function(target,pname) {
	return lime_graphics_opengl_GL.context.getQuery(target,pname);
};
lime_graphics_opengl_GL.getQueryParameter = function(query,pname) {
	return lime_graphics_opengl_GL.context.getQueryParameter(query,pname);
};
lime_graphics_opengl_GL.getRenderbufferParameter = function(target,pname) {
	return lime_graphics_opengl_GL.context.getRenderbufferParameter(target,pname);
};
lime_graphics_opengl_GL.getSamplerParameter = function(sampler,pname) {
	return lime_graphics_opengl_GL.context.getSamplerParameter(sampler,pname);
};
lime_graphics_opengl_GL.getShaderInfoLog = function(shader) {
	return lime_graphics_opengl_GL.context.getShaderInfoLog(shader);
};
lime_graphics_opengl_GL.getShaderParameter = function(shader,pname) {
	return lime_graphics_opengl_GL.context.getShaderParameter(shader,pname);
};
lime_graphics_opengl_GL.getShaderPrecisionFormat = function(shadertype,precisiontype) {
	return lime_graphics_opengl_GL.context.getShaderPrecisionFormat(shadertype,precisiontype);
};
lime_graphics_opengl_GL.getShaderSource = function(shader) {
	return lime_graphics_opengl_GL.context.getShaderSource(shader);
};
lime_graphics_opengl_GL.getSupportedExtensions = function() {
	return lime_graphics_opengl_GL.context.getSupportedExtensions();
};
lime_graphics_opengl_GL.getSyncParameter = function(sync,pname) {
	return lime_graphics_opengl_GL.context.getSyncParameter(sync,pname);
};
lime_graphics_opengl_GL.getTexParameter = function(target,pname) {
	return lime_graphics_opengl_GL.context.getTexParameter(target,pname);
};
lime_graphics_opengl_GL.getTransformFeedbackVarying = function(program,index) {
	return lime_graphics_opengl_GL.context.getTransformFeedbackVarying(program,index);
};
lime_graphics_opengl_GL.getUniform = function(program,location) {
	return lime_graphics_opengl_GL.context.getUniform(program,location);
};
lime_graphics_opengl_GL.getUniformBlockIndex = function(program,uniformBlockName) {
	return lime_graphics_opengl_GL.context.getUniformBlockIndex(program,uniformBlockName);
};
lime_graphics_opengl_GL.getUniformIndices = function(program,uniformNames) {
	return lime_graphics_opengl_GL.context.getUniformIndices(program,uniformNames);
};
lime_graphics_opengl_GL.getUniformLocation = function(program,name) {
	return lime_graphics_opengl_GL.context.getUniformLocation(program,name);
};
lime_graphics_opengl_GL.getVertexAttrib = function(index,pname) {
	return lime_graphics_opengl_GL.context.getVertexAttrib(index,pname);
};
lime_graphics_opengl_GL.getVertexAttribOffset = function(index,pname) {
	return lime_utils_DataPointer.fromFloat(lime_graphics_opengl_GL.context.getVertexAttribOffset(index,pname));
};
lime_graphics_opengl_GL.hint = function(target,mode) {
	lime_graphics_opengl_GL.context.hint(target,mode);
};
lime_graphics_opengl_GL.invalidateFramebuffer = function(target,attachments) {
	lime_graphics_opengl_GL.context.invalidateFramebuffer(target,attachments);
};
lime_graphics_opengl_GL.invalidateSubFramebuffer = function(target,attachments,x,y,width,height) {
	lime_graphics_opengl_GL.context.invalidateSubFramebuffer(target,attachments,x,y,width,height);
};
lime_graphics_opengl_GL.isBuffer = function(buffer) {
	return lime_graphics_opengl_GL.context.isBuffer(buffer);
};
lime_graphics_opengl_GL.isContextLost = function() {
	return lime_graphics_opengl_GL.context.isContextLost();
};
lime_graphics_opengl_GL.isEnabled = function(cap) {
	return lime_graphics_opengl_GL.context.isEnabled(cap);
};
lime_graphics_opengl_GL.isFramebuffer = function(framebuffer) {
	return lime_graphics_opengl_GL.context.isFramebuffer(framebuffer);
};
lime_graphics_opengl_GL.isProgram = function(program) {
	return lime_graphics_opengl_GL.context.isProgram(program);
};
lime_graphics_opengl_GL.isQuery = function(query) {
	return lime_graphics_opengl_GL.context.isQuery(query);
};
lime_graphics_opengl_GL.isRenderbuffer = function(renderbuffer) {
	return lime_graphics_opengl_GL.context.isRenderbuffer(renderbuffer);
};
lime_graphics_opengl_GL.isSampler = function(sampler) {
	return lime_graphics_opengl_GL.context.isSampler(sampler);
};
lime_graphics_opengl_GL.isShader = function(shader) {
	return lime_graphics_opengl_GL.context.isShader(shader);
};
lime_graphics_opengl_GL.isSync = function(sync) {
	return lime_graphics_opengl_GL.context.isSync(sync);
};
lime_graphics_opengl_GL.isTexture = function(texture) {
	return lime_graphics_opengl_GL.context.isTexture(texture);
};
lime_graphics_opengl_GL.isTransformFeedback = function(transformFeedback) {
	return lime_graphics_opengl_GL.context.isTransformFeedback(transformFeedback);
};
lime_graphics_opengl_GL.isVertexArray = function(vertexArray) {
	return lime_graphics_opengl_GL.context.isVertexArray(vertexArray);
};
lime_graphics_opengl_GL.lineWidth = function(width) {
	lime_graphics_opengl_GL.context.lineWidth(width);
};
lime_graphics_opengl_GL.linkProgram = function(program) {
	lime_graphics_opengl_GL.context.linkProgram(program);
};
lime_graphics_opengl_GL.pauseTransformFeedback = function() {
	lime_graphics_opengl_GL.context.pauseTransformFeedback();
};
lime_graphics_opengl_GL.pixelStorei = function(pname,param) {
	lime_graphics_opengl_GL.context.pixelStorei(pname,param);
};
lime_graphics_opengl_GL.polygonOffset = function(factor,units) {
	lime_graphics_opengl_GL.context.polygonOffset(factor,units);
};
lime_graphics_opengl_GL.readBuffer = function(src) {
	lime_graphics_opengl_GL.context.readBuffer(src);
};
lime_graphics_opengl_GL.readPixelsWEBGL = function(x,y,width,height,format,type,pixels,dstOffset) {
	var this1 = lime_graphics_opengl_GL.context;
	if(dstOffset != null) {
		this1.readPixels(x,y,width,height,format,type,pixels,dstOffset);
	} else {
		this1.readPixels(x,y,width,height,format,type,pixels);
	}
};
lime_graphics_opengl_GL.renderbufferStorage = function(target,internalformat,width,height) {
	lime_graphics_opengl_GL.context.renderbufferStorage(target,internalformat,width,height);
};
lime_graphics_opengl_GL.renderbufferStorageMultisample = function(target,samples,internalformat,width,height) {
	lime_graphics_opengl_GL.context.renderbufferStorageMultisample(target,samples,internalformat,width,height);
};
lime_graphics_opengl_GL.resumeTransformFeedback = function() {
	lime_graphics_opengl_GL.context.resumeTransformFeedback();
};
lime_graphics_opengl_GL.sampleCoverage = function(value,invert) {
	lime_graphics_opengl_GL.context.sampleCoverage(value,invert);
};
lime_graphics_opengl_GL.samplerParameterf = function(sampler,pname,param) {
	lime_graphics_opengl_GL.context.samplerParameterf(sampler,pname,param);
};
lime_graphics_opengl_GL.samplerParameteri = function(sampler,pname,param) {
	lime_graphics_opengl_GL.context.samplerParameteri(sampler,pname,param);
};
lime_graphics_opengl_GL.scissor = function(x,y,width,height) {
	lime_graphics_opengl_GL.context.scissor(x,y,width,height);
};
lime_graphics_opengl_GL.shaderSource = function(shader,source) {
	lime_graphics_opengl_GL.context.shaderSource(shader,source);
};
lime_graphics_opengl_GL.stencilFunc = function(func,ref,mask) {
	lime_graphics_opengl_GL.context.stencilFunc(func,ref,mask);
};
lime_graphics_opengl_GL.stencilFuncSeparate = function(face,func,ref,mask) {
	lime_graphics_opengl_GL.context.stencilFuncSeparate(face,func,ref,mask);
};
lime_graphics_opengl_GL.stencilMask = function(mask) {
	lime_graphics_opengl_GL.context.stencilMask(mask);
};
lime_graphics_opengl_GL.stencilMaskSeparate = function(face,mask) {
	lime_graphics_opengl_GL.context.stencilMaskSeparate(face,mask);
};
lime_graphics_opengl_GL.stencilOp = function(fail,zfail,zpass) {
	lime_graphics_opengl_GL.context.stencilOp(fail,zfail,zpass);
};
lime_graphics_opengl_GL.stencilOpSeparate = function(face,fail,zfail,zpass) {
	lime_graphics_opengl_GL.context.stencilOpSeparate(face,fail,zfail,zpass);
};
lime_graphics_opengl_GL.texImage2DWEBGL = function(target,level,internalformat,width,height,border,format,type,srcData,srcOffset) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.texImage2D(target,level,internalformat,width,height,border,format,type,srcData,srcOffset);
	} else if(format != null) {
		this1.texImage2D(target,level,internalformat,width,height,border,format,type,srcData);
	} else {
		this1.texImage2D(target,level,internalformat,width,height,border);
	}
};
lime_graphics_opengl_GL.texImage3DWEBGL = function(target,level,internalformat,width,height,depth,border,format,type,srcData,srcOffset) {
	lime_graphics_opengl_GL.context.texImage3D(target,level,internalformat,width,height,depth,border,format,type,srcData,srcOffset);
};
lime_graphics_opengl_GL.texStorage2D = function(target,level,internalformat,width,height) {
	lime_graphics_opengl_GL.context.texStorage2D(target,level,internalformat,width,height);
};
lime_graphics_opengl_GL.texStorage3D = function(target,level,internalformat,width,height,depth) {
	lime_graphics_opengl_GL.context.texStorage3D(target,level,internalformat,width,height,depth);
};
lime_graphics_opengl_GL.texParameterf = function(target,pname,param) {
	lime_graphics_opengl_GL.context.texParameterf(target,pname,param);
};
lime_graphics_opengl_GL.texParameteri = function(target,pname,param) {
	lime_graphics_opengl_GL.context.texParameteri(target,pname,param);
};
lime_graphics_opengl_GL.texSubImage2DWEBGL = function(target,level,xoffset,yoffset,width,height,format,type,srcData,srcOffset) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,srcData,srcOffset);
	} else if(type != null) {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,srcData);
	} else {
		this1.texSubImage2D(target,level,xoffset,yoffset,width,height,format);
	}
};
lime_graphics_opengl_GL.texSubImage3DWEBGL = function(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,source,srcOffset) {
	lime_graphics_opengl_GL.context.texSubImage3D(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,source,srcOffset);
};
lime_graphics_opengl_GL.transformFeedbackVaryings = function(program,varyings,bufferMode) {
	lime_graphics_opengl_GL.context.transformFeedbackVaryings(program,varyings,bufferMode);
};
lime_graphics_opengl_GL.uniform1f = function(location,v0) {
	lime_graphics_opengl_GL.context.uniform1f(location,v0);
};
lime_graphics_opengl_GL.uniform1fvWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform1fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform1fv(location,data);
	}
};
lime_graphics_opengl_GL.uniform1i = function(location,v0) {
	lime_graphics_opengl_GL.context.uniform1i(location,v0);
};
lime_graphics_opengl_GL.uniform1ivWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform1iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform1iv(location,data);
	}
};
lime_graphics_opengl_GL.uniform1ui = function(location,v0) {
	lime_graphics_opengl_GL.context.uniform1ui(location,v0);
};
lime_graphics_opengl_GL.uniform1uivWEBGL = function(location,data,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniform1uiv(location,data,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniform2f = function(location,v0,v1) {
	lime_graphics_opengl_GL.context.uniform2f(location,v0,v1);
};
lime_graphics_opengl_GL.uniform2fvWEBGL = function(location,data,srcOffset,srcLength) {
	lime_graphics_WebGL2RenderContext.uniform2fv(lime_graphics_opengl_GL.context,location,data,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniform2i = function(location,x,y) {
	lime_graphics_opengl_GL.context.uniform2i(location,x,y);
};
lime_graphics_opengl_GL.uniform2ivWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform2iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform2iv(location,data);
	}
};
lime_graphics_opengl_GL.uniform2ui = function(location,x,y) {
	lime_graphics_opengl_GL.context.uniform2ui(location,x,y);
};
lime_graphics_opengl_GL.uniform2uivWEBGL = function(location,data,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniform2uiv(location,data,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniform3f = function(location,v0,v1,v2) {
	lime_graphics_opengl_GL.context.uniform3f(location,v0,v1,v2);
};
lime_graphics_opengl_GL.uniform3fvWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform3fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform3fv(location,data);
	}
};
lime_graphics_opengl_GL.uniform3i = function(location,v0,v1,v2) {
	lime_graphics_opengl_GL.context.uniform3i(location,v0,v1,v2);
};
lime_graphics_opengl_GL.uniform3ivWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform3iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform3iv(location,data);
	}
};
lime_graphics_opengl_GL.uniform3ui = function(location,v0,v1,v2) {
	lime_graphics_opengl_GL.context.uniform3ui(location,v0,v1,v2);
};
lime_graphics_opengl_GL.uniform3uivWEBGL = function(location,data,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniform3uiv(location,data,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniform4f = function(location,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.uniform4f(location,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.uniform4fvWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform4fv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform4fv(location,data);
	}
};
lime_graphics_opengl_GL.uniform4i = function(location,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.uniform4i(location,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.uniform4ivWEBGL = function(location,data,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniform4iv(location,data,srcOffset,srcLength);
	} else {
		this1.uniform4iv(location,data);
	}
};
lime_graphics_opengl_GL.uniform4ui = function(location,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.uniform4ui(location,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.uniform4uivWEBGL = function(location,data,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniform4uiv(location,data,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformBlockBinding = function(program,uniformBlockIndex,uniformBlockBinding) {
	lime_graphics_opengl_GL.context.uniformBlockBinding(program,uniformBlockIndex,uniformBlockBinding);
};
lime_graphics_opengl_GL.uniformMatrix2fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniformMatrix2fv(location,transpose,v,srcOffset,srcLength);
	} else {
		this1.uniformMatrix2fv(location,transpose,v);
	}
};
lime_graphics_opengl_GL.uniformMatrix2x3fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix2x3fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformMatrix2x4fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix2x4fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformMatrix3fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniformMatrix3fv(location,transpose,v,srcOffset,srcLength);
	} else {
		this1.uniformMatrix3fv(location,transpose,v);
	}
};
lime_graphics_opengl_GL.uniformMatrix3x2fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix3x2fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformMatrix3x4fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix3x4fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformMatrix4fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	var this1 = lime_graphics_opengl_GL.context;
	if(srcOffset != null) {
		this1.uniformMatrix4fv(location,transpose,v,srcOffset,srcLength);
	} else {
		this1.uniformMatrix4fv(location,transpose,v);
	}
};
lime_graphics_opengl_GL.uniformMatrix4x2fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix4x2fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.uniformMatrix4x3fvWEBGL = function(location,transpose,v,srcOffset,srcLength) {
	lime_graphics_opengl_GL.context.uniformMatrix4x3fv(location,transpose,v,srcOffset,srcLength);
};
lime_graphics_opengl_GL.useProgram = function(program) {
	lime_graphics_opengl_GL.context.useProgram(program);
};
lime_graphics_opengl_GL.validateProgram = function(program) {
	lime_graphics_opengl_GL.context.validateProgram(program);
};
lime_graphics_opengl_GL.vertexAttrib1f = function(index,v0) {
	lime_graphics_opengl_GL.context.vertexAttrib1f(index,v0);
};
lime_graphics_opengl_GL.vertexAttrib1fv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib1fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib1fvWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib1fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib2f = function(index,v0,v1) {
	lime_graphics_opengl_GL.context.vertexAttrib2f(index,v0,v1);
};
lime_graphics_opengl_GL.vertexAttrib2fv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib2fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib2fvWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib2fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib3f = function(index,v0,v1,v2) {
	lime_graphics_opengl_GL.context.vertexAttrib3f(index,v0,v1,v2);
};
lime_graphics_opengl_GL.vertexAttrib3fv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib3fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib3fvWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib3fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib4f = function(index,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.vertexAttrib4f(index,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.vertexAttrib4fv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib4fv(index,v);
};
lime_graphics_opengl_GL.vertexAttrib4fvWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttrib4fv(index,v);
};
lime_graphics_opengl_GL.vertexAttribDivisor = function(index,divisor) {
	lime_graphics_opengl_GL.context.vertexAttribDivisor(index,divisor);
};
lime_graphics_opengl_GL.vertexAttribI4i = function(index,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.vertexAttribI4i(index,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.vertexAttribI4iv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttribI4iv(index,v);
};
lime_graphics_opengl_GL.vertexAttribI4ivWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttribI4iv(index,v);
};
lime_graphics_opengl_GL.vertexAttribI4ui = function(index,v0,v1,v2,v3) {
	lime_graphics_opengl_GL.context.vertexAttribI4ui(index,v0,v1,v2,v3);
};
lime_graphics_opengl_GL.vertexAttribI4uiv = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttribI4uiv(index,v);
};
lime_graphics_opengl_GL.vertexAttribI4uivWEBGL = function(index,v) {
	lime_graphics_opengl_GL.context.vertexAttribI4uiv(index,v);
};
lime_graphics_opengl_GL.vertexAttribIPointer = function(index,size,type,stride,offset) {
	lime_graphics_opengl_GL.context.vertexAttribIPointer(index,size,type,stride,offset);
};
lime_graphics_opengl_GL.vertexAttribPointer = function(index,size,type,normalized,stride,offset) {
	lime_graphics_opengl_GL.context.vertexAttribPointer(index,size,type,normalized,stride,offset);
};
lime_graphics_opengl_GL.viewport = function(x,y,width,height) {
	lime_graphics_opengl_GL.context.viewport(x,y,width,height);
};
lime_graphics_opengl_GL.waitSync = function(sync,flags,timeout) {
	lime_graphics_opengl_GL.context.waitSync(sync,flags,timeout);
};
lime_graphics_opengl_GL.__getObjectID = function(object) {
	if(object == null) {
		return 0;
	} else {
		return object.id;
	}
};
var lime_graphics_opengl_GLProgram = {};
lime_graphics_opengl_GLProgram.fromSources = function(gl,vertexSource,fragmentSource) {
	var vertexShader = lime_graphics_opengl_GLShader.fromSource(gl,vertexSource,gl.VERTEX_SHADER);
	var fragmentShader = lime_graphics_opengl_GLShader.fromSource(gl,fragmentSource,gl.FRAGMENT_SHADER);
	var program = gl.createProgram();
	gl.attachShader(program,vertexShader);
	gl.attachShader(program,fragmentShader);
	gl.linkProgram(program);
	if(gl.getProgramParameter(program,35714) == 0) {
		var message = "Unable to initialize the shader program";
		message += "\n" + lime_graphics_opengl_GL.context.getProgramInfoLog(program);
		lime_utils_Log.error(message,{ fileName : "lime/graphics/opengl/GLProgram.hx", lineNumber : 39, className : "lime.graphics.opengl._GLProgram.GLProgram_Impl_", methodName : "fromSources"});
	}
	return program;
};
var lime_graphics_opengl_GLShader = {};
lime_graphics_opengl_GLShader.fromSource = function(gl,source,type) {
	var shader = gl.createShader(type);
	gl.shaderSource(shader,source);
	gl.compileShader(shader);
	if(gl.getShaderParameter(shader,gl.COMPILE_STATUS) == 0) {
		var message;
		if(type == gl.VERTEX_SHADER) {
			message = "Error compiling vertex shader";
		} else if(type == gl.FRAGMENT_SHADER) {
			message = "Error compiling fragment shader";
		} else {
			message = "Error compiling unknown shader type";
		}
		message += "\n" + gl.getShaderInfoLog(shader);
		lime_utils_Log.error(message,{ fileName : "lime/graphics/opengl/GLShader.hx", lineNumber : 40, className : "lime.graphics.opengl._GLShader.GLShader_Impl_", methodName : "fromSource"});
	}
	return shader;
};
var lime_graphics_opengl_ext_KHR_$debug = function() {
	this.STACK_UNDERFLOW = 1284;
	this.STACK_OVERFLOW = 1283;
	this.CONTEXT_FLAG_DEBUG_BIT = 2;
	this.DEBUG_OUTPUT = 37600;
	this.DEBUG_SEVERITY_LOW = 37192;
	this.DEBUG_SEVERITY_MEDIUM = 37191;
	this.DEBUG_SEVERITY_HIGH = 37190;
	this.DEBUG_LOGGED_MESSAGES = 37189;
	this.MAX_DEBUG_LOGGED_MESSAGES = 37188;
	this.MAX_DEBUG_MESSAGE_LENGTH = 37187;
	this.MAX_LABEL_LENGTH = 33512;
	this.SAMPLER = 33510;
	this.QUERY = 33507;
	this.PROGRAM = 33506;
	this.SHADER = 33505;
	this.BUFFER = 33504;
	this.DEBUG_GROUP_STACK_DEPTH = 33389;
	this.MAX_DEBUG_GROUP_STACK_DEPTH = 33388;
	this.DEBUG_SEVERITY_NOTIFICATION = 33387;
	this.DEBUG_TYPE_POP_GROUP = 33386;
	this.DEBUG_TYPE_PUSH_GROUP = 33385;
	this.DEBUG_TYPE_MARKER = 33384;
	this.DEBUG_TYPE_OTHER = 33361;
	this.DEBUG_TYPE_PERFORMANCE = 33360;
	this.DEBUG_TYPE_PORTABILITY = 33359;
	this.DEBUG_TYPE_UNDEFINED_BEHAVIOR = 33358;
	this.DEBUG_TYPE_DEPRECATED_BEHAVIOR = 33357;
	this.DEBUG_TYPE_ERROR = 33356;
	this.DEBUG_SOURCE_OTHER = 33355;
	this.DEBUG_SOURCE_APPLICATION = 33354;
	this.DEBUG_SOURCE_THIRD_PARTY = 33353;
	this.DEBUG_SOURCE_SHADER_COMPILER = 33352;
	this.DEBUG_SOURCE_WINDOW_SYSTEM = 33351;
	this.DEBUG_SOURCE_API = 33350;
	this.DEBUG_CALLBACK_USER_PARAM = 33349;
	this.DEBUG_CALLBACK_FUNCTION = 33348;
	this.DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 33347;
	this.DEBUG_OUTPUT_SYNCHRONOUS = 33346;
};
$hxClasses["lime.graphics.opengl.ext.KHR_debug"] = lime_graphics_opengl_ext_KHR_$debug;
lime_graphics_opengl_ext_KHR_$debug.__name__ = "lime.graphics.opengl.ext.KHR_debug";
lime_graphics_opengl_ext_KHR_$debug.prototype = {
	__class__: lime_graphics_opengl_ext_KHR_$debug
};
var lime_math_ARGB = {};
lime_math_ARGB.__properties__ = {set_r:"set_r",get_r:"get_r",set_g:"set_g",get_g:"get_g",set_b:"set_b",get_b:"get_b",set_a:"set_a",get_a:"get_a"};
lime_math_ARGB._new = function(argb) {
	if(argb == null) {
		argb = 0;
	}
	var this1 = argb;
	return this1;
};
lime_math_ARGB.create = function(a,r,g,b) {
	var this1 = 0;
	var argb = this1;
	argb = (a & 255) << 24 | (r & 255) << 16 | (g & 255) << 8 | b & 255;
	return argb;
};
lime_math_ARGB.multiplyAlpha = function(this1) {
	if((this1 >>> 24 & 255) == 0) {
		this1 = 0;
	} else if((this1 >>> 24 & 255) != 255) {
		lime_math_ARGB.a16 = lime_math_RGBA.__alpha16[this1 >>> 24 & 255];
		this1 = (this1 >>> 24 & 255 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math_ARGB.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math_ARGB.a16 >> 16 & 255) << 8 | (this1 & 255) * lime_math_ARGB.a16 >> 16 & 255;
	}
};
lime_math_ARGB.readUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	switch(format) {
	case 0:
		this1 = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 1:
		this1 = (data[offset + 2] & 255) << 24 | (data[offset + 3] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 1] & 255;
		break;
	case 2:
		this1 = (data[offset + 1] & 255) << 24 | (data[offset] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset + 2] & 255;
		break;
	}
	if(premultiplied) {
		if((this1 >>> 24 & 255) != 0 && (this1 >>> 24 & 255) != 255) {
			lime_math_ARGB.unmult = 255.0 / (this1 >>> 24 & 255);
			this1 = (this1 >>> 24 & 255 & 255) << 24 | (lime_math_RGBA.__clamp[Math.floor((this1 >>> 16 & 255) * lime_math_ARGB.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.floor((this1 >>> 8 & 255) * lime_math_ARGB.unmult)] & 255) << 8 | lime_math_RGBA.__clamp[Math.floor((this1 & 255) * lime_math_ARGB.unmult)] & 255;
		}
	}
};
lime_math_ARGB.set = function(this1,a,r,g,b) {
	this1 = (a & 255) << 24 | (r & 255) << 16 | (g & 255) << 8 | b & 255;
};
lime_math_ARGB.unmultiplyAlpha = function(this1) {
	if((this1 >>> 24 & 255) != 0 && (this1 >>> 24 & 255) != 255) {
		lime_math_ARGB.unmult = 255.0 / (this1 >>> 24 & 255);
		this1 = (this1 >>> 24 & 255 & 255) << 24 | (lime_math_RGBA.__clamp[Math.floor((this1 >>> 16 & 255) * lime_math_ARGB.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.floor((this1 >>> 8 & 255) * lime_math_ARGB.unmult)] & 255) << 8 | lime_math_RGBA.__clamp[Math.floor((this1 & 255) * lime_math_ARGB.unmult)] & 255;
	}
};
lime_math_ARGB.writeUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	if(premultiplied) {
		if((this1 >>> 24 & 255) == 0) {
			this1 = 0;
		} else if((this1 >>> 24 & 255) != 255) {
			lime_math_ARGB.a16 = lime_math_RGBA.__alpha16[this1 >>> 24 & 255];
			this1 = (this1 >>> 24 & 255 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math_ARGB.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math_ARGB.a16 >> 16 & 255) << 8 | (this1 & 255) * lime_math_ARGB.a16 >> 16 & 255;
		}
	}
	switch(format) {
	case 0:
		data[offset] = this1 >>> 16 & 255;
		data[offset + 1] = this1 >>> 8 & 255;
		data[offset + 2] = this1 & 255;
		data[offset + 3] = this1 >>> 24 & 255;
		break;
	case 1:
		data[offset] = this1 >>> 24 & 255;
		data[offset + 1] = this1 >>> 16 & 255;
		data[offset + 2] = this1 >>> 8 & 255;
		data[offset + 3] = this1 & 255;
		break;
	case 2:
		data[offset] = this1 & 255;
		data[offset + 1] = this1 >>> 8 & 255;
		data[offset + 2] = this1 >>> 16 & 255;
		data[offset + 3] = this1 >>> 24 & 255;
		break;
	}
};
lime_math_ARGB.__fromBGRA = function(bgra) {
	var this1 = 0;
	var argb = this1;
	argb = (bgra & 255 & 255) << 24 | (bgra >>> 8 & 255 & 255) << 16 | (bgra >>> 16 & 255 & 255) << 8 | bgra >>> 24 & 255 & 255;
	return argb;
};
lime_math_ARGB.__fromRGBA = function(rgba) {
	var this1 = 0;
	var argb = this1;
	argb = (rgba & 255 & 255) << 24 | (rgba >>> 24 & 255 & 255) << 16 | (rgba >>> 16 & 255 & 255) << 8 | rgba >>> 8 & 255 & 255;
	return argb;
};
lime_math_ARGB.get_a = function(this1) {
	return this1 >>> 24 & 255;
};
lime_math_ARGB.set_a = function(this1,value) {
	this1 = (value & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math_ARGB.get_b = function(this1) {
	return this1 & 255;
};
lime_math_ARGB.set_b = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | value & 255;
	return value;
};
lime_math_ARGB.get_g = function(this1) {
	return this1 >>> 8 & 255;
};
lime_math_ARGB.set_g = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (value & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math_ARGB.get_r = function(this1) {
	return this1 >>> 16 & 255;
};
lime_math_ARGB.set_r = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (value & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
var lime_math_BGRA = {};
lime_math_BGRA.__properties__ = {set_r:"set_r",get_r:"get_r",set_g:"set_g",get_g:"get_g",set_b:"set_b",get_b:"get_b",set_a:"set_a",get_a:"get_a"};
lime_math_BGRA._new = function(bgra) {
	if(bgra == null) {
		bgra = 0;
	}
	var this1 = bgra;
	return this1;
};
lime_math_BGRA.create = function(b,g,r,a) {
	var this1 = 0;
	var bgra = this1;
	bgra = (b & 255) << 24 | (g & 255) << 16 | (r & 255) << 8 | a & 255;
	return bgra;
};
lime_math_BGRA.multiplyAlpha = function(this1) {
	if((this1 & 255) == 0) {
		this1 = 0;
	} else if((this1 & 255) != 255) {
		lime_math_BGRA.a16 = lime_math_RGBA.__alpha16[this1 & 255];
		this1 = ((this1 >>> 24 & 255) * lime_math_BGRA.a16 >> 16 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math_BGRA.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math_BGRA.a16 >> 16 & 255) << 8 | this1 & 255 & 255;
	}
};
lime_math_BGRA.readUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	switch(format) {
	case 0:
		this1 = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		this1 = (data[offset + 3] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 1] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		this1 = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied) {
		if((this1 & 255) != 0 && (this1 & 255) != 255) {
			lime_math_BGRA.unmult = 255.0 / (this1 & 255);
			this1 = (lime_math_RGBA.__clamp[Math.floor((this1 >>> 24 & 255) * lime_math_BGRA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.floor((this1 >>> 16 & 255) * lime_math_BGRA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.floor((this1 >>> 8 & 255) * lime_math_BGRA.unmult)] & 255) << 8 | this1 & 255 & 255;
		}
	}
};
lime_math_BGRA.set = function(this1,b,g,r,a) {
	this1 = (b & 255) << 24 | (g & 255) << 16 | (r & 255) << 8 | a & 255;
};
lime_math_BGRA.unmultiplyAlpha = function(this1) {
	if((this1 & 255) != 0 && (this1 & 255) != 255) {
		lime_math_BGRA.unmult = 255.0 / (this1 & 255);
		this1 = (lime_math_RGBA.__clamp[Math.floor((this1 >>> 24 & 255) * lime_math_BGRA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.floor((this1 >>> 16 & 255) * lime_math_BGRA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.floor((this1 >>> 8 & 255) * lime_math_BGRA.unmult)] & 255) << 8 | this1 & 255 & 255;
	}
};
lime_math_BGRA.writeUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	if(premultiplied) {
		if((this1 & 255) == 0) {
			this1 = 0;
		} else if((this1 & 255) != 255) {
			lime_math_BGRA.a16 = lime_math_RGBA.__alpha16[this1 & 255];
			this1 = ((this1 >>> 24 & 255) * lime_math_BGRA.a16 >> 16 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math_BGRA.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math_BGRA.a16 >> 16 & 255) << 8 | this1 & 255 & 255;
		}
	}
	switch(format) {
	case 0:
		data[offset] = this1 >>> 8 & 255;
		data[offset + 1] = this1 >>> 16 & 255;
		data[offset + 2] = this1 >>> 24 & 255;
		data[offset + 3] = this1 & 255;
		break;
	case 1:
		data[offset] = this1 & 255;
		data[offset + 1] = this1 >>> 8 & 255;
		data[offset + 2] = this1 >>> 16 & 255;
		data[offset + 3] = this1 >>> 24 & 255;
		break;
	case 2:
		data[offset] = this1 >>> 24 & 255;
		data[offset + 1] = this1 >>> 16 & 255;
		data[offset + 2] = this1 >>> 8 & 255;
		data[offset + 3] = this1 & 255;
		break;
	}
};
lime_math_BGRA.__fromARGB = function(argb) {
	var this1 = 0;
	var bgra = this1;
	bgra = (argb & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb >>> 16 & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
	return bgra;
};
lime_math_BGRA.__fromRGBA = function(rgba) {
	var this1 = 0;
	var bgra = this1;
	bgra = (rgba >>> 8 & 255 & 255) << 24 | (rgba >>> 16 & 255 & 255) << 16 | (rgba >>> 24 & 255 & 255) << 8 | rgba & 255 & 255;
	return bgra;
};
lime_math_BGRA.get_a = function(this1) {
	return this1 & 255;
};
lime_math_BGRA.set_a = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | value & 255;
	return value;
};
lime_math_BGRA.get_b = function(this1) {
	return this1 >>> 24 & 255;
};
lime_math_BGRA.set_b = function(this1,value) {
	this1 = (value & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math_BGRA.get_g = function(this1) {
	return this1 >>> 16 & 255;
};
lime_math_BGRA.set_g = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (value & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math_BGRA.get_r = function(this1) {
	return this1 >>> 8 & 255;
};
lime_math_BGRA.set_r = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (value & 255) << 8 | this1 & 255 & 255;
	return value;
};
var lime_math_ColorMatrix = {};
lime_math_ColorMatrix.__properties__ = {set_redOffset:"set_redOffset",get_redOffset:"get_redOffset",set_redMultiplier:"set_redMultiplier",get_redMultiplier:"get_redMultiplier",set_greenOffset:"set_greenOffset",get_greenOffset:"get_greenOffset",set_greenMultiplier:"set_greenMultiplier",get_greenMultiplier:"get_greenMultiplier",set_color:"set_color",get_color:"get_color",set_blueOffset:"set_blueOffset",get_blueOffset:"get_blueOffset",set_blueMultiplier:"set_blueMultiplier",get_blueMultiplier:"get_blueMultiplier",set_alphaOffset:"set_alphaOffset",get_alphaOffset:"get_alphaOffset",set_alphaMultiplier:"set_alphaMultiplier",get_alphaMultiplier:"get_alphaMultiplier"};
lime_math_ColorMatrix._new = function(data) {
	var this1;
	if(data != null && data.length == 20) {
		this1 = data;
	} else {
		var elements = null;
		var array = lime_math_ColorMatrix.__identity;
		var vector = null;
		var view = null;
		var buffer = null;
		var len = null;
		var this2;
		if(elements != null) {
			this2 = new Float32Array(elements);
		} else if(array != null) {
			this2 = new Float32Array(array);
		} else if(vector != null) {
			this2 = new Float32Array(vector.__array);
		} else if(view != null) {
			this2 = new Float32Array(view);
		} else if(buffer != null) {
			if(len == null) {
				this2 = new Float32Array(buffer,0);
			} else {
				this2 = new Float32Array(buffer,0,len);
			}
		} else {
			this2 = null;
		}
		this1 = this2;
	}
	return this1;
};
lime_math_ColorMatrix.clone = function(this1) {
	var elements = null;
	var array = null;
	var vector = null;
	var view = lime_utils_Float32Array.toArrayBufferView(this1);
	var buffer = null;
	var len = null;
	var this1;
	if(elements != null) {
		this1 = new Float32Array(elements);
	} else if(array != null) {
		this1 = new Float32Array(array);
	} else if(vector != null) {
		this1 = new Float32Array(vector.__array);
	} else if(view != null) {
		this1 = new Float32Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this1 = new Float32Array(buffer,0);
		} else {
			this1 = new Float32Array(buffer,0,len);
		}
	} else {
		this1 = null;
	}
	return lime_math_ColorMatrix._new(this1);
};
lime_math_ColorMatrix.concat = function(this1,second) {
	this1[0] += second[0];
	this1[6] += second[6];
	this1[12] += second[12];
	this1[18] += second[18];
};
lime_math_ColorMatrix.copyFrom = function(this1,other) {
	this1.set(other);
};
lime_math_ColorMatrix.identity = function(this1) {
	this1[0] = 1;
	this1[1] = 0;
	this1[2] = 0;
	this1[3] = 0;
	this1[4] = 0;
	this1[5] = 0;
	this1[6] = 1;
	this1[7] = 0;
	this1[8] = 0;
	this1[9] = 0;
	this1[10] = 0;
	this1[11] = 0;
	this1[12] = 1;
	this1[13] = 0;
	this1[14] = 0;
	this1[15] = 0;
	this1[16] = 0;
	this1[17] = 0;
	this1[18] = 1;
	this1[19] = 0;
};
lime_math_ColorMatrix.getAlphaTable = function(this1) {
	if(lime_math_ColorMatrix.__alphaTable == null) {
		var array = null;
		var vector = null;
		var view = null;
		var buffer = null;
		var len = null;
		var this2 = new Uint8Array(256);
		lime_math_ColorMatrix.__alphaTable = this2;
	}
	var value;
	lime_math_ColorMatrix.__alphaTable[0] = 0;
	var _g = 1;
	while(_g < 256) {
		var i = _g++;
		value = Math.floor(i * this1[18] + this1[19] * 255);
		if(value > 255) {
			value = 255;
		}
		if(value < 0) {
			value = 0;
		}
		lime_math_ColorMatrix.__alphaTable[i] = value;
	}
	return lime_math_ColorMatrix.__alphaTable;
};
lime_math_ColorMatrix.getBlueTable = function(this1) {
	if(lime_math_ColorMatrix.__blueTable == null) {
		var array = null;
		var vector = null;
		var view = null;
		var buffer = null;
		var len = null;
		var this2 = new Uint8Array(256);
		lime_math_ColorMatrix.__blueTable = this2;
	}
	var value;
	var _g = 0;
	while(_g < 256) {
		var i = _g++;
		value = Math.floor(i * this1[12] + this1[14] * 255);
		if(value > 255) {
			value = 255;
		}
		if(value < 0) {
			value = 0;
		}
		lime_math_ColorMatrix.__blueTable[i] = value;
	}
	return lime_math_ColorMatrix.__blueTable;
};
lime_math_ColorMatrix.getGreenTable = function(this1) {
	if(lime_math_ColorMatrix.__greenTable == null) {
		var array = null;
		var vector = null;
		var view = null;
		var buffer = null;
		var len = null;
		var this2 = new Uint8Array(256);
		lime_math_ColorMatrix.__greenTable = this2;
	}
	var value;
	var _g = 0;
	while(_g < 256) {
		var i = _g++;
		value = Math.floor(i * this1[6] + this1[9] * 255);
		if(value > 255) {
			value = 255;
		}
		if(value < 0) {
			value = 0;
		}
		lime_math_ColorMatrix.__greenTable[i] = value;
	}
	return lime_math_ColorMatrix.__greenTable;
};
lime_math_ColorMatrix.getRedTable = function(this1) {
	if(lime_math_ColorMatrix.__redTable == null) {
		var array = null;
		var vector = null;
		var view = null;
		var buffer = null;
		var len = null;
		var this2 = new Uint8Array(256);
		lime_math_ColorMatrix.__redTable = this2;
	}
	var value;
	var _g = 0;
	while(_g < 256) {
		var i = _g++;
		value = Math.floor(i * this1[0] + this1[4] * 255);
		if(value > 255) {
			value = 255;
		}
		if(value < 0) {
			value = 0;
		}
		lime_math_ColorMatrix.__redTable[i] = value;
	}
	return lime_math_ColorMatrix.__redTable;
};
lime_math_ColorMatrix.__toFlashColorTransform = function(this1) {
	return null;
};
lime_math_ColorMatrix.get_alphaMultiplier = function(this1) {
	return this1[18];
};
lime_math_ColorMatrix.set_alphaMultiplier = function(this1,value) {
	return this1[18] = value;
};
lime_math_ColorMatrix.get_alphaOffset = function(this1) {
	return this1[19] * 255;
};
lime_math_ColorMatrix.set_alphaOffset = function(this1,value) {
	return this1[19] = value / 255;
};
lime_math_ColorMatrix.get_blueMultiplier = function(this1) {
	return this1[12];
};
lime_math_ColorMatrix.set_blueMultiplier = function(this1,value) {
	return this1[12] = value;
};
lime_math_ColorMatrix.get_blueOffset = function(this1) {
	return this1[14] * 255;
};
lime_math_ColorMatrix.set_blueOffset = function(this1,value) {
	return this1[14] = value / 255;
};
lime_math_ColorMatrix.get_color = function(this1) {
	return (this1[4] * 255 | 0) << 16 | (this1[9] * 255 | 0) << 8 | (this1[14] * 255 | 0);
};
lime_math_ColorMatrix.set_color = function(this1,value) {
	this1[4] = (value >> 16 & 255) / 255;
	this1[9] = (value >> 8 & 255) / 255;
	this1[14] = (value & 255) / 255;
	this1[0] = 0;
	this1[6] = 0;
	this1[12] = 0;
	return lime_math_ColorMatrix.get_color(this1);
};
lime_math_ColorMatrix.get_greenMultiplier = function(this1) {
	return this1[6];
};
lime_math_ColorMatrix.set_greenMultiplier = function(this1,value) {
	return this1[6] = value;
};
lime_math_ColorMatrix.get_greenOffset = function(this1) {
	return this1[9] * 255;
};
lime_math_ColorMatrix.set_greenOffset = function(this1,value) {
	return this1[9] = value / 255;
};
lime_math_ColorMatrix.get_redMultiplier = function(this1) {
	return this1[0];
};
lime_math_ColorMatrix.set_redMultiplier = function(this1,value) {
	return this1[0] = value;
};
lime_math_ColorMatrix.get_redOffset = function(this1) {
	return this1[4] * 255;
};
lime_math_ColorMatrix.set_redOffset = function(this1,value) {
	return this1[4] = value / 255;
};
lime_math_ColorMatrix.get = function(this1,index) {
	return this1[index];
};
lime_math_ColorMatrix.set = function(this1,index,value) {
	return this1[index] = value;
};
var lime_math_Matrix3 = function(a,b,c,d,tx,ty) {
	if(ty == null) {
		ty = 0;
	}
	if(tx == null) {
		tx = 0;
	}
	if(d == null) {
		d = 1;
	}
	if(c == null) {
		c = 0;
	}
	if(b == null) {
		b = 0;
	}
	if(a == null) {
		a = 1;
	}
	this.a = a;
	this.b = b;
	this.c = c;
	this.d = d;
	this.tx = tx;
	this.ty = ty;
};
$hxClasses["lime.math.Matrix3"] = lime_math_Matrix3;
lime_math_Matrix3.__name__ = "lime.math.Matrix3";
lime_math_Matrix3.prototype = {
	clone: function() {
		return new lime_math_Matrix3(this.a,this.b,this.c,this.d,this.tx,this.ty);
	}
	,concat: function(m) {
		var a1 = this.a * m.a + this.b * m.c;
		this.b = this.a * m.b + this.b * m.d;
		this.a = a1;
		var c1 = this.c * m.a + this.d * m.c;
		this.d = this.c * m.b + this.d * m.d;
		this.c = c1;
		var tx1 = this.tx * m.a + this.ty * m.c + m.tx;
		this.ty = this.tx * m.b + this.ty * m.d + m.ty;
		this.tx = tx1;
	}
	,copyColumnFrom: function(column,vector4) {
		if(column > 2) {
			throw haxe_Exception.thrown("Column " + column + " out of bounds (2)");
		} else if(column == 0) {
			this.a = vector4.x;
			this.b = vector4.y;
		} else if(column == 1) {
			this.c = vector4.x;
			this.d = vector4.y;
		} else {
			this.tx = vector4.x;
			this.ty = vector4.y;
		}
	}
	,copyColumnTo: function(column,vector4) {
		if(column > 2) {
			throw haxe_Exception.thrown("Column " + column + " out of bounds (2)");
		} else if(column == 0) {
			vector4.x = this.a;
			vector4.y = this.b;
			vector4.z = 0;
		} else if(column == 1) {
			vector4.x = this.c;
			vector4.y = this.d;
			vector4.z = 0;
		} else {
			vector4.x = this.tx;
			vector4.y = this.ty;
			vector4.z = 1;
		}
	}
	,copyFrom: function(sourceMatrix3) {
		this.a = sourceMatrix3.a;
		this.b = sourceMatrix3.b;
		this.c = sourceMatrix3.c;
		this.d = sourceMatrix3.d;
		this.tx = sourceMatrix3.tx;
		this.ty = sourceMatrix3.ty;
	}
	,copyRowFrom: function(row,vector4) {
		if(row > 2) {
			throw haxe_Exception.thrown("Row " + row + " out of bounds (2)");
		} else if(row == 0) {
			this.a = vector4.x;
			this.c = vector4.y;
			this.tx = vector4.z;
		} else if(row == 1) {
			this.b = vector4.x;
			this.d = vector4.y;
			this.ty = vector4.z;
		}
	}
	,copyRowTo: function(row,vector4) {
		if(row > 2) {
			throw haxe_Exception.thrown("Row " + row + " out of bounds (2)");
		} else if(row == 0) {
			vector4.x = this.a;
			vector4.y = this.c;
			vector4.z = this.tx;
		} else if(row == 1) {
			vector4.x = this.b;
			vector4.y = this.d;
			vector4.z = this.ty;
		} else {
			vector4.x = 0;
			vector4.y = 0;
			vector4.z = 1;
		}
	}
	,createBox: function(scaleX,scaleY,rotation,tx,ty) {
		if(ty == null) {
			ty = 0;
		}
		if(tx == null) {
			tx = 0;
		}
		if(rotation == null) {
			rotation = 0;
		}
		if(rotation != 0) {
			var cos = Math.cos(rotation);
			var sin = Math.sin(rotation);
			this.a = cos * scaleX;
			this.b = sin * scaleY;
			this.c = -sin * scaleX;
			this.d = cos * scaleY;
		} else {
			this.a = scaleX;
			this.b = 0;
			this.c = 0;
			this.d = scaleY;
		}
		this.tx = tx;
		this.ty = ty;
	}
	,createGradientBox: function(width,height,rotation,tx,ty) {
		if(ty == null) {
			ty = 0;
		}
		if(tx == null) {
			tx = 0;
		}
		if(rotation == null) {
			rotation = 0;
		}
		this.a = width / 1638.4;
		this.d = height / 1638.4;
		if(rotation != 0) {
			var cos = Math.cos(rotation);
			var sin = Math.sin(rotation);
			this.b = sin * this.d;
			this.c = -sin * this.a;
			this.a *= cos;
			this.d *= cos;
		} else {
			this.b = 0;
			this.c = 0;
		}
		this.tx = tx + width / 2;
		this.ty = ty + height / 2;
	}
	,equals: function(matrix3) {
		if(matrix3 != null && this.tx == matrix3.tx && this.ty == matrix3.ty && this.a == matrix3.a && this.b == matrix3.b && this.c == matrix3.c) {
			return this.d == matrix3.d;
		} else {
			return false;
		}
	}
	,deltaTransformVector: function(Vector2,result) {
		if(result == null) {
			result = new lime_math_Vector2();
		}
		result.x = Vector2.x * this.a + Vector2.y * this.c;
		result.y = Vector2.x * this.b + Vector2.y * this.d;
		return result;
	}
	,identity: function() {
		this.a = 1;
		this.b = 0;
		this.c = 0;
		this.d = 1;
		this.tx = 0;
		this.ty = 0;
	}
	,invert: function() {
		var norm = this.a * this.d - this.b * this.c;
		if(norm == 0) {
			this.a = this.b = this.c = this.d = 0;
			this.tx = -this.tx;
			this.ty = -this.ty;
		} else {
			norm = 1.0 / norm;
			var a1 = this.d * norm;
			this.d = this.a * norm;
			this.a = a1;
			this.b *= -norm;
			this.c *= -norm;
			var tx1 = -this.a * this.tx - this.c * this.ty;
			this.ty = -this.b * this.tx - this.d * this.ty;
			this.tx = tx1;
		}
		return this;
	}
	,rotate: function(theta) {
		var cos = Math.cos(theta);
		var sin = Math.sin(theta);
		var a1 = this.a * cos - this.b * sin;
		this.b = this.a * sin + this.b * cos;
		this.a = a1;
		var c1 = this.c * cos - this.d * sin;
		this.d = this.c * sin + this.d * cos;
		this.c = c1;
		var tx1 = this.tx * cos - this.ty * sin;
		this.ty = this.tx * sin + this.ty * cos;
		this.tx = tx1;
	}
	,scale: function(sx,sy) {
		this.a *= sx;
		this.b *= sy;
		this.c *= sx;
		this.d *= sy;
		this.tx *= sx;
		this.ty *= sy;
	}
	,setRotation: function(theta,scale) {
		if(scale == null) {
			scale = 1;
		}
		this.a = Math.cos(theta) * scale;
		this.c = Math.sin(theta) * scale;
		this.b = -this.c;
		this.d = this.a;
	}
	,setTo: function(a,b,c,d,tx,ty) {
		this.a = a;
		this.b = b;
		this.c = c;
		this.d = d;
		this.tx = tx;
		this.ty = ty;
	}
	,to3DString: function(roundPixels) {
		if(roundPixels == null) {
			roundPixels = false;
		}
		if(roundPixels) {
			return "matrix3d(" + this.a + ", " + this.b + ", " + "0, 0, " + this.c + ", " + this.d + ", " + "0, 0, 0, 0, 1, 0, " + (this.tx | 0) + ", " + (this.ty | 0) + ", 0, 1)";
		} else {
			return "matrix3d(" + this.a + ", " + this.b + ", " + "0, 0, " + this.c + ", " + this.d + ", " + "0, 0, 0, 0, 1, 0, " + this.tx + ", " + this.ty + ", 0, 1)";
		}
	}
	,toString: function() {
		return "matrix(" + this.a + ", " + this.b + ", " + this.c + ", " + this.d + ", " + this.tx + ", " + this.ty + ")";
	}
	,transformRect: function(rect,result) {
		if(result == null) {
			result = new lime_math_Rectangle();
		}
		var tx0 = this.a * rect.x + this.c * rect.y;
		var tx1 = tx0;
		var ty0 = this.b * rect.x + this.d * rect.y;
		var ty1 = ty0;
		var tx = this.a * (rect.x + rect.width) + this.c * rect.y;
		var ty = this.b * (rect.x + rect.width) + this.d * rect.y;
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		tx = this.a * (rect.x + rect.width) + this.c * (rect.y + rect.height);
		ty = this.b * (rect.x + rect.width) + this.d * (rect.y + rect.height);
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		tx = this.a * rect.x + this.c * (rect.y + rect.height);
		ty = this.b * rect.x + this.d * (rect.y + rect.height);
		if(tx < tx0) {
			tx0 = tx;
		}
		if(ty < ty0) {
			ty0 = ty;
		}
		if(tx > tx1) {
			tx1 = tx;
		}
		if(ty > ty1) {
			ty1 = ty;
		}
		result.setTo(tx0 + tx,ty0 + ty,tx1 - tx0,ty1 - ty0);
		return result;
	}
	,transformVector: function(pos,result) {
		if(result == null) {
			result = new lime_math_Vector2();
		}
		result.x = pos.x * this.a + pos.y * this.c + this.tx;
		result.y = pos.x * this.b + pos.y * this.d + this.ty;
		return result;
	}
	,translate: function(dx,dy) {
		this.tx += dx;
		this.ty += dy;
	}
	,__class__: lime_math_Matrix3
};
var lime_math_Matrix4 = {};
lime_math_Matrix4.__properties__ = {set_position:"set_position",get_position:"get_position",get_determinant:"get_determinant"};
lime_math_Matrix4._new = function(data) {
	var this1;
	if(data != null && data.length == 16) {
		this1 = data;
	} else {
		var elements = null;
		var array = lime_math_Matrix4.__identity;
		var vector = null;
		var view = null;
		var buffer = null;
		var len = null;
		var this2;
		if(elements != null) {
			this2 = new Float32Array(elements);
		} else if(array != null) {
			this2 = new Float32Array(array);
		} else if(vector != null) {
			this2 = new Float32Array(vector.__array);
		} else if(view != null) {
			this2 = new Float32Array(view);
		} else if(buffer != null) {
			if(len == null) {
				this2 = new Float32Array(buffer,0);
			} else {
				this2 = new Float32Array(buffer,0,len);
			}
		} else {
			this2 = null;
		}
		this1 = this2;
	}
	return this1;
};
lime_math_Matrix4.append = function(this1,lhs) {
	var m111 = this1[0];
	var m121 = this1[4];
	var m131 = this1[8];
	var m141 = this1[12];
	var m112 = this1[1];
	var m122 = this1[5];
	var m132 = this1[9];
	var m142 = this1[13];
	var m113 = this1[2];
	var m123 = this1[6];
	var m133 = this1[10];
	var m143 = this1[14];
	var m114 = this1[3];
	var m124 = this1[7];
	var m134 = this1[11];
	var m144 = this1[15];
	var m211 = lime_math_Matrix4.get(lhs,0);
	var m221 = lime_math_Matrix4.get(lhs,4);
	var m231 = lime_math_Matrix4.get(lhs,8);
	var m241 = lime_math_Matrix4.get(lhs,12);
	var m212 = lime_math_Matrix4.get(lhs,1);
	var m222 = lime_math_Matrix4.get(lhs,5);
	var m232 = lime_math_Matrix4.get(lhs,9);
	var m242 = lime_math_Matrix4.get(lhs,13);
	var m213 = lime_math_Matrix4.get(lhs,2);
	var m223 = lime_math_Matrix4.get(lhs,6);
	var m233 = lime_math_Matrix4.get(lhs,10);
	var m243 = lime_math_Matrix4.get(lhs,14);
	var m214 = lime_math_Matrix4.get(lhs,3);
	var m224 = lime_math_Matrix4.get(lhs,7);
	var m234 = lime_math_Matrix4.get(lhs,11);
	var m244 = lime_math_Matrix4.get(lhs,15);
	this1[0] = m111 * m211 + m112 * m221 + m113 * m231 + m114 * m241;
	this1[1] = m111 * m212 + m112 * m222 + m113 * m232 + m114 * m242;
	this1[2] = m111 * m213 + m112 * m223 + m113 * m233 + m114 * m243;
	this1[3] = m111 * m214 + m112 * m224 + m113 * m234 + m114 * m244;
	this1[4] = m121 * m211 + m122 * m221 + m123 * m231 + m124 * m241;
	this1[5] = m121 * m212 + m122 * m222 + m123 * m232 + m124 * m242;
	this1[6] = m121 * m213 + m122 * m223 + m123 * m233 + m124 * m243;
	this1[7] = m121 * m214 + m122 * m224 + m123 * m234 + m124 * m244;
	this1[8] = m131 * m211 + m132 * m221 + m133 * m231 + m134 * m241;
	this1[9] = m131 * m212 + m132 * m222 + m133 * m232 + m134 * m242;
	this1[10] = m131 * m213 + m132 * m223 + m133 * m233 + m134 * m243;
	this1[11] = m131 * m214 + m132 * m224 + m133 * m234 + m134 * m244;
	this1[12] = m141 * m211 + m142 * m221 + m143 * m231 + m144 * m241;
	this1[13] = m141 * m212 + m142 * m222 + m143 * m232 + m144 * m242;
	this1[14] = m141 * m213 + m142 * m223 + m143 * m233 + m144 * m243;
	this1[15] = m141 * m214 + m142 * m224 + m143 * m234 + m144 * m244;
};
lime_math_Matrix4.appendRotation = function(this1,degrees,axis,pivotPoint) {
	var m = lime_math_Matrix4.__getAxisRotation(this1,axis.x,axis.y,axis.z,degrees);
	if(pivotPoint != null) {
		var p = pivotPoint;
		lime_math_Matrix4.appendTranslation(m,p.x,p.y,p.z);
	}
	lime_math_Matrix4.append(this1,m);
};
lime_math_Matrix4.appendScale = function(this1,xScale,yScale,zScale) {
	var elements = null;
	var array = [xScale,0.0,0.0,0.0,0.0,yScale,0.0,0.0,0.0,0.0,zScale,0.0,0.0,0.0,0.0,1.0];
	var vector = null;
	var view = null;
	var buffer = null;
	var len = null;
	var this2;
	if(elements != null) {
		this2 = new Float32Array(elements);
	} else if(array != null) {
		this2 = new Float32Array(array);
	} else if(vector != null) {
		this2 = new Float32Array(vector.__array);
	} else if(view != null) {
		this2 = new Float32Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this2 = new Float32Array(buffer,0);
		} else {
			this2 = new Float32Array(buffer,0,len);
		}
	} else {
		this2 = null;
	}
	lime_math_Matrix4.append(this1,lime_math_Matrix4._new(this2));
};
lime_math_Matrix4.appendTranslation = function(this1,x,y,z) {
	this1[12] += x;
	this1[13] += y;
	this1[14] += z;
};
lime_math_Matrix4.clone = function(this1) {
	var elements = null;
	var array = null;
	var vector = null;
	var view = lime_utils_Float32Array.toArrayBufferView(this1);
	var buffer = null;
	var len = null;
	var this1;
	if(elements != null) {
		this1 = new Float32Array(elements);
	} else if(array != null) {
		this1 = new Float32Array(array);
	} else if(vector != null) {
		this1 = new Float32Array(vector.__array);
	} else if(view != null) {
		this1 = new Float32Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this1 = new Float32Array(buffer,0);
		} else {
			this1 = new Float32Array(buffer,0,len);
		}
	} else {
		this1 = null;
	}
	return lime_math_Matrix4._new(this1);
};
lime_math_Matrix4.copyColumnFrom = function(this1,column,vector) {
	switch(column) {
	case 0:
		this1[0] = vector.x;
		this1[1] = vector.y;
		this1[2] = vector.z;
		this1[3] = vector.w;
		break;
	case 1:
		this1[4] = vector.x;
		this1[5] = vector.y;
		this1[6] = vector.z;
		this1[7] = vector.w;
		break;
	case 2:
		this1[8] = vector.x;
		this1[9] = vector.y;
		this1[10] = vector.z;
		this1[11] = vector.w;
		break;
	case 3:
		this1[12] = vector.x;
		this1[13] = vector.y;
		this1[14] = vector.z;
		this1[15] = vector.w;
		break;
	default:
		lime_utils_Log.error("Column " + column + " out of bounds [0, ..., 3]",{ fileName : "lime/math/Matrix4.hx", lineNumber : 187, className : "lime.math._Matrix4.Matrix4_Impl_", methodName : "copyColumnFrom"});
	}
};
lime_math_Matrix4.copyColumnTo = function(this1,column,vector) {
	switch(column) {
	case 0:
		vector.x = this1[0];
		vector.y = this1[1];
		vector.z = this1[2];
		vector.w = this1[3];
		break;
	case 1:
		vector.x = this1[4];
		vector.y = this1[5];
		vector.z = this1[6];
		vector.w = this1[7];
		break;
	case 2:
		vector.x = this1[8];
		vector.y = this1[9];
		vector.z = this1[10];
		vector.w = this1[11];
		break;
	case 3:
		vector.x = this1[12];
		vector.y = this1[13];
		vector.z = this1[14];
		vector.w = this1[15];
		break;
	default:
		lime_utils_Log.error("Column " + column + " out of bounds [0, ..., 3]",{ fileName : "lime/math/Matrix4.hx", lineNumber : 225, className : "lime.math._Matrix4.Matrix4_Impl_", methodName : "copyColumnTo"});
	}
};
lime_math_Matrix4.copyFrom = function(this1,other) {
	this1.set(other);
};
lime_math_Matrix4.copyRowFrom = function(this1,row,vector) {
	switch(row) {
	case 0:
		this1[0] = vector.x;
		this1[4] = vector.y;
		this1[8] = vector.z;
		this1[12] = vector.w;
		break;
	case 1:
		this1[1] = vector.x;
		this1[5] = vector.y;
		this1[9] = vector.z;
		this1[13] = vector.w;
		break;
	case 2:
		this1[2] = vector.x;
		this1[6] = vector.y;
		this1[10] = vector.z;
		this1[14] = vector.w;
		break;
	case 3:
		this1[3] = vector.x;
		this1[7] = vector.y;
		this1[11] = vector.z;
		this1[15] = vector.w;
		break;
	default:
		lime_utils_Log.error("Row " + row + " out of bounds [0, ..., 3]",{ fileName : "lime/math/Matrix4.hx", lineNumber : 272, className : "lime.math._Matrix4.Matrix4_Impl_", methodName : "copyRowFrom"});
	}
};
lime_math_Matrix4.copyRowTo = function(this1,row,vector) {
	switch(row) {
	case 0:
		vector.x = this1[0];
		vector.y = this1[4];
		vector.z = this1[8];
		vector.w = this1[12];
		break;
	case 1:
		vector.x = this1[1];
		vector.y = this1[5];
		vector.z = this1[9];
		vector.w = this1[13];
		break;
	case 2:
		vector.x = this1[2];
		vector.y = this1[6];
		vector.z = this1[10];
		vector.w = this1[14];
		break;
	case 3:
		vector.x = this1[3];
		vector.y = this1[7];
		vector.z = this1[11];
		vector.w = this1[15];
		break;
	default:
		lime_utils_Log.error("Row " + row + " out of bounds [0, ..., 3]",{ fileName : "lime/math/Matrix4.hx", lineNumber : 310, className : "lime.math._Matrix4.Matrix4_Impl_", methodName : "copyRowTo"});
	}
};
lime_math_Matrix4.create2D = function(this1,a,b,c,d,tx,ty) {
	if(ty == null) {
		ty = 0;
	}
	if(tx == null) {
		tx = 0;
	}
	this1[0] = a;
	this1[1] = b;
	this1[2] = 0;
	this1[3] = 0;
	this1[4] = c;
	this1[5] = d;
	this1[6] = 0;
	this1[7] = 0;
	this1[8] = 0;
	this1[9] = 0;
	this1[10] = 1;
	this1[11] = 0;
	this1[12] = tx;
	this1[13] = ty;
	this1[14] = 0;
	this1[15] = 1;
};
lime_math_Matrix4.createOrtho = function(this1,left,right,bottom,top,zNear,zFar) {
	var sx = 1.0 / (right - left);
	var sy = 1.0 / (top - bottom);
	var sz = 1.0 / (zFar - zNear);
	this1[0] = 2 * sx;
	this1[1] = 0;
	this1[2] = 0;
	this1[3] = 0;
	this1[4] = 0;
	this1[5] = 2 * sy;
	this1[6] = 0;
	this1[7] = 0;
	this1[8] = 0;
	this1[9] = 0;
	this1[10] = -2 * sz;
	this1[11] = 0;
	this1[12] = -(left + right) * sx;
	this1[13] = -(bottom + top) * sy;
	this1[14] = -(zNear + zFar) * sz;
	this1[15] = 1;
};
lime_math_Matrix4.deltaTransformVector = function(this1,v,result) {
	if(result == null) {
		result = new lime_math_Vector4();
	}
	var x = v.x;
	var y = v.y;
	var z = v.z;
	result.x = x * this1[0] + y * this1[4] + z * this1[8] + this1[3];
	result.y = x * this1[1] + y * this1[5] + z * this1[9] + this1[7];
	result.z = x * this1[2] + y * this1[6] + z * this1[10] + this1[11];
	return result;
};
lime_math_Matrix4.fromMatrix3 = function(matrix3) {
	var mat = lime_math_Matrix4._new();
	lime_math_Matrix4.create2D(mat,matrix3.a,matrix3.b,matrix3.c,matrix3.d,matrix3.tx,matrix3.ty);
	return mat;
};
lime_math_Matrix4.identity = function(this1) {
	this1[0] = 1;
	this1[1] = 0;
	this1[2] = 0;
	this1[3] = 0;
	this1[4] = 0;
	this1[5] = 1;
	this1[6] = 0;
	this1[7] = 0;
	this1[8] = 0;
	this1[9] = 0;
	this1[10] = 1;
	this1[11] = 0;
	this1[12] = 0;
	this1[13] = 0;
	this1[14] = 0;
	this1[15] = 1;
};
lime_math_Matrix4.interpolate = function(thisMat,toMat,percent,result) {
	if(result == null) {
		result = lime_math_Matrix4._new();
	}
	var _g = 0;
	while(_g < 16) {
		var i = _g++;
		lime_math_Matrix4.set(result,i,lime_math_Matrix4.get(thisMat,i) + (lime_math_Matrix4.get(toMat,i) - lime_math_Matrix4.get(thisMat,i)) * percent);
	}
	return result;
};
lime_math_Matrix4.interpolateTo = function(this1,toMat,percent) {
	var _g = 0;
	while(_g < 16) {
		var i = _g++;
		this1[i] += (lime_math_Matrix4.get(toMat,i) - this1[i]) * percent;
	}
};
lime_math_Matrix4.invert = function(this1) {
	var d = lime_math_Matrix4.get_determinant(this1);
	var invertable = Math.abs(d) > 0.00000000001;
	if(invertable) {
		d = 1 / d;
		var m11 = this1[0];
		var m21 = this1[4];
		var m31 = this1[8];
		var m41 = this1[12];
		var m12 = this1[1];
		var m22 = this1[5];
		var m32 = this1[9];
		var m42 = this1[13];
		var m13 = this1[2];
		var m23 = this1[6];
		var m33 = this1[10];
		var m43 = this1[14];
		var m14 = this1[3];
		var m24 = this1[7];
		var m34 = this1[11];
		var m44 = this1[15];
		this1[0] = d * (m22 * (m33 * m44 - m43 * m34) - m32 * (m23 * m44 - m43 * m24) + m42 * (m23 * m34 - m33 * m24));
		this1[1] = -d * (m12 * (m33 * m44 - m43 * m34) - m32 * (m13 * m44 - m43 * m14) + m42 * (m13 * m34 - m33 * m14));
		this1[2] = d * (m12 * (m23 * m44 - m43 * m24) - m22 * (m13 * m44 - m43 * m14) + m42 * (m13 * m24 - m23 * m14));
		this1[3] = -d * (m12 * (m23 * m34 - m33 * m24) - m22 * (m13 * m34 - m33 * m14) + m32 * (m13 * m24 - m23 * m14));
		this1[4] = -d * (m21 * (m33 * m44 - m43 * m34) - m31 * (m23 * m44 - m43 * m24) + m41 * (m23 * m34 - m33 * m24));
		this1[5] = d * (m11 * (m33 * m44 - m43 * m34) - m31 * (m13 * m44 - m43 * m14) + m41 * (m13 * m34 - m33 * m14));
		this1[6] = -d * (m11 * (m23 * m44 - m43 * m24) - m21 * (m13 * m44 - m43 * m14) + m41 * (m13 * m24 - m23 * m14));
		this1[7] = d * (m11 * (m23 * m34 - m33 * m24) - m21 * (m13 * m34 - m33 * m14) + m31 * (m13 * m24 - m23 * m14));
		this1[8] = d * (m21 * (m32 * m44 - m42 * m34) - m31 * (m22 * m44 - m42 * m24) + m41 * (m22 * m34 - m32 * m24));
		this1[9] = -d * (m11 * (m32 * m44 - m42 * m34) - m31 * (m12 * m44 - m42 * m14) + m41 * (m12 * m34 - m32 * m14));
		this1[10] = d * (m11 * (m22 * m44 - m42 * m24) - m21 * (m12 * m44 - m42 * m14) + m41 * (m12 * m24 - m22 * m14));
		this1[11] = -d * (m11 * (m22 * m34 - m32 * m24) - m21 * (m12 * m34 - m32 * m14) + m31 * (m12 * m24 - m22 * m14));
		this1[12] = -d * (m21 * (m32 * m43 - m42 * m33) - m31 * (m22 * m43 - m42 * m23) + m41 * (m22 * m33 - m32 * m23));
		this1[13] = d * (m11 * (m32 * m43 - m42 * m33) - m31 * (m12 * m43 - m42 * m13) + m41 * (m12 * m33 - m32 * m13));
		this1[14] = -d * (m11 * (m22 * m43 - m42 * m23) - m21 * (m12 * m43 - m42 * m13) + m41 * (m12 * m23 - m22 * m13));
		this1[15] = d * (m11 * (m22 * m33 - m32 * m23) - m21 * (m12 * m33 - m32 * m13) + m31 * (m12 * m23 - m22 * m13));
	}
	return invertable;
};
lime_math_Matrix4.pointAt = function(this1,pos,at,up) {
	if(at == null) {
		at = new lime_math_Vector4(0,0,1);
	}
	if(up == null) {
		up = new lime_math_Vector4(0,1,0);
	}
	var result = null;
	if(result == null) {
		result = new lime_math_Vector4();
	}
	result.x = pos.x - at.x;
	result.y = pos.y - at.y;
	result.z = pos.z - at.z;
	var dir = result;
	var vup = new lime_math_Vector4(up.x,up.y,up.z,up.w);
	var l = Math.sqrt(dir.x * dir.x + dir.y * dir.y + dir.z * dir.z);
	if(l != 0) {
		dir.x /= l;
		dir.y /= l;
		dir.z /= l;
	}
	var l = Math.sqrt(vup.x * vup.x + vup.y * vup.y + vup.z * vup.z);
	if(l != 0) {
		vup.x /= l;
		vup.y /= l;
		vup.z /= l;
	}
	var dir2 = new lime_math_Vector4(dir.x,dir.y,dir.z,dir.w);
	var s = vup.x * dir.x + vup.y * dir.y + vup.z * dir.z;
	dir2.x *= s;
	dir2.y *= s;
	dir2.z *= s;
	var result = null;
	if(result == null) {
		result = new lime_math_Vector4();
	}
	result.x = vup.x - dir2.x;
	result.y = vup.y - dir2.y;
	result.z = vup.z - dir2.z;
	vup = result;
	if(Math.sqrt(vup.x * vup.x + vup.y * vup.y + vup.z * vup.z) > 0) {
		var l = Math.sqrt(vup.x * vup.x + vup.y * vup.y + vup.z * vup.z);
		if(l != 0) {
			vup.x /= l;
			vup.y /= l;
			vup.z /= l;
		}
	} else if(dir.x != 0) {
		vup = new lime_math_Vector4(-dir.y,dir.x,0);
	} else {
		vup = new lime_math_Vector4(1,0,0);
	}
	var result = null;
	if(result == null) {
		result = new lime_math_Vector4();
	}
	var ya = vup.z * dir.x - vup.x * dir.z;
	var za = vup.x * dir.y - vup.y * dir.x;
	result.x = vup.y * dir.z - vup.z * dir.y;
	result.y = ya;
	result.z = za;
	result.w = 1;
	var right = result;
	var l = Math.sqrt(right.x * right.x + right.y * right.y + right.z * right.z);
	if(l != 0) {
		right.x /= l;
		right.y /= l;
		right.z /= l;
	}
	this1[0] = right.x;
	this1[4] = right.y;
	this1[8] = right.z;
	this1[12] = 0.0;
	this1[1] = vup.x;
	this1[5] = vup.y;
	this1[9] = vup.z;
	this1[13] = 0.0;
	this1[2] = dir.x;
	this1[6] = dir.y;
	this1[10] = dir.z;
	this1[14] = 0.0;
	this1[3] = pos.x;
	this1[7] = pos.y;
	this1[11] = pos.z;
	this1[15] = 1.0;
};
lime_math_Matrix4.prepend = function(this1,rhs) {
	var m111 = lime_math_Matrix4.get(rhs,0);
	var m121 = lime_math_Matrix4.get(rhs,4);
	var m131 = lime_math_Matrix4.get(rhs,8);
	var m141 = lime_math_Matrix4.get(rhs,12);
	var m112 = lime_math_Matrix4.get(rhs,1);
	var m122 = lime_math_Matrix4.get(rhs,5);
	var m132 = lime_math_Matrix4.get(rhs,9);
	var m142 = lime_math_Matrix4.get(rhs,13);
	var m113 = lime_math_Matrix4.get(rhs,2);
	var m123 = lime_math_Matrix4.get(rhs,6);
	var m133 = lime_math_Matrix4.get(rhs,10);
	var m143 = lime_math_Matrix4.get(rhs,14);
	var m114 = lime_math_Matrix4.get(rhs,3);
	var m124 = lime_math_Matrix4.get(rhs,7);
	var m134 = lime_math_Matrix4.get(rhs,11);
	var m144 = lime_math_Matrix4.get(rhs,15);
	var m211 = this1[0];
	var m221 = this1[4];
	var m231 = this1[8];
	var m241 = this1[12];
	var m212 = this1[1];
	var m222 = this1[5];
	var m232 = this1[9];
	var m242 = this1[13];
	var m213 = this1[2];
	var m223 = this1[6];
	var m233 = this1[10];
	var m243 = this1[14];
	var m214 = this1[3];
	var m224 = this1[7];
	var m234 = this1[11];
	var m244 = this1[15];
	this1[0] = m111 * m211 + m112 * m221 + m113 * m231 + m114 * m241;
	this1[1] = m111 * m212 + m112 * m222 + m113 * m232 + m114 * m242;
	this1[2] = m111 * m213 + m112 * m223 + m113 * m233 + m114 * m243;
	this1[3] = m111 * m214 + m112 * m224 + m113 * m234 + m114 * m244;
	this1[4] = m121 * m211 + m122 * m221 + m123 * m231 + m124 * m241;
	this1[5] = m121 * m212 + m122 * m222 + m123 * m232 + m124 * m242;
	this1[6] = m121 * m213 + m122 * m223 + m123 * m233 + m124 * m243;
	this1[7] = m121 * m214 + m122 * m224 + m123 * m234 + m124 * m244;
	this1[8] = m131 * m211 + m132 * m221 + m133 * m231 + m134 * m241;
	this1[9] = m131 * m212 + m132 * m222 + m133 * m232 + m134 * m242;
	this1[10] = m131 * m213 + m132 * m223 + m133 * m233 + m134 * m243;
	this1[11] = m131 * m214 + m132 * m224 + m133 * m234 + m134 * m244;
	this1[12] = m141 * m211 + m142 * m221 + m143 * m231 + m144 * m241;
	this1[13] = m141 * m212 + m142 * m222 + m143 * m232 + m144 * m242;
	this1[14] = m141 * m213 + m142 * m223 + m143 * m233 + m144 * m243;
	this1[15] = m141 * m214 + m142 * m224 + m143 * m234 + m144 * m244;
};
lime_math_Matrix4.prependRotation = function(this1,degrees,axis,pivotPoint) {
	var m = lime_math_Matrix4.__getAxisRotation(this1,axis.x,axis.y,axis.z,degrees);
	if(pivotPoint != null) {
		var p = pivotPoint;
		lime_math_Matrix4.appendTranslation(m,p.x,p.y,p.z);
	}
	lime_math_Matrix4.prepend(this1,m);
};
lime_math_Matrix4.prependScale = function(this1,xScale,yScale,zScale) {
	var elements = null;
	var array = [xScale,0.0,0.0,0.0,0.0,yScale,0.0,0.0,0.0,0.0,zScale,0.0,0.0,0.0,0.0,1.0];
	var vector = null;
	var view = null;
	var buffer = null;
	var len = null;
	var this2;
	if(elements != null) {
		this2 = new Float32Array(elements);
	} else if(array != null) {
		this2 = new Float32Array(array);
	} else if(vector != null) {
		this2 = new Float32Array(vector.__array);
	} else if(view != null) {
		this2 = new Float32Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this2 = new Float32Array(buffer,0);
		} else {
			this2 = new Float32Array(buffer,0,len);
		}
	} else {
		this2 = null;
	}
	lime_math_Matrix4.prepend(this1,lime_math_Matrix4._new(this2));
};
lime_math_Matrix4.prependTranslation = function(this1,x,y,z) {
	var m = lime_math_Matrix4._new();
	lime_math_Matrix4.set_position(m,new lime_math_Vector4(x,y,z));
	lime_math_Matrix4.prepend(this1,m);
};
lime_math_Matrix4.transformVector = function(this1,v,result) {
	if(result == null) {
		result = new lime_math_Vector4();
	}
	var x = v.x;
	var y = v.y;
	var z = v.z;
	result.x = x * this1[0] + y * this1[4] + z * this1[8] + this1[12];
	result.y = x * this1[1] + y * this1[5] + z * this1[9] + this1[13];
	result.z = x * this1[2] + y * this1[6] + z * this1[10] + this1[14];
	result.w = x * this1[3] + y * this1[7] + z * this1[11] + this1[15];
	return result;
};
lime_math_Matrix4.transformVectors = function(this1,ain,aout) {
	var i = 0;
	var x;
	var y;
	var z;
	while(i + 3 <= ain.length) {
		x = ain[i];
		y = ain[i + 1];
		z = ain[i + 2];
		aout[i] = x * this1[0] + y * this1[4] + z * this1[8] + this1[12];
		aout[i + 1] = x * this1[1] + y * this1[5] + z * this1[9] + this1[13];
		aout[i + 2] = x * this1[2] + y * this1[6] + z * this1[10] + this1[14];
		i += 3;
	}
};
lime_math_Matrix4.transpose = function(this1) {
	var temp = this1[1];
	this1[1] = this1[4];
	this1[4] = temp;
	var temp = this1[2];
	this1[2] = this1[8];
	this1[8] = temp;
	var temp = this1[3];
	this1[3] = this1[12];
	this1[12] = temp;
	var temp = this1[6];
	this1[6] = this1[9];
	this1[9] = temp;
	var temp = this1[7];
	this1[7] = this1[13];
	this1[13] = temp;
	var temp = this1[11];
	this1[11] = this1[14];
	this1[14] = temp;
};
lime_math_Matrix4.__getAxisRotation = function(this1,x,y,z,degrees) {
	var m = lime_math_Matrix4._new();
	var a1 = new lime_math_Vector4(x,y,z);
	var rad = -degrees * (Math.PI / 180);
	var c = Math.cos(rad);
	var s = Math.sin(rad);
	var t = 1.0 - c;
	lime_math_Matrix4.set(m,0,c + a1.x * a1.x * t);
	lime_math_Matrix4.set(m,5,c + a1.y * a1.y * t);
	lime_math_Matrix4.set(m,10,c + a1.z * a1.z * t);
	var tmp1 = a1.x * a1.y * t;
	var tmp2 = a1.z * s;
	lime_math_Matrix4.set(m,4,tmp1 + tmp2);
	lime_math_Matrix4.set(m,1,tmp1 - tmp2);
	tmp1 = a1.x * a1.z * t;
	tmp2 = a1.y * s;
	lime_math_Matrix4.set(m,8,tmp1 - tmp2);
	lime_math_Matrix4.set(m,2,tmp1 + tmp2);
	tmp1 = a1.y * a1.z * t;
	tmp2 = a1.x * s;
	lime_math_Matrix4.set(m,9,tmp1 + tmp2);
	lime_math_Matrix4.set(m,6,tmp1 - tmp2);
	return m;
};
lime_math_Matrix4.__swap = function(this1,a,b) {
	var temp = this1[a];
	this1[a] = this1[b];
	this1[b] = temp;
};
lime_math_Matrix4.get_determinant = function(this1) {
	return (this1[0] * this1[5] - this1[4] * this1[1]) * (this1[10] * this1[15] - this1[14] * this1[11]) - (this1[0] * this1[9] - this1[8] * this1[1]) * (this1[6] * this1[15] - this1[14] * this1[7]) + (this1[0] * this1[13] - this1[12] * this1[1]) * (this1[6] * this1[11] - this1[10] * this1[7]) + (this1[4] * this1[9] - this1[8] * this1[5]) * (this1[2] * this1[15] - this1[14] * this1[3]) - (this1[4] * this1[13] - this1[12] * this1[5]) * (this1[2] * this1[11] - this1[10] * this1[3]) + (this1[8] * this1[13] - this1[12] * this1[9]) * (this1[2] * this1[7] - this1[6] * this1[3]);
};
lime_math_Matrix4.get_position = function(this1) {
	return new lime_math_Vector4(this1[12],this1[13],this1[14]);
};
lime_math_Matrix4.set_position = function(this1,val) {
	this1[12] = val.x;
	this1[13] = val.y;
	this1[14] = val.z;
	return val;
};
lime_math_Matrix4.get = function(this1,index) {
	return this1[index];
};
lime_math_Matrix4.set = function(this1,index,value) {
	this1[index] = value;
	return value;
};
var lime_math_RGBA = {};
lime_math_RGBA.__properties__ = {set_r:"set_r",get_r:"get_r",set_g:"set_g",get_g:"get_g",set_b:"set_b",get_b:"get_b",set_a:"set_a",get_a:"get_a"};
lime_math_RGBA._new = function(rgba) {
	if(rgba == null) {
		rgba = 0;
	}
	var this1 = rgba;
	return this1;
};
lime_math_RGBA.create = function(r,g,b,a) {
	var this1 = 0;
	var rgba = this1;
	rgba = (r & 255) << 24 | (g & 255) << 16 | (b & 255) << 8 | a & 255;
	return rgba;
};
lime_math_RGBA.multiplyAlpha = function(this1) {
	if((this1 & 255) == 0) {
		if(this1 != 0) {
			this1 = 0;
		}
	} else if((this1 & 255) != 255) {
		lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[this1 & 255];
		this1 = ((this1 >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | this1 & 255 & 255;
	}
};
lime_math_RGBA.readUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	switch(format) {
	case 0:
		this1 = (data[offset] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset + 2] & 255) << 8 | data[offset + 3] & 255;
		break;
	case 1:
		this1 = (data[offset + 1] & 255) << 24 | (data[offset + 2] & 255) << 16 | (data[offset + 3] & 255) << 8 | data[offset] & 255;
		break;
	case 2:
		this1 = (data[offset + 2] & 255) << 24 | (data[offset + 1] & 255) << 16 | (data[offset] & 255) << 8 | data[offset + 3] & 255;
		break;
	}
	if(premultiplied) {
		if((this1 & 255) != 0 && (this1 & 255) != 255) {
			lime_math_RGBA.unmult = 255.0 / (this1 & 255);
			this1 = (lime_math_RGBA.__clamp[Math.round((this1 >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((this1 >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((this1 >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | this1 & 255 & 255;
		}
	}
};
lime_math_RGBA.set = function(this1,r,g,b,a) {
	this1 = (r & 255) << 24 | (g & 255) << 16 | (b & 255) << 8 | a & 255;
};
lime_math_RGBA.unmultiplyAlpha = function(this1) {
	if((this1 & 255) != 0 && (this1 & 255) != 255) {
		lime_math_RGBA.unmult = 255.0 / (this1 & 255);
		this1 = (lime_math_RGBA.__clamp[Math.round((this1 >>> 24 & 255) * lime_math_RGBA.unmult)] & 255) << 24 | (lime_math_RGBA.__clamp[Math.round((this1 >>> 16 & 255) * lime_math_RGBA.unmult)] & 255) << 16 | (lime_math_RGBA.__clamp[Math.round((this1 >>> 8 & 255) * lime_math_RGBA.unmult)] & 255) << 8 | this1 & 255 & 255;
	}
};
lime_math_RGBA.writeUInt8 = function(this1,data,offset,format,premultiplied) {
	if(premultiplied == null) {
		premultiplied = false;
	}
	if(format == null) {
		format = 0;
	}
	if(premultiplied) {
		if((this1 & 255) == 0) {
			if(this1 != 0) {
				this1 = 0;
			}
		} else if((this1 & 255) != 255) {
			lime_math_RGBA.a16 = lime_math_RGBA.__alpha16[this1 & 255];
			this1 = ((this1 >>> 24 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 24 | ((this1 >>> 16 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 16 | ((this1 >>> 8 & 255) * lime_math_RGBA.a16 >> 16 & 255) << 8 | this1 & 255 & 255;
		}
	}
	switch(format) {
	case 0:
		data[offset] = this1 >>> 24 & 255;
		data[offset + 1] = this1 >>> 16 & 255;
		data[offset + 2] = this1 >>> 8 & 255;
		data[offset + 3] = this1 & 255;
		break;
	case 1:
		data[offset] = this1 & 255;
		data[offset + 1] = this1 >>> 24 & 255;
		data[offset + 2] = this1 >>> 16 & 255;
		data[offset + 3] = this1 >>> 8 & 255;
		break;
	case 2:
		data[offset] = this1 >>> 8 & 255;
		data[offset + 1] = this1 >>> 16 & 255;
		data[offset + 2] = this1 >>> 24 & 255;
		data[offset + 3] = this1 & 255;
		break;
	}
};
lime_math_RGBA.__fromARGB = function(argb) {
	var this1 = 0;
	var rgba = this1;
	rgba = (argb >>> 16 & 255 & 255) << 24 | (argb >>> 8 & 255 & 255) << 16 | (argb & 255 & 255) << 8 | argb >>> 24 & 255 & 255;
	return rgba;
};
lime_math_RGBA.__fromBGRA = function(bgra) {
	var this1 = 0;
	var rgba = this1;
	rgba = (bgra >>> 8 & 255 & 255) << 24 | (bgra >>> 16 & 255 & 255) << 16 | (bgra >>> 24 & 255 & 255) << 8 | bgra & 255 & 255;
	return rgba;
};
lime_math_RGBA.get_a = function(this1) {
	return this1 & 255;
};
lime_math_RGBA.set_a = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | value & 255;
	return value;
};
lime_math_RGBA.get_b = function(this1) {
	return this1 >>> 8 & 255;
};
lime_math_RGBA.set_b = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (value & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math_RGBA.get_g = function(this1) {
	return this1 >>> 16 & 255;
};
lime_math_RGBA.set_g = function(this1,value) {
	this1 = (this1 >>> 24 & 255 & 255) << 24 | (value & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
lime_math_RGBA.get_r = function(this1) {
	return this1 >>> 24 & 255;
};
lime_math_RGBA.set_r = function(this1,value) {
	this1 = (value & 255) << 24 | (this1 >>> 16 & 255 & 255) << 16 | (this1 >>> 8 & 255 & 255) << 8 | this1 & 255 & 255;
	return value;
};
var lime_math_Rectangle = function(x,y,width,height) {
	if(height == null) {
		height = 0;
	}
	if(width == null) {
		width = 0;
	}
	if(y == null) {
		y = 0;
	}
	if(x == null) {
		x = 0;
	}
	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;
};
$hxClasses["lime.math.Rectangle"] = lime_math_Rectangle;
lime_math_Rectangle.__name__ = "lime.math.Rectangle";
lime_math_Rectangle.prototype = {
	clone: function() {
		return new lime_math_Rectangle(this.x,this.y,this.width,this.height);
	}
	,contains: function(x,y) {
		if(x >= this.x && y >= this.y && x < this.get_right()) {
			return y < this.get_bottom();
		} else {
			return false;
		}
	}
	,containsPoint: function(point) {
		return this.containsVector(point);
	}
	,containsRect: function(rect) {
		if(rect.width <= 0 || rect.height <= 0) {
			if(rect.x > this.x && rect.y > this.y && rect.get_right() < this.get_right()) {
				return rect.get_bottom() < this.get_bottom();
			} else {
				return false;
			}
		} else if(rect.x >= this.x && rect.y >= this.y && rect.get_right() <= this.get_right()) {
			return rect.get_bottom() <= this.get_bottom();
		} else {
			return false;
		}
	}
	,containsVector: function(vector) {
		return this.contains(vector.x,vector.y);
	}
	,copyFrom: function(sourceRect) {
		this.x = sourceRect.x;
		this.y = sourceRect.y;
		this.width = sourceRect.width;
		this.height = sourceRect.height;
	}
	,equals: function(toCompare) {
		if(toCompare != null && this.x == toCompare.x && this.y == toCompare.y && this.width == toCompare.width) {
			return this.height == toCompare.height;
		} else {
			return false;
		}
	}
	,inflate: function(dx,dy) {
		this.x -= dx;
		this.width += dx * 2;
		this.y -= dy;
		this.height += dy * 2;
	}
	,inflateVector: function(vector) {
		this.inflate(vector.x,vector.y);
	}
	,intersection: function(toIntersect,result) {
		if(result == null) {
			result = new lime_math_Rectangle();
		}
		var x0 = this.x < toIntersect.x ? toIntersect.x : this.x;
		var x1 = this.get_right() > toIntersect.get_right() ? toIntersect.get_right() : this.get_right();
		if(x1 <= x0) {
			result.setEmpty();
			return result;
		}
		var y0 = this.y < toIntersect.y ? toIntersect.y : this.y;
		var y1 = this.get_bottom() > toIntersect.get_bottom() ? toIntersect.get_bottom() : this.get_bottom();
		if(y1 <= y0) {
			result.setEmpty();
			return result;
		}
		result.x = x0;
		result.y = y0;
		result.width = x1 - x0;
		result.height = y1 - y0;
		return result;
	}
	,intersects: function(toIntersect) {
		var x0 = this.x < toIntersect.x ? toIntersect.x : this.x;
		var x1 = this.get_right() > toIntersect.get_right() ? toIntersect.get_right() : this.get_right();
		if(x1 <= x0) {
			return false;
		}
		var y0 = this.y < toIntersect.y ? toIntersect.y : this.y;
		var y1 = this.get_bottom() > toIntersect.get_bottom() ? toIntersect.get_bottom() : this.get_bottom();
		return y1 > y0;
	}
	,isEmpty: function() {
		if(!(this.width <= 0)) {
			return this.height <= 0;
		} else {
			return true;
		}
	}
	,offset: function(dx,dy) {
		this.x += dx;
		this.y += dy;
	}
	,offsetVector: function(vector) {
		this.x += vector.x;
		this.y += vector.y;
	}
	,setEmpty: function() {
		this.x = this.y = this.width = this.height = 0;
	}
	,setTo: function(xa,ya,widtha,heighta) {
		this.x = xa;
		this.y = ya;
		this.width = widtha;
		this.height = heighta;
	}
	,union: function(toUnion,result) {
		if(result == null) {
			result = new lime_math_Rectangle();
		}
		if(this.width == 0 || this.height == 0) {
			result.copyFrom(toUnion);
		} else if(toUnion.width == 0 || toUnion.height == 0) {
			result.copyFrom(this);
		} else {
			var x0 = this.x > toUnion.x ? toUnion.x : this.x;
			var x1 = this.get_right() < toUnion.get_right() ? toUnion.get_right() : this.get_right();
			var y0 = this.y > toUnion.y ? toUnion.y : this.y;
			var y1 = this.get_bottom() < toUnion.get_bottom() ? toUnion.get_bottom() : this.get_bottom();
			result.setTo(x0,y0,x1 - x0,y1 - y0);
		}
		return result;
	}
	,__toFlashRectangle: function() {
		return null;
	}
	,get_bottom: function() {
		return this.y + this.height;
	}
	,set_bottom: function(b) {
		this.height = b - this.y;
		return b;
	}
	,get_bottomRight: function() {
		return new lime_math_Vector2(this.x + this.width,this.y + this.height);
	}
	,set_bottomRight: function(p) {
		this.width = p.x - this.x;
		this.height = p.y - this.y;
		return p.clone();
	}
	,get_left: function() {
		return this.x;
	}
	,set_left: function(l) {
		this.width -= l - this.x;
		this.x = l;
		return l;
	}
	,get_right: function() {
		return this.x + this.width;
	}
	,set_right: function(r) {
		this.width = r - this.x;
		return r;
	}
	,get_size: function() {
		return new lime_math_Vector2(this.width,this.height);
	}
	,set_size: function(p) {
		this.width = p.x;
		this.height = p.y;
		return p.clone();
	}
	,get_top: function() {
		return this.y;
	}
	,set_top: function(t) {
		this.height -= t - this.y;
		this.y = t;
		return t;
	}
	,get_topLeft: function() {
		return new lime_math_Vector2(this.x,this.y);
	}
	,set_topLeft: function(p) {
		this.x = p.x;
		this.y = p.y;
		return p.clone();
	}
	,__class__: lime_math_Rectangle
	,__properties__: {set_topLeft:"set_topLeft",get_topLeft:"get_topLeft",set_top:"set_top",get_top:"get_top",set_size:"set_size",get_size:"get_size",set_right:"set_right",get_right:"get_right",set_left:"set_left",get_left:"get_left",set_bottomRight:"set_bottomRight",get_bottomRight:"get_bottomRight",set_bottom:"set_bottom",get_bottom:"get_bottom"}
};
var lime_math_Vector2 = function(x,y) {
	if(y == null) {
		y = 0;
	}
	if(x == null) {
		x = 0;
	}
	this.x = x;
	this.y = y;
};
$hxClasses["lime.math.Vector2"] = lime_math_Vector2;
lime_math_Vector2.__name__ = "lime.math.Vector2";
lime_math_Vector2.distance = function(pt1,pt2) {
	var dx = pt1.x - pt2.x;
	var dy = pt1.y - pt2.y;
	return Math.sqrt(dx * dx + dy * dy);
};
lime_math_Vector2.interpolate = function(pt1,pt2,f,result) {
	if(result == null) {
		result = new lime_math_Vector2();
	}
	result.x = pt2.x + f * (pt1.x - pt2.x);
	result.y = pt2.y + f * (pt1.y - pt2.y);
	return result;
};
lime_math_Vector2.polar = function(len,angle,result) {
	if(result == null) {
		result = new lime_math_Vector2();
	}
	var ya = len * Math.sin(angle);
	result.x = len * Math.cos(angle);
	result.y = ya;
	return result;
};
lime_math_Vector2.prototype = {
	add: function(v,result) {
		if(result == null) {
			result = new lime_math_Vector2();
		}
		result.x = v.x + this.x;
		result.y = v.y + this.y;
		return result;
	}
	,clone: function() {
		return new lime_math_Vector2(this.x,this.y);
	}
	,equals: function(toCompare) {
		if(toCompare != null && toCompare.x == this.x) {
			return toCompare.y == this.y;
		} else {
			return false;
		}
	}
	,normalize: function(thickness) {
		if(this.x == 0 && this.y == 0) {
			return;
		} else {
			var norm = thickness / Math.sqrt(this.x * this.x + this.y * this.y);
			this.x *= norm;
			this.y *= norm;
		}
	}
	,offset: function(dx,dy) {
		this.x += dx;
		this.y += dy;
	}
	,setTo: function(xa,ya) {
		this.x = xa;
		this.y = ya;
	}
	,subtract: function(v,result) {
		if(result == null) {
			result = new lime_math_Vector2();
		}
		result.x = this.x - v.x;
		result.y = this.y - v.y;
		return result;
	}
	,__toFlashPoint: function() {
		return null;
	}
	,get_length: function() {
		return Math.sqrt(this.x * this.x + this.y * this.y);
	}
	,get_lengthSquared: function() {
		return this.x * this.x + this.y * this.y;
	}
	,__class__: lime_math_Vector2
	,__properties__: {get_lengthSquared:"get_lengthSquared",get_length:"get_length"}
};
var lime_math_Vector4 = function(x,y,z,w) {
	if(w == null) {
		w = 0.;
	}
	if(z == null) {
		z = 0.;
	}
	if(y == null) {
		y = 0.;
	}
	if(x == null) {
		x = 0.;
	}
	this.w = w;
	this.x = x;
	this.y = y;
	this.z = z;
};
$hxClasses["lime.math.Vector4"] = lime_math_Vector4;
lime_math_Vector4.__name__ = "lime.math.Vector4";
lime_math_Vector4.__properties__ = {get_Z_AXIS:"get_Z_AXIS",get_Y_AXIS:"get_Y_AXIS",get_X_AXIS:"get_X_AXIS"};
lime_math_Vector4.angleBetween = function(a,b) {
	var a0 = new lime_math_Vector4(a.x,a.y,a.z,a.w);
	var l = Math.sqrt(a0.x * a0.x + a0.y * a0.y + a0.z * a0.z);
	if(l != 0) {
		a0.x /= l;
		a0.y /= l;
		a0.z /= l;
	}
	var b0 = new lime_math_Vector4(b.x,b.y,b.z,b.w);
	var l = Math.sqrt(b0.x * b0.x + b0.y * b0.y + b0.z * b0.z);
	if(l != 0) {
		b0.x /= l;
		b0.y /= l;
		b0.z /= l;
	}
	return Math.acos(a0.x * b0.x + a0.y * b0.y + a0.z * b0.z);
};
lime_math_Vector4.distance = function(pt1,pt2) {
	var x = pt2.x - pt1.x;
	var y = pt2.y - pt1.y;
	var z = pt2.z - pt1.z;
	return Math.sqrt(x * x + y * y + z * z);
};
lime_math_Vector4.distanceSquared = function(pt1,pt2) {
	var x = pt2.x - pt1.x;
	var y = pt2.y - pt1.y;
	var z = pt2.z - pt1.z;
	return x * x + y * y + z * z;
};
lime_math_Vector4.get_X_AXIS = function() {
	return new lime_math_Vector4(1,0,0);
};
lime_math_Vector4.get_Y_AXIS = function() {
	return new lime_math_Vector4(0,1,0);
};
lime_math_Vector4.get_Z_AXIS = function() {
	return new lime_math_Vector4(0,0,1);
};
lime_math_Vector4.prototype = {
	add: function(a,result) {
		if(result == null) {
			result = new lime_math_Vector4();
		}
		result.x = this.x + a.x;
		result.y = this.y + a.y;
		result.z = this.z + a.z;
		return result;
	}
	,clone: function() {
		return new lime_math_Vector4(this.x,this.y,this.z,this.w);
	}
	,copyFrom: function(sourceVector4) {
		this.x = sourceVector4.x;
		this.y = sourceVector4.y;
		this.z = sourceVector4.z;
	}
	,crossProduct: function(a,result) {
		if(result == null) {
			result = new lime_math_Vector4();
		}
		var ya = this.z * a.x - this.x * a.z;
		var za = this.x * a.y - this.y * a.x;
		result.x = this.y * a.z - this.z * a.y;
		result.y = ya;
		result.z = za;
		result.w = 1;
		return result;
	}
	,decrementBy: function(a) {
		this.x -= a.x;
		this.y -= a.y;
		this.z -= a.z;
	}
	,dotProduct: function(a) {
		return this.x * a.x + this.y * a.y + this.z * a.z;
	}
	,equals: function(toCompare,allFour) {
		if(allFour == null) {
			allFour = false;
		}
		if(this.x == toCompare.x && this.y == toCompare.y && this.z == toCompare.z) {
			if(!(!allFour)) {
				return this.w == toCompare.w;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	,incrementBy: function(a) {
		this.x += a.x;
		this.y += a.y;
		this.z += a.z;
	}
	,nearEquals: function(toCompare,tolerance,allFour) {
		if(allFour == null) {
			allFour = false;
		}
		if(Math.abs(this.x - toCompare.x) < tolerance && Math.abs(this.y - toCompare.y) < tolerance && Math.abs(this.z - toCompare.z) < tolerance) {
			if(!(!allFour)) {
				return Math.abs(this.w - toCompare.w) < tolerance;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	,negate: function() {
		this.x *= -1;
		this.y *= -1;
		this.z *= -1;
	}
	,normalize: function() {
		var l = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
		if(l != 0) {
			this.x /= l;
			this.y /= l;
			this.z /= l;
		}
		return l;
	}
	,project: function() {
		this.x /= this.w;
		this.y /= this.w;
		this.z /= this.w;
	}
	,scaleBy: function(s) {
		this.x *= s;
		this.y *= s;
		this.z *= s;
	}
	,setTo: function(xa,ya,za) {
		this.x = xa;
		this.y = ya;
		this.z = za;
	}
	,subtract: function(a,result) {
		if(result == null) {
			result = new lime_math_Vector4();
		}
		result.x = this.x - a.x;
		result.y = this.y - a.y;
		result.z = this.z - a.z;
		return result;
	}
	,toString: function() {
		return "Vector4(" + this.x + ", " + this.y + ", " + this.z + ")";
	}
	,get_length: function() {
		return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
	}
	,get_lengthSquared: function() {
		return this.x * this.x + this.y * this.y + this.z * this.z;
	}
	,__class__: lime_math_Vector4
	,__properties__: {get_lengthSquared:"get_lengthSquared",get_length:"get_length"}
};
var lime_media_AudioBuffer = function() {
};
$hxClasses["lime.media.AudioBuffer"] = lime_media_AudioBuffer;
lime_media_AudioBuffer.__name__ = "lime.media.AudioBuffer";
lime_media_AudioBuffer.fromBase64 = function(base64String) {
	if(base64String == null) {
		return null;
	}
	if(base64String.indexOf(",") == -1) {
		base64String = "data:" + lime_media_AudioBuffer.__getCodec(lime__$internal_format_Base64.decode(base64String)) + ";base64," + base64String;
	}
	var audioBuffer = new lime_media_AudioBuffer();
	audioBuffer.set_src(new Howl({ src : [base64String], html5 : true, preload : false}));
	return audioBuffer;
};
lime_media_AudioBuffer.fromBytes = function(bytes) {
	if(bytes == null) {
		return null;
	}
	var audioBuffer = new lime_media_AudioBuffer();
	audioBuffer.set_src(new Howl({ src : ["data:" + lime_media_AudioBuffer.__getCodec(bytes) + ";base64," + lime__$internal_format_Base64.encode(bytes)], html5 : true, preload : false}));
	return audioBuffer;
};
lime_media_AudioBuffer.fromFile = function(path) {
	if(path == null) {
		return null;
	}
	var audioBuffer = new lime_media_AudioBuffer();
	audioBuffer.__srcHowl = new Howl({ src : [path], preload : false});
	return audioBuffer;
};
lime_media_AudioBuffer.fromFiles = function(paths) {
	var audioBuffer = new lime_media_AudioBuffer();
	audioBuffer.__srcHowl = new Howl({ src : paths, preload : false});
	return audioBuffer;
};
lime_media_AudioBuffer.fromVorbisFile = function(vorbisFile) {
	return null;
};
lime_media_AudioBuffer.loadFromFile = function(path) {
	var promise = new lime_app_Promise();
	var audioBuffer = lime_media_AudioBuffer.fromFile(path);
	if(audioBuffer != null) {
		if(audioBuffer != null) {
			audioBuffer.__srcHowl.on("load",function() {
				promise.complete(audioBuffer);
			});
			audioBuffer.__srcHowl.on("loaderror",function(id,msg) {
				promise.error(msg);
			});
			audioBuffer.__srcHowl.load();
		}
	} else {
		promise.error(null);
	}
	return promise.future;
};
lime_media_AudioBuffer.loadFromFiles = function(paths) {
	var promise = new lime_app_Promise();
	var audioBuffer = lime_media_AudioBuffer.fromFiles(paths);
	if(audioBuffer != null) {
		audioBuffer.__srcHowl.on("load",function() {
			promise.complete(audioBuffer);
		});
		audioBuffer.__srcHowl.on("loaderror",function() {
			promise.error(null);
		});
		audioBuffer.__srcHowl.load();
	} else {
		promise.error(null);
	}
	return promise.future;
};
lime_media_AudioBuffer.__getCodec = function(bytes) {
	var signature = bytes.getString(0,4);
	switch(signature) {
	case "OggS":
		return "audio/ogg";
	case "RIFF":
		if(bytes.getString(8,4) == "WAVE") {
			return "audio/wav";
		} else {
			var _g = bytes.b[2];
			var _g1 = bytes.b[1];
			switch(bytes.b[0]) {
			case 73:
				if(_g1 == 68) {
					if(_g == 51) {
						return "audio/mp3";
					}
				}
				break;
			case 255:
				switch(_g1) {
				case 243:case 250:case 251:
					return "audio/mp3";
				default:
				}
				break;
			default:
			}
		}
		break;
	case "fLaC":
		return "audio/flac";
	default:
		var _g = bytes.b[2];
		var _g1 = bytes.b[1];
		switch(bytes.b[0]) {
		case 73:
			if(_g1 == 68) {
				if(_g == 51) {
					return "audio/mp3";
				}
			}
			break;
		case 255:
			switch(_g1) {
			case 243:case 250:case 251:
				return "audio/mp3";
			default:
			}
			break;
		default:
		}
	}
	lime_utils_Log.error("Unsupported sound format",{ fileName : "lime/media/AudioBuffer.hx", lineNumber : 362, className : "lime.media.AudioBuffer", methodName : "__getCodec"});
	return null;
};
lime_media_AudioBuffer.prototype = {
	dispose: function() {
		this.__srcHowl.unload();
	}
	,get_src: function() {
		return this.__srcHowl;
	}
	,set_src: function(value) {
		return this.__srcHowl = value;
	}
	,__class__: lime_media_AudioBuffer
	,__properties__: {set_src:"set_src",get_src:"get_src"}
};
var lime_media_AudioContext = function(type) {
	if(type != "custom") {
		if(type == null || type == "web") {
			try {
				window.AudioContext = window.AudioContext || window.webkitAudioContext;
				this.web = new window.AudioContext ();
				this.type = "web";
			} catch( _g ) {
				haxe_NativeStackTrace.lastError = _g;
			}
		}
		if(this.web == null && type != "web") {
			this.html5 = new lime_media_HTML5AudioContext();
			this.type = "html5";
		}
	} else {
		this.type = "custom";
	}
};
$hxClasses["lime.media.AudioContext"] = lime_media_AudioContext;
lime_media_AudioContext.__name__ = "lime.media.AudioContext";
lime_media_AudioContext.prototype = {
	__class__: lime_media_AudioContext
};
var lime_media_AudioManager = function() { };
$hxClasses["lime.media.AudioManager"] = lime_media_AudioManager;
lime_media_AudioManager.__name__ = "lime.media.AudioManager";
lime_media_AudioManager.init = function(context) {
	if(lime_media_AudioManager.context == null) {
		if(context == null) {
			lime_media_AudioManager.context = new lime_media_AudioContext();
			context = lime_media_AudioManager.context;
			if(context.type == "openal") {
				var alc = context.openal;
				var device = alc.openDevice();
				var ctx = alc.createContext(device);
				alc.makeContextCurrent(ctx);
				alc.processContext(ctx);
			}
		}
		lime_media_AudioManager.context = context;
	}
};
lime_media_AudioManager.resume = function() {
	if(lime_media_AudioManager.context != null && lime_media_AudioManager.context.type == "openal") {
		var alc = lime_media_AudioManager.context.openal;
		var currentContext = alc.getCurrentContext();
		if(currentContext != null) {
			var device = alc.getContextsDevice(currentContext);
			alc.resumeDevice(device);
			alc.processContext(currentContext);
		}
	}
};
lime_media_AudioManager.shutdown = function() {
	if(lime_media_AudioManager.context != null && lime_media_AudioManager.context.type == "openal") {
		var alc = lime_media_AudioManager.context.openal;
		var currentContext = alc.getCurrentContext();
		if(currentContext != null) {
			var device = alc.getContextsDevice(currentContext);
			alc.makeContextCurrent(null);
			alc.destroyContext(currentContext);
			if(device != null) {
				alc.closeDevice(device);
			}
		}
	}
	lime_media_AudioManager.context = null;
};
lime_media_AudioManager.suspend = function() {
	if(lime_media_AudioManager.context != null && lime_media_AudioManager.context.type == "openal") {
		var alc = lime_media_AudioManager.context.openal;
		var currentContext = alc.getCurrentContext();
		if(currentContext != null) {
			alc.suspendContext(currentContext);
			var device = alc.getContextsDevice(currentContext);
			if(device != null) {
				alc.pauseDevice(device);
			}
		}
	}
};
var lime_media_AudioSource = function(buffer,offset,length,loops) {
	if(loops == null) {
		loops = 0;
	}
	if(offset == null) {
		offset = 0;
	}
	this.onComplete = new lime_app__$Event_$Void_$Void();
	this.buffer = buffer;
	this.offset = offset;
	this.__backend = new lime__$internal_backend_html5_HTML5AudioSource(this);
	if(length != null && length != 0) {
		this.set_length(length);
	}
	this.set_loops(loops);
	if(buffer != null) {
		this.init();
	}
};
$hxClasses["lime.media.AudioSource"] = lime_media_AudioSource;
lime_media_AudioSource.__name__ = "lime.media.AudioSource";
lime_media_AudioSource.prototype = {
	dispose: function() {
		this.__backend.dispose();
	}
	,init: function() {
		this.__backend.init();
	}
	,play: function() {
		this.__backend.play();
	}
	,pause: function() {
		this.__backend.pause();
	}
	,stop: function() {
		this.__backend.stop();
	}
	,get_currentTime: function() {
		return this.__backend.getCurrentTime();
	}
	,set_currentTime: function(value) {
		return this.__backend.setCurrentTime(value);
	}
	,get_gain: function() {
		return this.__backend.getGain();
	}
	,set_gain: function(value) {
		return this.__backend.setGain(value);
	}
	,get_length: function() {
		return this.__backend.getLength();
	}
	,set_length: function(value) {
		return this.__backend.setLength(value);
	}
	,get_loops: function() {
		return this.__backend.getLoops();
	}
	,set_loops: function(value) {
		return this.__backend.setLoops(value);
	}
	,get_position: function() {
		return this.__backend.getPosition();
	}
	,set_position: function(value) {
		return this.__backend.setPosition(value);
	}
	,__class__: lime_media_AudioSource
	,__properties__: {set_position:"set_position",get_position:"get_position",set_loops:"set_loops",get_loops:"get_loops",set_length:"set_length",get_length:"get_length",set_gain:"set_gain",get_gain:"get_gain",set_currentTime:"set_currentTime",get_currentTime:"get_currentTime"}
};
var lime_media_FlashAudioContext = function() {
};
$hxClasses["lime.media.FlashAudioContext"] = lime_media_FlashAudioContext;
lime_media_FlashAudioContext.__name__ = "lime.media.FlashAudioContext";
lime_media_FlashAudioContext.prototype = {
	createBuffer: function(stream,context) {
		return null;
	}
	,getBytesLoaded: function(buffer) {
		return 0;
	}
	,getBytesTotal: function(buffer) {
		return 0;
	}
	,getID3: function(buffer) {
		return null;
	}
	,getIsBuffering: function(buffer) {
		return false;
	}
	,getIsURLInaccessible: function(buffer) {
		return false;
	}
	,getLength: function(buffer) {
		return 0;
	}
	,getURL: function(buffer) {
		return null;
	}
	,close: function(buffer) {
	}
	,extract: function(buffer,target,length,startPosition) {
		if(startPosition == null) {
			startPosition = -1;
		}
		return 0;
	}
	,load: function(buffer,stream,context) {
	}
	,loadCompressedDataFromByteArray: function(buffer,bytes,bytesLength) {
	}
	,loadPCMFromByteArray: function(buffer,bytes,samples,format,stereo,sampleRate) {
		if(sampleRate == null) {
			sampleRate = 44100;
		}
		if(stereo == null) {
			stereo = true;
		}
	}
	,play: function(buffer,startTime,loops,sndTransform) {
		if(loops == null) {
			loops = 0;
		}
		if(startTime == null) {
			startTime = 0;
		}
		return null;
	}
	,__class__: lime_media_FlashAudioContext
};
var lime_media_HTML5AudioContext = function() {
	this.NETWORK_NO_SOURCE = 3;
	this.NETWORK_LOADING = 2;
	this.NETWORK_IDLE = 1;
	this.NETWORK_EMPTY = 0;
	this.HAVE_NOTHING = 0;
	this.HAVE_METADATA = 1;
	this.HAVE_FUTURE_DATA = 3;
	this.HAVE_ENOUGH_DATA = 4;
	this.HAVE_CURRENT_DATA = 2;
};
$hxClasses["lime.media.HTML5AudioContext"] = lime_media_HTML5AudioContext;
lime_media_HTML5AudioContext.__name__ = "lime.media.HTML5AudioContext";
lime_media_HTML5AudioContext.prototype = {
	canPlayType: function(buffer,type) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.canPlayType(type);
		}
		return null;
	}
	,createBuffer: function(urlString) {
		var buffer = new lime_media_AudioBuffer();
		buffer.__srcAudio = new Audio();
		buffer.__srcAudio.src = urlString;
		return buffer;
	}
	,getAutoplay: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.autoplay;
		}
		return false;
	}
	,getBuffered: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.buffered;
		}
		return null;
	}
	,getCurrentSrc: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.currentSrc;
		}
		return null;
	}
	,getCurrentTime: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.currentTime;
		}
		return 0;
	}
	,getDefaultPlaybackRate: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.defaultPlaybackRate;
		}
		return 1;
	}
	,getDuration: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.duration;
		}
		return 0;
	}
	,getEnded: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.ended;
		}
		return false;
	}
	,getError: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.error;
		}
		return null;
	}
	,getLoop: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.loop;
		}
		return false;
	}
	,getMuted: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.muted;
		}
		return false;
	}
	,getNetworkState: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.networkState;
		}
		return 0;
	}
	,getPaused: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.paused;
		}
		return false;
	}
	,getPlaybackRate: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.playbackRate;
		}
		return 1;
	}
	,getPlayed: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.played;
		}
		return null;
	}
	,getPreload: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.preload;
		}
		return null;
	}
	,getReadyState: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.readyState;
		}
		return 0;
	}
	,getSeekable: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.seekable;
		}
		return null;
	}
	,getSeeking: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.seeking;
		}
		return false;
	}
	,getSrc: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.src;
		}
		return null;
	}
	,getStartTime: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.playbackRate;
		}
		return 0;
	}
	,getVolume: function(buffer) {
		if(buffer.__srcAudio != null) {
			return buffer.__srcAudio.volume;
		}
		return 1;
	}
	,load: function(buffer) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.load();
		}
	}
	,pause: function(buffer) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.pause();
		}
	}
	,play: function(buffer) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.play();
		}
	}
	,setAutoplay: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.autoplay = value;
		}
	}
	,setCurrentTime: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.currentTime = value;
		}
	}
	,setDefaultPlaybackRate: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.defaultPlaybackRate = value;
		}
	}
	,setLoop: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.loop = value;
		}
	}
	,setMuted: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.muted = value;
		}
	}
	,setPlaybackRate: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.playbackRate = value;
		}
	}
	,setPreload: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.preload = value;
		}
	}
	,setSrc: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.src = value;
		}
	}
	,setVolume: function(buffer,value) {
		if(buffer.__srcAudio != null) {
			buffer.__srcAudio.volume = value;
		}
	}
	,__class__: lime_media_HTML5AudioContext
};
var lime_media_OpenALAudioContext = function() {
	this.ALL_DEVICES_SPECIFIER = 4115;
	this.DEFAULT_ALL_DEVICES_SPECIFIER = 4114;
	this.ENUMERATE_ALL_EXT = 1;
	this.DEVICE_SPECIFIER = 4101;
	this.DEFAULT_DEVICE_SPECIFIER = 4100;
	this.ALL_ATTRIBUTES = 4099;
	this.ATTRIBUTES_SIZE = 4098;
	this.INVALID_CONTEXT = 40962;
	this.INVALID_DEVICE = 40961;
	this.STEREO_SOURCES = 4113;
	this.MONO_SOURCES = 4112;
	this.SYNC = 4105;
	this.REFRESH = 4104;
	this.EXPONENT_DISTANCE_CLAMPED = 53254;
	this.EXPONENT_DISTANCE = 53253;
	this.LINEAR_DISTANCE_CLAMPED = 53252;
	this.LINEAR_DISTANCE = 53251;
	this.INVERSE_DISTANCE_CLAMPED = 53250;
	this.INVERSE_DISTANCE = 53249;
	this.DISTANCE_MODEL = 53248;
	this.DOPPLER_VELOCITY = 49153;
	this.SPEED_OF_SOUND = 49155;
	this.DOPPLER_FACTOR = 49152;
	this.EXTENSIONS = 45060;
	this.RENDERER = 45059;
	this.VERSION = 45058;
	this.VENDOR = 45057;
	this.OUT_OF_MEMORY = 40965;
	this.INVALID_OPERATION = 40964;
	this.INVALID_VALUE = 40963;
	this.INVALID_ENUM = 40962;
	this.INVALID_NAME = 40961;
	this.NO_ERROR = 0;
	this.SIZE = 8196;
	this.CHANNELS = 8195;
	this.BITS = 8194;
	this.FREQUENCY = 8193;
	this.FORMAT_STEREO16 = 4355;
	this.FORMAT_STEREO8 = 4354;
	this.FORMAT_MONO16 = 4353;
	this.FORMAT_MONO8 = 4352;
	this.UNDETERMINED = 4144;
	this.STREAMING = 4137;
	this.STATIC = 4136;
	this.SOURCE_TYPE = 4135;
	this.BYTE_OFFSET = 4134;
	this.SAMPLE_OFFSET = 4133;
	this.SEC_OFFSET = 4132;
	this.MAX_DISTANCE = 4131;
	this.CONE_OUTER_GAIN = 4130;
	this.ROLLOFF_FACTOR = 4129;
	this.REFERENCE_DISTANCE = 4128;
	this.BUFFERS_PROCESSED = 4118;
	this.BUFFERS_QUEUED = 4117;
	this.STOPPED = 4116;
	this.PAUSED = 4115;
	this.PLAYING = 4114;
	this.INITIAL = 4113;
	this.SOURCE_STATE = 4112;
	this.ORIENTATION = 4111;
	this.MAX_GAIN = 4110;
	this.MIN_GAIN = 4109;
	this.GAIN = 4106;
	this.BUFFER = 4105;
	this.LOOPING = 4103;
	this.VELOCITY = 4102;
	this.DIRECTION = 4101;
	this.POSITION = 4100;
	this.PITCH = 4099;
	this.CONE_OUTER_ANGLE = 4098;
	this.CONE_INNER_ANGLE = 4097;
	this.SOURCE_RELATIVE = 514;
	this.TRUE = 1;
	this.FALSE = 0;
	this.NONE = 0;
};
$hxClasses["lime.media.OpenALAudioContext"] = lime_media_OpenALAudioContext;
lime_media_OpenALAudioContext.__name__ = "lime.media.OpenALAudioContext";
lime_media_OpenALAudioContext.prototype = {
	bufferData: function(buffer,format,data,size,freq) {
		lime_media_openal_AL.bufferData(buffer,format,data,size,freq);
	}
	,buffer3f: function(buffer,param,value1,value2,value3) {
		lime_media_openal_AL.buffer3f(buffer,param,value1,value2,value3);
	}
	,buffer3i: function(buffer,param,value1,value2,value3) {
		lime_media_openal_AL.buffer3i(buffer,param,value1,value2,value3);
	}
	,bufferf: function(buffer,param,value) {
		lime_media_openal_AL.bufferf(buffer,param,value);
	}
	,bufferfv: function(buffer,param,values) {
		lime_media_openal_AL.bufferfv(buffer,param,values);
	}
	,bufferi: function(buffer,param,value) {
		lime_media_openal_AL.bufferi(buffer,param,value);
	}
	,bufferiv: function(buffer,param,values) {
		lime_media_openal_AL.bufferiv(buffer,param,values);
	}
	,closeDevice: function(device) {
		return lime_media_openal_ALC.closeDevice(device);
	}
	,createContext: function(device,attrlist) {
		return lime_media_openal_ALC.createContext(device,attrlist);
	}
	,createBuffer: function() {
		return lime_media_openal_AL.createBuffer();
	}
	,createSource: function() {
		return lime_media_openal_AL.createSource();
	}
	,deleteBuffer: function(buffer) {
		lime_media_openal_AL.deleteBuffer(buffer);
	}
	,deleteBuffers: function(buffers) {
		lime_media_openal_AL.deleteBuffers(buffers);
	}
	,deleteSource: function(source) {
		lime_media_openal_AL.deleteSource(source);
	}
	,deleteSources: function(sources) {
		lime_media_openal_AL.deleteSources(sources);
	}
	,destroyContext: function(context) {
		if(context == null) {
			return;
		}
		lime_media_openal_ALC.destroyContext(context);
	}
	,disable: function(capability) {
		lime_media_openal_AL.disable(capability);
	}
	,distanceModel: function(distanceModel) {
		lime_media_openal_AL.distanceModel(distanceModel);
	}
	,dopplerFactor: function(value) {
		lime_media_openal_AL.dopplerFactor(value);
	}
	,dopplerVelocity: function(value) {
		lime_media_openal_AL.dopplerVelocity(value);
	}
	,enable: function(capability) {
		lime_media_openal_AL.enable(capability);
	}
	,genSource: function() {
		return this.createSource();
	}
	,genSources: function(n) {
		return lime_media_openal_AL.genSources(n);
	}
	,genBuffer: function() {
		return this.createBuffer();
	}
	,genBuffers: function(n) {
		return lime_media_openal_AL.genBuffers(n);
	}
	,getBoolean: function(param) {
		return lime_media_openal_AL.getBoolean(param);
	}
	,getBooleanv: function(param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getBooleanv(param,count);
	}
	,getBuffer3f: function(buffer,param) {
		return lime_media_openal_AL.getBuffer3f(buffer,param);
	}
	,getBuffer3i: function(buffer,param) {
		return lime_media_openal_AL.getBuffer3i(buffer,param);
	}
	,getBufferf: function(buffer,param) {
		return lime_media_openal_AL.getBufferf(buffer,param);
	}
	,getBufferfv: function(buffer,param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getBufferfv(buffer,param,count);
	}
	,getBufferi: function(buffer,param) {
		return lime_media_openal_AL.getBufferi(buffer,param);
	}
	,getBufferiv: function(buffer,param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getBufferiv(buffer,param,count);
	}
	,getContextsDevice: function(context) {
		if(context == null) {
			return null;
		}
		return lime_media_openal_ALC.getContextsDevice(context);
	}
	,getCurrentContext: function() {
		return lime_media_openal_ALC.getCurrentContext();
	}
	,getDouble: function(param) {
		return lime_media_openal_AL.getDouble(param);
	}
	,getDoublev: function(param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getDoublev(param,count);
	}
	,getEnumValue: function(ename) {
		return lime_media_openal_AL.getEnumValue(ename);
	}
	,getError: function(device) {
		if(device == null) {
			return lime_media_openal_AL.getError();
		} else {
			return lime_media_openal_ALC.getError(device);
		}
	}
	,getErrorString: function(device) {
		if(device == null) {
			return lime_media_openal_AL.getErrorString();
		} else {
			return lime_media_openal_ALC.getErrorString(device);
		}
	}
	,getFloat: function(param) {
		return lime_media_openal_AL.getFloat(param);
	}
	,getFloatv: function(param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getFloatv(param,count);
	}
	,getInteger: function(param) {
		return lime_media_openal_AL.getInteger(param);
	}
	,getIntegerv: function(param,count,device) {
		if(count == null) {
			count = 1;
		}
		if(device == null) {
			return lime_media_openal_AL.getIntegerv(param,count);
		} else {
			return lime_media_openal_ALC.getIntegerv(device,param,count);
		}
	}
	,getListener3f: function(param) {
		return lime_media_openal_AL.getListener3f(param);
	}
	,getListener3i: function(param) {
		return lime_media_openal_AL.getListener3i(param);
	}
	,getListenerf: function(param) {
		return lime_media_openal_AL.getListenerf(param);
	}
	,getListenerfv: function(param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getListenerfv(param,count);
	}
	,getListeneri: function(param) {
		return lime_media_openal_AL.getListeneri(param);
	}
	,getListeneriv: function(param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getListeneriv(param,count);
	}
	,getProcAddress: function(fname) {
		return lime_media_openal_AL.getProcAddress(fname);
	}
	,getSource3f: function(source,param) {
		return lime_media_openal_AL.getSource3f(source,param);
	}
	,getSourcef: function(source,param) {
		return lime_media_openal_AL.getSourcef(source,param);
	}
	,getSource3i: function(source,param) {
		return lime_media_openal_AL.getSource3i(source,param);
	}
	,getSourcefv: function(source,param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getSourcefv(source,param);
	}
	,getSourcei: function(source,param) {
		return lime_media_openal_AL.getSourcei(source,param);
	}
	,getSourceiv: function(source,param,count) {
		if(count == null) {
			count = 1;
		}
		return lime_media_openal_AL.getSourceiv(source,param,count);
	}
	,getString: function(param,device) {
		if(device == null) {
			return lime_media_openal_AL.getString(param);
		} else {
			return lime_media_openal_ALC.getString(device,param);
		}
	}
	,isBuffer: function(buffer) {
		return lime_media_openal_AL.isBuffer(buffer);
	}
	,isEnabled: function(capability) {
		return lime_media_openal_AL.isEnabled(capability);
	}
	,isExtensionPresent: function(extname) {
		return lime_media_openal_AL.isExtensionPresent(extname);
	}
	,isSource: function(source) {
		return lime_media_openal_AL.isSource(source);
	}
	,listener3f: function(param,value1,value2,value3) {
		lime_media_openal_AL.listener3f(param,value1,value2,value3);
	}
	,listener3i: function(param,value1,value2,value3) {
		lime_media_openal_AL.listener3i(param,value1,value2,value3);
	}
	,listenerf: function(param,value) {
		lime_media_openal_AL.listenerf(param,value);
	}
	,listenerfv: function(param,values) {
		lime_media_openal_AL.listenerfv(param,values);
	}
	,listeneri: function(param,value) {
		lime_media_openal_AL.listeneri(param,value);
	}
	,listeneriv: function(param,values) {
		lime_media_openal_AL.listeneriv(param,values);
	}
	,makeContextCurrent: function(context) {
		return lime_media_openal_ALC.makeContextCurrent(context);
	}
	,openDevice: function(deviceName) {
		return lime_media_openal_ALC.openDevice(deviceName);
	}
	,pauseDevice: function(device) {
		lime_media_openal_ALC.pauseDevice(device);
	}
	,processContext: function(context) {
		lime_media_openal_ALC.processContext(context);
	}
	,resumeDevice: function(device) {
		lime_media_openal_ALC.resumeDevice(device);
	}
	,source3f: function(source,param,value1,value2,value3) {
		lime_media_openal_AL.source3f(source,param,value1,value2,value3);
	}
	,source3i: function(source,param,value1,value2,value3) {
		lime_media_openal_AL.source3i(source,param,value1,value2,value3);
	}
	,sourcef: function(source,param,value) {
		lime_media_openal_AL.sourcef(source,param,value);
	}
	,sourcefv: function(source,param,values) {
		lime_media_openal_AL.sourcefv(source,param,values);
	}
	,sourcei: function(source,param,value) {
		lime_media_openal_AL.sourcei(source,param,value);
	}
	,sourceiv: function(source,param,values) {
		lime_media_openal_AL.sourceiv(source,param,values);
	}
	,sourcePlay: function(source) {
		lime_media_openal_AL.sourcePlay(source);
	}
	,sourcePlayv: function(sources) {
		lime_media_openal_AL.sourcePlayv(sources);
	}
	,sourceStop: function(source) {
		lime_media_openal_AL.sourceStop(source);
	}
	,sourceStopv: function(sources) {
		lime_media_openal_AL.sourceStopv(sources);
	}
	,sourceRewind: function(source) {
		lime_media_openal_AL.sourceRewind(source);
	}
	,sourceRewindv: function(sources) {
		lime_media_openal_AL.sourceRewindv(sources);
	}
	,sourcePause: function(source) {
		lime_media_openal_AL.sourcePause(source);
	}
	,sourcePausev: function(sources) {
		lime_media_openal_AL.sourcePausev(sources);
	}
	,sourceQueueBuffer: function(source,buffer) {
		lime_media_openal_AL.sourceQueueBuffer(source,buffer);
	}
	,sourceQueueBuffers: function(source,nb,buffers) {
		lime_media_openal_AL.sourceQueueBuffers(source,nb,buffers);
	}
	,sourceUnqueueBuffer: function(source) {
		return lime_media_openal_AL.sourceUnqueueBuffer(source);
	}
	,sourceUnqueueBuffers: function(source,nb) {
		return lime_media_openal_AL.sourceUnqueueBuffers(source,nb);
	}
	,speedOfSound: function(value) {
		lime_media_openal_AL.speedOfSound(value);
	}
	,suspendContext: function(context) {
		lime_media_openal_ALC.suspendContext(context);
	}
	,__class__: lime_media_OpenALAudioContext
};
var lime_media_openal_AL = function() { };
$hxClasses["lime.media.openal.AL"] = lime_media_openal_AL;
lime_media_openal_AL.__name__ = "lime.media.openal.AL";
lime_media_openal_AL.removeDirectFilter = function(source) {
};
lime_media_openal_AL.removeSend = function(source,index) {
};
lime_media_openal_AL.auxf = function(aux,param,value) {
};
lime_media_openal_AL.auxfv = function(aux,param,values) {
};
lime_media_openal_AL.auxi = function(aux,param,value) {
};
lime_media_openal_AL.auxiv = function(aux,param,values) {
};
lime_media_openal_AL.bufferData = function(buffer,format,data,size,freq) {
};
lime_media_openal_AL.buffer3f = function(buffer,param,value1,value2,value3) {
};
lime_media_openal_AL.buffer3i = function(buffer,param,value1,value2,value3) {
};
lime_media_openal_AL.bufferf = function(buffer,param,value) {
};
lime_media_openal_AL.bufferfv = function(buffer,param,values) {
};
lime_media_openal_AL.bufferi = function(buffer,param,value) {
};
lime_media_openal_AL.bufferiv = function(buffer,param,values) {
};
lime_media_openal_AL.createAux = function() {
	return null;
};
lime_media_openal_AL.createBuffer = function() {
	return null;
};
lime_media_openal_AL.createEffect = function() {
	return null;
};
lime_media_openal_AL.createFilter = function() {
	return null;
};
lime_media_openal_AL.createSource = function() {
	return null;
};
lime_media_openal_AL.deleteBuffer = function(buffer) {
};
lime_media_openal_AL.deleteBuffers = function(buffers) {
};
lime_media_openal_AL.deleteSource = function(source) {
};
lime_media_openal_AL.deleteSources = function(sources) {
};
lime_media_openal_AL.disable = function(capability) {
};
lime_media_openal_AL.distanceModel = function(distanceModel) {
};
lime_media_openal_AL.dopplerFactor = function(value) {
};
lime_media_openal_AL.dopplerVelocity = function(value) {
};
lime_media_openal_AL.effectf = function(effect,param,value) {
};
lime_media_openal_AL.effectfv = function(effect,param,values) {
};
lime_media_openal_AL.effecti = function(effect,param,value) {
};
lime_media_openal_AL.effectiv = function(effect,param,values) {
};
lime_media_openal_AL.enable = function(capability) {
};
lime_media_openal_AL.genSource = function() {
	return null;
};
lime_media_openal_AL.genSources = function(n) {
	return null;
};
lime_media_openal_AL.genBuffer = function() {
	return null;
};
lime_media_openal_AL.genBuffers = function(n) {
	return null;
};
lime_media_openal_AL.getBoolean = function(param) {
	return false;
};
lime_media_openal_AL.getBooleanv = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getBuffer3f = function(buffer,param) {
	return null;
};
lime_media_openal_AL.getBuffer3i = function(buffer,param) {
	return null;
};
lime_media_openal_AL.getBufferf = function(buffer,param) {
	return 0;
};
lime_media_openal_AL.getBufferfv = function(buffer,param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getBufferi = function(buffer,param) {
	return 0;
};
lime_media_openal_AL.getBufferiv = function(buffer,param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getDouble = function(param) {
	return 0;
};
lime_media_openal_AL.getDoublev = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getEnumValue = function(ename) {
	return 0;
};
lime_media_openal_AL.getError = function() {
	return 0;
};
lime_media_openal_AL.getErrorString = function() {
	switch(lime_media_openal_AL.getError()) {
	case 40961:
		return "INVALID_NAME: Invalid parameter name";
	case 40962:
		return "INVALID_ENUM: Invalid enum value";
	case 40963:
		return "INVALID_VALUE: Invalid parameter value";
	case 40964:
		return "INVALID_OPERATION: Illegal operation or call";
	case 40965:
		return "OUT_OF_MEMORY: OpenAL has run out of memory";
	default:
		return "";
	}
};
lime_media_openal_AL.getFilteri = function(filter,param) {
	return 0;
};
lime_media_openal_AL.getFloat = function(param) {
	return 0;
};
lime_media_openal_AL.getFloatv = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getInteger = function(param) {
	return 0;
};
lime_media_openal_AL.getIntegerv = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getListener3f = function(param) {
	return null;
};
lime_media_openal_AL.getListener3i = function(param) {
	return null;
};
lime_media_openal_AL.getListenerf = function(param) {
	return 0;
};
lime_media_openal_AL.getListenerfv = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getListeneri = function(param) {
	return 0;
};
lime_media_openal_AL.getListeneriv = function(param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getParameter = function(param) {
	return null;
};
lime_media_openal_AL.getProcAddress = function(fname) {
	return null;
};
lime_media_openal_AL.getSource3f = function(source,param) {
	return null;
};
lime_media_openal_AL.getSourcef = function(source,param) {
	return 0;
};
lime_media_openal_AL.getSource3i = function(source,param) {
	return null;
};
lime_media_openal_AL.getSourcefv = function(source,param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getSourcei = function(source,param) {
	return 0;
};
lime_media_openal_AL.getSourceiv = function(source,param,count) {
	if(count == null) {
		count = 1;
	}
	return null;
};
lime_media_openal_AL.getString = function(param) {
	return null;
};
lime_media_openal_AL.isBuffer = function(buffer) {
	return false;
};
lime_media_openal_AL.isEnabled = function(capability) {
	return false;
};
lime_media_openal_AL.isExtensionPresent = function(extname) {
	return false;
};
lime_media_openal_AL.isAux = function(aux) {
	return false;
};
lime_media_openal_AL.isEffect = function(effect) {
	return false;
};
lime_media_openal_AL.isFilter = function(filter) {
	return false;
};
lime_media_openal_AL.isSource = function(source) {
	return false;
};
lime_media_openal_AL.listener3f = function(param,value1,value2,value3) {
};
lime_media_openal_AL.listener3i = function(param,value1,value2,value3) {
};
lime_media_openal_AL.listenerf = function(param,value) {
};
lime_media_openal_AL.listenerfv = function(param,values) {
};
lime_media_openal_AL.listeneri = function(param,value) {
};
lime_media_openal_AL.listeneriv = function(param,values) {
};
lime_media_openal_AL.source3f = function(source,param,value1,value2,value3) {
};
lime_media_openal_AL.source3i = function(source,param,value1,value2,value3) {
};
lime_media_openal_AL.sourcef = function(source,param,value) {
};
lime_media_openal_AL.sourcefv = function(source,param,values) {
};
lime_media_openal_AL.sourcei = function(source,param,value) {
};
lime_media_openal_AL.filteri = function(filter,param,value) {
};
lime_media_openal_AL.filterf = function(filter,param,value) {
};
lime_media_openal_AL.sourceiv = function(source,param,values) {
};
lime_media_openal_AL.sourcePlay = function(source) {
};
lime_media_openal_AL.sourcePlayv = function(sources) {
};
lime_media_openal_AL.sourceStop = function(source) {
};
lime_media_openal_AL.sourceStopv = function(sources) {
};
lime_media_openal_AL.sourceRewind = function(source) {
};
lime_media_openal_AL.sourceRewindv = function(sources) {
};
lime_media_openal_AL.sourcePause = function(source) {
};
lime_media_openal_AL.sourcePausev = function(sources) {
};
lime_media_openal_AL.sourceQueueBuffer = function(source,buffer) {
};
lime_media_openal_AL.sourceQueueBuffers = function(source,nb,buffers) {
};
lime_media_openal_AL.sourceUnqueueBuffer = function(source) {
	return 0;
};
lime_media_openal_AL.sourceUnqueueBuffers = function(source,nb) {
	return null;
};
lime_media_openal_AL.speedOfSound = function(value) {
};
var lime_media_openal_ALAuxiliaryEffectSlot = {};
lime_media_openal_ALAuxiliaryEffectSlot._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal_ALBuffer = {};
lime_media_openal_ALBuffer._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal_ALC = function() { };
$hxClasses["lime.media.openal.ALC"] = lime_media_openal_ALC;
lime_media_openal_ALC.__name__ = "lime.media.openal.ALC";
lime_media_openal_ALC.closeDevice = function(device) {
	return false;
};
lime_media_openal_ALC.createContext = function(device,attrlist) {
	return null;
};
lime_media_openal_ALC.destroyContext = function(context) {
};
lime_media_openal_ALC.getContextsDevice = function(context) {
	return null;
};
lime_media_openal_ALC.getCurrentContext = function() {
	return null;
};
lime_media_openal_ALC.getError = function(device) {
	return 0;
};
lime_media_openal_ALC.getErrorString = function(device) {
	switch(lime_media_openal_ALC.getError(device)) {
	case 40961:
		return "INVALID_DEVICE: Invalid device (or no device?)";
	case 40962:
		return "INVALID_CONTEXT: Invalid context (or no context?)";
	case 40963:
		return "INVALID_ENUM: Invalid enum value";
	case 40964:
		return "INVALID_VALUE: Invalid param value";
	case 40965:
		return "OUT_OF_MEMORY: OpenAL has run out of memory";
	default:
		return "";
	}
};
lime_media_openal_ALC.getIntegerv = function(device,param,size) {
	return null;
};
lime_media_openal_ALC.getString = function(device,param) {
	return null;
};
lime_media_openal_ALC.makeContextCurrent = function(context) {
	return false;
};
lime_media_openal_ALC.openDevice = function(deviceName) {
	return null;
};
lime_media_openal_ALC.pauseDevice = function(device) {
};
lime_media_openal_ALC.processContext = function(context) {
};
lime_media_openal_ALC.resumeDevice = function(device) {
};
lime_media_openal_ALC.suspendContext = function(context) {
};
var lime_media_openal_ALContext = {};
lime_media_openal_ALContext._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal_ALDevice = {};
lime_media_openal_ALDevice._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal_ALEffect = {};
lime_media_openal_ALEffect._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal_ALFilter = {};
lime_media_openal_ALFilter._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_openal_ALSource = {};
lime_media_openal_ALSource._new = function(handle) {
	var this1 = handle;
	return this1;
};
var lime_media_vorbis_VorbisComment = function() {
};
$hxClasses["lime.media.vorbis.VorbisComment"] = lime_media_vorbis_VorbisComment;
lime_media_vorbis_VorbisComment.__name__ = "lime.media.vorbis.VorbisComment";
lime_media_vorbis_VorbisComment.prototype = {
	__class__: lime_media_vorbis_VorbisComment
};
var lime_media_vorbis_VorbisFile = function(handle) {
	this.handle = handle;
};
$hxClasses["lime.media.vorbis.VorbisFile"] = lime_media_vorbis_VorbisFile;
lime_media_vorbis_VorbisFile.__name__ = "lime.media.vorbis.VorbisFile";
lime_media_vorbis_VorbisFile.fromBytes = function(bytes) {
	return null;
};
lime_media_vorbis_VorbisFile.fromFile = function(path) {
	return null;
};
lime_media_vorbis_VorbisFile.prototype = {
	bitrate: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		return 0;
	}
	,bitrateInstant: function() {
		return 0;
	}
	,clear: function() {
	}
	,comment: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		return null;
	}
	,crosslap: function(other) {
		return 0;
	}
	,info: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		return null;
	}
	,pcmSeek: function(pos) {
		return 0;
	}
	,pcmSeekLap: function(pos) {
		return 0;
	}
	,pcmSeekPage: function(pos) {
		return 0;
	}
	,pcmSeekPageLap: function(pos) {
		return 0;
	}
	,pcmTell: function() {
		var this1 = new haxe__$Int64__$_$_$Int64(0,0);
		return this1;
	}
	,pcmTotal: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		var this1 = new haxe__$Int64__$_$_$Int64(0,0);
		return this1;
	}
	,rawSeek: function(pos) {
		return 0;
	}
	,rawSeekLap: function(pos) {
		return 0;
	}
	,rawTell: function() {
		var this1 = new haxe__$Int64__$_$_$Int64(0,0);
		return this1;
	}
	,rawTotal: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		var this1 = new haxe__$Int64__$_$_$Int64(0,0);
		return this1;
	}
	,read: function(buffer,position,length,bigEndianPacking,wordSize,signed) {
		if(signed == null) {
			signed = true;
		}
		if(wordSize == null) {
			wordSize = 2;
		}
		if(bigEndianPacking == null) {
			bigEndianPacking = false;
		}
		if(length == null) {
			length = 4096;
		}
		return 0;
	}
	,readFloat: function(pcmChannels,samples) {
		return 0;
	}
	,seekable: function() {
		return false;
	}
	,serialNumber: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		return 0;
	}
	,streams: function() {
		return 0;
	}
	,timeSeek: function(s) {
		return 0;
	}
	,timeSeekLap: function(s) {
		return 0;
	}
	,timeSeekPage: function(s) {
		return 0;
	}
	,timeSeekPageLap: function(s) {
		return 0;
	}
	,timeTell: function() {
		return 0;
	}
	,timeTotal: function(bitstream) {
		if(bitstream == null) {
			bitstream = -1;
		}
		return 0;
	}
	,__class__: lime_media_vorbis_VorbisFile
};
var lime_media_vorbis_VorbisInfo = function() {
};
$hxClasses["lime.media.vorbis.VorbisInfo"] = lime_media_vorbis_VorbisInfo;
lime_media_vorbis_VorbisInfo.__name__ = "lime.media.vorbis.VorbisInfo";
lime_media_vorbis_VorbisInfo.prototype = {
	__class__: lime_media_vorbis_VorbisInfo
};
var lime_net__$IHTTPRequest = function() { };
$hxClasses["lime.net._IHTTPRequest"] = lime_net__$IHTTPRequest;
lime_net__$IHTTPRequest.__name__ = "lime.net._IHTTPRequest";
lime_net__$IHTTPRequest.__isInterface__ = true;
lime_net__$IHTTPRequest.prototype = {
	__class__: lime_net__$IHTTPRequest
};
var lime_net__$HTTPRequest_AbstractHTTPRequest = function(uri) {
	this.uri = uri;
	this.contentType = "application/x-www-form-urlencoded";
	this.followRedirects = true;
	this.enableResponseHeaders = false;
	this.formData = new haxe_ds_StringMap();
	this.headers = [];
	this.method = "GET";
	this.timeout = 30000;
	this.withCredentials = false;
	this.__backend = new lime__$internal_backend_html5_HTML5HTTPRequest();
	this.__backend.init(this);
};
$hxClasses["lime.net._HTTPRequest.AbstractHTTPRequest"] = lime_net__$HTTPRequest_AbstractHTTPRequest;
lime_net__$HTTPRequest_AbstractHTTPRequest.__name__ = "lime.net._HTTPRequest.AbstractHTTPRequest";
lime_net__$HTTPRequest_AbstractHTTPRequest.__interfaces__ = [lime_net__$IHTTPRequest];
lime_net__$HTTPRequest_AbstractHTTPRequest.prototype = {
	cancel: function() {
		this.__backend.cancel();
	}
	,load: function(uri) {
		return null;
	}
	,__class__: lime_net__$HTTPRequest_AbstractHTTPRequest
};
var lime_net_HTTPRequest = function(uri) {
	lime_net__$HTTPRequest_AbstractHTTPRequest.call(this,uri);
};
$hxClasses["lime.net.HTTPRequest"] = lime_net_HTTPRequest;
lime_net_HTTPRequest.__name__ = "lime.net.HTTPRequest";
lime_net_HTTPRequest.__super__ = lime_net__$HTTPRequest_AbstractHTTPRequest;
lime_net_HTTPRequest.prototype = $extend(lime_net__$HTTPRequest_AbstractHTTPRequest.prototype,{
	__class__: lime_net_HTTPRequest
});
var lime_net__$HTTPRequest_$Bytes = function(uri) {
	lime_net__$HTTPRequest_AbstractHTTPRequest.call(this,uri);
};
$hxClasses["lime.net._HTTPRequest_Bytes"] = lime_net__$HTTPRequest_$Bytes;
lime_net__$HTTPRequest_$Bytes.__name__ = "lime.net._HTTPRequest_Bytes";
lime_net__$HTTPRequest_$Bytes.__super__ = lime_net__$HTTPRequest_AbstractHTTPRequest;
lime_net__$HTTPRequest_$Bytes.prototype = $extend(lime_net__$HTTPRequest_AbstractHTTPRequest.prototype,{
	fromBytes: function(bytes) {
		return bytes;
	}
	,load: function(uri) {
		var _gthis = this;
		if(uri != null) {
			this.uri = uri;
		}
		var promise = new lime_app_Promise();
		var future = this.__backend.loadData(this.uri);
		future.onProgress($bind(promise,promise.progress));
		future.onError($bind(promise,promise.error));
		future.onComplete(function(bytes) {
			_gthis.responseData = _gthis.fromBytes(bytes);
			promise.complete(_gthis.responseData);
		});
		return promise.future;
	}
	,__class__: lime_net__$HTTPRequest_$Bytes
});
var lime_net__$HTTPRequest_$String = function(uri) {
	lime_net__$HTTPRequest_AbstractHTTPRequest.call(this,uri);
};
$hxClasses["lime.net._HTTPRequest_String"] = lime_net__$HTTPRequest_$String;
lime_net__$HTTPRequest_$String.__name__ = "lime.net._HTTPRequest_String";
lime_net__$HTTPRequest_$String.__super__ = lime_net__$HTTPRequest_AbstractHTTPRequest;
lime_net__$HTTPRequest_$String.prototype = $extend(lime_net__$HTTPRequest_AbstractHTTPRequest.prototype,{
	load: function(uri) {
		var _gthis = this;
		if(uri != null) {
			this.uri = uri;
		}
		var promise = new lime_app_Promise();
		var future = this.__backend.loadText(this.uri);
		future.onProgress($bind(promise,promise.progress));
		future.onError($bind(promise,promise.error));
		future.onComplete(function(text) {
			_gthis.responseData = text;
			promise.complete(_gthis.responseData);
		});
		return promise.future;
	}
	,__class__: lime_net__$HTTPRequest_$String
});
var lime_net_HTTPRequestHeader = function(name,value) {
	if(value == null) {
		value = "";
	}
	this.name = name;
	this.value = value;
};
$hxClasses["lime.net.HTTPRequestHeader"] = lime_net_HTTPRequestHeader;
lime_net_HTTPRequestHeader.__name__ = "lime.net.HTTPRequestHeader";
lime_net_HTTPRequestHeader.prototype = {
	__class__: lime_net_HTTPRequestHeader
};
var lime_net__$HTTPRequest_$lime_$text_$Font = function(uri) {
	lime_net__$HTTPRequest_$Bytes.call(this,uri);
};
$hxClasses["lime.net._HTTPRequest_lime_text_Font"] = lime_net__$HTTPRequest_$lime_$text_$Font;
lime_net__$HTTPRequest_$lime_$text_$Font.__name__ = "lime.net._HTTPRequest_lime_text_Font";
lime_net__$HTTPRequest_$lime_$text_$Font.__super__ = lime_net__$HTTPRequest_$Bytes;
lime_net__$HTTPRequest_$lime_$text_$Font.prototype = $extend(lime_net__$HTTPRequest_$Bytes.prototype,{
	fromBytes: function(bytes) {
		return lime_text_Font.fromBytes(bytes);
	}
	,__class__: lime_net__$HTTPRequest_$lime_$text_$Font
});
var lime_net__$HTTPRequest_$lime_$utils_$Bytes = function(uri) {
	lime_net__$HTTPRequest_$Bytes.call(this,uri);
};
$hxClasses["lime.net._HTTPRequest_lime_utils_Bytes"] = lime_net__$HTTPRequest_$lime_$utils_$Bytes;
lime_net__$HTTPRequest_$lime_$utils_$Bytes.__name__ = "lime.net._HTTPRequest_lime_utils_Bytes";
lime_net__$HTTPRequest_$lime_$utils_$Bytes.__super__ = lime_net__$HTTPRequest_$Bytes;
lime_net__$HTTPRequest_$lime_$utils_$Bytes.prototype = $extend(lime_net__$HTTPRequest_$Bytes.prototype,{
	fromBytes: function(bytes) {
		return lime_utils_Bytes.fromBytes(bytes);
	}
	,__class__: lime_net__$HTTPRequest_$lime_$utils_$Bytes
});
var lime_net__$HTTPRequest_$openfl_$utils_$ByteArray = function(uri) {
	lime_net__$HTTPRequest_$Bytes.call(this,uri);
};
$hxClasses["lime.net._HTTPRequest_openfl_utils_ByteArray"] = lime_net__$HTTPRequest_$openfl_$utils_$ByteArray;
lime_net__$HTTPRequest_$openfl_$utils_$ByteArray.__name__ = "lime.net._HTTPRequest_openfl_utils_ByteArray";
lime_net__$HTTPRequest_$openfl_$utils_$ByteArray.__super__ = lime_net__$HTTPRequest_$Bytes;
lime_net__$HTTPRequest_$openfl_$utils_$ByteArray.prototype = $extend(lime_net__$HTTPRequest_$Bytes.prototype,{
	fromBytes: function(bytes) {
		return openfl_utils_ByteArray.fromBytes(bytes);
	}
	,__class__: lime_net__$HTTPRequest_$openfl_$utils_$ByteArray
});
var lime_system_CFFI = function() { };
$hxClasses["lime.system.CFFI"] = lime_system_CFFI;
lime_system_CFFI.__name__ = "lime.system.CFFI";
lime_system_CFFI.load = function(library,method,args,lazy) {
	if(lazy == null) {
		lazy = false;
	}
	if(args == null) {
		args = 0;
	}
	if(!lime_system_CFFI.enabled) {
		return Reflect.makeVarArgs(function(__) {
			return { };
		});
	}
	var result = null;
	return result;
};
lime_system_CFFI.__findHaxelib = function(library) {
	return "";
};
lime_system_CFFI.__loaderTrace = function(message) {
};
lime_system_CFFI.__sysName = function() {
	return null;
};
lime_system_CFFI.__tryLoad = function(name,library,func,args) {
	return null;
};
var lime_system_CFFIPointer = {};
lime_system_CFFIPointer._new = function(handle) {
	var this1 = handle;
	return this1;
};
lime_system_CFFIPointer.get = function(this1) {
	var tmp = this1 != null;
	return 0;
};
lime_system_CFFIPointer.equals = function(a,b) {
	return lime_system_CFFIPointer.get(a) == b;
};
lime_system_CFFIPointer.equalsPointer = function(a,b) {
	return lime_system_CFFIPointer.get(a) == lime_system_CFFIPointer.get(b);
};
lime_system_CFFIPointer.greaterThan = function(a,b) {
	return lime_system_CFFIPointer.get(a) > b;
};
lime_system_CFFIPointer.greaterThanPointer = function(a,b) {
	return lime_system_CFFIPointer.get(a) > lime_system_CFFIPointer.get(b);
};
lime_system_CFFIPointer.greaterThanOrEqual = function(a,b) {
	return lime_system_CFFIPointer.get(a) >= b;
};
lime_system_CFFIPointer.greaterThanOrEqualPointer = function(a,b) {
	return lime_system_CFFIPointer.get(a) >= lime_system_CFFIPointer.get(b);
};
lime_system_CFFIPointer.lessThan = function(a,b) {
	return lime_system_CFFIPointer.get(a) < b;
};
lime_system_CFFIPointer.lessThanPointer = function(a,b) {
	return lime_system_CFFIPointer.get(a) < lime_system_CFFIPointer.get(b);
};
lime_system_CFFIPointer.lessThanOrEqual = function(a,b) {
	return lime_system_CFFIPointer.get(a) <= b;
};
lime_system_CFFIPointer.lessThanOrEqualPointer = function(a,b) {
	return lime_system_CFFIPointer.get(a) <= lime_system_CFFIPointer.get(b);
};
lime_system_CFFIPointer.notEquals = function(a,b) {
	return lime_system_CFFIPointer.get(a) != b;
};
lime_system_CFFIPointer.notEqualsPointer = function(a,b) {
	return lime_system_CFFIPointer.get(a) != lime_system_CFFIPointer.get(b);
};
var lime_system_Clipboard = function() { };
$hxClasses["lime.system.Clipboard"] = lime_system_Clipboard;
lime_system_Clipboard.__name__ = "lime.system.Clipboard";
lime_system_Clipboard.__properties__ = {set_text:"set_text",get_text:"get_text"};
lime_system_Clipboard.__update = function() {
	var cacheText = lime_system_Clipboard._text;
	lime_system_Clipboard._text = null;
	if(lime_system_Clipboard._text != cacheText) {
		lime_system_Clipboard.onUpdate.dispatch();
	}
};
lime_system_Clipboard.get_text = function() {
	lime_system_Clipboard.__update();
	return lime_system_Clipboard._text;
};
lime_system_Clipboard.set_text = function(value) {
	var cacheText = lime_system_Clipboard._text;
	lime_system_Clipboard._text = value;
	var $window = lime_app_Application.current.__window;
	if($window != null) {
		$window.__backend.setClipboard(value);
	}
	if(lime_system_Clipboard._text != cacheText) {
		lime_system_Clipboard.onUpdate.dispatch();
	}
	return value;
};
var lime_system_Display = function() {
};
$hxClasses["lime.system.Display"] = lime_system_Display;
lime_system_Display.__name__ = "lime.system.Display";
lime_system_Display.prototype = {
	__class__: lime_system_Display
};
var lime_system_DisplayMode = function(width,height,refreshRate,pixelFormat) {
	this.width = width;
	this.height = height;
	this.refreshRate = refreshRate;
	this.pixelFormat = pixelFormat;
};
$hxClasses["lime.system.DisplayMode"] = lime_system_DisplayMode;
lime_system_DisplayMode.__name__ = "lime.system.DisplayMode";
lime_system_DisplayMode.prototype = {
	__class__: lime_system_DisplayMode
};
var lime_system_Endian = $hxEnums["lime.system.Endian"] = { __ename__ : "lime.system.Endian", __constructs__ : ["LITTLE_ENDIAN","BIG_ENDIAN"]
	,LITTLE_ENDIAN: {_hx_index:0,__enum__:"lime.system.Endian",toString:$estr}
	,BIG_ENDIAN: {_hx_index:1,__enum__:"lime.system.Endian",toString:$estr}
};
var lime_system_Sensor = function(type,id) {
	this.onUpdate = new lime_app__$Event_$Float_$Float_$Float_$Void();
	this.type = type;
	this.id = id;
};
$hxClasses["lime.system.Sensor"] = lime_system_Sensor;
lime_system_Sensor.__name__ = "lime.system.Sensor";
lime_system_Sensor.getSensors = function(type) {
	if(type == null) {
		return lime_system_Sensor.sensors.slice();
	} else {
		var result = [];
		var _g = 0;
		var _g1 = lime_system_Sensor.sensors;
		while(_g < _g1.length) {
			var sensor = _g1[_g];
			++_g;
			if(sensor.type == type) {
				result.push(sensor);
			}
		}
		return result;
	}
};
lime_system_Sensor.registerSensor = function(type,id) {
	var sensor = new lime_system_Sensor(type,id);
	lime_system_Sensor.sensors.push(sensor);
	lime_system_Sensor.sensorByID.h[id] = sensor;
	return sensor;
};
lime_system_Sensor.prototype = {
	__class__: lime_system_Sensor
};
var lime_system_SensorType = $hxEnums["lime.system.SensorType"] = { __ename__ : "lime.system.SensorType", __constructs__ : ["ACCELEROMETER"]
	,ACCELEROMETER: {_hx_index:0,__enum__:"lime.system.SensorType",toString:$estr}
};
var lime_system_System = function() { };
$hxClasses["lime.system.System"] = lime_system_System;
lime_system_System.__name__ = "lime.system.System";
lime_system_System.__properties__ = {get_userDirectory:"get_userDirectory",get_platformVersion:"get_platformVersion",get_platformName:"get_platformName",get_platformLabel:"get_platformLabel",get_numDisplays:"get_numDisplays",get_fontsDirectory:"get_fontsDirectory",get_endianness:"get_endianness",get_documentsDirectory:"get_documentsDirectory",get_deviceVendor:"get_deviceVendor",get_deviceModel:"get_deviceModel",get_desktopDirectory:"get_desktopDirectory",get_applicationStorageDirectory:"get_applicationStorageDirectory",get_applicationDirectory:"get_applicationDirectory",set_allowScreenTimeout:"set_allowScreenTimeout",get_allowScreenTimeout:"get_allowScreenTimeout"};
lime_system_System.embed = $hx_exports["lime"]["embed"] = function(projectName,element,width,height,config) {
	if(lime_system_System.__applicationEntryPoint == null) {
		return;
	}
	if(Object.prototype.hasOwnProperty.call(lime_system_System.__applicationEntryPoint.h,projectName)) {
		var htmlElement = null;
		if(typeof(element) == "string") {
			htmlElement = window.document.getElementById(element);
		} else if(element == null) {
			htmlElement = window.document.createElement("div");
		} else {
			htmlElement = element;
		}
		if(htmlElement == null) {
			window.console.log("[lime.embed] ERROR: Cannot find target element: " + Std.string(element));
			return;
		}
		if(width == null) {
			width = 0;
		}
		if(height == null) {
			height = 0;
		}
		if(config == null) {
			config = { };
		}
		if(Object.prototype.hasOwnProperty.call(config,"background") && typeof(config.background) == "string") {
			var background = StringTools.replace(Std.string(config.background),"#","");
			if(background.indexOf("0x") > -1) {
				config.background = Std.parseInt(background);
			} else {
				config.background = Std.parseInt("0x" + background);
			}
		}
		config.element = htmlElement;
		config.width = width;
		config.height = height;
		lime_system_System.__applicationEntryPoint.h[projectName](config);
	}
};
lime_system_System.exit = function(code) {
};
lime_system_System.getDisplay = function(id) {
	if(id == 0) {
		var display = new lime_system_Display();
		display.id = 0;
		display.name = "Generic Display";
		display.dpi = 96 * window.devicePixelRatio;
		display.currentMode = new lime_system_DisplayMode(window.screen.width,window.screen.height,60,1);
		display.supportedModes = [display.currentMode];
		display.bounds = new lime_math_Rectangle(0,0,display.currentMode.width,display.currentMode.height);
		return display;
	}
	return null;
};
lime_system_System.getTimer = function() {
	return window.performance.now() | 0;
};
lime_system_System.load = function(library,method,args,lazy) {
	if(lazy == null) {
		lazy = false;
	}
	if(args == null) {
		args = 0;
	}
	return lime_system_CFFI.load(library,method,args,lazy);
};
lime_system_System.openFile = function(path) {
	if(path != null) {
		window.open(path,"_blank");
	}
};
lime_system_System.openURL = function(url,target) {
	if(target == null) {
		target = "_blank";
	}
	if(url != null) {
		window.open(url,target);
	}
};
lime_system_System.__copyMissingFields = function(target,source) {
	if(source == null || target == null) {
		return;
	}
	var _g = 0;
	var _g1 = Reflect.fields(source);
	while(_g < _g1.length) {
		var field = _g1[_g];
		++_g;
		if(!Object.prototype.hasOwnProperty.call(target,field)) {
			target[field] = Reflect.field(source,field);
		}
	}
};
lime_system_System.__getDirectory = function(type) {
	return null;
};
lime_system_System.__parseBool = function(value) {
	return value == "true";
};
lime_system_System.__registerEntryPoint = function(projectName,entryPoint) {
	if(lime_system_System.__applicationEntryPoint == null) {
		lime_system_System.__applicationEntryPoint = new haxe_ds_StringMap();
	}
	lime_system_System.__applicationEntryPoint.h[projectName] = entryPoint;
};
lime_system_System.__runProcess = function(command,args) {
	return null;
};
lime_system_System.get_allowScreenTimeout = function() {
	return true;
};
lime_system_System.set_allowScreenTimeout = function(value) {
	return true;
};
lime_system_System.get_applicationDirectory = function() {
	if(lime_system_System.__applicationDirectory == null) {
		lime_system_System.__applicationDirectory = lime_system_System.__getDirectory(0);
	}
	return lime_system_System.__applicationDirectory;
};
lime_system_System.get_applicationStorageDirectory = function() {
	if(lime_system_System.__applicationStorageDirectory == null) {
		lime_system_System.__applicationStorageDirectory = lime_system_System.__getDirectory(1);
	}
	return lime_system_System.__applicationStorageDirectory;
};
lime_system_System.get_deviceModel = function() {
	var tmp = lime_system_System.__deviceModel == null;
	return lime_system_System.__deviceModel;
};
lime_system_System.get_deviceVendor = function() {
	var tmp = lime_system_System.__deviceVendor == null;
	return lime_system_System.__deviceVendor;
};
lime_system_System.get_desktopDirectory = function() {
	if(lime_system_System.__desktopDirectory == null) {
		lime_system_System.__desktopDirectory = lime_system_System.__getDirectory(2);
	}
	return lime_system_System.__desktopDirectory;
};
lime_system_System.get_documentsDirectory = function() {
	if(lime_system_System.__documentsDirectory == null) {
		lime_system_System.__documentsDirectory = lime_system_System.__getDirectory(3);
	}
	return lime_system_System.__documentsDirectory;
};
lime_system_System.get_endianness = function() {
	if(lime_system_System.__endianness == null) {
		var arrayBuffer = new ArrayBuffer(2);
		var elements = null;
		var array = null;
		var vector = null;
		var view = null;
		var len = null;
		var this1;
		if(elements != null) {
			this1 = new Uint8Array(elements);
		} else if(array != null) {
			this1 = new Uint8Array(array);
		} else if(vector != null) {
			this1 = new Uint8Array(vector.__array);
		} else if(view != null) {
			this1 = new Uint8Array(view);
		} else if(arrayBuffer != null) {
			if(len == null) {
				this1 = new Uint8Array(arrayBuffer,0);
			} else {
				this1 = new Uint8Array(arrayBuffer,0,len);
			}
		} else {
			this1 = null;
		}
		var uint8Array = this1;
		var elements = null;
		var array = null;
		var vector = null;
		var view = null;
		var len = null;
		var this1;
		if(elements != null) {
			this1 = new Uint16Array(elements);
		} else if(array != null) {
			this1 = new Uint16Array(array);
		} else if(vector != null) {
			this1 = new Uint16Array(vector.__array);
		} else if(view != null) {
			this1 = new Uint16Array(view);
		} else if(arrayBuffer != null) {
			if(len == null) {
				this1 = new Uint16Array(arrayBuffer,0);
			} else {
				this1 = new Uint16Array(arrayBuffer,0,len);
			}
		} else {
			this1 = null;
		}
		var uint16array = this1;
		uint8Array[0] = 170;
		uint8Array[1] = 187;
		if(uint16array[0] == 43707) {
			lime_system_System.__endianness = lime_system_Endian.BIG_ENDIAN;
		} else {
			lime_system_System.__endianness = lime_system_Endian.LITTLE_ENDIAN;
		}
	}
	return lime_system_System.__endianness;
};
lime_system_System.get_fontsDirectory = function() {
	if(lime_system_System.__fontsDirectory == null) {
		lime_system_System.__fontsDirectory = lime_system_System.__getDirectory(4);
	}
	return lime_system_System.__fontsDirectory;
};
lime_system_System.get_numDisplays = function() {
	return 1;
};
lime_system_System.get_platformLabel = function() {
	if(lime_system_System.__platformLabel == null) {
		var name = lime_system_System.get_platformName();
		var version = lime_system_System.get_platformVersion();
		if(name != null && version != null) {
			lime_system_System.__platformLabel = name + " " + version;
		} else if(name != null) {
			lime_system_System.__platformLabel = name;
		}
	}
	return lime_system_System.__platformLabel;
};
lime_system_System.get_platformName = function() {
	if(lime_system_System.__platformName == null) {
		lime_system_System.__platformName = "HTML5";
	}
	return lime_system_System.__platformName;
};
lime_system_System.get_platformVersion = function() {
	var tmp = lime_system_System.__platformVersion == null;
	return lime_system_System.__platformVersion;
};
lime_system_System.get_userDirectory = function() {
	if(lime_system_System.__userDirectory == null) {
		lime_system_System.__userDirectory = lime_system_System.__getDirectory(5);
	}
	return lime_system_System.__userDirectory;
};
var lime_system_ThreadPool = function(minThreads,maxThreads) {
	if(maxThreads == null) {
		maxThreads = 1;
	}
	if(minThreads == null) {
		minThreads = 0;
	}
	this.onRun = new lime_app__$Event_$Dynamic_$Void();
	this.onProgress = new lime_app__$Event_$Dynamic_$Void();
	this.onError = new lime_app__$Event_$Dynamic_$Void();
	this.onComplete = new lime_app__$Event_$Dynamic_$Void();
	this.doWork = new lime_app__$Event_$Dynamic_$Void();
	this.minThreads = minThreads;
	this.maxThreads = maxThreads;
	this.currentThreads = 0;
};
$hxClasses["lime.system.ThreadPool"] = lime_system_ThreadPool;
lime_system_ThreadPool.__name__ = "lime.system.ThreadPool";
lime_system_ThreadPool.prototype = {
	queue: function(state) {
		this.runWork(state);
	}
	,sendComplete: function(state) {
		this.onComplete.dispatch(state);
	}
	,sendError: function(state) {
		this.onError.dispatch(state);
	}
	,sendProgress: function(state) {
		this.onProgress.dispatch(state);
	}
	,runWork: function(state) {
		this.onRun.dispatch(state);
		this.doWork.dispatch(state);
	}
	,__class__: lime_system_ThreadPool
};
var lime_system__$ThreadPool_ThreadPoolMessageType = $hxEnums["lime.system._ThreadPool.ThreadPoolMessageType"] = { __ename__ : "lime.system._ThreadPool.ThreadPoolMessageType", __constructs__ : ["COMPLETE","ERROR","EXIT","PROGRESS","WORK"]
	,COMPLETE: {_hx_index:0,__enum__:"lime.system._ThreadPool.ThreadPoolMessageType",toString:$estr}
	,ERROR: {_hx_index:1,__enum__:"lime.system._ThreadPool.ThreadPoolMessageType",toString:$estr}
	,EXIT: {_hx_index:2,__enum__:"lime.system._ThreadPool.ThreadPoolMessageType",toString:$estr}
	,PROGRESS: {_hx_index:3,__enum__:"lime.system._ThreadPool.ThreadPoolMessageType",toString:$estr}
	,WORK: {_hx_index:4,__enum__:"lime.system._ThreadPool.ThreadPoolMessageType",toString:$estr}
};
var lime_system__$ThreadPool_ThreadPoolMessage = function(type,state) {
	this.type = type;
	this.state = state;
};
$hxClasses["lime.system._ThreadPool.ThreadPoolMessage"] = lime_system__$ThreadPool_ThreadPoolMessage;
lime_system__$ThreadPool_ThreadPoolMessage.__name__ = "lime.system._ThreadPool.ThreadPoolMessage";
lime_system__$ThreadPool_ThreadPoolMessage.prototype = {
	__class__: lime_system__$ThreadPool_ThreadPoolMessage
};
var lime_text_Font = function(name) {
	if(name != null) {
		this.name = name;
	}
	if(!this.__init) {
		if(this.ascender == undefined) {
			this.ascender = 0;
		}
		if(this.descender == undefined) {
			this.descender = 0;
		}
		if(this.height == undefined) {
			this.height = 0;
		}
		if(this.numGlyphs == undefined) {
			this.numGlyphs = 0;
		}
		if(this.underlinePosition == undefined) {
			this.underlinePosition = 0;
		}
		if(this.underlineThickness == undefined) {
			this.underlineThickness = 0;
		}
		if(this.unitsPerEM == undefined) {
			this.unitsPerEM = 0;
		}
		if(this.__fontID != null) {
			if(lime_utils_Assets.isLocal(this.__fontID)) {
				this.__fromBytes(lime_utils_Assets.getBytes(this.__fontID));
			}
		} else if(this.__fontPath != null) {
			this.__fromFile(this.__fontPath);
		}
	}
};
$hxClasses["lime.text.Font"] = lime_text_Font;
lime_text_Font.__name__ = "lime.text.Font";
lime_text_Font.fromBytes = function(bytes) {
	if(bytes == null) {
		return null;
	}
	var font = new lime_text_Font();
	font.__fromBytes(bytes);
	return font;
};
lime_text_Font.fromFile = function(path) {
	if(path == null) {
		return null;
	}
	var font = new lime_text_Font();
	font.__fromFile(path);
	return font;
};
lime_text_Font.loadFromBytes = function(bytes) {
	return lime_app_Future.withValue(lime_text_Font.fromBytes(bytes));
};
lime_text_Font.loadFromFile = function(path) {
	var request = new lime_net__$HTTPRequest_$lime_$text_$Font();
	return request.load(path).then(function(font) {
		if(font != null) {
			return lime_app_Future.withValue(font);
		} else {
			return lime_app_Future.withError("");
		}
	});
};
lime_text_Font.loadFromName = function(path) {
	var font = new lime_text_Font();
	return font.__loadFromName(path);
};
lime_text_Font.__measureFontNode = function(fontFamily) {
	var node = window.document.createElement("span");
	node.setAttribute("aria-hidden","true");
	var text = window.document.createTextNode("BESbswy");
	node.appendChild(text);
	var style = node.style;
	style.display = "block";
	style.position = "absolute";
	style.top = "-9999px";
	style.left = "-9999px";
	style.fontSize = "300px";
	style.width = "auto";
	style.height = "auto";
	style.lineHeight = "normal";
	style.margin = "0";
	style.padding = "0";
	style.fontVariant = "normal";
	style.whiteSpace = "nowrap";
	style.fontFamily = fontFamily;
	window.document.body.appendChild(node);
	return node;
};
lime_text_Font.prototype = {
	decompose: function() {
		return null;
	}
	,getGlyph: function(character) {
		return -1;
	}
	,getGlyphs: function(characters) {
		if(characters == null) {
			characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^`'\"/\\&*()[]{}<>|:;_-+=?,. ";
		}
		return null;
	}
	,getGlyphMetrics: function(glyph) {
		return null;
	}
	,renderGlyph: function(glyph,fontSize) {
		return null;
	}
	,renderGlyphs: function(glyphs,fontSize) {
		return null;
	}
	,__copyFrom: function(other) {
		if(other != null) {
			this.ascender = other.ascender;
			this.descender = other.descender;
			this.height = other.height;
			this.name = other.name;
			this.numGlyphs = other.numGlyphs;
			this.src = other.src;
			this.underlinePosition = other.underlinePosition;
			this.underlineThickness = other.underlineThickness;
			this.unitsPerEM = other.unitsPerEM;
			this.__fontID = other.__fontID;
			this.__fontPath = other.__fontPath;
			this.__init = true;
		}
	}
	,__fromBytes: function(bytes) {
		this.__fontPath = null;
	}
	,__fromFile: function(path) {
		this.__fontPath = path;
	}
	,__initializeSource: function() {
		this.__init = true;
	}
	,__loadFromName: function(name) {
		var _gthis = this;
		var promise = new lime_app_Promise();
		this.name = name;
		var userAgent = $global.navigator.userAgent.toLowerCase();
		var isSafari = userAgent.indexOf(" safari/") >= 0 && userAgent.indexOf(" chrome/") < 0;
		var isUIWebView = new EReg("(iPhone|iPod|iPad).*AppleWebKit(?!.*Version)","i").match(userAgent);
		if(!isSafari && !isUIWebView && (window.document.fonts && ($_=window.document.fonts,$bind($_,$_.load)))) {
			window.document.fonts.load("1em '" + name + "'").then(function(_) {
				promise.complete(_gthis);
			},function(_) {
				lime_utils_Log.warn("Could not load web font \"" + name + "\"",{ fileName : "lime/text/Font.hx", lineNumber : 513, className : "lime.text.Font", methodName : "__loadFromName"});
				promise.complete(_gthis);
			});
		} else {
			var node1 = lime_text_Font.__measureFontNode("'" + name + "', sans-serif");
			var node2 = lime_text_Font.__measureFontNode("'" + name + "', serif");
			var width1 = node1.offsetWidth;
			var width2 = node2.offsetWidth;
			var interval = -1;
			var timeout = 3000;
			var intervalLength = 50;
			var intervalCount = 0;
			var loaded;
			var timeExpired;
			var checkFont = function() {
				intervalCount += 1;
				loaded = node1.offsetWidth != width1 || node2.offsetWidth != width2;
				timeExpired = intervalCount * intervalLength >= timeout;
				if(loaded || timeExpired) {
					window.clearInterval(interval);
					node1.parentNode.removeChild(node1);
					node2.parentNode.removeChild(node2);
					node1 = null;
					node2 = null;
					if(timeExpired) {
						lime_utils_Log.warn("Could not load web font \"" + name + "\"",{ fileName : "lime/text/Font.hx", lineNumber : 548, className : "lime.text.Font", methodName : "__loadFromName"});
					}
					promise.complete(_gthis);
				}
			};
			interval = window.setInterval(checkFont,intervalLength);
		}
		return promise.future;
	}
	,__setSize: function(size) {
	}
	,__class__: lime_text_Font
};
var lime_text_Glyph = {};
lime_text_Glyph._new = function(i) {
	var this1 = i;
	return this1;
};
var lime_text_GlyphMetrics = function() {
};
$hxClasses["lime.text.GlyphMetrics"] = lime_text_GlyphMetrics;
lime_text_GlyphMetrics.__name__ = "lime.text.GlyphMetrics";
lime_text_GlyphMetrics.prototype = {
	__class__: lime_text_GlyphMetrics
};
var lime_text_harfbuzz_HB = function() { };
$hxClasses["lime.text.harfbuzz.HB"] = lime_text_harfbuzz_HB;
lime_text_harfbuzz_HB.__name__ = "lime.text.harfbuzz.HB";
lime_text_harfbuzz_HB.shape = function(font,buffer,features) {
};
var lime_text_harfbuzz_HBBlob = {};
lime_text_harfbuzz_HBBlob.__properties__ = {get_length:"get_length",get_immutable:"get_immutable",get_dataWritable:"get_dataWritable",get_data:"get_data",get_empty:"get_empty"};
lime_text_harfbuzz_HBBlob._new = function(data,length,memoryMode) {
	var this1 = null;
	return this1;
};
lime_text_harfbuzz_HBBlob.createSubBlob = function(this1,offset,length) {
	return null;
};
lime_text_harfbuzz_HBBlob.makeImmutable = function(this1) {
};
lime_text_harfbuzz_HBBlob.get_data = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBBlob.get_dataWritable = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBBlob.get_empty = function() {
	return null;
};
lime_text_harfbuzz_HBBlob.get_immutable = function(this1) {
	return false;
};
lime_text_harfbuzz_HBBlob.get_length = function(this1) {
	return 0;
};
var lime_text_harfbuzz_HBBuffer = {};
lime_text_harfbuzz_HBBuffer.__properties__ = {set_segmentProperties:"set_segmentProperties",get_segmentProperties:"get_segmentProperties",set_script:"set_script",get_script:"get_script",set_replacementCodepoint:"set_replacementCodepoint",get_replacementCodepoint:"get_replacementCodepoint",set_length:"set_length",get_length:"get_length",set_language:"set_language",get_language:"get_language",set_flags:"set_flags",get_flags:"get_flags",set_direction:"set_direction",get_direction:"get_direction",set_contentType:"set_contentType",get_contentType:"get_contentType",set_clusterLevel:"set_clusterLevel",get_clusterLevel:"get_clusterLevel",get_allocationSuccessful:"get_allocationSuccessful"};
lime_text_harfbuzz_HBBuffer._new = function() {
	var this1 = null;
	return this1;
};
lime_text_harfbuzz_HBBuffer.add = function(this1,codepoint,cluster) {
};
lime_text_harfbuzz_HBBuffer.addCodepoints = function(this1,text,textLength,itemOffset,itemLength) {
};
lime_text_harfbuzz_HBBuffer.addUTF8 = function(this1,text,itemOffset,itemLength) {
};
lime_text_harfbuzz_HBBuffer.addUTF16 = function(this1,text,textLength,itemOffset,itemLength) {
};
lime_text_harfbuzz_HBBuffer.addUTF32 = function(this1,text,textLength,itemOffset,itemLength) {
};
lime_text_harfbuzz_HBBuffer.clearContents = function(this1) {
};
lime_text_harfbuzz_HBBuffer.getGlyphInfo = function(this1) {
	return null;
};
lime_text_harfbuzz_HBBuffer.getGlyphPositions = function(this1) {
	return null;
};
lime_text_harfbuzz_HBBuffer.guessSegmentProperties = function(this1) {
};
lime_text_harfbuzz_HBBuffer.normalizeGlyphs = function(this1) {
};
lime_text_harfbuzz_HBBuffer.preallocate = function(this1,size) {
	return false;
};
lime_text_harfbuzz_HBBuffer.reset = function(this1) {
};
lime_text_harfbuzz_HBBuffer.reverse = function(this1) {
};
lime_text_harfbuzz_HBBuffer.reverseClusters = function(this1) {
};
lime_text_harfbuzz_HBBuffer.get_allocationSuccessful = function(this1) {
	return false;
};
lime_text_harfbuzz_HBBuffer.get_clusterLevel = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBBuffer.set_clusterLevel = function(this1,value) {
	return value;
};
lime_text_harfbuzz_HBBuffer.get_contentType = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBBuffer.set_contentType = function(this1,value) {
	return value;
};
lime_text_harfbuzz_HBBuffer.get_direction = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBBuffer.set_direction = function(this1,value) {
	return value;
};
lime_text_harfbuzz_HBBuffer.get_empty = function() {
	return null;
};
lime_text_harfbuzz_HBBuffer.get_flags = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBBuffer.set_flags = function(this1,value) {
	return value;
};
lime_text_harfbuzz_HBBuffer.get_language = function(this1) {
	return null;
};
lime_text_harfbuzz_HBBuffer.set_language = function(this1,value) {
	return value;
};
lime_text_harfbuzz_HBBuffer.get_length = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBBuffer.set_length = function(this1,value) {
	return value;
};
lime_text_harfbuzz_HBBuffer.get_replacementCodepoint = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBBuffer.set_replacementCodepoint = function(this1,value) {
	return value;
};
lime_text_harfbuzz_HBBuffer.get_script = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBBuffer.set_script = function(this1,value) {
	return value;
};
lime_text_harfbuzz_HBBuffer.get_segmentProperties = function(this1) {
	return null;
};
lime_text_harfbuzz_HBBuffer.set_segmentProperties = function(this1,value) {
	return value;
};
var lime_text_harfbuzz_HBFTFont = {};
lime_text_harfbuzz_HBFTFont.__properties__ = {set_loadFlags:"set_loadFlags",get_loadFlags:"get_loadFlags"};
lime_text_harfbuzz_HBFTFont._new = function(font) {
	var this1;
	if(font.src != null) {
		this1 = null;
	} else {
		this1 = null;
	}
	return this1;
};
lime_text_harfbuzz_HBFTFont.get_loadFlags = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBFTFont.set_loadFlags = function(this1,value) {
	return value;
};
var lime_text_harfbuzz_HBFace = {};
lime_text_harfbuzz_HBFace.__properties__ = {set_upem:"set_upem",get_upem:"get_upem",set_index:"set_index",get_index:"get_index",get_immutable:"get_immutable",set_glyphCount:"set_glyphCount",get_glyphCount:"get_glyphCount",get_empty:"get_empty"};
lime_text_harfbuzz_HBFace._new = function(blob,index) {
	var this1 = null;
	return this1;
};
lime_text_harfbuzz_HBFace.get_empty = function() {
	return null;
};
lime_text_harfbuzz_HBFace.get_glyphCount = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBFace.set_glyphCount = function(this1,value) {
	return value;
};
lime_text_harfbuzz_HBFace.get_immutable = function(this1) {
	return false;
};
lime_text_harfbuzz_HBFace.get_index = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBFace.set_index = function(this1,value) {
	return value;
};
lime_text_harfbuzz_HBFace.get_upem = function(this1) {
	return 0;
};
lime_text_harfbuzz_HBFace.set_upem = function(this1,value) {
	return value;
};
var lime_text_harfbuzz_HBFeature = function() {
};
$hxClasses["lime.text.harfbuzz.HBFeature"] = lime_text_harfbuzz_HBFeature;
lime_text_harfbuzz_HBFeature.__name__ = "lime.text.harfbuzz.HBFeature";
lime_text_harfbuzz_HBFeature.prototype = {
	__class__: lime_text_harfbuzz_HBFeature
};
var lime_text_harfbuzz_HBFont = {};
lime_text_harfbuzz_HBFont.__properties__ = {set_scale:"set_scale",get_scale:"get_scale",set_ppem:"set_ppem",get_ppem:"get_ppem",get_parent:"get_parent",get_immutable:"get_immutable",get_face:"get_face",get_empty:"get_empty"};
lime_text_harfbuzz_HBFont._new = function(face) {
	var this1 = null;
	return this1;
};
lime_text_harfbuzz_HBFont.addGlyphOriginForDirection = function(this1,glyph,direction,x,y) {
};
lime_text_harfbuzz_HBFont.createSubFont = function(this1) {
	return null;
};
lime_text_harfbuzz_HBFont.getGlyphAdvanceForDirection = function(this1,glyph,direction) {
	return null;
};
lime_text_harfbuzz_HBFont.getGlyphKerningForDirection = function(this1,glyph,firstGlyph,secondGlyph,direction) {
	return null;
};
lime_text_harfbuzz_HBFont.getGlyphOriginForDirection = function(this1,glyph,direction) {
	return null;
};
lime_text_harfbuzz_HBFont.glyphFromString = function(this1,s) {
	return 0;
};
lime_text_harfbuzz_HBFont.glyphToString = function(this1,codepoint) {
	return null;
};
lime_text_harfbuzz_HBFont.makeImmutable = function(this1) {
};
lime_text_harfbuzz_HBFont.subtractGlyphOriginForDirection = function(this1,glyph,direction,x,y) {
};
lime_text_harfbuzz_HBFont.get_empty = function() {
	return null;
};
lime_text_harfbuzz_HBFont.get_face = function(this1) {
	return null;
};
lime_text_harfbuzz_HBFont.get_immutable = function(this1) {
	return false;
};
lime_text_harfbuzz_HBFont.get_parent = function(this1) {
	return null;
};
lime_text_harfbuzz_HBFont.get_ppem = function(this1) {
	return null;
};
lime_text_harfbuzz_HBFont.set_ppem = function(this1,value) {
	return value;
};
lime_text_harfbuzz_HBFont.get_scale = function(this1) {
	return null;
};
lime_text_harfbuzz_HBFont.set_scale = function(this1,value) {
	return value;
};
var lime_text_harfbuzz_HBGlyphInfo = function() {
};
$hxClasses["lime.text.harfbuzz.HBGlyphInfo"] = lime_text_harfbuzz_HBGlyphInfo;
lime_text_harfbuzz_HBGlyphInfo.__name__ = "lime.text.harfbuzz.HBGlyphInfo";
lime_text_harfbuzz_HBGlyphInfo.prototype = {
	__class__: lime_text_harfbuzz_HBGlyphInfo
};
var lime_text_harfbuzz_HBGlyphPosition = function() {
};
$hxClasses["lime.text.harfbuzz.HBGlyphPosition"] = lime_text_harfbuzz_HBGlyphPosition;
lime_text_harfbuzz_HBGlyphPosition.__name__ = "lime.text.harfbuzz.HBGlyphPosition";
lime_text_harfbuzz_HBGlyphPosition.prototype = {
	__class__: lime_text_harfbuzz_HBGlyphPosition
};
var lime_text_harfbuzz_HBLanguage = {};
lime_text_harfbuzz_HBLanguage._new = function(language) {
	var this1 = null;
	return this1;
};
lime_text_harfbuzz_HBLanguage.toString = function(this1) {
	return null;
};
lime_text_harfbuzz_HBLanguage.fromString = function(value) {
	return lime_text_harfbuzz_HBLanguage._new(value);
};
var lime_text_harfbuzz_HBSegmentProperties = function() {
};
$hxClasses["lime.text.harfbuzz.HBSegmentProperties"] = lime_text_harfbuzz_HBSegmentProperties;
lime_text_harfbuzz_HBSegmentProperties.__name__ = "lime.text.harfbuzz.HBSegmentProperties";
lime_text_harfbuzz_HBSegmentProperties.prototype = {
	__class__: lime_text_harfbuzz_HBSegmentProperties
};
var lime_ui_Gamepad = function(id) {
	this.onDisconnect = new lime_app__$Event_$Void_$Void();
	this.onButtonUp = new lime_app__$Event_$lime_$ui_$GamepadButton_$Void();
	this.onButtonDown = new lime_app__$Event_$lime_$ui_$GamepadButton_$Void();
	this.onAxisMove = new lime_app__$Event_$lime_$ui_$GamepadAxis_$Float_$Void();
	this.id = id;
	this.connected = true;
};
$hxClasses["lime.ui.Gamepad"] = lime_ui_Gamepad;
lime_ui_Gamepad.__name__ = "lime.ui.Gamepad";
lime_ui_Gamepad.addMappings = function(mappings) {
};
lime_ui_Gamepad.__connect = function(id) {
	if(!lime_ui_Gamepad.devices.h.hasOwnProperty(id)) {
		var gamepad = new lime_ui_Gamepad(id);
		lime_ui_Gamepad.devices.h[id] = gamepad;
		lime_ui_Gamepad.onConnect.dispatch(gamepad);
	}
};
lime_ui_Gamepad.__disconnect = function(id) {
	var gamepad = lime_ui_Gamepad.devices.h[id];
	if(gamepad != null) {
		gamepad.connected = false;
	}
	lime_ui_Gamepad.devices.remove(id);
	if(gamepad != null) {
		gamepad.onDisconnect.dispatch();
	}
};
lime_ui_Gamepad.prototype = {
	get_guid: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].id;
	}
	,get_name: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].id;
	}
	,__class__: lime_ui_Gamepad
	,__properties__: {get_name:"get_name",get_guid:"get_guid"}
};
var lime_ui_GamepadAxis = {};
lime_ui_GamepadAxis.toString = function(this1) {
	switch(this1) {
	case 0:
		return "LEFT_X";
	case 1:
		return "LEFT_Y";
	case 2:
		return "RIGHT_X";
	case 3:
		return "RIGHT_Y";
	case 4:
		return "TRIGGER_LEFT";
	case 5:
		return "TRIGGER_RIGHT";
	default:
		return "UNKNOWN (" + this1 + ")";
	}
};
var lime_ui_GamepadButton = {};
lime_ui_GamepadButton.toString = function(this1) {
	switch(this1) {
	case 0:
		return "A";
	case 1:
		return "B";
	case 2:
		return "X";
	case 3:
		return "Y";
	case 4:
		return "BACK";
	case 5:
		return "GUIDE";
	case 6:
		return "START";
	case 7:
		return "LEFT_STICK";
	case 8:
		return "RIGHT_STICK";
	case 9:
		return "LEFT_SHOULDER";
	case 10:
		return "RIGHT_SHOULDER";
	case 11:
		return "DPAD_UP";
	case 12:
		return "DPAD_DOWN";
	case 13:
		return "DPAD_LEFT";
	case 14:
		return "DPAD_RIGHT";
	default:
		return "UNKNOWN (" + this1 + ")";
	}
};
var lime_ui_Joystick = function(id) {
	this.onTrackballMove = new lime_app__$Event_$Int_$Float_$Float_$Void();
	this.onHatMove = new lime_app__$Event_$Int_$lime_$ui_$JoystickHatPosition_$Void();
	this.onDisconnect = new lime_app__$Event_$Void_$Void();
	this.onButtonUp = new lime_app__$Event_$Int_$Void();
	this.onButtonDown = new lime_app__$Event_$Int_$Void();
	this.onAxisMove = new lime_app__$Event_$Int_$Float_$Void();
	this.id = id;
	this.connected = true;
};
$hxClasses["lime.ui.Joystick"] = lime_ui_Joystick;
lime_ui_Joystick.__name__ = "lime.ui.Joystick";
lime_ui_Joystick.__connect = function(id) {
	if(!lime_ui_Joystick.devices.h.hasOwnProperty(id)) {
		var joystick = new lime_ui_Joystick(id);
		lime_ui_Joystick.devices.h[id] = joystick;
		lime_ui_Joystick.onConnect.dispatch(joystick);
	}
};
lime_ui_Joystick.__disconnect = function(id) {
	var joystick = lime_ui_Joystick.devices.h[id];
	if(joystick != null) {
		joystick.connected = false;
	}
	lime_ui_Joystick.devices.remove(id);
	if(joystick != null) {
		joystick.onDisconnect.dispatch();
	}
};
lime_ui_Joystick.__getDeviceData = function() {
	if(navigator.getGamepads) {
		return navigator.getGamepads();
	} else if(navigator.webkitGetGamepads) {
		return navigator.webkitGetGamepads();
	} else {
		return null;
	}
};
lime_ui_Joystick.prototype = {
	get_guid: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].id;
	}
	,get_name: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].id;
	}
	,get_numAxes: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].axes.length;
	}
	,get_numButtons: function() {
		var devices = lime_ui_Joystick.__getDeviceData();
		return devices[this.id].buttons.length;
	}
	,get_numHats: function() {
		return 0;
	}
	,get_numTrackballs: function() {
		return 0;
	}
	,__class__: lime_ui_Joystick
	,__properties__: {get_numTrackballs:"get_numTrackballs",get_numHats:"get_numHats",get_numButtons:"get_numButtons",get_numAxes:"get_numAxes",get_name:"get_name",get_guid:"get_guid"}
};
var lime_ui_JoystickHatPosition = {};
lime_ui_JoystickHatPosition.__properties__ = {set_up:"set_up",get_up:"get_up",set_right:"set_right",get_right:"get_right",set_left:"set_left",get_left:"get_left",set_down:"set_down",get_down:"get_down",set_center:"set_center",get_center:"get_center"};
lime_ui_JoystickHatPosition._new = function(value) {
	var this1 = value;
	return this1;
};
lime_ui_JoystickHatPosition.get_center = function(this1) {
	return this1 == 0;
};
lime_ui_JoystickHatPosition.set_center = function(this1,value) {
	if(value) {
		this1 = 0;
	}
	return value;
};
lime_ui_JoystickHatPosition.get_down = function(this1) {
	return (this1 & 4) > 0;
};
lime_ui_JoystickHatPosition.set_down = function(this1,value) {
	if(value) {
		this1 |= 4;
	} else {
		this1 &= 268435455 - 4;
	}
	return value;
};
lime_ui_JoystickHatPosition.get_left = function(this1) {
	return (this1 & 8) > 0;
};
lime_ui_JoystickHatPosition.set_left = function(this1,value) {
	if(value) {
		this1 |= 8;
	} else {
		this1 &= 268435455 - 8;
	}
	return value;
};
lime_ui_JoystickHatPosition.get_right = function(this1) {
	return (this1 & 2) > 0;
};
lime_ui_JoystickHatPosition.set_right = function(this1,value) {
	if(value) {
		this1 |= 2;
	} else {
		this1 &= 268435455 - 2;
	}
	return value;
};
lime_ui_JoystickHatPosition.get_up = function(this1) {
	return (this1 & 1) > 0;
};
lime_ui_JoystickHatPosition.set_up = function(this1,value) {
	if(value) {
		this1 |= 1;
	} else {
		this1 &= 268435455 - 1;
	}
	return value;
};
var lime_ui_KeyCode = {};
lime_ui_KeyCode.fromScanCode = function(scanCode) {
	return 0;
};
lime_ui_KeyCode.toScanCode = function(keyCode) {
	return 0;
};
lime_ui_KeyCode.gt = function(a,b) {
	return a > b;
};
lime_ui_KeyCode.gte = function(a,b) {
	return a >= b;
};
lime_ui_KeyCode.lt = function(a,b) {
	return a < b;
};
lime_ui_KeyCode.lte = function(a,b) {
	return a <= b;
};
lime_ui_KeyCode.plus = function(a,b) {
	return a + b;
};
var lime_ui_KeyModifier = {};
lime_ui_KeyModifier.__properties__ = {set_shiftKey:"set_shiftKey",get_shiftKey:"get_shiftKey",set_numLock:"set_numLock",get_numLock:"get_numLock",set_metaKey:"set_metaKey",get_metaKey:"get_metaKey",set_ctrlKey:"set_ctrlKey",get_ctrlKey:"get_ctrlKey",set_capsLock:"set_capsLock",get_capsLock:"get_capsLock",set_altKey:"set_altKey",get_altKey:"get_altKey"};
lime_ui_KeyModifier.get_altKey = function(this1) {
	if((this1 & 256) <= 0) {
		return (this1 & 512) > 0;
	} else {
		return true;
	}
};
lime_ui_KeyModifier.set_altKey = function(this1,value) {
	if(value) {
		this1 |= 768;
	} else {
		this1 &= 268435455 - 768;
	}
	return value;
};
lime_ui_KeyModifier.get_capsLock = function(this1) {
	if((this1 & 8192) <= 0) {
		return (this1 & 8192) > 0;
	} else {
		return true;
	}
};
lime_ui_KeyModifier.set_capsLock = function(this1,value) {
	if(value) {
		this1 |= 8192;
	} else {
		this1 &= 268435455 - 8192;
	}
	return value;
};
lime_ui_KeyModifier.get_ctrlKey = function(this1) {
	if((this1 & 64) <= 0) {
		return (this1 & 128) > 0;
	} else {
		return true;
	}
};
lime_ui_KeyModifier.set_ctrlKey = function(this1,value) {
	if(value) {
		this1 |= 192;
	} else {
		this1 &= 268435455 - 192;
	}
	return value;
};
lime_ui_KeyModifier.get_metaKey = function(this1) {
	if((this1 & 1024) <= 0) {
		return (this1 & 2048) > 0;
	} else {
		return true;
	}
};
lime_ui_KeyModifier.set_metaKey = function(this1,value) {
	if(value) {
		this1 |= 3072;
	} else {
		this1 &= 268435455 - 3072;
	}
	return value;
};
lime_ui_KeyModifier.get_numLock = function(this1) {
	if((this1 & 4096) <= 0) {
		return (this1 & 4096) > 0;
	} else {
		return true;
	}
};
lime_ui_KeyModifier.set_numLock = function(this1,value) {
	if(value) {
		this1 |= 4096;
	} else {
		this1 &= 268435455 - 4096;
	}
	return value;
};
lime_ui_KeyModifier.get_shiftKey = function(this1) {
	if((this1 & 1) <= 0) {
		return (this1 & 2) > 0;
	} else {
		return true;
	}
};
lime_ui_KeyModifier.set_shiftKey = function(this1,value) {
	if(value) {
		this1 |= 3;
	} else {
		this1 &= 268435455 - 3;
	}
	return value;
};
var lime_ui_MouseCursor = $hxEnums["lime.ui.MouseCursor"] = { __ename__ : "lime.ui.MouseCursor", __constructs__ : ["ARROW","CROSSHAIR","DEFAULT","MOVE","POINTER","RESIZE_NESW","RESIZE_NS","RESIZE_NWSE","RESIZE_WE","TEXT","WAIT","WAIT_ARROW","CUSTOM"]
	,ARROW: {_hx_index:0,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,CROSSHAIR: {_hx_index:1,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,DEFAULT: {_hx_index:2,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,MOVE: {_hx_index:3,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,POINTER: {_hx_index:4,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,RESIZE_NESW: {_hx_index:5,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,RESIZE_NS: {_hx_index:6,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,RESIZE_NWSE: {_hx_index:7,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,RESIZE_WE: {_hx_index:8,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,TEXT: {_hx_index:9,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,WAIT: {_hx_index:10,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,WAIT_ARROW: {_hx_index:11,__enum__:"lime.ui.MouseCursor",toString:$estr}
	,CUSTOM: {_hx_index:12,__enum__:"lime.ui.MouseCursor",toString:$estr}
};
var lime_ui_MouseWheelMode = $hxEnums["lime.ui.MouseWheelMode"] = { __ename__ : "lime.ui.MouseWheelMode", __constructs__ : ["PIXELS","LINES","PAGES","UNKNOWN"]
	,PIXELS: {_hx_index:0,__enum__:"lime.ui.MouseWheelMode",toString:$estr}
	,LINES: {_hx_index:1,__enum__:"lime.ui.MouseWheelMode",toString:$estr}
	,PAGES: {_hx_index:2,__enum__:"lime.ui.MouseWheelMode",toString:$estr}
	,UNKNOWN: {_hx_index:3,__enum__:"lime.ui.MouseWheelMode",toString:$estr}
};
var lime_ui_ScanCode = {};
lime_ui_ScanCode.fromKeyCode = function(keyCode) {
	return lime_ui_KeyCode.toScanCode(keyCode);
};
lime_ui_ScanCode.toKeyCode = function(scanCode) {
	return lime_ui_KeyCode.fromScanCode(scanCode);
};
lime_ui_ScanCode.gt = function(a,b) {
	return a > b;
};
lime_ui_ScanCode.gte = function(a,b) {
	return a >= b;
};
lime_ui_ScanCode.lt = function(a,b) {
	return a < b;
};
lime_ui_ScanCode.lte = function(a,b) {
	return a <= b;
};
lime_ui_ScanCode.plus = function(a,b) {
	return a + b;
};
var lime_ui_Touch = function(x,y,id,dx,dy,pressure,device) {
	this.x = x;
	this.y = y;
	this.id = id;
	this.dx = dx;
	this.dy = dy;
	this.pressure = pressure;
	this.device = device;
};
$hxClasses["lime.ui.Touch"] = lime_ui_Touch;
lime_ui_Touch.__name__ = "lime.ui.Touch";
lime_ui_Touch.prototype = {
	__class__: lime_ui_Touch
};
var lime_ui_Window = function(application,attributes) {
	this.onTextInput = new lime_app__$Event_$String_$Void();
	this.onTextEdit = new lime_app__$Event_$String_$Int_$Int_$Void();
	this.onRestore = new lime_app__$Event_$Void_$Void();
	this.onResize = new lime_app__$Event_$Int_$Int_$Void();
	this.onRenderContextRestored = new lime_app__$Event_$lime_$graphics_$RenderContext_$Void();
	this.onRenderContextLost = new lime_app__$Event_$Void_$Void();
	this.onRender = new lime_app__$Event_$lime_$graphics_$RenderContext_$Void();
	this.onMove = new lime_app__$Event_$Float_$Float_$Void();
	this.onMouseWheel = new lime_app__$Event_$Float_$Float_$lime_$ui_$MouseWheelMode_$Void();
	this.onMouseUp = new lime_app__$Event_$Float_$Float_$Int_$Void();
	this.onMouseMoveRelative = new lime_app__$Event_$Float_$Float_$Void();
	this.onMouseMove = new lime_app__$Event_$Float_$Float_$Void();
	this.onMouseDown = new lime_app__$Event_$Float_$Float_$lime_$ui_$MouseButton_$Void();
	this.onMinimize = new lime_app__$Event_$Void_$Void();
	this.onMaximize = new lime_app__$Event_$Void_$Void();
	this.onLeave = new lime_app__$Event_$Void_$Void();
	this.onKeyUp = new lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void();
	this.onKeyDown = new lime_app__$Event_$lime_$ui_$KeyCode_$lime_$ui_$KeyModifier_$Void();
	this.onFullscreen = new lime_app__$Event_$Void_$Void();
	this.onFocusOut = new lime_app__$Event_$Void_$Void();
	this.onFocusIn = new lime_app__$Event_$Void_$Void();
	this.onExpose = new lime_app__$Event_$Void_$Void();
	this.onEnter = new lime_app__$Event_$Void_$Void();
	this.onDropFile = new lime_app__$Event_$String_$Void();
	this.onDeactivate = new lime_app__$Event_$Void_$Void();
	this.onClose = new lime_app__$Event_$Void_$Void();
	this.onActivate = new lime_app__$Event_$Void_$Void();
	this.application = application;
	this.__attributes = attributes != null ? attributes : { };
	if(Object.prototype.hasOwnProperty.call(this.__attributes,"parameters")) {
		this.parameters = this.__attributes.parameters;
	}
	this.__width = 0;
	this.__height = 0;
	this.__fullscreen = false;
	this.__scale = 1;
	this.__x = 0;
	this.__y = 0;
	this.__title = "";
	this.id = -1;
	this.__backend = new lime__$internal_backend_html5_HTML5Window(this);
};
$hxClasses["lime.ui.Window"] = lime_ui_Window;
lime_ui_Window.__name__ = "lime.ui.Window";
lime_ui_Window.prototype = {
	alert: function(message,title) {
		this.__backend.alert(message,title);
	}
	,close: function() {
		this.__backend.close();
	}
	,focus: function() {
		this.__backend.focus();
	}
	,move: function(x,y) {
		this.__backend.move(x,y);
		this.__x = x;
		this.__y = y;
	}
	,readPixels: function(rect) {
		return this.__backend.readPixels(rect);
	}
	,resize: function(width,height) {
		this.__backend.resize(width,height);
		this.__width = width;
		this.__height = height;
	}
	,setIcon: function(image) {
		if(image == null) {
			return;
		}
		this.__backend.setIcon(image);
	}
	,toString: function() {
		return "[object Window]";
	}
	,warpMouse: function(x,y) {
		this.__backend.warpMouse(x,y);
	}
	,get_cursor: function() {
		return this.__backend.getCursor();
	}
	,set_cursor: function(value) {
		return this.__backend.setCursor(value);
	}
	,get_display: function() {
		return this.__backend.getDisplay();
	}
	,get_displayMode: function() {
		return this.__backend.getDisplayMode();
	}
	,set_displayMode: function(value) {
		return this.__backend.setDisplayMode(value);
	}
	,get_borderless: function() {
		return this.__borderless;
	}
	,set_borderless: function(value) {
		return this.__borderless = this.__backend.setBorderless(value);
	}
	,get_frameRate: function() {
		return this.__backend.getFrameRate();
	}
	,set_frameRate: function(value) {
		return this.__backend.setFrameRate(value);
	}
	,get_fullscreen: function() {
		return this.__fullscreen;
	}
	,set_fullscreen: function(value) {
		return this.__fullscreen = this.__backend.setFullscreen(value);
	}
	,get_height: function() {
		return this.__height;
	}
	,set_height: function(value) {
		this.resize(this.__width,value);
		return this.__height;
	}
	,get_hidden: function() {
		return this.__hidden;
	}
	,get_maximized: function() {
		return this.__maximized;
	}
	,set_maximized: function(value) {
		this.__minimized = false;
		return this.__maximized = this.__backend.setMaximized(value);
	}
	,get_minimized: function() {
		return this.__minimized;
	}
	,set_minimized: function(value) {
		this.__maximized = false;
		return this.__minimized = this.__backend.setMinimized(value);
	}
	,get_mouseLock: function() {
		return this.__backend.getMouseLock();
	}
	,set_mouseLock: function(value) {
		this.__backend.setMouseLock(value);
		return value;
	}
	,get_resizable: function() {
		return this.__resizable;
	}
	,set_resizable: function(value) {
		this.__resizable = this.__backend.setResizable(value);
		return this.__resizable;
	}
	,get_scale: function() {
		return this.__scale;
	}
	,get_textInputEnabled: function() {
		return this.__backend.getTextInputEnabled();
	}
	,set_textInputEnabled: function(value) {
		return this.__backend.setTextInputEnabled(value);
	}
	,get_title: function() {
		return this.__title;
	}
	,set_title: function(value) {
		return this.__title = this.__backend.setTitle(value);
	}
	,get_width: function() {
		return this.__width;
	}
	,set_width: function(value) {
		this.resize(value,this.__height);
		return this.__width;
	}
	,get_x: function() {
		return this.__x;
	}
	,set_x: function(value) {
		this.move(value,this.__y);
		return this.__x;
	}
	,get_y: function() {
		return this.__y;
	}
	,set_y: function(value) {
		this.move(this.__x,value);
		return this.__y;
	}
	,__class__: lime_ui_Window
	,__properties__: {set_y:"set_y",get_y:"get_y",set_x:"set_x",get_x:"get_x",set_width:"set_width",get_width:"get_width",set_title:"set_title",get_title:"get_title",set_textInputEnabled:"set_textInputEnabled",get_textInputEnabled:"get_textInputEnabled",get_scale:"get_scale",set_resizable:"set_resizable",get_resizable:"get_resizable",set_mouseLock:"set_mouseLock",get_mouseLock:"get_mouseLock",set_minimized:"set_minimized",get_minimized:"get_minimized",set_maximized:"set_maximized",get_maximized:"get_maximized",get_hidden:"get_hidden",set_height:"set_height",get_height:"get_height",set_fullscreen:"set_fullscreen",get_fullscreen:"get_fullscreen",set_frameRate:"set_frameRate",get_frameRate:"get_frameRate",set_displayMode:"set_displayMode",get_displayMode:"get_displayMode",get_display:"get_display",set_cursor:"set_cursor",get_cursor:"get_cursor",set_borderless:"set_borderless",get_borderless:"get_borderless"}
};
var lime_utils_TAError = $hxEnums["lime.utils.TAError"] = { __ename__ : "lime.utils.TAError", __constructs__ : ["RangeError"]
	,RangeError: {_hx_index:0,__enum__:"lime.utils.TAError",toString:$estr}
};
var lime_utils_AssetBundle = function() {
	this.data = new haxe_ds_StringMap();
	this.paths = [];
};
$hxClasses["lime.utils.AssetBundle"] = lime_utils_AssetBundle;
lime_utils_AssetBundle.__name__ = "lime.utils.AssetBundle";
lime_utils_AssetBundle.fromBytes = function(bytes) {
	var input = new haxe_io_BytesInput(bytes);
	return lime_utils_AssetBundle.__extractBundle(input);
};
lime_utils_AssetBundle.fromFile = function(path) {
	return null;
};
lime_utils_AssetBundle.loadFromBytes = function(bytes) {
	return lime_app_Future.withValue(lime_utils_AssetBundle.fromBytes(bytes));
};
lime_utils_AssetBundle.loadFromFile = function(path) {
	return lime_utils_Bytes.loadFromFile(path).then(lime_utils_AssetBundle.loadFromBytes);
};
lime_utils_AssetBundle.__extractBundle = function(input) {
	var entries = haxe_zip_Reader.readZip(input);
	var bundle = new lime_utils_AssetBundle();
	var _g_head = entries.h;
	while(_g_head != null) {
		var val = _g_head.item;
		_g_head = _g_head.next;
		var entry = val;
		if(entry.compressed) {
			var bytes = entry.data;
			var this1 = bundle.data;
			var key = entry.fileName;
			var value = lime_utils_Bytes.decompress(bytes,lime_utils_CompressionAlgorithm.DEFLATE);
			this1.h[key] = value;
		} else {
			bundle.data.h[entry.fileName] = entry.data;
		}
		bundle.paths.push(entry.fileName);
	}
	return bundle;
};
lime_utils_AssetBundle.prototype = {
	__class__: lime_utils_AssetBundle
};
var lime_utils_AssetCache = function() {
	this.enabled = true;
	this.audio = new haxe_ds_StringMap();
	this.font = new haxe_ds_StringMap();
	this.image = new haxe_ds_StringMap();
	this.version = 56866;
};
$hxClasses["lime.utils.AssetCache"] = lime_utils_AssetCache;
lime_utils_AssetCache.__name__ = "lime.utils.AssetCache";
lime_utils_AssetCache.prototype = {
	exists: function(id,type) {
		if(type == "IMAGE" || type == null) {
			if(Object.prototype.hasOwnProperty.call(this.image.h,id)) {
				return true;
			}
		}
		if(type == "FONT" || type == null) {
			if(Object.prototype.hasOwnProperty.call(this.font.h,id)) {
				return true;
			}
		}
		if(type == "SOUND" || type == "MUSIC" || type == null) {
			if(Object.prototype.hasOwnProperty.call(this.audio.h,id)) {
				return true;
			}
		}
		return false;
	}
	,set: function(id,type,asset) {
		switch(type) {
		case "FONT":
			this.font.h[id] = asset;
			break;
		case "IMAGE":
			if(!((asset) instanceof lime_graphics_Image)) {
				throw haxe_Exception.thrown("Cannot cache non-Image asset: " + Std.string(asset) + " as Image");
			}
			this.image.h[id] = asset;
			break;
		case "MUSIC":case "SOUND":
			if(!((asset) instanceof lime_media_AudioBuffer)) {
				throw haxe_Exception.thrown("Cannot cache non-AudioBuffer asset: " + Std.string(asset) + " as AudioBuffer");
			}
			this.audio.h[id] = asset;
			break;
		default:
			throw haxe_Exception.thrown(type + " assets are not cachable");
		}
	}
	,clear: function(prefix) {
		if(prefix == null) {
			this.audio = new haxe_ds_StringMap();
			this.font = new haxe_ds_StringMap();
			this.image = new haxe_ds_StringMap();
		} else {
			var keys = haxe_ds_StringMap.keysIterator(this.audio.h);
			var key = keys;
			while(key.hasNext()) {
				var key1 = key.next();
				if(StringTools.startsWith(key1,prefix)) {
					var _this = this.audio;
					if(Object.prototype.hasOwnProperty.call(_this.h,key1)) {
						delete(_this.h[key1]);
					}
				}
			}
			var keys = haxe_ds_StringMap.keysIterator(this.font.h);
			var key = keys;
			while(key.hasNext()) {
				var key1 = key.next();
				if(StringTools.startsWith(key1,prefix)) {
					var _this = this.font;
					if(Object.prototype.hasOwnProperty.call(_this.h,key1)) {
						delete(_this.h[key1]);
					}
				}
			}
			var keys = haxe_ds_StringMap.keysIterator(this.image.h);
			var key = keys;
			while(key.hasNext()) {
				var key1 = key.next();
				if(StringTools.startsWith(key1,prefix)) {
					var _this = this.image;
					if(Object.prototype.hasOwnProperty.call(_this.h,key1)) {
						delete(_this.h[key1]);
					}
				}
			}
		}
	}
	,__class__: lime_utils_AssetCache
};
var lime_utils_AssetLibrary = function() {
	this.types = new haxe_ds_StringMap();
	this.sizes = new haxe_ds_StringMap();
	this.preload = new haxe_ds_StringMap();
	this.paths = new haxe_ds_StringMap();
	this.pathGroups = new haxe_ds_StringMap();
	this.classTypes = new haxe_ds_StringMap();
	this.cachedText = new haxe_ds_StringMap();
	this.cachedImages = new haxe_ds_StringMap();
	this.cachedFonts = new haxe_ds_StringMap();
	this.cachedBytes = new haxe_ds_StringMap();
	this.cachedAudioBuffers = new haxe_ds_StringMap();
	this.onChange = new lime_app__$Event_$Void_$Void();
	this.bytesLoaded = 0;
	this.bytesTotal = 0;
};
$hxClasses["lime.utils.AssetLibrary"] = lime_utils_AssetLibrary;
lime_utils_AssetLibrary.__name__ = "lime.utils.AssetLibrary";
lime_utils_AssetLibrary.fromBytes = function(bytes,rootPath) {
	return lime_utils_AssetLibrary.fromManifest(lime_utils_AssetManifest.fromBytes(bytes,rootPath));
};
lime_utils_AssetLibrary.fromFile = function(path,rootPath) {
	return lime_utils_AssetLibrary.fromManifest(lime_utils_AssetManifest.fromFile(path,rootPath));
};
lime_utils_AssetLibrary.fromBundle = function(bundle) {
	if(Object.prototype.hasOwnProperty.call(bundle.data.h,"library.json")) {
		var manifest = lime_utils_AssetManifest.fromBytes(bundle.data.h["library.json"]);
		if(manifest != null) {
			var library = null;
			if(manifest.libraryType == null) {
				library = new lime_utils_AssetLibrary();
			} else {
				var name = manifest.libraryType;
				var libraryClass = $hxClasses[name];
				if(libraryClass != null) {
					library = Type.createInstance(libraryClass,manifest.libraryArgs);
				} else {
					lime_utils_Log.warn("Could not find library type: " + manifest.libraryType,{ fileName : "lime/utils/AssetLibrary.hx", lineNumber : 122, className : "lime.utils.AssetLibrary", methodName : "fromBundle"});
					return null;
				}
			}
			library.__fromBundle(bundle,manifest);
			return library;
		}
	} else {
		var library = new lime_utils_AssetLibrary();
		library.__fromBundle(bundle);
		return library;
	}
	return null;
};
lime_utils_AssetLibrary.fromManifest = function(manifest) {
	if(manifest == null) {
		return null;
	}
	var library = null;
	if(manifest.libraryType == null) {
		library = new lime_utils_AssetLibrary();
	} else {
		var name = manifest.libraryType;
		var libraryClass = $hxClasses[name];
		if(libraryClass != null) {
			library = Type.createInstance(libraryClass,manifest.libraryArgs);
		} else {
			lime_utils_Log.warn("Could not find library type: " + manifest.libraryType,{ fileName : "lime/utils/AssetLibrary.hx", lineNumber : 160, className : "lime.utils.AssetLibrary", methodName : "fromManifest"});
			return null;
		}
	}
	library.__fromManifest(manifest);
	return library;
};
lime_utils_AssetLibrary.loadFromBytes = function(bytes,rootPath) {
	return lime_utils_AssetManifest.loadFromBytes(bytes,rootPath).then(function(manifest) {
		return lime_utils_AssetLibrary.loadFromManifest(manifest);
	});
};
lime_utils_AssetLibrary.loadFromFile = function(path,rootPath) {
	return lime_utils_AssetManifest.loadFromFile(path,rootPath).then(function(manifest) {
		return lime_utils_AssetLibrary.loadFromManifest(manifest);
	});
};
lime_utils_AssetLibrary.loadFromManifest = function(manifest) {
	var library = lime_utils_AssetLibrary.fromManifest(manifest);
	if(library != null) {
		return library.load();
	} else {
		return lime_app_Future.withError("Could not load asset manifest");
	}
};
lime_utils_AssetLibrary.prototype = {
	exists: function(id,type) {
		var requestedType = type != null ? js_Boot.__cast(type , String) : null;
		var assetType = this.types.h[id];
		if(assetType != null) {
			if(assetType == requestedType || (requestedType == "SOUND" || requestedType == "MUSIC") && (assetType == "MUSIC" || assetType == "SOUND")) {
				return true;
			}
			if(requestedType == "BINARY" || requestedType == null || assetType == "BINARY" && requestedType == "TEXT") {
				return true;
			}
		}
		return false;
	}
	,getAsset: function(id,type) {
		switch(type) {
		case "BINARY":
			return this.getBytes(id);
		case "FONT":
			return this.getFont(id);
		case "IMAGE":
			return this.getImage(id);
		case "MUSIC":case "SOUND":
			return this.getAudioBuffer(id);
		case "TEMPLATE":
			throw haxe_Exception.thrown("Not sure how to get template: " + id);
		case "TEXT":
			return this.getText(id);
		default:
			throw haxe_Exception.thrown("Unknown asset type: " + type);
		}
	}
	,getAudioBuffer: function(id) {
		if(Object.prototype.hasOwnProperty.call(this.cachedAudioBuffers.h,id)) {
			return this.cachedAudioBuffers.h[id];
		} else if(Object.prototype.hasOwnProperty.call(this.classTypes.h,id)) {
			return lime_media_AudioBuffer.fromBytes(js_Boot.__cast(Type.createInstance(this.classTypes.h[id],[]) , haxe_io_Bytes));
		} else {
			return lime_media_AudioBuffer.fromFile(this.paths.h[id]);
		}
	}
	,getBytes: function(id) {
		if(Object.prototype.hasOwnProperty.call(this.cachedBytes.h,id)) {
			return this.cachedBytes.h[id];
		} else if(Object.prototype.hasOwnProperty.call(this.cachedText.h,id)) {
			var bytes = lime_utils_Bytes.ofString(this.cachedText.h[id]);
			this.cachedBytes.h[id] = bytes;
			return bytes;
		} else if(Object.prototype.hasOwnProperty.call(this.classTypes.h,id)) {
			return js_Boot.__cast(Type.createInstance(this.classTypes.h[id],[]) , haxe_io_Bytes);
		} else {
			return lime_utils_Bytes.fromFile(this.paths.h[id]);
		}
	}
	,getFont: function(id) {
		if(Object.prototype.hasOwnProperty.call(this.cachedFonts.h,id)) {
			return this.cachedFonts.h[id];
		} else if(Object.prototype.hasOwnProperty.call(this.classTypes.h,id)) {
			return js_Boot.__cast(Type.createInstance(this.classTypes.h[id],[]) , lime_text_Font);
		} else {
			return lime_text_Font.fromFile(this.paths.h[id]);
		}
	}
	,getImage: function(id) {
		if(Object.prototype.hasOwnProperty.call(this.cachedImages.h,id)) {
			return this.cachedImages.h[id];
		} else if(Object.prototype.hasOwnProperty.call(this.classTypes.h,id)) {
			return js_Boot.__cast(Type.createInstance(this.classTypes.h[id],[]) , lime_graphics_Image);
		} else {
			return lime_graphics_Image.fromFile(this.paths.h[id]);
		}
	}
	,getPath: function(id) {
		if(Object.prototype.hasOwnProperty.call(this.paths.h,id)) {
			return this.paths.h[id];
		} else if(Object.prototype.hasOwnProperty.call(this.pathGroups.h,id)) {
			return this.pathGroups.h[id][0];
		} else {
			return null;
		}
	}
	,getText: function(id) {
		if(Object.prototype.hasOwnProperty.call(this.cachedText.h,id)) {
			return this.cachedText.h[id];
		} else {
			var bytes = this.getBytes(id);
			if(bytes == null) {
				return null;
			} else {
				return bytes.getString(0,bytes.length);
			}
		}
	}
	,isLocal: function(id,type) {
		if(Object.prototype.hasOwnProperty.call(this.classTypes.h,id)) {
			return true;
		}
		var requestedType = type != null ? js_Boot.__cast(type , String) : null;
		if(requestedType == null) {
			if(!Object.prototype.hasOwnProperty.call(this.cachedBytes.h,id)) {
				return Object.prototype.hasOwnProperty.call(this.cachedText.h,id);
			} else {
				return true;
			}
		} else {
			switch(requestedType) {
			case "FONT":
				return Object.prototype.hasOwnProperty.call(this.cachedFonts.h,id);
			case "IMAGE":
				return Object.prototype.hasOwnProperty.call(this.cachedImages.h,id);
			case "MUSIC":case "SOUND":
				return Object.prototype.hasOwnProperty.call(this.cachedAudioBuffers.h,id);
			default:
				if(!Object.prototype.hasOwnProperty.call(this.cachedBytes.h,id)) {
					return Object.prototype.hasOwnProperty.call(this.cachedText.h,id);
				} else {
					return true;
				}
			}
		}
	}
	,list: function(type) {
		var requestedType = type != null ? js_Boot.__cast(type , String) : null;
		var items = [];
		var id = haxe_ds_StringMap.keysIterator(this.types.h);
		while(id.hasNext()) {
			var id1 = id.next();
			if(requestedType == null || this.exists(id1,type)) {
				items.push(id1);
			}
		}
		return items;
	}
	,loadAsset: function(id,type) {
		switch(type) {
		case "BINARY":
			return this.loadBytes(id);
		case "FONT":
			return this.loadFont(id);
		case "IMAGE":
			return this.loadImage(id);
		case "MUSIC":case "SOUND":
			return this.loadAudioBuffer(id);
		case "TEMPLATE":
			throw haxe_Exception.thrown("Not sure how to load template: " + id);
		case "TEXT":
			return this.loadText(id);
		default:
			throw haxe_Exception.thrown("Unknown asset type: " + type);
		}
	}
	,load: function() {
		if(this.loaded) {
			return lime_app_Future.withValue(this);
		}
		if(this.promise == null) {
			this.promise = new lime_app_Promise();
			this.bytesLoadedCache = new haxe_ds_StringMap();
			this.assetsLoaded = 0;
			this.assetsTotal = 1;
			var id = haxe_ds_StringMap.keysIterator(this.preload.h);
			while(id.hasNext()) {
				var id1 = id.next();
				if(!this.preload.h[id1]) {
					continue;
				}
				lime_utils_Log.verbose("Preloading asset: " + id1 + " [" + this.types.h[id1] + "]",{ fileName : "lime/utils/AssetLibrary.hx", lineNumber : 405, className : "lime.utils.AssetLibrary", methodName : "load"});
				var _g = this.types.h[id1];
				if(_g != null) {
					switch(_g) {
					case "BINARY":
						this.assetsTotal++;
						var future = this.loadBytes(id1);
						future.onProgress((function(id,_g) {
							return function(bytesLoaded,bytesTotal) {
								_g[0](id[0],bytesLoaded,bytesTotal);
							};
						})([id1],[$bind(this,this.load_onProgress)]));
						future.onError((function(id,_g) {
							return function(message) {
								_g[0](id[0],message);
							};
						})([id1],[$bind(this,this.load_onError)]));
						future.onComplete((function(id,_g) {
							return function(bytes) {
								_g[0](id[0],bytes);
							};
						})([id1],[$bind(this,this.loadBytes_onComplete)]));
						break;
					case "FONT":
						this.assetsTotal++;
						var future1 = this.loadFont(id1);
						future1.onProgress((function(id,_g) {
							return function(bytesLoaded,bytesTotal) {
								_g[0](id[0],bytesLoaded,bytesTotal);
							};
						})([id1],[$bind(this,this.load_onProgress)]));
						future1.onError((function(id,_g) {
							return function(message) {
								_g[0](id[0],message);
							};
						})([id1],[$bind(this,this.load_onError)]));
						future1.onComplete((function(id,_g) {
							return function(font) {
								_g[0](id[0],font);
							};
						})([id1],[$bind(this,this.loadFont_onComplete)]));
						break;
					case "IMAGE":
						this.assetsTotal++;
						var future2 = this.loadImage(id1);
						future2.onProgress((function(id,_g) {
							return function(bytesLoaded,bytesTotal) {
								_g[0](id[0],bytesLoaded,bytesTotal);
							};
						})([id1],[$bind(this,this.load_onProgress)]));
						future2.onError((function(id,_g) {
							return function(message) {
								_g[0](id[0],message);
							};
						})([id1],[$bind(this,this.load_onError)]));
						future2.onComplete((function(id,_g) {
							return function(image) {
								_g[0](id[0],image);
							};
						})([id1],[$bind(this,this.loadImage_onComplete)]));
						break;
					case "MUSIC":case "SOUND":
						this.assetsTotal++;
						var future3 = this.loadAudioBuffer(id1);
						future3.onProgress((function(id,_g) {
							return function(bytesLoaded,bytesTotal) {
								_g[0](id[0],bytesLoaded,bytesTotal);
							};
						})([id1],[$bind(this,this.load_onProgress)]));
						future3.onError((function(id,_g) {
							return function(message) {
								_g[0](id[0],message);
							};
						})([id1],[$bind(this,this.loadAudioBuffer_onError)]));
						future3.onComplete((function(id,_g) {
							return function(audioBuffer) {
								_g[0](id[0],audioBuffer);
							};
						})([id1],[$bind(this,this.loadAudioBuffer_onComplete)]));
						break;
					case "TEXT":
						this.assetsTotal++;
						var future4 = this.loadText(id1);
						future4.onProgress((function(id,_g) {
							return function(bytesLoaded,bytesTotal) {
								_g[0](id[0],bytesLoaded,bytesTotal);
							};
						})([id1],[$bind(this,this.load_onProgress)]));
						future4.onError((function(id,_g) {
							return function(message) {
								_g[0](id[0],message);
							};
						})([id1],[$bind(this,this.load_onError)]));
						future4.onComplete((function(id,_g) {
							return function(text) {
								_g[0](id[0],text);
							};
						})([id1],[$bind(this,this.loadText_onComplete)]));
						break;
					default:
					}
				}
			}
			this.__assetLoaded(null);
		}
		return this.promise.future;
	}
	,loadAudioBuffer: function(id) {
		if(Object.prototype.hasOwnProperty.call(this.cachedAudioBuffers.h,id)) {
			return lime_app_Future.withValue(this.cachedAudioBuffers.h[id]);
		} else if(Object.prototype.hasOwnProperty.call(this.classTypes.h,id)) {
			return lime_app_Future.withValue(Type.createInstance(this.classTypes.h[id],[]));
		} else if(Object.prototype.hasOwnProperty.call(this.pathGroups.h,id)) {
			return lime_media_AudioBuffer.loadFromFiles(this.pathGroups.h[id]);
		} else {
			return lime_media_AudioBuffer.loadFromFile(this.paths.h[id]);
		}
	}
	,loadBytes: function(id) {
		if(Object.prototype.hasOwnProperty.call(this.cachedBytes.h,id)) {
			return lime_app_Future.withValue(this.cachedBytes.h[id]);
		} else if(Object.prototype.hasOwnProperty.call(this.classTypes.h,id)) {
			return lime_app_Future.withValue(Type.createInstance(this.classTypes.h[id],[]));
		} else {
			return lime_utils_Bytes.loadFromFile(this.paths.h[id]);
		}
	}
	,loadFont: function(id) {
		if(Object.prototype.hasOwnProperty.call(this.cachedFonts.h,id)) {
			return lime_app_Future.withValue(this.cachedFonts.h[id]);
		} else if(Object.prototype.hasOwnProperty.call(this.classTypes.h,id)) {
			var font = Type.createInstance(this.classTypes.h[id],[]);
			return font.__loadFromName(font.name);
		} else {
			return lime_text_Font.loadFromName(this.paths.h[id]);
		}
	}
	,loadImage: function(id) {
		var _gthis = this;
		if(Object.prototype.hasOwnProperty.call(this.cachedImages.h,id)) {
			return lime_app_Future.withValue(this.cachedImages.h[id]);
		} else if(Object.prototype.hasOwnProperty.call(this.classTypes.h,id)) {
			return lime_app_Future.withValue(Type.createInstance(this.classTypes.h[id],[]));
		} else if(Object.prototype.hasOwnProperty.call(this.cachedBytes.h,id)) {
			return lime_graphics_Image.loadFromBytes(this.cachedBytes.h[id]).then(function(image) {
				var _this = _gthis.cachedBytes;
				if(Object.prototype.hasOwnProperty.call(_this.h,id)) {
					delete(_this.h[id]);
				}
				_gthis.cachedImages.h[id] = image;
				return lime_app_Future.withValue(image);
			});
		} else {
			return lime_graphics_Image.loadFromFile(this.paths.h[id]);
		}
	}
	,loadText: function(id) {
		if(Object.prototype.hasOwnProperty.call(this.cachedText.h,id)) {
			return lime_app_Future.withValue(this.cachedText.h[id]);
		} else if(Object.prototype.hasOwnProperty.call(this.cachedBytes.h,id) || Object.prototype.hasOwnProperty.call(this.classTypes.h,id)) {
			var bytes = this.getBytes(id);
			if(bytes == null) {
				return lime_app_Future.withValue(null);
			} else {
				var text = bytes.getString(0,bytes.length);
				this.cachedText.h[id] = text;
				return lime_app_Future.withValue(text);
			}
		} else {
			var request = new lime_net__$HTTPRequest_$String();
			return request.load(this.paths.h[id]);
		}
	}
	,unload: function() {
	}
	,__assetLoaded: function(id) {
		this.assetsLoaded++;
		if(id != null) {
			lime_utils_Log.verbose("Loaded asset: " + id + " [" + this.types.h[id] + "] (" + (this.assetsLoaded - 1) + "/" + (this.assetsTotal - 1) + ")",{ fileName : "lime/utils/AssetLibrary.hx", lineNumber : 619, className : "lime.utils.AssetLibrary", methodName : "__assetLoaded"});
		}
		if(id != null) {
			var size = Object.prototype.hasOwnProperty.call(this.sizes.h,id) ? this.sizes.h[id] : 0;
			if(!Object.prototype.hasOwnProperty.call(this.bytesLoadedCache.h,id)) {
				this.bytesLoaded += size;
			} else {
				var cache = this.bytesLoadedCache.h[id];
				if(cache < size) {
					this.bytesLoaded += size - cache;
				}
			}
			this.bytesLoadedCache.h[id] = size;
		}
		if(this.assetsLoaded < this.assetsTotal) {
			this.promise.progress(this.bytesLoaded,this.bytesTotal);
		} else {
			this.loaded = true;
			this.promise.progress(this.bytesTotal,this.bytesTotal);
			this.promise.complete(this);
		}
	}
	,__cacheBreak: function(path) {
		return lime_utils_Assets.__cacheBreak(path);
	}
	,__fromBundle: function(bundle,manifest) {
		if(manifest != null) {
			var id;
			var data;
			var type;
			var _g = 0;
			var _g1 = manifest.assets;
			while(_g < _g1.length) {
				var asset = _g1[_g];
				++_g;
				id = Object.prototype.hasOwnProperty.call(asset,"id") ? asset.id : asset.path;
				data = bundle.data.h[asset.path];
				if(Object.prototype.hasOwnProperty.call(asset,"type")) {
					type = asset.type;
					if(type == "TEXT") {
						this.cachedText.h[id] = data != null ? Std.string(data) : null;
					} else {
						this.cachedBytes.h[id] = data;
					}
					this.types.h[id] = asset.type;
				} else {
					this.cachedBytes.h[id] = data;
					this.types.h[id] = "BINARY";
				}
			}
		} else {
			var _g = 0;
			var _g1 = bundle.paths;
			while(_g < _g1.length) {
				var path = _g1[_g];
				++_g;
				this.cachedBytes.h[path] = bundle.data.h[path];
				this.types.h[path] = "BINARY";
			}
		}
	}
	,__fromManifest: function(manifest) {
		var hasSize = manifest.version >= 2;
		var size;
		var id;
		var pathGroup;
		var classRef;
		var basePath = manifest.rootPath;
		if(basePath == null) {
			basePath = "";
		}
		if(basePath != "") {
			basePath += "/";
		}
		var _g = 0;
		var _g1 = manifest.assets;
		while(_g < _g1.length) {
			var asset = _g1[_g];
			++_g;
			size = hasSize && Object.prototype.hasOwnProperty.call(asset,"size") ? asset.size : 100;
			id = Object.prototype.hasOwnProperty.call(asset,"id") ? asset.id : asset.path;
			if(Object.prototype.hasOwnProperty.call(asset,"path")) {
				var this1 = this.paths;
				var value = this.__cacheBreak(this.__resolvePath(basePath + Std.string(Reflect.field(asset,"path"))));
				this1.h[id] = value;
			}
			if(Object.prototype.hasOwnProperty.call(asset,"pathGroup")) {
				pathGroup = Reflect.field(asset,"pathGroup");
				var _g2 = 0;
				var _g3 = pathGroup.length;
				while(_g2 < _g3) {
					var i = _g2++;
					pathGroup[i] = this.__cacheBreak(this.__resolvePath(basePath + pathGroup[i]));
				}
				this.pathGroups.h[id] = pathGroup;
			}
			this.sizes.h[id] = size;
			this.types.h[id] = asset.type;
			if(Object.prototype.hasOwnProperty.call(asset,"preload")) {
				this.preload.h[id] = Reflect.field(asset,"preload");
			}
			if(Object.prototype.hasOwnProperty.call(asset,"className")) {
				var name = Reflect.field(asset,"className");
				classRef = $hxClasses[name];
				this.classTypes.h[id] = classRef;
			}
		}
		this.bytesTotal = 0;
		var _g = 0;
		var _g1 = manifest.assets;
		while(_g < _g1.length) {
			var asset = _g1[_g];
			++_g;
			id = Object.prototype.hasOwnProperty.call(asset,"id") ? asset.id : asset.path;
			if(Object.prototype.hasOwnProperty.call(this.preload.h,id) && this.preload.h[id] && Object.prototype.hasOwnProperty.call(this.sizes.h,id)) {
				this.bytesTotal += this.sizes.h[id];
			}
		}
	}
	,__resolvePath: function(path) {
		path = StringTools.replace(path,"\\","/");
		var colonIdx = path.indexOf(":");
		if(StringTools.startsWith(path,"http") && colonIdx > 0) {
			var lastSlashIdx = colonIdx + 3;
			var httpSection = HxOverrides.substr(path,0,lastSlashIdx);
			path = httpSection + StringTools.replace(HxOverrides.substr(path,lastSlashIdx,null),"//","/");
		} else {
			path = StringTools.replace(path,"//","/");
		}
		if(path.indexOf("./") > -1) {
			var split = path.split("/");
			var newPath = [];
			var _g = 0;
			var _g1 = split.length;
			while(_g < _g1) {
				var i = _g++;
				if(split[i] == "..") {
					if(i == 0 || newPath[i - 1] == "..") {
						newPath.push("..");
					} else {
						newPath.pop();
					}
				} else if(split[i] == ".") {
					if(i == 0) {
						newPath.push(".");
					}
				} else {
					newPath.push(split[i]);
				}
			}
			path = newPath.join("/");
		}
		return path;
	}
	,loadAudioBuffer_onComplete: function(id,audioBuffer) {
		this.cachedAudioBuffers.h[id] = audioBuffer;
		if(Object.prototype.hasOwnProperty.call(this.pathGroups.h,id)) {
			var pathGroup = this.pathGroups.h[id];
			var otherID = haxe_ds_StringMap.keysIterator(this.pathGroups.h);
			while(otherID.hasNext()) {
				var otherID1 = otherID.next();
				if(otherID1 == id) {
					continue;
				}
				var _g = 0;
				while(_g < pathGroup.length) {
					var path = pathGroup[_g];
					++_g;
					if(this.pathGroups.h[otherID1].indexOf(path) > -1) {
						this.cachedAudioBuffers.h[otherID1] = audioBuffer;
						break;
					}
				}
			}
		}
		this.__assetLoaded(id);
	}
	,loadAudioBuffer_onError: function(id,message) {
		if(message != null && message != "") {
			lime_utils_Log.warn("Could not load \"" + id + "\": " + Std.string(message),{ fileName : "lime/utils/AssetLibrary.hx", lineNumber : 865, className : "lime.utils.AssetLibrary", methodName : "loadAudioBuffer_onError"});
		} else {
			lime_utils_Log.warn("Could not load \"" + id + "\"",{ fileName : "lime/utils/AssetLibrary.hx", lineNumber : 869, className : "lime.utils.AssetLibrary", methodName : "loadAudioBuffer_onError"});
		}
		this.loadAudioBuffer_onComplete(id,new lime_media_AudioBuffer());
	}
	,loadBytes_onComplete: function(id,bytes) {
		this.cachedBytes.h[id] = bytes;
		this.__assetLoaded(id);
	}
	,loadFont_onComplete: function(id,font) {
		this.cachedFonts.h[id] = font;
		this.__assetLoaded(id);
	}
	,loadImage_onComplete: function(id,image) {
		this.cachedImages.h[id] = image;
		this.__assetLoaded(id);
	}
	,loadText_onComplete: function(id,text) {
		this.cachedText.h[id] = text;
		this.__assetLoaded(id);
	}
	,load_onError: function(id,message) {
		if(message != null && message != "") {
			this.promise.error("Error loading asset \"" + id + "\": " + Std.string(message));
		} else {
			this.promise.error("Error loading asset \"" + id + "\"");
		}
	}
	,load_onProgress: function(id,bytesLoaded,bytesTotal) {
		if(bytesLoaded > 0) {
			var size = this.sizes.h[id];
			var percent;
			if(bytesTotal > 0) {
				percent = bytesLoaded / bytesTotal;
				if(percent > 1) {
					percent = 1;
				}
				bytesLoaded = Math.floor(percent * size);
			} else if(bytesLoaded > size) {
				bytesLoaded = size;
			}
			if(Object.prototype.hasOwnProperty.call(this.bytesLoadedCache.h,id)) {
				var cache = this.bytesLoadedCache.h[id];
				if(bytesLoaded != cache) {
					this.bytesLoaded += bytesLoaded - cache;
				}
			} else {
				this.bytesLoaded += bytesLoaded;
			}
			this.bytesLoadedCache.h[id] = bytesLoaded;
			this.promise.progress(this.bytesLoaded,this.bytesTotal);
		}
	}
	,__class__: lime_utils_AssetLibrary
};
var lime_utils_AssetManifest = function() {
	this.assets = [];
	this.libraryArgs = [];
	this.version = 2;
};
$hxClasses["lime.utils.AssetManifest"] = lime_utils_AssetManifest;
lime_utils_AssetManifest.__name__ = "lime.utils.AssetManifest";
lime_utils_AssetManifest.fromBytes = function(bytes,rootPath) {
	if(bytes != null) {
		return lime_utils_AssetManifest.parse(bytes.getString(0,bytes.length),rootPath);
	} else {
		return null;
	}
};
lime_utils_AssetManifest.fromFile = function(path,rootPath) {
	path = lime_utils_AssetManifest.__resolvePath(path);
	rootPath = lime_utils_AssetManifest.__resolveRootPath(rootPath,path);
	if(path == null) {
		return null;
	}
	return lime_utils_AssetManifest.fromBytes(lime_utils_Bytes.fromFile(path),rootPath);
};
lime_utils_AssetManifest.loadFromBytes = function(bytes,rootPath) {
	return lime_app_Future.withValue(lime_utils_AssetManifest.fromBytes(bytes,rootPath));
};
lime_utils_AssetManifest.loadFromFile = function(path,rootPath) {
	path = lime_utils_AssetManifest.__resolvePath(path);
	rootPath = lime_utils_AssetManifest.__resolveRootPath(rootPath,path);
	if(path == null) {
		return null;
	}
	return lime_utils_Bytes.loadFromFile(path).then(function(bytes) {
		return lime_app_Future.withValue(lime_utils_AssetManifest.fromBytes(bytes,rootPath));
	});
};
lime_utils_AssetManifest.parse = function(data,rootPath) {
	if(data == null || data == "") {
		return null;
	}
	var manifestData = JSON.parse(data);
	var manifest = new lime_utils_AssetManifest();
	if(Object.prototype.hasOwnProperty.call(manifestData,"name")) {
		manifest.name = manifestData.name;
	}
	if(Object.prototype.hasOwnProperty.call(manifestData,"libraryType")) {
		manifest.libraryType = manifestData.libraryType;
	}
	if(Object.prototype.hasOwnProperty.call(manifestData,"libraryArgs")) {
		manifest.libraryArgs = manifestData.libraryArgs;
	}
	if(Object.prototype.hasOwnProperty.call(manifestData,"assets")) {
		var assets = manifestData.assets;
		if(Object.prototype.hasOwnProperty.call(manifestData,"version") && manifestData.version <= 2) {
			manifest.assets = haxe_Unserializer.run(assets);
		} else {
			manifest.assets = assets;
		}
	}
	if(Object.prototype.hasOwnProperty.call(manifestData,"rootPath")) {
		manifest.rootPath = manifestData.rootPath;
	}
	if(rootPath != null && rootPath != "") {
		if(manifest.rootPath == null || manifest.rootPath == "") {
			manifest.rootPath = rootPath;
		} else {
			manifest.rootPath = rootPath + "/" + manifest.rootPath;
		}
	}
	return manifest;
};
lime_utils_AssetManifest.__resolvePath = function(path) {
	if(path == null) {
		return null;
	}
	var queryIndex = path.indexOf("?");
	var basePath;
	if(queryIndex > -1) {
		basePath = HxOverrides.substr(path,0,queryIndex);
	} else {
		basePath = path;
	}
	basePath = StringTools.replace(basePath,"\\","/");
	while(StringTools.endsWith(basePath,"/")) basePath = HxOverrides.substr(basePath,0,basePath.length - 1);
	if(StringTools.endsWith(basePath,".bundle")) {
		if(queryIndex > -1) {
			return basePath + "/library.json" + HxOverrides.substr(path,queryIndex,null);
		} else {
			return basePath + "/library.json";
		}
	} else {
		return path;
	}
};
lime_utils_AssetManifest.__resolveRootPath = function(rootPath,path) {
	if(rootPath != null) {
		return rootPath;
	}
	var queryIndex = path.indexOf("?");
	if(queryIndex > -1) {
		rootPath = HxOverrides.substr(path,0,queryIndex);
	} else {
		rootPath = path;
	}
	rootPath = StringTools.replace(rootPath,"\\","/");
	while(StringTools.endsWith(rootPath,"/")) {
		if(rootPath == "/") {
			return rootPath;
		}
		rootPath = HxOverrides.substr(rootPath,0,rootPath.length - 1);
	}
	if(StringTools.endsWith(rootPath,".bundle")) {
		return rootPath;
	} else {
		return haxe_io_Path.directory(rootPath);
	}
};
lime_utils_AssetManifest.prototype = {
	serialize: function() {
		var manifestData = { };
		manifestData.version = this.version;
		manifestData.libraryType = this.libraryType;
		manifestData.libraryArgs = this.libraryArgs;
		manifestData.name = this.name;
		manifestData.assets = haxe_Serializer.run(this.assets);
		manifestData.rootPath = this.rootPath;
		return JSON.stringify(manifestData);
	}
	,__class__: lime_utils_AssetManifest
};
var lime_utils_Assets = function() { };
$hxClasses["lime.utils.Assets"] = lime_utils_Assets;
lime_utils_Assets.__name__ = "lime.utils.Assets";
lime_utils_Assets.exists = function(id,type) {
	if(type == null) {
		type = "BINARY";
	}
	var id1 = id;
	var colonIndex = id1.indexOf(":");
	var symbol_libraryName = id1.substring(0,colonIndex);
	var symbol_symbolName = id1.substring(colonIndex + 1);
	var symbol_library = lime_utils_Assets.getLibrary(symbol_libraryName);
	if(symbol_library != null) {
		return symbol_library.exists(symbol_symbolName,type);
	}
	return false;
};
lime_utils_Assets.getAsset = function(id,type,useCache) {
	if(useCache && lime_utils_Assets.cache.enabled) {
		switch(type) {
		case "BINARY":case "TEXT":
			useCache = false;
			break;
		case "FONT":
			var font = lime_utils_Assets.cache.font.h[id];
			if(font != null) {
				return font;
			}
			break;
		case "IMAGE":
			var image = lime_utils_Assets.cache.image.h[id];
			if(lime_utils_Assets.isValidImage(image)) {
				return image;
			}
			break;
		case "MUSIC":case "SOUND":
			var audio = lime_utils_Assets.cache.audio.h[id];
			if(lime_utils_Assets.isValidAudio(audio)) {
				return audio;
			}
			break;
		case "TEMPLATE":
			throw haxe_Exception.thrown("Not sure how to get template: " + id);
		default:
			return null;
		}
	}
	var id1 = id;
	var colonIndex = id1.indexOf(":");
	var symbol_libraryName = id1.substring(0,colonIndex);
	var symbol_symbolName = id1.substring(colonIndex + 1);
	var symbol_library = lime_utils_Assets.getLibrary(symbol_libraryName);
	if(symbol_library != null) {
		if(symbol_library.exists(symbol_symbolName,type)) {
			if(symbol_library.isLocal(symbol_symbolName,type)) {
				var asset = symbol_library.getAsset(symbol_symbolName,type);
				if(useCache && lime_utils_Assets.cache.enabled) {
					lime_utils_Assets.cache.set(id,type,asset);
				}
				return asset;
			} else {
				lime_utils_Log.error(type + " asset \"" + id + "\" exists, but only asynchronously",{ fileName : "lime/utils/Assets.hx", lineNumber : 133, className : "lime.utils.Assets", methodName : "getAsset"});
			}
		} else {
			lime_utils_Log.error("There is no " + type + " asset with an ID of \"" + id + "\"",{ fileName : "lime/utils/Assets.hx", lineNumber : 138, className : "lime.utils.Assets", methodName : "getAsset"});
		}
	} else {
		lime_utils_Log.error(lime_utils_Assets.__libraryNotFound(symbol_libraryName),{ fileName : "lime/utils/Assets.hx", lineNumber : 143, className : "lime.utils.Assets", methodName : "getAsset"});
	}
	return null;
};
lime_utils_Assets.getAudioBuffer = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.getAsset(id,"SOUND",useCache);
};
lime_utils_Assets.getBytes = function(id) {
	return lime_utils_Assets.getAsset(id,"BINARY",false);
};
lime_utils_Assets.getFont = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.getAsset(id,"FONT",useCache);
};
lime_utils_Assets.getImage = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.getAsset(id,"IMAGE",useCache);
};
lime_utils_Assets.getLibrary = function(name) {
	if(name == null || name == "") {
		name = "default";
	}
	return lime_utils_Assets.libraries.h[name];
};
lime_utils_Assets.getPath = function(id) {
	var id1 = id;
	var colonIndex = id1.indexOf(":");
	var symbol_libraryName = id1.substring(0,colonIndex);
	var symbol_symbolName = id1.substring(colonIndex + 1);
	var symbol_library = lime_utils_Assets.getLibrary(symbol_libraryName);
	if(symbol_library != null) {
		if(symbol_library.exists(symbol_symbolName,null)) {
			return symbol_library.getPath(symbol_symbolName);
		} else {
			lime_utils_Log.error("There is no asset with an ID of \"" + id + "\"",{ fileName : "lime/utils/Assets.hx", lineNumber : 224, className : "lime.utils.Assets", methodName : "getPath"});
		}
	} else {
		lime_utils_Log.error(lime_utils_Assets.__libraryNotFound(symbol_libraryName),{ fileName : "lime/utils/Assets.hx", lineNumber : 229, className : "lime.utils.Assets", methodName : "getPath"});
	}
	return null;
};
lime_utils_Assets.getText = function(id) {
	return lime_utils_Assets.getAsset(id,"TEXT",false);
};
lime_utils_Assets.hasLibrary = function(name) {
	if(name == null || name == "") {
		name = "default";
	}
	return Object.prototype.hasOwnProperty.call(lime_utils_Assets.libraries.h,name);
};
lime_utils_Assets.isLocal = function(id,type,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	if(useCache && lime_utils_Assets.cache.enabled) {
		if(lime_utils_Assets.cache.exists(id,type)) {
			return true;
		}
	}
	var id1 = id;
	var colonIndex = id1.indexOf(":");
	var symbol_libraryName = id1.substring(0,colonIndex);
	var symbol_symbolName = id1.substring(colonIndex + 1);
	var symbol_library = lime_utils_Assets.getLibrary(symbol_libraryName);
	if(symbol_library != null) {
		return symbol_library.isLocal(symbol_symbolName,type);
	} else {
		return false;
	}
};
lime_utils_Assets.isValidAudio = function(buffer) {
	return buffer != null;
};
lime_utils_Assets.isValidImage = function(image) {
	if(image != null) {
		return image.buffer != null;
	} else {
		return false;
	}
};
lime_utils_Assets.list = function(type) {
	var items = [];
	var library = haxe_ds_StringMap.valueIterator(lime_utils_Assets.libraries.h);
	while(library.hasNext()) {
		var library1 = library.next();
		var libraryItems = library1.list(type);
		if(libraryItems != null) {
			items = items.concat(libraryItems);
		}
	}
	return items;
};
lime_utils_Assets.loadAsset = function(id,type,useCache) {
	if(useCache && lime_utils_Assets.cache.enabled) {
		switch(type) {
		case "BINARY":case "TEXT":
			useCache = false;
			break;
		case "FONT":
			var font = lime_utils_Assets.cache.font.h[id];
			if(font != null) {
				return lime_app_Future.withValue(font);
			}
			break;
		case "IMAGE":
			var image = lime_utils_Assets.cache.image.h[id];
			if(lime_utils_Assets.isValidImage(image)) {
				return lime_app_Future.withValue(image);
			}
			break;
		case "MUSIC":case "SOUND":
			var audio = lime_utils_Assets.cache.audio.h[id];
			if(lime_utils_Assets.isValidAudio(audio)) {
				return lime_app_Future.withValue(audio);
			}
			break;
		case "TEMPLATE":
			throw haxe_Exception.thrown("Not sure how to get template: " + id);
		default:
			return null;
		}
	}
	var id1 = id;
	var colonIndex = id1.indexOf(":");
	var symbol_libraryName = id1.substring(0,colonIndex);
	var symbol_symbolName = id1.substring(colonIndex + 1);
	var symbol_library = lime_utils_Assets.getLibrary(symbol_libraryName);
	if(symbol_library != null) {
		if(symbol_library.exists(symbol_symbolName,type)) {
			var future = symbol_library.loadAsset(symbol_symbolName,type);
			if(useCache && lime_utils_Assets.cache.enabled) {
				future.onComplete(function(asset) {
					lime_utils_Assets.cache.set(id,type,asset);
				});
			}
			return future;
		} else {
			return lime_app_Future.withError("There is no " + type + " asset with an ID of \"" + id + "\"");
		}
	} else {
		return lime_app_Future.withError(lime_utils_Assets.__libraryNotFound(symbol_libraryName));
	}
};
lime_utils_Assets.loadAudioBuffer = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.loadAsset(id,"SOUND",useCache);
};
lime_utils_Assets.loadBytes = function(id) {
	return lime_utils_Assets.loadAsset(id,"BINARY",false);
};
lime_utils_Assets.loadFont = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.loadAsset(id,"FONT",useCache);
};
lime_utils_Assets.loadImage = function(id,useCache) {
	if(useCache == null) {
		useCache = true;
	}
	return lime_utils_Assets.loadAsset(id,"IMAGE",useCache);
};
lime_utils_Assets.loadLibrary = function(id) {
	var promise = new lime_app_Promise();
	var library = lime_utils_Assets.getLibrary(id);
	if(library != null) {
		return library.load();
	}
	var path = id;
	var rootPath = null;
	if(Object.prototype.hasOwnProperty.call(lime_utils_Assets.bundlePaths.h,id)) {
		lime_utils_AssetBundle.loadFromFile(lime_utils_Assets.bundlePaths.h[id]).onComplete(function(bundle) {
			if(bundle == null) {
				promise.error("Cannot load bundle for library \"" + id + "\"");
				return;
			}
			var library = lime_utils_AssetLibrary.fromBundle(bundle);
			if(library == null) {
				promise.error("Cannot open library \"" + id + "\"");
			} else {
				lime_utils_Assets.libraries.h[id] = library;
				library.onChange.add(($_=lime_utils_Assets.onChange,$bind($_,$_.dispatch)));
				promise.completeWith(library.load());
			}
		}).onError(function(_) {
			promise.error("There is no asset library with an ID of \"" + id + "\"");
		});
	} else {
		if(Object.prototype.hasOwnProperty.call(lime_utils_Assets.libraryPaths.h,id)) {
			path = lime_utils_Assets.libraryPaths.h[id];
			rootPath = haxe_io_Path.directory(path);
		} else {
			if(StringTools.endsWith(path,".bundle")) {
				rootPath = path;
				path += "/library.json";
			} else {
				rootPath = haxe_io_Path.directory(path);
			}
			path = lime_utils_Assets.__cacheBreak(path);
		}
		lime_utils_AssetManifest.loadFromFile(path,rootPath).onComplete(function(manifest) {
			if(manifest == null) {
				promise.error("Cannot parse asset manifest for library \"" + id + "\"");
				return;
			}
			var library = lime_utils_AssetLibrary.fromManifest(manifest);
			if(library == null) {
				promise.error("Cannot open library \"" + id + "\"");
			} else {
				lime_utils_Assets.libraries.h[id] = library;
				library.onChange.add(($_=lime_utils_Assets.onChange,$bind($_,$_.dispatch)));
				promise.completeWith(library.load());
			}
		}).onError(function(_) {
			promise.error("There is no asset library with an ID of \"" + id + "\"");
		});
	}
	return promise.future;
};
lime_utils_Assets.loadText = function(id) {
	return lime_utils_Assets.loadAsset(id,"TEXT",false);
};
lime_utils_Assets.registerLibrary = function(name,library) {
	if(Object.prototype.hasOwnProperty.call(lime_utils_Assets.libraries.h,name)) {
		if(lime_utils_Assets.libraries.h[name] == library) {
			return;
		} else {
			lime_utils_Assets.unloadLibrary(name);
		}
	}
	if(library != null) {
		library.onChange.add(lime_utils_Assets.library_onChange);
	}
	lime_utils_Assets.libraries.h[name] = library;
};
lime_utils_Assets.unloadLibrary = function(name) {
	if(name == null || name == "") {
		name = "default";
	}
	var library = lime_utils_Assets.libraries.h[name];
	if(library != null) {
		lime_utils_Assets.cache.clear(name + ":");
		library.onChange.remove(lime_utils_Assets.library_onChange);
		library.unload();
	}
	var _this = lime_utils_Assets.libraries;
	if(Object.prototype.hasOwnProperty.call(_this.h,name)) {
		delete(_this.h[name]);
	}
};
lime_utils_Assets.__cacheBreak = function(path) {
	if(lime_utils_Assets.cache.version > 0) {
		if(path.indexOf("?") > -1) {
			path += "&" + lime_utils_Assets.cache.version;
		} else {
			path += "?" + lime_utils_Assets.cache.version;
		}
	}
	return path;
};
lime_utils_Assets.__libraryNotFound = function(name) {
	if(name == null || name == "") {
		name = "default";
	}
	if(lime_app_Application.current != null && lime_app_Application.current.__preloader != null && !lime_app_Application.current.__preloader.complete) {
		return "There is no asset library named \"" + name + "\", or it is not yet preloaded";
	} else {
		return "There is no asset library named \"" + name + "\"";
	}
};
lime_utils_Assets.library_onChange = function() {
	lime_utils_Assets.cache.clear();
	lime_utils_Assets.onChange.dispatch();
};
var lime_utils__$Assets_LibrarySymbol = function(id) {
	var colonIndex = id.indexOf(":");
	this.libraryName = id.substring(0,colonIndex);
	this.symbolName = id.substring(colonIndex + 1);
	this.library = lime_utils_Assets.getLibrary(this.libraryName);
};
$hxClasses["lime.utils._Assets.LibrarySymbol"] = lime_utils__$Assets_LibrarySymbol;
lime_utils__$Assets_LibrarySymbol.__name__ = "lime.utils._Assets.LibrarySymbol";
lime_utils__$Assets_LibrarySymbol.prototype = {
	isLocal: function(type) {
		return this.library.isLocal(this.symbolName,type);
	}
	,exists: function(type) {
		return this.library.exists(this.symbolName,type);
	}
	,__class__: lime_utils__$Assets_LibrarySymbol
};
var lime_utils_BytePointer = {};
lime_utils_BytePointer._new = function(bytes,offset) {
	if(offset == null) {
		offset = 0;
	}
	var this1 = new lime_utils_BytePointerData(bytes,offset);
	return this1;
};
lime_utils_BytePointer.set = function(this1,bytes,bufferView,buffer,offset) {
	if(buffer != null) {
		bytes = haxe_io_Bytes.ofData(buffer);
	}
	if(bytes != null || bufferView == null) {
		this1.bytes = bytes;
		this1.offset = offset != null ? offset : 0;
	} else {
		this1.bytes = haxe_io_Bytes.ofData(bufferView.buffer);
		this1.offset = offset != null ? bufferView.byteOffset + offset : bufferView.byteOffset;
	}
};
lime_utils_BytePointer.__arrayGet = function(this1,index) {
	if(this1.bytes != null) {
		return this1.bytes.b[index + this1.offset];
	} else {
		return 0;
	}
};
lime_utils_BytePointer.__arraySet = function(this1,index,value) {
	if(this1.bytes == null) {
		this1.bytes.b[index + this1.offset] = value & 255;
	}
	return value;
};
lime_utils_BytePointer.fromArrayBufferView = function(arrayBufferView) {
	if(arrayBufferView == null) {
		return null;
	}
	return new lime_utils_BytePointerData(haxe_io_Bytes.ofData(arrayBufferView.buffer),arrayBufferView.byteOffset);
};
lime_utils_BytePointer.fromArrayBuffer = function(buffer) {
	if(buffer == null) {
		return null;
	}
	return new lime_utils_BytePointerData(haxe_io_Bytes.ofData(buffer),0);
};
lime_utils_BytePointer.fromBytes = function(bytes) {
	return new lime_utils_BytePointerData(bytes,0);
};
lime_utils_BytePointer.fromBytesData = function(bytesData) {
	if(bytesData == null) {
		return new lime_utils_BytePointerData(null,0);
	} else {
		return new lime_utils_BytePointerData(haxe_io_Bytes.ofData(bytesData),0);
	}
};
lime_utils_BytePointer.fromFile = function(path) {
	return new lime_utils_BytePointerData(lime_utils_Bytes.fromFile(path),0);
};
lime_utils_BytePointer.fromLimeBytes = function(bytes) {
	return new lime_utils_BytePointerData(bytes,0);
};
lime_utils_BytePointer.toUInt8Array = function(bytePointer) {
	var elements = null;
	var array = null;
	var vector = null;
	var view = null;
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 8 | 0;
	var len = null;
	if(byteoffset == null) {
		byteoffset = 0;
	}
	var this1;
	if(elements != null) {
		this1 = new Uint8Array(elements);
	} else if(array != null) {
		this1 = new Uint8Array(array);
	} else if(vector != null) {
		this1 = new Uint8Array(vector.__array);
	} else if(view != null) {
		this1 = new Uint8Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this1 = new Uint8Array(buffer,byteoffset);
		} else {
			this1 = new Uint8Array(buffer,byteoffset,len);
		}
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils_BytePointer.toUInt8ClampedArray = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var elements = null;
	var array = null;
	var vector = null;
	var view = null;
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 8 | 0;
	var len = null;
	if(byteoffset == null) {
		byteoffset = 0;
	}
	var this1;
	if(elements != null) {
		this1 = new Uint8ClampedArray(elements);
	} else if(array != null) {
		this1 = new Uint8ClampedArray(array);
	} else if(vector != null) {
		this1 = new Uint8ClampedArray(vector.__array);
	} else if(view != null) {
		this1 = new Uint8ClampedArray(view);
	} else if(buffer != null) {
		if(len == null) {
			this1 = new Uint8ClampedArray(buffer,byteoffset);
		} else {
			this1 = new Uint8ClampedArray(buffer,byteoffset,len);
		}
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils_BytePointer.toInt8Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var elements = null;
	var array = null;
	var vector = null;
	var view = null;
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 8 | 0;
	var len = null;
	if(byteoffset == null) {
		byteoffset = 0;
	}
	var this1;
	if(elements != null) {
		this1 = new Int8Array(elements);
	} else if(array != null) {
		this1 = new Int8Array(array);
	} else if(vector != null) {
		this1 = new Int8Array(vector.__array);
	} else if(view != null) {
		this1 = new Int8Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this1 = new Int8Array(buffer,byteoffset);
		} else {
			this1 = new Int8Array(buffer,byteoffset,len);
		}
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils_BytePointer.toUInt16Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var elements = null;
	var array = null;
	var vector = null;
	var view = null;
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 16 | 0;
	var len = null;
	if(byteoffset == null) {
		byteoffset = 0;
	}
	var this1;
	if(elements != null) {
		this1 = new Uint16Array(elements);
	} else if(array != null) {
		this1 = new Uint16Array(array);
	} else if(vector != null) {
		this1 = new Uint16Array(vector.__array);
	} else if(view != null) {
		this1 = new Uint16Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this1 = new Uint16Array(buffer,byteoffset);
		} else {
			this1 = new Uint16Array(buffer,byteoffset,len);
		}
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils_BytePointer.toInt16Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var elements = null;
	var array = null;
	var vector = null;
	var view = null;
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 16 | 0;
	var len = null;
	if(byteoffset == null) {
		byteoffset = 0;
	}
	var this1;
	if(elements != null) {
		this1 = new Int16Array(elements);
	} else if(array != null) {
		this1 = new Int16Array(array);
	} else if(vector != null) {
		this1 = new Int16Array(vector.__array);
	} else if(view != null) {
		this1 = new Int16Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this1 = new Int16Array(buffer,byteoffset);
		} else {
			this1 = new Int16Array(buffer,byteoffset,len);
		}
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils_BytePointer.toUInt32Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var elements = null;
	var array = null;
	var vector = null;
	var view = null;
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 32 | 0;
	var len = null;
	if(byteoffset == null) {
		byteoffset = 0;
	}
	var this1;
	if(elements != null) {
		this1 = new Uint32Array(elements);
	} else if(array != null) {
		this1 = new Uint32Array(array);
	} else if(vector != null) {
		this1 = new Uint32Array(vector.__array);
	} else if(view != null) {
		this1 = new Uint32Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this1 = new Uint32Array(buffer,byteoffset);
		} else {
			this1 = new Uint32Array(buffer,byteoffset,len);
		}
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils_BytePointer.toInt32Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var elements = null;
	var array = null;
	var vector = null;
	var view = null;
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 32 | 0;
	var len = null;
	if(byteoffset == null) {
		byteoffset = 0;
	}
	var this1;
	if(elements != null) {
		this1 = new Int32Array(elements);
	} else if(array != null) {
		this1 = new Int32Array(array);
	} else if(vector != null) {
		this1 = new Int32Array(vector.__array);
	} else if(view != null) {
		this1 = new Int32Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this1 = new Int32Array(buffer,byteoffset);
		} else {
			this1 = new Int32Array(buffer,byteoffset,len);
		}
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils_BytePointer.toFloat32Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var elements = null;
	var array = null;
	var vector = null;
	var view = null;
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 32 | 0;
	var len = null;
	if(byteoffset == null) {
		byteoffset = 0;
	}
	var this1;
	if(elements != null) {
		this1 = new Float32Array(elements);
	} else if(array != null) {
		this1 = new Float32Array(array);
	} else if(vector != null) {
		this1 = new Float32Array(vector.__array);
	} else if(view != null) {
		this1 = new Float32Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this1 = new Float32Array(buffer,byteoffset);
		} else {
			this1 = new Float32Array(buffer,byteoffset,len);
		}
	} else {
		this1 = null;
	}
	return this1;
};
lime_utils_BytePointer.toFloat64Array = function(bytePointer) {
	if(bytePointer == null || bytePointer.bytes == null) {
		return null;
	}
	var elements = null;
	var array = null;
	var vector = null;
	var view = null;
	var buffer = bytePointer.bytes.b.bufferValue;
	var byteoffset = bytePointer.offset / 64 | 0;
	var len = null;
	if(byteoffset == null) {
		byteoffset = 0;
	}
	var this1;
	if(elements != null) {
		this1 = new Float64Array(elements);
	} else if(array != null) {
		this1 = new Float64Array(array);
	} else if(vector != null) {
		this1 = new Float64Array(vector.__array);
	} else if(view != null) {
		this1 = new Float64Array(view);
	} else if(buffer != null) {
		if(len == null) {
			this1 = new Float64Array(buffer,byteoffset);
		} else {
			this1 = new Float64Array(buffer,byteoffset,len);
		}
	} else {
		this1 = null;
	}
	return this1;
};
var lime_utils_BytePointerData = function(bytes,offset) {
	this.bytes = bytes;
	this.offset = offset;
};
$hxClasses["lime.utils.BytePointerData"] = lime_utils_BytePointerData;
lime_utils_BytePointerData.__name__ = "lime.utils.BytePointerData";
lime_utils_BytePointerData.prototype = {
	__class__: lime_utils_BytePointerData
};
var lime_utils_Bytes = {};
lime_utils_Bytes._new = function(length,bytesData) {
	var this1 = new haxe_io_Bytes(bytesData);
	return this1;
};
lime_utils_Bytes.alloc = function(length) {
	return new haxe_io_Bytes(new ArrayBuffer(length));
};
lime_utils_Bytes.compress = function(this1,algorithm) {
	switch(algorithm._hx_index) {
	case 0:
		return lime__$internal_format_Deflate.compress(this1);
	case 1:
		return lime__$internal_format_GZip.compress(this1);
	case 2:
		return lime__$internal_format_LZMA.compress(this1);
	case 3:
		return lime__$internal_format_Zlib.compress(this1);
	}
};
lime_utils_Bytes.decompress = function(this1,algorithm) {
	switch(algorithm._hx_index) {
	case 0:
		return lime__$internal_format_Deflate.decompress(this1);
	case 1:
		return lime__$internal_format_GZip.decompress(this1);
	case 2:
		return lime__$internal_format_LZMA.decompress(this1);
	case 3:
		return lime__$internal_format_Zlib.decompress(this1);
	}
};
lime_utils_Bytes.fastGet = function(b,pos) {
	return b.bytes[pos];
};
lime_utils_Bytes.fromBytes = function(bytes) {
	if(bytes == null) {
		return null;
	}
	return lime_utils_Bytes._new(bytes.length,bytes.b.bufferValue);
};
lime_utils_Bytes.fromFile = function(path) {
	return null;
};
lime_utils_Bytes.loadFromBytes = function(bytes) {
	return lime_app_Future.withValue(lime_utils_Bytes.fromBytes(bytes));
};
lime_utils_Bytes.loadFromFile = function(path) {
	var request = new lime_net__$HTTPRequest_$lime_$utils_$Bytes();
	return request.load(path);
};
lime_utils_Bytes.ofData = function(b) {
	var bytes = haxe_io_Bytes.ofData(b);
	return lime_utils_Bytes._new(bytes.length,bytes.b.bufferValue);
};
lime_utils_Bytes.ofString = function(s) {
	var bytes = haxe_io_Bytes.ofString(s);
	return lime_utils_Bytes._new(bytes.length,bytes.b.bufferValue);
};
var lime_utils_CompressionAlgorithm = $hxEnums["lime.utils.CompressionAlgorithm"] = { __ename__ : "lime.utils.CompressionAlgorithm", __constructs__ : ["DEFLATE","GZIP","LZMA","ZLIB"]
	,DEFLATE: {_hx_index:0,__enum__:"lime.utils.CompressionAlgorithm",toString:$estr}
	,GZIP: {_hx_index:1,__enum__:"lime.utils.CompressionAlgorithm",toString:$estr}
	,LZMA: {_hx_index:2,__enum__:"lime.utils.CompressionAlgorithm",toString:$estr}
	,ZLIB: {_hx_index:3,__enum__:"lime.utils.CompressionAlgorithm",toString:$estr}
};
var lime_utils_DataPointer = {};
lime_utils_DataPointer._new = function(data) {
	var this1 = data;
	return this1;
};
lime_utils_DataPointer.fromFloat = function(value) {
	return value;
};
lime_utils_DataPointer.fromBytesPointer = function(pointer) {
	return lime_utils_DataPointer.fromFloat(0);
};
lime_utils_DataPointer.fromArrayBufferView = function(arrayBufferView) {
	return lime_utils_DataPointer.fromFloat(0);
};
lime_utils_DataPointer.fromArrayBuffer = function(buffer) {
	return lime_utils_DataPointer.fromFloat(0);
};
lime_utils_DataPointer.fromBytes = function(bytes) {
	return lime_utils_DataPointer.fromFloat(0);
};
lime_utils_DataPointer.fromBytesData = function(bytesData) {
	return lime_utils_DataPointer.fromFloat(0);
};
lime_utils_DataPointer.fromLimeBytes = function(bytes) {
	return lime_utils_DataPointer.fromBytes(bytes);
};
lime_utils_DataPointer.fromCFFIPointer = function(pointer) {
	return lime_utils_DataPointer.fromFloat(0);
};
lime_utils_DataPointer.fromFile = function(path) {
	return lime_utils_DataPointer.fromFloat(0);
};
lime_utils_DataPointer.__withOffset = function(data,offset) {
	return lime_utils_DataPointer.fromFloat(0);
};
lime_utils_DataPointer.equals = function(a,b) {
	return a == b;
};
lime_utils_DataPointer.equalsPointer = function(a,b) {
	return a == b;
};
lime_utils_DataPointer.greaterThan = function(a,b) {
	return a > b;
};
lime_utils_DataPointer.greaterThanPointer = function(a,b) {
	return lime_system_CFFIPointer.get(a) > lime_system_CFFIPointer.get(b);
};
lime_utils_DataPointer.greaterThanOrEqual = function(a,b) {
	return a >= b;
};
lime_utils_DataPointer.greaterThanOrEqualPointer = function(a,b) {
	return lime_system_CFFIPointer.get(a) >= lime_system_CFFIPointer.get(b);
};
lime_utils_DataPointer.lessThan = function(a,b) {
	return a < b;
};
lime_utils_DataPointer.lessThanPointer = function(a,b) {
	return lime_system_CFFIPointer.get(a) < lime_system_CFFIPointer.get(b);
};
lime_utils_DataPointer.lessThanOrEqual = function(a,b) {
	return a <= b;
};
lime_utils_DataPointer.lessThanOrEqualPointer = function(a,b) {
	return lime_system_CFFIPointer.get(a) <= lime_system_CFFIPointer.get(b);
};
lime_utils_DataPointer.notEquals = function(a,b) {
	return a != b;
};
lime_utils_DataPointer.notEqualsPointer = function(a,b) {
	return a != b;
};
lime_utils_DataPointer.plus = function(a,b) {
	return lime_utils_DataPointer.__withOffset(a,b);
};
lime_utils_DataPointer.plusPointer = function(a,b) {
	return lime_utils_DataPointer.__withOffset(a,b | 0);
};
lime_utils_DataPointer.minus = function(a,b) {
	return lime_utils_DataPointer.__withOffset(a,-b);
};
lime_utils_DataPointer.minusPointer = function(a,b) {
	return lime_utils_DataPointer.__withOffset(a,-(b | 0));
};
var lime_utils_Float32Array = {};
lime_utils_Float32Array.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils_Float32Array.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Float32Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Float32Array(bytes.b.bufferValue,byteOffset);
	}
	return new Float32Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils_Float32Array.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils_Float32Array.toString = function(this1) {
	if(this1 != null) {
		return "Float32Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils_Float64Array = {};
lime_utils_Float64Array.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils_Float64Array.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Float64Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Float64Array(bytes.b.bufferValue,byteOffset);
	}
	return new Float64Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils_Float64Array.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils_Float64Array.toString = function(this1) {
	if(this1 != null) {
		return "Float64Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils_Int16Array = {};
lime_utils_Int16Array.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils_Int16Array.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Int16Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Int16Array(bytes.b.bufferValue,byteOffset);
	}
	return new Int16Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils_Int16Array.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils_Int16Array.toString = function(this1) {
	if(this1 != null) {
		return "Int16Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils_Int32Array = {};
lime_utils_Int32Array.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils_Int32Array.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Int32Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Int32Array(bytes.b.bufferValue,byteOffset);
	}
	return new Int32Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils_Int32Array.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils_Int32Array.toString = function(this1) {
	if(this1 != null) {
		return "Int32Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils_Int8Array = {};
lime_utils_Int8Array.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils_Int8Array.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	return new Int8Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils_Int8Array.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils_Int8Array.toString = function(this1) {
	if(this1 != null) {
		return "Int8Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils_Log = function() { };
$hxClasses["lime.utils.Log"] = lime_utils_Log;
lime_utils_Log.__name__ = "lime.utils.Log";
lime_utils_Log.debug = function(message,info) {
	if(lime_utils_Log.level >= 4) {
		console.debug("[" + info.className + "] " + Std.string(message));
	}
};
lime_utils_Log.error = function(message,info) {
	if(lime_utils_Log.level >= 1) {
		var message1 = "[" + info.className + "] ERROR: " + Std.string(message);
		if(lime_utils_Log.throwErrors) {
			throw haxe_Exception.thrown(message1);
		} else {
			console.error(message1);
		}
	}
};
lime_utils_Log.info = function(message,info) {
	if(lime_utils_Log.level >= 3) {
		console.info("[" + info.className + "] " + Std.string(message));
	}
};
lime_utils_Log.print = function(message) {
	console.log(message);
};
lime_utils_Log.println = function(message) {
	console.log(message);
};
lime_utils_Log.verbose = function(message,info) {
	if(lime_utils_Log.level >= 5) {
		var message1 = "[" + info.className + "] " + Std.string(message);
		console.log(message1);
	}
};
lime_utils_Log.warn = function(message,info) {
	if(lime_utils_Log.level >= 2) {
		console.warn("[" + info.className + "] WARNING: " + Std.string(message));
	}
};
var lime_utils_LogLevel = {};
lime_utils_LogLevel.gt = function(a,b) {
	return a > b;
};
lime_utils_LogLevel.gte = function(a,b) {
	return a >= b;
};
lime_utils_LogLevel.lt = function(a,b) {
	return a < b;
};
lime_utils_LogLevel.lte = function(a,b) {
	return a <= b;
};
var lime_utils_Preloader = function() {
	this.bytesTotalCache = new haxe_ds_StringMap();
	this.bytesLoadedCache2 = new haxe_ds_StringMap();
	this.bytesLoadedCache = new haxe_ds_ObjectMap();
	this.onProgress = new lime_app__$Event_$Int_$Int_$Void();
	this.onComplete = new lime_app__$Event_$Void_$Void();
	this.bytesLoaded = 0;
	this.bytesTotal = 0;
	this.libraries = [];
	this.libraryNames = [];
	this.onProgress.add($bind(this,this.update));
};
$hxClasses["lime.utils.Preloader"] = lime_utils_Preloader;
lime_utils_Preloader.__name__ = "lime.utils.Preloader";
lime_utils_Preloader.prototype = {
	addLibrary: function(library) {
		this.libraries.push(library);
	}
	,addLibraryName: function(name) {
		if(this.libraryNames.indexOf(name) == -1) {
			this.libraryNames.push(name);
		}
	}
	,load: function() {
		var _gthis = this;
		var _g = 0;
		var _g1 = this.libraries;
		while(_g < _g1.length) {
			var library = _g1[_g];
			++_g;
			this.bytesTotal += library.bytesTotal;
		}
		this.loadedLibraries = -1;
		this.preloadStarted = false;
		var _g = 0;
		var _g1 = this.libraries;
		while(_g < _g1.length) {
			var library = [_g1[_g]];
			++_g;
			lime_utils_Log.verbose("Preloading asset library",{ fileName : "lime/utils/Preloader.hx", lineNumber : 132, className : "lime.utils.Preloader", methodName : "load"});
			library[0].load().onProgress((function(library) {
				return function(loaded,total) {
					if(_gthis.bytesLoadedCache.h.__keys__[library[0].__id__] == null) {
						_gthis.bytesLoaded += loaded;
					} else {
						_gthis.bytesLoaded += loaded - _gthis.bytesLoadedCache.h[library[0].__id__];
					}
					_gthis.bytesLoadedCache.set(library[0],loaded);
					if(!_gthis.simulateProgress) {
						_gthis.onProgress.dispatch(_gthis.bytesLoaded,_gthis.bytesTotal);
					}
				};
			})(library)).onComplete((function(library) {
				return function(_) {
					if(_gthis.bytesLoadedCache.h.__keys__[library[0].__id__] == null) {
						_gthis.bytesLoaded += library[0].bytesTotal;
					} else {
						_gthis.bytesLoaded += library[0].bytesTotal - _gthis.bytesLoadedCache.h[library[0].__id__];
					}
					_gthis.loadedAssetLibrary();
				};
			})(library)).onError((function() {
				return function(e) {
					lime_utils_Log.error(e,{ fileName : "lime/utils/Preloader.hx", lineNumber : 168, className : "lime.utils.Preloader", methodName : "load"});
				};
			})());
		}
		var _g = 0;
		var _g1 = this.libraryNames;
		while(_g < _g1.length) {
			var name = _g1[_g];
			++_g;
			this.bytesTotal += 200;
		}
		this.loadedLibraries++;
		this.preloadStarted = true;
		this.updateProgress();
	}
	,loadedAssetLibrary: function(name) {
		this.loadedLibraries++;
		var current = this.loadedLibraries;
		if(!this.preloadStarted) {
			++current;
		}
		var totalLibraries = this.libraries.length + this.libraryNames.length;
		if(name != null) {
			lime_utils_Log.verbose("Loaded asset library: " + name + " [" + current + "/" + totalLibraries + "]",{ fileName : "lime/utils/Preloader.hx", lineNumber : 195, className : "lime.utils.Preloader", methodName : "loadedAssetLibrary"});
		} else {
			lime_utils_Log.verbose("Loaded asset library [" + current + "/" + totalLibraries + "]",{ fileName : "lime/utils/Preloader.hx", lineNumber : 199, className : "lime.utils.Preloader", methodName : "loadedAssetLibrary"});
		}
		this.updateProgress();
	}
	,start: function() {
		if(this.complete || this.simulateProgress || !this.preloadComplete) {
			return;
		}
		this.complete = true;
		this.onComplete.dispatch();
	}
	,update: function(loaded,total) {
	}
	,updateProgress: function() {
		var _gthis = this;
		if(!this.simulateProgress) {
			this.onProgress.dispatch(this.bytesLoaded,this.bytesTotal);
		}
		if(this.loadedLibraries == this.libraries.length && !this.initLibraryNames) {
			this.initLibraryNames = true;
			var _g = 0;
			var _g1 = this.libraryNames;
			while(_g < _g1.length) {
				var name = [_g1[_g]];
				++_g;
				lime_utils_Log.verbose("Preloading asset library: " + name[0],{ fileName : "lime/utils/Preloader.hx", lineNumber : 236, className : "lime.utils.Preloader", methodName : "updateProgress"});
				lime_utils_Assets.loadLibrary(name[0]).onProgress((function(name) {
					return function(loaded,total) {
						if(total > 0) {
							if(!Object.prototype.hasOwnProperty.call(_gthis.bytesTotalCache.h,name[0])) {
								_gthis.bytesTotalCache.h[name[0]] = total;
								_gthis.bytesTotal += total - 200;
							}
							if(loaded > total) {
								loaded = total;
							}
							if(!Object.prototype.hasOwnProperty.call(_gthis.bytesLoadedCache2.h,name[0])) {
								_gthis.bytesLoaded += loaded;
							} else {
								_gthis.bytesLoaded += loaded - _gthis.bytesLoadedCache2.h[name[0]];
							}
							_gthis.bytesLoadedCache2.h[name[0]] = loaded;
							if(!_gthis.simulateProgress) {
								_gthis.onProgress.dispatch(_gthis.bytesLoaded,_gthis.bytesTotal);
							}
						}
					};
				})(name)).onComplete((function(name) {
					return function(library) {
						var total = 200;
						if(Object.prototype.hasOwnProperty.call(_gthis.bytesTotalCache.h,name[0])) {
							total = _gthis.bytesTotalCache.h[name[0]];
						}
						if(!Object.prototype.hasOwnProperty.call(_gthis.bytesLoadedCache2.h,name[0])) {
							_gthis.bytesLoaded += total;
						} else {
							_gthis.bytesLoaded += total - _gthis.bytesLoadedCache2.h[name[0]];
						}
						_gthis.loadedAssetLibrary(name[0]);
					};
				})(name)).onError((function() {
					return function(e) {
						lime_utils_Log.error(e,{ fileName : "lime/utils/Preloader.hx", lineNumber : 290, className : "lime.utils.Preloader", methodName : "updateProgress"});
					};
				})());
			}
		}
		if(!this.simulateProgress && this.loadedLibraries == this.libraries.length + this.libraryNames.length) {
			if(!this.preloadComplete) {
				this.preloadComplete = true;
				lime_utils_Log.verbose("Preload complete",{ fileName : "lime/utils/Preloader.hx", lineNumber : 301, className : "lime.utils.Preloader", methodName : "updateProgress"});
			}
			this.start();
		}
	}
	,__class__: lime_utils_Preloader
};
var lime_utils_UInt16Array = {};
lime_utils_UInt16Array.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils_UInt16Array.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Uint16Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Uint16Array(bytes.b.bufferValue,byteOffset);
	}
	return new Uint16Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils_UInt16Array.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils_UInt16Array.toString = function(this1) {
	if(this1 != null) {
		return "UInt16Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils_UInt32Array = {};
lime_utils_UInt32Array.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils_UInt32Array.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Uint32Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Uint32Array(bytes.b.bufferValue,byteOffset);
	}
	return new Uint32Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils_UInt32Array.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils_UInt32Array.toString = function(this1) {
	if(this1 != null) {
		return "UInt32Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils_UInt8Array = {};
lime_utils_UInt8Array.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils_UInt8Array.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		return new Uint8Array(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Uint8Array(bytes.b.bufferValue,byteOffset);
	}
	return new Uint8Array(bytes.b.bufferValue,byteOffset,len);
};
lime_utils_UInt8Array.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils_UInt8Array.toString = function(this1) {
	if(this1 != null) {
		return "UInt8Array [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
var lime_utils_UInt8ClampedArray = {};
lime_utils_UInt8ClampedArray.toArrayBufferView = function(this1) {
	return this1;
};
lime_utils_UInt8ClampedArray.fromBytes = function(bytes,byteOffset,len) {
	if(byteOffset == null) {
		byteOffset = 0;
	}
	if(byteOffset == null) {
		return new Uint8ClampedArray(bytes.b.bufferValue);
	}
	if(len == null) {
		return new Uint8ClampedArray(bytes.b.bufferValue,byteOffset);
	}
	return new Uint8ClampedArray(bytes.b.bufferValue,byteOffset,len);
};
lime_utils_UInt8ClampedArray.toBytes = function(this1) {
	return new haxe_io_Bytes(new Uint8Array(this1.buffer));
};
lime_utils_UInt8ClampedArray.toString = function(this1) {
	if(this1 != null) {
		return "UInt8ClampedArray [byteLength:" + this1.byteLength + ", length:" + this1.length + "]";
	} else {
		return null;
	}
};
lime_utils_UInt8ClampedArray._clamp = function(_in) {
	var _out = _in | 0;
	if(_out > 255) {
		_out = 255;
	}
	if(_out < 0) {
		return 0;
	} else {
		return _out;
	}
};
var openfl_Lib = function() { };
$hxClasses["openfl.Lib"] = openfl_Lib;
openfl_Lib.__name__ = "openfl.Lib";
openfl_Lib.__properties__ = {get_current:"get_current",get_application:"get_application"};
openfl_Lib.as = function(v,c) {
	if(js_Boot.__instanceof(v,c)) {
		return v;
	} else {
		return null;
	}
};
openfl_Lib.attach = function(name) {
	return new openfl_display_MovieClip();
};
openfl_Lib.clearInterval = function(id) {
	if(openfl_Lib.__timers.h.hasOwnProperty(id)) {
		var timer = openfl_Lib.__timers.h[id];
		timer.stop();
		openfl_Lib.__timers.remove(id);
	}
};
openfl_Lib.clearTimeout = function(id) {
	if(openfl_Lib.__timers.h.hasOwnProperty(id)) {
		var timer = openfl_Lib.__timers.h[id];
		timer.stop();
		openfl_Lib.__timers.remove(id);
	}
};
openfl_Lib.getDefinitionByName = function(name) {
	if(name == null) {
		return null;
	}
	return $hxClasses[name];
};
openfl_Lib.getQualifiedClassName = function(value) {
	if(value == null) {
		return null;
	}
	var ref = js_Boot.__instanceof(value,Class) ? value : js_Boot.getClass(value);
	if(ref == null) {
		if(typeof(value) == "boolean" || value == Bool) {
			return "Bool";
		} else if(typeof(value) == "number" && ((value | 0) === value) || value == Int) {
			return "Int";
		} else if(typeof(value) == "number" || value == Float) {
			return "Float";
		} else {
			return null;
		}
	}
	return ref.__name__;
};
openfl_Lib.getQualifiedSuperclassName = function(value) {
	if(value == null) {
		return null;
	}
	var ref = js_Boot.__instanceof(value,Class) ? value : js_Boot.getClass(value);
	if(ref == null) {
		return null;
	}
	var parentRef = ref.__super__;
	if(parentRef == null) {
		return null;
	}
	return parentRef.__name__;
};
openfl_Lib.getTimer = function() {
	return lime_system_System.getTimer();
};
openfl_Lib.getURL = function(request,target) {
	openfl_Lib.navigateToURL(request,target);
};
openfl_Lib.navigateToURL = function(request,$window) {
	if($window == null) {
		$window = "_blank";
	}
	var uri = request.url;
	if(Type.typeof(request.data) == ValueType.TObject) {
		var query = "";
		var fields = Reflect.fields(request.data);
		var _g = 0;
		while(_g < fields.length) {
			var field = fields[_g];
			++_g;
			if(query.length > 0) {
				query += "&";
			}
			var query1 = encodeURIComponent(field) + "=";
			var s = Std.string(Reflect.field(request.data,field));
			query += query1 + encodeURIComponent(s);
		}
		if(uri.indexOf("?") > -1) {
			uri += "&" + query;
		} else {
			uri += "?" + query;
		}
	}
	lime_system_System.openURL(uri,$window);
};
openfl_Lib.notImplemented = function(posInfo) {
	var api = posInfo.className + "." + posInfo.methodName;
	if(!Object.prototype.hasOwnProperty.call(openfl_Lib.__sentWarnings.h,api)) {
		openfl_Lib.__sentWarnings.h[api] = true;
		lime_utils_Log.warn(posInfo.methodName + " is not implemented",posInfo);
	}
};
openfl_Lib.preventDefaultTouchMove = function() {
	window.document.addEventListener("touchmove",function(evt) {
		evt.preventDefault();
	},false);
};
openfl_Lib.sendToURL = function(request) {
	var urlLoader = new openfl_net_URLLoader();
	urlLoader.load(request);
};
openfl_Lib.setInterval = function(closure,delay,args) {
	var id = ++openfl_Lib.__lastTimerID;
	var timer = new haxe_Timer(delay);
	openfl_Lib.__timers.h[id] = timer;
	timer.run = function() {
		closure.apply(closure,args == null ? [] : args);
	};
	return id;
};
openfl_Lib.setTimeout = function(closure,delay,args) {
	var id = ++openfl_Lib.__lastTimerID;
	var this1 = openfl_Lib.__timers;
	var v = haxe_Timer.delay(function() {
		closure.apply(closure,args == null ? [] : args);
	},delay);
	this1.h[id] = v;
	return id;
};
openfl_Lib.trace = function(arg) {
	haxe_Log.trace(arg,{ fileName : "openfl/Lib.hx", lineNumber : 565, className : "openfl.Lib", methodName : "trace"});
};
openfl_Lib.get_application = function() {
	return openfl_utils__$internal_Lib.application;
};
openfl_Lib.get_current = function() {
	if(openfl_utils__$internal_Lib.current == null) {
		openfl_utils__$internal_Lib.current = new openfl_display_MovieClip();
	}
	return openfl_utils__$internal_Lib.current;
};
var openfl__$Vector_IVector = function() { };
$hxClasses["openfl._Vector.IVector"] = openfl__$Vector_IVector;
openfl__$Vector_IVector.__name__ = "openfl._Vector.IVector";
openfl__$Vector_IVector.__isInterface__ = true;
openfl__$Vector_IVector.prototype = {
	__class__: openfl__$Vector_IVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl__$Vector_BoolVector = function(length,fixed,array) {
	if(fixed == null) {
		fixed = false;
	}
	if(length == null) {
		length = 0;
	}
	if(array == null) {
		array = [];
	}
	this.__array = array;
	if(length > 0) {
		this.set_length(length);
	}
	this.fixed = fixed;
};
$hxClasses["openfl._Vector.BoolVector"] = openfl__$Vector_BoolVector;
openfl__$Vector_BoolVector.__name__ = "openfl._Vector.BoolVector";
openfl__$Vector_BoolVector.__interfaces__ = [openfl__$Vector_IVector];
openfl__$Vector_BoolVector.prototype = {
	concat: function(a) {
		if(a == null) {
			return new openfl__$Vector_BoolVector(0,false,this.__array.slice());
		} else {
			var other = a;
			if(other.__array.length > 0) {
				return new openfl__$Vector_BoolVector(0,false,this.__array.concat(other.__array));
			} else {
				return new openfl__$Vector_BoolVector(0,false,this.__array.slice());
			}
		}
	}
	,copy: function() {
		return new openfl__$Vector_BoolVector(0,this.fixed,this.__array.slice());
	}
	,filter: function(callback) {
		var tmp = this.fixed;
		var _g = [];
		var _g1 = 0;
		var _g2 = this.__array;
		while(_g1 < _g2.length) {
			var v = _g2[_g1];
			++_g1;
			if(callback(v)) {
				_g.push(v);
			}
		}
		return new openfl__$Vector_BoolVector(0,tmp,_g);
	}
	,get: function(index) {
		if(index >= this.__array.length) {
			return false;
		} else {
			return this.__array[index];
		}
	}
	,indexOf: function(x,from) {
		if(from == null) {
			from = 0;
		}
		var _g = from;
		var _g1 = this.__array.length;
		while(_g < _g1) {
			var i = _g++;
			if(this.__array[i] == x) {
				return i;
			}
		}
		return -1;
	}
	,insertAt: function(index,element) {
		if(!this.fixed || index < this.__array.length) {
			this.__array.splice(index,0,element);
		}
	}
	,iterator: function() {
		return new haxe_iterators_ArrayIterator(this.__array);
	}
	,join: function(sep) {
		if(sep == null) {
			sep = ",";
		}
		return this.__array.join(sep);
	}
	,lastIndexOf: function(x,from) {
		var i = from == null || from >= this.__array.length ? this.__array.length - 1 : from;
		while(i >= 0) {
			if(this.__array[i] == x) {
				return i;
			}
			--i;
		}
		return -1;
	}
	,pop: function() {
		if(!this.fixed) {
			return this.__array.pop();
		} else {
			return null;
		}
	}
	,push: function(x) {
		if(!this.fixed) {
			return this.__array.push(x);
		} else {
			return this.__array.length;
		}
	}
	,removeAt: function(index) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array.splice(index,1)[0];
		}
		return false;
	}
	,reverse: function() {
		this.__array.reverse();
		return this;
	}
	,set: function(index,value) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array[index] = value;
		} else {
			return value;
		}
	}
	,shift: function() {
		if(!this.fixed) {
			return this.__array.shift();
		} else {
			return null;
		}
	}
	,slice: function(startIndex,endIndex) {
		if(startIndex == null) {
			startIndex = 0;
		}
		if(endIndex == null) {
			endIndex = 16777215;
		}
		return new openfl__$Vector_BoolVector(0,false,this.__array.slice(startIndex,endIndex));
	}
	,sort: function(f) {
		this.__array.sort(f);
	}
	,splice: function(pos,len) {
		return new openfl__$Vector_BoolVector(0,false,this.__array.splice(pos,len));
	}
	,toJSON: function() {
		return this.__array;
	}
	,toString: function() {
		if(this.__array != null) {
			return this.__array.toString();
		} else {
			return null;
		}
	}
	,unshift: function(x) {
		if(!this.fixed) {
			this.__array.unshift(x);
		}
	}
	,get_length: function() {
		return this.__array.length;
	}
	,set_length: function(value) {
		if(!this.fixed) {
			var currentLength = this.__array.length;
			if(value < 0) {
				value = 0;
			}
			if(value > currentLength) {
				var _g = currentLength;
				var _g1 = value;
				while(_g < _g1) {
					var i = _g++;
					this.__array[i] = false;
				}
			} else {
				while(this.__array.length > value) this.__array.pop();
			}
		}
		return this.__array.length;
	}
	,__class__: openfl__$Vector_BoolVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl__$Vector_FloatVector = function(length,fixed,array,forceCopy) {
	if(forceCopy == null) {
		forceCopy = false;
	}
	if(fixed == null) {
		fixed = false;
	}
	if(length == null) {
		length = 0;
	}
	if(forceCopy) {
		this.__array = [];
		if(array != null) {
			var _g = 0;
			var _g1 = array.length;
			while(_g < _g1) {
				var i = _g++;
				this.__array[i] = array[i];
			}
		}
	} else {
		if(array == null) {
			array = [];
		}
		this.__array = array;
	}
	if(length > 0) {
		this.set_length(length);
	}
	this.fixed = fixed;
};
$hxClasses["openfl._Vector.FloatVector"] = openfl__$Vector_FloatVector;
openfl__$Vector_FloatVector.__name__ = "openfl._Vector.FloatVector";
openfl__$Vector_FloatVector.__interfaces__ = [openfl__$Vector_IVector];
openfl__$Vector_FloatVector.prototype = {
	concat: function(a) {
		if(a == null) {
			return new openfl__$Vector_FloatVector(0,false,this.__array.slice());
		} else {
			var other = a;
			if(other.__array.length > 0) {
				return new openfl__$Vector_FloatVector(0,false,this.__array.concat(other.__array));
			} else {
				return new openfl__$Vector_FloatVector(0,false,this.__array.slice());
			}
		}
	}
	,copy: function() {
		return new openfl__$Vector_FloatVector(0,this.fixed,this.__array.slice());
	}
	,filter: function(callback) {
		var tmp = this.fixed;
		var _g = [];
		var _g1 = 0;
		var _g2 = this.__array;
		while(_g1 < _g2.length) {
			var v = _g2[_g1];
			++_g1;
			if(callback(v)) {
				_g.push(v);
			}
		}
		return new openfl__$Vector_FloatVector(0,tmp,_g);
	}
	,get: function(index) {
		return this.__array[index];
	}
	,indexOf: function(x,from) {
		if(from == null) {
			from = 0;
		}
		var _g = from;
		var _g1 = this.__array.length;
		while(_g < _g1) {
			var i = _g++;
			if(this.__array[i] == x) {
				return i;
			}
		}
		return -1;
	}
	,insertAt: function(index,element) {
		if(!this.fixed || index < this.__array.length) {
			this.__array.splice(index,0,element);
		}
	}
	,iterator: function() {
		return new haxe_iterators_ArrayIterator(this.__array);
	}
	,join: function(sep) {
		if(sep == null) {
			sep = ",";
		}
		return this.__array.join(sep);
	}
	,lastIndexOf: function(x,from) {
		var i = from == null || from >= this.__array.length ? this.__array.length - 1 : from;
		while(i >= 0) {
			if(this.__array[i] == x) {
				return i;
			}
			--i;
		}
		return -1;
	}
	,pop: function() {
		if(!this.fixed) {
			return this.__array.pop();
		} else {
			return null;
		}
	}
	,push: function(x) {
		if(!this.fixed) {
			return this.__array.push(x);
		} else {
			return this.__array.length;
		}
	}
	,removeAt: function(index) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array.splice(index,1)[0];
		}
		return 0;
	}
	,reverse: function() {
		this.__array.reverse();
		return this;
	}
	,set: function(index,value) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array[index] = value;
		} else {
			return value;
		}
	}
	,shift: function() {
		if(!this.fixed) {
			return this.__array.shift();
		} else {
			return null;
		}
	}
	,slice: function(startIndex,endIndex) {
		if(startIndex == null) {
			startIndex = 0;
		}
		if(endIndex == null) {
			endIndex = 16777215;
		}
		return new openfl__$Vector_FloatVector(0,false,this.__array.slice(startIndex,endIndex));
	}
	,sort: function(f) {
		this.__array.sort(f);
	}
	,splice: function(pos,len) {
		return new openfl__$Vector_FloatVector(0,false,this.__array.splice(pos,len));
	}
	,toJSON: function() {
		return this.__array;
	}
	,toString: function() {
		if(this.__array != null) {
			return this.__array.toString();
		} else {
			return null;
		}
	}
	,unshift: function(x) {
		if(!this.fixed) {
			this.__array.unshift(x);
		}
	}
	,get_length: function() {
		return this.__array.length;
	}
	,set_length: function(value) {
		if(value != this.__array.length && !this.fixed) {
			var currentLength = this.__array.length;
			if(value < 0) {
				value = 0;
			}
			if(value > currentLength) {
				var _g = currentLength;
				var _g1 = value;
				while(_g < _g1) {
					var i = _g++;
					this.__array[i] = 0;
				}
			} else {
				while(this.__array.length > value) this.__array.pop();
			}
		}
		return this.__array.length;
	}
	,__class__: openfl__$Vector_FloatVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl__$Vector_FunctionVector = function(length,fixed,array) {
	if(fixed == null) {
		fixed = false;
	}
	if(length == null) {
		length = 0;
	}
	if(array == null) {
		array = [];
	}
	this.__array = array;
	if(length > 0) {
		this.set_length(length);
	}
	this.fixed = fixed;
};
$hxClasses["openfl._Vector.FunctionVector"] = openfl__$Vector_FunctionVector;
openfl__$Vector_FunctionVector.__name__ = "openfl._Vector.FunctionVector";
openfl__$Vector_FunctionVector.__interfaces__ = [openfl__$Vector_IVector];
openfl__$Vector_FunctionVector.prototype = {
	concat: function(a) {
		if(a == null) {
			return new openfl__$Vector_FunctionVector(0,false,this.__array.slice());
		} else {
			var other = a;
			if(other.__array.length > 0) {
				return new openfl__$Vector_FunctionVector(0,false,this.__array.concat(other.__array));
			} else {
				return new openfl__$Vector_FunctionVector(0,false,this.__array.slice());
			}
		}
	}
	,copy: function() {
		return new openfl__$Vector_FunctionVector(0,this.fixed,this.__array.slice());
	}
	,filter: function(callback) {
		var tmp = this.fixed;
		var _g = [];
		var _g1 = 0;
		var _g2 = this.__array;
		while(_g1 < _g2.length) {
			var v = _g2[_g1];
			++_g1;
			if(callback(v)) {
				_g.push(v);
			}
		}
		return new openfl__$Vector_FunctionVector(0,tmp,_g);
	}
	,get: function(index) {
		if(index >= this.__array.length) {
			return null;
		} else {
			return this.__array[index];
		}
	}
	,indexOf: function(x,from) {
		if(from == null) {
			from = 0;
		}
		var _g = from;
		var _g1 = this.__array.length;
		while(_g < _g1) {
			var i = _g++;
			if(Reflect.compareMethods(this.__array[i],x)) {
				return i;
			}
		}
		return -1;
	}
	,insertAt: function(index,element) {
		if(!this.fixed || index < this.__array.length) {
			this.__array.splice(index,0,element);
		}
	}
	,iterator: function() {
		return new haxe_iterators_ArrayIterator(this.__array);
	}
	,join: function(sep) {
		if(sep == null) {
			sep = ",";
		}
		return this.__array.join(sep);
	}
	,lastIndexOf: function(x,from) {
		var i = from == null || from >= this.__array.length ? this.__array.length - 1 : from;
		while(i >= 0) {
			if(Reflect.compareMethods(this.__array[i],x)) {
				return i;
			}
			--i;
		}
		return -1;
	}
	,pop: function() {
		if(!this.fixed) {
			return this.__array.pop();
		} else {
			return null;
		}
	}
	,push: function(x) {
		if(!this.fixed) {
			return this.__array.push(x);
		} else {
			return this.__array.length;
		}
	}
	,removeAt: function(index) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array.splice(index,1)[0];
		}
		return null;
	}
	,reverse: function() {
		this.__array.reverse();
		return this;
	}
	,set: function(index,value) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array[index] = value;
		} else {
			return value;
		}
	}
	,shift: function() {
		if(!this.fixed) {
			return this.__array.shift();
		} else {
			return null;
		}
	}
	,slice: function(startIndex,endIndex) {
		if(startIndex == null) {
			startIndex = 0;
		}
		if(endIndex == null) {
			endIndex = 16777215;
		}
		return new openfl__$Vector_FunctionVector(0,false,this.__array.slice(startIndex,endIndex));
	}
	,sort: function(f) {
		this.__array.sort(f);
	}
	,splice: function(pos,len) {
		return new openfl__$Vector_FunctionVector(0,false,this.__array.splice(pos,len));
	}
	,toJSON: function() {
		return this.__array;
	}
	,toString: function() {
		if(this.__array != null) {
			return this.__array.toString();
		} else {
			return null;
		}
	}
	,unshift: function(x) {
		if(!this.fixed) {
			this.__array.unshift(x);
		}
	}
	,get_length: function() {
		return this.__array.length;
	}
	,set_length: function(value) {
		if(!this.fixed) {
			var currentLength = this.__array.length;
			if(value < 0) {
				value = 0;
			}
			if(value > currentLength) {
				var _g = currentLength;
				var _g1 = value;
				while(_g < _g1) {
					var i = _g++;
					this.__array[i] = null;
				}
			} else {
				while(this.__array.length > value) this.__array.pop();
			}
		}
		return this.__array.length;
	}
	,__class__: openfl__$Vector_FunctionVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl__$Vector_IntVector = function(length,fixed,array) {
	if(fixed == null) {
		fixed = false;
	}
	if(length == null) {
		length = 0;
	}
	if(array == null) {
		array = [];
	}
	this.__array = array;
	if(length > 0) {
		this.set_length(length);
	}
	this.fixed = fixed;
};
$hxClasses["openfl._Vector.IntVector"] = openfl__$Vector_IntVector;
openfl__$Vector_IntVector.__name__ = "openfl._Vector.IntVector";
openfl__$Vector_IntVector.__interfaces__ = [openfl__$Vector_IVector];
openfl__$Vector_IntVector.prototype = {
	concat: function(a) {
		if(a == null) {
			return new openfl__$Vector_IntVector(0,false,this.__array.slice());
		} else {
			var other = a;
			if(other.__array.length > 0) {
				return new openfl__$Vector_IntVector(0,false,this.__array.concat(other.__array));
			} else {
				return new openfl__$Vector_IntVector(0,false,this.__array.slice());
			}
		}
	}
	,copy: function() {
		return new openfl__$Vector_IntVector(0,this.fixed,this.__array.slice());
	}
	,filter: function(callback) {
		var tmp = this.fixed;
		var _g = [];
		var _g1 = 0;
		var _g2 = this.__array;
		while(_g1 < _g2.length) {
			var v = _g2[_g1];
			++_g1;
			if(callback(v)) {
				_g.push(v);
			}
		}
		return new openfl__$Vector_IntVector(0,tmp,_g);
	}
	,get: function(index) {
		return this.__array[index];
	}
	,indexOf: function(x,from) {
		if(from == null) {
			from = 0;
		}
		var _g = from;
		var _g1 = this.__array.length;
		while(_g < _g1) {
			var i = _g++;
			if(this.__array[i] == x) {
				return i;
			}
		}
		return -1;
	}
	,insertAt: function(index,element) {
		if(!this.fixed || index < this.__array.length) {
			this.__array.splice(index,0,element);
		}
	}
	,iterator: function() {
		return new haxe_iterators_ArrayIterator(this.__array);
	}
	,join: function(sep) {
		if(sep == null) {
			sep = ",";
		}
		return this.__array.join(sep);
	}
	,lastIndexOf: function(x,from) {
		var i = from == null || from >= this.__array.length ? this.__array.length - 1 : from;
		while(i >= 0) {
			if(this.__array[i] == x) {
				return i;
			}
			--i;
		}
		return -1;
	}
	,pop: function() {
		if(!this.fixed) {
			return this.__array.pop();
		} else {
			return null;
		}
	}
	,push: function(x) {
		if(!this.fixed) {
			return this.__array.push(x);
		} else {
			return this.__array.length;
		}
	}
	,removeAt: function(index) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array.splice(index,1)[0];
		}
		return 0;
	}
	,reverse: function() {
		this.__array.reverse();
		return this;
	}
	,set: function(index,value) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array[index] = value;
		} else {
			return value;
		}
	}
	,shift: function() {
		if(!this.fixed) {
			return this.__array.shift();
		} else {
			return null;
		}
	}
	,slice: function(startIndex,endIndex) {
		if(startIndex == null) {
			startIndex = 0;
		}
		if(endIndex == null) {
			endIndex = 16777215;
		}
		return new openfl__$Vector_IntVector(0,false,this.__array.slice(startIndex,endIndex));
	}
	,sort: function(f) {
		this.__array.sort(f);
	}
	,splice: function(pos,len) {
		return new openfl__$Vector_IntVector(0,false,this.__array.splice(pos,len));
	}
	,toJSON: function() {
		return this.__array;
	}
	,toString: function() {
		if(this.__array != null) {
			return this.__array.toString();
		} else {
			return null;
		}
	}
	,unshift: function(x) {
		if(!this.fixed) {
			this.__array.unshift(x);
		}
	}
	,get_length: function() {
		return this.__array.length;
	}
	,set_length: function(value) {
		if(!this.fixed) {
			var currentLength = this.__array.length;
			if(value < 0) {
				value = 0;
			}
			if(value > currentLength) {
				var _g = currentLength;
				var _g1 = value;
				while(_g < _g1) {
					var i = _g++;
					this.__array[i] = 0;
				}
			} else {
				while(this.__array.length > value) this.__array.pop();
			}
		}
		return this.__array.length;
	}
	,__class__: openfl__$Vector_IntVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl__$Vector_ObjectVector = function(length,fixed,array,forceCopy) {
	if(forceCopy == null) {
		forceCopy = false;
	}
	if(fixed == null) {
		fixed = false;
	}
	if(length == null) {
		length = 0;
	}
	if(forceCopy) {
		this.__array = [];
		if(array != null) {
			var _g = 0;
			var _g1 = array.length;
			while(_g < _g1) {
				var i = _g++;
				this.__array[i] = array[i];
			}
		}
	} else {
		if(array == null) {
			array = [];
		}
		this.__array = array;
	}
	if(length > 0) {
		this.set_length(length);
	}
	this.fixed = fixed;
};
$hxClasses["openfl._Vector.ObjectVector"] = openfl__$Vector_ObjectVector;
openfl__$Vector_ObjectVector.__name__ = "openfl._Vector.ObjectVector";
openfl__$Vector_ObjectVector.__interfaces__ = [openfl__$Vector_IVector];
openfl__$Vector_ObjectVector.prototype = {
	concat: function(a) {
		if(a == null) {
			return new openfl__$Vector_ObjectVector(0,false,this.__array.slice());
		} else {
			var other = a;
			if(other.__array.length > 0) {
				return new openfl__$Vector_ObjectVector(0,false,this.__array.concat(other.__array));
			} else {
				return new openfl__$Vector_ObjectVector(0,false,this.__array.slice());
			}
		}
	}
	,copy: function() {
		return new openfl__$Vector_ObjectVector(0,this.fixed,this.__array.slice());
	}
	,filter: function(callback) {
		var tmp = this.fixed;
		var _g = [];
		var _g1 = 0;
		var _g2 = this.__array;
		while(_g1 < _g2.length) {
			var v = _g2[_g1];
			++_g1;
			if(callback(v)) {
				_g.push(v);
			}
		}
		return new openfl__$Vector_ObjectVector(0,tmp,_g);
	}
	,get: function(index) {
		return this.__array[index];
	}
	,indexOf: function(x,from) {
		if(from == null) {
			from = 0;
		}
		var _g = from;
		var _g1 = this.__array.length;
		while(_g < _g1) {
			var i = _g++;
			if(this.__array[i] == x) {
				return i;
			}
		}
		return -1;
	}
	,insertAt: function(index,element) {
		if(!this.fixed || index < this.__array.length) {
			this.__array.splice(index,0,element);
		}
	}
	,iterator: function() {
		return new haxe_iterators_ArrayIterator(this.__array);
	}
	,join: function(sep) {
		if(sep == null) {
			sep = ",";
		}
		return this.__array.join(sep);
	}
	,lastIndexOf: function(x,from) {
		var i = from == null || from >= this.__array.length ? this.__array.length - 1 : from;
		while(i >= 0) {
			if(this.__array[i] == x) {
				return i;
			}
			--i;
		}
		return -1;
	}
	,pop: function() {
		if(!this.fixed) {
			return this.__array.pop();
		} else {
			return null;
		}
	}
	,push: function(x) {
		if(!this.fixed) {
			return this.__array.push(x);
		} else {
			return this.__array.length;
		}
	}
	,removeAt: function(index) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array.splice(index,1)[0];
		}
		return null;
	}
	,reverse: function() {
		this.__array.reverse();
		return this;
	}
	,set: function(index,value) {
		if(!this.fixed || index < this.__array.length) {
			return this.__array[index] = value;
		} else {
			return value;
		}
	}
	,shift: function() {
		if(!this.fixed) {
			return this.__array.shift();
		} else {
			return null;
		}
	}
	,slice: function(startIndex,endIndex) {
		if(startIndex == null) {
			startIndex = 0;
		}
		if(endIndex == null) {
			endIndex = 16777215;
		}
		return new openfl__$Vector_ObjectVector(0,false,this.__array.slice(startIndex,endIndex));
	}
	,sort: function(f) {
		this.__array.sort(f);
	}
	,splice: function(pos,len) {
		return new openfl__$Vector_ObjectVector(0,false,this.__array.splice(pos,len));
	}
	,toJSON: function() {
		return this.__array;
	}
	,toString: function() {
		if(this.__array != null) {
			return this.__array.toString();
		} else {
			return null;
		}
	}
	,unshift: function(x) {
		if(!this.fixed) {
			this.__array.unshift(x);
		}
	}
	,get_length: function() {
		return this.__array.length;
	}
	,set_length: function(value) {
		if(!this.fixed) {
			var currentLength = this.__array.length;
			if(value < 0) {
				value = 0;
			}
			if(value > currentLength) {
				var _g = currentLength;
				var _g1 = value;
				while(_g < _g1) {
					var i = _g++;
					this.__array.push(null);
				}
			} else {
				while(this.__array.length > value) this.__array.pop();
			}
		}
		return this.__array.length;
	}
	,__class__: openfl__$Vector_ObjectVector
	,__properties__: {set_length:"set_length",get_length:"get_length"}
};
var openfl_display_Application = function() {
	lime_app_Application.call(this);
	if(openfl_utils__$internal_Lib.application == null) {
		openfl_utils__$internal_Lib.application = this;
	}
	if(openfl_utils__$internal_Lib.current == null) {
		openfl_utils__$internal_Lib.current = new openfl_display_MovieClip();
	}
	openfl_utils__$internal_Lib.current.__loaderInfo = openfl_display_LoaderInfo.create(null);
	openfl_utils__$internal_Lib.current.__loaderInfo.content = openfl_utils__$internal_Lib.current;
};
$hxClasses["openfl.display.Application"] = openfl_display_Application;
openfl_display_Application.__name__ = "openfl.display.Application";
openfl_display_Application.__super__ = lime_app_Application;
openfl_display_Application.prototype = $extend(lime_app_Application.prototype,{
	createWindow: function(attributes) {
		var $window = new openfl_display_Window(this,attributes);
		this.__windows.push($window);
		this.__windowByID.h[$window.id] = $window;
		var _g = $bind(this,this.__onWindowClose);
		var window1 = $window;
		var tmp = function() {
			_g(window1);
		};
		$window.onClose.add(tmp,false,-10000);
		if(this.__window == null) {
			this.__window = $window;
			$window.onActivate.add($bind(this,this.onWindowActivate));
			$window.onRenderContextLost.add($bind(this,this.onRenderContextLost));
			$window.onRenderContextRestored.add($bind(this,this.onRenderContextRestored));
			$window.onDeactivate.add($bind(this,this.onWindowDeactivate));
			$window.onDropFile.add($bind(this,this.onWindowDropFile));
			$window.onEnter.add($bind(this,this.onWindowEnter));
			$window.onExpose.add($bind(this,this.onWindowExpose));
			$window.onFocusIn.add($bind(this,this.onWindowFocusIn));
			$window.onFocusOut.add($bind(this,this.onWindowFocusOut));
			$window.onFullscreen.add($bind(this,this.onWindowFullscreen));
			$window.onKeyDown.add($bind(this,this.onKeyDown));
			$window.onKeyUp.add($bind(this,this.onKeyUp));
			$window.onLeave.add($bind(this,this.onWindowLeave));
			$window.onMinimize.add($bind(this,this.onWindowMinimize));
			$window.onMouseDown.add($bind(this,this.onMouseDown));
			$window.onMouseMove.add($bind(this,this.onMouseMove));
			$window.onMouseMoveRelative.add($bind(this,this.onMouseMoveRelative));
			$window.onMouseUp.add($bind(this,this.onMouseUp));
			$window.onMouseWheel.add($bind(this,this.onMouseWheel));
			$window.onMove.add($bind(this,this.onWindowMove));
			$window.onRender.add($bind(this,this.render));
			$window.onResize.add($bind(this,this.onWindowResize));
			$window.onRestore.add($bind(this,this.onWindowRestore));
			$window.onTextEdit.add($bind(this,this.onTextEdit));
			$window.onTextInput.add($bind(this,this.onTextInput));
			this.onWindowCreate();
		}
		this.onCreateWindow.dispatch($window);
		return $window;
	}
	,__class__: openfl_display_Application
});
var openfl_display_Bitmap = function(bitmapData,pixelSnapping,smoothing) {
	if(smoothing == null) {
		smoothing = false;
	}
	openfl_display_DisplayObject.call(this);
	this.__drawableType = 2;
	this.__bitmapData = bitmapData;
	this.pixelSnapping = pixelSnapping;
	this.smoothing = smoothing;
	if(pixelSnapping == null) {
		this.pixelSnapping = 1;
	}
};
$hxClasses["openfl.display.Bitmap"] = openfl_display_Bitmap;
openfl_display_Bitmap.__name__ = "openfl.display.Bitmap";
openfl_display_Bitmap.__super__ = openfl_display_DisplayObject;
openfl_display_Bitmap.prototype = $extend(openfl_display_DisplayObject.prototype,{
	__enterFrame: function(deltaTime) {
		if(this.__bitmapData != null && this.__bitmapData.image != null && this.__bitmapData.image.version != this.__imageVersion) {
			if(!this.__renderDirty) {
				this.__renderDirty = true;
				this.__setParentRenderDirty();
			}
		}
	}
	,__getBounds: function(rect,matrix) {
		var bounds = openfl_geom_Rectangle.__pool.get();
		if(this.__bitmapData != null) {
			bounds.setTo(0,0,this.__bitmapData.width,this.__bitmapData.height);
		} else {
			bounds.setTo(0,0,0,0);
		}
		bounds.__transform(bounds,matrix);
		rect.__expand(bounds.x,bounds.y,bounds.width,bounds.height);
		openfl_geom_Rectangle.__pool.release(bounds);
	}
	,__hitTest: function(x,y,shapeFlag,stack,interactiveOnly,hitObject) {
		if(!hitObject.get_visible() || this.__isMask || this.__bitmapData == null) {
			return false;
		}
		if(this.get_mask() != null && !this.get_mask().__hitTestMask(x,y)) {
			return false;
		}
		this.__getRenderTransform();
		var _this = this.__renderTransform;
		var norm = _this.a * _this.d - _this.b * _this.c;
		var px = norm == 0 ? -_this.tx : 1.0 / norm * (_this.c * (_this.ty - y) + _this.d * (x - _this.tx));
		var _this = this.__renderTransform;
		var norm = _this.a * _this.d - _this.b * _this.c;
		var py = norm == 0 ? -_this.ty : 1.0 / norm * (_this.a * (y - _this.ty) + _this.b * (_this.tx - x));
		if(px > 0 && py > 0 && px <= this.__bitmapData.width && py <= this.__bitmapData.height) {
			if(this.__scrollRect != null && !this.__scrollRect.contains(px,py)) {
				return false;
			}
			if(stack != null && !interactiveOnly) {
				stack.push(hitObject);
			}
			return true;
		}
		return false;
	}
	,__hitTestMask: function(x,y) {
		if(this.__bitmapData == null) {
			return false;
		}
		this.__getRenderTransform();
		var _this = this.__renderTransform;
		var norm = _this.a * _this.d - _this.b * _this.c;
		var px = norm == 0 ? -_this.tx : 1.0 / norm * (_this.c * (_this.ty - y) + _this.d * (x - _this.tx));
		var _this = this.__renderTransform;
		var norm = _this.a * _this.d - _this.b * _this.c;
		var py = norm == 0 ? -_this.ty : 1.0 / norm * (_this.a * (y - _this.ty) + _this.b * (_this.tx - x));
		if(px > 0 && py > 0 && px <= this.__bitmapData.width && py <= this.__bitmapData.height) {
			return true;
		}
		return false;
	}
	,get_bitmapData: function() {
		return this.__bitmapData;
	}
	,set_bitmapData: function(value) {
		this.__bitmapData = value;
		this.smoothing = false;
		if(!this.__renderDirty) {
			this.__renderDirty = true;
			this.__setParentRenderDirty();
		}
		var tmp = this.__filters != null;
		this.__imageVersion = -1;
		return this.__bitmapData;
	}
	,set_height: function(value) {
		if(this.__bitmapData != null) {
			this.set_scaleY(value / this.__bitmapData.height);
		} else {
			this.set_scaleY(0);
		}
		return value;
	}
	,set_width: function(value) {
		if(this.__bitmapData != null) {
			this.set_scaleX(value / this.__bitmapData.width);
		} else {
			this.set_scaleX(0);
		}
		return value;
	}
	,__class__: openfl_display_Bitmap
	,__properties__: $extend(openfl_display_DisplayObject.prototype.__properties__,{set_bitmapData:"set_bitmapData",get_bitmapData:"get_bitmapData"})
});
var openfl_display_BitmapData = function(width,height,transparent,fillColor) {
	if(fillColor == null) {
		fillColor = -1;
	}
	if(transparent == null) {
		transparent = true;
	}
	this.__drawableType = 0;
	this.transparent = transparent;
	if(width == null) {
		width = 0;
	}
	if(height == null) {
		height = 0;
	}
	if(width < 0) {
		width = 0;
	}
	if(height < 0) {
		height = 0;
	}
	this.width = width;
	this.height = height;
	this.rect = new openfl_geom_Rectangle(0,0,width,height);
	this.__textureWidth = width;
	this.__textureHeight = height;
	if(width > 0 && height > 0) {
		if(transparent) {
			if((fillColor & -16777216) == 0) {
				fillColor = 0;
			}
		} else {
			fillColor = -16777216 | fillColor & 16777215;
		}
		fillColor = fillColor << 8 | fillColor >>> 24 & 255;
		this.image = new lime_graphics_Image(null,0,0,width,height,fillColor);
		this.image.set_transparent(transparent);
		this.__isValid = true;
		this.readable = true;
	}
	this.__renderTransform = new openfl_geom_Matrix();
	this.__worldAlpha = 1;
	this.__worldTransform = new openfl_geom_Matrix();
	this.__worldColorTransform = new openfl_geom_ColorTransform();
	this.__renderable = true;
};
$hxClasses["openfl.display.BitmapData"] = openfl_display_BitmapData;
openfl_display_BitmapData.__name__ = "openfl.display.BitmapData";
openfl_display_BitmapData.__interfaces__ = [openfl_display_IBitmapDrawable];
openfl_display_BitmapData.fromBase64 = function(base64,type) {
	return null;
};
openfl_display_BitmapData.fromBytes = function(bytes,rawAlpha) {
	return null;
};
openfl_display_BitmapData.fromCanvas = function(canvas,transparent) {
	if(transparent == null) {
		transparent = true;
	}
	if(canvas == null) {
		return null;
	}
	var bitmapData = new openfl_display_BitmapData(0,0,transparent,0);
	bitmapData.__fromImage(lime_graphics_Image.fromCanvas(canvas));
	bitmapData.image.set_transparent(transparent);
	return bitmapData;
};
openfl_display_BitmapData.fromFile = function(path) {
	return null;
};
openfl_display_BitmapData.fromImage = function(image,transparent) {
	if(transparent == null) {
		transparent = true;
	}
	if(image == null || image.buffer == null) {
		return null;
	}
	var bitmapData = new openfl_display_BitmapData(0,0,transparent,0);
	bitmapData.__fromImage(image);
	bitmapData.image.set_transparent(transparent);
	if(bitmapData.image != null) {
		return bitmapData;
	} else {
		return null;
	}
};
openfl_display_BitmapData.fromTexture = function(texture) {
	if(texture == null) {
		return null;
	}
	var bitmapData = new openfl_display_BitmapData(texture.__width,texture.__height,true,0);
	bitmapData.readable = false;
	bitmapData.__texture = texture;
	bitmapData.__textureContext = texture.__textureContext;
	bitmapData.image = null;
	return bitmapData;
};
openfl_display_BitmapData.loadFromBase64 = function(base64,type) {
	return lime_graphics_Image.loadFromBase64(base64,type).then(function(image) {
		return lime_app_Future.withValue(openfl_display_BitmapData.fromImage(image));
	});
};
openfl_display_BitmapData.loadFromBytes = function(bytes,rawAlpha) {
	return lime_graphics_Image.loadFromBytes(openfl_utils_ByteArray.toBytes(bytes)).then(function(image) {
		var bitmapData = openfl_display_BitmapData.fromImage(image);
		if(rawAlpha != null) {
			bitmapData.__applyAlpha(rawAlpha);
		}
		return lime_app_Future.withValue(bitmapData);
	});
};
openfl_display_BitmapData.loadFromFile = function(path) {
	return lime_graphics_Image.loadFromFile(path).then(function(image) {
		return lime_app_Future.withValue(openfl_display_BitmapData.fromImage(image));
	});
};
openfl_display_BitmapData.prototype = {
	applyFilter: function(sourceBitmapData,sourceRect,destPoint,filter) {
		if(!this.readable || sourceBitmapData == null || !sourceBitmapData.readable) {
			return;
		}
		var needSecondBitmapData = filter.__needSecondBitmapData;
		var needCopyOfOriginal = filter.__preserveObject;
		var bitmapData2 = null;
		var bitmapData3 = null;
		if(needSecondBitmapData) {
			bitmapData2 = new openfl_display_BitmapData(this.width,this.height,true,0);
		} else {
			bitmapData2 = this;
		}
		if(needCopyOfOriginal) {
			bitmapData3 = new openfl_display_BitmapData(this.width,this.height,true,0);
		}
		if(filter.__preserveObject) {
			bitmapData3.copyPixels(this,this.rect,destPoint);
		}
		var lastBitmap = filter.__applyFilter(bitmapData2,this,sourceRect,destPoint);
		if(filter.__preserveObject) {
			lastBitmap.draw(bitmapData3,null,null);
		}
		if(needSecondBitmapData && lastBitmap == bitmapData2) {
			bitmapData2.image.version = this.image.version;
			this.image = bitmapData2.image;
		}
		this.image.dirty = true;
		this.image.version++;
	}
	,clone: function() {
		var bitmapData;
		if(!this.__isValid) {
			bitmapData = new openfl_display_BitmapData(this.width,this.height,this.transparent,0);
		} else if(!this.readable && this.image == null) {
			bitmapData = new openfl_display_BitmapData(0,0,this.transparent,0);
			bitmapData.width = this.width;
			bitmapData.height = this.height;
			bitmapData.__textureWidth = this.__textureWidth;
			bitmapData.__textureHeight = this.__textureHeight;
			bitmapData.rect.copyFrom(this.rect);
			bitmapData.__framebuffer = this.__framebuffer;
			bitmapData.__framebufferContext = this.__framebufferContext;
			bitmapData.__texture = this.__texture;
			bitmapData.__textureContext = this.__textureContext;
			bitmapData.__isValid = true;
		} else {
			bitmapData = openfl_display_BitmapData.fromImage(this.image.clone(),this.transparent);
		}
		bitmapData.__worldTransform.copyFrom(this.__worldTransform);
		bitmapData.__renderTransform.copyFrom(this.__renderTransform);
		return bitmapData;
	}
	,colorTransform: function(rect,colorTransform) {
		if(!this.readable) {
			return;
		}
		this.image.colorTransform(rect.__toLimeRectangle(),colorTransform.__toLimeColorMatrix());
	}
	,compare: function(otherBitmapData) {
		if(otherBitmapData == this) {
			return 0;
		} else if(otherBitmapData == null) {
			return -1;
		} else if(this.readable == false || otherBitmapData.readable == false) {
			return -2;
		} else if(this.width != otherBitmapData.width) {
			return -3;
		} else if(this.height != otherBitmapData.height) {
			return -4;
		}
		if(this.image != null && otherBitmapData.image != null && this.image.get_format() == otherBitmapData.image.get_format()) {
			var bytes = this.image.get_data();
			var otherBytes = otherBitmapData.image.get_data();
			var equal = true;
			var _g = 0;
			var _g1 = bytes.length;
			while(_g < _g1) {
				var i = _g++;
				if(bytes[i] != otherBytes[i]) {
					equal = false;
					break;
				}
			}
			if(equal) {
				return 0;
			}
		}
		var bitmapData = null;
		var foundDifference;
		var pixel;
		var otherPixel;
		var comparePixel;
		var r;
		var g;
		var b;
		var a;
		var _g = 0;
		var _g1 = this.height;
		while(_g < _g1) {
			var y = _g++;
			var _g2 = 0;
			var _g3 = this.width;
			while(_g2 < _g3) {
				var x = _g2++;
				foundDifference = false;
				pixel = this.getPixel32(x,y);
				otherPixel = otherBitmapData.getPixel32(x,y);
				comparePixel = 0;
				if(pixel != otherPixel) {
					r = (pixel >>> 16 & 255) - (otherPixel >>> 16 & 255);
					g = (pixel >>> 8 & 255) - (otherPixel >>> 8 & 255);
					b = (pixel & 255) - (otherPixel & 255);
					if(r < 0) {
						r *= -1;
					}
					if(g < 0) {
						g *= -1;
					}
					if(b < 0) {
						b *= -1;
					}
					if(r == 0 && g == 0 && b == 0) {
						a = (pixel >>> 24 & 255) - (otherPixel >>> 24 & 255);
						if(a != 0) {
							comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | 16711680 | (comparePixel >>> 8 & 255 & 255) << 8 | comparePixel & 255 & 255;
							comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | (comparePixel >>> 16 & 255 & 255) << 16 | 65280 | comparePixel & 255 & 255;
							comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | (comparePixel >>> 16 & 255 & 255) << 16 | (comparePixel >>> 8 & 255 & 255) << 8 | 255;
							comparePixel = (a & 255) << 24 | (comparePixel >>> 16 & 255 & 255) << 16 | (comparePixel >>> 8 & 255 & 255) << 8 | comparePixel & 255 & 255;
							foundDifference = true;
						}
					} else {
						comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | (r & 255) << 16 | (comparePixel >>> 8 & 255 & 255) << 8 | comparePixel & 255 & 255;
						comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | (comparePixel >>> 16 & 255 & 255) << 16 | (g & 255) << 8 | comparePixel & 255 & 255;
						comparePixel = (comparePixel >>> 24 & 255 & 255) << 24 | (comparePixel >>> 16 & 255 & 255) << 16 | (comparePixel >>> 8 & 255 & 255) << 8 | b & 255;
						comparePixel = -16777216 | (comparePixel >>> 16 & 255 & 255) << 16 | (comparePixel >>> 8 & 255 & 255) << 8 | comparePixel & 255 & 255;
						foundDifference = true;
					}
				}
				if(foundDifference) {
					if(bitmapData == null) {
						bitmapData = new openfl_display_BitmapData(this.width,this.height,this.transparent || otherBitmapData.transparent,0);
					}
					bitmapData.setPixel32(x,y,comparePixel);
				}
			}
		}
		if(bitmapData == null) {
			return 0;
		}
		return bitmapData;
	}
	,copyChannel: function(sourceBitmapData,sourceRect,destPoint,sourceChannel,destChannel) {
		if(!this.readable) {
			return;
		}
		var sourceChannel1;
		switch(sourceChannel) {
		case 1:
			sourceChannel1 = lime_graphics_ImageChannel.RED;
			break;
		case 2:
			sourceChannel1 = lime_graphics_ImageChannel.GREEN;
			break;
		case 4:
			sourceChannel1 = lime_graphics_ImageChannel.BLUE;
			break;
		case 8:
			sourceChannel1 = lime_graphics_ImageChannel.ALPHA;
			break;
		default:
			return;
		}
		var destChannel1;
		switch(destChannel) {
		case 1:
			destChannel1 = lime_graphics_ImageChannel.RED;
			break;
		case 2:
			destChannel1 = lime_graphics_ImageChannel.GREEN;
			break;
		case 4:
			destChannel1 = lime_graphics_ImageChannel.BLUE;
			break;
		case 8:
			destChannel1 = lime_graphics_ImageChannel.ALPHA;
			break;
		default:
			return;
		}
		this.image.copyChannel(sourceBitmapData.image,sourceRect.__toLimeRectangle(),destPoint.__toLimeVector2(),sourceChannel1,destChannel1);
	}
	,copyPixels: function(sourceBitmapData,sourceRect,destPoint,alphaBitmapData,alphaPoint,mergeAlpha) {
		if(mergeAlpha == null) {
			mergeAlpha = false;
		}
		if(!this.readable || sourceBitmapData == null) {
			return;
		}
		if(alphaPoint != null) {
			openfl_display_BitmapData.__tempVector.x = alphaPoint.x;
			openfl_display_BitmapData.__tempVector.y = alphaPoint.y;
		}
		this.image.copyPixels(sourceBitmapData.image,sourceRect.__toLimeRectangle(),destPoint.__toLimeVector2(),alphaBitmapData != null ? alphaBitmapData.image : null,alphaPoint != null ? openfl_display_BitmapData.__tempVector : null,mergeAlpha);
	}
	,dispose: function() {
		this.image = null;
		this.width = 0;
		this.height = 0;
		this.rect = null;
		this.__isValid = false;
		this.readable = false;
		this.__surface = null;
		this.__vertexBuffer = null;
		this.__framebuffer = null;
		this.__framebufferContext = null;
		this.__texture = null;
		this.__textureContext = null;
	}
	,disposeImage: function() {
		this.readable = false;
	}
	,draw: function(source,matrix,colorTransform,blendMode,clipRect,smoothing) {
		if(smoothing == null) {
			smoothing = false;
		}
		if(source == null) {
			return;
		}
		source.__update(false,true);
		var transform = openfl_geom_Matrix.__pool.get();
		transform.copyFrom(source.__renderTransform);
		transform.invert();
		if(matrix != null) {
			transform.concat(matrix);
		}
		var clipMatrix = null;
		if(clipRect != null) {
			clipMatrix = openfl_geom_Matrix.__pool.get();
			clipMatrix.copyFrom(transform);
			clipMatrix.invert();
		}
		var _colorTransform = new openfl_geom_ColorTransform();
		_colorTransform.__copyFrom(source.__worldColorTransform);
		_colorTransform.__invert();
		if(!this.readable && openfl_Lib.get_current().stage.context3D != null) {
			if(this.__textureContext == null) {
				this.__textureContext = lime_app_Application.current.__window.context;
			}
			if(colorTransform != null) {
				_colorTransform.__combine(colorTransform);
			}
			var renderer = new openfl_display_OpenGLRenderer(openfl_Lib.get_current().stage.context3D,this);
			renderer.__allowSmoothing = smoothing;
			renderer.__overrideBlendMode = blendMode;
			renderer.__worldTransform = transform;
			renderer.__worldAlpha = 1 / source.__worldAlpha;
			renderer.__worldColorTransform = _colorTransform;
			renderer.__resize(this.width,this.height);
			if(clipRect != null) {
				renderer.__pushMaskRect(clipRect,clipMatrix);
			}
			this.__drawGL(source,renderer);
			if(clipRect != null) {
				renderer.__popMaskRect();
				openfl_geom_Matrix.__pool.release(clipMatrix);
			}
		} else {
			if(colorTransform != null) {
				var bounds = openfl_geom_Rectangle.__pool.get();
				var boundsMatrix = openfl_geom_Matrix.__pool.get();
				source.__getBounds(bounds,boundsMatrix);
				var width = Math.ceil(bounds.width);
				var height = Math.ceil(bounds.height);
				boundsMatrix.tx = -bounds.x;
				boundsMatrix.ty = -bounds.y;
				var copy = new openfl_display_BitmapData(width,height,true,0);
				copy.draw(source,boundsMatrix);
				copy.colorTransform(copy.rect,colorTransform);
				copy.__renderTransform.identity();
				copy.__renderTransform.tx = bounds.x;
				copy.__renderTransform.ty = bounds.y;
				copy.__renderTransform.concat(source.__renderTransform);
				copy.__worldAlpha = source.__worldAlpha;
				copy.__worldColorTransform.__copyFrom(source.__worldColorTransform);
				source = copy;
				openfl_geom_Rectangle.__pool.release(bounds);
				openfl_geom_Matrix.__pool.release(boundsMatrix);
			}
			lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this.image);
			var renderer = new openfl_display_CanvasRenderer(this.image.buffer.__srcContext);
			renderer.__allowSmoothing = smoothing;
			renderer.__overrideBlendMode = blendMode;
			renderer.__worldTransform = transform;
			renderer.__worldAlpha = 1 / source.__worldAlpha;
			renderer.__worldColorTransform = _colorTransform;
			if(clipRect != null) {
				renderer.__pushMaskRect(clipRect,clipMatrix);
			}
			this.__drawCanvas(source,renderer);
			if(clipRect != null) {
				renderer.__popMaskRect();
				openfl_geom_Matrix.__pool.release(clipMatrix);
			}
		}
		openfl_geom_Matrix.__pool.release(transform);
	}
	,drawWithQuality: function(source,matrix,colorTransform,blendMode,clipRect,smoothing,quality) {
		if(smoothing == null) {
			smoothing = false;
		}
		this.draw(source,matrix,colorTransform,blendMode,clipRect,quality != 2 && smoothing);
	}
	,encode: function(rect,compressor,byteArray) {
		if(!this.readable || rect == null) {
			byteArray = null;
			return byteArray;
		}
		if(byteArray == null) {
			var this1 = new openfl_utils_ByteArrayData(0);
			byteArray = this1;
		}
		var image = this.image;
		if(!rect.equals(this.rect)) {
			var matrix = openfl_geom_Matrix.__pool.get();
			matrix.tx = Math.round(-rect.x);
			matrix.ty = Math.round(-rect.y);
			var bitmapData = new openfl_display_BitmapData(Math.ceil(rect.width),Math.ceil(rect.height),true,0);
			bitmapData.draw(this,matrix);
			image = bitmapData.image;
			openfl_geom_Matrix.__pool.release(matrix);
		}
		if(((compressor) instanceof openfl_display_PNGEncoderOptions)) {
			byteArray.writeBytes(openfl_utils_ByteArray.fromBytes(image.encode(lime_graphics_ImageFileFormat.PNG)),0,0);
			return byteArray;
		} else if(((compressor) instanceof openfl_display_JPEGEncoderOptions)) {
			byteArray.writeBytes(openfl_utils_ByteArray.fromBytes(image.encode(lime_graphics_ImageFileFormat.JPEG,(js_Boot.__cast(compressor , openfl_display_JPEGEncoderOptions)).quality)),0,0);
			return byteArray;
		}
		byteArray = null;
		return byteArray;
	}
	,fillRect: function(rect,color) {
		this.__fillRect(rect,color,true);
	}
	,floodFill: function(x,y,color) {
		if(!this.readable) {
			return;
		}
		this.image.floodFill(x,y,color,1);
	}
	,generateFilterRect: function(sourceRect,filter) {
		return sourceRect.clone();
	}
	,getIndexBuffer: function(context,scale9Grid) {
		var gl = context.gl;
		if(this.__indexBuffer == null || this.__indexBufferContext != context.__context || scale9Grid != null && this.__indexBufferGrid == null || this.__indexBufferGrid != null && !this.__indexBufferGrid.equals(scale9Grid)) {
			this.__indexBufferContext = context.__context;
			this.__indexBuffer = null;
			if(scale9Grid != null) {
				if(this.__indexBufferGrid == null) {
					this.__indexBufferGrid = new openfl_geom_Rectangle();
				}
				this.__indexBufferGrid.copyFrom(scale9Grid);
				var centerX = scale9Grid.width;
				var centerY = scale9Grid.height;
				if(centerX != 0 && centerY != 0) {
					var array = null;
					var vector = null;
					var view = null;
					var buffer = null;
					var len = null;
					var this1 = new Uint16Array(54);
					this.__indexBufferData = this1;
					this.__indexBufferData[0] = 0;
					this.__indexBufferData[1] = 1;
					this.__indexBufferData[2] = 2;
					this.__indexBufferData[3] = 2;
					this.__indexBufferData[4] = 1;
					this.__indexBufferData[5] = 3;
					this.__indexBufferData[6] = 4;
					this.__indexBufferData[7] = 0;
					this.__indexBufferData[8] = 5;
					this.__indexBufferData[9] = 5;
					this.__indexBufferData[10] = 0;
					this.__indexBufferData[11] = 2;
					this.__indexBufferData[12] = 6;
					this.__indexBufferData[13] = 4;
					this.__indexBufferData[14] = 7;
					this.__indexBufferData[15] = 7;
					this.__indexBufferData[16] = 4;
					this.__indexBufferData[17] = 5;
					this.__indexBufferData[18] = 8;
					this.__indexBufferData[19] = 9;
					this.__indexBufferData[20] = 0;
					this.__indexBufferData[21] = 0;
					this.__indexBufferData[22] = 9;
					this.__indexBufferData[23] = 1;
					this.__indexBufferData[24] = 10;
					this.__indexBufferData[25] = 8;
					this.__indexBufferData[26] = 4;
					this.__indexBufferData[27] = 4;
					this.__indexBufferData[28] = 8;
					this.__indexBufferData[29] = 0;
					this.__indexBufferData[30] = 11;
					this.__indexBufferData[31] = 10;
					this.__indexBufferData[32] = 6;
					this.__indexBufferData[33] = 6;
					this.__indexBufferData[34] = 10;
					this.__indexBufferData[35] = 4;
					this.__indexBufferData[36] = 12;
					this.__indexBufferData[37] = 13;
					this.__indexBufferData[38] = 8;
					this.__indexBufferData[39] = 8;
					this.__indexBufferData[40] = 13;
					this.__indexBufferData[41] = 9;
					this.__indexBufferData[42] = 14;
					this.__indexBufferData[43] = 12;
					this.__indexBufferData[44] = 10;
					this.__indexBufferData[45] = 10;
					this.__indexBufferData[46] = 12;
					this.__indexBufferData[47] = 8;
					this.__indexBufferData[48] = 15;
					this.__indexBufferData[49] = 14;
					this.__indexBufferData[50] = 11;
					this.__indexBufferData[51] = 11;
					this.__indexBufferData[52] = 14;
					this.__indexBufferData[53] = 10;
					this.__indexBuffer = context.createIndexBuffer(54);
				} else if(centerX == 0 && centerY != 0) {
					var array = null;
					var vector = null;
					var view = null;
					var buffer = null;
					var len = null;
					var this1 = new Uint16Array(18);
					this.__indexBufferData = this1;
					this.__indexBufferData[0] = 0;
					this.__indexBufferData[1] = 1;
					this.__indexBufferData[2] = 2;
					this.__indexBufferData[3] = 2;
					this.__indexBufferData[4] = 1;
					this.__indexBufferData[5] = 3;
					this.__indexBufferData[6] = 4;
					this.__indexBufferData[7] = 5;
					this.__indexBufferData[8] = 0;
					this.__indexBufferData[9] = 0;
					this.__indexBufferData[10] = 5;
					this.__indexBufferData[11] = 1;
					this.__indexBufferData[12] = 6;
					this.__indexBufferData[13] = 7;
					this.__indexBufferData[14] = 4;
					this.__indexBufferData[15] = 4;
					this.__indexBufferData[16] = 7;
					this.__indexBufferData[17] = 5;
					this.__indexBuffer = context.createIndexBuffer(18);
				} else if(centerX != 0 && centerY == 0) {
					var array = null;
					var vector = null;
					var view = null;
					var buffer = null;
					var len = null;
					var this1 = new Uint16Array(18);
					this.__indexBufferData = this1;
					this.__indexBufferData[0] = 0;
					this.__indexBufferData[1] = 1;
					this.__indexBufferData[2] = 2;
					this.__indexBufferData[3] = 2;
					this.__indexBufferData[4] = 1;
					this.__indexBufferData[5] = 3;
					this.__indexBufferData[6] = 4;
					this.__indexBufferData[7] = 0;
					this.__indexBufferData[8] = 5;
					this.__indexBufferData[9] = 5;
					this.__indexBufferData[10] = 0;
					this.__indexBufferData[11] = 2;
					this.__indexBufferData[12] = 6;
					this.__indexBufferData[13] = 4;
					this.__indexBufferData[14] = 7;
					this.__indexBufferData[15] = 7;
					this.__indexBufferData[16] = 4;
					this.__indexBufferData[17] = 5;
					this.__indexBuffer = context.createIndexBuffer(18);
				}
			} else {
				this.__indexBufferGrid = null;
			}
			if(this.__indexBuffer == null) {
				var array = null;
				var vector = null;
				var view = null;
				var buffer = null;
				var len = null;
				var this1 = new Uint16Array(6);
				this.__indexBufferData = this1;
				this.__indexBufferData[0] = 0;
				this.__indexBufferData[1] = 1;
				this.__indexBufferData[2] = 2;
				this.__indexBufferData[3] = 2;
				this.__indexBufferData[4] = 1;
				this.__indexBufferData[5] = 3;
				this.__indexBuffer = context.createIndexBuffer(6);
			}
			this.__indexBuffer.uploadFromTypedArray(this.__indexBufferData);
		}
		return this.__indexBuffer;
	}
	,getVertexBuffer: function(context,scale9Grid,targetObject) {
		var gl = context.gl;
		if(this.__vertexBuffer == null || this.__vertexBufferContext != context.__context || scale9Grid != null && this.__vertexBufferGrid == null || this.__vertexBufferGrid != null && !this.__vertexBufferGrid.equals(scale9Grid) || targetObject != null && (this.__vertexBufferWidth != targetObject.get_width() || this.__vertexBufferHeight != targetObject.get_height() || this.__vertexBufferScaleX != targetObject.get_scaleX() || this.__vertexBufferScaleY != targetObject.get_scaleY())) {
			this.__uvRect = new openfl_geom_Rectangle(0,0,this.width,this.height);
			var uvWidth = 1;
			var uvHeight = 1;
			this.__vertexBufferContext = context.__context;
			this.__vertexBuffer = null;
			if(targetObject != null) {
				this.__vertexBufferWidth = targetObject.get_width();
				this.__vertexBufferHeight = targetObject.get_height();
				this.__vertexBufferScaleX = targetObject.get_scaleX();
				this.__vertexBufferScaleY = targetObject.get_scaleY();
			}
			if(scale9Grid != null && targetObject != null) {
				if(this.__vertexBufferGrid == null) {
					this.__vertexBufferGrid = new openfl_geom_Rectangle();
				}
				this.__vertexBufferGrid.copyFrom(scale9Grid);
				this.__vertexBufferWidth = targetObject.get_width();
				this.__vertexBufferHeight = targetObject.get_height();
				this.__vertexBufferScaleX = targetObject.get_scaleX();
				this.__vertexBufferScaleY = targetObject.get_scaleY();
				var centerX = scale9Grid.width;
				var centerY = scale9Grid.height;
				if(centerX != 0 && centerY != 0) {
					var array = null;
					var vector = null;
					var view = null;
					var buffer = null;
					var len = null;
					var this1 = new Float32Array(224);
					this.__vertexBufferData = this1;
					var left = scale9Grid.x;
					var top = scale9Grid.y;
					var right = this.width - centerX - left;
					var bottom = this.height - centerY - top;
					var uvLeft = left / this.width;
					var uvTop = top / this.height;
					var uvCenterX = centerX / this.width;
					var uvCenterY = centerY / this.height;
					var uvRight = right / this.width;
					var uvBottom = bottom / this.height;
					var renderedLeft = left / targetObject.get_scaleX();
					var renderedTop = top / targetObject.get_scaleY();
					var renderedRight = right / targetObject.get_scaleX();
					var renderedBottom = bottom / targetObject.get_scaleY();
					var renderedCenterX = targetObject.get_width() / targetObject.get_scaleX() - renderedLeft - renderedRight;
					var renderedCenterY = targetObject.get_height() / targetObject.get_scaleY() - renderedTop - renderedBottom;
					this.__vertexBufferData[0] = renderedLeft;
					this.__vertexBufferData[1] = renderedTop;
					this.__vertexBufferData[3] = uvWidth * uvLeft;
					this.__vertexBufferData[4] = uvHeight * uvTop;
					this.__vertexBufferData[15] = renderedTop;
					this.__vertexBufferData[18] = uvHeight * uvTop;
					this.__vertexBufferData[28] = renderedLeft;
					this.__vertexBufferData[31] = uvWidth * uvLeft;
					this.__vertexBufferData[56] = renderedLeft + renderedCenterX;
					this.__vertexBufferData[57] = renderedTop;
					this.__vertexBufferData[59] = uvWidth * (uvLeft + uvCenterX);
					this.__vertexBufferData[60] = uvHeight * uvTop;
					this.__vertexBufferData[70] = renderedLeft + renderedCenterX;
					this.__vertexBufferData[73] = uvWidth * (uvLeft + uvCenterX);
					this.__vertexBufferData[84] = this.width;
					this.__vertexBufferData[85] = renderedTop;
					this.__vertexBufferData[87] = uvWidth;
					this.__vertexBufferData[88] = uvHeight * uvTop;
					this.__vertexBufferData[98] = this.width;
					this.__vertexBufferData[101] = uvWidth;
					this.__vertexBufferData[112] = renderedLeft;
					this.__vertexBufferData[113] = renderedTop + renderedCenterY;
					this.__vertexBufferData[115] = uvWidth * uvLeft;
					this.__vertexBufferData[116] = uvHeight * (uvTop + uvCenterY);
					this.__vertexBufferData[127] = renderedTop + renderedCenterY;
					this.__vertexBufferData[130] = uvHeight * (uvTop + uvCenterY);
					this.__vertexBufferData[140] = renderedLeft + renderedCenterX;
					this.__vertexBufferData[141] = renderedTop + renderedCenterY;
					this.__vertexBufferData[143] = uvWidth * (uvLeft + uvCenterX);
					this.__vertexBufferData[144] = uvHeight * (uvTop + uvCenterY);
					this.__vertexBufferData[154] = this.width;
					this.__vertexBufferData[155] = renderedTop + renderedCenterY;
					this.__vertexBufferData[157] = uvWidth;
					this.__vertexBufferData[158] = uvHeight * (uvTop + uvCenterY);
					this.__vertexBufferData[168] = renderedLeft;
					this.__vertexBufferData[169] = this.height;
					this.__vertexBufferData[171] = uvWidth * uvLeft;
					this.__vertexBufferData[172] = uvHeight;
					this.__vertexBufferData[183] = this.height;
					this.__vertexBufferData[186] = uvHeight;
					this.__vertexBufferData[196] = renderedLeft + renderedCenterX;
					this.__vertexBufferData[197] = this.height;
					this.__vertexBufferData[199] = uvWidth * (uvLeft + uvCenterX);
					this.__vertexBufferData[200] = uvHeight;
					this.__vertexBufferData[210] = this.width;
					this.__vertexBufferData[211] = this.height;
					this.__vertexBufferData[213] = uvWidth;
					this.__vertexBufferData[214] = uvHeight;
					this.__vertexBuffer = context.createVertexBuffer(16,14);
				} else if(centerX == 0 && centerY != 0) {
					var array = null;
					var vector = null;
					var view = null;
					var buffer = null;
					var len = null;
					var this1 = new Float32Array(112);
					this.__vertexBufferData = this1;
					var top = scale9Grid.y;
					var bottom = this.height - centerY - top;
					var uvTop = top / this.height;
					var uvCenterY = centerY / this.height;
					var uvBottom = bottom / this.height;
					var renderedTop = top / targetObject.get_scaleY();
					var renderedBottom = bottom / targetObject.get_scaleY();
					var renderedCenterY = targetObject.get_height() / targetObject.get_scaleY() - renderedTop - renderedBottom;
					var renderedWidth = targetObject.get_width() / targetObject.get_scaleX();
					this.__vertexBufferData[0] = renderedWidth;
					this.__vertexBufferData[1] = renderedTop;
					this.__vertexBufferData[3] = uvWidth;
					this.__vertexBufferData[4] = uvHeight * uvTop;
					this.__vertexBufferData[15] = renderedTop;
					this.__vertexBufferData[18] = uvHeight * uvTop;
					this.__vertexBufferData[28] = renderedWidth;
					this.__vertexBufferData[31] = uvWidth;
					this.__vertexBufferData[56] = renderedWidth;
					this.__vertexBufferData[57] = renderedTop + renderedCenterY;
					this.__vertexBufferData[59] = uvWidth;
					this.__vertexBufferData[60] = uvHeight * (uvTop + uvCenterY);
					this.__vertexBufferData[71] = renderedTop + renderedCenterY;
					this.__vertexBufferData[74] = uvHeight * (uvTop + uvCenterY);
					this.__vertexBufferData[84] = renderedWidth;
					this.__vertexBufferData[85] = this.height;
					this.__vertexBufferData[87] = uvWidth;
					this.__vertexBufferData[88] = uvHeight;
					this.__vertexBufferData[99] = this.height;
					this.__vertexBufferData[102] = uvHeight;
					this.__vertexBuffer = context.createVertexBuffer(8,14);
				} else if(centerY == 0 && centerX != 0) {
					var array = null;
					var vector = null;
					var view = null;
					var buffer = null;
					var len = null;
					var this1 = new Float32Array(112);
					this.__vertexBufferData = this1;
					var left = scale9Grid.x;
					var right = this.width - centerX - left;
					var uvLeft = left / this.width;
					var uvCenterX = centerX / this.width;
					var uvRight = right / this.width;
					var renderedLeft = left / targetObject.get_scaleX();
					var renderedRight = right / targetObject.get_scaleX();
					var renderedCenterX = targetObject.get_width() / targetObject.get_scaleX() - renderedLeft - renderedRight;
					var renderedHeight = targetObject.get_height() / targetObject.get_scaleY();
					this.__vertexBufferData[0] = renderedLeft;
					this.__vertexBufferData[1] = renderedHeight;
					this.__vertexBufferData[3] = uvWidth * uvLeft;
					this.__vertexBufferData[4] = uvHeight;
					this.__vertexBufferData[15] = renderedHeight;
					this.__vertexBufferData[18] = uvHeight;
					this.__vertexBufferData[28] = renderedLeft;
					this.__vertexBufferData[31] = uvWidth * uvLeft;
					this.__vertexBufferData[56] = renderedLeft + renderedCenterX;
					this.__vertexBufferData[57] = renderedHeight;
					this.__vertexBufferData[59] = uvWidth * (uvLeft + uvCenterX);
					this.__vertexBufferData[60] = uvHeight;
					this.__vertexBufferData[70] = renderedLeft + renderedCenterX;
					this.__vertexBufferData[73] = uvWidth * (uvLeft + uvCenterX);
					this.__vertexBufferData[84] = this.width;
					this.__vertexBufferData[85] = renderedHeight;
					this.__vertexBufferData[87] = uvWidth;
					this.__vertexBufferData[88] = uvHeight;
					this.__vertexBufferData[98] = this.width;
					this.__vertexBufferData[101] = uvWidth;
					this.__vertexBuffer = context.createVertexBuffer(8,14);
				}
			} else {
				this.__vertexBufferGrid = null;
			}
			if(this.__vertexBuffer == null) {
				var array = null;
				var vector = null;
				var view = null;
				var buffer = null;
				var len = null;
				var this1 = new Float32Array(56);
				this.__vertexBufferData = this1;
				this.__vertexBufferData[0] = this.width;
				this.__vertexBufferData[1] = this.height;
				this.__vertexBufferData[3] = uvWidth;
				this.__vertexBufferData[4] = uvHeight;
				this.__vertexBufferData[15] = this.height;
				this.__vertexBufferData[18] = uvHeight;
				this.__vertexBufferData[28] = this.width;
				this.__vertexBufferData[31] = uvWidth;
				this.__vertexBuffer = context.createVertexBuffer(3,14);
			}
			this.__vertexBuffer.uploadFromTypedArray(lime_utils_Float32Array.toArrayBufferView(this.__vertexBufferData));
		}
		return this.__vertexBuffer;
	}
	,getColorBoundsRect: function(mask,color,findColor) {
		if(findColor == null) {
			findColor = true;
		}
		if(!this.readable) {
			return new openfl_geom_Rectangle(0,0,this.width,this.height);
		}
		if(!this.transparent || (mask >> 24 & 255) > 0) {
			var color1 = color;
			if((color1 >>> 24 & 255) == 0) {
				color1 = 0;
			}
		}
		var rect = this.image.getColorBoundsRect(mask,color,findColor,1);
		return new openfl_geom_Rectangle(rect.x,rect.y,rect.width,rect.height);
	}
	,getPixel: function(x,y) {
		if(!this.readable) {
			return 0;
		}
		return this.image.getPixel(x,y,1);
	}
	,getPixel32: function(x,y) {
		if(!this.readable) {
			return 0;
		}
		return this.image.getPixel32(x,y,1);
	}
	,getPixels: function(rect) {
		if(!this.readable) {
			return null;
		}
		if(rect == null) {
			rect = this.rect;
		}
		var byteArray = openfl_utils_ByteArray.fromBytes(this.image.getPixels(rect.__toLimeRectangle(),1));
		byteArray.__endian = 0;
		return byteArray;
	}
	,getSurface: function() {
		if(!this.readable) {
			return null;
		}
		if(this.__surface == null) {
			this.__surface = lime_graphics_cairo_CairoImageSurface.fromImage(this.image);
		}
		return this.__surface;
	}
	,getTexture: function(context) {
		if(!this.__isValid) {
			return null;
		}
		if(this.__texture == null || this.__textureContext != context.__context) {
			this.__textureContext = context.__context;
			this.__texture = context.createRectangleTexture(this.width,this.height,1,false);
			this.__textureVersion = -1;
		}
		lime__$internal_graphics_ImageCanvasUtil.sync(this.image,false);
		if(this.image != null && this.image.version > this.__textureVersion) {
			if(this.__surface != null) {
				lime_graphics_cairo_CairoSurface.flush(this.__surface);
			}
			var textureImage = this.image;
			if(!openfl_display3D_textures_TextureBase.__supportsBGRA && textureImage.get_format() != 0) {
				textureImage = textureImage.clone();
				textureImage.set_format(0);
			}
			this.__texture.__uploadFromImage(textureImage);
			this.__textureVersion = this.image.version;
			this.__textureWidth = textureImage.buffer.width;
			this.__textureHeight = textureImage.buffer.height;
		}
		if(!this.readable && this.image != null) {
			this.__surface = null;
			this.image = null;
		}
		return this.__texture;
	}
	,getVector: function(rect) {
		var pixels = this.getPixels(rect);
		var length = UInt.toFloat(openfl_utils_ByteArray.get_length(pixels)) / UInt.toFloat(4) | 0;
		var result = openfl_Vector.toIntVector(null,length,true);
		var _g = 0;
		var _g1 = length;
		while(_g < _g1) {
			var i = _g++;
			result.set(i,pixels.readUnsignedInt());
		}
		return result;
	}
	,histogram: function(hRect) {
		var rect = hRect != null ? hRect : new openfl_geom_Rectangle(0,0,this.width,this.height);
		var pixels = this.getPixels(rect);
		var _g = [];
		var _g1 = [];
		var _g2 = 0;
		while(_g2 < 256) {
			var j = _g2++;
			_g1.push(0);
		}
		_g.push(_g1);
		var _g1 = [];
		var _g2 = 0;
		while(_g2 < 256) {
			var j = _g2++;
			_g1.push(0);
		}
		_g.push(_g1);
		var _g1 = [];
		var _g2 = 0;
		while(_g2 < 256) {
			var j = _g2++;
			_g1.push(0);
		}
		_g.push(_g1);
		var _g1 = [];
		var _g2 = 0;
		while(_g2 < 256) {
			var j = _g2++;
			_g1.push(0);
		}
		_g.push(_g1);
		var result = _g;
		var _g = 0;
		var _g1 = openfl_utils_ByteArray.get_length(pixels);
		while(_g < _g1) {
			var i = _g++;
			var result1 = result[i % 4];
			++result1[pixels.readUnsignedByte()];
		}
		return result;
	}
	,hitTest: function(firstPoint,firstAlphaThreshold,secondObject,secondBitmapDataPoint,secondAlphaThreshold) {
		if(secondAlphaThreshold == null) {
			secondAlphaThreshold = 1;
		}
		if(!this.readable) {
			return false;
		}
		if(((secondObject) instanceof openfl_display_Bitmap)) {
			secondObject = (js_Boot.__cast(secondObject , openfl_display_Bitmap)).__bitmapData;
		}
		if(((secondObject) instanceof openfl_geom_Point)) {
			var secondPoint = secondObject;
			var x = secondPoint.x - firstPoint.x | 0;
			var y = secondPoint.y - firstPoint.y | 0;
			if(this.rect.contains(x,y)) {
				var pixel = this.getPixel32(x,y);
				if((pixel >> 24 & 255) > firstAlphaThreshold) {
					return true;
				}
			}
		} else if(((secondObject) instanceof openfl_display_BitmapData)) {
			var secondBitmapData = secondObject;
			var x;
			var y;
			if(secondBitmapDataPoint == null) {
				x = 0;
				y = 0;
			} else {
				x = Math.round(secondBitmapDataPoint.x - firstPoint.x);
				y = Math.round(secondBitmapDataPoint.y - firstPoint.y);
			}
			var hitRect = openfl_geom_Rectangle.__pool.get();
			hitRect.setTo(x,y,secondBitmapData.width,secondBitmapData.height);
			if(this.rect.intersects(hitRect)) {
				if(x < 0) {
					hitRect.x = 0;
					hitRect.width = Math.min(secondBitmapData.width + x,this.width);
				} else {
					hitRect.width = Math.min(secondBitmapData.width,this.width - x);
				}
				if(y < 0) {
					hitRect.y = 0;
					hitRect.height = Math.min(secondBitmapData.height + y,this.height);
				} else {
					hitRect.height = Math.min(secondBitmapData.height,this.height - y);
				}
				var pixels = this.getPixels(hitRect);
				hitRect.x = x < 0 ? -x : 0;
				hitRect.y = y < 0 ? -y : 0;
				var testPixels = secondBitmapData.getPixels(hitRect);
				var length = hitRect.width * hitRect.height | 0;
				var pixel;
				var testPixel;
				var _g = 0;
				var _g1 = length;
				while(_g < _g1) {
					var i = _g++;
					pixel = pixels.readUnsignedInt();
					testPixel = testPixels.readUnsignedInt();
					if(UInt.gt(pixel >>> 24 & 255,firstAlphaThreshold) && UInt.gt(testPixel >>> 24 & 255,secondAlphaThreshold)) {
						openfl_geom_Rectangle.__pool.release(hitRect);
						return true;
					}
				}
			}
			openfl_geom_Rectangle.__pool.release(hitRect);
		} else if(((secondObject) instanceof openfl_geom_Rectangle)) {
			var secondRectangle = openfl_geom_Rectangle.__pool.get();
			secondRectangle.copyFrom(secondObject);
			secondRectangle.offset(-firstPoint.x,-firstPoint.y);
			secondRectangle.__contract(0,0,this.width,this.height);
			if(secondRectangle.width > 0 && secondRectangle.height > 0) {
				var pixels = this.getPixels(secondRectangle);
				var length = UInt.toFloat(openfl_utils_ByteArray.get_length(pixels)) / UInt.toFloat(4) | 0;
				var pixel;
				var _g = 0;
				var _g1 = length;
				while(_g < _g1) {
					var i = _g++;
					pixel = pixels.readUnsignedInt();
					if(UInt.gt(pixel >>> 24 & 255,firstAlphaThreshold)) {
						openfl_geom_Rectangle.__pool.release(secondRectangle);
						return true;
					}
				}
			}
			openfl_geom_Rectangle.__pool.release(secondRectangle);
		}
		return false;
	}
	,lock: function() {
	}
	,merge: function(sourceBitmapData,sourceRect,destPoint,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
		if(!this.readable || sourceBitmapData == null || !sourceBitmapData.readable || sourceRect == null || destPoint == null) {
			return;
		}
		this.image.merge(sourceBitmapData.image,sourceRect.__toLimeRectangle(),destPoint.__toLimeVector2(),redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
	}
	,noise: function(randomSeed,low,high,channelOptions,grayScale) {
		if(grayScale == null) {
			grayScale = false;
		}
		if(channelOptions == null) {
			channelOptions = 7;
		}
		if(high == null) {
			high = 255;
		}
		if(low == null) {
			low = 0;
		}
		if(!this.readable) {
			return;
		}
		var func = function() {
			randomSeed = randomSeed * 1103515245 + 12345;
			return (Math.abs(randomSeed / 65536) | 0) % 32768;
		};
		var rand = func;
		rand();
		var range = high - low;
		var redChannel = (channelOptions & 1) == 1;
		var greenChannel = (channelOptions & 2) >> 1 == 1;
		var blueChannel = (channelOptions & 4) >> 2 == 1;
		var alphaChannel = (channelOptions & 8) >> 3 == 1;
		var _g = 0;
		var _g1 = this.height;
		while(_g < _g1) {
			var y = _g++;
			var _g2 = 0;
			var _g3 = this.width;
			while(_g2 < _g3) {
				var x = _g2++;
				var red = 0;
				var blue = 0;
				var green = 0;
				var alpha = 255;
				if(grayScale) {
					blue = low + rand() % range;
					green = blue;
					red = green;
					alpha = 255;
				} else {
					if(redChannel) {
						red = low + rand() % range;
					}
					if(greenChannel) {
						green = low + rand() % range;
					}
					if(blueChannel) {
						blue = low + rand() % range;
					}
					if(alphaChannel) {
						alpha = low + rand() % range;
					}
				}
				var rgb = alpha;
				rgb = (rgb << 8) + red;
				rgb = (rgb << 8) + green;
				rgb = (rgb << 8) + blue;
				this.setPixel32(x,y,rgb);
			}
		}
	}
	,paletteMap: function(sourceBitmapData,sourceRect,destPoint,redArray,greenArray,blueArray,alphaArray) {
		var sw = sourceRect.width | 0;
		var sh = sourceRect.height | 0;
		var pixels = sourceBitmapData.getPixels(sourceRect);
		var pixelValue;
		var r;
		var g;
		var b;
		var a;
		var color;
		var _g = 0;
		var _g1 = sh * sw;
		while(_g < _g1) {
			var i = _g++;
			pixelValue = pixels.readUnsignedInt();
			a = alphaArray == null ? pixelValue & -16777216 : alphaArray[pixelValue >> 24 & 255];
			r = redArray == null ? pixelValue & 16711680 : redArray[pixelValue >> 16 & 255];
			g = greenArray == null ? pixelValue & 65280 : greenArray[pixelValue >> 8 & 255];
			b = blueArray == null ? pixelValue & 255 : blueArray[pixelValue & 255];
			color = a + r + g + b;
			pixels.position = i * 4;
			pixels.writeUnsignedInt(color);
		}
		pixels.position = 0;
		var destRect = openfl_geom_Rectangle.__pool.get();
		destRect.setTo(destPoint.x,destPoint.y,sw,sh);
		this.setPixels(destRect,pixels);
		openfl_geom_Rectangle.__pool.release(destRect);
	}
	,perlinNoise: function(baseX,baseY,numOctaves,randomSeed,stitch,fractalNoise,channelOptions,grayScale,offsets) {
		if(grayScale == null) {
			grayScale = false;
		}
		if(channelOptions == null) {
			channelOptions = 7;
		}
		if(!this.readable) {
			return;
		}
		var noise = new openfl_display__$internal_PerlinNoise(randomSeed,numOctaves,channelOptions,grayScale,0.5,stitch,0.15);
		noise.fill(this,baseX,baseY,0);
	}
	,scroll: function(x,y) {
		if(!this.readable) {
			return;
		}
		this.image.scroll(x,y);
	}
	,setPixel: function(x,y,color) {
		if(!this.readable) {
			return;
		}
		this.image.setPixel(x,y,color,1);
	}
	,setPixel32: function(x,y,color) {
		if(!this.readable) {
			return;
		}
		this.image.setPixel32(x,y,color,1);
	}
	,setPixels: function(rect,byteArray) {
		if(!this.readable || rect == null) {
			return;
		}
		var length = rect.width * rect.height * 4;
		if(UInt.toFloat(byteArray.length - byteArray.position) < length) {
			throw haxe_Exception.thrown(new openfl_errors_Error("End of file was encountered.",2030));
		}
		this.image.setPixels(rect.__toLimeRectangle(),openfl_utils_ByteArray.toBytePointer(byteArray),1,openfl_utils_Endian.toLimeEndian(byteArray.__endian));
	}
	,setVector: function(rect,inputVector) {
		var this1 = new openfl_utils_ByteArrayData(0);
		var byteArray = this1;
		openfl_utils_ByteArray.set_length(byteArray,inputVector.get_length() * 4);
		var color = inputVector.iterator();
		while(color.hasNext()) {
			var color1 = color.next();
			byteArray.writeUnsignedInt(color1);
		}
		byteArray.position = 0;
		this.setPixels(rect,byteArray);
	}
	,threshold: function(sourceBitmapData,sourceRect,destPoint,operation,threshold,color,mask,copySource) {
		if(copySource == null) {
			copySource = false;
		}
		if(mask == null) {
			mask = -1;
		}
		if(color == null) {
			color = 0;
		}
		if(sourceBitmapData == null || sourceRect == null || destPoint == null || sourceRect.x > sourceBitmapData.width || sourceRect.y > sourceBitmapData.height || destPoint.x > this.width || destPoint.y > this.height) {
			return 0;
		}
		return this.image.threshold(sourceBitmapData.image,sourceRect.__toLimeRectangle(),destPoint.__toLimeVector2(),operation,threshold,color,mask,copySource,1);
	}
	,unlock: function(changeRect) {
	}
	,__applyAlpha: function(alpha) {
		lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(this.image);
		lime__$internal_graphics_ImageCanvasUtil.createImageData(this.image);
		var data = this.image.buffer.data;
		var _g = 0;
		var _g1 = openfl_utils_ByteArray.get_length(alpha);
		while(_g < _g1) {
			var i = _g++;
			data[i * 4 + 3] = alpha.readUnsignedByte();
		}
		this.image.version++;
	}
	,__drawCairo: function(source,renderer) {
	}
	,__drawCanvas: function(source,renderer) {
		var buffer = this.image.buffer;
		if(!renderer.__allowSmoothing) {
			renderer.applySmoothing(buffer.__srcContext,false);
		}
		renderer.__render(source);
		if(!renderer.__allowSmoothing) {
			renderer.applySmoothing(buffer.__srcContext,true);
		}
		buffer.__srcContext.setTransform(1,0,0,1,0,0);
		buffer.__srcImageData = null;
		buffer.data = null;
		this.image.dirty = true;
		this.image.version++;
	}
	,__drawGL: function(source,renderer) {
		var context = renderer.__context3D;
		var cacheRTT = context.__state.renderToTexture;
		var cacheRTTDepthStencil = context.__state.renderToTextureDepthStencil;
		var cacheRTTAntiAlias = context.__state.renderToTextureAntiAlias;
		var cacheRTTSurfaceSelector = context.__state.renderToTextureSurfaceSelector;
		context.setRenderToTexture(this.getTexture(context),true);
		renderer.__render(source);
		if(cacheRTT != null) {
			context.setRenderToTexture(cacheRTT,cacheRTTDepthStencil,cacheRTTAntiAlias,cacheRTTSurfaceSelector);
		} else {
			context.setRenderToBackBuffer();
		}
	}
	,__fillRect: function(rect,color,allowFramebuffer) {
		if(rect == null) {
			return;
		}
		if(this.transparent && (color & -16777216) == 0) {
			color = 0;
		}
		if(allowFramebuffer && this.__texture != null && this.__texture.__glFramebuffer != null && openfl_Lib.get_current().stage.__renderer.__type == "opengl") {
			var renderer = openfl_Lib.get_current().stage.__renderer;
			var context = renderer.__context3D;
			var color1 = color;
			var useScissor = !this.rect.equals(rect);
			var cacheRTT = context.__state.renderToTexture;
			var cacheRTTDepthStencil = context.__state.renderToTextureDepthStencil;
			var cacheRTTAntiAlias = context.__state.renderToTextureAntiAlias;
			var cacheRTTSurfaceSelector = context.__state.renderToTextureSurfaceSelector;
			context.setRenderToTexture(this.__texture);
			if(useScissor) {
				context.setScissorRectangle(rect);
			}
			context.clear((color1 >>> 16 & 255) / 255,(color1 >>> 8 & 255) / 255,(color1 & 255) / 255,this.transparent ? (color1 >>> 24 & 255) / 255 : 1,0,0,1);
			if(useScissor) {
				context.setScissorRectangle(null);
			}
			if(cacheRTT != null) {
				context.setRenderToTexture(cacheRTT,cacheRTTDepthStencil,cacheRTTAntiAlias,cacheRTTSurfaceSelector);
			} else {
				context.setRenderToBackBuffer();
			}
		} else if(this.readable) {
			this.image.fillRect(rect.__toLimeRectangle(),color,1);
		}
	}
	,__fromBase64: function(base64,type) {
		var image = lime_graphics_Image.fromBase64(base64,type);
		this.__fromImage(image);
	}
	,__fromBytes: function(bytes,rawAlpha) {
		var image = lime_graphics_Image.fromBytes(openfl_utils_ByteArray.toBytes(bytes));
		this.__fromImage(image);
		if(rawAlpha != null) {
			this.__applyAlpha(rawAlpha);
		}
	}
	,__fromFile: function(path) {
		var image = lime_graphics_Image.fromFile(path);
		this.__fromImage(image);
	}
	,__fromImage: function(image) {
		if(image != null && image.buffer != null) {
			this.image = image;
			this.width = image.width;
			this.height = image.height;
			this.rect = new openfl_geom_Rectangle(0,0,image.width,image.height);
			this.__textureWidth = this.width;
			this.__textureHeight = this.height;
			this.readable = true;
			this.__isValid = true;
		}
	}
	,__getBounds: function(rect,matrix) {
		var bounds = openfl_geom_Rectangle.__pool.get();
		this.rect.__transform(bounds,matrix);
		rect.__expand(bounds.x,bounds.y,bounds.width,bounds.height);
		openfl_geom_Rectangle.__pool.release(bounds);
	}
	,__loadFromBase64: function(base64,type) {
		var _gthis = this;
		return lime_graphics_Image.loadFromBase64(base64,type).then(function(image) {
			_gthis.__fromImage(image);
			return lime_app_Future.withValue(_gthis);
		});
	}
	,__loadFromBytes: function(bytes,rawAlpha) {
		var _gthis = this;
		return lime_graphics_Image.loadFromBytes(openfl_utils_ByteArray.toBytes(bytes)).then(function(image) {
			_gthis.__fromImage(image);
			if(rawAlpha != null) {
				_gthis.__applyAlpha(rawAlpha);
			}
			return lime_app_Future.withValue(_gthis);
		});
	}
	,__loadFromFile: function(path) {
		var _gthis = this;
		return lime_graphics_Image.loadFromFile(path).then(function(image) {
			_gthis.__fromImage(image);
			return lime_app_Future.withValue(_gthis);
		});
	}
	,__resize: function(width,height) {
		this.width = width;
		this.height = height;
		this.rect.width = width;
		this.rect.height = height;
		this.__textureWidth = width;
		this.__textureHeight = height;
	}
	,__setUVRect: function(context,x,y,width,height) {
		var buffer = this.getVertexBuffer(context);
		if(buffer != null && (width != this.__uvRect.width || height != this.__uvRect.height || x != this.__uvRect.x || y != this.__uvRect.y)) {
			var gl = context.gl;
			if(this.__uvRect == null) {
				this.__uvRect = new openfl_geom_Rectangle();
			}
			this.__uvRect.setTo(x,y,width,height);
			var uvX = this.__textureWidth > 0 ? x / this.__textureWidth : 0;
			var uvY = this.__textureHeight > 0 ? y / this.__textureHeight : 0;
			var uvWidth = this.__textureWidth > 0 ? width / this.__textureWidth : 0;
			var uvHeight = this.__textureHeight > 0 ? height / this.__textureHeight : 0;
			this.__vertexBufferData[0] = width;
			this.__vertexBufferData[1] = height;
			this.__vertexBufferData[3] = uvX + uvWidth;
			this.__vertexBufferData[4] = uvY + uvHeight;
			this.__vertexBufferData[15] = height;
			this.__vertexBufferData[17] = uvX;
			this.__vertexBufferData[18] = uvY + uvHeight;
			this.__vertexBufferData[28] = width;
			this.__vertexBufferData[31] = uvX + uvWidth;
			this.__vertexBufferData[32] = uvY;
			this.__vertexBufferData[45] = uvX;
			this.__vertexBufferData[46] = uvY;
			this.__vertexBuffer.uploadFromTypedArray(lime_utils_Float32Array.toArrayBufferView(this.__vertexBufferData));
		}
	}
	,__sync: function() {
		lime__$internal_graphics_ImageCanvasUtil.sync(this.image,false);
	}
	,__update: function(transformOnly,updateChildren) {
		this.__updateTransforms();
	}
	,__updateTransforms: function(overrideTransform) {
		if(overrideTransform == null) {
			this.__worldTransform.identity();
		} else {
			this.__worldTransform.copyFrom(overrideTransform);
		}
		this.__renderTransform.copyFrom(this.__worldTransform);
	}
	,__class__: openfl_display_BitmapData
};
var openfl_display_BlendMode = {};
openfl_display_BlendMode.fromString = function(value) {
	switch(value) {
	case "add":
		return 0;
	case "alpha":
		return 1;
	case "darken":
		return 2;
	case "difference":
		return 3;
	case "erase":
		return 4;
	case "hardlight":
		return 5;
	case "invert":
		return 6;
	case "layer":
		return 7;
	case "lighten":
		return 8;
	case "multiply":
		return 9;
	case "normal":
		return 10;
	case "overlay":
		return 11;
	case "screen":
		return 12;
	case "shader":
		return 13;
	case "subtract":
		return 14;
	default:
		return null;
	}
};
openfl_display_BlendMode.toString = function(this1) {
	switch(this1) {
	case 0:
		return "add";
	case 1:
		return "alpha";
	case 2:
		return "darken";
	case 3:
		return "difference";
	case 4:
		return "erase";
	case 5:
		return "hardlight";
	case 6:
		return "invert";
	case 7:
		return "layer";
	case 8:
		return "lighten";
	case 9:
		return "multiply";
	case 10:
		return "normal";
	case 11:
		return "overlay";
	case 12:
		return "screen";
	case 13:
		return "shader";
	case 14:
		return "subtract";
	default:
		return null;
	}
};
var openfl_display_DisplayObjectRenderer = function() {
	openfl_events_EventDispatcher.call(this);
	this.__allowSmoothing = true;
	this.__tempColorTransform = new openfl_geom_ColorTransform();
	this.__worldAlpha = 1;
};
$hxClasses["openfl.display.DisplayObjectRenderer"] = openfl_display_DisplayObjectRenderer;
openfl_display_DisplayObjectRenderer.__name__ = "openfl.display.DisplayObjectRenderer";
openfl_display_DisplayObjectRenderer.__super__ = openfl_events_EventDispatcher;
openfl_display_DisplayObjectRenderer.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	__clear: function() {
	}
	,__getAlpha: function(value) {
		return value * this.__worldAlpha;
	}
	,__getColorTransform: function(value) {
		if(this.__worldColorTransform != null) {
			this.__tempColorTransform.__copyFrom(this.__worldColorTransform);
			this.__tempColorTransform.__combine(value);
			return this.__tempColorTransform;
		} else {
			return value;
		}
	}
	,__popMask: function() {
	}
	,__popMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
	}
	,__popMaskRect: function() {
	}
	,__pushMask: function(mask) {
	}
	,__pushMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
	}
	,__pushMaskRect: function(rect,transform) {
	}
	,__render: function(object) {
	}
	,__renderEvent: function(displayObject) {
		var renderer = this;
		if(displayObject.__customRenderEvent != null && displayObject.__renderable) {
			displayObject.__customRenderEvent.allowSmoothing = renderer.__allowSmoothing;
			displayObject.__customRenderEvent.objectMatrix.copyFrom(displayObject.__renderTransform);
			displayObject.__customRenderEvent.objectColorTransform.__copyFrom(displayObject.__worldColorTransform);
			displayObject.__customRenderEvent.renderer = renderer;
			switch(renderer.__type) {
			case "cairo":
				displayObject.__customRenderEvent.type = "renderCairo";
				break;
			case "canvas":
				displayObject.__customRenderEvent.type = "renderCanvas";
				break;
			case "dom":
				if(displayObject.stage != null && displayObject.__worldVisible) {
					displayObject.__customRenderEvent.type = "renderDOM";
				} else {
					displayObject.__customRenderEvent.type = "clearDOM";
				}
				break;
			case "opengl":
				if(!renderer.__cleared) {
					renderer.__clear();
				}
				var renderer1 = renderer;
				renderer1.setShader(displayObject.__worldShader);
				renderer1.__context3D.__flushGL();
				displayObject.__customRenderEvent.type = "renderOpenGL";
				break;
			default:
				return;
			}
			renderer.__setBlendMode(displayObject.__worldBlendMode);
			renderer.__pushMaskObject(displayObject);
			displayObject.dispatchEvent(displayObject.__customRenderEvent);
			renderer.__popMaskObject(displayObject);
			if(renderer.__type == "opengl") {
				var renderer1 = renderer;
				renderer1.setViewport();
			}
		}
	}
	,__resize: function(width,height) {
	}
	,__setBlendMode: function(value) {
	}
	,__shouldCacheHardware: function(displayObject,value) {
		if(displayObject == null) {
			return null;
		}
		switch(displayObject.__drawableType) {
		case 4:case 5:
			if(value == true) {
				return true;
			}
			value = this.__shouldCacheHardware_DisplayObject(displayObject,value);
			if(value == true) {
				return true;
			}
			if(displayObject.__children != null) {
				var _g = 0;
				var _g1 = displayObject.__children;
				while(_g < _g1.length) {
					var child = _g1[_g];
					++_g;
					value = this.__shouldCacheHardware_DisplayObject(child,value);
					if(value == true) {
						return true;
					}
				}
			}
			return value;
		case 7:
			if(value == true) {
				return true;
			} else {
				return false;
			}
			break;
		case 9:
			return true;
		default:
			return this.__shouldCacheHardware_DisplayObject(displayObject,value);
		}
	}
	,__shouldCacheHardware_DisplayObject: function(displayObject,value) {
		if(value == true || displayObject.__filters != null) {
			return true;
		}
		if(value == false || displayObject.__graphics != null && !openfl_display__$internal_Context3DGraphics.isCompatible(displayObject.__graphics)) {
			return false;
		}
		return null;
	}
	,__updateCacheBitmap: function(displayObject,force) {
		if(displayObject == null) {
			return false;
		}
		var renderer = this;
		switch(displayObject.__drawableType) {
		case 2:
			var bitmap = displayObject;
			if(bitmap.__bitmapData == null || bitmap.__filters == null && renderer.__type == "opengl" && bitmap.__cacheBitmap == null) {
				return false;
			}
			force = bitmap.__bitmapData.image != null && bitmap.__bitmapData.image.version != bitmap.__imageVersion;
			break;
		case 7:
			var textField = displayObject;
			if(textField.__filters == null && renderer.__type == "opengl" && textField.__cacheBitmap == null && !textField.__domRender) {
				return false;
			}
			if(force) {
				textField.__renderDirty = true;
			}
			force = force || textField.__dirty;
			break;
		case 9:
			var tilemap = displayObject;
			if(tilemap.__filters == null && renderer.__type == "opengl" && tilemap.__cacheBitmap == null) {
				return false;
			}
			break;
		default:
		}
		if(displayObject.__isCacheBitmapRender) {
			return false;
		}
		var colorTransform = openfl_geom_ColorTransform.__pool.get();
		colorTransform.__copyFrom(displayObject.__worldColorTransform);
		if(renderer.__worldColorTransform != null) {
			colorTransform.__combine(renderer.__worldColorTransform);
		}
		var updated = false;
		if(displayObject.get_cacheAsBitmap() || renderer.__type != "opengl" && !colorTransform.__isDefault(true)) {
			var rect = null;
			var needRender = displayObject.__cacheBitmap == null || displayObject.__renderDirty && (force || displayObject.__children != null && displayObject.__children.length > 0) || displayObject.opaqueBackground != displayObject.__cacheBitmapBackground;
			var softwareDirty = needRender || displayObject.__graphics != null && displayObject.__graphics.__softwareDirty || !displayObject.__cacheBitmapColorTransform.__equals(colorTransform,true);
			var hardwareDirty = needRender || displayObject.__graphics != null && displayObject.__graphics.__hardwareDirty;
			var renderType = renderer.__type;
			if(softwareDirty || hardwareDirty) {
				if(renderType == "opengl") {
					if(this.__shouldCacheHardware(displayObject,null) == false) {
						renderType = "canvas";
					}
				}
				if(softwareDirty && (renderType == "canvas" || renderType == "cairo")) {
					needRender = true;
				}
				if(hardwareDirty && renderType == "opengl") {
					needRender = true;
				}
			}
			var updateTransform = needRender || !displayObject.__cacheBitmap.__worldTransform.equals(displayObject.__worldTransform);
			var hasFilters = displayObject.__filters != null;
			if(hasFilters && !needRender) {
				var _g = 0;
				var _g1 = displayObject.__filters;
				while(_g < _g1.length) {
					var filter = _g1[_g];
					++_g;
					if(filter.__renderDirty) {
						needRender = true;
						break;
					}
				}
			}
			if(displayObject.__cacheBitmapMatrix == null) {
				displayObject.__cacheBitmapMatrix = new openfl_geom_Matrix();
			}
			var bitmapMatrix = displayObject.__cacheAsBitmapMatrix != null ? displayObject.__cacheAsBitmapMatrix : displayObject.__renderTransform;
			if(!needRender && (bitmapMatrix.a != displayObject.__cacheBitmapMatrix.a || bitmapMatrix.b != displayObject.__cacheBitmapMatrix.b || bitmapMatrix.c != displayObject.__cacheBitmapMatrix.c || bitmapMatrix.d != displayObject.__cacheBitmapMatrix.d)) {
				needRender = true;
			}
			if(!needRender && renderer.__type != "opengl" && displayObject.__cacheBitmapData != null && displayObject.__cacheBitmapData.image != null && displayObject.__cacheBitmapData.image.version < displayObject.__cacheBitmapData.__textureVersion) {
				needRender = true;
			}
			displayObject.__cacheBitmapMatrix.copyFrom(bitmapMatrix);
			displayObject.__cacheBitmapMatrix.tx = 0;
			displayObject.__cacheBitmapMatrix.ty = 0;
			var bitmapWidth = 0;
			var bitmapHeight = 0;
			var filterWidth = 0;
			var filterHeight = 0;
			var offsetX = 0.;
			var offsetY = 0.;
			if(updateTransform || needRender) {
				rect = openfl_geom_Rectangle.__pool.get();
				displayObject.__getFilterBounds(rect,displayObject.__cacheBitmapMatrix);
				filterWidth = Math.ceil(rect.width);
				filterHeight = Math.ceil(rect.height);
				offsetX = rect.x > 0 ? Math.ceil(rect.x) : Math.floor(rect.x);
				offsetY = rect.y > 0 ? Math.ceil(rect.y) : Math.floor(rect.y);
				if(displayObject.__cacheBitmapData != null) {
					if(filterWidth > displayObject.__cacheBitmapData.width || filterHeight > displayObject.__cacheBitmapData.height) {
						bitmapWidth = Math.ceil(Math.max(filterWidth * 1.25,displayObject.__cacheBitmapData.width));
						bitmapHeight = Math.ceil(Math.max(filterHeight * 1.25,displayObject.__cacheBitmapData.height));
						needRender = true;
					} else {
						bitmapWidth = displayObject.__cacheBitmapData.width;
						bitmapHeight = displayObject.__cacheBitmapData.height;
					}
				} else {
					bitmapWidth = filterWidth;
					bitmapHeight = filterHeight;
				}
			}
			if(needRender) {
				updateTransform = true;
				displayObject.__cacheBitmapBackground = displayObject.opaqueBackground;
				if(filterWidth >= 0.5 && filterHeight >= 0.5) {
					var needsFill = displayObject.opaqueBackground != null && (bitmapWidth != filterWidth || bitmapHeight != filterHeight);
					var fillColor = displayObject.opaqueBackground != null ? -16777216 | displayObject.opaqueBackground : 0;
					var bitmapColor = needsFill ? 0 : fillColor;
					var allowFramebuffer = renderer.__type == "opengl";
					if(displayObject.__cacheBitmapData == null || bitmapWidth > displayObject.__cacheBitmapData.width || bitmapHeight > displayObject.__cacheBitmapData.height) {
						displayObject.__cacheBitmapData = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,bitmapColor);
						if(displayObject.__cacheBitmap == null) {
							displayObject.__cacheBitmap = new openfl_display_Bitmap();
						}
						displayObject.__cacheBitmap.__bitmapData = displayObject.__cacheBitmapData;
						displayObject.__cacheBitmapRenderer = null;
					} else {
						displayObject.__cacheBitmapData.__fillRect(displayObject.__cacheBitmapData.rect,bitmapColor,allowFramebuffer);
					}
					if(needsFill) {
						rect.setTo(0,0,filterWidth,filterHeight);
						displayObject.__cacheBitmapData.__fillRect(rect,fillColor,allowFramebuffer);
					}
				} else {
					openfl_geom_ColorTransform.__pool.release(colorTransform);
					displayObject.__cacheBitmap = null;
					displayObject.__cacheBitmapData = null;
					displayObject.__cacheBitmapData2 = null;
					displayObject.__cacheBitmapData3 = null;
					displayObject.__cacheBitmapRenderer = null;
					if(displayObject.__drawableType == 7) {
						var textField = displayObject;
						if(textField.__cacheBitmap != null) {
							textField.__cacheBitmap.__renderTransform.tx -= textField.__offsetX;
							textField.__cacheBitmap.__renderTransform.ty -= textField.__offsetY;
						}
					}
					return true;
				}
			} else {
				displayObject.__cacheBitmapData = displayObject.__cacheBitmap.get_bitmapData();
				displayObject.__cacheBitmapData2 = null;
				displayObject.__cacheBitmapData3 = null;
			}
			if(updateTransform || needRender) {
				displayObject.__cacheBitmap.__worldTransform.copyFrom(displayObject.__worldTransform);
				if(bitmapMatrix == displayObject.__renderTransform) {
					displayObject.__cacheBitmap.__renderTransform.identity();
					displayObject.__cacheBitmap.__renderTransform.tx = displayObject.__renderTransform.tx + offsetX;
					displayObject.__cacheBitmap.__renderTransform.ty = displayObject.__renderTransform.ty + offsetY;
				} else {
					displayObject.__cacheBitmap.__renderTransform.copyFrom(displayObject.__cacheBitmapMatrix);
					displayObject.__cacheBitmap.__renderTransform.invert();
					displayObject.__cacheBitmap.__renderTransform.concat(displayObject.__renderTransform);
					displayObject.__cacheBitmap.__renderTransform.tx += offsetX;
					displayObject.__cacheBitmap.__renderTransform.ty += offsetY;
				}
			}
			displayObject.__cacheBitmap.smoothing = renderer.__allowSmoothing;
			displayObject.__cacheBitmap.__renderable = displayObject.__renderable;
			displayObject.__cacheBitmap.__worldAlpha = displayObject.__worldAlpha;
			displayObject.__cacheBitmap.__worldBlendMode = displayObject.__worldBlendMode;
			displayObject.__cacheBitmap.__worldShader = displayObject.__worldShader;
			displayObject.__cacheBitmap.set_mask(displayObject.__mask);
			if(needRender) {
				if(displayObject.__cacheBitmapRenderer == null || renderType != displayObject.__cacheBitmapRenderer.__type) {
					if(renderType == "opengl") {
						displayObject.__cacheBitmapRenderer = new openfl_display_OpenGLRenderer((js_Boot.__cast(renderer , openfl_display_OpenGLRenderer)).__context3D,displayObject.__cacheBitmapData);
					} else {
						if(displayObject.__cacheBitmapData.image == null) {
							var color = displayObject.opaqueBackground != null ? -16777216 | displayObject.opaqueBackground : 0;
							displayObject.__cacheBitmapData = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,color);
							displayObject.__cacheBitmap.__bitmapData = displayObject.__cacheBitmapData;
						}
						lime__$internal_graphics_ImageCanvasUtil.convertToCanvas(displayObject.__cacheBitmapData.image);
						displayObject.__cacheBitmapRenderer = new openfl_display_CanvasRenderer(displayObject.__cacheBitmapData.image.buffer.__srcContext);
					}
					displayObject.__cacheBitmapRenderer.__worldTransform = new openfl_geom_Matrix();
					displayObject.__cacheBitmapRenderer.__worldColorTransform = new openfl_geom_ColorTransform();
				}
				if(displayObject.__cacheBitmapColorTransform == null) {
					displayObject.__cacheBitmapColorTransform = new openfl_geom_ColorTransform();
				}
				displayObject.__cacheBitmapRenderer.__stage = displayObject.stage;
				displayObject.__cacheBitmapRenderer.__allowSmoothing = renderer.__allowSmoothing;
				displayObject.__cacheBitmapRenderer.__setBlendMode(10);
				displayObject.__cacheBitmapRenderer.__worldAlpha = 1 / displayObject.__worldAlpha;
				displayObject.__cacheBitmapRenderer.__worldTransform.copyFrom(displayObject.__renderTransform);
				displayObject.__cacheBitmapRenderer.__worldTransform.invert();
				displayObject.__cacheBitmapRenderer.__worldTransform.concat(displayObject.__cacheBitmapMatrix);
				displayObject.__cacheBitmapRenderer.__worldTransform.tx -= offsetX;
				displayObject.__cacheBitmapRenderer.__worldTransform.ty -= offsetY;
				displayObject.__cacheBitmapRenderer.__worldColorTransform.__copyFrom(colorTransform);
				displayObject.__cacheBitmapRenderer.__worldColorTransform.__invert();
				displayObject.__isCacheBitmapRender = true;
				if(displayObject.__cacheBitmapRenderer.__type == "opengl") {
					var parentRenderer = renderer;
					var childRenderer = displayObject.__cacheBitmapRenderer;
					var context = childRenderer.__context3D;
					var cacheRTT = context.__state.renderToTexture;
					var cacheRTTDepthStencil = context.__state.renderToTextureDepthStencil;
					var cacheRTTAntiAlias = context.__state.renderToTextureAntiAlias;
					var cacheRTTSurfaceSelector = context.__state.renderToTextureSurfaceSelector;
					var cacheBlendMode = parentRenderer.__blendMode;
					parentRenderer.__suspendClipAndMask();
					childRenderer.__copyShader(parentRenderer);
					displayObject.__cacheBitmapData.__setUVRect(context,0,0,filterWidth,filterHeight);
					childRenderer.__setRenderTarget(displayObject.__cacheBitmapData);
					if(displayObject.__cacheBitmapData.image != null) {
						displayObject.__cacheBitmapData.__textureVersion = displayObject.__cacheBitmapData.image.version + 1;
					}
					displayObject.__cacheBitmapData.__drawGL(displayObject,childRenderer);
					if(hasFilters) {
						var needSecondBitmapData = true;
						var needCopyOfOriginal = false;
						var _g = 0;
						var _g1 = displayObject.__filters;
						while(_g < _g1.length) {
							var filter = _g1[_g];
							++_g;
							if(filter.__preserveObject) {
								needCopyOfOriginal = true;
							}
						}
						var bitmap = displayObject.__cacheBitmapData;
						var bitmap2 = null;
						var bitmap3 = null;
						if(displayObject.__cacheBitmapData2 == null || bitmapWidth > displayObject.__cacheBitmapData2.width || bitmapHeight > displayObject.__cacheBitmapData2.height) {
							displayObject.__cacheBitmapData2 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
						} else {
							displayObject.__cacheBitmapData2.fillRect(displayObject.__cacheBitmapData2.rect,0);
							if(displayObject.__cacheBitmapData2.image != null) {
								displayObject.__cacheBitmapData2.__textureVersion = displayObject.__cacheBitmapData2.image.version + 1;
							}
						}
						displayObject.__cacheBitmapData2.__setUVRect(context,0,0,filterWidth,filterHeight);
						bitmap2 = displayObject.__cacheBitmapData2;
						if(needCopyOfOriginal) {
							if(displayObject.__cacheBitmapData3 == null || bitmapWidth > displayObject.__cacheBitmapData3.width || bitmapHeight > displayObject.__cacheBitmapData3.height) {
								displayObject.__cacheBitmapData3 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
							} else {
								displayObject.__cacheBitmapData3.fillRect(displayObject.__cacheBitmapData3.rect,0);
								if(displayObject.__cacheBitmapData3.image != null) {
									displayObject.__cacheBitmapData3.__textureVersion = displayObject.__cacheBitmapData3.image.version + 1;
								}
							}
							displayObject.__cacheBitmapData3.__setUVRect(context,0,0,filterWidth,filterHeight);
							bitmap3 = displayObject.__cacheBitmapData3;
						}
						childRenderer.__setBlendMode(10);
						childRenderer.__worldAlpha = 1;
						childRenderer.__worldTransform.identity();
						childRenderer.__worldColorTransform.__identity();
						var shader;
						var cacheBitmap;
						var _g = 0;
						var _g1 = displayObject.__filters;
						while(_g < _g1.length) {
							var filter = _g1[_g];
							++_g;
							if(filter.__preserveObject) {
								childRenderer.__setRenderTarget(bitmap3);
								childRenderer.__renderFilterPass(bitmap,childRenderer.__defaultDisplayShader,filter.__smooth);
							}
							var _g2 = 0;
							var _g3 = filter.__numShaderPasses;
							while(_g2 < _g3) {
								var i = _g2++;
								shader = filter.__initShader(childRenderer,i,filter.__preserveObject ? bitmap3 : null);
								childRenderer.__setBlendMode(filter.__shaderBlendMode);
								childRenderer.__setRenderTarget(bitmap2);
								childRenderer.__renderFilterPass(bitmap,shader,filter.__smooth);
								cacheBitmap = bitmap;
								bitmap = bitmap2;
								bitmap2 = cacheBitmap;
							}
							filter.__renderDirty = false;
						}
						displayObject.__cacheBitmap.__bitmapData = bitmap;
					}
					parentRenderer.__blendMode = 10;
					parentRenderer.__setBlendMode(cacheBlendMode);
					parentRenderer.__copyShader(childRenderer);
					if(cacheRTT != null) {
						context.setRenderToTexture(cacheRTT,cacheRTTDepthStencil,cacheRTTAntiAlias,cacheRTTSurfaceSelector);
					} else {
						context.setRenderToBackBuffer();
					}
					parentRenderer.__resumeClipAndMask(childRenderer);
					parentRenderer.setViewport();
					displayObject.__cacheBitmapColorTransform.__copyFrom(colorTransform);
				} else {
					displayObject.__cacheBitmapData.__drawCanvas(displayObject,displayObject.__cacheBitmapRenderer);
					if(hasFilters) {
						var needSecondBitmapData = false;
						var needCopyOfOriginal = false;
						var _g = 0;
						var _g1 = displayObject.__filters;
						while(_g < _g1.length) {
							var filter = _g1[_g];
							++_g;
							if(filter.__needSecondBitmapData) {
								needSecondBitmapData = true;
							}
							if(filter.__preserveObject) {
								needCopyOfOriginal = true;
							}
						}
						var bitmap = displayObject.__cacheBitmapData;
						var bitmap2 = null;
						var bitmap3 = null;
						if(needSecondBitmapData) {
							if(displayObject.__cacheBitmapData2 == null || displayObject.__cacheBitmapData2.image == null || bitmapWidth > displayObject.__cacheBitmapData2.width || bitmapHeight > displayObject.__cacheBitmapData2.height) {
								displayObject.__cacheBitmapData2 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
							} else {
								displayObject.__cacheBitmapData2.fillRect(displayObject.__cacheBitmapData2.rect,0);
							}
							bitmap2 = displayObject.__cacheBitmapData2;
						} else {
							bitmap2 = bitmap;
						}
						if(needCopyOfOriginal) {
							if(displayObject.__cacheBitmapData3 == null || displayObject.__cacheBitmapData3.image == null || bitmapWidth > displayObject.__cacheBitmapData3.width || bitmapHeight > displayObject.__cacheBitmapData3.height) {
								displayObject.__cacheBitmapData3 = new openfl_display_BitmapData(bitmapWidth,bitmapHeight,true,0);
							} else {
								displayObject.__cacheBitmapData3.fillRect(displayObject.__cacheBitmapData3.rect,0);
							}
							bitmap3 = displayObject.__cacheBitmapData3;
						}
						if(displayObject.__tempPoint == null) {
							displayObject.__tempPoint = new openfl_geom_Point();
						}
						var destPoint = displayObject.__tempPoint;
						var cacheBitmap;
						var lastBitmap;
						var _g = 0;
						var _g1 = displayObject.__filters;
						while(_g < _g1.length) {
							var filter = _g1[_g];
							++_g;
							if(filter.__preserveObject) {
								bitmap3.copyPixels(bitmap,bitmap.rect,destPoint);
							}
							lastBitmap = filter.__applyFilter(bitmap2,bitmap,bitmap.rect,destPoint);
							if(filter.__preserveObject) {
								lastBitmap.draw(bitmap3,null,displayObject.__objectTransform != null ? displayObject.__objectTransform.__colorTransform : null);
							}
							filter.__renderDirty = false;
							if(needSecondBitmapData && lastBitmap == bitmap2) {
								cacheBitmap = bitmap;
								bitmap = bitmap2;
								bitmap2 = cacheBitmap;
							}
						}
						if(displayObject.__cacheBitmapData != bitmap) {
							cacheBitmap = displayObject.__cacheBitmapData;
							displayObject.__cacheBitmapData = bitmap;
							displayObject.__cacheBitmapData2 = cacheBitmap;
							displayObject.__cacheBitmap.__bitmapData = displayObject.__cacheBitmapData;
							displayObject.__cacheBitmapRenderer = null;
						}
						displayObject.__cacheBitmap.__imageVersion = displayObject.__cacheBitmapData.__textureVersion;
					}
					displayObject.__cacheBitmapColorTransform.__copyFrom(colorTransform);
					if(!displayObject.__cacheBitmapColorTransform.__isDefault(true)) {
						displayObject.__cacheBitmapColorTransform.alphaMultiplier = 1;
						displayObject.__cacheBitmapData.colorTransform(displayObject.__cacheBitmapData.rect,displayObject.__cacheBitmapColorTransform);
					}
				}
				displayObject.__isCacheBitmapRender = false;
			}
			if(updateTransform || needRender) {
				openfl_geom_Rectangle.__pool.release(rect);
			}
			updated = updateTransform;
		} else if(displayObject.__cacheBitmap != null) {
			if(renderer.__type == "dom") {
				var domRenderer = renderer;
				domRenderer.__renderDrawableClear(displayObject.__cacheBitmap);
			}
			displayObject.__cacheBitmap = null;
			displayObject.__cacheBitmapData = null;
			displayObject.__cacheBitmapData2 = null;
			displayObject.__cacheBitmapData3 = null;
			displayObject.__cacheBitmapColorTransform = null;
			displayObject.__cacheBitmapRenderer = null;
			updated = true;
		}
		openfl_geom_ColorTransform.__pool.release(colorTransform);
		if(updated && displayObject.__drawableType == 7) {
			var textField = displayObject;
			if(textField.__cacheBitmap != null) {
				textField.__cacheBitmap.__renderTransform.tx -= textField.__offsetX;
				textField.__cacheBitmap.__renderTransform.ty -= textField.__offsetY;
			}
		}
		return updated;
	}
	,__class__: openfl_display_DisplayObjectRenderer
});
var openfl_display_CairoRenderer = function(cairo) {
	openfl_display_DisplayObjectRenderer.call(this);
};
$hxClasses["openfl.display.CairoRenderer"] = openfl_display_CairoRenderer;
openfl_display_CairoRenderer.__name__ = "openfl.display.CairoRenderer";
openfl_display_CairoRenderer.__super__ = openfl_display_DisplayObjectRenderer;
openfl_display_CairoRenderer.prototype = $extend(openfl_display_DisplayObjectRenderer.prototype,{
	applyMatrix: function(transform,cairo) {
		if(cairo == null) {
			cairo = this.cairo;
		}
		this.__matrix.copyFrom(transform);
		if(this.cairo == cairo && this.__worldTransform != null) {
			this.__matrix.concat(this.__worldTransform);
		}
		this.__matrix3.a = this.__matrix.a;
		this.__matrix3.b = this.__matrix.b;
		this.__matrix3.c = this.__matrix.c;
		this.__matrix3.d = this.__matrix.d;
		if(this.__roundPixels) {
			this.__matrix3.tx = Math.round(this.__matrix.tx);
			this.__matrix3.ty = Math.round(this.__matrix.ty);
		} else {
			this.__matrix3.tx = this.__matrix.tx;
			this.__matrix3.ty = this.__matrix.ty;
		}
		cairo.set_matrix(this.__matrix3);
	}
	,__clear: function() {
		if(this.cairo == null) {
			return;
		}
		this.cairo.identityMatrix();
		if(this.__stage != null && this.__stage.__clearBeforeRender) {
			var cacheBlendMode = this.__blendMode;
			this.__setBlendMode(10);
			this.cairo.setSourceRGB(this.__stage.__colorSplit[0],this.__stage.__colorSplit[1],this.__stage.__colorSplit[2]);
			this.cairo.paint();
			this.__setBlendMode(cacheBlendMode);
		}
	}
	,__popMask: function() {
		this.cairo.restore();
	}
	,__popMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
		if(!object.__isCacheBitmapRender && object.__mask != null) {
			this.__popMask();
		}
		if(handleScrollRect && object.__scrollRect != null) {
			this.__popMaskRect();
		}
	}
	,__popMaskRect: function() {
		this.cairo.restore();
	}
	,__pushMask: function(mask) {
		this.cairo.save();
		this.applyMatrix(mask.__renderTransform,this.cairo);
		this.cairo.newPath();
		this.__renderDrawableMask(mask);
		this.cairo.clip();
	}
	,__pushMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
		if(handleScrollRect && object.__scrollRect != null) {
			this.__pushMaskRect(object.__scrollRect,object.__renderTransform);
		}
		if(!object.__isCacheBitmapRender && object.__mask != null) {
			this.__pushMask(object.__mask);
		}
	}
	,__pushMaskRect: function(rect,transform) {
		this.cairo.save();
		this.applyMatrix(transform,this.cairo);
		this.cairo.newPath();
		this.cairo.rectangle(rect.x,rect.y,rect.width,rect.height);
		this.cairo.clip();
	}
	,__render: function(object) {
		if(this.cairo == null) {
			return;
		}
		this.__renderDrawable(object);
	}
	,__renderDrawable: function(object) {
		if(object == null) {
			return;
		}
		switch(object.__drawableType) {
		case 0:
			break;
		case 2:
			break;
		case 3:
			break;
		case 4:case 5:
			break;
		case 6:
			var simpleButton = object;
			if(!(!simpleButton.__renderable || simpleButton.__worldAlpha <= 0 || simpleButton.__currentState == null)) {
				this.__pushMaskObject(simpleButton);
				this.__renderDrawable(simpleButton.__currentState);
				this.__popMaskObject(simpleButton);
				this.__renderEvent(simpleButton);
			}
			break;
		case 7:
			break;
		case 8:
			break;
		case 9:
			break;
		default:
		}
	}
	,__renderDrawableMask: function(object) {
		if(object == null) {
			return;
		}
		switch(object.__drawableType) {
		case 0:
			break;
		case 2:
			var bitmap = object;
			this.cairo.rectangle(0,0,bitmap.get_width(),bitmap.get_height());
			break;
		case 3:
			break;
		case 4:case 5:
			break;
		case 6:
			this.__renderDrawableMask(object.__currentState);
			break;
		case 7:
			break;
		case 8:
			break;
		case 9:
			break;
		default:
		}
	}
	,__setBlendMode: function(value) {
		if(this.__overrideBlendMode != null) {
			value = this.__overrideBlendMode;
		}
		if(this.__blendMode == value) {
			return;
		}
		this.__blendMode = value;
		this.__setBlendModeCairo(this.cairo,value);
	}
	,__setBlendModeCairo: function(cairo,value) {
		switch(value) {
		case 0:
			cairo.setOperator(12);
			break;
		case 2:
			cairo.setOperator(17);
			break;
		case 3:
			cairo.setOperator(23);
			break;
		case 5:
			cairo.setOperator(21);
			break;
		case 7:
			cairo.setOperator(2);
			break;
		case 8:
			cairo.setOperator(18);
			break;
		case 9:
			cairo.setOperator(14);
			break;
		case 11:
			cairo.setOperator(16);
			break;
		case 12:
			cairo.setOperator(15);
			break;
		default:
			cairo.setOperator(2);
		}
	}
	,__class__: openfl_display_CairoRenderer
});
var openfl_display_CanvasRenderer = function(context) {
	this.pixelRatio = 1;
	openfl_display_DisplayObjectRenderer.call(this);
	this.context = context;
	this.__tempMatrix = new openfl_geom_Matrix();
	this.__type = "canvas";
};
$hxClasses["openfl.display.CanvasRenderer"] = openfl_display_CanvasRenderer;
openfl_display_CanvasRenderer.__name__ = "openfl.display.CanvasRenderer";
openfl_display_CanvasRenderer.__super__ = openfl_display_DisplayObjectRenderer;
openfl_display_CanvasRenderer.prototype = $extend(openfl_display_DisplayObjectRenderer.prototype,{
	applySmoothing: function(context,value) {
		context.imageSmoothingEnabled = value;
	}
	,setTransform: function(transform,context) {
		if(context == null) {
			context = this.context;
		} else if(this.context == context && this.__worldTransform != null) {
			this.__tempMatrix.copyFrom(transform);
			this.__tempMatrix.concat(this.__worldTransform);
			transform = this.__tempMatrix;
		}
		if(this.__roundPixels) {
			context.setTransform(transform.a,transform.b,transform.c,transform.d,transform.tx | 0,transform.ty | 0);
		} else {
			context.setTransform(transform.a,transform.b,transform.c,transform.d,transform.tx,transform.ty);
		}
	}
	,__clear: function() {
		if(this.__stage != null) {
			var cacheBlendMode = this.__blendMode;
			this.__blendMode = null;
			this.__setBlendMode(10);
			this.context.setTransform(1,0,0,1,0,0);
			this.context.globalAlpha = 1;
			if(!this.__stage.__transparent && this.__stage.__clearBeforeRender) {
				this.context.fillStyle = this.__stage.__colorString;
				this.context.fillRect(0,0,this.__stage.stageWidth * this.__stage.window.__scale,this.__stage.stageHeight * this.__stage.window.__scale);
			} else if(this.__stage.__transparent && this.__stage.__clearBeforeRender) {
				this.context.clearRect(0,0,this.__stage.stageWidth * this.__stage.window.__scale,this.__stage.stageHeight * this.__stage.window.__scale);
			}
			this.__setBlendMode(cacheBlendMode);
		}
	}
	,__popMask: function() {
		this.context.restore();
	}
	,__popMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
		if(!object.__isCacheBitmapRender && object.__mask != null) {
			this.__popMask();
		}
		if(handleScrollRect && object.__scrollRect != null) {
			this.__popMaskRect();
		}
	}
	,__popMaskRect: function() {
		this.context.restore();
	}
	,__pushMask: function(mask) {
		this.context.save();
		this.setTransform(mask.__renderTransform,this.context);
		this.context.beginPath();
		this.__renderDrawableMask(mask);
		this.context.closePath();
		this.context.clip();
	}
	,__pushMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
		if(handleScrollRect && object.__scrollRect != null) {
			this.__pushMaskRect(object.__scrollRect,object.__renderTransform);
		}
		if(!object.__isCacheBitmapRender && object.__mask != null) {
			this.__pushMask(object.__mask);
		}
	}
	,__pushMaskRect: function(rect,transform) {
		this.context.save();
		this.setTransform(transform,this.context);
		this.context.beginPath();
		this.context.rect(rect.x,rect.y,rect.width,rect.height);
		this.context.clip();
	}
	,__render: function(object) {
		this.__renderDrawable(object);
	}
	,__renderDrawable: function(object) {
		if(object == null) {
			return;
		}
		switch(object.__drawableType) {
		case 0:
			openfl_display__$internal_CanvasBitmapData.renderDrawable(object,this);
			break;
		case 2:
			openfl_display__$internal_CanvasBitmap.renderDrawable(object,this);
			break;
		case 3:
			openfl_display__$internal_CanvasDisplayObject.renderDrawable(object,this);
			break;
		case 4:case 5:
			openfl_display__$internal_CanvasDisplayObjectContainer.renderDrawable(object,this);
			break;
		case 6:
			openfl_display__$internal_CanvasSimpleButton.renderDrawable(object,this);
			break;
		case 7:
			openfl_display__$internal_CanvasTextField.renderDrawable(object,this);
			break;
		case 8:
			openfl_display__$internal_CanvasVideo.renderDrawable(object,this);
			break;
		case 9:
			openfl_display__$internal_CanvasTilemap.renderDrawable(object,this);
			break;
		default:
		}
	}
	,__renderDrawableMask: function(object) {
		if(object == null) {
			return;
		}
		switch(object.__drawableType) {
		case 0:
			openfl_display__$internal_CanvasBitmapData.renderDrawableMask(object,this);
			break;
		case 2:
			openfl_display__$internal_CanvasBitmap.renderDrawableMask(object,this);
			break;
		case 3:
			openfl_display__$internal_CanvasDisplayObject.renderDrawableMask(object,this);
			break;
		case 4:case 5:
			openfl_display__$internal_CanvasDisplayObjectContainer.renderDrawableMask(object,this);
			break;
		case 6:
			openfl_display__$internal_CanvasSimpleButton.renderDrawableMask(object,this);
			break;
		case 7:
			openfl_display__$internal_CanvasTextField.renderDrawableMask(object,this);
			break;
		case 8:
			openfl_display__$internal_CanvasVideo.renderDrawableMask(object,this);
			break;
		case 9:
			openfl_display__$internal_CanvasTilemap.renderDrawableMask(object,this);
			break;
		default:
		}
	}
	,__setBlendMode: function(value) {
		if(this.__overrideBlendMode != null) {
			value = this.__overrideBlendMode;
		}
		if(this.__blendMode == value) {
			return;
		}
		this.__blendMode = value;
		this.__setBlendModeContext(this.context,value);
	}
	,__setBlendModeContext: function(context,value) {
		switch(value) {
		case 0:
			context.globalCompositeOperation = "lighter";
			break;
		case 2:
			context.globalCompositeOperation = "darken";
			break;
		case 3:
			context.globalCompositeOperation = "difference";
			break;
		case 5:
			context.globalCompositeOperation = "hard-light";
			break;
		case 8:
			context.globalCompositeOperation = "lighten";
			break;
		case 9:
			context.globalCompositeOperation = "multiply";
			break;
		case 11:
			context.globalCompositeOperation = "overlay";
			break;
		case 12:
			context.globalCompositeOperation = "screen";
			break;
		default:
			context.globalCompositeOperation = "source-over";
		}
	}
	,__class__: openfl_display_CanvasRenderer
});
var openfl_display_CapsStyle = {};
openfl_display_CapsStyle.fromInt = function(value) {
	return value;
};
openfl_display_CapsStyle.fromString = function(value) {
	switch(value) {
	case "none":
		return 0;
	case "round":
		return 1;
	case "square":
		return 2;
	default:
		return null;
	}
};
openfl_display_CapsStyle.toInt = function(this1) {
	return this1;
};
openfl_display_CapsStyle.toString = function(this1) {
	switch(this1) {
	case 0:
		return "none";
	case 1:
		return "round";
	case 2:
		return "square";
	default:
		return null;
	}
};
var openfl_display_DOMElement = function(element) {
	openfl_display_DisplayObject.call(this);
	this.__drawableType = 10;
	this.__element = element;
};
$hxClasses["openfl.display.DOMElement"] = openfl_display_DOMElement;
openfl_display_DOMElement.__name__ = "openfl.display.DOMElement";
openfl_display_DOMElement.__super__ = openfl_display_DisplayObject;
openfl_display_DOMElement.prototype = $extend(openfl_display_DisplayObject.prototype,{
	__class__: openfl_display_DOMElement
});
var openfl_display_DOMRenderer = function(element) {
	this.pixelRatio = 1;
	openfl_display_DisplayObjectRenderer.call(this);
	this.element = element;
	openfl_display_DisplayObject.__supportDOM = true;
	var prefix = (function () {
		  var styles = window.getComputedStyle(document.documentElement, ''),
			pre = (Array.prototype.slice
			  .call(styles)
			  .join('')
			  .match(/-(moz|webkit|ms)-/) || (styles.OLink === '' && ['', 'o'])
			)[1],
			dom = ('WebKit|Moz|MS|O').match(new RegExp('(' + pre + ')', 'i'))[1];
		  return {
			dom: dom,
			lowercase: pre,
			css: '-' + pre + '-',
			js: pre[0].toUpperCase() + pre.substr(1)
		  };
		})();
	this.__vendorPrefix = prefix.lowercase;
	this.__transformProperty = prefix.lowercase == "webkit" ? "-webkit-transform" : "transform";
	this.__transformOriginProperty = prefix.lowercase == "webkit" ? "-webkit-transform-origin" : "transform-origin";
	this.__clipRects = [];
	this.__numClipRects = 0;
	this.__z = 0;
	this.__type = "dom";
	this.__canvasRenderer = new openfl_display_CanvasRenderer(null);
	this.__canvasRenderer.__isDOM = true;
};
$hxClasses["openfl.display.DOMRenderer"] = openfl_display_DOMRenderer;
openfl_display_DOMRenderer.__name__ = "openfl.display.DOMRenderer";
openfl_display_DOMRenderer.__super__ = openfl_display_DisplayObjectRenderer;
openfl_display_DOMRenderer.prototype = $extend(openfl_display_DisplayObjectRenderer.prototype,{
	applyStyle: function(parent,childElement) {
		if(parent != null && childElement != null) {
			if(parent.__style == null || childElement.parentElement != this.element) {
				this.__initializeElement(parent,childElement);
			}
			parent.__style = childElement.style;
			this.__updateClip(parent);
			this.__applyStyle(parent,true,true,true);
		}
	}
	,clearStyle: function(childElement) {
		if(childElement != null && childElement.parentElement == this.element) {
			this.element.removeChild(childElement);
		}
	}
	,__applyStyle: function(displayObject,setTransform,setAlpha,setClip) {
		var style = displayObject.__style;
		if(setTransform && displayObject.__renderTransformChanged) {
			var _this = displayObject.__renderTransform;
			var roundPixels = this.__roundPixels;
			if(roundPixels == null) {
				roundPixels = false;
			}
			style.setProperty(this.__transformProperty,roundPixels ? "matrix3d(" + _this.a + ", " + _this.b + ", 0, 0, " + _this.c + ", " + _this.d + ", 0, 0, 0, 0, 1, 0, " + (_this.tx | 0) + ", " + (_this.ty | 0) + ", 0, 1)" : "matrix3d(" + _this.a + ", " + _this.b + ", 0, 0, " + _this.c + ", " + _this.d + ", 0, 0, 0, 0, 1, 0, " + _this.tx + ", " + _this.ty + ", 0, 1)",null);
		}
		if(displayObject.__worldZ != ++this.__z) {
			displayObject.__worldZ = this.__z;
			style.setProperty("z-index",displayObject.__worldZ == null ? "null" : "" + displayObject.__worldZ,null);
		}
		if(setAlpha && displayObject.__worldAlphaChanged) {
			if(displayObject.__worldAlpha < 1) {
				style.setProperty("opacity",displayObject.__worldAlpha == null ? "null" : "" + displayObject.__worldAlpha,null);
			} else {
				style.removeProperty("opacity");
			}
		}
		if(setClip && displayObject.__worldClipChanged) {
			if(displayObject.__worldClip == null) {
				style.removeProperty("clip");
			} else {
				var clip = displayObject.__worldClip;
				style.setProperty("clip","rect(" + clip.y + "px, " + clip.get_right() + "px, " + clip.get_bottom() + "px, " + clip.x + "px)",null);
			}
		}
	}
	,__initializeElement: function(displayObject,element) {
		var style = displayObject.__style = element.style;
		style.setProperty("position","absolute",null);
		style.setProperty("top","0",null);
		style.setProperty("left","0",null);
		style.setProperty(this.__transformOriginProperty,"0 0 0",null);
		this.element.appendChild(element);
		displayObject.__worldAlphaChanged = true;
		displayObject.__renderTransformChanged = true;
		displayObject.__worldVisibleChanged = true;
		displayObject.__worldClipChanged = true;
		displayObject.__worldClip = null;
		displayObject.__worldZ = -1;
	}
	,__popMask: function() {
		this.__popMaskRect();
	}
	,__popMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
		if(object.__mask != null) {
			this.__popMask();
		}
		if(handleScrollRect && object.__scrollRect != null) {
			this.__popMaskRect();
		}
	}
	,__popMaskRect: function() {
		if(this.__numClipRects > 0) {
			this.__numClipRects--;
			if(this.__numClipRects > 0) {
				this.__currentClipRect = this.__clipRects[this.__numClipRects - 1];
			} else {
				this.__currentClipRect = null;
			}
		}
	}
	,__pushMask: function(mask) {
		this.__pushMaskRect(mask.getBounds(mask),mask.__renderTransform);
	}
	,__pushMaskObject: function(object,handleScrollRect) {
		if(handleScrollRect == null) {
			handleScrollRect = true;
		}
		if(handleScrollRect && object.__scrollRect != null) {
			this.__pushMaskRect(object.__scrollRect,object.__renderTransform);
		}
		if(object.__mask != null) {
			this.__pushMask(object.__mask);
		}
	}
	,__pushMaskRect: function(rect,transform) {
		if(this.__numClipRects == this.__clipRects.length) {
			this.__clipRects[this.__numClipRects] = new openfl_geom_Rectangle();
		}
		var clipRect = this.__clipRects[this.__numClipRects];
		rect.__transform(clipRect,transform);
		if(this.__numClipRects > 0) {
			var parentClipRect = this.__clipRects[this.__numClipRects - 1];
			clipRect.__contract(parentClipRect.x,parentClipRect.y,parentClipRect.width,parentClipRect.height);
		}
		if(clipRect.height < 0) {
			clipRect.height = 0;
		}
		if(clipRect.width < 0) {
			clipRect.width = 0;
		}
		this.__currentClipRect = clipRect;
		this.__numClipRects++;
	}
	,__render: function(object) {
		if(!this.__stage.__transparent) {
			this.element.style.background = this.__stage.__colorString;
		} else {
			this.element.style.background = "none";
		}
		this.__z = 1;
		this.__renderDrawable(object);
	}
	,__renderDrawable: function(object) {
		if(object == null) {
			return;
		}
		switch(object.__drawableType) {
		case 0:
			break;
		case 2:
			openfl_display__$internal_DOMBitmap.renderDrawable(object,this);
			break;
		case 3:
			openfl_display__$internal_DOMDisplayObject.renderDrawable(object,this);
			break;
		case 4:case 5:
			openfl_display__$internal_DOMDisplayObjectContainer.renderDrawable(object,this);
			break;
		case 6:
			openfl_display__$internal_DOMSimpleButton.renderDrawable(object,this);
			break;
		case 7:
			openfl_display__$internal_DOMTextField.renderDrawable(object,this);
			break;
		case 8:
			openfl_display__$internal_DOMVideo.renderDrawable(object,this);
			break;
		case 9:
			openfl_display__$internal_DOMTilemap.renderDrawable(object,this);
			break;
		case 10:
			var domElement = object;
			if(domElement.stage != null && domElement.__worldVisible && domElement.__renderable) {
				if(!domElement.__active) {
					this.__initializeElement(domElement,domElement.__element);
					domElement.__active = true;
				}
				this.__updateClip(domElement);
				this.__applyStyle(domElement,true,true,true);
			} else if(domElement.__active) {
				this.element.removeChild(domElement.__element);
				domElement.__active = false;
			}
			openfl_display__$internal_DOMDisplayObject.renderDrawable(domElement,this);
			break;
		default:
		}
	}
	,__renderDrawableClear: function(object) {
		if(object == null) {
			return;
		}
		switch(object.__drawableType) {
		case 0:
			break;
		case 2:
			openfl_display__$internal_DOMBitmap.renderDrawableClear(object,this);
			break;
		case 3:
			openfl_display__$internal_DOMDisplayObject.renderDrawableClear(object,this);
			break;
		case 4:case 5:
			openfl_display__$internal_DOMDisplayObjectContainer.renderDrawableClear(object,this);
			break;
		case 6:
			openfl_display__$internal_DOMSimpleButton.renderDrawableClear(object,this);
			break;
		case 7:
			openfl_display__$internal_DOMTextField.renderDrawableClear(object,this);
			break;
		case 8:
			openfl_display__$internal_DOMVideo.renderDrawableClear(object,this);
			break;
		case 9:
			openfl_display__$internal_DOMTilemap.renderDrawableClear(object,this);
			break;
		default:
		}
	}
	,__setBlendMode: function(value) {
		if(this.__overrideBlendMode != null) {
			value = this.__overrideBlendMode;
		}
		if(this.__blendMode == value) {
			return;
		}
		this.__blendMode = value;
	}
	,__updateClip: function(displayObject) {
		if(this.__currentClipRect == null) {
			displayObject.__worldClipChanged = displayObject.__worldClip != null;
			displayObject.__worldClip = null;
		} else {
			if(displayObject.__worldClip == null) {
				displayObject.__worldClip = new openfl_geom_Rectangle();
			}
			var clip = openfl_geom_Rectangle.__pool.get();
			var matrix = openfl_geom_Matrix.__pool.get();
			matrix.copyFrom(displayObject.__renderTransform);
			matrix.invert();
			this.__currentClipRect.__transform(clip,matrix);
			if(clip.equals(displayObject.__worldClip)) {
				displayObject.__worldClipChanged = false;
			} else {
				displayObject.__worldClip.copyFrom(clip);
				displayObject.__worldClipChanged = true;
			}
			openfl_geom_Rectangle.__pool.release(clip);
			openfl_geom_Matrix.__pool.release(matrix);
		}
	}
	,__class__: openfl_display_DOMRenderer
});
var openfl_display_Shader = function(code) {
	this.byteCode = code;
	this.precisionHint = 1;
	this.__glSourceDirty = true;
	this.__numPasses = 1;
	this.__data = openfl_display_ShaderData._new(code);
};
$hxClasses["openfl.display.Shader"] = openfl_display_Shader;
openfl_display_Shader.__name__ = "openfl.display.Shader";
openfl_display_Shader.prototype = {
	__clearUseArray: function() {
		var _g = 0;
		var _g1 = this.__paramBool;
		while(_g < _g1.length) {
			var parameter = _g1[_g];
			++_g;
			parameter.__useArray = false;
		}
		var _g = 0;
		var _g1 = this.__paramFloat;
		while(_g < _g1.length) {
			var parameter = _g1[_g];
			++_g;
			parameter.__useArray = false;
		}
		var _g = 0;
		var _g1 = this.__paramInt;
		while(_g < _g1.length) {
			var parameter = _g1[_g];
			++_g;
			parameter.__useArray = false;
		}
	}
	,__createGLShader: function(source,type) {
		var gl = this.__context.gl;
		var shader = gl.createShader(type);
		gl.shaderSource(shader,source);
		gl.compileShader(shader);
		if(gl.getShaderParameter(shader,gl.COMPILE_STATUS) == 0) {
			var message = type == gl.VERTEX_SHADER ? "Error compiling vertex shader" : "Error compiling fragment shader";
			message += "\n" + gl.getShaderInfoLog(shader);
			message += "\n" + source;
			lime_utils_Log.error(message,{ fileName : "openfl/display/Shader.hx", lineNumber : 331, className : "openfl.display.Shader", methodName : "__createGLShader"});
		}
		return shader;
	}
	,__createGLProgram: function(vertexSource,fragmentSource) {
		var gl = this.__context.gl;
		var vertexShader = this.__createGLShader(vertexSource,gl.VERTEX_SHADER);
		var fragmentShader = this.__createGLShader(fragmentSource,gl.FRAGMENT_SHADER);
		var program = gl.createProgram();
		var _g = 0;
		var _g1 = this.__paramFloat;
		while(_g < _g1.length) {
			var param = _g1[_g];
			++_g;
			if(param.name.indexOf("Position") > -1 && StringTools.startsWith(param.name,"openfl_")) {
				gl.bindAttribLocation(program,0,param.name);
				break;
			}
		}
		gl.attachShader(program,vertexShader);
		gl.attachShader(program,fragmentShader);
		gl.linkProgram(program);
		if(gl.getProgramParameter(program,gl.LINK_STATUS) == 0) {
			var message = "Unable to initialize the shader program";
			message += "\n" + gl.getProgramInfoLog(program);
			lime_utils_Log.error(message,{ fileName : "openfl/display/Shader.hx", lineNumber : 364, className : "openfl.display.Shader", methodName : "__createGLProgram"});
		}
		return program;
	}
	,__disable: function() {
		if(this.program != null) {
			this.__disableGL();
		}
	}
	,__disableGL: function() {
		var gl = this.__context.gl;
		var textureCount = 0;
		var _g = 0;
		var _g1 = this.__inputBitmapData;
		while(_g < _g1.length) {
			var input = _g1[_g];
			++_g;
			input.__disableGL(this.__context,textureCount);
			++textureCount;
		}
		var _g = 0;
		var _g1 = this.__paramBool;
		while(_g < _g1.length) {
			var parameter = _g1[_g];
			++_g;
			parameter.__disableGL(this.__context);
		}
		var _g = 0;
		var _g1 = this.__paramFloat;
		while(_g < _g1.length) {
			var parameter = _g1[_g];
			++_g;
			parameter.__disableGL(this.__context);
		}
		var _g = 0;
		var _g1 = this.__paramInt;
		while(_g < _g1.length) {
			var parameter = _g1[_g];
			++_g;
			parameter.__disableGL(this.__context);
		}
		this.__context.__bindGLArrayBuffer(null);
		if(this.__context.__context.type == "opengl") {
			gl.disable(gl.TEXTURE_2D);
		}
	}
	,__enable: function() {
		this.__init();
		if(this.program != null) {
			this.__enableGL();
		}
	}
	,__enableGL: function() {
		var textureCount = 0;
		var gl = this.__context.gl;
		var _g = 0;
		var _g1 = this.__inputBitmapData;
		while(_g < _g1.length) {
			var input = _g1[_g];
			++_g;
			gl.uniform1i(input.index,textureCount);
			++textureCount;
		}
		if(this.__context.__context.type == "opengl" && textureCount > 0) {
			gl.enable(gl.TEXTURE_2D);
		}
	}
	,__init: function() {
		if(this.__data == null) {
			this.__data = openfl_display_ShaderData._new(null);
		}
		if(this.__glFragmentSource != null && this.__glVertexSource != null && (this.program == null || this.__glSourceDirty)) {
			this.__initGL();
		}
	}
	,__initGL: function() {
		if(this.__glSourceDirty || this.__paramBool == null) {
			this.__glSourceDirty = false;
			this.program = null;
			this.__inputBitmapData = [];
			this.__paramBool = [];
			this.__paramFloat = [];
			this.__paramInt = [];
			this.__processGLData(this.get_glVertexSource(),"attribute");
			this.__processGLData(this.get_glVertexSource(),"uniform");
			this.__processGLData(this.get_glFragmentSource(),"uniform");
		}
		if(this.__context != null && this.program == null) {
			var gl = this.__context.gl;
			var prefix = "#ifdef GL_ES\n\t\t\t\t" + (this.precisionHint == 1 ? "#ifdef GL_FRAGMENT_PRECISION_HIGH\n\t\t\t\tprecision highp float;\n\t\t\t\t#else\n\t\t\t\tprecision mediump float;\n\t\t\t\t#endif" : "precision lowp float;") + "\n\t\t\t\t#endif\n\t\t\t\t";
			var vertex = prefix + this.get_glVertexSource();
			var fragment = prefix + this.get_glFragmentSource();
			var id = vertex + fragment;
			if(Object.prototype.hasOwnProperty.call(this.__context.__programs.h,id)) {
				this.program = this.__context.__programs.h[id];
			} else {
				this.program = this.__context.createProgram(1);
				this.program.__glProgram = this.__createGLProgram(vertex,fragment);
				this.__context.__programs.h[id] = this.program;
			}
			if(this.program != null) {
				this.glProgram = this.program.__glProgram;
				var _g = 0;
				var _g1 = this.__inputBitmapData;
				while(_g < _g1.length) {
					var input = _g1[_g];
					++_g;
					if(input.__isUniform) {
						input.index = gl.getUniformLocation(this.glProgram,input.name);
					} else {
						input.index = gl.getAttribLocation(this.glProgram,input.name);
					}
				}
				var _g = 0;
				var _g1 = this.__paramBool;
				while(_g < _g1.length) {
					var parameter = _g1[_g];
					++_g;
					if(parameter.__isUniform) {
						parameter.index = gl.getUniformLocation(this.glProgram,parameter.name);
					} else {
						parameter.index = gl.getAttribLocation(this.glProgram,parameter.name);
					}
				}
				var _g = 0;
				var _g1 = this.__paramFloat;
				while(_g < _g1.length) {
					var parameter = _g1[_g];
					++_g;
					if(parameter.__isUniform) {
						parameter.index = gl.getUniformLocation(this.glProgram,parameter.name);
					} else {
						parameter.index = gl.getAttribLocation(this.glProgram,parameter.name);
					}
				}
				var _g = 0;
				var _g1 = this.__paramInt;
				while(_g < _g1.length) {
					var parameter = _g1[_g];
					++_g;
					if(parameter.__isUniform) {
						parameter.index = gl.getUniformLocation(this.glProgram,parameter.name);
					} else {
						parameter.index = gl.getAttribLocation(this.glProgram,parameter.name);
					}
				}
			}
		}
	}
	,__processGLData: function(source,storageType) {
		var lastMatch = 0;
		var position;
		var regex;
		var name;
		var type;
		if(storageType == "uniform") {
			regex = new EReg("uniform ([A-Za-z0-9]+) ([A-Za-z0-9_]+)","");
		} else {
			regex = new EReg("attribute ([A-Za-z0-9]+) ([A-Za-z0-9_]+)","");
		}
		while(regex.matchSub(source,lastMatch)) {
			type = regex.matched(1);
			name = regex.matched(2);
			if(StringTools.startsWith(name,"gl_")) {
				continue;
			}
			var isUniform = storageType == "uniform";
			if(StringTools.startsWith(type,"sampler")) {
				var input = new openfl_display_ShaderInput();
				input.name = name;
				input.__isUniform = isUniform;
				this.__inputBitmapData.push(input);
				switch(name) {
				case "bitmap":
					this.__bitmap = input;
					break;
				case "openfl_Texture":
					this.__texture = input;
					break;
				default:
				}
				this.__data[name] = input;
				if(this.__isGenerated) {
					this[name] = input;
				}
			} else if(!Object.prototype.hasOwnProperty.call(this.__data,name) || Reflect.field(this.__data,name) == null) {
				var parameterType;
				switch(type) {
				case "bool":
					parameterType = 0;
					break;
				case "bvec2":
					parameterType = 1;
					break;
				case "bvec3":
					parameterType = 2;
					break;
				case "bvec4":
					parameterType = 3;
					break;
				case "dvec2":case "vec2":
					parameterType = 5;
					break;
				case "dvec3":case "vec3":
					parameterType = 6;
					break;
				case "double":case "float":
					parameterType = 4;
					break;
				case "ivec3":case "uvec3":
					parameterType = 10;
					break;
				case "ivec4":case "uvec4":
					parameterType = 11;
					break;
				case "mat2":case "mat2x2":
					parameterType = 12;
					break;
				case "mat2x3":
					parameterType = 13;
					break;
				case "mat2x4":
					parameterType = 14;
					break;
				case "mat3x2":
					parameterType = 15;
					break;
				case "mat3":case "mat3x3":
					parameterType = 16;
					break;
				case "mat3x4":
					parameterType = 17;
					break;
				case "mat4":case "mat4x4":
					parameterType = 20;
					break;
				case "mat4x2":
					parameterType = 18;
					break;
				case "mat4x3":
					parameterType = 19;
					break;
				case "int":case "uint":
					parameterType = 8;
					break;
				case "ivec2":case "uvec2":
					parameterType = 9;
					break;
				case "dvec4":case "vec4":
					parameterType = 7;
					break;
				default:
					parameterType = null;
				}
				var length;
				switch(parameterType) {
				case 1:case 5:case 9:
					length = 2;
					break;
				case 3:case 7:case 11:case 12:
					length = 4;
					break;
				case 2:case 6:case 10:
					length = 3;
					break;
				case 16:
					length = 9;
					break;
				case 20:
					length = 16;
					break;
				default:
					length = 1;
				}
				var arrayLength;
				switch(parameterType) {
				case 12:
					arrayLength = 2;
					break;
				case 16:
					arrayLength = 3;
					break;
				case 20:
					arrayLength = 4;
					break;
				default:
					arrayLength = 1;
				}
				switch(parameterType) {
				case 0:case 1:case 2:case 3:
					var parameter = new openfl_display_ShaderParameter();
					parameter.set_name(name);
					parameter.type = parameterType;
					parameter.__arrayLength = arrayLength;
					parameter.__isBool = true;
					parameter.__isUniform = isUniform;
					parameter.__length = length;
					this.__paramBool.push(parameter);
					if(name == "openfl_HasColorTransform") {
						this.__hasColorTransform = parameter;
					}
					this.__data[name] = parameter;
					if(this.__isGenerated) {
						this[name] = parameter;
					}
					break;
				case 8:case 9:case 10:case 11:
					var parameter1 = new openfl_display_ShaderParameter();
					parameter1.set_name(name);
					parameter1.type = parameterType;
					parameter1.__arrayLength = arrayLength;
					parameter1.__isInt = true;
					parameter1.__isUniform = isUniform;
					parameter1.__length = length;
					this.__paramInt.push(parameter1);
					this.__data[name] = parameter1;
					if(this.__isGenerated) {
						this[name] = parameter1;
					}
					break;
				default:
					var parameter2 = new openfl_display_ShaderParameter();
					parameter2.set_name(name);
					parameter2.type = parameterType;
					parameter2.__arrayLength = arrayLength;
					if(arrayLength > 0) {
						var elements = arrayLength * arrayLength;
						var array = null;
						var vector = null;
						var view = null;
						var buffer = null;
						var len = null;
						var this1;
						if(elements != null) {
							this1 = new Float32Array(elements);
						} else if(array != null) {
							this1 = new Float32Array(array);
						} else if(vector != null) {
							this1 = new Float32Array(vector.__array);
						} else if(view != null) {
							this1 = new Float32Array(view);
						} else if(buffer != null) {
							if(len == null) {
								this1 = new Float32Array(buffer,0);
							} else {
								this1 = new Float32Array(buffer,0,len);
							}
						} else {
							this1 = null;
						}
						parameter2.__uniformMatrix = this1;
					}
					parameter2.__isFloat = true;
					parameter2.__isUniform = isUniform;
					parameter2.__length = length;
					this.__paramFloat.push(parameter2);
					if(StringTools.startsWith(name,"openfl_")) {
						switch(name) {
						case "openfl_Alpha":
							this.__alpha = parameter2;
							break;
						case "openfl_ColorMultiplier":
							this.__colorMultiplier = parameter2;
							break;
						case "openfl_ColorOffset":
							this.__colorOffset = parameter2;
							break;
						case "openfl_Matrix":
							this.__matrix = parameter2;
							break;
						case "openfl_Position":
							this.__position = parameter2;
							break;
						case "openfl_TextureCoord":
							this.__textureCoord = parameter2;
							break;
						case "openfl_TextureSize":
							this.__textureSize = parameter2;
							break;
						default:
						}
					}
					this.__data[name] = parameter2;
					if(this.__isGenerated) {
						this[name] = parameter2;
					}
				}
			}
			position = regex.matchedPos();
			lastMatch = position.pos + position.len;
		}
	}
	,__update: function() {
		if(this.program != null) {
			this.__updateGL();
		}
	}
	,__updateFromBuffer: function(shaderBuffer,bufferOffset) {
		if(this.program != null) {
			this.__updateGLFromBuffer(shaderBuffer,bufferOffset);
		}
	}
	,__updateGL: function() {
		var textureCount = 0;
		var _g = 0;
		var _g1 = this.__inputBitmapData;
		while(_g < _g1.length) {
			var input = _g1[_g];
			++_g;
			input.__updateGL(this.__context,textureCount);
			++textureCount;
		}
		var _g = 0;
		var _g1 = this.__paramBool;
		while(_g < _g1.length) {
			var parameter = _g1[_g];
			++_g;
			parameter.__updateGL(this.__context);
		}
		var _g = 0;
		var _g1 = this.__paramFloat;
		while(_g < _g1.length) {
			var parameter = _g1[_g];
			++_g;
			parameter.__updateGL(this.__context);
		}
		var _g = 0;
		var _g1 = this.__paramInt;
		while(_g < _g1.length) {
			var parameter = _g1[_g];
			++_g;
			parameter.__updateGL(this.__context);
		}
	}
	,__updateGLFromBuffer: function(shaderBuffer,bufferOffset) {
		var textureCount = 0;
		var input;
		var inputData;
		var inputFilter;
		var inputMipFilter;
		var inputWrap;
		var _g = 0;
		var _g1 = shaderBuffer.inputCount;
		while(_g < _g1) {
			var i = _g++;
			input = shaderBuffer.inputRefs[i];
			inputData = shaderBuffer.inputs[i];
			inputFilter = shaderBuffer.inputFilter[i];
			inputMipFilter = shaderBuffer.inputMipFilter[i];
			inputWrap = shaderBuffer.inputWrap[i];
			if(inputData != null) {
				input.__updateGL(this.__context,textureCount,inputData,inputFilter,inputMipFilter,inputWrap);
				++textureCount;
			}
		}
		var gl = this.__context.gl;
		if(shaderBuffer.paramDataLength > 0) {
			if(shaderBuffer.paramDataBuffer == null) {
				shaderBuffer.paramDataBuffer = gl.createBuffer();
			}
			this.__context.__bindGLArrayBuffer(shaderBuffer.paramDataBuffer);
			lime_graphics_WebGLRenderContext.bufferData(gl,gl.ARRAY_BUFFER,shaderBuffer.paramData,gl.DYNAMIC_DRAW);
		} else {
			this.__context.__bindGLArrayBuffer(null);
		}
		var boolIndex = 0;
		var floatIndex = 0;
		var intIndex = 0;
		var boolCount = shaderBuffer.paramBoolCount;
		var floatCount = shaderBuffer.paramFloatCount;
		var paramData = shaderBuffer.paramData;
		var boolRef;
		var floatRef;
		var intRef;
		var hasOverride;
		var overrideBoolValue = null;
		var overrideFloatValue = null;
		var overrideIntValue = null;
		var _g = 0;
		var _g1 = shaderBuffer.paramCount;
		while(_g < _g1) {
			var i = _g++;
			hasOverride = false;
			if(i < boolCount) {
				boolRef = shaderBuffer.paramRefs_Bool[boolIndex];
				var _g2 = 0;
				var _g3 = shaderBuffer.overrideBoolCount;
				while(_g2 < _g3) {
					var j = _g2++;
					if(boolRef.name == shaderBuffer.overrideBoolNames[j]) {
						overrideBoolValue = shaderBuffer.overrideBoolValues[j];
						hasOverride = true;
						break;
					}
				}
				if(hasOverride) {
					boolRef.__updateGL(this.__context,overrideBoolValue);
				} else {
					boolRef.__updateGLFromBuffer(this.__context,paramData,shaderBuffer.paramPositions[i],shaderBuffer.paramLengths[i],bufferOffset);
				}
				++boolIndex;
			} else if(i < boolCount + floatCount) {
				floatRef = shaderBuffer.paramRefs_Float[floatIndex];
				var _g4 = 0;
				var _g5 = shaderBuffer.overrideFloatCount;
				while(_g4 < _g5) {
					var j1 = _g4++;
					if(floatRef.name == shaderBuffer.overrideFloatNames[j1]) {
						overrideFloatValue = shaderBuffer.overrideFloatValues[j1];
						hasOverride = true;
						break;
					}
				}
				if(hasOverride) {
					floatRef.__updateGL(this.__context,overrideFloatValue);
				} else {
					floatRef.__updateGLFromBuffer(this.__context,paramData,shaderBuffer.paramPositions[i],shaderBuffer.paramLengths[i],bufferOffset);
				}
				++floatIndex;
			} else {
				intRef = shaderBuffer.paramRefs_Int[intIndex];
				var _g6 = 0;
				var _g7 = shaderBuffer.overrideIntCount;
				while(_g6 < _g7) {
					var j2 = _g6++;
					if(intRef.name == shaderBuffer.overrideIntNames[j2]) {
						overrideIntValue = shaderBuffer.overrideIntValues[j2];
						hasOverride = true;
						break;
					}
				}
				if(hasOverride) {
					intRef.__updateGL(this.__context,overrideIntValue);
				} else {
					intRef.__updateGLFromBuffer(this.__context,paramData,shaderBuffer.paramPositions[i],shaderBuffer.paramLengths[i],bufferOffset);
				}
				++intIndex;
			}
		}
	}
	,get_data: function() {
		if(this.__glSourceDirty || this.__data == null) {
			this.__init();
		}
		return this.__data;
	}
	,set_data: function(value) {
		return this.__data = value;
	}
	,get_glFragmentSource: function() {
		return this.__glFragmentSource;
	}
	,set_glFragmentSource: function(value) {
		if(value != this.__glFragmentSource) {
			this.__glSourceDirty = true;
		}
		return this.__glFragmentSource = value;
	}
	,get_glVertexSource: function() {
		return this.__glVertexSource;
	}
	,set_glVertexSource: function(value) {
		if(value != this.__glVertexSource) {
			this.__glSourceDirty = true;
		}
		return this.__glVertexSource = value;
	}
	,__class__: openfl_display_Shader
	,__properties__: {set_glVertexSource:"set_glVertexSource",get_glVertexSource:"get_glVertexSource",set_glFragmentSource:"set_glFragmentSource",get_glFragmentSource:"get_glFragmentSource",set_data:"set_data",get_data:"get_data"}
};
var openfl_display_DisplayObjectShader = function(code) {
	if(this.__glFragmentSource == null) {
		this.__glFragmentSource = "varying float openfl_Alphav;\n\t\tvarying vec4 openfl_ColorMultiplierv;\n\t\tvarying vec4 openfl_ColorOffsetv;\n\t\tvarying vec2 openfl_TextureCoordv;\n\n\t\tuniform bool openfl_HasColorTransform;\n\t\tuniform sampler2D openfl_Texture;\n\t\tuniform vec2 openfl_TextureSize;\n\n\t\tvoid main(void) {\n\n\t\t\tvec4 color = texture2D (openfl_Texture, openfl_TextureCoordv);\n\n\t\tif (color.a == 0.0) {\n\n\t\t\tgl_FragColor = vec4 (0.0, 0.0, 0.0, 0.0);\n\n\t\t} else if (openfl_HasColorTransform) {\n\n\t\t\tcolor = vec4 (color.rgb / color.a, color.a);\n\n\t\t\tmat4 colorMultiplier = mat4 (0);\n\t\t\tcolorMultiplier[0][0] = openfl_ColorMultiplierv.x;\n\t\t\tcolorMultiplier[1][1] = openfl_ColorMultiplierv.y;\n\t\t\tcolorMultiplier[2][2] = openfl_ColorMultiplierv.z;\n\t\t\tcolorMultiplier[3][3] = 1.0; // openfl_ColorMultiplierv.w;\n\n\t\t\tcolor = clamp (openfl_ColorOffsetv + (color * colorMultiplier), 0.0, 1.0);\n\n\t\t\tif (color.a > 0.0) {\n\n\t\t\t\tgl_FragColor = vec4 (color.rgb * color.a * openfl_Alphav, color.a * openfl_Alphav);\n\n\t\t\t} else {\n\n\t\t\t\tgl_FragColor = vec4 (0.0, 0.0, 0.0, 0.0);\n\n\t\t\t}\n\n\t\t} else {\n\n\t\t\tgl_FragColor = color * openfl_Alphav;\n\n\t\t}\n\n\t\t}";
	}
	if(this.__glVertexSource == null) {
		this.__glVertexSource = "attribute float openfl_Alpha;\n\t\tattribute vec4 openfl_ColorMultiplier;\n\t\tattribute vec4 openfl_ColorOffset;\n\t\tattribute vec4 openfl_Position;\n\t\tattribute vec2 openfl_TextureCoord;\n\n\t\tvarying float openfl_Alphav;\n\t\tvarying vec4 openfl_ColorMultiplierv;\n\t\tvarying vec4 openfl_ColorOffsetv;\n\t\tvarying vec2 openfl_TextureCoordv;\n\n\t\tuniform mat4 openfl_Matrix;\n\t\tuniform bool openfl_HasColorTransform;\n\t\tuniform vec2 openfl_TextureSize;\n\n\t\tvoid main(void) {\n\n\t\t\topenfl_Alphav = openfl_Alpha;\n\t\topenfl_TextureCoordv = openfl_TextureCoord;\n\n\t\tif (openfl_HasColorTransform) {\n\n\t\t\topenfl_ColorMultiplierv = openfl_ColorMultiplier;\n\t\t\topenfl_ColorOffsetv = openfl_ColorOffset / 255.0;\n\n\t\t}\n\n\t\tgl_Position = openfl_Matrix * openfl_Position;\n\n\t\t}";
	}
	openfl_display_Shader.call(this,code);
	this.__isGenerated = true;
	this.__initGL();
};
$hxClasses["openfl.display.DisplayObjectShader"] = openfl_display_DisplayObjectShader;
openfl_display_DisplayObjectShader.__name__ = "openfl.display.DisplayObjectShader";
openfl_display_DisplayObjectShader.__super__ = openfl_display_Shader;
openfl_display_DisplayObjectShader.prototype = $extend(openfl_display_Shader.prototype,{
	__class__: openfl_display_DisplayObjectShader
});
var openfl_display_FrameLabel = function(name,frame) {
	openfl_events_EventDispatcher.call(this);
	this.name = name;
	this.frame = frame;
};
$hxClasses["openfl.display.FrameLabel"] = openfl_display_FrameLabel;
openfl_display_FrameLabel.__name__ = "openfl.display.FrameLabel";
openfl_display_FrameLabel.__super__ = openfl_events_EventDispatcher;
openfl_display_FrameLabel.prototype = $extend(openfl_events_EventDispatcher.prototype,{
	__class__: openfl_display_FrameLabel
});
var openfl_display_FrameScript = function(script,frame) {
	this.script = script;
	this.frame = frame;
};
$hxClasses["openfl.display.FrameScript"] = openfl_display_FrameScript;
openfl_display_FrameScript.__name__ = "openfl.display.FrameScript";
openfl_display_FrameScript.prototype = {
	__class__: openfl_display_FrameScript
};
var openfl_display_GradientType = {};
openfl_display_GradientType.fromInt = function(value) {
	return value;
};
openfl_display_GradientType.fromString = function(value) {
	switch(value) {
	case "linear":
		return 0;
	case "radial":
		return 1;
	default:
		return null;
	}
};
openfl_display_GradientType.toInt = function(this1) {
	return this1;
};
openfl_display_GradientType.toString = function(this1) {
	switch(this1) {
	case 0:
		return "linear";
	case 1:
		return "radial";
	default:
		return null;
	}
};
var openfl_display_Graphics = function(owner) {
	this.__dirty = true;
	this.__owner = owner;
	this.__commands = new openfl_display__$internal_DrawCommandBuffer();
	this.__strokePadding = 0;
	this.__positionX = 0;
	this.__positionY = 0;
	this.__renderTransform = new openfl_geom_Matrix();
	this.__usedShaderBuffers = new haxe_ds_List();
	this.__worldTransform = new openfl_geom_Matrix();
	this.__width = 0;
	this.__height = 0;
	this.__shaderBufferPool = new lime_utils_ObjectPool(function() {
		return new openfl_display__$internal_ShaderBuffer();
	});
	this.moveTo(0,0);
};
$hxClasses["openfl.display.Graphics"] = openfl_display_Graphics;
openfl_display_Graphics.__name__ = "openfl.display.Graphics";
openfl_display_Graphics.prototype = {
	beginBitmapFill: function(bitmap,matrix,repeat,smooth) {
		if(smooth == null) {
			smooth = false;
		}
		if(repeat == null) {
			repeat = true;
		}
		this.__commands.beginBitmapFill(bitmap,matrix != null ? matrix.clone() : null,repeat,smooth);
		this.__visible = true;
	}
	,beginFill: function(color,alpha) {
		if(alpha == null) {
			alpha = 1;
		}
		if(color == null) {
			color = 0;
		}
		this.__commands.beginFill(color & 16777215,alpha);
		if(alpha > 0) {
			this.__visible = true;
		}
	}
	,beginGradientFill: function(type,colors,alphas,ratios,matrix,spreadMethod,interpolationMethod,focalPointRatio) {
		if(focalPointRatio == null) {
			focalPointRatio = 0;
		}
		if(interpolationMethod == null) {
			interpolationMethod = 1;
		}
		if(spreadMethod == null) {
			spreadMethod = 0;
		}
		if(colors == null || colors.length == 0) {
			return;
		}
		if(alphas == null) {
			alphas = [];
			var _g = 0;
			var _g1 = colors.length;
			while(_g < _g1) {
				var i = _g++;
				alphas.push(1);
			}
		}
		if(ratios == null) {
			ratios = [];
			var _g = 0;
			var _g1 = colors.length;
			while(_g < _g1) {
				var i = _g++;
				ratios.push(Math.ceil(i / colors.length * 255));
			}
		}
		if(alphas.length < colors.length || ratios.length < colors.length) {
			return;
		}
		this.__commands.beginGradientFill(type,colors,alphas,ratios,matrix,spreadMethod,interpolationMethod,focalPointRatio);
		var _g = 0;
		while(_g < alphas.length) {
			var alpha = alphas[_g];
			++_g;
			if(alpha > 0) {
				this.__visible = true;
				break;
			}
		}
	}
	,beginShaderFill: function(shader,matrix) {
		if(shader != null) {
			var shaderBuffer = this.__shaderBufferPool.get();
			this.__usedShaderBuffers.add(shaderBuffer);
			shaderBuffer.update(shader);
			this.__commands.beginShaderFill(shaderBuffer);
		}
	}
	,clear: function() {
		var _g_head = this.__usedShaderBuffers.h;
		while(_g_head != null) {
			var val = _g_head.item;
			_g_head = _g_head.next;
			var shaderBuffer = val;
			this.__shaderBufferPool.release(shaderBuffer);
		}
		this.__usedShaderBuffers.clear();
		this.__commands.clear();
		this.__strokePadding = 0;
		if(this.__bounds != null) {
			this.set___dirty(true);
			this.__transformDirty = true;
			this.__bounds = null;
		}
		this.__visible = false;
		this.__positionX = 0;
		this.__positionY = 0;
		this.moveTo(0,0);
	}
	,copyFrom: function(sourceGraphics) {
		this.__bounds = sourceGraphics.__bounds != null ? sourceGraphics.__bounds.clone() : null;
		this.__commands = sourceGraphics.__commands.copy();
		this.set___dirty(true);
		this.__strokePadding = sourceGraphics.__strokePadding;
		this.__positionX = sourceGraphics.__positionX;
		this.__positionY = sourceGraphics.__positionY;
		this.__transformDirty = true;
		this.__visible = sourceGraphics.__visible;
	}
	,cubicCurveTo: function(controlX1,controlY1,controlX2,controlY2,anchorX,anchorY) {
		this.__inflateBounds(this.__positionX - this.__strokePadding,this.__positionY - this.__strokePadding);
		this.__inflateBounds(this.__positionX + this.__strokePadding,this.__positionY + this.__strokePadding);
		var ix1 = anchorX;
		var ix2 = anchorX;
		if(!((controlX1 < anchorX && controlX1 > this.__positionX || controlX1 > anchorX && controlX1 < this.__positionX) && (controlX2 < anchorX && controlX2 > this.__positionX || controlX2 > anchorX && controlX2 < this.__positionX))) {
			var u = 2 * this.__positionX - 4 * controlX1 + 2 * controlX2;
			var v = controlX1 - this.__positionX;
			var w = -this.__positionX + 3 * controlX1 + anchorX - 3 * controlX2;
			var t1 = (-u + Math.sqrt(u * u - 4 * v * w)) / (2 * w);
			var t2 = (-u - Math.sqrt(u * u - 4 * v * w)) / (2 * w);
			if(t1 > 0 && t1 < 1) {
				ix1 = this.__calculateBezierCubicPoint(t1,this.__positionX,controlX1,controlX2,anchorX);
			}
			if(t2 > 0 && t2 < 1) {
				ix2 = this.__calculateBezierCubicPoint(t2,this.__positionX,controlX1,controlX2,anchorX);
			}
		}
		var iy1 = anchorY;
		var iy2 = anchorY;
		if(!((controlY1 < anchorY && controlY1 > this.__positionX || controlY1 > anchorY && controlY1 < this.__positionX) && (controlY2 < anchorY && controlY2 > this.__positionX || controlY2 > anchorY && controlY2 < this.__positionX))) {
			var u = 2 * this.__positionX - 4 * controlY1 + 2 * controlY2;
			var v = controlY1 - this.__positionX;
			var w = -this.__positionX + 3 * controlY1 + anchorY - 3 * controlY2;
			var t1 = (-u + Math.sqrt(u * u - 4 * v * w)) / (2 * w);
			var t2 = (-u - Math.sqrt(u * u - 4 * v * w)) / (2 * w);
			if(t1 > 0 && t1 < 1) {
				iy1 = this.__calculateBezierCubicPoint(t1,this.__positionX,controlY1,controlY2,anchorY);
			}
			if(t2 > 0 && t2 < 1) {
				iy2 = this.__calculateBezierCubicPoint(t2,this.__positionX,controlY1,controlY2,anchorY);
			}
		}
		this.__inflateBounds(ix1 - this.__strokePadding,iy1 - this.__strokePadding);
		this.__inflateBounds(ix1 + this.__strokePadding,iy1 + this.__strokePadding);
		this.__inflateBounds(ix2 - this.__strokePadding,iy2 - this.__strokePadding);
		this.__inflateBounds(ix2 + this.__strokePadding,iy2 + this.__strokePadding);
		this.__positionX = anchorX;
		this.__positionY = anchorY;
		this.__inflateBounds(this.__positionX - this.__strokePadding,this.__positionY - this.__strokePadding);
		this.__inflateBounds(this.__positionX + this.__strokePadding,this.__positionY + this.__strokePadding);
		this.__commands.cubicCurveTo(controlX1,controlY1,controlX2,controlY2,anchorX,anchorY);
		this.set___dirty(true);
	}
	,curveTo: function(controlX,controlY,anchorX,anchorY) {
		this.__inflateBounds(this.__positionX - this.__strokePadding,this.__positionY - this.__strokePadding);
		this.__inflateBounds(this.__positionX + this.__strokePadding,this.__positionY + this.__strokePadding);
		var ix;
		var iy;
		if(controlX < anchorX && controlX > this.__positionX || controlX > anchorX && controlX < this.__positionX) {
			ix = anchorX;
		} else {
			var tx = (this.__positionX - controlX) / (this.__positionX - 2 * controlX + anchorX);
			ix = this.__calculateBezierQuadPoint(tx,this.__positionX,controlX,anchorX);
		}
		if(controlY < anchorY && controlY > this.__positionY || controlY > anchorY && controlY < this.__positionY) {
			iy = anchorY;
		} else {
			var ty = (this.__positionY - controlY) / (this.__positionY - 2 * controlY + anchorY);
			iy = this.__calculateBezierQuadPoint(ty,this.__positionY,controlY,anchorY);
		}
		this.__inflateBounds(ix - this.__strokePadding,iy - this.__strokePadding);
		this.__inflateBounds(ix + this.__strokePadding,iy + this.__strokePadding);
		this.__positionX = anchorX;
		this.__positionY = anchorY;
		this.__commands.curveTo(controlX,controlY,anchorX,anchorY);
		this.set___dirty(true);
	}
	,drawCircle: function(x,y,radius) {
		if(radius <= 0) {
			return;
		}
		this.__inflateBounds(x - radius - this.__strokePadding,y - radius - this.__strokePadding);
		this.__inflateBounds(x + radius + this.__strokePadding,y + radius + this.__strokePadding);
		this.__commands.drawCircle(x,y,radius);
		this.set___dirty(true);
	}
	,drawEllipse: function(x,y,width,height) {
		if(width <= 0 || height <= 0) {
			return;
		}
		this.__inflateBounds(x - this.__strokePadding,y - this.__strokePadding);
		this.__inflateBounds(x + width + this.__strokePadding,y + height + this.__strokePadding);
		this.__commands.drawEllipse(x,y,width,height);
		this.set___dirty(true);
	}
	,drawGraphicsData: function(graphicsData) {
		var fill;
		var bitmapFill;
		var gradientFill;
		var shaderFill;
		var stroke;
		var path;
		var trianglePath;
		var quadPath;
		var graphics = graphicsData.iterator();
		while(graphics.hasNext()) {
			var graphics1 = graphics.next();
			switch(graphics1.__graphicsDataType) {
			case 0:
				stroke = graphics1;
				if(stroke.fill != null) {
					var thickness = stroke.thickness;
					if(isNaN(thickness)) {
						thickness = null;
					}
					switch(stroke.fill.__graphicsFillType) {
					case 0:
						fill = stroke.fill;
						this.lineStyle(thickness,fill.color,fill.alpha,stroke.pixelHinting,stroke.scaleMode,stroke.caps,stroke.joints,stroke.miterLimit);
						break;
					case 1:
						gradientFill = stroke.fill;
						this.lineStyle(thickness,0,1,stroke.pixelHinting,stroke.scaleMode,stroke.caps,stroke.joints,stroke.miterLimit);
						this.lineGradientStyle(gradientFill.type,gradientFill.colors,gradientFill.alphas,gradientFill.ratios,gradientFill.matrix,gradientFill.spreadMethod,gradientFill.interpolationMethod,gradientFill.focalPointRatio);
						break;
					case 2:
						bitmapFill = stroke.fill;
						this.lineStyle(thickness,0,1,stroke.pixelHinting,stroke.scaleMode,stroke.caps,stroke.joints,stroke.miterLimit);
						this.lineBitmapStyle(bitmapFill.bitmapData,bitmapFill.matrix,bitmapFill.repeat,bitmapFill.smooth);
						break;
					default:
					}
				} else {
					this.lineStyle();
				}
				break;
			case 1:
				fill = graphics1;
				this.beginFill(fill.color,fill.alpha);
				break;
			case 2:
				gradientFill = graphics1;
				this.beginGradientFill(gradientFill.type,gradientFill.colors,gradientFill.alphas,gradientFill.ratios,gradientFill.matrix,gradientFill.spreadMethod,gradientFill.interpolationMethod,gradientFill.focalPointRatio);
				break;
			case 3:
				path = graphics1;
				this.drawPath(path.commands,path.data,path.winding);
				break;
			case 4:
				bitmapFill = graphics1;
				this.beginBitmapFill(bitmapFill.bitmapData,bitmapFill.matrix,bitmapFill.repeat,bitmapFill.smooth);
				break;
			case 5:
				this.endFill();
				break;
			case 6:
				quadPath = graphics1;
				this.drawQuads(quadPath.rects,quadPath.indices,quadPath.transforms);
				break;
			case 7:
				trianglePath = graphics1;
				this.drawTriangles(trianglePath.vertices,trianglePath.indices,trianglePath.uvtData,trianglePath.culling);
				break;
			case 8:
				shaderFill = graphics1;
				this.beginShaderFill(shaderFill.shader,shaderFill.matrix);
				break;
			}
		}
	}
	,drawPath: function(commands,data,winding) {
		if(winding == null) {
			winding = 0;
		}
		var dataIndex = 0;
		if(winding == 1) {
			this.__commands.windingNonZero();
		}
		var command = commands.iterator();
		_hx_loop1: while(command.hasNext()) {
			var command1 = command.next();
			switch(command1) {
			case 1:
				this.moveTo(data.get(dataIndex),data.get(dataIndex + 1));
				dataIndex += 2;
				break;
			case 2:
				this.lineTo(data.get(dataIndex),data.get(dataIndex + 1));
				dataIndex += 2;
				break;
			case 3:
				this.curveTo(data.get(dataIndex),data.get(dataIndex + 1),data.get(dataIndex + 2),data.get(dataIndex + 3));
				dataIndex += 4;
				break;
			case 4:
				this.moveTo(data.get(dataIndex + 2),data.get(dataIndex + 3));
				break _hx_loop1;
			case 5:
				this.lineTo(data.get(dataIndex + 2),data.get(dataIndex + 3));
				break _hx_loop1;
			case 6:
				this.cubicCurveTo(data.get(dataIndex),data.get(dataIndex + 1),data.get(dataIndex + 2),data.get(dataIndex + 3),data.get(dataIndex + 4),data.get(dataIndex + 5));
				dataIndex += 6;
				break;
			default:
			}
		}
	}
	,drawQuads: function(rects,indices,transforms) {
		if(rects == null) {
			return;
		}
		var hasIndices = indices != null;
		var transformABCD = false;
		var transformXY = false;
		var length = hasIndices ? indices.get_length() : Math.floor(rects.get_length() / 4);
		if(length == 0) {
			return;
		}
		if(transforms != null) {
			if(transforms.get_length() >= length * 6) {
				transformABCD = true;
				transformXY = true;
			} else if(transforms.get_length() >= length * 4) {
				transformABCD = true;
			} else if(transforms.get_length() >= length * 2) {
				transformXY = true;
			}
		}
		var tileRect = openfl_geom_Rectangle.__pool.get();
		var tileTransform = openfl_geom_Matrix.__pool.get();
		var minX = Infinity;
		var minY = Infinity;
		var maxX = -Infinity;
		var maxY = -Infinity;
		var ri;
		var ti;
		var _g = 0;
		var _g1 = length;
		while(_g < _g1) {
			var i = _g++;
			ri = hasIndices ? indices.get(i) * 4 : i * 4;
			if(ri < 0) {
				continue;
			}
			tileRect.setTo(0,0,rects.get(ri + 2),rects.get(ri + 3));
			if(tileRect.width <= 0 || tileRect.height <= 0) {
				continue;
			}
			if(transformABCD && transformXY) {
				ti = i * 6;
				tileTransform.setTo(transforms.get(ti),transforms.get(ti + 1),transforms.get(ti + 2),transforms.get(ti + 3),transforms.get(ti + 4),transforms.get(ti + 5));
			} else if(transformABCD) {
				ti = i * 4;
				tileTransform.setTo(transforms.get(ti),transforms.get(ti + 1),transforms.get(ti + 2),transforms.get(ti + 3),tileRect.x,tileRect.y);
			} else if(transformXY) {
				ti = i * 2;
				tileTransform.tx = transforms.get(ti);
				tileTransform.ty = transforms.get(ti + 1);
			} else {
				tileTransform.tx = tileRect.x;
				tileTransform.ty = tileRect.y;
			}
			tileRect.__transform(tileRect,tileTransform);
			if(minX > tileRect.x) {
				minX = tileRect.x;
			}
			if(minY > tileRect.y) {
				minY = tileRect.y;
			}
			if(maxX < tileRect.get_right()) {
				maxX = tileRect.get_right();
			}
			if(maxY < tileRect.get_bottom()) {
				maxY = tileRect.get_bottom();
			}
		}
		this.__inflateBounds(minX,minY);
		this.__inflateBounds(maxX,maxY);
		this.__commands.drawQuads(rects,indices,transforms);
		this.set___dirty(true);
		this.__visible = true;
		openfl_geom_Rectangle.__pool.release(tileRect);
		openfl_geom_Matrix.__pool.release(tileTransform);
	}
	,drawRect: function(x,y,width,height) {
		if(width == 0 && height == 0) {
			return;
		}
		var xSign = width < 0 ? -1 : 1;
		var ySign = height < 0 ? -1 : 1;
		this.__inflateBounds(x - this.__strokePadding * xSign,y - this.__strokePadding * ySign);
		this.__inflateBounds(x + width + this.__strokePadding * xSign,y + height + this.__strokePadding * ySign);
		this.__commands.drawRect(x,y,width,height);
		this.set___dirty(true);
	}
	,drawRoundRect: function(x,y,width,height,ellipseWidth,ellipseHeight) {
		if(width == 0 && height == 0) {
			return;
		}
		var xSign = width < 0 ? -1 : 1;
		var ySign = height < 0 ? -1 : 1;
		this.__inflateBounds(x - this.__strokePadding * xSign,y - this.__strokePadding * ySign);
		this.__inflateBounds(x + width + this.__strokePadding * xSign,y + height + this.__strokePadding * ySign);
		this.__commands.drawRoundRect(x,y,width,height,ellipseWidth,ellipseHeight);
		this.set___dirty(true);
	}
	,drawRoundRectComplex: function(x,y,width,height,topLeftRadius,topRightRadius,bottomLeftRadius,bottomRightRadius) {
		if(width <= 0 || height <= 0) {
			return;
		}
		this.__inflateBounds(x - this.__strokePadding,y - this.__strokePadding);
		this.__inflateBounds(x + width + this.__strokePadding,y + height + this.__strokePadding);
		var xw = x + width;
		var yh = y + height;
		var minSize = width < height ? width * 2 : height * 2;
		if(!(topLeftRadius < minSize)) {
			topLeftRadius = minSize;
		}
		if(!(topRightRadius < minSize)) {
			topRightRadius = minSize;
		}
		if(!(bottomLeftRadius < minSize)) {
			bottomLeftRadius = minSize;
		}
		if(!(bottomRightRadius < minSize)) {
			bottomRightRadius = minSize;
		}
		var anchor = 1 - Math.sin(45 * (Math.PI / 180));
		var control = 1 - Math.tan(22.5 * (Math.PI / 180));
		var a = bottomRightRadius * anchor;
		var s = bottomRightRadius * control;
		this.moveTo(xw,yh - bottomRightRadius);
		this.curveTo(xw,yh - s,xw - a,yh - a);
		this.curveTo(xw - s,yh,xw - bottomRightRadius,yh);
		a = bottomLeftRadius * anchor;
		s = bottomLeftRadius * control;
		this.lineTo(x + bottomLeftRadius,yh);
		this.curveTo(x + s,yh,x + a,yh - a);
		this.curveTo(x,yh - s,x,yh - bottomLeftRadius);
		a = topLeftRadius * anchor;
		s = topLeftRadius * control;
		this.lineTo(x,y + topLeftRadius);
		this.curveTo(x,y + s,x + a,y + a);
		this.curveTo(x + s,y,x + topLeftRadius,y);
		a = topRightRadius * anchor;
		s = topRightRadius * control;
		this.lineTo(xw - topRightRadius,y);
		this.curveTo(xw - s,y,xw - a,y + a);
		this.curveTo(xw,y + s,xw,y + topRightRadius);
		this.lineTo(xw,yh - bottomRightRadius);
		this.set___dirty(true);
	}
	,drawTriangles: function(vertices,indices,uvtData,culling) {
		if(culling == null) {
			culling = 1;
		}
		if(vertices == null || vertices.get_length() == 0) {
			return;
		}
		var vertLength = vertices.get_length() / 2 | 0;
		if(indices == null) {
			if(vertLength % 3 != 0) {
				throw haxe_Exception.thrown(new openfl_errors_ArgumentError("Not enough vertices to close a triangle."));
			}
			indices = openfl_Vector.toIntVector(null);
			var _g = 0;
			var _g1 = vertLength;
			while(_g < _g1) {
				var i = _g++;
				indices.push(i);
			}
		}
		if(culling == null) {
			culling = 1;
		}
		var x;
		var y;
		var minX = Infinity;
		var minY = Infinity;
		var maxX = -Infinity;
		var maxY = -Infinity;
		var _g = 0;
		var _g1 = vertLength;
		while(_g < _g1) {
			var i = _g++;
			x = vertices.get(i * 2);
			y = vertices.get(i * 2 + 1);
			if(minX > x) {
				minX = x;
			}
			if(minY > y) {
				minY = y;
			}
			if(maxX < x) {
				maxX = x;
			}
			if(maxY < y) {
				maxY = y;
			}
		}
		this.__inflateBounds(minX,minY);
		this.__inflateBounds(maxX,maxY);
		this.__commands.drawTriangles(vertices,indices,uvtData,culling);
		this.set___dirty(true);
		this.__visible = true;
	}
	,endFill: function() {
		this.__commands.endFill();
	}
	,lineBitmapStyle: function(bitmap,matrix,repeat,smooth) {
		if(smooth == null) {
			smooth = false;
		}
		if(repeat == null) {
			repeat = true;
		}
		this.__commands.lineBitmapStyle(bitmap,matrix != null ? matrix.clone() : null,repeat,smooth);
	}
	,lineGradientStyle: function(type,colors,alphas,ratios,matrix,spreadMethod,interpolationMethod,focalPointRatio) {
		if(focalPointRatio == null) {
			focalPointRatio = 0;
		}
		if(interpolationMethod == null) {
			interpolationMethod = 1;
		}
		if(spreadMethod == null) {
			spreadMethod = 0;
		}
		this.__commands.lineGradientStyle(type,colors,alphas,ratios,matrix,spreadMethod,interpolationMethod,focalPointRatio);
	}
	,lineStyle: function(thickness,color,alpha,pixelHinting,scaleMode,caps,joints,miterLimit) {
		if(miterLimit == null) {
			miterLimit = 3;
		}
		if(scaleMode == null) {
			scaleMode = 2;
		}
		if(pixelHinting == null) {
			pixelHinting = false;
		}
		if(alpha == null) {
			alpha = 1;
		}
		if(color == null) {
			color = 0;
		}
		if(thickness != null) {
			if(joints == 1) {
				if(thickness > this.__strokePadding) {
					this.__strokePadding = Math.ceil(thickness);
				}
			} else if(thickness / 2 > this.__strokePadding) {
				this.__strokePadding = Math.ceil(thickness / 2);
			}
		}
		this.__commands.lineStyle(thickness,color,alpha,pixelHinting,scaleMode,caps,joints,miterLimit);
		if(thickness != null) {
			this.__visible = true;
		}
	}
	,lineTo: function(x,y) {
		if(!isFinite(x) || !isFinite(y)) {
			return;
		}
		this.__inflateBounds(this.__positionX - this.__strokePadding,this.__positionY - this.__strokePadding);
		this.__inflateBounds(this.__positionX + this.__strokePadding,this.__positionY + this.__strokePadding);
		this.__positionX = x;
		this.__positionY = y;
		this.__inflateBounds(this.__positionX - this.__strokePadding,this.__positionY - this.__strokePadding);
		this.__inflateBounds(this.__positionX + this.__strokePadding * 2,this.__positionY + this.__strokePadding);
		this.__commands.lineTo(x,y);
		this.set___dirty(true);
	}
	,moveTo: function(x,y) {
		this.__positionX = x;
		this.__positionY = y;
		this.__commands.moveTo(x,y);
	}
	,overrideBlendMode: function(blendMode) {
		if(blendMode == null) {
			blendMode = 10;
		}
		this.__commands.overrideBlendMode(blendMode);
	}
	,readGraphicsData: function(recurse) {
		if(recurse == null) {
			recurse = true;
		}
		var graphicsData = openfl_Vector.toObjectVector(null);
		this.__owner.__readGraphicsData(graphicsData,recurse);
		return graphicsData;
	}
	,__calculateBezierCubicPoint: function(t,p1,p2,p3,p4) {
		var iT = 1 - t;
		return p1 * (iT * iT * iT) + 3 * p2 * t * (iT * iT) + 3 * p3 * iT * (t * t) + p4 * (t * t * t);
	}
	,__calculateBezierQuadPoint: function(t,p1,p2,p3) {
		var iT = 1 - t;
		return iT * iT * p1 + 2 * iT * t * p2 + t * t * p3;
	}
	,__cleanup: function() {
		if(this.__bounds != null && this.__canvas != null) {
			this.set___dirty(true);
			this.__transformDirty = true;
		}
		this.__bitmap = null;
		this.__canvas = null;
		this.__context = null;
	}
	,__getBounds: function(rect,matrix) {
		if(this.__bounds == null) {
			return;
		}
		var bounds = openfl_geom_Rectangle.__pool.get();
		this.__bounds.__transform(bounds,matrix);
		rect.__expand(bounds.x,bounds.y,bounds.width,bounds.height);
		openfl_geom_Rectangle.__pool.release(bounds);
	}
	,__hitTest: function(x,y,shapeFlag,matrix) {
		if(this.__bounds == null) {
			return false;
		}
		var norm = matrix.a * matrix.d - matrix.b * matrix.c;
		var px = norm == 0 ? -matrix.tx : 1.0 / norm * (matrix.c * (matrix.ty - y) + matrix.d * (x - matrix.tx));
		var norm = matrix.a * matrix.d - matrix.b * matrix.c;
		var py = norm == 0 ? -matrix.ty : 1.0 / norm * (matrix.a * (y - matrix.ty) + matrix.b * (matrix.tx - x));
		if(px > this.__bounds.x && py > this.__bounds.y && this.__bounds.contains(px,py)) {
			if(shapeFlag) {
				return openfl_display__$internal_CanvasGraphics.hitTest(this,px,py);
			}
			return true;
		}
		return false;
	}
	,__inflateBounds: function(x,y) {
		if(this.__bounds == null) {
			this.__bounds = new openfl_geom_Rectangle(x,y,0,0);
			this.__transformDirty = true;
			return;
		}
		if(x < this.__bounds.x) {
			this.__bounds.width += this.__bounds.x - x;
			this.__bounds.x = x;
			this.__transformDirty = true;
		}
		if(y < this.__bounds.y) {
			this.__bounds.height += this.__bounds.y - y;
			this.__bounds.y = y;
			this.__transformDirty = true;
		}
		if(x > this.__bounds.x + this.__bounds.width) {
			this.__bounds.width = x - this.__bounds.x;
		}
		if(y > this.__bounds.y + this.__bounds.height) {
			this.__bounds.height = y - this.__bounds.y;
		}
	}
	,__readGraphicsData: function(graphicsData) {
		var data = new openfl_display__$internal_DrawCommandReader(this.__commands);
		var path = null;
		var stroke;
		var _g = 0;
		var _g1 = this.__commands.types;
		while(_g < _g1.length) {
			var type = _g1[_g];
			++_g;
			switch(type._hx_index) {
			case 4:case 5:case 6:case 7:case 9:case 10:case 17:case 18:
				if(path == null) {
					path = new openfl_display_GraphicsPath();
				}
				break;
			default:
				if(path != null) {
					graphicsData.push(path);
					path = null;
				}
			}
			switch(type._hx_index) {
			case 0:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.BEGIN_BITMAP_FILL;
				var this1 = data;
				var c = this1;
				graphicsData.push(new openfl_display_GraphicsBitmapFill(c.buffer.o[c.oPos],c.buffer.o[c.oPos + 1],c.buffer.b[c.bPos],c.buffer.b[c.bPos + 1]));
				break;
			case 1:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.BEGIN_FILL;
				var this2 = data;
				var c1 = this2;
				graphicsData.push(new openfl_display_GraphicsSolidFill(c1.buffer.i[c1.iPos],1));
				break;
			case 2:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.BEGIN_GRADIENT_FILL;
				var this3 = data;
				var c2 = this3;
				graphicsData.push(new openfl_display_GraphicsGradientFill(c2.buffer.o[c2.oPos],c2.buffer.ii[c2.iiPos],c2.buffer.ff[c2.ffPos],c2.buffer.ii[c2.iiPos + 1],c2.buffer.o[c2.oPos + 1],c2.buffer.o[c2.oPos + 2],c2.buffer.o[c2.oPos + 3],c2.buffer.f[c2.fPos]));
				break;
			case 3:
				break;
			case 4:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.CUBIC_CURVE_TO;
				var this4 = data;
				var c3 = this4;
				path.cubicCurveTo(c3.buffer.f[c3.fPos],c3.buffer.f[c3.fPos + 1],c3.buffer.f[c3.fPos + 2],c3.buffer.f[c3.fPos + 3],c3.buffer.f[c3.fPos + 4],c3.buffer.f[c3.fPos + 5]);
				break;
			case 5:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.CURVE_TO;
				var this5 = data;
				var c4 = this5;
				path.curveTo(c4.buffer.f[c4.fPos],c4.buffer.f[c4.fPos + 1],c4.buffer.f[c4.fPos + 2],c4.buffer.f[c4.fPos + 3]);
				break;
			case 6:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.DRAW_CIRCLE;
				var this6 = data;
				var c5 = this6;
				path.__drawCircle(c5.buffer.f[c5.fPos],c5.buffer.f[c5.fPos + 1],c5.buffer.f[c5.fPos + 2]);
				break;
			case 7:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.DRAW_ELLIPSE;
				var this7 = data;
				var c6 = this7;
				path.__drawEllipse(c6.buffer.f[c6.fPos],c6.buffer.f[c6.fPos + 1],c6.buffer.f[c6.fPos + 2],c6.buffer.f[c6.fPos + 3]);
				break;
			case 9:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.DRAW_RECT;
				var this8 = data;
				var c7 = this8;
				path.__drawRect(c7.buffer.f[c7.fPos],c7.buffer.f[c7.fPos + 1],c7.buffer.f[c7.fPos + 2],c7.buffer.f[c7.fPos + 3]);
				break;
			case 10:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.DRAW_ROUND_RECT;
				var this9 = data;
				var c8 = this9;
				path.__drawRoundRect(c8.buffer.f[c8.fPos],c8.buffer.f[c8.fPos + 1],c8.buffer.f[c8.fPos + 2],c8.buffer.f[c8.fPos + 3],c8.buffer.f[c8.fPos + 4],c8.buffer.o[c8.oPos] != null ? c8.buffer.o[c8.oPos] : c8.buffer.f[c8.fPos + 4]);
				break;
			case 13:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.END_FILL;
				var this10 = data;
				graphicsData.push(new openfl_display_GraphicsEndFill());
				break;
			case 14:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.LINE_BITMAP_STYLE;
				var this11 = data;
				var c9 = this11;
				path = null;
				break;
			case 15:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.LINE_GRADIENT_STYLE;
				var this12 = data;
				var c10 = this12;
				break;
			case 16:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.LINE_STYLE;
				var this13 = data;
				var c11 = this13;
				stroke = new openfl_display_GraphicsStroke(c11.buffer.o[c11.oPos],c11.buffer.b[c11.bPos],c11.buffer.o[c11.oPos + 1],c11.buffer.o[c11.oPos + 2],c11.buffer.o[c11.oPos + 3],c11.buffer.f[c11.fPos + 1]);
				stroke.fill = new openfl_display_GraphicsSolidFill(c11.buffer.i[c11.iPos],c11.buffer.f[c11.fPos]);
				graphicsData.push(stroke);
				break;
			case 17:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.LINE_TO;
				var this14 = data;
				var c12 = this14;
				path.lineTo(c12.buffer.f[c12.fPos],c12.buffer.f[c12.fPos + 1]);
				break;
			case 18:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = openfl_display__$internal_DrawCommandType.MOVE_TO;
				var this15 = data;
				var c13 = this15;
				path.moveTo(c13.buffer.f[c13.fPos],c13.buffer.f[c13.fPos + 1]);
				break;
			default:
				switch(data.prev._hx_index) {
				case 0:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 1:
					data.iPos += 1;
					data.fPos += 1;
					break;
				case 2:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 3:
					data.oPos += 1;
					break;
				case 4:
					data.fPos += 6;
					break;
				case 5:
					data.fPos += 4;
					break;
				case 6:
					data.fPos += 3;
					break;
				case 7:
					data.fPos += 4;
					break;
				case 8:
					data.oPos += 3;
					break;
				case 9:
					data.fPos += 4;
					break;
				case 10:
					data.fPos += 5;
					data.oPos += 1;
					break;
				case 12:
					data.oPos += 4;
					break;
				case 13:
					break;
				case 14:
					data.oPos += 2;
					data.bPos += 2;
					break;
				case 15:
					data.oPos += 4;
					data.iiPos += 2;
					data.ffPos += 1;
					data.fPos += 1;
					break;
				case 16:
					data.oPos += 4;
					data.iPos += 1;
					data.fPos += 2;
					data.bPos += 1;
					break;
				case 17:
					data.fPos += 2;
					break;
				case 18:
					data.fPos += 2;
					break;
				case 19:
					data.oPos += 1;
					break;
				case 20:
					data.oPos += 1;
					break;
				case 21:case 22:
					break;
				default:
				}
				data.prev = type;
			}
		}
		if(path != null) {
			graphicsData.push(path);
		}
	}
	,__update: function(displayMatrix) {
		if(this.__bounds == null || this.__bounds.width <= 0 || this.__bounds.height <= 0) {
			return;
		}
		var parentTransform = this.__owner.__renderTransform;
		var scaleX = 1.0;
		var scaleY = 1.0;
		if(parentTransform != null) {
			if(parentTransform.b == 0) {
				scaleX = Math.abs(parentTransform.a);
			} else {
				scaleX = Math.sqrt(parentTransform.a * parentTransform.a + parentTransform.b * parentTransform.b);
			}
			if(parentTransform.c == 0) {
				scaleY = Math.abs(parentTransform.d);
			} else {
				scaleY = Math.sqrt(parentTransform.c * parentTransform.c + parentTransform.d * parentTransform.d);
			}
		} else {
			return;
		}
		if(displayMatrix != null) {
			if(displayMatrix.b == 0) {
				scaleX *= displayMatrix.a;
			} else {
				scaleX *= Math.sqrt(displayMatrix.a * displayMatrix.a + displayMatrix.b * displayMatrix.b);
			}
			if(displayMatrix.c == 0) {
				scaleY *= displayMatrix.d;
			} else {
				scaleY *= Math.sqrt(displayMatrix.c * displayMatrix.c + displayMatrix.d * displayMatrix.d);
			}
		}
		var width = this.__bounds.width * scaleX;
		var height = this.__bounds.height * scaleY;
		if(width < 1 || height < 1) {
			if(this.__width >= 1 || this.__height >= 1) {
				this.set___dirty(true);
			}
			this.__width = 0;
			this.__height = 0;
			return;
		}
		if(openfl_display_Graphics.maxTextureWidth != null && width > openfl_display_Graphics.maxTextureWidth) {
			width = openfl_display_Graphics.maxTextureWidth;
			scaleX = openfl_display_Graphics.maxTextureWidth / this.__bounds.width;
		}
		if(openfl_display_Graphics.maxTextureWidth != null && height > openfl_display_Graphics.maxTextureHeight) {
			height = openfl_display_Graphics.maxTextureHeight;
			scaleY = openfl_display_Graphics.maxTextureHeight / this.__bounds.height;
		}
		this.__renderTransform.a = width / this.__bounds.width;
		this.__renderTransform.d = height / this.__bounds.height;
		var inverseA = 1 / this.__renderTransform.a;
		var inverseD = 1 / this.__renderTransform.d;
		this.__worldTransform.a = inverseA * parentTransform.a;
		this.__worldTransform.b = inverseA * parentTransform.b;
		this.__worldTransform.c = inverseD * parentTransform.c;
		this.__worldTransform.d = inverseD * parentTransform.d;
		var x = this.__bounds.x;
		var y = this.__bounds.y;
		var tx = x * parentTransform.a + y * parentTransform.c + parentTransform.tx;
		var ty = x * parentTransform.b + y * parentTransform.d + parentTransform.ty;
		this.__worldTransform.tx = Math.round(tx);
		this.__worldTransform.ty = Math.round(ty);
		var _this = this.__worldTransform;
		var norm = _this.a * _this.d - _this.b * _this.c;
		this.__renderTransform.tx = norm == 0 ? -_this.tx : 1.0 / norm * (_this.c * (_this.ty - ty) + _this.d * (tx - _this.tx));
		var _this = this.__worldTransform;
		var norm = _this.a * _this.d - _this.b * _this.c;
		this.__renderTransform.ty = norm == 0 ? -_this.ty : 1.0 / norm * (_this.a * (ty - _this.ty) + _this.b * (_this.tx - tx));
		var newWidth = Math.ceil(width + 1.0);
		var newHeight = Math.ceil(height + 1.0);
		if(newWidth != this.__width || newHeight != this.__height) {
			this.set___dirty(true);
		}
		this.__width = newWidth;
		this.__height = newHeight;
	}
	,set___dirty: function(value) {
		if(value && this.__owner != null) {
			var _this = this.__owner;
			if(!_this.__renderDirty) {
				_this.__renderDirty = true;
				_this.__setParentRenderDirty();
			}
		}
		if(value) {
			this.__softwareDirty = true;
			this.__hardwareDirty = true;
		}
		return this.__dirty = value;
	}
	,__class__: openfl_display_Graphics
	,__properties__: {set___dirty:"set___dirty"}
};
var openfl_display_IGraphicsFill = function() { };
$hxClasses["openfl.display.IGraphicsFill"] = openfl_display_IGraphicsFill;
openfl_display_IGraphicsFill.__name__ = "openfl.display.IGraphicsFill";
openfl_display_IGraphicsFill.__isInterface__ = true;
openfl_display_IGraphicsFill.prototype = {
	__class__: openfl_display_IGraphicsFill
};
var openfl_display_IGraphicsData = function() { };
$hxClasses["openfl.display.IGraphicsData"] = openfl_display_IGraphicsData;
openfl_display_IGraphicsData.__name__ = "openfl.display.IGraphicsData";
openfl_display_IGraphicsData.__isInterface__ = true;
openfl_display_IGraphicsData.prototype = {
	__class__: openfl_display_IGraphicsData
};
var openfl_display_GraphicsBitmapFill = function(bitmapData,matrix,repeat,smooth) {
	if(smooth == null) {
		smooth = false;
	}
	if(repeat == null) {
		repeat = true;
	}
	this.bitmapData = bitmapData;
	this.matrix = matrix;
	this.repeat = repeat;
	this.smooth = smooth;
	this.__graphicsDataType = 4;
	this.__graphicsFillType = 2;
};
$hxClasses["openfl.display.GraphicsBitmapFill"] = openfl_display_GraphicsBitmapFill;
openfl_display_GraphicsBitmapFill.__name__ = "openfl.display.GraphicsBitmapFill";
openfl_display_GraphicsBitmapFill.__interfaces__ = [openfl_display_IGraphicsFill,openfl_display_IGraphicsData];
openfl_display_GraphicsBitmapFill.prototype = {
	__class__: openfl_display_GraphicsBitmapFill
};
var openfl_display_GraphicsEndFill = function() {
	this.__graphicsDataType = 5;
	this.__graphicsFillType = 3;
};
$hxClasses["openfl.display.GraphicsEndFill"] = openfl_display_GraphicsEndFill;
openfl_display_GraphicsEndFill.__name__ = "openfl.display.GraphicsEndFill";
openfl_display_GraphicsEndFill.__interfaces__ = [openfl_display_IGraphicsFill,openfl_display_IGraphicsData];
openfl_display_GraphicsEndFill.prototype = {
	__class__: openfl_display_GraphicsEndFill
};
var openfl_display_GraphicsGradientFill = function(type,colors,alphas,ratios,matrix,spreadMethod,interpolationMethod,focalPointRatio) {
	if(focalPointRatio == null) {
		focalPointRatio = 0;
	}
	if(type == null) {
		type = 0;
	}
	if(spreadMethod == null) {
		spreadMethod = 0;
	}
	if(interpolationMethod == null) {
		interpolationMethod = 1;
	}
	this.type = type;
	this.colors = colors;
	this.alphas = alphas;
	this.ratios = ratios;
	this.matrix = matrix;
	this.spreadMethod = spreadMethod;
	this.interpolationMethod = interpolationMethod;
	this.focalPointRatio = focalPointRatio;
	this.__graphicsDataType = 2;
	this.__graphicsFillType = 1;
};
$hxClasses["openfl.display.GraphicsGradientFill"] = openfl_display_GraphicsGradientFill;
openfl_display_GraphicsGradientFill.__name__ = "openfl.display.GraphicsGradientFill";
openfl_display_GraphicsGradientFill.__interfaces__ = [openfl_display_IGraphicsFill,openfl_display_IGraphicsData];
openfl_display_GraphicsGradientFill.prototype = {
	__class__: openfl_display_GraphicsGradientFill
};
var openfl_display_IGraphicsPath = function() { };
$hxClasses["openfl.display.IGraphicsPath"] = openfl_display_IGraphicsPath;
openfl_display_IGraphicsPath.__name__ = "openfl.display.IGraphicsPath";
openfl_display_IGraphicsPath.__isInterface__ = true;
var openfl_display_GraphicsPath = function(commands,data,winding) {
	if(winding == null) {
		winding = 0;
	}
	this.commands = commands;
	this.data = data;
	this.winding = winding;
	this.__graphicsDataType = 3;
};
$hxClasses["openfl.display.GraphicsPath"] = openfl_display_GraphicsPath;
openfl_display_GraphicsPath.__name__ = "openfl.display.GraphicsPath";
openfl_display_GraphicsPath.__interfaces__ = [openfl_display_IGraphicsPath,openfl_display_IGraphicsData];
openfl_display_GraphicsPath.prototype = {
	cubicCurveTo: function(controlX1,controlY1,controlX2,controlY2,anchorX,anchorY) {
		if(this.commands == null) {
			this.commands = openfl_Vector.toIntVector(null);
		}
		if(this.data == null) {
			this.data = openfl_Vector.toFloatVector(null);
		}
		this.commands.push(6);
		this.data.push(controlX1);
		this.data.push(controlY1);
		this.data.push(controlX2);
		this.data.push(controlY2);
		this.data.push(anchorX);
		this.data.push(anchorY);
	}
	,curveTo: function(controlX,controlY,anchorX,anchorY) {
		if(this.commands == null) {
			this.commands = openfl_Vector.toIntVector(null);
		}
		if(this.data == null) {
			this.data = openfl_Vector.toFloatVector(null);
		}
		this.commands.push(3);
		this.data.push(controlX);
		this.data.push(controlY);
		this.data.push(anchorX);
		this.data.push(anchorY);
	}
	,lineTo: function(x,y) {
		if(this.commands == null) {
			this.commands = openfl_Vector.toIntVector(null);
		}
		if(this.data == null) {
			this.data = openfl_Vector.toFloatVector(null);
		}
		this.commands.push(2);
		this.data.push(x);
		this.data.push(y);
	}
	,moveTo: function(x,y) {
		if(this.commands == null) {
			this.commands = openfl_Vector.toIntVector(null);
		}
		if(this.data == null) {
			this.data = openfl_Vector.toFloatVector(null);
		}
		this.commands.push(1);
		this.data.push(x);
		this.data.push(y);
	}
	,wideLineTo: function(x,y) {
		if(this.commands == null) {
			this.commands = openfl_Vector.toIntVector(null);
		}
		if(this.data == null) {
			this.data = openfl_Vector.toFloatVector(null);
		}
		this.commands.push(2);
		this.data.push(x);
		this.data.push(y);
	}
	,wideMoveTo: function(x,y) {
		if(this.commands == null) {
			this.commands = openfl_Vector.toIntVector(null);
		}
		if(this.data == null) {
			this.data = openfl_Vector.toFloatVector(null);
		}
		this.commands.push(1);
		this.data.push(x);
		this.data.push(y);
	}
	,__drawCircle: function(x,y,radius) {
		this.__drawRoundRect(x - radius,y - radius,radius * 2,radius * 2,radius * 2,radius * 2);
	}
	,__drawEllipse: function(x,y,width,height) {
		this.__drawRoundRect(x,y,width,height,width,height);
	}
	,__drawRect: function(x,y,width,height) {
		this.moveTo(x,y);
		this.lineTo(x + width,y);
		this.lineTo(x + width,y + height);
		this.lineTo(x,y + height);
		this.lineTo(x,y);
	}
	,__drawRoundRect: function(x,y,width,height,ellipseWidth,ellipseHeight) {
		ellipseWidth *= 0.5;
		ellipseHeight *= 0.5;
		if(ellipseWidth > width / 2) {
			ellipseWidth = width / 2;
		}
		if(ellipseHeight > height / 2) {
			ellipseHeight = height / 2;
		}
		var xe = x + width;
		var ye = y + height;
		var cx1 = -ellipseWidth + ellipseWidth * 0.70710678118654752440084436210485;
		var cx2 = -ellipseWidth + ellipseWidth * 0.4142135623730950488016887242097;
		var cy1 = -ellipseHeight + ellipseHeight * 0.70710678118654752440084436210485;
		var cy2 = -ellipseHeight + ellipseHeight * 0.4142135623730950488016887242097;
		this.moveTo(xe,ye - ellipseHeight);
		this.curveTo(xe,ye + cy2,xe + cx1,ye + cy1);
		this.curveTo(xe + cx2,ye,xe - ellipseWidth,ye);
		this.lineTo(x + ellipseWidth,ye);
		this.curveTo(x - cx2,ye,x - cx1,ye + cy1);
		this.curveTo(x,ye + cy2,x,ye - ellipseHeight);
		this.lineTo(x,y + ellipseHeight);
		this.curveTo(x,y - cy2,x - cx1,y - cy1);
		this.curveTo(x - cx2,y,x + ellipseWidth,y);
		this.lineTo(xe - ellipseWidth,y);
		this.curveTo(xe + cx2,y,xe + cx1,y - cy1);
		this.curveTo(xe,y - cy2,xe,y + ellipseHeight);
		this.lineTo(xe,ye - ellipseHeight);
	}
	,__class__: openfl_display_GraphicsPath
};
var openfl_display_GraphicsPathWinding = {};
openfl_display_GraphicsPathWinding.fromString = function(value) {
	switch(value) {
	case "evenOdd":
		return 0;
	case "nonZero":
		return 1;
	default:
		return null;
	}
};
openfl_display_GraphicsPathWinding.toString = function(this1) {
	switch(this1) {
	case 0:
		return "evenOdd";
	case 1:
		return "nonZero";
	default:
		return null;
	}
};
var openfl_display_GraphicsQuadPath = function(rects,indices,transforms) {
	this.rects = rects;
	this.indices = indices;
	this.transforms = transforms;
	this.__graphicsDataType = 6;
};
$hxClasses["openfl.display.GraphicsQuadPath"] = openfl_display_GraphicsQuadPath;
openfl_display_GraphicsQuadPath.__name__ = "openfl.display.GraphicsQuadPath";
openfl_display_GraphicsQuadPath.__interfaces__ = [openfl_display_IGraphicsPath,openfl_display_IGraphicsData];
openfl_display_GraphicsQuadPath.prototype = {
	__class__: openfl_display_GraphicsQuadPath
};
var openfl_display_GraphicsShader = function(code) {
	if(this.__glFragmentSource == null) {
		this.__glFragmentSource = "varying float openfl_Alphav;\n\t\tvarying vec4 openfl_ColorMultiplierv;\n\t\tvarying vec4 openfl_ColorOffsetv;\n\t\tvarying vec2 openfl_TextureCoordv;\n\n\t\tuniform bool openfl_HasColorTransform;\n\t\tuniform vec2 openfl_TextureSize;\n\t\tuniform sampler2D bitmap;\n\n\t\tvoid main(void) {\n\n\t\t\tvec4 color = texture2D (bitmap, openfl_TextureCoordv);\n\n\t\tif (color.a == 0.0) {\n\n\t\t\tgl_FragColor = vec4 (0.0, 0.0, 0.0, 0.0);\n\n\t\t} else if (openfl_HasColorTransform) {\n\n\t\t\tcolor = vec4 (color.rgb / color.a, color.a);\n\n\t\t\tmat4 colorMultiplier = mat4 (0);\n\t\t\tcolorMultiplier[0][0] = openfl_ColorMultiplierv.x;\n\t\t\tcolorMultiplier[1][1] = openfl_ColorMultiplierv.y;\n\t\t\tcolorMultiplier[2][2] = openfl_ColorMultiplierv.z;\n\t\t\tcolorMultiplier[3][3] = 1.0; // openfl_ColorMultiplierv.w;\n\n\t\t\tcolor = clamp (openfl_ColorOffsetv + (color * colorMultiplier), 0.0, 1.0);\n\n\t\t\tif (color.a > 0.0) {\n\n\t\t\t\tgl_FragColor = vec4 (color.rgb * color.a * openfl_Alphav, color.a * openfl_Alphav);\n\n\t\t\t} else {\n\n\t\t\t\tgl_FragColor = vec4 (0.0, 0.0, 0.0, 0.0);\n\n\t\t\t}\n\n\t\t} else {\n\n\t\t\tgl_FragColor = color * openfl_Alphav;\n\n\t\t}\n\n\t\t}";
	}
	if(this.__glVertexSource == null) {
		this.__glVertexSource = "attribute float openfl_Alpha;\n\t\tattribute vec4 openfl_ColorMultiplier;\n\t\tattribute vec4 openfl_ColorOffset;\n\t\tattribute vec4 openfl_Position;\n\t\tattribute vec2 openfl_TextureCoord;\n\n\t\tvarying float openfl_Alphav;\n\t\tvarying vec4 openfl_ColorMultiplierv;\n\t\tvarying vec4 openfl_ColorOffsetv;\n\t\tvarying vec2 openfl_TextureCoordv;\n\n\t\tuniform mat4 openfl_Matrix;\n\t\tuniform bool openfl_HasColorTransform;\n\t\tuniform vec2 openfl_TextureSize;\n\n\t\tvoid main(void) {\n\n\t\t\topenfl_Alphav = openfl_Alpha;\n\t\topenfl_TextureCoordv = openfl_TextureCoord;\n\n\t\tif (openfl_HasColorTransform) {\n\n\t\t\topenfl_ColorMultiplierv = openfl_ColorMultiplier;\n\t\t\topenfl_ColorOffsetv = openfl_ColorOffset / 255.0;\n\n\t\t}\n\n\t\tgl_Position = openfl_Matrix * openfl_Position;\n\n\t\t}";
	}
	openfl_display_Shader.call(this,code);
	this.__isGenerated = true;
	this.__initGL();
};
$hxClasses["openfl.display.GraphicsShader"] = openfl_display_GraphicsShader;
openfl_display_GraphicsShader.__name__ = "openfl.display.GraphicsShader";
openfl_display_GraphicsShader.__super__ = openfl_display_Shader;
openfl_display_GraphicsShader.prototype = $extend(openfl_display_Shader.prototype,{
	__class__: openfl_display_GraphicsShader
});
var openfl_display_GraphicsShaderFill = function(shader,matrix) {
	this.shader = shader;
	this.matrix = matrix;
	this.__graphicsDataType = 8;
	this.__graphicsFillType = 4;
};
$hxClasses["openfl.display.GraphicsShaderFill"] = openfl_display_GraphicsShaderFill;
openfl_display_GraphicsShaderFill.__name__ = "openfl.display.GraphicsShaderFill";
openfl_display_GraphicsShaderFill.__interfaces__ = [openfl_display_IGraphicsFill,openfl_display_IGraphicsData];
openfl_display_GraphicsShaderFill.prototype = {
	__class__: openfl_display_GraphicsShaderFill
};
var openfl_display_GraphicsSolidFill = function(color,alpha) {
	if(alpha == null) {
		alpha = 1;
	}
	if(color == null) {
		color = 0;
	}
	this.alpha = alpha;
	this.color = color;
	this.__graphicsDataType = 1;
	this.__graphicsFillTyp